<?php

namespace shangfan\controller\base\web\admin;

use framework\Request;
use framework\Response;
use framework\Auth;
use shangfan\model\base\MemberUser;
use shangfan\model\base\MemberPayRecord;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 会员管理
 */
class MemberUserController {

    /**
     * 会员列表
     * @param Request $request
     * @return type
     */
    public function lists(Request $request) {
        $results = MemberUser::lists($request);
        $assign = compact('results');
        setTitle('会员列表');
        return view('base.web.admin.memberUser.lists', $assign);
    }

    /**
     * eidt
     * @param Request $request
     * @param type $memberUserId
     * @return type
     */
    public function edit(Request $request, $memberUserId) {
        if ($request->isPost()) {
            return Response::json(MemberUser::edit($request, $memberUserId));
        }
        $memberUser = MemberUser::detail($memberUserId);
        $assign = compact('memberUser');
        return view('base.web.admin.memberUser.edit', $assign);
    }

    /**
     * payAdd
     * @param Request $request
     * @param type $memberUserId
     * @return type
     */
    public function payAdd(Request $request, $memberUserId) {
        if ($request->isPost()) {
            $rmb = $request->post('rmb', 0);
            return Response::json(MemberPayRecord::adminAdd($memberUserId, $rmb));
        }
        $memberUser = MemberUser::detail($memberUserId);
        $assign = compact('memberUser');
        return view('base.web.admin.memberUser.payAdd', $assign);
    }

    /**
     * del
     * @param Request $request
     * @param type $memberUserId
     * @return type
     */
    public function del(Request $request, $memberUserId) {
        return Response::json(MemberUser::del($request, $memberUserId));
    }

    /**
     * resetPasswd
     * @param Request $request
     * @param type $memberUserId
     * @return type
     */
    public function resetPasswd(Request $request, $memberUserId) {
        return Response::json(MemberUser::resetPasswd($request, $memberUserId));
    }

}
