<?php

namespace shangfan\controller\base\web\admin;

use framework\Request;
use framework\Response;
use framework\Auth;
use shangfan\model\base\ShopGoods;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 商品
 */
class ShopGoodsController {

    /**
     * 商品管理
     * @param Request $request
     * @return type
     */
    public function lists(Request $request) {
        if ($request->isPost()) {
            return Response::json(ShopGoods::addBase($request, Auth::merchant()));
        }
        $results = ShopGoods::listsAdmin($request);
        $assign = compact('results');
        setTitle('商品列表');
        return view('base.web.admin.shopGoods.lists', $assign);
    }

    /**
     * 商城上架商品
     * @param Request $request
     * @return type
     */
    public function mallPutaway(Request $request, $md5) {
        return Response::json(ShopGoods::adminUpdatePutawayStatus($md5, 'is_putaway_mall', 1));
    }

    /**
     * 商城下架商品
     * @param Request $request
     * @return type
     */
    public function mallSoldout(Request $request, $md5) {
        return Response::json(ShopGoods::adminUpdatePutawayStatus($md5, 'is_putaway_mall', 0));
    }

    /**
     * 店铺上架商品
     * @param Request $request
     * @return type
     */
    public function shopPutaway(Request $request, $md5) {
        return Response::json(ShopGoods::adminUpdatePutawayStatus($md5, 'is_putaway', 1));
    }

    /**
     * 店铺下架商品
     * @param Request $request
     * @return type
     */
    public function shopSoldout(Request $request, $md5) {
        return Response::json(ShopGoods::adminUpdatePutawayStatus($md5, 'is_putaway', 0));
    }

    /**
     * h5商城上架商品
     * @param Request $request
     * @return type
     */
    public function h5MallPutaway(Request $request, $md5) {
        return Response::json(ShopGoods::adminUpdatePutawayStatus($md5, 'h5_is_putaway_mall', 1));
    }

    /**
     * h5商城下架商品
     * @param Request $request
     * @return type
     */
    public function h5MallSoldout(Request $request, $md5) {
        return Response::json(ShopGoods::adminUpdatePutawayStatus($md5, 'h5_is_putaway_mall', 0));
    }

    /**
     * h5店铺上架商品
     * @param Request $request
     * @return type
     */
    public function h5ShopPutaway(Request $request, $md5) {
        return Response::json(ShopGoods::adminUpdatePutawayStatus($md5, 'h5_is_putaway', 1));
    }

    /**
     * h5店铺下架商品
     * @param Request $request
     * @return type
     */
    public function h5ShopSoldout(Request $request, $md5) {
        return Response::json(ShopGoods::adminUpdatePutawayStatus($md5, 'h5_is_putaway', 0));
    }

    /**
     * 删除商品
     * @param Request $request
     * @return type
     */
    public function del(Request $request, $md5) {
        return Response::json(ShopGoods::del(Auth::merchant(), $md5));
    }

}
