<?php

namespace shangfan\controller\base\web\admin;

use framework\Request;
use framework\Response;
use framework\Auth;
use framework\Exception;
use shangfan\model\base\ShopUser;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 商品
 */
class ShopUserController {

    /**
     * 商品管理
     * @param Request $request
     * @return type
     */
    public function lists(Request $request) {
        if ($request->isPost()) {
            return Response::json(ShopGoods::addBase($request, Auth::merchant()));
        }
        $results = ShopUser::listsAdmin($request);
        $assign = compact('results');
        setTitle('商品列表');
        return view('base.web.admin.shopUser.lists', $assign);
    }

    /**
     * lock
     * @param Request $request
     * @param type $shopUserId
     * @return type
     */
    public function lock(Request $request, $shopUserId) {
        return Response::json(ShopUser::lock($shopUserId));
    }

    /**
     * unlock
     * @param Request $request
     * @param type $shopUserId
     * @return type
     */
    public function unlock(Request $request, $shopUserId) {
        return Response::json(ShopUser::unlock($shopUserId));
    }

    /**
     * del
     * @param Request $request
     * @param type $shopUserId
     * @return type
     */
    public function del(Request $request, $shopUserId) {
        return Response::json(ShopUser::del($shopUserId));
    }

    /**
     * shopOnline
     * @param Request $request
     * @param type $shopUserId
     * @return type
     */
    public function shopOnline(Request $request, $shopUserId) {
        return Response::json(ShopUser::shopOnline($shopUserId));
    }

    /**
     * shopOffline
     * @param Request $request
     * @param type $shopUserId
     * @return type
     */
    public function shopOffline(Request $request, $shopUserId) {
        return Response::json(ShopUser::shopOffline($shopUserId));
    }

}
