<?php

namespace shangfan\controller\base\web\admin;

use framework\Request;
use framework\Response;
use shangfan\model\base\SystemConfig;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 配置管理
 */
class SystemConfigController {

    /**
     * 保存配置
     * @param Request $request
     * @return type
     */
    public function saveConfig(Request $request) {
        return Response::json(SystemConfig::saveConfig($request));
    }

    /**
     * 网站设置
     * @param Request $request
     * @return type
     */
    public function pcWebsite(Request $request) {
        setTitle('商城设置');
        return view('base.web.admin.systemConfig.pcWebsite');
    }

    /**
     * 会员设置
     * @param Request $request
     * @return type
     */
    public function pcMember(Request $request) {
        setTitle('会员设置');
        return view('base.web.admin.systemConfig.pcMember');
    }

    /**
     * 商家设置
     * @param Request $request
     * @return type
     */
    public function pcMerchant(Request $request) {
        setTitle('商家设置');
        return view('base.web.admin.systemConfig.pcMerchant');
    }

    /**
     * 余额支付
     * @param Request $request
     * @return type
     */
    public function pcPayBalance(Request $request) {
        setTitle('余额支付');
        return view('base.web.admin.systemConfig.pcPayBalance');
    }

    /**
     * 微信支付
     * @param Request $request
     * @return type
     */
    public function pcPayWechat(Request $request) {
        setTitle('余额支付');
        return view('base.web.admin.systemConfig.pcPayWechat');
    }

    /**
     * 支付宝支付
     * @param Request $request
     * @return type
     */
    public function pcPayAlipay(Request $request) {
        setTitle('支付宝支付');
        return view('base.web.admin.systemConfig.pcPayAlipay');
    }

    /**
     * 手机端网站设置
     * @param Request $request
     * @return type
     */
    public function h5Website(Request $request) {
        setTitle('手机端商城设置');
        return view('base.web.admin.systemConfig.h5Website');
    }

    /**
     * 手机端会员设置
     * @param Request $request
     * @return type
     */
    public function h5Member(Request $request) {
        setTitle('手机端会员设置');
        return view('base.web.admin.systemConfig.h5Member');
    }

}
