<?php
namespace shangfan\controller\base\web\mall;

use framework\Request;
use shangfan\model\base\MallCategory;
use shangfan\model\base\ShopGoods;
use shangfan\model\base\SystemFocus;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 商城首页
 */
class HomeController {

    /**
     * index
     * @param Request $request
     * @return string
     */
    public function index(Request $request) {
        $systemFocus = SystemFocus::pcLists($request);
        $listsMallCategory = MallCategory::listsLevel();
        $listsMallIndex = ShopGoods::listsMallIndex($request);
        $assign = compact('listsMallCategory', 'listsMallIndex', 'systemFocus');
        setTitle('商城首页');
        return view('base.web.mall.home.index', $assign);
    }

}
