<?php

namespace shangfan\controller\base\web\mall;

use framework\Request;
use shangfan\model\base\MallCategory;
use shangfan\model\base\ShopGoods;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 商城分类
 */
class MallCategoryController {

    /**
     * 商品分类
     * @param Request $request
     * @return string
     */
    public function category(Request $request, $mallCategoryId) {
        $mallCategory = MallCategory::detail($mallCategoryId);
        $mallCategoryGoods = ShopGoods::listsMallCategory($request, $mallCategoryId);
        $assign = compact('mallCategoryGoods');
        setTitle($mallCategory->name);
        return view('base.web.mall.mallCategory.category', $assign);
    }

}
