<?php

namespace shangfan\controller\base\web\mall;

use framework\Request;
use framework\Response;
use framework\Exception;
use framework\Auth;
use shangfan\model\base\Order;
use shangfan\model\base\MemberAddress;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 订单
 */
class OrderController {

    /**
     * 创建订单
     * @param Request $request
     * @return string
     */
    public function add(Request $request) {
        return Response::json(Order::add($request, Auth::member()));
    }

    /**
     * detail
     * @param Request $request
     * @param type $orderNumberStr
     * @return type
     * @throws Exception
     */
    public static function detail(Request $request, $orderNumberStr) {
        $member = Auth::member();
        if (!$member) {
            return $request->redirect('/member/login/index');
        }
        if (!$orderNumberStr) {
            throw new Exception('缺少订单号');
        }
        $orderNumberArr = explode(',', $orderNumberStr);
        if (!is_array($orderNumberArr) || !count($orderNumberArr)) {
            throw new Exception('缺少订单号');
        }
        $orderArr = Order::listsOrderDetail($orderNumberArr);
        if (!count($orderArr)) {
            throw new Exception('未找到订单');
        }
        $currentOrder = current($orderArr);
        $orderMemberAddress = Order::orderMemberAddress($orderNumberArr);
        $orderTotalAmount = Order::orderTotalAmount($orderNumberArr);
        $listsMemberAddress = MemberAddress::listsMemberAddress($member->id);
        $assign = compact('orderNumberStr', 'orderArr', 'currentOrder', 'orderMemberAddress', 'orderTotalAmount', 'listsMemberAddress');
        setTitle('订单详情');
        return view('base.web.mall.order.detail', $assign);
    }

    /**
     * addressUpdate
     * @param Request $request
     * @return type
     */
    public function addressUpdate(Request $request) {
        $success = Order::addressUpdate($request, Auth::member());
        return Response::json($success);
    }

    /**
     * paytypeUpdate
     * @param Request $request
     * @return type
     */
    public function paytypeUpdate(Request $request) {
        $success = Order::paytypeUpdate($request, Auth::member());
        return Response::json($success);
    }

    /**
     * checkAddress
     * @param Request $request
     * @param type $orderNumberStr
     * @return type
     */
    public function checkAddress(Request $request, $orderNumberStr) {
        $successs = Order::orderCheckAddress($orderNumberStr);
        if ($successs) {
            return Response::json(statusSuccess());
        }
        return Response::json(statusFailure('请完善订单收货地址'));
    }

    /**
     * 支付成功
     * @param Request $request
     * @return type
     */
    public function orderSuccess(Request $request, $orderNumberStr) {
        $assign = compact('orderNumberStr');
        setTitle('支付成功');
        return view('base.web.mall.order.success', $assign);
    }

}
