<?php

namespace shangfan\controller\base\web\mall;

use framework\Request;
use framework\Response;
use framework\pay\Pay;
use shangfan\model\base\Order;
use framework\Auth;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 支付
 */
class PayController {

    /**
     * 付款码
     * @param Request $request
     * @param type $channel wechat alipay
     * @param type $orderNumberStr
     * @return type
     */
    public function qrcode(Request $request, $channel, $orderNumberStr) {
        $orderNumberArr = explode(',', $orderNumberStr);
        if (!Order::orderCheckAddress($orderNumberArr)) {
            return $request->redirect('/');
        }
        $pay = new Pay(['channel' => $channel]);
        $enQrcodeString = $pay->qrcode([
            'body' => '订单号' . $orderNumberStr,
            'outTradeNo' => $orderNumberStr,
            'totalFee' => Order::orderTotalAmount($orderNumberArr),
            'notifyUrl' => httpDomain() . '/mall/pay/notify/wechat',
            'tradeType' => 'NATIVE'
        ]);
        $assign = compact('order', 'orderNumberStr', 'channel', 'enQrcodeString');
        if ($channel == 'wechat') {
            setTitle('微信支付');
        }
        if ($channel == 'alipay') {
            setTitle('支付宝支付');
        }
        return view('base.web.mall.pay.payQrcode', $assign);
    }

    /**
     * 二维码
     * @param Request $request
     * @return type
     * @throws Exception
     */
    public function qrcodeCreate(Request $request, $string) {
        $string = base64_decode($string);
        return qrcodeCreate($string);
    }

    /**
     * 回调
     * @param Request $request
     * @param type $channel wechat alipay
     * @return type
     */
    public function notify(Request $request, $channel) {
        $pay = new Pay(['channel' => $channel]);
        return $pay->notify($request);
    }

    /**
     * 订单查询
     * @param Request $request
     * @param type $channel
     * @return type
     */
    public function orderQuery(Request $request, $channel, $orderNumberStr) {
        $pay = new Pay(['channel' => $channel]);
        $success = $pay->orderQuery($orderNumberStr);
        return Response::json($success);
    }

    /**
     * balance
     * @param Request $request
     * @return type
     */
    public function balance(Request $request, $orderNumberStr) {
        $pay = new Pay(['channel' => 'balance']);
        return Response::json($pay->pay($orderNumberStr, Auth::member()));
    }

}
