<?php

namespace shangfan\controller\base\web\mall;

use framework\Request;
use framework\Response;
use framework\Auth;
use shangfan\model\base\ShopShopingcart;
use shangfan\model\base\ShopShopingcartOption;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 购物车
 */
class ShopingcartController {

    /**
     * 加入购物车
     * @param Request $request
     * @return string
     */
    public function add(Request $request) {
        $member = Auth::member();
        return Response::json(ShopShopingcart::add($request, $member));
    }

    /**
     * 立即购买
     * @param Request $request
     * @return string
     */
    public function buy(Request $request) {
        return Response::json(ShopShopingcart::buy($request, Auth::member()));
    }

    /**
     * 购物车列表
     * @param Request $request
     * @return string
     */
    public function lists(Request $request) {
        $listsShopShopingcart = ShopShopingcart::listsShopShopingcart($request, Auth::member());
        $assign = compact('listsShopShopingcart');
        setTitle('购物车');
        return view('base.web.mall.shopingcart.lists', $assign);
    }

    /**
     * updateNumber
     * @param Request $request
     * @return type
     */
    public function updateNumber(Request $request) {
        $shopingcartOptionId = intval($request->post('shopingcartOptionId', 0));
        $number = intval($request->post('number', 0));
        $success = ShopShopingcartOption::updateNumber(Auth::member(), $shopingcartOptionId, $number);
        return Response::json($success);
    }

    /**
     * 删除购物车
     * @param Request $request
     * @return string
     */
    public function del(Request $request) {
        return Response::json(ShopShopingcart::del($request, Auth::member()));
    }

}
