<?php

namespace shangfan\controller\base\web\member;

use framework\Request;
use framework\Response;
use framework\Auth;
use shangfan\model\base\MemberUser;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 会员登录
 */
class LoginController {

    /**
     * 会员登录
     * @param Request $request
     * @return type
     */
    public function index(Request $request) {
        setTitle('会员登录');
        return view('base.web.member.login.index');
    }

    /**
     * 登录提交
     * @param Request $request
     * @return type
     */
    public function login(Request $request) {
        return Response::json(MemberUser::login($request));
    }

    /**
     * 退出登录
     * @param Request $request
     * @return type
     */
    public function logout(Request $request) {
        Auth::remove('member');
        return $request->redirect('/member/login/index');
    }
    
    /**
     * 找回密码
     * @return type
     */
    public function findPassword(Request $request) {
        return view('base.web.member.register.findPassword');
    }

}
