<?php

namespace shangfan\controller\base\web\member;

use framework\Request;
use framework\Response;
use framework\Auth;
use shangfan\model\base\MemberFocusGoods;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 商品关注
 */
class MemberFocusGoodsController {

    /**
     * 商品关注
     * @param Request $request
     * @return type
     */
    public function ajaxAdd(Request $request) {
        return Response::json(MemberFocusGoods::add($request, Auth::member()));
    }

    /**
     * lists
     * @param Request $request
     * @return type
     */
    public function lists(Request $request) {
        $results = MemberFocusGoods::lists($request, Auth::member());
        $assign = compact('results');
        setTitle('我关注的商品');
        return view('base.web.member.focusGoods.lists', $assign);
    }

    /**
     * 删除商品关注
     * @param Request $request
     * @return type
     */
    public function del(Request $request, $memberFocusGoodsId) {
        return Response::json(MemberFocusGoods::del(Auth::member(), $memberFocusGoodsId));
    }

}
