<?php

namespace shangfan\controller\base\web\merchant;

use framework\Request;
use framework\Auth;
use framework\Response;
use shangfan\model\base\ShopUser;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * Main
 */
class MainController {

    /**
     * 登录首页
     * @param Request $request
     * @return type
     */
    public function index(Request $request) {
        $h5DomainBase64 = base64_encode('http://'.rootDomain().'/h5/mall/index');
        $assign = compact('h5DomainBase64');
        setTitle('商家管理首页');
        return view('base.web.merchant.main.index', $assign);
    }

    /**
     * passwd
     * @param Request $request
     * @return type
     */
    public function passwd(Request $request) {
        if ($request->isPost()) {
            return Response::json(ShopUser::password($request, Auth::merchant()));
        }
        setTitle('修改密码');
        return view('base.web.merchant.main.passwd');
    }
    
    /**
     * 二维码
     * @param Request $request
     * @return type
     * @throws Exception
     */
    public function qrcode(Request $request, $string) {
        $string = base64_decode($string);
        return qrcodeCreate($string);
    }

}
