<?php

namespace shangfan\controller\base\web\merchant;

use framework\Request;
use framework\Response;
use framework\Auth;
use shangfan\model\base\Order;
use shangfan\model\base\SystemExpress;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 订单管理
 */
class OrderController {

    /**
     * lists
     * @param Request $request
     * @return type
     */
    public static function lists(Request $request) {
        $merchant = Auth::merchant();
        if (!$merchant) {
            return $request->redirect('/merchant/login/index');
        }
        $listsMerchantOrder = Order::listsMerchantOrder($request, $merchant->id);
        $assign = compact('listsMerchantOrder');
        setTitle('订单列表');
        return view('base.web.merchant.order.lists', $assign);
    }
    
        /**
     * lists
     * @param Request $request
     * @return type
     */
    public static function shipments(Request $request, $orderNumber) {
        if($request->isPost()){
            $success = Order::shipments($request, $orderNumber, Auth::merchant());
            return Response::json($success);
        }
        $systemExpress = SystemExpress::lists($request);
        $assign = compact('systemExpress');
        return view('base.web.merchant.order.shipments', $assign);
    }

}
