<?php

namespace shangfan\controller\base\web\merchant;

use framework\Request;
use framework\Response;
use framework\Auth;
use shangfan\model\base\ShopCategory;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 店铺分类
 */
class ShopCategoryController {

    /**
     * 添加店铺大类
     * @param Request $request
     * @return type
     */
    public function addFirst(Request $request) {
        if ($request->isPost()) {
            $success = ShopCategory::addFirst($request, Auth::merchant());
            return Response::json($success);
        }
        setTitle('添加店铺大类');
        return view('base.web.merchant.shopCategory.addFirst');
    }

    /**
     * 添加店铺小类
     * @param Request $request
     * @return type
     */
    public function addSecond(Request $request) {
        if ($request->isPost()) {
            $success = ShopCategory::addSecond($request, Auth::merchant());
            return Response::json($success);
        }
        $merchant = Auth::merchant();
        $secondArray = ShopCategory::secondArray($merchant->id);
        $assign = compact('secondArray');
        setTitle('添加店铺小类');
        return view('base.web.merchant.shopCategory.addSecond', $assign);
    }

    /**
     * 管理店铺分类
     * @param Request $request
     * @return type
     */
    public function lists(Request $request) {
        $results = ShopCategory::listFirst($request, Auth::merchant());
        $assign = compact('results');
        setTitle('管理店铺分类');
        return view('base.web.merchant.shopCategory.lists', $assign);
    }

    /**
     * 管理店铺小分类
     * @param Request $request
     * @return type
     */
    public function listsLevel2(Request $request, $pid) {
        $shopCategory = ShopCategory::detail($pid);
        $results = ShopCategory::listSecond($request, Auth::merchant(), $pid);
        $assign = compact('results');
        setTitle($shopCategory->title);
        return view('base.web.merchant.shopCategory.listsLevel2', $assign);
    }

    /**
     * 修改店铺小类
     * @param Request $request
     * @param type $id
     * @return type
     */
    public function edit(Request $request, $id) {
        if ($request->isPost()) {
            $success = ShopCategory::edit($request, Auth::merchant(), $id);
            return Response::json($success);
        }
        $shopCategory = ShopCategory::detail($id);
        if (!$shopCategory) {
            throw new Exception("未找到该分类数据");
        }
        if ($shopCategory->pid == 0) {
            $assign = compact('shopCategory');
            setTitle('修改店铺大类');
            return view('base.web.merchant.shopCategory.editFirst', $assign);
        }
        $merchant = Auth::merchant();
        $secondArray = ShopCategory::secondArray($merchant->id);
        $assign = compact('shopCategory', 'secondArray');
        setTitle('修改店铺小类');
        return view('base.web.merchant.shopCategory.editSecond', $assign);
    }

    /**
     * 删除店铺分类
     * @param Request $request
     * @param type $id
     * @return type
     * @throws Exception
     */
    public function del(Request $request, $id) {
        $shopCategory = ShopCategory::detail($id);
        if (!$shopCategory) {
            throw new Exception("未找到该分类数据");
        }
        $success = ShopCategory::del($id, Auth::merchant());
        return Response::json($success);
    }
    
    /**
     * ajax店铺大类
     * @param Request $request
     * @return type
     */
    public function ajaxLevel1(Request $request){
        return Response::json(ShopCategory::ajaxLevel());
    }
    
    /**
     * ajax店铺小类
     * @param Request $request
     * @param type $pid
     * @return type
     */
    public function ajaxLevel2(Request $request, $pid){
        return Response::json(ShopCategory::ajaxLevel($request, $pid));
    }

}
