<?php

namespace shangfan\controller\base\web\merchant;

use framework\Request;
use framework\Response;
use framework\Auth;
use framework\Exception;
use shangfan\model\base\ShopCategory;
use shangfan\model\base\MallCategory;
use shangfan\model\base\ShopGoods;
use shangfan\model\base\ShopGoodsImages;
use shangfan\model\base\ShopGoodsSelect;
use shangfan\model\base\ShopGoodsOption;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 商品
 */
class ShopGoodsController {

    /**
     * 步骤1，添加商品基础信息
     * @param Request $request
     * @return type
     */
    public function step1(Request $request) {
        if ($request->isPost()) {
            return Response::json(ShopGoods::step1($request, Auth::merchant()));
        }
        $merchant = Auth::merchant();
        $mallCategoryAjaxLists = MallCategory::ajaxLists($request, 0);
        $shopCategoryAjaxLists = ShopCategory::ajaxLists($request, 0);
        $assign = compact('mallCategory', 'mallCategoryAjaxLists', 'shopCategoryAjaxLists');
        setTitle('第一步，添加商品基础信息');
        return view('base.web.merchant.shopGoods.step1', $assign);
    }

    /**
     * 步骤2，添加商品描述信息
     * @param Request $request
     * @return type
     */
    public function step2(Request $request, $md5) {
        $shopGoods = ShopGoods::detailMd5($md5);
        if (!$shopGoods) {
            throw new Exception('未找到商品数据');
        }
        $sidShopCategory = null;
        $pidShopCategory = null;
        $shopCategory = ShopCategory::detail($shopGoods->shop_category_id);
        if ($shopCategory) {
            $sidShopCategory = $shopCategory;
            $pidShopCategory = ShopCategory::detail($shopCategory->pid);
        }
        $shopGoodsDetailPics = ShopGoodsImages::getShopGoodsDetailPics($shopGoods->id);
        $assign = compact('shopGoods', 'sidShopCategory', 'pidShopCategory', 'shopGoodsDetailPics');
        setTitle('第二步，添加商品描述信息');
        return view('base.web.merchant.shopGoods.step2', $assign);
    }

    /**
     * 步骤3，添加商品型号分类信息
     * @param Request $request
     * @return type
     */
    public function step3(Request $request, $shopGoodsId) {
        $shopGoods = ShopGoods::detail($shopGoodsId);
        if (!$shopGoods) {
            throw new Exception('未找到商品数据');
        }
        ShopGoodsSelect::init($request, Auth::merchant(), $shopGoodsId);
        $listsDetailMain = ShopGoodsSelect::listsDetailMain($request, $shopGoodsId);
        $listsDetailNoMain = ShopGoodsSelect::listsDetailNoMain($request, $shopGoodsId);
        $assign = compact('shopGoods', 'listsDetailMain', 'listsDetailNoMain');
        setTitle('第三步，添加商品型号分类信息');
        return view('base.web.merchant.shopGoods.step3', $assign);
    }

    /**
     * 规格添加小类
     * @param Request $request
     * @param type $goodsSelectId
     * @return type
     * @throws Exception
     */
    public function step3OptionAdd(Request $request, $goodsSelectId) {
        return Response::json(ShopGoodsOption::step3OptionAdd($request, Auth::merchant(), $goodsSelectId));
    }

    /**
     * 下属型号管理
     * @param Request $request
     * @return type
     */
    public function step3OptionLists(Request $request, $goodsSelectId) {
        if ($request->isPost()) {
            return Response::json(ShopGoods::addBase($request, Auth::merchant()));
        }
        $shopGoodsOption = ShopGoodsOption::lists($request, $goodsSelectId);
        $assign = compact('shopGoodsOption');
        return view('base.web.merchant.shopGoods.step3OptionLists', $assign);
    }

    /**
     * 规格修改小类
     * @param Request $request
     * @param type $goodsOptionId
     * @return type
     * @throws Exception
     */
    public function step3OptionEdit(Request $request, $goodsOptionId) {
        if ($request->isPost()) {
            return Response::json(ShopGoodsOption::step3OptionEdit($request, Auth::merchant(), $goodsOptionId));
        }
        $shopGoodsOption = ShopGoodsOption::detail($goodsOptionId);
        if (!$shopGoodsOption) {
            throw new Exception('未找到商品数据');
        }
        $shopGoodsSelect = ShopGoodsSelect::detail($shopGoodsOption->shop_goods_select_id);
        $assign = compact('shopGoodsOption', 'shopGoodsSelect');
        return view('base.web.merchant.shopGoods.step3OptionEdit', $assign);
    }

    /**
     * 规格删除小类
     * @delete
     * @param Request $request
     * @param type $goodsOptionId
     * @return type
     * @throws Exception
     */
    public function step3OptionDel(Request $request, $goodsOptionId) {
        return Response::json(ShopGoodsOption::step3OptionDel($request, Auth::merchant(), $goodsOptionId));
    }

    /**
     * 规格修改
     * @param Request $request
     * @param type $goodsSelectId
     * @return type
     * @throws Exception
     */
    public function step3SelectEdit(Request $request, $goodsSelectId) {
        if($request->isPost()){
            return Response::json(ShopGoodsSelect::edit($request, Auth::merchant(), $goodsSelectId));
        }
        $shopGoodsSelect = ShopGoodsSelect::detail($goodsSelectId);
        $assign = compact('shopGoodsSelect');
        return view('base.web.merchant.shopGoods.step3SelectEdit', $assign);
    }

    /**
     * 规格删除
     * @param Request $request
     * @param type $goodsSelectId
     * @return type
     * @throws Exception
     */
    public function step3SelectDel(Request $request, $goodsSelectId) {
        return Response::json(ShopGoodsSelect::del($request, Auth::merchant(), $goodsSelectId));
    }

    /**
     * 商品图片排序
     * @param Request $request
     * @return type
     */
    public function picSort(Request $request) {
        $merchant = Auth::merchant();
        return Response::json(ShopGoodsImages::picSort($request, $merchant));
    }

    /**
     * 商品图片删除
     * @param Request $request
     * @param type $goodsImagesId
     * @return type
     */
    public function picDel(Request $request, $goodsImagesId) {
        $merchant = Auth::merchant();
        return Response::json(ShopGoodsImages::picDel($request, $merchant, $goodsImagesId));
    }

    /**
     * 商品管理
     * @param Request $request
     * @return type
     */
    public function lists(Request $request) {
        if ($request->isPost()) {
            return Response::json(ShopGoods::addBase($request, Auth::merchant()));
        }
        $results = ShopGoods::lists($request, Auth::merchant());
        $assign = compact('results');
        setTitle('商品管理');
        return view('base.web.merchant.shopGoods.lists', $assign);
    }

    /**
     * 编辑步骤1，添加商品基础信息
     * @param Request $request
     * @return type
     */
    public function step1Edit(Request $request, $md5) {
        if ($request->isPost()) {
            return Response::json(ShopGoods::step1Edit($request, Auth::merchant(), $md5));
        }
        $merchant = Auth::merchant();
        $shopGoods = ShopGoods::detailMd5($md5);
        if (!$shopGoods) {
            throw new Exception('未找到数据');
        }
        $mallCategoryAjaxLevel1 = MallCategory::ajaxLists($request, 0);
        $mallCategoryAjaxLevel2 = MallCategory::ajaxLists($request, $shopGoods->mall_category_pid);
        $mallCategoryAjaxLevel3 = MallCategory::ajaxLists($request, $shopGoods->mall_category_sid);
        $shopCategoryAjaxLevel1 = ShopCategory::ajaxLists($request, 0);
        $shopCategoryAjaxLevel2 = ShopCategory::ajaxLists($request, $shopGoods->shop_category_pid);
        $assign = compact('shopGoods', 'mallCategoryAjaxLevel1', 'mallCategoryAjaxLevel2', 'mallCategoryAjaxLevel3', 'shopCategoryAjaxLevel1', 'shopCategoryAjaxLevel2');
        setTitle('第一步，添加商品基础信息');
        return view('base.web.merchant.shopGoods.step1Edit', $assign);
    }

    /**
     * 上架商品
     * @param Request $request
     * @return type
     */
    public function putaway(Request $request, $md5) {
        return Response::json(ShopGoods::merchantUpdatePutawayStatus(Auth::merchant(), $md5, 'is_putaway', 1));
    }

    /**
     * 下架商品
     * @param Request $request
     * @return type
     */
    public function soldout(Request $request, $md5) {
        return Response::json(ShopGoods::merchantUpdatePutawayStatus(Auth::merchant(), $md5, 'is_putaway', 0));
    }

    /**
     * 删除商品
     * @param Request $request
     * @return type
     */
    public function del(Request $request, $md5) {
        return Response::json(ShopGoods::del(Auth::merchant(), $md5));
    }

    /**
     * 二维码
     * @param Request $request
     * @return type
     * @throws Exception
     */
    public function qrcode(Request $request, $string) {
        $string = base64_decode($string);
        return qrcodeCreate($string);
    }

    /**
     * h5 步骤2，添加商品描述信息
     * @param Request $request
     * @return type
     */
    public function h5Step2(Request $request, $md5) {
        $shopGoods = ShopGoods::detailMd5($md5);
        if (!$shopGoods) {
            throw new Exception('未找到商品数据');
        }
        $sidShopCategory = null;
        $pidShopCategory = null;
        $shopCategory = ShopCategory::detail($shopGoods->shop_category_id);
        if ($shopCategory) {
            $sidShopCategory = $shopCategory;
            $pidShopCategory = ShopCategory::detail($shopCategory->pid);
        }
        $shopGoodsDetailPics = ShopGoodsImages::getH5ShopGoodsDetailPics($shopGoods->id);
        $assign = compact('shopGoods', 'sidShopCategory', 'pidShopCategory', 'shopGoodsDetailPics');
        setTitle('手机端添加商品描述信息');
        return view('base.web.merchant.shopGoods.h5Step2', $assign);
    }

    /**
     * h5QrCode
     * @param Request $request
     * @return type
     * @throws Exception
     */
    public function h5Preview(Request $request, $md5) {
        $string = base64_encode(url('/h5/goods/'.$md5));
        $assign = compact('string');
        setTitle('手机端添加商品描述信息');
        return view('base.web.merchant.shopGoods.h5Preview', $assign);
    }

    /**
     * h5上架商品
     * @param Request $request
     * @return type
     */
    public function h5Putaway(Request $request, $md5) {
        return Response::json(ShopGoods::merchantUpdatePutawayStatus(Auth::merchant(), $md5, 'h5_is_putaway', 1));
    }

    /**
     * h5架商品
     * @param Request $request
     * @return type
     */
    public function h5Soldout(Request $request, $md5) {
        return Response::json(ShopGoods::merchantUpdatePutawayStatus(Auth::merchant(), $md5, 'h5_is_putaway', 0));
    }

}
