<?php

namespace shangfan\controller\base\web\merchant;

use framework\Request;
use framework\Response;
use framework\Auth;
use framework\Exception;
use shangfan\model\base\ShopInfo;
use shangfan\model\base\ShopUser;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 商家信息设置
 */
class ShopInfoController {

    /**
     * 商家信息设置
     * @param Request $request
     * @return type
     */
    public function setShopInfo(Request $request) {
        if($request->isPost()){
            $success = ShopInfo::setShopInfo($request, Auth::merchant());
            return Response::json($success);
        }
        $merchant = Auth::merchant();
        if(!$merchant){
            throw new Exception('未能正确获取商家登录信息');
        }
        $shopInfo = ShopInfo::detailShopUserId($merchant->id);
        $isOnline = ShopUser::strIsOnline($merchant->is_online);
        $assign = compact('shopInfo', 'merchant', 'isOnline');
        setTitle('商家信息设置');
        return view('base.web.merchant.shopInfo.index', $assign);
    }

}
