<?php

namespace shangfan\controller\base\web\merchant;

use framework\Request;
use framework\Response;
use framework\Auth;
use framework\Exception;
use shangfan\model\base\ShopGoodsSelect;
use shangfan\model\base\ShopGoodsPrice;
use shangfan\model\base\ShopGoods;
use shangfan\model\base\Stock;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 库存管理
 */
class StockController {

    /**
     * 库存列表
     * @param Request $request
     * @return type
     */
    public function lists(Request $request, $md5) {
        $shopGoods = ShopGoods::detailMd5($md5);
        if (!$shopGoods) {
            throw new Exception('未找到商品数据');
        }
        ShopGoodsSelect::init($request, Auth::merchant(), $shopGoods->id);
        list($shopGoodsOptionConf1, $shopGoodsOptionConf2) = ShopGoodsSelect::shopGoodsOptionConf($request, $shopGoods->id);
        $assign = compact('shopGoods', 'shopGoodsOptionConf1', 'shopGoodsOptionConf2');
        setTitle('商品库存');
        return view('base.web.merchant.stock.lists', $assign);
    }

    /**
     * stockNumPrice
     * @param Request $request
     * @return type
     */
    public static function stockNumPrice(Request $request) {
        $shopGoodsId = intval($request->post('shopGoodsId', 0));
        $idsOption = $request->post('idsOption', '');
        $detailIdsOption = ShopGoodsPrice::detailIdsOption($idsOption);
        return Response::json([
                    'stock' => Stock::countSurplusIdsOption($shopGoodsId, $idsOption),
                    'price' => $detailIdsOption ? $detailIdsOption->price : 0,
                    'picMini' => $detailIdsOption ? $detailIdsOption->pic_mini : '/shangfan/view/base/web/public/img/shangfan_default.png',
                    'picSrc' => $detailIdsOption ? $detailIdsOption->pic_src : '/shangfan/view/base/web/public/img/shangfan_default.png',
        ]);
    }

    /**
     * save
     * @param Request $request
     * @return type
     */
    public function save(Request $request) {
        return Response::json(Stock::stockSave($request, Auth::merchant()));
    }

}
