<?php

namespace shangfan\controller\base\web\merchant;

use framework\Request;
use framework\Response;
use framework\file\Upload;
use framework\Auth;
use shangfan\model\base\ShopGoodsImages;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 文件上传
 */
class UploadController {

    /**
     * upload
     * @param Request $request
     * @param type $type goods商品
     * @return type
     */
    public function upload(Request $request, $type) {
        if (!$request->isFile()) {
            return Response::json(statusFailure('请选择文件'));
        }
        if ($type == 'cover') {
            return $this->uploadCover($request, $type);
        }
        if ($type == 'goods') {
            return $this->uploadGoods($request, $type);
        }
        if ($type == 'goodsh5') {
            return $this->uploadGoodsH5($request, $type);
        }
        if ($type == 'option') {
            return $this->uploadGoodsOption($request, $type);
        }
    }
    
    /**
     * 商品规格图片上传
     * @param Request $request
     * @param type $type
     * @return type
     */
    private function uploadGoodsOption(Request $request, $type) {
        if ($type != 'option') {
            return statusFailure('上传模型错误');
        }
        if (!Auth::hasLogin('merchant')) {
            return statusFailure('登录超时，请重新登录');
        }
        $goodsOptionId = $request->post('goodsOptionId', 0);
        if (!$goodsOptionId) {
            return statusFailure('缺少商品相关参数，请刷新重试');
        }
        $date = date('Ymd');
        $uploadPicDir = Upload::getUploadPicDir($type, $date);
        if (!Upload::checkExtension()) {
            return Response::json(statusFailure('上传类型错误，请上传图片文件'));
        }
        $uploadFilePath = Upload::getUploadFilePath();
        if (Upload::moveUploadedFile($uploadPicDir, $uploadFilePath)) {
            $data = [
                'httpPath' => Upload::getUploadHttpPath($type, $date, $uploadFilePath),
                'thumbPath' => null,
            ];
            if (Upload::createThumbGoods300x400($uploadPicDir, $uploadFilePath)) {
                $data['thumbPath'] = Upload::getUploadHttpThumbPath($type, $date, $uploadFilePath);
            }
            ShopGoodsImages::addGoodsOptionPic(Auth::merchant(), $goodsOptionId, $data['httpPath'], $data['thumbPath']);
            return Response::json(statusSuccess('上传成功', $data));
        }
        return Response::json(statusFailure('上传失败，请重试'));
    }

    /**
     * 商品封面上传
     * @param Request $request
     * @param type $type
     * @return type
     */
    private function uploadCover(Request $request, $type) {
        if ($type != 'cover') {
            return statusFailure('上传模型错误');
        }
        if (!Auth::hasLogin('merchant')) {
            return statusFailure('登录超时，请重新登录');
        }
        $shopGoodsId = $request->post('goodsId', 0);
        if (!$shopGoodsId) {
            return statusFailure('缺少商品相关参数，请刷新重试');
        }
        $date = date('Ymd');
        $uploadPicDir = Upload::getUploadPicDir($type, $date);
        if (!Upload::checkExtension()) {
            return Response::json(statusFailure('上传类型错误，请上传图片文件'));
        }
        $uploadFilePath = Upload::getUploadFilePath();
        if (Upload::moveUploadedFile($uploadPicDir, $uploadFilePath)) {
            $data = [
                'httpPath' => Upload::getUploadHttpPath($type, $date, $uploadFilePath),
                'thumbPath' => null,
            ];
            if (Upload::createThumbGoods300x400($uploadPicDir, $uploadFilePath)) {
                $data['thumbPath'] = Upload::getUploadHttpThumbPath($type, $date, $uploadFilePath);
            }
            ShopGoodsImages::updateGoodsCoverPic(Auth::merchant(), $shopGoodsId, $data['httpPath'], $data['thumbPath']);
            return Response::json(statusSuccess('上传成功', $data));
        }
        return Response::json(statusFailure('上传失败，请重试'));
    }

    /**
     * 商品图片上传
     * @param Request $request
     * @param type $type
     * @return type
     */
    private function uploadGoods(Request $request, $type) {
        if ($type != 'goods') {
            return statusFailure('上传模型错误');
        }
        if (!Auth::hasLogin('merchant')) {
            return statusFailure('登录超时，请重新登录');
        }
        $shopGoodsId = $request->post('goodsId', 0);
        if (!$shopGoodsId) {
            return statusFailure('缺少商品相关参数，请刷新重试');
        }
        $date = date('Ymd');
        $uploadPicDir = Upload::getUploadPicDir($type, $date);
        if (!Upload::checkExtension()) {
            return Response::json(statusFailure('上传类型错误，请上传图片文件'));
        }
        $uploadFilePath = Upload::getUploadFilePath();
        if (Upload::moveUploadedFile($uploadPicDir, $uploadFilePath)) {
            $data = [
                'httpPath' => Upload::getUploadHttpPath($type, $date, $uploadFilePath),
                'thumbPath' => null,
            ];
            if (Upload::createThumbGoods300x400($uploadPicDir, $uploadFilePath)) {
                $data['thumbPath'] = Upload::getUploadHttpThumbPath($type, $date, $uploadFilePath);
            }
            ShopGoodsImages::addGoodsDetailPic(Auth::merchant(), $shopGoodsId, $data['httpPath'], $data['thumbPath']);
            return Response::json(statusSuccess('上传成功', $data));
        }
        return Response::json(statusFailure('上传失败，请重试'));
    }
    
    /**
     * h5商品图片上传
     * @param Request $request
     * @param type $type
     * @return type
     */
    private function uploadGoodsH5(Request $request, $type) {
        if ($type != 'goodsh5') {
            return statusFailure('上传模型错误');
        }
        if (!Auth::hasLogin('merchant')) {
            return statusFailure('登录超时，请重新登录');
        }
        $shopGoodsId = $request->post('goodsId', 0);
        if (!$shopGoodsId) {
            return statusFailure('缺少商品相关参数，请刷新重试');
        }
        $date = date('Ymd');
        $uploadPicDir = Upload::getUploadPicDir($type, $date);
        if (!Upload::checkExtension()) {
            return Response::json(statusFailure('上传类型错误，请上传图片文件'));
        }
        $uploadFilePath = Upload::getUploadFilePath();
        if (Upload::moveUploadedFile($uploadPicDir, $uploadFilePath)) {
            $data = [
                'httpPath' => Upload::getUploadHttpPath($type, $date, $uploadFilePath),
                'thumbPath' => null,
            ];
            if (Upload::createThumbGoods300x400($uploadPicDir, $uploadFilePath)) {
                $data['thumbPath'] = Upload::getUploadHttpThumbPath($type, $date, $uploadFilePath);
            }
            ShopGoodsImages::addH5GoodsDetailPic(Auth::merchant(), $shopGoodsId, $data['httpPath'], $data['thumbPath']);
            return Response::json(statusSuccess('上传成功', $data));
        }
        return Response::json(statusFailure('上传失败，请重试'));
    }

}
