<?php

namespace shangfan\controller\base\web\shop;

use framework\Request;
use framework\Response;
use framework\Exception;
use framework\Auth;
use shangfan\model\base\ShopGoods;
use shangfan\model\base\ShopGoodsImages;
use shangfan\model\base\ShopInfo;
use shangfan\model\base\ShopGoodsSelect;
use shangfan\model\base\ShopGoodsOption;
use shangfan\model\base\MemberFocusShop;
use shangfan\model\base\MemberFocusGoods;
use shangfan\model\base\OrderGoods;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 商品
 */
class ShopGoodsController {

    /**
     * 商品详情
     * @param Request $request
     * @return string
     */
    public function goods(Request $request, $md5) {
        $shopGoods = ShopGoods::detailMd5($md5);
        if (!$shopGoods) {
            throw new Exception('未找到商品数据');
        }
        $member = Auth::member();
        $isFocusShop = false;
        if ($member) {
            $isFocusShop = MemberFocusShop::isFocusShop($member->id, $shopGoods->shop_user_id);
            $isFocusGoods = MemberFocusGoods::isFocusGoods($member->id, $shopGoods->shop_user_id, $shopGoods->id);
        }
        $countSales = OrderGoods::countSales($md5);
        $listsDetailMain = ShopGoodsSelect::listsDetailMain($request, $shopGoods->id);
        $listsDetailNoMain = ShopGoodsSelect::listsDetailNoMain($request, $shopGoods->id);
        $shopGoodsDetailPics = ShopGoodsImages::getShopGoodsDetailPics($shopGoods->id);
        $shopInfo = ShopInfo::detailShopUserId($shopGoods->shop_user_id);
        $shopNewGoodsLists = ShopInfo::shopNewGoods($shopGoods->shop_user_id);
        $assign = compact('shopGoods', 'countSales', 'isFocusShop', 'isFocusGoods', 'shopGoodsDetailPics', 'shopInfo', 'shopNewGoodsLists', 'listsDetailMain', 'listsDetailNoMain');
        setTitle($shopGoods->name);
        return view('base.web.shop.shopGoods.goods', $assign);
    }

    /**
     * ajaxGoodsOption
     * @param Request $request
     * @param type $goodsOptionId
     * @return type
     */
    public function ajaxGoodsOption(Request $request) {
        $shopGoodsMd5 = $request->post('shopGoodsMd5', '');
        $idsOption = $request->post('idsOption', '');
        return Response::json(ShopGoodsOption::ajaxGoodsOption($shopGoodsMd5, $idsOption));
    }

}
