<?php

namespace shangfan\middleware;

use framework\Request;
use framework\Auth;
use shangfan\model\base\MemberUser;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 */
class AppBeforeMiddleware {

    /**
     * context
     * @param Request $request
     * @return boolean
     */
    public function context(Request $request) {
        $memberUserId = $request->param('member_user_id', 0);
        $sign = $request->param('sign', '');
        $time = $request->param('time', 0);
        if (!$memberUserId || !$sign || !$time) {
            return statusFailure('请求错误，参数缺少');
        }
        $memberUser = MemberUser::detail($memberUserId);
        if (!$memberUser) {
            return statusFailure('未找到用户数据，请重新登录');
        }
        if (md5($time . $memberUser->token) != $sign) {
            return statusFailure('密钥错误，请重新登录');
        }
        return true;
    }

}
