<?php

namespace shangfan\model\base;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * MemberPayRecord
 */
class MemberPayRecord extends BaseModel {

    public $table = 'shangfan_member_pay_record';
    public $key = 'id';

    /**
     * add
     * @param type $memberUserId
     * @param type $rmb
     * @param type $channelTypeStr
     * @param type $channelNumber
     * @return type
     */
    public static function add($memberUserId, $rmb, $channelTypeStr, $orderNumber, $channelNumber = '') {
        return MemberPayRecord::writeRecord(1, $memberUserId, $rmb, $channelTypeStr, $orderNumber, $channelNumber);
    }

    /**
     * reduce
     * @param type $memberUserId
     * @param type $rmb
     * @param type $channelTypeStr
     * @param type $channelNumber
     * @return type
     */
    public static function reduce($memberUserId, $rmb, $channelTypeStr, $orderNumber, $channelNumber = '') {
        return MemberPayRecord::writeRecord(2, $memberUserId, $rmb, $channelTypeStr, $orderNumber, $channelNumber);
    }

    /**
     * writeRecord
     * @param type $type
     * @param type $memberUserId
     * @param type $rmb
     * @param type $channelTypeStr
     * @param type $channelNumber
     * @return type
     */
    public static function writeRecord($type, $memberUserId, $rmb, $channelTypeStr, $orderNumber, $channelNumber = '') {
        if (!in_array($channelTypeStr, ['balance', 'wxpay', 'alipay', 'net', 'admin'])) {
            return statusFailure('支付类型有误');
        }
        $channelType = 0;
        if ($channelTypeStr == 'balance') {
            $channelType = 1;
        }
        if ($channelTypeStr == 'wxpay') {
            $channelType = 2;
        }
        if ($channelTypeStr == 'alipay') {
            $channelType = 3;
        }
        if ($channelTypeStr == 'net') {
            $channelType = 4;
        }
        if ($channelTypeStr == 'admin') {
            $channelType = 10;
        }
        $success = MemberPayRecord::insert([
                    'member_user_id' => $memberUserId,
                    'type' => $type,
                    'rmb' => $rmb,
                    'channel_type' => $channelType,
                    'channel_number' => $channelNumber,
                    'order_number' => $orderNumber,
                    'create_time' => time(),
        ]);
        if (!$success) {
            if ($type == 1) {
                return statusFailure('充值失败，请重试');
            }
            if ($type == 2) {
                return statusFailure('扣款失败，请重试');
            }
            return statusFailure('操作失败，请重试');
        }
        if ($type == 1) {
            return statusSuccess('充值成功');
        }
        if ($type == 2) {
            return statusSuccess('扣款成功');
        }
        return statusSuccess('操作成功');
    }

    /**
     * adminAdd
     * @param type $memberUserId
     * @param type $rmb
     * @return type
     */
    public static function adminAdd($memberUserId, $rmb) {
        if (!$rmb) {
            return statusFailure('充值金额需大于0');
        }
        return MemberPayRecord::add($memberUserId, $rmb, 'admin', '');
    }

    /**
     * countMemberRecordAdd
     * @param type $memberUserId
     * @return int
     */
    public static function countMemberRecordAdd($memberUserId) {
        $payRecord = MemberPayRecord::first("select sum(rmb) rmb from {table} where member_user_id={$memberUserId} and type=1;");
        if (!$payRecord) {
            return 0;
        }
        return $payRecord->rmb;
    }

    /**
     * countMemberRecordReduce
     * @param type $memberUserId
     * @return int
     */
    public static function countMemberRecordReduce($memberUserId) {
        $payRecord = MemberPayRecord::first("select sum(rmb) rmb from {table} where member_user_id={$memberUserId} and type=2;");
        if (!$payRecord) {
            return 0;
        }
        return $payRecord->rmb;
    }

    /**
     * countMemberRecordSurplus
     * @param type $memberUserId
     * @return type
     */
    public static function countMemberRecordSurplus($memberUserId) {
        $rmb = MemberPayRecord::countMemberRecordAdd($memberUserId) - MemberPayRecord::countMemberRecordReduce($memberUserId);
        return bcadd($rmb, 0, 2);
    }

}
