<?php

namespace shangfan\model\base;

use framework\Request;
use framework\Auth;
use framework\paginate\Paginate;
use shangfan\model\base\MemberPayRecord;
use shangfan\model\base\SystemCity;
use shangfan\model\base\Order;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * MemberUser
 */
class MemberUser extends BaseModel {

    public $table = 'shangfan_member_user';
    public $key = 'id';

    /**
     * login
     * @param Request $request
     * @return type
     */
    public static function login(Request $request) {
        $user = trim($request->post('user', ''));
        $passwd = trim($request->post('passwd', ''));
        if (!$user) {
            return statusFailure('请输入手机号');
        }
        if (!$passwd) {
            return statusFailure('请输入密码');
        }
        $memberUser = MemberUser::detailUser($user);
        if (!$memberUser) {
            return statusFailure('账号错误，请检查');
        }
        if ($memberUser->passwd != md5($passwd)) {
            return statusFailure('密码错误，请检查');
        }
        if (!Auth::refresh('member', (array) $memberUser->attribute)) {
            return statusFailure('登录失败，请重试');
        }
        return statusSuccess('欢迎回来');
    }

    /**
     * login
     * @param Request $request
     * @return type
     */
    public static function h5Login(Request $request) {
        $user = trim($request->post('user', ''));
        $passwd = trim($request->post('passwd', ''));
        if (!$user) {
            return statusFailure('请输入手机号');
        }
        if (!$passwd) {
            return statusFailure('请输入密码');
        }
        $memberUser = MemberUser::detailUser($user);
        if (!$memberUser) {
            return statusFailure('账号错误，请检查');
        }
        if ($memberUser->passwd != md5($passwd)) {
            return statusFailure('密码错误，请检查');
        }
        if (!Auth::refresh('member.h5', (array) $memberUser->attribute)) {
            return statusFailure('登录失败，请重试');
        }
        return statusSuccess('欢迎回来');
    }

    /**
     * register
     * @param Request $request
     * @return type
     */
    public static function register(Request $request) {
        $name = trim($request->post('name', ''));
        $user = trim($request->post('user', ''));
        $passwd1 = trim($request->post('passwd1', ''));
        $passwd2 = trim($request->post('passwd2', ''));
        if (!$name) {
            return statusFailure('请输入姓名');
        }
        if (!$user || (substr($user, 0, 1) != '1')) {
            return statusFailure('请输入正确的手机号');
        }
        if (!$passwd1) {
            return statusFailure('请输入密码');
        }
        if (!$passwd2) {
            return statusFailure('请再次输入密码');
        }
        if ($passwd1 != $passwd2) {
            return statusFailure('两次密码不一致，请检查');
        }
        $count = MemberUser::count("select count(id) as count from {table} where status>0 and user='{$user}';");
        if ($count) {
            return statusFailure('手机号已经存在，请换一个');
        }
        $insert = [
            'user' => $user,
            'name' => $name,
            'passwd' => md5($passwd1),
            'create_time' => time(),
        ];
        $success = MemberUser::insert($insert);
        if (!$success) {
            return statusFailure('注册会员失败，请重试或联系客服');
        }
        return statusSuccess('注册会员成功');
    }

    /**
     * password
     * @param Request $request
     * @param type $memberUser
     * @return type
     */
    public static function password(Request $request, $memberUser) {
        $password1 = trim($request->post('password1', ''));
        $password2 = trim($request->post('password2', ''));
        $password3 = trim($request->post('password3', ''));
        if (!$password1) {
            return statusFailure('请输入旧密码');
        }
        if (!$password2) {
            return statusFailure('请输入新密码');
        }
        if (!$password3) {
            return statusFailure('请再次输入新密码');
        }
        if ($memberUser->passwd != md5($password1)) {
            return statusFailure('旧密码错误，请检查');
        }
        if ($password2 != $password3) {
            return statusFailure('两次输入的新密码不一致，请检查');
        }
        $memberUser->passwd = md5($password2);
        if (!$memberUser->save()) {
            return statusFailure('修改密码失败，请重试');
        }
        return statusSuccess('修改密码成功');
    }

    /**
     * lists
     * @param Request $request
     * @param type $shopUser
     * @return Paginate
     */
    public static function lists(Request $request) {
        $where = " and status in (1,2) ";
        $results = new Paginate($request, MemberUser::db(), 10);
        $results->setSelectCount("select count(id) as count from {table} where 1=1 {$where} order by create_time desc,id desc;");
        $results->setSelectResults("select * from {table} where 1=1 {$where} order by create_time desc,id desc;");
        $results->appends([
                //'type' => $request->get('type', 0),
        ]);
        if (count($results->results)) {
            foreach ($results->results as &$val) {
                $val->strProvince = '-';
                $val->strCity = '-';
                $val->strCountry = '-';
                if ($val->province_id) {
                    $city = SystemCity::detail($val->province_id);
                    if ($city) {
                        $val->strProvince = $city->name;
                    }
                }
                if ($val->city_id) {
                    $city = SystemCity::detail($val->city_id);
                    if ($city) {
                        $val->strCity = $city->name;
                    }
                }
                if ($val->country_id) {
                    $city = SystemCity::detail($val->country_id);
                    if ($city) {
                        $val->strCountry = $city->name;
                    }
                }
                $val->strCreateTime = MemberUser::strCreateTime($val->create_time);
                $val->countMemberUserOrder = Order::countMemberUserOrder($val->id);
                $val->strStatus = MemberUser::strStatus($val->id);
//                $shopGoodsCoverPics = ShopGoodsImages::getShopGoodsCoverPics($val->id);
//                $val->picMini = $shopGoodsCoverPics->pic_mini;
//                $val->mallCategoryTitle = MallCategory::strTitle($val->mall_category_id);
//                $val->shopCategoryTitle = ShopCategory::strTitle($val->shop_category_id);
//                $val->price_member = ShopGoods::strPriceMember($val->price_member);
//                $val->strIsPutway = ShopGoods::strIsPutway($val->is_putaway);
//                $val->countStockSurplus = Stock::countSurplusGoodsId($val->id);
            }
        }
        return $results;
    }

    /**
     * edit
     * @param Request $request
     * @param type $memberUserId
     * @return type
     */
    public static function edit(Request $request, $memberUserId) {
        if (!$request->post('name', '')) {
            return statusFailure('姓名不可为空');
        }
        $memberUser = MemberUser::detail($memberUserId);
        if (!$memberUser) {
            return statusFailure('未找到数据，请检查');
        }
        $memberUser->fill([
            'province_id' => intval($request->post('province_id', 0)),
            'city_id' => intval($request->post('city_id', 0)),
            'country_id' => intval($request->post('country_id', 0)),
            'name' => $request->post('name', ''),
        ]);
        if (!$memberUser->save()) {
            return statusFailure('修改失败，请重试');
        }
        return statusSuccess('修改成功');
    }

    /**
     * del
     * @param Request $request
     * @param type $memberUserId
     * @return type
     */
    public static function del(Request $request, $memberUserId) {
        $memberUser = MemberUser::detail($memberUserId);
        if (!$memberUser) {
            return statusFailure('未找到数据，请检查');
        }
        $memberUser->status = 0;
        if (!$memberUser->save()) {
            return statusFailure('删除失败，请重试');
        }
        return statusSuccess('删除成功');
    }

    /**
     * resetPasswd
     * @param Request $request
     * @param type $memberUserId
     * @return type
     */
    public static function resetPasswd(Request $request, $memberUserId) {
        $memberUser = MemberUser::detail($memberUserId);
        if (!$memberUser) {
            return statusFailure('未找到数据，请检查');
        }
        $memberUser->passwd = md5('12345678');
        if (!$memberUser->save()) {
            return statusFailure('重置密码失败，请重试');
        }
        return statusSuccess('密码成功重置为12345678');
    }

    /**
     * strCreateTime
     * @param type $createTime
     * @return type
     */
    public static function strCreateTime($createTime) {
        return date('Y/m/d H:i:s', $createTime);
    }

    /**
     * strStatus
     * @param type $status
     * @return string
     */
    public static function strStatus($status) {
        if ($status == 1) {
            return '正常';
        }
        if ($status == 2) {
            return '锁定';
        }
        if ($status == 0) {
            return '删除';
        }
        return '-';
    }

    /**
     * detail
     * @param type $id
     * @return type
     */
    public static function detail($id) {
        return MemberUser::first("select * from {table} where id={$id};");
    }

    /**
     * detailUser
     * @param type $user
     * @return type
     */
    public static function detailUser($user) {
        return MemberUser::first("select * from {table} where user='{$user}' and status>0;");
    }

    /**
     * detailApp
     * @param Request $request
     * @return type
     */
    public static function detailApp(Request $request) {
        return MemberUser::detail(intval($request->param('member_user_id', 0)));
    }

    /**
     * rmb
     * @param type $memberUserId
     * @return type
     */
    public static function rmb($memberUserId) {
        $rmb = MemberPayRecord::countMemberRecordSurplus($memberUserId);
        return $rmb < 0 ? 0 : $rmb;
    }

}
