<?php

namespace shangfan\model\base;

use framework\Request;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * OrderMark
 */
class OrderMark extends BaseModel {

    public $table = 'shangfan_order_mark';
    public $key = 'id';

    /**
     * updateMark
     * @param Request $request
     * @param $memberUser
     * @return type
     */
    public static function updateMark(Request $request, MemberUser $memberUser) {
        $orderNumber = trim($request->post('orderNumber', ''));
        if (!$orderNumber) {
            return statusFailure('缺少订单号参数');
        }
        if (!$request->post('mark', '')) {
            return statusSuccess();
        }
        $order = Order::detail($orderNumber);
        if (!$order) {
            return statusFailure('未找到订单数据');
        }
        if ($order->member_user_id != $memberUser->id) {
            return statusFailure('您没有权限');
        }
        $detail = OrderMark::detail($orderNumber);
        if (!$detail) {
            return OrderMark::add($orderNumber, $memberUser->id, $request->post('mark', ''));
        }
        $detail->fill([
            'mark' => $request->post('mark', '')
        ]);
        if (!$detail->save()) {
            return statusFailure('更新备注失败，请重试');
        }
        return statusSuccess();
    }

    /**
     * add
     * @param type $orderNumber
     * @param type $memberUserId
     * @param type $mark
     * @return type
     */
    public static function add($orderNumber, $memberUserId, $mark) {
        $detail = OrderMark::detail($orderNumber);
        if ($detail) {
            return statusFailure('记录已存在');
        }
        $success = OrderMark::insert([
                    'order_number' => $orderNumber,
                    'member_user_id' => $memberUserId,
                    'mark' => $mark,
                    'create_time' => time(),
        ]);
        if (!$success) {
            return statusFailure('更新备注失败，请重试');
        }
        return statusSuccess();
    }

    /**
     * detail
     * @param type $orderNumber
     * @return type
     */
    public static function detail($orderNumber) {
        return OrderMark::first("select * from {table} where order_number='{$orderNumber}';");
    }

}
