<?php

namespace shangfan\model\base;

use framework\Request;
use shangfan\model\base\Stock;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * ShopGoodsOption
 */
class ShopGoodsOption extends BaseModel {

    public $table = 'shangfan_shop_goods_option';
    public $key = 'id';

    /**
     * step3OptionAdd
     * @param Request $request
     * @param type $shopUser
     * @param type $goodsSelectId
     * @return type
     */
    public static function step3OptionAdd(Request $request, $shopUser, $goodsSelectId) {
        $goodsSelect = ShopGoodsSelect::detail($goodsSelectId);
        if (!$goodsSelect) {
            return statusFailure('未找到数据，请重试或联系客服');
        }
        $name = trim($request->post('name', ''));
        if (!$name) {
            $name = '默认' . $goodsSelect->name;
        }
        if ($goodsSelect->shop_user_id != $shopUser->id) {
            return statusFailure('您没有权限');
        }
        $success = ShopGoodsOption::insert([
                    'shop_goods_id' => $goodsSelect->shop_goods_id,
                    'shop_user_id' => $shopUser->id,
                    'shop_goods_select_id' => $goodsSelect->id,
                    'is_main' => $goodsSelect->is_main,
                    'name' => $name,
                    'create_time' => time(),
                    'status' => 1,
        ]);
        if (!$success) {
            return statusFailure('添加规格失败，请重试或联系客服');
        }
        return statusSuccess('添加规格成功，请编辑修改');
    }

    /**
     * step3OptionEdit
     * @param Request $request
     * @param type $shopUser
     * @param type $goodsOptionId
     * @return type
     */
    public static function step3OptionEdit(Request $request, $shopUser, $goodsOptionId) {
        $name = trim($request->post('name', ''));
        if (!$name) {
            return statusFailure('请输入规格名称');
        }
        $shopGoodsOption = ShopGoodsOption::detail($goodsOptionId);
        if (!$shopGoodsOption) {
            return statusFailure('未找到数据，请重试或联系客服');
        }
        if ($shopGoodsOption->shop_user_id != $shopUser->id) {
            return statusFailure('您没有权限');
        }
        $shopGoodsOption->name = $name;
        if (!$shopGoodsOption->save()) {
            return statusFailure('修改规格失败，请重试或联系客服');
        }
        return statusSuccess('修改成功');
    }

    /**
     * step3OptionDel
     * @param Request $request
     * @param type $shopUser
     * @param type $goodsOptionId
     * @return type
     */
    public static function step3OptionDel(Request $request, $shopUser, $goodsOptionId) {
        $shopGoodsOption = ShopGoodsOption::detail($goodsOptionId);
        if (!$shopGoodsOption) {
            return statusFailure('未找到数据，请重试或联系客服');
        }
        if ($shopGoodsOption->shop_user_id != $shopUser->id) {
            return statusFailure('您没有权限');
        }
        $shopGoodsOption->status = 0;
        if (!$shopGoodsOption->save()) {
            return statusFailure('删除规格失败，请重试或联系客服');
        }
        $unlinkPicSrc = rootPath() . '/public' . $shopGoodsOption->pic_src;
        if (file_exists($unlinkPicSrc)) {
            @unlink($unlinkPicSrc);
        }
        $unlinkPicMini = rootPath() . '/public' . $shopGoodsOption->pic_mini;
        if (file_exists($unlinkPicMini)) {
            @unlink($unlinkPicMini);
        }
        return statusSuccess('删除成功');
    }

    /**
     * lists
     * @param Request $request
     * @param ShopUser $goodsSelectId
     * @return type
     */
    public static function lists(Request $request, $goodsSelectId) {
        $results = ShopGoodsOption::get("select * from {table} where shop_goods_select_id={$goodsSelectId} and status=1 order by id asc;");
        if (!count($results)) {
            return [];
        }
        foreach ($results as &$val) {
            if ($val->pic_mini) {
                $val->pic_mini = picPublic($val->pic_mini);
            } else {
                $val->pic_mini = '/shangfan/view/base/web/public/img/shangfan_default.png';
            }
        }
        return $results;
    }

    /**
     * ajaxGoodsOption
     * @param type $goodsOptionId
     * @return type
     */
    public static function ajaxGoodsOption($shopGoodsMd5, $idsOption) {
        $shopGoods = ShopGoods::detailMd5($shopGoodsMd5);
        if (!$shopGoods) {
            return statusFailure('未找到商品数据');
        }
        if (!ShopGoodsOption::isIdsOptionRight($shopGoods->id, $idsOption)) {
            return statusSuccess('', [
                'pic_src' => '',
                'pic_mini' => '',
                'price' => 0,
                'stock' => 0
            ]);
        }
        list($mainOptionId, $nomainOptionId) = explode(',', $idsOption);
        $shopGoodsOption = ShopGoodsOption::detail($mainOptionId);
        if (!$shopGoodsOption) {
            return statusFailure('未找到规格数据');
        }
        $shopGoodsPrice = ShopGoodsPrice::detailIdsOption($idsOption);
        return statusSuccess('', [
            'pic_src' => $shopGoodsOption->pic_src,
            'pic_mini' => $shopGoodsOption->pic_mini,
            'price' => $shopGoodsPrice->price,
            'stock' => Stock::countSurplusIdsOption($shopGoods->id, $idsOption)
        ]);
    }

    /**
     * isIdsOptionRight
     * @param type $shopGoodsId
     * @param type $idsOption
     * @return boolean
     */
    public static function isIdsOptionRight($shopGoodsId, $idsOption) {
        list($mainOptionId, $noMainOptionId) = explode(',', $idsOption);
        if (!$mainOptionId || (ShopGoodsOption::countOptionNoMain($shopGoodsId) > 0 && !$noMainOptionId)) {
            return false;
        }
        return true;
    }

    /**
     * countOptionMain
     * @param type $shopGoodsId
     * @return type
     */
    public static function countOptionMain($shopGoodsId) {
        return ShopGoodsSelect::count("select count(id) as count from {table} where shop_goods_id={$shopGoodsId} and is_main=1 and status=1;");
    }

    /**
     * countOptionNoMain
     * @param type $shopGoodsId
     * @return type
     */
    public static function countOptionNoMain($shopGoodsId) {
        return ShopGoodsSelect::count("select count(id) as count from {table} where shop_goods_id={$shopGoodsId} and is_main=0 and status=1;");
    }

    /**
     * detail
     * @param type $id
     * @return type
     */
    public static function detail($id) {
        return ShopGoodsOption::first("select * from {table} where id={$id} and status=1;");
    }

    /**
     * countOption
     * @param type $goodsSelectId
     * @return type
     */
    public static function countOption($goodsSelectId) {
        return ShopGoodsOption::count("select count(id) as count from {table} where shop_goods_select_id={$goodsSelectId} and status=1;");
    }

}
