<?php

namespace shangfan\model\base;

use framework\Request;
use framework\Exception;
use shangfan\model\base\ShopGoods;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * ShopGoodsPrice
 */
class ShopGoodsPrice extends BaseModel {

    public $table = 'shangfan_shop_goods_price';
    public $key = 'id';

    /**
     * updateGoodsOptionPrice
     * @param type $idsOption
     * @param type $price
     * @return type
     */
    public static function updateGoodsOptionPrice($shopGoodsId, $idsOption, $price) {
        $shopGoods = ShopGoods::detail($shopGoodsId);
        if (!$shopGoods) {
            return statusFailure('未找到商品数据');
        }
        $detailIdsOption = ShopGoodsPrice::detailIdsOption($idsOption);
        if (!$detailIdsOption) {
            return ShopGoodsPrice::add($shopGoods->shop_user_id, $shopGoodsId, $idsOption, $price);
        }
        $detailIdsOption->price = $price;
        if (!$detailIdsOption->save()) {
            return statusFailure('更新价格失败，请重试');
        }
        return statusSuccess();
    }

    /**
     * add
     * @param type $shopUserId
     * @param type $shopGoodsId
     * @param type $idsOption
     * @param type $price
     * @return type
     */
    public static function add($shopUserId, $shopGoodsId, $idsOption, $price) {
        if (ShopGoodsPrice::existPrice($shopUserId, $shopGoodsId, $idsOption)) {
            return statusFailure('记录已存在');
        }
        $success = ShopGoodsPrice::insert([
                    'shop_user_id' => $shopUserId,
                    'shop_goods_id' => $shopGoodsId,
                    'ids_option' => $idsOption,
                    'price' => $price,
                    'status' => 1,
                    'create_time' => time()
        ]);
        if (!$success) {
            return statusFailure('添加失败，请重试');
        }
        return statusSuccess();
    }

    /**
     * updatePic
     * @param ShopUser $shopUser
     * @param type $goodsOptionId
     * @param type $picSrc
     * @param type $picMini
     * @param type $picBig
     * @return boolean
     */
    public static function updatePic(ShopUser $shopUser, $idsOption, $picSrc, $picMini = '') {
        if (!$shopUser || !$idsOption || !$picSrc) {
            return false;
        }
        $detailIdsOption = ShopGoodsPrice::detailIdsOption($idsOption);
        if (!$detailIdsOption) {
            return statusFailure('未找到商品数据');
        }
        if ($detailIdsOption->shop_user_id != $shopUser->id) {
            return statusFailure('您没有权限');
        }
        $unlinkPicSrc = rootPath() . $detailIdsOption->pic_src;
        if (file_exists($unlinkPicSrc)) {
            @unlink($unlinkPicSrc);
        }
        $unlinkPicMini = rootPath() . $detailIdsOption->pic_mini;
        if (file_exists($unlinkPicMini)) {
            @unlink($unlinkPicMini);
        }
        $detailIdsOption->fill([
            'pic_src' => $picSrc,
            'pic_mini' => $picMini,
        ]);
        return $detailIdsOption->save();
    }

    /**
     * existPrice
     * @param type $shopUserId
     * @param type $shopGoodsId
     * @param type $idsOption
     * @return type
     */
    public static function existPrice($shopUserId, $shopGoodsId, $idsOption) {
        $count = ShopGoodsPrice::count("select count(id) as count from {table} where shop_user_id={$shopUserId} and shop_goods_id={$shopGoodsId} and ids_option='{$idsOption}';");
        return $count ? true : false;
    }

    /**
     * goodsOptionPrice
     * @param type $idsOption
     * @return int
     */
    public static function goodsOptionPrice($idsOption) {
        $detailIdsOption = ShopGoodsPrice::detailIdsOption($idsOption);
        if (!$detailIdsOption) {
            return 0;
        }
        return $detailIdsOption->price;
    }

    /**
     * detailIdsOption
     * @param type $idsOption
     * @return type
     */
    public static function detailIdsOption($idsOption) {
        if (!$idsOption) {
            return null;
        }
        $idsOption = trim($idsOption);
        return ShopGoodsPrice::first("select * from {table} where ids_option='{$idsOption}';");
    }

}
