<?php

namespace shangfan\model\base;

use framework\Request;
use shangfan\model\base\ShopGoodsOption;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * ShopGoodsSelect
 */
class ShopGoodsSelect extends BaseModel {

    public $table = 'shangfan_shop_goods_select';
    public $key = 'id';

    /**
     * init
     * @param Request $request
     * @param type $shopUser
     * @param type $shopGoodsId
     * @return type
     */
    public static function init(Request $request, $shopUser, $shopGoodsId) {
        $countGoodsSelect = ShopGoodsSelect::countGoodsSelect($shopGoodsId);
        if ($countGoodsSelect > 0) {
            return true;
        }
        ShopGoodsSelect::add($request, $shopUser, $shopGoodsId, 1);
        ShopGoodsSelect::add($request, $shopUser, $shopGoodsId, 0);
        return true;
    }

    /**
     * add
     * @param Request $request
     * @param type $shopUser
     * @param type $shopGoodsId
     * @return type
     */
    public static function add(Request $request, $shopUser, $shopGoodsId, $isMain = 0) {
        $name = trim($request->post('name', '规格'));
        $success = ShopGoodsSelect::insert([
                    'shop_goods_id' => $shopGoodsId,
                    'shop_user_id' => $shopUser->id,
                    'is_main' => $isMain,
                    'type' => 2,
                    'name' => $name,
                    'create_time' => time(),
                    'status' => 1,
                    'sort' => 0,
        ]);
        if (!$success) {
            return statusFailure('添加规格名称失败，请重试或联系客服');
        }
        return statusSuccess('添加成功，请添加规格', ['goodsSelectId' => $success]);
    }

    /**
     * edit
     * @param Request $request
     * @param type $shopUser
     * @param type $goodsSelectId
     * @return type
     */
    public static function edit(Request $request, $shopUser, $goodsSelectId) {
        $name = trim($request->post('name', ''));
        if (!$name) {
            return statusFailure('请输入规格名称');
        }
        $shopGoodsSelect = ShopGoodsSelect::detail($goodsSelectId);
        if (!$shopGoodsSelect) {
            return statusFailure('未找到数据');
        }
        if ($shopGoodsSelect->shop_user_id != $shopUser->id) {
            return statusFailure('您没有权限');
        }
        $shopGoodsSelect->name = $name;
        $shopGoodsSelect->type = 0;
        if (!$shopGoodsSelect->save()) {
            return statusFailure('修改规格设置失败，请重试或联系客服');
        }
        return statusSuccess('修改成功');
    }

    /**
     * del
     * @param Request $request
     * @param type $shopUser
     * @param type $goodsSelectId
     * @return type
     */
    public static function del(Request $request, $shopUser, $goodsSelectId) {
        $shopGoodsSelect = ShopGoodsSelect::detail($goodsSelectId);
        if (!$shopGoodsSelect) {
            return statusFailure('未找到数据');
        }
        if ($shopGoodsSelect->shop_user_id != $shopUser->id) {
            return statusFailure('您没有权限');
        }
        $shopGoodsSelect->status = 0;
        if (!$shopGoodsSelect->save()) {
            return statusFailure('删除规格名称失败，请重试或联系客服');
        }
        return statusSuccess('删除成功');
    }

    /**
     * lists
     * @param Request $request
     * @param ShopUser $shopUser
     * @return type
     */
    public static function merchantLists(Request $request, ShopUser $shopUser, $shopGoodsId) {
        $results = ShopGoodsSelect::get("select * from {table} where shop_user_id={$shopUser->id} and shop_goods_id={$shopGoodsId} and status=1 order by sort asc, id desc;");
        if (!count($results)) {
            return [];
        }
        foreach ($results as &$val) {
            $val->countOption = ShopGoodsOption::countOption($val->id);
            $val->shopGoodsOption = ShopGoodsOption::lists($request, $val->id);
        }
        return $results;
    }

    /**
     * lists
     * @param Request $request
     * @return type
     */
    public static function lists(Request $request, $shopGoodsId) {
        $results = ShopGoodsSelect::get("select * from {table} where shop_goods_id={$shopGoodsId} and status=1 order by is_main desc;");
        if (!count($results)) {
            return [];
        }
        foreach ($results as &$val) {
            $val->strIsMain = ShopGoodsSelect::strIsMain($val->is_main);
            $val->countOption = ShopGoodsOption::countOption($val->id);
            $val->shopGoodsOption = ShopGoodsOption::lists($request, $val->id);
        }
        return $results;
    }

    /**
     * listsDetailMain
     * @param type $request
     * @param type $shopGoodsId
     * @return type
     */
    public static function listsDetailMain($request, $shopGoodsId) {
        $goodsSelect = ShopGoodsSelect::detailMain($shopGoodsId);
        if (!$goodsSelect) {
            return [];
        }
        $goodsSelect->strIsMain = ShopGoodsSelect::strIsMain($goodsSelect->is_main);
        $goodsSelect->countOption = ShopGoodsOption::countOption($goodsSelect->id);
        $goodsSelect->shopGoodsOption = ShopGoodsOption::lists($request, $goodsSelect->id);
        return $goodsSelect;
    }

    /**
     * listsDetailNoMain
     * @param type $request
     * @param type $shopGoodsId
     * @return type
     */
    public static function listsDetailNoMain($request, $shopGoodsId) {
        $goodsSelect = ShopGoodsSelect::detailNoMain($shopGoodsId);
        if (!$goodsSelect) {
            return [];
        }
        $goodsSelect->strIsMain = ShopGoodsSelect::strIsMain($goodsSelect->is_main);
        $goodsSelect->countOption = ShopGoodsOption::countOption($goodsSelect->id);
        $goodsSelect->shopGoodsOption = ShopGoodsOption::lists($request, $goodsSelect->id);
        return $goodsSelect;
    }

    /**
     * shopGoodsOptionConf
     * @param type $request
     * @param type $shopGoodsId
     * @return type
     */
    public static function shopGoodsOptionConf($request, $shopGoodsId) {
        $shopGoodsSelect = ShopGoodsSelect::get("select * from {table} where shop_goods_id={$shopGoodsId} and status=1 order by id asc;");
        if (!count($shopGoodsSelect)) {
            return [];
        }
        $shopGoodsOptionConf = [];
        foreach ($shopGoodsSelect as $key => $val) {
            $shopGoodsOptionConf[$key] = ShopGoodsOption::get("select * from {table} where shop_goods_select_id={$val->id} and status=1 order by id asc;");
        }
        return $shopGoodsOptionConf;
    }

    /**
     * isUseNoMain
     * @param type $shopGoodsId
     * @return type
     */
    public static function isUseNoMain($shopGoodsId) {
        return ShopGoodsOption::countOptionNoMain($shopGoodsId) ? true : false;
    }

    /**
     * countGoodsSelect
     * @param type $shopGoodsId
     * @return type
     */
    public static function countGoodsSelect($shopGoodsId) {
        return ShopGoodsSelect::count("select count(id) as count from {table} where shop_goods_id={$shopGoodsId} and status=1;");
    }

    /**
     * detail
     * @param type $goodsSelectId
     * @return type
     */
    public static function detail($goodsSelectId) {
        return ShopGoodsSelect::first("select * from {table} where id={$goodsSelectId} and status=1;");
    }

    /**
     * detailMain
     * @param type $shopGoodsId
     * @return type
     */
    public static function detailMain($shopGoodsId) {
        return ShopGoodsSelect::first("select * from {table} where shop_goods_id={$shopGoodsId} and is_main=1 and status=1;");
    }

    /**
     * detailNoMain
     * @param type $shopGoodsId
     * @return type
     */
    public static function detailNoMain($shopGoodsId) {
        return ShopGoodsSelect::first("select * from {table} where shop_goods_id={$shopGoodsId} and is_main=0 and status=1;");
    }

    /**
     * detailGoodsId
     * @param type $goodsGoodsId
     * @return type
     */
    public static function detailGoodsId($goodsGoodsId) {
        return ShopGoodsSelect::first("select * from {table} where shop_goods_id={$goodsGoodsId} and status=1 order by id desc limit 1;");
    }

    /**
     * strIsMain
     * @param type $isMain
     * @return string
     */
    public static function strIsMain($isMain) {
        if ($isMain == 1) {
            return '主规格';
        }
        if ($isMain == 0) {
            return '附属规格';
        }
        return '-';
    }

}
