<?php

namespace shangfan\model\base;

use framework\Request;
use shangfan\model\base\ShopUser;
use shangfan\model\base\Order;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 商铺信息
 */
class ShopInfo extends BaseModel {

    public $table = 'shangfan_shop_info';
    public $key = 'id';

    /**
     * setShopInfo
     * @param Request $request
     * @param ShopUser $shopUser
     * @return type
     */
    public static function setShopInfo(Request $request, ShopUser $shopUser) {
        if (!$request->post('name', '')) {
            return statusFailure('请输入店铺名称');
        }
        if (!$request->post('description', '')) {
            return statusFailure('请输入店铺简介');
        }
        $shopInfo = ShopInfo::detailShopUserId($shopUser->id);
        if (!$shopInfo) {
            $insertId = ShopInfo::insert([
                        'shop_user_id' => $shopUser->id,
                        'md5' => createMd5($shopInfo->id),
                        'name' => $request->post('name', ''),
                        'qq' => $request->post('qq', ''),
                        'phone' => $request->post('phone', ''),
                        'address' => $request->post('address', ''),
                        'description' => $request->post('description', ''),
                        'create_time' => time()
            ]);
            if (!$insertId) {
                return statusFailure('创建店铺信息失败，请重试或联系客服');
            }
            $shopInfo = ShopInfo::detail($insertId);
            if (!$shopInfo) {
                return statusFailure('未找到店铺数据，请重试或联系客服');
            }
            $shopInfo->md5 = createMd5($shopInfo->id);
            $shopInfo->save();
            return statusSuccess('创建店铺信息成功');
        }
        $fill = [
            'name' => $request->post('name', ''),
            'qq' => $request->post('qq', ''),
            'phone' => $request->post('phone', ''),
            'address' => $request->post('address', ''),
            'description' => $request->post('description', ''),
            'update_time' => time()
        ];
        if (!$shopInfo->md5) {
            $fill['md5'] = createMd5($shopInfo->id);
        }
        $shopInfo->fill($fill);
        if (!$shopInfo->save()) {
            return statusFailure('更新店铺信息失败，请重试或联系客服');
        }
        return statusSuccess('更新店铺信息成功');
    }

    /**
     * shopNewGoods
     * @param type $shopUserId
     * @param type $limit
     * @return type
     */
    public static function shopNewGoods($shopUserId, $limit = 6) {
        return ShopGoods::get("select * from {table} where shop_user_id={$shopUserId} and status=1 order by create_time desc,id desc limit {$limit};");
    }

    /**
     * isOpen
     * @param type $shopUserId
     * @return boolean
     */
    public static function isOpen($shopUserId) {
        $detail = ShopInfo::detailShopUserId($shopUserId);
        if (!$detail) {
            return false;
        }
        return $detail->status == 1;
    }

    /**
     * detail
     * @param type $id
     * @return type
     */
    public static function detail($id) {
        $detail = ShopInfo::first("select * from {table} where id={$id};");
        if ($detail && !$detail->md5) {
            $detail->md5 = createMd5($detail->id);
            $detail->save();
        }
        return $detail;
    }

    /**
     * detailMd5
     * @param type $md5
     * @return type
     */
    public static function detailMd5($md5) {
        return ShopInfo::first("select * from {table} where md5='{$md5}';");
    }

    /**
     * detailShopUserId
     * @param type $shopUserId
     * @return type
     */
    public static function detailShopUserId($shopUserId) {
        $detail = ShopInfo::first("select * from {table} where shop_user_id={$shopUserId};");
        if ($detail && !$detail->md5) {
            $detail->md5 = createMd5($detail->id);
            $detail->save();
        }
        return $detail;
    }

    /**
     * shopRank
     * @param type $shopUserId
     * @return type
     */
    public static function shopRank($shopUserId) {
        $orderGoods = OrderGoods::get("select md5,name,cover_mini,price_member,(select sum(number) from shangfan_order_goods where 
shop_goods_md5=md5) as number from shangfan_shop_goods where shop_user_id={$shopUserId} order by number desc limit 30");
        if (!count($orderGoods)) {
            return [];
        }
        foreach ($orderGoods as &$val) {
            $val->url = url('/shop/go/goods/' . $val->md5);
        }
        return $orderGoods;
    }


}
