<?php

namespace shangfan\model\base;

use framework\Request;
use shangfan\model\base\MemberUser;
use shangfan\model\base\ShopGoods;
use shangfan\model\base\ShopShopingcart;
use shangfan\model\base\ShopShopingcartOption;
use shangfan\model\base\ShopInfo;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 购物车
 */
class ShopShopingcart extends BaseModel {

    public $table = 'shangfan_shop_shopingcart';
    public $key = 'id';

    /**
     * add
     * @param Request $request
     * @param MemberUser $memberUser
     * @return type
     */
    public static function add(Request $request, $memberUser) {
        if (!$memberUser) {
            return statusFailure('请先登录');
        }
        $shopGoodsMd5 = $request->post('shopGoodsMd5', '');
        if (!$shopGoodsMd5) {
            return statusFailure('缺少参数，请重试或联系客服');
        }
        $shopGoods = ShopGoods::detailMd5($shopGoodsMd5);
        if (!$shopGoods) {
            return statusFailure('未找到商品数据，请重试或联系客服');
        }
        $number = intval($request->post('number', 0));
        if (!$number) {
            return statusFailure('缺少数量，请重试或联系客服');
        }
        $idsOption = trim($request->post('idsOption', ''));
        if (!ShopGoodsOption::isIdsOptionRight($shopGoods->id, $idsOption)) {
            return statusFailure('请选择商品规格');
        }
        $shopShopingcart = ShopShopingcart::first("select * from {table} where member_user_id={$memberUser->id} and shop_user_id={$shopGoods->shop_user_id} and status=1;");
        if (!$shopShopingcart) {
            $success = ShopShopingcart::insert([
                        'member_user_id' => $memberUser->id,
                        'shop_user_id' => $shopGoods->shop_user_id,
                        'status' => 1,
            ]);
            if (!$success) {
                return statusFailure('创建购物车失败，请重试或联系客服');
            }
        }
        $shopShopingcartOption = ShopShopingcartOption::first("select * from {table} where member_user_id={$memberUser->id} and shop_goods_md5='{$shopGoods->md5}' and ids_option='{$idsOption}' and is_order=0 and status=1;");
        if (!$shopShopingcartOption) {
            $success = ShopShopingcartOption::insert([
                        'member_user_id' => $memberUser->id,
                        'shop_user_id' => $shopGoods->shop_user_id,
                        'shop_goods_md5' => $shopGoods->md5,
                        'ids_option' => $idsOption,
                        'number' => $number,
                        'create_time' => time(),
                        'status' => 1,
                        'is_order' => 0
            ]);
            if (!$success) {
                return statusFailure('添加购物车失败，请重试或联系客服');
            }
            return statusSuccess('添加购物车成功');
        }
        $shopShopingcartOption->number = $shopShopingcartOption->number + $number;
        if (!$shopShopingcartOption->save()) {
            return statusFailure('添加购物车失败，请重试或联系客服');
        }
        return statusSuccess('添加购物车成功');
    }

    /**
     * buy
     * @param Request $request
     * @param MemberUser $memberUser
     * @return type
     */
    public static function buy(Request $request, $memberUser) {
        if (!$memberUser) {
            return statusFailure('请先登录');
        }
        $shopGoodsMd5 = $request->post('shopGoodsMd5', '');
        if (!$shopGoodsMd5) {
            return statusFailure('缺少参数，请重试或联系客服');
        }
        $shopGoods = ShopGoods::detailMd5($shopGoodsMd5);
        if (!$shopGoods) {
            return statusFailure('未找到商品数据，请重试或联系客服');
        }
        $number = intval($request->post('number', 0));
        if (!$number) {
            return statusFailure('缺少数量，请重试或联系客服');
        }
        $idsOption = trim($request->post('idsOption', ''));
        if (!ShopGoodsOption::isIdsOptionRight($shopGoods->id, $idsOption)) {
            return statusFailure('请选择商品规格');
        }
        ShopShopingcartOption::update("update {table} set status=0,is_order=0 where member_user_id={$memberUser->id} and is_order=2 and status=1;");
        $success = ShopShopingcartOption::insert([
                    'member_user_id' => $memberUser->id,
                    'shop_user_id' => $shopGoods->shop_user_id,
                    'shop_goods_md5' => $shopGoods->md5,
                    'ids_option' => $idsOption,
                    'number' => $number,
                    'create_time' => time(),
                    'status' => 1,
                    'is_order' => 2
        ]);
        if (!$success) {
            return statusFailure('创建购物车失败，请重试或联系客服');
        }
        return Order::shopOrderCreate($shopGoods->shop_user_id, $memberUser);
    }

    /**
     * countMemberShopingcart
     * @param type $memberUser
     */
    public static function countMemberShopingcart($memberUser) {
        if (!$memberUser || !$memberUser->id) {
            return 0;
        }
        return ShopShopingcartOption::count("select count(id) as count from {table} where member_user_id={$memberUser->id} and is_order=0 and status=1;");
    }

    /**
     * listsShopShopingcart
     * @param Request $request
     * @param MemberUser $memberUser
     * @return type
     */
    public static function listsShopShopingcart(Request $request, $memberUser) {
        $shopShopingcart = ShopShopingcart::get("select * from {table} where member_user_id={$memberUser->id} and status=1;");
        if (!count($shopShopingcart)) {
            return [];
        }
        foreach ($shopShopingcart as &$val) {
            $shopInfo = ShopInfo::detailShopUserId($val->shop_user_id);
            $val->shopName = $shopInfo ? $shopInfo->name : '-';
            $val->listsShopingcartOption = ShopShopingcartOption::listsShopUserId($val->shop_user_id);
        }
        return $shopShopingcart;
    }

    /**
     * del
     * @param Request $request
     * @param MemberUser $memberUser
     * @return type
     */
    public static function del(Request $request, $memberUser) {
        if (!$memberUser) {
            return statusFailure('请先登录');
        }
        $goodsOptionIds = $request->post('goodsOptionIds', []);
        if (!is_array($goodsOptionIds) || !count($goodsOptionIds)) {
            return statusFailure('请至少选择一个商品');
        }
        $goodsOptionIdsStr = sqlWhrerInStringBuild($goodsOptionIds);
        $shopShopingcart = ShopShopingcartOption::update("update {table} set status=0,is_order=0 where member_user_id={$memberUser->id} and id in ({$goodsOptionIdsStr});");
        if (!$shopShopingcart) {
            return statusFailure('删除购物车失败');
        }
        return statusSuccess('删除购物车成功');
    }

}
