<?php

namespace shangfan\model\base;

use framework\Request;
use framework\Exception;
use shangfan\model\base\ShopUser;
use shangfan\model\base\ShopGoodsOption;
use shangfan\model\base\ShopGoodsPrice;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 仓储
 */
class Stock extends BaseModel {

    public $table = 'shangfan_stock';
    public $key = 'id';

    /**
     * stockSave
     * @param Request $request
     * @param ShopUser $shopUser
     * @param type $goodsOptionId
     * @return type
     */
    public static function stockSave(Request $request, ShopUser $shopUser) {
        $shopGoodsId = intval($request->post('shopGoodsId', 0));
        if (!$shopGoodsId) {
            return statusFailure('商品参数不齐全，请刷新重试');
        }
        $idsOptionArr = $request->post('idsOptionArr', []);
        if (!is_array($idsOptionArr) || !count($idsOptionArr)) {
            return statusFailure('请至少填写一个规格');
        }
        $shopGoods = ShopGoods::detail($shopGoodsId);
        if (!$shopGoods) {
            return statusFailure('未找到商品数据');
        }
        if ($shopGoods->shop_user_id != $shopUser->id) {
            return statusFailure('您没有权限');
        }
        foreach ($idsOptionArr as $val) {
            $idsOption = trim($val['idsOption']);
            if ($val['price']) {
                ShopGoodsPrice::updateGoodsOptionPrice($shopGoodsId, $idsOption, $val['price']);
            }
            $add = intval($val['add']);
            if ($add) {
                Stock::add($request, $shopGoods->shop_user_id, $shopGoodsId, $idsOption, $add);
            }
            $reduce = intval($val['reduce']);
            if ($reduce) {
                $countSurplusIdsOption = Stock::countSurplusIdsOption($shopGoodsId, $idsOption);
                if ($countSurplusIdsOption > $reduce) {
                    Stock::reduce($request, $shopGoods->shop_user_id, $shopGoodsId, $idsOption, $reduce);
                } else {
                    Stock::reduce($request, $shopGoods->shop_user_id, $shopGoodsId, $idsOption, $countSurplusIdsOption);
                }
            }
        }
        return statusSuccess('库存保存成功');
    }

    /**
     * add
     * @param Request $request
     * @param type $shopUserId
     * @param type $shopGoodsId
     * @param type $idsOption
     * @param type $number
     * @return type
     */
    public static function add(Request $request, $shopUserId, $shopGoodsId, $idsOption, $number) {
        if (!$number) {
            return statusFailure('请输入库存数量');
        }
        $success = Stock::insert([
                    'shop_user_id' => $shopUserId,
                    'shop_goods_id' => $shopGoodsId,
                    'ids_option' => $idsOption,
                    'type' => 1,
                    'number' => $number,
                    'create_time' => time(),
                    'status' => 1
        ]);
        if (!$success) {
            return statusFailure('添加库存失败，请重试或联系客服');
        }
        return statusSuccess('添加库存成功');
    }

    /**
     * reduce
     * @param Request $request
     * @param type $shopUserId
     * @param type $shopGoodsId
     * @param type $idsOption
     * @param type $number
     * @return type
     */
    public static function reduce(Request $request, $shopUserId, $shopGoodsId, $idsOption, $number) {
        if (!$number) {
            return statusFailure('请输入库存数量');
        }
        $success = Stock::insert([
                    'shop_user_id' => $shopUserId,
                    'shop_goods_id' => $shopGoodsId,
                    'ids_option' => $idsOption,
                    'type' => 2,
                    'number' => $number,
                    'create_time' => time(),
                    'status' => 1
        ]);
        if (!$success) {
            return statusFailure('减少库存失败，请重试或联系客服');
        }
        return statusSuccess('减少库存成功');
    }

    /**
     * countSurplusIdsOption
     * @param type $idsOption
     * @return int
     * @throws Exception
     */
    public static function countSurplusIdsOption($shopGoodsId, $idsOption) {
        $idsOption = trim($idsOption);
        if (!$idsOption) {
            return 0;
        }
        $sql = "select (select sum(number) number from {table} where shop_goods_id={$shopGoodsId} and ids_option='{$idsOption}' and type=1 and status=1) addCount,
        (select sum(number) number from {table} where shop_goods_id={$shopGoodsId} and ids_option='{$idsOption}' and type=2 and status=1) reduceCount;";
        $stock = Stock::first($sql);
        return $stock->addCount - $stock->reduceCount;
    }

    /**
     * countSurplusGoodsId
     * @param type $shopGoodsId
     * @return type
     */
    public static function countSurplusGoodsId($shopGoodsId) {
        $sql = "select (select sum(number) number from {table} where shop_goods_id={$shopGoodsId} and type=1 and status=1) addCount,
        (select sum(number) number from {table} where shop_goods_id={$shopGoodsId} and type=2 and status=1) reduceCount;";
        $stock = Stock::first($sql);
        return $stock->addCount - $stock->reduceCount;
    }
    
}
