<?php

namespace shangfan\model\base;

use framework\Request;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 * 商城导航
 */
class SystemNavigation extends BaseModel {

    public $table = 'shangfan_system_navigation';
    public $key = 'id';

    /**
     * add
     * @param Request $request
     * @return type
     */
    public static function add(Request $request) {
        if (!$request->post('name', '')) {
            return statusFailure('请输入导航名称');
        }
        if (!$request->post('url', '')) {
            return statusFailure('请输入链接地址');
        }
        $success = SystemNavigation::insert([
                    'name' => $request->post('name', ''),
                    'url' => $request->post('url', ''),
                    'sort' => intval($request->post('sort', 0)),
                    'is_show' => 1,
                    'status' => 1,
        ]);
        if (!$success) {
            return statusFailure('添加失败，请重试');
        }
        return statusSuccess('添加导航成功');
    }

    /**
     * edit
     * @param Request $request
     * @param type $navigationId
     * @return type
     */
    public static function edit(Request $request, $navigationId) {
        if (!$request->post('name', '')) {
            return statusFailure('请输入导航名称');
        }
        if (!$request->post('url', '')) {
            return statusFailure('请输入链接地址');
        }
        $navigation = SystemNavigation::detail($navigationId);
        if (!$navigation) {
            return statusFailure('未找到导航数据');
        }
        $navigation->fill([
            'name' => $request->post('name', ''),
            'url' => $request->post('url', ''),
            'sort' => intval($request->post('sort', 0)),
        ]);
        if (!$navigation->save()) {
            return statusFailure('修改失败，请重试');
        }
        return statusSuccess('修改导航成功');
    }

    /**
     * mallNavigationLists
     * @return type
     */
    public static function mallNavigationLists() {
        return SystemNavigation::get("select * from {table} where status=1 and is_show=1 order by sort asc,id asc;");
    }

    /**
     * lists
     * @return type
     */
    public static function lists() {
        $results = SystemNavigation::get("select * from {table} where status=1 order by sort asc,id asc;");
        if (count($results)) {
            foreach ($results as &$val) {
                $val->strIsShow = SystemNavigation::strIsShow($val);
                $val->strStatus = SystemNavigation::strStatus($val);
            }
        }
        return $results;
    }

    /**
     * hide
     * @param Request $request
     * @param type $navigationId
     * @return type
     */
    public static function hide(Request $request, $navigationId) {
        $navigation = SystemNavigation::detail($navigationId);
        if (!$navigation) {
            return statusFailure('未找到导航数据');
        }
        $navigation->is_show = 0;
        if (!$navigation->save()) {
            return statusFailure('操作失败，请重试');
        }
        return statusSuccess('操作成功');
    }

    /**
     * show
     * @param Request $request
     * @param type $navigationId
     * @return type
     */
    public static function show(Request $request, $navigationId) {
        $navigation = SystemNavigation::detail($navigationId);
        if (!$navigation) {
            return statusFailure('未找到导航数据');
        }
        $navigation->is_show = 1;
        if (!$navigation->save()) {
            return statusFailure('操作失败，请重试');
        }
        return statusSuccess('操作成功');
    }

    /**
     * del
     * @param Request $request
     * @param type $navigationId
     * @return type
     */
    public static function del(Request $request, $navigationId) {
        $navigation = SystemNavigation::detail($navigationId);
        if (!$navigation) {
            return statusFailure('未找到导航数据');
        }
        $navigation->status = 0;
        if (!$navigation->save()) {
            return statusFailure('删除失败，请重试');
        }
        return statusSuccess('删除成功');
    }

    /**
     * detail
     * @param type $id
     * @return type
     */
    public static function detail($id) {
        return SystemNavigation::first("select * from {table} where id={$id} and status=1;");
    }

    /**
     * strIsShow
     * @param type $systemNavigation
     * @return string
     */
    public static function strIsShow($systemNavigation) {
        if ($systemNavigation->is_show == 0) {
            return '隐藏';
        }
        if ($systemNavigation->is_show == 1) {
            return '显示';
        }
        return '-';
    }

    /**
     * strStatus
     * @param type $systemNavigation
     * @return string
     */
    public static function strStatus($systemNavigation) {
        if ($systemNavigation->status == 0) {
            return '删除';
        }
        if ($systemNavigation->status == 1) {
            return '正常';
        }
        return '-';
    }

}
