<?php

use framework\route\Route;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 */
Route::get('/member/login/index', '\shangfan\controller\develop\web\member\LoginController@index');
Route::post('/member/login/login', '\shangfan\controller\develop\web\member\LoginController@login');
Route::get('/member/login/logout', '\shangfan\controller\develop\web\member\LoginController@logout');
Route::get('/member/register/index', '\shangfan\controller\develop\web\member\RegisterController@index');
Route::post('/member/register/register', '\shangfan\controller\develop\web\member\RegisterController@register');
Route::get('/member/main/index', '\shangfan\controller\develop\web\member\MainController@index', 'member.before');
Route::any('/member/safe/password', '\shangfan\controller\develop\web\member\SafeController@password', 'member.before');
Route::any('/member/address/add', '\shangfan\controller\develop\web\member\MemberAddressController@add', 'member.before');
Route::any('/member/address/ajax/city/{param}', '\shangfan\controller\develop\web\member\MemberAddressController@city', 'member.before');
Route::any('/member/address/ajax/county/{param}', '\shangfan\controller\develop\web\member\MemberAddressController@county', 'member.before');
Route::get('/member/order/lists', '\shangfan\controller\develop\web\member\OrderController@lists', 'member.before');
Route::post('/member/order/delivery/{param}', '\shangfan\controller\develop\web\member\OrderController@delivery', 'member.before');
Route::post('/member/focus/shop/add', '\shangfan\controller\develop\web\member\MemberFocusShopController@ajaxAdd');
Route::post('/member/focus/goods/add', '\shangfan\controller\develop\web\member\MemberFocusGoodsController@ajaxAdd');
Route::get('/member/focus/goods/lists', '\shangfan\controller\develop\web\member\MemberFocusGoodsController@lists');
Route::get('/member/focus/goods/del/{param}', '\shangfan\controller\develop\web\member\MemberFocusGoodsController@del');
Route::get('/member/focus/shop/lists', '\shangfan\controller\develop\web\member\MemberFocusShopController@lists');
Route::get('/member/focus/shop/del/{param}', '\shangfan\controller\develop\web\member\MemberFocusShopController@del');
