<?php

use framework\route\Route;

/**
 * -----------------------------------------------------------------------------
 * shangfan商城
 * 商范软件 版权所有，并保留所有权利。
 * 官网地址：http://www.shangfanruanjian.com
 * -----------------------------------------------------------------------------
 */
Route::get('/merchant/login/index', '\shangfan\controller\develop\web\merchant\LoginController@index');
Route::post('/merchant/login/login', '\shangfan\controller\develop\web\merchant\LoginController@login');
Route::get('/merchant/login/loginout', '\shangfan\controller\develop\web\merchant\LoginController@loginout');
Route::get('/merchant/register/index', '\shangfan\controller\develop\web\merchant\RegisterController@index');
Route::post('/merchant/register/register', '\shangfan\controller\develop\web\merchant\RegisterController@register');
Route::get('/merchant/main/index', '\shangfan\controller\develop\web\merchant\MainController@index', 'merchant.before');
Route::any('/merchant/main/passwd', '\shangfan\controller\develop\web\merchant\MainController@passwd', 'merchant.before');
Route::get('/merchant/main/qrcode/{param}', '\shangfan\controller\develop\web\merchant\MainController@qrcode', 'merchant.before');
Route::any('/merchant/upload/{param}', '\shangfan\controller\develop\web\merchant\UploadController@upload', 'merchant.before');
Route::any('/merchant/shopinfo/setshopinfo', '\shangfan\controller\develop\web\merchant\ShopInfoController@setShopInfo', 'merchant.before');
Route::any('/merchant/category/add/first', '\shangfan\controller\develop\web\merchant\ShopCategoryController@addFirst', 'merchant.before');
Route::any('/merchant/category/add/second', '\shangfan\controller\develop\web\merchant\ShopCategoryController@addSecond', 'merchant.before');
Route::get('/merchant/category/lists', '\shangfan\controller\develop\web\merchant\ShopCategoryController@lists', 'merchant.before');
Route::get('/merchant/category/listslevel2/{param}', '\shangfan\controller\develop\web\merchant\ShopCategoryController@listsLevel2', 'merchant.before');
Route::any('/merchant/category/edit/{param}', '\shangfan\controller\develop\web\merchant\ShopCategoryController@edit', 'merchant.before');
Route::any('/merchant/category/del/{param}', '\shangfan\controller\develop\web\merchant\ShopCategoryController@del', 'merchant.before');
Route::any('/merchant/mall/category/ajaxlevel1', '\shangfan\controller\develop\web\merchant\ShopCategoryController@ajaxLevel1', 'merchant.before');
Route::any('/merchant/mall/category/ajaxlevel2/{param}', '\shangfan\controller\develop\web\merchant\MallCategoryController@ajaxLevel2', 'merchant.before');
Route::any('/merchant/mall/category/ajaxlevel3/{param}', '\shangfan\controller\develop\web\merchant\MallCategoryController@ajaxLevel3', 'merchant.before');
Route::any('/merchant/shop/category/ajaxlevel1', '\shangfan\controller\develop\web\merchant\MallCategoryController@ajaxLevel1', 'merchant.before');
Route::any('/merchant/shop/category/ajaxlevel2/{param}', '\shangfan\controller\develop\web\merchant\ShopCategoryController@ajaxLevel2', 'merchant.before');
Route::get('/merchant/goods/qrcode/{param}', '\shangfan\controller\develop\web\merchant\ShopGoodsController@qrcode', 'merchant.before');
Route::any('/merchant/goods/step1', '\shangfan\controller\develop\web\merchant\ShopGoodsController@step1', 'merchant.before');
Route::any('/merchant/goods/step2/{param}', '\shangfan\controller\develop\web\merchant\ShopGoodsController@step2', 'merchant.before');
Route::post('/merchant/goods/pic/sort', '\shangfan\controller\develop\web\merchant\ShopGoodsController@picSort', 'merchant.before');
Route::get('/merchant/goods/pic/del/{param}', '\shangfan\controller\develop\web\merchant\ShopGoodsController@picDel', 'merchant.before');
Route::any('/merchant/goods/step3/{param}', '\shangfan\controller\develop\web\merchant\ShopGoodsController@step3', 'merchant.before');
Route::any('/merchant/goods/step3select/edit/{param}', '\shangfan\controller\develop\web\merchant\ShopGoodsController@step3SelectEdit', 'merchant.before');
Route::any('/merchant/goods/step3option/add/{param}', '\shangfan\controller\develop\web\merchant\ShopGoodsController@step3OptionAdd', 'merchant.before');
Route::get('/merchant/goods/step3option/lists/{param}', '\shangfan\controller\develop\web\merchant\ShopGoodsController@step3OptionLists', 'merchant.before');
Route::any('/merchant/goods/step3option/edit/{param}', '\shangfan\controller\develop\web\merchant\ShopGoodsController@step3OptionEdit', 'merchant.before');
Route::get('/merchant/goods/step3option/del/{param}', '\shangfan\controller\develop\web\merchant\ShopGoodsController@step3OptionDel', 'merchant.before');
Route::get('/merchant/goods/lists', '\shangfan\controller\develop\web\merchant\ShopGoodsController@lists', 'merchant.before');
Route::any('/merchant/goods/step1/edit/{param}', '\shangfan\controller\develop\web\merchant\ShopGoodsController@step1Edit', 'merchant.before');
Route::get('/merchant/goods/del/{param}', '\shangfan\controller\develop\web\merchant\ShopGoodsController@del', 'merchant.before');
Route::get('/merchant/goods/putaway/{param}', '\shangfan\controller\develop\web\merchant\ShopGoodsController@putaway', 'merchant.before');
Route::get('/merchant/goods/soldout/{param}', '\shangfan\controller\develop\web\merchant\ShopGoodsController@soldout', 'merchant.before');
Route::get('/merchant/goods/h5/putaway/{param}', '\shangfan\controller\develop\web\merchant\ShopGoodsController@h5Putaway', 'merchant.before');
Route::get('/merchant/goods/h5/soldout/{param}', '\shangfan\controller\develop\web\merchant\ShopGoodsController@h5Soldout', 'merchant.before');
Route::any('/merchant/goods/h5/step2/{param}', '\shangfan\controller\develop\web\merchant\ShopGoodsController@h5Step2', 'merchant.before');
Route::get('/merchant/goods/h5/preview/{param}', '\shangfan\controller\develop\web\merchant\ShopGoodsController@h5Preview', 'merchant.before');
Route::get('/merchant/stock/lists/{param}', '\shangfan\controller\develop\web\merchant\StockController@lists', 'merchant.before');
Route::post('/merchant/stock/numprice', '\shangfan\controller\develop\web\merchant\StockController@stockNumPrice', 'merchant.before');
Route::post('/merchant/stock/save', '\shangfan\controller\develop\web\merchant\StockController@save', 'merchant.before');
Route::get('/merchant/order/lists', '\shangfan\controller\develop\web\merchant\OrderController@lists', 'merchant.before');
Route::any('/merchant/order/shipments/{param}', '\shangfan\controller\develop\web\merchant\OrderController@shipments', 'merchant.before');
