layui.use(['jquery', 'layer'], function () {
    var layer = layui.layer;
    //goods
//    goodsInit();
    elementId('eveAddShopingCart').addEventListener('click', function () {
        addShopingCart();
    });
    elementId('eveAddBuy').addEventListener('click', function () {
        addBuy();
    });
    //btn
    elementId('eveBarAddShopingCart').addEventListener('click', function () {
        modelOpen();
    });
    elementId('eveBarAddBuy').addEventListener('click', function () {
        modelOpen();
    });
    elementId('eveClose').addEventListener('click', function () {
        modelClose();
    });
    elementId('eveFocusShopAdd').addEventListener('click', function () {
        var $param = {
            shopUserId: elementId('shopUserId').value
        };
        layui.$.post('/h5/member/focus/shop/add', $param, function ($data) {
            layer.msg($data.message);
            if ($data.status == 1) {
                window.setTimeout(function () {
                    window.location.reload();
                }, 1000);
            }
        });
    });
    //nav
    elementId('eveCover').addEventListener('click', function () {
        elementId('eveCoverContainer').scrollIntoView();
        modelClose();
    });
    elementId('eveBuy').addEventListener('click', function () {
        modelOpen();
    });
    elementId('eveDetail').addEventListener('click', function () {
        elementId('eveDetailContainer').scrollIntoView();
        modelClose();
    });
    elementId('eveRecommend').addEventListener('click', function () {
        elementId('eveRecommendContainer').scrollIntoView();
        modelClose();
    });
});
function modelClose() {
    elementId('model').style.display = 'none';
}
function modelOpen() {
    elementId('model').style.display = 'inline';
}
function goodsMainOptionValue() {
    var $eveMainOptionItem = elementClass('eveMainOptionItem');
    if (!$eveMainOptionItem.length) {
        return 0;
    }
    for (var $i = 0; $i < $eveMainOptionItem.length; $i++) {
        if (!$eveMainOptionItem[$i]) {
            continue;
        }
        if ($eveMainOptionItem[$i].className == 'item eveMainOptionItem active') {
            return $eveMainOptionItem[$i].getAttribute('goodsOptionId');
        }
    }
    return 0;
}
function goodsNoMainOptionValue() {
    var $eveNoMainOptionItem = elementClass('eveNoMainOptionItem');
    if (!$eveNoMainOptionItem.length) {
        return 0;
    }
    for (var $i = 0; $i < $eveNoMainOptionItem.length; $i++) {
        if (!$eveNoMainOptionItem[$i]) {
            continue;
        }
        if ($eveNoMainOptionItem[$i].className == 'item eveNoMainOptionItem active') {
            return $eveNoMainOptionItem[$i].getAttribute('goodsOptionId');
        }
    }
    return 0;
}
function goodsMainOptionIdClick($this) {
    var $eveMainOptionItem = elementClass('eveMainOptionItem');
    if ($eveMainOptionItem.length) {
        for (var $i = 0; $i < $eveMainOptionItem.length; $i++) {
            if ($eveMainOptionItem[$i]) {
                $eveMainOptionItem[$i].classList.remove('active');
            }
        }
    }
    $this.classList.add('active');
    return goodsAjaxIdsOption();
}
function goodsNoMainOptionIdClick($this) {
    var $eveNoMainOptionItem = elementClass('eveNoMainOptionItem');
    if ($eveNoMainOptionItem.length) {
        for (var $i = 0; $i < $eveNoMainOptionItem.length; $i++) {
            if ($eveNoMainOptionItem[$i]) {
                $eveNoMainOptionItem[$i].classList.remove('active');
            }
        }
    }
    $this.classList.add('active');
    return goodsAjaxIdsOption();
}
function goodsAjaxIdsOption() {
    var $param = {
        shopGoodsMd5: elementId('shopGoodsMd5').value,
        idsOption: goodsMainOptionValue() + ',' + goodsNoMainOptionValue()
    };
    layui.$.post('/h5/shop/goods/ajax/option', $param, function ($data) {
        if ($data.status === 0) {
            layer.msg($data.message);
            return;
        }
        if ($data.data.price) {
            elementId('eveCoverPreview').src = $data.data.pic_src;
            elementId('eveMemberPrice').innerHTML = $data.data.price;
            elementId('eveStockNumber').innerHTML = $data.data.stock;
        }
    });
}
function isUseNoMain() {
    $isUseNoMain = parseInt(elementId('isUseNoMain').value);
    return $isUseNoMain ? true : false;
}
function addShopingCart() {
    var $param = {
        shopGoodsMd5: elementId('shopGoodsMd5').value,
        idsOption: goodsMainOptionValue() + ',' + goodsNoMainOptionValue(),
        number: 1
    };
    layui.$.post('/h5/mall/shopingcart/add', $param, function ($data) {
        layer.msg($data.message);
        if ($data.status === 1) {
            layer.confirm('加入购物车成功，继续购物？', {
                btn: ['继续购物', '去购物车结算']
            }, function () {
                layer.msg('稍后您可以进入购物车结算', {icon: 1});
            }, function () {
                window.location.href = '/h5/mall/shopingcart/lists';
            });
        }
    });
}
function addBuy() {
    var $param = {
        shopGoodsMd5: elementId('shopGoodsMd5').value,
        idsOption: goodsMainOptionValue() + ',' + goodsNoMainOptionValue(),
        number: 1
    };
    layui.$.post('/h5/mall/shopingcart/buy', $param, function ($data) {
        if ($data.status === 0) {
            layer.msg($data.message);
            return;
        }
        if ($data.status === 1) {
            window.location.href = '/h5/mall/order/detail/' + $data.data.orderNumber;
        }
    });
}