<?= view('base.web.admin.common.header')?>
<script src="<?= resource('/base/web/public/js/shangfan.admin/shopUser.lists.js') ?>"></script>

<div class="layui-layout layui-layout-admin">
    <?= view('base.web.admin.common.navigation')?>
    <?= view('base.web.admin.common.menu')?>
    <!-- body -->
    <div class="layui-body">
        <div class="container">
            
            <div class="home-container">
                <i class="layui-icon layui-icon-location"></i>当前位置： 后台首页 / 商家管理 / 商家列表
            </div>
            <div class="tab-container-gray">
                <a href="<?= urlAdmin('/shopuser/lists') ?>" class="item active">商家列表</a>
            </div>
            
            <div class="table-container">
                <table class="layui-table">
                    <colgroup>
                        <col style="width: 70px;">
                        <col style="width: 100px;">
                        <col style="width: 100px;">
                        <col>
                        <col width="10%">
                        <col width="10%">
                        <col width="15%">
                        <col width="10%">
                        <col width="20%">
                    </colgroup>
                    <thead>
                        <tr>
                            <th>序号</th>
                            <th>账号</th>
                            <th>姓名</th>
                            <th>店铺名称</th>
                            <th>类型</th>
                            <th>余额</th>
                            <th>地区</th>
                            <th>账号状态/店铺状态</th>
                            <th>操作</th>
                        </tr> 
                    </thead>
                    <tbody>
                        <?php if(isset($results->results) && count($results->results)):?>
                        <?php foreach ($results->results as $val):?>
                        <tr>
                            <td><?=$val->id?></td>
                            <td>
                                <a href="<?=url('/shop/go/shop/'.$val->md5)?>" target="_blank"><?=$val->user?></a>
                            </td>
                            <td><?=$val->name?></td>
                            <td><?=$val->strShopInfoTitle?></td>
                            <td><?=$val->strType?></td>
                            <td><?=$val->rmb?></td>
                            <td><?=$val->strProvince?>/<?=$val->strCity?>/<?=$val->strCountry?></td>
                            <td>
                                <?php if($val->status == 1):?>
                                <span class="statusSuccess"><?=$val->strStatus?></span>
                                <?php else:?>
                                <span class="statusWarning"><?=$val->strStatus?></span>
                                <?php endif;?>
                                /
                                <?php if($val->is_online == 1):?>
                                <span class="statusSuccess"><?=$val->strIsOnline?></span>
                                <?php else:?>
                                <span class="statusWarning"><?=$val->strIsOnline?></span>
                                <?php endif;?>
                            </td>
                            <td>
                                <p>
                                    <?php if($val->is_online == 2):?>
                                    <a href="<?= urlAdmin('/shopuser/shop/online/'.$val->id)?>" class="input-button-gray input-button-a eveShopOnline">店铺审核通过</a>
                                    <?php endif;?> 
                                    <?php if($val->is_online == 1):?>
                                    <a href="<?=urlAdmin('/shopuser/shop/offline/'.$val->id)?>" class="input-button-gray input-button-a eveShopOffline">店铺审核拒绝</a>
                                    <?php endif;?> 
                                    <a href="<?=url('/shop/go/shop/'.$val->id)?>" target="_blank" class="input-button-gray input-button-a">查看店铺</a>
                                </p>
                                <p style="margin-top: 15px;">
                                    <?php if($val->status == 1):?>
                                    <a href="<?= urlAdmin('/shopuser/lock/'.$val->id) ?>" class="input-button-gray input-button-a eveLock">账号锁定</a>
                                    <?php endif;?>
                                    <?php if($val->status == 2):?>
                                    <a href="<?= urlAdmin('/shopuser/unlock/'.$val->id) ?>" class="input-button-gray input-button-a eveUnlock">账号解锁</a>
                                    <?php endif;?>
                                    <a href="<?= urlAdmin('/shopuser/del/'.$val->id) ?>" class="input-button-gray input-button-a eveDel">账号删除</a>
                                </p>
                            </td>
                        </tr>
                        <?php endforeach;?>
                        <?php else:?>
                        <tr>
                            <td colspan="10">暂无数据</td>
                        </tr>
                        <?php endif;?>
                        <tr>
                            <td colspan="10" style="text-align: right;"><?=$results->render();?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            
        </div>
    </div>
    <!-- //body -->
</div>

<?= view('base.web.admin.common.footer')?>