<?php
/**
 * 通用通知接口demo
 * ====================================================
 * 支付完成后，微信会把相关支付和用户信息发送到商户设定的通知URL，
 * 商户接收回调信息后，根据需要设定相应的处理流程。
 * 
 * 这里举例使用log文件形式记录回调信息。
*/
	include_once("./log_.php");
	include_once("../WxPayPubHelper/WxPayPubHelper.php");

    //使用通用通知接口
	$notify = new Notify_pub();

	//存储微信的回调
	$xml = file_get_contents("php://input");
//        $xml="<xml><appid><![CDATA[wxe4a5e1d88489d181]]></appid>
//<bank_type><![CDATA[CFT]]></bank_type>
//<cash_fee><![CDATA[1]]></cash_fee>
//<fee_type><![CDATA[CNY]]></fee_type>
//<is_subscribe><![CDATA[N]]></is_subscribe>
//<mch_id><![CDATA[1491107022]]></mch_id>
//<nonce_str><![CDATA[3JD4KD2PECLKMZRZ]]></nonce_str>
//<openid><![CDATA[oR735w5LEMjJcA76Vz8HvNXk4s9Y]]></openid>
//<out_trade_no><![CDATA[GB02918797273335]]></out_trade_no>
//<result_code><![CDATA[SUCCESS]]></result_code>
//<return_code><![CDATA[SUCCESS]]></return_code>
//<sign><![CDATA[53BE1D7318FC3CA17BF680C1C2F8AA5B]]></sign>
//<time_end><![CDATA[20171102110448]]></time_end>
//<total_fee>1</total_fee>
//<trade_type><![CDATA[APP]]></trade_type>
//<transaction_id><![CDATA[4200000010201711021882146438]]></transaction_id>
//</xml>";
	$notify->saveData($xml);
	
	//验证签名，并回应微信。
	//对后台通知交互时，如果微信收到商户的应答不是成功或超时，微信认为通知失败，
	//微信会通过一定的策略（如30分钟共8次）定期重新发起通知，
	//尽可能提高通知的成功率，但微信不保证通知最终能成功。
	if($notify->checkSign() == 0){
		$notify->setReturnParameter("return_code","FAIL");//返回状态码
		$notify->setReturnParameter("return_msg","签名失败");//返回信息
	}else{
		$notify->setReturnParameter("return_code","SUCCESS");//设置返回码
	}
	$returnXml = $notify->returnXml();
	//echo $returnXml;
	
	//==商户根据实际情况设置相应的处理流程，此处仅作举例=======
	
	//以log文件形式记录回调信息
	$log_ = new Log_();
	$log_name="./notify_url.log";//log文件路径
	$log_->log_result($log_name,"【接收到的notify通知】:\n".$xml."\n");
	if($notify->checkSign() == 1)
	{
		if ($notify->data["return_code"] == "FAIL") {
			//此处应该更新一下订单状态，商户自行增删操作
			$log_->log_result($log_name,"【通信出错】:\n".$xml."\n");
		}
		elseif($notify->data["result_code"] == "FAIL"){
			//此处应该更新一下订单状态，商户自行增删操作
			$log_->log_result($log_name,"【业务出错】:\n".$xml."\n");
		}
		else{
			//此处应该更新一下订单状态，商户自行增删操作
			$log_->log_result($log_name,"【支付成功】:\n".$xml."\n");
			
			
		//自己的业务逻辑
		$postObj = simplexml_load_string($xml, 'SimpleXMLElement', LIBXML_NOCDATA);
		$result_code = $postObj->result_code; //SUCCESS
		$out_trade_no = $postObj->out_trade_no;
		$openid = $postObj->openid;
		$total_fee = $postObj->total_fee;
		$total_fee = $total_fee / 100;
			
			
			
		
	 
	 		      
                   
                $url="http://".$_SERVER['HTTP_HOST']."/index.php?c=product&a=pay_wan&option=".$out_trade_no."&action=微信支付";         
                 $file=file_get_contents($url);
                    //   logResult($wl);		 
                       $wl1=json_decode($file,1);
                          if($wl1['slay']==1){
                               $log_->log_result($log_name,"单号".$out_trade_no); 
                               $log_->log_result($log_name,"状态：".'支付成功');
                            
                          }
	  
	  
	  

                

			
	
		
               }
		//商户自行增加处理流程,
		//例如：更新订单状态
		//例如：数据库操作
		//例如：推送支付完成信息
	}else {
        $log_->log_result($log_name,"【验签失败】:\n".$xml."\n");
    }
?>