/*
SQLyog Ultimate v11.11 (32 bit)
MySQL - 5.5.53 : Database - demo_tpshop5
*********************************************************************
*/


/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`demo_tpshop5` /*!40100 DEFAULT CHARACTER SET utf8 */;

/*Table structure for table `tp_account_log` */

DROP TABLE IF EXISTS `tp_account_log`;

CREATE TABLE `tp_account_log` (
  `log_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '日志id',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `user_money` decimal(10,2) DEFAULT '0.00' COMMENT '用户金额',
  `frozen_money` decimal(10,2) DEFAULT '0.00' COMMENT '冻结金额',
  `pay_points` mediumint(9) NOT NULL DEFAULT '0' COMMENT '支付积分',
  `change_time` int(10) unsigned NOT NULL COMMENT '变动时间',
  `desc` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `order_sn` varchar(50) DEFAULT NULL COMMENT '订单编号',
  `order_id` int(10) DEFAULT NULL COMMENT '订单id',
  PRIMARY KEY (`log_id`),
  KEY `user_id` (`user_id`)
)  AUTO_INCREMENT=512 DEFAULT CHARSET=utf8;

/*Data for the table `tp_account_log` */

LOCK TABLES `tp_account_log` WRITE;

insert  into `tp_account_log`(`log_id`,`user_id`,`user_money`,`frozen_money`,`pay_points`,`change_time`,`desc`,`order_sn`,`order_id`) values (1,1,0.00,0.00,100,1523235674,'会员注册赠送积分','',0),(148,1,10.00,0.00,0,1524106226,'退还预售商品保罗骑士男鞋2018春季新款英伦风真皮男小白鞋休闲鞋潮流系带板鞋 2018春季上新 简约英伦风的定金，订单ID为：156','201804191038534536',156),(4,3,0.00,0.00,100,1523266058,'会员注册赠送积分','',0),(5,4,0.00,0.00,100,1523266117,'会员注册赠送积分','',0),(6,4,0.00,0.00,10,1523339894,'第一次签到赠送10积分','',0),(149,1,10.00,0.00,0,1524106226,'退还预售商品保罗骑士男鞋2018春季新款英伦风真皮男小白鞋休闲鞋潮流系带板鞋 2018春季上新 简约英伦风的定金，订单ID为：155','201804191037058053',155),(12,5,0.00,0.00,100,1523588976,'会员注册赠送积分','',0),(13,5,99999999.99,0.00,8388607,1523589115,'54','',0),(14,5,-6999.00,0.00,0,1523589451,'下单消费','201804131117304233',13),(15,6,0.00,0.00,100,1523601798,'会员注册赠送积分','',0),(16,7,0.00,0.00,100,1523608222,'会员注册赠送积分','',0),(17,5,-99999000.99,0.00,-8388608,1523610023,'2323','',0),(18,5,6000.00,0.00,0,1523610085,'232323','',0),(19,5,-500.00,0.00,0,1523610244,'23','',0),(20,5,0.00,0.00,300,1523610392,'223','',0),(21,5,100.00,0.00,100,1523610407,'22233','',0),(22,5,400.00,0.00,0,1523610455,'322323','',0),(23,5,400.00,0.00,0,1523610555,'223323','',0),(24,5,-300.00,0.00,0,1523610573,'22323','',0),(150,3,0.00,0.00,500,1524107046,'订单活动赠送积分','',0),(151,1,0.00,0.00,300,1524108766,'订单活动赠送积分','',0),(152,9,20000.00,0.00,100000,1524108975,'55222','',0),(153,3,-20.00,0.00,0,1524118019,'下单消费','201804191405212235',183),(154,3,-0.02,0.00,-1661,1524118107,'下单消费','201804191405212235',183),(155,2,-102.60,0.00,0,1524118295,'下单消费','201804191410534924',188),(156,5,50000.00,0.00,2000,1524118340,'8554222','',0),(157,9,-99.00,0.00,0,1524119285,'下单消费','201804191427531531',195),(158,1,10000.00,0.00,0,1524119560,'00','',0),(159,10,10000.00,0.00,0,1524119645,'11','',0),(160,10,-108.00,0.00,0,1524120398,'下单消费','201804191446213375',201),(161,5,-186.12,0.00,0,1524120406,'下单消费','201804191445229243',200),(162,9,-99.00,0.00,0,1524120548,'下单消费','201804191448531215',202),(163,9,59.00,0.00,0,1524121129,'用户取消订单退款','201804191137215202',171),(164,3,10.00,0.00,0,1524121268,'','201804191405212235',183),(165,3,0.00,0.00,500,1524121718,'订单活动赠送积分','',0),(166,3,0.00,0.00,200,1524121718,'下单赠送积分','201804191405212235',183),(44,8,0.00,0.00,100,1523857661,'会员注册赠送积分','',0),(167,10,0.00,0.00,500,1524122331,'订单活动赠送积分','',0),(168,5,0.00,0.00,10,1524122382,'第一次签到赠送10积分','',0),(47,6,1000.00,0.00,0,1523860790,'CESHI','',0),(48,9,0.00,0.00,100,1523861478,'会员注册赠送积分','',0),(49,10,0.00,0.00,100,1523864842,'会员注册赠送积分','',0),(169,10,-108.00,0.00,0,1524122521,'下单消费','201804191439479569',199),(170,2,-102.60,0.00,0,1524122650,'下单消费','201804191523415828',205),(171,2,0.00,0.00,500,1524123178,'订单活动赠送积分','',0),(172,2,0.00,0.00,500,1524123181,'订单活动赠送积分','',0),(173,10,0.00,0.00,500,1524123224,'订单活动赠送积分','',0),(174,2,-142.50,0.00,0,1524123445,'下单消费','201804191536391831',209),(175,10,-150.00,0.00,0,1524123556,'下单消费','201804191538171030',210),(176,2,-142.50,0.00,0,1524123689,'下单消费','201804191540599893',213),(177,2,102.60,0.00,0,1524124080,'用户申请商品退款','201804191523415828',205),(178,2,1000.00,0.00,0,1524124147,'111','',0),(179,2,-46.82,0.00,0,1524125666,'下单消费','201804191613335437',215),(180,10,-29.90,0.00,0,1524126097,'下单消费','201804191621165259',217),(181,10,-60.00,0.00,0,1524126202,'下单消费','201804191622575839',218),(182,10,-69.70,0.00,0,1524126267,'下单消费','201804191623521017',219),(183,3,0.00,0.00,10,1524126612,'第一次签到赠送10积分','',0),(184,3,0.00,0.00,-278,1524126744,'下单消费','201804191632098352',222),(185,5,-28.80,0.00,0,1524127087,'下单消费','201804191637482212',223),(186,10,-36.90,0.00,0,1524127168,'下单消费','201804191639037742',224),(187,2,-34.56,0.00,0,1524127233,'下单消费','201804191640111379',226),(188,9,-30.00,0.00,0,1524127340,'下单消费','201804191641409909',227),(189,10,1.00,0.00,0,1524127374,'','201804191639037742',224),(190,5,28.80,0.00,0,1524127583,'用户申请订单退款','201804191637482212',223),(191,10,-39.90,0.00,0,1524127782,'下单消费','201804191649421833',228),(192,9,0.00,0.00,10,1524127807,'第一次签到赠送10积分','',0),(77,11,0.00,0.00,100,1523933777,'会员注册赠送积分','',0),(193,3,-10.00,0.00,0,1524128915,'下单消费','201804191708099385',230),(194,3,-0.01,0.00,-177,1524129045,'下单消费','201804191708099385',230),(195,2,-27.91,0.00,0,1524129536,'下单消费','201804191718103193',234),(196,2,-102.60,0.00,0,1524129642,'下单消费','201804191720239500',235),(83,3,3000.00,0.00,20000,1523955450,'8524112','',0),(84,3,-133.90,0.00,0,1523955774,'下单消费','201804171702545505',81),(197,10,-108.00,0.00,0,1524130150,'下单消费','201804191727544276',236),(86,3,-1359.00,0.00,0,1523956270,'下单消费','201804171711102334',83),(87,3,-25.00,0.00,-1000,1523957538,'下单消费','201804171732185193',84),(88,3,-288.00,0.00,0,1523958311,'下单消费','201804171745113240',85),(89,3,25.00,0.00,1000,1523959757,'用户申请订单退款','201804171732185193',84),(90,3,-445.20,0.00,0,1523960700,'下单消费','201804171824596144',88),(91,3,0.00,0.00,-700,1524013784,'下单消费','201804180909434096',90),(92,3,-214.83,0.00,0,1524015676,'下单消费','201804180941158584',91),(94,3,-199.00,0.00,0,1524016084,'下单消费','201804180948035281',93),(95,3,-198.00,0.00,0,1524016232,'下单消费','201804180950326430',94),(96,3,0.00,0.00,20000,1524016418,'下单赠送积分','201804180950326430',94),(97,3,199.00,0.00,0,1524017092,'用户申请商品退款','201804180948035281',93),(198,10,-108.00,0.00,0,1524130196,'下单消费','201804191729283108',237),(199,10,108.00,0.00,0,1524185726,'用户申请订单退款','201804191729283108',237),(200,10,-39.90,0.00,0,1524186800,'下单消费','201804200912448956',243),(102,3,-24.00,0.00,0,1524021536,'下单消费','201804181118567164',97),(103,3,3330.00,0.00,10000,1524021662,'232323','',0),(104,3,-2589.30,0.00,0,1524021696,'下单消费','201804181121369575',98),(105,3,-117.00,0.00,0,1524022277,'下单消费','201804181131176524',99),(106,3,-78.00,0.00,0,1524022621,'下单消费','201804181137003556',100),(107,3,-39.00,0.00,0,1524022664,'下单消费','201804181137448196',101),(108,3,-49.00,0.00,0,1524022707,'下单消费','201804181138272876',102),(109,3,-117.00,0.00,0,1524022951,'下单消费','201804181142316679',103),(201,10,-29.90,0.00,0,1524187582,'下单消费','201804200926046917',244),(111,12,0.00,0.00,100,1524023190,'会员注册赠送积分','',0),(202,13,0.00,0.00,100,1524188790,'会员注册赠送积分','',0),(203,14,0.00,0.00,100,1524188838,'会员注册赠送积分','',0),(204,3,3000.00,0.00,0,1524189050,'655','',0),(205,3,0.00,0.00,-48494,1524189139,'885542','',0),(206,3,0.00,0.00,993,1524189156,'/8855','',0),(116,3,-136.00,0.00,0,1524031798,'下单消费','201804181409587926',109),(207,3,0.00,0.00,-1991,1524189179,'855','',0),(118,3,-135.00,0.00,0,1524032744,'下单消费','201804181425438341',111),(208,2,-27.91,0.00,0,1524189218,'下单消费','201804200953146860',247),(209,3,0.00,0.00,1000,1524189364,'855411225555522','',0),(210,2,-27.91,0.00,0,1524189369,'下单消费','201804200955479850',248),(211,1,0.00,0.00,100,1524189711,'下单赠送积分','201804171603071811',77),(212,15,0.00,0.00,100,1524189832,'会员注册赠送积分','',0),(125,3,-277.30,0.00,0,1524036355,'下单消费','201804181525553150',119),(126,3,277.30,0.00,0,1524036394,'用户申请订单退款','201804181525553150',119),(127,3,-277.30,0.00,0,1524036468,'下单消费','201804181527487192',122),(128,3,0.00,0.00,500,1524036758,'订单活动赠送积分','',0),(213,3,-22.90,0.00,-200,1524190629,'下单消费','201804201014599182',249),(130,12,2000.00,0.00,3000,1524039418,'232323','',0),(214,3,-26.80,0.00,0,1524193290,'下单消费','201804201100389900',250),(215,3,-26.80,0.00,0,1524193380,'下单消费','201804201102075320',251),(133,12,0.00,0.00,-700,1524039767,'下单消费','201804181622465608',128),(216,2,0.00,0.00,-1000,1524195039,'下单消费','201804201130393117',252),(217,2,0.00,0.00,1000,1524204106,'订单取消，退回0.00元,1000积分','201804201130393117',252),(218,2,-37.91,0.00,0,1524204661,'下单消费','201804201410507328',253),(219,3,0.00,0.00,-700,1524205360,'下单消费','201804201422393062',254),(141,3,-3.73,0.00,0,1524043134,'下单消费','201804181718541808',133),(220,3,0.00,0.00,350,1524205856,'用户申请商品退款','201804201422393062',254),(221,3,0.00,0.00,350,1524205856,'用户申请商品退款','201804201422393062',254),(222,3,0.00,0.00,-350,1524206125,'下单消费','201804201435244467',256),(146,3,-100.00,0.00,0,1524044435,'下单消费','201804181740351558',138),(147,3,0.00,0.00,500,1524044881,'订单活动赠送积分','',0),(223,3,0.00,0.00,350,1524206168,'用户申请订单退款','201804201435244467',256),(224,3,-261.32,0.00,0,1524206652,'下单消费','201804201444127651',257),(225,3,0.00,0.00,350,1524206666,'用户申请商品退款','201804201422393062',254),(226,3,261.32,0.00,0,1524207269,'用户申请商品退款','201804201444127651',257),(227,9,-177.00,0.00,0,1524207870,'下单消费','201804201504303648',258),(228,9,0.00,0.00,100,1524208101,'下单赠送积分','201804191427531531',195),(229,2,-24.00,0.00,-1000,1524208257,'下单消费','201804201510574786',259),(230,10,-39.90,0.00,0,1524208508,'下单消费','201804201514538922',260),(231,9,-178.20,0.00,0,1524208608,'下单消费','201804201516472940',261),(232,10,-250.00,0.00,0,1524208683,'下单消费','201804201518034699',262),(233,2,-250.00,0.00,-90,1524208772,'下单消费','201804201519314892',263),(234,2,-49.00,0.00,0,1524208862,'下单消费','201804201521024404',264),(235,10,-20.00,0.00,0,1524209156,'下单消费','201804201525412217',265),(236,10,-9.90,0.00,0,1524209203,'下单消费','201804201525412217',265),(237,3,0.00,0.00,10,1524210091,'签到赠送10积分','',0),(238,10,-86.00,0.00,0,1524212863,'下单消费','201804201627427860',277),(239,9,-108.00,0.00,0,1524212958,'下单消费','201804201629172125',280),(240,10,0.00,0.00,100,1524213263,'下单赠送积分','201804201626314342',276),(241,9,20.00,0.00,0,1524213266,'退还预售商品预售限制地区的定金，订单ID为：269','201804201614008080',269),(242,9,20.00,0.00,0,1524213266,'退还预售商品预售限制地区的定金，订单ID为：270','201804201622089747',270),(243,9,20.00,0.00,0,1524213266,'退还预售商品预售限制地区的定金，订单ID为：272','201804201621099183',272),(244,10,0.00,0.00,1000,1524213412,'下单赠送积分','201804201622259675',274),(245,9,40.00,0.00,0,1524214205,'用户申请商品退款','201804201602569047',268),(246,10,60.00,0.00,0,1524214658,'订单取消，退回60.00元,0积分','201804191622575839',218),(247,9,120.00,0.00,0,1524214864,'用户申请商品退款','201804201601104633',267),(248,10,250.00,0.00,0,1524215058,'用户申请商品退款','201804201626314342',276),(249,9,-9587.00,0.00,0,1524215945,'56656','',0),(250,10,-260.00,0.00,0,1524216002,'下单消费','201804201720027469',286),(251,10,-260.00,0.00,0,1524216003,'下单消费','201804201720037606',287),(252,9,9587.00,0.00,0,1524216056,'1','',0),(253,10,-531.30,0.00,0,1524216194,'下单消费','201804201723132286',288),(254,10,-505.00,0.00,0,1524217615,'下单消费','201804201746328746',296),(255,2,-484.00,0.00,0,1524217872,'下单消费','201804201750463182',297),(256,10,598.00,0.00,0,1524217946,'','201804201746328746',296),(257,10,-505.00,0.00,0,1524218242,'下单消费','201804201756461015',298),(258,2,-484.00,0.00,0,1524218364,'下单消费','201804201759055459',299),(259,2,0.00,0.00,100,1524218598,'下单赠送积分','201804201759055459',299),(260,2,475.00,0.00,0,1524218862,'用户申请商品退款','201804201759055459',299),(261,10,0.00,0.00,100,1524420323,'下单赠送积分','201804201756461015',298),(262,10,250.00,0.00,0,1524444939,'订单取消，退回250.00元,0积分','201804201518034699',262),(263,10,531.30,0.00,0,1524444939,'订单取消，退回531.30元,0积分','201804201723132286',288),(264,3,0.00,0.00,10,1524445675,'签到赠送10积分','',0),(265,3,0.00,0.00,-350,1524446789,'下单消费','201804230926287100',302),(266,2,24.00,0.00,1000,1524449003,'订单取消，退回24.00元,1000积分','201804201510574786',259),(267,2,-198.00,0.00,0,1524449918,'下单消费','201804231017098339',307),(268,10,-190.00,0.00,-160,1524450121,'下单消费','201804231019529851',308),(269,2,-602.00,0.00,0,1524450692,'下单消费','201804231030524150',312),(270,10,-404.00,0.00,0,1524450778,'下单消费','201804231032302189',313),(271,9,-60.00,0.00,0,1524451199,'管理员处理用户提现申请','',0),(272,9,-1000.00,0.00,0,1524451245,'管理员处理用户提现申请','',0),(273,2,-44.00,0.00,-50,1524451867,'下单消费','201804231051078308',314),(274,10,-352.00,0.00,0,1524452234,'下单消费','201804231057135002',315),(275,2,-50.00,0.00,-2000,1524453580,'下单消费','201804231119409851',316),(276,10,-25.00,0.00,-1000,1524453933,'下单消费','201804231125338576',317),(277,10,-25.00,0.00,-1000,1524454306,'下单消费','201804231131468119',318),(278,10,0.00,0.00,100,1524455331,'下单赠送积分','201804231147305805',320),(279,2,100.00,0.00,0,1524455591,'DD','201804231030524150',312),(280,10,-25.00,0.00,-240,1524455808,'下单消费','201804231156477263',323),(281,3,-201.00,0.00,0,1524455996,'下单消费','201804231159562431',324),(282,10,-100.00,0.00,0,1524462356,'下单消费','201804231345569849',325),(283,10,0.00,0.00,1000,1524464008,'下单赠送积分','201804231345569849',325),(284,10,-59.00,0.00,0,1524464946,'下单消费','201804231429051062',327),(285,10,-10.00,0.00,0,1524466169,'下单消费','201804231449297833',328),(286,3,-317.72,0.00,0,1524466432,'下单消费','201804231453528829',329),(287,10,0.00,0.00,100,1524466507,'下单赠送积分','201804231356386989',326),(288,10,-59.00,0.00,-35,1524467113,'下单消费','201804231503544313',330),(289,10,-67.00,0.00,0,1524467439,'下单消费','201804231510394474',335),(290,10,-10.00,0.00,0,1524470019,'下单消费','201804231553396775',339),(291,10,-42.40,0.00,0,1524470394,'下单消费','201804231559531419',340),(292,16,0.00,0.00,100,1524470536,'会员注册赠送积分','',0),(293,10,-378.00,0.00,0,1524471718,'下单消费','201804231621586676',341),(294,5,-83.66,0.00,0,1524541695,'下单消费','201804241148157916',350),(295,2,-177.00,0.00,0,1524541815,'下单消费','201804241150159981',351),(296,2,168.00,0.00,0,1524542070,'用户申请商品退款','201804241150159981',351),(297,2,-196.00,0.00,0,1524548235,'下单消费','201804241337157707',354),(298,3,-216.00,0.00,0,1524549713,'下单消费','201804241401525238',355),(299,3,-102.37,0.00,0,1524552678,'下单消费','201804241451186379',356),(300,3,-199.19,0.00,0,1524553669,'下单消费','201804241507495471',357),(301,17,0.00,0.00,100,1524554349,'会员注册赠送积分','',0),(302,17,10000.00,0.00,0,1524554535,'8555555','',0),(303,2,-294.00,0.00,0,1524555667,'下单消费','201804241541069985',358),(304,17,-172.50,0.00,0,1524555720,'下单消费','201804241542003139',359),(305,17,0.00,0.00,400,1524555904,'下单赠送积分','201804241542003139',359),(306,2,-82.72,0.00,0,1524556735,'下单消费','201804241558554559',360),(307,3,-39.90,0.00,0,1524558343,'下单消费','201804241625433279',362),(308,3,-69.80,0.00,0,1524558405,'下单消费','201804241626455164',363),(309,3,-69.80,0.00,0,1524558538,'下单消费','201804241628587011',364),(310,3,0.00,0.00,200,1524558744,'下单赠送积分','201804241628587011',364),(311,3,0.00,0.00,-698,1524558863,'下单消费','201804241634228009',365),(312,3,29.90,0.00,0,1524559802,'用户申请商品退款','201804241628587011',364),(313,17,59.80,0.00,0,1524560040,'用户申请商品退款','201804241542003139',359),(314,3,110.92,0.00,0,1524560307,'用户申请商品退款','201804241507495471',357),(315,3,0.00,0.00,50000,1524560575,'855412255555533443','',0),(316,2,-281.06,0.00,0,1524561952,'下单消费','201804241725527037',369),(317,17,-82.80,0.00,0,1524563178,'下单消费','201804241746187580',373),(318,2,-139.66,0.00,0,1524565051,'下单消费','201804241817302207',378),(319,2,-186.12,0.00,0,1524566329,'下单消费','201804241838496183',387),(320,3,-0.06,0.00,-1715,1524617536,'下单消费','201804250852158739',388),(321,3,-7.94,0.00,1715,1524618200,'用户申请商品退款','201804250852158739',388),(322,3,-70.05,0.00,0,1524619938,'下单消费','201804250932188377',389),(323,18,0.00,0.00,100,1524623385,'会员注册赠送积分','',0),(324,3,-70.05,0.00,0,1524628920,'下单消费','201804251201591732',390),(325,3,-294.23,0.00,0,1524634991,'下单消费','201804251343119753',391),(326,3,-294.23,0.00,0,1524635584,'下单消费','201804251353042717',394),(327,3,294.23,0.00,0,1524635629,'用户申请订单退款','201804251353042717',394),(328,3,-465.86,0.00,0,1524635857,'下单消费','201804251357361806',395),(329,3,465.86,0.00,0,1524635888,'用户申请订单退款','201804251357361806',395),(330,3,-371.30,0.00,0,1524639991,'下单消费','201804251506313069',398),(331,3,-297.04,0.00,0,1524640099,'下单消费','201804251508197412',399),(332,2,-1700.04,0.00,-759,1524640110,'下单消费','201804251508301323',400),(333,3,-322.90,0.00,0,1524640175,'下单消费','201804251509356054',401),(334,3,-259.92,0.00,0,1524640198,'下单消费','201804251509589099',402),(335,2,-1775.94,0.00,0,1524640223,'下单消费','201804251510236147',403),(336,12,-88.00,0.00,0,1524640571,'下单消费','201804251516107466',404),(337,2,1775.94,0.00,0,1524640758,'用户申请订单退款','201804251510236147',403),(338,2,-1775.12,0.00,-8,1524640903,'下单消费','201804251521438147',406),(339,2,0.00,0.00,10000,1524640963,'下单赠送积分','201804251521438147',406),(340,2,1775.12,0.00,8,1524641200,'用户申请商品退款','201804251521438147',406),(341,2,0.02,0.00,0,1524641200,'用户申请商品退款','201804251521438147',406),(342,12,-88.00,0.00,0,1524641309,'下单消费','201804251528297240',407),(343,3,-148.52,0.00,0,1524641549,'下单消费','201804251532281641',408),(344,3,-12.24,0.00,-2411,1524641703,'下单消费','201804251535029706',409),(345,3,5000.00,0.00,0,1524642024,'232323','',0),(346,3,-297.04,0.00,0,1524642044,'下单消费','201804251540442415',410),(347,3,0.00,0.00,1200,1524642084,'下单赠送积分','201804251540442415',410),(348,3,74.26,0.00,0,1524642123,'用户申请商品退款','201804251540442415',410),(349,3,-297.04,0.00,0,1524642277,'下单消费','201804251544362936',413),(350,2,-657.99,0.00,0,1524642324,'下单消费','201804251545249728',414),(351,2,-657.99,0.00,0,1524642489,'下单消费','201804251548092992',415),(352,2,-251.92,0.00,0,1524642621,'下单消费','201804251550211718',416),(353,2,0.00,0.00,-350,1524643049,'下单消费','201804251557289441',417),(354,2,0.00,0.00,350,1524643206,'用户申请订单退款','201804251557289441',417),(355,2,-59.00,0.00,0,1524647974,'下单消费','201804251719345355',425),(356,2,-12.97,0.00,0,1524648233,'下单消费','201804251723538622',426),(357,2,-12.97,0.00,0,1524649769,'下单消费','201804251749299473',427),(358,2,-100.00,0.00,0,1524649921,'下单消费','201804251752019282',428),(359,2,-90.00,0.00,0,1524650374,'下单消费','201804251759342677',429),(360,2,-9.31,0.00,0,1524651864,'下单消费','201804251824245660',432),(361,2,-195.52,0.00,0,1524651981,'下单消费','201804251826212190',433),(362,2,-195.52,0.00,0,1524652249,'下单消费','201804251830483726',434),(363,2,-19.90,0.00,0,1524704315,'下单消费','201804260858356632',435),(364,2,19.90,0.00,0,1524704769,'用户申请订单退款','201804260858356632',435),(365,2,-83.75,0.00,0,1524704946,'下单消费','201804260909062973',436),(366,2,-83.75,0.00,0,1524704995,'下单消费','201804260909546002',437),(367,2,-100.00,0.00,-10000,1524705674,'下单消费','201804260921142445',439),(368,19,0.00,0.00,100,1524706705,'会员注册赠送积分','',0),(369,3,0.00,0.00,-700,1524706957,'下单消费','201804260942379901',440),(370,3,-162.00,0.00,0,1524709415,'下单消费','201804261023344536',441),(371,3,-188.00,0.00,0,1524709446,'下单消费','201804261024065410',442),(372,3,188.00,0.00,0,1524709512,'用户申请订单退款','201804261024065410',442),(373,2,-49.00,0.00,0,1524713138,'下单消费','201804261125376116',444),(374,20,0.00,0.00,100,1524714610,'会员注册赠送积分','',0),(375,20,0.00,0.00,-100,1524714842,'2121','',0),(376,20,100.00,0.00,0,1524714859,'232323','',0),(377,20,-100.00,0.00,0,1524714931,'8551221','',0),(378,3,-260.71,0.00,0,1524722541,'下单消费','201804261402207777',451),(379,3,0.00,0.00,700,1524722588,'下单赠送积分','201804261402207777',451),(380,3,0.00,0.00,200,1524723726,'邀请人会员注册赠送积分','',0),(381,21,0.00,0.00,100,1524723726,'会员注册赠送积分','',0),(382,21,50000.00,0.00,0,1524724835,'2121212121','',0),(383,21,-126.00,0.00,0,1524724904,'下单消费','201804261441441117',452),(384,2,-207.00,0.00,-100,1524726570,'下单消费','201804261509304559',453),(385,22,0.00,0.00,100,1524726905,'会员注册赠送积分','',0),(386,22,2000.00,0.00,50000,1524727019,'855','',0),(387,2,49.00,0.00,0,1524727150,'订单取消，退回49.00元,0积分','201804261125376116',444),(388,22,0.00,0.00,-700,1524727160,'下单消费','201804261519202279',454),(389,22,0.00,0.00,-350,1524727389,'下单消费','201804261523089667',455),(390,2,0.00,0.00,10000,1524727737,'下单赠送积分','201804260921142445',439),(391,22,-372.60,0.00,0,1524727895,'下单消费','201804261531359209',457),(392,22,-110.00,0.00,0,1524728556,'下单消费','201804261542358862',462),(393,10,59.00,0.00,35,1524728695,'订单取消，退回59.00元,35积分','201804231503544313',330),(394,10,-1106.00,0.00,0,1524729136,'下单消费','201804261552169775',463),(395,2,-80.00,0.00,0,1524730321,'下单消费','201804261612017361',465),(396,2,-80.09,0.00,0,1524730355,'下单消费','201804261612352068',466),(397,22,-737.70,0.00,0,1524730365,'下单消费','201804261612452649',467),(398,22,0.00,0.00,3000,1524730487,'下单赠送积分','201804261612452649',467),(399,23,0.00,0.00,100,1524730504,'会员注册赠送积分','',0),(400,2,-39.90,0.00,0,1524731065,'下单消费','201804261624252460',468),(401,2,0.00,0.00,10,1524731154,'签到赠送10积分','',0),(402,23,1000000.00,0.00,2000000,1524731593,'好人','',0),(403,2,0.00,0.00,-10060,1524731672,'下单消费','201804261634327133',469),(404,2,39.90,0.00,0,1524731844,'用户申请订单退款','201804261624252460',468),(405,2,0.00,0.00,10060,1524731946,'用户申请商品退款','201804261634327133',469),(406,2,-6.00,0.00,-10000,1524732058,'下单消费','201804261640578629',470),(407,22,0.00,0.00,-5000,1524732321,'下单消费','201804261645044726',472),(408,22,-5.00,0.00,0,1524732357,'下单消费','201804261645044726',472),(409,23,-88.70,0.00,0,1524732638,'下单消费','201804261650371588',473),(410,2,0.00,0.00,-11060,1524732656,'下单消费','201804261650566293',474),(411,22,-157.00,0.00,0,1524733605,'下单消费','201804261706445927',475),(412,2,0.00,0.00,-235,1524733689,'下单消费','201804261708098683',476),(413,22,-182.24,0.00,0,1524733717,'下单消费','201804261708375102',477),(414,2,0.00,0.00,1000,1524733865,'下单赠送积分','201804261708098683',476),(415,2,-180.18,0.00,0,1524734243,'下单消费','201804261717231285',478),(416,22,-311.84,0.00,0,1524734727,'下单消费','201804261725279363',479),(417,22,0.00,0.00,1100,1524734940,'下单赠送积分','201804261725279363',479),(418,2,11.00,0.00,0,1524737463,'用户申请商品退款','201804261757322164',480),(419,2,-126.49,0.00,0,1524737821,'下单消费','201804261817017729',483),(420,21,-510.00,0.00,0,1524737824,'下单消费','201804261816456427',482),(421,22,0.00,0.00,-1980,1524738059,'下单消费','201804261820598521',484),(422,2,-24.50,0.00,0,1524738113,'下单消费','201804261821539815',485),(423,21,-108.00,0.00,0,1524738348,'下单消费','201804261822427498',486),(424,2,-24.50,0.00,0,1524738747,'下单消费','201804261832273397',487),(425,2,80.00,0.00,0,1524791304,'订单取消，退回80.00元,0积分','201804261612017361',465),(426,17,-110.00,0.00,0,1524793428,'下单消费','201804270943487885',493),(427,2,0.00,0.00,10,1524793767,'签到赠送10积分','',0),(428,23,-165.00,0.00,0,1524794051,'下单消费','201804270954113027',494),(429,23,-292.53,0.00,0,1524794586,'下单消费','201804271003064332',495),(430,23,-477.98,0.00,0,1524794747,'下单消费','201804271005474592',496),(431,17,-39.90,0.00,0,1524794883,'下单消费','201804271008023215',498),(432,17,-80.00,0.00,0,1524795376,'下单消费','201804271014089370',500),(433,17,-60.00,0.00,0,1524795449,'下单消费','201804271017075618',501),(434,17,0.00,0.00,-200,1524795500,'下单消费','201804271017075618',501),(435,24,0.00,0.00,100,1524795728,'会员注册赠送积分','',0),(436,24,100000.00,0.00,0,1524795849,'21212121','',0),(437,24,-100.00,0.00,0,1524796386,'下单消费','201804271032297694',503),(438,23,-50.00,0.00,0,1524796542,'下单消费','201804271035318046',504),(439,2,-19.90,0.00,0,1524796716,'下单消费','201804271038362928',505),(440,2,-12.56,0.00,0,1524796774,'下单消费','201804271039341359',506),(441,24,-20.00,0.00,0,1524798541,'下单消费','201804271108501664',509),(442,24,-30.00,0.00,0,1524798553,'下单消费','201804271108501664',509),(443,2,-90.00,0.00,0,1524798810,'下单消费','201804271113302797',510),(444,23,-262.00,0.00,0,1524799062,'下单消费','201804271117417803',513),(445,17,10.00,0.00,0,1524799116,'','201804271017075618',501),(446,23,0.00,0.00,-680,1524799327,'下单消费','201804271121325682',515),(447,23,0.00,0.00,680,1524799470,'订单取消，退回0.00元,680积分','201804271121325682',515),(448,23,-18.00,0.00,-600,1524799553,'下单消费','201804271125308876',516),(449,24,-39.00,0.00,0,1524799593,'下单消费','201804271126222941',517),(450,23,-78.00,0.00,0,1524799695,'下单消费','201804271128021914',518),(451,24,-78.00,0.00,0,1524799718,'下单消费','201804271128248948',519),(452,24,-39.00,0.00,0,1524799820,'下单消费','201804271130081598',520),(453,23,-39.00,0.00,0,1524799856,'下单消费','201804271130454133',521),(454,23,-20.00,0.00,-800,1524799939,'下单消费','201804271131502527',522),(455,24,-40.00,0.00,-100,1524800012,'下单消费','201804271133135105',523),(456,22,0.00,0.00,-495,1524800109,'下单消费','201804271134301349',524),(457,23,10.00,0.00,0,1524800204,'12377','201804271131502527',522),(458,23,20.00,0.00,800,1524800617,'用户申请商品退款','201804271131502527',522),(459,24,40.00,0.00,100,1524800843,'用户申请商品退款','201804271133135105',523),(460,2,82.00,0.00,0,1524800975,'用户申请商品退款','201804271113302797',510),(461,2,24.50,0.00,0,1524800990,'用户申请商品退款','201804261832273397',487),(462,22,0.00,0.00,10,1524801181,'第一次签到赠送10积分','',0),(463,23,-50.00,0.00,0,1524801370,'下单消费','201804271155436350',525),(464,25,0.00,0.00,100,1524801616,'会员注册赠送积分','',0),(465,25,0.00,0.00,250,1524807582,'下单赠送积分','201804271338515493',526),(466,17,-218.00,0.00,-10,1524809640,'下单消费','201804271414004226',538),(467,24,-381.50,0.00,0,1524810329,'下单消费','201804271425297386',539),(468,17,-275.70,0.00,0,1524810889,'下单消费','201804271434496990',540),(469,17,0.00,0.00,100,1524811135,'下单赠送积分','201804271434496990',540),(470,23,-315.00,0.00,0,1524812894,'下单消费','201804271508146135',543),(471,23,-1395.00,0.00,0,1524813330,'下单消费','201804271515296896',545),(472,23,24.00,0.00,-1980,1524813898,'下单消费','201804271524578152',546),(473,25,1000.00,0.00,1000,1524813958,'111','',0),(474,25,-100.00,0.00,0,1524814026,'111','',0),(475,22,0.00,0.00,-700,1524814028,'下单消费','201804271527089812',547),(476,2,0.00,0.00,-100,1524814986,'下单消费','201804271543066115',548),(477,2,-9.90,0.00,-100,1524815017,'下单消费','201804271543364257',549),(478,22,-66.00,0.00,0,1524815527,'下单消费','201804271552078975',551),(479,17,-37.00,0.00,0,1524815641,'下单消费','201804271554017746',552),(480,25,0.00,0.00,100,1524817630,'下单赠送积分','201804271625542513',555),(481,24,-249.28,0.00,0,1524818028,'下单消费','201804271633488766',556),(482,24,0.00,0.00,600,1524818122,'下单赠送积分','201804271633488766',556),(483,24,-330.56,0.00,0,1524818413,'下单消费','201804271640122937',557),(484,2,-73.00,0.00,0,1524818616,'下单消费','201804271643358249',558),(485,2,0.00,0.00,100,1524818924,'订单取消，退回0.00元,100积分','201804271543066115',548),(486,2,0.00,0.00,-10,1524819655,'下单消费','201804271700523274',561),(487,2,0.00,0.00,10,1524819851,'下单赠送积分','201804271700523274',561),(488,2,0.00,0.00,-10,1524819989,'下单消费','201804271706289783',562),(489,2,0.00,0.00,10,1524820547,'下单赠送积分','201804271706289783',562),(490,2,0.00,0.00,10,1524820631,'用户申请商品退款','201804271706289783',562),(491,2,12.00,0.00,0,1524820631,'用户申请商品退款','201804271706289783',562),(492,17,-16.00,0.00,-200,1524821804,'下单消费','201804271736449786',571),(493,2,0.00,0.00,100,1524823324,'下单赠送积分','201804271354149430',531),(494,2,-19.90,0.00,-10623,1524824830,'下单消费','201804271827099736',573),(495,31,0.00,0.00,100,1524825281,'会员注册赠送积分','',0),(496,33,0.00,0.00,100,1524825395,'会员注册赠送积分','',0),(497,31,100000.00,0.00,0,1524825790,'3443','',0),(498,31,-409.00,0.00,0,1524825875,'下单消费','201804271844359792',576),(499,33,0.00,0.00,-100,1524828332,'下单消费','201804271925316992',577),(500,31,-246.00,0.00,0,1524877537,'下单消费','201804280905363378',578),(501,31,399.00,0.00,0,1524877852,'用户申请商品退款','201804271844359792',576),(502,31,-118.00,0.00,0,1524878391,'下单消费','201804280919504126',581),(503,31,118.00,0.00,0,1524878500,'用户申请商品退款','201804280919504126',581),(504,31,-246.00,0.00,0,1524879244,'下单消费','201804280934028635',582),(505,25,0.00,0.00,200,1530613665,'下单赠送积分','201804271352255209',528),(506,24,140.00,0.00,0,1530613665,'订单:201804271844359792分佣','',0),(507,24,70.00,0.00,0,1530613665,'订单:201804280919504126分佣','',0),(508,2,560.00,0.00,0,1530781560,'订单:201804280908012544分佣','',0),(509,2,560.00,0.00,0,1530781560,'订单:201804280909288472分佣','',0),(510,8,0.00,0.00,-10,1531558809,'下单消费','201807141700091232',585),(511,8,0.00,0.00,10,1540189957,'订单取消，退回0.00元,10积分','201807141700091232',585);

UNLOCK TABLES;

/*Table structure for table `tp_ad` */

DROP TABLE IF EXISTS `tp_ad`;

CREATE TABLE `tp_ad` (
  `ad_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '广告id',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '广告位置ID',
  `media_type` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '广告类型',
  `ad_name` varchar(60) NOT NULL DEFAULT '' COMMENT '广告名称',
  `ad_link` varchar(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `ad_code` text NOT NULL COMMENT '图片地址',
  `start_time` int(11) NOT NULL DEFAULT '0' COMMENT '投放时间',
  `end_time` int(11) NOT NULL DEFAULT '0' COMMENT '结束时间',
  `link_man` varchar(60) NOT NULL DEFAULT '' COMMENT '添加人',
  `link_email` varchar(60) NOT NULL DEFAULT '' COMMENT '添加人邮箱',
  `link_phone` varchar(60) NOT NULL DEFAULT '' COMMENT '添加人联系电话',
  `click_count` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '点击量',
  `enabled` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示',
  `orderby` smallint(6) DEFAULT '50' COMMENT '排序',
  `target` tinyint(1) DEFAULT '0' COMMENT '是否开启浏览器新窗口',
  `bgcolor` varchar(20) DEFAULT NULL COMMENT '背景颜色',
  PRIMARY KEY (`ad_id`),
  KEY `enabled` (`enabled`),
  KEY `position_id` (`pid`)
)  AUTO_INCREMENT=82 DEFAULT CHARSET=utf8;

/*Data for the table `tp_ad` */

LOCK TABLES `tp_ad` WRITE;

insert  into `tp_ad`(`ad_id`,`pid`,`media_type`,`ad_name`,`ad_link`,`ad_code`,`start_time`,`end_time`,`link_man`,`link_email`,`link_phone`,`click_count`,`enabled`,`orderby`,`target`,`bgcolor`) values (1,2,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-24/a7a54a5b527f0b1b069b8421378ad0fa.jpg',1451577600,1483286400,'','','',0,1,0,0,'#43d7f6'),(2,2,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-25/93bf5c1ebdf4c4359253a107bcbdbe98.jpg',1451577600,1767283200,'','','',0,1,0,0,'#ff8000'),(3,2,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-13/6eeaa63e76c946927d0c1e67f6cf4f4f.jpg',1451577600,1767283200,'','','',0,1,0,0,'#fea8c1'),(4,2,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-13/8099744a886c2cfad7c837e28aee9d52.jpg',1451577600,1767283200,'','','',0,1,0,0,'#f1e6d2'),(5,52,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-09/26c1fa2220802a0d27beee0991d8c4d1.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(6,52,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-09/8163831b208ddd86d7f12f97277b4dc4.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(7,2,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-13/7009c820b93bcf31d3e42df31d78ed71.jpg',1451577600,1767283200,'','','',0,1,0,0,'#f1dcf7'),(8,51,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-09/6ef2f9b7347fe73acbe067ea77327778.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(10,50,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-09/1109cd61a047c0a79b52e70669f2abe4.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(11,50,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-09/9d765b024000406a13f0f229ef9822e4.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(12,2,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-24/44aa330b056f5b090b6d6ac8a9a072dd.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(13,10,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/7e4c3ba078ec31d9bcd676ea617b2565.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(14,20,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/d5efa73bcea8524473e48bdef5bb1b17.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(15,11,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-13/4335611d9ab78af07e93ff2a31d2c895.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(16,21,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/5bd662f577fa35e1ab93d1b55c9e89ba.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(17,12,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/3181c862e182923170dcf1e15bc0a2cc.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(18,22,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/2174905d797ce41bd4191269dae63118.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(19,13,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/0709c98a383426ecef6bec431a1fee1f.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(20,23,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/bf516c7032ac6e700b658dc71cb0daed.png',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(21,14,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/a4129d96e71c30563c724aecd5d9e44b.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(22,24,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/97136712e30ea25217ca534e8a14328e.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(23,15,0,'自定义广告名称http://b2t.tp-shop.cn/Home/Goods/goodsInfo/id/34.html','javascript:void(0);','/public/upload/ad/2018/04-12/2a748189faba2a989ac0c9271318824c.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(24,25,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/27ee83779c467091df062e06edeb98b8.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(25,16,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/5ccf5393abe9e19814d40865cec2c491.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(26,26,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/ca1e401cbd313540eadace224524d766.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(27,401,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/90455f9788541c6e5e46996ab4d4beed.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(28,400,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-27/357175c001c55bfa82b9f71ceee9a260.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(29,301,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/2174905d797ce41bd4191269dae63118.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(30,302,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-09/8163831b208ddd86d7f12f97277b4dc4.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(31,300,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-09/d5eee035222f2d82e2af98dcbaa2da58.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(32,303,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-09/4a0fd2fcbe3d2b914b4e73b0d2afabb3.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(33,304,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/084df97ca37b72c3e772ec860174a443.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(34,304,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/1d819fc32fa4e15c179928e351f38d46.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(35,305,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-26/f3748d7bc38ecfdcd7fd89bdfa4ad3cf.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(36,306,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/ca1e401cbd313540eadace224524d766.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(37,307,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/0d43b5c11d0ddfa86644b286512aa256.png',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(38,307,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/6eaa6d4ef7a560f1ebdde70fc5deb74a.png',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(39,307,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/0affedb6e8aadf0883ba3786e1f4eb2d.png',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(40,307,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/c79cf66ff965f99b4b821870da3b0966.png',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(41,11,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-13/382052a07ca4795bf95f8067b88991b0.png',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(42,11,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-13/964733352359d70a5f43b814e2679ea2.png',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(43,11,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-13/06fd5a2896edeee49120f8717d642ee1.png',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(44,11,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-13/e8f1892d1a21c64318c53635a7225e66.png',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(45,12,1,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-13/0051c20be128541be1f4cfa41316b1ca.png',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(46,50,0,'广告122222','javascript:void(0);','/public/upload/ad/2018/04-26/c1f8608955dfdc853c86c8d4679a550f.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(47,49,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/07-05/4e2631e39c39b248343c27bb1897b1ba.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(48,12,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/3181c862e182923170dcf1e15bc0a2cc.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(49,12,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-13/cd8a548bcc78a0a2fcc855a644c0e92f.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(50,13,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-12/3181c862e182923170dcf1e15bc0a2cc.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(51,2,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-24/b0ffa5a48fc4c0b6922fe1349ff705cf.jpg',1451577600,1767283200,'','','',0,1,0,0,'#ff8040'),(52,500,3,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/23f237c06f0cb7887da69e957baf4e6f.jpg',1451577600,1767283200,'','','',0,1,50,0,NULL),(53,500,3,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/5367310e74759b0614515b76dbe80e6e.png',1451577600,1767283200,'','','',0,1,50,0,NULL),(54,500,3,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/c7a4a714d9952f80be75ef1f91e0e97c.png',1451577600,1767283200,'','','',0,1,50,0,NULL),(55,500,3,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/d4220880e9ec2607b0ab91225d5e7c18.jpg',1451577600,1767283200,'','','',0,1,50,0,NULL),(56,500,3,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/721b9157f72aa577190101c0ee2144b0.png',1451577600,1767283200,'','','',0,1,50,0,NULL),(57,506,4,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-27/1dca111d3603713e5bbe36c534db90f1.jpg',1451577600,1767283200,'','','',0,1,50,0,NULL),(58,507,3,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/68d69f1f6fbfd9411b8f6b344569f083.jpg',1451577600,1767283200,'','','',0,1,50,0,NULL),(59,508,3,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/24b18b1d80754a228ad54177caa5fbb6.jpg',1451577600,1767283200,'','','',0,1,50,0,NULL),(60,509,3,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/bc41de1772760da8f061aa4d4b2ad06c.png',1451577600,1767283200,'','','',0,1,50,0,NULL),(61,510,3,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/199d9c7282b161f288c6f579a4cfce92.jpg',1451577600,1767283200,'','','',0,1,50,0,NULL),(62,511,3,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/66d1d8f80f85b09c47b1c2677bbcaff2.jpg',1451577600,1767283200,'','','',0,1,50,0,NULL),(63,512,3,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/fb0929c143684f35b44ff03d8817b250.png',1451577600,1767283200,'','','',0,1,50,0,NULL),(64,513,3,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/726c131f0c7176825a9f04bb402e7ab8.jpg',1451577600,1767283200,'','','',0,1,50,0,NULL),(65,514,3,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/423797ee68f9be728e4bb2fbfac9edb6.png',1451577600,1767283200,'','','',0,1,50,0,NULL),(66,515,3,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/c2b6cdaae48095ffe4d06dd0053a30fd.jpg',1451577600,1767283200,'','','',0,1,50,0,NULL),(67,516,3,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/7b1e2f7f247ccfa1e02ba255e2701b0c.jpg',1451577600,1767283200,'','','',0,1,50,0,NULL),(68,517,3,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/f4c6568b637bb6772937932a9573b00a.jpg',1451577600,1767283200,'','','',0,1,50,0,NULL),(69,518,3,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/49856d62103ec59b4ffcefae9932cb12.jpg',1451577600,1767283200,'','','',0,1,50,0,NULL),(70,531,3,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/7ad21ba8d9ba049f6aaf5f56701691ca.jpg',1451577600,1767283200,'','','',0,1,50,0,NULL),(71,533,3,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/ed24d04a79666cb26f2e9a87173303ff.jpg',1451577600,1767283200,'','','',0,1,50,0,NULL),(72,534,3,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/7ffbed5c049d13996fe70e7770ca8e6b.jpg',1451577600,1767283200,'','','',0,1,50,0,NULL),(73,535,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-16/c99d513aaf51e2249a989c12c7c77a97.png',1451577600,1767283200,'','','',0,1,50,0,'#000000'),(74,2,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-24/7c93c5138b2dd2ae479b7f6279201313.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(75,9,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-24/50b7b35e90bf5e7e351b2741edaf00cb.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(76,9,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-24/f379b3475a396e1a2c35394c5401e968.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(77,50,0,'自定义广告名称','javascript:void(0);','/public/upload/ad/2018/04-09/f6eff949e20f9b8c63e98208d70064e8.jpg',1451577600,1767283200,'','','',0,1,0,0,'#000000'),(78,17,0,'自定义广告名称','javascript:void();','/public/upload/ad/2018/04-12/f64acc517c1c28795dfb61e6b03c3249.jpg',1451577600,1767196800,'','','',0,1,0,0,'#000000'),(79,27,0,'自定义广告名称','javascript:void();','/public/upload/ad/2018/04-16/66d1d8f80f85b09c47b1c2677bbcaff2.jpg',1451577600,1767196800,'','','',0,1,0,0,'#000000'),(80,18,0,'自定义广告名称','javascript:void();','/public/upload/ad/2018/04-12/0709c98a383426ecef6bec431a1fee1f.jpg',1451577600,1767196800,'','','',0,1,0,0,'#000000'),(81,28,0,'自定义广告名称','javascript:void();','/public/upload/ad/2018/04-13/4335611d9ab78af07e93ff2a31d2c895.jpg',1451577600,1767196800,'','','',0,1,0,0,'#000000');

UNLOCK TABLES;

/*Table structure for table `tp_ad_position` */

DROP TABLE IF EXISTS `tp_ad_position`;

CREATE TABLE `tp_ad_position` (
  `position_id` int(3) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `position_name` varchar(60) NOT NULL DEFAULT '' COMMENT '广告位置名称',
  `ad_width` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '广告位宽度',
  `ad_height` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '广告位高度',
  `position_desc` varchar(255) NOT NULL DEFAULT '' COMMENT '广告描述',
  `position_style` text COMMENT '模板',
  `is_open` tinyint(1) DEFAULT '0' COMMENT '0关闭1开启',
  PRIMARY KEY (`position_id`)
)  AUTO_INCREMENT=537 DEFAULT CHARSET=utf8;

/*Data for the table `tp_ad_position` */

LOCK TABLES `tp_ad_position` WRITE;

insert  into `tp_ad_position`(`position_id`,`position_name`,`ad_width`,`ad_height`,`position_desc`,`position_style`,`is_open`) values (9,'Index页面自动增加广告位 9 ',0,0,'Index页面',NULL,1),(400,'Index页面自动增加广告位 400 ',0,0,'Index页面',NULL,1),(301,'Index页面自动增加广告位 301 ',0,0,'Index页面',NULL,1),(302,'Index页面自动增加广告位 302 ',0,0,'Index页面',NULL,1),(300,'Index页面自动增加广告位 300 ',0,0,'Index页面',NULL,1),(303,'Index页面自动增加广告位 303 ',0,0,'Index页面',NULL,1),(304,'Index页面自动增加广告位 304 ',0,0,'Index页面',NULL,1),(305,'Index页面自动增加广告位 305 ',0,0,'Index页面',NULL,1),(306,'Index页面自动增加广告位 306 ',0,0,'Index页面',NULL,1),(307,'Index页面自动增加广告位 307 ',0,0,'Index页面',NULL,1),(2,'Index页面自动增加广告位 2 ',0,0,'Index页面',NULL,1),(52,'Index页面自动增加广告位 52 ',0,0,'Index页面',NULL,1),(50,'Index页面自动增加广告位 50 ',0,0,'Index页面',NULL,1),(49,'Index页面自动增加广告位 49 ',0,0,'Index页面',NULL,1),(1,'Cart页面自动增加广告位 1 ',0,0,'Cart页面',NULL,1),(11,'Index页面自动增加广告位 11 ',0,0,'Index页面',NULL,1),(51,'Index页面自动增加广告位 51 ',0,0,'Index页面',NULL,1),(10,'Index页面自动增加广告位 10 ',0,0,'Index页面',NULL,1),(20,'Index页面自动增加广告位 20 ',0,0,'Index页面',NULL,1),(12,'Index页面自动增加广告位 12 ',0,0,'Index页面',NULL,1),(21,'Index页面自动增加广告位 21 ',0,0,'Index页面',NULL,1),(13,'Index页面自动增加广告位 13 ',0,0,'Index页面',NULL,1),(14,'Index页面自动增加广告位 14 ',0,0,'Index页面',NULL,1),(500,'Ad页面自动增加广告位 500 ',0,0,'Ad页面',NULL,1),(506,'Ad页面自动增加广告位 506 ',0,0,'Ad页面',NULL,1),(507,'Ad页面自动增加广告位 507 ',0,0,'Ad页面',NULL,1),(508,'Ad页面自动增加广告位 508 ',0,0,'Ad页面',NULL,1),(509,'Ad页面自动增加广告位 509 ',0,0,'Ad页面',NULL,1),(510,'Ad页面自动增加广告位 510 ',0,0,'Ad页面',NULL,1),(511,'Ad页面自动增加广告位 511 ',0,0,'Ad页面',NULL,1),(512,'Ad页面自动增加广告位 512 ',0,0,'Ad页面',NULL,1),(513,'Ad页面自动增加广告位 513 ',0,0,'Ad页面',NULL,1),(514,'Ad页面自动增加广告位 514 ',0,0,'Ad页面',NULL,1),(515,'Ad页面自动增加广告位 515 ',0,0,'Ad页面',NULL,1),(516,'Ad页面自动增加广告位 516 ',0,0,'Ad页面',NULL,1),(517,'Ad页面自动增加广告位 517 ',0,0,'Ad页面',NULL,1),(518,'Ad页面自动增加广告位 518 ',0,0,'Ad页面',NULL,1),(531,'Ad页面自动增加广告位 531 ',0,0,'Ad页面',NULL,1),(15,'Index页面自动增加广告位 15 ',0,0,'Index页面',NULL,1),(16,'Index页面自动增加广告位 16 ',0,0,'Index页面',NULL,1),(17,'Index页面自动增加广告位 17 ',0,0,'Index页面',NULL,1),(18,'Index页面自动增加广告位 18 ',0,0,'Index页面',NULL,1),(22,'Index页面自动增加广告位 22 ',0,0,'Index页面',NULL,1),(23,'Index页面自动增加广告位 23 ',0,0,'Index页面',NULL,1),(24,'Index页面自动增加广告位 24 ',0,0,'Index页面',NULL,1),(19,'Index页面自动增加广告位 19 ',0,0,'Index页面',NULL,1),(534,'Ad页面自动增加广告位 534 ',0,0,'Ad页面',NULL,1),(535,'Ad页面自动增加广告位 535 ',0,0,'Ad页面',NULL,1),(25,'Index页面自动增加广告位 25 ',0,0,'Index页面',NULL,1),(26,'Index页面自动增加广告位 26 ',0,0,'Index页面',NULL,1),(4,'Topic页面自动增加广告位 4 ',0,0,'Topic页面',NULL,1),(401,'Goods页面自动增加广告位 401 ',0,0,'Goods页面',NULL,1),(536,'',0,0,'',NULL,0),(533,'Ad页面自动增加广告位 533 ',0,0,'Ad页面',NULL,1),(204,'Activity页面自动增加广告位 204 ',0,0,'Activity页面',NULL,1),(205,'Activity页面自动增加广告位 205 ',0,0,'Activity页面',NULL,1),(206,'Activity页面自动增加广告位 206 ',0,0,'Activity页面',NULL,1),(207,'Activity页面自动增加广告位 207 ',0,0,'Activity页面',NULL,1),(208,'Activity页面自动增加广告位 208 ',0,0,'Activity页面',NULL,1),(101,'Index页面自动增加广告位 101 ',0,0,'Index页面',NULL,1),(102,'Index页面自动增加广告位 102 ',0,0,'Index页面',NULL,1),(103,'Index页面自动增加广告位 103 ',0,0,'Index页面',NULL,1),(104,'Index页面自动增加广告位 104 ',0,0,'Index页面',NULL,1),(105,'Index页面自动增加广告位 105 ',0,0,'Index页面',NULL,1),(106,'Index页面自动增加广告位 106 ',0,0,'Index页面',NULL,1),(107,'Index页面自动增加广告位 107 ',0,0,'Index页面',NULL,1),(108,'Index页面自动增加广告位 108 ',0,0,'Index页面',NULL,1),(27,'Index页面自动增加广告位 27 ',0,0,'Index页面',NULL,1),(28,'Index页面自动增加广告位 28 ',0,0,'Index页面',NULL,1);

UNLOCK TABLES;

/*Table structure for table `tp_admin` */

DROP TABLE IF EXISTS `tp_admin`;

CREATE TABLE `tp_admin` (
  `admin_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(60) NOT NULL DEFAULT '' COMMENT '用户名',
  `email` varchar(60) NOT NULL DEFAULT '' COMMENT 'email',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `ec_salt` varchar(10) DEFAULT NULL COMMENT '秘钥',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `last_login` int(11) NOT NULL DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) NOT NULL DEFAULT '' COMMENT '最后登录ip',
  `nav_list` text COMMENT '权限',
  `lang_type` varchar(50) NOT NULL DEFAULT '' COMMENT 'lang_type',
  `agency_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'agency_id',
  `suppliers_id` smallint(5) unsigned DEFAULT '0' COMMENT 'suppliers_id',
  `todolist` longtext COMMENT 'todolist',
  `role_id` smallint(5) DEFAULT '0' COMMENT '角色id',
  `province_id` int(8) unsigned DEFAULT '0' COMMENT '加盟商省级id',
  `city_id` int(8) unsigned DEFAULT '0' COMMENT '加盟商市级id',
  `district_id` int(8) unsigned DEFAULT '0' COMMENT '加盟商区级id',
  PRIMARY KEY (`admin_id`),
  KEY `user_name` (`user_name`) USING BTREE,
  KEY `agency_id` (`agency_id`) USING BTREE
)  AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

/*Data for the table `tp_admin` */

LOCK TABLES `tp_admin` WRITE;

insert  into `tp_admin`(`admin_id`,`user_name`,`email`,`password`,`ec_salt`,`add_time`,`last_login`,`last_ip`,`nav_list`,`lang_type`,`agency_id`,`suppliers_id`,`todolist`,`role_id`,`province_id`,`city_id`,`district_id`) values (1,'admin','admin@admin.coom','519475228fe35ad067744465c42a19b2','',1428974654,1540190483,'127.0.0.1','商品列表|goods.php?act=list,订单列表|order.php?act=list,用户评论|comment_manage.php?act=list,会员列表|users.php?act=list,商店设置|shop_config.php?act=list_edit','',0,0,NULL,1,NULL,NULL,0),(2,'test','test@163.com','22ff9e5002ddd31a1c7cf53815b41a19','',1245044099,1523860733,'183.11.70.112','商品列表|goods.php?act=list,订单列表|order.php?act=list,用户评论|comment_manage.php?act=list,会员列表|users.php?act=list,商店设置|shop_config.php?act=list_edit','',0,0,'',1,0,0,0),(3,'tpshop','tpshop@163.com','c6e452ed059014792516e0e021705ff3','',1472610878,1486619732,'127.0.0.1','商品列表|goods.php?act=list,订单列表|order.php?act=list,用户评论|comment_manage.php?act=list,会员列表|users.php?act=list,商店设置|shop_config.php?act=list_edit','',0,0,NULL,1,0,0,0);

UNLOCK TABLES;

/*Table structure for table `tp_admin_log` */

DROP TABLE IF EXISTS `tp_admin_log`;

CREATE TABLE `tp_admin_log` (
  `log_id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) DEFAULT NULL COMMENT '管理员id',
  `log_info` varchar(255) DEFAULT NULL COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT NULL COMMENT 'ip地址',
  `log_url` varchar(50) DEFAULT NULL COMMENT 'url',
  `log_time` int(10) DEFAULT NULL COMMENT '日志时间',
  PRIMARY KEY (`log_id`)
)  AUTO_INCREMENT=495 DEFAULT CHARSET=utf8;

/*Data for the table `tp_admin_log` */

LOCK TABLES `tp_admin_log` WRITE;

insert  into `tp_admin_log`(`log_id`,`admin_id`,`log_info`,`log_ip`,`log_url`,`log_time`) values (1,1,'后台登录','183.11.37.8','/index.php',1523237725),(2,1,'后台登录','183.11.37.8','/index.php',1523238191),(3,1,'后台登录','183.11.37.8','/index.php',1523238384),(4,1,'后台登录','183.11.37.8','/index.php',1523238827),(5,1,'后台登录','183.11.37.8','/index.php',1523239787),(6,1,'后台登录','183.11.37.8','/index.php',1523240434),(7,1,'后台登录','183.11.37.8','/index.php',1523243607),(8,1,'后台登录','183.11.37.8','/index.php',1523252307),(9,1,'后台登录','183.11.37.8','/index.php',1523252625),(10,1,'后台登录','183.11.37.8','/index.php',1523255759),(11,1,'后台登录','183.11.37.8','/index.php',1523258916),(12,1,'后台登录','183.11.37.8','/index.php',1523266327),(13,1,'后台登录','183.11.37.8','/index.php',1523320610),(14,1,'后台登录','183.11.37.8','/index.php',1523321306),(15,1,'后台登录','183.11.37.8','/index.php',1523321995),(16,1,'后台登录','183.11.37.8','/index.php',1523326117),(17,1,'后台登录','183.11.37.8','/index.php',1523338707),(18,1,'后台登录','183.11.37.8','/index.php',1523342172),(19,1,'后台登录','183.11.37.8','/index.php',1523347195),(20,1,'后台登录','183.11.37.8','/index.php',1523350429),(21,1,'后台登录','183.11.37.8','/index.php',1523355753),(22,1,'后台登录','183.11.39.114','/index.php',1523407442),(23,1,'后台登录','183.11.39.114','/index.php',1523425367),(24,1,'后台登录','183.11.39.114','/index.php',1523425465),(25,1,'后台登录','183.11.39.114','/index.php',1523428019),(26,1,'后台登录','183.11.39.114','/index.php',1523441347),(27,1,'后台登录','183.11.39.114','/index.php',1523441379),(28,1,'后台登录','183.11.39.114','/index.php',1523493497),(29,1,'后台登录','183.11.39.114','/index.php',1523493785),(30,1,'后台登录','183.11.39.114','/index.php',1523494141),(31,1,'后台登录','183.11.39.114','/index.php',1523495537),(32,1,'后台登录','183.11.39.114','/index.php',1523498725),(33,1,'后台登录','183.11.39.114','/index.php',1523499647),(34,1,'后台登录','183.11.39.114','/index.php',1523501952),(35,1,'后台登录','183.11.39.114','/index.php',1523502168),(36,1,'后台登录','183.11.39.114','/index.php',1523504420),(37,1,'后台登录','183.11.39.114','/index.php',1523505470),(38,1,'后台登录','183.11.39.114','/index.php',1523518513),(39,1,'后台登录','14.127.251.113','/index.php',1523519655),(40,1,'后台登录','183.11.39.114','/index.php',1523520679),(41,1,'后台登录','183.11.39.114','/index.php',1523523806),(42,1,'后台登录','183.11.39.114','/index.php',1523524597),(43,1,'后台登录','183.11.71.115','/index.php',1523580223),(44,1,'后台登录','183.11.71.115','/index.php',1523585353),(45,1,'后台登录','183.11.71.115','/index.php',1523587170),(46,1,'后台登录','183.11.71.115','/index.php',1523588384),(47,1,'后台登录','183.11.71.115','/index.php',1523588580),(48,1,'后台登录','183.11.71.115','/index.php',1523588679),(49,1,'后台登录','183.11.71.115','/index.php',1523597954),(50,1,'后台登录','183.11.71.115','/index.php',1523598220),(51,1,'后台登录','183.11.71.115','/index.php',1523601595),(52,1,'后台登录','183.11.71.115','/index.php',1523607942),(53,1,'后台登录','183.11.71.115','/index.php',1523608093),(54,1,'后台登录','183.11.71.115','/index.php',1523609397),(55,1,'后台登录','183.11.71.115','/index.php',1523609798),(56,1,'后台登录','183.11.71.115','/index.php',1523609892),(57,1,'后台登录','183.11.71.115','/index.php',1523610455),(58,1,'后台登录','183.11.71.115','/index.php',1523610741),(59,1,'后台登录','183.11.71.115','/index.php',1523613395),(60,1,'后台登录','183.11.71.115','/index.php',1523613458),(61,1,'后台登录','183.11.71.115','/index.php',1523613726),(62,1,'后台登录','183.11.70.112','/index.php',1523840705),(63,1,'后台登录','183.11.70.112','/index.php',1523840733),(64,1,'后台登录','183.11.70.112','/index.php',1523844613),(65,1,'后台登录','183.11.70.112','/index.php',1523844869),(66,1,'后台登录','183.11.70.112','/index.php',1523845260),(67,1,'后台登录','183.11.70.112','/index.php',1523845748),(68,1,'后台登录','183.11.70.112','/index.php',1523846185),(69,1,'后台登录','183.11.70.112','/index.php',1523857056),(70,1,'后台登录','183.11.70.112','/index.php',1523857188),(71,1,'后台登录','183.11.70.112','/index.php',1523857458),(72,1,'管理角色','183.11.70.112','/index.php/Admin/Admin/roleSave',1523860009),(73,2,'后台登录','183.11.70.112','/index.php',1523860053),(74,1,'后台登录','183.11.70.112','/index.php',1523860122),(75,1,'管理角色','183.11.70.112','/index.php/Admin/Admin/roleSave',1523860209),(76,2,'后台登录','183.11.70.112','/index.php',1523860258),(77,1,'管理角色','183.11.70.112','/index.php/Admin/Admin/roleSave',1523860679),(78,2,'后台登录','183.11.70.112','/index.php',1523860733),(79,1,'后台登录','183.11.70.112','/index.php',1523860753),(80,1,'后台登录','183.11.70.112','/index.php',1523860791),(81,1,'后台登录','183.11.70.112','/index.php',1523860922),(82,1,'后台登录','183.11.70.112','/index.php',1523861388),(83,1,'后台登录','183.11.70.112','/index.php',1523866552),(84,1,'后台登录','183.11.37.141','/index.php',1523926224),(85,1,'后台登录','183.11.37.141','/index.php',1523926373),(86,1,'后台登录','183.11.37.141','/index.php',1523927166),(87,1,'后台登录','183.11.37.141','/index.php',1523927810),(88,1,'管理角色','183.11.37.141','/index.php/Admin/Admin/roleSave',1523927974),(89,1,'管理角色','183.11.37.141','/index.php/Admin/Admin/roleSave',1523927992),(90,1,'后台登录','183.11.37.141','/index.php',1523928314),(91,1,'后台登录','183.11.37.141','/index.php',1523931721),(92,1,'后台登录','183.11.37.141','/index.php',1523933847),(93,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1523933978),(94,1,'后台登录','183.11.37.141','/index.php',1523934145),(95,1,'后台登录','183.11.37.141','/index.php',1523935363),(96,1,'后台登录','183.11.37.141','/index.php',1523935619),(97,1,'后台登录','183.11.37.141','/index.php',1523936694),(98,1,'管理员添加了商品促销 232323','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1523936955),(99,1,'管理员添加了商品促销 2121','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1523937045),(100,1,'管理员添加了商品促销 12121','183.11.37.141','/index.php/Admin/Promotion/prom_order_save',1523937127),(101,1,'后台登录','183.11.37.141','/index.php',1523943339),(102,1,'后台登录','183.11.37.141','/index.php',1523943471),(103,1,'后台登录','183.11.37.141','/index.php',1523943662),(104,1,'后台登录','183.11.37.141','/index.php',1523946420),(105,1,'后台登录','183.11.37.141','/index.php',1523946729),(106,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1523948934),(107,1,'后台登录','183.11.37.141','/index.php',1523951416),(108,1,'后台登录','183.11.37.141','/index.php',1523951955),(109,1,'后台登录','183.11.37.141','/index.php',1523952327),(110,1,'后台登录','183.11.37.141','/index.php',1523953380),(111,1,'后台登录','183.11.37.141','/index.php',1523954061),(112,1,'后台登录','183.11.37.141','/index.php',1523954472),(113,1,'管理员添加了商品促销 5555','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1523955623),(114,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1523957094),(115,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1523957359),(116,1,'后台登录','183.11.37.141','/index.php',1523958432),(117,1,'后台登录','183.11.37.141','/index.php',1523959354),(118,1,'发放10张点点滴滴','183.11.37.141','/index.php/admin/Coupon/send_coupon/cid/5',1523959470),(119,1,'管理员添加了商品促销 满300减50（减价）','183.11.37.141','/index.php/Admin/Promotion/prom_order_save',1523959837),(120,1,'管理员添加了商品促销 满400（打折）','183.11.37.141','/index.php/Admin/Promotion/prom_order_save',1523959890),(121,1,'后台登录','183.11.37.141','/index.php',1524012552),(122,1,'后台登录','183.11.37.141','/index.php',1524012991),(123,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1524015235),(124,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1524015786),(125,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1524015990),(126,1,'后台登录','183.11.37.141','/index.php',1524019760),(127,1,'后台登录','183.11.37.141','/index.php',1524019987),(128,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1524020685),(129,1,'管理员添加了商品促销 促销活动开始','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524020734),(130,1,'管理员修改了商品促销 促销活动开始','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524020787),(131,1,'管理员修改了商品促销 促销活动开始','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524020829),(132,1,'管理员添加了商品促销 思恋会过期','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524021275),(133,1,'管理员修改了商品促销 思恋会过期','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524021402),(134,1,'后台登录','183.11.37.141','/index.php',1524021469),(135,1,'管理员添加了商品促销 买送券','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524021605),(136,1,'管理员添加了商品促销 555','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524021917),(137,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1524022113),(138,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1524022120),(139,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1524022152),(140,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1524022175),(141,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1524022216),(142,1,'管理员添加了商品促销 活动等待中','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524022839),(143,1,'管理员修改了商品促销 促销活动开始','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524022856),(144,1,'后台登录','183.11.37.141','/index.php',1524022992),(145,1,'管理员修改了商品促销 活动等待中','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524023070),(146,1,'后台登录','183.11.37.141','/index.php',1524023111),(147,1,'管理员添加了商品促销 买','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524023136),(148,1,'后台登录','183.11.37.141','/index.php',1524030011),(149,1,'管理员修改了商品促销 买','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524030516),(150,1,'管理员修改了商品促销 买','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524030623),(151,1,'管理员修改了商品促销 买','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524030675),(152,1,'管理员修改了商品促销 买','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524030737),(153,1,'发放10张线下优惠券','183.11.37.141','/index.php/Admin/Coupon/make_coupon/id/15/type/3',1524030889),(154,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1524031326),(155,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1524031399),(156,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1524031518),(157,1,'管理员添加了商品促销 满额优惠','183.11.37.141','/index.php/Admin/Promotion/prom_order_save',1524031759),(158,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1524032215),(159,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1524032455),(160,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1524032557),(161,1,'管理员修改了商品促销 满额优惠','183.11.37.141','/index.php/Admin/Promotion/prom_order_save',1524032819),(162,1,'管理员修改了商品促销 满额500优惠','183.11.37.141','/index.php/Admin/Promotion/prom_order_save',1524032837),(163,1,'发放10张ABC','183.11.37.141','/index.php/Admin/Coupon/make_coupon/id/16/type/3',1524033204),(164,1,'发放10张ABC','183.11.37.141','/index.php/Admin/Coupon/make_coupon/id/16/type/3',1524033402),(165,1,'发放1张ABC','183.11.37.141','/index.php/Admin/Coupon/make_coupon/id/16/type/3',1524033575),(166,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1524033585),(167,1,'管理员添加了商品促销 223','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524033656),(168,1,'管理员添加了商品促销 2','183.11.37.141','/index.php/Admin/Promotion/prom_order_save',1524033688),(169,1,'管理员添加了商品促销 直接优惠100','183.11.37.141','/index.php/Admin/Promotion/prom_order_save',1524033799),(170,1,'管理员添加了商品促销 满额送积分','183.11.37.141','/index.php/Admin/Promotion/prom_order_save',1524033886),(171,1,'管理员修改了商品促销 满额送积分','183.11.37.141','/index.php/Admin/Promotion/prom_order_save',1524034009),(172,1,'管理员修改了商品促销 满300减50（减价）','183.11.37.141','/index.php/Admin/Promotion/prom_order_save',1524035328),(173,1,'管理员修改了商品促销 直接优惠100','183.11.37.141','/index.php/Admin/Promotion/prom_order_save',1524035372),(174,1,'管理员修改了商品促销 2','183.11.37.141','/index.php/Admin/Promotion/prom_order_save',1524036111),(175,1,'管理员添加了商品促销 2828','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524037329),(176,1,'管理员添加了商品促销 2822','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524037501),(177,1,'管理员修改了商品促销 2822','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524037591),(178,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1524037917),(179,1,'管理员添加了商品促销 2825','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524038067),(180,1,'管理员修改了商品促销 2825','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524038195),(181,1,'管理员添加了商品促销 8585KUAI','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524038388),(182,1,'管理员修改了商品促销 8585KUAI','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524038506),(183,1,'管理员修改了商品促销 2825','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524038627),(184,1,'管理员修改了商品促销 8585KUAI','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524038658),(185,1,'管理员修改了商品促销 8585KUAI','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524038677),(186,1,'管理员添加了商品促销 满1000额度送500分','183.11.37.141','/index.php/Admin/Promotion/prom_order_save',1524039425),(187,1,'管理员修改了商品促销 满1000额度送500分','183.11.37.141','/index.php/Admin/Promotion/prom_order_save',1524039454),(188,1,'管理员修改了商品促销 满1000额度送500分','183.11.37.141','/index.php/Admin/Promotion/prom_order_save',1524041068),(189,1,'管理员修改了商品促销 满500额度送300分','183.11.37.141','/index.php/Admin/Promotion/prom_order_save',1524041128),(190,1,'后台登录','183.11.37.141','/index.php',1524042026),(191,1,'管理员修改了商品促销 223','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524043062),(192,1,'管理员修改了商品促销 223','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524043085),(193,1,'管理员添加商品预售活动 丽乔 2018新品女装小西装春季一粒扣外套女复古格纹修身西服长袖外衣潮 FFSSMD2003','183.11.37.141','/index.php/admin/Promotion/pre_sell_info',1524043484),(194,1,'管理员添加商品预售活动 桑扶兰 薄款高侧比大罩杯聚拢性感文胸双胶骨收副乳胸罩内衣WAJ1517S肤色B80','183.11.37.141','/index.php/admin/Promotion/pre_sell_info',1524045302),(195,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1524046961),(196,1,'管理员添加抢购活动 ','183.11.37.141','/index.php/Admin/Promotion/flash_sale_info',1524047009),(197,1,'管理员添加了商品促销 阳光在风雨后','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524047106),(198,1,'管理员修改了商品促销 阳光在风雨后','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524047180),(199,1,'管理员添加了商品促销 ZIEN','183.11.37.141','/index.php/Admin/Promotion/prom_goods_save',1524047666),(200,1,'后台登录','220.112.16.205','/index.php',1524056336),(201,1,'后台登录','183.11.39.194','/index.php',1524098695),(202,1,'后台登录','183.11.39.194','/index.php',1524098872),(203,1,'管理员修改了商品促销 8585KUAI','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524099153),(204,1,'管理员修改了商品促销 8585KUAI','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524099210),(205,1,'管理员修改了商品促销 8585KUAI','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524099245),(206,1,'管理员添加商品预售活动 美的(Midea)220升 家用商用冰柜 双箱双温冷柜 蝶形门侧掀门 化冻包赔','183.11.39.194','/index.php/admin/Promotion/pre_sell_info',1524099255),(207,1,'管理员修改了商品促销 8585KUAI','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524099278),(208,1,'后台登录','183.11.39.194','/index.php',1524099819),(209,1,'管理员添加商品预售活动 闪迪（SanDisk）酷铄(CZ73) USB3.0 金属U盘 128GB 读150MB/秒','183.11.39.194','/index.php/admin/Promotion/pre_sell_info',1524100034),(210,1,'管理员添加商品预售活动 多版本多规格苹果电脑','183.11.39.194','/index.php/admin/Promotion/pre_sell_info',1524100249),(211,1,'后台登录','183.11.39.194','/index.php',1524102122),(212,1,'管理员添加商品预售活动 全国送花深圳生日鲜花速递同城北京上海红玫瑰花束广州杭州成都店 中礼鲜花 20年老品牌 值得信赖','183.11.39.194','/index.php/admin/Promotion/pre_sell_info',1524102492),(213,1,'管理员添加商品预售活动 佳能（Canon） EF 24-70mm f/2.8L II USM 标准变焦镜头','183.11.39.194','/index.php/admin/Promotion/pre_sell_info',1524103756),(214,1,'后台登录','183.11.39.194','/index.php',1524104149),(215,1,'后台登录','183.11.39.194','/index.php',1524104516),(216,1,'管理员添加商品预售活动 保罗骑士男鞋2018春季新款英伦风真皮男小白鞋休闲鞋潮流系带板鞋 2018春季上新 简约英伦风','183.11.39.194','/index.php/admin/Promotion/pre_sell_info',1524104775),(217,1,'后台登录','183.11.39.194','/index.php',1524105415),(218,1,'管理员添加商品预售活动 迪豪灯饰 欧式水晶吊灯奢华客厅灯现代简欧卧室灯锌合金大气别墅复式楼美式餐厅led灯具套餐 金枝玉叶B款15头（包安装带三色光源+底锅发光款）','183.11.39.194','/index.php/admin/Promotion/pre_sell_info',1524106001),(219,1,'后台登录','183.11.39.194','/index.php',1524106243),(220,1,'管理员添加商品预售活动 简林 电视柜玄关装创意饰品摆件客厅家居复古美式软装人物雕塑艺术品酒吧咖啡厅摆设','183.11.39.194','/index.php/admin/Promotion/pre_sell_info',1524106390),(221,1,'后台登录','183.11.39.194','/index.php',1524106411),(222,1,'管理员添加商品预售活动 宁美国度 AOC I2479VXHD 23.8英寸高清屏幕护眼液晶电脑显示器 送发光键鼠套装','183.11.39.194','/index.php/admin/Promotion/pre_sell_info',1524107146),(223,1,'管理员添加商品预售活动 艾路丝婷短袖T恤女上衣印花圆领女士体恤衫TX3532','183.11.39.194','/index.php/admin/Promotion/pre_sell_info',1524107415),(224,1,'管理员添加商品预售活动 稀奇艺术限量雕塑瞿广慈《桃园三结义》现代桌面摆件办公室装饰品 大师作品 限量百件 以古鉴今 荒诞幽默','183.11.39.194','/index.php/admin/Promotion/pre_sell_info',1524107642),(225,1,'管理员添加商品预售活动 恒瓷美 北欧创意家居软装艺术品摆设树脂简约现代装饰品房间玄关客厅电视柜酒柜小摆件结婚礼物','183.11.39.194','/index.php/admin/Promotion/pre_sell_info',1524108383),(226,1,'管理员添加商品预售活动 男士速干抗皱抽象字母印花短袖T恤','183.11.39.194','/index.php/admin/Promotion/pre_sell_info',1524109081),(227,1,'发放9张拼团','183.11.39.194','/index.php/Admin/Coupon/make_coupon/id/20/type/3',1524110292),(228,1,'管理员添加商品预售活动 国家地理（National Geographic） NG W5072 摄影包 单反相机包 双肩包 逍遥者系列 旅行多功能 时尚通勤','183.11.39.194','/index.php/admin/Promotion/pre_sell_info',1524110351),(229,1,'管理员添加商品预售活动 荣耀 畅玩6 2GB+16GB 金色 全网通4G手机 双卡双待','183.11.39.194','/index.php/admin/Promotion/pre_sell_info',1524110518),(230,1,'后台登录','183.11.39.194','/index.php',1524116107),(231,1,'后台登录','183.11.39.194','/index.php',1524116165),(232,1,'发放3张yuyuyu','183.11.39.194','/index.php/admin/Coupon/send_coupon/cid/21',1524117317),(233,1,'后台登录','183.11.39.194','/index.php',1524117773),(234,1,'后台登录','183.11.39.194','/index.php',1524119761),(235,1,'后台登录','183.11.39.194','/index.php',1524126803),(236,1,'后台登录','183.11.39.194','/index.php',1524127144),(237,1,'后台登录','183.11.39.194','/index.php',1524128119),(238,1,'后台登录','183.11.39.194','/index.php',1524128176),(239,1,'后台登录','183.11.39.194','/index.php',1524128246),(240,1,'管理员添加抢购活动 ','183.11.39.194','/index.php/Admin/Promotion/flash_sale_info',1524131702),(241,1,'管理员添加抢购活动 ','183.11.39.194','/index.php/Admin/Promotion/flash_sale_info',1524132069),(242,1,'后台登录','183.11.39.194','/index.php',1524184666),(243,1,'后台登录','183.11.39.194','/index.php',1524184930),(244,1,'后台登录','183.11.39.194','/index.php',1524185346),(245,1,'后台登录','183.11.39.194','/index.php',1524185489),(246,1,'管理角色','183.11.39.194','/index.php/Admin/Admin/roleSave',1524188157),(247,1,'管理角色','183.11.39.194','/index.php/Admin/Admin/roleSave',1524188186),(248,1,'管理角色','183.11.39.194','/index.php/Admin/Admin/roleSave',1524188216),(249,1,'后台登录','183.11.39.194','/index.php',1524189870),(250,1,'后台登录','183.11.39.194','/index.php',1524190189),(251,1,'后台登录','183.11.39.194','/index.php',1524191450),(252,1,'后台登录','183.11.39.194','/index.php',1524191772),(253,1,'管理员添加抢购活动 ','183.11.39.194','/index.php/Admin/Promotion/flash_sale_info',1524192372),(254,1,'管理员添加抢购活动 ','183.11.39.194','/index.php/Admin/Promotion/flash_sale_info',1524192778),(255,1,'后台登录','183.11.39.194','/index.php',1524193710),(256,1,'后台登录','183.11.39.194','/index.php',1524194010),(257,1,'管理员添加了商品促销 11','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194071),(258,1,'管理员添加了商品促销 545454','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194104),(259,1,'管理员添加了商品促销 55','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194125),(260,1,'管理员添加了商品促销 4545454','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194159),(261,1,'管理员添加了商品促销 855','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194319),(262,1,'管理员添加了商品促销 855','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194320),(263,1,'管理员添加了商品促销 855','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194320),(264,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194521),(265,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194521),(266,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194522),(267,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194522),(268,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194522),(269,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194522),(270,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194523),(271,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194523),(272,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194523),(273,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194525),(274,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194525),(275,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194525),(276,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194525),(277,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194525),(278,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194526),(279,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194526),(280,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194526),(281,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194526),(282,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194526),(283,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194526),(284,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194527),(285,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194527),(286,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194527),(287,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194527),(288,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194527),(289,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194528),(290,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194528),(291,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194528),(292,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194528),(293,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194528),(294,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194529),(295,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194529),(296,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194529),(297,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194529),(298,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194529),(299,1,'管理员添加了商品促销 满300打折','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524194530),(300,1,'管理员添加了商品促销 2323','183.11.39.194','/index.php/Admin/Promotion/prom_order_save',1524194553),(301,1,'管理员添加了商品促销 2323','183.11.39.194','/index.php/Admin/Promotion/prom_order_save',1524194553),(302,1,'管理员添加了商品促销 2323','183.11.39.194','/index.php/Admin/Promotion/prom_order_save',1524194553),(303,1,'管理员添加了商品促销 2323','183.11.39.194','/index.php/Admin/Promotion/prom_order_save',1524194553),(304,1,'管理员添加了商品促销 2323','183.11.39.194','/index.php/Admin/Promotion/prom_order_save',1524194553),(305,1,'管理员添加抢购活动 ','183.11.39.194','/index.php/Admin/Promotion/flash_sale_info',1524194749),(306,1,'后台登录','183.11.39.194','/index.php',1524195360),(307,1,'管理员添加抢购活动 ','183.11.39.194','/index.php/Admin/Promotion/flash_sale_info',1524195517),(308,1,'管理员添加了商品促销 满400（打折）','183.11.39.194','/index.php/Admin/Promotion/prom_order_save',1524195714),(309,1,'管理员添加了商品促销 蛮00','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524196005),(310,1,'管理员添加了商品促销 蛮00','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524196042),(311,1,'管理员添加商品预售活动 多规格鞋子','183.11.39.194','/index.php/admin/Promotion/pre_sell_info',1524196921),(312,1,'后台登录','183.11.39.194','/index.php',1524202533),(313,1,'后台登录','183.11.39.194','/index.php',1524202624),(314,1,'后台登录','183.11.39.194','/index.php',1524203229),(315,1,'管理员添加了商品促销 yuyuyu','183.11.39.194','/index.php/Admin/Promotion/prom_goods_save',1524204526),(316,1,'管理员添加商品预售活动 南极人保暖内衣男女士蓄热加厚加绒黄金暖绒套装','183.11.39.194','/index.php/admin/Promotion/pre_sell_info',1524205458),(317,1,'管理员添加抢购活动 ','183.11.39.194','/index.php/Admin/Promotion/flash_sale_info',1524205564),(318,1,'后台登录','183.11.39.194','/index.php',1524208529),(319,1,'后台登录','183.11.39.194','/index.php',1524209557),(320,1,'后台登录','183.11.39.194','/index.php',1524209781),(321,1,'管理员添加商品预售活动 苏泊尔（SUPOR）电饭煲电饭锅4L容量 精铁球釜IH电磁加热CFXB40HC817-120','183.11.39.194','/index.php/admin/Promotion/pre_sell_info',1524211091),(322,1,'后台登录','183.11.39.194','/index.php',1524211219),(323,1,'管理员添加商品预售活动 预售限制地区','183.11.39.194','/index.php/admin/Promotion/pre_sell_info',1524211642),(324,1,'后台登录','183.11.39.194','/index.php',1524213357),(325,1,'后台登录','183.11.39.194','/index.php',1524214739),(326,1,'后台登录','183.11.39.194','/index.php',1524217868),(327,1,'后台登录','183.11.39.194','/index.php',1524218375),(328,1,'后台登录','183.11.39.194','/index.php',1524219570),(329,1,'后台登录','183.11.39.194','/index.php',1524219987),(330,1,'后台登录','171.106.21.197','/index.php',1524420320),(331,1,'后台登录','183.11.37.28','/index.php',1524444717),(332,1,'后台登录','183.11.37.28','/index.php',1524445013),(333,1,'后台登录','183.11.37.28','/index.php',1524445727),(334,1,'管理员添加商品预售活动 贵州茅乡酒 M10浓香型白酒 52度送礼白酒 纯粮500ml一瓶 贵州 52度白酒 浓香型 純粮酿造','183.11.37.28','/index.php/admin/Promotion/pre_sell_info',1524445912),(335,1,'后台登录','183.11.37.28','/index.php',1524449065),(336,1,'后台登录','183.11.37.28','/index.php',1524449109),(337,1,'后台登录','183.11.37.28','/index.php',1524449631),(338,1,'后台登录','183.11.37.28','/index.php',1524450144),(339,1,'管理员添加了商品促销 满500额送100积分','183.11.37.28','/index.php/Admin/Promotion/prom_order_save',1524450879),(340,1,'后台登录','183.11.37.28','/index.php',1524451115),(341,1,'管理员添加了商品促销 促销活动','183.11.37.28','/index.php/Admin/Promotion/prom_goods_save',1524451148),(342,1,'后台登录','183.11.37.28','/index.php',1524451237),(343,1,'管理员修改了商品促销 促销活动','183.11.37.28','/index.php/Admin/Promotion/prom_goods_save',1524451604),(344,1,'管理员修改了商品促销 促销活动','183.11.37.28','/index.php/Admin/Promotion/prom_goods_save',1524451632),(345,1,'管理员添加了商品促销 多规格快递配送','183.11.37.28','/index.php/Admin/Promotion/prom_goods_save',1524451749),(346,1,'后台登录','183.11.37.28','/index.php',1524453490),(347,1,'后台登录','183.11.37.28','/index.php',1524453960),(348,1,'管理员添加商品预售活动 鲜花礼盒花束速递红玫瑰北京同城鲜花上海送花南京广州鲜花店杭州 手机购更优惠 6年老店 指定日期送','183.11.37.28','/index.php/admin/Promotion/pre_sell_info',1524454607),(349,1,'后台登录','183.11.37.28','/index.php',1524456616),(350,1,'后台登录','183.11.37.28','/index.php',1524461642),(351,1,'后台登录','183.11.37.28','/index.php',1524461756),(352,1,'后台登录','183.11.37.28','/index.php',1524461827),(353,1,'后台登录','183.11.37.28','/index.php',1524464311),(354,1,'管理员添加抢购活动 ','183.11.37.28','/index.php/Admin/Promotion/flash_sale_info',1524465435),(355,1,'管理员添加抢购活动 ','183.11.37.28','/index.php/Admin/Promotion/flash_sale_info',1524465633),(356,1,'管理员添加抢购活动 ','183.11.37.28','/index.php/Admin/Promotion/flash_sale_info',1524465779),(357,1,'后台登录','183.11.37.28','/index.php',1524466192),(358,1,'管理员添加商品预售活动 【北京联通】100M宽带 郊区高速（1年版）','183.11.37.28','/index.php/admin/Promotion/pre_sell_info',1524467829),(359,1,'管理员添加抢购活动 ','183.11.37.28','/index.php/Admin/Promotion/flash_sale_info',1524470900),(360,1,'管理员添加抢购活动 ','183.11.37.28','/index.php/Admin/Promotion/flash_sale_info',1524471103),(361,1,'后台登录','183.11.37.28','/index.php',1524471434),(362,1,'管理员添加抢购活动 ','183.11.37.28','/index.php/Admin/Promotion/flash_sale_info',1524471488),(363,1,'后台登录','183.11.37.28','/index.php',1524471889),(364,1,'后台登录','183.11.37.28','/index.php',1524472322),(365,1,'后台登录','183.11.37.28','/index.php',1524474458),(366,1,'后台登录','183.11.37.28','/index.php',1524478895),(367,1,'后台登录','183.11.37.28','/index.php',1524532952),(368,1,'后台登录','183.11.37.28','/index.php',1524532974),(369,1,'后台登录','183.11.37.28','/index.php',1524538084),(370,1,'管理员添加商品预售活动 双牌 动感单车家用超静音健身车室内运动自行车健身器材 SC-5000','183.11.37.28','/index.php/admin/Promotion/pre_sell_info',1524539506),(371,1,'后台登录','183.11.37.28','/index.php',1524540002),(372,1,'管理角色','183.11.37.28','/index.php/Admin/Admin/roleSave',1524540250),(373,1,'管理员添加抢购活动 ','183.11.37.28','/index.php/Admin/Promotion/flash_sale_info',1524540392),(374,1,'管理员添加抢购活动 ','183.11.37.28','/index.php/Admin/Promotion/flash_sale_info',1524540821),(375,1,'管理员添加抢购活动 ','183.11.37.28','/index.php/Admin/Promotion/flash_sale_info',1524541248),(376,1,'管理员添加抢购活动 ','183.11.37.28','/index.php/Admin/Promotion/flash_sale_info',1524541341),(377,1,'管理员添加商品预售活动 海尔（Haier)6公斤干衣机 大烘干量 GDZE6-1W','183.11.37.28','/index.php/admin/Promotion/pre_sell_info',1524542064),(378,1,'管理员添加抢购活动 ','183.11.37.28','/index.php/Admin/Promotion/flash_sale_info',1524542223),(379,1,'后台登录','183.11.37.28','/index.php',1524542768),(380,1,'后台登录','183.11.37.28','/index.php',1524548056),(381,1,'后台登录','183.11.37.28','/index.php',1524548100),(382,1,'后台登录','183.11.37.28','/index.php',1524550790),(383,1,'后台登录','183.11.37.28','/index.php',1524551937),(384,1,'管理角色','183.11.37.28','/index.php/Admin/Admin/roleSave',1524552072),(385,18,'后台登录','183.11.37.28','/index.php',1524552494),(386,1,'后台登录','183.11.37.28','/index.php',1524555558),(387,1,'后台登录','183.11.37.28','/index.php',1524558662),(388,18,'后台登录','183.11.37.28','/index.php',1524560268),(389,1,'后台登录','183.11.37.28','/index.php',1524562383),(390,1,'后台登录','183.11.37.28','/index.php',1524563275),(391,1,'后台登录','183.11.37.28','/index.php',1524564844),(392,1,'后台登录','183.11.70.126','/index.php',1524616995),(393,1,'后台登录','183.11.70.126','/index.php',1524617228),(394,1,'管理员添加了商品促销 888','183.11.70.126','/index.php/Admin/Promotion/prom_goods_save',1524618740),(395,1,'后台登录','183.11.70.126','/index.php',1524622571),(396,1,'后台登录','183.11.70.126','/index.php',1524623240),(397,1,'后台登录','183.11.70.126','/index.php',1524628844),(398,1,'后台登录','183.11.70.126','/index.php',1524631380),(399,1,'后台登录','183.11.70.126','/index.php',1524639806),(400,1,'后台登录','183.11.70.126','/index.php',1524639969),(401,1,'管理员添加了商品促销 恒源祥促销商品','183.11.70.126','/index.php/Admin/Promotion/prom_goods_save',1524640149),(402,1,'后台登录','183.11.70.126','/index.php',1524640592),(403,1,'后台登录','183.11.70.126','/index.php',1524640618),(404,1,'后台登录','183.11.70.126','/index.php',1524645501),(405,1,'管理员添加商品预售活动 欧迪鸟品牌比基尼三件套2018春季新品小胸钢托聚拢遮肚修身温泉泳装女','183.11.70.126','/index.php/admin/Promotion/pre_sell_info',1524645812),(406,1,'后台登录','183.11.70.126','/index.php',1524646906),(407,1,'后台登录','183.11.70.126','/index.php',1524647128),(408,1,'后台登录','183.11.70.126','/index.php',1524647205),(409,1,'后台登录','183.11.70.126','/index.php',1524647991),(410,1,'后台登录','183.11.70.126','/index.php',1524648939),(411,1,'后台登录','183.11.70.126','/index.php',1524648951),(412,1,'管理员添加了商品促销 00000','183.11.70.126','/index.php/Admin/Promotion/prom_goods_save',1524649629),(413,1,'后台登录','183.11.70.126','/index.php',1524649833),(414,1,'后台登录','183.11.70.126','/index.php',1524703091),(415,1,'后台登录','183.11.70.126','/index.php',1524703152),(416,1,'后台登录','183.11.70.126','/index.php',1524703191),(417,1,'后台登录','183.11.70.126','/index.php',1524705850),(418,1,'发放6张指定商品海信','183.11.70.126','/index.php/admin/Coupon/send_coupon/cid/26',1524706427),(419,1,'发放1张指定商品海信','183.11.70.126','/index.php/admin/Coupon/send_coupon/cid/26',1524706508),(420,1,'管理员添加了商品促销 yiy','183.11.70.126','/index.php/Admin/Promotion/prom_goods_save',1524709166),(421,1,'后台登录','183.11.70.126','/index.php',1524711407),(422,1,'后台登录','183.11.70.126','/index.php',1524712518),(423,1,'管理员添加商品预售活动 多规格电脑','183.11.70.126','/index.php/admin/Promotion/pre_sell_info',1524714203),(424,1,'后台登录','183.11.70.126','/index.php',1524714315),(425,1,'后台登录','183.11.70.126','/index.php',1524715299),(426,1,'管理员添加商品预售活动 俪莎公馆 电视柜 欧式电视柜茶几组合套装客厅简约大理石电视柜地柜家具 (红龙玉大理石) 套餐二电视柜2.2m+茶几1.35m','183.11.70.126','/index.php/admin/Promotion/pre_sell_info',1524715362),(427,1,'后台登录','183.11.70.126','/index.php',1524720849),(428,1,'后台登录','183.11.70.126','/index.php',1524721184),(429,1,'后台登录','183.11.70.126','/index.php',1524721661),(430,1,'后台登录','183.11.70.126','/index.php',1524723495),(431,1,'后台登录','183.11.70.126','/index.php',1524723560),(432,1,'管理员添加抢购活动 ','183.11.70.126','/index.php/Admin/Promotion/flash_sale_info',1524724638),(433,1,'后台登录','183.11.70.126','/index.php',1524725064),(434,1,'管理员添加抢购活动 ','183.11.70.126','/index.php/Admin/Promotion/flash_sale_info',1524725362),(435,1,'管理员添加抢购活动 ','183.11.70.126','/index.php/Admin/Promotion/flash_sale_info',1524725513),(436,1,'后台登录','183.11.70.126','/index.php',1524726245),(437,1,'管理员添加了商品促销 250','183.11.70.126','/index.php/Admin/Promotion/prom_goods_save',1524726475),(438,1,'管理员添加商品预售活动 BXMAN宽松男士内裤平角裤纯棉梭织阿罗裤舒适睡裤春夏家居短裤 921组4条装','183.11.70.126','/index.php/admin/Promotion/pre_sell_info',1524727102),(439,1,'后台登录','183.11.70.126','/index.php',1524728759),(440,1,'后台登录','183.11.70.126','/index.php',1524730214),(441,1,'后台登录','183.11.70.126','/index.php',1524730408),(442,1,'后台登录','183.11.70.126','/index.php',1524731550),(443,1,'管理员添加抢购活动 ','183.11.70.126','/index.php/Admin/Promotion/flash_sale_info',1524732457),(444,1,'管理员添加抢购活动 ','183.11.70.126','/index.php/Admin/Promotion/flash_sale_info',1524732558),(445,1,'管理员添加抢购活动 ','183.11.70.126','/index.php/Admin/Promotion/flash_sale_info',1524733163),(446,1,'管理员添加商品预售活动 仙人球多肉植物组合','183.11.70.126','/index.php/admin/Promotion/pre_sell_info',1524736292),(447,1,'管理员添加商品预售活动 比多乐来一口PK脆休闲点心面 泰国酱鸡味336g 膨化','183.11.70.126','/index.php/admin/Promotion/pre_sell_info',1524736869),(448,1,'后台登录','183.11.38.21','/index.php',1524789896),(449,1,'管理员添加了商品促销 ADB','183.11.38.21','/index.php/Admin/Promotion/prom_goods_save',1524790693),(450,1,'管理员添加抢购活动 ','183.11.38.21','/index.php/Admin/Promotion/flash_sale_info',1524790821),(451,1,'后台登录','183.11.38.21','/index.php',1524790852),(452,1,'管理员添加抢购活动 ','183.11.38.21','/index.php/Admin/Promotion/flash_sale_info',1524790964),(453,1,'管理员添加抢购活动 ','183.11.38.21','/index.php/Admin/Promotion/flash_sale_info',1524790999),(454,1,'后台登录','183.11.38.21','/index.php',1524791466),(455,1,'管理员添加商品预售活动 浪莎（LangSha）女士内裤女高腰棉质性感大码透气收腹提臀三角裤4条 混色','183.11.38.21','/index.php/admin/Promotion/pre_sell_info',1524792181),(456,1,'后台登录','183.11.38.21','/index.php',1524793257),(457,1,'后台登录','183.11.38.21','/index.php',1524793396),(458,1,'后台登录','183.11.38.21','/index.php',1524794076),(459,1,'后台登录','183.11.38.21','/index.php',1524795664),(460,1,'管理员添加了商品促销 优惠减价','183.11.38.21','/index.php/Admin/Promotion/prom_order_save',1524795953),(461,1,'管理员添加抢购活动 ','183.11.38.21','/index.php/Admin/Promotion/flash_sale_info',1524798739),(462,1,'后台登录','183.11.38.21','/index.php',1524801174),(463,1,'后台登录','183.11.38.21','/index.php',1524807357),(464,1,'发放10张指定商品下单','183.11.38.21','/index.php/admin/Coupon/send_coupon/cid/29',1524809217),(465,1,'发放5张指定商品下发','183.11.38.21','/index.php/admin/Coupon/send_coupon/cid/30',1524809381),(466,1,'发放1张指定商品下单1','183.11.38.21','/index.php/admin/Coupon/send_coupon/cid/31',1524809814),(467,1,'发放1张指定商品下单1','183.11.38.21','/index.php/admin/Coupon/send_coupon/cid/31',1524809858),(468,1,'发放1张指定商品下单1','183.11.38.21','/index.php/admin/Coupon/send_coupon/cid/31',1524809947),(469,1,'后台登录','183.11.38.21','/index.php',1524810245),(470,1,'后台登录','183.11.38.21','/index.php',1524810904),(471,1,'管理员添加抢购活动 ','183.11.38.21','/index.php/Admin/Promotion/flash_sale_info',1524815218),(472,1,'管理员添加了商品促销 不醉不会','183.11.38.21','/index.php/Admin/Promotion/prom_goods_save',1524815309),(473,1,'管理员修改了商品促销 不醉不会','183.11.38.21','/index.php/Admin/Promotion/prom_goods_save',1524815339),(474,1,'管理员添加抢购活动 ','183.11.38.21','/index.php/Admin/Promotion/flash_sale_info',1524815468),(475,1,'后台登录','183.11.38.21','/index.php',1524815725),(476,1,'后台登录','183.11.38.21','/index.php',1524818054),(477,1,'后台登录','183.11.38.21','/index.php',1524818470),(478,1,'管理员添加抢购活动 ','183.11.38.21','/index.php/Admin/Promotion/flash_sale_info',1524818581),(479,1,'管理员添加抢购活动 ','183.11.38.21','/index.php/Admin/Promotion/flash_sale_info',1524819505),(480,1,'后台登录','183.11.38.21','/index.php',1524825364),(481,1,'后台登录','183.11.38.21','/index.php',1524826319),(482,1,'后台登录','183.11.38.21','/index.php',1524826354),(483,1,'后台登录','117.136.40.230','/index.php',1524837466),(484,1,'后台登录','183.11.38.21','/index.php',1524876796),(485,1,'后台登录','183.11.38.21','/index.php',1524877109),(486,1,'后台登录','183.11.38.21','/index.php',1524877224),(487,1,'后台登录','127.0.0.1','/index.php',1530613664),(488,1,'后台登录','127.0.0.1','/index.php',1530781559),(489,1,'后台登录','127.0.0.1','/index.php',1530784374),(490,1,'后台登录','127.0.0.1','/index.php',1530841692),(491,1,'后台登录','127.0.0.1','/index.php',1531558168),(492,1,'后台登录','127.0.0.1','/index.php',1540190026),(493,1,'后台登录','127.0.0.1','/index.php',1540190349),(494,1,'后台登录','127.0.0.1','/index.php',1540190483);

UNLOCK TABLES;

/*Table structure for table `tp_admin_role` */

DROP TABLE IF EXISTS `tp_admin_role`;

CREATE TABLE `tp_admin_role` (
  `role_id` smallint(6) unsigned NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) DEFAULT NULL COMMENT '角色名称',
  `act_list` text COMMENT '权限列表',
  `role_desc` varchar(255) DEFAULT NULL COMMENT '角色描述',
  PRIMARY KEY (`role_id`)
)  AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

/*Data for the table `tp_admin_role` */

LOCK TABLES `tp_admin_role` WRITE;

insert  into `tp_admin_role`(`role_id`,`role_name`,`act_list`,`role_desc`) values (2,'编辑','4,22,23,48,52,31,45,49,61,62,14,18,19,20,21,50,24,25,26,41,53,27,28,29,30,32,33,34,35,46,47','违法接口'),(1,'超级管理员','all','管理全站'),(4,'客服','5,7,49,61,27,28,29,30,32','客服处理订单发货'),(6,'仓管员','11,12,13,14','仓管员'),(9,'运营专员','4,22,23,48,52,7,31,45,49,61,15,16,17,18,19,20,21,50,24,25,26,41,51,53','负责维护商品活动推广'),(10,'加盟商','27,28,29,30,33,34,35','加盟商查看管理订单'),(11,'文章管理','15,16,17,18,19,20,21,50,118,119,63','文章管理'),(17,'运营','27,28,29,30,32,33,34,35,121,123,63,64,68,69,78,81,82,83,84,86,96,97,98,99,106','负责用户订单');

UNLOCK TABLES;

/*Table structure for table `tp_area_region` */

DROP TABLE IF EXISTS `tp_area_region`;

CREATE TABLE `tp_area_region` (
  `shipping_area_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '物流配置id',
  `region_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '地区id对应region表id',
  PRIMARY KEY (`shipping_area_id`,`region_id`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_area_region` */

LOCK TABLES `tp_area_region` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_article` */

DROP TABLE IF EXISTS `tp_article`;

CREATE TABLE `tp_article` (
  `article_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `cat_id` smallint(5) NOT NULL DEFAULT '0' COMMENT '类别ID',
  `title` varchar(150) NOT NULL DEFAULT '' COMMENT '文章标题',
  `content` longtext NOT NULL,
  `author` varchar(30) NOT NULL DEFAULT '' COMMENT '文章作者',
  `author_email` varchar(60) NOT NULL DEFAULT '' COMMENT '作者邮箱',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `article_type` tinyint(1) unsigned NOT NULL DEFAULT '2',
  `is_open` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示,1:显示;0:不显示',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `file_url` varchar(255) NOT NULL DEFAULT '' COMMENT '附件地址',
  `open_type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `link` varchar(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `description` mediumtext COMMENT '文章摘要',
  `click` int(11) DEFAULT '0' COMMENT '浏览量',
  `publish_time` int(11) DEFAULT NULL COMMENT '文章预告发布时间',
  `thumb` varchar(255) DEFAULT '' COMMENT '文章缩略图',
  PRIMARY KEY (`article_id`),
  KEY `cat_id` (`cat_id`) USING BTREE
)  AUTO_INCREMENT=35 DEFAULT CHARSET=utf8;

/*Data for the table `tp_article` */

LOCK TABLES `tp_article` WRITE;

insert  into `tp_article`(`article_id`,`cat_id`,`title`,`content`,`author`,`author_email`,`keywords`,`article_type`,`is_open`,`add_time`,`file_url`,`open_type`,`link`,`description`,`click`,`publish_time`,`thumb`) values (1,1,'新用户注册','&lt;p&gt;是打发士大夫&lt;/p&gt;','','','',2,0,1504687587,'',0,'','',1122,1504195200,''),(2,1,'积分细则','&lt;p&gt;的说法各大省份&lt;/p&gt;','','','',2,0,1504687696,'',0,'','',1201,1504195200,''),(3,1,'忘记密码','&lt;p&gt;第十个梵蒂冈&lt;/p&gt;','','','',2,0,1504687712,'',0,'','',1060,1504195200,''),(4,1,'如何搜索','&lt;p&gt;不错vbcvb&lt;/p&gt;','','','',2,0,1504687729,'',0,'','',1013,1504713600,''),(5,2,'会员修改密码','&lt;p&gt;修改密码&lt;/p&gt;','','','无限惊喜',2,0,1504687769,'',0,'','',1033,1504195200,''),(6,2,'修改个人资料','&lt;p&gt;修改个人资料&lt;/p&gt;','','','无限惊喜',2,0,1504687791,'',0,'','',1095,1504195200,''),(7,2,'会员等级','&lt;p&gt;是打发士大夫&lt;/p&gt;','','','',2,0,1504687818,'',0,'','',1030,1504195200,''),(8,2,'常见问题','&lt;p&gt;的所发生的&lt;/p&gt;','','','',2,0,1504687833,'',0,'','',1223,1504195200,''),(9,4,'银联支付','&lt;p&gt;是的发送到&lt;/p&gt;','','','',2,0,1504687862,'',0,'','',1038,1504195200,''),(10,4,'支付宝支付','&lt;p&gt;支付宝支付&lt;/p&gt;','','','',2,0,1504687884,'',0,'','',1250,1504195200,''),(11,4,'微信支付','&lt;p&gt;水电费水电费&lt;/p&gt;','','','',2,0,1504687900,'',0,'','',1243,1504195200,''),(12,4,'余额支付','&lt;p&gt;是的发送到水电费&lt;/p&gt;','','','',2,0,1504687920,'',0,'','',1191,1504195200,''),(13,4,'分期付款','&lt;p&gt;阿萨德发水电费&lt;/p&gt;','','','',2,0,1504687950,'',0,'','',1091,1504195200,''),(14,3,'售后政策','&lt;p&gt;是的发送到&lt;/p&gt;','','','',2,0,1504687964,'',0,'','',1086,1504195200,''),(15,3,'退换货流程','&lt;p&gt;&lt;a href=&quot;http://help.suning.com/page/id-287.htm&quot; target=&quot;_blank&quot; style=&quot;color: rgb(84, 84, 84); outline: 0px; font-family: &amp;quot;Microsoft yahei&amp;quot;; font-size: 12px; white-space: normal; background-color: rgb(245, 245, 245); text-decoration-line: none !important;&quot;&gt;退换货流程&lt;/a&gt;&lt;/p&gt;','','','',2,0,1504687979,'',0,'','',1008,1504195200,''),(16,3,'退款说明','&lt;p&gt;&lt;a href=&quot;http://help.suning.com/page/id-290.htm&quot; target=&quot;_blank&quot; style=&quot;color: rgb(84, 84, 84); outline: 0px; font-family: &amp;quot;Microsoft yahei&amp;quot;; font-size: 12px; white-space: normal; background-color: rgb(245, 245, 245); text-decoration-line: none !important;&quot;&gt;退款说明&lt;/a&gt;&lt;/p&gt;','','','',2,0,1504687995,'',0,'','',1128,1504195200,''),(17,3,'取消订单','&lt;ul class=&quot;mod_help_nav_con list-paddingleft-2&quot; style=&quot;padding: 0px; color: rgb(102, 102, 102); font-family: &amp;quot;Microsoft YaHei&amp;quot;, tahoma, arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;\\\\5b8b体&amp;quot;, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(234, 234, 234);&quot;&gt;&lt;li&gt;&lt;p&gt;&lt;a href=&quot;https://help.jd.com/user/issue/list-50.html&quot; target=&quot;_blank&quot; style=&quot;margin: 0px; padding: 0px; color: rgb(200, 22, 35); text-decoration-line: none;&quot;&gt;取消订单&lt;/a&gt;&lt;/p&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;','','','',2,0,1504688016,'',0,'','',1078,1504195200,''),(18,5,'免运费政策','&lt;p&gt;&lt;a href=&quot;http://help.suning.com/page/channel-37.htm&quot; target=&quot;_blank&quot; style=&quot;color: rgb(255, 102, 0); outline: 0px; font-family: &amp;quot;Microsoft yahei&amp;quot;; font-size: 12px; white-space: normal; background-color: rgb(245, 245, 245); text-decoration-line: none !important;&quot;&gt;免运费政策&lt;/a&gt;&lt;/p&gt;','','','',2,0,1504688045,'',0,'','',1041,1504195200,''),(19,5,'物流查询','&lt;p&gt;&lt;a href=&quot;http://help.suning.com/page/id-204.htm&quot; target=&quot;_blank&quot; style=&quot;color: rgb(84, 84, 84); outline: 0px; font-family: &amp;quot;Microsoft yahei&amp;quot;; font-size: 12px; white-space: normal; background-color: rgb(245, 245, 245); text-decoration-line: none !important;&quot;&gt;物流查询&lt;/a&gt;&lt;/p&gt;','','','',2,0,1504688058,'',0,'','',1161,1504195200,''),(20,5,'上门自提','&lt;ul class=&quot;mod_help_nav_con list-paddingleft-2&quot; style=&quot;padding: 0px; color: rgb(102, 102, 102); font-family: &amp;quot;Microsoft YaHei&amp;quot;, tahoma, arial, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;\\\\5b8b体&amp;quot;, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(234, 234, 234);&quot;&gt;&lt;li&gt;&lt;p&gt;&lt;a href=&quot;https://help.jd.com/user/issue/list-81-100.html&quot; target=&quot;_blank&quot; style=&quot;margin: 0px; padding: 0px; color: rgb(200, 22, 35); text-decoration-line: none;&quot;&gt;上门自提&lt;/a&gt;&lt;/p&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;','','','',2,0,1504688077,'',0,'','',1295,1504195200,''),(21,5,'配送服务承诺','&lt;p&gt;&lt;a href=&quot;http://help.suning.com/page/id-197.htm&quot; target=&quot;_blank&quot; style=&quot;color: rgb(255, 102, 0); outline: 0px; font-family: &amp;quot;Microsoft yahei&amp;quot;; font-size: 12px; white-space: normal; background-color: rgb(245, 245, 245); text-decoration-line: none !important;&quot;&gt;配送服务承诺&lt;/a&gt;&lt;/p&gt;','','','',2,0,1504688104,'',0,'','',1259,1504195200,''),(22,2,'修改收货地址','&lt;p&gt;&lt;a href=&quot;http://v5.33hao.com/member/index.php?act=article&amp;op=show&amp;article_id=21&quot; title=&quot;修改收货地址&quot; style=&quot;color: rgb(153, 153, 153); outline: none medium; transition-property: color; transition-duration: 0.3s; transition-timing-function: ease; font-family: &amp;quot;microsoft yahei&amp;quot;; font-size: 12px; background-color: rgb(255, 255, 255);&quot;&gt;修改收货地址&lt;/a&gt;&lt;/p&gt;','','','',2,0,1504688221,'',0,'','',1086,1504195200,''),(23,1,'积分兑换说明','&lt;p&gt;&lt;a href=&quot;http://v5.33hao.com/member/index.php?act=article&amp;op=show&amp;article_id=40&quot; title=&quot;积分兑换说明&quot; style=&quot;color: rgb(153, 153, 153); text-decoration-line: none; outline: none medium; transition-property: color; transition-duration: 0.3s; transition-timing-function: ease; font-family: &amp;quot;microsoft yahei&amp;quot;; font-size: 12px; background-color: rgb(255, 255, 255);&quot;&gt;积分兑换说明&lt;/a&gt;&lt;/p&gt;','','','',2,0,1504688275,'',0,'','',1085,1504195200,''),(24,6,'多商家2.09发布了','&lt;p&gt;阿斯顿发送到范德萨发&lt;/p&gt;','','','',2,0,1504690924,'',0,'','',1195,1504195200,''),(25,6,'台风暴雨期间送货时间通知','&lt;p&gt;台风暴雨期间送货时间通知&lt;/p&gt;','','','',2,0,1504691037,'',0,'','',1026,1504195200,''),(26,6,'多商户小程序上线了','&lt;p&gt;多商户小程序上线了&lt;/p&gt;','','','tpshop',2,0,1504691079,'',0,'','',1299,1504195200,''),(27,1,'8855','&lt;p&gt;55445&lt;/p&gt;','','','',2,0,1511936826,'',0,'http://demo6.tpshop.com/index.php/Mobile/Goods/goodsInfo/id/272.html','',1133,1511971200,''),(28,1,'sss','&lt;p&gt;&lt;img src=&quot;/public/upload/article/2017/12-21/14b9aa5bb2012696e00df2a902b4d755.png&quot; title=&quot;&quot; alt=&quot;&quot;/&gt;&lt;/p&gt;','','','',2,0,1513824513,'',0,'','',1069,1513872000,''),(29,14,'分销说明','&lt;p&gt;666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666&lt;/p&gt;','','','',2,0,1516783618,'',0,'','',1013,1516809600,'/public/upload/article/2018/01-24/7e165a22777ffbbae307d67fda36a521.jpg'),(30,5,'发货与签收','&lt;p&gt;开箱验货&lt;br/&gt;&lt;/p&gt;','','','',2,0,1523438712,'',0,'','',1278,1523462400,''),(31,4,'信用卡支付','&lt;p&gt;信用卡支付&lt;/p&gt;','','','',2,0,1523439052,'',0,'','',1270,1523462400,''),(33,3,'价格保证','&lt;p&gt;价格保证&lt;/p&gt;','','','',2,0,1523442099,'',0,'','',1279,1523462400,''),(34,14,'分销','&lt;p&gt;分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销分销&lt;/p&gt;','','','',2,1,1524217283,'',0,'','',1206,1524240000,'');

UNLOCK TABLES;

/*Table structure for table `tp_article2` */

DROP TABLE IF EXISTS `tp_article2`;

CREATE TABLE `tp_article2` (
  `article_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `cat_id` smallint(5) NOT NULL DEFAULT '0' COMMENT '类别ID',
  `title` varchar(150) NOT NULL DEFAULT '' COMMENT '文章标题',
  `content` longtext NOT NULL COMMENT '文章内容',
  `author` varchar(30) NOT NULL DEFAULT '' COMMENT '文章作者',
  `author_email` varchar(60) NOT NULL DEFAULT '' COMMENT '作者邮箱',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `article_type` tinyint(1) unsigned NOT NULL DEFAULT '2' COMMENT '文章类型',
  `is_open` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否开启',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `file_url` varchar(255) NOT NULL DEFAULT '' COMMENT '附件地址',
  `open_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'open_type',
  `link` varchar(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `description` mediumtext COMMENT '文章摘要',
  `click` int(11) DEFAULT '0' COMMENT '浏览量',
  `publish_time` int(11) DEFAULT '0' COMMENT '文章发布时间',
  `thumb` varchar(255) DEFAULT '' COMMENT '文章缩略图',
  PRIMARY KEY (`article_id`),
  KEY `cat_id` (`cat_id`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_article2` */

LOCK TABLES `tp_article2` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_article_bak` */

DROP TABLE IF EXISTS `tp_article_bak`;

CREATE TABLE `tp_article_bak` (
  `article_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `cat_id` smallint(5) NOT NULL DEFAULT '0' COMMENT '类别ID',
  `cat_id2` smallint(5) DEFAULT '0' COMMENT '扩展类别ID',
  `title` varchar(150) NOT NULL DEFAULT '' COMMENT '文章标题',
  `content` longtext NOT NULL COMMENT '文章内容',
  `author` varchar(30) NOT NULL DEFAULT '' COMMENT '文章作者',
  `author_email` varchar(60) NOT NULL DEFAULT '' COMMENT '作者邮箱',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `article_type` tinyint(1) unsigned NOT NULL DEFAULT '2' COMMENT '文章类型',
  `is_open` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否开启',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `file_url` varchar(255) NOT NULL DEFAULT '' COMMENT '附件地址',
  `open_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'open_type',
  `link` varchar(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `description` mediumtext COMMENT '文章摘要',
  `click` int(11) DEFAULT '0' COMMENT '浏览量',
  `publish_time` int(11) DEFAULT '0' COMMENT '文章发布时间',
  `thumb` varchar(255) DEFAULT '' COMMENT '文章缩略图',
  PRIMARY KEY (`article_id`),
  KEY `cat_id` (`cat_id`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_article_bak` */

LOCK TABLES `tp_article_bak` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_article_cat` */

DROP TABLE IF EXISTS `tp_article_cat`;

CREATE TABLE `tp_article_cat` (
  `cat_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_name` varchar(20) DEFAULT NULL COMMENT '类别名称',
  `cat_type` smallint(6) DEFAULT '0' COMMENT '默认分组',
  `parent_id` smallint(6) DEFAULT '0' COMMENT '夫级ID',
  `show_in_nav` tinyint(1) DEFAULT '0' COMMENT '是否导航显示',
  `sort_order` smallint(6) DEFAULT '50' COMMENT '排序',
  `cat_desc` varchar(255) DEFAULT NULL COMMENT '分类描述',
  `keywords` varchar(30) DEFAULT NULL COMMENT '搜索关键词',
  `cat_alias` varchar(20) DEFAULT NULL COMMENT '别名',
  PRIMARY KEY (`cat_id`)
)  AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

/*Data for the table `tp_article_cat` */

LOCK TABLES `tp_article_cat` WRITE;

insert  into `tp_article_cat`(`cat_id`,`cat_name`,`cat_type`,`parent_id`,`show_in_nav`,`sort_order`,`cat_desc`,`keywords`,`cat_alias`) values (1,'新手上路',1,0,0,0,'1233','',NULL),(2,'购物指南',1,0,0,2,'','',NULL),(3,'售后服务',1,0,0,2,'','',NULL),(4,'支付方式',1,0,0,4,'','',NULL),(5,'配送方式',1,0,0,5,'','',NULL),(6,'商城公告',1,0,0,6,'','',NULL),(7,'关于我们',1,0,0,7,'','',NULL),(8,'每日推荐',1,0,1,9,'','',NULL),(10,'余家',0,0,0,1,'','',NULL),(11,'售后消息',0,10,1,1,'','',NULL),(12,'售后信息',0,0,1,2,'','2',NULL),(13,'退换货',0,11,1,0,'','',NULL),(14,'分销简介',0,1,1,1,'','',NULL);

UNLOCK TABLES;

/*Table structure for table `tp_article_cat2` */

DROP TABLE IF EXISTS `tp_article_cat2`;

CREATE TABLE `tp_article_cat2` (
  `cat_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `cat_name` varchar(20) DEFAULT NULL COMMENT '类别名称',
  `cat_type` smallint(6) DEFAULT '0' COMMENT '系统分组',
  `parent_id` smallint(6) DEFAULT NULL COMMENT '夫级ID',
  `show_in_nav` tinyint(1) DEFAULT '0' COMMENT '是否导航显示',
  `sort_order` smallint(6) DEFAULT '50' COMMENT '排序',
  `cat_desc` varchar(255) DEFAULT NULL COMMENT '分类描述',
  `keywords` varchar(30) DEFAULT NULL COMMENT '搜索关键词',
  `cat_alias` varchar(20) DEFAULT NULL COMMENT '别名',
  PRIMARY KEY (`cat_id`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_article_cat2` */

LOCK TABLES `tp_article_cat2` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_brand` */

DROP TABLE IF EXISTS `tp_brand`;

CREATE TABLE `tp_brand` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '品牌表',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '品牌名称',
  `logo` varchar(80) NOT NULL DEFAULT '' COMMENT '品牌logo',
  `desc` text NOT NULL COMMENT '品牌描述',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌地址',
  `sort` int(3) unsigned NOT NULL DEFAULT '50' COMMENT '排序',
  `cat_name` varchar(128) DEFAULT '' COMMENT '品牌分类',
  `parent_cat_id` int(11) DEFAULT '0' COMMENT '分类id',
  `cat_id` int(10) DEFAULT '0' COMMENT '分类id',
  `is_hot` tinyint(1) DEFAULT '0' COMMENT '是否推荐',
  PRIMARY KEY (`id`)
)  AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

/*Data for the table `tp_brand` */

LOCK TABLES `tp_brand` WRITE;

insert  into `tp_brand`(`id`,`name`,`logo`,`desc`,`url`,`sort`,`cat_name`,`parent_cat_id`,`cat_id`,`is_hot`) values (1,'苹果','/public/upload/brand/2018/04-09/0b15dc421ab6acbd955dcda3ac879796.jpg','','https://search.jd.com/Search?k',1,'',31,168,1),(2,'小米','/public/upload/brand/2018/04-09/06f53e6a922473719c1f18fc53479794.png','小米手机','http://xiaomi.cn',2,'',31,33,1),(3,'UR','/public/upload/brand/2018/04-09/b63df73fad187d84d19ec290f86efdac.jpg','','',5,'',12,13,1),(4,'联想','/public/upload/brand/2018/04-09/ead2ddf41ab9940fad739ba8a43a8f20.jpg','','http://lianxiang.cn',4,'',37,38,1),(5,'华为手机','/public/upload/brand/2018/04-10/23ed026bfcb51100d79a5a93989b83c8.jpg','','',3,'',31,33,1),(7,'戴尔','/public/upload/brand/2018/04-10/331f134c1cab918782f390908d50c578.jpg','','',6,'',37,38,1),(8,'三星','','','',3,'',31,33,1),(9,'安踏','/public/upload/brand/2018/04-10/74b8c31f3e990a13c4b888a2bf16eb88.jpg','','',9,'',12,23,1),(10,'卓诗尼','/public/upload/brand/2018/04-10/1ad8d0f83b86404848c83709ada3cecb.jpg','','http://www.zdashu.com.cn/shop/josiny.html',9,'',56,57,1),(11,'阿迪达斯','/public/upload/brand/2018/04-10/41f70fb32780777fc2c493f039d43290.jpg','','',10,'',12,23,1),(12,'花花公子','/public/upload/brand/2018/04-11/6d96f6d787cc3c09b51f1bfafcea8305.jpg','','',10,'',12,23,0),(13,'浪琴','/public/upload/brand/2018/04-13/a3e093e3ea102712ffbaaadd80365ddb.jpg','','http://www.xbiao.com',9,'',56,495,0),(14,'卡西欧','/public/upload/brand/2018/04-13/0ed003e0e548942c68de001168791fc8.png','','http://www.casiostore.com.cn/',12,'',56,495,1),(15,'耐克','','','',0,'',12,23,0),(16,'LG','','','',0,'',56,58,0);

UNLOCK TABLES;

/*Table structure for table `tp_cart` */

DROP TABLE IF EXISTS `tp_cart`;

CREATE TABLE `tp_cart` (
  `id` int(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '购物车表',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `session_id` char(128) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT 'session',
  `goods_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `goods_sn` varchar(60) NOT NULL DEFAULT '' COMMENT '商品货号',
  `goods_name` varchar(120) NOT NULL DEFAULT '' COMMENT '商品名称',
  `market_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '市场价',
  `goods_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '本店价',
  `member_goods_price` decimal(10,2) DEFAULT '0.00' COMMENT '会员折扣价',
  `goods_num` smallint(5) unsigned DEFAULT '0' COMMENT '购买数量',
  `item_id` int(11) DEFAULT '0' COMMENT '规格ID',
  `spec_key` varchar(64) DEFAULT '' COMMENT '商品规格key 对应tp_spec_goods_price 表',
  `spec_key_name` varchar(64) DEFAULT '' COMMENT '商品规格组合名称',
  `bar_code` varchar(64) DEFAULT '' COMMENT '商品条码',
  `selected` tinyint(1) DEFAULT '1' COMMENT '购物车选中状态',
  `add_time` int(11) DEFAULT '0' COMMENT '加入购物车的时间',
  `prom_type` tinyint(1) DEFAULT '0' COMMENT '0 普通订单,1 限时抢购, 2 团购 , 3 促销优惠,7 搭配购',
  `prom_id` int(11) DEFAULT '0' COMMENT '活动id',
  `sku` varchar(128) DEFAULT '' COMMENT 'sku',
  `combination_group_id` int(8) unsigned NOT NULL DEFAULT '0' COMMENT ' 搭配购的组id/cart_id',
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  KEY `user_id` (`user_id`),
  KEY `goods_id` (`goods_id`),
  KEY `spec_key` (`spec_key`)
)  AUTO_INCREMENT=219 DEFAULT CHARSET=utf8;

/*Data for the table `tp_cart` */

LOCK TABLES `tp_cart` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_combination` */

DROP TABLE IF EXISTS `tp_combination`;

CREATE TABLE `tp_combination` (
  `combination_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `desc` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `is_on_sale` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '上下架，0下，1上',
  `start_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '活动有效起始时间',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '活动有效截止时间',
  PRIMARY KEY (`combination_id`)
)  DEFAULT CHARSET=utf8 COMMENT='组合促销表';

/*Data for the table `tp_combination` */

LOCK TABLES `tp_combination` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_combination_goods` */

DROP TABLE IF EXISTS `tp_combination_goods`;

CREATE TABLE `tp_combination_goods` (
  `combination_id` int(10) NOT NULL,
  `goods_name` varchar(255) NOT NULL DEFAULT '' COMMENT '商品名称',
  `key_name` varchar(255) NOT NULL DEFAULT '' COMMENT '规格名称',
  `goods_id` int(10) NOT NULL,
  `item_id` int(10) NOT NULL,
  `original_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '原价/商城价',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '优惠价格',
  `is_master` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '1主0从'
)  DEFAULT CHARSET=utf8 COMMENT='组合促销商品映射关系表';

/*Data for the table `tp_combination_goods` */

LOCK TABLES `tp_combination_goods` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_comment` */

DROP TABLE IF EXISTS `tp_comment`;

CREATE TABLE `tp_comment` (
  `comment_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '评论id',
  `goods_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `email` varchar(60) NOT NULL DEFAULT '' COMMENT 'email邮箱',
  `username` varchar(60) NOT NULL DEFAULT '' COMMENT '用户名',
  `content` text NOT NULL COMMENT '评论内容',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `ip_address` varchar(15) NOT NULL DEFAULT '' COMMENT 'ip地址',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否显示',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '评论用户',
  `img` text COMMENT '晒单图片',
  `order_id` mediumint(8) DEFAULT '0' COMMENT '订单id',
  `deliver_rank` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '物流评价等级',
  `goods_rank` tinyint(1) DEFAULT '0' COMMENT '商品评价等级',
  `service_rank` tinyint(1) DEFAULT '0' COMMENT '商家服务态度评价等级',
  `zan_num` int(10) NOT NULL DEFAULT '0' COMMENT '被赞数',
  `zan_userid` varchar(255) NOT NULL DEFAULT '' COMMENT '点赞用户id',
  `is_anonymous` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否匿名评价:0不是，1是',
  `rec_id` int(11) DEFAULT NULL COMMENT '订单商品表ID',
  `sort` int(4) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`comment_id`),
  KEY `parent_id` (`parent_id`),
  KEY `id_value` (`goods_id`),
  KEY `order_id` (`order_id`),
  KEY `user_id` (`user_id`)
)  AUTO_INCREMENT=68 DEFAULT CHARSET=utf8;

/*Data for the table `tp_comment` */

LOCK TABLES `tp_comment` WRITE;

insert  into `tp_comment`(`comment_id`,`goods_id`,`email`,`username`,`content`,`add_time`,`ip_address`,`is_show`,`parent_id`,`user_id`,`img`,`order_id`,`deliver_rank`,`goods_rank`,`service_rank`,`zan_num`,`zan_userid`,`is_anonymous`,`rec_id`,`sort`) values (1,154,'','','54545445',1523851074,'183.11.70.112',1,0,2,'a:5:{i:0;s:51:\"/public/upload/comment/2018/04-16/5ad41f428b4e5.png\";i:1;s:51:\"/public/upload/comment/2018/04-16/5ad41f428b4e5.png\";i:2;s:51:\"/public/upload/comment/2018/04-16/5ad41f428b4e5.png\";i:3;s:51:\"/public/upload/comment/2018/04-16/5ad41f428b4e5.png\";i:4;s:51:\"/public/upload/comment/2018/04-16/5ad41f428b4e5.png\";}',24,2,3,4,2,',2,3',1,32,100),(2,74,'','15915407513','OK!OK!OK!OKOKOKOKOKOK1',1523857699,'183.11.70.112',1,0,2,'s:0:\"\";',25,0,3,3,0,'',0,33,100),(3,56,'','','okokokokokokok',1523858263,'183.11.70.112',1,0,2,'s:0:\"\";',7,4,4,4,0,'',1,7,100),(4,97,'123456@qq.com','15915407513','往事并不如烟123456',1523869839,'183.11.70.112',1,0,2,'a:5:{i:0;s:67:\"/public/upload/user/2/comment//5028f4eaaeec64d8c1918b3fa65f0c8b.jpg\";i:1;s:67:\"/public/upload/user/2/comment//9ef3862b61b24ecb82d89ad5dc33e9bb.jpg\";i:2;s:67:\"/public/upload/user/2/comment//dfc6b6b565ec492d0f61cbea66492c50.png\";i:3;s:67:\"/public/upload/user/2/comment//f5f38481bc76a025234b6ee89e40ec1a.png\";i:4;s:67:\"/public/upload/user/2/comment//59d2256f28ae30da4085c045ea01d001.png\";}',32,3,5,2,1,',2',0,44,100),(5,93,'123456@qq.com','','好好好好哈哈哈哈或或或',1523870688,'183.11.70.112',1,0,2,'a:1:{i:0;s:67:\"/public/upload/user/2/comment//ab5a7c93a17399678744feafb8995e13.jpg\";}',23,5,5,5,1,',2',1,31,100),(6,109,'123456@qq.com','','有艺术的感觉非常喜欢',1523870755,'183.11.70.112',1,0,2,'s:0:\"\";',27,4,4,5,0,'',1,35,100),(7,93,'123456@qq.com','15915407513','与预期期望的不一样，差评123',1523871562,'183.11.70.112',1,0,2,'a:5:{i:0;s:67:\"/public/upload/user/2/comment//67597519f299e41136ba16b193041925.png\";i:1;s:67:\"/public/upload/user/2/comment//3d9cb869c8af166b540598e41464f19a.png\";i:2;s:67:\"/public/upload/user/2/comment//cdd8208ee222967865fcc490d81568a9.png\";i:3;s:67:\"/public/upload/user/2/comment//9be58af292eb78f183b83fb8daf1cb3b.png\";i:4;s:67:\"/public/upload/user/2/comment//29a439d309ca699bb3d22d2123dec0d6.png\";}',35,2,3,1,1,',2',0,49,100),(8,93,'','admin','pilun',1523871675,'',1,7,0,NULL,0,0,0,0,0,'',0,NULL,100),(9,93,'','admin','1221212121',1523871706,'',1,7,0,NULL,0,0,0,0,0,'',0,NULL,100),(10,171,'123456@qq.com','','衣服质量不错，颜色没有色差，很不错，一分钱一分货，值得购买！',1523873368,'183.11.70.112',1,0,2,'a:2:{i:0;s:67:\"/public/upload/user/2/comment//21e2f7ca6c9aef81e723fee8bc67c64a.jpg\";i:1;s:67:\"/public/upload/user/2/comment//79c7f40a9f7b1f36de9855b0c7d7ffda.jpg\";}',36,4,5,5,0,'',1,50,100),(11,108,'123456@qq.com','','好看还是挺可以的不错\r\n',1523930696,'183.11.37.141',1,0,2,'s:0:\"\";',41,2,2,2,0,'',1,56,100),(12,171,'123456@qq.com','','订单订单订单订单的  的订单的 订单',1523930857,'183.11.37.141',1,0,2,'s:0:\"\";',40,4,2,1,0,'',1,54,100),(13,93,'123456@qq.com','15915407513','给力给力力力力力力地方',1523931583,'183.11.37.141',1,0,2,'a:1:{i:0;s:67:\"/public/upload/user/2/comment//32cabe3d1120f002dc6299dcd1c5cbf6.jpg\";}',47,5,5,5,1,',2',0,64,100),(14,116,'123456@qq.com','15915407513','好吃好吃',1523947204,'117.136.79.162',1,0,2,'a:1:{i:0;s:68:\"/public/upload/comment/20180417/0db66d5d954483b1f0895b9145ec0927.png\";}',31,3,3,3,0,'',1,NULL,100),(15,21,'','18516589423','商品12345678997756433222',1523956870,'183.11.37.141',1,0,3,'a:1:{i:0;s:67:\"/public/upload/user/3/comment//059a9395c42f1a88f68768b8c58ca389.png\";}',81,1,2,1,1,',3',0,107,100),(16,199,'','18516589423','很好很好',1524017723,'183.11.37.141',1,0,3,'a:5:{i:0;s:68:\"/public/upload/comment/20180418/23951bcc2ed610121c9ce1feeb3aa150.png\";i:1;s:68:\"/public/upload/comment/20180418/23951bcc2ed610121c9ce1feeb3aa150.png\";i:2;s:68:\"/public/upload/comment/20180418/23951bcc2ed610121c9ce1feeb3aa150.png\";i:3;s:68:\"/public/upload/comment/20180418/23951bcc2ed610121c9ce1feeb3aa150.png\";i:4;s:68:\"/public/upload/comment/20180418/23951bcc2ed610121c9ce1feeb3aa150.png\";}',94,3,4,2,0,'',1,NULL,100),(17,202,'123456@qq.com','15915407513','踏踏乱他家她踏踏自己她他呀！',1524018508,'223.104.63.174',1,0,2,'a:5:{i:0;s:68:\"/public/upload/comment/20180418/4eb771f1bd2df4c34c1ff10565392b27.png\";i:1;s:68:\"/public/upload/comment/20180418/4eb771f1bd2df4c34c1ff10565392b27.png\";i:2;s:68:\"/public/upload/comment/20180418/4eb771f1bd2df4c34c1ff10565392b27.png\";i:3;s:68:\"/public/upload/comment/20180418/4eb771f1bd2df4c34c1ff10565392b27.png\";i:4;s:68:\"/public/upload/comment/20180418/7bdae09e8a4533e21b1dcaf282e8393d.png\";}',92,4,3,4,0,'',1,NULL,100),(18,190,'123456@qq.com','15915407513','阿拉伯她他她它它他',1524018724,'223.104.63.174',1,0,2,'a:5:{i:0;s:68:\"/public/upload/comment/20180418/c434f867788ecfc0c43eb74e0bd8e684.png\";i:1;s:68:\"/public/upload/comment/20180418/c434f867788ecfc0c43eb74e0bd8e684.png\";i:2;s:68:\"/public/upload/comment/20180418/c434f867788ecfc0c43eb74e0bd8e684.png\";i:3;s:68:\"/public/upload/comment/20180418/e9eb995c513514b04734f5a1c73e3c03.png\";i:4;s:68:\"/public/upload/comment/20180418/e9eb995c513514b04734f5a1c73e3c03.png\";}',44,3,3,3,0,'',1,NULL,100),(19,97,'123456@qq.com','15915407513','衣服简单实惠，买到赚到了。',1524019124,'223.104.63.174',1,0,2,'',31,5,5,5,0,'',0,NULL,100),(20,171,'15915407513@163.com','','给力给力给力给了个好的的好的',1524019739,'183.11.37.141',1,0,1,'a:4:{i:0;s:67:\"/public/upload/user/1/comment//b4e247e8429216d0bd06c09429b92efc.jpg\";i:1;s:67:\"/public/upload/user/1/comment//e32784f4c50a36acdc21899a3bb94049.jpg\";i:2;s:67:\"/public/upload/user/1/comment//458b42215bc09fdee82c2d5bbcd1d365.jpg\";i:3;s:67:\"/public/upload/user/1/comment//0d553a44c73e8d7a54a715ab0e40d51c.jpg\";}',57,3,3,3,0,'',1,79,100),(21,133,'','','与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼与与鱼鱼鱼鱼鱼鱼',1524121988,'183.11.39.194',1,0,3,'a:3:{i:0;s:51:\"/public/upload/comment/2018/04-19/5ad84184c0d8b.png\";i:1;s:51:\"/public/upload/comment/2018/04-19/5ad84184c1ccd.png\";i:2;s:51:\"/public/upload/comment/2018/04-19/5ad84184c283f.png\";}',183,2,4,2,0,'',1,212,100),(22,177,'123456@qq.com','15915407513','你好好你好好好',1524124286,'183.11.39.194',1,0,2,'a:2:{i:0;s:68:\"/public/upload/comment/20180419/3e8a693d77e0c091759adb16d650a8a9.png\";i:1;s:68:\"/public/upload/comment/20180419/496f4e016e6bdf5f6cadc09f90c8b5c6.png\";}',205,3,2,3,0,'',1,NULL,100),(23,177,'15825@163.com','等待','阿拉他律',1524124488,'117.136.79.147',1,0,10,'',201,3,3,3,0,'',0,NULL,100),(24,219,'','青春','红尘滚滚',1524128827,'183.11.39.194',1,0,3,'',222,2,3,2,0,'',0,NULL,100),(25,177,'15825@163.com','','HKDHOFHGFKHOU ',1524186252,'183.11.39.194',1,0,10,NULL,199,4,3,4,0,'',1,228,100),(31,74,'15825@163.com','','SFSF',1524455373,'183.11.37.28',1,0,10,'a:5:{i:0;s:51:\"/public/upload/comment/2018/04-23/5add57cdaa688.jpg\";i:1;s:51:\"/public/upload/comment/2018/04-23/5add57cdab1f9.jpg\";i:2;s:51:\"/public/upload/comment/2018/04-23/5add57cdabd6b.jpg\";i:3;s:51:\"/public/upload/comment/2018/04-23/5add57cdac8dc.jpg\";i:4;s:51:\"/public/upload/comment/2018/04-23/5add57cdaccad.jpg\";}',320,0,3,3,0,'',1,349,100),(28,221,'15825@163.com','等待','DDDGDGSDDGDSG',1524220043,'183.11.39.194',1,0,10,'s:0:\"\";',276,3,3,3,0,'',0,305,100),(29,1,'15825@163.com','等待','JSKLSHGFKLSHG LSKGLSGLSKHSKLGG',1524220055,'183.11.39.194',1,0,10,'s:0:\"\";',274,4,4,3,1,',25',0,303,100),(32,4,'','','0哦哦哦哦哦',1524466610,'183.11.37.28',1,0,3,'a:5:{i:0;s:51:\"/public/upload/comment/2018/04-23/5add83b1f1f09.png\";i:1;s:51:\"/public/upload/comment/2018/04-23/5add83b1f321c.png\";i:2;s:51:\"/public/upload/comment/2018/04-23/5add83b1f415f.png\";i:3;s:51:\"/public/upload/comment/2018/04-23/5add83b201232.png\";i:4;s:51:\"/public/upload/comment/2018/04-23/5add83b201da4.png\";}',329,2,2,1,0,'',1,358,100),(33,74,'1522585@qq.com','','123456456456456456',1524469548,'183.11.37.28',1,0,10,'a:5:{i:0;s:68:\"/public/upload/user/10/comment//d652a779d235b0468d0fd5d24eec3819.png\";i:1;s:68:\"/public/upload/user/10/comment//4783ce1f1b9217e7cb00c2861ed707fe.jpg\";i:2;s:68:\"/public/upload/user/10/comment//04157946ad99c8820f9bca0e31e1f80d.jpg\";i:3;s:68:\"/public/upload/user/10/comment//72938ec679ae102d1b70874bf727f029.jpg\";i:4;s:68:\"/public/upload/user/10/comment//6ba5dadd448655b65949273d482bdecc.jpg\";}',326,0,4,4,0,'',1,355,100),(34,12,'','青春','夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上海夜上',1524553309,'183.11.37.28',1,0,3,'a:5:{i:0;s:51:\"/public/upload/comment/2018/04-24/5aded65d16e39.png\";i:1;s:51:\"/public/upload/comment/2018/04-24/5aded65d179aa.png\";i:2;s:51:\"/public/upload/comment/2018/04-24/5aded65d1814c.png\";i:3;s:51:\"/public/upload/comment/2018/04-24/5aded65d1908e.png\";i:4;s:51:\"/public/upload/comment/2018/04-24/5aded65d1982f.jpg\";}',356,2,3,1,1,',2',0,388,100),(35,16,'','','1',1524553375,'183.11.37.28',1,0,3,NULL,356,1,3,2,0,'',1,389,100),(36,32,'','','221212121212121',1524553507,'183.11.37.28',1,0,3,'a:3:{i:0;s:51:\"/public/upload/comment/2018/04-24/5aded723392bd.jpg\";i:1;s:51:\"/public/upload/comment/2018/04-24/5aded72339e2f.jpg\";i:2;s:51:\"/public/upload/comment/2018/04-24/5aded7233a5d0.png\";}',356,3,1,4,0,'',1,390,100),(37,3,'','','23232322323',1524554021,'183.11.37.28',1,0,3,'a:2:{i:0;s:67:\"/public/upload/user/3/comment//0ff340b8c18d30e35a35945d88006326.png\";i:1;s:67:\"/public/upload/user/3/comment//8e229a4e93138c436b909b24fa18d222.png\";}',357,1,2,1,0,'',1,391,100),(38,220,'','15247471414','很好436458855很好43645885',1524556005,'183.11.37.28',1,0,17,'a:5:{i:0;s:68:\"/public/upload/comment/20180424/2f4bb2f883e72896679c0de1870b540d.png\";i:1;s:68:\"/public/upload/comment/20180424/a4519a3d2ea07de3ca27b708d4478af1.png\";i:2;s:68:\"/public/upload/comment/20180424/6b13ed936882ccf1cff25b05557b1f74.png\";i:3;s:68:\"/public/upload/comment/20180424/515075bf223f4671daa505a5dcac7570.png\";i:4;s:68:\"/public/upload/comment/20180424/86d19eecfd18efbfe3f0253a3167bfe1.png\";}',359,1,3,3,1,',3',1,NULL,100),(39,142,'15915407513@163.com','','你好你好你后你你好你你你你',1524647690,'183.11.70.126',1,0,1,'a:1:{i:0;s:67:\"/public/upload/user/1/comment//7bba7d9cf178942c60659438d10ea778.jpg\";}',424,0,4,4,1,',1',1,463,100),(40,142,'','admin','感谢你的支持，欢迎下次光临',1524648838,'',1,39,0,NULL,0,0,0,0,0,'',0,NULL,100),(41,15,'','','23285544112255',1524722681,'183.11.70.126',1,0,3,'a:3:{i:0;s:67:\"/public/upload/user/3/comment//c3d36c24b0082fcd7fa943d6d1841389.jpg\";i:1;s:67:\"/public/upload/user/3/comment//04cb06ea70ab5980780d295c59dae937.jpg\";i:2;s:67:\"/public/upload/user/3/comment//01d26734d971dbb88d247d362e394031.png\";}',451,4,3,1,1,',3',1,490,100),(42,220,'','青春','啦啦啦阿拉啦啦啦啦2',1524722978,'183.11.70.126',1,0,3,'a:5:{i:0;s:67:\"/public/upload/user/3/comment//d58035b8022bc2530ab6a290251b5abd.jpg\";i:1;s:67:\"/public/upload/user/3/comment//3a0e804d21fe421ddb2bf244ac6bdd35.jpg\";i:2;s:67:\"/public/upload/user/3/comment//7ecb04eba8299f5db53ac13cb543645f.jpg\";i:3;s:67:\"/public/upload/user/3/comment//72357faec86d1c217157e18d2a72a838.png\";i:4;s:67:\"/public/upload/user/3/comment//92468b748bfb961f2ebda6c89c6c23f4.png\";}',451,1,2,3,0,'',0,491,100),(43,219,'','青春','21122121212121',1524723037,'183.11.70.126',1,0,3,'a:4:{i:0;s:67:\"/public/upload/user/3/comment//7daf459c9a05ea2ec64c84dbe00cb1c2.jpg\";i:1;s:67:\"/public/upload/user/3/comment//dda90f4576639d0ed43f02758675cb93.jpg\";i:2;s:67:\"/public/upload/user/3/comment//474639fed2c9d0d531a0e1533f149e81.jpg\";i:3;s:67:\"/public/upload/user/3/comment//8e16e858b16211ca76f13c7275b623cd.jpg\";}',451,2,3,4,0,'',0,492,100),(44,219,'','青春','2232323',1524723213,'183.11.70.126',1,0,3,'a:4:{i:0;s:51:\"/public/upload/comment/2018/04-26/5ae16e0d37b0f.jpg\";i:1;s:51:\"/public/upload/comment/2018/04-26/5ae16e0d38681.png\";i:2;s:51:\"/public/upload/comment/2018/04-26/5ae16e0d391f2.png\";i:3;s:51:\"/public/upload/comment/2018/04-26/5ae16e0d3a134.jpg\";}',451,2,3,4,0,'',0,493,100),(45,47,'123456@qq.com','','你好你 好你好你好你好你好',1524725761,'183.11.70.126',1,0,2,'a:5:{i:0;s:51:\"/public/upload/comment/2018/04-26/5ae178019191f.jpg\";i:1;s:51:\"/public/upload/comment/2018/04-26/5ae17801920c0.jpg\";i:2;s:51:\"/public/upload/comment/2018/04-26/5ae1780192c32.jpg\";i:3;s:51:\"/public/upload/comment/2018/04-26/5ae1780193b74.jpg\";i:4;s:51:\"/public/upload/comment/2018/04-26/5ae17801946e5.jpg\";}',433,3,3,3,1,',2',1,472,100),(46,212,'','13243434343','好想好想你',1524728691,'183.11.70.126',1,0,22,'',462,1,1,1,0,'',0,NULL,100),(47,189,'','13243434343','很好喝好',1524730735,'183.11.70.126',1,0,22,'a:5:{i:0;s:68:\"/public/upload/comment/20180426/2f504e6c168ef139d938c97e35f113dd.png\";i:1;s:68:\"/public/upload/comment/20180426/0275408778c7f1dfa988037670667e06.png\";i:2;s:68:\"/public/upload/comment/20180426/3f08539fbde1e956962285da182a1177.png\";i:3;s:68:\"/public/upload/comment/20180426/cfd8cf16fb684a707fa804fea3f1c311.png\";i:4;s:68:\"/public/upload/comment/20180426/8584338a0df39a3ca70d121f846b5252.png\";}',467,1,1,1,0,'',1,NULL,100),(48,220,'','13243434343','关于风风光光不回家',1524734974,'183.11.70.126',1,0,22,'',479,1,3,3,0,'',0,NULL,100),(49,157,'','18679683657','123456789123456789',1524798180,'183.11.38.21',1,0,23,'a:2:{i:0;s:68:\"/public/upload/comment/20180427/a3eb0a49569a0fd31a0d55a61d61f49c.png\";i:1;s:68:\"/public/upload/comment/20180427/35865117ccb122c2ae84a0fa2d2b7401.png\";}',504,2,2,3,0,'',1,NULL,100),(50,219,'','','突然很想你太多太多了',1524807409,'183.11.38.21',1,0,22,'a:3:{i:0;s:51:\"/public/upload/comment/2018/04-27/5ae2b6f14556b.jpg\";i:1;s:51:\"/public/upload/comment/2018/04-27/5ae2b6f1460dc.jpg\";i:2;s:51:\"/public/upload/comment/2018/04-27/5ae2b6f146c4e.jpg\";}',479,1,4,2,0,'',1,532,100),(51,219,'','咻咻','越来越不懂爱',1524808166,'183.11.38.21',1,0,26,'a:1:{i:0;s:68:\"/public/upload/comment/20180427/6f75131472158b5f090731eb26df277e.png\";}',527,2,3,2,0,'',1,NULL,100),(52,157,'','18679683657','我就是看看',1524810221,'183.11.38.21',1,0,23,'',522,1,1,1,0,'',1,NULL,100),(53,204,'424077952@qq.com','15915407197','啦啦啦啦巨鹿路哭邋遢哭啊露露露露他看看图聊聊聊统计图捋了捋考虑旅途兔兔图聊聊聊聊聊连连连连连连连连铁路局卡卡路途看看连连连连啦啦啦他看看兔兔铁路局铁路局他考虑考虑兔兔啦啦啦他家里家里连连连聊聊聊聊聊聊啦啦啦啦卡露露露露她家聚聚太冷了解决了了',1524813258,'117.136.79.126',1,0,25,'a:1:{i:0;s:68:\"/public/upload/comment/20180427/5b842d4b7e5f7353156fdc4991dcc0f1.png\";}',541,4,4,4,0,'',1,NULL,100),(54,204,'424077952@qq.com','15915407197','塔卡裤',1524813614,'117.136.79.126',1,0,25,'a:5:{i:0;s:68:\"/public/upload/comment/20180427/304da92e98f4d5464087cd7c56815081.png\";i:1;s:68:\"/public/upload/comment/20180427/85a05583abca520daac50f6c01386120.png\";i:2;s:68:\"/public/upload/comment/20180427/7e4442c704fad9da0fca7b7895d747ca.png\";i:3;s:68:\"/public/upload/comment/20180427/c3f11af1149cfd599f0d79e303257863.png\";i:4;s:68:\"/public/upload/comment/20180427/5e88253211c9ac426a246e643505d682.png\";}',544,4,5,3,0,'',1,NULL,100),(55,229,'123','15915407513','他考虑考虑糖醋里脊他具体',1524814864,'117.136.79.126',1,0,2,'a:5:{i:0;s:51:\"/public/upload/comment/2018/04-27/5ae2d410c88aa.jpg\";i:1;s:51:\"/public/upload/comment/2018/04-27/5ae2d410c97ec.jpg\";i:2;s:51:\"/public/upload/comment/2018/04-27/5ae2d410ca35e.jpg\";i:3;s:51:\"/public/upload/comment/2018/04-27/5ae2d410caed0.png\";i:4;s:51:\"/public/upload/comment/2018/04-27/5ae2d410cbe12.jpg\";}',510,3,3,3,1,',2',0,575,100),(56,229,'','15247471414','说完话123456',1524816081,'183.11.38.21',1,0,17,'a:3:{i:0;s:68:\"/public/upload/comment/20180427/7aa95e4a51f6d217e372b3682c59ceee.png\";i:1;s:68:\"/public/upload/comment/20180427/5bf5e7c21ccb722257de9202e903cd54.png\";i:2;s:68:\"/public/upload/comment/20180427/446d6ea6e7d337dc59f08a53c6bf6a6b.png\";}',552,2,3,3,0,'',1,NULL,100),(57,220,'424077952@qq.com','15915407197','天空',1524818362,'117.136.79.126',1,0,25,'',555,3,3,3,0,'',1,NULL,100),(58,229,'123','','中国是个好地方中国是个好地方',1524818889,'183.11.38.21',1,0,2,'a:5:{i:0;s:67:\"/public/upload/user/2/comment//b04afb3e73ec918bb17c160040561c98.jpg\";i:1;s:67:\"/public/upload/user/2/comment//8c9da2562848d0aa16fcf407d178380a.jpg\";i:2;s:67:\"/public/upload/user/2/comment//e59797ce26500bc8056135d0ac86f813.jpg\";i:3;s:67:\"/public/upload/user/2/comment//372aff292f5bf5cffcae2631c2186b53.jpg\";i:4;s:67:\"/public/upload/user/2/comment//48bf2da533a84c9c895746f111c86d52.jpg\";}',558,5,4,4,0,'',1,624,100),(59,174,'123','15915407513','他啦啦他徒步不聊了啦他不看看他啊看看家里连连连连连连连连连连连连连连连连连连连连连连连连连连连连连连连连连看看家里连连连看看家里连连连看看家里连连连看看家里连连连看看家里连连连看邋遢他她辣辣啊拉裤不啊啦啦拖拉机看看连连连连连连连连连连连',1524821294,'117.136.79.126',1,0,2,'a:1:{i:0;s:68:\"/public/upload/comment/20180427/e9eb4e2ef0318ea0f9fd756e4a089608.png\";}',566,4,4,4,0,'',0,NULL,100),(60,220,'','15247471414','123456756789123456789123456756789123456789123456756789123456789123456756789123456789123456756789123456789123456756789123',1524822171,'183.11.38.21',1,0,17,'a:3:{i:0;s:68:\"/public/upload/comment/20180427/1fe7cb8631fbdc8147b884cb31b9a9a6.png\";i:1;s:68:\"/public/upload/comment/20180427/f8afa1901cac35412dbecaa1cf7729b6.png\";i:2;s:68:\"/public/upload/comment/20180427/59d03e6bc8ffc11f19a28da28419ef32.png\";}',540,1,3,2,0,'',0,NULL,100),(61,152,'123','15915407513','看看家里连连连聊聊聊聊聊聊',1524822223,'117.136.79.126',1,0,2,'',562,4,4,4,0,'',0,NULL,100),(62,186,'123','15915407513','他啦啦啦连连连连连',1524822265,'117.136.79.126',1,0,2,'a:1:{i:0;s:68:\"/public/upload/comment/20180427/5ab2879cdfb0dcde7cd1a42fa4498381.png\";}',487,4,4,4,0,'',0,NULL,100),(63,234,'123','15915407513','他啦啦鲁啦啦啦',1524822321,'117.136.79.126',1,0,2,'a:1:{i:0;s:68:\"/public/upload/comment/20180427/cd0bb6ebe419311644eb2e1f64cd8d5a.png\";}',480,3,3,4,0,'',0,NULL,100),(64,68,'123','','HHHKJHKJDSHFKHJHFKJSGKJSGFKJG F地负海涵发快递还开会开会空间划分肯定是客户冯绍峰客户康师傅科技客服哈萨克回复开始犯困公开化的看过看过积分是开高三跪九叩购房款国境四方钢结构司法局是高科技高副书记会计师规范健康更舒服恐惧感框架结构开发几首歌开个房勘设股份框架是就开始就奉公克己国际饭店给谁看几个块勘设股份空间感慨看恐惧感会计师购房款开始就规范恐惧感快叫师傅恐惧感刷卡机付过款',1524822623,'183.11.38.21',1,0,2,'a:5:{i:0;s:51:\"/public/upload/comment/2018/04-27/5ae2f25fd9407.jpg\";i:1;s:51:\"/public/upload/comment/2018/04-27/5ae2f25fd9f78.jpg\";i:2;s:51:\"/public/upload/comment/2018/04-27/5ae2f25fda71a.jpg\";i:3;s:51:\"/public/upload/comment/2018/04-27/5ae2f25fdb28b.jpg\";i:4;s:51:\"/public/upload/comment/2018/04-27/5ae2f25fdba2d.jpg\";}',476,3,3,3,1,',2',1,527,100),(65,194,'123','','是飞洒发很快就是否开几个师傅光看sggs',1524822661,'183.11.38.21',1,0,2,NULL,469,3,3,3,0,'',1,518,100),(66,225,'123','15915407513','爽肤水归属感的郭德纲',1524822714,'183.11.38.21',1,0,2,'a:1:{i:0;s:51:\"/public/upload/comment/2018/04-27/5ae2f2ba8815f.jpg\";}',299,3,3,3,0,'',0,328,100),(67,181,'123','','的郭德纲数据库和和可好看了会',1524822750,'183.11.38.21',1,0,2,'a:1:{i:0;s:51:\"/public/upload/comment/2018/04-27/5ae2f2de4b62b.jpg\";}',439,4,4,4,0,'',1,478,100);

UNLOCK TABLES;

/*Table structure for table `tp_config` */

DROP TABLE IF EXISTS `tp_config`;

CREATE TABLE `tp_config` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `name` varchar(50) DEFAULT NULL COMMENT '配置的key键名',
  `value` varchar(512) DEFAULT NULL COMMENT '配置的val值',
  `inc_type` varchar(64) DEFAULT NULL COMMENT '配置分组',
  `desc` varchar(50) DEFAULT NULL COMMENT '描述',
  PRIMARY KEY (`id`)
)  AUTO_INCREMENT=149 DEFAULT CHARSET=utf8;

/*Data for the table `tp_config` */

LOCK TABLES `tp_config` WRITE;

insert  into `tp_config`(`id`,`name`,`value`,`inc_type`,`desc`) values (1,'site_url','http://www.tpshop.cn','shop_info',NULL),(2,'record_no','粤ICP备123456号','shop_info',NULL),(3,'store_name','TPshop开源商城','shop_info',NULL),(5,'store_title','开源商城 | B2C商城 | B2B2C商城 | 三级分销 | 免费商城 | 多用户商城 | tpshop｜thinkphp shop｜TPshop 免费开源系统 | 微商城','shop_info',NULL),(6,'store_desc','TPshop 开源商城 tpshop thinkphp shop B2C商城 B2B2C商城 三级分销 免费商城  微商城 多用户商城 免费开源系统','shop_info',NULL),(7,'store_keyword','开源商城 B2C商城  B2B2C商城  三级分销  多用户商城  免费商城  微商城','shop_info',NULL),(55,'auto_confirm_date','1','shopping',NULL),(8,'contact','张小姐','shop_info',NULL),(9,'phone','0744-12345678','shop_info',NULL),(10,'address','南山区西丽镇留仙大道1001号','shop_info',NULL),(11,'qq','123456789','shop_info',NULL),(12,'qq2','123456789','shop_info',NULL),(13,'qq3','123456789','shop_info',NULL),(14,'freight_free','0','shopping',NULL),(15,'point_rate','10','shopping',NULL),(16,'is_mark','1','water',NULL),(17,'mark_txt','Tpshop商城','water',NULL),(18,'mark_img','/public/upload/water/2018/01-26/9da13305eb67822d8403b13d7fc29827.png','water',NULL),(19,'mark_width','40','water',NULL),(20,'mark_height','40','water',NULL),(21,'mark_degree','40','water',NULL),(22,'mark_quality','100','water',NULL),(23,'sel','9','water',NULL),(24,'sms_url','https://yunpan.cn/OcRgiKWxZFmjSJ','sms',NULL),(25,'sms_user','','sms',NULL),(26,'sms_pwd','访问密码 080e','sms',NULL),(27,'regis_sms_enable','1','sms',NULL),(28,'sms_time_out','300','sms',NULL),(29,'reg_integral','100','basic',NULL),(30,'file_size','2','basic',NULL),(31,'default_storage','100','basic',NULL),(32,'warning_storage','10','basic',NULL),(33,'tax','6','basic',NULL),(34,'is_remind','0','basic',NULL),(35,'order_finish_time','','basic',NULL),(36,'order_cancel_time','','basic',NULL),(37,'hot_keywords','手机|小米|iphone|三星|华为|冰箱','basic',NULL),(38,'__hash__','8d9fea07e44955760d3407524e469255_6ac8706878aa807db7ffb09dd0b02453','sms',NULL),(116,'store_logo','/public/upload/logo/2018/04-09/814d7e9a0eddcf3754f2e8373a50a19c.png','shop_info',NULL),(40,'app_test','0','basic',NULL),(41,'switch','1','distribut',NULL),(42,'condition','0','distribut',NULL),(43,'name','我的分销商','distribut',NULL),(44,'pattern','0','distribut',NULL),(45,'order_rate','20','distribut',NULL),(46,'first_name','一级分销','distribut',NULL),(47,'first_rate','70','distribut',NULL),(48,'second_name','二级分销','distribut',NULL),(49,'second_rate','20','distribut',NULL),(50,'third_name','三级分销','distribut',NULL),(51,'third_rate','10','distribut',NULL),(52,'date','1','distribut',NULL),(53,'need','100','basic',NULL),(54,'min','50','basic',NULL),(56,'sms_appkey','123456','sms',NULL),(57,'sms_secretKey','123456','sms',NULL),(58,'sms_product','TPshop 开源商城','sms',NULL),(59,'sms_templateCode','SMS_101234567890','sms',NULL),(60,'smtp_server','ssl://smtp.qq.com','smtp',NULL),(61,'smtp_port','465','smtp',NULL),(62,'smtp_user','123456@qq.com','smtp',NULL),(63,'smtp_pwd','123456','smtp',NULL),(64,'regis_smtp_enable','1','smtp',NULL),(65,'test_eamil','123456@qq.com','smtp',NULL),(66,'mobile','12345678911','shop_info',NULL),(67,'province','636','shop_info',NULL),(68,'city','1188','shop_info',NULL),(69,'district','1218','shop_info',NULL),(70,'forget_pwd_sms_enable','1','sms',NULL),(71,'bind_mobile_sms_enable','1','sms',NULL),(72,'order_add_sms_enable','0','sms',NULL),(73,'order_pay_sms_enable','0','sms',NULL),(74,'order_shipping_sms_enable','0','sms',NULL),(75,'form_submit','ok','distribut',NULL),(76,'form_submit','ok','shop_info',NULL),(78,'reduce','2','shopping',NULL),(77,'form_submit','ok','shopping',NULL),(79,'form_submit','ok','',NULL),(80,'reg_integral','100','',NULL),(81,'file_size','2','basic',NULL),(82,'default_storage','100','basic',NULL),(84,'need','100','basic',NULL),(85,'min','50','basic',NULL),(86,'tax','6','',NULL),(87,'hot_keywords','手机|小米|iphone|三星|华为|冰箱','basic',NULL),(88,'point_min_limit','10','shopping',NULL),(89,'point_use_percent','100','shopping',NULL),(90,'inc_type','smtp','smtp',NULL),(91,'mark_type','text','water',NULL),(92,'need','100','basic',NULL),(93,'min','50','basic',NULL),(115,'integral_use_enable','1','shopping',NULL),(94,'form_submit','ok','push',NULL),(95,'jpush_app_key','123456','push',NULL),(96,'jpush_master_secret','123456','push',NULL),(98,'sms_platform','2','sms',NULL),(99,'form_submit','ok','oss',NULL),(100,'oss_key_id','123456','oss',NULL),(101,'oss_key_secret','1','oss',NULL),(102,'oss_endpoint','oss-cn-shenzhen.aliyuncs.com','oss',NULL),(103,'oss_bucket','how1','oss',NULL),(104,'android_app_path','public/upload/appfile/androidapp_0.12.1_170706_104041.apk','mobile_app',NULL),(105,'android_app_version','0.12.1','mobile_app',NULL),(106,'android_app_log','测试日记','mobile_app',NULL),(107,'oss_switch','0','oss',NULL),(110,'qrcode_menu_word','distribut_qrcode','distribut',NULL),(108,'mark_txt_size','12','water',NULL),(109,'mark_txt_color','#000000','water',NULL),(111,'qrcode_input_word','我的二维码','distribut',NULL),(112,'qr_back','/public/upload/weixin/2017/10-27/e9823d589b202818c86511be60a6b65a.jpg','distribut',NULL),(113,'qr_big_back','/public/upload/weixin/2017/10-27/ddbf260c88c706b38473dc6972b66c42.jpg','distribut',NULL),(114,'auto_service_date','16','shopping',NULL),(117,'invite','1','basic',NULL),(118,'invite_integral','200','basic',NULL),(125,'store_ico','/public/upload/logo/2018/04-09/516bc70315079d81dc3726991672b4af.png','shop_info',NULL),(119,'store_user_logo','/public/upload/logo/2018/04-17/570c1284f663ce3fad34e819d430b428.png','shop_info',NULL),(120,'sign_on_off','1','sign',NULL),(121,'sign_integral','10','sign',NULL),(122,'sign_signcount','7','sign',NULL),(123,'sign_award','20','sign',NULL),(124,'own_rate','10','distribut',NULL),(126,'regrade','1','distribut',NULL),(127,'rechargevip_on_off','1','basic',NULL),(128,'rechargevip_price','1','basic',NULL),(129,'rechargevip_rebate_on_off','0','basic',NULL),(130,'rechargevip_rebate','1','basic',NULL),(131,'is_bind_account','0','basic',NULL),(132,'virtual_goods_sms_enable','1','sms',NULL),(133,'form_submit','ok','kdniao',NULL),(134,'kdniao_switch','1','kdniao',NULL),(135,'kdniao_id','123456','express',NULL),(136,'kdniao_key','123456','express',NULL),(137,'form_submit','ok','express',NULL),(138,'express_switch','0','express',NULL),(139,'kd100_key','123456','express',NULL),(140,'kdniao_id','123456','express',NULL),(141,'kdniao_key','123456','express',NULL),(142,'admin_login_logo','/public/static/images/logo/admin_login_logo_default.png','shop_info',NULL),(143,'admin_home_logo','/public/upload/logo/2018/04-10/da91523a817bc5adcb2c4c123bbf6e3f.png','shop_info',NULL),(144,'wap_home_logo','/public/static/images/logo/wap_home_logo_default.png','shop_info',NULL),(145,'wap_login_logo','/public/upload/logo/2018/03-16/f3e95de4bf31b237ee7ca125053f84b8.png','shop_info',NULL),(146,'t_number','687474703a2f2f61706974657374322e747073686f702e636e2f686f6d652f546a2f7032',NULL,NULL),(147,'point_rate','10','integral',NULL),(148,'header_background','#dd0f20','basic',NULL);

UNLOCK TABLES;

/*Table structure for table `tp_coupon` */

DROP TABLE IF EXISTS `tp_coupon`;

CREATE TABLE `tp_coupon` (
  `id` int(8) NOT NULL AUTO_INCREMENT COMMENT '表id',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '优惠券名字',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '发放类型 0下单赠送1 指定发放 2 免费领取 3线下发放',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '优惠券金额',
  `condition` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '使用条件',
  `createnum` int(11) DEFAULT '0' COMMENT '发放数量',
  `send_num` int(11) DEFAULT '0' COMMENT '已领取数量',
  `use_num` int(11) DEFAULT '0' COMMENT '已使用数量',
  `send_start_time` int(11) DEFAULT NULL COMMENT '发放开始时间',
  `send_end_time` int(11) DEFAULT NULL COMMENT '发放结束时间',
  `use_start_time` int(11) DEFAULT NULL COMMENT '使用开始时间',
  `use_end_time` int(11) DEFAULT NULL COMMENT '使用结束时间',
  `add_time` int(11) DEFAULT NULL COMMENT '添加时间',
  `status` int(2) DEFAULT NULL COMMENT '状态：1有效,2无效',
  `use_type` tinyint(1) DEFAULT '0' COMMENT '使用范围：0全店通用1指定商品可用2指定分类商品可用',
  PRIMARY KEY (`id`),
  KEY `use_end_time` (`use_end_time`)
)  AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

/*Data for the table `tp_coupon` */

LOCK TABLES `tp_coupon` WRITE;

insert  into `tp_coupon`(`id`,`name`,`type`,`money`,`condition`,`createnum`,`send_num`,`use_num`,`send_start_time`,`send_end_time`,`use_start_time`,`use_end_time`,`add_time`,`status`,`use_type`) values (1,'春夏秋冬',2,20.00,100.00,10,8,5,1523157468,1526440668,1523243868,1528600668,1523330330,1,0),(2,'优惠券',0,30.00,100.00,0,0,0,1523440158,1525945758,1523440158,1528624158,1523353798,1,0),(3,'成都',0,100.00,200.00,3,1,1,1524023549,1526529149,1523850749,1529207549,1523937168,1,0),(4,'来如',2,30.00,200.00,100,2,3,1523861827,1526540227,1523861827,1529218627,1523948258,1,0),(5,'点点滴滴',1,15.00,60.00,10,10,1,1523949082,1526541082,1524035482,1529219482,1523949134,1,1),(6,'大优惠',2,90.00,500.00,10,3,1,1524014340,1526541082,1524013463,1529219482,1523949143,1,2),(7,'来吧',2,100.00,500.00,0,3,2,1523949162,1526541162,1524035562,1529219562,1523949178,1,0),(8,'指定商品',2,40.00,200.00,0,2,1,1523868674,1526547074,1523868674,1529225474,1523955149,1,1),(9,'指定分类',2,50.00,200.00,60,1,0,1523955173,1526547173,1523955173,1529225573,1523955241,1,2),(10,'下单赠送',0,10.00,90.00,9,0,0,1524099469,1526605069,1524013069,1529283469,1524013103,1,0),(11,'冷血',0,10.00,100.00,9,0,0,1524099674,1526605274,1524099674,1529283674,1524013294,1,0),(12,'54444',0,10.00,100.00,100,0,0,1524099772,1526605372,1524099772,1529283772,1524013397,1,0),(13,'下单即可送券',0,30.00,100.00,10,0,0,1524101087,1526606687,1524101087,1529285087,1524014743,1,1),(14,'下单即可送优惠券',0,30.00,100.00,100,1,1,1524101087,1526606687,1524014687,1529285087,1524014793,1,0),(15,'线下优惠券',3,100.00,200.00,0,10,2,1524030833,1526622833,1524030833,1529301233,1524030858,1,0),(16,'ABC',3,50.00,200.00,100,21,2,1524033134,1526625150,1524033138,1529303550,1524033192,1,0),(17,'0',0,0.00,0.00,0,0,0,1524120092,1526625692,1524120092,1529304092,1524033705,1,0),(18,'指定电脑',2,10.00,100.00,0,3,0,1524123558,1526629158,1524067200,1529307558,1524037204,1,2),(19,'123',2,50.00,200.00,0,1,0,1524046043,1526638065,1524046047,1529316465,1524046110,1,2),(20,'拼团',2,20.00,50.00,0,11,0,1524106842,1526701542,1524110202,1529380602,1524110261,1,1),(21,'yuyuyu',1,10.00,100.00,6,3,0,1524116231,1524202631,1524116231,1524202631,1524116390,1,0),(22,'434',0,3434.00,3434.00,3434,0,0,1524280961,1526786561,1524280961,1529464961,1524194568,1,0),(23,'434',2,10.00,100.00,3,2,1,1524282285,1526787885,1524282285,1529466285,1524195927,1,0),(24,'ADB',2,100.00,500.00,100,2,0,1524203275,1526795279,1524203279,1529473679,1524203338,1,2),(25,'下单即可赠送优惠券',0,10.00,10.00,10,3,3,1524289778,1526795378,1524203405,1529473778,1524203446,1,0),(26,'指定商品海信',1,100.00,500.00,10,7,0,1524792649,1527298249,1524792649,1529976649,1524706327,1,1),(28,'指定商品下单你送',2,10.00,100.00,0,2,1,1524726294,1527318294,1524726294,1529996694,1524726369,1,1),(29,'指定商品下单',1,10.00,99.00,10,10,0,1524809152,1527401145,1524809145,1530079545,1524809198,1,1),(32,'11111',2,100.00,1000.00,0,1,0,1524816329,1527408331,1524816331,1530086731,1524816360,1,0),(31,'指定商品下单1',1,10.00,100.00,3,3,0,1524809462,1527401458,1524809458,1530079858,1524809750,1,1);

UNLOCK TABLES;

/*Table structure for table `tp_coupon_list` */

DROP TABLE IF EXISTS `tp_coupon_list`;

CREATE TABLE `tp_coupon_list` (
  `id` int(8) NOT NULL AUTO_INCREMENT COMMENT '表id',
  `cid` int(8) NOT NULL DEFAULT '0' COMMENT '优惠券 对应coupon表id',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '发放类型 1 按订单发放 2 注册 3 邀请 4 按用户发放',
  `uid` int(8) NOT NULL DEFAULT '0' COMMENT '用户id',
  `order_id` int(8) NOT NULL DEFAULT '0' COMMENT '订单id',
  `get_order_id` int(11) DEFAULT '0' COMMENT '优惠券来自订单ID',
  `use_time` int(11) NOT NULL DEFAULT '0' COMMENT '使用时间',
  `code` varchar(10) DEFAULT '' COMMENT '优惠券兑换码',
  `send_time` int(11) NOT NULL DEFAULT '0' COMMENT '发放时间',
  `status` tinyint(1) DEFAULT '0' COMMENT '0未使用1已使用2已过期',
  PRIMARY KEY (`id`),
  KEY `cid` (`cid`),
  KEY `uid` (`uid`),
  KEY `code` (`code`),
  KEY `order_id` (`order_id`)
)  AUTO_INCREMENT=116 DEFAULT CHARSET=utf8;

/*Data for the table `tp_coupon_list` */

LOCK TABLES `tp_coupon_list` WRITE;

insert  into `tp_coupon_list`(`id`,`cid`,`type`,`uid`,`order_id`,`get_order_id`,`use_time`,`code`,`send_time`,`status`) values (1,1,2,4,0,0,0,'',1523330394,0),(3,1,2,2,82,0,1523956158,'',1523949672,1),(4,8,2,3,83,0,1523956270,'',1523955386,1),(5,4,2,3,85,0,1523958311,'',1523955394,1),(6,1,2,3,81,0,1523955774,'',1523955398,1),(7,1,2,1,0,0,0,'',1523959281,0),(8,5,1,11,0,0,0,'',1523959470,0),(9,5,1,10,0,0,0,'',1523959470,0),(10,5,1,9,0,0,0,'',1523959470,0),(11,5,1,8,0,0,0,'',1523959470,0),(12,5,1,7,0,0,0,'',1523959470,0),(13,5,1,6,0,0,0,'',1523959470,0),(14,5,1,5,0,0,0,'',1523959470,0),(15,5,1,4,0,0,0,'',1523959470,0),(16,5,1,3,324,0,1524455996,'',1523959470,1),(17,5,1,2,0,0,0,'',1523959470,0),(18,7,2,1,0,0,0,'',1523960149,0),(19,7,2,2,470,0,1524732058,'',1523964037,1),(20,8,2,2,0,0,0,'',1523964044,0),(21,4,2,2,126,0,1524039515,'',1523979222,1),(22,6,2,2,115,0,1524035008,'',1524014410,1),(24,3,0,3,124,98,1524037060,'',1524021780,1),(23,6,2,3,0,0,0,'',1524017285,0),(25,15,3,2,107,0,1524030988,'JF8qiEpl',1524030889,1),(26,15,3,2,116,0,1524035538,'gbDnP9tD',1524030889,1),(27,15,3,0,0,0,0,'Pkdqatev',1524030889,0),(28,15,3,0,0,0,0,'b65qeCCb',1524030889,0),(29,15,3,0,0,0,0,'4uS9CCjc',1524030889,0),(30,15,3,0,0,0,0,'lGFbhwKl',1524030889,0),(31,15,3,0,0,0,0,'NCbpqdnb',1524030889,0),(32,15,3,0,0,0,0,'4L2iaj2S',1524030889,0),(33,15,3,0,0,0,0,'ewL8yvHA',1524030889,0),(34,15,3,0,0,0,0,'F6DHsFtb',1524030889,0),(35,16,3,3,451,0,1524722541,'GtAgpcn2',1524033204,1),(36,16,3,0,0,0,0,'fNC9M3ey',1524033204,0),(37,16,3,0,0,0,0,'v2K53lsK',1524033204,0),(38,16,3,0,0,0,0,'Co136K9n',1524033204,0),(39,16,3,0,0,0,0,'6qbFmxKi',1524033204,0),(40,16,3,0,0,0,0,'i7aNbd53',1524033204,0),(41,16,3,0,0,0,0,'4ldBzAut',1524033204,0),(42,16,3,0,0,0,0,'Pk2dMcy1',1524033204,0),(43,16,3,0,0,0,0,'AMAt4SP2',1524033204,0),(44,16,3,0,0,0,0,'pDMQJQPq',1524033204,0),(45,16,3,0,0,0,0,'1Dc2Fwvu',1524033402,0),(46,16,3,0,0,0,0,'j1JL1SCq',1524033402,0),(47,16,3,0,0,0,0,'awzDPqKl',1524033402,0),(48,16,3,0,0,0,0,'2zhBh2MA',1524033402,0),(49,16,3,0,0,0,0,'GF5mzn3z',1524033402,0),(50,16,3,0,0,0,0,'Eeh9oEN8',1524033402,0),(51,16,3,0,0,0,0,'xtaawH4g',1524033402,0),(52,16,3,0,0,0,0,'Jug23vAy',1524033402,0),(53,16,3,0,0,0,0,'FqM7mS95',1524033402,0),(54,16,3,0,0,0,0,'wjtkKw4a',1524033402,0),(55,16,3,0,0,0,0,'Lb46ycKh',1524033575,0),(56,7,2,3,0,0,0,'',1524037105,0),(57,14,0,2,135,131,1524043209,'',1524041611,1),(58,20,3,0,0,0,0,'13owQNG4',1524110292,0),(59,20,3,0,0,0,0,'LmQjMgxE',1524110292,0),(60,20,3,0,0,0,0,'nF5Ltn25',1524110292,0),(61,20,3,0,0,0,0,'G147ukk8',1524110292,0),(62,20,3,0,0,0,0,'EJhgygou',1524110292,0),(63,20,3,0,0,0,0,'EuHd4yLL',1524110292,0),(64,20,3,0,0,0,0,'1NewrTfl',1524110292,0),(65,20,3,0,0,0,0,'CSxqBC1H',1524110292,0),(66,20,3,0,0,0,0,'pcwKsJrh',1524110292,0),(67,21,1,5,0,0,0,'',1524117317,0),(68,21,1,3,0,0,0,'',1524117317,0),(69,21,1,1,0,0,0,'',1524117317,0),(70,18,2,2,0,0,0,'',1524208370,0),(71,6,2,9,0,0,0,'',1524212971,0),(72,18,2,9,0,0,0,'',1524212974,0),(73,24,2,10,0,0,0,'',1524448792,0),(74,1,2,10,341,0,1524471718,'',1524470195,1),(75,19,2,2,0,0,0,'',1524647424,0),(76,9,2,2,0,0,0,'',1524647441,0),(77,20,2,2,0,0,0,'',1524650343,0),(78,24,2,2,0,0,0,'',1524650349,0),(79,23,2,2,429,0,1524650374,'',1524650352,1),(80,26,1,18,0,0,0,'',1524706427,0),(81,26,1,17,0,0,0,'',1524706427,0),(82,26,1,15,0,0,0,'',1524706427,0),(83,26,1,12,0,0,0,'',1524706427,0),(84,26,1,9,0,0,0,'',1524706427,0),(85,26,1,8,0,0,0,'',1524706427,0),(91,29,1,26,0,0,0,'',1524809217,0),(87,28,2,2,453,0,1524726570,'',1524726404,1),(88,25,0,2,508,453,1524798257,'',1524726651,1),(89,18,2,22,0,0,0,'',1524727826,0),(90,1,2,17,501,0,1524795449,'',1524793023,1),(92,29,1,25,0,0,0,'',1524809217,0),(93,29,1,24,0,0,0,'',1524809217,0),(94,29,1,23,0,0,0,'',1524809217,0),(95,29,1,22,0,0,0,'',1524809217,0),(96,29,1,21,0,0,0,'',1524809217,0),(97,29,1,20,0,0,0,'',1524809217,0),(98,29,1,19,0,0,0,'',1524809217,0),(99,29,1,18,0,0,0,'',1524809217,0),(100,29,1,17,0,0,0,'',1524809217,0),(109,31,1,16,0,0,0,'',1524809947,0),(108,25,0,17,540,538,1524810889,'',1524809868,1),(107,31,1,1,0,0,0,'',1524809858,0),(106,31,1,2,0,0,0,'',1524809814,0),(110,1,2,23,0,0,0,'',1524812701,0),(111,32,2,25,0,0,0,'',1524816382,0),(112,28,2,25,0,0,0,'',1524823260,0),(113,23,2,25,0,0,0,'',1524823263,0),(114,20,2,25,0,0,0,'',1524823266,0),(115,25,0,23,0,543,0,'',1530613665,0);

UNLOCK TABLES;

/*Table structure for table `tp_delivery_doc` */

DROP TABLE IF EXISTS `tp_delivery_doc`;

CREATE TABLE `tp_delivery_doc` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '发货单ID',
  `order_id` int(11) unsigned NOT NULL COMMENT '订单ID',
  `order_sn` varchar(64) NOT NULL DEFAULT '' COMMENT '订单编号',
  `user_id` int(11) unsigned NOT NULL COMMENT '用户ID',
  `admin_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `consignee` varchar(64) NOT NULL DEFAULT '' COMMENT '收货人',
  `zipcode` varchar(6) DEFAULT NULL COMMENT '邮编',
  `mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '联系手机',
  `country` int(11) unsigned NOT NULL COMMENT '国ID',
  `province` int(11) unsigned NOT NULL COMMENT '省ID',
  `city` int(11) unsigned NOT NULL COMMENT '市ID',
  `district` int(11) unsigned NOT NULL COMMENT '区ID',
  `address` varchar(255) NOT NULL DEFAULT '' COMMENT '地址',
  `shipping_code` varchar(32) DEFAULT NULL COMMENT '物流code',
  `shipping_name` varchar(64) DEFAULT NULL COMMENT '快递名称',
  `shipping_price` decimal(10,2) DEFAULT '0.00' COMMENT '运费',
  `invoice_no` varchar(255) DEFAULT '' COMMENT '物流单号',
  `tel` varchar(64) DEFAULT NULL COMMENT '座机电话',
  `note` text COMMENT '管理员添加的备注信息',
  `best_time` int(11) DEFAULT NULL COMMENT '友好收货时间',
  `create_time` int(11) NOT NULL COMMENT '创建时间',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  `send_type` tinyint(1) DEFAULT '0' COMMENT '发货方式0自填快递1在线预约2电子面单3无需物流',
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `user_id` (`user_id`)
)  AUTO_INCREMENT=143 DEFAULT CHARSET=utf8 COMMENT='发货单';

/*Data for the table `tp_delivery_doc` */

LOCK TABLES `tp_delivery_doc` WRITE;

insert  into `tp_delivery_doc`(`id`,`order_id`,`order_sn`,`user_id`,`admin_id`,`consignee`,`zipcode`,`mobile`,`country`,`province`,`city`,`district`,`address`,`shipping_code`,`shipping_name`,`shipping_price`,`invoice_no`,`tel`,`note`,`best_time`,`create_time`,`is_del`,`send_type`) values (1,6,'201804101812348362',2,1,'小傅','511111','0775-86140485',0,28240,28558,28590,'西城工业区12栋','shunfeng','顺丰快递',10.00,'152862542',NULL,'',NULL,1523355371,0,0),(2,7,'201804101826252337',2,1,'小傅','511111','0775-86140485',0,28240,28558,28590,'西城工业区12栋','yuantong','顺丰快递',10.00,'5853467812',NULL,'',NULL,1523356099,0,3),(3,7,'201804101826252337',2,1,'小傅','511111','0775-86140485',0,28240,28558,28590,'西城工业区12栋','yuantong','顺丰快递',10.00,'5853467812',NULL,'',NULL,1523356111,0,0),(4,7,'201804101826252337',2,1,'小傅','511111','0775-86140485',0,28240,28558,28590,'西城工业区12栋','yuantong','顺丰快递',10.00,'5853467812',NULL,'',NULL,1523356123,0,0),(5,13,'201804131117304233',5,1,'直径4CM棒棒','','13800138006',0,636,1188,1190,'棒棒','shunfeng','顺丰快递',0.00,'23141341234124124',NULL,'',NULL,1523589647,0,0),(6,19,'201804161128259177',2,1,'xiaoxiao','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',9.00,'1582182825',NULL,'',NULL,1523849410,0,0),(7,17,'201804161103588183',2,1,'xiaoxiao','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',0.00,'',NULL,'',NULL,1523849538,0,3),(8,17,'201804161103588183',2,1,'xiaoxiao','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',0.00,'21121212121',NULL,'212121',NULL,1523849541,0,0),(9,20,'201804161140465340',2,1,'fuman','518688','15915407513',0,28240,28558,28590,'西乡西城工业区12栋','ZTO	','中通快递',10.00,'85441225633',NULL,'23232323233223',NULL,1523850324,0,0),(10,23,'201804161150416733',2,1,'xiaoxiao','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',9.00,'',NULL,'',NULL,1523850886,0,3),(11,24,'201804161154003219',2,1,'fuman','518688','15915407513',0,28240,28558,28590,'西乡西城工业区12栋','shunfeng','顺丰快递',0.00,'',NULL,'',NULL,1523850941,0,3),(12,21,'201804161143212439',2,1,'xiaoxiao','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',0.00,'',NULL,'',NULL,1523851184,0,3),(13,26,'201804161340359763',2,1,'xiaoxiao','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',0.00,'',NULL,'',NULL,1523857432,0,3),(14,27,'201804161416314339',2,1,'xiaoxiao','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',0.00,'1285537',NULL,'',NULL,1523859491,0,0),(15,15,'201804161053369673',2,1,'xiaoxiao','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',8.00,'',NULL,'',NULL,1523860241,0,3),(16,31,'201804161645066554',2,1,'fuman','518688','15915407513',0,28240,28558,28590,'西乡西城工业区12栋','YD','韵达快递',10.00,'123456789123456',NULL,'',NULL,1523868707,0,0),(17,32,'201804161703083123',2,1,'xiaoxiao','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',9.00,'4454554545454',NULL,'433434343434',NULL,1523869624,0,0),(18,33,'201804161713217993',2,1,'xiaoxiao','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',0.00,'',NULL,'',NULL,1523870108,0,3),(19,35,'201804161734549372',2,1,'xiaoxiao','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',9.00,'12855638',NULL,'',NULL,1523871330,0,0),(20,36,'201804161748302156',2,1,'xiaoxiao','600500','15915407513',0,636,637,639,'建北大桥15号','YTO','圆通快递',0.00,'12852356853',NULL,'',NULL,1523873214,0,0),(21,41,'201804170931452774',2,1,'xiaoxiao','600500','15915407513',0,636,637,639,'建北大桥15号','YZPY','中国邮政',0.00,'135882828',NULL,'',NULL,1523928744,0,0),(22,40,'201804161812508910',2,1,'xiaoxiao','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',0.00,'18282485',NULL,'',NULL,1523928927,0,0),(23,44,'201804170954098826',2,1,'xiaoxiao','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',0.00,'585555522255',NULL,'二位二无无',NULL,1523930113,0,0),(24,39,'201804161811142032',2,1,'xiaoxiao','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',0.00,'1582825',NULL,'',NULL,1523930780,0,0),(25,47,'201804171015189381',2,1,'xiaoxiao','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',9.00,'28552',NULL,'',NULL,1523931344,0,0),(26,57,'201804171128591999',1,1,'xiaoxiao','51828','15915407513',0,1,300,322,'西城工业区12栋','shunfeng','顺丰快递',0.00,'18282855',NULL,'',NULL,1523935956,0,0),(27,62,'201804171149479728',1,1,'苏苏','518282','15915407513',0,1,2,3,'黄田岗贝工业区12栋','shunfeng','顺丰快递',0.00,'1582822',NULL,'',NULL,1523937230,0,0),(28,81,'201804171702545505',3,1,'咖啡','123456','18516589423',0,45753,45871,45903,'站北地区11号大街','YD','韵达快递',0.00,'85411222556333',NULL,'',NULL,1523955870,0,0),(29,85,'201804171745113240',3,1,'咖啡','123456','15274851694',0,45753,45871,45903,'站北地区11号大街','shunfeng','顺丰快递',0.00,'9552236652',NULL,'232323',NULL,1523958370,0,0),(30,90,'201804180909434096',3,1,'咖啡','123456','15274851694',0,45753,45871,45903,'站北地区11号大街','YD','韵达快递',0.00,'85441222355',NULL,'选择种类:选择5斤装 种类:礼品盒装',NULL,1524013871,0,0),(31,94,'201804180950326430',3,1,'咖啡','123456','15274851694',0,45753,45871,45903,'站北地区11号大街','YTO','圆通快递',0.00,'854411255855',NULL,'223232323',NULL,1524016263,0,0),(32,93,'201804180948035281',3,1,'咖啡','123456','15274851694',0,45753,45871,45903,'站北地区11号大街','YD','韵达快递',0.00,'855411225563',NULL,'',NULL,1524016637,0,0),(33,92,'201804180947382514',2,1,'SH2','600500','15915407513',0,636,637,639,'建北大桥15号','YTO','圆通快递',0.00,'1828282',NULL,'',NULL,1524017953,0,0),(34,98,'201804181121369575',3,1,'咖啡','123456','15274851694',0,45753,45871,45903,'站北地区11号大街','YTO','圆通快递',0.00,'854412255633252',NULL,'32323232323',NULL,1524021770,0,0),(35,114,'201804181458196582',2,1,'SH2','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',0.00,'18582',NULL,'',NULL,1524034778,0,0),(36,117,'201804181513283173',2,1,'SH2','600500','15915407513',0,636,637,639,'建北大桥15号','YD','韵达快递',0.00,'18282',NULL,'',NULL,1524035643,0,0),(37,123,'201804181530167823',3,1,'夏夏','','15274851694',0,1,2,3,'1234','YD','韵达快递',18.00,'8554422255336',NULL,'',NULL,1524036736,0,0),(38,128,'201804181622465608',12,1,'夏夏','','15274851694',0,1,2,3,'123456489','YTO','圆通快递',0.00,'85544222555',NULL,'454454554788877',NULL,1524039947,0,0),(39,131,'201804181646357002',2,1,'SH2','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',0.00,'2852502',NULL,'',NULL,1524041606,0,0),(40,132,'201804181654351025',2,1,'SH2','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',0.00,'2585582',NULL,'',NULL,1524042234,0,0),(41,135,'201804181720092802',2,1,'SH2','600500','15915407513',0,636,637,639,'建北大桥15号','YTO','圆通快递',0.00,'58252',NULL,'',NULL,1524043235,0,0),(42,138,'201804181740351558',3,1,'咖啡','123456','15274851694',0,3102,3379,3395,'站北地区11号大街','YD','韵达快递',0.00,'565656656',NULL,'5665',NULL,1524044872,0,0),(43,141,'201804181811562550',2,1,'SH2','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',0.00,'258582',NULL,'',NULL,1524046336,0,0),(44,124,'201804181537404906',3,1,'咖啡','123456','15274851694',0,636,1188,1208,'站北地区11号大街','YZPY','中国邮政',0.00,'2825822',NULL,'',NULL,1524047505,0,0),(45,77,'201804171603071811',1,1,'对对对','518285','15915407513',0,636,936,938,'新城成','YZPY','中国邮政',0.00,'2858282',NULL,'',NULL,1524047505,0,0),(46,147,'201804190936185031',2,1,'SH2','600500','15915407513',0,636,637,639,'建北大桥15号','YD','韵达快递',0.00,'85441422285',NULL,'8885541225',NULL,1524103831,0,0),(47,170,'201804191131363872',1,1,'小小','518284','15915407513',0,3102,3224,3225,'西城工业区12栋','YTO','圆通快递',0.00,'1828258514',NULL,'',NULL,1524108729,0,0),(48,169,'201804191135088117',1,1,'小小','518284','15915407513',0,3102,3224,3225,'西城工业区12栋','shunfeng','顺丰快递',0.00,'585825',NULL,'',NULL,1524109891,0,0),(49,201,'201804191446213375',10,1,'傅慢','','15915407513',0,17359,18829,18949,'他提供啦太可怜了','shunfeng','顺丰快递',0.00,'258582',NULL,'',NULL,1524121280,0,0),(50,195,'201804191427531531',9,1,'1234','','18515252525',0,14234,14687,14764,'123456789','YD','韵达快递',0.00,'85441122552366',NULL,'',NULL,1524121541,0,0),(51,183,'201804191405212235',3,1,'xiasj','600255','18516589423',0,28240,28558,28581,'433434344','YD','韵达快递',0.00,'85441122552367',NULL,'',NULL,1524121541,0,0),(52,188,'201804191410534924',2,1,'SH2','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',0.00,'285202',NULL,'',NULL,1524122375,0,0),(53,205,'201804191523415828',2,1,'SH2','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',0.00,'58282',NULL,'',NULL,1524122982,0,0),(54,199,'201804191439479569',10,1,'傅慢','','15915407513',0,17359,18829,18949,'他提供啦太可怜了','shunfeng','顺丰快递',0.00,'28828',NULL,'',NULL,1524123026,0,0),(55,213,'201804191540599893',2,1,'SH2','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',0.00,'258522',NULL,'',NULL,1524123871,0,0),(56,210,'201804191538171030',10,1,'傅慢','','15915407513',0,17359,18829,18949,'他提供啦太可怜了','shunfeng','顺丰快递',0.00,'28522',NULL,'',NULL,1524123895,0,0),(57,227,'201804191641409909',9,1,'1234','','18515252525',0,14234,14687,14764,'123456789','YD','韵达快递',10.00,'12345677',NULL,'',NULL,1524127708,0,0),(58,222,'201804191632098352',3,1,'咖啡','123456','15274851694',0,3102,3379,3395,'站北地区11号大街','zhongtong','中通快递',9.00,'85542255633255',NULL,'23232323',NULL,1524128753,0,0),(59,254,'201804201422393062',3,1,'咖啡','123456','15274851694',0,3102,3379,3395,'站北地区11号大街','YTO','圆通快递',0.00,'855222366966622',NULL,'223232323',NULL,1524205452,0,0),(60,257,'201804201444127651',3,1,'咖啡','123456','15274851694',0,3102,3379,3395,'站北地区11号大街','YD','韵达快递',0.00,'343344455445',NULL,'4554',NULL,1524206694,0,0),(61,258,'201804201504303648',9,1,'夏夏','','15274851694',0,1,2,3,'123456786','YTO','圆通快递',0.00,'85541122532366',NULL,'334343434',NULL,1524207913,0,0),(62,261,'201804201516472940',9,1,'夏夏','','15274851694',0,1,2,3,'123456786','YD','韵达快递',0.00,'85541225566',NULL,'8555',NULL,1524208756,0,0),(63,276,'201804201626314342',10,1,'小红帽','182820','15915407513',0,28240,28558,28590,'西乡西城工业区12栋','shunfeng','顺丰快递',10.00,'85852',NULL,'',NULL,1524212921,0,0),(64,274,'201804201622259675',10,1,'小红帽','182820','15915407513',0,28240,28558,28590,'西乡西城工业区12栋','YTO','圆通快递',10.00,'285828282',NULL,'',NULL,1524213362,0,0),(65,268,'201804201602569047',9,1,'夏夏','','15274851694',0,1,2,3,'123456786','YD','韵达快递',0.00,'8554125522966',NULL,'43343434',NULL,1524213941,0,0),(66,267,'201804201601104633',9,1,'夏夏','','15274851694',0,1,2,3,'123456786','YTO','圆通快递',0.00,'85422366688',NULL,'855422',NULL,1524214354,0,0),(67,299,'201804201759055459',2,1,'SH2','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',9.00,'858285225',NULL,'',NULL,1524218541,0,0),(68,298,'201804201756461015',10,1,'小红帽','182820','15915407513',0,28240,28558,28590,'西乡西城工业区12栋','YTO','圆通快递',10.00,'1885825',NULL,'',NULL,1524218568,0,0),(69,323,'201804231156477263',10,1,'小红帽','182820','15915407513',0,28240,28558,28590,'西乡西城工业区12栋','YD','韵达快递',10.00,'123456',NULL,'',NULL,1524456047,0,0),(70,315,'201804231057135002',10,1,'小红帽','182820','15915407513',0,28240,28558,28590,'西乡西城工业区12栋','shunfeng','顺丰快递',55.00,'858285',NULL,'',NULL,1524462020,0,0),(71,315,'201804231057135002',10,1,'小红帽','182820','15915407513',0,28240,28558,28590,'西乡西城工业区12栋','shunfeng','顺丰快递',55.00,'858285',NULL,'',NULL,1524462020,0,0),(72,325,'201804231345569849',10,1,'小红帽','182820','15915407513',0,28240,28558,28590,'西乡西城工业区12栋','shunfeng','顺丰快递',0.00,'288582',NULL,'',NULL,1524462854,0,0),(73,327,'201804231429051062',10,1,'方法','582','15915407513',0,28240,28558,28590,'西城工业区12栋','shunfeng','顺丰快递',0.00,'12858282',NULL,'',NULL,1524465065,0,0),(74,329,'201804231453528829',3,1,'咖啡','123456','15274851694',0,5827,6476,6488,'站北地区11号大街12号','YTO','圆通快递',0.00,'85412336633566',NULL,'红豆熬的烂',NULL,1524466496,0,0),(75,338,'201804231546346994',10,1,'dfds','85582','15915407513',0,28240,28241,28243,'dgdgdg','YTO','圆通快递',0.00,'85827885',NULL,'',NULL,1524469647,0,0),(76,351,'201804241150159981',2,1,'SH2','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',9.00,'288852',NULL,'',NULL,1524541870,0,0),(77,353,'201804241202315315',1,1,'25825','28582','15915407513282',0,1,2,14,'28582','YD','韵达快递',19.00,'8554111222544',NULL,'多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递多规格衣服的的快递',NULL,1524548468,0,0),(78,353,'201804241202315315',1,1,'25825','28582','15915407513282',0,1,2,14,'28582','zhongtong','中通快递',19.00,'96665523368',NULL,'2323',NULL,1524548549,0,0),(79,356,'201804241451186379',3,18,'华晨宇','600255','18516589423',0,7531,7706,7708,'1233455','YZPY','中国邮政',0.00,'8554122555222',NULL,'56565656565656556',NULL,1524553154,0,0),(80,357,'201804241507495471',3,18,'罗华','600','18515453456',0,7531,7986,8008,'34343434334','zhongtong','中通快递',0.00,'85541255522225',NULL,'1212122121212121',NULL,1524553720,0,0),(81,358,'201804241541069985',2,1,'SH2','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',9.00,'28582',NULL,'',NULL,1524555692,0,0),(82,359,'201804241542003139',17,18,'夏夏','','15274851694',0,1,2,14,'124547785555666','zhongtong','中通快递',13.00,'23232323333223',NULL,'232323323',NULL,1524555814,0,0),(83,359,'201804241542003139',17,18,'夏夏','','15274851694',0,1,2,14,'124547785555666','zhongtong','顺丰快递',13.00,'23232323333223',NULL,'8554112255',NULL,1524555886,0,0),(84,364,'201804241628587011',3,1,'咖啡','123456','15274851694',0,5827,6476,6488,'站北地区11号大街12号','YTO','圆通快递',10.00,'8855555555544',NULL,'85555558252',NULL,1524558608,0,0),(85,388,'201804250852158739',3,1,'咖啡','123456','15274851694',0,1,2,14,'站北地区11号大街12号','YTO','圆通快递',8.00,'855444522556333',NULL,'3435432',NULL,1524617640,0,0),(86,406,'201804251521438147',2,1,'SH2','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',0.00,'28255825',NULL,'',NULL,1524640951,0,0),(87,410,'201804251540442415',3,1,'咖啡','123456','15274851694',0,1,2,14,'站北地区11号大街12号','shunfeng','顺丰快递',0.00,'8555252253366',NULL,'',NULL,1524642071,0,0),(88,416,'201804251550211718',2,1,'SH2','600500','15915407513',0,636,637,639,'建北大桥15号','shunfeng','顺丰快递',0.00,'28855',NULL,'',NULL,1524642658,0,0),(89,418,'201804251635489652',1,1,'FUMAN','58282','159154075135',0,338,339,347,'天津市天津市','YTO','圆通快递',9.00,'2858558252',NULL,'',NULL,1524645597,0,0),(90,425,'201804251719345355',2,1,'度以上都是','','15915407513',0,4670,5029,5118,'内蒙古自治区','shunfeng','顺丰快递',0.00,'2888582585',NULL,'',NULL,1524648072,0,0),(91,428,'201804251752019282',2,1,'阿拉','','15915407513',0,7531,8216,8300,'踏踏他她他她她','shunfeng','顺丰快递',0.00,'5885252',NULL,'',NULL,1524649959,0,0),(92,429,'201804251759342677',2,1,'度以上都是','','15915407513',0,4670,5029,5118,'内蒙古自治区','shunfeng','顺丰快递',0.00,'288225',NULL,'',NULL,1524650406,0,0),(93,433,'201804251826212190',2,1,'度以上都是','','15915407513',0,4670,5029,5118,'内蒙古自治区','shunfeng','顺丰快递',0.00,'882555',NULL,'',NULL,1524652012,0,0),(94,434,'201804251830483726',2,1,'度以上都是','','15915407513',0,4670,5029,5118,'内蒙古自治区','shunfeng','顺丰快递',0.00,'123456',NULL,'',NULL,1524652277,0,0),(95,439,'201804260921142445',2,1,'度以上都是','','15915407513',0,4670,5029,5118,'内蒙古自治区','shunfeng','顺丰快递',0.00,'285825885',NULL,'',NULL,1524705747,0,0),(96,451,'201804261402207777',3,1,'可可','123456','18516589423',0,1,2,105,'站北地区11号大街12','YD','韵达快递',10.00,'232232332233232',NULL,'322332',NULL,1524722571,0,0),(97,399,'201804251508197412',3,1,'咖啡','123456','15274851694',0,1,2,14,'站北地区11号大街12号','YD','韵达快递',0.00,NULL,NULL,'',NULL,1524726359,0,1),(98,453,'201804261509304559',2,1,'度以上都是','','15915407513',0,4670,5029,5118,'内蒙古自治区','shunfeng','顺丰快递',10.00,'1111111111',NULL,'',NULL,1524726640,0,0),(99,462,'201804261542358862',22,1,'夏夏','','15274851694',0,1,2,3,'法国红酒','YD','韵达快递',0.00,'8554112255566',NULL,'',NULL,1524728597,0,1),(100,462,'201804261542358862',22,1,'夏夏','','15274851694',0,1,2,3,'法国红酒','YD','韵达快递',0.00,'8554112255566',NULL,'',NULL,1524728627,0,0),(101,461,'201804261542334113',10,1,'XIAO','','15919919433',0,636,936,952,'SKFHKSHFKSF','shunfeng','顺丰快递',0.00,'25888525',NULL,'',NULL,1524728636,0,0),(102,463,'201804261552169775',10,1,'XIAO','','15919919433',0,636,936,952,'SKFHKSHFKSF','shunfeng','顺丰快递',0.00,'47711554',NULL,'',NULL,1524729234,0,0),(103,467,'201804261612452649',22,1,'夏夏','','15274851694',0,1,2,3,'法国红酒','YZPY','中国邮政',23.00,'8554112255441',NULL,'',NULL,1524730451,0,0),(104,469,'201804261634327133',2,1,'度以上都是','','15915407513',0,4670,5029,5118,'内蒙古自治区','shunfeng','顺丰快递',0.00,'1258522',NULL,'dsfsg',NULL,1524731735,0,0),(105,470,'201804261640578629',2,1,'度以上都是','','15915407513',0,4670,5029,5118,'内蒙古自治区','shunfeng','顺丰快递',0.00,'',NULL,'',NULL,1524732091,0,3),(106,474,'201804261650566293',2,1,'度以上都是','','15915407513',0,4670,5029,5118,'内蒙古自治区','shunfeng','顺丰快递',0.00,'2882525',NULL,'',NULL,1524732675,0,0),(107,476,'201804261708098683',2,1,'度以上都是','','15915407513',0,4670,5029,5118,'内蒙古自治区','shunfeng','顺丰快递',0.00,'25852852',NULL,'',NULL,1524733751,0,0),(108,479,'201804261725279363',22,1,'风格过','','15274851694',0,338,339,340,'36746888','YTO','圆通快递',19.00,'85544111255855',NULL,'22332',NULL,1524734919,0,0),(109,481,'201804261758169633',2,1,'度以上都是','','15915407513',0,4670,5029,5118,'内蒙古自治区','shunfeng','顺丰快递',0.00,'2858252',NULL,'',NULL,1524737208,0,0),(110,480,'201804261757322164',2,1,'度以上都是','','15915407513',0,4670,5029,5118,'内蒙古自治区','shunfeng','顺丰快递',0.00,'45852522',NULL,'',NULL,1524737370,0,0),(111,483,'201804261817017729',2,1,'度以上都是','','15915407513',0,4670,5029,5118,'内蒙古自治区','shunfeng','顺丰快递',0.00,'38582852',NULL,'',NULL,1524737842,0,0),(112,485,'201804261821539815',2,1,'度以上都是','','15915407513',0,4670,5029,5118,'内蒙古自治区','shunfeng','顺丰快递',0.00,'28822',NULL,'',NULL,1524738208,0,0),(113,487,'201804261832273397',2,1,'度以上都是','','15915407513',0,4670,5029,5118,'内蒙古自治区','YZPY','中国邮政',0.00,'28522',NULL,'',NULL,1524738766,0,0),(114,494,'201804270954113027',23,1,'罗','','18679683657',0,3102,3379,3388,'哦用','shunfeng','顺丰快递',0.00,'4512222445544455',NULL,'33',NULL,1524794137,0,0),(115,503,'201804271032297694',24,1,'夏夏','','15274851694',0,1,2,3,'3545454545454','YD','韵达快递',0.00,'854122552336',NULL,'5454544554',NULL,1524797645,0,0),(116,504,'201804271035318046',23,1,'罗','','18679683657',0,3102,3379,3388,'哦用','YD','韵达快递',0.00,'54656566656',NULL,'',NULL,1524797666,0,0),(117,510,'201804271113302797',2,1,'笑笑','','15915407513',0,1,2,14,'北京大学','shunfeng','顺丰快递',8.00,'28858825',NULL,'',NULL,1524798847,0,0),(118,514,'201804271118502197',2,1,'笑笑','','15915407513',0,1,2,14,'北京大学','YZPY','中国邮政',8.00,'2852558',NULL,'',NULL,1524799155,0,0),(119,524,'201804271134301349',22,1,'风格过','','15274851694',0,338,339,340,'36746888','YZPY','中国邮政',0.00,'123456678899',NULL,'74441411',NULL,1524800278,0,0),(120,523,'201804271133135105',24,1,'夏夏','','15274851694',0,1,2,3,'3545454545454','YTO','圆通快递',0.00,'8554412555',NULL,'',NULL,1524800302,0,0),(121,522,'201804271131502527',23,1,'罗','','18679683657',0,3102,3379,3388,'哦用','shunfeng','顺丰快递',0.00,'8554112255',NULL,'',NULL,1524800339,0,0),(122,526,'201804271338515493',25,1,'fghh','','15915407513',0,1,2,14,'北京大学','shunfeng','顺丰快递',8.00,'2858252',NULL,'',NULL,1524807561,0,0),(123,527,'201804271348002460',26,1,'越来五八了的','','18516586423',0,1,2,3,'1255688555','YZPY','中国邮政',10.00,'32323323222',NULL,'2323',NULL,1524808112,0,0),(124,538,'201804271414004226',17,1,'洽洽','','18516589423',0,1,2,14,'哦某某路','YD','韵达快递',10.00,'1234567891234',NULL,'21212121212',NULL,1524809855,0,0),(125,539,'201804271425297386',24,1,'夏夏','','15274851694',0,1,2,3,'3545454545454','zhongtong','中通快递',0.00,'490828402765',NULL,'434343434',NULL,1524810532,0,0),(126,540,'201804271434496990',17,1,'夏夏','','15274851694',0,338,339,340,'124547785555666','YTO','圆通快递',11.00,'889214400299124892',NULL,'3434',NULL,1524811051,0,0),(127,541,'201804271455263965',25,1,'fghh','','15915407513',0,1,2,14,'北京大学','shunfeng','顺丰快递',0.00,'258522',NULL,'',NULL,1524812169,0,0),(128,543,'201804271508146135',23,1,'罗','','18679683657',0,3102,3379,3388,'哦用','shunfeng','顺丰快递',9.00,'854411225522',NULL,'2323232222',NULL,1524813126,0,0),(129,544,'201804271515241584',25,1,'梅子','','15915407513',0,636,1188,1218,'河北省','shunfeng','顺丰快递',0.00,'258852220',NULL,'',NULL,1524813377,0,0),(130,552,'201804271554017746',17,1,'洽洽','','18516589423',0,1,2,14,'哦某某路','shunfeng','顺丰快递',8.00,'855441112255',NULL,'',NULL,1524815726,0,0),(131,555,'201804271625542513',25,1,'梅子','','15915407513',0,636,1188,1218,'河北省','shunfeng','顺丰快递',9.00,'588552',NULL,'',NULL,1524817599,0,0),(132,556,'201804271633488766',24,1,'夏夏','','15274851694',0,1,2,3,'3545454545454','shunfeng','顺丰快递',0.00,'8554112255522',NULL,'4545454',NULL,1524818097,0,0),(133,558,'201804271643358249',2,1,'笑笑','','15915407513',0,1,2,14,'北京大学','shunfeng','顺丰快递',8.00,'2885825822',NULL,'',NULL,1524818737,0,0),(134,531,'201804271354149430',2,1,'15915407513','','15915407513',0,0,0,0,'','shunfeng','顺丰快递',0.00,'285852',NULL,'',NULL,1524819267,0,0),(135,528,'201804271352255209',25,1,'梅子','','15915407513',0,636,1188,1218,'河北省','shunfeng','顺丰快递',9.00,'285825225',NULL,'',NULL,1524819292,0,0),(136,561,'201804271700523274',2,1,'拉锯','','15915407513',0,3102,3597,3673,'啦啊龙','shunfeng','顺丰快递',0.00,'28582',NULL,'',NULL,1524819818,0,0),(137,562,'201804271706289783',2,1,'拉锯','','15915407513',0,3102,3597,3673,'啦啊龙','YZPY','中国邮政',0.00,'285222',NULL,'',NULL,1524820531,0,0),(138,566,'201804271725302339',2,1,'拉锯','','15915407513',0,3102,3597,3673,'啦啊龙','shunfeng','顺丰快递',10.00,'28582522',NULL,'',NULL,1524821155,0,0),(139,576,'201804271844359792',31,1,'夏夏','','15274851685',0,1,2,3,'2123323323','YD','韵达快递',10.00,'6544444444333',NULL,'4444',NULL,1524825924,0,0),(140,580,'201804280909288472',32,1,'傅曼','','13923797247',0,636,936,938,'他卡里路JJ','shunfeng','顺丰快递',0.00,'282585',NULL,'',NULL,1524877911,0,0),(141,579,'201804280908012544',32,1,'傅曼','','13923797247',0,636,936,938,'他卡里路JJ','shunfeng','顺丰快递',0.00,'28522',NULL,'',NULL,1524877933,0,0),(142,581,'201804280919504126',31,1,'夏夏','','15274851685',0,1,2,3,'2123323323','YTO','圆通快递',0.00,'2344555555',NULL,'333',NULL,1524878422,0,0);

UNLOCK TABLES;

/*Table structure for table `tp_distribut_goods` */

DROP TABLE IF EXISTS `tp_distribut_goods`;

CREATE TABLE `tp_distribut_goods` (
  `user_id` int(11) DEFAULT NULL,
  `goods_id` int(11) DEFAULT NULL,
  `goods_name` varchar(255) DEFAULT NULL COMMENT '商品名称',
  `goods_price` decimal(10,2) DEFAULT NULL COMMENT '商品价格',
  `sales` int(11) DEFAULT NULL COMMENT '销量'
)  DEFAULT CHARSET=utf8 COMMENT='分销商销售表';

/*Data for the table `tp_distribut_goods` */

LOCK TABLES `tp_distribut_goods` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_distribut_level` */

DROP TABLE IF EXISTS `tp_distribut_level`;

CREATE TABLE `tp_distribut_level` (
  `level_id` tinyint(2) unsigned NOT NULL AUTO_INCREMENT,
  `level_type` tinyint(1) DEFAULT '0' COMMENT '分销等级类别',
  `rate1` decimal(6,2) DEFAULT '0.00' COMMENT '一级佣金比例',
  `rate2` decimal(6,2) DEFAULT '0.00' COMMENT '二级佣金比例',
  `rate3` decimal(6,2) DEFAULT '0.00' COMMENT '三级佣金比例',
  `order_money` decimal(12,2) DEFAULT '0.00' COMMENT '升级条件',
  `level_name` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`level_id`)
)  AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*Data for the table `tp_distribut_level` */

LOCK TABLES `tp_distribut_level` WRITE;

insert  into `tp_distribut_level`(`level_id`,`level_type`,`rate1`,`rate2`,`rate3`,`order_money`,`level_name`) values (1,0,65.00,10.00,5.00,0.00,'一级分销商'),(2,0,55.00,8.00,4.00,0.00,'二级分销商'),(3,0,25.00,8.00,3.00,0.00,'三级分销商');

UNLOCK TABLES;

/*Table structure for table `tp_expense_log` */

DROP TABLE IF EXISTS `tp_expense_log`;

CREATE TABLE `tp_expense_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) DEFAULT NULL COMMENT '操作管理员',
  `money` decimal(10,2) DEFAULT NULL COMMENT '支出金额',
  `integral` int(10) DEFAULT '0' COMMENT '赠送积分',
  `type` tinyint(1) DEFAULT '0' COMMENT '支出类型0用户提现,1订单退款,2其他,3注册,4邀请,5分享,6评论',
  `addtime` int(11) DEFAULT NULL COMMENT '日志记录时间',
  `log_type_id` int(11) DEFAULT '0' COMMENT '业务关联ID',
  `user_id` int(10) DEFAULT '0' COMMENT '涉及会员id',
  `user_name` int(10) DEFAULT '0' COMMENT '涉及用户',
  PRIMARY KEY (`id`)
)  AUTO_INCREMENT=55 DEFAULT CHARSET=latin1 COMMENT='平台支出金额或赠送积分日志';

/*Data for the table `tp_expense_log` */

LOCK TABLES `tp_expense_log` WRITE;

insert  into `tp_expense_log`(`id`,`admin_id`,`money`,`integral`,`type`,`addtime`,`log_type_id`,`user_id`,`user_name`) values (1,1,96.00,0,2,1523849230,18,2,0),(2,1,12.00,0,2,1523851044,22,2,0),(3,1,31.50,350,3,1523860508,22,2,0),(4,1,77.12,1000,3,1523867238,35,2,0),(5,1,59.00,0,3,1523867394,34,2,0),(6,1,0.12,2949,3,1523929142,56,2,0),(7,1,88.11,0,3,1523930500,60,2,0),(8,1,184.40,0,2,1523933425,51,2,0),(9,1,25.00,0,2,1523959757,84,3,0),(10,1,199.00,0,3,1524017092,122,3,0),(11,1,0.01,0,2,1524017809,95,2,0),(12,1,1404.04,9999,3,1524018363,121,2,0),(13,1,117.00,0,2,1524023443,104,2,0),(14,1,135.00,0,2,1524032853,112,2,0),(15,1,277.30,0,2,1524036394,119,3,0),(16,1,483.00,0,3,1524044078,161,2,0),(17,1,0.00,0,2,1524121129,171,9,0),(18,1,102.60,0,3,1524124080,234,2,0),(19,1,28.80,0,2,1524127583,223,5,0),(20,1,108.00,0,2,1524185726,237,10,0),(21,1,0.00,350,3,1524205856,283,3,0),(22,1,0.00,350,3,1524205856,283,3,0),(23,1,0.00,0,2,1524206168,256,3,0),(24,1,0.00,350,3,1524206666,283,3,0),(25,1,261.32,0,3,1524207269,286,3,0),(26,1,40.00,0,3,1524214205,297,9,0),(27,1,120.00,0,3,1524214864,296,9,0),(28,1,250.00,0,3,1524215058,305,10,0),(29,1,475.00,0,3,1524218862,328,2,0),(30,1,60.00,0,1,1524451199,10,9,0),(31,1,1000.00,0,1,1524451245,9,9,0),(32,1,168.00,0,3,1524542070,380,2,0),(33,1,29.90,0,3,1524559802,403,3,0),(34,1,59.80,0,3,1524560040,395,17,0),(35,18,110.92,0,3,1524560307,391,3,0),(36,1,-7.94,1715,3,1524618201,427,3,0),(37,1,294.23,0,2,1524635629,394,3,0),(38,1,465.86,0,2,1524635888,395,3,0),(39,1,1775.94,0,2,1524640758,403,2,0),(40,1,1775.14,8,3,1524641200,445,2,0),(41,1,74.26,0,3,1524642123,449,3,0),(42,1,0.00,0,2,1524643206,417,2,0),(43,1,19.90,0,2,1524704769,435,2,0),(44,1,188.00,0,2,1524709512,442,3,0),(45,1,39.90,0,2,1524731844,468,2,0),(46,1,0.00,10060,3,1524731946,518,2,0),(47,1,11.00,0,3,1524737463,537,2,0),(48,1,20.00,800,3,1524800617,587,23,0),(49,1,40.00,100,3,1524800843,588,24,0),(50,1,82.00,0,3,1524800975,575,2,0),(51,1,24.50,0,3,1524800990,544,2,0),(52,1,12.00,10,3,1524820631,626,2,0),(53,1,399.00,0,3,1524877852,640,31,0),(54,1,118.00,0,3,1524878500,645,31,0);

UNLOCK TABLES;

/*Table structure for table `tp_feedback` */

DROP TABLE IF EXISTS `tp_feedback`;

CREATE TABLE `tp_feedback` (
  `msg_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '默认自增ID',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '回复留言ID',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `user_name` varchar(60) NOT NULL DEFAULT '',
  `msg_title` varchar(200) NOT NULL DEFAULT '' COMMENT '留言标题',
  `msg_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '留言类型',
  `msg_status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '处理状态',
  `msg_content` text NOT NULL COMMENT '留言内容',
  `msg_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '留言时间',
  `message_img` varchar(255) NOT NULL DEFAULT '',
  `order_id` int(11) unsigned NOT NULL DEFAULT '0',
  `msg_area` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`msg_id`),
  KEY `user_id` (`user_id`) USING BTREE
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_feedback` */

LOCK TABLES `tp_feedback` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_flash_sale` */

DROP TABLE IF EXISTS `tp_flash_sale`;

CREATE TABLE `tp_flash_sale` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL DEFAULT '' COMMENT '活动标题',
  `goods_id` int(10) NOT NULL COMMENT '参团商品ID',
  `item_id` bigint(20) DEFAULT '0' COMMENT '对应spec_goods_price商品规格id',
  `price` float(10,2) NOT NULL COMMENT '活动价格',
  `goods_num` int(10) DEFAULT '1' COMMENT '商品参加活动数',
  `buy_limit` int(11) NOT NULL DEFAULT '1' COMMENT '每人限购数',
  `buy_num` int(11) NOT NULL DEFAULT '0' COMMENT '已购买人数',
  `order_num` int(10) DEFAULT '0' COMMENT '已下单数',
  `description` text COMMENT '活动描述',
  `start_time` int(11) NOT NULL COMMENT '开始时间',
  `end_time` int(11) NOT NULL COMMENT '结束时间',
  `is_end` tinyint(1) DEFAULT '0' COMMENT '是否已结束',
  `goods_name` varchar(255) DEFAULT NULL COMMENT '商品名称',
  PRIMARY KEY (`id`)
)  AUTO_INCREMENT=56 DEFAULT CHARSET=utf8;

/*Data for the table `tp_flash_sale` */

LOCK TABLES `tp_flash_sale` WRITE;

insert  into `tp_flash_sale`(`id`,`title`,`goods_id`,`item_id`,`price`,`goods_num`,`buy_limit`,`buy_num`,`order_num`,`description`,`start_time`,`end_time`,`is_end`,`goods_name`) values (3,'阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星阳光下的星星',135,0,159.00,10,6,2,1,'212332233232',1523952000,1523959200,1,'月缦 2018新款礼服A字裙短袖少女中国风学生日常短款中式礼服连衣裙'),(2,'抢购时间倒计时开始',210,0,10.00,10,2,0,0,'',1523944800,1523952000,1,'苹果7钢化膜iphone8plus手机7plus全屏全覆盖8贴膜水凝7p抗蓝光3D'),(6,'阳光123',196,178,29.00,20,5,0,0,'233',1524016800,1524024000,1,'花花公子短袖t恤男棉质翻领半袖衫中年男士打底衫夏季男装Polo衫 正品保证 支持扫描验货 包邮选择颜色:蓝色 码数:M'),(7,'54444',199,0,99.00,30,5,2,1,'232323',1524009600,1524016800,1,'送醒酒器法国原瓶进口红酒路易拉菲干红葡萄酒6支整箱装送礼红酒 送红酒杯 送醒酒器开瓶器酒塞'),(8,'活动未开始',203,0,20.00,9,6,0,0,'22323',1524024000,1524031200,0,'鲜花礼盒花束速递红玫瑰北京同城鲜花上海送花南京广州鲜花店杭州 手机购更优惠 6年老店 指定日期送'),(9,'活动等待中',207,0,999.99,100,2,0,0,'6666666666',1524024000,1524031200,1,'美的(Midea)220升 家用商用冰柜 双箱双温冷柜 蝶形门侧掀门 化冻包赔'),(10,'如果当时123',135,0,39.00,20,3,9,4,'22121',1524016800,1524024000,1,'月缦 2018新款礼服A字裙短袖少女中国风学生日常短款中式礼服连衣裙'),(11,'花花花',146,0,49.00,15,3,1,1,'2121',1524016800,1524024000,0,'恒源祥女装风衣女长款2017秋季新款英伦风系带外套女春秋厚'),(12,'211221',178,0,59.00,16,3,0,0,'',1524016800,1524024000,0,'雅鹿中老年男士羽绒裤秋冬季保暖高腰轻薄修身加大码内穿加绒加厚'),(13,'322323',151,0,29.90,10,3,0,0,'',1524016800,1524024000,0,'私柜 情趣内衣女骚性感睡衣制服诱惑套装蕾丝透明吊带睡裙 莹伶恋曲4件套'),(14,'adc',107,0,590.00,90,2,0,0,'',1524031200,1524038400,0,'稀奇（XQ） 稀奇艺术Mini版雕塑《天使比比》瞿广慈艺术品桌面摆可爱小人摆件创意生日礼 粉蓝'),(15,'xihuan',199,0,199.00,10,3,0,0,'11',1524031200,1524038400,1,'送醒酒器法国原瓶进口红酒路易拉菲干红葡萄酒6支整箱装送礼红酒 送红酒杯 送醒酒器开瓶器酒塞'),(16,'12',195,0,199.00,10,10,0,0,'111',1524031200,1524038400,0,'贝尔（BBL） 贝尔地板 实木 地板 东南亚进口 番龙眼 18mm家用环保 红枫古道 深色'),(18,'运费',214,235,39.00,6,4,6,2,'433434',1524031200,1524038400,1,'抢购活动待运费选择颜色:绿色 码数:XS'),(19,'下一个时间',118,0,100.00,99,10,1,1,'2258822',1524038400,1524045600,1,'单蜜半身裙女装2018春季新款高腰破洞牛仔中长裙子'),(21,'1285',206,0,582.00,100,10,0,0,'',1524038400,1524045600,1,'TCL 118升 小型双门电冰箱 LED照明 迷你节能 办公居家便捷之选 环保内胆 （芭蕾白）BCD-118KA9'),(22,'2852',196,178,99.00,90,10,0,0,'',1524045600,1524052800,0,'花花公子短袖t恤男棉质翻领半袖衫中年男士打底衫夏季男装Polo衫 正品保证 支持扫描验货 包邮选择颜色:蓝色 码数:M'),(23,'2855',196,180,99.00,99,10,0,0,'',1524052800,1524060000,0,'花花公子短袖t恤男棉质翻领半袖衫中年男士打底衫夏季男装Polo衫 正品保证 支持扫描验货 包邮选择颜色:蓝色 码数:S'),(24,'666',131,0,59.00,9,3,0,0,'232323',1524124800,1524132000,0,'子婳打底裤女2018新款大码春夏铅笔小脚休闲裤外穿打底裤'),(25,'43',209,0,20.00,9,5,0,0,'555455545455554',1524139200,1524146400,1,'九阳（Joyoung）豆浆机破壁免滤预约1300ml家用全自动多功能DJ13E-Q1'),(27,'天蓝堤北',1,281,79.00,65,10,0,0,'855444122233444',1524189600,1524196800,1,'vivoX21 6GB+128GB 4G全网通 全面屏 拍照手机选择版本:全网通4G+64G 选择颜色:铂光色 套餐类型:套餐一'),(28,'2',218,0,10.00,50,2,0,0,'',1524189600,1524196800,1,'232323'),(29,'美美的',203,0,100.00,50,2,0,0,'',1524189600,1524196800,1,'鲜花礼盒花束速递红玫瑰北京同城鲜花上海送花南京广州鲜花店杭州 手机购更优惠 6年老店 指定日期送'),(30,'258522',196,221,188.00,100,100,0,0,'',1524204000,1524211200,0,'花花公子短袖t恤男棉质翻领半袖衫中年男士打底衫夏季男装Polo衫 正品保证 支持扫描验货 包邮选择颜色:红色 码数:XXM'),(31,'2585',210,0,10.00,80,10,2,2,'',1524463200,1524470400,1,'苹果7钢化膜iphone8plus手机7plus全屏全覆盖8贴膜水凝7p抗蓝光3D'),(32,'5555',37,338,300.00,80,10,0,0,'282582',1524463200,1524470400,0,'罗技（Logitech）G502 炫光自适应游戏鼠标 RGB鼠标 FPS鼠标 吃鸡鼠标 绝地求生颜色分类:银色'),(33,'地址限制',62,0,59.00,10,10,1,1,'',1524463200,1524470400,1,'闪迪（SanDisk）A1 32GB 读速98MB/s 至尊高速移动MicroSDHC UHS-I存储卡 TF卡'),(34,'88888',44,0,888.00,10,10,0,0,'',1524470400,1524477600,0,'LUOLAI罗莱家纺 229纱支纯棉四件套 全棉床上用品床品套件床单被罩 WD5006晨暮间 220*250'),(35,'1885',65,0,398.00,100,100,1,1,'',1524470400,1524477600,0,'绿联Type-C转HDMI/VGA转换器 USB-C扩展坞PD充电转接头数据线 苹果MacBook华为Mate10Pro拓展坞集线器40873'),(36,'7777',199,0,119.00,10,10,0,0,'',1524477600,1524481200,1,'送醒酒器法国原瓶进口红酒路易拉菲干红葡萄酒6支整箱装送礼红酒 送红酒杯 送醒酒器开瓶器酒塞'),(37,'8888',76,0,1299.00,100,50,0,0,'',1524535200,1524542400,0,'戴尔（DELL） U2417H 23.8英寸四边微边框旋转升降IPS屏 出厂色彩校准 99%sRGB 电脑吃鸡显示器'),(38,'999',137,0,258.00,100,10,0,0,'',1524535200,1524542400,0,'新款桔杏格配红色头层牛皮百搭双肩包'),(39,'1000',228,341,185.00,100,0,0,0,'',1524535200,1524542400,1,'多规格衣服的的快递选择颜色:蓝色 码数:M'),(40,'1001',228,342,168.00,100,10,0,0,'',1524535200,1524542400,1,'多规格衣服的的快递选择颜色:紫色 码数:M'),(41,'1002',228,343,186.00,100,10,1,1,'2882582',1524542400,1524549600,1,'多规格衣服的的快递选择颜色:蓝色 码数:L'),(42,'莱恩',229,346,59.00,30,10,2,1,'23232323',1524722400,1524729600,1,'78889选择颜色:宝蓝色'),(43,'抢购商品活动开始',91,0,88.88,10,1,0,0,'',1524722400,1524729600,1,'绍泽文化 文房四宝毛笔书法套装 （毛笔/墨锭/石砚/笔架/水碗/镇尺）'),(44,'666666',53,62,100.00,10,10,0,0,'',1524722400,1524729600,0,'73Hours 天鹅小径 2018春季新品羊皮踝靴蝴蝶结细跟深口高跟鞋女 新品尺码:36 颜色:白色'),(45,'华科',171,159,89.00,20,6,0,0,'343434343434322323',1524729600,1524736800,0,'睡衣女士纯棉短袖夏季红豆居家春大码全棉甜美薄款家居服短裤套装 红豆居家女士纯棉睡衣 休闲可外穿码数:M'),(46,'活动未开始',118,0,30.00,30,6,0,0,'434343434',1524736800,1524744000,1,'单蜜半身裙女装2018春季新款高腰破洞牛仔中长裙子'),(47,'443434',230,351,49.00,30,3,3,1,'2323',1524729600,1524736800,1,'稻草人(MEXICAN)男包男士单肩包头层牛皮竖款商务休闲单肩斜挎包小颜色:黑色'),(48,'588282',162,0,68.00,100,10,0,0,'',1524787200,1524794400,0,'北极绒牛仔短裤男七分裤破洞韩版修身夏天直筒宽松乞丐夏日五分中裤男士夏季大码运动马裤'),(49,'11111',18,0,3300.00,100,10,0,0,'',1524787200,1524794400,1,'格力（GREE）正1.5匹 变频 品圆 冷暖 壁挂式空调 KFR-35GW/(35592)FNhDa-A3'),(50,'22122',46,0,100.00,100,10,0,0,'',1524787200,1524794400,0,'雅琼 沙发北欧布艺沙发可拆洗小户型三人位懒人沙发现代简约客厅家具A68 两件套（备注颜色） 海绵坐垫（送地毯）'),(51,'255822',229,345,82.00,10,10,1,1,'',1524794400,1524801600,1,'78889选择颜色:藏青色'),(52,'889889',52,0,300.00,100,10,0,0,'',1524808800,1524816000,1,'【官方旗舰店】广州电信光纤宽带新装100M 送不限流量手机卡流量卡 升级分享计划 100M 200元预存+199元一次性费用'),(53,'78888',229,346,29.00,8,2,3,2,'34434342323',1524808800,1524816000,1,'78889选择颜色:宝蓝色'),(54,'00000',229,345,65.00,59,10,1,1,'',1524816000,1524823200,1,'78889选择颜色:藏青色'),(55,'222222',174,0,88.88,91,10,1,1,'',1524816000,1524823200,0,'茵曼A字半身裙');

UNLOCK TABLES;

/*Table structure for table `tp_freight_config` */

DROP TABLE IF EXISTS `tp_freight_config`;

CREATE TABLE `tp_freight_config` (
  `config_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置id',
  `first_unit` double(16,4) NOT NULL DEFAULT '0.0000' COMMENT '首(重：体积：件）',
  `first_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '首(重：体积：件）运费',
  `continue_unit` double(16,4) unsigned NOT NULL DEFAULT '0.0000' COMMENT '继续加（件：重量：体积）区间',
  `continue_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '继续加（件：重量：体积）的运费',
  `template_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '运费模板ID',
  `is_default` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否是默认运费配置.0不是，1是',
  PRIMARY KEY (`config_id`)
)  AUTO_INCREMENT=14 DEFAULT CHARSET=latin1 COMMENT='运费配置表';

/*Data for the table `tp_freight_config` */

LOCK TABLES `tp_freight_config` WRITE;

insert  into `tp_freight_config`(`config_id`,`first_unit`,`first_money`,`continue_unit`,`continue_money`,`template_id`,`is_default`) values (5,3.0000,10.00,2.0000,3.00,3,1),(6,2.0000,9.00,3.0000,2.00,3,0),(7,500.0000,8.00,200.0000,3.00,4,0),(9,300.0000,10.00,100.0000,3.00,6,1),(10,400.0000,8.00,200.0000,2.00,6,0),(13,5.0000,8.00,3.0000,2.00,5,0);

UNLOCK TABLES;

/*Table structure for table `tp_freight_region` */

DROP TABLE IF EXISTS `tp_freight_region`;

CREATE TABLE `tp_freight_region` (
  `template_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '模板id',
  `config_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '运费模板配置ID',
  `region_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT 'region表id'
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_freight_region` */

LOCK TABLES `tp_freight_region` WRITE;

insert  into `tp_freight_region`(`template_id`,`config_id`,`region_id`) values (3,6,338),(3,6,636),(3,6,3102),(6,10,10808),(5,13,1),(4,7,636);

UNLOCK TABLES;

/*Table structure for table `tp_freight_template` */

DROP TABLE IF EXISTS `tp_freight_template`;

CREATE TABLE `tp_freight_template` (
  `template_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '运费模板ID',
  `template_name` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT '模板名称',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0 件数；1 商品重量；2 商品体积',
  `is_enable_default` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否启用使用默认运费配置,0:不启用，1:启用',
  PRIMARY KEY (`template_id`)
)  AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COMMENT='运费模板表';

/*Data for the table `tp_freight_template` */

LOCK TABLES `tp_freight_template` WRITE;

insert  into `tp_freight_template`(`template_id`,`template_name`,`type`,`is_enable_default`) values (3,'以件计算',0,1),(4,'配送河北',1,0),(5,'以体积计算',2,0),(6,'以重量计算，全国配送',1,1);

UNLOCK TABLES;

/*Table structure for table `tp_friend_link` */

DROP TABLE IF EXISTS `tp_friend_link`;

CREATE TABLE `tp_friend_link` (
  `link_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `link_name` varchar(255) NOT NULL DEFAULT '' COMMENT '链接名称',
  `link_url` varchar(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `link_logo` varchar(255) NOT NULL DEFAULT '' COMMENT '链接logo',
  `orderby` tinyint(3) unsigned NOT NULL DEFAULT '50' COMMENT '排序',
  `is_show` tinyint(1) DEFAULT '1' COMMENT '是否显示',
  `target` tinyint(1) DEFAULT '1' COMMENT '是否新窗口打开',
  PRIMARY KEY (`link_id`),
  KEY `show_order` (`orderby`) USING BTREE
)  AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

/*Data for the table `tp_friend_link` */

LOCK TABLES `tp_friend_link` WRITE;

insert  into `tp_friend_link`(`link_id`,`link_name`,`link_url`,`link_logo`,`orderby`,`is_show`,`target`) values (1,'淘宝网','https://www.taobao.com','/public/upload/link/2018/04-10/a647e7a20eb5be07409a4bb09940ffe2.jpg',3,1,0),(2,'京东','https://www.jd.com','/public/upload/link/2018/04-10/ff2e6f7aadc027e37a3e4d312aa3bbcb.jpg',2,1,0),(3,'唯品会','https://www.vip.com','/public/upload/link/2018/04-10/1461dcb6e60104f80a8597697f1d1931.gif',1,1,0),(4,'苏宁易购','https://www.suning.com','/public/upload/link/2018/04-10/ba5c31a2f80beb49e0f2e2ada85b0f91.jpg',4,1,1),(6,'淘宝','https://www.taobao.com','',1,0,0),(7,'百度','https://www.baidu.com','',2,1,0),(9,'555','http://www.b2t.com','',1,0,0),(5,'1号店','http://www.yhd.com','',6,1,0);

UNLOCK TABLES;

/*Table structure for table `tp_goods` */

DROP TABLE IF EXISTS `tp_goods`;

CREATE TABLE `tp_goods` (
  `goods_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品id',
  `cat_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '分类id',
  `extend_cat_id` int(11) DEFAULT '0' COMMENT '扩展分类id',
  `goods_sn` varchar(60) NOT NULL DEFAULT '' COMMENT '商品编号',
  `goods_name` varchar(120) NOT NULL DEFAULT '' COMMENT '商品名称',
  `click_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点击数',
  `brand_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '品牌id',
  `store_count` smallint(5) unsigned NOT NULL DEFAULT '10' COMMENT '库存数量',
  `comment_count` smallint(5) DEFAULT '0' COMMENT '商品评论数',
  `weight` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品重量克为单位',
  `volume` double(10,4) unsigned NOT NULL DEFAULT '0.0000' COMMENT '商品体积。单位立方米',
  `market_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '市场价',
  `shop_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '本店价',
  `cost_price` decimal(10,2) DEFAULT '0.00' COMMENT '商品成本价',
  `price_ladder` text COMMENT '价格阶梯',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '商品关键词',
  `goods_remark` varchar(255) NOT NULL DEFAULT '' COMMENT '商品简单描述',
  `goods_content` text COMMENT '商品详细描述',
  `mobile_content` text COMMENT '手机端商品详情',
  `original_img` varchar(255) NOT NULL DEFAULT '' COMMENT '商品上传原始图',
  `is_virtual` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否为虚拟商品 1是，0否',
  `virtual_indate` int(11) DEFAULT '0' COMMENT '虚拟商品有效期',
  `virtual_limit` smallint(6) DEFAULT '0' COMMENT '虚拟商品购买上限',
  `virtual_refund` tinyint(1) DEFAULT '1' COMMENT '是否允许过期退款， 1是，0否',
  `virtual_sales_sum` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '虚拟销售量',
  `virtual_collect_sum` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '虚拟收藏量',
  `collect_sum` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '收藏量',
  `is_on_sale` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否上架',
  `is_free_shipping` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否包邮0否1是',
  `sort` smallint(4) unsigned NOT NULL DEFAULT '50' COMMENT '商品排序',
  `is_recommend` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否推荐',
  `is_new` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否新品',
  `is_hot` tinyint(1) DEFAULT '0' COMMENT '是否热卖',
  `last_update` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后更新时间',
  `goods_type` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '商品所属类型id，取值表goods_type的cat_id',
  `give_integral` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '购买商品赠送积分',
  `exchange_integral` int(10) NOT NULL DEFAULT '0' COMMENT '积分兑换：0不参与积分兑换，积分和现金的兑换比例见后台配置',
  `suppliers_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '供货商ID',
  `sales_sum` int(11) DEFAULT '0' COMMENT '商品销量',
  `prom_type` tinyint(1) DEFAULT '0' COMMENT '0默认1抢购2团购3优惠促销4预售5虚拟(5其实没用)6拼团7搭配购',
  `prom_id` int(11) NOT NULL DEFAULT '0' COMMENT '优惠活动id',
  `commission` decimal(10,2) DEFAULT '0.00' COMMENT '佣金用于分销分成',
  `spu` varchar(128) DEFAULT '' COMMENT 'SPU',
  `sku` varchar(128) DEFAULT '' COMMENT 'SKU',
  `template_id` int(11) unsigned DEFAULT '0' COMMENT '运费模板ID',
  `video` varchar(255) DEFAULT '' COMMENT '视频',
  PRIMARY KEY (`goods_id`),
  KEY `goods_sn` (`goods_sn`),
  KEY `cat_id` (`cat_id`),
  KEY `last_update` (`last_update`),
  KEY `brand_id` (`brand_id`),
  KEY `goods_number` (`store_count`),
  KEY `goods_weight` (`weight`),
  KEY `sort_order` (`sort`)
)  AUTO_INCREMENT=236 DEFAULT CHARSET=utf8;

/*Data for the table `tp_goods` */

LOCK TABLES `tp_goods` WRITE;

insert  into `tp_goods`(`goods_id`,`cat_id`,`extend_cat_id`,`goods_sn`,`goods_name`,`click_count`,`brand_id`,`store_count`,`comment_count`,`weight`,`volume`,`market_price`,`shop_price`,`cost_price`,`price_ladder`,`keywords`,`goods_remark`,`goods_content`,`mobile_content`,`original_img`,`is_virtual`,`virtual_indate`,`virtual_limit`,`virtual_refund`,`virtual_sales_sum`,`virtual_collect_sum`,`collect_sum`,`is_on_sale`,`is_free_shipping`,`sort`,`is_recommend`,`is_new`,`is_hot`,`last_update`,`goods_type`,`give_integral`,`exchange_integral`,`suppliers_id`,`sales_sum`,`prom_type`,`prom_id`,`commission`,`spu`,`sku`,`template_id`,`video`) values (1,32,0,'TP0000001','vivoX21 6GB+128GB 4G全网通 全面屏 拍照手机',37,0,934,1,0,0.0000,3198.00,2999.00,0.00,'','','全新刘海屏，屏占比90.3%，3D曲面玻璃机身6GB大运存高通多核神经网络芯片，性能更强劲','&lt;p&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/938895458116268325542800_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/376971680565580798687400_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/790106621142642705711030_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/487847932958638125141000_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/114296889713304561813038_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/146324807699599842178000_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/349873411156683004513400_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/107489173511150852380240_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/181480188214831031266206_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/417800177113422536646430_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/264456586171287706483460_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/188441258110420208757984_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/111414050414008857656890_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/120366806832711673169310_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/181239963836955596272210_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/117629241683374892955750_x.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-09/5d20aae3bd2954be026ae678ffd9ed58.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,2,1000,0,0,4,0,0,0.00,'','',3,''),(2,38,0,'TP0000002','联想(Lenovo)一体机电脑AIO 520S-23 I5 7200 4G 500G 2G 23寸 带KM5922鼠标',5,0,100,0,6590,0.0000,5299.00,4999.00,0.00,'','','【全国联保 厂家直供 电子发票 正品保障】商务办公~家庭娱乐','&lt;p&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/649716666979559393412000_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/189135066252817923598500_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/133164058049158052735720_x.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-09/fae5286b27e625cd1cad58dc63cc3af0.png',0,-28800,0,1,0,0,0,1,1,50,1,0,0,0,0,0,0,0,0,0,0,0.00,'','',0,''),(3,15,0,'TP0000003','佐露絲RALOS实拍大码女装连衣裙春装200斤胖妹妹遮肚子减龄胖mm蕾丝拼接裙子',16,0,196,1,0,0.0000,135.00,118.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/121163259859384112591700_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/303355449200901071042560_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/806888583149031205314990_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/332828384153106843464290_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/578865766187983525414900_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/145289273416187097066313_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/841162661782266691638800_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/163479072794536721942330_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/486128509179546292021550_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/833412608919787118468400_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/125902261916468442311464_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/343546121229032015950900_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/157757737749010734573040_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/147026179615772085615632_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/943569531985501994398700_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/313327041767383601178000_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/167012610921085176444066_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/547168599811128172936000_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/675746910138078160942960_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/130799210438591314069480_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/771059959517625685869000_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/206540247204162765945710_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/415912671393156304232800_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/746823200137038158472460_x.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-09/00218db8155e70da05d95537caddf0ff.png',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,0,0,0,0,4,0,0,0.00,'','',0,''),(4,45,0,'TP0000004','苏泊尔28cm玻璃盖火红点煎锅平底锅无油烟不粘电磁炉通用PJ28K4',10,0,150,1,2320,0.0000,269.00,169.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t3040/315/22870818/172180/8042e0af/57903184Nd9c8f342.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2950/256/187790466/275072/26792f47/574ea746N884ac4aa.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2818/33/1888973939/175304/d77623a1/574ea751N907d9e87.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2767/353/1906372034/341462/1d4ae43/574ea759N8b6d7801.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2857/356/1881431199/130272/7c75c2aa/574ea763Ne4a5e667.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2965/290/173023626/253208/23e9869b/574ea76bN10c956ed.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2797/28/1881355804/331437/95f09a04/574ea772N59ad5f3e.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-09/d51297e77f522e0bb29f6fd42e856cbe.png',0,-28800,0,1,0,0,0,1,1,50,1,0,0,0,0,0,0,0,0,0,0,0.00,'','',0,''),(5,354,0,'TP0000005','小米（MI）电视 55英寸 4K 智能WiFi网络平板 智能语音 液晶电视机 标准版 T 4A L55M5-AZ',7,0,100,0,16300,0.0000,3099.00,2598.00,0.00,'','','','',NULL,'/public/upload/goods/2018/04-17/5766e3578552ae123da53a653bc6dae2.png',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,0,0,0,0,0,0,0,0.00,'','',0,''),(6,403,0,'TP0000006','沃隆 每日坚果 休闲零食 坚果炒货 扁桃仁腰果榛子核桃 成人款',5,0,149,0,1040,0.0000,158.00,139.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t7084/32/380521321/319548/c1908f08/597f5587N0b64196c.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5767/256/8843831800/274308/6c2ebaf4/597f5588Nd63890b0.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5671/169/8851222164/158060/12a923b7/597f5589Nd76f9d94.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t7201/350/343924283/318906/8a4ccf5f/597f558aNa38b485a.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t6991/278/1265777682/298705/33e512b6/597f558bN1d8f0280.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5761/212/8802625794/283707/816b48f0/597f558cNadcf3756.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t6931/287/1243573095/194171/fa3ced81/597f558dN10cfd4c0.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5596/105/8784613061/394157/e7cea705/597f558eN75388d07.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t6115/291/7558779391/263922/7eaf8c7f/597f558dN0a483e27.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t7186/51/372863330/240988/1a58f471/597f5631Nf4c454ba.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t6955/294/1223613513/259548/7a2a6bcd/597f5632Ndc4aca3f.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5866/211/8799003262/208536/1d9bb20d/597f5632Nda42c9cd.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5869/5/8885648784/115779/d29f3870/597f5633Nd6234b29.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t6952/299/1220257329/297278/58cdc2e1/597f5634Na356f56b.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5908/135/7539984763/282240/c3202d4d/597f5635N47e0aa74.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5593/298/8850779784/177838/16ce7203/597f5635N6a1ab557.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5800/253/8831537350/197223/266e414a/597f5636N552ab1be.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5602/204/8757807294/365209/4fbb29fe/597f5637Nf577bb85.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t6928/298/1268902252/284200/6b6d8ff8/597f562fNdcadcadb.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t6871/4/1245267538/338823/2d2d617d/597f56bbNd9ce4eff.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-09/a438ee20c8db25b5b9c998edf0ac7b44.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,1,0,0,0.00,'','',0,''),(7,14,0,'TP0000007','哥弟女装2018春季新款口袋趣味图案贴标连帽针织长开衫A400065 连帽设计 实穿美观',16,0,100,0,1000,1.0000,580.00,480.00,280.00,'','春季衣服','哥弟女装2018春季新款口袋趣味图案贴标连帽针织长开衫A400065\r\n连帽设计 实穿美观','&lt;h1 style=&quot;margin: 0px; padding: 0px 0px 0.2em; font-size: 16px; font-family: &amp;quot;microsoft yahei&amp;quot;; line-height: 1; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;哥弟女装2018春季新款口袋趣味图案贴标连帽针织长开衫A400065&lt;/h1&gt;&lt;p style=&quot;margin-bottom: 0px; padding: 0px; color: rgb(255, 0, 54); font-family: &amp;quot;microsoft yahei&amp;quot;; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255); margin-top: 0px;&quot;&gt;连帽设计 实穿美观&lt;/p&gt;&lt;p style=&quot;margin-top: 0px;&quot;&gt;品牌名称：&lt;span class=&quot;J_EbrandLogo&quot; style=&quot;margin: 0px; padding: 0px; color: rgb(51, 51, 51);&quot;&gt;Girdear/哥弟&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;attr-list-hd tm-clear&quot; style=&quot;margin-top: 0px; margin-bottom: 0px; padding: 5px 20px; line-height: 22px; color: rgb(153, 153, 153); font-family: tahoma, arial, 微软雅黑, sans-serif; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t18265/219/429446678/222731/74a26cb2/5a7955c7N1b89fbe4.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t19021/285/430808486/214946/881908e1/5a7955c7N275d7fba.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t16303/80/2048181516/152196/d4d8b105/5a7955c7N99dcd6a4.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t11935/234/2494029732/130595/52da63f1/5a7955c7Nfd55ce2e.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t14533/154/2194152222/118660/69d4c8ef/5a7955c6Nf933c93b.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t14311/230/2181419613/180157/42e455f7/5a7955c7N76b291ac.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-09/e60ff1a4c481dfa69cec48508a665f42.jpg',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(12,112,0,'TP0000012','所有失去的都会以另一种方式归来',7,0,98,1,0,0.0000,26.00,20.00,0.00,'','','人气作家耿帅，暌违五年，重新归来，1800000次点赞，超5亿次阅读，每3秒钟都有人在书里看到另一个自己。给年轻人爱的正能量和信心，领着失意的你，向过去告别。（随书附赠限量珍藏版明信片×精致书签）','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/vc/jfs/t2392/262/2268441037/550815/ae609dc6/56f8c520N63931419.jpg&quot;/&gt;&lt;/p&gt;&lt;h3 style=&quot;margin: 0px; padding: 0px 0px 0px 20px; font-size: 14px; line-height: 28px; width: 99px; height: 25px; overflow: hidden; color: rgb(255, 255, 255); background: url(&amp;quot;//static.360buyimg.com/item/main/1.0.38/css/i/item.sprite.png&amp;quot;) 0px -13px no-repeat;&quot;&gt;内容简介&lt;/h3&gt;&lt;p&gt;　　★《所有失去的都会以另一种方式归来》是励志作家耿帅暌违五年，送给读者暖心的励志故事，五年时光。&lt;br/&gt;　　★他的文字，给年轻人爱的正能量和信心。与你讲述人情冷暖，万水千山。见解独到，治愈励志。&lt;br/&gt;　　★换一个城市是不是更快乐、离开现在的工作是不是就会有前途、结束一段关系是不是就幸福了，这些困扰的问题你都会从他的书里找到答案。他用文字来告诉每一个人，所有的困境都是来自内在的心境，单身不可怕，失恋不可怕，可怕的是失去爱的能力。&lt;br/&gt;　　★这是一份你应该送给自己，并与生命中所有朋友分享的礼物。亦或，送给你在乎的人，有了Ta，世界才完整。&lt;br/&gt;　　★你也可以把这本书放在枕边，放在书架，别太介意得失，要相信：所有失去的都会以另一种方式归来。&lt;br/&gt;&lt;/p&gt;&lt;h3 style=&quot;margin: 0px; padding: 0px 0px 0px 20px; font-size: 14px; line-height: 28px; width: 99px; height: 25px; overflow: hidden; color: rgb(255, 255, 255); background: url(&amp;quot;//static.360buyimg.com/item/main/1.0.38/css/i/item.sprite.png&amp;quot;) 0px -13px no-repeat;&quot;&gt;作者简介&lt;/h3&gt;&lt;p&gt;　　耿帅，著名作家、畅销书出版人。喜阅读、电影、旅行的典型狮子座。历任多家出版传媒及互联网公司产品总监、市场营销副总裁。&lt;br/&gt;&lt;/p&gt;&lt;h3 style=&quot;margin: 0px; padding: 0px 0px 0px 20px; font-size: 14px; line-height: 28px; width: 99px; height: 25px; overflow: hidden; color: rgb(255, 255, 255); background: url(&amp;quot;//static.360buyimg.com/item/main/1.0.38/css/i/item.sprite.png&amp;quot;) 0px -13px no-repeat;&quot;&gt;精彩书评&lt;/h3&gt;&lt;p&gt;　　直到故事终了，直到合上这本书，我们才发觉：所有失去的，都会以另一种方式归来。&lt;br/&gt;　　——畅销书作家林楚茨&lt;br/&gt;&lt;br/&gt;　　这本书，我买了三次，因为，每买一次，就被别人拿走。&lt;br/&gt;　　——畅销书作家宋筱白&lt;br/&gt;&lt;br/&gt;　　我需要的书就是这个样子，不用看心情，可以随时随地翻开某一页来阅读。&lt;br/&gt;　　——追随八年的读者Sally&lt;br/&gt;&lt;br/&gt;　　谢谢你，耿先生，在我们走了很久很久的路上，我们会记得你很久很久。&lt;br/&gt;　　——微博&amp;amp;微信公众号数十万粉丝的致词&lt;/p&gt;&lt;h3 style=&quot;margin: 0px; padding: 0px 0px 0px 20px; font-size: 14px; line-height: 28px; width: 99px; height: 25px; overflow: hidden; color: rgb(255, 255, 255); background: url(&amp;quot;//static.360buyimg.com/item/main/1.0.38/css/i/item.sprite.png&amp;quot;) 0px -13px no-repeat;&quot;&gt;目录&lt;/h3&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 0px; padding: 0px;&quot;&gt;代序：所有热爱的事情都要不遗余力&lt;br/&gt;Chapter 1 岁月与记忆背道而驰&lt;br/&gt;Chapter 2 时间会让你遇见更好的人&lt;br/&gt;Chapter 3 我们没必要再去怀念从前&lt;br/&gt;Chapter 4 别回头，我不在你身后了&lt;br/&gt;Chapter 5 如今最好别说来日方长&lt;br/&gt;Chapter 6 相濡以沫，不如相忘于江湖&lt;br/&gt;Chapter 7&amp;nbsp;&lt;span style=&quot;margin: 0px; padding: 0px; font-size: 12px;&quot;&gt;唯愿无事常相见&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 0px; padding: 0px;&quot;&gt;Chapter 8 如果觉得委屈，就成为你想要的光&lt;br/&gt;Chapter 9 在我行走很久很久的路上&lt;br/&gt;Chapter 10 四季轮回，渐远还生&lt;br/&gt;后记：所有失去的，都会以另一种方式归来&lt;br/&gt;&lt;/p&gt;&lt;h3 style=&quot;margin: 0px; padding: 0px 0px 0px 20px; font-size: 14px; line-height: 28px; width: 99px; height: 25px; overflow: hidden; color: rgb(255, 255, 255); background: url(&amp;quot;//static.360buyimg.com/item/main/1.0.38/css/i/item.sprite.png&amp;quot;) 0px -13px no-repeat;&quot;&gt;精彩书摘&lt;/h3&gt;&lt;p&gt;　　所有热爱的事情都要不遗余力&lt;br/&gt;　　林楚茨&lt;br/&gt;　　在给耿先生的新书写这篇文字的时候，正值除夕，工作暂时告一段落，陪在父母身边。&lt;br/&gt;　　除夕的夜晚，北方城市里烟火锦簇，满地余烬。就像一些人，在我们的世界里也是盛开过的烟花，高空绽放，然后消失。所有邂逅的意义，只存在于交会的火光瞬间。&lt;br/&gt;　　耿先生说：每写一次书，就像过了一辈子。&lt;br/&gt;　　这本书对他而言，既是结束，也是开始。是他一个人度过那么久，无声而又漫长岁月的见证。&lt;br/&gt;　　可能以后回想起来，或许也没什么，我们一生所拥有的，在几十年的人生长河里，毕竟只是零星。&lt;br/&gt;　　写作一直是一件孤独的事，人的孤独感是随着时光增加的。很多时候，说着说着，就忘记了究竟是在对别人说，还是说给自己听。更多的时候，更像是在自说自话，一个人站在角落里，所有的灯光均匀地打在他头上。而那些未提及的情感，在黑暗里更显得郑重庄严，代表着延续和生长，没有终点。&lt;br/&gt;　　他一直想写这样一本书，那些文字属于记忆深处，写在水面上，写在火焰中，写在灰烬里，写在沉默和告白里。这些字，它们是一块路标，标识着一条流离失所的路。有时候很美，有时候也让人很慌张。它通往未知的森林、草原、世界尽头的星空、海洋，或者是清晨大雾的屋顶。熙攘之后，相忘于江湖。&lt;br/&gt;　　每个人的生命中都需要那么一些空白期，来想清楚一些事，来规划一些方向。人的心境每一个阶段都会发生变化，如同河流冲刷掉每一个脚步。&lt;br/&gt;　　他对我谈论起这本书，所有的语言都温柔坦诚。我喜欢袒露内心的文字，走走停停，观照内心。细细潜入，润物无声。看似简单却意味深长。&lt;br/&gt;　　他内心是想保持一种疏离感，这种疏离感会在内心细细地灼烧，感受置身于时间中的流逝。是黑暗海面上的一束明亮的光线，带着隐约的肯定。遗失与记得、默然与回声、散落与回归，反反复复，一直有光亮。&lt;br/&gt;　　故事里的人走了漫漫疲惫的长路，彼此邂逅旅伴，摆了一壶好酒，彻夜长谈。故事外的人还在不停地寻找，渴望相互拯救，交换生命中重要的部分。&lt;br/&gt;　　与人相处和写作一样，应该关注更多的细节，用足够的时间打量。刻意的文字和刻意的人际关系都会显得单薄，当我们看到一本书，遇到一个人，在遇见的几分钟里，预感已经决定了一切。真实而深厚的感情，一开始便有定数。付出情感的书，会被妥善收藏。付出情感的人，就像默契对话下涌动的心绪暗流，都是值得珍惜的美好。&lt;br/&gt;　　我珍惜这些自然的维系，这是长期默契下印证的信心和安定。&lt;br/&gt;　　耿先生可以用自己的存在方式影响别人。这么多年的职场打拼，他有自己的做事风格，雷厉风行，干脆利落。我时常觉得人生中碰到亦师亦友的人是一种幸运。&lt;br/&gt;　　耿先生一直都是稳重的人，心智成熟，处事低调。其实我知道，所有外界人看到的优秀，背后都是不断努力的叠加。&lt;br/&gt;　　都说认真的男人最有魅力，他性格里有比较执著的部分，内心真正的想法会一直坚持。在无限的时空里，他会用有限的生命去表达自己，完成自己。沉着、真实。有原则和控制，有内心的力量。&lt;br/&gt;　　大概这是一种生的恣意，也活得傲然的赤诚吧。&lt;br/&gt;　　有时候待在一个地方太久了，太熟悉就会产生钝性，需要感知唤醒一些敏感的东西。这并不是旅行、谈话可以解决的。&lt;br/&gt;　　或许一个人需要这么一段时间，或者是几年的时间，来达成内心的一种平衡。有时候感觉就像是一艘快要撞上冰山的船，最要紧的是怎么把自己救出来。&lt;br/&gt;　　总是这样，我们选择什么，就要随之付出什么，得到什么，就要舍得放弃什么。要有自己的标准，跟着直觉和信念走，遵循品德和善良。&lt;br/&gt;　　他一直在尽力避免这种事情的发生，内心的强大也是需要修行的，需要不断地唤醒，不断地强调。这也同时需要不断地学习。&lt;br/&gt;　　所以，他写的文字和他的人一样，坚韧洁净，有倏然而至的沉静。在阳光下生长旺盛，在寂寞的时间里不断行走。&lt;br/&gt;　　我问过他，有没有想过另一种人生。&lt;br/&gt;　　他说，如果换一种生活，应该会找一个靠海的小城市，周围最好有大学，读读书，进厨房做做菜，乐不思蜀。&lt;br/&gt;　　我笑他，原来你喜欢这种隐士的日子。&lt;br/&gt;　　他举起一听啤酒晃了晃说，其实我很享受这一件事。&lt;br/&gt;　　耿先生不论是写书还是生活，都充满了热情。文字本身就是作者情感的载体，落笔之时就有了既定的轮廓，停笔的时候，便建立了一种独立的意识，坦然自处。它是一种存在，被人评论、猜测、回忆，嵌入生命。&lt;br/&gt;　　人到了一定的年龄，就需要获得一种与自我和解的力量，就像是大海冲刷岩石，磨损的同时也改变了内核与气质，使之目标清晰。&lt;br/&gt;　　这些年来，他已经学会不再把希望完全寄托在他人身上，只会越来越努力地去追寻想要的一切。在自己能够承受的范围内尽力做好事情，就可以了。用漫不经心来掩饰心情的起伏，以免听故事的人也不知道该怎么安慰。&lt;br/&gt;　　岁月绵长，我们总要学会，对热爱的事情不遗余力。&lt;br/&gt;　　正是因为有了热爱的事情，才会觉得这个世界多了那么一点可爱。他有他热爱的文字，他努力地去给这些文字赋予灵魂，在文字和照片中，他愿意将自己修行的心得，分享给读者。&lt;br/&gt;　　人生里，总有些心意或者感受，是需要自己体会的。或许独立之后做的最成功的一件事就是不满足那种安逸的状态，最好的状态就是他还是愿意去尝试的，也不怕尝试所带来的任何后果。&lt;br/&gt;　　希望以后的某一天再回首起此刻，是柔软坦诚，能够被温柔对待，而不会因为无力感想要回到从前。也希望未来仅仅是闲暇时的小憧憬，而不是在以后妄想，可以驻足此刻。&lt;br/&gt;　　回忆是一箱丰盛的行李，唯有通过它来感知到曾经的自己。原来时光流逝是这样一种感觉。&lt;br/&gt;　　我们的生命，就是以不断以前进的姿态获得新生。那些只有自己感知到的，来自内心的呐喊，呼啸而来，没有归途。&lt;br/&gt;　　年轻可以提供的，就是大胆，就是没有边际的梦想。年轻最吸引人的地方，就是在于对未知的一切，还有更多的可能性，还有许多的想象力和更多好奇。&lt;br/&gt;　　我很喜欢黄碧云说的那句：如果有天我们湮没在人潮之中，庸碌一生，那是因为我们没有努力要活得丰盛。&lt;br/&gt;　　我们都在走一条更深远的路，路上有不断出现的人，带着爱与相信，在时光里发生着故事。消逝和奔流的时光长河，我们遥望彼岸，等待泅渡。&lt;br/&gt;　　就像是在大雪中被困住的野兽，深一脚浅一脚地走过来，满身狼狈，疼痛是真的，失败是真的，无助也是真的。可是野兽终究是野兽，结果没有答案，过程也须默默地承受。&lt;br/&gt;　　生活还没有教会我们一笑而过的本领，我们还是会一次次地摔倒，只是不会再那么害怕疼痛了。没有了软肋，也就不需要铠甲，爬起来拍拍土，继续向前走，伤口总会愈合的。&lt;br/&gt;　　虽然生活里没有完全的公平，但上天愿给予努力生活的人以公平对待。&lt;br/&gt;　　即便沿途处处可见迷雾、断崖，你还是要往远方去&lt;br/&gt;　　即使江面水雾弥漫，渡口渺茫，你还是要到对岸去。&lt;br/&gt;　　即使一生都在摸索爱的真相，渴望被爱，你还是要穿越生命保持敬畏。&lt;br/&gt;　　力量有很多种，心平气和的那种最坚定。&lt;br/&gt;　　虽然我们不知道未来，但一定要朴素地生活，对所有热爱的事情都要不遗余力。&lt;br/&gt;　　愿你过上我从未看见与理解的生活。&lt;br/&gt;　　爱着一个人，并且被之所爱，内心始终单纯而有力量。&lt;br/&gt;　　就像耿先生在这本新书中所说的：&lt;br/&gt;　　请相信，所有失去的，都会以另一种方式归来。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/bookDetail/jfs/t2779/144/3647246168/138634/b2323909/5795b9aaN9c6cea26.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-09/53a885ee3892175d5c56fea69db7305c.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,2,0,0,0.00,'','',0,''),(8,57,0,'DF51113017','迪芙斯（D:FUSE）女鞋 牛皮革细跟露趾性感高跟鞋',1,0,198,0,1100,0.0000,218.00,179.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3205/233/6756954977/135960/8f06e255/58abef79N0d6cace7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4057/241/2657748778/158983/38b354d3/58abef7aNd7362a36.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3232/279/6721687058/333768/cdfdb3e4/58abef7bN47626263.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3292/303/6556972893/309305/c99338cf/58abef7cN59878e56.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4111/265/2545198635/460399/4d060e6/58abef7cNa34a62df.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3940/263/2494346599/292761/ea49c28d/58abef7dNf7023490.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3931/274/2551637774/309690/481922fe/58abef7eN7836d0a2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3064/8/6692665184/672484/d5efb13/58abef7eNe0d52383.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/imgzone/jfs/t19381/159/1446119633/54251/e38fefc2/5ac9eac0N0b163890.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-09/5514304fa76cbfa9cfc3c7b870e02fd8.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,2,0,0,0.00,'','',0,''),(9,60,0,'D69-39','东方泥土 陶瓷艺术品招财摆件 客厅办公室/烈焰釉大貔貅D69-39 D69-39 大貔貅 烈焰釉',5,0,100,0,3000,0.0000,2199.00,1580.00,0.00,'','','如火焰般跳跃的釉水，每一个都不一样','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8716/70/1862402517/222183/8b3684db/59c08953N140f87dd.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9190/148/1384564953/140460/7f6c11ec/59c08947N01fe590e.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9073/27/1846497824/198980/868c45e7/59c08948N1db2fdb7.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8308/8/1878482835/143397/c15efbe0/59c08955Ne37bc085.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9166/31/1826186121/230742/29afdca1/59c08953Na608bb27.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7951/70/3582246872/218028/65fa7b67/59c08950Nadb749e4.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9028/38/1415078693/168623/eab185e/59c08957N47a0449d.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8296/65/1895799119/190870/1d6bc683/59c08957Nc8633ae8.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9232/299/1691254421/283712/7e1c38a6/59c08958N2ee22c7f.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8314/51/1860784568/215998/6e0d4338/59c0894dN75e0fc11.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9376/91/1889258734/131469/70fbd867/59c0894eN4cec53c0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3904/352/2496818040/157657/e8617b8/58aaa0f5N1d352859.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4036/204/1919564076/85870/84d25a72/589c3659Nb469151f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3136/251/6026561937/105287/6f4aaa69/589c3659N47a9239d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3166/341/6088813156/229304/8d53f44e/589c355aN19c02bb2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3199/144/6092462832/252413/61fcbba9/589c3559Nb9013bb6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3112/127/6038648025/142102/83d6b5c3/589c355bNd55581ae.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3868/349/1865401954/272061/dde41c03/589c355bNbfc6a9ed.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3145/177/6090278448/154591/fb9f8e25/589c355cN6dc9394b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3985/151/1914694210/277940/b36a3aed/589c355cN403cf2cc.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-09/4416d9327a4a9e81e723fb93541fa292.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(10,190,0,'TP0000010','歌诺瑞丝衬衫女2018春季新品休闲宽松长袖格子打底上衣潮-NV10302 黄色 L',31,0,784,0,500,0.0000,169.00,159.00,100.00,'','春季','歌诺瑞丝衬衫女2018春季新品休闲宽松长袖格子打底上衣潮-NV10302 黄色 L','&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;西城工业区&quot; width=&quot;10&quot; height=&quot;10&quot;/&gt;&lt;/p&gt;&lt;p class=&quot;shopname_de&quot; style=&quot;margin-top: 0px; margin-bottom: 0px; padding: 0px 0px 0px 10px; color: rgb(102, 102, 102); line-height: 40px; font-size: 12px; font-family: &amp;quot;Helvetica Neue&amp;quot;, Helvetica, Arial, &amp;quot;Microsoft Yahei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Heiti SC&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; white-space: normal;&quot;&gt;&lt;span style=&quot;margin: 0px; padding: 0px; font-size: 16px;&quot;&gt;商品名称：歌诺瑞丝衬衫女2018春季新品休闲宽松长袖格子打底上衣潮-NV10302 黄色 L&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;span style=&quot;font-size: 18px; margin: 0px; padding: 0px;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 18px;&quot;&gt;&lt;span style=&quot;margin: 0px; padding: 0px;&quot;&gt;货号：TP000001&lt;/span&gt;&lt;span style=&quot;margin: 0px; padding: 0px;&quot;&gt;0&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t14569/72/2288415048/609379/d459aad/5a9421ffN08d5262c.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t18715/74/524129802/397738/e6fde823/5a9421ffN4a36379c.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t17881/33/567679062/287644/ff1c85b6/5a942202N8441dc01.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t17683/22/542601390/394535/df20632/5a942202Nc201cef1.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t18142/28/553725282/212395/c2bc6eae/5a942203N2098232d.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t15661/24/2135497084/242169/25631ea5/5a942203Nb6e529fd.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t17677/269/532105105/264779/ad685e4b/5a942203N016f45a8.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/305cf15d476d02cb2771576c9d81d91d.png',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,1,0,0,0,8,0,0,59.00,'','',0,'/public/upload/goods/2018/04-17/441785014b2fd8701914f07b3d9f4e3f.mp4'),(11,61,0,'1177764','康奈男鞋 休闲鞋新款男士简约休闲鞋低帮复古系带圆头休闲板鞋',1,0,100,0,500,0.0000,318.00,298.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5935/28/8054272055/676630/da5662f7/59855a01N2f216113.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5836/42/9283418543/655387/ac58ba6e/59855a0eNa0b9f606.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5929/363/8201591609/454445/b58cd09b/59855a0fN1a03acfa.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5857/151/9384314388/416709/edfb9d8f/59855a0cN4ea4dc7b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5704/47/9347255071/530241/896c44a0/59855a02N5dd4c3c1.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5731/87/9304907465/237553/a565499d/598559e1N00f794e8.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5911/271/8027282211/631426/4827f8bb/598559e1N2655b85b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6877/201/1778731980/449063/9313e524/598559e1N414d3676.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5986/316/8127925535/214680/f2583ace/598559e2N76efa730.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5812/310/9213697620/462488/922c2430/598559d6Nfea3921e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5677/36/9362452061/326463/e665d168/598559e0Nc88155b5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6934/71/1754670677/226941/555049d2/598559e5N6203195f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5881/1/9324784334/279815/6051384/598559e5N7119b7f2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5716/45/9350959242/242719/28de0944/598559e6Nbe126581.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6100/59/8118507265/217058/2b7c6b6b/598559e7Neaf2f59e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7081/196/859641421/142250/16299714/598559e7N26006ab1.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5695/299/9276554555/72832/90c0e13a/598559e8N314c182d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5737/159/9317851426/165385/725ab72e/598559e8N4129a5b7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7171/164/846627738/183454/ab8d586f/598559e5N8fb18b26.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7063/214/851030552/145674/dbcd4b35/598559e9N6e5807e7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5890/277/9347947771/118750/2e651762/598559e8N16549ef2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6826/251/1749460609/102744/75bc4749/598559e1N6b7df8b7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5878/286/9322319668/99071/11df3664/598559dcN9675e46d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5779/179/9349353363/64455/116c79d5/598559eaN7306c8f0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5884/291/9261250270/94750/3ca4e82c/598559ebN291ead5f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6802/260/1803187505/52300/ca5a30eb/598559ecN99e37a8d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6934/100/1744076251/150276/f6a6faf3/598559ecNbc6d96d5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5839/213/9271139080/106710/9bc6f7cb/598559e4N7ce94eb3.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7120/203/871107673/74638/e40ffe70/598559edN5a6ca1ed.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6022/67/8209534218/132218/efa86339/598559edNd3313d3b.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3304/214/5847476363/56036/a58bd26f/589aab69N60b65541.jpg?t=1486531470678&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2194/191/2948657887/161138/c03c0743/571f167bN7e4f2700.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2815/358/653444643/170161/8dda8989/571f167bNca33c06f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2797/83/658638492/94803/23b25627/571f167cNa5897485.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4357/163/632807916/400382/e9bb3300/58b79991N62b16477.jpg?t=1488427411860&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-09/89917c25664b5a1e5f6c2b096f9768df.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,0,0,0,0.00,'','',0,'/public/upload/goods/2018/04-09/b07bd3b4e91e93055c5def806edecb1a.mp4'),(13,62,0,'TP0000013','【套餐赠耳机】HUAWEI/华为 畅享8 Plus 全面屏手机',9,0,2398,0,1000,1.0000,1799.00,1699.00,1000.00,'','华为手机','【套餐赠耳机】HUAWEI/华为 畅享8 Plus 全面屏手机','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2616970884/TB2aavkhk9WBuNjSspeXXaz5VXa_!!2616970884.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2616970884/TB25mu_hhSYBuNjSsphXXbGvVXa_!!2616970884.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2616970884/TB2qUlJb8yWBuNkSmFPXXXguVXa_!!2616970884.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2616970884/TB2qUlJb8yWBuNkSmFPXXXguVXa_!!2616970884.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2616970884/TB28gRUb8jTBKNjSZFDXXbVgVXa_!!2616970884.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2616970884/TB25qxCb.OWBKNjSZKzXXXfWFXa_!!2616970884.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2616970884/TB2_8D8hhGYBuNjy0FnXXX5lpXa_!!2616970884.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2616970884/TB25MDvheSSBuNjy0FlXXbBpVXa_!!2616970884.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2616970884/TB2bQ4jbYwrBKNjSZPcXXXpapXa_!!2616970884.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2616970884/TB2Di1ab77mBKNjSZFyXXbydFXa_!!2616970884.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/4c67162a2a45e4c4fbfea50b64241567.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,2,0,0,0,2,0,0,800.00,'','',0,''),(14,95,0,'TP0000014','戴尔(DELL)灵越AIO 23.8英寸IPS窄边框一体机台式电脑(A6-9225 4G 1T 三年上门 无线键鼠 白)',14,0,100,0,5000,1.0000,4699.00,3699.00,2000.00,'','一体机电脑','戴尔(DELL)灵越AIO 23.8英寸IPS窄边框一体机台式电脑(A6-9225 4G 1T 三年上门 无线键鼠 白)','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/cms/jfs/t16366/69/2518815987/114731/8bebd982/5ab1d52fN71696b3f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/jgsq-productsoa/jfs/t17335/52/1309812446/174075/c89f6530/5ac372cfNc195b268.gif&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/f2e199fdc413372717f6fc7427a1086f.png',0,-28800,0,1,0,0,0,1,1,50,1,0,0,0,0,0,0,0,0,0,0,100.00,'','',4,'/public/upload/goods/2018/04-17/a173460013d64b62d2cad1604bf0449d.mp4'),(15,16,0,'1218','贝蕾曼 t恤女2018夏新款短袖韩版半袖宽松休闲时尚上衣打底',38,0,483,1,300,0.0000,99.00,79.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4606/287/1452720775/313486/5389fad5/58df47b3Nb3d0ac35.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4351/241/1400545218/166677/f77b3715/58c0c311N3cb70aa9.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3094/76/8183506985/155823/3e064b00/58c0c310N17fa7f8d.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4312/271/1354809308/220240/6e63a5dc/58c0c310N27f7e6fc.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3277/192/8520043199/300487/5fd8143c/58c51981N708cb1db.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4315/65/1500455499/145383/6dbedd39/58c286f6Nbd522cdd.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4315/275/1341187236/191170/c16738d9/58c0c314N9e9caede.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3148/127/8095331680/161529/99728e67/58c0c313N3ff3bb82.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3148/26/8135678818/167224/9fb7c33f/58c0c312N787ead0c.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4228/32/1360889969/129915/9e9a3d6f/58c0c313N5c07bb02.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3208/218/8103298931/144476/1893827b/58c0c315N01905654.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4357/193/1289764830/173280/42a016ae/58c0c312N75128ad7.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3181/113/8196600715/152914/a217e96c/58c0c312Nf48c54a6.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4129/64/1344471255/154264/ebcfdccc/58c0c314N406b22c7.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3166/115/8252166176/122098/b013b9e9/58c0c315N42f01a62.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3232/226/8177498703/118943/a09adb7c/58c0c312N637e17bf.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4162/175/1351141632/141787/45d93d5d/58c0c317N369ab9d2.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4240/236/1373011591/177959/818d5a0/58c0c315Nfd00e7f0.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3145/144/8186607212/150120/b83f4826/58c0c316N5bcbe70e.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4207/183/1394009320/143282/36e50d63/58c0c316N4920f103.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3247/251/8272343409/116109/cacff9cf/58c0c317N7edc255f.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4306/307/1356970375/133093/961ba0e4/58c0c317N7c746a93.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4195/199/1348710721/171700/5ffc6cc4/58c0c315N1b7a026c.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3235/110/8152321855/122113/685e2f8b/58c0c317N4bca9cea.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4171/201/1349502609/178867/1bb0563/58c0c318Na89fa0ea.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4201/185/1335123468/163810/4ba640fb/58c0c316N03f0c233.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3238/301/8204958358/138847/b3031d59/58c0c318Nda1377ee.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3049/84/8199620284/154502/64bf99e8/58c0c31aNcec55c33.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3247/46/8150856574/161085/348d33c8/58c0c319Ne38d4bb5.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4342/269/1311663595/154824/26fa93f3/58c0c31aN109542fa.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3151/206/8168047492/172896/59c57e29/58c0c319N9928c587.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3154/203/8168324385/164737/5ec7df73/58c0c31aNb5e9aa04.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3163/180/8128059482/121269/e77c39c4/58c0c31aN3e5e58d1.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4174/208/1320150850/111602/e9855739/58c0c31aN9bfbd6a8.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3181/70/8253732837/149468/cd479664/58c0c31aN791a06b6.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3292/162/8116764491/134882/8af9dc/58c0c31cN97d038d1.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3259/260/8287418505/122832/a4faa303/58c0c31bNe4c59ebc.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3589/24/587629797/133766/e2c7c697/58117283N95e0222e.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-09/5d9607b7e728bfbf7a340330d58d604b.png',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,0,300,0,0,17,0,0,0.00,'','',0,''),(16,80,0,'116 115','华为耳机原装手机 荣耀9/8/v9/p9/mate9/8/p10/v10/7x/6x 华为AM115（标准版）',17,0,498,1,100,0.0000,76.00,48.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7279/5/489804384/310242/6c43237d/5993f9a1Nab4a3ecd.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6628/143/1593410564/306813/db587ebf/5954a22cN260c1cdb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6043/296/3266158163/187923/8f8ee315/5954a22eNe2b9f5c4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6721/94/1571710148/65907/f4ed0990/5954a22fNce443fa9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6394/333/1639467860/203701/5ae0196d/5954a232N00f04b2a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6319/248/1626667841/79320/241ca670/5954a225N3b93924d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6433/276/1626731930/81662/62064b24/5954a233N8b74b439.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6313/240/1608730752/163730/64666d92/5954a23eNbd0e2731.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10891/269/881835637/259956/b23d5e13/59d9e636N92300344.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-09/6e81bdb2e0a3ecc8ad546f99bd577a74.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,2,0,0,0.00,'','',0,'/public/upload/goods/2018/04-09/52cca935bcd90d7a5cb8ff729cd8eb01.mp4'),(17,97,0,'TP0000017','英特尔（Intel） i7 8700K 酷睿六核 盒装CPU处理器',1,0,200,0,90,0.0000,2799.00,2599.00,0.00,'','','【八代新品发售】英特尔酷睿八代I5-8500、奔腾、赛扬新品发售！英特尔，让电脑性能更胜一筹！','&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t17443/58/472662614/1640612/122f65a8/5a7c1ebcN0d53b382.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/jgsq-productsoa/jfs/t19564/256/1315224186/172029/f0644b65/5ac46abfNc191cc9f.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-09/cc0cc16df043df1ad3737295e6c4fd2e.png',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,0,0,0,0,0,0,0,0.00,'','',0,''),(18,343,0,'TP0000018','格力（GREE）正1.5匹 变频 品圆 冷暖 壁挂式空调 KFR-35GW/(35592)FNhDa-A3',3,0,150,0,13500,0.0000,3899.00,3399.00,0.00,'','','','',NULL,'/public/upload/goods/2018/04-09/3777e0843252de68b331c85673c3f810.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(20,223,0,'5570','无钢圈文胸少女发育期胸罩初中高中生抹胸美背心学生跑步运动内衣 黑色小字母 均码',15,0,354,0,100,0.0000,19.90,14.90,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18400/284/1015360005/546239/88290801/5ab65290N2e1a7768.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5563/152/2265442142/242884/489bc6a7/59194aa1N86f7e7bb.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5560/206/2295667705/603677/c264b01e/59194a9eN1a81f584.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5077/187/2216776833/377008/e5edcd1f/59194a9aN150727fa.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5410/203/2122405484/695072/13588709/59194aa2N0109ffd0.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t17236/118/1005433675/531466/fe725296/5ab652a9N8f2d263f.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5158/77/2309460187/259718/615c854/59194a98Nb3ff9c00.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5095/157/2156666802/374965/13ff3140/59194a9aNdf29c689.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5104/60/2176763501/684311/c0b333aa/59194aa2N5ea259a6.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/16bbd0cc84f5db6e2616e76318d892cd.png',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,0,0,0,12,0,0,0.00,'','',0,''),(21,24,0,'nz184','花花公子韩版裤子男潮原宿风bf百搭青少年牛仔裤加大刺绣学生修身小脚裤',20,0,296,1,500,0.0000,270.00,130.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t11458/261/382170273/41251/aeb0a939/59eee949N1e6dd16c.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7222/38/4201054292/253683/37f26b98/59eee94aNbb1d7f8d.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t10192/327/2109506048/259262/48c68795/59eee93dNc2d55163.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9805/147/2144862536/272257/b2e9c60b/59eee933N0ca84425.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7795/343/3785183598/251618/522186f9/59eee944Ndb800546.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t11407/257/391253465/228028/ffe8b654/59eee94cN7d2b2e11.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t11947/49/382571936/218430/a1a70738/59eee932Ne5c8e3fc.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9943/128/2104488600/231622/e7b08e80/59eee94bN13e2d131.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t10903/213/2105082096/242194/5fb1c875/59eee94bN4243c48b.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9829/154/2099557252/259941/866b3d6e/59eee934N79085475.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9910/195/2082121497/245198/632d65f8/59eee935N21dbca88.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t11245/336/367814837/137280/672e63b3/59eee94dN8a49e788.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9940/161/2070400766/153111/21841f5e/59eee94cNd8863ae5.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-09/c6a16618053bcc67b1bd354ff1fa0976.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,4,0,0,0.00,'','',0,''),(22,108,0,'TP0000022','北斗童书·中国地图：跟爸爸一起去旅行（百科知识版）大开本、精装绘本 [3-12岁]',9,0,100,0,110,1.0000,39.00,33.90,151.00,'[{\"amount\":3,\"price\":33.9},{\"amount\":5,\"price\":30}]','','北斗童书·中国地图：跟爸爸一起去旅行（百科知识版）大开本、精装绘本 [3-12岁]','&lt;p&gt;&lt;img src=&quot;http://img14.360buyimg.com/da/jfs/t17404/145/1308849123/64677/a6c3718b/5ac46640Ne351a2cc.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/vc/jfs/t18946/214/1468945429/115842/71f6dd11/5acadca4Nedd066e0.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/vc/jfs/t9613/225/2168217140/133680/c2343a28/59f291f6Nc6ec0ff0.gif&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/vc/jfs/t9916/164/2212537834/298319/ea4bf190/59f291f6Ne2ef275f.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/vc/jfs/t9505/165/2228281882/244603/91f933b2/59f291f7Nd6b7de93.gif&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-09/40ba16ecbbfe7eebe668ee086ea705d6.jpg',0,-28800,0,1,0,0,0,0,1,50,0,1,1,0,4,10,0,0,0,0,0,100.00,'','',0,''),(23,27,0,'PZPOL6216','帕森（PARZIN）太阳镜女款墨镜 复古大框时尚偏光太阳眼镜',18,0,653,0,30,0.0000,129.00,89.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2851/23/1207169536/221620/71166eef/5737ed3aNfa901a10.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2638/343/1201758998/145062/19a8b2e0/5737ed3bN8822249a.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2821/31/1237222807/182761/c520454b/5737ed3bN065ce8c7.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2590/23/1188088627/241186/d187f5d0/5737ed3bN4a554e9e.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2695/115/1258393773/150017/e6f91c50/57392ae6Nce4774bb.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2824/26/1207068159/80756/869425e7/5737ed3cN0b4dec73.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2704/42/1255763546/319128/d0b270de/5737ed3dNc3a86434.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2680/347/1256561770/1080954/b8d96b94/5737ed3fN9aeb082a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3286/156/5648931404/204725/d70a01d9/586caf84N9e32180e.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2869/349/1238746867/113693/28f95402/5737ed3fNbe9bafe0.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2833/343/1259261202/415826/e9ec47d5/5737ed40N64695033.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3166/262/5362301024/266966/b8b920ab/586caf85N2f974868.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2887/40/1228313069/106444/e0a70270/5737ed41N1ba54c6d.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2830/15/1220723028/106761/1711f484/5737ed41Nf0e25076.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2662/344/1229571764/33781/82fda6bc/5737ed41N20b47c8c.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2854/18/1210301819/116779/c3524da1/5737ed42Nd548ff44.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2641/36/1192451398/35966/6bafc071/5737ed42N8445338a.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2731/37/1173104571/113377/8b7c75fe/5737ed42N144b0859.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2722/30/1213163637/39553/794dca3d/5737ed43N8aa83f7d.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2653/347/1190184076/104945/c6519dc4/5737ed4fNd9d8ee6c.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2905/31/1214338006/35497/84b0a900/5737ed50N42c86a87.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2887/65/1206423912/85056/a662a634/5737ed50Nf0a73c2a.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2749/71/1262189434/28127/bc743e9b/5737ed50Ncf9981e0.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t19057/97/1009856642/114145/ffb9a26c/5ab5c1e4N8a0e134e.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2758/59/527103155/469844/5668a8c3/5718c333Nd590961b.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-09/2df25ccda9b6734c2dc78081fade3741.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,13,0,0,0.00,'','',0,'/public/upload/goods/2018/04-09/280a40401f7a215fd17a7533ec1fd3f7.mp4'),(24,28,0,'TP0000024','榴芒贝贝童装女童套装2018春装新款休闲三件套儿童春秋运动套装女孩大童韩版少女小学生衣服',0,0,549,0,800,0.0000,129.00,89.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6556/107/2121500008/268344/a2535441/595da9e7N481cb10f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6247/83/2189685276/541181/e015a98a/595da9e8N1528db2e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6148/34/2120491493/157117/1e2dfedd/595da9e8N691d958d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6712/109/2083627970/373187/f71c1e60/595da9e9Ne8624436.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6253/55/2146010785/304661/c2c39bdd/595da9e9N0317c0b5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6166/65/2069735092/304571/b05a34f1/595da9ebNc50fd1f8.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5734/245/5295960325/216970/13c0b54e/595da9eaNd1a7b68c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5974/133/4123784780/241328/b69b2b54/595da9dfNe4e16253.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6298/51/2115989546/208866/c302d272/595da9e8Nc9770a57.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6601/198/2151521549/293217/370d6270/595da9ebN4ef684a9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6064/297/4058431209/496488/cab82d8a/595da9edNb16c1db2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6655/160/2087258260/251202/6128b6f9/595da9edNe0bc0ecb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6736/226/2113720913/220907/49f80d9/595da9e7N9beb5d59.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5884/175/5271852511/243291/9b107829/595da9efNc735c660.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6007/240/4038554774/327199/6ef91aee/595da9efNa88e3846.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5902/161/4160308162/152642/e8a03c89/595da9f0N2c633ef1.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-09/1baa3c8f8dcb7238cbfb160a3e75bca1.png',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,0,0,0,0,1,0,0,0.00,'','',0,''),(25,62,0,'TP0000025','直降200元◆vivo Y85全面屏手机 vivoy85手机 y75 y97官方旗舰店',9,0,100,0,1000,1.0000,1698.00,1598.00,1000.00,'','','直降200元◆vivo Y85全面屏手机 vivoy85手机 y75 y97官方旗舰店\r\n直降200 送电话手表+碎屏险','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t19534/333/1302273943/67735/87dd7276/5ac4b14eNbfc6992f.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t19300/18/842292190/136891/9814a5b7/5aad081dNaf967d75.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t17995/111/844629216/163045/bf9f8ca5/5aad081dN21e02b50.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18427/350/859895865/114369/65da642e/5aad081dN9cdec04f.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t16099/310/2456449237/131524/1ee30405/5aad081dNc0e79e52.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t19027/141/853567936/137597/19cf89fe/5aad081dN4d22c000.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t14551/129/2610377398/178383/1fe4bbd7/5aad081dNaee1e5f2.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18568/239/859140662/87211/9f4a7f6d/5aad081dN3e56ae6c.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t14593/148/2643907176/101188/136700c6/5aad081cN6acb1a34.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18565/76/905267710/95129/a495f272/5aad081eNca06b6ad.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t17251/333/840755990/155288/af380479/5aad081eN3d1d2123.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t16507/123/2245669490/108104/673ca7bb/5aad085aN5a6812ab.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t17674/26/862526883/50807/b6b85d3e/5aad085aN1849cca1.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t14317/315/2633571904/81074/95a88719/5aad085aN190dc792.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18532/307/1502475904/799613/eadeb478/5acd7d55N08e527cc.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/9021d9a5a60989500d49078cd1e7ff72.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,0,0,0,10000.00,'','',6,''),(26,48,0,'TP0000026','雷士（NVC） 【满1699减550】雷士照明 简约欧式吊灯壁灯 客厅卧室餐厅走廊吊灯壁灯',2,0,300,0,4000,0.0000,3599.00,3099.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15043/14/2577010450/90838/3caa1301/5aa8859eNdb26de35.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17710/325/774717009/86739/faa7a0a3/5aa8859eN85a8cad0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15028/40/2585409691/88897/cf8b1be9/5aa8859eN00c02f55.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18610/202/764965028/91906/d16686dc/5aa8859fN8d72379d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8722/21/1989388733/77192/59a67e44/59c23a99Nf45c2112.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8086/185/2024024216/200969/744941b5/59c23a99Nb2fdcf2e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8557/267/1983158415/90747/c9c72923/59c23a9aNf3ba902a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8725/181/1961566596/180317/67abe17c/59c23a9aN3e3bf6c5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8548/269/1995210488/167640/9f66711f/59c23a9aNc129e32f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8608/227/2580789406/189048/47c53239/59d1add1N55383fa2.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-09/9eed16eb1b1f1f3ccc4fe89131ad4d96.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(27,80,0,'TP0000027','Sony/索尼 MDR-EX155AP 入耳式耳机通用重低音手机线控带麦通话',17,0,95,0,100,1.0000,168.00,125.00,11.00,'','','Sony/索尼 MDR-EX155AP 入耳式耳机通用重低音手机线控带麦通话','',NULL,'/public/upload/goods/2018/04-09/3439ff946b1f4120be63b760c1911154.jpg',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,1000,0,5,0,0,11.00,'','',0,''),(28,68,0,'TP0000028','Apple 苹果 iPhone 6 手机【移动合约购】老号码不换号',4,0,200,0,600,0.0000,2599.00,1988.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15883/298/2433347010/261475/be1e995c/5ab37fc4Nbba074b1.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17128/112/961843354/141761/857e5bfd/5ab37fc4N0913bc4d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15937/281/2536394775/192854/2ca70e65/5ab37fc4N8995d913.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18472/196/950595832/202851/39a6f7eb/5ab37fc4N8e7af57c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17338/225/980602264/225956/6a891834/5ab37fc5Nd2a7d179.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16273/293/2327178387/570014/80c2ff47/5ab37fc5Ndb0c7a98.png&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18355/59/953379717/196010/1df534ff/5ab37fc4Na676be37.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18472/192/964972700/1018021/8dd7b298/5ab37fc5N52cbc3e6.png&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17614/67/962336417/295204/f0800445/5ab37fc5N882c50fc.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19543/354/933068201/259981/68953538/5ab37fc5N1eac5bea.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15877/316/2589920893/206971/93421473/5ab37fc5Na8e075d6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18904/55/952292114/73718/39dc3670/5ab37fc5N23f62c1d.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/412b393ec99ce6b54b9a7879e6ef9e2f.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(30,69,0,'TP0000030','中国移动 移动流量卡4g全国通用无限流量卡设备卡手机纯上网卡 9.9元/月包5G全国★移动流量王',2,0,599,0,1000,0.0000,58.00,38.00,0.00,'','','关注店铺购流量王赠20元费。空卡需用户每月自动充值。提供号码为虚拟号码，以实际收到号码为准','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14923/21/2648841098/486979/d360599a/5aaf78b2N0077ef08.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18886/115/984755102/561128/8a7360f1/5ab4d199N8697bd72.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19405/27/964122412/424215/bb454a20/5ab46ed8N7f4284e1.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/popWaterMark/jfs/t17890/307/1388759309/282160/cb31bcc7/5ac879a0N1f9e52ae.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14158/27/2300868512/389817/12d4572/5a39d0c8N83e5f20f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18514/350/519341013/123346/81432e19/5a928d3aNa7de3834.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17239/137/451802169/474871/81585fc3/5a758e9aN35cceb5f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13450/296/1716551128/438164/1c2b2aba/5a278be5N3c1bbb0d.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/53f135984e73edf15c9c08f3fb6a226f.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,1,0,0,0.00,'','',0,''),(31,400,0,'TP0000031','大青皮绿芒果新鲜水果大青芒果玉芒果生鲜1500g3-5个果',11,0,400,0,500,1.0000,19.00,15.00,12.00,'','','大青皮绿芒果新鲜水果大青芒果玉芒果生鲜1500g3-5个果','&lt;p&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t16399/115/2288775797/207599/5973c67f/5aa62132N4600eb5e.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t16828/332/909186416/212588/a5ea4966/5ab0b324N2d2b055b.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t9691/229/1351078744/211088/90425d96/59df132bN6e62822f.jpg&quot;/&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t14284/147/2520259500/348897/5e64d0bf/5aa62143Nffde7a6e.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t10930/111/1318824988/195543/1d4cbc8c/59df132fN8afcf8d8.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/d045f9c1ca75fc07cf833264b59aad10.jpg',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,3,100,0,2,0,2,0,0.00,'','',3,''),(32,396,0,'TP0000032','【雅安馆】四川雅安 红心猕猴桃 15个装 单果约80g-100g',7,0,99,1,500,1.0000,21.00,20.90,16.00,'','','【雅安馆】四川雅安 红心猕猴桃 15个装 单果约80g-100g','&lt;p&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t17215/120/1426708249/335850/8d04b18a/5acb4a4cNb1dbfe8b.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t7549/186/483041576/175375/8b945f82/5993d1d0N126696dd.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t7276/201/485953713/229929/d3ad64ec/5993d1dcN3234e4bf.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t7840/185/513225784/102791/c70ec25c/5993d1e1N02d6f3b5.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t7204/315/2281525312/246102/18d0772/5993d1e2N8adfdb3f.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/c82a80c273b369dfab1afeea2fab9d85.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,3,0,0,2,1,0,0,0.00,'','',0,''),(33,12,0,'TP0000033','欧莱雅(LOREAL)男士8重醒肤护肤套装（洁面膏100ml+醒肤露50ml+洁面50mlx2+面膜单片x5）新老包装随机发货',5,0,100,0,11,11.0000,499.00,399.00,11.00,'','','欧莱雅(LOREAL)男士8重醒肤护肤套装（洁面膏100ml+醒肤露50ml+洁面50mlx2+面膜单片x5）新老包装随机发货','&lt;p&gt;&lt;img src=&quot;http://img14.360buyimg.com/cms/jfs/t17011/22/618732548/339036/3584881c/5a97b572N92b338f4.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/edc2f2088212fc4ab04389930f7e42cc.jpg',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,0,0,0,0,0,0,111.00,'','',0,''),(34,75,0,'TP0000034','KOOLIFE 畅享6S手机壳 透明保护套/TPU全包外壳 硅胶防摔软壳 适用于华为 畅享 6S',1,0,1000,0,35,0.0000,20.90,15.90,0.00,'','','','',NULL,'/public/upload/goods/2018/04-10/d823c918acd62639aedad0b02e3f3b0f.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(35,84,0,'TP0000035','GoPro HERO 6 Black 运动摄像机 4K60帧高清 语音控制 防抖防水',3,0,150,0,460,0.0000,5099.00,3398.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t18676/289/1338851817/653719/f8645b38/5ac49ff9N17993f01.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t17770/223/1300598674/763789/21327f45/5ac4a060N47ad33dc.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t19168/121/1319208831/807578/a40441f3/5ac4a071Nadca816e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/jgsq-productsoa/jfs/t19564/256/1315224186/172029/f0644b65/5ac46abfNc191cc9f.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/6060d49d72db0a3dea1b01f9891f25a7.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(36,55,0,'TP0000036','雀巢（Nestle）脆脆鲨 休闲零食 威化饼干巧克力味24*20g+8*20g',14,0,737,0,300,0.0000,50.00,25.70,20.00,'','零食，巧克力','','',NULL,'/public/upload/goods/2018/04-10/dc78ded272ec8fdb9acfbb7702064ac7.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,3,0,0,0,1,0,0,5.00,'','',0,''),(43,61,0,'TP0000043','双牌 动感单车家用超静音健身车室内运动自行车健身器材 SC-5000',39,0,196,0,111,111.0000,699.00,599.00,11.00,'[{\"amount\":3,\"price\":19.9}]','11','双牌 动感单车家用超静音健身车室内运动自行车健身器材 SC-5000','&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2746/182/1544931421/393101/ffa36df3/57427707Nbd1d74ce.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7681/49/2178365044/192673/4947819e/59a91aa0N302eabc1.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2743/69/1527973015/335033/d6e0cbe5/5741750aNdd8849cb.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8065/60/355101271/266613/12565807/59a91aa5Na88c6585.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7225/346/2161244911/273702/68a10890/59a91aa7N48290f28.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/8209c084dc30cc4d4b75e6f4247a2d80.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,1,0,6,11,0,0,4,4,0,0.00,'','',3,''),(44,46,0,'TP0000044','LUOLAI罗莱家纺 229纱支纯棉四件套 全棉床上用品床品套件床单被罩 WD5006晨暮间 220*250',4,0,150,0,3860,0.0000,1599.00,999.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2659/350/1059790898/67186/80e92f07/5732dcbcNf9bbdd36.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2665/1/1069720182/78583/1ef8ce75/5732dcbdNdf7e31a7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2737/22/1084356994/77219/828ad253/5732dcbdNd53b5627.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2599/8/1072502827/45261/fe657aa5/5732dcbdNc791dfd9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2908/5/1048540847/107450/2688ffc8/5732dcbeN0e721074.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2677/16/1071738157/20462/4f82462d/5732dcbeN2a5f3f2a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2872/10/1076901820/76774/b7b21882/5732dcbfN7bd29acb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2800/44/1093899205/53037/9cb135f0/5732dcbfN42a9c5db.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2692/33/1072133794/32717/95855c0a/5732dcc0N76101790.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2731/51/1038663402/85181/d402157e/5732dcc0N89807cb6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2707/85/1116328641/60307/4ad566ac/57345180Nf1054f50.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t6613/119/664493725/133648/6022bfe1/594382f5Ne7d11039.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/acbc2a97b56c4fb0892aa4e9437544b9.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,0,1,34,0.00,'','',0,''),(45,61,0,'TP0000045','匡途超轻超短折叠登山杖伸缩直柄外锁手杖徒步爬山装备拐杖棍户外',8,0,200,0,11,0.0000,20.90,19.90,10.00,'','','匡途超轻超短折叠登山杖伸缩直柄外锁手杖徒步爬山装备拐杖棍户外','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2192673981/TB2kMzocHZnBKNjSZFrXXaRLFXa_!!2192673981.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2192673981/TB2R8mIrolnpuFjSZFjXXXTaVXa_!!2192673981.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2192673981/TB2NlCpXpmWBuNjSspdXXbugXXa_!!2192673981.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2192673981/TB2fhyuXmYTBKNjSZKbXXXJ8pXa_!!2192673981.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2192673981/TB2YmqpXbZnBKNjSZFKXXcGOVXa_!!2192673981.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/9738a2207124267cac641092dd8f804f.jpg',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,1000,0,0,0,0,0,0.00,'','',0,''),(95,15,0,'GDB604-9991','2018新款大码女装春装修身显瘦中长款时尚连衣裙9991',15,0,300,0,1000,0.0000,366.00,268.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img13.360buyimg.com/imgzone/jfs/t16123/87/2445968031/557633/7735949d/5aaf5134Nb0b3fb0b.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/imgzone/jfs/t17845/8/860810327/137100/f6b5e54b/5aaf5134Nf1fc68aa.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/imgzone/jfs/t19441/273/903021425/246368/c24ba497/5aaf5135Ndb9a46fb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/imgzone/jfs/t16228/283/2508966783/376120/24302161/5aaf5137Ne53c1510.jpg&quot;/&gt;&lt;img src=&quot;https://img13.360buyimg.com/imgzone/jfs/t17818/14/870671412/332100/24dfec13/5aaf5137N38a93e28.jpg&quot;/&gt;&lt;img src=&quot;https://img11.360buyimg.com/imgzone/jfs/t19054/301/873185558/321776/1611b8a2/5aaf5139N4dedd9f4.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/imgzone/jfs/t14524/198/2644954772/306911/7f648ae0/5aaf5139Nbc92ead8.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t17029/50/893479660/483174/b444a051/5aaf513aN809ba828.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/imgzone/jfs/t17899/275/863455351/478126/f572a4a8/5aaf513cNaf49f34b.jpg&quot;/&gt;&lt;img src=&quot;https://img11.360buyimg.com/imgzone/jfs/t15247/151/2384551673/366455/9b97d1e2/5aaf513cN6fd0bf68.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t14395/230/2639935703/338281/9182012/5aaf513dNb42a6c15.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t14956/283/2691376474/359043/da032385/5aaf513fN3dee580c.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/imgzone/jfs/t18955/311/924545039/425872/a98262c8/5aaf5141N295205ea.jpg&quot;/&gt;&lt;img src=&quot;https://img11.360buyimg.com/imgzone/jfs/t17785/340/875896443/467960/fd07769e/5aaf5144N47b0598d.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/imgzone/jfs/t19099/318/861130905/383223/17084430/5aaf5147Nad0d0ba6.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t14257/137/2672404092/520971/aaf159f5/5aaf514aNe9b58569.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/imgzone/jfs/t18118/250/888726099/360929/3de721ec/5aaf514cNc17e41e6.jpg&quot;/&gt;&lt;img src=&quot;https://img13.360buyimg.com/imgzone/jfs/t17479/9/894025937/330551/5061a31d/5aaf514dN8eec5eb5.jpg&quot;/&gt;&lt;img src=&quot;https://img11.360buyimg.com/imgzone/jfs/t15076/316/2547857758/357427/834b705f/5aaf514eN495dde23.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t16390/343/2367466163/451470/e37c0269/5aaf5151Nf0f6c7f6.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/imgzone/jfs/t16588/167/2479328727/487673/f8286a1b/5aaf5153Na79857fb.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/imgzone/jfs/t15586/6/2491416891/284969/7b16aa2a/5aaf5155N83f6b7d6.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t19387/313/905676260/251554/a507544d/5aaf5155N157a173b.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/imgzone/jfs/t19018/348/929018665/310632/cead93b/5aaf5157Ne8c0f41e.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t16510/174/2463184532/264058/1dfa89dc/5aaf5157Ne8ef095e.jpg&quot;/&gt;&lt;img src=&quot;https://img11.360buyimg.com/imgzone/jfs/t17284/46/898232522/212273/6ca5c5eb/5aaf5159N0c892cf8.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-11/1159f82b3accc3009f0be3542f0260d4.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(40,58,0,'R2412003211','梦特娇Montagut2018春季新款真皮女包时尚女士手提包欧美潮流拼色单肩斜挎包',2,0,360,0,1000,0.0000,869.00,799.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10615/83/2574644188/141747/7a3e03c8/59f93fbbN12d919d6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10555/98/2595733940/161000/aa863bcc/59f93fcaNbf30a334.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10423/21/2545937461/159106/f6af2bdb/59f93fcaNdf158763.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11752/58/804666627/160570/d2d93f16/59f93fc7N41022a2d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9973/140/2578256784/94142/231fffbe/59f93fcaN709d8743.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11767/45/820159815/166392/99d72c48/59f93fc7N18f2a4cf.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10987/340/2010343054/141817/2216a300/59f93fcaN806b9d78.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11347/117/828172060/267848/42cdc525/59f93fbcN9ea5d747.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11932/320/810935171/20785/400e8831/59f93fcaNcfe8c844.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10564/75/2510558119/181030/83ac12e/59f93fb6N5d623e03.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7993/115/3426803065/127756/1e1e22d6/59f93fcaNa8e0988f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10411/31/2517893355/150083/d610f1e1/59f93fcbN0e2e783e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10444/318/2540144449/133052/d12a9ecf/59f93fcbN7388933f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10327/30/2580354950/75039/47b3edce/59f93fcbN24b85285.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10417/3/2545527667/89370/1789de76/59f93fcbNf4f5a079.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10747/91/2514857975/104759/c3c2dc0b/59f93fcbN780af1da.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11143/255/834617345/126075/eb62ac46/59f93fcbN4b40b36e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10450/304/2496992124/119117/d315f587/59f93fcbNbbc6643f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11905/327/796878772/69734/b5a9a677/59f93fccNd857836b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9799/63/2504096289/78744/7b47180f/59f93fccNc10cbb56.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10033/106/2535014956/165386/a3e018e6/59f93fccNb1946501.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10192/223/2531614639/146419/cf298b1e/59f93fc5N93081cd9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11890/346/811340531/92467/93b58a07/59f93fccNe1212d29.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10381/308/2483109060/111628/1145e7fd/59f93fccN282f7cf8.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7720/171/3555594842/114223/6d6f3d1d/59f93fc6N54fccd72.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9523/114/2551414040/53634/db1e302/59f93fc7N7a3550db.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/39d69859b1e277dbd06f40e39c750c45.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(37,99,0,'TP0000037','罗技（Logitech）G502 炫光自适应游戏鼠标 RGB鼠标 FPS鼠标 吃鸡鼠标 绝地求生',5,0,200,0,111,1.0000,499.00,399.00,11.00,'','','罗技（Logitech）G502 炫光自适应游戏鼠标 RGB鼠标 FPS鼠标 吃鸡鼠标 绝地求生','&lt;p&gt;&lt;img src=&quot;http://img30.360buyimg.com/jgsq-productsoa/jfs/t17335/52/1309812446/174075/c89f6530/5ac372cfNc195b268.gif&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/0637d340d8b2dead246eadea6fab09df.jpg',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,5,100,0,0,0,1,0,11.00,'','',3,''),(39,72,0,'TP0000039','自动发货 steam 充值卡5美元钱包卡5美刀 5美金 统一通',10,0,12,0,0,0.0000,150.00,100.00,10.00,'','','自动发货 steam 充值卡5美元钱包卡5美刀 5美金 统一通','',NULL,'/public/upload/goods/2018/04-10/5ca310ba090891abf6597a7079f55244.jpg',1,1988121600,10,1,0,0,0,1,1,50,1,1,0,0,0,0,0,0,0,0,0,0.00,'','',0,''),(38,100,0,'TP0000038','雷蛇（Razer）BlackWidow X 黑寡妇蜘蛛X幻彩版 悬浮式游戏机械键盘 黑色绿轴 绝地求生吃鸡键盘',5,0,300,0,1910,0.0000,899.00,599.00,0.00,'','','雷蛇新品登场，[X]系类，金属元素顶部构造，SKT T1推荐装备','&lt;p class=&quot;more-par&quot; style=&quot;margin-top: -5px; margin-bottom: 0px; padding: 0px 20px 0px 0px; text-align: right;&quot;&gt;&lt;br/&gt;&lt;/p&gt;&lt;table width=&quot;750&quot; align=&quot;center&quot;&gt;&lt;tbody&gt;&lt;tr class=&quot;firstRow&quot;&gt;&lt;td&gt;&lt;a href=&quot;https://item.jd.com/5077797.html&quot; target=&quot;_blank&quot; style=&quot;margin: 0px; padding: 0px; color: rgb(102, 102, 102); text-decoration-line: none;&quot;&gt;&lt;img width=&quot;250&quot; height=&quot;300&quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t14257/293/749158160/30506/62a682db/5a373046Nf4aef868.jpg&quot;/&gt;&lt;/a&gt;&lt;/td&gt;&lt;td&gt;&lt;a href=&quot;https://item.jd.com/5954856.html&quot; target=&quot;_blank&quot; style=&quot;margin: 0px; padding: 0px; color: rgb(102, 102, 102); text-decoration-line: none;&quot;&gt;&lt;img width=&quot;250&quot; height=&quot;300&quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t12985/254/2207132041/32065/6c389025/5a373040N14d49d1f.jpg&quot;/&gt;&lt;/a&gt;&lt;/td&gt;&lt;td&gt;&lt;a href=&quot;https://item.jd.com/5008238.html&quot; target=&quot;_blank&quot; style=&quot;margin: 0px; padding: 0px; color: rgb(102, 102, 102); text-decoration-line: none;&quot;&gt;&lt;img width=&quot;250&quot; height=&quot;300&quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t16324/63/525316673/55279/f419ce7a/5a373046Ndf037fd9.jpg&quot;/&gt;&lt;/a&gt;&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;&lt;a href=&quot;https://item.jd.com/4991110.html&quot; target=&quot;_blank&quot; style=&quot;margin: 0px; padding: 0px; color: rgb(102, 102, 102); text-decoration-line: none;&quot;&gt;&lt;img width=&quot;250&quot; height=&quot;300&quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t14563/242/725586015/33716/6b38b963/5a373046Nd1e9549f.jpg&quot;/&gt;&lt;/a&gt;&lt;/td&gt;&lt;td&gt;&lt;a href=&quot;https://item.jd.com/1329265.html&quot; target=&quot;_blank&quot; style=&quot;margin: 0px; padding: 0px; color: rgb(102, 102, 102); text-decoration-line: none;&quot;&gt;&lt;img width=&quot;250&quot; height=&quot;300&quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t16129/61/553110618/31276/639abfdc/5a373040N11938e25.jpg&quot;/&gt;&lt;/a&gt;&lt;/td&gt;&lt;td style=&quot;word-break: break-all;&quot;&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;采用屡获殊荣的RAZER机械轴&lt;/p&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;p&gt;&lt;br/&gt;RAZER机械轴专为游戏打造，特别优化了按键触发键程，带给玩家更快的响应速度和按键确认感，自从推出以来就被称赞为机械式游戏键盘的新标准。&lt;/p&gt;&lt;p&gt;绿轴&lt;br/&gt;按键声清脆，并拥有经优化的触觉反馈&lt;/p&gt;&lt;p&gt;经久耐用&lt;/p&gt;&lt;p&gt;每一枚RAZER机械轴能经受多达&amp;nbsp;8,000&amp;nbsp;万次按键敲击，让你在未来数年内享受&amp;nbsp;RAZER带来的优势。&lt;/p&gt;&lt;p&gt;防尘罩&lt;br/&gt;保护内在部件远离尘屑&lt;/p&gt;&lt;p&gt;RAZER绿轴&lt;br/&gt;经优化的按键反馈&lt;br/&gt;&lt;/p&gt;&lt;p&gt;黄金触点&lt;br/&gt;确保快速响应&lt;/p&gt;&lt;p&gt;高品质弹簧&lt;br/&gt;提供50g触发压力&lt;/p&gt;&lt;p&gt;&lt;img alt=&quot;雷蛇（Razer）BlackWidow X 黑寡妇蜘蛛X幻彩版 悬浮式游戏机械键盘 黑色绿轴 绝地求生吃鸡键盘-京东&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/sku/jfs/t5518/81/420229552/306135/e3644080/58ff060aN3a809851.gif&quot;/&gt;&lt;/p&gt;&lt;p&gt;更为简约实用的外观设计&lt;/p&gt;&lt;p&gt;金属上盖&lt;br/&gt;坚固耐用&lt;/p&gt;&lt;p&gt;104标准键位&lt;br/&gt;去掉了左侧宏按键，键位简洁，&lt;br/&gt;同时减少了游戏中的误操作。&lt;/p&gt;&lt;p&gt;全新RAZER按键字符&lt;br/&gt;线条纤细，辨识度高，更具实用性。&lt;/p&gt;&lt;p&gt;新增背部导线槽&lt;br/&gt;可以根据自己的桌面摆放需求，&lt;br/&gt;随意调整线缆出口位置。&lt;/p&gt;&lt;p&gt;悬浮式按键&lt;br/&gt;便于玩家拆卸键帽&lt;/p&gt;&lt;p&gt;无边框设计&lt;br/&gt;易于清洁内部污垢&lt;/p&gt;&lt;p&gt;大神操作，一键搞定&lt;/p&gt;&lt;p&gt;黑寡妇蜘蛛支持游戏模式10键无冲，通过Razer&amp;nbsp;Synapse云驱动软件，可自定义设置各类游戏的按键宏，一键完成原本复杂的游戏操作，并通过云端服务器轻松同步。&lt;/p&gt;&lt;p&gt;请前往雷蛇中文官网下载并安装Razer&amp;nbsp;Synapse云驱动软件&lt;/p&gt;&lt;p&gt;可自定义的CHROMA幻彩灯光系统&lt;br/&gt;&lt;/p&gt;&lt;p&gt;多种内置炫酷灯光模式随意选择，chroma万种色彩随意搭配，自定义设置按键色彩，&lt;br/&gt;通过Razer&amp;nbsp;Synapse云驱动轻松完成设置，随时与云端轻松同步。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/5f130444a3e5d8bb2b5355c4d5594841.png',0,-28800,0,1,0,0,0,1,1,50,0,0,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(41,106,0,'TP0000041','天堂伞 全遮光黑胶转印宇宙星空三折晴雨伞太阳伞',12,0,997,0,340,0.0000,79.00,59.00,0.00,'','','','',NULL,'/public/upload/goods/2018/04-10/3102a4330217107aaeec3b0520c9f0d1.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,3,0,0,0.00,'','',0,''),(42,61,0,'TP0000042','探险者（TAN XIAN ZHE） 睡袋户外成人 春夏秋冬四季加厚保暖午休成人露营睡袋 1.6KG藏青+可拆洗内胆送助眠三宝',10,0,150,0,150,1.0000,109.00,99.00,11.00,'','','探险者（TAN XIAN ZHE） 睡袋户外成人 春夏秋冬四季加厚保暖午休成人露营睡袋 1.6KG藏青+可拆洗内胆送助眠三宝','&lt;p&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t14191/186/1800321682/240324/89bb2672/5a2a137aNbb55e4bd.png&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t3934/353/953264729/197827/4dcd483c/58634a6cNe586682b.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t9028/111/2700162188/634903/3d45ad42/59dc8ca8N140afd86.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t9601/217/1105951733/232535/bc9cfac2/59dc8ca8N07483543.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t9601/217/1105951733/232535/bc9cfac2/59dc8ca8N07483543.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t10684/244/1089343456/303490/5441e5/59dc8ca8Nc5e1def6.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/ba1ebddafdbff7cf1f1f525a0ebf8380.jpg',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,6,1000,0,0,0,0,0,11.00,'','',0,''),(46,49,0,'6052','雅琼 沙发北欧布艺沙发可拆洗小户型三人位懒人沙发现代简约客厅家具A68 两件套（备注颜色） 海绵坐垫（送地毯）',1,0,350,0,80000,0.0000,2898.00,1699.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t12337/336/2337888116/543498/3aa72646/5a3b16c8N099c2f20.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16129/320/645214606/339961/8dc9307e/5a3b16d9N569bf1a5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13750/77/2329892195/287279/882cff64/5a3b16ddNfa21203f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16144/275/607719575/572427/bcbdfccf/5a3b16ceN21640961.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14857/273/856836343/163257/1107027b/5a3b16e3N2f73f837.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t12220/197/2345323163/539820/a9abe6a7/5a3b16d8N74c0ff51.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13534/62/2388902607/486552/66e2c92c/5a3b16eaNb73aa59b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13483/163/2285070668/504752/84e3bc1c/5a3b16bbN8030078d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15034/76/850729124/413684/a2437355/5a3b16d5Nc2c8be07.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15376/16/835299348/454150/fad4bdc3/5a3b16f2Nd6ad6a48.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14596/156/834915991/329166/12c3bc77/5a3b16f5N300e4a44.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16576/4/631987159/185117/e4b28276/5a3b16f8Ne75cc173.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16189/115/699712412/205223/75bd03f2/5a3b16fdN88ac8333.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13033/260/2386245326/187853/a5fda92c/5a3b1702Nb254d090.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15667/258/664786374/321817/a15612d3/5a3b1706N627060f2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15160/49/877206956/378762/cc6783a5/5a3b170aN4167613a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16054/130/557509488/273590/7a6660d9/5a3b170eNadf7a70a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14644/2/842282581/136937/ecb59334/5a3b1712Nb7336135.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13876/162/2276149448/146492/e0ecf1ba/5a3b1716Ne86e1c47.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15100/284/866106563/364616/13927740/5a3b1715N4ab37e6a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16105/356/652711824/275102/7287cf10/5a3b171aNe2afd19c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3058/290/2191620723/243764/7e01ee7f/57dd14c0N43c5edcc.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3253/162/2175566413/209042/5795df88/57dd14c1Nd098bd6b.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5731/142/4842556096/185257/9eb72eb0/5954ba8aN98fd3cea.jpg?t=1498725014787&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3298/137/2139868923/305582/4a82a2f7/57dd14c2Nb116d8d0.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7534/183/1278688087/822369/d4aaeaa3/599b9006N0dacb5ca.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3124/179/2121316291/215085/58206293/57dd14c4N397caa7d.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/aaf7d1cfedc544d0582dea4cc8c8fc1d.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,0,1,50,0.00,'','',0,''),(47,50,0,'TP0000047','巢里巢外 电表箱装饰画推拉式 配电箱定制液压翻盖画 餐厅现代简约客厅装饰画 简约花卉',8,0,500,1,500,0.0000,266.00,208.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16300/312/1492064532/107257/ffac8930/5a558da2Nd44fb71d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5911/243/4688511374/127811/e702bd86/5965e35eN9e33a237.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2596/64/2832570561/86499/96efe156/57736301N74feaf44.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3283/294/3972693604/208118/b6246762/57fb6b7aN5b643768.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2734/233/2815075583/83700/f0cdb12/57736302N4566ab58.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2584/259/2805155476/74725/76fb4fb0/57736303N669a94e6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2773/20/2739373820/85676/c1869342/57736303N707b9c77.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2905/315/2704732846/103894/63491037/57736303Nd1ba3262.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2938/266/1032531783/131452/5ce2437/57736304N5ae87aa5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2614/272/2734271844/123206/d0e2f2b4/57736304N7ea61b3e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2965/205/1067915424/115124/f88abff0/57736305N96520bff.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2797/317/2762041918/102930/9c77eed8/57736305Nb42fc923.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2917/184/1048885549/101202/c5ae7c73/57736305Na98f2221.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2698/297/2827091939/89115/9a3c2a2/57736306N7f1f53e9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t6319/106/73477612/107350/b283ad7a/5938c189N457becd4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2782/50/2783635122/56093/86821295/57736306N755ef1a5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2929/303/1071686915/77478/74f61b48/57736307N9f186715.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2623/77/2769824104/72712/43c3f5f/57736307Nbdc63c6f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2620/42/2760780406/83504/f7879bcb/57736308Nd05994c4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5848/269/3179752351/100792/f1394e54/5938c189Na5cb41d6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2599/40/2783641133/54051/e87cbff2/57736308N95bcbb91.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2977/313/1089454901/110933/66ab45bc/57736309Ne743cd9b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2872/352/2739844446/99468/ec33dbf0/57736309Nabd5a8e4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2920/314/1025242556/87579/1c858eb6/5773630aN7d1b03b5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2887/289/2770790000/135709/22fc6e76/5773630aNd25e3552.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t3193/295/2809875074/88097/2265e552/57e6450aN071269c0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3133/306/6691069681/1381025/ca467510/58aa3f4aN0c7bedd6.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/0fe936c3116ee2e7b8f7e86a897449c8.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(48,89,0,'TP0000048','国家地理（National Geographic） NG W5072 摄影包 单反相机包 双肩包 逍遥者系列 旅行多功能 时尚通勤',1,0,200,0,1810,0.0000,2588.00,1699.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t17503/255/545901619/774290/77c790fd/5a9623a8Nab0933f2.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t17485/31/533374855/783673/d969036b/5a9623b3Nff171bbc.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/829b8716e008160f0a162081440013c4.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,0,4,0,0.00,'','',0,''),(49,90,0,'TP0000049','三星（SAMSUNG）存储卡128GB 读速100MB/s 写速90MB/s 4K Class10 高速TF卡（Micro SD卡）红色plus升级版',6,0,197,0,15,0.0000,359.00,219.00,0.00,'','','','',NULL,'/public/upload/goods/2018/04-10/a967ffd5736c421b0db1ca048cf65da0.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,3,3,69,0.00,'','',3,''),(50,87,0,'TP0000050','佳能（Canon） EF 24-70mm f/2.8L II USM 标准变焦镜头',0,0,150,0,0,0.0000,15899.00,10299.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/jgsq-productsoa/jfs/t11611/305/1316181325/112289/1594269/59ffd678Ne120b986.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/jgsq-productsoa/g7/M03/06/01/rBEHZlBSnb0IAAAAAAEAB7LLCfwAABLiQHLXIkAAQAf620.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/jgsq-productsoa/g7/M03/06/01/rBEHZlBSncYIAAAAAABl0_dt9oIAABLiQJ97S0AAGXr461.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/jgsq-productsoa/g8/M03/06/01/rBEHaFBSnd8IAAAAAAA9Az4BXJYAABLiQKME5oAAD0b305.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/jgsq-productsoa/g7/M03/06/01/rBEHZlBSnc0IAAAAAACxG4N_SUkAABLiQMIg0UAALEz197.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/jgsq-productsoa/g9/M03/06/01/rBEHaVBSnsoIAAAAAAISxfO4qgkAABLiwJtryUAAhLd707.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/jgsq-productsoa/g8/M03/06/01/rBEHZ1BSnwkIAAAAAALQBcvrEXwAABLiwM0xAQAAtAd054.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/jgsq-productsoa/g7/M03/06/01/rBEHZlBSnw8IAAAAAAGYKm1Pg_gAABLjAAoynAAAZhC259.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/jgsq-productsoa/g7/M03/06/01/rBEHZVBSnzgIAAAAAAFmSwNxJoMAABLjAGiIS8AAWZj040.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/3cd420d309451aee058cd17ab6e1fe87.png',0,-28800,0,1,0,0,0,0,1,50,0,1,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(51,91,0,'TP0000051','Asus/华硕 商务本 _A580ur笔记本电脑轻薄便携学生游戏15.6英寸i5 八代酷睿i5 四色炫彩机身',7,0,150,0,1000,1.0000,4996.00,3999.00,2000.00,'','笔记本','Asus/华硕 商务本 _A580ur笔记本电脑轻薄便携学生游戏15.6英寸i5\r\n八代酷睿i5 四色炫彩机身','&lt;p&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i1/2923048015/TB2nNVOo0zJ8KJjSspkXXbF7VXa_!!2923048015.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2923048015/TB21rF8jVGWBuNjy0FbXXb4sXXa_!!2923048015.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2923048015/TB2zJl8jVGWBuNjy0FbXXb4sXXa_!!2923048015.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2923048015/TB2bdSNXL9TBuNjy0FcXXbeiFXa_!!2923048015.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2923048015/TB24M9qXQyWBuNjy0FpXXassXXa_!!2923048015.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2923048015/TB2ByL8XTlYBeNjSszcXXbwhFXa_!!2923048015.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2923048015/TB2GDjZXQKWBuNjy1zjXXcOypXa_!!2923048015.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2923048015/TB23JCpe4SYBuNjSsphXXbGvVXa_!!2923048015.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2923048015/TB2eVitXKOSBuNjy0FdXXbDnVXa_!!2923048015.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/21ecc8a426cff2ccecc3009217341d7d.jpg',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,5,0,0,0,0,0,0,111.00,'','',0,''),(52,70,0,'TP0000052','【官方旗舰店】广州电信光纤宽带新装100M 送不限流量手机卡流量卡 升级分享计划 100M 200元预存+199元一次性费用',0,0,300,0,100,0.0000,499.00,399.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t18877/123/1465869584/121464/caab5ea6/5acb2e05N2f08c476.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19456/40/909401175/1849473/214e96df/5ab21d90N345b24bd.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t4621/138/2195535771/194136/f85c5bd/58ec37c8N4009b704.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/6ac4b759421fcff73fb51f46322fc9c4.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(53,56,0,'TP0000053','73Hours 天鹅小径 2018春季新品羊皮踝靴蝴蝶结细跟深口高跟鞋女 新品',7,0,1399,0,1000,1.0000,139.00,139.00,100.00,'','','73Hours 天鹅小径 2018春季新品羊皮踝靴蝴蝶结细跟深口高跟鞋女\r\n新品','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/3000560259/TB2kaJzaVuWBuNjSspnXXX1NVXa_!!3000560259.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/3000560259/TB2z60Da7CWBuNjy0FaXXXUlXXa_!!3000560259.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/3000560259/TB2buYka_JYBeNjy1zeXXahzVXa_!!3000560259.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/3000560259/TB2az4Da7CWBuNjy0FaXXXUlXXa_!!3000560259.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/3000560259/TB2nK7.X7omBKNjSZFqXXXtqVXa_!!3000560259.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/3000560259/TB2m1NDaY1YBuNjSszhXXcUsFXa_!!3000560259.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/3000560259/TB2Z3YkXOOYBuNjSsD4XXbSkFXa_!!3000560259.jpg&quot;/&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i2/3000560259/TB21rNJiStYBeNjSspkXXbU8VXa_!!3000560259.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/e0badd92d48dfad8835c23dc9774eb78.jpg',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,7,0,0,0,1,1,0,111.00,'','',0,''),(54,71,0,'TP0000054','【北京移动】7天芒果TV会员 1GB流量仅售9.9元',1,0,500,0,0,0.0000,17.90,9.90,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/jgsq-productsoa/jfs/t4981/126/1147399254/465481/271c4880/58ed9397Nc4d16ea4.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/fc03e27c7c366b6f9b612af123d2e610.png',1,1534953599,3,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(55,73,0,'TP0000055','中国移动198号段 免预存 198号码198手机卡移动198不限量流量卡上网卡电话卡',2,0,600,0,10,0.0000,198.00,58.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/jgsq-productsoa/jfs/t7234/127/3121275818/1293125/196cb4ce/5a7f93a4N4eb754a4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/jgsq-productsoa/jfs/t16453/26/1602874436/134694/9da6799c/5a604380N4d7ca0bd.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/b38fa43cbff3171c8f35821388363b2d.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(56,58,0,'TP0000056','CHARLES＆KEITH波士顿包CK2-50780528春季通勤手提单肩包中号 纯色通勤 双根手拎带设计',18,0,97,1,11,11.0000,159.00,139.00,11.00,'','11','CHARLES＆KEITH波士顿包CK2-50780528春季通勤手提单肩包中号\r\n纯色通勤 双根手拎带设计','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/411832242/TB2eOIWX4WYBuNjy1zkXXXGGpXa_!!411832242.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/411832242/TB2TDsRX9CWBuNjy0FhXXb6EVXa_!!411832242.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/411832242/TB2b_kZX1uSBuNjy1XcXXcYjFXa_!!411832242.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/411832242/TB2d.qFanJYBeNjy1zeXXahzVXa_!!411832242.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/411832242/TB2Lj.ZX1uSBuNjSsziXXbq8pXa_!!411832242.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/411832242/TB2QNuzamBYBeNjy0FeXXbnmFXa_!!411832242.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/411832242/TB2qeQMkJhvOuFjSZFBXXcZgFXa_!!411832242.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/8205df2cb9866bc13a2f8d42296f0e1c.jpg',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,7,0,0,0,3,0,0,11.00,'','',0,''),(57,74,0,'TP0000057','【北京联通】100M宽带 郊区高速（1年版）',2,0,100,0,1000,0.0000,1399.00,1280.00,0.00,'','','预约办理百兆宽带，买一年多享2个月+高清IPTV，活动仅限','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/jgsq-productsoa/jfs/t17830/30/1196964249/675111/722dbb24/5ac1afe4N57e3dcd4.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/02b48666bbd133689a8282417cfe2218.png',0,-28800,0,1,0,0,0,0,1,50,1,0,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(58,104,0,'TP0000058','GPD win10掌上游戏机PSP掌机PS2迷你电脑LOL DNF网游',1,0,200,0,111,1.0000,2999.00,1999.00,111.00,'','','GPD win10掌上游戏机PSP掌机PS2迷你电脑LOL DNF网游','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2845890026/TB2cyRdepOWBuNjy0FiXXXFxVXa_!!2845890026.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2845890026/TB26hHlgfDH8KJjy1XcXXcpdXXa_!!2845890026.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2845890026/TB2kKlgfj3z9KJjy0FmXXXiwXXa_!!2845890026.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2845890026/TB2ZTKEglDH8KJjSszcXXbDTFXa_!!2845890026.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2845890026/TB25A.xbjgy_uJjSZSgXXbz0XXa_!!2845890026.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2845890026/TB2fYvigdnJ8KJjSszdXXaxuFXa_!!2845890026.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/c749ef6cf26e673039700a097a1319a3.jpg',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,5,0,0,0,0,0,0,111.00,'','',0,''),(59,76,0,'TP0000059','亿色（ESR）华为p10钢化膜 p10手机膜 非全屏覆盖高清透明防指纹玻璃贴膜',4,0,200,0,75,0.0000,25.00,19.90,0.00,'','','','',NULL,'/public/upload/goods/2018/04-10/85d1189a30db5d96b362a1d04d7f5e7f.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(60,104,0,'TP0000060','GPD XD plus翻盖掌机PSP安卓模拟器掌上手游游戏机王者荣耀XD2代',1,0,200,0,11,11.0000,1111.00,1069.00,111.00,'','','GPD XD plus翻盖掌机PSP安卓模拟器掌上手游游戏机王者荣耀XD2代','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/3072021829/TB2ov8sgASWBuNjSszdXXbeSpXa_!!3072021829.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/3072021829/TB29VIVgbGYBuNjy0FoXXciBFXa_!!3072021829.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/3072021829/TB2dBppgr1YBuNjSszhXXcUsFXa_!!3072021829.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/3072021829/TB2RXQOgeuSBuNjSsplXXbe8pXa_!!3072021829.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/3072021829/TB2fPkdhgaTBuNjSszfXXXgfpXa_!!3072021829.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/3072021829/TB2L6KEgCtYBeNjSspkXXbU8VXa_!!3072021829.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/3072021829/TB2WPoPbtcnBKNjSZR0XXcFqFXa_!!3072021829.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/3072021829/TB2Is0kgx1YBuNjy1zcXXbNcXXa_!!3072021829.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/3072021829/TB2b23DbsUrBKNjSZPxXXX00pXa_!!3072021829.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/3072021829/TB240Xkgx1YBuNjy1zcXXbNcXXa_!!3072021829.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/e96caa242ba06722a50b0e2525e7a6ed.jpg',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,5,1000,0,0,0,0,0,0.00,'','',0,''),(63,58,0,'TP0000063','阿迪达斯双肩包2018阿迪运动包背包男包女包学生书包电脑包CF9008 八年品牌老店 全场正品',1,0,100,0,11,1.0000,138.00,128.00,0.00,'','','阿迪达斯双肩包2018阿迪运动包背包男包女包学生书包电脑包CF9008\r\n八年品牌老店 全场正品','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/612456912/TB2sP8xX_XYBeNkHFrdXXciuVXa_!!612456912.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/612456912/TB2ERBGbhSYBuNjSspjXXX73VXa_!!612456912.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/612456912/TB2zo9aj26H8KJjy0FjXXaXepXa_!!612456912.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/612456912/TB2rIu5c7fb_uJkSnfoXXb_epXa_!!612456912.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/612456912/TB29fH5jlfH8KJjy1XbXXbLdXXa_!!612456912.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/612456912/TB29fH5jlfH8KJjy1XbXXbLdXXa_!!612456912.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/612456912/TB20hoTjlDH8KJjy1zeXXXjepXa_!!612456912.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/f744680215840cbe5d9cb7d01047ba90.jpg',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,1,100,0,0,0,0,0,0.00,'','',0,''),(62,77,0,'TP0000062','闪迪（SanDisk）A1 32GB 读速98MB/s 至尊高速移动MicroSDHC UHS-I存储卡 TF卡',12,0,99,0,15,0.0000,119.00,69.00,0.00,'','','移动存储卡认准闪迪，大牌原厂，高好评率见证，A1标准，强大内芯，快速启动运行APP！','',NULL,'/public/upload/goods/2018/04-10/60f9658269c4f1c1390ecd48455d72f7.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,100,0,0,1,0,0,0.00,'','',4,''),(193,443,0,'TP0000193','实体店新款鞋兑换券',22,0,397,0,100,0.0000,199.00,79.00,69.00,'','','安妮','&lt;p&gt;3434343&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/08b6fcdbbaa2583939685981f1f9a4d4.png',1,1526745600,10,1,0,0,0,1,1,50,0,0,0,0,7,0,0,0,25,0,0,0.00,'','',6,'/public/upload/goods/2018/04-17/ba78747ab515c0937307b0b94a6368ed.mp4'),(81,93,0,'TP0000081','2018新款Apple/苹果 iPad 9.7英寸32/128Gwifi平板电脑air A182 2 12期分期 正规发票 正品国行',4,0,100,0,11,11.0000,1799.00,1688.00,100.00,'','','2018新款Apple/苹果 iPad 9.7英寸32/128Gwifi平板电脑air A182 2\r\n12期分期 正规发票 正品国行','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/268451883/TB25Xw.lUlnpuFjSZFjXXXTaVXa_!!268451883.png&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/268451883/TB2HnLjjYRkpuFjSspmXXc.9XXa_!!268451883.png&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/268451883/TB2CPh0gyC9MuFjSZFoXXbUzFXa_!!268451883.png&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/268451883/TB2zQXwlYBmpuFjSZFuXXaG_XXa_!!268451883.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/268451883/TB2zQXwlYBmpuFjSZFuXXaG_XXa_!!268451883.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/44d3000d83951b18fce1412e529e640b.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,0,0,2,0,0,0,0,0,0,100.00,'','',0,''),(65,78,0,'TP0000065','绿联Type-C转HDMI/VGA转换器 USB-C扩展坞PD充电转接头数据线 苹果MacBook华为Mate10Pro拓展坞集线器40873',4,0,299,0,150,0.0000,499.00,399.00,0.00,'','','','&lt;p&gt;&lt;span class=&quot;ssd-widget-heading-ch W151295999137921&quot; style=&quot;margin: 0px 6px 0px 15px; padding: 0px; float: left; display: inline-block; height: 30px; line-height: 30px; letter-spacing: 0px; color: rgb(255, 255, 255); font-size: 14px; background-color: transparent; font-family: &amp;quot;microsoft yahei&amp;quot;;&quot;&gt;产品功能&lt;/span&gt;&lt;span class=&quot;ssd-widget-heading-en W151295999137922&quot; style=&quot;margin: 0px 15px 0px 6px; padding: 0px; float: left; display: inline-block; height: 30px; line-height: 30px; letter-spacing: 0px; color: rgb(255, 255, 255); background-color: transparent; font-family: &amp;quot;microsoft yahei&amp;quot;;&quot;&gt;Product Function&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span class=&quot;ssd-widget-heading-ch W151296000784224&quot; style=&quot;margin: 0px 6px 0px 15px; padding: 0px; float: left; display: inline-block; height: 30px; line-height: 30px; letter-spacing: 0px; color: rgb(255, 255, 255); font-size: 14px; background-color: transparent; font-family: &amp;quot;microsoft yahei&amp;quot;;&quot;&gt;适用型号&lt;/span&gt;&lt;span class=&quot;ssd-widget-heading-en W151296000784225&quot; style=&quot;margin: 0px 15px 0px 6px; padding: 0px; float: left; display: inline-block; height: 30px; line-height: 30px; letter-spacing: 0px; color: rgb(255, 255, 255); background-color: transparent; font-family: &amp;quot;microsoft yahei&amp;quot;;&quot;&gt;Applicable Models&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span class=&quot;ssd-widget-heading-ch W151296002331528&quot; style=&quot;margin: 0px 6px 0px 15px; padding: 0px; float: left; display: inline-block; height: 30px; line-height: 30px; letter-spacing: 0px; color: rgb(255, 255, 255); font-size: 14px; background-color: transparent; font-family: &amp;quot;microsoft yahei&amp;quot;;&quot;&gt;产品特色&lt;/span&gt;&lt;span class=&quot;ssd-widget-heading-en W151296002331529&quot; style=&quot;margin: 0px 15px 0px 6px; padding: 0px; float: left; display: inline-block; height: 30px; line-height: 30px; letter-spacing: 0px; color: rgb(255, 255, 255); background-color: transparent; font-family: &amp;quot;microsoft yahei&amp;quot;;&quot;&gt;Selling Point&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span class=&quot;ssd-widget-heading-ch W151296005650034&quot; style=&quot;margin: 0px 6px 0px 15px; padding: 0px; float: left; display: inline-block; height: 30px; line-height: 30px; letter-spacing: 0px; color: rgb(255, 255, 255); font-size: 14px; background-color: transparent; font-family: &amp;quot;microsoft yahei&amp;quot;;&quot;&gt;产品信息&lt;/span&gt;&lt;span class=&quot;ssd-widget-heading-en W151296005650035&quot; style=&quot;margin: 0px 15px 0px 6px; padding: 0px; float: left; display: inline-block; height: 30px; line-height: 30px; letter-spacing: 0px; color: rgb(255, 255, 255); background-color: transparent; font-family: &amp;quot;microsoft yahei&amp;quot;;&quot;&gt;Product Information&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span class=&quot;ssd-widget-heading-ch W151296006224337&quot; style=&quot;margin: 0px 6px 0px 15px; padding: 0px; float: left; display: inline-block; height: 30px; line-height: 30px; letter-spacing: 0px; color: rgb(255, 255, 255); font-size: 14px; background-color: transparent; font-family: &amp;quot;microsoft yahei&amp;quot;;&quot;&gt;附件清单&lt;/span&gt;&lt;span class=&quot;ssd-widget-heading-en W151296006224338&quot; style=&quot;margin: 0px 15px 0px 6px; padding: 0px; float: left; display: inline-block; height: 30px; line-height: 30px; letter-spacing: 0px; color: rgb(255, 255, 255); background-color: transparent; font-family: &amp;quot;microsoft yahei&amp;quot;;&quot;&gt;Accessories&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span class=&quot;ssd-widget-heading-ch W151296006877740&quot; style=&quot;margin: 0px 6px 0px 15px; padding: 0px; float: left; display: inline-block; height: 30px; line-height: 30px; letter-spacing: 0px; color: rgb(255, 255, 255); font-size: 14px; background-color: transparent; font-family: &amp;quot;microsoft yahei&amp;quot;;&quot;&gt;品牌介绍&lt;/span&gt;&lt;span class=&quot;ssd-widget-heading-en W151296006877741&quot; style=&quot;margin: 0px 15px 0px 6px; padding: 0px; float: left; display: inline-block; height: 30px; line-height: 30px; letter-spacing: 0px; color: rgb(255, 255, 255); background-color: transparent; font-family: &amp;quot;microsoft yahei&amp;quot;;&quot;&gt;Brand Introduction&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/jgsq-productsoa/jfs/t15268/95/1265109199/163292/d71b37b7/5a4ade29N169849e0.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/jgsq-productsoa/jfs/t15130/195/1251953256/113037/cdfda4bb/5a4ade0dN4817b638.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/196183aeee0e4b4e1a18a109d53ddd4b.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,1,1,35,0.00,'','',0,''),(66,14,0,'TP0000066','图片上传123',11,0,97,0,0,0.0000,110.00,90.00,100.00,'','','图片上传','',NULL,'/public/upload/goods/2018/04-10/b40b673371bdb52e64b759199b044c98.png',0,-28800,0,1,0,0,0,1,1,50,0,0,1,0,0,0,0,0,3,0,0,0.00,'','',0,''),(67,110,0,'TP0000067','【赠明信片8张】现货包邮 幸得诸君慰平生 故园风雨前美文范本王开岭作序汪曾祺林清玄大冰推荐畅销书籍经典文学散文作家小说随笔',1,0,300,0,11,11.0000,69.00,59.00,11.00,'','','【赠明信片8张】现货包邮 幸得诸君慰平生 故园风雨前美文范本王开岭作序汪曾祺林清玄大冰推荐畅销书籍经典文学散文作家小说随笔','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/101450072/TB2isv_egjN8KJjSZFkXXaboXXa-101450072.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/101450072/TB2isv_egjN8KJjSZFkXXaboXXa-101450072.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/101450072/TB2cGubl26H8KJjSspmXXb2WXXa-101450072.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/101450072/TB2cGubl26H8KJjSspmXXb2WXXa-101450072.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/101450072/TB26sASlRDH8KJjSszcXXbDTFXa-101450072.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/101450072/TB24267elfM8KJjSZFhXXcRyFXa-101450072.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/101450072/TB2cV0cXiOYBuNjSsD4XXbSkFXa-101450072.jpg&quot;/&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i4/101450072/TB2rAo_eHJmpuFjSZFwXXaE4VXa-101450072.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/5ee41fe4e7320fb595fb6a3427e5a0da.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,1,0,4,0,0,0,0,0,0,11.00,'','',0,''),(68,111,0,'TP0000068','圣女的救济 东野圭吾作品集 精装正版包邮 现当代日本文学悬疑推理侦探小说书籍 圣女的救赎 嫌疑人X的献身白夜行 新华书店文轩网',4,0,99,1,111,1.0000,26.00,25.90,0.00,'','11','圣女的救济 东野圭吾作品集 精装正版包邮 现当代日本文学悬疑推理侦探小说书籍 圣女的救赎 嫌疑人X的献身白夜行 新华书店文轩网','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/101450072/TB2lUJEhZjI8KJjSsppXXXbyVXa-101450072.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/101450072/TB2lUJEhZjI8KJjSsppXXXbyVXa-101450072.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/101450072/TB2lUJEhZjI8KJjSsppXXXbyVXa-101450072.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/101450072/TB2lUJEhZjI8KJjSsppXXXbyVXa-101450072.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/101450072/TB2dnqjhZLJ8KJjy0FnXXcFDpXa-101450072.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/101450072/TB2Zs42h4PI8KJjSspfXXcCFXXa-101450072.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/101450072/TB2Ydlnh0fJ8KJjy0FeXXXKEXXa-101450072.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/101450072/TB2hIVfh0bJ8KJjy1zjXXaqapXa-101450072.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/cbb47f78209bae16d9ee0856f6bc675f.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,1,0,4,1000,0,0,0,0,0,0.00,'','',0,''),(69,79,0,'TP0000069','罗马仕（ROMOSS）HO20锂聚合物 移动电源/充电宝 太阳神 20000毫安LED数显屏 白色 苹果/安卓双输入 手机/平板通用',18,0,349,0,540,0.0000,169.00,99.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t15403/255/551933391/120662/ec66deb8/5a30bf38Ne9f037bb.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t15850/238/382206917/139614/ec5268b7/5a30bf66Nf1266a77.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t12421/210/2042903971/143804/24571361/5a30bf5aN325de5ff.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t15640/55/155348378/28182/90db2ec4/5a28d51fN887ab1c6.gif&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t13264/57/2355488101/218214/5a91dea/5a3b483cNf302adf1.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t15112/99/584311246/223260/eb520a34/5a30bf58Nb7a5f305.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t14869/142/551578723/119467/45d82b85/5a30bf6aNfe21c5bd.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t14173/112/2025197056/328340/16735f14/5a30bf6eN6e5d1d54.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t13213/156/2062232598/118249/80f37087/5a30bf6cN9cc85d3b.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t16072/246/399229998/236222/8567ad22/5a30bf6dNa77a68c6.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t16426/351/925764894/119232/3346ad3b/5a433da6N6f51ed86.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t15943/247/406843530/97967/da1071b1/5a30bff1N5e15cec2.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t15451/81/555110480/93229/3a994bb5/5a30bff6Na35e56c8.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/c264441d23f24210d429bf6c58dac1ee.jpg',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,1,0,0,0.00,'','',0,''),(154,405,0,'TP0000154','小熊饼干990',26,0,168,1,0,0.0000,199.00,35.00,79.00,'','','小熊饼干，懂你的饼干','&lt;p&gt;23232323&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/2ae49c7b1e6ad0645315b6bcf40f6bf7.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,3,0,350,2,16,0,0,0.00,'','',4,'/public/upload/goods/2018/04-16/ed22b253231ee2e1ce8a37e76de09df5.mp4'),(70,81,0,'TP0000070','索尼（SONY）黑卡DSC-RX100M5? 1英寸大底数码相机/卡片机 蔡司镜头（WIFI/NFC 4K视频 RX100V/黑卡5）',3,0,300,0,540,0.0000,6699.00,5789.00,0.00,'','','','',NULL,'/public/upload/goods/2018/04-10/a68b6606db6dce312c0a83b57091db7f.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(71,82,0,'TP0000071','佳能（Canon）EOS 80D 单反套机（EF-S 18-200mm f/3.5-5.6 IS） 2420万有效像素 45点十字对焦 WIFI/NFC',2,0,200,0,2140,0.0000,9988.00,8498.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/jgsq-productsoa/jfs/t11611/305/1316181325/112289/1594269/59ffd678Ne120b986.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t1960/271/1865172382/61681/5b7b7b42/56e27ec0N39bb87f9.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2359/108/2656631756/132857/b6afe6c1/56e28120N67b0df61.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2149/16/1886058386/214387/c6fc83c1/56e280dfN0f80961e.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2278/132/2529581448/100495/c915c85a/56e28523Naf776d03.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2092/170/2584859355/124248/d4d68f83/56e28761Nb5846c8a.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t1894/280/2528305510/32833/8a2e4310/56e28847Nf456bd80.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2296/181/1849726001/60153/4f43b1a7/56e2888dNee43d999.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2143/181/1871024316/61220/b23a8326/56e28987Ncd029248.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2032/100/2544920701/25674/1489689e/56e289bbN0324aad2.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t1849/264/2568840127/28034/cec0106f/56e289f3Nae52d17a.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2287/135/1853382402/51686/d94d2479/56e28a5fNc3f49c2f.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2410/211/2621820954/38949/da0f3ff3/56e28b0eN5d662130.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/jgsq-productsoa/jfs/t19564/256/1315224186/172029/f0644b65/5ac46abfNc191cc9f.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/f20390b709011c472e5c5161a8d7a7f3.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(72,96,0,'TP0000072','宁美国度 AOC I2479VXHD 23.8英寸高清屏幕护眼液晶电脑显示器 送发光键鼠套装',4,0,299,0,11,212.0000,1699.00,1599.00,500.00,'','11','宁美国度 AOC I2479VXHD 23.8英寸高清屏幕护眼液晶电脑显示器\r\n送发光键鼠套装','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/595397331/TB2Taswc4OMSKJjSZFlXXXqQFXa_!!595397331.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/595397331/TB2mQSjXnMlyKJjSZFFXXalVFXa_!!595397331.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/595397331/TB2qq08XXgkyKJjSspfXXcj1XXa_!!595397331.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/595397331/TB2btSjXk7myKJjSZFkXXa3vVXa_!!595397331.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/595397331/TB2dQKZXbAPyuJjy0FjXXXhfFXa_!!595397331.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/595397331/TB2dQKZXbAPyuJjy0FjXXXhfFXa_!!595397331.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/595397331/TB2sxyljC7PL1JjSZFHXXcciXXa_!!595397331.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/595397331/TB2LJF8Xo.iyKJjy1XbXXc4cXXa_!!595397331.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/595397331/TB25pu1Xk.OyuJjSszeXXXY.VXa_!!595397331.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/595397331/TB25pu1Xk.OyuJjSszeXXXY.VXa_!!595397331.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/595397331/TB25pu1Xk.OyuJjSszeXXXY.VXa_!!595397331.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/595397331/TB2xjV7XkQkyKJjSspaXXc_ipXa_!!595397331.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/595397331/TB2XhShXVOWBuNjy0FiXXXFxVXa_!!595397331.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/b810d7e9771a6fdca200b867ab96c89e.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,1,0,5,1000,0,0,1,4,0,111.00,'','',0,''),(73,86,0,'TP0000073','爱国者（aigo） 数码相框DPF83 8英寸高清电子相册 人体感应 支持视频音乐 SD卡/U盘直插 礼品佳选 亮白色',3,0,200,0,710,0.0000,369.00,299.00,0.00,'','','','',NULL,'/public/upload/goods/2018/04-10/9733ec1c65330990c7cc01710acda00b.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(74,72,0,'TP0000074','广西移动 手机 话费充值 50元 快充直充 24小时自动充值快速到账',31,0,92,3,11,0.0000,15.00,9.90,10.00,'','','浙江移动 手机 话费充值 50元 快充直充 24小时自动充值快速到账','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/908875136/TB2XG0daFXXXXaNXpXXXXXXXXXX_!!908875136.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/4190c48be10ab0be8ba6e5a9b11e0461.jpg',1,1546272000,10,1,0,0,0,1,1,50,1,1,1,0,0,100,0,0,8,0,0,0.00,'','',0,''),(91,44,0,'TP0000091','绍泽文化 文房四宝毛笔书法套装 （毛笔/墨锭/石砚/笔架/水碗/镇尺）',1,0,159,0,1390,0.0000,159.00,99.00,0.00,'','','','',NULL,'/public/upload/goods/2018/04-10/0b2a04a19ee871646746029fa0cba0e1.png',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,0,0,0,1,0,0,0.00,'','',0,''),(75,88,0,'Ronin-M','大疆 DJI Ronin-M 新如影 三轴手持云台系统 Ronin-M 标配',12,0,99,0,2300,0.0000,7999.00,6999.00,0.00,'','','大疆中国区一级代理商，重量轻盈，超长续航，支持多种工作模式，专业技术指导，贴心售后！','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3760/211/309997549/201042/f19bcc9/5805d8faN8005461d.png&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3514/112/271579602/154233/fd31b4c2/5805d77eN5e00bf26.png&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3745/199/300651436/76992/5fca9e8c/58071422Nb8651044.png&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t15121/251/2461702707/132999/7af3e4b1/5a9faa02Nc1b9f0ee.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18499/58/666006883/125639/83d26671/5a9faa02N3c0340e9.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18781/271/709784176/329633/389dc6dc/5a9faa01N9f2895eb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19117/283/819188459/444605/6d39e570/5aaa0e92N82af3c40.png&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18616/40/673511253/317917/f6d12096/5a9faa02N278993f4.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t15091/259/2464409790/177958/79355768/5a9faa02N38016fa7.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18253/339/700067846/649181/3087e79a/5a9faa03N4bc25d89.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18589/111/703967522/200794/6b35ddb3/5a9faa03Nbacff37b.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t14983/85/2386504099/129750/9db52074/5a9faa03Ncdb14bfc.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t14770/243/2467154926/118204/8a32634b/5a9faa03N42a76af7.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t17533/331/674627095/195260/d5b4e8b1/5a9faa04N6ca7a43e.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t17980/229/684190422/227606/685e6ca9/5a9faa04N952300bf.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t14743/97/2497480810/262644/7a529019/5a9faa04N0521a7d1.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t17458/53/660716590/173620/1bbe5929/5a9faa04N0fee50ec.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17542/60/838773996/250272/864e97a0/5aaa0ed0N0e07e6f7.png&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18796/88/673359582/782553/d7855fb7/5a9faa05N9fa3f1ba.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18679/76/684478841/88971/1529caad/5a9faa04N9e9cd692.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18952/215/827241115/179810/dc81cc72/5aaa0edeNb9ec58a5.png&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18865/109/688132513/126093/80fa79e3/5a9fb79bN501fb8a5.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t11773/355/2690387329/77372/dc86b3e7/5a9fb79bNb7cca6b6.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/popWaterMark/jfs/t17671/197/1259897385/312714/dca0be30/5ac43fa4N6646b23b.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/99b8add4c9fb54b7f3ae5ada54308bb1.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,1,0,0,0.00,'','',0,''),(76,96,0,'TP0000076','戴尔（DELL） U2417H 23.8英寸四边微边框旋转升降IPS屏 出厂色彩校准 99%sRGB 电脑吃鸡显示器',7,0,220,0,7880,0.0000,1799.00,1399.00,0.00,'','','CES大奖作品！高颜值四边窄边框，出厂校色专业级色彩，旋转升降屏，丰富接口，一步到位！','&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t7396/170/2397169745/655533/3137ee94/59ae48f7Na17a1cd1.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t7804/260/2407933054/552429/6d291997/59ae48fbN2d199464.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t8656/214/725784518/547785/d822c4fb/59ae48ffN6c5c6594.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t9277/99/755284117/693900/f8156d39/59ae48f4Nda7df1a7.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t7741/293/2427198563/541381/917ad082/59ae4908N5aa460fc.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/359d8a160df53b17ef7572f5b07fe963.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,0,1,37,0.00,'','',0,''),(77,57,0,'TP0000077','卓诗尼高跟鞋女2018春季新款浅口粗跟中空单鞋优雅一字扣尖头女鞋 品牌正品 假一罚十',15,10,699,0,500,1.0000,299.00,296.00,0.00,'','','卓诗尼高跟鞋女2018春季新款浅口粗跟中空单鞋优雅一字扣尖头女鞋\r\n品牌正品 假一罚十','&lt;p&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i3/2258957216/TB2Yr64hhGYBuNjy0FnXXX5lpXa_!!2258957216.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2258957216/TB280V0XrSYBuNjSspfXXcZCpXa_!!2258957216.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2258957216/TB2W85kXljTBKNjSZFDXXbVgVXa_!!2258957216.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2258957216/TB24lWeXbZnBKNjSZFKXXcGOVXa_!!2258957216.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2258957216/TB2NvaxXnqWBKNjSZFAXXanSpXa_!!2258957216.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2258957216/TB2L7SfXbZnBKNjSZFrXXaRLFXa_!!2258957216.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2258957216/TB2L7SfXbZnBKNjSZFrXXaRLFXa_!!2258957216.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2258957216/TB2wLFycVXXXXcbXpXXXXXXXXXX_!!2258957216.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2258957216/TB2JTdZXqSWBuNjSsrbXXa0mVXa_!!2258957216.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2258957216/TB2Hg9fXiMnBKNjSZFCXXX0KFXa_!!2258957216.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/76375dc42c7815d169756466c185b8e4.jpg',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,7,1000,0,0,1,0,0,0.00,'','',0,''),(78,98,0,'TP0000078','华硕（ASUS）PRIME Z370-A 主板（Intel Z370/LGA 1151）',0,0,100,0,1450,0.0000,2166.00,1699.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://opbgfiles.asus.com.cn/MotherBoards/PRIME-Z370-A/img/5way-pic.jpg&quot;/&gt;&lt;img src=&quot;https://opbgfiles.asus.com.cn/MotherBoards/PRIME-Z370-A/img/5way/5way-detail-fan.png&quot;/&gt;&lt;img src=&quot;https://opbgfiles.asus.com.cn/MotherBoards/PRIME-Z370-A/img/fanholder.jpg&quot;/&gt;&lt;img src=&quot;https://opbgfiles.asus.com.cn/MotherBoards/PRIME-Z370-A/img/uefi-screen1.jpg&quot;/&gt;&lt;img src=&quot;https://opbgfiles.asus.com.cn/MotherBoards/PRIME-Z370-A/img/uefi-screen2.jpg&quot;/&gt;&lt;img src=&quot;https://opbgfiles.asus.com.cn/MotherBoards/PRIME-Z370-A/img/ddr4.jpg&quot;/&gt;&lt;img src=&quot;https://opbgfiles.asus.com.cn/MotherBoards/PRIME-Z370-A/img/conn-m2.jpg&quot;/&gt;&lt;img src=&quot;https://opbgfiles.asus.com.cn/MotherBoards/PRIME-Z370-A/img/conn-heatsink.jpg&quot;/&gt;&lt;img src=&quot;https://opbgfiles.asus.com.cn/MotherBoards/PRIME-Z370-A/img/3dmount-pic.jpg&quot;/&gt;&lt;img src=&quot;https://opbgfiles.asus.com.cn/MotherBoards/PRIME-Z370-A/img/conn-usb3-type.jpg&quot;/&gt;&lt;img src=&quot;https://opbgfiles.asus.com.cn/MotherBoards/PRIME-Z370-A/img/thunderbolt.jpg&quot;/&gt;&lt;img src=&quot;https://opbgfiles.asus.com.cn/MotherBoards/PRIME-Z370-A/img/safeslot-pic.jpg&quot;/&gt;&lt;img src=&quot;https://opbgfiles.asus.com.cn/MotherBoards/PRIME-Z370-A/img/vr.jpg&quot; alt=&quot;VR&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t5308/175/1597543061/217585/98ae644f/59127ce3N6d6a9503.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/jgsq-productsoa/jfs/t2803/240/1272738137/191862/a6c33e89/573a88c6Nacea0b78.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/b50676b8e5d2df864a862f9bcf7da7ec.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(79,62,0,'TP0000079','【新品上市】Samsung/三星 Galaxy S9 SM-G9600/DS 全网通 4G手机',21,0,400,0,111,1.0000,3999.00,2999.00,0.00,'','','【新品上市】Samsung/三星 Galaxy S9 SM-G9600/DS 全网通 4G手机','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/370627083/TB2mDxHfDtYBeNjy1XdXXXXyVXa-370627083.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/370627083/TB2iZ3tbiCYBuNkHFCcXXcHtVXa-370627083.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/370627083/TB2_3pZfDtYBeNjy1XdXXXXyVXa-370627083.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/370627083/TB2PigAblsmBKNjSZFsXXaXSVXa-370627083.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/370627083/TB25Iwxbk7mBKNjSZFyXXbydFXa-370627083.gif&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/370627083/TB2I7Y7fbSYBuNjSspfXXcZCpXa-370627083.gif&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/370627083/TB2ttcubXooBKNjSZFPXXXa2XXa-370627083.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/370627083/TB2YKHDfXuWBuNjSszbXXcS7FXa-370627083.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/224ba3b41fa7f67f7861581748854b0c.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,2,0,0,0,0,0,0,0.00,'','',0,''),(80,101,0,'TP0000080','闪迪（SanDisk）酷铄(CZ73) USB3.0 金属U盘 128GB 读150MB/秒',1,0,500,0,20,0.0000,259.00,189.00,0.00,'','','买U盘选闪迪，金属U盘普及风暴，大牌原厂，品牌评论过百万，全金属外壳，高速便捷，大家说好才是真的好，速速下手！！','&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t1837/63/1764852499/308642/affe1fbd/5678c8e0N0709fb29.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2500/275/1836419347/228417/95ffa521/5678c8efN9d0d06c4.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t1888/123/1741095579/229306/70273cd/5678c917Nd9ce7ba1.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2257/126/1827205449/577339/34c190fa/56791520N3ecb93eb.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t4534/27/793202940/212983/61e88695/58d4d175Ne7818c1a.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t3379/83/2022426727/412953/114d3110/583be3d7N951950a3.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t3688/66/1855172934/511886/bb6d7ab1/583be846Nd9aed657.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t3688/66/1855172934/511886/bb6d7ab1/583be846Nd9aed657.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t3940/180/82208276/269023/88b32bbc/583be682Nb34a0317.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t8569/56/1251743117/116769/85c01123/59b73f27Ncd20c76b.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2779/243/2418744119/130637/cec15fee/5763b9d5N5a06a1dc.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/281b935d63431353df220dd998f86297.png',0,-28800,0,1,0,0,0,0,1,50,1,0,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(82,102,0,'TP0000082','和冠（Wacom）PTH-660/K0-F 影拓 Pro 数位板 Intuos 5手写手绘板 触控 中号（M）',1,0,100,0,1760,0.0000,2599.00,2099.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t3832/347/3636895213/141668/9ea849be/589d5dcaN679637f0.jpg&quot; alt=&quot;åå&amp;nbsp;ï¼Wacomï¼PTH-660/K0-F å½±æ Pro æ°...-äº¬ä¸&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t3214/4/6194493583/80716/d76df2cf/589d5e1aN6d89d464.jpg&quot; alt=&quot;åå&amp;nbsp;ï¼Wacomï¼PTH-660/K0-F å½±æ Pro æ°...-äº¬ä¸&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t4084/316/1908452096/125350/97bb1be8/589d5f49Nd6e760aa.jpg&quot; alt=&quot;åå&amp;nbsp;ï¼Wacomï¼PTH-660/K0-F å½±æ Pro æ°...-äº¬ä¸&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t3226/108/6098412695/65050/faae76a5/589d6095N84adcd99.jpg&quot; alt=&quot;åå&amp;nbsp;ï¼Wacomï¼PTH-660/K0-F å½±æ Pro æ°...-äº¬ä¸&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t4096/188/1946684179/35797/a8000ac8/589d60c1N760547df.jpg&quot; alt=&quot;åå&amp;nbsp;ï¼Wacomï¼PTH-660/K0-F å½±æ Pro æ°...-äº¬ä¸&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t3925/78/1960758456/38142/95798d8/589d6139N8ca01176.jpg&quot; alt=&quot;åå&amp;nbsp;ï¼Wacomï¼PTH-660/K0-F å½±æ Pro æ°...-äº¬ä¸&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t3211/183/6090015383/23947/e7bef362/589d6196N55cf1214.jpg&quot; alt=&quot;åå&amp;nbsp;ï¼Wacomï¼PTH-660/K0-F å½±æ Pro æ°...-äº¬ä¸&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t5866/174/3135797691/23451/3136a157/59376ca4Nc9029d77.jpg&quot; alt=&quot;åå&amp;nbsp;ï¼Wacomï¼PTH-660/K0-F å½±æ Pro æ°...-äº¬ä¸&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t5764/135/3029327453/145282/2821da20/59361262N85038382.jpg&quot; alt=&quot;åå&amp;nbsp;ï¼Wacomï¼PTH-660/K0-F å½±æ Pro æ°...-äº¬ä¸&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t3829/264/3682348646/31150/6834bf72/589d61d7Nd17a22a5.jpg&quot; alt=&quot;åå&amp;nbsp;ï¼Wacomï¼PTH-660/K0-F å½±æ Pro æ°...-äº¬ä¸&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t17140/268/468136637/41983/1ca06594/5a7d079cN8d33ff4a.jpg&quot; alt=&quot;åå&amp;nbsp;ï¼Wacomï¼PTH-660/K0-F å½±æ Pro æ°...-äº¬ä¸&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t4039/73/1912785039/56845/5710cfe1/589d6316Nb8821486.jpg&quot; alt=&quot;åå&amp;nbsp;ï¼Wacomï¼PTH-660/K0-F å½±æ Pro æ°...-äº¬ä¸&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t3268/37/6093777333/34314/a6ad2f35/589d6338Nf3896305.jpg&quot; alt=&quot;åå&amp;nbsp;ï¼Wacomï¼PTH-660/K0-F å½±æ Pro æ°...-äº¬ä¸&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t3877/42/1939997962/40728/83808af0/589d6352N721c550c.jpg&quot; alt=&quot;åå&amp;nbsp;ï¼Wacomï¼PTH-660/K0-F å½±æ Pro æ°...-äº¬ä¸&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t3253/229/6138301113/28352/77cb7ac8/589d6369Nb6919537.jpg&quot; alt=&quot;åå&amp;nbsp;ï¼Wacomï¼PTH-660/K0-F å½±æ Pro æ°...-äº¬ä¸&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t4015/226/1899284484/32490/382aabbc/589d6382N9b8fb381.jpg&quot; alt=&quot;åå&amp;nbsp;ï¼Wacomï¼PTH-660/K0-F å½±æ Pro æ°...-äº¬ä¸&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t3466/103/310358796/139441/ff64d85f/5805e6a5N8c3b161b.png&quot; alt=&quot;åå&amp;nbsp;ï¼Wacomï¼PTH-660/K0-F å½±æ Pro æ°...-äº¬ä¸&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/150f71d8f0be096eac5583f85be46e2d.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,0,0,0,0.00,'','',3,''),(83,60,0,'TP0000083','简约现代创意沉默是金工艺品摆件北欧雕塑办公室客厅艺术品装饰品',10,0,95,0,0,0.0000,69.00,60.00,0.00,'','','简约现代创意沉默是金工艺品摆件北欧雕塑办公室客厅艺术品装饰品','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2809440570/TB2vZfmkrBnpuFjSZFGXXX51pXa_!!2809440570.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2809440570/TB23V6YkypnpuFjSZFkXXc4ZpXa_!!2809440570.jpg&quot;/&gt;C&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2809440570/TB2Gj1texRDOuFjSZFzXXcIipXa_!!2809440570.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2809440570/TB2PSqNuXXXXXXtXFXXXXXXXXXX_!!2809440570.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2809440570/TB2pwLyuXXXXXaqXXXXXXXXXXXX_!!2809440570.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2809440570/TB2rE2quXXXXXbLXXXXXXXXXXXX_!!2809440570.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/cb867ea2fe4064cd8196b4f0ea1424ed.jpg',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,100,0,0,5,2,9,0.00,'','',0,''),(84,103,0,'TP0000084','罗技（Logitech）Pro C920 高清网络摄像头',2,0,141,0,290,0.0000,599.00,399.00,0.00,'','','','',NULL,'/public/upload/goods/2018/04-10/ed2f9df009826c7e0bc9c34486b948c2.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,9,6,20,0.00,'','',0,''),(85,104,0,'TP0000085','索尼（SONY）【PS4 Pro国行主机套装】PlayStation 4 Pro 《NBA 2K18》限量珍藏套装（晶透蓝手柄版）',3,0,150,0,5885,0.0000,3899.00,3499.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t16690/362/655774204/199697/b7a70ea1/5a9e399fN5660f731.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t16702/359/677012943/260169/96dc2dc5/5a9e399fN3c0c7dc5.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t16288/54/2265994009/231710/9826c97/5a9e39a0N75dabd31.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t15109/34/2441445979/308572/e1f5023/5a9e39a0N47b1117e.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18334/274/668843300/284933/db3cf716/5a9e39a0N4de068c3.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t19441/261/681570497/141853/225a80e7/5a9e39a0N334a4f0e.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18472/357/670900568/187197/714bb9cf/5a9e39a0N1f8ad5ce.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t15973/297/2211254998/186945/2e1422bc/5a98c3ebNeffc27e3.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t16537/243/1978001230/261565/ead38775/5a98c3eaN338492ad.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t14572/63/2127814482/346918/67145501/5a98c3ebN0374c461.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t17650/263/599422597/246633/c4ba33a0/5a98c3ecN0e05dc18.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t16552/128/2212909385/381919/5549db88/5a98c3ecNa9ac5d81.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t14380/77/2312716297/241537/3fc03513/5a98c3ecN7b6b5777.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t17908/129/608235614/307314/5237bbb7/5a98c3ecN6c7f2366.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/ed2433202fb8676f9df6c7ba30e52662.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,0,0,0,0.00,'','',3,''),(86,105,0,'TP0000086','达尔优（dareu）EH722电竞版 头戴式游戏发光耳机耳麦 绝地求生吃鸡利器 冰蓝钻石版',2,0,200,0,590,0.0000,169.00,119.00,0.00,'','','','',NULL,'/public/upload/goods/2018/04-10/7c426340a4e331a3b5a059a5ffe60f76.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,10,0,0,0,0,0,0.00,'','',0,''),(87,60,0,'TP0000087','现代装饰 树脂雕塑动物抽象招财双马桌面摆件马办公室工艺艺术品 新品上市 现代家居 创意礼品',3,0,100,0,1000,1.0000,138.00,128.00,0.00,'','','现代装饰 树脂雕塑动物抽象招财双马桌面摆件马办公室工艺艺术品\r\n新品上市 现代家居 创意礼品','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/840399152/TB225lcXbglyKJjSZFuXXaE6FXa_!!840399152.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/840399152/TB2ChhbXecnyKJjSZFPXXXdqVXa_!!840399152.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/840399152/TB28U8bXdsmyKJjSZFvXXcE.FXa_!!840399152.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/840399152/TB2Lyx7XfAPyuJjy0FcXXbCzpXa_!!840399152.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/840399152/TB2hJB7XeIPyuJjSspcXXXiApXa_!!840399152.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/840399152/TB2JHX7XbAPyuJjy0FjXXXhfFXa_!!840399152.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/840399152/TB2Wed7Xk.OyuJjSszhXXbZbVXa_!!840399152.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/840399152/TB2IZJcXnAlyKJjSZPiXXXL2VXa_!!840399152.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/840399152/T2R4gYXj0aXXXXXXXX_!!840399152.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/840399152/T2R4gYXj0aXXXXXXXX_!!840399152.jpg&quot;/&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i4/840399152/TB2rCg_alLxQeBjy0FnXXcQwpXa_!!840399152.jpg&quot;/&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i3/840399152/TB2NT3plFXXXXb5XXXXXXXXXXXX_!!840399152.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/bc2e384d695682d5d57c5163fd8887f2.jpg',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,1000,0,0,0,0,0,0.00,'','',3,''),(88,60,0,'TP0000088','稀奇艺术限量雕塑瞿广慈《桃园三结义》现代桌面摆件办公室装饰品 大师作品 限量百件 以古鉴今 荒诞幽默',14,0,100,0,2000,1.0000,1600.00,1500.00,0.00,'','','稀奇艺术限量雕塑瞿广慈《桃园三结义》现代桌面摆件办公室装饰品\r\n大师作品 限量百件 以古鉴今 荒诞幽默','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/3027005606/TB2FTrqcZaJ.eBjy0FbXXcwrFXa_!!3027005606.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/3027005606/TB2FTrqcZaJ.eBjy0FbXXcwrFXa_!!3027005606.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/3027005606/TB27K9EdICO.eBjSZFzXXaRiVXa_!!3027005606.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/3027005606/TB2QA18esCO.eBjSZFzXXaRiVXa_!!3027005606.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/3027005606/TB2QRBDdSuJ.eBjy0FgXXXBBXXa_!!3027005606.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/3027005606/TB2fqqOcByN.eBjSZFkXXb8YFXa_!!3027005606.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/8b6da293dcea26b33efaede0031ee76b.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,0,0,0,0,0,0,0,4,0,0.00,'','',5,''),(89,42,0,'TP0000089','TP-LINK TL-WDR5620 1200M 5G双频智能无线路由器 四天线智能wifi 稳定穿墙高速家用路由器',7,0,98,0,6850,0.0000,189.00,109.00,0.00,'','','','',NULL,'/public/upload/goods/2018/04-10/ea84ab4fa65ba1c238a95780ccffa947.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,2,0,0,0.00,'','',0,''),(90,43,0,'TP0000090','爱普生（EPSON）CB-S41 办公 投影机 投影仪（3300流明 SVGA分辨率 标配HDMI 支持左右梯形校正）',0,0,200,0,4150,0.0000,2889.00,2599.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t8422/91/812030709/391062/fa7288b1/59af901bN2acd1d00.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t8533/114/824012081/329439/804b4704/59af901bN416fb667.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t8950/76/810661406/319094/9308df72/59af9018N7019b99e.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t8731/89/807170098/233427/da2bf475/59af9010N453a32c5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t9037/130/436322782/99737/29923300/59a821e3N7064ea0d.gif&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t8665/235/314187197/93883/52feba54/59a821e3N571a649d.gif&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t9115/79/795733640/182886/97ac4be4/59af9016Na67a1cb2.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t7852/192/2533287735/153325/e8f11d97/59af9006N35858256.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t16405/148/2024395814/212508/f82f8557/5a824990N91ec64a9.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t7957/198/2478445125/358676/55b4c35c/59af901dNa12a5a2a.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t9448/196/790474984/114006/f6778501/59af9101N8322fea2.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t7402/242/2461530225/216477/625214d9/59af9109Nf8045dc7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/sku/jfs/t11623/119/375210502/123569/fe770591/5a24f426Nf8d6a89d.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t7288/145/2536270473/179031/a5c59499/59af910cN32bb5c5b.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t9160/75/2232503202/70956/772a2b10/59c9c4e2N6c2dc6b1.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/f6f5ded7bdc445a697b3b1b310fb6351.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(92,60,0,'TP0000092','简约现代相框餐厅客厅创意装饰品摆件卧室艺术纪念相片收纳小摆件 创意 相框',5,0,100,0,1,1.0000,99.00,98.00,11.00,'','','简约现代相框餐厅客厅创意装饰品摆件卧室艺术纪念相片收纳小摆件\r\n创意 相框','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1697827363/TB2ajSxi46I8KJjy0FgXXXXzVXa_!!1697827363.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1697827363/TB2xSJEi0fJ8KJjy0FeXXXKEXXa_!!1697827363.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1697827363/TB2Pz5hi6nD8KJjSspbXXbbEXXa_!!1697827363.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1697827363/TB2H4BZiZjI8KJjSsppXXXbyVXa_!!1697827363.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1697827363/TB2TCusdaLN8KJjSZFmXXcQ6XXa_!!1697827363.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1697827363/TB2FIqedlfM8KJjSZFhXXcRyFXa_!!1697827363.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1697827363/TB22aX9iZnI8KJjSsziXXb8QpXa_!!1697827363.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1697827363/TB2kMWoi4PI8KJjSspfXXcCFXXa_!!1697827363.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1697827363/TB2FDSbi26H8KJjy0FjXXaXepXa_!!1697827363.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/6882ec5288e206872aeb16cd7a0a9df5.jpg',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,1000,0,0,0,0,0,11.00,'','',0,''),(93,58,0,'TP0000093','【积分兑换】百斯锐羽毛球包 男女单肩黄金战包二代3支装运动背包 新款上市 黄金战包二代 PU材质',34,0,193,3,1500,0.0000,15.00,13.00,1.00,'','','【积分兑换】百斯锐羽毛球包 男女单肩黄金战包二代3支装运动背包\r\n新款上市 黄金战包二代 PU材质','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/192572892/TB2_c83gVXXXXcNXXXXXXXXXXXX_!!192572892.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/192572892/TB227_FtpXXXXcVXpXXXXXXXXXX_!!192572892.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/192572892/TB2H2X7gVXXXXcAXXXXXXXXXXXX_!!192572892.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/192572892/TB2xJR0gVXXXXXXXpXXXXXXXXXX_!!192572892.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/192572892/TB2vjmfgVXXXXXOXXXXXXXXXXXX_!!192572892.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/192572892/TB2KSk2sFXXXXcYXXXXXXXXXXXX_!!192572892.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/192572892/TB2Fw7SsFXXXXaXXpXXXXXXXXXX_!!192572892.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/192572892/TB26ZNQgVXXXXarXpXXXXXXXXXX_!!192572892.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/192572892/TB2OyKhgVXXXXXSXXXXXXXXXXXX_!!192572892.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-10/5ebada09eadda508a425180086b67da7.jpg',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,1,100,100,0,5,0,0,1.00,'','',3,''),(94,14,0,'HYZ831','芈儿2018新款春季女装百搭修身显瘦纯棉v领长袖t恤女百搭打底衫ME831',17,0,256,0,500,0.0000,109.00,79.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3271/43/2518593477/368778/3c8eb43b/57e257e8Neda71ddf.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3073/104/2520203180/354325/a354eed4/57e257edNcc0a0677.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3163/250/2481060597/353616/3b1c94cb/57e257f1N4f4ed110.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3133/177/2433813559/332524/63265169/57e257f3Nd56b478c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3151/182/2464623956/344841/53598fab/57e257f6Nc4cc8750.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3052/101/2573828218/431054/23cb2b02/57e257f9N717757ad.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3142/288/2588089037/445696/629fb95c/57e257fcN7ad6d333.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3157/1/2501558704/375966/44c82dae/57e257ffNb658ab7f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3046/213/2518474440/344506/e0b4f2ce/57e25802N7a9978fb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3091/190/2481614393/306619/a125abbd/57e25804N03f2974f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3193/168/2522226668/341323/981a34e7/57e25807N9f5cded6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3241/262/2547902863/386297/94a27bf6/57e2580aN2b1dd50f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3247/252/2487627560/272222/e24b1507/57e2580bNb7de6a1d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3175/59/2502455967/333228/1b214608/57e2580eNe6614e21.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3238/234/2524702997/287223/493e155c/57e25811Nf117d056.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3229/160/2512505624/361504/5adbe600/57e25813N668de967.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3313/13/832563008/329259/a08d1dda/5815b6adNd69c9bdd.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3745/61/793569125/363571/2ff2044a/5815b6afNb3e9846e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3421/16/846797765/351323/86a965ca/5815b6b2N6b460456.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3559/62/875643613/383513/247e37ab/5815b6b6Nad1e2dfe.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3688/41/728804115/343718/a6e817cf/5815b6b8N7ce87ed6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3793/66/830915076/325789/66bc56f1/5815b6bbN59aabd58.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3832/80/602726876/346774/44027995/5815b6bdNc75cef56.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3427/106/857851343/545250/808e9993/5815b6c1Nbd1acd9e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3184/203/2530650707/242355/3ab17504/57e25814N477a0df1.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3142/342/2546045809/150927/674a9bb5/57e25816N3cbfa85e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3232/251/2519147850/162839/17c08c/57e25817N41ac1d83.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3178/308/2532067447/186969/dfd9f418/57e25818N90edc545.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-11/c3b2d20f27fe1bbaa0df0b6532a5253b.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,4,0,0,0.00,'','',0,''),(96,25,0,'TP0000096','花花公子长袖衬衫男韩版修身免烫纯色潮流工装商务男士白衬衣春秋 正品保证60天无理由退换赠送运费险',6,12,896,0,1000,1.0000,269.00,259.00,111.00,'','','花花公子长袖衬衫男韩版修身免烫纯色潮流工装商务男士白衬衣春秋\r\n正品保证60天无理由退换赠送运费险','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/191609058/TB2guO6iY9YBuNjy0FgXXcxcXXa_!!191609058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/191609058/TB2y1S6iY9YBuNjy0FgXXcxcXXa_!!191609058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/191609058/TB2VhKMi21TBuNjy0FjXXajyXXa_!!191609058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/191609058/TB2VhKMi21TBuNjy0FjXXajyXXa_!!191609058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/191609058/TB2FNGaiYGYBuNjy0FoXXciBFXa_!!191609058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/191609058/TB25y9Hi1GSBuNjSspbXXciipXa_!!191609058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/191609058/TB25y9Hi1GSBuNjSspbXXciipXa_!!191609058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/191609058/TB2xZq.i49YBuNjy0FfXXXIsVXa_!!191609058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/191609058/TB2xZq.i49YBuNjy0FfXXXIsVXa_!!191609058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/191609058/TB2GP5Wi4WYBuNjy1zkXXXGGpXa_!!191609058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/191609058/TB2hwKYi25TBuNjSspmXXaDRVXa_!!191609058.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-11/61587b190068f454369ab3e918c0003b.jpg',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,1,0,0,0,4,0,0,0.00,'','',3,''),(97,16,0,'TX3532','艾路丝婷短袖T恤女上衣印花圆领女士体恤衫TX3532',25,0,448,2,300,0.0000,129.00,89.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2626/277/1669281519/1316354/664274f8/57451fd9N09384e53.png&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2767/33/1632924218/268480/7d7b21d8/57451fdaNd40bbbde.png&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2857/352/1614837852/384273/a060b3e1/57451fdfN6056fda7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2818/326/1655383660/1211802/a72827e8/57451fe6N471328b8.png&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2596/325/1644164625/1052346/93651ebf/57451fecN19376077.png&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2767/69/1668728501/989510/bacd1145/57451ff0Nea9c6f34.png&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2644/3/1605126127/735499/90294c82/57451ff2N4c6740db.png&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2629/341/1696556195/1081375/449b7ae2/57451ffaN115f5273.png&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2734/13/1610151458/1052720/6b077607/57451ffdNd5ea7a91.png&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2827/128/1637044885/779770/2afade73/57452000N80a5c5d6.png&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2698/81/1648041088/177781/5e0c1971/57452001N766a38ac.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2782/325/1641459480/199634/d8804b14/57452002N6ffb1c5a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2785/263/1636804792/398109/12fe52d3/57452002Nc8c0700b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2698/87/1633077192/314135/73aaccde/57452004N62389e1f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2875/29/1672555549/328508/a5720b76/57452005Nc41aec77.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2875/37/1654014952/395405/ea13d46e/5745200aNd6fabd87.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-11/562221075f8b7adaf1d9d139b79b24b8.png',0,-28800,0,1,0,0,0,1,1,50,0,0,1,0,0,0,0,0,2,4,0,0.00,'','',0,''),(98,17,0,'18610VP11221','茵曼女装秋冬新款纯棉文艺范七分袖宽松衬衣女士衬衫【18610VP11221】',6,0,499,0,1000,0.0000,199.00,159.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t1873/50/2232409008/117233/a8529b6f/56c03d9dN9659c367.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2488/356/1504884228/93395/8a29a389/56c03d9eN5fae86f1.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2314/20/2160240543/85353/6637dbaf/56c03d9eN92d30107.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2251/185/1513278878/231234/cf553aa9/56c03d9fN60669777.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2446/25/1482003010/106877/d6722a80/56c03d9fN25c5ee7c.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t1852/354/2215725160/179807/7df973/56c03da0N65039c11.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2287/91/1504636270/62063/6430a43f/56c03da0N047ebee1.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2113/45/2202789238/254653/bc2c18ea/56c03da1Nbd681df8.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2329/324/2209909590/78840/a3b3b906/56c03da1N8ee8243d.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2182/190/2147194291/62518/1ef7d8ef/56c03da1N07fdaced.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2350/327/1477304742/239539/34901c3d/56c03da2N4feb4c6b.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t1879/94/2285739535/268457/9f6baed7/56c03da3Nb204e0d2.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t1840/352/2153779305/299522/80b9f30f/56c03da3N53eb9a03.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t1870/351/1471430163/261761/79a07352/56c03da4Nd898df73.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2476/1/2128729201/127422/676a73e8/56c03da4N87ec0217.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t1894/7/2120085250/266048/281d05f3/56c03da5N9d6a1f30.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2557/101/1428104812/74953/c10c74/56c03da5N0f8c9f67.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t1954/307/1516805159/128320/460378e1/56c03da6Nae187fa9.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2335/248/1522524229/69153/4d789914/56c03da6Nfa46990e.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-11/3725519236cf78057da53fcf92388010.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,1,0,0,0.00,'','',0,''),(99,18,0,'8ASXXFSl8060','2018夏装新款女上衣系带印花喇叭袖粉色复古温柔风漏肩露肩雪纺衫',4,0,599,0,300,0.0000,226.00,189.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18142/325/1236501049/428630/123c3e54/5ac1ba14Nef6536a5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18103/143/1227993885/93392/baa92383/5ac1ba12N64147cfb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19336/302/1267883805/68171/2eadef8c/5ac1ba23Nec95a2f4.png&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17530/204/1199172375/183336/8270d766/5ac1ba4aNe109bdd5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16930/84/1230704076/499234/fd6ac3f1/5ac1ba4cNb213d19d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19072/225/1234384119/358895/407153c1/5ac1ba4bN56ef4187.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17683/348/1234140059/381103/4594155/5ac1ba4cNe6e6c596.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18823/211/1238566560/360183/ddacad9e/5ac1ba4cNfa16a984.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18799/330/1232729029/328942/e782820c/5ac1ba4bN434b500b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17062/140/1252964823/526136/a8ed1768/5ac1ba4cNd1f1ec60.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3067/92/6365118972/171344/7405d830/58a3b717N5306051c.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-11/23ad4a153dd66a137204f0340ef5ceb1.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,1,2,1,0.00,'','',0,''),(100,19,0,'LD7931','迪尔绒莎夏季宽松百搭防晒衣女大码长袖薄款长外套休闲户外中长款防晒服防紫外线7931',1,0,299,0,250,0.0000,198.00,118.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t6091/76/924743781/378414/f65299cd/592e6be9Nefc703dc.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5677/139/2236944515/350929/5792ddb4/592e6be8Nea0c3205.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5818/7/2171157543/383853/4588d94d/592e6be0N6b5613af.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5752/248/2161877184/416078/d19c903c/592e6be3N3302c002.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5980/338/1066051370/162103/e74a32ad/592e6be7Ne97846fb.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5992/306/1014400309/149846/f5d3debc/592e6be6Na9ad6a50.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5659/254/2208539704/286357/7d77f47b/592e6be9Nc9c78319.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5737/164/2190272863/391254/e593b523/592e6be4N4d26ddfb.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5614/27/2217182582/309822/5a034282/592e6be8N8a4c1ec8.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5920/1/1027126885/338030/2777c9c7/592e6be9Na2b7f626.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5764/8/2183533800/350457/ff8bdd04/592e6be9N28acc4fd.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5629/234/2201696331/363339/7c669dff/592e6beaNee6e94c8.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5923/358/1025149381/374881/bf4eacdc/592e6be7N840f38e4.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5998/282/938731345/396166/dfa96bec/592e6be4Nc8c119e4.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5599/242/2232385229/364312/f0e4b327/592e6be9N8fee0e71.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t6013/31/943163857/263543/3975d8fa/592e6becN8d4616b3.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5767/94/2191146674/302914/22971098/592e6be8N302c88b2.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5734/22/2210746999/351383/22397c35/592e6bdfNf31d2997.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5872/214/2133602631/375935/9efc911f/592e6bf1Nf79a1b3a.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5590/217/2181015438/281327/d6100cc4/592e6be8N7efa7980.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5761/110/2202742387/363016/c2da438/592e6be8N3a71eaa4.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-11/4a1da3ed4ecb4257518efb7b39678f5e.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,1,0,0,0.00,'','',0,''),(101,25,0,'TP0000101','花花公子休闲裤男春秋修身直筒裤子男士休闲男装正装薄款商务男裤 时尚四色春秋季薄款 赠运费险',19,12,295,0,11,1.0000,159.00,139.00,0.00,'','','花花公子休闲裤男春秋修身直筒裤子男士休闲男装正装薄款商务男裤\r\n时尚四色春秋季薄款 赠运费险','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2075736152/TB2JSY7rHJmpuFjSZFwXXaE4VXa_!!2075736152.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2075736152/TB26REIrUhnpuFjSZFEXXX0PFXa_!!2075736152.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2075736152/TB2b7rNrJBopuFjSZPcXXc9EpXa_!!2075736152.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2075736152/TB2uGMYrS8mpuFjSZFMXXaxpVXa_!!2075736152.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2075736152/TB2Q0AArOpnpuFjSZFIXXXh2VXa_!!2075736152.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2075736152/TB2_IBnmyC9MuFjSZFoXXbUzFXa_!!2075736152.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2075736152/TB2quFuo9XlpuFjy0FeXXcJbFXa_!!2075736152.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2075736152/TB2ON9TbIuYBuNkSmRyXXcA3pXa-2075736152.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2075736152/TB2rUSegQOWBuNjSsppXXXPgpXa-2075736152.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2075736152/TB2QeWvcwKTBuNkSne1XXaJoXXa-2075736152.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-11/37d19630dde8c20aef03aa65623416b9.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,1,0,1,0,0,0,5,0,0,0.00,'','',3,''),(102,110,0,'TP0000102','正版包邮 百年孤独 精装 加西亚-马尔克斯 精装中文版 缔造文坛传奇奇迹经典名篇诺贝尔文学奖 世界名著 外国文学',2,0,199,0,111,1.0000,41.90,39.90,0.00,'','','正版包邮 百年孤独 精装 加西亚-马尔克斯 精装中文版 缔造文坛传奇奇迹经典名篇诺贝尔文学奖 世界名著 外国文学','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/859515618/TB2I5HVjBTH8KJjy0FiXXcRsXXa_!!859515618.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/859515618/TB2YHm6d0bJ8KJjy1zjXXaqapXa_!!859515618.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/859515618/TB2rHPvd2DH8KJjy1XcXXcpdXXa_!!859515618.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/859515618/TB2rHPvd2DH8KJjy1XcXXcpdXXa_!!859515618.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/859515618/TB2YFPod0nJ8KJjSszdXXaxuFXa_!!859515618.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/859515618/TB2wLbod4PI8KJjSspoXXX6MFXa_!!859515618.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-11/af42f91bd305f16583ebc0279114e3de.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,1,0,4,100,0,0,1,0,0,0.00,'','',0,''),(103,111,0,'TP0000103','【新华书店】人间失格 太宰治 正版日文经典文学推荐 震撼心灵力作 外国小说 日本原版小说经典文学文轩网图书籍排行榜',5,0,100,0,11,11.0000,22.00,21.90,0.00,'','','【新华书店】人间失格 太宰治 正版日文经典文学推荐 震撼心灵力作 外国小说 日本原版小说经典文学文轩网图书籍排行榜','&lt;p&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i2/101450072/TB20L.kXRfH8KJjy1XbXXbLdXXa-101450072.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/101450072/TB2Zn.Bg3vD8KJjSsplXXaIEFXa-101450072.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/101450072/TB2dGIjcNRDOuFjSZFzXXcIipXa-101450072.png&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/101450072/TB2LvCmhxXkpuFjy0FiXXbUfFXa-101450072.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-11/1882280caa289b2e92137733a5f60651.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,1,0,0,100,0,0,0,0,0,0.00,'','',5,''),(104,58,0,'TP0000104','红谷HONGU单肩包女时尚休闲牛皮斜挎包女小方包 H51207859中紫',18,0,299,0,11,1.0000,499.00,399.00,0.00,'','','红谷HONGU单肩包女时尚休闲牛皮斜挎包女小方包 H51207859中紫','&lt;p&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t9136/173/1550005728/48560/9ece19e1/59bb779fN5c8412ae.jpg&quot;/&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t9034/105/1533266985/175858/310be9e9/59bb77b0N3df040f8.jpg&quot;/&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t8779/327/1561558207/68514/5e66ab9/59bb77afN572280ac.jpg&quot;/&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t9136/171/1516881683/176505/e0b3d7b5/59bb77b3Nb41db48b.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t8656/224/1528199298/66251/ca491f2/59bb77a2N2cf4c1fe.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t8422/187/1548320626/182537/d93d8aee/59bb77b3N1ea0b14e.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t9208/244/1538363274/55476/cf8bbc2e/59bb77b3Nb593e9ae.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t8629/227/1568307570/183148/fc073bb1/59bb77a3N703acf83.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t8014/79/1544033555/188817/f9e63051/59bb946aNabea3de6.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t8131/203/1531070918/123590/7146d441/59bb77aeN5dda15a6.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t8272/169/1533313411/64327/5151fded/59bb77b5Nd72d4a2f.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t7636/57/3241674231/174034/6ea16009/59bb77b5N52b5beff.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-11/b2ec37c304e14223353394f5957a64d7.jpg',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,7,100,0,0,1,0,0,0.00,'','',0,''),(105,60,0,'TP0000105','恒瓷美 北欧创意家居软装艺术品摆设树脂简约现代装饰品房间玄关客厅电视柜酒柜小摆件结婚礼物',1,0,100,0,100,1.0000,59.00,48.00,0.00,'','','恒瓷美 北欧创意家居软装艺术品摆设树脂简约现代装饰品房间玄关客厅电视柜酒柜小摆件结婚礼物','&lt;p&gt;&lt;span style=&quot;color: rgb(102, 102, 102); font-family: Arial, &amp;quot;microsoft yahei&amp;quot;; font-weight: bold; background-color: rgb(255, 255, 255);&quot;&gt;恒瓷美 北欧创意家居软装艺术品摆设树脂简约现代装饰品房间玄关客厅电视柜酒柜小摆件结婚礼物&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;color: rgb(102, 102, 102); font-family: Arial, &amp;quot;microsoft yahei&amp;quot;; font-weight: bold; background-color: rgb(255, 255, 255);&quot;&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t16843/80/131908419/111257/7a521d20/5a5f10bfN271bf2ae.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t16885/70/130136490/189739/8b863afc/5a5f10bfNd994f0f2.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t14866/11/1940021381/143670/a2856fc2/5a5f10bbNe30c01f7.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t19150/86/126826966/88112/a18d22d1/5a5f10bfN1257dab3.jpg&quot;/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;color: rgb(102, 102, 102); font-family: Arial, &amp;quot;microsoft yahei&amp;quot;; font-weight: bold; background-color: rgb(255, 255, 255);&quot;&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t19465/26/133652589/106640/6855df55/5a5f10bfN4d6c3166.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t15931/156/1756252284/117512/f2ec1ee6/5a5f10bfN07a69a18.jpg&quot;/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;color: rgb(102, 102, 102); font-family: Arial, &amp;quot;microsoft yahei&amp;quot;; font-weight: bold; background-color: rgb(255, 255, 255);&quot;&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t18079/63/130193449/99142/83203472/5a5f10bfNc0498ea6.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t19141/92/136337228/92455/b5ddcb4f/5a5f10bfN3e14dc94.jpg&quot;/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;color: rgb(102, 102, 102); font-family: Arial, &amp;quot;microsoft yahei&amp;quot;; font-weight: bold; background-color: rgb(255, 255, 255);&quot;&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t15277/145/1862783846/91900/14c04628/5a5f10bfN69d2e828.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t16804/94/130887712/155779/b21110f1/5a5f10c0N082f31b9.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t14377/133/1926489736/78727/cf23da14/5a5f10bfN7029700f.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t18502/98/136470156/114378/c990de8d/5a5f10c0N4fa265ad.jpg&quot;/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;color: rgb(102, 102, 102); font-family: Arial, &amp;quot;microsoft yahei&amp;quot;; font-weight: bold; background-color: rgb(255, 255, 255);&quot;&gt;&lt;br/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;color: rgb(102, 102, 102); font-family: Arial, &amp;quot;microsoft yahei&amp;quot;; font-weight: bold; background-color: rgb(255, 255, 255);&quot;&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t15706/83/1746207156/150500/3db8da6/5a5f10c0Neb6a4683.jpg&quot;/&gt;&lt;/span&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-11/2b8d03b7c0b44389dda5441ef68e9cc4.jpg',0,-28800,0,1,0,0,0,0,1,50,1,0,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(106,60,0,'TP0000106','Snnei室内 地中海帆船模型客厅摆件装饰品手工艺品办公室家居房间艺术品 一帆风顺80cm 普鲁士号80CM',8,0,99,0,1500,1.0000,1090.00,1080.00,0.00,'','','Snnei室内 地中海帆船模型客厅摆件装饰品手工艺品办公室家居房间艺术品 一帆风顺80cm 普鲁士号80CM','&lt;p&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t5110/132/1785408661/125302/8daf34c6/59141f8fN74ef86cf.jpg&quot;/&gt;&lt;img src=&quot;http://img11.360buyimg.com/cms/jfs/t3268/285/1955501050/91124/2096c90c/57d7b177Naeda7ffd.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://img12.360buyimg.com/cms/jfs/t2770/215/4235051166/158174/6744cce0/57b286a5N48d1f8f8.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t4033/174/1511730690/154303/e0f594d0/5879c629N76a6d869.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t3271/118/5670248992/143639/de223839/5879c636Nfd6957c8.jpg&quot;/&gt;&lt;img src=&quot;http://img10.360buyimg.com/cms/jfs/t2647/335/4272066399/153663/573732e8/57b286a7Nca74bd77.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t4111/256/1495506495/112604/e69f112f/5879c64aN395d6d91.jpg&quot;/&gt;&lt;img src=&quot;http://img13.360buyimg.com/cms/jfs/t2848/96/4218077475/72976/313582b9/57b286a9N7fcd6d02.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-11/11f802eac4f375809a313b37b5b846ba.jpg',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,1000,0,0,1,0,0,0.00,'','',0,''),(107,59,0,'TP0000107','稀奇（XQ） 稀奇艺术Mini版雕塑《天使比比》瞿广慈艺术品桌面摆可爱小人摆件创意生日礼 粉蓝',11,0,100,0,100,1.0000,790.00,690.00,0.00,'','','稀奇（XQ） 稀奇艺术Mini版雕塑《天使比比》瞿广慈艺术品桌面摆可爱小人摆件创意生日礼 粉蓝','&lt;p&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t19063/139/464210858/74456/6b6a8f03/5a7fde1cNcf0577f7.jpg&quot;/&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t16543/74/2066935873/69653/a65a0d9e/5a7fde1cN463023cc.jpg&quot;/&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t16630/84/479368646/68115/41f96473/5a7fde1cNb4b96b87.jpg&quot;/&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t17164/95/465632481/46832/b54464d9/5a7fde1dN9c5ce09b.jpg&quot;/&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t14209/265/2204955138/69220/78fdef07/5a7fde1dN143eb027.jpg&quot;/&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t15433/362/1917993207/137774/9a52a83/5a7fde1dN48fa7434.jpg&quot;/&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t17287/73/498614721/87044/8f7828df/5a7fde1dN8f88e3e5.jpg&quot;/&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t18019/333/479770956/58737/d55fab4f/5a7fde1dNd049432c.jpg&quot;/&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t16036/274/2069490385/115480/5501f69e/5a7fde1dNc76ad9f4.jpg&quot;/&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t17407/219/504433961/67143/92358fc8/5a7fde1dN9ff75308.jpg&quot;/&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t19498/235/468862149/128707/45b95963/5a7fde1eN187bac5e.jpg&quot;/&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t16642/245/463260288/224906/a560ff7d/5a7fde1eNf15d889a.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t18481/236/493747708/192461/5663d9b4/5a7fde1eN40eb0152.jpg&quot;/&gt;&lt;img src=&quot;http://img10.360buyimg.com/imgzone/jfs/t17647/174/479080512/253390/3367c3a1/5a7fde1eNd1cca73e.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-11/4e80b69a4df47d58b7b5665c21394507.jpg',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,100,0,0,0,1,14,0.00,'','',0,''),(108,59,0,'TP0000108','简林 电视柜玄关装创意饰品摆件客厅家居复古美式软装人物雕塑艺术品酒吧咖啡厅摆设',15,0,100,1,100,1.0000,398.00,298.00,0.00,'','','简林 电视柜玄关装创意饰品摆件客厅家居复古美式软装人物雕塑艺术品酒吧咖啡厅摆设','&lt;p&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t5596/165/9690200839/188131/99fb9a8/59894f3bN17da93ba.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t6925/360/2154189473/107384/8a4d195/59894f3cN7534604b.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t5698/22/9679496899/237720/d84a0bac/59894f3dN1b506ccb.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t5698/22/9679496899/237720/d84a0bac/59894f3dN1b506ccb.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t7123/149/1223279250/179204/f2d2c4c8/59894f3eN02e020a8.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t6985/350/2125341276/230485/594d35dd/59894f3bNfa773f42.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t6832/211/2148289119/155640/56534aeb/59894f41N0539fd5d.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t6127/332/8451249281/136531/91629332/59894f33N6b575e54.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t6043/197/8021798790/167215/9aa299e1/59894f41N29e0d993.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t6994/15/2135380600/119662/75fd408/59894f43N81a0a68e.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-11/c7108337952d19308c2ed783bb02cee3.jpg',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,0,4,0,0.00,'','',0,''),(109,59,0,'TP0000109','集思美 创意复古摆件思想者砂岩摆设办公室客厅欧式家居装饰品艺术工艺品',26,0,99,1,0,1.0000,99.00,88.00,0.00,'','','集思美 创意复古摆件思想者砂岩摆设办公室客厅欧式家居装饰品艺术工艺品','&lt;p&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t2581/28/1811721244/61815/a24d4d58/574b030bN8d63fcdb.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t2776/126/1808389387/59821/b56a632f/574b030cN20079240.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t2782/119/1818546541/105701/88b3ea6f/574b030cN2764866f.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t2770/153/1806524729/122225/267df98f/574b030cN563e0f0b.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t2965/300/87437918/111721/c5e5fc26/574b030dNc3a6695d.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t2749/109/1818400629/147525/ccf94de4/574b030dN3eb7cfd8.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t2656/120/1810878719/137745/db4e3807/574b030eNb9657b4a.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t2671/26/1780413219/125735/bc4d58f3/574b0310N6ce0d042.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-11/bf521ee7d32bc65883466e0117bbbf21.jpg',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,100,0,0,1,0,0,0.00,'','',0,''),(110,59,0,'TP0000110','马到功成战马摆件摆件家居装饰品客厅酒柜玄关书房办公室桌面装饰艺术品生肖动物骏马装饰摆件招财工艺品 FX-068-01B 平马',14,0,97,0,0,0.0000,209.00,198.00,0.00,'','','马到功成战马摆件摆件家居装饰品客厅酒柜玄关书房办公室桌面装饰艺术品生肖动物骏马装饰摆件招财工艺品 FX-068-01B 平马','&lt;p&gt;&lt;img src=&quot;https://img11.360buyimg.com/imgzone/jfs/t16171/333/2550232368/182593/ce9f4f06/5abc91d5Nb1fb3e82.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t19387/246/1111833606/184857/e44a9175/5abc91d5Ne49784f1.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t17041/277/1098717031/173339/50002336/5abc91d5Nb255c3bf.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/imgzone/jfs/t19657/322/1078680700/101163/619a2e87/5abc91d5N4dfdd895.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/imgzone/jfs/t19702/29/1177498778/248454/712f41dd/5abc91d5Na3c74de7.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t17623/20/1135458396/172756/e3716ab3/5abc91d5N51398c85.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/imgzone/jfs/t18001/119/1106700133/232056/3d2b938a/5abc91d6N57d39516.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t16786/249/1165004084/169420/d710df0/5abc91d6Nc90a069e.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t16786/249/1165004084/169420/d710df0/5abc91d6Nc90a069e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/imgzone/jfs/t17377/305/1143993699/240416/b6c17c23/5abc91d6N86de573f.jpg&quot;/&gt;&lt;img src=&quot;https://img13.360buyimg.com/imgzone/jfs/t19483/99/1097380705/155914/ed97434e/5abc91d6N6d319ae8.jpg&quot;/&gt;&lt;img src=&quot;https://img11.360buyimg.com/imgzone/jfs/t16669/1/1165858562/136638/61e8c1df/5abc91d6N6a7f57b2.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/imgzone/jfs/t16669/364/1113917918/264347/4b62e6ad/5abc91d6Ne1571cc5.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/imgzone/jfs/t17956/235/1118691822/186748/a1826ced/5abc91d7Ncd84a6cc.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t19366/12/1106541568/210055/9741bfe1/5abc91d7Ne7b5a509.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-11/dd04f33806d743f1e02190dd05e2422b.jpg',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,100,0,0,3,0,0,0.00,'','',0,''),(111,525,0,'TP0000111','结婚礼物送老婆情人节创意礼品婚庆订婚装饰品女生生日礼物家居客厅卧室摆件浪漫节日礼物送女友 XR-061 珍珠白(有相框）',6,0,100,0,110,1.0000,99.99,99.99,0.00,'','','结婚礼物送老婆情人节创意礼品婚庆订婚装饰品女生生日礼物家居客厅卧室摆件浪漫节日礼物送女友 XR-061 珍珠白(有相框）','&lt;p&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t12898/362/2527294451/149787/c109519/5a473462Na7225992.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t15802/186/1040234344/124591/19ace31a/5a473463N751c4a71.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t16216/217/1007072221/95558/f64bc91d/5a473463N84a06b8d.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t13657/146/2593087000/125978/bee70947/5a473463N5530e28f.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t14413/351/1161907512/109262/aea09df2/5a473463Nf969c86b.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t13948/154/2625418374/187281/50696779/5a473464Ndfb8124a.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t13963/113/2662334473/84721/7ed2fa01/5a473464N3345c366.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t15811/5/1022345741/192685/a92cd3c2/5a473465N7ac0ce93.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t12886/231/2657806685/145074/d0b5cb00/5a47345cNb9733dbb.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/629aa36e3780bc16397b2488cc0f3da4.jpg',0,-28800,0,1,0,0,0,1,1,50,1,0,0,0,0,100,0,0,0,0,0,0.00,'','',0,''),(112,55,0,'TP0000112','DIY儿童饭团模 创意兔子海豚饭团模具4件套装 便当寿司食物模',7,0,97,0,11,1.0000,12.50,12.50,0.00,'','','DIY儿童饭团模 创意兔子海豚饭团模具4件套装 便当寿司食物模','&lt;p&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t556/340/817743252/165318/7206734b/548c0e84Nda069373.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t568/255/824714864/159791/2855aaaf/548c0e84N476704e9.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t691/160/784395340/186376/1bd5aa92/548c0e84N4b93a456.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t646/326/816035666/89587/140ec9e2/548c0e85N8e05dda8.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t625/265/779814740/203039/7174e820/548c0e85Nf8ba60c5.png&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t625/265/779814740/203039/7174e820/548c0e85Nf8ba60c5.png&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t670/99/816343588/106930/cb84fd9e/548c0e85N1d204a26.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t589/146/825468274/113053/e4576d78/548c0e85Ncfeecba1.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-11/c5b8be7b0af643b336608dee775a47b7.jpg',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,10,0,0,3,0,0,0.00,'','',0,''),(113,24,0,'TP0000113','南极人 polo衫男 翻领短袖t恤男装小鹿印花休闲 灰色 XL',3,0,494,0,125,0.0000,139.00,129.00,0.00,'','','南极人 polo衫男 翻领短袖t恤男装小鹿印花休闲 灰色 XL','&lt;p&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t19690/215/1450817854/79236/75fb094f/5ac9ba1dN4dc74ae8.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t16849/108/1441691183/86674/201886a/5ac9ba1dN752c4fa7.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t18652/108/1416766899/110851/e5c52343/5ac9ba1dNd4425814.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t17860/284/1392676311/49092/85b07ebf/5ac9ba1aNdb809968.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t18802/328/1405782381/84197/d3f37383/5ac9ba1dN06f6f548.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t16870/211/1448543920/74209/6eae7f65/5ac9ba1dN666f1253.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t16870/211/1448543920/74209/6eae7f65/5ac9ba1dN666f1253.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t17107/59/1392082208/77508/ab3efad7/5ac9ba1dN1266070f.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t19540/129/1419722120/105901/50c04a1c/5ac9ba1eN5f740299.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t18286/52/1402446283/84492/b2cdfbdb/5ac9ba1eNb963935e.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWaterMark/jfs/t19240/322/1459558679/136531/58850a1/5ac9ba21N15a1494d.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-11/948c9a2f762c263e34e39369e1c643a8.jpg',0,-28800,0,1,0,0,0,1,1,50,1,0,0,0,1,3000,0,0,6,0,0,0.00,'','',3,''),(114,62,0,'TP0000114','荣耀 畅玩6 2GB+16GB 金色 全网通4G手机 双卡双待',12,0,199,0,125,0.0000,699.00,599.00,0.00,'','','荣耀 畅玩6 2GB+16GB 金色 全网通4G手机 双卡双待','&lt;p&gt;&lt;img src=&quot;http://img13.360buyimg.com/cms/jfs/t8623/43/851254002/231614/10b69c99/59af9faaN1cfffdb0.jpg&quot;/&gt;&lt;img src=&quot;http://img10.360buyimg.com/cms/jfs/t7606/112/2423228805/261739/fdd13ef9/59af9fb4N8bc3e818.jpg&quot;/&gt;&lt;img src=&quot;http://img13.360buyimg.com/cms/jfs/t7843/158/2473797804/222389/cec9adf3/59af9fbbN3b5e7c01.jpg&quot;/&gt;&lt;img src=&quot;http://img13.360buyimg.com/cms/jfs/t7498/119/2456967878/269943/6de94c4d/59af9fc2Nfbd7b7e7.jpg&quot;/&gt;&lt;img src=&quot;http://img14.360buyimg.com/cms/jfs/t7510/163/2446226753/250350/61b4ae2b/59afa007Nfe0ec860.jpg&quot;/&gt;&lt;img src=&quot;http://img11.360buyimg.com/cms/jfs/t9229/346/803588160/139193/68b09732/59afa016N519bbc5c.jpg&quot;/&gt;&lt;img src=&quot;http://img11.360buyimg.com/cms/jfs/t9178/208/811965610/58374/17a7c898/59afa01bN38514ec8.jpg&quot;/&gt;&lt;img src=&quot;http://img14.360buyimg.com/cms/jfs/t8791/217/820890779/61083/cf36b460/59afa019Ncd278b6a.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-11/5ce2fb5c34d81c0e27388b440711916e.jpg',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,2,0,0,0,1,4,0,0.00,'','',3,''),(153,245,0,'TP0000153','积分兑换维尼小熊手套',20,0,317,0,100,0.0000,199.00,99.00,109.00,'[{\"amount\":3,\"price\":79},{\"amount\":5,\"price\":69},{\"amount\":7,\"price\":59}]','','990积分兑换维尼小熊','&lt;p&gt;停格&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/662e37a0f558df16a43837cf89bfc4b9.jpg',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,1,0,990,1,2,0,0,0.00,'','',3,'/public/upload/goods/2018/04-16/6933ceb4acc92dba2d35ec5b43549e9e.mp4'),(115,43,0,'TP0000115','包材商城 TRULY信利SC 991ES PLUS微积分学生高考计算器 科学函数计算器',9,0,96,0,111,11.0000,29.90,19.90,10.00,'','','包材商城 TRULY信利SC 991ES PLUS微积分学生高考计算器 科学函数计算器','&lt;p&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWareDetail/jfs/t2920/279/154425577/330843/6ad6ba93/574d3effNa5aace9d.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWareDetail/jfs/t2869/345/1876199415/278918/ad698900/574d3effN465c5092.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWareDetail/jfs/t2869/345/1876199415/278918/ad698900/574d3effN465c5092.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWareDetail/jfs/t1384/88/1423530299/142866/f45a79b5/55c6ebb9N2353d652.jpg&quot;/&gt;&lt;img src=&quot;http://img30.360buyimg.com/popWareDetail/jfs/t1603/117/1424924404/211774/fb2257f/55c6ebb9Nf0de867f.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-12/812c2c384a34876cca2b23b2b5b406cd.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,1,0,0,0,100,0,4,0,0,1.00,'','',0,''),(116,117,0,'TP0000116','劲仔小鱼 鱼干鱼仔 零食 香辣味 15g*20包/盒',15,0,77,1,300,0.0000,70.00,23.80,66.00,'','辣 湖南特产','产自靖港古镇','&lt;p class=&quot;more-par&quot; style=&quot;margin-top: -5px; margin-bottom: 0px; padding: 0px 20px 0px 0px; text-align: right;&quot;&gt;&lt;a href=&quot;https://item.jd.com/1096587.html#product-detail&quot; class=&quot;J-more-param&quot; style=&quot;margin: 0px; padding: 0px; color: rgb(0, 90, 160); text-decoration-line: none;&quot;&gt;更多参数&lt;span class=&quot;txt-arr&quot;&gt;&amp;gt;&amp;gt;&lt;/span&gt;&lt;/a&gt;&lt;/p&gt;&lt;table width=&quot;0&quot; align=&quot;center&quot;&gt;&lt;tbody&gt;&lt;tr class=&quot;firstRow&quot;&gt;&lt;td&gt;&lt;img width=&quot;750&quot; height=&quot;486&quot; class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t6046/333/3023560277/174140/4ae5924f/5949dcafN7c017443.jpg&quot;/&gt;&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;&lt;img width=&quot;750&quot; height=&quot;490&quot; class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t5881/358/4223417258/235353/b751f117/5949dcafN00c04f99.jpg&quot;/&gt;&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;&lt;img alt=&quot;&quot; width=&quot;750&quot; height=&quot;726&quot; class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t6106/340/2959879567/235396/20771801/5949dcb0N0998fcae.jpg&quot;/&gt;&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;&lt;img alt=&quot;&quot; width=&quot;750&quot; height=&quot;769&quot; class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t6715/245/1025417710/254532/46608382/5949dcb0N698cf3f4.jpg&quot;/&gt;&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;&lt;img alt=&quot;&quot; width=&quot;750&quot; height=&quot;684&quot; class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t5869/83/4216688243/241478/c2227934/5949dcb0Ne05dd97d.jpg&quot;/&gt;&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;&lt;img alt=&quot;&quot; width=&quot;750&quot; height=&quot;530&quot; class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t6742/231/1062177743/193437/3b883aa6/5949dcb0Na88710da.jpg&quot;/&gt;&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;&lt;img alt=&quot;&quot; width=&quot;750&quot; height=&quot;501&quot; class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t6553/2/1059966274/138317/142dd62c/5949dcb0N73bda396.jpg&quot;/&gt;&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;&lt;img alt=&quot;&quot; width=&quot;750&quot; height=&quot;384&quot; class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t6736/255/1026133860/139332/45aeb5c3/5949dcb1N30a29732.jpg&quot;/&gt;&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;&lt;img alt=&quot;&quot; width=&quot;750&quot; height=&quot;498&quot; class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t5836/260/4218496618/242736/e0d51dcb/5949dcb1N02a8f239.jpg&quot;/&gt;&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;&lt;img alt=&quot;&quot; width=&quot;750&quot; height=&quot;595&quot; class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t6556/148/1042475937/243102/2faac41a/5949dcb1N43b5a2f3.jpg&quot;/&gt;&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;&lt;td&gt;&lt;img alt=&quot;&quot; width=&quot;750&quot; height=&quot;620&quot; class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t5839/140/4217748540/245872/ebeb8a5c/5949dcb8N3e50b811.jpg&quot;/&gt;&lt;br/&gt;&lt;br/&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-12/0ed8bc843f85f0436016c0feb9728ce8.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,3,0,0,0.00,'','',3,'/public/upload/goods/2018/04-12/4eb6fa9047b52b30c327ba7aa88fc902.mp4'),(117,20,0,'720668','套头卫衣女秋装新款短纯色连帽衫潮关晓彤商场款',0,0,249,0,400,0.0000,179.00,125.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9760/287/2103242358/339297/2f4cabf5/59ef3da8N2e57644a.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5650/56/6924521528/162650/5ba319a7/596d82e6Nc0fccb4c.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5788/7/6922168375/109525/d2cf2699/596d82e6N8fa80da8.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t6130/191/5628946541/124535/feef3045/596d82deN2ea0aa0a.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5776/239/6884184787/141534/42e4fb2f/596d82f4N00805c53.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t6013/195/5647590942/98830/74ec028a/596d82e3Nd480226f.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t6040/189/5651591748/93459/bd609d4d/596d82e5Nd1a50714.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5581/281/6950493552/140407/aacd2794/596d82e5N4be3825d.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5713/331/6946386167/208190/816341b4/596d82e9N52d9d5e8.png&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5689/234/6880334952/60100/bbe37ae4/596d82e7Nd88de1eb.png&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5647/238/6889853799/452254/695cf1bd/596d82ebN6635dd77.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5776/215/6965304175/147956/5e45cbb5/596d82efN9b4ebd2c.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5653/330/6914948625/139105/c695f0bc/596d82ebN22d0cb6f.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/43270a902f6878f2ac4582d89b423e52.png',0,-28800,0,1,0,0,0,1,1,50,1,0,0,0,0,0,0,0,1,0,0,0.00,'','',0,''),(118,183,0,'888','单蜜半身裙女装2018春季新款高腰破洞牛仔中长裙子',9,0,195,1,500,0.0000,198.00,138.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19420/52/302568544/519451/9bf28999/5a69a092N8a490a8d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19477/328/316184248/457931/d50696d8/5a69a092Ne3842aab.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18151/3/302998366/453910/12bef176/5a69a092N194d1f53.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19414/53/317332949/418577/8bf94786/5a69a092N3e5108f5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13249/307/1338073685/330783/696b90f6/5a69a092N5b23a980.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17503/59/298157145/61041/e88ba9a8/5a69a092Nc317e621.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17938/291/292296414/663164/6ffa5236/5a69a093N629c952f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19342/31/279339691/425429/96d34544/5a69a093Nefdce2f0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14587/66/2052986820/473274/327615b6/5a69a093Nd7aadf02.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14377/72/2097354285/519373/d26326be/5a69a094N10230e5e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14809/148/2071130358/664036/da42a334/5a69a08fN5e4268e5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17194/8/297849799/648608/89a09203/5a69a093Nb04e6ed6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15118/326/2030889173/400454/82eedcb3/5a69a093N744c5f68.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18940/41/308361872/510953/e5e44382/5a69a093N47202371.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14557/253/2056864279/576749/c7107e8/5a69a096Nace50096.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16600/254/314294269/484480/6ee81f67/5a69a093N3f5509e2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19414/58/303069738/266175/804bf1b7/5a69a094Ne1509936.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17296/347/323370087/372259/e39c3a0e/5a69a094N5ea2683e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18787/14/296755329/407828/ac0c8b58/5a69a094N07554641.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17011/18/305534432/395873/997ae75f/5a69a094N70baaedf.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16603/73/288488186/327507/b92b56ec/5a69a094N08e236e7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16573/359/1819453607/461273/15603456/5a69a094Nf4ae1ea3.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19192/44/287784305/262734/d2eca82a/5a69a094N7a4210ec.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/447a78f19d258268e6f2e61100e8346f.png',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,0,0,0,0,5,0,0,0.00,'','',0,''),(119,184,0,'JBD922','南极人 牛仔短裤女2018夏季新款韩版高腰排扣宽松破洞毛边阔腿裤弹力显瘦热裤JBD922',11,0,497,0,300,0.0000,128.00,89.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18259/70/634367039/469097/271f1a15/5a9d1b0bN9189c9a8.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15820/355/2291723139/461049/cdbe951a/5a9d1b0cN148ca817.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19612/71/652789445/528350/36432a8f/5a9d1b0cN3711c5f8.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17812/57/672581682/225234/46e89c3f/5a9d1b09N08e088e4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14197/183/2432632001/222035/c0b15721/5a9d1b09Neea398ba.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14932/275/2452508354/229599/600c1ee2/5a9d1b09N3c88b7c1.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15769/210/2262813869/195650/c5a82f80/5a9d1b09N3ae7f252.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16444/148/2227321049/232381/148bc13a/5a9d1b09Nf5296b8f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19051/97/652261652/113439/30381677/5a9d1b08Nab45e938.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18391/289/650239866/423678/4376542e/5a9d1b0bNae92458c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18610/293/625112925/448473/da00fefc/5a9d1b0cN29bd47b1.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14662/39/2394817018/407019/7f6efe0b/5a9d1b0bN91a0ebf7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15496/202/2266124776/446205/a9bc9aa1/5a9d1b0aN86efee2a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17137/132/657798666/405057/6fa17365/5a9d1b0bNe0df3e45.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15613/162/2252921388/458453/9c4e0a11/5a9d1b0cN60ce5874.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19369/352/629278510/423404/83a1b596/5a9d1b0bN021d8fff.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18976/331/612297907/468566/57895b6a/5a9d1b0cN8b28a5e0.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/a00629a8e6293c9f41fc48c0dc01cf8a.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,3,0,0,0.00,'','',0,''),(120,500,0,'TP0000120','Casio/卡西欧手表男三眼皮带防水石英表正品学生男表BEM-506L-7A 卡西欧商务休闲石英男表',26,14,99,0,100,1.0000,2899.00,2699.00,111.00,'','','Casio/卡西欧手表男三眼皮带防水石英表正品学生男表BEM-506L-7A\r\n卡西欧商务休闲石英男表','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1978783381/TB2z3xikdrJ8KJjSspaXXXuKpXa_!!1978783381.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1978783381/TB2QApZXER1BeNjy0FmXXb0wVXa_!!1978783381.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1978783381/TB2QApZXER1BeNjy0FmXXb0wVXa_!!1978783381.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1978783381/TB2hnBAkgvD8KJjy0FlXXagBFXa_!!1978783381.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1978783381/TB2z3xikdrJ8KJjSspaXXXuKpXa_!!1978783381.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1978783381/TB2Un0Ykf6H8KJjSspmXXb2WXXa_!!1978783381.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1978783381/TB294pZknvI8KJjSspjXXcgjXXa_!!1978783381.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1978783381/TB2hXXBkcnI8KJjSsziXXb8QpXa_!!1978783381.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1978783381/TB2hXXBkcnI8KJjSsziXXb8QpXa_!!1978783381.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1978783381/TB2mRM7j0fJ8KJjy0FeXXXKEXXa_!!1978783381.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1978783381/TB2mRM7j0fJ8KJjy0FeXXXKEXXa_!!1978783381.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1978783381/TB2QSteklHH8KJjy0FbXXcqlpXa_!!1978783381.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1978783381/TB2QSteklHH8KJjy0FbXXcqlpXa_!!1978783381.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1978783381/TB2IHUNj8DH8KJjSszcXXbDTFXa_!!1978783381.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1978783381/TB2bHRqkgnH8KJjSspcXXb3QFXa_!!1978783381.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1978783381/TB2SioKkxHI8KJjy1zbXXaxdpXa_!!1978783381.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1978783381/TB2Jq.QhbuWBuNjSszgXXb8jVXa_!!1978783381.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/749829bc816932b670dc46d823f3ce5c.jpg',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,10000,0,0,1,0,0,0.00,'','',0,'/public/upload/goods/2018/04-13/840beec2b83dfa7b49863a61fc4b2d4a.mp4'),(121,185,0,'TP0000121','亲晨新款旗袍上衣2017秋款改良中式复古唐装女士日常连衣裙中袖 A0051-A七分袖上衣',1,0,299,0,500,0.0000,218.00,168.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t1150/74/1466445661/316299/12d4a878/572dbf9dNbe7dfb31.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t1252/18/1490085260/221791/85e55e1f/572dbf9eN8adbe78a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2737/23/965995789/253036/279cf671/572dbf9eN5591c419.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2689/26/985108039/292063/18cac911/572dbf9fNbcdee6d4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t1258/331/1442039777/325158/14d52358/572dbf9fNc6a16986.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2749/15/967343480/331694/d94dad77/572dbf9fN1fbf27ae.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t1033/51/1460743946/350919/7aac3a59/572dbfa0N7ea139c8.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t1276/224/1474571373/297181/74f25f2b/572dbfa0Ndca62337.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t1114/301/1468069961/421091/72613a11/572dbfa1N1c095b1b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t1105/18/1450461765/253100/48fae3d9/572dbfa1N416f0068.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t862/228/1455995903/261535/ed23ea8c/572dbfa2N5fad315d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2863/321/974325842/246539/7183578c/572dbfa2Ne1f4ca6c.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/9458b8588e00e59113d2c815d0b7905c.png',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,0,100,0,0,1,0,0,0.00,'','',0,''),(122,495,0,'TP0000122','阿帕琦IK 手表镂空全自动夜光机械表 男表防水商务韩版时尚休闲腕表学生运动男士手表新款钟表 金边白面金机心/过万评价',4,0,100,0,100,1.0000,398.00,199.00,1588.00,'','','阿帕琦IK 手表镂空全自动夜光机械表 男表防水商务韩版时尚休闲腕表学生运动男士手表新款钟表 金边白面金机心/过万评价','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3808/304/1007104203/789634/17a2a521/5820de60N481964ee.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3067/145/5874976770/384874/aa57138a/58920a76N221f405e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3751/69/1232769313/792588/87497913/5820de66Ne0b3900e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3727/352/1264977138/811865/c2148559/5820de6cNa993bcf0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3355/61/1267177635/747278/4b0a37e2/5820de72N2f9d6965.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3625/10/1241032866/763142/e8914fe2/5820de78N8607dc1b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3547/334/1244362484/1018969/11e6df06/5820de80N79831cad.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3319/302/1259383829/1107282/2535b4d2/5820de88N370e7a03.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3961/118/1037382640/297411/52498c86/58665b96N80f2fc7a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3961/118/1037382640/297411/52498c86/58665b96N80f2fc7a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3838/339/1006726097/858461/33f06d8b/5820de95N331829c0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3895/157/1008485170/292207/2c2fe893/58665bb0N5db794a0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3394/319/1293234196/1067051/4c948f78/5820dea3Nf4eaf93d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3661/265/1263045871/878389/572e5d64/5820deaaN2f06146e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3607/13/1297694230/894759/fdf757e1/5820deb1Nebce2c49.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3652/339/1271359830/875315/cda52847/5820dee4N0320f933.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/e968ee802db0d6aa06efe4ad96e977a3.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,1,0,0,10000,0,0,0,0,0,1852.00,'','',3,'/public/upload/goods/2018/04-13/59547355436ecf6e729cda2452662b8b.mp4'),(123,186,0,'G-322H-6666-43','汐颜 阔腿裤套装女2018新款女装短袖套装韩版宽松时尚七分裤两件套G-322H-6666 ',1,0,200,0,1000,0.0000,215.00,158.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t18829/92/1308472335/510974/b5d66981/5ac49350N1ab24291.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/imgzone/jfs/t18808/106/1301257864/479491/778563e6/5ac49352N3d1d9e37.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t18142/124/1269757322/340144/f2098095/5ac49354N5c817362.jpg&quot;/&gt;&lt;img src=&quot;https://img13.360buyimg.com/imgzone/jfs/t18145/154/1314965111/349905/b5590303/5ac49357Na8af0981.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/imgzone/jfs/t17764/100/1283533238/163015/d76c1747/5ac49358N23904965.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/imgzone/jfs/t19135/217/1281047660/274684/5faf8572/5ac4935aN3bd21ca5.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t19771/98/1362466732/285613/39abe99f/5ac49362Nf5affc23.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/imgzone/jfs/t18715/94/1324185505/659375/371dd217/5ac49367Nf5103084.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t19129/97/1310453714/424173/97f9ab60/5ac4936aN211bf99b.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/imgzone/jfs/t17524/62/1299335297/370199/54c0b235/5ac4936cNd27d1ace.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/imgzone/jfs/t17971/143/1292457084/512446/129ffb3b/5ac49370N25326aca.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t18094/355/1318399572/260520/38f2c3ed/5ac49372N20383872.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t18952/5/1334102736/632760/5c178677/5ac49377N5730d112.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/imgzone/jfs/t17947/149/1326100741/464264/ba9e61c9/5ac49379N8639c37c.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/imgzone/jfs/t19186/151/1316388004/699875/4eac4d2e/5ac4937cN41bc9283.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/imgzone/jfs/t19138/40/1310100075/339282/3a60c5bd/5ac4937fN1c249db9.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18514/311/1299398573/338911/95cd8e1f/5ac49381Nce77afcf.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/533f44ecc87e1f031d47ff0e01cfc6ea.png',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,0,0,0,0,0,0,0,0.00,'','',0,''),(124,187,0,'GD B211-C 535#35','荻尼菲夏季牛仔裤女2018新款时尚高腰牛仔九分破洞哈伦女裤',1,0,300,0,300,0.0000,119.00,86.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18340/233/1114144797/98875/e3e0d62d/5abdf89fNc08dbef2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19690/82/1178751125/97586/297fc9df/5abdf89dN4953dc38.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17191/163/1144405146/98343/494d01a9/5abdf89fN4746a8ba.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16648/175/1150187392/100242/568fc7e5/5abdf8a0N9309463a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18562/4/1170414686/97035/ba4eabb3/5abdf8a0N45a2119e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17926/87/1158154572/99346/1a5b48c2/5abdf8a0Ne8f92250.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18577/13/1164618460/90522/5dbe91fa/5abdf8a0Nb7e909e1.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18985/365/1146689211/97043/cad1051a/5abdf8a0N640d02a5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19069/331/1175979789/95985/1a1e61db/5abdf8a0N3fd8e888.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19300/25/1170874173/99634/18d28134/5abdf8a0Nf38d83a3.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19201/26/1120273757/97413/d5106113/5abdf8a0N09c6bf24.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19225/323/1188905196/99398/91bc69a4/5abdf8a0N92645687.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18133/71/1151400620/98313/24f37f/5abdf8a0N101b2f48.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18061/42/1157769047/99052/2e9d306b/5abdf8a0N2b5efbc0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19207/16/1177240064/98083/cde6b829/5abdf8a0Nda97d15f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16969/320/1163594458/249428/f5a99cd3/5abdf8a1N71772203.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17056/273/1123870488/98455/4fed0d26/5abdf8a1N6063019d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18610/7/1180498151/97877/29fd778a/5abdf8a0Nfcfe3af8.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16453/173/2676175739/99192/6e2c1359/5abdf8a0N5e5a7753.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18085/273/1161069765/98896/afd425b/5abdf8a1Nb4adcd31.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18763/31/1117201107/98454/73918af7/5abdf8a1Nd88dad67.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18727/37/1187767864/99906/ee5d8128/5abdf8a1N7c89c89e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18493/63/1097094357/100287/385e53cc/5abdf8a1N7de0554b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17308/61/1172324590/99211/5220ec29/5abdf8a1N2b4baf40.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16048/277/2456007508/98213/29f43b68/5abdf8a1N99109fa3.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16960/158/1034818970/99387/240ac7a1/5abdf8a1N742d1dd6.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/b7abe1ebbf8cbcd52382059111414d2c.png',0,-28800,0,1,0,0,0,1,1,50,1,0,0,0,0,0,0,0,0,0,0,0.00,'','',0,''),(125,15,0,'TP0000125','面料菱形肌理感针织连衣裙',10,0,398,0,1202,1.0000,1590.00,1490.00,140.00,'','','面料菱形肌理感针织连衣裙','&lt;p&gt;&lt;img src=&quot;http://a.vpimg4.com/upload/merchandise/pdcvis/2017/12/22/52/da83253c-f417-43a4-b121-bdbd691b48ea.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg4.com/upload/merchandise/pdcvis/2017/12/22/115/7baef949-9318-4bb6-80df-cfeeb5d0676d.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg4.com/upload/merchandise/pdcvis/2017/12/22/36/c73198e3-5aa7-4837-a25c-3e158514464d.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg4.com/upload/merchandise/pdcvis/2017/12/22/174/f34fbc4b-7764-4ba0-929f-b475024690d6.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/e4c789f8a4378a03ba7188dc8a2b1bf2.jpg',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,1,10000,0,0,2,0,0,1410.00,'','',0,''),(126,188,0,'SM-18W02955','水墨佳人中老年女装2018春装新款短外套女中年女装圆领外套妈妈装薄外套18W02955',2,0,200,0,500,0.0000,288.00,169.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15523/126/1832571470/512577/9d10e8d6/5a644de2N28eb4a08.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17650/292/221577146/73653/6c42360f/5a644ddbN286bb01f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18232/275/211920945/347588/dbddd705/5a644de2N8c893704.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15652/144/1850192260/288173/ebdbdb5d/5a644ddcNb53928bc.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18286/278/219059251/101212/7a7ec90a/5a644ddbN404cf242.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17446/267/215457971/434711/a79accdd/5a644de4Nece92475.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18259/278/220564853/464948/5386f368/5a644de0N58f12cdf.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16984/47/221960927/154038/1f0b0a47/5a644dddN55738c83.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14281/99/1993849664/197191/c43bd85e/5a644de0Ne3e20f12.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14425/221/2026249379/502428/c056d6e1/5a644de2Ne9d08411.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14368/54/1930942584/383490/a0c29c9b/5a644de4N3e6d8a18.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17383/217/217756312/354286/5da3bdb9/5a644de4N4da23046.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11860/297/2214306436/242158/45ddd488/5a644de8N071bf5d7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13387/290/2239856005/366731/44403350/5a644de6N230074f6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14380/53/1962322007/321571/28fe9cbc/5a644de8N7e71e47c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14818/122/2041637820/414027/8a53d059/5a644de3N8070e2f2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15388/171/1969709590/328997/8016c124/5a644de8Nc2304151.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16648/269/221703013/327242/d4f09bc7/5a644dedN364acd13.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14359/163/1987422299/294996/4cfdc477/5a644de9Nbbd472eb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18907/271/226010075/370929/289a1090/5a644dedNf208e184.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13306/68/2614578226/287502/bbaad1e/5a644deaN8248ec7d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16240/133/1860213040/400031/58900bc5/5a644decN48d3984c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t12970/165/2645951295/315713/bd57f203/5a644df4Na741e4ed.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19183/199/227483093/273460/1e18fd2b/5a644debNae5d096a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14491/16/2032795905/351953/e5d4b86c/5a644decN955ff6ca.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/5ffb3f83a082a4648dc6470d355c7aa3.png',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,0,0,0,0,0,0,0.00,'','',0,'/public/upload/goods/2018/04-13/92d335eb8788cc2222f341957a5ef0b1.mp4'),(127,189,0,'FFSSMD2003','丽乔 2018新品女装小西装春季一粒扣外套女复古格纹修身西服长袖外衣潮 FFSSMD2003',1,0,302,0,500,0.0000,335.00,269.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15352/274/2274911887/259672/578c5329/5a97c356Nb8b7304f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16048/149/1948728280/63108/bd3543cd/5a97c356N77faa773.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16474/236/2030220904/237475/e927b3f5/5a97c357N49ec92e0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17440/325/587448387/142642/40919f45/5a97c357Nbeb81301.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17407/50/561908258/225594/c79933ff/5a97c357Nb3c88aae.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15760/149/2245528680/195458/994f134e/5a97c357N2095850c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14653/199/2314221683/214999/e454fc60/5a97c359N1ecf046b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16708/76/597881042/230524/86417f80/5a97c35aNecd329b8.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15280/278/2340382219/258993/f0021538/5a97c35bNbe30dc78.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15523/169/2235681428/206620/fdb68a3b/5a97c35bN7fb0424b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14386/153/2190362564/269193/799f191e/5a97c35bN28e82890.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14374/277/2299493400/237247/af61cfa0/5a97c35bNe56c5784.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16450/188/2231845461/222144/b7d91486/5a97c35dN5f283c1c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19054/328/564380333/207845/3a625f87/5a97c35eN12f0ceee.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16345/75/2066655642/220088/76d922b9/5a97c35eN47e7d31e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18109/267/591700984/208083/564318b0/5a97c35fN9dbf63b5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15391/145/2337902839/171234/e2d6d6bc/5a97c35eNef1bd39a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17074/328/561928793/485102/fbd3bb00/5a97c363N3754fa25.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15472/141/2193368771/509484/e57a1d3f/5a97c362N9e665982.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16435/256/2151271728/419616/28a2fb26/5a97c363Nb0e041f0.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/cc866841d5a07a13b557629169ed206e.png',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,0,0,0,0,-2,4,0,0.00,'','',0,''),(128,25,0,'TP0000128','男士速干抗皱抽象字母印花短袖T恤',2,0,700,0,11,1.0000,89.00,78.00,15.00,'','','男士速干抗皱抽象字母印花短袖T恤\r\n','&lt;p&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/05/12/102/48aedb85-f71e-4616-88dd-dce44ba0a13a.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/05/12/131/3f516ba8-2fdf-4311-bfe7-d827a9c0298d.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/05/12/178/f669f21f-3468-43c4-8097-3e5aee9cdcfc.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/05/12/185/709edf15-b993-4d72-8cb6-b925a0d5125d.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/05/12/45/1c7ecbc4-47e6-4777-aa6a-d04d19a82c2b.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/05/12/14/df29a15d-80eb-4660-a3a2-7d2974d7e7af.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/05/12/10/b13fdcb8-c5c6-41d9-8d7b-f47b203b0785.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/05/12/186/00c9c939-248a-49d7-871b-1bb11ca7d4db.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/05/12/119/6e5fc832-00ee-4047-b864-600291e500e1.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/05/12/107/c6d059ec-4f9f-47c5-b468-737cba79b0db.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/05/12/73/8013f6ea-3b7a-4192-8058-8e3f4e9f47c5.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/6d380f7980ac3083a3062f7bdebb1fd8.jpg',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,1,100,0,0,0,4,0,28.00,'','',0,''),(129,190,0,'P4717','优洛莎 2018夏季新款时尚百搭蕾丝镂空针织拼接显瘦上衣P4717',12,0,499,0,350,0.0000,139.00,88.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18835/205/1411940231/505227/f42456c8/5ac71aaeN9e09684b.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t19207/146/1369548810/577862/7168c005/5ac71aaeN530f3852.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t17272/317/1357329351/466505/f5a90f21/5ac71aaeNfa069532.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t17752/269/1326179811/422732/9d2523a9/5ac71ab0Nf87eecdc.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t19654/355/1365925963/477534/26593c2e/5ac71ab0Na24c972a.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t19705/297/1362640728/382829/8836be09/5ac71ab0Nd1793b7b.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18493/160/1344502795/345075/2f5b6066/5ac71ab1N92111d54.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t16717/279/1328234167/347066/6b66f8b7/5ac71ab1Ne9fd0105.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t19087/316/1409762987/381881/44bd9479/5ac71ab1Ndc774632.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t17551/255/1372332448/342729/3f5fe3db/5ac71ab2N9a6b6635.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t17758/273/1357884042/310071/fb1474bc/5ac71ab2N06d6fa5e.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t17014/104/1383622745/354517/b8d5d7fe/5ac71ab2N10025c9c.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/e52c17e3302ed6a6c909eb47becc4133.png',0,-28800,0,1,0,0,0,1,1,50,0,0,1,0,0,0,0,0,1,0,0,0.00,'','',0,''),(130,24,0,'TP0000130','潮牌【多色情侣装】舒适抗皱百搭连帽套头运动男士卫衣',1,0,96,0,1,11.0000,139.00,128.00,100.00,'','','潮牌【多色情侣装】舒适抗皱百搭连帽套头运动男士卫衣','&lt;p&gt;&lt;span style=&quot;color: rgb(51, 51, 51); font-family: 微软雅黑, sans-serif; font-weight: bold;&quot;&gt;潮牌【多色情侣装】舒适抗皱百搭连帽套头运动男士卫衣&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/605176/2017/0711/137/190aa9d0-bcc0-45f6-894a-566c796ef7cf.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/605176/2017/0711/11/e2afe483-7e49-4dd4-b01b-4553f1411383.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/605176/2017/1018/176/2c5308c1-f5f7-4274-9f1f-c4a1b2b6d66f.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/605176/2017/0711/46/93969695-b169-40b1-b3f7-4912f40dcd74.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/605176/2017/0711/23/572c5b00-b48d-476c-9161-97bdebb43e6d.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/605176/2017/0711/91/6ffc9029-f8f6-4c1c-bc49-5133e568e5a0.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/605176/2017/0711/99/bfbbb938-71a3-431c-9b29-761f5cda0a92.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/605176/2017/0711/194/ca99271f-40e0-4106-bf79-b14673ca976c.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/605176/2017/0711/191/173c6d7b-3185-4bf8-8fb7-3ed9060d1324.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/605176/2017/0711/120/2f3b5491-e34b-439f-963c-6b9808830e3e.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/605176/2017/0711/41/ebe7ba93-695e-44e2-913e-db8ce1d70f90.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/605176/2017/0807/101/1d77782b-eed3-4565-aa43-b59a87c872f9.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/605176/2017/0711/1/f9279e19-f0c0-4897-9697-a3869b7072cb.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/605176/2017/0711/29/85896710-93e6-4f00-b5ad-3bcc20a8fa90.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/605176/2017/0711/122/e0da92c7-559f-480a-8d22-692600576281.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/605176/2017/0711/93/341873bd-c414-4824-9d7a-1e634ada4755.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/6a6182ba7c5271c54dd07d4d72851960.jpg',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,0,0,0,0,4,0,0,100.00,'','',0,''),(131,191,0,'TP0000131','子婳打底裤女2018新款大码春夏铅笔小脚休闲裤外穿打底裤',0,0,299,0,500,0.0000,119.00,79.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5602/240/3769662597/142545/e5955e25/594253e6Ne3721bfc.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6601/36/613728083/309430/3a42739d/594253eaN0ab2be16.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8758/209/1087338434/324552/38a52131/59b4a2b4N3ceb80bf.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8575/186/1126095373/573112/2917b1b0/59b4a2c8N9a55c5ca.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7210/311/2736148030/342913/dd212764/59b4a2c8N015f2e8b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7477/196/2820068852/310003/c3cae756/59b4fc6eN62deb639.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7522/123/2824402557/279509/c11b8806/59b4fc6cN5ba9be75.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8569/107/1137443078/324463/7461ad31/59b4fc6fNa11c9c6c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8425/55/1129350657/277527/8bdb0b15/59b4fc70Nad72ebbf.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8230/56/1135699145/170991/4253fe6a/59b4fc71Ncb1fa671.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8653/187/1112604890/221591/792d23c3/59b4a2c9Na256ffa9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2905/320/3367204167/411174/2128d122/578adf2dN012b5cea.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/a9d6eacd4ebf3b1a5cfecc1f6340cc42.png',0,-28800,0,1,0,0,0,1,1,50,1,0,0,0,0,0,0,0,1,1,24,0.00,'','',0,''),(132,192,0,'国投442 1534','怡芊 2018春夏季新款baid个性百搭背心韩版短款牛仔马甲女无袖时尚坎肩破洞马夹上衣女外',0,0,299,0,500,0.0000,99.00,62.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3232/276/6839845280/235147/dcb7702/58ad3613N46ef5f0d.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4015/266/2630341387/166869/7f174c23/58ad3614N580d79e7.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3916/282/2674804215/176214/740a2fc8/58ad3615Na9737ff1.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3997/272/2651954852/254856/a188be01/58ad3617N381da81a.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3910/41/2620395064/157742/8ef12e47/58ad3617N8b9f452e.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3910/65/2612886509/189778/bd42644e/58ad361eNb85cea0e.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3259/223/6867881078/216461/a2c98db8/58ad3618Ne033e953.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4027/2/87117072/316188/4aa32d37/58ad361aNdeb05f2c.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3883/355/91683466/154814/a0d5ca91/58ad361cN8d606268.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3262/94/6813658752/170414/c70b56bd/58ad361dNb9482c66.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3280/232/6660436739/182461/b12384ba/58ad3621Nbd357e8f.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3904/306/2636324088/126162/91935957/58ad361dNa615dbfe.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3250/13/6834532958/170104/174e99de/58ad3621N2f9d2559.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3994/13/88628363/267024/4583ddaf/58ad3622N17e920a3.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3163/281/6832211150/142721/bff9138a/58ad3622N8636e541.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/2c7da46e5341275f677352838fbe125e.png',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,0,0,0,0,1,0,0,0.00,'','',0,''),(133,504,0,'TP0000133','【好礼在此】CASIO BABY-G少女时代广告款石英女表',1,0,88,1,1,1.0000,1111.00,1096.00,0.00,'','','【好礼在此】CASIO BABY-G少女时代广告款石英女表','&lt;p&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2018/0327/158/d714bd84-e041-4cae-8c90-35f861674b7c.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2018/0327/158/d714bd84-e041-4cae-8c90-35f861674b7c.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2018/0327/158/d714bd84-e041-4cae-8c90-35f861674b7c.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2018/0327/158/d714bd84-e041-4cae-8c90-35f861674b7c.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2018/0327/143/491b735b-9b41-400a-8803-c280ffc6170e.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2018/0327/143/491b735b-9b41-400a-8803-c280ffc6170e.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2018/0327/143/491b735b-9b41-400a-8803-c280ffc6170e.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2018/0327/152/51218db7-5acc-4760-87ea-f3be3d750624.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2018/0327/152/51218db7-5acc-4760-87ea-f3be3d750624.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2018/0327/34/db665dcf-574f-4221-8bd7-00be9fffb86c.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2018/0327/27/2bc612cc-a2e9-40a5-984e-c3253969f1ae.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2018/0327/27/2bc612cc-a2e9-40a5-984e-c3253969f1ae.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2018/0327/27/2bc612cc-a2e9-40a5-984e-c3253969f1ae.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/2016/12/19/145/32243d68-c4d8-4902-b9b2-8aa40c593557.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2017/0630/112/d140df8e-0ea9-4c55-b489-b8d0bfe1ac51.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/2016/12/19/28/621273e4-dc99-4250-bfe5-5306a1843923.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/fd795b31781cc27b63b9f80961e18cca.jpg',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,100,0,0,12,6,4,0.00,'','',0,''),(134,500,0,'TP0000134','送给亲爱的】CASIO指针系列网红小红表女士石英表手表  【小红表】 卡地亚的造型，卡西欧的价格。适合在校学生和白领的搭配，火红色的表带象征着热气活力，这款小红表甜美知性，线条柔和细腻，表盘独居设计感强，带点小复古的感觉。喜欢的小仙女们可以',7,0,98,0,0,0.0000,399.00,299.00,0.00,'','','送给亲爱的】CASIO指针系列网红小红表女士石英表手表\r\n\r\n【小红表】 卡地亚的造型，卡西欧的价格。适合在校学生和白领的搭配，火红色的表带象征着热气活力，这款小红表甜美知性，线条柔和细腻，表盘独居设计感强，带点小复古的感觉。喜欢的小仙女们可以入手了哦。','&lt;p&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2017/1018/77/55858b57-8f72-4b9b-914a-da8169334b96.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2017/1018/77/55858b57-8f72-4b9b-914a-da8169334b96.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2017/1018/92/f40856cf-e6ef-44ea-a0fa-66957e510a76.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2017/1018/92/f40856cf-e6ef-44ea-a0fa-66957e510a76.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2017/1018/129/b32de734-0b12-415e-b795-9222ed8e8bc3.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2017/1018/129/b32de734-0b12-415e-b795-9222ed8e8bc3.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2017/1018/63/bba7eabc-2a0f-40f2-82bc-58134b97024d.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2017/1018/63/bba7eabc-2a0f-40f2-82bc-58134b97024d.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2017/1018/2/d24bb742-75ac-4f9c-8df2-2c6c27de4d08.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2017/1018/109/090265d9-0a2f-47dd-bfc4-8d4dcaa4ad20.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2017/1018/155/a282e8ee-65fc-4241-81d2-a0eebf0c9c62.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/600717/2017/1018/155/a282e8ee-65fc-4241-81d2-a0eebf0c9c62.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/3013080d708e695f4d2116c8c14ef149.jpg',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,100,0,0,2,0,0,0.00,'','',0,''),(135,193,0,'TP0000135','月缦 2018新款礼服A字裙短袖少女中国风学生日常短款中式礼服连衣裙',19,0,189,0,800,0.0000,339.00,218.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19771/289/1065156629/459408/6a34ef4a/5aba19dcN94d5e270.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18181/291/1096809907/455432/f9713338/5aba19ddN73b30413.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16078/1/2598308855/274006/ca4d2782/5aba19d8N71fc70f7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18277/248/1050755601/523864/52877e06/5aba19dcN4b0648e6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16666/198/1033971972/469581/659a8a82/5aba19deN0ee713b4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18844/223/1102328816/495117/733f5d08/5aba19e0N72972032.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17953/319/1073571001/181602/2a049cf2/5aba19d9Nb99a4dca.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17371/321/1055166272/347801/2f49bfb8/5aba19dbNb6520a09.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18598/305/1071029110/386970/19c22f7c/5aba19e0N5813cd6a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17257/273/1074083912/394803/3f0dc7f2/5aba19e2Nd74de22f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18907/27/1074567351/404379/123d168f/5aba19e2Nf133a13c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15247/19/2614639738/306401/dfd4f6f4/5aba19e5N659d58c4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17032/190/1074844170/294144/f7ff2599/5aba19e0N69352a1a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18934/220/1075461747/360673/67475bca/5aba19e3Nd17eb062.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17500/103/1081915236/383370/5868c86/5aba19e4N8b9b90ae.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18934/211/1059035982/485829/1379910a/5aba19e5Na08398a4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13849/180/2588367841/458734/20cfd054/5aba19e5Neb215e15.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18835/236/1035346177/350372/9f6d4f6c/5aba19e4Nce6728a4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18292/264/1087475882/165723/91b4ffef/5aba19eeNf551f9ce.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/686356cfc70ffcf6005d4c4f1d0f98e9.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,11,0,0,0.00,'','',0,''),(136,486,0,'TP0000136','黄金(足金)六字大明咒戒指 计价',7,0,299,0,0,1.0000,1111.00,999.99,0.00,'','','黄金(足金)六字大明咒戒指 计价','&lt;p&gt;&lt;span style=&quot;color: rgb(51, 51, 51); font-family: 微软雅黑, sans-serif; font-weight: bold;&quot;&gt;黄金(足金)六字大明咒戒指 计价&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;color: rgb(51, 51, 51); font-family: 微软雅黑, sans-serif; font-weight: bold;&quot;&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2018/03/30/48/ce7f6a9e-2b32-4bce-9df1-f0c3a741378b.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2018/03/30/117/1d9e78d3-7898-43fb-bd26-8b44e3c6bd23.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2018/03/30/181/337d2a22-5750-4741-9777-babdd45131be.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2018/03/30/154/ab34fd1a-8b7f-4ef8-bc77-da4256143d74.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2018/03/30/198/e677befc-d914-4296-b927-edb123892556.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/ugcaudit/2018/02/22/70/ugc_m_21_366224.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2018/03/30/2/b3273b9b-e6a8-40f9-abea-5464a7841e50.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2018/03/30/2/b3273b9b-e6a8-40f9-abea-5464a7841e50.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2018/03/30/23/a49688ab-69fd-46a9-ae37-9f700235efdf.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2018/03/30/160/1fd5d72e-1182-4832-a661-b8d65beffe5d.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2018/03/30/12/b1375bee-0a8e-4990-8f82-d647a0103ec3.jpg&quot;/&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2018/03/30/2/b3273b9b-e6a8-40f9-abea-5464a7841e50.jpg&quot;/&gt;&lt;/span&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/9953fbb8531e5ae59a809ade6d8a6faf.jpg',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,7,100,0,0,1,0,0,0.00,'','',0,''),(137,464,0,'TP0000137','新款桔杏格配红色头层牛皮百搭双肩包',3,0,100,0,0,0.0000,698.00,598.00,500.00,'','','新款桔杏格配红色头层牛皮百搭双肩包','&lt;p&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/179/571bd6e9-0e57-41c3-bf04-a1ad893890aa.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/91/eaa1665b-a97c-474e-b7e4-c48149b6f059.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/11/119af997-0b2c-4aa3-8b2f-cca14a54ec93.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/49/4945accf-05ad-451e-8b0c-c952fb189f72.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/173/c6214760-35f7-4a57-bcfe-a382f9aa5436.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/116/f8338a9b-bcde-49f7-9eca-78c4f492c1f0.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/46/6bc8f89c-7d15-453a-971b-0a7c9dfa32e8.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/93/00ed5ee4-2d05-44cd-af2e-ab8288da708b.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/93/00ed5ee4-2d05-44cd-af2e-ab8288da708b.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/47/296b1983-9a19-49df-9d47-57a3a86a1169.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/47/296b1983-9a19-49df-9d47-57a3a86a1169.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/187/896917b2-e93a-4166-9f1b-e89bc36b6198.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/187/896917b2-e93a-4166-9f1b-e89bc36b6198.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/37/e0ea21a1-2bcd-421a-be56-fbfc6e3d1eb1.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/64/efe6289b-3b98-48bd-92be-37c6569c651e.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/171/829e7339-723d-4b48-b1fd-a6da3ad8b144.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/13/09146b0c-c77f-4f57-9e6a-2d703f66c71e.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/107/f624b756-3cbe-4337-920e-c314ada46f38.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/59/909fd691-33d4-4725-bc54-8c8080b41faf.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/85/00fb0018-89bc-418d-a78c-a7073f034a8e.jpg&quot;/&gt;&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/30/181/602a747c-4077-4544-b5cd-6c3169577337.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/c5e82a201070b8148d6812fdeac556e2.png',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,0,0,0,0,0,1,38,0.00,'','',3,''),(140,195,0,'XB037','歆觅带胸垫吊带背心女修身瑜伽运动无钢圈吊带内衣打底女装',0,0,300,0,200,0.0000,89.00,59.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t13324/230/1861669974/243853/6cb0fd0d/5aab8874N7b7fbcd2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5821/114/888335899/203467/8de38bd3/59223ea9Nd00ddb5a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5833/102/853464111/244619/47a43e4e/59223eaaN1875fbad.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5737/115/857149292/200416/668e515a/59223eaaN6ee3b30b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5599/202/840129053/256346/3f764544/59223ea8N8c760b44.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5596/15/883510403/240287/d155aa66/59223eaaN2aac6dab.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t4696/342/3340057243/203180/a82b79f5/59223eabN42623fc5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5674/320/839448274/124346/ddf8f33a/59223ea6N522ec94c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5797/118/842619782/238733/36be9399/59223eabNa06dfc95.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5752/131/836591753/191117/33b2f8e8/59223eabN45a0cc47.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5884/351/862414282/289822/5ba351b0/59223ea4N9965373b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5725/283/856247595/210538/c7864717/59223eacN1ae289c6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t4645/252/3298863072/144033/e9940860/59223eacN7fadf4bd.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5602/126/835494402/159141/1c891df1/59223eabN8e8674a7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5896/361/852075474/123353/192afe4e/59223eacNd56a3765.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5740/354/867819738/218196/4892a004/59223eadNe1410e60.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5791/153/841020544/467712/3b90595/59223ea5N888680d3.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5779/229/861122327/382034/4cdbf5fa/59223eadN8735c67c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5881/110/855760082/397445/a185e6f2/59223eadN71374191.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5779/234/850695051/256793/64cf7701/59223ea5Nef29bf8b.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/52bd95ac311ffe084759808a7b890105.png',0,-28800,0,1,0,0,0,1,1,50,0,0,1,0,0,0,0,0,0,0,0,0.00,'','',0,'/public/upload/goods/2018/04-13/28103ceedf7863e5a256099a30cee617.mp4'),(138,194,0,'1874','模丽秀婚纱2017新款韩版一字肩公主裙撑梦幻宫廷奢华齐地大码拖尾婚纱礼服2018冬季简约 白色一字肩齐地婚纱',0,0,100,0,2000,0.0000,588.00,368.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7006/333/1504357586/99221/b03371a3/598286b5N9646a316.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5572/308/4373171335/506294/193115be/594cc482Nc543dbcb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6241/118/1242377078/115418/8d2384a9/594cc483N31df858f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5590/60/4432510114/279768/9400b44f/594cc483N96a1ab66.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6667/98/1185902650/254087/77440984/594cc484N4429b3e3.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6427/1/1195681999/143929/fd2f3d27/594cc484N7632f9a8.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6118/360/6273377468/217626/72181670/597167b8N015e07cb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5599/359/7504655243/293418/64b9722e/597167bdNa4276f14.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5869/67/7579088845/258321/8d5b5e2e/597167c1Nb3e04495.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6103/359/6257758533/191549/be4d852e/597167c2N8de19423.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6256/183/1194177485/196076/a1e52990/594cc485N8aaa383c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9475/138/970962412/154422/20a7760d/59b26373N5892cbd9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7816/98/2592703279/131467/18ce962c/59b26373N0e119314.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6487/102/1193367672/557997/5577724a/594cc485Nde009184.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5983/163/3221652656/480993/3d3d87ff/594cc486N4ccf6093.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6406/320/1225780337/511656/c0919681/594cc487Nce64557d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5689/105/4336878224/589706/68a75af1/594cc488Nd4cf5f55.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6559/171/1194349310/436318/944cab09/594cc489N8f53349a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5719/118/4380929434/417216/41168745/594cc48aNe70499ab.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5722/284/4374751179/320294/bcde6f9f/594cc48bN28aa2647.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6250/140/1221787407/300685/93183f7b/594cc48bN69fe24ca.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5698/352/4354738267/288360/acd0838a/594cc48cNb8e915ef.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/0202a9cfdf1a1cae03fdf4d28025d2d3.png',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,0,0,0,0,0,0,0.00,'','',0,''),(139,477,0,'TP0000139','Rimowa/日默瓦DELUXE电子标签30寸ELECTRONIC TAG智能拉杆箱 开启智能旅行时代',3,0,100,0,1,5.0000,7790.00,7780.00,1000.00,'','','Rimowa/日默瓦DELUXE电子标签30寸ELECTRONIC TAG智能拉杆箱\r\n开启智能旅行时代','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2120839436/TB2VQUdevjM8KJjSZFsXXXdZpXa-2120839436.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2120839436/TB2CxInmDvI8KJjSspjXXcgjXXa-2120839436.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2120839436/TB2CxInmDvI8KJjSspjXXcgjXXa-2120839436.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2120839436/TB2Q81VdQfb_uJkSmRyXXbWxVXa-2120839436.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2120839436/TB2Fb1.mDTI8KJjSsphXXcFppXa-2120839436.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2120839436/TB2Fb1.mDTI8KJjSsphXXcFppXa-2120839436.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2120839436/TB2OKHZeazB9uJjSZFMXXXq4XXa-2120839436.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2120839436/TB2.nT7eBLN8KJjSZFPXXXoLXXa-2120839436.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2120839436/TB2cga0eBfM8KJjSZPiXXXdspXa-2120839436.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2120839436/TB2gyW.mx6I8KJjSszfXXaZVXXa-2120839436.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2120839436/TB2kVfPmxrI8KJjy0FpXXb5hVXa-2120839436.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2120839436/TB2KfjtmsrI8KJjy0FhXXbfnpXa-2120839436.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2120839436/TB2uwa0eBfM8KJjSZPiXXXdspXa-2120839436.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2120839436/TB2jzMQmsLJ8KJjy0FnXXcFDpXa-2120839436.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2120839436/TB2hMv2eqLN8KJjSZFvXXXW8VXa-2120839436.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2120839436/TB2NOK.dQfb_uJkHFJHXXb4vFXa-2120839436.jpg&quot;/&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i1/2120839436/TB2X_VhfN6I8KJjSszfXXaZVXXa-2120839436.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/f456da4b9d104e264661a59350dbc838.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,1,0,0,0,0,0,0,1000.00,'','',0,''),(141,72,0,'TP0000141','广西移动官方 话费充值 30元 快充 直充 24小时自动充值 即时到帐',7,0,100,0,0,0.0000,30.90,29.90,12.00,'','','广西移动官方 话费充值 30元 快充 直充 24小时自动充值 即时到帐','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1665542541/TB29sAqlgnH8KJjSspcXXb3QFXa_!!1665542541.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1665542541/TB2j2CjcpYM8KJjSZFuXXcf7FXa_!!1665542541.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/5153d87f7d37ab95c32af3d988a05bbc.jpg',1,1577808000,10,1,0,0,0,1,1,50,1,0,1,0,0,10,0,0,0,0,0,0.00,'','',0,''),(142,72,0,'TP0000142','广东联通官方充值全国手机话费100元快速到账自动充值',22,0,98,1,0,0.0000,100.00,99.90,90.00,'','','广东联通官方充值全国手机话费100元快速到账自动充值','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/747143122/TB2UFhVXrZnBKNjSZFrXXaRLFXa_!!747143122.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/747143122/TB2CJ__X25TBuNjSspmXXaDRVXa_!!747143122.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/1d6c3741a3827d27c4e3a6aa4226d234.jpg',1,1577808000,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,2,0,0,0.00,'','',0,''),(143,196,0,'18643VP21274','茵曼毛呢大衣女简约贴布绣花中长款毛呢外套大衣【18643VP21274】',12,0,149,0,1000,0.0000,998.00,609.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t3631/53/747473818/256556/5c194861/58132de7N1b9eaa67.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3433/40/751729991/190914/426a792/58132defNa9322770.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/imgzone/jfs/t3721/65/681426555/392024/2b5b0ada/58132df7Nefb796f4.png&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t3580/12/729992709/239407/8c247845/58132e0aN7a4cde9c.jpg&quot;/&gt;&lt;img src=&quot;https://img13.360buyimg.com/imgzone/jfs/t3343/318/785874952/191952/9483024c/58132e0fN816bb786.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/imgzone/jfs/t3319/315/742865455/163535/d44b4e03/58132e12N8468b8f4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/imgzone/jfs/t3613/36/729229928/186706/c7f411f5/58132e15N432f3e5c.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3547/83/727352815/178147/faddd4be/58132e19N69145613.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/imgzone/jfs/t3325/109/687076022/206709/150c8db9/58132e1bNc501cd23.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3760/274/767570453/176735/13a4f069/58132e1eN6d0c7d83.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/imgzone/jfs/t3316/61/741196018/162906/91b614b6/58132e22N282bbce2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/imgzone/jfs/t3835/85/522280291/207209/59f0365c/58132e2aN7225d0dd.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t3388/209/785592330/143577/1610ce25/58132e2cNcbc85737.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t3466/140/769967152/140774/6bd519ec/58132e2fN857125b7.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/imgzone/jfs/t3460/30/765582184/149937/1801a3e7/58132e3dN9bee029a.jpg&quot;/&gt;&lt;img src=&quot;https://img13.360buyimg.com/imgzone/jfs/t3661/295/747915717/161031/f0f53754/58132e40Ndfd80a71.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/imgzone/jfs/t3502/110/770776790/167040/e27b4e44/58132e43N00a442d9.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3424/152/637365796/142747/73ac941/58132e43N38d9ae06.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3544/231/739294161/122310/4ed2fe70/58132e46Nd6f5e45c.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3637/33/768347243/123759/4941f408/58132e48N90b7eb86.jpg&quot;/&gt;&lt;img src=&quot;https://img13.360buyimg.com/imgzone/jfs/t3799/115/763974714/307283/8a0db8b6/58132e4eN03218f94.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/599bdaa1a930b4668fd7e492e392f8d5.png',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,0,0,0,0,1,0,0,0.00,'','',0,''),(144,197,0,'G1160149','高梵羽绒服女中长款2017冬季韩版修身女士加厚学生大码轻薄外套',0,0,200,0,800,0.0000,579.00,459.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6046/28/4015836445/298821/36a8898/595d0a45Ncf8d9fd3.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7330/229/369920150/171979/e60c9622/5992748dNec56c5a1.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7498/270/370104613/136487/5429aa16/5992749cN9b37e1cc.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7879/254/387640389/161187/7c00217/599274a7N7e9d8a1b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6430/243/2082568208/197519/aced16dc/595d0a48N03eff180.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11350/359/37163516/39030/f9422b3b/59e62767N5f1d9d24.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t7438/201/3178411400/31049/94e9e28d/59e625b4Nc731fa10.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t11677/104/33716526/51337/6249634b/59e625b5Ne8a8e1b5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t10147/199/1814180898/80622/e047f0f/59e625b5Nbe2252b5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t10033/115/1732921136/30543/ba612ad8/59e6251cNca0c1fd3.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9520/129/1781369572/116385/ecf2738f/59e627b0N35083bcf.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6751/164/2111170229/292059/ebc28b93/595d0a4bN751a483e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6511/243/2084943569/199511/2a3c2f16/595d0a4bN3a8c3b10.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6505/320/2167842923/256961/3e52971e/595d0a4dNa99c9a0e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5707/101/5291388089/225049/160e2790/595d0a4aN0c6f3696.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6370/292/2068929902/202622/1dcd38ca/595d0a4eNf9dd29da.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6256/282/2118702919/248838/e748321e/595d0a4fNf727fba2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5749/174/5335734912/181807/b69f375c/595d0a50N5c304502.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6073/38/4067327083/309693/26d89524/595d0a50N66bcba98.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7993/351/381841962/254151/877713e0/59927328N82286613.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7237/115/378149910/81279/8eb9638/5992734cN73fca315.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7837/60/402816358/127148/6a9f4c3c/5992734aN725b6fce.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7690/113/375816045/166060/9ef51f4d/5992734cNad01b3ed.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7309/120/364302045/133930/629b5f5/5992734dNd18fc4fe.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7309/117/398461285/129480/eea2236e/5992734dNbef1ed24.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7267/122/378721298/145671/f201ddd8/5992734dN643dc07c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7252/68/388217513/113237/ff0f75af/5992734eN61346c6a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7660/144/381642030/149125/3848684c/5992734eN7b93a207.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7102/188/2135950693/128452/beba36f6/5992734fN8291aad3.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6073/279/9371544851/60602/f2a21cfc/5992734fN88527646.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t3301/126/5352296670/245574/b1a099ad/586c7030N8cbd6aa9.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/fa031ca0a1d1761166c53ad7af761eb3.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,0,0,0,0.00,'','',0,'/public/upload/goods/2018/04-13/3d597c2004850dface054ac511f650de.mp4'),(145,62,0,'TP0000145','Huawei/华为 nova 2s 4G全面屏官方正品手机 抢先加购 抢天猫券减120最高直降300',5,0,600,0,11,0.0000,2999.00,2599.00,0.00,'','','Huawei/华为 nova 2s 4G全面屏官方正品手机\r\n抢先加购 抢天猫券减120最高直降300\r\n','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2838892713/TB2Bz10gYYI8KJjy0FaXXbAiVXa_!!2838892713.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2838892713/TB2Bz10gYYI8KJjy0FaXXbAiVXa_!!2838892713.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2838892713/TB2_Cy1g_nI8KJjy0FfXXcdoVXa_!!2838892713.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2838892713/TB2Opalg_nI8KJjSszgXXc8ApXa_!!2838892713.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2838892713/TB2vXqHg8DH8KJjy1zeXXXjepXa_!!2838892713.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2838892713/TB2vXqHg8DH8KJjy1zeXXXjepXa_!!2838892713.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2838892713/TB2AaGLg26H8KJjy0FjXXaXepXa_!!2838892713.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2838892713/TB2TbqYg26H8KJjSspmXXb2WXXa_!!2838892713.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2838892713/TB2CQCBg8DH8KJjSspnXXbNAVXa_!!2838892713.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2838892713/TB2Rsyxg9_I8KJjy0FoXXaFnVXa_!!2838892713.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2838892713/TB220yLg26H8KJjy0FjXXaXepXa_!!2838892713.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2838892713/TB2er1Og3fH8KJjy1zcXXcTzpXa_!!2838892713.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/d42c733560a005139559a5479c11c324.png',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,2,0,0,0,0,0,0,0.00,'','',0,'/public/upload/goods/2018/04-13/6bba121c102b278c70c3b1173f07ba1f.mp4'),(146,22,0,'711085008','恒源祥女装风衣女长款2017秋季新款英伦风系带外套女春秋厚',1,0,159,0,990,0.0000,556.00,439.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10315/132/263347128/344270/ef436ce3/59c9d274Ne6ee474f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10450/156/239206004/315973/8171abd9/59c9d274Ne6c6986a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9634/188/237007274/322477/f8d900f5/59c9d275N8cd32937.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10774/110/251844239/306373/741575a2/59c9d275N63b987eb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9808/177/235800558/262876/cad2dbd2/59c9d276N81b6739b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8971/345/1767142630/315840/6acda12e/59c9d263N92f2bdf4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8971/345/1767142630/315840/6acda12e/59c9d263N92f2bdf4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9895/174/244844830/388420/41875efd/59c9d278N24eed2af.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9391/219/2313112585/369516/d3a42653/59c9d279N4db8ecaa.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9568/182/228212343/409483/521c6771/59c9d26dN292024a6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9565/173/255732025/341007/f69f55ab/59c9d264N9e6c5a78.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9667/200/231603569/257332/21d6311e/59c9d27aN76071075.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8851/97/2316053693/313474/317bca8/59c9d27bN564c5343.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9472/215/2279312743/391627/12826933/59c9d27cN5bf39ebc.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10828/100/256430799/301794/21b561d8/59c9d27cN265326b0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10276/139/236960983/356257/d616de32/59c9d27dNe801987f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10102/162/222517696/280652/9b27a7e5/59c9d27dNcfa958e2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8896/252/2294981408/217732/976cb8fb/59c9d27eNdb4afd1a.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/718f440199ac5ce966149ad41c66f4df.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,1,1,11,0.00,'','',0,''),(147,178,0,'TP0000147','掌阅iReader plus6.8英寸墨水屏电纸电子书阅读器 6期免息，赠运费险，8GB大内存',20,0,99,0,599,1.0000,1000.00,999.99,599.00,'','','掌阅iReader plus6.8英寸墨水屏电纸电子书阅读器\r\n6期免息，赠运费险，8GB大内存','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2732446196/TB2TFdyqORnpuFjSZFCXXX2DXXa_!!2732446196.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2732446196/TB2UsplqUlnpuFjSZFjXXXTaVXa_!!2732446196.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2732446196/TB2yIxlqUlnpuFjSZFjXXXTaVXa_!!2732446196.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2732446196/TB2J6XAqOlnpuFjSZFgXXbi7FXa_!!2732446196.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2732446196/TB2f0xKqS0mpuFjSZPiXXbssVXa_!!2732446196.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2732446196/TB2VCl4n80kpuFjy1zdXXXuUVXa_!!2732446196.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2732446196/TB2VCl4n80kpuFjy1zdXXXuUVXa_!!2732446196.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2732446196/TB2ipCInW8lpuFjy0FpXXaGrpXa_!!2732446196.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2732446196/TB2PSmcnYtlpuFjSspoXXbcDpXa_!!2732446196.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2732446196/TB2KLyenYJkpuFjy1zcXXa5FFXa_!!2732446196.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2732446196/TB2UIRkqUhnpuFjSZFpXXcpuXXa_!!2732446196.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2732446196/TB21xVfqSVmpuFjSZFFXXcZApXa_!!2732446196.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2732446196/TB2j7t0n9tkpuFjy0FhXXXQzFXa_!!2732446196.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2732446196/TB2oUqkkOqAXuNjy1XdXXaYcVXa_!!2732446196.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/37313c576ee86dd2b8d86956246c0c71.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,100,0,0,1,0,0,0.00,'','',0,'/public/upload/goods/2018/04-13/5b3cb307f830a62ab53833190dddb816.mp4'),(148,571,0,'TP0000148','乔比迈凯真皮休闲皮鞋系带运动男鞋子英伦风潮单鞋时尚板鞋鞋运动 新品上市 头层牛皮 猪皮内里 马上抢购~',0,0,500,0,1580,1.0000,498.00,398.00,0.00,'','','乔比迈凯真皮休闲皮鞋系带运动男鞋子英伦风潮单鞋时尚板鞋鞋运动\r\n新品上市 头层牛皮 猪皮内里 马上抢购~','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1059610760/TB22O1npFXXXXXqXXXXXXXXXXXX_!!1059610760.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1059610760/TB2O75wpFXXXXXnXXXXXXXXXXXX_!!1059610760.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1059610760/TB2uOp8pFXXXXcUXXXXXXXXXXXX_!!1059610760.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1059610760/TB23YucpFXXXXcqXXXXXXXXXXXX_!!1059610760.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1059610760/TB2NNx3pFXXXXXJXpXXXXXXXXXX_!!1059610760.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1059610760/TB2vsGmpFXXXXa4XXXXXXXXXXXX_!!1059610760.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1059610760/TB21UF2pFXXXXXuXpXXXXXXXXXX_!!1059610760.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1059610760/TB2m_l5pFXXXXXAXpXXXXXXXXXX_!!1059610760.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1059610760/TB2MJ1gpFXXXXbZXXXXXXXXXXXX_!!1059610760.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1059610760/TB2t388pFXXXXXaXpXXXXXXXXXX_!!1059610760.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1059610760/TB2Gz8EpFXXXXajXFXXXXXXXXXX_!!1059610760.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1059610760/TB2mUx2pFXXXXXJXpXXXXXXXXXX_!!1059610760.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1059610760/TB2xTKppFXXXXaqXXXXXXXXXXXX_!!1059610760.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1059610760/TB2fIX6pFXXXXXdXpXXXXXXXXXX_!!1059610760.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1059610760/TB2SOdSpFXXXXbVXpXXXXXXXXXX_!!1059610760.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1059610760/TB2fVGxpFXXXXXkXXXXXXXXXXXX_!!1059610760.jpg&quot;/&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i4/1059610760/TB2nLHSdPgy_uJjSZSyXXbqvVXa_!!1059610760.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/3f3acf80253941c5d4e7a258da474c57.jpg',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,7,0,0,0,0,0,0,0.00,'','',0,''),(149,221,0,'T8561','依曼柔文胸套装 无钢圈无痕女士内衣性感蕾丝聚拢 舒适调整型胸罩',2,0,200,0,120,0.0000,239.00,139.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2065/192/2909984224/104729/25ba9855/56f67233N2f246034.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2407/297/2945825678/188287/890298bf/56f67233N17c10928.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2197/140/2253982705/158255/3540df94/56f67234Nb7080a83.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t1969/159/2965079199/186998/2303e44f/56f67234N6a1e62b7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t1891/274/2791860913/111788/217c87ef/56f67234N6bdcc97c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t1954/237/2151451357/166258/bcea96c/56f67235N8a3e18c6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t1966/239/2198108823/320352/d6884eff/56f67235Nf08eb649.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t1948/241/2930104623/209706/ced461d2/56f67235Nac5f87f0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2383/164/2240126166/334578/e1fa6880/56f67235Nd25eba25.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2371/227/2818998952/81754/45b5954f/56f67236N9f741464.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2011/265/2206345151/85095/f079b7e/56f67236N8a4eef04.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2506/215/2939915505/184421/4b473ddf/56f6745fNf90e98fb.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/ad88d59e0aed06d8638c30dfdb7d9379.png',0,-28800,0,1,0,0,0,1,1,50,1,0,0,0,0,0,0,0,0,0,0,0.00,'','',0,''),(150,222,0,'644052','维慕诗情侣纯棉 睡衣女秋 长袖套装春季小清新男士休闲家居服644052',0,0,300,0,450,0.0000,198.00,108.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3094/20/207010638/281291/6ef54294/57aafbb2Nce4bd24b.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2992/173/2336900623/97412/9551fbb/57aafbb3N0e258e59.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2707/188/4150036905/104786/7e96cacc/57aafbb3Ndde7fd37.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2944/18/2412976173/114817/8d47cfdc/57aafbb4N45600b86.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2632/189/4174306962/115333/be0ce34b/57aafbb4N4e64fe29.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3046/32/203375278/147474/3e62dd8a/57aafbb5N99b522f9.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2611/206/4122012312/122839/6633bacf/57aafbb7N645607d5.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2857/356/4091249186/101910/b7199eab/57aafbb7N01422354.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3286/325/201052111/101426/faa3de29/57aafbb8Nb657edfb.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3175/16/203475409/98071/f04f7625/57aafbb9N80fd4ea1.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2698/232/4177177112/109667/6337c1aa/57aafbbaN183bc4be.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2734/331/4015542048/99463/ce28aea1/57aafbbaN8a508ffb.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3244/323/207951036/116749/62a10f99/57aafbbbNf46d31e7.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3205/26/221059244/92560/f9fc462/57aafbbcNf7f73a27.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3082/28/203618558/265251/97f4bbeb/57aafbbeN8afcc130.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2749/111/4151211228/205886/6a34eea9/57aafbc0N29178bf4.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2668/168/4097081938/195585/7d59bc01/57aafbc2N00666e35.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3124/41/209320810/224459/1e27b620/57aafbc5N2eb183e4.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2788/307/4158588589/240845/4f1c9206/57aafbc6N5409c4d0.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2605/227/4110436092/191396/ef5eba32/57aafbc8N21314aec.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/aae6db969782d46768a610f7058ccc1c.png',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,0,0,0,0,0,0,0.00,'','',0,''),(151,231,0,'TP0000151','私柜 情趣内衣女骚性感睡衣制服诱惑套装蕾丝透明吊带睡裙 莹伶恋曲4件套',1,0,300,0,50,0.0000,169.00,89.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3820/75/3562824427/531784/c3238930/589ac31dN248a85cc.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3820/75/3562824427/531784/c3238930/589ac31dN248a85cc.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3202/354/6073528988/399626/936f79d5/589ac31eNf09b2391.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3202/354/6073528988/399626/936f79d5/589ac31eNf09b2391.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3820/76/3546334081/245192/dcc19a56/589ac31dN606fee7d.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3820/76/3546334081/245192/dcc19a56/589ac31dN606fee7d.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4105/354/1873244408/162499/2d0ab0b1/589ac31dN1cda5d36.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t4105/354/1873244408/162499/2d0ab0b1/589ac31dN1cda5d36.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4021/12/1858847448/537681/5ee959c4/589ac31fNa7ee7ce0.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t4021/12/1858847448/537681/5ee959c4/589ac31fNa7ee7ce0.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3304/51/5835220121/250208/84a5e2ae/589ac31fNd135ce13.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3304/51/5835220121/250208/84a5e2ae/589ac31fNd135ce13.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4054/33/1797467558/435923/1ab168a7/589ac321N9e47fa50.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t4054/33/1797467558/435923/1ab168a7/589ac321N9e47fa50.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4045/23/1807901530/223093/894b0d84/589ac320Nfd0ba5e1.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t4045/23/1807901530/223093/894b0d84/589ac320Nfd0ba5e1.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3091/55/5848901656/391714/eeee9d2c/589ac323Nc4a0d282.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3091/55/5848901656/391714/eeee9d2c/589ac323Nc4a0d282.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3202/23/5964271322/234130/336e94f9/589ac323N527b7120.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3202/23/5964271322/234130/336e94f9/589ac323N527b7120.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3250/249/6013616528/333581/5b615f4b/589ac326Na3efcc5b.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3250/249/6013616528/333581/5b615f4b/589ac326Na3efcc5b.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4015/28/1897390695/297526/fafd3c86/589ac325N69f41358.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t4015/28/1897390695/297526/fafd3c86/589ac325N69f41358.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3238/28/6099214283/398768/c11eb4d/589ac325Nfb345cf0.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3238/28/6099214283/398768/c11eb4d/589ac325Nfb345cf0.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3208/33/6114496351/401070/7d119d7a/589ac327N16d8bbec.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3208/33/6114496351/401070/7d119d7a/589ac327N16d8bbec.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4093/30/1856762606/241697/d2d51a54/589ac329Ne645381b.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t4093/30/1856762606/241697/d2d51a54/589ac329Ne645381b.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3139/78/6059014396/424624/c37746cf/589ac328Nc9ea0b76.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3139/78/6059014396/424624/c37746cf/589ac328Nc9ea0b76.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3973/51/1920729703/268720/2157a7fe/589ac328Nc89e2240.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3973/51/1920729703/268720/2157a7fe/589ac328Nc89e2240.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4021/69/1861359815/503191/bc8abba4/589ac33bN155e6190.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t4021/69/1861359815/503191/bc8abba4/589ac33bN155e6190.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4060/52/1856840880/321945/d251a1d7/589ac33bNdaec890d.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t4060/52/1856840880/321945/d251a1d7/589ac33bNdaec890d.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3193/350/6054513605/294724/e5f64f94/589ac33dN3250f11a.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3193/350/6054513605/294724/e5f64f94/589ac33dN3250f11a.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3823/41/3540202816/389789/eb9ef091/589ac33cN50ede19f.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3823/41/3540202816/389789/eb9ef091/589ac33cN50ede19f.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3817/98/3600048851/384671/120e8315/589ac33dN1c2faf17.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3817/98/3600048851/384671/120e8315/589ac33dN1c2faf17.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3151/66/6025189109/242752/f2471942/589ac33eN92e4786b.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3151/66/6025189109/242752/f2471942/589ac33eN92e4786b.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3142/229/6065302952/331147/7f5d594/589ac33eN75e0143b.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3142/229/6065302952/331147/7f5d594/589ac33eN75e0143b.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3205/72/5980037017/292978/c181625f/589ac340N80f793f4.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3205/72/5980037017/292978/c181625f/589ac340N80f793f4.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3862/85/1856209875/390621/aec74138/589ac33fNb303de93.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3862/85/1856209875/390621/aec74138/589ac33fNb303de93.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3868/248/1863884778/439182/93a67822/589ac343Nbdb06a49.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3868/248/1863884778/439182/93a67822/589ac343Nbdb06a49.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3898/103/1871183587/307842/a5b4a2c9/589ac343N2dc463e9.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3898/103/1871183587/307842/a5b4a2c9/589ac343N2dc463e9.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3187/71/6025278271/269056/bd6c1bd8/589ac342N2263b385.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3187/71/6025278271/269056/bd6c1bd8/589ac342N2263b385.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4078/58/1912252715/526921/c2fcf516/589ac344N31d24ed4.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t4078/58/1912252715/526921/c2fcf516/589ac344N31d24ed4.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3997/90/1946774710/265224/58f9d7ef/589ac343Nee8b43a0.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3997/90/1946774710/265224/58f9d7ef/589ac343Nee8b43a0.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3892/66/1891892116/229412/d540ae32/589ac344N0d51b230.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3892/66/1891892116/229412/d540ae32/589ac344N0d51b230.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3127/344/6058017908/426404/67cbd351/589ac344Nd50a0935.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3127/344/6058017908/426404/67cbd351/589ac344Nd50a0935.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3244/294/5963921707/232413/f7707bc7/589ac347N69fd9110.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3244/294/5963921707/232413/f7707bc7/589ac347N69fd9110.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3106/41/6125347967/565264/9770c0b4/589ac346N2c24be72.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3106/41/6125347967/565264/9770c0b4/589ac346N2c24be72.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3070/335/6082982859/361533/63182aa7/589ac351N14a76eb5.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3070/335/6082982859/361533/63182aa7/589ac351N14a76eb5.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3970/95/1910705124/370230/b4fdbeeb/589ac352Nce82dfd3.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3970/95/1910705124/370230/b4fdbeeb/589ac352Nce82dfd3.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4039/104/1855642937/517290/b42df2a2/589ac351N0cada6c4.jpg?t=1486537808954&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t4039/104/1855642937/517290/b42df2a2/589ac351N0cada6c4.jpg?t=1486537808954&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4096/82/1862463198/292538/365608e8/589ac352N9e0f4846.jpg?t=1486537808953&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t4096/82/1862463198/292538/365608e8/589ac352N9e0f4846.jpg?t=1486537808953&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3235/87/6102525395/396070/5f14ba37/589ac353N6eb05783.jpg?t=1486537808953&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3235/87/6102525395/396070/5f14ba37/589ac353N6eb05783.jpg?t=1486537808953&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3979/108/1821048575/344299/8a7f4f32/589ac353Na313f883.jpg?t=1486537808953&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3979/108/1821048575/344299/8a7f4f32/589ac353Na313f883.jpg?t=1486537808953&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3046/355/6032893989/220930/5242d6c8/589ac353N0949d372.jpg?t=1486537808953&quot; alt=&quot;https://img10.360buyimg.com/imgzone/jfs/t3046/355/6032893989/220930/5242d6c8/589ac353N0949d372.jpg?t=1486537808953&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2887/227/496555598/82722/eae69fc4/571727f6N32338530.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9004/297/1361091370/512979/6c12466/59b89412N34fdc2c6.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9319/176/923254917/529383/7405761f/59b89412Nf459bf03.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8959/164/1342257761/293464/7710dbb7/59b89412N2317ac36.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8536/230/1391955067/292469/59013d05/59b89414Nc342d988.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8368/229/1365367674/403196/6dd4a6ac/59b89417Nced5f852.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9412/239/1341503596/442302/a9fe0447/59b8941aNb75c1059.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8416/247/1377477364/520445/3b319e3d/59b8941cNfb9b718c.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8473/289/1346634110/619934/c4d1e154/59b8940bN883d2970.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8452/302/1337943962/415693/e6836f9a/59b8941cN63753e02.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8680/293/1351804262/162746/385cdff7/59b8941eN6bd73e40.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8980/231/1396790968/34747/41499212/59b8941eN743c9e5c.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8098/30/1374367740/571161/d257a83e/59b893b9N32987f8d.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8698/90/1387343376/473328/169550b7/59b893bcNdfdd7221.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9154/128/1338421203/308893/3fc9422a/59b893b6N2cfa140d.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7570/67/3057134990/319772/37aa6251/59b893bcN20dda5ca.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8140/361/1381805734/376024/53009b3c/59b893baN077b3a34.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8263/34/1367907997/529818/2e49c5ca/59b893bcN1cf94150.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9364/69/1365057652/526899/6cc31f58/59b893bfNbd89a469.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7684/70/3021133798/679229/39ceead8/59b893c1Nd0f27117.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8905/363/1352646083/490230/6417a424/59b893c5N2cfc60d4.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8506/94/1355942622/162717/cafbc597/59b893c4Nf7231c90.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8089/49/1378220396/34746/69716786/59b893c4N101d4b73.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8407/150/1374807564/456609/86ca88ee/59b893e3N1c7b585b.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9322/143/1370670299/451300/572456a4/59b893e7N0f75c9b9.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9250/63/905386640/261792/c9f9def7/59b893e5Nf937cb84.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8218/132/1374413623/284481/9b34886f/59b893e9Nc04d289c.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7594/229/3005324407/463937/54da1368/59b893ebNeea5e8c8.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8293/119/1397854871/390472/5d133c5e/59b893eeN01e44f22.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8527/157/1373891786/467485/c2fd9bd7/59b893ecN4431c52d.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9154/226/1357330011/345626/24461f12/59b893dfN82e84096.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8272/130/1339691911/349439/9635ade0/59b893f0N9324d1ba.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8095/171/1371135163/162746/2cc561da/59b893f0N6dcbb0c9.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8929/263/1348916568/34953/79f98a18/59b893ecNf318eaa1.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8674/278/1362474682/458668/a6e33194/59b894caNc9d71202.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8497/277/1364610620/473484/99586973/59b894caN3672ce96.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8272/191/1350854466/273569/327c1708/59b894c9N15be381a.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9229/364/1353768489/323785/58417a7d/59b894ccNa438eac2.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9019/204/1350086221/353637/33fcbc1d/59b894caN43594c03.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8677/246/1392879145/376520/b025129/59b894cbN549c3e1c.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8725/213/1348545010/453556/1edf8dd1/59b894d3N1fd0b275.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8410/248/1352392943/400787/e80f1b51/59b894d1N77bcd37f.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8569/286/1409781543/407922/784b9fd4/59b894d1N43b06bbb.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9460/261/1363754719/162746/962b5e12/59b894d3Ncd50ec6f.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9418/231/1362810600/34759/202bf369/59b894d2Nf0c2403b.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8107/363/1374599866/804427/91071e4c/59b89510N44f6146e.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8056/355/1405290738/597278/3bb8d13d/59b8950aNc4a2b537.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8350/350/1397514834/324239/d48eb2f3/59b89509N57f830fd.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7636/163/2997115191/380272/a7681f5a/59b8950cN48b98027.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9151/287/1366601727/377416/6106ae71/59b8950aNa889eba1.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9178/166/1359485451/430496/230fc55c/59b89512N37d14605.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8431/363/1361907138/529207/a0d3456e/59b89514Nb3c96343.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9460/38/1364007354/537688/b86728b0/59b89517Ne8a63d5c.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8176/314/1340176086/691231/f009c775/59b89514N2f792d51.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7507/102/3005929467/162746/c37d062f/59b89502N7a943f3a.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9235/333/1331256113/34681/ca4791b0/59b89514Nf2799042.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8455/160/1367620274/460292/dbc70982/59b8953bN2372f766.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8557/179/1369270203/532600/5594f825/59b8952cN7ebd28c5.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8203/103/1376926290/334262/74ecf798/59b8953fN2dec22d2.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9220/78/1371389332/379514/309040db/59b89534N115d7cf8.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9169/39/1350226814/384085/c9534429/59b89532N0e10531b.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9349/88/1383574056/457554/14821a1d/59b8953bN34400570.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7360/70/2986696593/647013/280165eb/59b8954bNbf645ef2.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8521/178/1324146859/549847/984811b5/59b8953fN8e1ef065.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7792/313/3016278373/607805/96353268/59b89538N8a72da43.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8419/113/1398907126/162859/8c37f869/59b8953bN5191b940.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7528/255/3059350399/34760/a27ef8cd/59b89539N2537b9ee.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8398/186/1359431778/462308/60be29e1/59b89571N79ed3244.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8869/111/910437807/479995/18471687/59b89571N1fe4acc6.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7606/183/3019509363/294232/56bc0bda/59b8956cN08c39ca2.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8836/162/1351675621/322628/9c13781d/59b89571Neef0186b.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8470/265/1375365262/295330/38bfe17a/59b89561Ne4f54868.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8497/264/1357047869/403644/253f21a2/59b89576N5a4fb2bd.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7375/274/3047060322/559938/b10337e8/59b89578N8dae07c7.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7573/218/3035939385/388329/ec4b7da3/59b89579N637d27d8.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9244/164/1372780907/517163/88215c65/59b89577Nf04e8230.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8989/185/1382735015/157252/4b6c1a99/59b8957aNab30e06c.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8986/111/1349807653/34721/7d14e750/59b89579Naf494740.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9118/282/1367927379/471530/f88803ce/59b895aaN91ab6fb2.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8890/286/1342959112/498185/7fed98e6/59b895a7N352f1255.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7534/285/3034927945/322859/60f68798/59b895aaNa531b4e8.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9391/362/1321573714/274093/15cfc0f/59b895acN79cd8dff.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8632/313/1377906916/307345/3c428fc9/59b895adN90ce55fe.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8983/3/1391099459/461514/916c82b0/59b895b2Ncf49c7c0.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9481/337/1371028001/373912/387b0509/59b895b2N32e1e9a9.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8701/18/1357785213/494238/2604a5d2/59b895b4N579b3efc.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9019/278/1345087700/289638/210542f8/59b895b3Nf5ce51de.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9205/257/1351450417/159125/2514142d/59b895b3Nc37672d9.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9457/129/1212528668/34711/5960331c/59b895b3N53de3ea9.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t1984/140/2918227192/102994/ce21a379/56fc7ef9N324db3ff.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t1336/3/345876337/215652/99e9c611/556c1dbeNc3e07f3f.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t1447/97/281763821/172880/53ca1144/556c1dc1N5af03ecd.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t655/263/1176365910/118753/de7169ad/54b77280N6784f27f.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-13/57bfbc4d273534de365983f28ec986e1.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,0,1,13,0.00,'','',0,''),(152,464,0,'TP0000152','实用公司广告展会商城开业促销赠品活动积分小礼品送客户定制LOGO',16,0,99,1,1,1.0000,14.00,13.00,9.00,'','','实用公司广告展会商城开业促销赠品活动积分小礼品送客户定制LOGO','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2947111497/TB2QYJgcHglyKJjSZFuXXaE6FXa_!!2947111497.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2947111497/TB2Sc4bbXIkyKJjy0FgXXX0mFXa_!!2947111497.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2947111497/TB2oFkhb77myKJjSZFgXXcT9XXa_!!2947111497.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2947111497/TB2vDQ_a3ojyKJjy0FaXXakspXa_!!2947111497.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2947111497/TB2mNN2bbAPyuJjy0FjXXXhfFXa_!!2947111497.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2947111497/TB2.4VUbaZPyuJjy1zcXXXp1FXa_!!2947111497.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2947111497/TB2lp..a3ojyKJjy0FaXXakspXa_!!2947111497.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2947111497/TB2N9khb63nyKJjSZFHXXaTCpXa_!!2947111497.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2947111497/TB2aeo2a3AjyKJjSsziXXbyxXXa_!!2947111497.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/bdc6a4086d20a2d7dcc30ae4a7f0e729.jpg',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,10,10,0,1,0,0,0.00,'','',0,''),(155,215,0,'004','保安服衬衣衬衫长袖 夏装上衣警服 警卫酒店门卫物业保安制服套装执勤服定制 蓝色长袖套装',1,0,200,0,500,0.0000,156.00,99.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6787/358/1000033061/302394/de38ec1f/597bfaaaN7962fda3.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t6766/318/869936019/241159/a1f2cb45/597ab01aN9c1910e0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5965/133/7237163536/569916/4a755253/597ab01aNb78b5072.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t7042/254/1170341155/382556/df79824f/597d7c6aN6e4c5a58.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7060/44/1192845829/321626/29a72620/597e7be9N221aeceb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t6076/298/7153655040/169330/1ffd09ea/597ab01aN0cef2b81.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5845/310/8442474044/130291/ce7e30fc/597ab01aN5c38f570.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7123/182/1255537053/283329/91d8ac59/59898023N00cd7938.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t6952/313/880663808/399170/954df17e/597ab012N20ff3cfb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5635/104/8359003748/204294/7b6b57ea/597ab00eN1eb35510.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t6097/232/7204893335/192651/d642bdbc/597ab01aNdbc952f0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5983/191/7154100907/153684/fcca83/597ab01bNc3323581.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4030/202/1270330944/218948/2928cb66/58be8a93N756dcb33.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/c354f66f7ea4af4c36d6482605a686fd.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(156,198,0,'12216001008','森马 Semir T恤 短袖T恤夏装男士纯棉个性印花',2,0,500,0,200,0.0000,126.00,79.90,0.00,'','','','',NULL,'/public/upload/goods/2018/04-16/8ba55e980d61df0415b167d25c6f5741.png',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,0,0,0,0,0,0,0.00,'','',0,''),(157,199,0,'A089 916','霁蓝 牛仔裤男2018春季新款长裤韩版猫须小脚裤潮流修身男裤',0,0,291,2,700,0.0000,159.00,136.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5014/290/771461759/167871/51be138b/58e87fb4N8f06b139.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t4705/189/1924032552/158395/735aa701/58e87fbbNdd827c69.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t4375/56/3819899562/79075/ad6f9d7e/58e87fbbN358de012.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t4267/100/3795374144/249998/bea88a9d/58e87fbdN8d83ec11.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t4126/253/3762692380/246471/67526ca3/58e87fbfN4ebec46a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t4423/249/1921970148/205395/cd624134/58e87fc0Nd5040e39.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t4156/312/3825363632/182904/c6bdb66b/58e87fbcN6a1da3f7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t4144/15/3857493007/224455/e0d330e5/58e87fc3N1e8ad6bb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t4495/209/1901515025/184284/7b047227/58e87fc3Ncf3d7ea9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t4798/151/808148824/163848/af5521bb/58e87fc4N2536f576.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t4711/246/1914457270/173752/c80b27ad/58e87fc5N03c7ac83.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t4291/26/3804924241/199214/4e46c683/58e87fc2Nbe81e22b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t4507/282/1917711463/165143/14b65b36/58e87fc8N89b45160.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t4603/212/1960608997/316662/e89254a/58e87fc9N50f0a4b4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t4765/167/799510055/372183/3ee7b25e/58e87fcdNad9e3641.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t4462/130/1964400826/324421/e8d70d8e/58e87fcbN0899458f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t4261/179/3827867967/314849/ad3206da/58e87fceN30ffa182.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t4399/269/1936790453/282598/f8bbe462/58e87fd0N4dccfba2.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/367bfeeb8c8fb8a177f3052d88602ae5.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,9,6,19,0.00,'','',0,''),(158,514,0,'TP0000158','恒美手绘油画定制欧式山水画风景画美式挂画鹿客厅壁画玄关装饰画 恒美原创 名师品质 宝盆聚财 福禄双全',0,0,100,0,1,12.0000,549.00,539.00,0.00,'','1111','恒美手绘油画定制欧式山水画风景画美式挂画鹿客厅壁画玄关装饰画\r\n恒美原创 名师品质 宝盆聚财 福禄双全','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2862177248/TB2FOUdXHuWBuNjSszgXXb8jVXa_!!2862177248.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2862177248/TB2B_l3X_JYBeNjy1zeXXahzVXa_!!2862177248.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2862177248/TB28B04X_tYBeNjy1XdXXXXyVXa_!!2862177248.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2862177248/TB2g_UdXFuWBuNjSszbXXcS7FXa_!!2862177248.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2862177248/TB2DModXNSYBuNjSsphXXbGvVXa_!!2862177248.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2862177248/TB2DModXNSYBuNjSsphXXbGvVXa_!!2862177248.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2862177248/TB2.9NYX_lYBeNjSszcXXbwhFXa_!!2862177248.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2862177248/TB2sRMbXFmWBuNjSspdXXbugXXa_!!2862177248.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2862177248/TB2qjEdXHuWBuNjSszgXXb8jVXa_!!2862177248.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2862177248/TB2qjEdXHuWBuNjSszgXXb8jVXa_!!2862177248.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/0bfd4166d67884d597dba9f27035eed4.jpg',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,100,0,0,0,0,0,0.00,'','',5,'/public/upload/goods/2018/04-16/17e9a40e0cb735a9b48f141929a00cfd.mp4'),(159,514,0,'TP0000159','六派 中式山水风景油画欧式客厅装饰画沙发背景墙画挂画有框壁画 艺术微喷 手绘油画肌理工艺 手工装裱',2,0,100,0,1000,12.0000,549.00,539.00,0.00,'','','六派 中式山水风景油画欧式客厅装饰画沙发背景墙画挂画有框壁画\r\n艺术微喷 手绘油画肌理工艺 手工装裱','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2261857580/TB2QFWogTcCL1FjSZFPXXXZgpXa_!!2261857580.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2261857580/TB26dLzl5pnpuFjSZFIXXXh2VXa_!!2261857580.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2261857580/TB209fElYlmpuFjSZFlXXbdQXXa_!!2261857580.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2261857580/TB2xwrBl5RnpuFjSZFCXXX2DXXa_!!2261857580.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2261857580/TB2lgTnl.lnpuFjSZFjXXXTaVXa_!!2261857580.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2261857580/TB28mmccr_0UKFjy1XaXXbKfXXa_!!2261857580.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2261857580/TB2uAbql.hnpuFjSZFpXXcpuXXa_!!2261857580.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2261857580/TB2AszHl4BmpuFjSZFDXXXD8pXa_!!2261857580.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2261857580/TB24pIRj80kpuFjy1zdXXXuUVXa_!!2261857580.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2261857580/TB20sZFj9hlpuFjSspkXXa1ApXa_!!2261857580.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2261857580/TB2pE3Tj9xjpuFjSszeXXaeMVXa_!!2261857580.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2261857580/TB2zfsEjYBkpuFjy1zkXXbSpFXa_!!2261857580.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/dfc999a7668c044b8802e70a90dc7e79.jpg',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,0,0,0,0,0,0,0,0.00,'','',0,''),(160,200,0,'602024','美特斯邦威 Meters Bonwe 602024 男休闲字母印花针织裤',3,0,300,0,400,0.0000,179.00,119.90,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10021/269/1094696745/266063/f54d9ac1/59dcb735N19e16b13.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9301/160/2645293565/151032/2cf6806c/59dcb72cNafa8d41c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9535/163/1117644822/381151/8e7e1e02/59dcb738N035bae54.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10960/158/1141792371/211318/e291d233/59dcb71bNd9ce86ed.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10228/272/1132799953/130407/ddfdf903/59dcb73bNd8d6cb16.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10327/160/1109669632/90196/a2d8e7b9/59dcb73bN0271f1f3.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10309/138/1133768120/86645/5047f557/59dcb73aN3ddca2a2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10348/171/1086119802/142305/ff4d8585/59dcb73cN0e122ac0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10303/129/1128111929/148048/3244ad31/59dcb739N56af2860.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10330/135/1099926685/161104/3392145a/59dcb73dN926b5e6e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9793/281/1133190654/114674/5b3bdeb4/59dcb73dN20949557.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9367/358/2689485622/141385/cc305561/59dcb73eN9427e739.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10633/182/1103901546/138855/aad541f/59dcb73eN364b0092.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10975/175/1105228721/114434/16cecfe6/59dcb73fNdca11538.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10501/215/1080584092/159270/6bdce339/59dcb73fNf8fd0e3a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9676/240/1120936858/209195/2595a296/59dcb732N2219f37f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10633/176/1122306596/144311/f3c244e9/59dcb740N00d0d028.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10711/174/1101618973/110809/4ad12e9e/59dcb72aN93a2abe6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10195/277/1093745689/110146/b5fca304/59dcb741Nbf105dc2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10420/170/1133074397/315284/d3facbe/59dcb742N461bd2ac.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10171/273/1098443180/145723/3304e5bb/59dcb742Nd092d1b8.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10624/213/1109559894/88476/c324aaf0/59dcb743N995bb4e1.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10483/189/1122225730/127785/3b0c780/59dcb743N28745526.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10516/266/1114836207/280851/d7d8e13e/59dcb72cNdc6044fa.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10237/287/1112178400/180684/ce772f8a/59dcb73fNca898c10.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10144/262/1142202854/73526/1e5def7a/59dcb745Nbd87f72d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10276/160/1090296641/186517/7d7bd669/59dcb745N20990b39.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10156/257/1142074842/433257/12a690c8/59dcb746Nadc4f6d9.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/1d84bc5ca76b65eca1a921c7d90cc718.png',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,0,0,0,0,0,0,0.00,'','',0,''),(161,201,0,'HHCWQC011','花花公子短袖衬衫男2018夏季新款中青年商务休闲男士上班修身免烫男士衬衣 ',0,0,260,0,600,0.0000,198.00,139.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9808/54/1107354896/133942/a188f89/59dc5758Nb7d6b59b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7252/307/3007968426/135529/8c8d93f8/59b77cadN20e88b30.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16777/19/1470439671/262860/df1e7f01/5acc8627N1d612cd2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18694/59/1495264461/407899/bdbe2b18/5acc8629N7b890ec5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19564/287/1493650347/365893/43d04298/5acc8629Nd92fb319.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16801/41/1521062507/358562/e57275d7/5acc862aN4f9c9ad9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17020/90/1481511513/400948/7b44f235/5acc862eN03764931.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19180/102/1501469405/396092/208575c1/5acc862bN8188c222.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18307/159/1513268253/394175/434dd2/5acc862cN56ffb2f0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18091/187/1491250674/389091/b8225aa/5acc862dN30bd9b96.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19297/319/1485490925/181946/6540ba8e/5acc862eNc4218951.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19303/62/1443687554/361336/209f841a/5acc862dN65dab2b9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18064/355/1528845198/408893/77ffa5e5/5acc862fNd124f89e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19171/316/1442619630/393540/146f2320/5acc8630N12536f1e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17374/154/1498065451/469590/61f0cc15/5acc8632N2c7f316f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8446/318/1312464635/240320/ce415c4e/59b77caeNa7d9d3fb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8587/364/1303181851/577512/64ab379e/59b77cafNdcafdc5e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8665/180/1162323270/321446/eea0ad32/59b77cafN85caccdb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8299/302/1296714879/220883/dfce4c2d/59b77ca5Nc4588bcf.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7429/37/2955108849/136315/1e4b151f/59b77cacNee36d1e6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8065/251/1176484722/194000/eae9d9a0/59b77cb1N0cae16e1.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9049/277/1309985198/187660/f5e5e092/59b77cb1N13505831.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8269/286/1283547648/184956/ce14b5a4/59b77cb2Nc8ad2474.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8404/326/1295218589/176082/2c595df/59b77ca7N0980ff2c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8455/30/1269055618/182842/2d662f11/59b77ca8N5aaf17f5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8350/342/1297621632/186878/2c78d6ba/59b77ca8N9de0064a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8401/325/1326726621/203630/8c704dc3/59b77cb4N68fb178f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7393/359/2944623254/215885/ea0594a4/59b77cb4Na396b19e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8545/6/1272129234/217836/ede612bb/59b77caaN3d134953.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7573/2/2955990299/405261/4f06546b/59b77cabN72fe6806.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8158/285/1314536513/459624/c0bae391/59b77cb5N74738222.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8101/318/1275893477/282503/9b53de03/59b77cb8N618c027d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8590/35/1278354774/449305/93b7b4b6/59b77cb9N1d8edc3e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9391/27/1314774112/528799/299a7007/59b77cbaN73a44f28.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17068/76/863342064/403388/c6bcb490/5aaf2c46N8a0c8ac1.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16762/32/886557232/525164/37d042a0/5aaf2c48Ncdf6a909.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16840/46/853750770/528629/c5b11b7d/5aaf2c47Nc6f57ec7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15367/46/2586351588/204977/57b99004/5aaf2c45Ne4fdf550.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15781/82/2540185636/335357/6f63b4e7/5aaf2c47N7782b59a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19087/45/867881177/192146/10a5339a/5aaf2c45N7a5fd533.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16576/121/2451842926/126991/1c4d004b/5aaf2c46N6008872f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16885/175/915032890/248656/64fce724/5aaf2c48Nf4902e9c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18673/216/898938161/232086/72701310/5aaf2c49N6c386641.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14326/96/2719186619/230300/2179e328/5aaf2c4bNf426a7a8.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15952/109/2494721064/333476/ad91a20a/5aaf2c4bNef581e98.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14737/258/2676309987/328628/b7377232/5aaf2c4aN131801f0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19420/5/902243027/317860/1038fe32/5aaf2c4bNbea7b149.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14944/113/2650538915/318521/14d72859/5aaf2c4dNd49008d3.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15430/57/2581124177/335793/75315555/5aaf2c4dNf3f26347.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19762/5/914083169/142333/2dec2467/5aaf2c4dN4b5e97c7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18058/209/880483613/499139/39c34702/5aaf2c4fNedff1f24.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18796/51/863789456/412103/ffb8b431/5aaf2c4dNa43c00c3.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16696/58/858814874/433103/7a1703b0/5aaf2c4fNaf43fb78.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19246/41/1148183599/438056/30cd287a/5abf5327N15c05b02.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16222/364/2680975883/566971/65d55d19/5abf5329Na989424f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17167/302/1184315910/561705/623781c8/5abf532bN197815fe.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17446/2/1193972883/228010/8b87c286/5abf5326N2535bda4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19426/90/1219266067/440380/f2f6e686/5abf5328Na1efba3e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17326/306/1166018272/398739/35e2edc6/5abf5326N0a2ec0e6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18265/6/1197998810/387808/efe31713/5abf532cN699a114b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18376/74/1129079125/416813/ff6928b1/5abf532aN42870bbc.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19345/147/1206861917/447399/869df287/5abf5329Na54eef5d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17446/4/1218679697/472639/d2f15f1a/5abf5330N5850e94e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16507/77/2594100562/482129/109fb0be/5abf532dN766b1db1.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17371/213/1224925829/522185/581a91df/5abf532fN1f130974.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18217/177/1192398299/385075/2eb7d051/5abf532eN429daab5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18460/69/1217719599/487887/feb109ea/5abf532fN735d3c88.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19339/177/1181340070/483676/ff32065a/5abf5331N92104bcf.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18379/85/1237328331/470221/93c2d06c/5abf5331Nc4938009.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18739/243/1184749668/554248/f629147d/5abf5331N84c2c1bb.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/005f3f65d9050cce8d0101268de2e53c.png',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,0,0,0,0,0,0,0,0.00,'','',0,'/public/upload/goods/2018/04-16/b5545261a5524176cc7611ccee6317f0.mp4'),(162,202,0,'TP0000162','北极绒牛仔短裤男七分裤破洞韩版修身夏天直筒宽松乞丐夏日五分中裤男士夏季大码运动马裤',3,0,300,0,200,0.0000,99.00,89.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17419/140/1204145718/589106/48cf9319/5abf3d4eN11cad7b0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19471/39/1192106955/548208/dfeaf438/5abf3d4eNb024e749.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19741/263/1174609257/334695/dc5b56ca/5abf3d4dN6a0bc264.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18241/115/1167426942/140160/7c0db47/5abf3d4dN5f6426f6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18823/101/1211507381/391646/7f76e663/5abf3d4eNdce67673.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17482/107/1191037828/446826/78b8457e/5abf3d7aN081b6cde.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17815/201/1218080190/510874/3825f9fe/5abf3d7dN2e9f987d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19474/32/1221357395/252868/d547e79a/5abf3d4eNeda12b16.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19360/143/1169152114/236841/90833a14/5abf3d4eNcaa493f3.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17926/81/1209821139/267844/8fbfe52c/5abf3d4eN85a2bd1e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18484/35/1176052577/275738/80bfcc2/5abf3d4fN77a83876.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19420/217/1205167308/265183/b7f461cb/5abf3d50Nfcaf7d2b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19465/40/1185638067/282333/3ff78cca/5abf3d50Ne75f8502.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18994/65/1160931140/260073/453ad265/5abf3d50Nb96b908b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17218/205/1187130833/281988/81780c2f/5abf3d50Nbdc67237.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19741/268/1159383062/235957/3de0fc23/5abf3d50N046f8126.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17698/228/1193682174/224305/504e958d/5abf3d50Nf335b12a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19648/257/1163124401/363563/f67aa133/5abf3d50N0f9d86f8.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18862/154/1186098079/260613/d38f25da/5abf3d50N6b678e3e.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/048a0222109ee76110e23e71f79f0c75.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,0,1,48,0.00,'','',0,''),(163,203,0,'JM17002PL7598','花花公子羽绒服男2017秋冬新品男士加厚休闲修身青年轻薄短款连帽外套男装',1,0,200,0,1000,0.0000,466.00,329.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10618/31/1521995253/570178/2f0ad797/59e1e2a4N77400e41.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10720/12/1473122529/140097/13c6c27e/59e1e2a0Nabb93af5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18718/363/447477375/83581/371015ec/5a7ae343Na9681bad.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10198/42/1492478238/221797/98cc00b4/59e1e29dNf84a2705.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7315/212/4092362196/652819/d62e54c4/59e1e2a7N35cc8836.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7717/351/2870037461/235132/e9b49b19/59e1e30dN50d80211.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10552/254/1497030919/388437/555af687/59e1e30eNbb33c4c2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10081/313/1462497847/347762/6eb18755/59e1e30eNd00d1aed.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10318/316/1472030061/691761/319895f9/59e1e2a8N50b2dec4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9505/5/1497229503/1049704/8a6ca310/59e1e2aaN46197c6b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10069/27/1500451264/384958/ebbb8dd9/59e1e2aaN78492d7d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10426/46/1515986697/485266/a1fa6d15/59e1e360N35a0b82f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10567/67/1505058529/461536/3eba37/59e1e2afN418c899f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7219/120/4099838449/487104/2ec89ee8/59e1e298N61a6c921.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10708/49/1526092707/542025/eee57225/59e1e2b1N4751290c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10150/36/1509566397/308508/2c897e41/59e1e2b2N60128d78.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10489/18/1507780221/355508/64c7c692/59e1e37bN75f128a0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9706/79/1469087772/392881/8c8f8ca2/59e1e37cNb03bb770.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10522/127/1525569028/364055/727774da/59e1e37dN3ea8981d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8770/362/1802469091/556890/717ef0df/59bfd716N76ca189c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8083/331/1844829134/184252/d8827e7e/59bfd70bN00b7c0fa.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/687c22a1e4c465ac4730e11f732dfae7.png',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,0,0,0,0,0,0,0,0.00,'','',0,''),(164,204,0,'花花公子086','2017年新款花花公子时尚休闲旅行夹克男冲锋上衣男户外速干衣夹克外套多口袋冲锋衣男外套',0,0,150,0,1000,0.0000,316.00,188.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15916/352/2080952566/253435/e361a26b/5a770033N89b46453.png&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16444/239/2059963699/266000/c83abebf/5a770036N4233bd08.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16489/287/2052247113/284058/36b00fb/5a770031Nf362ff1a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19219/3/421668198/246625/6b4fe1d4/5a770031N929b25ce.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14317/223/2195520494/370515/52b4fe11/5a770033N5fd98aab.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19297/7/447439221/198266/1c9f3309/5a770032Naf0ad66c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14554/291/2198953152/286627/62488d8/5a770033N258246d6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13699/203/2353654965/275545/7d58f62f/5a770035Nd9cf2ec6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19303/8/417834423/479024/22941889/5a770038N24cbe769.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18487/336/433652015/386881/e4cfd103/5a770033Nfd7f4414.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14521/285/2188895088/323247/73ccf5ff/5a770034Nd2dabf94.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16849/16/415347870/401502/e430fe2e/5a770035N303e0f08.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17332/62/449470701/322113/60d348b0/5a770035Ne32a0272.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15265/92/2178667221/405218/c760a6c/5a770036Nff938722.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18895/361/424372837/446863/7923d281/5a770037N66df39b3.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14296/271/2233518360/389285/3831aa20/5a770036N7ef83ed1.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19582/50/442382951/354149/50db329b/5a770037N3221f51b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15175/267/2165041331/339590/5cf2d112/5a770038Nb50e46dc.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/1a3ded70ec73e4730a5b37b43194f58b.png',0,-28800,0,1,0,0,0,1,1,50,1,0,0,0,0,0,0,0,0,0,0,0.00,'','',0,''),(165,205,0,'DMFNJ017S','红豆（Hodo）夹克男外套男春款时尚休闲立领夹克 男士外套',1,0,200,0,400,0.0000,268.00,199.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3202/221/1573198836/264166/fc418209/57cfadc7Na5f7e8d4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3256/48/1582904843/257036/e75a66/57cfadc8N0188ca6d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3142/320/1570149774/292756/45f32079/57cfadc9Ncc74e2ef.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3289/233/1536125655/275781/feaeb0c6/57cfadc9N4bacc7bb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2998/311/1996946718/136363/21a8f0eb/57cfadcaNa7dbdf31.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3136/285/1533714894/64712/37620b88/57cfadcaN0b5e17ca.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3064/261/1556486543/210009/bdb9eb1c/57cfadcbN396600ac.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3235/151/1556413495/195320/c9b6a5bb/57cfadcbNf39ebc45.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3298/152/1563702581/303544/fa532f12/57cfadccN890756a2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3145/328/1575058741/133886/4b2a8f/57cfadcdN017ece67.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3181/42/1539644949/60715/ef0ada9b/57cfadcdN162e28b6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3157/34/1499502039/251852/db74d6b5/57cfadceNb97375e6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3199/347/1557076697/199857/9c562b1a/57cfadceNcba20e42.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3217/150/1573454792/279239/d6f36f0e/57cfadcfN61bae0c6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3187/66/1560605588/122509/91027150/57cfadd1N63ecc1cf.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3298/209/1526950311/60558/ad880fed/57cfadd1Nec6074cc.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3142/15/1542935517/213638/9017abeb/57cfadd2N9179493a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3241/56/1584315002/212803/df52eaf4/57cfadd2Nd19516f2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3175/364/1538905856/266883/f556c985/57cfadd4Nc8b1b7b7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3016/148/1933097216/270132/4b3d8c32/57cfadd4Nf1f8420e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3010/10/1959958544/280097/e3728c41/57cfadd5Ne123090d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3019/230/1970813833/282028/56cfba9b/57cfadd6N295418ea.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3121/156/1603684892/270859/a748acd6/57cfadd6Na3332dc5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3238/198/1553634302/251230/5f1d1410/57cfadd7Na9f1236b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3067/352/1527307390/270423/516c5c7d/57cfadd7N3b9cfdad.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3229/261/1554037671/260804/1d2b5626/57cfadd8N2a7651a8.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3178/34/1593541477/276244/eb0426d9/57cfadd9N533e98c0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3208/144/1522621145/256653/6a446f3b/57cfaddaN1aa96fe5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3172/177/1565733655/295696/2f57cb4/57cfaddbNd769830e.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/f117f668e25784478bb2ee65e56884b6.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(178,29,0,'7008','雅鹿中老年男士羽绒裤秋冬季保暖高腰轻薄修身加大码内穿加绒加厚',1,0,450,0,100,0.0000,350.00,298.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3712/46/5005190/195310/57b4457a/57fce8d8N82885b38.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3205/133/4052274286/231319/81b0b660/57fce8d9N6b52bc75.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3364/144/46641966/116520/2797a176/57fce8d9Ndf73d97c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3367/177/45742550/163634/b23df7f5/57fce8daN0c54af15.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3406/258/45094071/237239/1cf9ca3/57fce8daNf1b93533.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3190/11/3962207633/441559/ec4d9d21/57fce8dbNfc183269.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3451/262/47868880/117962/98851376/57fce8dcN927515f3.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3292/204/3913898513/171452/32479938/57fce8dcNf9008e5d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3070/102/4052127615/159857/dd154e6e/57fce8ddNdf1798c9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3643/51/3880090/96004/2f8111c6/57fce8ddNd4c4c560.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3106/8/4005590981/128247/36ee6326/57fce8deN04b6aace.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3484/212/50807270/120280/682d7dc3/57fce8deNec3032fb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3796/277/47256916/111710/b9d3e67a/57fce8deNa22d6519.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3121/215/4103464392/131456/8936789c/57fce8dfN56d74765.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3244/130/3902005235/131786/cd84130d/57fce8dfN3cb406b2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3532/265/45800110/175007/925648d8/57fce8e0N3493249c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3382/1/4631687/323985/bb11adb0/57fce8e1N76c7170a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3412/15/6128320/317304/b0261ccb/57fce8e1Ncc0abdba.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/fe759659a7546c976c7296c5501c1a2a.png',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,0,0,0,0,1,12,0.00,'','',0,''),(166,206,0,'661159','美特斯邦威Metersbonwe 2018春新款街头潮流个性连帽韩版多色时尚运动外套男士卫',0,0,300,0,10,0.0000,166.00,129.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19723/195/1273963223/76629/c517ebb3/5ac44de4Nf1e70f35.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/7c4e33440b5afd9843a1ad4292b73dd1.png',0,-28800,0,1,0,0,0,1,1,50,1,0,0,0,0,0,0,0,0,0,0,0.00,'','',0,''),(167,207,0,'DMGTD062S','红豆（Hodo）男装 针织大衣男 冬季绣贴装饰男士修身大衣外套',0,0,200,0,1200,0.0000,478.00,379.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18298/109/28881234/283685/21c1d27b/5a58646bN1aab90d7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16090/362/1656664477/230433/5c810980/5a58646bNc3041212.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18787/131/28262943/141979/6dee8ec6/5a58646bN009d0bfd.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16330/182/1537718959/282668/636688f5/5a58646bNbb15d383.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t12688/10/2572292022/296851/d87bf11a/5a58646bN7eeb1544.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16318/110/1582568225/285460/1a6c708e/5a58646bN87d7b039.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17749/156/24365672/293661/31f9314f/5a58646bN73972d28.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17599/153/26777468/177871/753a8c39/5a58646bN93a823d2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19720/238/26919247/149631/88d30881/5a58646bN0dfe5b99.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16255/134/1648814111/113167/8377f496/5a58646bNfbf8e0fc.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7456/351/4349920699/134081/5ce62504/5a586468N4585fab0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17485/158/28215209/135364/43d3aa52/5a58646bN866c406b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14929/228/1746462143/120561/9879a8be/5a58646bN73132ab7.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/10874804478ebe3645c37fbeddeb2123.png',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,0,0,0,0,0,0,0,0.00,'','',0,''),(168,208,0,'TP0000168','罗蒙男士西服套装正装商务职业装男女同款OL工作服西装大码西装三件套',2,0,300,0,2000,0.0000,789.00,599.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16648/105/1134461067/160837/8e8e0b0/5abe20d7Ndf77daf1.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18703/361/1202744192/223559/820ca29/5abe20dbN9eec77cd.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18205/164/1134209588/281754/d28fa30c/5abe20ddNd28f8d24.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19444/26/1190249340/118339/8462dac4/5abe20e4N828d261e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18505/7/1191911882/102652/c0a1cef7/5abe20e6N86e8990e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19423/156/1149732073/224278/3f4b12a7/5abe20e8N13abb36a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16363/3/2692790487/192870/56de7d92/5abe20f0Nec68bdea.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18721/203/1160933032/149949/3f15b147/5abe210cN1930a2fd.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17152/362/1182454769/152713/bf6a648f/5abe212cN20cbd429.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17956/32/1157692903/138081/339eb1a8/5abe2144N118bddca.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17188/246/1182979773/151799/ed7baae7/5abe2146Nf6de4763.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15658/223/2528507043/246594/1960d304/5abe2148N7c471986.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18961/155/1189065666/326653/64abf3fb/5abe214cNef170f47.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15022/182/2718729689/253956/ccf541dd/5abe214dNf7fb79a0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18472/249/1158866365/450886/8dac70cc/5abe2152N63838d1f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16993/242/1130383542/116142/2ee15310/5abe2154N0f0dce08.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17257/219/1199474010/281860/a8154cfe/5abe2157Nf7d01ed6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18523/90/1159315501/157881/68f76cd1/5abe215bN8875b2eb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19786/4/1156741558/129257/5ed59154/5abe215dN7c911516.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/90fbe086057e1c1fd579f6f004968964.png',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,0,0,0,0,0,0,0,0.00,'','',0,''),(169,209,0,'17061PL2732','花花公子PLAYBOY 风衣男士秋冬时尚休闲夹克中长款外套男装',0,0,260,0,570,0.0000,316.00,186.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7777/85/2599822674/120879/5c063463/59b10bf4Na97c7d29.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8716/277/891828807/194886/7513a246/59b10bf2N35c310f9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8257/283/899614882/133151/5a9c789a/59b10bf6N5f1b4269.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7609/60/2619353169/106147/a24f4103/59b10bf6Nc4b326a4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7816/291/2565423870/107557/814b3dcd/59b10bf7N3c1406a2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9430/326/916284605/93640/9dc52568/59b10becN8905282b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7561/307/2579491120/132218/ce312cec/59b10bf3Ncf4c1454.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8197/292/880912096/124282/69c53722/59b10be6Nfa01ade9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8086/312/907698798/122623/d9067968/59b10bf5N01b0bc91.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8080/307/877099291/94900/24b4faa0/59b10bf9Nc991cc54.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8395/306/907484701/126651/76bbba65/59b10bf9Nbe2d2cc6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9388/299/896574151/131395/91f69006/59b10bfaN4534c0a4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7726/222/2541547570/121340/494691e1/59b10bfaN26101ee4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8959/277/909457617/121856/1f112eb4/59b10bf7N0d6c160b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8056/323/894196843/120734/ce404927/59b10bfbNcea2afed.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7438/306/2550995002/62970/ae3c802a/59b10bfcNd159d612.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8446/308/872734600/46877/993283c9/59b10bfcN987683a7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8467/69/916942047/85665/f3e16dd9/59b10bfcNfc42bba4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8095/311/924175401/68792/e89c0646/59b10bfdNfbf46bd2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7642/41/2529452591/69376/98ed9cd/59b10bfdN2a8683e6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8428/332/923127903/95785/15c7ced/59b10bfeNf348c1c1.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8107/323/877563992/73229/6fed3642/59b10bfeN96076c7c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7633/14/2554930119/69429/9c47ca24/59b10bffNfef2a93e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8098/321/912722828/98004/e8f5114e/59b10bffN34a429ce.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7642/48/2555761950/60614/5b6177a1/59b10c00N0fd3edf1.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8038/324/916847001/193592/a8b1b38b/59b10c00N083bf77f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7471/345/2614395666/43938/2546013b/59b10bf6N76e0545c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8251/337/929153597/353029/e63bb354/59b10c02Ne056b86f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7666/114/2565415475/431197/bc15836a/59b10c03N74cc47ef.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7285/321/2519185717/355144/3332b125/59b10bf9Nbd1a16cb.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/297eaa17baf20e407df63cda42463d92.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(170,210,0,'7882','吉普盾 秋季薄款休闲摄影钓鱼马甲男背心马夹户外宽松军绿大码衣服',1,0,348,0,300,0.0000,102.00,89.10,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6853/332/1980926540/52150/da944554/5987cd26N9d69cadd.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6814/241/1994307538/183938/f796b129/5987cd26N71ca3adf.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5974/281/8424515508/195787/ed111211/5987cd27Nbec1d9cf.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5899/204/9445600324/227017/89e2c0fb/5987cd28Ne7ffb075.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5572/19/9553990246/205745/cb7855c9/5987cd2aN2533b4b4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5869/123/9647439829/225248/c049f1f9/5987cd2dNfc710c38.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7075/224/1081472743/251769/76963632/5987cd2eNcc1495a9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5584/272/9639716919/219795/9a9c8535/5987cd28N7d21de38.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5635/266/9513700736/273295/34021ca1/5987cd33N68dfaac0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6004/19/8314192319/86016/254ec6a2/5987cd35N8a81557c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5671/44/9499700288/138894/ab159b9a/5987cd37N321b8980.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5863/156/9563283339/146372/a8aef06a/5987cd39N7c765923.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6829/284/1969933004/152921/9eee5eb2/5987cd3bN3c6e7c25.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7189/275/1063253879/148070/c90889a/5987cd3dN7e2fa7c1.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7033/152/2039744872/74158/754368f0/5987cd3fN439e6c22.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6805/281/2016498074/123121/14f50b8f/5987cd41N40a21fbc.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5920/361/8343096371/123464/5e450b3b/5987cd32N5827c0e7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5989/353/8410631766/97910/d003d378/5987cd45N8fb92708.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5653/177/9509704210/171665/e78fd10d/5987cd47N92ac481f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6823/327/2015070307/151454/52aade83/5987cd49Nc89629b6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5617/196/9456664840/192216/763e8547/5987cd4bN12394015.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/7ce2632e4e6a904da1c51afb7c730bbf.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,2,0,0,0.00,'','',0,'/public/upload/goods/2018/04-16/a6683a1a20f3f9b52bbd824a1eedd08b.mp4'),(171,14,0,'TP0000171','睡衣女士纯棉短袖夏季红豆居家春大码全棉甜美薄款家居服短裤套装 红豆居家女士纯棉睡衣 休闲可外穿',37,0,400,3,11,11.0000,138.00,128.00,128.00,'','','睡衣女士纯棉短袖夏季红豆居家春大码全棉甜美薄款家居服短裤套装\r\n红豆居家女士纯棉睡衣 休闲可外穿','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/387911053/TB2PpoTXOMnBKNjSZFCXXX0KFXa_!!387911053.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/387911053/TB28LgSXOMnBKNjSZFoXXbOSFXa_!!387911053.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/387911053/TB2tlOjeUR1BeNjy0FmXXb0wVXa_!!387911053.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/387911053/TB2MtAoinJYBeNjy1zeXXahzVXa_!!387911053.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/387911053/TB2uMh5gH1YBuNjSszeXXablFXa_!!387911053.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/387911053/TB27cCsgL1TBuNjy0FjXXajyXXa_!!387911053.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/387911053/TB2.kt_gKSSBuNjy0FlXXbBpVXa_!!387911053.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/036cb22e5b560d0b182312d6de328903.jpg',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,1,0,0,0,10,1,0,0.00,'','',3,''),(172,211,0,'1D1710104290','七匹狼休闲单西 春季新款 男士时尚休闲商务西服装韩版小单西外套 ',4,0,499,0,500,0.0000,510.00,399.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4117/279/1754626671/35533/5541c208/5896d8a3Ne4c96cd0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11176/309/419108486/209232/2f1878ba/59ef09f6N55e6ee77.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3232/120/6345168693/44562/3bd7a2e2/58a54a61N525e947f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3907/107/2184664343/416961/d404bcc5/58a54a61N3b96f4ea.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11467/266/393113941/247222/470844e5/59ef0a24N81a00403.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9946/182/2107203587/254404/32563856/59ef0a26Nf550700a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7654/145/2822513211/92870/fcc0fbaa/59ef0a26Nde59d598.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11368/231/404374878/384442/dc26cc45/59ef0a26N72e7aff9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10753/59/2119776033/275717/df6d4c23/59ef0a23Na2891b7f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7210/107/4757297504/382023/d602e043/59ef0a27N1999da8e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10147/18/2110738794/369647/88c12d6b/59ef0a25Nd1d2b57f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10516/127/2080762129/355940/1fcf13cd/59ef0a27N289276a6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7663/349/3026087266/399069/1002368f/59ef0a27N7c356529.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7858/279/3139329614/373554/40b536d0/59ef0a27N138d89c9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10597/150/2110969275/441638/3f489946/59ef0a28N9e8f5f2f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10156/31/2128379616/330851/55d92ca4/59ef0a29N5320d5ba.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11659/232/390515597/288644/85e431f1/59ef0a28N5c51e20f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7468/198/3841254283/368977/15f8dd67/59ef0a1bNd768f71f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11926/59/368008986/344679/d831bbfd/59ef0a15N29e95305.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11992/89/401965678/406121/c4da0cbf/59ef0a24N0b19d142.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7969/232/2830887500/336629/aa355fdb/59ef0a29Nb35edd77.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11359/269/397888694/337825/73125ec/59ef0a23N62cbe7df.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10177/293/2162766226/338673/577efd3d/59ef0a29Nc822bc25.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10609/179/2116978067/310303/375e3135/59ef0a2aNe92ee504.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11374/242/393045830/303922/512e7358/59ef0a2bN0c8e71ae.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3283/339/6474433955/178327/2764ab26/58a54a6eN15ccfdfb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3859/115/2153727481/147590/3fb780b8/58a54a6eN5d203854.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3880/359/2249278949/207563/d1422ae6/58a54a6fNc2d1b56e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4039/123/2214478674/154198/a2cc5898/58a54a70Na1706b5b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3208/158/6367477265/155059/9fd2bc47/58a54a70Nc0788258.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4054/279/2212592886/143722/e0cc2838/58a54a71N076fc4d5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3928/284/2207649177/154312/58d074a/58a54a71N7a349f77.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3196/104/6401981458/126307/a118f05b/58a54a71N18e82e76.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4087/148/2221667281/156593/a41935f6/58a54a71Nb3258844.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3865/12/2175119168/199061/a0afdfe9/58a54a73N99ea753d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3901/139/2245773372/276106/1d9fabc3/58a54a73N76535723.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3160/163/6486002351/242032/ec848aa6/58a54a74N892947e7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3163/139/6365878169/233812/f0f1a5d7/58a54a75N1e5ae595.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4048/142/2250010825/197585/66c5c9b/58a54a74Nfd00d254.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/bffc8901eba1c3fc3b2feebf309cdd21.png',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,0,0,0,1,6,18,0.00,'','',0,'/public/upload/goods/2018/04-16/6facb0e2545a6f51a6be498cc538cf19.mp4'),(173,212,0,'TP0000173','杉杉（FIRS）男士免烫商务防皱韩版修身西裤',0,0,300,0,670,0.0000,256.00,179.00,0.00,'','','','',NULL,'/public/upload/goods/2018/04-16/3fdd5f38d267f98230fcd525e538f5fb.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(174,183,0,'TP0000174','茵曼A字半身裙',10,0,96,1,300,5.0000,199.00,98.00,299.00,'[{\"amount\":3,\"price\":79},{\"amount\":5,\"price\":69},{\"amount\":7,\"price\":59}]','A字型，半身裙。','鱼鱼鱼鱼','&lt;p&gt;6666666666666666666666666666666&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/ef1d3905c7cb6a0b97a045fd316c7005.png',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,0,0,1,4,1,55,0.00,'','',6,'/public/upload/goods/2018/04-16/9b7e3df3c01896268596be68da028371.mp4'),(175,216,0,'HWS5M6382','红豆（Hodo）毛衣男V领套头加厚 冬季新款男士背心V领全羊毛无袖羊毛衫',2,0,197,1,400,0.0000,366.00,299.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7693/21/767817280/293725/90eceeef/5996b635N6534910f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7408/248/763152553/289967/6f8319ef/5996b636N49bedf61.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7144/360/2459428199/57680/406f8937/5996b636N9b088c34.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t6130/168/9767516754/49419/d6adc05d/5996b637Nd16cfd90.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7519/251/748784678/286699/845e3a44/5996b638Nf1e18993.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7741/344/729079435/293341/3b8e9900/5996b639N39594f1d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5983/227/9658246032/288658/9c5c598/5996b63aN3187af8a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7618/312/733603083/286878/e6c8468/5996b63bNfc00a1dc.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7654/361/723896484/296903/2c9d0d63/5996b63cN1deb2c62.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7345/15/716258653/287443/6ce1e0bc/5996b63cN435def4d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7597/308/726062769/292756/96a8ae18/5996b63dNc5210a5e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7873/326/755827511/291781/9689bf59/5996b63eNf5109c74.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7420/340/742608943/294689/5bf16719/5996b641N17cef46d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7492/329/739311167/294506/768f5862/5996b640Ndccd979b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7720/40/730526888/294313/52a42de7/5996b641Na30b6080.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7222/19/738766448/295445/1c7306b5/5996b642N04604e07.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7663/357/762090893/289013/7b422054/5996b643Nef6b6a83.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7567/20/743044057/296043/25be60a3/5996b644N7e45a167.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/4987a79394e85f009e530e38bb09744e.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,3,0,0,0.00,'','',0,''),(176,213,0,'PB1026-1756ZLG','花花公子夏季中老年人男装短袖t恤 中年男士大码爸爸装半袖体恤衫上衣 男针织衫短袖',0,0,200,0,300,0.0000,199.00,158.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5047/144/701047520/177027/f0fa3a5b/58e7113aNc0568a8f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4516/355/1855553600/106392/e550e7d8/58e7113cN86a2d969.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4249/68/3745716731/177603/e94b0819/58e7113cN6dceb2b6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4183/120/3764650820/174651/1cb613f8/58e7113cNd7a1d5a4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4747/266/729429897/117837/9ee075b/58e7113dNf76a045a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4210/90/3713757977/760790/d54aaa0e/58e7113eN1232f245.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4708/12/1834234259/232816/d8dc9da/58e7113fN0915bc43.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4189/353/3719160358/786986/449af2ce/58e7113eN8fb2add0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4252/127/3669063922/242346/d3e15551/58e7113fN94945e81.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4351/263/3696461266/94093/c61216c8/58e71169Ne11584a4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4717/124/741775461/144365/f9b3482f/58e7116bNd61dd4be.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4618/75/1873575978/90829/cc386265/58e7116aN2c5638f4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4402/356/1827887789/703731/e2c79ae6/58e7116dNfb8f1163.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4219/285/3733083081/203983/139787fc/58e7116dN7570ed48.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5020/166/689433884/201343/c382f75a/58e71168Na7655f86.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4135/251/3747852682/760200/64c9d72e/58e7116eNd123afee.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4504/85/1863920615/193069/bdfcac56/58e71170N8d6607b7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4906/18/701161700/685588/f460c7f9/58e7116fN98dea0b4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4606/58/1882845075/229688/8a4abe2e/58e71170Nbfdd7260.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4921/167/723890671/192339/9719ec67/58e7116eNbc34deaa.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/005544c4a53bf91bacc845eb6b726c3b.png',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,0,0,0,0,0,0,0.00,'','',0,''),(177,214,0,'D281','GENANX闪电潮牌男士拼接格子短袖衬衫 设计师潮牌夏季商务休闲免烫立领衬衫男潮',4,0,222,3,350,0.0000,279.00,198.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4138/260/1943495152/65154/dd1c7903/58c8ba2dN17967375.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4144/107/1932803248/136027/c6e73bff/58c8ba2eNad124e81.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4426/37/50719649/164883/6b48a86e/58c8ba2eN0630254f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4102/166/2057185562/160212/4e2f423f/58c8ba2fN94c0f112.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4267/105/1909863237/136052/6e2551ac/58c8ba2fN68f3b078.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4714/21/48492986/139592/1626b80c/58c8ba2fNa8a2056d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4393/26/45837776/156371/70991976/58c8ba30N8926332c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3301/171/8742168827/138353/7fe5f3e7/58c8ba30N8787174f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4120/180/2021776815/141720/33f26716/58c8ba2fN1ea03135.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4654/13/50280845/55793/c7b3bfcf/58c8ba31Nbb076948.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4168/93/1944017176/85228/7b61ec42/58c8ba31N2b8d74c1.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3211/132/8699328300/74445/2f75951a/58c8ba32N38a057a1.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4195/126/1903674417/95349/d81c92c8/58c8ba32N5a4f202f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4711/21/46998810/97980/307bf34/58c8ba33N8c4f2396.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3232/87/8797757788/83423/43403ee2/58c8ba33Nb3e47ea7.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4279/189/1922878312/48588/e0bc006a/58c8ba34N37e5951d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4618/28/47069049/55328/284acaf9/58c8ba34N99cb4130.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t11017/274/1436677477/67120/bfb1b813/5a01194eNe269cec1.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t17161/201/1130122133/78210/638c70be/5abc395eN846796a7.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3193/18/2167273468/236688/b9ce7962/57dd1058Nf67b25c7.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/28fac2e7faa5dcc2ef72ccbcf9a8949b.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,8,6,6,0.00,'','',0,''),(179,219,0,'915921922923','BXMAN宽松男士内裤平角裤纯棉梭织阿罗裤舒适睡裤春夏家居短裤 921组4条装',4,0,300,0,370,0.0000,129.00,99.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9679/36/1524884126/674784/c5627260/59e2d415N5b001d35.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t10909/299/1526488677/476235/7d37362c/59e2d413N2050d551.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t10831/340/1481061059/450891/d3fa2d0b/59e2d414N5237d2cd.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t10387/19/1546894762/444761/c0102902/59e2d3fdN0dc1a03e.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9895/100/1549799992/431382/5dc4c54b/59e2d414N95d33b40.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9706/20/1562998876/325443/3e0a5436/59e2d417N450f698a.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9766/279/1543358743/335316/19747deb/59e2d418N03b4a6a1.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9877/112/1542262414/325890/fd4d90be/59e2d419N39d8f12b.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t10345/40/1505321253/385254/365d60f2/59e2d419Na9dbb740.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t10264/27/1528107741/327543/73fea9a/59e2d419N7ea0b291.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t10867/296/1582069181/479938/95b14bfd/59e2d3fbN100a34c4.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9589/355/1539967871/1036999/53adcbbd/59e2d404N9bbe2054.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/024573f6d57e3dc508dcf0dcc87fdaa5.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,100,0,0,0,4,0,0.00,'','',0,''),(180,573,0,'TP0000180','保罗骑士男鞋2018春季新款英伦风真皮男小白鞋休闲鞋潮流系带板鞋 2018春季上新 简约英伦风',12,0,500,0,0,0.0000,298.00,198.00,0.00,'','','保罗骑士男鞋2018春季新款英伦风真皮男小白鞋休闲鞋潮流系带板鞋\r\n2018春季上新 简约英伦风','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/631497058/TB2_P4nbVuWBuNjSszbXXcS7FXa_!!631497058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/631497058/TB2YPlnb29TBuNjy0FcXXbeiFXa_!!631497058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/631497058/TB2168nbVuWBuNjSszbXXcS7FXa_!!631497058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/631497058/TB293RpbVGWBuNjy0FbXXb4sXXa_!!631497058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/631497058/TB27gJlb3aTBuNjSszfXXXgfpXa_!!631497058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/631497058/TB2YNxwb7yWBuNjy0FpXXassXXa_!!631497058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/631497058/TB2yLdqbWSWBuNjSsrbXXa0mVXa_!!631497058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/631497058/TB2yLdqbWSWBuNjSsrbXXa0mVXa_!!631497058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/631497058/TB2O4Bwb7yWBuNjy0FpXXassXXa_!!631497058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/631497058/TB2zjW6b9BYBeNjy0FeXXbnmFXa_!!631497058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/631497058/TB2iaVib1uSBuNjSsplXXbe8pXa_!!631497058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/631497058/TB2sXXhbVmWBuNjSspdXXbugXXa_!!631497058.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/631497058/T245M2XN4XXXXXXXXX-631497058.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/ac3f0581ca45ce542e92712cffcb174d.jpg',0,-28800,0,1,0,0,0,0,1,50,0,1,1,0,7,100,0,0,0,0,0,0.00,'','',0,'/public/upload/goods/2018/04-16/9301ce496382d2651135e8044399d5dd.mp4'),(181,371,0,'TP0000181','德国WMF福腾宝厨具套装锅具不锈钢炒锅不锈钢汤锅厨刀2件',15,0,0,1,0,0.0000,1399.00,1299.00,0.00,'','','德国WMF福腾宝厨具套装锅具不锈钢炒锅不锈钢汤锅厨刀2件','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/761898997/TB2TY1VhuOSBuNjy0FdXXbDnVXa_!!761898997.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/761898997/TB2Pja6hASWBuNjSszdXXbeSpXa_!!761898997.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/761898997/TB2u1WwhpuWBuNjSszbXXcS7FXa_!!761898997.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/761898997/TB2dfWYhuuSBuNjSsziXXbq8pXa_!!761898997.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/761898997/TB2dfWYhuuSBuNjSsziXXbq8pXa_!!761898997.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/604b7de19ba1cab579c18d538c8bdd9b.png',0,-28800,10,1,0,0,0,1,1,50,1,0,1,0,0,100,100,0,100,0,0,0.00,'','',0,''),(182,220,0,'TP0000182','浪莎（LangSha）女士内裤女高腰棉质性感大码透气收腹提臀三角裤4条 混色',5,0,496,0,240,0.0000,79.00,55.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11005/153/2061520208/416292/d90d1464/5a0ea602Nb6774c7f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11416/288/1858315431/210704/5eb745e9/5a0ea601Nc82183ae.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14008/335/590895087/366317/88824667/5a0ea602N528e25ce.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7291/223/3764292937/109610/c64984c1/5a0ea601N3fde5835.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11212/219/2052118815/91432/a8fb418b/5a0ea601N9669e655.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13870/328/569800736/331221/bee08d83/5a0ea602Ne364e36d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t12421/219/564229623/396305/cb54a6f1/5a0ea604N4a58c7f5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13297/28/581240332/429759/59a3d509/5a0ea5f6N21b10357.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11578/18/1874323981/484526/ea218943/5a0ea606N701163b3.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13594/333/563197636/171680/47f60db2/5a0ea5ffN92a3bc56.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13048/41/564570806/228406/6269e8ca/5a0ea604N749f3dfd.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13003/361/556634454/310215/b3b8fca2/5a0ea606N714cc2b9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13465/24/547660021/414134/27fe9664/5a0ea607Ncb96a878.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13591/331/578500600/210056/4b6e23f0/5a0ea606N8799b0c4.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/7a18bed2dd0af51e307c878bb2499b47.png',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,0,0,0,4,0,0,0.00,'','',0,''),(183,223,0,'TP0000183','幻薇少女文胸运动文胸学生内衣发育期初中生高中生抹胸背心瑜伽防震跑步胸罩 交叉黑+交叉白共2件 均码（建议体重80-135斤）',1,0,198,0,100,0.0000,89.00,59.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13981/45/626615399/157521/2aadddf3/5a0fe0c8N6d2e71eb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11125/186/2077010905/133609/e607ac5f/5a0fe0f1N868e6d64.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7813/320/4389871381/237900/c9d8653b/5a0fe0f2N76c65097.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t12367/18/633188479/154936/d105a737/5a0fe0f2N98d20c47.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t12481/173/629542881/124881/a7bdc19d/5a0fe0f1N40d46176.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t12352/186/618316989/164751/bafe6472/5a0fe0f2Nff3e4232.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11656/86/2083768818/107811/4d601e15/5a0fe0f1N6569c5fb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11089/120/2088430373/182717/e1491de2/5a0fe0f6N5c516f5f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11905/286/2033688559/189420/b36b4a07/5a0fe0f4Nb3d37efe.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13459/50/613687518/122310/4a51106b/5a0fe0f4Nc1453d30.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13612/20/597675463/137430/8ad40180/5a0fe0ccN2cd072fb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14113/72/646709248/330139/dc393b4/5a0fe0f5N11dd6c26.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11269/52/2076594893/118071/719495ce/5a0fe0f3N6464bdc8.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13303/39/625958831/181232/a14c8ff6/5a0fe0f2Nf8c9e72b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13462/152/633341206/194662/3a704f53/5a0fe0f4N90d8c954.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11212/249/2109810893/204204/6765bb00/5a0fe0f7Na9bfa326.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13048/68/630607335/152158/9dd0a326/5a0fe0f6Nc3bb2c9c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7840/9/4453502162/141226/348201b8/5a0fe0f5N0faeb625.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t12796/48/607902299/92059/ca6ae0bf/5a0fe0f9N07afcfa9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11719/63/2097284661/224351/f4a3e1b2/5a0fe0e7Nf81cba24.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t12148/300/608488335/189151/3b0b582f/5a0fe0f6N1c85d515.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11710/303/2040355742/131765/2d9c8d42/5a0fe0f7N59b70cb5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t12625/17/627750298/245483/10fb44d3/5a0fe0f9N1db018d2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13708/39/614172918/160613/c8145efd/5a0fe0f7N102bae3b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t12457/114/611303130/250923/8d802615/5a0fe0f7Nad558dd5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13201/26/628817126/147937/5695bb4e/5a0fe0f8Ncbd6e889.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t12103/231/619675574/189643/ce885853/5a0fe0faN91cfabb3.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/8c1b57581118d685c199f248e8088e7c.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,2,0,0,0.00,'','',0,''),(184,120,0,'TP0000184','贵州茅乡酒 M10浓香型白酒 52度送礼白酒 纯粮500ml一瓶 贵州 52度白酒 浓香型 純粮酿造',9,0,98,0,0,0.0000,168.00,159.00,0.00,'','','贵州茅乡酒 M10浓香型白酒 52度送礼白酒 纯粮500ml一瓶\r\n贵州 52度白酒 浓香型 純粮酿造','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1763893017/TB279XwpgfH8KJjy1zcXXcTzpXa_!!1763893017.jpg&quot; width=&quot;810&quot; height=&quot;1269&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1763893017/TB2tumxfBLN8KJjSZPhXXc.spXa_!!1763893017.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1763893017/TB2SeuAePgy_uJjSZTEXXcYkFXa_!!1763893017.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1763893017/TB2SeuAePgy_uJjSZTEXXcYkFXa_!!1763893017.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1763893017/TB21FQDo22H8KJjy0FcXXaDlFXa_!!1763893017.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1763893017/TB2M9COePgy_uJjSZSgXXbz0XXa_!!1763893017.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1763893017/TB2M9COePgy_uJjSZSgXXbz0XXa_!!1763893017.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1763893017/TB2vCE0oZjI8KJjSsppXXXbyVXa_!!1763893017.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1763893017/TB2vCE0oZjI8KJjSsppXXXbyVXa_!!1763893017.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/234d53752def10b7347ab741b7c9ea1b.jpg',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,100,0,0,2,4,0,0.00,'','',0,''),(185,224,0,'A110030/110031','恒源祥袜子 男士6双装 男士纯棉四季款 吸湿透气全棉男袜 A110030款',0,0,297,0,190,0.0000,79.00,49.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t4369/326/2455294131/361348/d18c040e/58d21714N7cc29883.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t3277/85/9327477416/461709/96e7432b/58d21714Naf0ad42e.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t4384/326/2472264311/190700/99be822e/58d2171cN0d6f1079.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t4393/205/589286574/83693/912ce31d/58d21720N53a427c0.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t4567/199/580091782/417096/a88b1712/58d21724N10102172.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t4711/193/588834101/281424/224f9134/58d2172aN8d92492a.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t4135/27/2476592063/175751/c59bd027/58d2172bN9af5e225.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t4213/322/2451649397/173575/71bde98e/58d21732Nd202fa5a.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t4501/225/570088257/187017/758d59ba/58d21736N2c06197d.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t4156/22/2494693407/531149/f2fcf3f/58d2173aNa93b803c.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t4132/200/2452461484/262956/978c628f/58d2173eNa5406ec6.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t4408/240/604821087/766325/84f655b9/58d21741N3f04d55c.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t4528/308/594181800/381045/f0c3bac6/58d21748N999f1bdc.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t3181/81/9322465533/184006/db5bf9dd/58d2174cN81318449.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/c03ac10f8a3a38db6164af61f2c76ddd.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,3,6,11,0.00,'','',0,'/public/upload/goods/2018/04-16/d1da0b7e501dde9ef05ea3b3e6937a39.mp4'),(186,226,0,'CI1800001','恒源祥打底裤袜女连脚【2条装】春季新品光腿神器防勾丝加裆连裤袜女 肤色2条 均码',17,0,294,1,200,0.0000,89.00,49.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17773/310/231423407/399948/71e05331/5a6539c1Nd5b1612f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16399/32/1833369308/410534/cd868bf5/5a6539c2Ne06dc65c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17083/314/236434867/303938/2a4920c8/5a6539c2N32a57905.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19129/312/215012070/319216/54607d60/5a6539c1N8fd7e3c3.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18142/271/230668755/260246/579c8e83/5a6539c1N4573ac23.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15460/172/1955231377/275258/96f12653/5a6539c1N545d4085.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16537/295/1629102370/167583/77910214/5a6539c2N4445d8e9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18136/267/243699240/199537/9c56a6eb/5a6539c2Ne3c71f5c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18826/318/227666974/216101/beef6f/5a6539c2Nbf85d0bc.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18934/307/222800819/358081/32221120/5a6539c2N16bf757a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15859/129/1893447249/373983/b7f068ff/5a6539c2N206471e8.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18886/301/231751394/361474/b2c18c3b/5a6539c2Nd75bd636.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19402/313/242944081/447458/b322b54f/5a6539bfN1fa04f05.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18406/271/228358017/367955/77c43c49/5a6539c3Nbe912590.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18136/266/225833242/314446/624cb22e/5a6539c3Nd9a0e631.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16603/326/242592805/240606/167a5716/5a6539c3N09bbbf53.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/f8e4ea345fc1ced0dcd9e9c794aaa38a.png',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,0,0,0,6,3,66,0.00,'','',0,'/public/upload/goods/2018/04-16/af355d05d732e8f40b9d750e1eb2a126.mp4'),(187,227,0,'3003','3对硅胶游泳防水透气乳头贴防凸点胸贴防走光乳贴女薄隐形乳晕贴 三代圆形1对+梅花2对【3对装】',4,0,200,0,100,0.0000,26.00,14.90,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t15082/253/1625579163/8163/c3204002/5a5362b4Nac21db71.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t16210/365/1482298362/388235/7777d164/5a5362a6N34b2d6bb.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t14305/218/1629759526/335066/75a285da/5a5362afN30336744.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t14935/40/1708675899/296701/7e803b0b/5a5362b5N6319f4a3.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t16417/130/1474779849/285080/aaca628b/5a5362b5N7cd0e960.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/1ca677c1f32302a63ecae403a2c4f7a1.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(188,228,0,'D16XK63204','欧迪鸟品牌比基尼三件套2018春季新品小胸钢托聚拢遮肚修身温泉泳装女',0,0,297,0,1000,0.0000,2199.00,1759.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t3856/305/543958346/992147/44245dfb/585509cdNefea7273.jpg&quot;/&gt;&lt;img src=&quot;https://img11.360buyimg.com/imgzone/jfs/t3181/242/4762826335/109500/d404f55d/585509ceN36298529.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/imgzone/jfs/t3676/184/2450988858/594710/1499d62a/585509d3N17db4384.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3055/114/4837039482/872980/8c25c8e5/585509e5N31f03446.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/imgzone/jfs/t3169/122/4820307839/760662/826aa9f/585509f0N8328bfff.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3280/134/4564309031/933448/2c49cc2/585509faNc9a9f3ff.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/imgzone/jfs/t4060/228/573101172/59825/80727bd7/585509faNec1ef50d.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/imgzone/jfs/t3832/131/2266701008/116142/8c3fd267/585509fcNacf12adc.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7894/151/720870581/985412/dedf2201/59968765N286b07a1.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/150f01bd81c2bae47a45a1ae48ff086a.png',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,0,0,0,3,4,0,0.00,'','',0,''),(189,427,0,'TP0000189','菲斯奈特黑牌起泡酒 西班牙CAVA产区FREIXENET原味起泡酒促销包邮 西班牙进口 优质起泡酒 纯天然口感 百搭产品！',15,0,96,1,0,0.0000,139.00,129.00,0.00,'','','菲斯奈特黑牌起泡酒 西班牙CAVA产区FREIXENET原味起泡酒促销包邮\r\n西班牙进口 优质起泡酒 纯天然口感 百搭产品！','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1611973622/TB2sBp1g49YBuNjy0FfXXXIsVXa_!!1611973622.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1611973622/TB2sBp1g49YBuNjy0FfXXXIsVXa_!!1611973622.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1611973622/TB251lZg7CWBuNjy0FaXXXUlXXa_!!1611973622.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1611973622/TB2ynI9gKuSBuNjSsplXXbe8pXa_!!1611973622.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1611973622/TB29Ypmg79WBuNjSspeXXaz5VXa_!!1611973622.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1611973622/TB2ehjkg_JYBeNjy1zeXXahzVXa_!!1611973622.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/faf22eb93d21bdd086c6e7a2590394f7.jpg',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,1000,0,0,4,3,63,0.00,'','',0,''),(190,229,0,'1821843D1/21844D1','三枪秋衣秋裤男女情侣纯棉加厚圆领宽松保暖内衣保暖裤男士女士套装',2,0,323,1,400,0.0000,128.00,99.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9733/68/1387511811/268707/cedb6b5f/59e0929fN48984e6b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10240/17/1387319553/327592/70ca134/59e0929fNd53f2d65.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10711/19/1409440749/295573/ef16541/59e092a0N0b8d8746.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10933/315/1420056724/154066/4b758910/59e092a1Naf054605.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10924/300/1428492045/301751/1c8b87c2/59e092a2N7746fc70.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10312/357/1388243398/342375/7c454430/59e0929dNd224d5cc.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9841/76/1429083546/343070/59aa844d/59e092a3Na7ac680f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7378/215/3167705038/175797/f4f69048/59e092a3N11ed57e2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9805/81/1402121873/165822/86130d73/59e09291N767bf043.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10297/359/1427115325/285955/bade00dd/59e092a5Ncaa93ad8.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9859/149/1424346251/175994/75bc035c/59e09292N8cc0c7db.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7243/11/3205598372/158495/ab130cbd/59e092a6N5e5d316d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7972/213/2760643793/177320/99775e7a/59e092a6N507bd84d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10546/83/1413158850/164360/45ea6bda/59e092a7Nf980b5be.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10177/48/1436196355/249602/3af7f979/59e092a8Nd78ea1b6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t8053/225/2548972966/241506/c7b6093f/59e092a8N0a85fa87.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/0afb7460ba914c7138e96b94e90c7e83.png',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,0,0,0,7,0,0,0.00,'','',0,'/public/upload/goods/2018/04-16/9f378485de811029b3bdba79fbac130b.mp4'),(191,230,0,'10012','南极人保暖内衣男女士蓄热加厚加绒黄金暖绒套装',1,0,399,0,760,0.0000,99.00,86.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19186/356/459201425/253587/db3a3090/5a7c6863N01030397.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14713/327/2231538091/245381/d2d3a23a/5a7c6864N333425df.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18700/164/465460871/400277/b8fb9d46/5a7c6868Naa002abe.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16582/9/2049842792/442059/6adf7790/5a7c6864Nd3e2f561.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17617/236/448150560/323279/79fd4783/5a7c6864Nbbe99a0f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13399/208/2327830861/217669/29ffe0ab/5a7c6867N1b3c9abb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16513/154/2026548633/219178/8016bef3/5a7c6869N3bf697e9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14356/343/2221130371/193693/c152163c/5a7c6864N9d567c46.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16630/162/467853104/189994/b1076a7d/5a7c6864N60e64d92.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16144/190/1992631234/322104/a7e0a16c/5a7c6864Ndd893e20.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15313/339/2221803662/153051/81fa2a67/5a7c6869N905db5e2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17902/196/468298745/115007/b49f4538/5a7c6866N7e5af1dd.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19768/216/456574330/153058/1e1782db/5a7c6865Na5885537.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17164/174/464612770/176357/93c5c2cf/5a7c6865N9d4e2009.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18628/332/450143103/146488/c2d63308/5a7c6866Nac8f860d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14236/135/2179479892/153217/ef7043a2/5a7c6866N453386be.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15223/362/2180727841/235150/806d5d62/5a7c6866N0f7f96b5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16624/298/472287357/186218/49550a04/5a7c6866Ne5629956.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19624/158/458919617/200903/4b670ced/5a7c6867N24276764.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17266/215/447794090/153945/b9d594ec/5a7c6867N111cd2fd.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18304/229/451249160/348519/e51cbfda/5a7c6867Nb92d8065.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14230/140/2224297118/178280/4677e709/5a7c6867N83e44576.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14227/148/2133585017/205829/df6d5228/5a7c6867N8316d079.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14893/350/2270440527/226386/34b8130d/5a7c6867N55a221ba.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18682/146/453268859/169548/1fb03a0c/5a7c6867N79a33c95.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17917/313/453969159/226017/22b67901/5a7c6868Ncdcca5bb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17344/295/485749848/250096/4baa8feb/5a7c6868N8bdc79b4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17293/302/466302000/198932/2e3e3037/5a7c6868Nf83153e6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16399/116/2025481667/208309/effd3ca9/5a7c6868N0a5c653d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13993/363/2465653048/221700/191c5635/5a7c6868Nba5e01d3.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16642/325/477493245/385264/a4b9adfa/5a7c6868N240747c6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14962/151/2254726416/389057/ae46bb38/5a7c6869N08faacc6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15427/81/2265428957/294343/6cab533b/5a7c686cNef466b54.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t14665/138/2283462375/218082/db22efd8/5a7c6869N92a9868c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16282/158/1943679772/380149/d9a5843a/5a7c6869N97fe879f.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/08c4fe33dc36f9ce3b3d3dc1ad85898e.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,1,4,0,0.00,'','',0,''),(192,217,0,'WAJ1517S','桑扶兰 薄款高侧比大罩杯聚拢性感文胸双胶骨收副乳胸罩内衣WAJ1517S肤色B80',0,0,500,0,100,0.0000,236.00,159.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8794/123/912530022/457946/124d8b3b/59b9552fNca93865b.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8776/121/923692621/218495/4af2ffca/59b9552aNeff8e924.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9310/38/1442840385/447331/65fb676a/59b9552aN50abf565.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7456/326/3044787323/336071/71c2e36/59b9552cN1e85872c.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8374/219/1411424047/396679/364d38a2/59b95522Ncfcd862d.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8926/138/1413144723/267455/31c254df/59b9552fN05bac465.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9400/160/1406397922/277104/1b6424d0/59b9552eN75422bb6.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8938/7/1413781005/266075/a834e5bf/59b95530N9424233a.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8539/145/1419181153/179788/9c13ee27/59b95532N404dd293.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8053/173/1403755606/239332/df31008f/59b95532Naaf5ee25.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8575/245/1414678473/290911/1d809b85/59b95532Nb2968522.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9466/44/945308779/176279/54e4d928/59b95535N397e7e93.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8617/236/1399799365/143825/6eb3d30b/59b95535N8631f005.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9034/152/1455440030/324668/faec68ad/59b95530Nda7f90a8.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9268/132/1370906407/277457/184982af/59b95536N860ae960.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8086/173/1406270728/180360/81651ed9/59b95522N49fbb81c.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t8713/192/1401275397/386322/475174f0/59b95538N263b20f3.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/cms/jfs/t3883/179/1273808207/222253/cce1deea/58be724cN58e14868.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-16/798050eddf9069ff28aee80bfcc6499e.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,0,4,0,0.00,'','',0,'/public/upload/goods/2018/04-16/39026452f16870fb9f43414e582475e9.mp4'),(194,338,0,'N00003','尚品宅配橱柜定制 欧式风格整体橱柜智能厨柜定制多功能橱柜厨房定做 石英石台面厨柜',27,0,200,1,100,0.0000,2699.00,2000.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t7960/228/305951501/167189/64bf3df9/59915452Ndcf98a96.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t6121/162/9254356066/155990/417f4472/59915442N6792de37.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t7333/232/292090078/243483/1312f86b/59915441N16379562.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t7651/295/293507092/220622/54b95518/5991544fN102a5b90.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t7303/240/281875797/350662/86ae25dc/59915454N9bbddeea.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t7237/247/285684546/172775/30c74143/59915454Nd9bbcabb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t7201/281/2098343740/236966/b21c2e47/59915454N5315aa30.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t12892/190/2529471287/133187/aad568cd/5a5ef7c8N056bfff0.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t16552/319/1756666715/149112/b456de5a/5a5ef7c8Na7d77993.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t19048/317/126062918/127205/9fa0f51c/5a5ef7c8Nd410b0ee.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t15274/106/1902877757/145586/9276bc71/5a5ef7c8N32da3eff.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18643/23/131185617/361361/cf04b369/5a5ef3eaN7dcf5f12.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t15160/11/1869389029/204821/8c17abd/5a5ef7c8Nb9328d9e.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t14914/228/1901170348/225352/506b16d7/5a5ef7c9Nc7886433.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/6113022a41c146056a2d31faa63e0c25.png',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,0,0,0,0,3,62,0.00,'','',0,'/public/upload/goods/2018/04-17/efb47040dc51a38962b53d2a1faa1ca7.mp4'),(195,325,0,'TP0000195','贝尔（BBL） 贝尔地板 实木 地板 东南亚进口 番龙眼 18mm家用环保 红枫古道 深色',1,0,500,0,1000,0.0000,236.00,209.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13729/162/1814873386/261046/969a086b/5a2a2890Nfa3baeaf.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11941/264/1314387187/119832/dddc16ec/5a004b73Na8dd6d55.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5290/27/2291934161/75605/5b5b7808/5919525cN001c8045.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5197/161/2267514623/208655/db716138/5919525dNee4d6757.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3112/255/3082509954/420199/a2eb9d85/57eb5d7bN0cea075d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5860/31/3560148477/303663/80fc2bd1/593e0bc7Nc6e43401.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3187/321/3045480070/577476/8ce762bb/57eb5d7cN347104c9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5968/163/1327918699/139456/f1c6da9f/59310a5aNee0bc7fb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3109/283/3031966824/447310/c90f92f7/57eb5d7dNd9b0aa00.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11818/280/1317189175/625774/7c4fb968/5a004b74N8c3fc84f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7972/222/4368406407/618939/79389db2/5a004b74N5b1d59a6.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5761/100/3536333485/648615/5c33e643/593e0db6Na769ca48.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11332/79/1352272964/189711/35a03840/5a004b73N5e167199.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t6040/106/2302771133/299720/679bbd1d/593e0dafN0f8676f2.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t6337/220/352890594/217384/d9f2b77d/593e0db7N74cfcbcb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11851/161/1341268062/177640/3d6a4f87/5a004b73N16782912.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5611/348/3553254578/452243/5d2a5b5e/593e0f68N3013b698.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t6460/93/335919926/358731/608c8289/593e0f68N8684a4d3.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3091/345/2946860557/520894/1d7abff0/57eb5da5N2335bafa.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5710/311/2488202811/157307/d8a9f42f/59310a5cN1b40105f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3112/48/3058550945/469191/73e96366/57eb5da7Ndddccfb4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11800/292/1301524104/473985/93c9dbca/5a004b74N6900711b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t5947/298/2358166126/460606/16748b95/593e107fN3e25400c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t6202/128/344208188/465230/b9090cc9/593e107cN40ce82d4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3196/79/3071766575/389476/c18ca9fd/57eb5da9N50f2b4b5.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3073/185/3049704687/294848/675b36a/57eb5da9Nc2ad3cff.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t6070/274/2271600543/341869/fed56bbd/593e10edNbc8ed14d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3082/251/2977126462/351654/2a1553b9/57eb5da9Nfc8bcb2f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t6034/257/1185100280/141992/27025cd/59310a52N88583d94.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3205/36/3033630144/321916/bd5425fe/57eb5dabNee4672fd.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11821/277/1354401122/412308/4b93dfad/5a004b74Ne32c2bfb.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16366/244/180407266/365032/c6e5ac01/5a2a2883Nb0af220e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3115/93/3052472302/291213/bdb2ad1a/57eb5dacN235f3da1.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3058/82/3043232431/314310/dd1c275/57eb5dadN47e9e862.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16540/90/2134159055/435906/e067511f/5a936e99Nd0d6a57a.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15187/17/2279947008/561577/ddbe97dd/5a936e99Nf357ffe9.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t13768/169/2538674463/198139/4d63f0b0/5a936e99N8e2bccbe.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17842/175/518918441/434857/bd6284ce/5a936e99N77d6b76f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19549/112/519674447/533790/93b1f946/5a936e99N4e91c734.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18466/33/518836434/479772/43846e19/5a936e99Nf667596c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15955/35/2126897514/417828/fc1eaf4d/5a936e9aNb9c12d6f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15250/237/2326877649/232192/af0bb20e/5a936e9aN180d64e0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16909/180/517728952/182370/f4d0b4bf/5a936e9aN85176d2d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16915/70/535886345/233821/f36b6ffe/5a936e9aN1e43d078.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18466/33/518836434/479772/43846e19/5a936e99Nf667596c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15955/35/2126897514/417828/fc1eaf4d/5a936e9aNb9c12d6f.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15250/237/2326877649/232192/af0bb20e/5a936e9aN180d64e0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16909/180/517728952/182370/f4d0b4bf/5a936e9aN85176d2d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t16915/70/535886345/233821/f36b6ffe/5a936e9aN1e43d078.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t19459/21/515933906/171006/f588c037/5a936e9aN8eb64079.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17974/55/531774385/209817/15652e3f/5a936e9aN20d04499.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17008/76/541917403/226671/e73880db/5a936e9aN9ea6803d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15952/295/2171790031/721839/c607fd81/5a936e9aN815f318b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17761/174/511145686/216147/9767e101/5a936e9aN5a0e3485.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15007/16/2292570981/668848/f8c1af48/5a936e9aNa967286c.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t18307/178/529724705/631154/29d288ba/5a936e9aNcf252782.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t15946/205/2150362298/742625/e4cb3c66/5a936e9aN16455554.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t17914/181/533449943/440428/b8d97660/5a936e9bN4cf08cc1.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4402/37/4431687061/101289/22156bd2/590d9d9eN1e09714d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3934/285/1559571285/168940/a8ff47e6/587ee2d0Na9d6f7f0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t9811/140/1731413562/171816/bda500f3/59e5a795N1d6cc70d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t11167/347/10820418/154799/86fa49f3/59e5a795N470dd352.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4219/349/1917700789/374084/494565a2/58c8a05eNe76d0834.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3175/149/5772482360/356666/a13091aa/587ee2d2N14f9c83a.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4510/158/2139862959/180739/d937cba9/58eb4386N4bfe8412.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t17086/354/437744941/133732/1afef922/5a7aaa99N5e6ecc6d.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t16057/271/1980793152/59752/f0273576/5a7aaa99Ne7f37530.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t16525/4/2008271113/310136/ea475e1a/5a7aaa99Naf6042cd.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t19708/339/450502789/155828/99d7da29/5a7aaa99Nf0e4cb6a.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t15397/173/2192083092/217749/4b068ecc/5a7aaa99Ncb8c1dda.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t16783/334/435624046/177981/7b5ad534/5a7aaa99Nb7a92dbb.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t19321/271/426226331/203789/12e99151/5a7aaa9aNd710b483.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t13237/177/1774092710/96301/996f0a/5a7aaa9aNffca69c9.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/389d2a8ffca370060f2e5022669f2e9b.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,0,1,16,0.00,'','',0,'/public/upload/goods/2018/04-17/bb4ab934927b26e06820383191b61f27.mp4'),(196,198,0,'TP0000196','花花公子短袖t恤男棉质翻领半袖衫中年男士打底衫夏季男装Polo衫 正品保证 支持扫描验货 包邮',14,0,3996,0,1,1.0000,299.00,199.00,0.00,'','','花花公子短袖t恤男棉质翻领半袖衫中年男士打底衫夏季男装Polo衫\r\n正品保证 支持扫描验货 包邮','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2069197505/TB2TqzPX5CYBuNkSnaVXXcMsVXa_!!2069197505.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2069197505/TB2UqDCXYZnBKNjSZFrXXaRLFXa_!!2069197505.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2069197505/TB2XMlqbQOWBuNjSsppXXXPgpXa_!!2069197505.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2069197505/TB2dFJhbFmWBuNjSspdXXbugXXa_!!2069197505.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/2cc4e3f1b7ae838c584c17b0d79e310a.jpg',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,1,0,0,0,1,1,0,0.00,'','',0,''),(197,292,0,'6086','迪豪灯饰 欧式水晶吊灯奢华客厅灯现代简欧卧室灯锌合金大气别墅复式楼美式餐厅led灯具套餐 金枝玉叶B款15头（包安装带三色光源+底锅发光款）',6,0,101,0,13000,0.0000,2599.00,2198.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t10474/172/1771716393/475750/e5d25d47/59e6bd73N46c60b58.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7873/8/2729666147/325921/64949797/59e6bd69N3e84f25b.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7612/245/3517775833/372945/7878346d/59e6bd60Nda0114d7.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7705/110/2806990550/377844/ed0e2651/59e6bd67N343525e4.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11764/37/203139589/556165/ccd271a7/59ea1296N74d764c6.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7729/120/3131466984/493409/6eaf9f87/59e6bd5cNcfecab6b.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t10606/297/1728016754/463435/f93e0196/59e6bd7eNd5e35f79.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t10078/296/1764275997/507761/3350cde5/59e6bd79Nebfbf1ae.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9733/304/1783518149/412269/e7aa5702/59e6bd82N24731b87.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7270/44/3079703692/448079/80bd9adc/59e6bd82N5a58e855.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11449/336/233982499/412440/f6b7e238/59ea0ed5Ncb701792.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9808/254/1956976833/504263/2d75ebea/59ea0ec4N19cc2ec8.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t12946/124/2193628902/465130/804bcf03/5a371e82N62a98f64.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t10783/177/1950161280/306543/71314f87/59ea0f04N73f6f5db.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t9598/54/1957486910/307991/fba99c01/59ea0f0dNe86b4236.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t11182/166/210007255/322316/58762318/59ea0f17Nb1e57a8f.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t15871/235/1182069698/397757/567c61f7/5a4c38cdNfe37d85e.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t11140/222/57448568/400362/ea71f793/59e6bd86N75bdcd1d.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7294/55/3150927808/245230/9eff171/59e6bd81N33a5f75e.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7720/104/2884212164/747812/7f613cba/59e855f3N9c432fc3.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t9829/344/1857565236/289524/30af7b48/59e85857N523827b4.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/1f06e0613e7d149b2c171b57b0564f4c.png',0,-28800,0,1,0,0,0,0,1,50,1,0,1,0,0,0,0,0,-1,0,0,0.00,'','',0,'/public/upload/goods/2018/04-17/a2fa74a90fa46aee124d621609a01d98.mp4'),(198,536,0,'TP0000198','全国送花深圳生日鲜花速递同城北京上海红玫瑰花束广州杭州成都店 中礼鲜花 20年老品牌 值得信赖',4,0,98,0,110,11.0000,98.00,78.00,0.00,'','','全国送花深圳生日鲜花速递同城北京上海红玫瑰花束广州杭州成都店\r\n中礼鲜花 20年老品牌 值得信赖','&lt;p&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i2/89365102/TB2_4BAmz3z9KJjy0FmXXXiwXXa_!!89365102.jpg&quot;/&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i4/89365102/TB2TWlljjnD8KJjSspbXXbbEXXa_!!89365102.jpg&quot;/&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i2/89365102/TB2P7lojfDH8KJjy1XcXXcpdXXa_!!89365102.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/244ac3b4fc3f1fe6ae4055345bf11f9f.jpg',0,-28800,0,1,0,0,0,0,1,50,1,0,0,0,0,100,0,0,2,0,0,0.00,'','',0,''),(199,427,0,'TP0000199','送醒酒器法国原瓶进口红酒路易拉菲干红葡萄酒6支整箱装送礼红酒 送红酒杯 送醒酒器开瓶器酒塞',17,0,92,1,0,0.0000,398.00,298.00,0.00,'','','送醒酒器法国原瓶进口红酒路易拉菲干红葡萄酒6支整箱装送礼红酒\r\n送红酒杯 送醒酒器开瓶器酒塞','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1915468652/TB2OULucmFjpuFjSspbXXXagVXa_!!1915468652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1915468652/TB2SAYwcl0kpuFjSsppXXcGTXXa_!!1915468652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1915468652/TB26FblcmBjpuFjSsplXXa5MVXa_!!1915468652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1915468652/TB2PKawspXXXXc4XpXXXXXXXXXX_!!1915468652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1915468652/TB294yZspXXXXXVXpXXXXXXXXXX_!!1915468652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1915468652/TB2qHVatVXXXXbhXpXXXXXXXXXX_!!1915468652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1915468652/TB2ujCJg9BjpuFjSsplXXa5MVXa_!!1915468652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1915468652/TB2JQs2tFXXXXbDXpXXXXXXXXXX_!!1915468652.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/6c98d6cb66963aaa116b6449e0f966c3.jpg',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,3,10000,0,5,8,0,0,0.00,'','',0,'/public/upload/goods/2018/04-17/1c821c34ab32f7b8c17e2b658726966c.mp4'),(200,315,0,'910客厅两件套','俪莎公馆 电视柜 欧式电视柜茶几组合套装客厅简约大理石电视柜地柜家具 (红龙玉大理石) 套餐二电视柜2.2m+茶几1.35m',2,0,198,0,100000,0.0000,3988.00,3080.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2656/210/3221676307/704107/89c63f6c/57849d30N697b0f49.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2650/181/3207411505/516087/73f6e6ff/57849d31N912c3ee8.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2155/359/28891822/806622/dbc0c63f/55e7dce9N86efcd1d.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t1867/359/27997842/762882/7f51ddb6/55e7dcebNaa0a0a3b.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2005/286/31664140/930896/98711e81/55e7dcedN416c8db8.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2401/287/29039703/626691/f5fa1335/55e7dceeN4e328b63.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2092/360/31222416/666389/fa7a0b5b/55e7dcf0Nd76e6b28.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t7888/359/2495026263/925369/b99b4e4a/59af73b1Na393d933.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2929/194/1488766405/857325/6f3c2f87/57849d34N05f10221.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2152/231/28352505/389889/c3d89bdb/55e7dfc6N6e922470.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2155/140/27840186/191591/caa7c951/55e7e41fN6a2acc7e.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2689/292/3185759163/726238/9af32d36/57849664Nc9b6b1d0.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t1963/241/518022784/385065/be8aae4c/56126242N957e815b.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7957/320/365575495/580608/2c8ebbf7/59926d02Nef12729b.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t12646/27/738762654/1047900/dc64310d/5a12a097N910289f0.jpg?t=1511170233123&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7981/305/1598838167/423845/b20a4c2b/599e3e7bN61d7a452.jpg?t=1503542911032&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7534/328/1609330628/220929/3d3083a6/599e3e92Nad6a5afd.jpg?t=1503542911032&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7888/227/1552884722/454357/a87be330/599e3e8dNd22e1471.jpg?t=1503542911032&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t7753/298/1612675718/533599/855c302/599e3e81N3a74c68c.jpg?t=1503542911032&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t19591/54/1489077493/505377/bb1c597e/5acb10c4N1832d2d4.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/6f990ffb7e830a808a76c6abbb2cdf72.png',0,-28800,0,1,0,0,0,0,1,50,0,1,1,0,0,0,0,0,2,0,0,0.00,'','',0,''),(201,351,0,'1TE55GLTCNEB','海信（Hisense）LED55E7C 55英寸 超高清4K 曲面电视 HDR 丰富影视教育资源',0,0,300,0,25300,0.0000,3799.00,3499.00,0.00,'','','','',NULL,'/public/upload/goods/2018/04-17/4fc8ad57adb34c65367dc0feb8249d36.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,0,0,0,0.00,'','',0,''),(202,372,0,'TP0000202','西门子 (SIEMENS) 8公斤 变频 滚筒洗衣机 缓震降噪 筒清洁 加漂洗',7,0,299,1,75000,0.0000,4129.00,3699.00,0.00,'','','','',NULL,'/public/upload/goods/2018/04-17/dbfed9f415847891c304de81ce5e51be.png',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,0,0,0,1,0,0,0.00,'','',0,''),(203,536,0,'TP0000203','鲜花礼盒花束速递红玫瑰北京同城鲜花上海送花南京广州鲜花店杭州 手机购更优惠 6年老店 指定日期送',27,0,89,0,0,0.0000,108.00,108.00,0.00,'','','鲜花礼盒花束速递红玫瑰北京同城鲜花上海送花南京广州鲜花店杭州\r\n手机购更优惠 6年老店 指定日期送','&lt;h1 style=&quot;margin: 0px; padding: 0px 0px 0.2em; font-size: 16px; font-family: &amp;quot;microsoft yahei&amp;quot;; line-height: 1; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;鲜花礼盒花束速递红玫瑰北京同城鲜花上海送花南京广州鲜花店杭州&lt;/h1&gt;&lt;p class=&quot;newp&quot; style=&quot;margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(255, 0, 54); font-family: &amp;quot;microsoft yahei&amp;quot;; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;手机购更优惠 6年老店 指定日期送&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i1/724285898/TB2oO2NeFXXXXaFXXXXXXXXXXXX_!!724285898.jpg&quot;/&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i1/724285898/TB2AKYxeFXXXXaxXpXXXXXXXXXX_!!724285898.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/724285898/TB2JPmMjFXXXXaiXXXXXXXXXXXX_!!724285898.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/724285898/TB2mBuFjFXXXXb4XXXXXXXXXXXX_!!724285898.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/724285898/TB2jzuEjFXXXXbSXXXXXXXXXXXX_!!724285898.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/724285898/TB2wm1njFXXXXa6XpXXXXXXXXXX_!!724285898.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/724285898/TB2NwSEjFXXXXb2XXXXXXXXXXXX_!!724285898.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/724285898/TB2UjWxjFXXXXXbXpXXXXXXXXXX_!!724285898.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/724285898/TB2rhmEjFXXXXb5XXXXXXXXXXXX_!!724285898.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/724285898/TB2DmywjFXXXXXyXpXXXXXXXXXX_!!724285898.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/724285898/TB2HAucjFXXXXc4XpXXXXXXXXXX_!!724285898.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/db7567e7d449773d4e8bbf750d083916.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,100,0,0,11,4,0,0.00,'','',0,'/public/upload/goods/2018/04-17/d9fd7c1cd0002dfd573de2235557d73f.mp4'),(204,376,0,'TP0000204','海尔（Haier)6公斤干衣机 大烘干量 GDZE6-1W',9,0,497,2,35000,0.0000,1699.00,1399.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5593/11/2886201171/206203/c3e5df91/59356080Nd56e1f81.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5899/104/2859350614/295921/71266799/593526a4N81e96980.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5869/105/2879268569/300112/84ca2707/593526a4N1caeb887.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5893/28/2908657069/289868/511834aa/593526a5N26c1f18b.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t6004/252/1625582618/296711/12a37c/593526a4Nde1a687e.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5617/365/2943722847/300958/b90b9c4c/593526a5Nd721ae0b.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5890/214/2953128492/192446/7307c8c9/593526a5N1fe67ef3.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5713/63/2908050057/301653/3d6c9a0b/593526a5N79b4c9b6.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5794/254/2902262635/299026/4f16d9c1/593526a5N9fa0d907.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5647/25/2889807080/218041/b9707027/593526abNa2703e30.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5992/157/1739295623/189458/a5a3170d/593526acN1368c896.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5683/17/2960098902/294237/2a2f2c1a/593526acNa279f044.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t6130/360/1619591722/93989/46f2053e/593526acNeb57c67b.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5725/117/2893526965/175199/44b1e1c3/5935596dN0a5e8336.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t6067/292/1613396004/143090/ecff6c23/593526adNc37d7249.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5779/165/2870020663/291293/23cdd755/593526adNa5c2c5c1.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5839/124/2945034983/201070/4e299282/593526adN868b533a.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/267c58bb03bb1a6db0f97dae53903e88.png',0,-28800,0,1,0,0,0,1,1,50,1,0,1,0,0,0,0,0,3,4,0,0.00,'','',0,''),(205,344,0,'TP0000205','格力(GREE) 3匹 变频 Q铂 立柜式冷暖空调 KFR-72LW/(72596)FNAa-A3',3,0,300,0,60000,0.0000,7899.00,6299.00,0.00,'','','','&lt;table width=&quot;750&quot; align=&quot;center&quot;&gt;&lt;tbody&gt;&lt;tr class=&quot;firstRow&quot;&gt;&lt;td&gt;&lt;center&gt;&lt;img alt=&quot;&quot; width=&quot;750&quot; height=&quot;420&quot; class=&quot;&quot; src=&quot;https://img14.360buyimg.com/cms/jfs/t3271/234/2558304912/90405/b6e840c3/57e33bb6Nbac21614.jpg&quot;/&gt;&lt;/center&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;p&gt;&lt;area shape=&quot;rect&quot; coords=&quot;521,380,714,460&quot; href=&quot;https://help.jd.com/user/issue/239-275.html&quot;/&gt;&lt;area shape=&quot;rect&quot; coords=&quot;74,341,280,381&quot; href=&quot;https://help.jd.com/user/issue/239-295.html&quot;/&gt;&lt;area shape=&quot;rect&quot; coords=&quot;394,340,676,380&quot; href=&quot;https://help.jd.com/user/issue/239-294.html&quot;/&gt;&lt;/p&gt;&lt;table width=&quot;750&quot; align=&quot;center&quot;&gt;&lt;tbody&gt;&lt;tr class=&quot;firstRow&quot;&gt;&lt;td style=&quot;word-break: break-all;&quot;&gt;&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/jgsq-productsoa/jfs/t3130/151/6064668418/19590/ea903bd9/58996413N41675815.jpg&quot;/&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;span class=&quot;ssd-widget-heading-ch W146976186860330&quot; style=&quot;margin: 0px 6px 0px 15px; padding: 0px; float: left; display: inline-block; height: 30px; line-height: 30px; color: rgb(255, 255, 255); font-size: 16px; background-color: transparent; font-family: &amp;quot;microsoft yahei&amp;quot;;&quot;&gt;产品功能&lt;/span&gt;&lt;span class=&quot;ssd-widget-heading-en W146976186860431&quot; style=&quot;margin: 0px 15px 0px 6px; padding: 0px; float: left; display: inline-block; height: 30px; line-height: 30px; color: rgb(255, 255, 255); font-size: 14px; background-color: transparent; font-family: &amp;quot;microsoft yahei&amp;quot;;&quot;&gt;Product Function&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span class=&quot;ssd-widget-heading-ch W150112468979411&quot; style=&quot;margin: 0px 6px 0px 15px; padding: 0px; float: left; display: inline-block; height: 30px; line-height: 30px; letter-spacing: 0px; color: rgb(255, 255, 255); font-size: 16px; background-color: transparent; font-family: &amp;quot;microsoft yahei&amp;quot;;&quot;&gt;产品细节&lt;/span&gt;&lt;span class=&quot;ssd-widget-heading-en W150112468979412&quot; style=&quot;margin: 0px 15px 0px 6px; padding: 0px; float: left; display: inline-block; height: 30px; line-height: 30px; letter-spacing: 0px; color: rgb(255, 255, 255); font-size: 14px; background-color: transparent; font-family: &amp;quot;microsoft yahei&amp;quot;;&quot;&gt;Product Details&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span class=&quot;ssd-widget-heading-ch W150112510571513I0&quot; style=&quot;margin: 0px 6px 0px 15px; padding: 0px; float: left; display: inline-block; height: 30px; line-height: 30px; letter-spacing: 0px; color: rgb(255, 255, 255); font-size: 16px; background-color: transparent; font-family: &amp;quot;microsoft yahei&amp;quot;;&quot;&gt;收费标准&lt;/span&gt;&lt;span class=&quot;ssd-widget-heading-en W150112510571513I1&quot; style=&quot;margin: 0px 15px 0px 6px; padding: 0px; float: left; display: inline-block; height: 30px; line-height: 30px; letter-spacing: 0px; color: rgb(255, 255, 255); font-size: 14px; background-color: transparent; font-family: &amp;quot;microsoft yahei&amp;quot;;&quot;&gt;Charging standards&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;img width=&quot;750&quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/jgsq-productsoa/jfs/t16033/26/2203677933/65528/e3120135/5a9c081dN6f7923c3.jpg&quot;/&gt;&lt;img width=&quot;750&quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/jgsq-productsoa/jfs/t18508/211/631607696/42405/c456809/5a9c083eNf4cb98ba.jpg&quot;/&gt;&lt;img width=&quot;750&quot; height=&quot;350&quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/cms/jfs/t6049/132/6861564372/77197/d0f8f193/5976ebafN1e64b2fa.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/2f121475f02e3028b423473c0777e08d.png',0,-28800,0,1,0,0,0,1,1,50,0,1,1,0,0,0,0,0,0,2,3,0.00,'','',0,''),(206,381,0,'TP0000206','TCL 118升 小型双门电冰箱 LED照明 迷你节能 办公居家便捷之选 环保内胆 （芭蕾白）BCD-118KA9',17,0,499,0,35000,0.0000,1099.00,769.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img14.360buyimg.com/cms/jfs/t4480/305/1093140715/113826/a38d7df8/58d87fafN1a839045.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/cms/jfs/t3097/72/9803724585/87024/8acd25de/58d8721eN42963ff5.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img13.360buyimg.com/cms/jfs/t3304/286/9711702445/129159/77c602d1/58d8721eNf8089471.gif&quot;/&gt;&lt;img src=&quot;https://img13.360buyimg.com/cms/jfs/t4267/201/2953876680/59578/4d73460/58d87220N032ac299.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/cms/jfs/t4603/19/1065722194/72808/453fa1ea/58d87227N0c3dd75c.gif&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/cms/jfs/t3166/28/9780799453/40100/c5c42141/58d8722eN3540eebc.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/cms/jfs/t4660/3/1080401682/57177/ff3048ad/58d87230Nb4a0fd5d.gif&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/cms/jfs/t4330/225/2979085243/224775/34cdde64/58d8a658N01848c54.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/cms/jfs/t4315/19/2906536815/74883/eb6667e/58d87237Ncc8777cd.jpg&quot;/&gt;&lt;img src=&quot;https://img11.360buyimg.com/cms/jfs/t4186/148/3000911885/104655/bb448ad9/58d8850dNf326456f.jpg&quot;/&gt;&lt;img src=&quot;https://img11.360buyimg.com/cms/jfs/t4363/335/2954887819/94407/50305c42/58d87237Nb9d810ec.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/cms/jfs/t4246/161/2958510319/103360/481d50bc/58d87239Nd82105f9.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/cms/jfs/t4714/60/1053785285/119679/c873b9b1/58d8723aN5cc96f76.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/cms/jfs/t4594/283/1081323806/202279/4e66fb26/58d8a660Nb34b2e43.jpg&quot;/&gt;&lt;img src=&quot;https://img11.360buyimg.com/cms/jfs/t4486/13/1109196102/76463/af8ea41f/58d8723dN3f5f91b9.jpg&quot;/&gt;&lt;img src=&quot;https://img13.360buyimg.com/cms/jfs/t4504/268/1105343906/181650/b26248ab/58d8a661N5e7d7b0b.jpg&quot;/&gt;&lt;img src=&quot;https://img14.360buyimg.com/cms/jfs/t4435/115/1080102348/73096/a95b5e5f/58d87251N1209d4c6.jpg&quot;/&gt;&lt;img src=&quot;https://img11.360buyimg.com/cms/jfs/t4204/211/2971239967/54970/5abd6ddb/58d8724eN26934169.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/cms/jfs/t4162/108/2938608647/266678/407bdd54/58d877d7Nf6069276.jpg&quot;/&gt;&lt;img src=&quot;https://img13.360buyimg.com/cms/jfs/t3133/338/9739322969/277554/ce4a092d/58d877d7N0b1d05fc.jpg&quot;/&gt;&lt;img src=&quot;https://img13.360buyimg.com/cms/jfs/t5698/10/8235537347/165580/c1554117/597942abN25b8f71f.jpg&quot;/&gt;&lt;img src=&quot;https://img12.360buyimg.com/cms/jfs/t4255/84/3011360879/201780/3d642320/58d877d3Nfa63f168.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/4e5e1d5541ea1c9e33bd7e0717d551ec.png',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,0,0,0,1,3,60,0.00,'','',0,''),(207,382,0,'TP0000207','美的(Midea)220升 家用商用冰柜 双箱双温冷柜 蝶形门侧掀门 化冻包赔',8,0,199,0,49000,0.0000,1369.00,1299.00,0.00,'','','','',NULL,'/public/upload/goods/2018/04-17/1bb4944acb3b0ac5a70aa0ed23f99aa2.png',0,-28800,0,1,0,0,0,0,1,50,1,0,1,0,0,0,0,0,1,0,0,0.00,'','',0,''),(208,386,0,'TP0000208','苏泊尔（SUPOR）电饭煲电饭锅4L容量 精铁球釜IH电磁加热CFXB40HC817-120',10,0,346,0,6600,0.0000,799.00,599.00,0.00,'','','','',NULL,'/public/upload/goods/2018/04-17/60bad6aadfa8e4d624877c6e76f2ab9a.png',0,-28800,0,1,0,0,0,0,1,50,0,1,1,0,0,0,0,0,14,0,0,0.00,'','',0,'/public/upload/goods/2018/04-17/86721877ffa7ada44609ff8281667c1c.mp4'),(209,389,0,'TP0000209','九阳（Joyoung）豆浆机破壁免滤预约1300ml家用全自动多功能DJ13E-Q1',2,0,297,0,3300,0.0000,699.00,499.00,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t3562/246/624824915/300950/86f8a25c/580eca29N0e505ef1.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t3919/24/2594579919/53108/3e7975e8/58d24abcN6c2ab716.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2752/47/1088364823/246137/4bdc4139/57342d8bN290c5d80.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t3709/29/2003775093/185897/7a9b9c2/583d2260Nef881414.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2770/326/2203223024/283572/ed853b7b/575e54a9Nf1307d61.gif&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2716/49/1090922520/301247/84feb033/57342d80N73985cf3.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2599/259/1084704912/212898/920f5c8e/57342df0N44a11cd5.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2596/294/1085097030/168300/e63a6cec/57342dfbN6e3a213c.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2680/248/1101896223/110258/31e038f2/57342df5Na9358c46.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t3922/175/831794257/64341/6855192d/58b902efN05a2865c.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2599/57/1137677221/167110/9ed3d117/57342e35Nd023749d.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t4363/192/760801412/191187/a5864ebf/58b90301N071dbc2f.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t1015/118/1540942552/305020/280e8074/57302dbbN3730cec5.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t3802/303/355533289/250992/d6c28f00/580742afN6519c1d8.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t4207/163/769770182/132373/652a4ad1/58b9030cN97d3d3be.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t5629/212/1114146763/328106/cf87949b/5923ed8eN27a0e0ab.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t3610/148/1462545403/176634/7eb0fab8/58295eecN46e5d944.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t1057/280/1499864712/165812/4f6e8c7b/57302e07N1a8837fe.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t2761/62/1067726135/226217/9f7130e7/57342ec5N0c1527f7.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t3670/140/1536155351/184717/3001c2dc/58295ef3N688862a2.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/bbdfc5edb8136e6a9a1aac5cb7e4996f.png',0,-28800,0,1,0,0,0,1,1,50,1,1,0,0,0,0,0,0,3,3,68,0.00,'','',0,'/public/upload/goods/2018/04-17/c93a20ced684925c1c8012288193f63f.mp4'),(210,76,0,'TP0000210','苹果7钢化膜iphone8plus手机7plus全屏全覆盖8贴膜水凝7p抗蓝光3D',23,0,80,0,10,0.0000,14.38,13.80,0.00,'','','苹果7钢化膜iphone8plus手机7plus全屏全覆盖8贴膜水凝7p抗蓝光3D','&lt;h1 style=&quot;margin: 0px; padding: 0px 0px 0.2em; font-size: 16px; font-family: &amp;quot;microsoft yahei&amp;quot;; line-height: 1; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;苹果7钢化膜iphone8plus手机7plus全屏全覆盖8贴膜水凝7p抗蓝光3D&lt;/h1&gt;&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2024058652/TB2N5HVdkfb_uJkSnb4XXXCrXXa_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2024058652/TB2xS1BbUlnpuFjSZFjXXXTaVXa_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2024058652/TB2U7vnh3vD8KJjSsplXXaIEFXa_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2024058652/TB2y0s1qFXXXXbYXXXXXXXXXXXX_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2024058652/TB2HazofXXXXXa9XpXXXXXXXXXX-2024058652.gif&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2024058652/TB28znAfXXXXXc6XXXXXXXXXXXX-2024058652.gif&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2024058652/TB2l_Z3lVXXXXcEXpXXXXXXXXXX_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2024058652/TB2uAKsg2BNTKJjSszeXXcu2VXa_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2024058652/TB2Am76rFXXXXcCXpXXXXXXXXXX_!!2024058652.gif&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2024058652/TB2zFPibdRopuFjSZFtXXcanpXa_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2024058652/TB2BYVshPuhSKJjSspjXXci8VXa_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2024058652/TB22KGplHsTMeJjSszgXXacpFXa_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2024058652/TB2Wrw8hzihSKJjy0FiXXcuiFXa_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2024058652/TB2C.bvaM0kpuFjSspdXXX4YXXa_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2024058652/TB2A74phPihSKJjy0FlXXadEXXa_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2024058652/TB242K6g2BNTKJjy0FdXXcPpVXa_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2024058652/TB2cxHGqVXXXXajXpXXXXXXXXXX_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2024058652/TB2JmAiqVXXXXamXXXXXXXXXXXX_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2024058652/TB2R2hdmXXXXXa0XpXXXXXXXXXX_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2024058652/TB2hNjVqVXXXXc2XXXXXXXXXXXX_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2024058652/TB2yTFKmXXXXXbaXXXXXXXXXXXX_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2024058652/TB2lNxdcY5YBuNjSspoXXbeNFXa_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2024058652/TB2UUSZapooBKNjSZFPXXXa2XXa_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2024058652/TB2ZxNmc49YBuNjy0FfXXXIsVXa_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2024058652/TB25JCIc9BYBeNjy0FeXXbnmFXa_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2024058652/TB2fvk_cFOWBuNjy0FiXXXFxVXa_!!2024058652.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2024058652/TB25LNfuUlnpuFjSZFjXXXTaVXa_!!2024058652.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/e5ed1c25936b66d0df15d0daa29ceab9.jpg',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,0,100,0,0,20,0,0,0.00,'','',0,'/public/upload/goods/2018/04-17/3c86bff10035eeff661d4f792a1b6e92.mp4'),(211,409,0,'TP0000211','绿鲜知 鲜香椿 香椿芽 约150g 新鲜蔬菜',6,0,293,0,150,0.0000,26.00,23.90,0.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t4345/187/393760948/206961/6af284b6/58b4054cNda2041ac.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t4375/191/396245205/201122/9f0916f8/58b40555N08694de9.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t3244/63/7237895946/143085/dd1e433d/58b4055cN44993ecb.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t3217/207/7333874305/180802/c60da06f/58b40564Nf964b61f.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t4192/189/397585226/287892/2ea11bda/58b4056cNb0c09f31.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t4219/215/402221454/218750/a0d2369c/58b40573Nefa8c144.jpg&quot;/&gt;&lt;img src=&quot;https://img20.360buyimg.com/vc/jfs/t3073/261/7317940221/294985/6b639f5d/58b4057bNe331a172.jpg&quot;/&gt;&lt;img src=&quot;https://img30.360buyimg.com/jgsq-productsoa/jfs/t3781/341/2037386522/116108/c60f3314/583d7c6aN9865f949.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/7f82b93ea2760e7047caec5a898d5a95.png',0,-28800,0,1,0,0,0,1,1,50,1,0,0,0,0,0,0,0,7,2,6,0.00,'','',0,''),(212,444,0,'TP0000212','Daphne/达芙妮正品女鞋 春新款羊皮浅口圆头中跟职业工作鞋女单鞋 1016101087',29,0,886,1,0,0.0000,89.00,65.00,0.00,'','','Daphne/达芙妮正品女鞋 春新款羊皮浅口圆头中跟职业工作鞋女单鞋\r\n1016101087','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1715171039/TB2W6dUk0nJ8KJjSszdXXaxuFXa_!!1715171039.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1715171039/TB2oJs0kJzJ8KJjSspkXXbF7VXa_!!1715171039.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1715171039/TB277mXk_nI8KJjy0FfXXcdoVXa_!!1715171039.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1715171039/TB2Oj71kN6I8KJjSszfXXaZVXXa_!!1715171039.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1715171039/TB28x89kYYI8KJjy0FaXXbAiVXa_!!1715171039.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1715171039/TB2W6dUk0nJ8KJjSszdXXaxuFXa_!!1715171039.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1715171039/TB2fitFk8DH8KJjy1zeXXXjepXa_!!1715171039.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1715171039/TB2dQ8ek8HH8KJjy0FbXXcqlpXa_!!1715171039.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-17/a926e8f97d5499f952a4e943b503f74d.jpg',0,-28800,0,1,0,0,0,1,1,50,0,1,0,0,7,0,0,0,12,2,0,0.00,'','',0,''),(214,15,0,'TP0000214','抢购活动待运费',15,0,271,0,200,6.0000,199.00,99.00,20.00,'','运费','123456','&lt;p&gt;啦啦啦啦啦啦啦&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-18/922b3fabc508efe0cdd6580f66d8b5c9.png',0,-28800,0,1,0,0,0,1,1,50,0,0,0,0,1,0,0,1,5,6,0,0.00,'','',5,'/public/upload/goods/2018/04-18/20ed3f26930b7a1e24b20b0f50315224.mp4'),(215,172,0,'TP0000215','团购活动运费',9,0,137,0,200,6.0000,199.00,79.00,0.00,'','6555','123446666','&lt;p&gt;5666&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-18/bf089b23d8eedc0fa3a5991bdf5f368c.png',0,-28800,0,1,0,0,0,1,1,50,0,0,0,0,2,0,0,1,2,6,0,0.00,'','',4,'/public/upload/goods/2018/04-18/c00e1053fe9a535c2ace759d6dbaf6db.mp4'),(217,95,0,'TP0000217','多版本多规格苹果电脑',9,0,899,0,1500,2.0000,7799.00,7788.00,252.00,'','','','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1669409267/TB25cz3kwvD8KJjSsplXXaIEFXa_!!1669409267.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1669409267/TB2B6Y5knnI8KJjy0FfXXcdoVXa_!!1669409267.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1669409267/TB2Zt50kh6I8KJjSszfXXaZVXXa_!!1669409267.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1669409267/TB2UF6bklHH8KJjy0FbXXcqlpXa_!!1669409267.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1669409267/TB2EoO3kdfJ8KJjy0FeXXXKEXXa_!!1669409267.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1669409267/TB2cx6mkgnH8KJjSspcXXb3QFXa_!!1669409267.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1669409267/TB2hQ5adJHO8KJjSZFtXXchfXXa_!!1669409267.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1669409267/TB2hQ5adJHO8KJjSZFtXXchfXXa_!!1669409267.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1669409267/TB2epTJkjnD8KJjSspbXXbbEXXa_!!1669409267.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1669409267/TB2dCDVknvI8KJjSspjXXcgjXXa_!!1669409267.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-19/ba296804ed2a002d3a7fff2ae9684183.jpg',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,5,250,0,0,1,4,0,25.00,'','',5,''),(216,14,0,'TP0000216','属性123',25,0,220,0,200,6.0000,199.00,79.00,78.00,'','4334','','&lt;p&gt;123455&lt;/p&gt;&lt;p&gt;123455&lt;/p&gt;&lt;p&gt;123455&lt;/p&gt;&lt;p&gt;123455&lt;/p&gt;&lt;p&gt;123455&lt;/p&gt;&lt;p&gt;123455&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-18/3c3027bd9623757873950a3cbe4641a6.png',0,-28800,0,1,0,0,0,0,1,50,0,0,0,0,1,0,0,1,18,0,0,0.00,'','',6,'/public/upload/goods/2018/04-18/223020916fc3867098972f04f86067c7.mp4'),(225,14,0,'TP0000225','多规格衣服',22,0,993,1,0,0.0000,600.00,598.00,0.00,'[{\"amount\":3,\"price\":568},{\"amount\":4,\"price\":558},{\"amount\":5,\"price\":548}]','','282822','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/420567757/TB2Doofc26TBKNjSZJiXXbKVFXa-420567757.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/420567757/TB2C.zCdnXYBeNkHFrdXXciuVXa-420567757.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/420567757/TB21RO1XoD.BuNjt_ioXXcKEFXa-420567757.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/420567757/TB20.kMlxSYBuNjSspjXXX73VXa-420567757.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/420567757/TB2eaZdlAOWBuNjSsppXXXPgpXa-420567757.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/420567757/TB2H8.slAyWBuNjy0FpXXassXXa-420567757.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/420567757/TB2MgtOlStYBeNjSspaXXaOOFXa-420567757.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/420567757/TB2knkclAOWBuNjSsppXXXPgpXa-420567757.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/420567757/TB2i_PhdlmWBuNkSndVXXcsApXa-420567757.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/420567757/TB2aMwJluuSBuNjy1XcXXcYjFXa-420567757.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-20/bb44155a3f066c305307a8e7844a5200.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,0,0,1,100,0,1,7,6,0,0.00,'','',3,''),(219,402,0,'TP0000219','零食大礼包',12,0,567,5,0,0.0000,199.00,89.00,0.00,'','','','&lt;p&gt;123123232323&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-19/fced3012c5693d1a87380ec1ea6cd32c.png',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,3,0,0,0,15,6,0,0.00,'','',3,''),(220,402,0,'TP0000220','好多多',11,0,1160,5,10,1.0000,35.00,29.90,0.00,'','','28522','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2046293456/TB2DKXvwR0lpuFjSszdXXcdxFXa_!!2046293456.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2046293456/TB2T1XvwR0lpuFjSszdXXcdxFXa_!!2046293456.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2046293456/TB2DKXvwR0lpuFjSszdXXcdxFXa_!!2046293456.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2046293456/TB2d.unwHRkpuFjSspmXXc.9XXa_!!2046293456.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2046293456/TB2iqnjnjihSKJjy0FlXXadEXXa_!!2046293456.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-19/42409986d627f6ad8deb459ae874b612.jpg',0,-28800,0,1,0,0,0,1,1,50,1,1,1,0,3,100,0,0,38,6,0,0.00,'','',3,''),(221,58,0,'TP0000221','COACH/蔻驰 女士单肩斜挎手提包57521 客邻尚品',20,0,196,1,0,0.0000,265.00,255.00,0.00,'[{\"amount\":3,\"price\":255},{\"amount\":4,\"price\":245},{\"amount\":5,\"price\":235}]','','COACH/蔻驰 女士单肩斜挎手提包57521\r\n客邻尚品','&lt;h1 style=&quot;margin: 0px; padding: 0px 0px 0.2em; font-size: 16px; font-family: &amp;quot;microsoft yahei&amp;quot;; line-height: 1; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;COACH/蔻驰 女士单肩斜挎手提包57521&lt;/h1&gt;&lt;p class=&quot;newp&quot; style=&quot;margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(255, 0, 54); font-family: &amp;quot;microsoft yahei&amp;quot;; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;客邻尚品&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2037432060/TB27DE7lcjI8KJjSsppXXXbyVXa_!!2037432060.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2037432060/TB2Pq37lgnH8KJjSspcXXb3QFXa_!!2037432060.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2037432060/TB2Pq37lgnH8KJjSspcXXb3QFXa_!!2037432060.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2037432060/TB2blpSlr_I8KJjy1XaXXbsxpXa_!!2037432060.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2037432060/TB2blpSlr_I8KJjy1XaXXbsxpXa_!!2037432060.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-20/f49f279feabb08730e051839d8cb2a9c.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,0,0,7,100,0,0,4,2,0,1.00,'','',3,''),(222,15,0,'TP0000222','Vero Moda2018春季新款吊带蕾丝中长款连衣裙|31816Z503 吊带，蕾丝，双层底摆，高腰',3,0,200,0,1,1.0000,699.00,599.00,11.00,'','','DDD','&lt;h1 style=&quot;margin: 0px; padding: 0px 0px 0.2em; font-size: 16px; font-family: &amp;quot;microsoft yahei&amp;quot;; line-height: 1; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;Vero Moda2018春季新款吊带蕾丝中长款连衣裙|31816Z503&lt;/h1&gt;&lt;p class=&quot;newp&quot; style=&quot;margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(255, 0, 54); font-family: &amp;quot;microsoft yahei&amp;quot;; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;吊带，蕾丝，双层底摆，高腰&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/420567757/TB220sadStYBeNjSspaXXaOOFXa-420567757.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/420567757/TB2Vj1CdFuWBuNjSspnXXX1NVXa-420567757.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/420567757/TB2mWEadSBYBeNjy0FeXXbnmFXa-420567757.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/420567757/TB24k6saPQnBKNjSZSgXXXHGXXa-420567757.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/420567757/TB2Ol9xdGSWBuNjSsrbXXa0mVXa-420567757.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/420567757/TB2Gi3caTqWBKNjSZFAXXanSpXa-420567757.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/420567757/TB2biEadStYBeNjSspkXXbU8VXa-420567757.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/420567757/TB2B.seaTqWBKNjSZFxXXcpLpXa-420567757.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-20/4b2a4a43960282e91a3f3c1efe97bf4e.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,0,0,1,100,0,1,0,2,0,11.00,'','',3,''),(224,571,0,'TP0000224','多规格鞋子',2,0,800,0,0,0.0000,599.00,589.00,0.00,'','','2852','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2999119381/TB252TtnYBmpuFjSZFAXXaQ0pXa-2999119381.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2999119381/TB2iW_Tc9XlpuFjy0FeXXcJbFXa_!!2999119381.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2933844383/TB2.LJDtFXXXXa3XXXXXXXXXXXX_!!2933844383.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-20/a1e7dba6487358f3c47c1f5e5f148f82.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,0,0,7,0,0,1,0,0,0,0.00,'','',3,''),(226,78,0,'TP0000226','预售限制地区',1,0,236,0,100,0.0000,200.00,199.00,0.00,'','','123444','&lt;p&gt;2323233&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-20/48227d0cc3a52b2dba4ee982d278fcdf.png',0,-28800,0,1,0,0,0,1,1,50,0,0,0,0,1,0,0,0,6,0,0,0.00,'','',4,'/public/upload/goods/2018/04-20/542962ad4bae838bec5c77b1e2ccd476.mp4'),(227,200,0,'TP0000227','地区限制',2,0,595,0,1,1.0000,358.00,258.00,100.00,'','111','三国杀','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1860270913/TB2h997a3wjyKJjy1zdXXbgZpXa_!!1860270913.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1860270913/TB2h997a3wjyKJjy1zdXXbgZpXa_!!1860270913.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1860270913/TB2UTjga7ZkyKJjy0FnXXXveFXa_!!1860270913.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1860270913/TB2UTjga7ZkyKJjy0FnXXXveFXa_!!1860270913.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1860270913/TB25PG7a7UkyKJjy1zjXXX1wFXa_!!1860270913.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-23/6a2cc994c8118b13ab542d33db4efe8f.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,0,0,7,100,0,0,5,6,0,10.00,'','',4,''),(228,15,0,'TP0000228','多规格衣服的的快递',17,3,395,0,0,0.0000,385.00,285.00,0.00,'','','多规格一个','&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/692195348/TB2x7C7aOMnBKNjSZFCXXX0KFXa_!!692195348.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/692195348/TB2dEEcdv9TBuNjy0FcXXbeiFXa_!!692195348.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/692195348/TB2FVMBdqmWBuNjy1XaXXXCbXXa_!!692195348.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/692195348/TB2V3Usdr5YBuNjSspoXXbeNFXa_!!692195348.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-24/d7958c786d790450adf7edd39a2b62de.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,0,0,1,0,0,0,3,0,0,100.00,'','',3,''),(229,360,0,'TP0000229','美女化妆品',54,0,0,3,0,0.0000,199.00,99.00,60.00,'','','美女化妆品','&lt;p&gt;美女化妆品&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-24/2e3d8924c1958f7c9d98bb60476b6bb1.png',0,0,0,1,0,0,0,1,1,50,0,0,0,0,6,0,0,1,21,0,0,0.00,'','',5,'/public/upload/goods/2018/04-24/cee6edb8993758ddc3b71a8d522c20fc.mp4'),(230,468,0,'TP0000230','稻草人(MEXICAN)男包男士单肩包头层牛皮竖款商务休闲单肩斜挎包小',11,0,97,0,0,0.0000,285.00,258.00,25.00,'[{\"amount\":3,\"price\":248},{\"amount\":4,\"price\":238}]','','稻草人(MEXICAN)男包男士单肩包头层牛皮竖款商务休闲单肩斜挎包小','&lt;p&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18790/209/704179234/290790/88823e4e/5aa0d2abNf6150346.jpg&quot;/&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t18901/229/698481718/206067/447f774a/5aa0d2abNdcc3fa41.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-26/d7053d928000ad92d6ac96fa42c8ddfe.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,0,0,7,100,0,0,3,0,0,11.00,'','',6,''),(231,91,0,'TP0000231','多规格电脑',2,0,898,0,11,11.0000,7900.00,6900.00,0.00,'','','多规格电脑','&lt;p&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/202748625011748286495477_x.jpg&quot;/&gt;&lt;img src=&quot;https://image.suning.cn/uimg/sop/commodity/202928144314004101535004_x.jpg&quot;/&gt;&lt;img src=&quot;https://gfs1.gomein.net.cn/T17ZbvB___1RCvBVdK&quot;/&gt;&lt;img src=&quot;https://gfs1.gomein.net.cn/T17ZbvB___1RCvBVdK&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-26/c8cc12dda8c5b8d9c0f6049af316b214.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,0,0,5,250,0,0,2,3,71,100.00,'','',3,''),(232,500,0,'TP0000232','CASIO卡西欧 BA-120SC-1A 7A 9A 防水防震时尚炫彩运动女表',3,0,298,0,11,1.0000,999.99,990.00,0.00,'','','CASIO卡西欧 BA-120SC-1A 7A 9A 防水防震时尚炫彩运动女表','&lt;h1 style=&quot;margin: 0px; padding: 0px 0px 0.2em; font-size: 16px; font-family: &amp;quot;microsoft yahei&amp;quot;; line-height: 1; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;CASIO卡西欧 BA-120SC-1A 7A 9A 防水防震时尚炫彩运动女表&lt;/h1&gt;&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/749901026/TB2uDR5hVXXXXbzXXXXXXXXXXXX-749901026.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/749901026/TB2rohbiVXXXXX_XXXXXXXXXXXX-749901026.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/749901026/TB2sG8iiVXXXXXjXXXXXXXXXXXX-749901026.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/749901026/TB2szl7hVXXXXbqXXXXXXXXXXXX-749901026.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/749901026/TB259oQiFXXXXaYXpXXXXXXXXXX-749901026.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/749901026/TB2cusNiFXXXXbrXpXXXXXXXXXX-749901026.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/749901026/TB2TUVIhVXXXXbAXpXXXXXXXXXX-749901026.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-26/aab1b811f51954326910acb43a75adc8.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,0,0,7,100,0,0,2,2,0,100.00,'','',3,''),(233,435,0,'TP285','比多乐来一口PK脆休闲点心面 泰国酱鸡味336g 膨化',2,0,604,0,0,0.0000,13.00,12.00,0.00,'','','比多乐来一口PK脆休闲点心面 泰国酱鸡味336g 膨化','&lt;h1 style=&quot;margin: 0px; padding: 0px 0px 0.2em; font-size: 16px; font-family: &amp;quot;microsoft yahei&amp;quot;; line-height: 1; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;比多乐来一口PK脆休闲点心面 泰国酱鸡味336g 膨化&lt;/h1&gt;&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/725677994/TB2J206etqUQKJjSZFIXXcOkFXa_!!725677994.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/725677994/TB2wwwlcK38SeJjSZFPXXc_vFXa_!!725677994.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/725677994/TB2e3sxaLMTUeJjSZFKXXagopXa_!!725677994.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/725677994/TB2uh_tbT0ATuJjSZFEXXap2FXa_!!725677994.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/725677994/TB2yJLOfwn.PuJjSZFkXXc_lpXa_!!725677994.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/725677994/TB25YUOiUUIL1JjSZFrXXb3xFXa_!!725677994.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/725677994/TB2.X4UatPJ3eJjSZFLXXab3FXa_!!725677994.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-26/8ec6c6d96fa3e3a75cc5e0c9009cfa84.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,0,0,3,0,0,0,0,0,0,1.00,'','',4,''),(234,541,0,'TP125','仙人球多肉植物组合',6,0,198,1,1,1.0000,13.00,12.00,12.00,'','','TP125','&lt;h1 style=&quot;margin: 0px; padding: 0px 0px 0.2em; font-size: 16px; font-family: &amp;quot;microsoft yahei&amp;quot;; line-height: 1; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;仙人球多肉植物组合仙人掌盆栽办公室桌面防辐射水培肉肉植物盆景&lt;/h1&gt;&lt;p class=&quot;newp&quot; style=&quot;margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(255, 0, 54); font-family: &amp;quot;microsoft yahei&amp;quot;; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;浑圆碧绿 金碧辉煌 萌萌魅力 带盆栽好&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2460919140/TB2vhNJXai5V1BjSspmXXXlwpXa_!!2460919140.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2460919140/TB2oR85axvC11Bjy1zdXXXPcVXa_!!2460919140.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2460919140/TB2zQV1az2C11BjSszgXXaKlpXa_!!2460919140.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2460919140/TB23vdytXXXXXaLXXXXXXXXXXXX_!!2460919140.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2460919140/TB2hgE0sVXXXXbKXpXXXXXXXXXX_!!2460919140.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2460919140/TB2BqLytpXXXXc6XXXXXXXXXXXX_!!2460919140.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2460919140/TB24e96tpXXXXcMXpXXXXXXXXXX_!!2460919140.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2460919140/TB25ftOtXXXXXbnXXXXXXXXXXXX_!!2460919140.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2460919140/TB2v0FStXXXXXaJXXXXXXXXXXXX_!!2460919140.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2460919140/TB2uWBKXX15V1Bjy1XdXXayCFXa_!!2460919140.jpg&quot;/&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2460919140/TB2Z88JXX95V1Bjy0FgXXc2vFXa_!!2460919140.jpg&quot;/&gt;&lt;/p&gt;',NULL,'/public/upload/goods/2018/04-26/b00e13b15afd81efee90775ff985b3d0.jpg',0,-28800,0,1,0,0,0,1,1,50,0,0,0,0,9,1000,0,0,2,3,70,1.00,'','',3,'');

UNLOCK TABLES;

/*Table structure for table `tp_goods_activity` */

DROP TABLE IF EXISTS `tp_goods_activity`;

CREATE TABLE `tp_goods_activity` (
  `act_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '活动ID',
  `act_name` varchar(255) NOT NULL DEFAULT '' COMMENT '活动名称',
  `act_desc` text NOT NULL COMMENT '活动描述',
  `act_type` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '活动类型:1预售2拼团',
  `goods_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '参加活动商品ID',
  `spec_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '商品规格ID',
  `goods_name` varchar(255) NOT NULL DEFAULT '' COMMENT '商品名称',
  `start_time` int(10) unsigned NOT NULL COMMENT '活动开始时间',
  `end_time` int(10) unsigned NOT NULL COMMENT '活动结束时间',
  `is_finished` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否已结束:0,正常；1,成功结束；2，失败结束。',
  `ext_info` text NOT NULL COMMENT '活动扩展配置',
  `act_count` mediumint(8) NOT NULL DEFAULT '0' COMMENT '商品购买数',
  PRIMARY KEY (`act_id`),
  KEY `act_name` (`act_name`,`act_type`,`goods_id`)
)  AUTO_INCREMENT=34 DEFAULT CHARSET=utf8;

/*Data for the table `tp_goods_activity` */

LOCK TABLES `tp_goods_activity` WRITE;

insert  into `tp_goods_activity`(`act_id`,`act_name`,`act_desc`,`act_type`,`goods_id`,`spec_id`,`goods_name`,`start_time`,`end_time`,`is_finished`,`ext_info`,`act_count`) values (1,'丽乔 2018新品女装小西装春季一粒扣外套女复古格纹修身西服长袖外衣潮 FFSSMD2003','85555',1,127,0,'丽乔 2018新品女装小西装春季一粒扣外套女复古格纹修身西服长袖外衣潮 FFSSMD2003',1524043309,1524045345,0,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:2:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:99;}i:1;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:49;}}s:15:\"restrict_amount\";s:2:\"20\";s:7:\"deposit\";s:2:\"10\";s:13:\"deliver_goods\";s:24:\"付款后 N 天内发货\";s:15:\"retainage_start\";i:1524045600;s:13:\"retainage_end\";i:1524048600;}',3),(2,'桑扶兰 薄款高侧比大罩杯聚拢性感文胸双胶骨收副乳胸罩内衣WAJ1517S肤色B80','2858258',1,192,0,'桑扶兰 薄款高侧比大罩杯聚拢性感文胸双胶骨收副乳胸罩内衣WAJ1517S肤色B80',1524045240,1524153599,0,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:3:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:159;}i:1;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:149;}i:2;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:148;}}s:15:\"restrict_amount\";s:3:\"100\";s:7:\"deposit\";s:2:\"10\";s:13:\"deliver_goods\";s:8:\"28582825\";s:15:\"retainage_start\";i:1524110400;s:13:\"retainage_end\";i:1524114000;}',2),(4,'闪迪（SanDisk）酷铄(CZ73) USB3.0 金属U盘 128GB 读150MB/秒','244342221',1,80,0,'闪迪（SanDisk）酷铄(CZ73) USB3.0 金属U盘 128GB 读150MB/秒',1524100000,1524102000,1,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:4:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:85;}i:1;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:75;}i:2;a:2:{s:6:\"amount\";i:7;s:5:\"price\";d:65;}i:3;a:2:{s:6:\"amount\";i:9;s:5:\"price\";d:55;}}s:15:\"restrict_amount\";s:2:\"30\";s:7:\"deposit\";s:2:\"15\";s:13:\"deliver_goods\";s:23:\"付款后 5天内发货\";s:15:\"retainage_start\";i:1524102000;s:13:\"retainage_end\";i:1524105600;}',5),(5,'多版本多规格苹果电脑','1.预计 yyyy-MM-dd HH 时前发货。2.付款后 N 天内发货。',1,217,0,'多版本多规格苹果电脑',1524100111,1524105059,0,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:3:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:7788;}i:1;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:5588;}i:2;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:5588;}}s:15:\"restrict_amount\";s:2:\"58\";s:7:\"deposit\";s:2:\"10\";s:13:\"deliver_goods\";s:67:\"1.预计 yyyy-MM-dd HH 时前发货。2.付款后 N 天内发货。\";s:15:\"retainage_start\";i:1524105120;s:13:\"retainage_end\";i:1524106800;}',7),(6,'全国送花深圳生日鲜花速递同城北京上海红玫瑰花束广州杭州成都店 中礼鲜花 20年老品牌 值得信赖','',1,198,0,'全国送花深圳生日鲜花速递同城北京上海红玫瑰花束广州杭州成都店 中礼鲜花 20年老品牌 值得信赖',1524102480,1524103200,1,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:2:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:76;}i:1;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:76;}}s:15:\"restrict_amount\";s:2:\"90\";s:7:\"deposit\";s:2:\"10\";s:13:\"deliver_goods\";s:63:\".预计 yyyy-MM-dd HH 时前发货。2.付款后 N 天内发货\";s:15:\"retainage_start\";i:1524103261;s:13:\"retainage_end\";i:1524103800;}',0),(7,'佳能（Canon） EF 24-70mm f/2.8L II USM 标准变焦镜头','',1,50,0,'佳能（Canon） EF 24-70mm f/2.8L II USM 标准变焦镜头',1524103744,1524104159,2,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:1:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:1079;}}s:15:\"restrict_amount\";s:2:\"10\";s:7:\"deposit\";s:2:\"10\";s:13:\"deliver_goods\";s:7:\"1184811\";s:15:\"retainage_start\";i:1524104160;s:13:\"retainage_end\";i:1524104400;}',0),(8,'保罗骑士男鞋2018春季新款英伦风真皮男小白鞋休闲鞋潮流系带板鞋 2018春季上新 简约英伦风','',1,180,0,'保罗骑士男鞋2018春季新款英伦风真皮男小白鞋休闲鞋潮流系带板鞋 2018春季上新 简约英伦风',1524104580,1524106200,2,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:4:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:108;}i:1;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:107;}i:2;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:106;}i:3;a:2:{s:6:\"amount\";i:6;s:5:\"price\";d:104;}}s:15:\"restrict_amount\";s:3:\"100\";s:7:\"deposit\";s:2:\"10\";s:13:\"deliver_goods\";s:6:\"285822\";s:15:\"retainage_start\";i:1524105060;s:13:\"retainage_end\";i:1524105300;}',3),(9,'迪豪灯饰 欧式水晶吊灯奢华客厅灯现代简欧卧室灯锌合金大气别墅复式楼美式餐厅led灯具套餐 金枝玉叶B款15头（包安装带三色光源+底锅发光款）','',1,197,0,'迪豪灯饰 欧式水晶吊灯奢华客厅灯现代简欧卧室灯锌合金大气别墅复式楼美式餐厅led灯具套餐 金枝玉叶B款15头（包安装带三色光源+底锅发光款）',1524105900,1524106800,1,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:2:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:2189;}i:1;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:2178;}}s:15:\"restrict_amount\";s:2:\"10\";s:7:\"deposit\";s:2:\"10\";s:13:\"deliver_goods\";s:9:\"582585225\";s:15:\"retainage_start\";i:1524106860;s:13:\"retainage_end\";i:1524107400;}',2),(10,'简林 电视柜玄关装创意饰品摆件客厅家居复古美式软装人物雕塑艺术品酒吧咖啡厅摆设','44343434',1,108,0,'简林 电视柜玄关装创意饰品摆件客厅家居复古美式软装人物雕塑艺术品酒吧咖啡厅摆设',1524106244,1524108900,0,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:3:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:85;}i:1;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:58;}i:2;a:2:{s:6:\"amount\";i:7;s:5:\"price\";d:48;}}s:15:\"restrict_amount\";s:2:\"20\";s:7:\"deposit\";s:2:\"10\";s:13:\"deliver_goods\";s:9:\"yuyuyyuyy\";s:15:\"retainage_start\";i:1524108900;s:13:\"retainage_end\";i:1524111300;}',7),(11,'宁美国度 AOC I2479VXHD 23.8英寸高清屏幕护眼液晶电脑显示器 送发光键鼠套装','232323',1,72,0,'宁美国度 AOC I2479VXHD 23.8英寸高清屏幕护眼液晶电脑显示器 送发光键鼠套装',1524107079,1524715200,0,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:6:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:89;}i:1;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:79;}i:2;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:59;}i:3;a:2:{s:6:\"amount\";i:6;s:5:\"price\";d:49;}i:4;a:2:{s:6:\"amount\";i:7;s:5:\"price\";d:39;}i:5;a:2:{s:6:\"amount\";i:8;s:5:\"price\";d:29;}}s:15:\"restrict_amount\";s:2:\"20\";s:7:\"deposit\";s:2:\"15\";s:13:\"deliver_goods\";s:6:\"343434\";s:15:\"retainage_start\";i:1524114000;s:13:\"retainage_end\";i:1524121200;}',0),(12,'艾路丝婷短袖T恤女上衣印花圆领女士体恤衫TX3532','3434',1,97,0,'艾路丝婷短袖T恤女上衣印花圆领女士体恤衫TX3532',1524107402,1524109259,0,'a:5:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:1:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:29;}}s:15:\"restrict_amount\";s:2:\"20\";s:7:\"deposit\";s:1:\"0\";s:13:\"deliver_goods\";s:7:\"4234344\";}',2),(13,'稀奇艺术限量雕塑瞿广慈《桃园三结义》现代桌面摆件办公室装饰品 大师作品 限量百件 以古鉴今 荒诞幽默','582822',1,88,0,'稀奇艺术限量雕塑瞿广慈《桃园三结义》现代桌面摆件办公室装饰品 大师作品 限量百件 以古鉴今 荒诞幽默',1524107520,1524281400,0,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:3:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:1199;}i:1;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:1188;}i:2;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:1166;}}s:15:\"restrict_amount\";s:3:\"100\";s:7:\"deposit\";s:2:\"10\";s:13:\"deliver_goods\";s:5:\"12828\";s:15:\"retainage_start\";i:1524108660;s:13:\"retainage_end\";i:1524109200;}',3),(14,'恒瓷美 北欧创意家居软装艺术品摆设树脂简约现代装饰品房间玄关客厅电视柜酒柜小摆件结婚礼物','282802',1,105,0,'恒瓷美 北欧创意家居软装艺术品摆设树脂简约现代装饰品房间玄关客厅电视柜酒柜小摆件结婚礼物',1524108260,1524108959,1,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:3:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:47;}i:1;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:46;}i:2;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:45;}}s:15:\"restrict_amount\";s:3:\"100\";s:7:\"deposit\";s:2:\"10\";s:13:\"deliver_goods\";s:6:\"285822\";s:15:\"retainage_start\";i:1524108960;s:13:\"retainage_end\";i:1524109800;}',2),(15,'男士速干抗皱抽象字母印花短袖T恤','',1,128,0,'男士速干抗皱抽象字母印花短袖T恤',1524108960,1524109500,0,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:3:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:76;}i:1;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:75;}i:2;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:74;}}s:15:\"restrict_amount\";s:2:\"10\";s:7:\"deposit\";s:2:\"10\";s:13:\"deliver_goods\";s:5:\"28552\";s:15:\"retainage_start\";i:1524109560;s:13:\"retainage_end\";i:1524110100;}',0),(16,'国家地理（National Geographic） NG W5072 摄影包 单反相机包 双肩包 逍遥者系列 旅行多功能 时尚通勤','18582',1,48,0,'国家地理（National Geographic） NG W5072 摄影包 单反相机包 双肩包 逍遥者系列 旅行多功能 时尚通勤',1524112215,1524116159,0,'a:5:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:3:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:1599;}i:1;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:1499;}i:2;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:1399;}}s:15:\"restrict_amount\";s:3:\"100\";s:7:\"deposit\";s:1:\"0\";s:13:\"deliver_goods\";s:6:\"285822\";}',2),(17,'荣耀 畅玩6 2GB+16GB 金色 全网通4G手机 双卡双待','',1,114,0,'荣耀 畅玩6 2GB+16GB 金色 全网通4G手机 双卡双待',1524110409,1524116159,0,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:4:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:598;}i:1;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:578;}i:2;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:568;}i:3;a:2:{s:6:\"amount\";i:6;s:5:\"price\";d:558;}}s:15:\"restrict_amount\";s:3:\"100\";s:7:\"deposit\";s:1:\"1\";s:13:\"deliver_goods\";s:6:\"285825\";s:15:\"retainage_start\";i:1524116160;s:13:\"retainage_end\";i:1524116760;}',5),(19,'南极人保暖内衣男女士蓄热加厚加绒黄金暖绒套装','',1,191,0,'南极人保暖内衣男女士蓄热加厚加绒黄金暖绒套装',1524205298,1524205859,0,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:4:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:85;}i:1;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:84;}i:2;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:83;}i:3;a:2:{s:6:\"amount\";i:6;s:5:\"price\";d:82;}}s:15:\"restrict_amount\";s:3:\"100\";s:7:\"deposit\";s:2:\"10\";s:13:\"deliver_goods\";s:9:\"185828252\";s:15:\"retainage_start\";i:1524205860;s:13:\"retainage_end\";i:1524206400;}',0),(20,'苏泊尔（SUPOR）电饭煲电饭锅4L容量 精铁球釜IH电磁加热CFXB40HC817-120','45454',1,208,0,'苏泊尔（SUPOR）电饭煲电饭锅4L容量 精铁球釜IH电磁加热CFXB40HC817-120',1524210960,1524213600,1,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:5:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:85;}i:1;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:68;}i:2;a:2:{s:6:\"amount\";i:6;s:5:\"price\";d:60;}i:3;a:2:{s:6:\"amount\";i:7;s:5:\"price\";d:59;}i:4;a:2:{s:6:\"amount\";i:8;s:5:\"price\";d:40;}}s:15:\"restrict_amount\";s:2:\"20\";s:7:\"deposit\";s:2:\"10\";s:13:\"deliver_goods\";s:33:\"预计 yyyy-MM-dd HH 时前发货\";s:15:\"retainage_start\";i:1524213600;s:13:\"retainage_end\";i:1524215700;}',8),(21,'预售限制地区','233223',1,226,0,'预售限制地区',1524211568,1524213198,2,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:4:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:89;}i:1;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:79;}i:2;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:69;}i:3;a:2:{s:6:\"amount\";i:6;s:5:\"price\";d:59;}}s:15:\"restrict_amount\";s:2:\"20\";s:7:\"deposit\";s:2:\"10\";s:13:\"deliver_goods\";s:8:\"34343434\";s:15:\"retainage_start\";i:1524213000;s:13:\"retainage_end\";i:1524213000;}',6),(22,'贵州茅乡酒 M10浓香型白酒 52度送礼白酒 纯粮500ml一瓶 贵州 52度白酒 浓香型 純粮酿造','sgsgsgsggsdgs',1,184,0,'贵州茅乡酒 M10浓香型白酒 52度送礼白酒 纯粮500ml一瓶 贵州 52度白酒 浓香型 純粮酿造',1524445799,1524456059,0,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:5:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:158;}i:1;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:148;}i:2;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:138;}i:3;a:2:{s:6:\"amount\";i:6;s:5:\"price\";d:128;}i:4;a:2:{s:6:\"amount\";i:7;s:5:\"price\";d:118;}}s:15:\"restrict_amount\";s:2:\"10\";s:7:\"deposit\";s:2:\"10\";s:13:\"deliver_goods\";s:7:\"2858258\";s:15:\"retainage_start\";i:1524456060;s:13:\"retainage_end\";i:1524462300;}',1),(23,'鲜花礼盒花束速递红玫瑰北京同城鲜花上海送花南京广州鲜花店杭州 手机购更优惠 6年老店 指定日期送','',1,203,0,'鲜花礼盒花束速递红玫瑰北京同城鲜花上海送花南京广州鲜花店杭州 手机购更优惠 6年老店 指定日期送',1524452400,1525060800,0,'a:5:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:3:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:89;}i:1;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:79;}i:2;a:2:{s:6:\"amount\";i:7;s:5:\"price\";d:69;}}s:15:\"restrict_amount\";s:2:\"20\";s:7:\"deposit\";s:1:\"0\";s:13:\"deliver_goods\";s:12:\"开始发货\";}',7),(24,'【北京联通】100M宽带 郊区高速（1年版）','5784744',1,57,0,'【北京联通】100M宽带 郊区高速（1年版）',1524467762,1524469081,1,'a:5:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:4:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:1276;}i:1;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:1176;}i:2;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:1076;}i:3;a:2:{s:6:\"amount\";i:6;s:5:\"price\";d:976;}}s:15:\"restrict_amount\";s:2:\"10\";s:7:\"deposit\";s:1:\"0\";s:13:\"deliver_goods\";s:4:\"2852\";}',0),(25,'双牌 动感单车家用超静音健身车室内运动自行车健身器材 SC-5000','3222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223322233222332223',1,43,0,'双牌 动感单车家用超静音健身车室内运动自行车健身器材 SC-5000',1524539248,1524542400,0,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:3:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:89;}i:1;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:69;}i:2;a:2:{s:6:\"amount\";i:7;s:5:\"price\";d:59;}}s:15:\"restrict_amount\";s:2:\"20\";s:7:\"deposit\";s:2:\"20\";s:13:\"deliver_goods\";s:24:\"付款后第五天发货\";s:15:\"retainage_start\";i:1524546000;s:13:\"retainage_end\";i:1524722400;}',4),(26,'海尔（Haier)6公斤干衣机 大烘干量 GDZE6-1W','2323323',1,204,0,'海尔（Haier)6公斤干衣机 大烘干量 GDZE6-1W',1524541980,1524542400,0,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:1:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:50;}}s:15:\"restrict_amount\";s:3:\"300\";s:7:\"deposit\";s:2:\"20\";s:13:\"deliver_goods\";s:5:\"45445\";s:15:\"retainage_start\";i:1524546000;s:13:\"retainage_end\";i:1524549600;}',0),(27,'欧迪鸟品牌比基尼三件套2018春季新品小胸钢托聚拢遮肚修身温泉泳装女','55',1,188,0,'欧迪鸟品牌比基尼三件套2018春季新品小胸钢托聚拢遮肚修身温泉泳装女',1524645739,1524649859,0,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:1:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:50;}}s:15:\"restrict_amount\";s:2:\"30\";s:7:\"deposit\";s:2:\"10\";s:13:\"deliver_goods\";s:8:\"65545454\";s:15:\"retainage_start\";i:1524649200;s:13:\"retainage_end\";i:1524649500;}',2),(28,'多规格电脑','：1.预计 yyyy-MM-dd HH 时前发货。2.付款后 N 天内',1,231,0,'多规格电脑',1524714073,1524714659,1,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:3:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:6900;}i:1;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:6800;}i:2;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:6700;}}s:15:\"restrict_amount\";s:2:\"50\";s:7:\"deposit\";s:3:\"0.1\";s:13:\"deliver_goods\";s:61:\"：1.预计 yyyy-MM-dd HH 时前发货。2.付款后 N 天内\";s:15:\"retainage_start\";i:1524714660;s:13:\"retainage_end\";i:1524715020;}',2),(29,'俪莎公馆 电视柜 欧式电视柜茶几组合套装客厅简约大理石电视柜地柜家具 (红龙玉大理石) 套餐二电视柜2.2m+茶几1.35m','多少个说过的话电话费电话费的回复交房贷很大方和施工方好',1,200,0,'俪莎公馆 电视柜 欧式电视柜茶几组合套装客厅简约大理石电视柜地柜家具 (红龙玉大理石) 套餐二电视柜2.2m+茶几1.35m',1524715318,1524721259,1,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:3:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:3000;}i:1;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:2900;}i:2;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:2800;}}s:15:\"restrict_amount\";s:2:\"10\";s:7:\"deposit\";s:2:\"10\";s:13:\"deliver_goods\";s:54:\"上纲上线个的身高多少固定股东会烦得很\";s:15:\"retainage_start\";i:1524721260;s:13:\"retainage_end\";i:1524721860;}',2),(30,'BXMAN宽松男士内裤平角裤纯棉梭织阿罗裤舒适睡裤春夏家居短裤 921组4条装','',1,179,0,'BXMAN宽松男士内裤平角裤纯棉梭织阿罗裤舒适睡裤春夏家居短裤 921组4条装',1524727074,1525363199,0,'a:5:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:1:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:13.6;}}s:15:\"restrict_amount\";s:2:\"10\";s:7:\"deposit\";s:1:\"0\";s:13:\"deliver_goods\";s:82:\"格式建议：1.预计 yyyy-MM-dd HH 时前发货。2.付款后 N 天内发货。\";}',0),(31,'仙人球多肉植物组合','1.预计 yyyy-MM-dd HH 时前发货。2.付款后 N 天内发货。',1,234,0,'仙人球多肉植物组合',1524736173,1524736859,1,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:3:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:11;}i:1;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:10;}i:2;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:9;}}s:15:\"restrict_amount\";s:2:\"10\";s:7:\"deposit\";s:1:\"1\";s:13:\"deliver_goods\";s:67:\"1.预计 yyyy-MM-dd HH 时前发货。2.付款后 N 天内发货。\";s:15:\"retainage_start\";i:1524736860;s:13:\"retainage_end\";i:1524737400;}',2),(32,'比多乐来一口PK脆休闲点心面 泰国酱鸡味336g 膨化','\r\n格式建议：1.预计 yyyy-MM-dd HH 时前发货。2.付款后 N 天内发货',1,233,0,'比多乐来一口PK脆休闲点心面 泰国酱鸡味336g 膨化',1524736723,1524790859,1,'a:5:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:2:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:11;}i:1;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:10;}}s:15:\"restrict_amount\";s:2:\"10\";s:7:\"deposit\";s:1:\"0\";s:13:\"deliver_goods\";s:81:\"\r\n格式建议：1.预计 yyyy-MM-dd HH 时前发货。2.付款后 N 天内发货\";}',0),(33,'浪莎（LangSha）女士内裤女高腰棉质性感大码透气收腹提臀三角裤4条 混色','格式建议：1.预计 yyyy-MM-dd HH 时前发货。2.付款后 N 天内发货。',1,182,0,'浪莎（LangSha）女士内裤女高腰棉质性感大码透气收腹提臀三角裤4条 混色',1524792068,1524792659,1,'a:7:{s:10:\"sale_price\";i:0;s:12:\"price_ladder\";a:3:{i:0;a:2:{s:6:\"amount\";i:3;s:5:\"price\";d:54;}i:1;a:2:{s:6:\"amount\";i:4;s:5:\"price\";d:53;}i:2;a:2:{s:6:\"amount\";i:5;s:5:\"price\";d:52;}}s:15:\"restrict_amount\";s:3:\"100\";s:7:\"deposit\";s:3:\"0.1\";s:13:\"deliver_goods\";s:82:\"格式建议：1.预计 yyyy-MM-dd HH 时前发货。2.付款后 N 天内发货。\";s:15:\"retainage_start\";i:1524792660;s:13:\"retainage_end\";i:1524793200;}',2);

UNLOCK TABLES;

/*Table structure for table `tp_goods_attr` */

DROP TABLE IF EXISTS `tp_goods_attr`;

CREATE TABLE `tp_goods_attr` (
  `goods_attr_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品属性id自增',
  `goods_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `attr_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  `attr_value` text NOT NULL COMMENT '属性值',
  `attr_price` varchar(255) NOT NULL DEFAULT '' COMMENT '属性价格',
  PRIMARY KEY (`goods_attr_id`),
  KEY `goods_id` (`goods_id`),
  KEY `attr_id` (`attr_id`)
)  AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

/*Data for the table `tp_goods_attr` */

LOCK TABLES `tp_goods_attr` WRITE;

insert  into `tp_goods_attr`(`goods_attr_id`,`goods_id`,`attr_id`,`attr_value`,`attr_price`) values (1,36,1,'中国大陆','0'),(2,36,2,'2019-9-9','0'),(3,42,3,'订单','0'),(4,216,1,'湖南','0'),(5,216,2,'2018-8-9','0'),(9,216,4,'M','0'),(8,216,3,'1235555\r\n122552336','0'),(10,225,1,'玉林服装有限公司','0'),(11,225,2,'2018/9/6','0'),(12,225,4,'XL','0'),(13,225,3,'材质成分: 聚酯纤维100%销售渠道类型: 商场同款(线上线下都销售)货号: 31827B542风格: 通勤通勤: 淑女裙长: 中长裙领型: V领腰型: 高腰图案: 碎花品牌: Vero Moda适用年龄: 25-29周岁年份季节: 2018年夏季颜色分类: C01沙草绿色 C27念香粉色 D07柠咖黄色尺码: 155/76A/XS 160/80A/S 165/84A/M 17','0');

UNLOCK TABLES;

/*Table structure for table `tp_goods_attribute` */

DROP TABLE IF EXISTS `tp_goods_attribute`;

CREATE TABLE `tp_goods_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `attr_name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `type_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '属性分类id',
  `attr_index` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否显示0不显示1显示',
  `attr_values` text NOT NULL COMMENT '可选值列表',
  `order` tinyint(3) unsigned NOT NULL DEFAULT '50' COMMENT '属性排序',
  PRIMARY KEY (`attr_id`),
  KEY `cat_id` (`type_id`)
)  AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

/*Data for the table `tp_goods_attribute` */

LOCK TABLES `tp_goods_attribute` WRITE;

insert  into `tp_goods_attribute`(`attr_id`,`attr_name`,`type_id`,`attr_index`,`attr_values`,`order`) values (1,'生产地',1,1,'',50),(2,'保证期',1,1,'',50),(3,'规则',1,0,'',50),(4,'服装规格',1,1,'X\r\nXL\r\nS\r\nM',50);

UNLOCK TABLES;

/*Table structure for table `tp_goods_category` */

DROP TABLE IF EXISTS `tp_goods_category`;

CREATE TABLE `tp_goods_category` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品分类id',
  `name` varchar(90) NOT NULL DEFAULT '' COMMENT '商品分类名称',
  `mobile_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '' COMMENT '手机端显示的商品分类名',
  `parent_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `parent_id_path` varchar(128) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '' COMMENT '家族图谱',
  `level` tinyint(1) DEFAULT '0' COMMENT '等级',
  `sort_order` tinyint(1) unsigned NOT NULL DEFAULT '50' COMMENT '顺序排序',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示',
  `image` varchar(512) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '' COMMENT '分类图片',
  `is_hot` tinyint(1) DEFAULT '0' COMMENT '是否推荐为热门分类',
  `cat_group` tinyint(1) DEFAULT '0' COMMENT '分类分组默认0',
  `commission_rate` tinyint(1) DEFAULT '0' COMMENT '分佣比例',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`)
)  AUTO_INCREMENT=581 DEFAULT CHARSET=utf8;

/*Data for the table `tp_goods_category` */

LOCK TABLES `tp_goods_category` WRITE;

insert  into `tp_goods_category`(`id`,`name`,`mobile_name`,`parent_id`,`parent_id_path`,`level`,`sort_order`,`is_show`,`image`,`is_hot`,`cat_group`,`commission_rate`) values (7,'春季新品','男装/女装/童装/内衣',6,'0_5_6_5_6_7',5,3,1,'',1,17,0),(8,'男装','男装/女装/童装/内衣',11,'0_8_11_8',3,1,1,'',0,19,3),(5,'女装','男装/女装/童装/内衣',6,'0_5_6_5',3,1,1,'',1,19,3),(6,'女装','男装/女装/童装/内衣',5,'0_5_6_5_6',4,2,1,'',1,18,3),(12,'服饰','服装服饰',0,'0_12',1,2,1,'',1,10,3),(11,'男装','男装/女装/童装/内衣',8,'0_8_11_8_11',4,1,1,'',0,12,3),(13,'女装','男装/女装/童装/内装',12,'0_12_13',2,2,1,'',1,10,3),(14,'新品推荐','男装/女装/童装/内衣',13,'0_12_13_14',3,3,1,'',1,10,3),(15,'连衣裙','男装/女装/童装/内衣',13,'0_12_13_15',3,3,1,'',0,10,3),(16,'T恤','男装/女装/童装/内衣',13,'0_12_13_16',3,3,1,'',0,10,3),(17,'衬衫','男装/女装/童装/内衣',13,'0_12_13_17',3,3,1,'',0,8,3),(18,'雪纺衫','男装/女装/童装/内衣',13,'0_12_13_18',3,10,1,'',0,9,3),(19,'短外套','男装/女装/童装/内衣',13,'0_12_13_19',3,10,1,'',0,8,3),(20,'卫衣','男装/女装/童装/内衣',13,'0_12_13_20',3,10,1,'',0,6,3),(21,'针秀衫','男装/女装/童装/内衣',13,'0_12_13_21',3,11,1,'',0,0,3),(22,'风衣','男装/女装/童装/内衣',13,'0_12_13_22',3,11,1,'',0,7,3),(23,'男装','男装/女装/童装/内衣',12,'0_12_23',2,15,1,'',0,14,3),(24,'当季热卖','男装/女装/童装/内衣',23,'0_12_23_24',3,6,1,'',0,11,3),(25,'新品推荐','男装/女装/童装/内衣',23,'0_12_23_25',3,11,1,'',0,11,3),(26,'内衣','男装/女装/童装/内衣',12,'0_12_26',2,16,1,'',0,16,3),(27,'配饰','男装/女装/童装/内衣',12,'0_12_27',2,17,1,'',0,10,3),(28,'童装','男装/女装/童装/内装',12,'0_12_28',2,18,1,'',0,12,3),(29,'加绒裤','男装/女装/童装/内装',23,'0_12_23_29',3,19,1,'',0,13,3),(30,'家居','家具家居',0,'0_30',1,6,1,'',1,18,3),(31,'手机','手机数码',0,'0_31',1,1,1,'',1,12,3),(32,'手机通讯','手机/运营商/数码',31,'0_31_32',2,10,1,'',0,10,3),(33,'运营商','手机/运营商/数码',31,'0_31_33',2,10,1,'',0,10,3),(34,'手机配件','手机/运营商/数码',31,'0_31_34',2,10,1,'',0,6,3),(35,'摄影摄像','手机/运营商/数码',31,'0_31_35',2,10,1,'',0,11,3),(36,'数码配件','手机/运营商/数码',31,'0_31_36',2,10,1,'',0,9,3),(37,'电脑','电脑配件',0,'0_37',1,3,1,'',1,8,3),(38,'电脑整机','电脑/办公',37,'0_37_38',2,3,1,'',0,10,2),(39,'电脑配件','电脑/办公',37,'0_37_39',2,3,1,'',0,10,3),(40,'外设产品','电脑/办公',37,'0_37_40',2,3,1,'',0,10,3),(41,'游戏设备','电脑/办公',37,'0_37_41',2,3,1,'',0,10,3),(42,'网络产品','电脑/办公',37,'0_37_42',2,3,1,'',0,11,3),(43,'办公设备','电脑/办公',37,'0_37_43',2,3,1,'',0,10,3),(44,'文具耗材','电脑/办公',37,'0_37_44',2,3,1,'',0,10,3),(45,'厨具','家居/家具/家厨/厨具',30,'0_30_45',2,6,1,'',0,10,3),(46,'家纺','家居/家具/家厨/厨具',30,'0_30_46',2,6,1,'',0,10,3),(47,'生活日品','家居/家具/家厨/厨具',30,'0_30_47',2,7,1,'',0,10,3),(48,'灯具','家居/家具/家厨/厨具',30,'0_30_48',2,6,1,'',0,9,3),(49,'家具','家居/家具/家厨/厨具',30,'0_30_49',2,6,1,'',0,0,3),(50,'家装主材','家居/家具/家厨/厨具',30,'0_30_50',2,7,1,'',0,10,3),(51,'厨房卫浴','家居/家具/家厨/厨具',30,'0_30_51',2,7,1,'',0,10,3),(52,'电器','电器工具',0,'0_52',1,7,1,'',0,14,3),(53,'生活电器','家用电器',52,'0_52_53',2,7,1,'',0,0,3),(54,'洗衣机','家用电器',52,'0_52_54',2,2,1,'',0,10,3),(55,'食品','食品生鲜',0,'0_55',1,8,1,'',1,0,3),(56,'鞋类','鞋类配饰',0,'0_56',1,9,1,'',1,10,3),(57,'时尚女鞋','女鞋/箱包/钟表/珠宝',56,'0_56_57',2,9,1,'',0,10,3),(58,'潮流女包','女鞋/箱包/钟表/珠宝',56,'0_56_58',2,9,1,'',0,10,3),(59,'艺术','艺术鲜花',0,'0_59',1,10,1,'',1,11,3),(60,'艺术品','艺术/礼品鲜花',59,'0_59_60',2,10,1,'',0,10,3),(84,'运动相机','手机/运营商/数码',35,'0_31_35_84',3,1,1,'',0,6,3),(61,'户外','户外运动',0,'0_61',1,11,0,'',0,10,3),(62,'手机','手机/运营商/数码',32,'0_31_32_62',3,1,1,'/public/upload/category/2018/04-17/0f99baf5f9853ec925ea3c8274f9110c.jpg',0,5,3),(63,'老人手机','手机/运营商/数码',32,'0_31_32_63',3,1,1,'/public/upload/category/2018/04-17/4003debb9f72112728ecc629292c98fb.jpg',0,3,3),(64,'游戏手机','手机/运营商/数码',32,'0_31_32_64',3,1,1,'/public/upload/category/2018/04-17/d4f22550a9855a0cf71362f1f79c525b.png',0,8,3),(65,'对讲机','手机/运营商/数码',32,'0_31_32_65',3,1,1,'/public/upload/category/2018/04-17/09846781acf3352a075a0e66f0b85d15.jpg',0,6,3),(66,'以旧换新','手机/运营商/数码',32,'0_31_32_66',3,1,1,'/public/upload/category/2018/04-17/78a98946e41d2d46155c602d9e5c8869.jpg',0,9,3),(67,'手机维修','手机/运营商/数码',32,'0_31_32_67',3,1,1,'/public/upload/category/2018/04-17/175d675e520b02bad0f57d9a8bcabd20.jpg',0,7,3),(68,'合约机','手机/运营商/数码',33,'0_31_33_68',3,1,1,'',0,6,3),(69,'选号码','手机/运营商/数码',33,'0_31_33_69',3,1,1,'',0,0,3),(70,'固定宽带','手机/运营商/数码',33,'0_31_33_70',3,1,1,'',0,8,3),(71,'办套餐','手机/运营商/数码',33,'0_31_33_71',3,1,1,'',0,6,3),(72,'充话费/流量','手机/运营商/数码',33,'0_31_33_72',3,1,1,'',0,8,3),(73,'中国移动','手机/运营商/数码',33,'0_31_33_73',3,1,1,'',0,5,3),(74,'中国联通','手机/运营商/数码',33,'0_31_33_74',3,1,1,'',0,13,3),(75,'手机壳','手机/运营商/数码',34,'0_31_34_75',3,1,1,'',0,6,3),(76,'贴膜','手机/运营商/数码',34,'0_31_34_76',3,1,1,'',0,8,3),(77,'手机储存卡','手机/运营商/数码',34,'0_31_34_77',3,1,1,'',0,9,3),(78,'数据线','手机/运营商/数码',34,'0_31_34_78',3,1,1,'',0,5,3),(79,'充电宝','手机/运营商/数码',34,'0_31_34_79',3,1,1,'',0,8,3),(80,'手机耳机','手机/运营商/数码',34,'0_31_34_80',3,1,1,'',0,9,3),(81,'数码相机','手机/运营商/数码',35,'0_31_35_81',3,1,1,'',0,8,3),(82,'单反相机','手机/运营商/数码',35,'0_31_35_82',3,1,1,'',0,5,3),(83,'图书','图书小说',0,'0_83',1,11,0,'',0,0,3),(85,'摄像头','手机/运营商/数码',35,'0_31_35_85',3,1,1,'',0,7,3),(86,'数码相框','手机/运营商/数码',35,'0_31_35_86',3,1,0,'',0,5,3),(87,'镜头','手机/运营商/数码',35,'0_31_35_87',3,1,0,'',0,6,3),(88,'户外器材','手机/运营商/数码',35,'0_31_35_88',3,1,1,'',0,8,3),(89,'相机包','手机/运营商/数码',36,'0_31_36_89',3,1,1,'',0,6,3),(90,'储存卡','手机/运营商/数码',36,'0_31_36_90',3,1,1,'',0,7,3),(91,'笔记本','电脑/办公',38,'0_37_38_91',3,2,1,'',0,7,3),(92,'游戏本','电脑/办公',38,'0_37_38_92',3,2,1,'',0,5,3),(93,'平板电脑','电脑/办公',38,'0_37_38_93',3,2,1,'',0,6,3),(94,'台试机','电脑/办公',38,'0_37_38_94',3,2,1,'',0,7,3),(95,'一体机','电脑/办公',38,'0_37_38_95',3,2,1,'',0,8,3),(96,'散热器','电脑/办公',39,'0_37_39_96',3,3,1,'',0,8,3),(97,'装机配件','电脑/办公',39,'0_37_39_97',3,3,1,'',0,8,3),(98,'组装电脑','电脑/办公',39,'0_37_39_98',3,3,1,'',0,10,3),(99,'鼠标','电脑/办公',40,'0_37_40_99',3,3,1,'',0,6,3),(100,'键盘','电脑/办公',40,'0_37_40_100',3,3,1,'',0,6,3),(101,'U盘','电脑/办公',40,'0_37_40_101',3,3,1,'',0,7,3),(102,'手写板','电脑/办公',40,'0_37_40_102',3,0,1,'',0,9,0),(103,'摄像头','电脑/办公',40,'0_37_40_103',3,3,1,'',0,9,3),(104,'游戏机','电脑/办公',41,'0_37_41_104',3,3,1,'',0,9,3),(105,'游戏耳机','电脑/办公',41,'0_37_41_105',3,3,1,'',0,9,3),(106,'雨伞雨具','家居/家具/家厨/厨具',47,'0_30_47_106',3,3,1,'',0,7,3),(107,'少儿','图书/音像/电子书',83,'0_83_107',2,17,0,'',0,9,3),(108,'0-2岁','图书/音像/电子书',107,'0_83_107_108',3,17,1,'',0,10,3),(109,'电视','家用电器',52,'0_52_109',2,1,1,'',0,8,3),(111,'小说','图书',83,'0_83_111',2,9,0,'',0,0,3),(110,'文学类','图书',83,'0_83_110',2,9,0,'',0,8,3),(112,'教育','图书',83,'0_83_112',2,9,0,'',0,6,3),(113,'科技','图书',83,'0_83_113',2,9,0,'',0,0,0),(114,'户外风衣','户外',61,'0_61_114',2,9,0,'',0,0,0),(115,'户外装备','户外',61,'0_61_115',2,9,0,'',0,6,3),(116,'新鲜水果','食物',55,'0_55_116',2,9,1,'',0,0,0),(117,'休闲零食','食物',55,'0_55_117',2,9,1,'',0,0,3),(118,'蔬菜蛋品','食物',55,'0_55_118',2,9,1,'',0,0,3),(119,'精选肉类','食物',55,'0_55_119',2,9,1,'',0,0,3),(120,'中外名酒','食物',55,'0_55_120',2,9,1,'',0,0,3),(121,'路由器','电脑',42,'0_37_42_121',3,6,1,'',0,0,3),(122,'网络机顶盒','电脑',42,'0_37_42_122',3,6,1,'',0,0,0),(123,'交换机','电脑',42,'0_37_42_123',3,0,1,'',0,0,0),(124,'网络存储卡','电脑',42,'0_37_42_124',3,0,1,'',0,0,0),(125,'网卡','电脑',42,'0_37_42_125',3,0,1,'',0,0,0),(126,'网络配件','电脑',42,'0_37_42_126',3,6,1,'',0,0,2),(127,'4G/3G上网','电脑',42,'0_37_42_127',3,0,1,'',0,0,0),(128,'游戏软件','电脑',41,'0_37_41_128',3,0,1,'',0,0,0),(129,'游戏周边','电脑',41,'0_37_41_129',3,0,1,'',0,5,0),(130,'手柄/方向盘','电脑',41,'0_37_41_130',3,0,1,'',0,0,0),(131,'投像机','电脑',43,'0_37_43_131',3,0,1,'',0,6,0),(132,'投影配件','电脑',43,'0_37_43_132',3,9,1,'',0,0,3),(133,'多功能一体机','电脑',43,'0_37_43_133',3,0,1,'',0,0,0),(134,'打印机','电脑',43,'0_37_43_134',3,0,1,'',0,0,0),(135,'传真设备','电脑',43,'0_37_43_135',3,0,1,'',0,0,0),(136,'验钞/点钞机','电脑',43,'0_37_43_136',3,0,1,'',0,0,0),(137,'收银机','电脑',43,'0_37_43_137',3,0,1,'',0,0,0),(138,'硒鼓/墨粉','电脑',44,'0_37_44_138',3,0,1,'',0,0,0),(139,'墨盒','电脑',44,'0_37_44_139',3,0,1,'',0,0,0),(140,'色带','电脑',44,'0_37_44_140',3,0,1,'',0,0,0),(141,'纸类','电脑',44,'0_37_44_141',3,0,1,'',0,3,0),(142,'办公文具','电脑',44,'0_37_44_142',3,0,1,'',0,0,0),(143,'学生文具','电脑',44,'0_37_44_143',3,0,1,'',0,0,0),(144,'文件收纳','电脑',44,'0_37_44_144',3,0,1,'',0,0,0),(145,'计算器','电脑',44,'0_37_44_145',3,0,1,'',0,0,0),(146,'财会用品','电脑',44,'0_37_44_146',3,0,1,'',0,0,0),(147,'显示器','电脑',39,'0_37_39_147',3,0,1,'',0,0,0),(148,'CPU','电脑',39,'0_37_39_148',3,0,1,'',0,0,0),(149,'主板','电脑',39,'0_37_39_149',3,0,1,'',0,0,0),(150,'显卡','电脑',39,'0_37_39_150',3,0,1,'',0,0,0),(151,'硬盘','电脑',39,'0_37_39_151',3,0,1,'',0,0,0),(152,'内存','电脑',39,'0_37_39_152',3,0,1,'',0,0,0),(153,'机箱','电脑',39,'0_37_39_153',3,0,1,'',0,0,0),(154,'电源','电脑',39,'0_37_39_154',3,0,1,'',0,0,0),(155,'鼠标垫','电脑',40,'0_37_40_155',3,0,1,'',0,0,0),(156,'电脑工具','电脑',40,'0_37_40_156',3,0,1,'',0,0,0),(157,'电脑清洁','',40,'0_37_40_157',3,0,1,'',0,0,0),(158,'插座','电脑',40,'0_37_40_158',3,0,1,'',0,0,0),(159,'线缆','电脑',43,'0_37_43_159',3,0,1,'',0,0,0),(160,'三角架/云台','手机',36,'0_31_36_160',3,0,1,'',0,0,0),(161,'滤器','手机',36,'0_31_36_161',3,0,1,'',0,0,0),(162,'闪光灯/手柄','手机',36,'0_31_36_162',3,0,1,'',0,0,0),(163,'相机清洁','手机',36,'0_31_36_163',3,0,1,'',0,0,0),(164,'机身附件','手机',36,'0_31_36_164',3,0,1,'',0,0,0),(165,'读卡器','电脑',36,'0_31_36_165',3,0,1,'',0,0,0),(166,'支架','手机',36,'0_31_36_166',3,0,1,'',0,0,0),(167,'电池/充电器','手机',36,'0_31_36_167',3,0,1,'',0,0,0),(168,'影音娱乐','手机',31,'0_31_168',2,10,1,'',0,0,0),(169,'耳机/耳麦','手机',168,'0_31_168_169',3,0,1,'',0,0,0),(170,'音箱/音响','手机',168,'0_31_168_170',3,0,1,'',0,0,0),(171,'智能音箱','手机',168,'0_31_168_171',3,0,1,'',0,0,0),(172,'无线音箱','手机',168,'0_31_168_172',3,0,1,'',0,0,0),(173,'收音机','手机',168,'0_31_168_173',3,0,1,'',0,0,0),(174,'麦克风','手机',168,'0_31_168_174',3,0,1,'',0,0,0),(175,'MP3/MP4','手机',168,'0_31_168_175',3,0,1,'',0,0,0),(176,'专业音频','手机',168,'0_31_168_176',3,0,1,'',0,0,0),(177,'电子教育','手机',31,'0_31_177',2,10,1,'',0,5,0),(178,'学生平板','手机',177,'0_31_177_178',3,0,1,'',0,0,0),(179,'点读机','手机',177,'0_31_177_179',3,0,1,'',0,0,0),(180,'录音笔','手机',177,'0_31_177_180',3,0,1,'',0,0,0),(181,'电子词典','手机',177,'0_31_177_181',3,0,1,'',0,0,0),(182,'复读机','手机',177,'0_31_177_182',3,0,1,'',0,0,0),(183,'半身裙','男装/女装/童装/内装',13,'0_12_13_183',3,0,1,'',0,0,0),(184,'短裤','男装/女装/童装/内装',13,'0_12_13_184',3,0,1,'',0,0,0),(185,'旗袍','男装/女装/童装/内装',13,'0_12_13_185',3,0,1,'',0,0,0),(186,'休闲裤','男装/女装/童装/内装',13,'0_12_13_186',3,0,1,'',0,0,0),(187,'牛仔裤','男装/女装/童装/内装',13,'0_12_13_187',3,0,1,'',0,0,0),(188,'中老年女装','男装/女装/童装/内装',13,'0_12_13_188',3,0,1,'',0,0,0),(189,'小西装','男装/女装/童装/内装',13,'0_12_13_189',3,0,1,'',0,0,0),(190,'打底衫','男装/女装/童装/内装',13,'0_12_13_190',3,0,1,'',0,0,0),(191,'打底裤','男装/女装/童装/内装',13,'0_12_13_191',3,0,1,'',0,0,0),(192,'马甲','男装/女装/童装/内装',13,'0_12_13_192',3,0,1,'',0,0,0),(193,'礼服','男装/女装/童装/内装',13,'0_12_13_193',3,0,1,'',0,0,0),(194,'婚纱','男装/女装/童装/内装',13,'0_12_13_194',3,0,1,'',0,0,0),(195,'吊带/背心','男装/女装/童装/内装',13,'0_12_13_195',3,0,1,'',0,0,0),(196,'毛尼大衣','男装/女装/童装/内装',13,'0_12_13_196',3,0,1,'',0,0,0),(197,'羽绒服','男装/女装/童装/内装',13,'0_12_13_197',3,0,1,'',0,0,0),(198,'T恤','男装/女装/童装/内装',23,'0_12_23_198',3,15,1,'',0,0,0),(199,'牛仔裤','男装/女装/童装/内装',23,'0_12_23_199',3,15,1,'',0,0,0),(200,'休闲裤','男装/女装/童装/内装',23,'0_12_23_200',3,15,1,'',0,0,0),(201,'衬衫','男装/女装/童装/内装',23,'0_12_23_201',3,15,1,'',0,0,0),(202,'短裤','男装/女装/童装/内装',23,'0_12_23_202',3,15,1,'',0,0,0),(203,'羽绒服','男装/女装/童装/内装',23,'0_12_23_203',3,15,1,'',0,0,0),(204,'棉服','男装/女装/童装/内装',23,'0_12_23_204',3,15,1,'',0,0,0),(205,'夹克','男装/女装/童装/内装',23,'0_12_23_205',3,15,1,'',0,0,0),(206,'卫衣','男装/女装/童装/内装',23,'0_12_23_206',3,15,1,'',0,0,0),(207,'毛尼大衣','男装/女装/童装/内装',23,'0_12_23_207',3,15,1,'',0,0,0),(208,'西服套装','男装/女装/童装/内装',23,'0_12_23_208',3,15,1,'',0,0,0),(209,'风衣','男装/女装/童装/内装',23,'0_12_23_209',3,15,1,'',0,0,0),(210,'马甲/背心','男装/女装/童装/内装',23,'0_12_23_210',3,15,1,'',0,0,0),(211,'西服','男装/女装/童装/内装',23,'0_12_23_211',3,15,1,'',0,0,0),(212,'西裤','男装/女装/童装/内装',23,'0_12_23_212',3,15,1,'',0,0,0),(213,'中老男装','男装/女装/童装/内装',23,'0_12_23_213',3,16,1,'',0,0,0),(214,'设计师/潮牌','男装/女装/童装/内装',23,'0_12_23_214',3,16,1,'',0,0,0),(215,'工装','男装/女装/童装/内装',23,'0_12_23_215',3,14,1,'',0,14,0),(216,'羊毛衫','男装/女装/童装/内装',23,'0_12_23_216',3,15,1,'',0,0,0),(217,'文胸','男装/女装/童装/内装',26,'0_12_26_217',3,11,1,'',0,0,0),(218,'睡衣/家居服','男装/女装/童装/内装',26,'0_12_26_218',3,11,0,'',0,0,0),(219,'男士内裤','男装/女装/童装/内装',26,'0_12_26_219',3,0,1,'',0,0,0),(220,'女士内裤','男装/女装/童装/内装',26,'0_12_26_220',3,0,1,'',0,0,0),(221,'文胸套装','男装/女装/童装/内装',26,'0_12_26_221',3,0,1,'',0,0,0),(222,'情侣睡衣','男装/女装/童装/内装',26,'0_12_26_222',3,0,1,'',0,0,0),(223,'少女文胸','男装/女装/童装/内装',26,'0_12_26_223',3,0,1,'',0,0,0),(224,'商务男袜','男装/女装/童装/内装',26,'0_12_26_224',3,0,1,'',0,0,0),(225,'美腿袜','男装/女装/童装/内装',26,'0_12_26_225',3,0,0,'',0,0,0),(226,'打底裤袜','男装/女装/童装/内装',26,'0_12_26_226',3,0,1,'',0,0,0),(227,'内衣配件','男装/女装/童装/内装',26,'0_12_26_227',3,0,1,'',0,0,0),(228,'泳衣','男装/女装/童装/内装',26,'0_12_26_228',3,0,1,'',0,0,0),(229,'秋衣秋裤','男装/女装/童装/内装',26,'0_12_26_229',3,0,1,'',0,0,0),(230,'保暖内衣','男装/女装/童装/内装',26,'0_12_26_230',3,0,1,'',0,0,0),(231,'情趣内衣','男装/女装/童装/内装',26,'0_12_26_231',3,0,1,'',0,0,0),(232,'女士围巾/披肩','男装/女装/童装/内装',27,'0_12_27_232',3,0,1,'',0,0,0),(233,'男士丝巾/围巾','男装/女装/童装/内装',27,'0_12_27_233',3,0,1,'',0,0,0),(234,'太阳镜','男装/女装/童装/内装',27,'0_12_27_234',3,0,1,'',0,0,0),(235,'防辐射眼镜','男装/女装/童装/内装',27,'0_12_27_235',3,0,1,'',0,0,0),(236,'老花镜','男装/女装/童装/内装',27,'0_12_27_236',3,0,1,'',0,0,0),(237,'游泳镜','男装/女装/童装/内装',27,'0_12_27_237',3,0,1,'',0,0,0),(238,'领带/领结','男装/女装/童装/内装',27,'0_12_27_238',3,0,1,'',0,0,0),(239,'毛线帽','男装/女装/童装/内装',27,'0_12_27_239',3,0,1,'',0,0,0),(240,'棒球帽','男装/女装/童装/内装',27,'0_12_27_240',3,0,1,'',0,0,0),(241,'遮阳伞/雨伞','男装/女装/童装/内装',27,'0_12_27_241',3,0,1,'',0,0,0),(242,'男士腰带','男装/女装/童装/内装',27,'0_12_27_242',3,0,1,'',0,0,0),(243,'女士腰带','男装/女装/童装/内装',27,'0_12_27_243',3,0,1,'',0,0,0),(244,'真皮手套','男装/女装/童装/内装',27,'0_12_27_244',3,0,1,'',0,0,0),(245,'毛线手套','男装/女装/童装/内装',27,'0_12_27_245',3,0,1,'',0,0,0),(246,'套装','男装/女装/童装/内装',28,'0_12_28_246',3,0,1,'',0,0,0),(247,'卫衣','男装/女装/童装/内装',28,'0_12_28_247',3,0,1,'',0,0,0),(248,'裤子','男装/女装/童装/内装',28,'0_12_28_248',3,0,1,'',0,0,0),(249,'外套/大衣','男装/女装/童装/内装',28,'0_12_28_249',3,0,1,'',0,0,0),(250,'毛衣/针织衫','男装/女装/童装/内装',28,'0_12_28_250',3,0,1,'',0,0,0),(251,'衬衫','男装/女装/童装/内装',28,'0_12_28_251',3,0,1,'',0,0,0),(252,'户外/运动服','男装/女装/童装/内装',28,'0_12_28_252',3,0,1,'',0,0,0),(253,'T恤','男装/女装/童装/内装',28,'0_12_28_253',3,0,0,'',0,0,0),(254,'裙子','男装/女装/童装/内装',28,'0_12_28_254',3,0,1,'',0,0,0),(255,'亲子装','男装/女装/童装/内装',28,'0_12_28_255',3,0,1,'',0,0,0),(256,'礼服/演出服','男装/女装/童装/内装',28,'0_12_28_256',3,0,1,'',0,0,0),(257,'羽绒服','男装/女装/童装/内装',28,'0_12_28_257',3,0,1,'',0,0,0),(258,'棉服','男装/女装/童装/内装',28,'0_12_28_258',3,0,1,'',0,0,0),(259,'内衣裤','男装/女装/童装/内装',28,'0_12_28_259',3,0,1,'',0,0,0),(260,'口罩','男装/女装/童装/内装',28,'0_12_28_260',3,0,1,'',0,0,0),(261,'耳罩/耳包','男装/女装/童装/内装',28,'0_12_28_261',3,0,1,'',0,0,0),(262,'水具酒具','厨具',45,'0_30_45_262',3,0,1,'',0,0,0),(263,'餐具','厨具',45,'0_30_45_263',3,0,1,'',0,0,0),(264,'厨房配件','厨具',45,'0_30_45_264',3,0,1,'',0,0,0),(265,'刀剪菜板','厨具',45,'0_30_45_265',3,0,1,'',0,0,0),(266,'锅具套装','厨具',45,'0_30_45_266',3,0,1,'',0,0,0),(268,'茶具/咖啡具','厨具',45,'0_30_45_268',3,0,1,'',0,0,0),(269,'保温杯','厨具',45,'0_30_45_269',3,0,1,'',0,0,0),(270,'保鲜盒','厨具',45,'0_30_45_270',3,0,1,'',0,0,0),(271,'床品套件','家具家居',46,'0_30_46_271',3,0,0,'',0,0,0),(272,'被子','家具家居',46,'0_30_46_272',3,0,0,'',0,0,0),(273,'枕芯','家具家居',46,'0_30_46_273',3,0,0,'',0,0,0),(274,'蚊帐','家具家居',46,'0_30_46_274',3,0,0,'',0,0,0),(275,'凉席','家具家居',46,'0_30_46_275',3,0,1,'',0,0,0),(276,'毛巾浴巾','家具家居',46,'0_30_46_276',3,0,1,'',0,0,0),(277,'地毯地垫','家具家居',46,'0_30_46_277',3,0,1,'',0,0,0),(278,'床垫','家具家居',46,'0_30_46_278',3,0,1,'',0,0,0),(279,'毯子','家具家居',46,'0_30_46_279',3,0,1,'',0,0,0),(280,'抱枕靠垫','家具家居',46,'0_30_46_280',3,0,1,'',0,0,0),(281,'窗帘/窗纱','家具家居',46,'0_30_46_281',3,0,1,'',0,0,0),(282,'床单','家具家居',46,'0_30_46_282',3,0,1,'',0,0,0),(283,'被套','家具家居',46,'0_30_46_283',3,0,1,'',0,0,0),(284,'电热垫','家具家居',46,'0_30_46_284',3,0,1,'',0,0,0),(285,'桌布/罩件','家具家居',46,'0_30_46_285',3,0,1,'',0,0,0),(286,'收纳用品','家具家居',47,'0_30_47_286',3,0,1,'',0,0,0),(287,'净化除味','家具家居',47,'0_30_47_287',3,0,1,'',0,0,0),(288,'浴室用品','家具家居',47,'0_30_47_288',3,0,1,'',0,0,0),(289,'缝纫/针织用品','家具家居',47,'0_30_47_289',3,0,1,'',0,0,0),(290,'清洁工具','家具家居',47,'0_30_47_290',3,0,1,'',0,0,0),(291,'吸顶灯','家具家居',48,'0_30_48_291',3,0,1,'',0,0,0),(292,'吊灯','家具家居',48,'0_30_48_292',3,0,1,'',0,0,0),(293,'台灯','家具家居',48,'0_30_48_293',3,0,1,'',0,0,0),(294,'筒灯射灯','家具家居',48,'0_30_48_294',3,0,1,'',0,0,0),(295,'装饰灯','家具家居',48,'0_30_48_295',3,0,1,'',0,0,0),(296,'LED灯','家具家居',48,'0_30_48_296',3,0,1,'',0,0,0),(297,'氛围照明','家具家居',48,'0_30_48_297',3,0,1,'',0,0,0),(298,'落地灯','家具家居',48,'0_30_48_298',3,0,1,'',0,0,0),(299,'庭院灯','家具家居',48,'0_30_48_299',3,0,1,'',0,0,0),(300,'节能灯','家具家居',48,'0_30_48_300',3,0,1,'',0,0,0),(301,'应急灯/手电','家具家居',48,'0_30_48_301',3,0,1,'',0,0,0),(302,'卧室家具','家具家居',49,'0_30_49_302',3,0,1,'',0,0,0),(303,'客厅家具','家具家居',49,'0_30_49_303',3,0,1,'',0,0,0),(304,'餐厅家具','家具家居',49,'0_30_49_304',3,0,1,'',0,0,0),(305,'书房家具','家具家居',49,'0_30_49_305',3,0,1,'',0,0,0),(306,'儿童家具','家具家居',49,'0_30_49_306',3,0,1,'',0,0,0),(307,'储物家具','家具家居',49,'0_30_49_307',3,0,1,'',0,0,0),(308,'阳台/户外','家具家居',49,'0_30_49_308',3,0,1,'',0,0,0),(309,'办公家具','家具家居',49,'0_30_49_309',3,0,1,'',0,0,0),(310,'床','家具家居',49,'0_30_49_310',3,0,1,'',0,0,0),(311,'床垫','家具家居',49,'0_30_49_311',3,0,1,'',0,0,0),(312,'沙发','家具家居',49,'0_30_49_312',3,0,1,'',0,0,0),(313,'电脑椅','家具家居',49,'0_30_49_313',3,0,1,'',0,0,0),(314,'衣柜','家具家居',49,'0_30_49_314',3,0,1,'',0,0,0),(315,'电视柜','家具家居',49,'0_30_49_315',3,0,1,'',0,0,0),(316,'餐桌','家具家居',49,'0_30_49_316',3,0,1,'',0,0,0),(317,'电脑桌','家具家居',49,'0_30_49_317',3,0,1,'',0,0,0),(318,'鞋架/衣帽椅','家具家居',49,'0_30_49_318',3,0,1,'',0,0,0),(319,'儿童桌椅','家具家居',49,'0_30_49_319',3,0,1,'',0,0,0),(320,'儿童床','家具家居',49,'0_30_49_320',3,0,1,'',0,0,0),(321,'晾衣架','家具家居',49,'0_30_49_321',3,0,1,'',0,0,0),(324,'瓷砖','家具家居',50,'0_30_50_324',3,0,1,'',0,0,0),(323,'装修定制','家具家居',30,'0_30_323',2,10,1,'',0,0,0),(325,'地板','家具家居',50,'0_30_50_325',3,0,1,'',0,0,0),(326,'油漆涂料','家具家居',50,'0_30_50_326',3,0,1,'',0,0,0),(327,'壁纸','家具家居',50,'0_30_50_327',3,0,1,'',0,0,0),(328,'水槽','家具家居',51,'0_30_51_328',3,0,1,'',0,0,0),(329,'涂刷辅料','家具家居',50,'0_30_50_329',3,0,1,'',0,0,0),(330,'龙头','家具家居',51,'0_30_51_330',3,0,1,'',0,0,0),(331,'马桶','家具家居',51,'0_30_51_331',3,0,1,'',0,0,0),(332,'智能马桶盖','家具家居',51,'0_30_51_332',3,0,1,'',0,0,0),(333,'浴室柜','家具家居',51,'0_30_51_333',3,0,1,'',0,0,0),(334,'垃圾处理器','家具家居',51,'0_30_51_334',3,0,1,'',0,0,0),(335,'装修设计','家具家居',323,'0_30_323_335',3,0,1,'',0,0,0),(336,'全包装修','家具家居',323,'0_30_323_336',3,0,1,'',0,0,0),(337,'局部装修','家具家居',323,'0_30_323_337',3,0,1,'',0,0,0),(338,'橱柜','家具家居',323,'0_30_323_338',3,0,1,'',0,0,0),(339,'门窗','家具家居',323,'0_30_323_339',3,0,1,'',0,0,0),(340,'散热器','家具家居',323,'0_30_323_340',3,0,1,'',0,0,0),(341,'安装服务','家具家居',323,'0_30_323_341',3,0,1,'',0,0,0),(342,'空调','家用电器',52,'0_52_342',2,2,1,'',0,0,0),(343,'壁挂试空调','家用电器',342,'0_52_342_343',3,0,1,'',0,0,0),(344,'柜试空调','家用电器',342,'0_52_342_344',3,0,1,'',0,0,0),(345,'中央空调','家用电器',342,'0_52_342_345',3,0,1,'',0,0,0),(346,'节能空调','家用电器',342,'0_52_342_346',3,0,1,'',0,0,0),(347,'智能空调','家用电器',342,'0_52_342_347',3,0,1,'',0,0,0),(348,'变频空调','家用电器',342,'0_52_342_348',3,0,1,'',0,0,0),(349,'以旧换新','家用电器',342,'0_52_342_349',3,0,1,'',0,0,0),(350,'空调配件','家用电器',342,'0_52_342_350',3,0,1,'',0,0,0),(351,'曲面电视','家用电器',109,'0_52_109_351',3,0,1,'',0,0,0),(352,'超薄电视','家用电器',109,'0_52_109_352',3,0,1,'',0,0,0),(353,'HDR电视','家用电器',109,'0_52_109_353',3,0,1,'',0,0,0),(354,'4K超清电视','家用电器',109,'0_52_109_354',3,0,1,'',0,0,0),(355,'人工智能电视','家用电器',109,'0_52_109_355',3,0,1,'',0,0,0),(356,'55英寸','家用电器',109,'0_52_109_356',3,0,1,'',0,0,0),(357,'65英寸','家用电器',109,'0_52_109_357',3,0,1,'',0,0,0),(358,'电视配件','家用电器',109,'0_52_109_358',3,0,1,'',0,0,0),(359,'吸尘器','',53,'0_52_53_359',3,0,1,'',0,0,0),(360,'空气净化器','',53,'0_52_53_360',3,0,1,'',0,0,0),(361,'电风扇','家用电器',53,'0_52_53_361',3,0,1,'',0,0,0),(362,'扫地机器人','家用电器',53,'0_52_53_362',3,0,1,'',0,0,0),(363,'蒸汽拖把','家用电器',53,'0_52_53_363',3,0,1,'',0,0,0),(364,'干衣机','家用电器',53,'0_52_53_364',3,0,1,'',0,0,0),(365,'电话机','家用电器',53,'0_52_53_365',3,0,1,'',0,0,0),(366,'饮水机','家用电器',53,'0_52_53_366',3,0,1,'',0,0,0),(367,'净水器','家用电器',53,'0_52_53_367',3,0,1,'',0,0,0),(368,'除湿器','家用电器',53,'0_52_53_368',3,0,1,'',0,0,0),(369,'加湿器','家用电器',53,'0_52_53_369',3,0,1,'',0,0,0),(370,'冷风扇','家用电器',53,'0_52_53_370',3,0,1,'',0,0,0),(371,'生活电器配件','家用电器',53,'0_52_53_371',3,0,1,'',0,0,0),(372,'滚筒洗衣机','家用电器',54,'0_52_54_372',3,0,1,'',0,0,0),(373,'洗烘一体机','',54,'0_52_54_373',3,0,1,'',0,0,0),(374,'波轮洗衣机','家用电器',54,'0_52_54_374',3,0,1,'',0,0,0),(375,'迷你洗衣机','家用电器',54,'0_52_54_375',3,0,1,'',0,0,0),(376,'烘干机','家用电器',54,'0_52_54_376',3,0,1,'',0,0,0),(377,'洗衣机配件','家用电器',54,'0_52_54_377',3,0,1,'',0,0,0),(378,'冰箱','家用电器',52,'0_52_378',2,2,1,'',0,0,0),(379,'多门','家用电器',378,'0_52_378_379',3,0,1,'',0,0,0),(380,'对开门','家用电器',378,'0_52_378_380',3,0,1,'',0,0,0),(381,'双门','家用电器',378,'0_52_378_381',3,0,0,'',0,0,0),(382,'冷柜/冰吧','家用电器',378,'0_52_378_382',3,0,1,'',0,0,0),(383,'冰箱配件','家用电器',378,'0_52_378_383',3,0,1,'',0,0,0),(384,'厨房小电','家用电器',52,'0_52_384',2,2,1,'',0,0,0),(385,'油烟机','家用电器',384,'0_52_384_385',3,0,1,'',0,0,0),(386,'电饭煲','家用电器',384,'0_52_384_386',3,0,1,'',0,0,0),(387,'电压力锅','家用电器',384,'0_52_384_387',3,0,1,'',0,0,0),(388,'咖啡机','家用电器',384,'0_52_384_388',3,0,1,'',0,0,0),(389,'豆浆机','家用电器',384,'0_52_384_389',3,0,1,'',0,0,0),(390,'料理机','家用电器',384,'0_52_384_390',3,0,1,'',0,0,0),(391,'电水壶','家用电器',384,'0_52_384_391',3,0,1,'',0,0,0),(392,'苹果','',116,'0_55_116_392',3,0,1,'',0,0,0),(393,'香蕉','',116,'0_55_116_393',3,0,1,'',0,0,0),(394,'梨','食物',116,'0_55_116_394',3,0,1,'',0,0,0),(395,'橙子','食物',116,'0_55_116_395',3,0,1,'',0,0,0),(396,'奇异果','',116,'0_55_116_396',3,0,1,'',0,0,0),(397,'火龙果','食物',116,'0_55_116_397',3,0,1,'',0,0,0),(398,'榴莲','食物',116,'0_55_116_398',3,0,1,'',0,0,0),(399,'百香果','食物',116,'0_55_116_399',3,0,1,'',0,0,0),(400,'国产水果','食物',116,'0_55_116_400',3,0,1,'',0,0,0),(401,'进口水果','食物',116,'0_55_116_401',3,0,1,'',0,0,0),(402,'营养零食','食物',117,'0_55_117_402',3,0,1,'',0,0,0),(403,'坚果炒货','食物',117,'0_55_117_403',3,0,1,'',0,0,0),(404,'糖果/巧克力','食物',117,'0_55_117_404',3,0,1,'',0,0,0),(405,'饼干蛋糕','食物',117,'0_55_117_405',3,0,1,'',0,0,0),(406,'肉干','食物',117,'0_55_117_406',3,0,1,'',0,0,0),(407,'熟食腊味','食物',117,'0_55_117_407',3,0,1,'',0,0,0),(408,'蛋品','',118,'0_55_118_408',3,0,1,'',0,0,0),(409,'叶菜类','',118,'0_55_118_409',3,0,1,'',0,0,0),(410,'葱姜蒜','食物',118,'0_55_118_410',3,0,1,'',0,0,0),(411,'玉米','食物',118,'0_55_118_411',3,0,1,'',0,0,0),(412,'山药','食物',118,'0_55_118_412',3,0,1,'',0,0,0),(413,'地瓜/红薯','食物',118,'0_55_118_413',3,0,1,'',0,0,0),(414,'鲜菌菇','食物',118,'0_55_118_414',3,0,1,'',0,0,0),(415,'瓜类','食物',118,'0_55_118_415',3,0,1,'',0,0,0),(416,'猪肉','',119,'0_55_119_416',3,0,1,'',0,0,0),(417,'牛肉','食物',119,'0_55_119_417',3,0,1,'',0,0,0),(418,'羊肉','食物',119,'0_55_119_418',3,0,1,'',0,0,0),(419,'鸡肉','食物',119,'0_55_119_419',3,0,1,'',0,0,0),(420,'鸭肉','食物',119,'0_55_119_420',3,0,1,'',0,0,0),(421,'冷鲜肉','',119,'0_55_119_421',3,0,1,'',0,0,0),(422,'特色肉类','食物',119,'0_55_119_422',3,0,1,'',0,0,0),(423,'牛排','食物',119,'0_55_119_423',3,0,1,'',0,0,0),(424,'鸡翅','食物',119,'0_55_119_424',3,0,1,'',0,0,0),(425,'白酒','食物',120,'0_55_120_425',3,0,1,'',0,0,0),(426,'葡萄酒','食物',120,'0_55_120_426',3,0,1,'',0,0,0),(427,'洋酒','食物',120,'0_55_120_427',3,0,1,'',0,0,0),(428,'啤酒','食物',120,'0_55_120_428',3,0,1,'',0,0,0),(429,'收藏酒/陈年老酒','食物',120,'0_55_120_429',3,0,1,'',0,0,0),(430,'保健酒','食物',120,'0_55_120_430',3,0,1,'',0,0,0),(431,'配制酒','食物',120,'0_55_120_431',3,0,1,'',0,0,0),(432,'黄酒','食物',120,'0_55_120_432',3,0,1,'',0,0,0),(433,'进口食品','食物',55,'0_55_433',2,0,1,'',0,0,0),(434,'牛奶','食物',433,'0_55_433_434',3,0,1,'',0,0,0),(435,'零食','食物',433,'0_55_433_435',3,0,1,'',0,0,0),(436,'饮料','食物',433,'0_55_433_436',3,0,1,'',0,0,0),(437,'咖啡粉','食物',433,'0_55_433_437',3,0,1,'',0,0,0),(438,'方便食品','食物',433,'0_55_433_438',3,0,1,'',0,0,0),(439,'水','',433,'0_55_433_439',3,0,1,'',0,0,0),(440,'糖/巧克力','食物',433,'0_55_433_440',3,0,1,'',0,0,0),(441,'冲调品','食物',433,'0_55_433_441',3,0,1,'',0,0,0),(442,'油','食物',433,'0_55_433_442',3,0,1,'',0,0,0),(443,'新品推荐','时尚女鞋',57,'0_56_57_443',3,0,1,'',0,0,0),(444,'单鞋','时尚女鞋',57,'0_56_57_444',3,0,1,'',0,0,0),(445,'休闲鞋','时尚女鞋',57,'0_56_57_445',3,0,1,'',0,0,0),(446,'帆布鞋','时尚女鞋',57,'0_56_57_446',3,0,1,'',0,0,0),(447,'布鞋/绣花鞋','时尚女鞋',57,'0_56_57_447',3,0,1,'',0,0,0),(448,'女靴','时尚女鞋',57,'0_56_57_448',3,0,1,'',0,0,0),(449,'马丁靴','时尚女鞋',57,'0_56_57_449',3,0,1,'',0,0,0),(450,'高跟鞋','时尚女鞋',57,'0_56_57_450',3,0,1,'',0,0,0),(451,'运动鞋','时尚女鞋',57,'0_56_57_451',3,0,1,'',0,0,0),(452,'凉鞋','时尚女鞋',57,'0_56_57_452',3,0,1,'',0,0,0),(453,'内增高','时尚女鞋',57,'0_56_57_453',3,0,1,'',0,0,0),(454,'防水台','时尚女鞋',57,'0_56_57_454',3,0,1,'',0,0,0),(455,'鞋配件','时尚女鞋',57,'0_56_57_455',3,0,1,'',0,0,0),(456,'真皮包','时尚女鞋',58,'0_56_58_456',3,0,1,'',0,0,0),(457,'女士钱包','潮流女包',58,'0_56_58_457',3,0,1,'',0,0,0),(458,'单肩包','潮流女包',58,'0_56_58_458',3,0,1,'',0,0,0),(459,'斜跨包','时尚女鞋',58,'0_56_58_459',3,0,1,'',0,0,0),(460,'手提包','时尚女鞋',58,'0_56_58_460',3,0,1,'',0,0,0),(461,'腰包','潮流包包',58,'0_56_58_461',3,0,1,'',0,0,0),(462,'化妆包','潮流包包',58,'0_56_58_462',3,0,1,'',0,0,0),(463,'钥匙包','潮流包包',58,'0_56_58_463',3,0,1,'',0,0,0),(464,'双肩包','潮流包包',58,'0_56_58_464',3,0,1,'',0,0,0),(465,'精品男包','精品男包',56,'0_56_465',2,9,1,'',0,10,0),(466,'男士钱包','精品男包',465,'0_56_465_466',3,0,1,'',0,0,0),(467,'双肩包','精品男包',465,'0_56_465_467',3,0,1,'',0,0,0),(468,'单肩/斜跨包','精品男包',465,'0_56_465_468',3,0,1,'',0,0,0),(469,'商务公文包','精品男包',465,'0_56_465_469',3,0,1,'',0,0,0),(470,'男士手包','精品男包',465,'0_56_465_470',3,0,1,'',0,0,0),(471,'钥匙包','精品男包',465,'0_56_465_471',3,0,1,'',0,0,0),(472,'腰包','精品男包',465,'0_56_465_472',3,0,1,'',0,0,0),(473,'功能箱包','功能箱包',56,'0_56_473',2,10,1,'',0,10,0),(474,'旅行箱','功能箱包',473,'0_56_473_474',3,0,1,'',0,0,0),(475,'万向轮箱','功能箱包',473,'0_56_473_475',3,0,1,'',0,0,0),(476,'旅行袋','功能箱包',473,'0_56_473_476',3,0,1,'',0,0,0),(477,'拉杆箱','',473,'0_56_473_477',3,0,1,'',0,0,0),(478,'电脑包','功能箱包',473,'0_56_473_478',3,0,1,'',0,0,0),(479,'休闲运动包','功能箱包',473,'0_56_473_479',3,0,1,'',0,0,0),(480,'书包','功能箱包',473,'0_56_473_480',3,0,0,'',0,0,0),(481,'登山包','功能箱包',473,'0_56_473_481',3,0,1,'',0,0,0),(482,'相机包','功能箱包',473,'0_56_473_482',3,0,1,'',0,0,0),(483,'妈咪包','功能箱包',473,'0_56_473_483',3,0,1,'',0,0,0),(484,'旅行配件','功能箱包',473,'0_56_473_484',3,0,1,'',0,0,0),(485,'珠宝首饰','珠宝首饰',56,'0_56_485',2,10,1,'',0,0,0),(486,'黄金','珠宝首饰',485,'0_56_485_486',3,0,1,'',0,0,0),(487,'K金','珠宝首饰',485,'0_56_485_487',3,0,1,'',0,0,0),(488,'时尚饰品','珠宝首饰',485,'0_56_485_488',3,0,1,'',0,0,0),(489,'砖石','珠宝首饰',485,'0_56_485_489',3,0,1,'',0,0,0),(490,'银饰','珠宝首饰',485,'0_56_485_490',3,0,1,'',0,0,0),(491,'铂金','珠宝首饰',485,'0_56_485_491',3,0,1,'',0,0,0),(492,'珍珠','珠宝首饰',485,'0_56_485_492',3,0,1,'',0,0,0),(493,'发饰','珠宝首饰',485,'0_56_485_493',3,0,1,'',0,0,0),(494,'水晶玛瑙','珠宝首饰',485,'0_56_485_494',3,0,1,'',0,0,0),(495,'时尚钟表','时尚钟表',56,'0_56_495',2,10,1,'',0,0,0),(499,'浪琴','时尚钟表',495,'0_56_495_499',3,0,1,'',0,0,0),(500,'卡西欧','时尚钟表',495,'0_56_495_500',3,0,1,'',0,0,0),(498,'DW','时尚钟表',495,'0_56_495_498',3,0,1,'',0,0,0),(501,'西铁城','时尚钟表',495,'0_56_495_501',3,0,1,'',0,0,0),(502,'天王','时尚钟表',495,'0_56_495_502',3,0,1,'',0,0,0),(503,'瑞表','时尚钟表',495,'0_56_495_503',3,0,1,'',0,0,0),(504,'国表','时尚钟表',495,'0_56_495_504',3,0,1,'',0,0,0),(505,'日韩表','时尚钟表',495,'0_56_495_505',3,0,1,'',0,0,0),(506,'欧美表','时尚钟表',495,'0_56_495_506',3,0,1,'',0,0,0),(507,'儿童手表','时尚钟表',495,'0_56_495_507',3,0,1,'',0,0,0),(508,'智能手表','时尚钟表',495,'0_56_495_508',3,0,1,'',0,0,0),(509,'闹钟','时尚钟表',495,'0_56_495_509',3,0,1,'',0,0,0),(510,'挂钟','时尚钟表',495,'0_56_495_510',3,0,1,'',0,0,0),(511,'座钟','时尚钟表',495,'0_56_495_511',3,0,1,'',0,0,0),(512,'钟表配件','时尚钟表',495,'0_56_495_512',3,0,1,'',0,0,0),(513,'精美礼品','艺术',59,'0_59_513',2,10,1,'',0,10,0),(514,'油画','艺术品',60,'0_59_60_514',3,0,1,'',0,0,0),(515,'版画','艺术品',60,'0_59_60_515',3,0,1,'',0,0,0),(516,'水墨画','艺术品',60,'0_59_60_516',3,0,1,'',0,0,0),(517,'书法','艺术品',60,'0_59_60_517',3,0,1,'',0,0,0),(518,'雕塑','艺术品',60,'0_59_60_518',3,0,1,'',0,0,0),(519,'艺术画册','艺术品',60,'0_59_60_519',3,0,1,'',0,0,0),(520,'艺术衍生品','艺术品',60,'0_59_60_520',3,0,1,'',0,0,0),(521,'创意礼品','艺术品',513,'0_59_513_521',3,0,1,'',0,0,0),(522,'电子礼品','艺术品',513,'0_59_513_522',3,0,1,'',0,0,0),(523,'工艺礼品','艺术品',513,'0_59_513_523',3,0,1,'',0,0,0),(524,'美妆礼品','艺术品',513,'0_59_513_524',3,0,1,'',0,0,0),(525,'婚庆节庆','艺术品',513,'0_59_513_525',3,0,1,'',0,0,0),(526,'礼盒礼券','艺术品',513,'0_59_513_526',3,0,1,'',0,0,0),(527,'礼品定制','艺术品',513,'0_59_513_527',3,0,1,'',0,0,0),(528,'古董文玩','艺术品',513,'0_59_513_528',3,0,1,'',0,0,0),(529,'收藏品','艺术品',513,'0_59_513_529',3,0,1,'',0,0,0),(530,'礼品文具','艺术品',513,'0_59_513_530',3,0,1,'',0,0,0),(531,'熏香','艺术品',513,'0_59_513_531',3,0,1,'',0,0,0),(532,'鲜花速递','艺术鲜花',59,'0_59_532',2,10,1,'',0,0,0),(533,'绿植园艺','艺术品',59,'0_59_533',2,10,1,'',0,0,0),(534,'种子','艺术品',59,'0_59_534',2,11,1,'',0,0,0),(535,'畜牧养殖','艺术品',59,'0_59_535',2,10,1,'',0,0,0),(536,'鲜花','鲜花速递',532,'0_59_532_536',3,0,1,'',0,0,0),(537,'每周一花','鲜花速递',532,'0_59_532_537',3,0,1,'',0,0,0),(538,'永生花','鲜花速递',532,'0_59_532_538',3,0,1,'',0,0,0),(539,'香皂花','鲜花速递',532,'0_59_532_539',3,0,1,'',0,0,0),(540,'卡通花束','鲜花速递',532,'0_59_532_540',3,0,1,'',0,0,0),(541,'桌面绿植','鲜花速递',533,'0_59_533_541',3,0,1,'',0,0,0),(542,'苗木','鲜花速递',533,'0_59_533_542',3,0,1,'',0,0,0),(543,'绿植盘栽','鲜花速递',533,'0_59_533_543',3,0,1,'',0,0,0),(544,'多肉植物','鲜花速递',533,'0_59_533_544',3,0,1,'',0,0,0),(545,'花卉','鲜花速递',533,'0_59_533_545',3,0,1,'',0,0,0),(546,'种子种球','鲜花速递',533,'0_59_533_546',3,0,1,'',0,0,0),(547,'园艺土肥','鲜花速递',533,'0_59_533_547',3,0,1,'',0,0,0),(548,'园艺工具','鲜花速递',533,'0_59_533_548',3,0,1,'',0,0,0),(549,'花盆花器','鲜花速递',533,'0_59_533_549',3,0,1,'',0,0,0),(550,'花草林木类','种子',534,'0_59_534_550',3,0,1,'',0,0,0),(551,'蔬菜/菌类','种子',534,'0_59_534_551',3,0,1,'',0,0,0),(552,'瓜果类','种子',534,'0_59_534_552',3,0,1,'',0,0,0),(553,'大田作物类','种子',534,'0_59_534_553',3,0,1,'',0,0,0),(554,'中兽药','畜牧养殖',535,'0_59_535_554',3,0,1,'',0,0,0),(555,'西兽药','畜牧养殖',535,'0_59_535_555',3,0,1,'',0,0,0),(556,'农缩料','畜牧养殖',535,'0_59_535_556',3,0,1,'',0,0,0),(557,'全价料','畜牧养殖',535,'0_59_535_557',3,0,1,'',0,0,0),(558,'养殖场专用','畜牧养殖',535,'0_59_535_558',3,0,1,'',0,0,0),(559,'农药','畜牧养殖',59,'0_59_559',2,12,1,'',0,0,0),(560,'杀虫剂','畜牧养殖',559,'0_59_559_560',3,0,1,'',0,0,0),(561,'杀菌剂','畜牧养殖',559,'0_59_559_561',3,0,1,'',0,0,0),(562,'除草剂','畜牧养殖',559,'0_59_559_562',3,0,1,'',0,0,0),(563,'植物生长调节剂','畜牧养殖',559,'0_59_559_563',3,0,1,'',0,0,0),(564,'肥料','畜牧养殖',59,'0_59_564',2,12,1,'',0,0,0),(565,'碳/磷/钾肥','畜牧养殖',564,'0_59_564_565',3,0,1,'',0,0,0),(566,'复合肥','畜牧养殖',564,'0_59_564_566',3,0,1,'',0,0,0),(567,'生物菌肥','畜牧养殖',564,'0_59_564_567',3,0,1,'',0,0,0),(568,'水溶/叶面肥','畜牧养殖',564,'0_59_564_568',3,0,1,'',0,0,0),(569,'有机肥','畜牧养殖',564,'0_59_564_569',3,0,1,'',0,0,0),(570,'男士鞋子','鞋类',56,'0_56_570',2,9,1,'',0,0,0),(571,'新品推荐','鞋类',570,'0_56_570_571',3,0,1,'',0,0,0),(572,'当季热卖','鞋子',570,'0_56_570_572',3,0,1,'',0,0,0),(573,'运动鞋','鞋子',570,'0_56_570_573',3,0,1,'',0,0,0),(574,'品牌鞋','鞋子',570,'0_56_570_574',3,0,0,'',0,0,0),(575,'休闲鞋','鞋子',570,'0_56_570_575',3,0,1,'',0,0,0),(576,'凉鞋','鞋子',570,'0_56_570_576',3,0,1,'',0,0,0),(577,'棉拖鞋','鞋子',570,'0_56_570_577',3,0,1,'',0,0,0),(578,'牛皮鞋','鞋子',570,'0_56_570_578',3,0,1,'',0,0,0),(579,'布帆鞋','鞋子',570,'0_56_570_579',3,0,1,'',0,0,0),(580,'解放鞋','鞋子',570,'0_56_570_580',3,0,1,'',0,0,0);

UNLOCK TABLES;

/*Table structure for table `tp_goods_collect` */

DROP TABLE IF EXISTS `tp_goods_collect`;

CREATE TABLE `tp_goods_collect` (
  `collect_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `goods_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`collect_id`),
  KEY `user_id` (`user_id`),
  KEY `goods_id` (`goods_id`)
)  AUTO_INCREMENT=67 DEFAULT CHARSET=utf8;

/*Data for the table `tp_goods_collect` */

LOCK TABLES `tp_goods_collect` WRITE;

insert  into `tp_goods_collect`(`collect_id`,`user_id`,`goods_id`,`add_time`) values (55,2,230,1524712283),(23,2,196,1523947757),(22,8,199,1523934574),(29,8,196,1524016004),(30,3,203,1524021050),(50,3,4,1524466308),(66,31,130,1524877523),(35,3,215,1524036037),(53,3,193,1524561832),(26,3,21,1523956905),(58,2,141,1524731111),(32,3,135,1524022315),(36,3,183,1524036489),(59,23,212,1524731418),(38,9,133,1524118137),(40,3,220,1524131562),(41,3,131,1524131730),(42,3,13,1524132888),(43,3,219,1524186485),(44,5,219,1524188936),(45,3,154,1524204764),(46,3,1,1524206544),(47,9,174,1524207406),(48,3,194,1524446526),(49,3,5,1524449952),(51,10,62,1524470059),(52,10,12,1524470943),(60,22,216,1524731927),(62,24,228,1524797440),(63,23,193,1524812666),(64,25,220,1524813692),(65,2,204,1524814610);

UNLOCK TABLES;

/*Table structure for table `tp_goods_consult` */

DROP TABLE IF EXISTS `tp_goods_consult`;

CREATE TABLE `tp_goods_consult` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '商品咨询id',
  `goods_id` int(11) DEFAULT '0' COMMENT '商品id',
  `username` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '网名',
  `add_time` int(11) DEFAULT '0' COMMENT '咨询时间',
  `consult_type` tinyint(1) DEFAULT '1' COMMENT '1 商品咨询 2 支付咨询 3 配送 4 售后',
  `content` varchar(1024) CHARACTER SET utf8 DEFAULT '' COMMENT '咨询内容',
  `parent_id` int(11) DEFAULT '0' COMMENT '父id 用于管理员回复',
  `is_show` tinyint(1) DEFAULT '0' COMMENT '是否显示',
  `status` tinyint(1) DEFAULT '0' COMMENT '管理员回复状态，0未回复，1已回复',
  PRIMARY KEY (`id`)
)  AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

/*Data for the table `tp_goods_consult` */

LOCK TABLES `tp_goods_consult` WRITE;

insert  into `tp_goods_consult`(`id`,`goods_id`,`username`,`add_time`,`consult_type`,`content`,`parent_id`,`is_show`,`status`) values (1,56,'15915407513',1523340349,3,'请问配送的方式是什么？',0,0,0),(2,56,'',1523349612,3,'默认是中通圆通快递，72小时内发货',1,1,0),(3,79,'15915407513',1523858731,1,'商品有保修期多久吗？',0,0,0),(4,79,'',1523858835,1,'感谢你的咨询，很高兴能为你服务，商品的保修期为2年之内，免费维修，谢谢关注！',3,1,0),(5,93,'15915407513',1523871753,3,'yuyyeuej',0,0,0),(6,93,'15915407513',1523931664,2,'订单是否',0,0,0),(7,97,'青春',1524187287,2,'在线支付',0,1,0),(8,97,'青春',1524187621,4,'售后呀',0,1,0),(9,97,'青春',1524187656,3,'配送',0,1,0),(10,97,'青春',1524187695,1,'咨询',0,1,0),(11,225,'15915407513',1524207834,3,'2852588285',0,0,0),(12,225,'',1524207863,3,'85828282822',11,1,0),(13,225,'15915407513',1524207892,2,'2858582',0,0,0),(14,225,'',1524207934,2,'2858522',13,1,0),(15,225,'15915407513',1524208097,1,'你好恨你后悔考虑了咯了来得及发货了时光飞逝管理会计改李四施工方了卡回复老师傅历史课斐林试剂方式开发说过话ID卡李狗嗨改回来打开拉近代理商刚回来说过话了手机格式霍林郭勒市过来是还是活动偶偶扩绿扩扩多扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩',0,0,0),(16,225,'',1524208126,1,'ni好恨你后悔考虑了咯了来得及发货了时光飞逝管理会计改李四施工方了卡回复老师傅历史课斐林试剂方式开发说过话ID卡李狗嗨改回来打开拉近代理商刚回来说过话了手机格式霍林郭勒市过来是还是活动偶偶扩绿扩扩多扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩扩',15,1,0);

UNLOCK TABLES;

/*Table structure for table `tp_goods_coupon` */

DROP TABLE IF EXISTS `tp_goods_coupon`;

CREATE TABLE `tp_goods_coupon` (
  `coupon_id` int(8) NOT NULL COMMENT '优惠券id',
  `goods_id` int(11) NOT NULL DEFAULT '0' COMMENT '指定的商品id：为零表示不指定商品',
  `goods_category_id` smallint(5) NOT NULL DEFAULT '0' COMMENT '指定的商品分类：为零表示不指定分类',
  PRIMARY KEY (`coupon_id`,`goods_id`,`goods_category_id`)
)  DEFAULT CHARSET=latin1;

/*Data for the table `tp_goods_coupon` */

LOCK TABLES `tp_goods_coupon` WRITE;

insert  into `tp_goods_coupon`(`coupon_id`,`goods_id`,`goods_category_id`) values (5,203,0),(6,0,15),(8,204,0),(9,0,444),(18,0,91),(19,0,0),(24,0,0),(26,201,0),(28,49,0),(29,228,0),(30,0,94),(31,229,0);

UNLOCK TABLES;

/*Table structure for table `tp_goods_images` */

DROP TABLE IF EXISTS `tp_goods_images`;

CREATE TABLE `tp_goods_images` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '图片id 自增',
  `goods_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `image_url` varchar(255) NOT NULL DEFAULT '' COMMENT '图片地址',
  PRIMARY KEY (`img_id`),
  KEY `goods_id` (`goods_id`)
)  AUTO_INCREMENT=948 DEFAULT CHARSET=utf8;

/*Data for the table `tp_goods_images` */

LOCK TABLES `tp_goods_images` WRITE;

insert  into `tp_goods_images`(`img_id`,`goods_id`,`image_url`) values (1,1,'/public/upload/goods/2018/04-09/5d20aae3bd2954be026ae678ffd9ed58.png'),(2,1,'/public/upload/goods/2018/04-09/db91d22adb5bdd4a651b820b3c8f196c.png'),(3,1,'/public/upload/goods/2018/04-09/620d40fa02bcd43c560d3eefcfb0432e.png'),(4,1,'/public/upload/goods/2018/04-09/d96fb77b4b031933c7d50d9e5d4dba34.png'),(5,2,'/public/upload/goods/2018/04-09/fae5286b27e625cd1cad58dc63cc3af0.png'),(6,2,'/public/upload/goods/2018/04-09/1b85ff9608352e069719d6f7cac27c74.png'),(7,2,'/public/upload/goods/2018/04-09/3d259c19117f1129084fb95c64132da9.png'),(8,2,'/public/upload/goods/2018/04-09/db32f76fb523f7b7567d9dfae1de390b.png'),(9,2,'/public/upload/goods/2018/04-09/353ae10af30f10f24cf3246a8ed695ca.png'),(10,3,'/public/upload/goods/2018/04-09/00218db8155e70da05d95537caddf0ff.png'),(11,3,'/public/upload/goods/2018/04-09/0acf307eed845f553a5328088a82a2c5.png'),(12,3,'/public/upload/goods/2018/04-09/d46ad26aaf034e3b2966204f078d55a7.png'),(13,3,'/public/upload/goods/2018/04-09/bdb2cc27427ec4b31284548d50c666ee.png'),(14,4,'/public/upload/goods/2018/04-09/d51297e77f522e0bb29f6fd42e856cbe.png'),(15,4,'/public/upload/goods/2018/04-09/6323a3292412a5e996b87aba314cf5a4.png'),(16,4,'/public/upload/goods/2018/04-09/f31642cd128aec2a27c94460b0690379.png'),(20,5,'/public/upload/goods/2018/04-09/2444f6f4aeb6f6c7e96609cd0ab7efb2.png'),(21,5,'/public/upload/goods/2018/04-09/e315b5f11af65c73e32b25f6638f76fc.png'),(22,5,'/public/upload/goods/2018/04-09/0924f5ef5e4565cd79a6886a25568346.png'),(793,5,'/public/upload/goods/2018/04-17/5766e3578552ae123da53a653bc6dae2.png'),(24,6,'/public/upload/goods/2018/04-09/a438ee20c8db25b5b9c998edf0ac7b44.png'),(25,6,'/public/upload/goods/2018/04-09/33023139b1aa9b35afca096c6ae742dd.png'),(26,6,'/public/upload/goods/2018/04-09/a89fdff3269435fb119ebc03778fd35a.png'),(27,7,'/public/upload/goods/2018/04-09/1353a7b1660ede6d22e56787df7293ee.jpg'),(28,7,'/public/upload/goods/2018/04-09/cd976c9e183d74ffa774dcb8dc3ac54c.jpg'),(29,7,'/public/upload/goods/2018/04-09/c0f421ec3f51c2b2132e127295e7b799.jpg'),(30,7,'/public/upload/goods/2018/04-09/69a02ebd471662dc51b403eb602cfd86.jpg'),(31,7,'/public/upload/goods/2018/04-09/785bd0298e2ed59af68e69c167a503ef.jpg'),(32,7,'/public/upload/goods/2018/04-09/e60ff1a4c481dfa69cec48508a665f42.jpg'),(33,8,'/public/upload/goods/2018/04-09/5514304fa76cbfa9cfc3c7b870e02fd8.png'),(34,8,'/public/upload/goods/2018/04-09/edbe194d6da64164cb64d9b74ddb4f27.png'),(35,8,'/public/upload/goods/2018/04-09/f30753f2a79873184a7f42012b1bb913.png'),(36,8,'/public/upload/goods/2018/04-09/95910462a4d03ca1aaccece1fd9555f7.png'),(37,8,'/public/upload/goods/2018/04-09/9b0b9771e13df4e936cd325bb4e9f695.png'),(38,9,'/public/upload/goods/2018/04-09/4416d9327a4a9e81e723fb93541fa292.png'),(890,214,'/public/upload/goods/2018/04-18/922b3fabc508efe0cdd6580f66d8b5c9.png'),(760,10,'/public/upload/goods/2018/04-17/6cf45341a1a43fc9d90672f36bbf1ad6.png'),(759,10,'/public/upload/goods/2018/04-17/96d66cc83ee25905a29e2a472c99f9eb.png'),(852,13,'/public/upload/goods/2018/04-17/4c67162a2a45e4c4fbfea50b64241567.png'),(853,13,'/public/upload/goods/2018/04-17/9566bd7008d9046c9f93a2c78d96d7c8.png'),(758,10,'/public/upload/goods/2018/04-17/e4ed597599e49f67818f928e33007fb8.png'),(855,25,'/public/upload/goods/2018/04-17/7c1b3ffb3a6ac2091377bc8ecd685046.png'),(54,12,'/public/upload/goods/2018/04-09/53a885ee3892175d5c56fea69db7305c.png'),(48,9,'/public/upload/goods/2018/04-09/1853e86ba507e1a0015064ab4147a974.png'),(49,9,'/public/upload/goods/2018/04-09/bd0a7c3ec19ee8d0b52c571fb7232d9f.png'),(50,11,'/public/upload/goods/2018/04-09/89917c25664b5a1e5f6c2b096f9768df.png'),(51,11,'/public/upload/goods/2018/04-09/a61133c77ab3264ab88688d3c79cac2d.png'),(52,11,'/public/upload/goods/2018/04-09/0e65979e92d876ec63d84496dd5f64f1.png'),(53,11,'/public/upload/goods/2018/04-09/10c3f3f3684d7f8934124d5cf39e1be8.png'),(889,203,'/public/upload/goods/2018/04-17/fee5de91cab8e950236b5b5f6cc75b32.png'),(884,72,'/public/upload/goods/2018/04-17/bcc5c85d4d42f2f24fefa0f9479328e5.png'),(882,14,'/public/upload/goods/2018/04-17/05f04231197fd14b76d3346cb4b175f2.png'),(881,14,'/public/upload/goods/2018/04-17/21539af2ca84292f73374bc48497579b.png'),(880,14,'/public/upload/goods/2018/04-17/f2e199fdc413372717f6fc7427a1086f.png'),(65,15,'/public/upload/goods/2018/04-09/5d9607b7e728bfbf7a340330d58d604b.png'),(66,15,'/public/upload/goods/2018/04-09/b6b5cc9d6555e11a2ce8d94d3571072f.png'),(67,15,'/public/upload/goods/2018/04-09/8ed8f1e12deb503bc57314d81bda435f.png'),(68,15,'/public/upload/goods/2018/04-09/8f57f9bf241b5d4b180c48c9502c5fe2.png'),(69,16,'/public/upload/goods/2018/04-09/6e81bdb2e0a3ecc8ad546f99bd577a74.png'),(70,16,'/public/upload/goods/2018/04-09/59ec0386cd422153c8d4e6ece78a2277.png'),(71,16,'/public/upload/goods/2018/04-09/24477b9223ab48ed3aba0aa3f37761ec.png'),(72,16,'/public/upload/goods/2018/04-09/6cb8bbc78833d04a1253aa8cfc485b42.png'),(73,17,'/public/upload/goods/2018/04-09/cc0cc16df043df1ad3737295e6c4fd2e.png'),(74,17,'/public/upload/goods/2018/04-09/5651cc31ccec64db9fd5212b5acf6131.png'),(75,17,'/public/upload/goods/2018/04-09/addd9ff376d0aad2ccb82fac21fb1f40.png'),(76,18,'/public/upload/goods/2018/04-09/3777e0843252de68b331c85673c3f810.png'),(77,18,'/public/upload/goods/2018/04-09/46ba2ebf30010ed5d04a3659a93f57ad.png'),(78,18,'/public/upload/goods/2018/04-09/3718bc2f58e87144d656ca57c0c6e00b.png'),(79,18,'/public/upload/goods/2018/04-09/a42b0da5fbf661c8aca1e70b882d56bc.png'),(559,141,'/public/upload/goods/2018/04-13/5153d87f7d37ab95c32af3d988a05bbc.jpg'),(558,140,'/public/upload/goods/2018/04-13/52bd95ac311ffe084759808a7b890105.png'),(557,140,'/public/upload/goods/2018/04-13/4bdf140970899f271bcf6d0eff6dbc2c.png'),(546,138,'/public/upload/goods/2018/04-13/6993a93210dc7b9381fb4d932bc28d66.png'),(757,20,'/public/upload/goods/2018/04-17/16bbd0cc84f5db6e2616e76318d892cd.png'),(87,20,'/public/upload/goods/2018/04-09/1bd485a78ff5be6e946026a229de05d9.png'),(88,20,'/public/upload/goods/2018/04-09/3968c7f3377f143b336a7ce8110baa00.png'),(89,20,'/public/upload/goods/2018/04-09/f6bdf313ca897ea406a1a0110e3a64a7.png'),(90,21,'/public/upload/goods/2018/04-09/c6a16618053bcc67b1bd354ff1fa0976.png'),(91,21,'/public/upload/goods/2018/04-09/98eb3b008be2efe66a62d5a0e1b521a4.png'),(92,21,'/public/upload/goods/2018/04-09/331b6ea4ca068cb00016f6dced072b6a.png'),(93,21,'/public/upload/goods/2018/04-09/382a98b973feca7d1a7b3091abd79d46.png'),(94,21,'/public/upload/goods/2018/04-09/51ff3ec3ded2d4ce2d70b03171f63fd6.png'),(95,22,'/public/upload/goods/2018/04-09/40ba16ecbbfe7eebe668ee086ea705d6.jpg'),(96,22,'/public/upload/goods/2018/04-09/158af6298c8d391c33193bc0d3ca34f1.jpg'),(97,23,'/public/upload/goods/2018/04-09/2df25ccda9b6734c2dc78081fade3741.png'),(98,23,'/public/upload/goods/2018/04-09/d94232557b26d601af0717c37868bc1b.png'),(99,23,'/public/upload/goods/2018/04-09/14bb558d347961b36d1f53fed03f579a.png'),(100,24,'/public/upload/goods/2018/04-09/1baa3c8f8dcb7238cbfb160a3e75bca1.png'),(101,24,'/public/upload/goods/2018/04-09/88a61ead3d261d004067b8ff66482de1.png'),(102,24,'/public/upload/goods/2018/04-09/5b683227df72fa2b75b792d7c28ffd82.png'),(103,24,'/public/upload/goods/2018/04-09/bcd7017574ddc3bdb3536b3cb64e667c.png'),(104,24,'/public/upload/goods/2018/04-09/bbd9dbc930575d192b8a1e731d245771.png'),(105,24,'/public/upload/goods/2018/04-09/a9cd52fa7396a832105b76774c6b1a3d.png'),(854,25,'/public/upload/goods/2018/04-17/9021d9a5a60989500d49078cd1e7ff72.png'),(107,26,'/public/upload/goods/2018/04-09/4693f619838f0b2a6fd382b6f5060a11.png'),(108,26,'/public/upload/goods/2018/04-09/543edc0d39b62c2fbdcd19c42104dcb3.png'),(109,26,'/public/upload/goods/2018/04-09/f47708cffe0e745acc866227ad1a9acc.png'),(110,26,'/public/upload/goods/2018/04-09/c7c3bc9492bd222d7f525ecbd7f9bdc4.png'),(111,26,'/public/upload/goods/2018/04-09/8d3d789fdb4f3cfb9c5124930577a0ae.png'),(112,26,'/public/upload/goods/2018/04-09/9eed16eb1b1f1f3ccc4fe89131ad4d96.png'),(113,27,'/public/upload/goods/2018/04-09/97bd287a75006c1d17bc891deb8a88ca.jpg'),(114,27,'/public/upload/goods/2018/04-09/929328bbb0d671e9b682321bd5afe949.jpg'),(115,27,'/public/upload/goods/2018/04-09/c22b12d769d98745fd724a0c3b80919c.jpg'),(116,27,'/public/upload/goods/2018/04-09/3439ff946b1f4120be63b760c1911154.jpg'),(117,28,'/public/upload/goods/2018/04-10/3e4d1493f780facd4e44fe96e4d1c29b.png'),(118,28,'/public/upload/goods/2018/04-10/b45e4e6465c25bb2a47661995bdbc92a.png'),(119,28,'/public/upload/goods/2018/04-10/1c989e14b0129a6853759aa6b3385e2e.png'),(120,28,'/public/upload/goods/2018/04-10/693cda63395478bf2f615514b3808be4.png'),(121,28,'/public/upload/goods/2018/04-10/9008a3690f551462212d2832f5af902d.png'),(122,28,'/public/upload/goods/2018/04-10/412b393ec99ce6b54b9a7879e6ef9e2f.png'),(123,30,'/public/upload/goods/2018/04-10/53f135984e73edf15c9c08f3fb6a226f.png'),(124,31,'/public/upload/goods/2018/04-10/d045f9c1ca75fc07cf833264b59aad10.jpg'),(125,31,'/public/upload/goods/2018/04-10/c2df8dfb260334a0ced134a9a045875e.jpg'),(826,32,'/public/upload/goods/2018/04-17/c82a80c273b369dfab1afeea2fab9d85.png'),(827,210,'/public/upload/goods/2018/04-17/89a39a36311298e0578772db0332a336.jpg'),(128,33,'/public/upload/goods/2018/04-10/edc2f2088212fc4ab04389930f7e42cc.jpg'),(129,33,'/public/upload/goods/2018/04-10/c070cba2bda2eb8203716dc24f4db6e2.jpg'),(130,33,'/public/upload/goods/2018/04-10/66fde8b298b41558924be40f83f0fd21.jpg'),(131,34,'/public/upload/goods/2018/04-10/4012cf71e197ad520cb0a6e9487e961a.png'),(132,34,'/public/upload/goods/2018/04-10/56a72a6605475775e53c44a353e11618.png'),(133,34,'/public/upload/goods/2018/04-10/ce0e18e60aa486385a842f557176a734.png'),(134,34,'/public/upload/goods/2018/04-10/f4704d69d683e56daf803eb932c6fa71.png'),(135,34,'/public/upload/goods/2018/04-10/d4dde38bfad158b61de22932f14a73cd.png'),(136,34,'/public/upload/goods/2018/04-10/d823c918acd62639aedad0b02e3f3b0f.png'),(137,35,'/public/upload/goods/2018/04-10/6060d49d72db0a3dea1b01f9891f25a7.png'),(138,35,'/public/upload/goods/2018/04-10/f99bf668f9590cb697d9f8597f015076.png'),(139,35,'/public/upload/goods/2018/04-10/a6b3ab464717075a94291d1ac92d0129.png'),(140,35,'/public/upload/goods/2018/04-10/f4848eb760c4a1c791c1e9e5f6db8790.png'),(141,36,'/public/upload/goods/2018/04-10/9e1a6ac2ccd29c97245971c66d53037e.png'),(142,36,'/public/upload/goods/2018/04-10/8a166dc665a2f3a1ac8b694a2283ff43.png'),(143,36,'/public/upload/goods/2018/04-10/aef26a8fc8578b7b160e7a16c2430593.png'),(144,36,'/public/upload/goods/2018/04-10/06a3df8c92bb3b491c1d633dd23a9920.png'),(145,36,'/public/upload/goods/2018/04-10/dc78ded272ec8fdb9acfbb7702064ac7.png'),(146,37,'/public/upload/goods/2018/04-10/0637d340d8b2dead246eadea6fab09df.jpg'),(147,37,'/public/upload/goods/2018/04-10/3abf6f170ec1a72892fad0fc8da8b058.jpg'),(148,37,'/public/upload/goods/2018/04-10/79d5c1abfa5a16d51740014fdf11d9f4.jpg'),(149,37,'/public/upload/goods/2018/04-10/5825b1b2c49c832fe04a1dba3d5f6045.jpg'),(150,38,'/public/upload/goods/2018/04-10/66ba200d16177e219b46f87644b65513.png'),(151,38,'/public/upload/goods/2018/04-10/f3720d1ed8fed4ef6a08dcf418d032dd.png'),(152,38,'/public/upload/goods/2018/04-10/3a8096bd702938df4cbe2d7920f1ffaf.png'),(153,38,'/public/upload/goods/2018/04-10/5f130444a3e5d8bb2b5355c4d5594841.png'),(154,39,'/public/upload/goods/2018/04-10/5ca310ba090891abf6597a7079f55244.jpg'),(155,40,'/public/upload/goods/2018/04-10/9b64b1402226e66133557c611ce07fad.png'),(156,40,'/public/upload/goods/2018/04-10/80db20c99e718329eb1d0341f5e2243d.png'),(157,40,'/public/upload/goods/2018/04-10/52115054d3a0b6f1e55509ada12a7c47.png'),(158,40,'/public/upload/goods/2018/04-10/cba7d4b50f9d6313678bab400b6ee326.png'),(159,40,'/public/upload/goods/2018/04-10/39d69859b1e277dbd06f40e39c750c45.png'),(160,41,'/public/upload/goods/2018/04-10/c2a093afbb33e4a94e609b0bb672767a.png'),(161,41,'/public/upload/goods/2018/04-10/c23652365447e6761080e6851fe4e984.png'),(162,41,'/public/upload/goods/2018/04-10/e7ab2c797faf32bb69a53041e6fb63f9.png'),(163,41,'/public/upload/goods/2018/04-10/3102a4330217107aaeec3b0520c9f0d1.png'),(164,42,'/public/upload/goods/2018/04-10/ba1ebddafdbff7cf1f1f525a0ebf8380.jpg'),(165,42,'/public/upload/goods/2018/04-10/3aedcf2b59d6c1321655e23491e8e7ba.jpg'),(166,42,'/public/upload/goods/2018/04-10/19adf9e20a05225a32bac5ad1fee9533.jpg'),(167,43,'/public/upload/goods/2018/04-10/0af6a45ac7251e90c90901575cbcc5e8.jpg'),(168,43,'/public/upload/goods/2018/04-10/8209c084dc30cc4d4b75e6f4247a2d80.jpg'),(169,44,'/public/upload/goods/2018/04-10/6ae8b3366ff76e58815a71210c8d8628.png'),(170,44,'/public/upload/goods/2018/04-10/7dede49ed81874a4fe5695e51532567f.png'),(171,44,'/public/upload/goods/2018/04-10/d8920f78f2856c770455fb38c1273061.png'),(172,44,'/public/upload/goods/2018/04-10/b61cce8b55ecfbc45b5343cca30d2d59.png'),(173,44,'/public/upload/goods/2018/04-10/466d5ce3aed50b00f5a94de5a3c33b40.png'),(174,44,'/public/upload/goods/2018/04-10/acbc2a97b56c4fb0892aa4e9437544b9.png'),(175,45,'/public/upload/goods/2018/04-10/0da49e307abddb8d0f3a0e44d0ec9966.jpg'),(176,45,'/public/upload/goods/2018/04-10/9738a2207124267cac641092dd8f804f.jpg'),(177,46,'/public/upload/goods/2018/04-10/9bc9d133a83fa1581250a117cb33934e.png'),(178,46,'/public/upload/goods/2018/04-10/61ad33d96a5cd7d876911f1879261108.png'),(179,46,'/public/upload/goods/2018/04-10/83cfe35e531a724af5caabb748ab934f.png'),(180,46,'/public/upload/goods/2018/04-10/e8ffbda58ffa9389ee4496b5f3fce085.png'),(181,46,'/public/upload/goods/2018/04-10/506579e2a0121b215f262b31314db2ce.png'),(182,46,'/public/upload/goods/2018/04-10/aaf7d1cfedc544d0582dea4cc8c8fc1d.png'),(183,47,'/public/upload/goods/2018/04-10/a92624860ad986f1b44c29f6c1cdd727.png'),(184,47,'/public/upload/goods/2018/04-10/2007b2ec3ad57917a80776cb5994299c.png'),(185,47,'/public/upload/goods/2018/04-10/dbe9cf99de33da44fe6f60a17c753a34.png'),(186,47,'/public/upload/goods/2018/04-10/26f365bdab32f6aaf21530719db65e71.png'),(187,47,'/public/upload/goods/2018/04-10/af510a77361284ae3a89c8a06a65675e.png'),(188,47,'/public/upload/goods/2018/04-10/0fe936c3116ee2e7b8f7e86a897449c8.png'),(189,48,'/public/upload/goods/2018/04-10/3f8ce030494c81c32b3ffc670dc4cac0.png'),(190,48,'/public/upload/goods/2018/04-10/ad80a050c0de97d996f7a1d0c386cb26.png'),(191,48,'/public/upload/goods/2018/04-10/39f6ad7c33bbf8c2129b8fa4c495eae4.png'),(192,48,'/public/upload/goods/2018/04-10/33edbc919e663dbeb7f2a4e8cca3fc7a.png'),(193,48,'/public/upload/goods/2018/04-10/fc155430d97b7da503b37064a06006d0.png'),(194,48,'/public/upload/goods/2018/04-10/829b8716e008160f0a162081440013c4.png'),(894,217,'/public/upload/goods/2018/04-19/8359a1dd1f0f965fb0afbe03ab99fe8a.jpg'),(871,49,'/public/upload/goods/2018/04-17/90ff062b620fee75cf2295450f81d3b3.png'),(870,49,'/public/upload/goods/2018/04-17/2014654b0270e0a40ecbd3c83796d606.png'),(198,49,'/public/upload/goods/2018/04-10/a967ffd5736c421b0db1ca048cf65da0.png'),(199,50,'/public/upload/goods/2018/04-10/3364cb6cd960abf23c0521b6610dbd76.png'),(200,50,'/public/upload/goods/2018/04-10/b2d68a7b262229122a2356404b44876b.png'),(201,50,'/public/upload/goods/2018/04-10/3cd420d309451aee058cd17ab6e1fe87.png'),(202,51,'/public/upload/goods/2018/04-10/21ecc8a426cff2ccecc3009217341d7d.jpg'),(203,52,'/public/upload/goods/2018/04-10/915d363536c25771cebd4741e9a84bd2.png'),(204,52,'/public/upload/goods/2018/04-10/84767130e8212704110304ce5e7d664a.png'),(205,52,'/public/upload/goods/2018/04-10/346c889265fbb7db722dfb3421a8cd72.png'),(206,52,'/public/upload/goods/2018/04-10/6ac4b759421fcff73fb51f46322fc9c4.png'),(207,53,'/public/upload/goods/2018/04-10/e0badd92d48dfad8835c23dc9774eb78.jpg'),(208,53,'/public/upload/goods/2018/04-10/1597878f928d1778efed477389595be5.jpg'),(209,54,'/public/upload/goods/2018/04-10/fc03e27c7c366b6f9b612af123d2e610.png'),(893,217,'/public/upload/goods/2018/04-19/81e20f556d8937364ed1aa6dd57d2e1f.jpg'),(873,55,'/public/upload/goods/2018/04-17/469c0d1d34723b1a55155c9b42c36158.png'),(872,55,'/public/upload/goods/2018/04-17/7c1c0eacdda4ad418e8673127b0e4c7e.png'),(213,55,'/public/upload/goods/2018/04-10/b38fa43cbff3171c8f35821388363b2d.png'),(214,56,'/public/upload/goods/2018/04-10/3b91ecc1ad989a184751aa4fbaf746fd.jpg'),(215,56,'/public/upload/goods/2018/04-10/8205df2cb9866bc13a2f8d42296f0e1c.jpg'),(216,57,'/public/upload/goods/2018/04-10/02b48666bbd133689a8282417cfe2218.png'),(217,58,'/public/upload/goods/2018/04-10/c749ef6cf26e673039700a097a1319a3.jpg'),(892,216,'/public/upload/goods/2018/04-18/3c3027bd9623757873950a3cbe4641a6.png'),(877,59,'/public/upload/goods/2018/04-17/bd8a9c1a3c2b48a66a0726e9c7e38a2f.png'),(876,59,'/public/upload/goods/2018/04-17/d929f4b1d413707e7394898018b0f53c.png'),(875,59,'/public/upload/goods/2018/04-17/1d2705296e3d1e216cc1ac981126d9d0.png'),(874,59,'/public/upload/goods/2018/04-17/b84bbc5899df39a58ed3391ed797667a.png'),(223,59,'/public/upload/goods/2018/04-10/85d1189a30db5d96b362a1d04d7f5e7f.png'),(224,58,'/public/upload/goods/2018/04-10/087f5ba0824b00d41465fb537e342182.jpg'),(225,58,'/public/upload/goods/2018/04-10/2653b60bce4e1fd87282833e65193bec.jpg'),(226,58,'/public/upload/goods/2018/04-10/4e580457290db72c29f1514aa3b4a9db.jpg'),(227,60,'/public/upload/goods/2018/04-10/e0bcad255a81b049b986241a59d5f05b.jpg'),(228,60,'/public/upload/goods/2018/04-10/e96caa242ba06722a50b0e2525e7a6ed.jpg'),(766,194,'/public/upload/goods/2018/04-17/137702f1eb232d14c8c7edb5cbad968f.png'),(765,194,'/public/upload/goods/2018/04-17/cee81489e3a65abe02de93b44129e0c6.png'),(764,194,'/public/upload/goods/2018/04-17/623730ccb4ba7dc933cbfb6537b90533.png'),(242,63,'/public/upload/goods/2018/04-10/f744680215840cbe5d9cb7d01047ba90.jpg'),(241,63,'/public/upload/goods/2018/04-10/cbbb10f3294be4d09b66a679eb5ff54d.jpg'),(240,63,'/public/upload/goods/2018/04-10/01bb2ee3d2bfbcbcaf3021d97a06f50b.jpg'),(235,62,'/public/upload/goods/2018/04-10/68f71c4e64a067d74c21a6a269ca51ca.png'),(236,62,'/public/upload/goods/2018/04-10/a7da9f741cce3cbfb60809301a93117f.png'),(237,62,'/public/upload/goods/2018/04-10/4ed2aaf446639a6684b7e0a36ef46074.png'),(238,62,'/public/upload/goods/2018/04-10/2024373f30aacbc6db98461653893633.png'),(239,62,'/public/upload/goods/2018/04-10/60f9658269c4f1c1390ecd48455d72f7.png'),(763,194,'/public/upload/goods/2018/04-17/6113022a41c146056a2d31faa63e0c25.png'),(762,193,'/public/upload/goods/2018/04-17/08b6fcdbbaa2583939685981f1f9a4d4.png'),(248,65,'/public/upload/goods/2018/04-10/156954fb001311c433b4d4912aebff83.png'),(249,65,'/public/upload/goods/2018/04-10/1bd003a2e489c77e3c95df577e9e0b79.png'),(250,65,'/public/upload/goods/2018/04-10/22e89a2c1c6ca5a4f4e023c75d91f578.png'),(251,65,'/public/upload/goods/2018/04-10/dceed5b2de1f23b93b483ae7ae470191.png'),(252,65,'/public/upload/goods/2018/04-10/0e95a61a8ab8cadf03267eb83d61c0b7.png'),(253,65,'/public/upload/goods/2018/04-10/196183aeee0e4b4e1a18a109d53ddd4b.png'),(254,66,'/public/upload/goods/2018/04-10/e8881f6aa93c6d75ab741eb9f5f572e1.png'),(255,66,'/public/upload/goods/2018/04-10/fb0bb62725062134e86fe76adcdd9e65.png'),(256,66,'/public/upload/goods/2018/04-10/fb4930dddf551b2e76b5dcab4350822f.png'),(257,66,'/public/upload/goods/2018/04-10/98b499ae1946723f1bb5c66b9ea09427.png'),(258,66,'/public/upload/goods/2018/04-10/4597b6a81fac4e351b41161e6b60bc0e.png'),(259,66,'/public/upload/goods/2018/04-10/b40b673371bdb52e64b759199b044c98.png'),(260,67,'/public/upload/goods/2018/04-10/5ee41fe4e7320fb595fb6a3427e5a0da.jpg'),(261,67,'/public/upload/goods/2018/04-10/910318b46d270979a19df0dd97c3a6ac.jpg'),(262,68,'/public/upload/goods/2018/04-10/58f30c5607565e8275a67c003c5548b1.jpg'),(263,68,'/public/upload/goods/2018/04-10/cbb47f78209bae16d9ee0856f6bc675f.jpg'),(264,69,'/public/upload/goods/2018/04-10/8e02b2d2bc6d21e24c6c45cda20a3783.png'),(265,69,'/public/upload/goods/2018/04-10/28a2df2063b448587fa73eef68148db4.png'),(266,69,'/public/upload/goods/2018/04-10/a2d16fa1399fdf048d762679b23174c7.png'),(267,69,'/public/upload/goods/2018/04-10/9b0546f9ff132810e4ab4beab089d679.png'),(604,154,'/public/upload/goods/2018/04-16/06c7a865b0e3ba1ec411d00ca328924d.png'),(603,154,'/public/upload/goods/2018/04-16/b9b85251e0c4e63c47321299a2fe1e29.png'),(270,70,'/public/upload/goods/2018/04-10/8d2a5998c4bba18e1e13a6b535d3c679.png'),(271,70,'/public/upload/goods/2018/04-10/c511a485e280df36e03d95c6c68eff88.png'),(272,70,'/public/upload/goods/2018/04-10/ddd93fb0e010481180fc193872d63b56.png'),(273,70,'/public/upload/goods/2018/04-10/4e8fb11c4151924c746d45fb1ee2b5b4.png'),(274,70,'/public/upload/goods/2018/04-10/edfc8d90a853cdb3f87a87e2983306ec.png'),(275,70,'/public/upload/goods/2018/04-10/a68b6606db6dce312c0a83b57091db7f.png'),(276,71,'/public/upload/goods/2018/04-10/c89eddd181097be7329f2a4f6fad2b2a.png'),(277,71,'/public/upload/goods/2018/04-10/55c8784594ebb04c59e02f7c629ae50d.png'),(278,71,'/public/upload/goods/2018/04-10/690e7c8b9ea1e223766d1d46284bca37.png'),(279,71,'/public/upload/goods/2018/04-10/9ad152a8b4af19d1b2cd6c80a08bba1f.png'),(280,71,'/public/upload/goods/2018/04-10/6f729af93b3a04b4676148d4c5fe6845.png'),(281,71,'/public/upload/goods/2018/04-10/f20390b709011c472e5c5161a8d7a7f3.png'),(883,72,'/public/upload/goods/2018/04-17/509be4337aab1572baa652bbbe0416ec.png'),(283,72,'/public/upload/goods/2018/04-10/b810d7e9771a6fdca200b867ab96c89e.jpg'),(284,73,'/public/upload/goods/2018/04-10/1cb995c9583987b3aa09a610c4f9dd30.png'),(285,73,'/public/upload/goods/2018/04-10/483b18b4ba05b8134718dffe465bc147.png'),(286,73,'/public/upload/goods/2018/04-10/663bbe0135cdcea3ca394a2b9f2b9754.png'),(287,73,'/public/upload/goods/2018/04-10/517eb240fec52b6bb8f182a12868d5c4.png'),(288,73,'/public/upload/goods/2018/04-10/47273d5fcc4c62ed2be12cdbc209f585.png'),(289,73,'/public/upload/goods/2018/04-10/27fd77786c82fd2802a14dd57c83983c.png'),(290,73,'/public/upload/goods/2018/04-10/b226bba8f6eaf9cf41bef60817a75269.png'),(291,73,'/public/upload/goods/2018/04-10/9733ec1c65330990c7cc01710acda00b.png'),(292,74,'/public/upload/goods/2018/04-10/be868501fea75f9c3abaee877b9d6876.jpg'),(293,74,'/public/upload/goods/2018/04-10/4190c48be10ab0be8ba6e5a9b11e0461.jpg'),(294,75,'/public/upload/goods/2018/04-10/99c1ded2d9ae2c5a98353e940faa68d7.png'),(295,75,'/public/upload/goods/2018/04-10/ad1cdeaaf608f8d7e3c50f3618a7fa3e.png'),(296,75,'/public/upload/goods/2018/04-10/19ccc43d3ef007ff57dd1b8c5a73703d.png'),(297,75,'/public/upload/goods/2018/04-10/74363fef7e010fe03dd0ebcf07936455.png'),(298,75,'/public/upload/goods/2018/04-10/99b8add4c9fb54b7f3ae5ada54308bb1.png'),(299,76,'/public/upload/goods/2018/04-10/725f99dcdecece64ca35e000db24a07d.png'),(300,76,'/public/upload/goods/2018/04-10/7046b26d7da38d07057c391334eaf19a.png'),(301,76,'/public/upload/goods/2018/04-10/b4e2c6f43eb24c920502083487b7a987.png'),(302,76,'/public/upload/goods/2018/04-10/749160a39cf6b132d4c897ebd1155978.png'),(303,76,'/public/upload/goods/2018/04-10/359d8a160df53b17ef7572f5b07fe963.png'),(304,77,'/public/upload/goods/2018/04-10/19b969b995fc04dc6a8f6f8db16e3ea3.jpg'),(305,77,'/public/upload/goods/2018/04-10/967e552740e31eccacfc9dae47b295f0.jpg'),(306,77,'/public/upload/goods/2018/04-10/a44ada0b44d2e956da3be3a6250e8c69.jpg'),(307,77,'/public/upload/goods/2018/04-10/76375dc42c7815d169756466c185b8e4.jpg'),(308,78,'/public/upload/goods/2018/04-10/557263e075b030a3839f0b7a9f223810.png'),(309,78,'/public/upload/goods/2018/04-10/9e8a3f0b0fbf20745e6740f79b77f22c.png'),(310,78,'/public/upload/goods/2018/04-10/845e5324bea67e5992c6bc711cf15725.png'),(311,78,'/public/upload/goods/2018/04-10/b50676b8e5d2df864a862f9bcf7da7ec.png'),(858,79,'/public/upload/goods/2018/04-17/224ba3b41fa7f67f7861581748854b0c.png'),(313,80,'/public/upload/goods/2018/04-10/a8fcacba8801aabc3af9bcc2c3746b7e.png'),(314,80,'/public/upload/goods/2018/04-10/4940742216deb93e4599a3411c0970d0.png'),(315,80,'/public/upload/goods/2018/04-10/281b935d63431353df220dd998f86297.png'),(316,81,'/public/upload/goods/2018/04-10/44d3000d83951b18fce1412e529e640b.jpg'),(317,82,'/public/upload/goods/2018/04-10/5a63d2171c8b30a141c14c8b2c121e51.png'),(318,82,'/public/upload/goods/2018/04-10/68e82dc43f76884f30e32e525b5b2513.png'),(319,82,'/public/upload/goods/2018/04-10/709ba62761e1ae7988b6f19ffbb92f8f.png'),(320,82,'/public/upload/goods/2018/04-10/150f71d8f0be096eac5583f85be46e2d.png'),(324,84,'/public/upload/goods/2018/04-10/2e3713a5be50fbcf67f672fa6d68fa02.png'),(322,83,'/public/upload/goods/2018/04-10/7a643d857cbb587fbebac8bfc009fb10.jpg'),(323,83,'/public/upload/goods/2018/04-10/cb867ea2fe4064cd8196b4f0ea1424ed.jpg'),(325,84,'/public/upload/goods/2018/04-10/a8cbcf98c224e1e12ac32b494bb9e941.png'),(326,84,'/public/upload/goods/2018/04-10/ce3ea253473c1d4fef1d71301288de23.png'),(327,84,'/public/upload/goods/2018/04-10/ed2f9df009826c7e0bc9c34486b948c2.png'),(328,85,'/public/upload/goods/2018/04-10/61e908ecc8f2d156445da5f398f4c27c.png'),(329,85,'/public/upload/goods/2018/04-10/6a837b08e5dd9242ea3866a819b43cc1.png'),(330,85,'/public/upload/goods/2018/04-10/efa497d2d2e822797ddfb8e894f8b1e7.png'),(331,85,'/public/upload/goods/2018/04-10/a36d741879ed4b54733ad9d58963a3b8.png'),(332,85,'/public/upload/goods/2018/04-10/ed2433202fb8676f9df6c7ba30e52662.png'),(333,86,'/public/upload/goods/2018/04-10/df058b71b8aa197d476f46a3d812550e.png'),(334,86,'/public/upload/goods/2018/04-10/7d4f80b59d17dedb53a380c6978fadf8.png'),(335,86,'/public/upload/goods/2018/04-10/74115d4b9e49fd8f74a6439ddc8b7b5e.png'),(336,86,'/public/upload/goods/2018/04-10/7c426340a4e331a3b5a059a5ffe60f76.png'),(337,87,'/public/upload/goods/2018/04-10/816de45f4c12822ef0bf9e4ac18f8393.jpg'),(338,87,'/public/upload/goods/2018/04-10/51ede5847306bf97142ea47680ea6de1.jpg'),(339,87,'/public/upload/goods/2018/04-10/bfb0aa4fb161f570c8bad93759a6b3b6.jpg'),(340,87,'/public/upload/goods/2018/04-10/a070a8b7d989eb9240b6c30306db0cc7.jpg'),(341,87,'/public/upload/goods/2018/04-10/bc2e384d695682d5d57c5163fd8887f2.jpg'),(342,88,'/public/upload/goods/2018/04-10/ee151981e4e44eea8778b54e6494ad61.jpg'),(343,88,'/public/upload/goods/2018/04-10/f70a57b4a831b8b82db17d60e002a80a.jpg'),(344,89,'/public/upload/goods/2018/04-10/e10df95865a8f4608e25703aacb6daa6.png'),(345,89,'/public/upload/goods/2018/04-10/08d35018d5757b4ac489c0b091bf26f7.png'),(346,89,'/public/upload/goods/2018/04-10/4eb4a43fd5355207606c0aeb48488e6f.png'),(347,89,'/public/upload/goods/2018/04-10/ea84ab4fa65ba1c238a95780ccffa947.png'),(348,90,'/public/upload/goods/2018/04-10/a8bd69d100f4407b08de1909c151651a.png'),(349,90,'/public/upload/goods/2018/04-10/ff6cf5c7ca6174d1676cd4874985267f.png'),(350,90,'/public/upload/goods/2018/04-10/c6c6aacb0a3ccb44a411ee9a219b7d90.png'),(351,90,'/public/upload/goods/2018/04-10/f6f5ded7bdc445a697b3b1b310fb6351.png'),(352,91,'/public/upload/goods/2018/04-10/e8d5ee7d879a110fb086ad302312c46e.png'),(353,91,'/public/upload/goods/2018/04-10/d13865363b7efcf9ef4e624758a2679e.png'),(354,91,'/public/upload/goods/2018/04-10/6fa988aa8cc0867fa1e339e2b8d02e6b.png'),(355,91,'/public/upload/goods/2018/04-10/36a90d0cf948f9883f5ce7f8208cb4b8.png'),(356,91,'/public/upload/goods/2018/04-10/bf5d3a84353d280666b544788f0dff1e.png'),(357,91,'/public/upload/goods/2018/04-10/0b2a04a19ee871646746029fa0cba0e1.png'),(358,92,'/public/upload/goods/2018/04-10/1b08030a660239dc0382235017317c30.jpg'),(359,92,'/public/upload/goods/2018/04-10/892379001de7ff3a181267e8d8e2ecdb.jpg'),(360,92,'/public/upload/goods/2018/04-10/53e98bbbcb56d455c2a9820c334a870d.jpg'),(361,92,'/public/upload/goods/2018/04-10/6882ec5288e206872aeb16cd7a0a9df5.jpg'),(362,93,'/public/upload/goods/2018/04-10/0f9ca33fd77c5ab3a6cc3f01ae29316b.jpg'),(363,93,'/public/upload/goods/2018/04-10/76dae0f3107ac3ea6cece7a45fc45617.jpg'),(364,93,'/public/upload/goods/2018/04-10/951e2d7dffbe6ee7fed3b4491c626974.jpg'),(365,93,'/public/upload/goods/2018/04-10/5ebada09eadda508a425180086b67da7.jpg'),(366,94,'/public/upload/goods/2018/04-11/129fa7d7b9d8918fd3ccdf37fb9c7611.png'),(367,94,'/public/upload/goods/2018/04-11/0bd9b2855f04f87db4a9c86d71589f49.png'),(368,94,'/public/upload/goods/2018/04-11/65ff78a9ea2553bff95e150394fc5ed1.png'),(369,94,'/public/upload/goods/2018/04-11/f23673f91f085a27f8becb12cfbd48a3.png'),(370,94,'/public/upload/goods/2018/04-11/90fe73d9258292058250ae59fabc5e2a.png'),(371,94,'/public/upload/goods/2018/04-11/c3b2d20f27fe1bbaa0df0b6532a5253b.png'),(372,95,'/public/upload/goods/2018/04-11/cad26ef05f8b64779c202e976c9494a8.png'),(373,95,'/public/upload/goods/2018/04-11/e62b6495f5e52290b9d4c2b1ef212d8d.png'),(374,95,'/public/upload/goods/2018/04-11/162030d94807c5bb3d79c29837a8ee9d.png'),(375,95,'/public/upload/goods/2018/04-11/f74e81fb02ef5185b102b1b9d064bf88.png'),(376,95,'/public/upload/goods/2018/04-11/1159f82b3accc3009f0be3542f0260d4.png'),(377,96,'/public/upload/goods/2018/04-11/be10d109d4619ba4d3d8df0dad112f0f.jpg'),(378,96,'/public/upload/goods/2018/04-11/44cf969bfead8171aea8579971b9514f.jpg'),(379,96,'/public/upload/goods/2018/04-11/61587b190068f454369ab3e918c0003b.jpg'),(616,97,'/public/upload/goods/2018/04-16/119e81d37e572a991ab44d9b5561e0be.png'),(617,97,'/public/upload/goods/2018/04-16/681afa914ce7fb97156793922aa92990.png'),(618,97,'/public/upload/goods/2018/04-16/134d275ec606117e3583693f601c0a82.png'),(619,88,'/public/upload/goods/2018/04-16/8b6da293dcea26b33efaede0031ee76b.jpg'),(384,97,'/public/upload/goods/2018/04-11/562221075f8b7adaf1d9d139b79b24b8.png'),(385,98,'/public/upload/goods/2018/04-11/986f557b8b2beb115dacd2fcaa1a6ef1.png'),(386,98,'/public/upload/goods/2018/04-11/73fde145f76c4689026efc2aaa1325b8.png'),(387,98,'/public/upload/goods/2018/04-11/36de0c28a467904aa35277623a285045.png'),(388,98,'/public/upload/goods/2018/04-11/3725519236cf78057da53fcf92388010.png'),(389,99,'/public/upload/goods/2018/04-11/c9298db13af158daf58262a4bd0f8496.png'),(390,99,'/public/upload/goods/2018/04-11/217e573be6026b6b106926aecae673b9.png'),(391,99,'/public/upload/goods/2018/04-11/7d3d06ec22ccf2f9262ace36680555ed.png'),(392,99,'/public/upload/goods/2018/04-11/23ad4a153dd66a137204f0340ef5ceb1.png'),(393,100,'/public/upload/goods/2018/04-11/c042994bed7f64f000a85362acaa9f61.png'),(394,100,'/public/upload/goods/2018/04-11/f18ba3501165dcc656e824214124cc31.png'),(395,100,'/public/upload/goods/2018/04-11/3e95ebd56a29b84936511d5d30e8ba1c.png'),(396,100,'/public/upload/goods/2018/04-11/251754bd1c0defacf4e7d67c7e14e35d.png'),(397,100,'/public/upload/goods/2018/04-11/7505a1eeb7e731815c3b8454b52791a3.png'),(398,100,'/public/upload/goods/2018/04-11/4a1da3ed4ecb4257518efb7b39678f5e.png'),(399,101,'/public/upload/goods/2018/04-11/f9604bd580ebd220e1e98dffe205167a.jpg'),(400,101,'/public/upload/goods/2018/04-11/37d19630dde8c20aef03aa65623416b9.jpg'),(401,102,'/public/upload/goods/2018/04-11/af42f91bd305f16583ebc0279114e3de.jpg'),(402,103,'/public/upload/goods/2018/04-11/1882280caa289b2e92137733a5f60651.jpg'),(403,104,'/public/upload/goods/2018/04-11/81a330658612e028956581ecac0074f9.jpg'),(404,104,'/public/upload/goods/2018/04-11/b2ec37c304e14223353394f5957a64d7.jpg'),(405,105,'/public/upload/goods/2018/04-11/f61fe9ea19c6e03d55aa0105830a0e01.jpg'),(406,105,'/public/upload/goods/2018/04-11/36d0f38d0de0249640f4701c4b2bf7f8.jpg'),(407,105,'/public/upload/goods/2018/04-11/2b8d03b7c0b44389dda5441ef68e9cc4.jpg'),(408,106,'/public/upload/goods/2018/04-11/7d3d22f2044767e14c2a007572b01d5d.jpg'),(409,106,'/public/upload/goods/2018/04-11/0c39cf65cc88373766efc7a588f94930.jpg'),(410,106,'/public/upload/goods/2018/04-11/f341dfa12ffe449e3edf6d4467a12d5e.jpg'),(411,106,'/public/upload/goods/2018/04-11/11f802eac4f375809a313b37b5b846ba.jpg'),(412,107,'/public/upload/goods/2018/04-11/5ed542d566ac3da0086611f80fa1a4e1.jpg'),(413,107,'/public/upload/goods/2018/04-11/4e80b69a4df47d58b7b5665c21394507.jpg'),(414,108,'/public/upload/goods/2018/04-11/05b65cac800475d61acd22d885c645cc.jpg'),(415,108,'/public/upload/goods/2018/04-11/4cb95fdeb040276ae3bd7a56ec7269da.jpg'),(416,108,'/public/upload/goods/2018/04-11/c7108337952d19308c2ed783bb02cee3.jpg'),(417,109,'/public/upload/goods/2018/04-11/ea503f1fd6d19ba8cee6e5d0cb8261cc.jpg'),(418,109,'/public/upload/goods/2018/04-11/127cb503fdd78db4a89bf535f90a8658.jpg'),(419,109,'/public/upload/goods/2018/04-11/cbbf5db5593acb2ea4d1c0eefeda7264.jpg'),(420,109,'/public/upload/goods/2018/04-11/bf521ee7d32bc65883466e0117bbbf21.jpg'),(421,110,'/public/upload/goods/2018/04-11/60e69011f71240328180853aa9cf73fb.jpg'),(422,110,'/public/upload/goods/2018/04-11/502144d867b1ebe09751b0303c28ae12.jpg'),(423,110,'/public/upload/goods/2018/04-11/dd04f33806d743f1e02190dd05e2422b.jpg'),(424,111,'/public/upload/goods/2018/04-11/d65f0451191e2ebabd0fb1a565791ccd.jpg'),(425,111,'/public/upload/goods/2018/04-11/cc7135545aa4dc8f4ac87c642c2fcbd3.jpg'),(426,111,'/public/upload/goods/2018/04-11/6561d54658b97b92a3f1c2474ccbc8fa.jpg'),(427,111,'/public/upload/goods/2018/04-11/91244b45794d5ee461b55a6700fccebb.jpg'),(428,112,'/public/upload/goods/2018/04-11/62f54e15ba35b78c74a370b4f0ad5a91.jpg'),(429,112,'/public/upload/goods/2018/04-11/d5b44558287c3b9a316e38ed37a2567d.jpg'),(430,112,'/public/upload/goods/2018/04-11/c5b8be7b0af643b336608dee775a47b7.jpg'),(431,113,'/public/upload/goods/2018/04-11/b3657f541038c20ef88fab311dd838b3.jpg'),(432,113,'/public/upload/goods/2018/04-11/74c0330f817df5842e113df83103e382.jpg'),(433,113,'/public/upload/goods/2018/04-11/13d7ee8c3bb90004e589c756c422e7e0.jpg'),(434,113,'/public/upload/goods/2018/04-11/948c9a2f762c263e34e39369e1c643a8.jpg'),(435,114,'/public/upload/goods/2018/04-11/ad25907c3f1d718e40de7b922dbd0d0a.jpg'),(436,114,'/public/upload/goods/2018/04-11/7130b4eb71bd02f3f1dda07767cf86ad.jpg'),(437,114,'/public/upload/goods/2018/04-11/22adcebda9672344d9015e544f158bbb.jpg'),(438,114,'/public/upload/goods/2018/04-11/5ce2fb5c34d81c0e27388b440711916e.jpg'),(439,115,'/public/upload/goods/2018/04-12/f6271dd051f8ac8360685a3819f86850.jpg'),(440,115,'/public/upload/goods/2018/04-12/f4fd2724344165eab59ad0465b4d0915.jpg'),(441,115,'/public/upload/goods/2018/04-12/812c2c384a34876cca2b23b2b5b406cd.jpg'),(442,116,'/public/upload/goods/2018/04-12/786659b8a930465902c49ead6e93a3b2.png'),(443,116,'/public/upload/goods/2018/04-12/d6e36a3e68e70b99145879a9aa13c7ba.png'),(444,116,'/public/upload/goods/2018/04-12/7fc16b2344d8261bbe7173ce4017790e.png'),(445,116,'/public/upload/goods/2018/04-12/871c16020470b8a1c6da272c5d43f597.png'),(446,116,'/public/upload/goods/2018/04-12/0176698879fe663b731151bf2faf9306.png'),(447,116,'/public/upload/goods/2018/04-12/0bb9993ed5daeeb3656e20ba13325995.png'),(448,116,'/public/upload/goods/2018/04-12/74a188c9d7ae402740a760a873e1eba9.png'),(449,116,'/public/upload/goods/2018/04-12/0ed8bc843f85f0436016c0feb9728ce8.png'),(450,117,'/public/upload/goods/2018/04-13/dcd62f7ecbdf70a6e45952674cb793ea.png'),(451,117,'/public/upload/goods/2018/04-13/83855cbdd6b347ee89ef8237fcb0238a.png'),(452,117,'/public/upload/goods/2018/04-13/e835e459302084bc60ab14e8cb00271d.png'),(453,117,'/public/upload/goods/2018/04-13/7efe94909fbd6bea41ee6cd2bdd90439.png'),(454,117,'/public/upload/goods/2018/04-13/43270a902f6878f2ac4582d89b423e52.png'),(455,118,'/public/upload/goods/2018/04-13/9e47b788310dc9e1244ac6564ea735a8.png'),(456,118,'/public/upload/goods/2018/04-13/49df53069d8953c072e4f51bc8411293.png'),(457,118,'/public/upload/goods/2018/04-13/473b873d2fdc72a41319bf37c36fb721.png'),(458,118,'/public/upload/goods/2018/04-13/ad28092f015a824e5274188dac1eaf34.png'),(459,118,'/public/upload/goods/2018/04-13/6be034312c7f0e6c5c2c0cc5a657b38a.png'),(460,118,'/public/upload/goods/2018/04-13/447a78f19d258268e6f2e61100e8346f.png'),(461,119,'/public/upload/goods/2018/04-13/91bb38bd2750f27d73f0c0122f61877d.png'),(462,119,'/public/upload/goods/2018/04-13/3e8f50bdc659ede72abd99dff6a7c7a8.png'),(463,119,'/public/upload/goods/2018/04-13/a6ad2295de11bb5639fdeaa91c067eb3.png'),(464,119,'/public/upload/goods/2018/04-13/7b7c597e6d90220af83a914095ee732d.png'),(465,119,'/public/upload/goods/2018/04-13/a113f33b3f843eea0e51bd938f4ba24c.png'),(466,119,'/public/upload/goods/2018/04-13/6d2ac9cc0c5f6480c089f50ddf544433.png'),(467,119,'/public/upload/goods/2018/04-13/a00629a8e6293c9f41fc48c0dc01cf8a.png'),(468,120,'/public/upload/goods/2018/04-13/749829bc816932b670dc46d823f3ce5c.jpg'),(469,121,'/public/upload/goods/2018/04-13/68938dc7820ef8a85657809d2e8ed85f.png'),(470,121,'/public/upload/goods/2018/04-13/b945f9628c511316f85a2b6bb46e99b8.png'),(471,121,'/public/upload/goods/2018/04-13/e15a7df34b6ff7a6180777c82d45cfd3.png'),(472,121,'/public/upload/goods/2018/04-13/84d5259bd8313ea62ced8695d6396184.png'),(473,121,'/public/upload/goods/2018/04-13/a55d6f6ceb139fe3302b5c2072f92767.png'),(474,121,'/public/upload/goods/2018/04-13/830695811bc7f5ea76c7207855e02900.png'),(475,121,'/public/upload/goods/2018/04-13/9458b8588e00e59113d2c815d0b7905c.png'),(476,122,'/public/upload/goods/2018/04-13/e968ee802db0d6aa06efe4ad96e977a3.jpg'),(477,123,'/public/upload/goods/2018/04-13/7183a0a4283d928db498370c85896270.png'),(478,123,'/public/upload/goods/2018/04-13/e6d2b45318d3f67c7f55da64b377da16.png'),(479,123,'/public/upload/goods/2018/04-13/f981e49667f95d44ce57c5f7305935ac.png'),(480,123,'/public/upload/goods/2018/04-13/533f44ecc87e1f031d47ff0e01cfc6ea.png'),(481,124,'/public/upload/goods/2018/04-13/d960d6794d6c517fa790e5f8f617a213.png'),(482,124,'/public/upload/goods/2018/04-13/f73e3cb50a9f8e0532c810852d30b40b.png'),(483,124,'/public/upload/goods/2018/04-13/8f7140f8dfc01b044e1ba1966b5fa7e3.png'),(484,124,'/public/upload/goods/2018/04-13/136ef46760a1a1acc8e9a73ec965cba9.png'),(493,126,'/public/upload/goods/2018/04-13/5ffb3f83a082a4648dc6470d355c7aa3.png'),(487,125,'/public/upload/goods/2018/04-13/fa9165b03fc5568e9f0140e2897c868e.jpg'),(488,125,'/public/upload/goods/2018/04-13/5b729daf8dfadf75ddab4a466f08ce7b.jpg'),(489,125,'/public/upload/goods/2018/04-13/a6ed29a383a4d115ce4366255b52ab54.jpg'),(490,125,'/public/upload/goods/2018/04-13/4901035aa6409f06e297cfcd1bbfd826.jpg'),(491,125,'/public/upload/goods/2018/04-13/e4c789f8a4378a03ba7188dc8a2b1bf2.jpg'),(492,124,'/public/upload/goods/2018/04-13/b7abe1ebbf8cbcd52382059111414d2c.png'),(891,215,'/public/upload/goods/2018/04-18/bf089b23d8eedc0fa3a5991bdf5f368c.png'),(879,126,'/public/upload/goods/2018/04-17/c3a8393b1f44d2899bd8ccc4d7a26ee8.png'),(878,126,'/public/upload/goods/2018/04-17/22352012d7248ab8d1dc88a8b6d968b5.png'),(497,127,'/public/upload/goods/2018/04-13/cc866841d5a07a13b557629169ed206e.png'),(498,127,'/public/upload/goods/2018/04-13/8e0a995e2c705ecc638ff214c9853341.png'),(499,127,'/public/upload/goods/2018/04-13/9277f1471fc74022bd28a5ad8d324ab6.png'),(500,127,'/public/upload/goods/2018/04-13/49f24689cfd988b47432027dd991ef0a.png'),(501,127,'/public/upload/goods/2018/04-13/95f210493e8787a20a99602e98f016cb.png'),(502,128,'/public/upload/goods/2018/04-13/6f8d0bb1adadf5dea561b235518521fc.jpg'),(503,128,'/public/upload/goods/2018/04-13/328bd896f376876f9d12771d70e0e73c.jpg'),(504,128,'/public/upload/goods/2018/04-13/3a83c90811963a2a9619a59826f4304a.jpg'),(505,128,'/public/upload/goods/2018/04-13/f30bdbb1ec7bbb1b81545a7077631078.jpg'),(506,128,'/public/upload/goods/2018/04-13/6d380f7980ac3083a3062f7bdebb1fd8.jpg'),(507,129,'/public/upload/goods/2018/04-13/e52c17e3302ed6a6c909eb47becc4133.png'),(508,129,'/public/upload/goods/2018/04-13/cace97b4357eeb1a4fae9a765b2454f4.png'),(509,129,'/public/upload/goods/2018/04-13/b39ba573c64d3908c64648024c3bde58.png'),(510,129,'/public/upload/goods/2018/04-13/ec27de31ff2290c0ca4cb214d4ff2977.png'),(511,129,'/public/upload/goods/2018/04-13/a56e546b211b81e4eaf8d41e5bf3af7b.png'),(512,130,'/public/upload/goods/2018/04-13/381007462d76e846b53dbbdb352bee33.jpg'),(513,130,'/public/upload/goods/2018/04-13/c8648f2003385a7ae111e554ca1a979a.jpg'),(514,130,'/public/upload/goods/2018/04-13/4e40cc01552b4447d16477d38791935e.jpg'),(515,130,'/public/upload/goods/2018/04-13/de247b97f302ace17b4579e2bc42d669.jpg'),(516,130,'/public/upload/goods/2018/04-13/6a6182ba7c5271c54dd07d4d72851960.jpg'),(517,131,'/public/upload/goods/2018/04-13/a9d6eacd4ebf3b1a5cfecc1f6340cc42.png'),(518,131,'/public/upload/goods/2018/04-13/376ff18ffcd1dc3537fb509a3a683e56.png'),(519,131,'/public/upload/goods/2018/04-13/ce70511757ded707419972b33e422dbd.png'),(520,132,'/public/upload/goods/2018/04-13/07c9d37e3b5e7d0207b9e3062d0af3c6.png'),(521,132,'/public/upload/goods/2018/04-13/9886d4b74e31e3aef6478fb6d8dfcaec.png'),(522,132,'/public/upload/goods/2018/04-13/2c7da46e5341275f677352838fbe125e.png'),(523,133,'/public/upload/goods/2018/04-13/271875f4b8c9eddbeb93145f62b7f394.jpg'),(524,133,'/public/upload/goods/2018/04-13/fd795b31781cc27b63b9f80961e18cca.jpg'),(525,134,'/public/upload/goods/2018/04-13/0ea636baaa20cf87cb97e7e974fa45c4.jpg'),(526,134,'/public/upload/goods/2018/04-13/2a17bc1c55997728a734e043e963fc5b.jpg'),(527,135,'/public/upload/goods/2018/04-13/4596a125f4813e24c5cd176bbac984da.png'),(528,135,'/public/upload/goods/2018/04-13/58e5db861dab542bb281bd135b936bac.png'),(529,135,'/public/upload/goods/2018/04-13/72016d15e05b9aac72472b2b4a9d3622.png'),(530,135,'/public/upload/goods/2018/04-13/5e7e0c51834a4792837300d82ec055d8.png'),(531,135,'/public/upload/goods/2018/04-13/686356cfc70ffcf6005d4c4f1d0f98e9.png'),(532,136,'/public/upload/goods/2018/04-13/9953fbb8531e5ae59a809ade6d8a6faf.jpg'),(533,136,'/public/upload/goods/2018/04-13/3f0853d0ec9ec9e373d823fcfd8c2cf6.jpg'),(534,136,'/public/upload/goods/2018/04-13/3d39875597e8137a35068bccf1d8766e.jpg'),(843,137,'/public/upload/goods/2018/04-17/2c05b4b8d442a2b282afc26b316ddabe.png'),(842,137,'/public/upload/goods/2018/04-17/c02840c7a514dd85e076c2b2bc18d222.png'),(841,137,'/public/upload/goods/2018/04-17/868e0cc6050e26a79211b9dff470fec5.png'),(840,137,'/public/upload/goods/2018/04-17/c5e82a201070b8148d6812fdeac556e2.png'),(547,138,'/public/upload/goods/2018/04-13/a90f2f9617582d0ef6dfe13ef46133ed.png'),(548,138,'/public/upload/goods/2018/04-13/40fdcd24a3dcc5eeda38d9ace6560d84.png'),(549,138,'/public/upload/goods/2018/04-13/dcc69ba557f652261254451348e099ac.png'),(550,138,'/public/upload/goods/2018/04-13/0202a9cfdf1a1cae03fdf4d28025d2d3.png'),(850,139,'/public/upload/goods/2018/04-17/8c83cfa229b8edfba1dcaaf8b3d7b24c.png'),(849,139,'/public/upload/goods/2018/04-17/9a0e43f400cf87271e7be6f0c00f7d6d.png'),(848,139,'/public/upload/goods/2018/04-17/ea7bcfc4e8ae1d5d6514dff6f0efa7a7.png'),(847,139,'/public/upload/goods/2018/04-17/f456da4b9d104e264661a59350dbc838.png'),(556,140,'/public/upload/goods/2018/04-13/15f2e92a0eb43870c15a9525c389fa0f.png'),(560,142,'/public/upload/goods/2018/04-13/1d6c3741a3827d27c4e3a6aa4226d234.jpg'),(561,143,'/public/upload/goods/2018/04-13/bba87011fc68c3030351424ac144d564.png'),(562,143,'/public/upload/goods/2018/04-13/4a284e077fabb4cf33ad17d76cb49633.png'),(563,143,'/public/upload/goods/2018/04-13/29cd22656a7e28256081d206b3d0308d.png'),(564,143,'/public/upload/goods/2018/04-13/599bdaa1a930b4668fd7e492e392f8d5.png'),(565,144,'/public/upload/goods/2018/04-13/e81cecb76645d579144c3aab1514f179.png'),(566,144,'/public/upload/goods/2018/04-13/acdef09a38f10adc9a61cc42d4e6a281.png'),(567,144,'/public/upload/goods/2018/04-13/e3455bf6d7eb1b934f7ba99b04a3a9c6.png'),(568,144,'/public/upload/goods/2018/04-13/fa031ca0a1d1761166c53ad7af761eb3.png'),(867,145,'/public/upload/goods/2018/04-17/d42c733560a005139559a5479c11c324.png'),(862,147,'/public/upload/goods/2018/04-17/37313c576ee86dd2b8d86956246c0c71.png'),(574,146,'/public/upload/goods/2018/04-13/6e31727e9c243ee7ad47047633f3dd28.png'),(572,146,'/public/upload/goods/2018/04-13/718f440199ac5ce966149ad41c66f4df.png'),(575,146,'/public/upload/goods/2018/04-13/decce6921a64fe633571fc683a25ed75.png'),(866,147,'/public/upload/goods/2018/04-17/01ce3d9e741502e287645ec85b783d85.png'),(577,148,'/public/upload/goods/2018/04-13/c6d844fcab52d89b8815722d78b7d3af.jpg'),(578,148,'/public/upload/goods/2018/04-13/60d9cbb9994a457453754368fdea518e.jpg'),(579,148,'/public/upload/goods/2018/04-13/4c6917e33e71a9f02e8c8ad7c3cb08e4.jpg'),(580,148,'/public/upload/goods/2018/04-13/946a8eada87d05e1193c0aa7c9b2ebe3.jpg'),(581,148,'/public/upload/goods/2018/04-13/a5400fdf4df7fbed21cac60ac6f7298e.jpg'),(582,148,'/public/upload/goods/2018/04-13/3f3acf80253941c5d4e7a258da474c57.jpg'),(583,149,'/public/upload/goods/2018/04-13/ac8b90a89de2734767e4778cee370cef.png'),(584,149,'/public/upload/goods/2018/04-13/526d83db6c6bc0d5783c89d8858ef01d.png'),(585,149,'/public/upload/goods/2018/04-13/ad88d59e0aed06d8638c30dfdb7d9379.png'),(589,150,'/public/upload/goods/2018/04-13/df29c3d0466ef69e91d07793fc516c4e.png'),(590,150,'/public/upload/goods/2018/04-13/ad8b38c7e28e48cfed40f8c449a7a0cb.png'),(588,150,'/public/upload/goods/2018/04-13/aae6db969782d46768a610f7058ccc1c.png'),(591,151,'/public/upload/goods/2018/04-13/57bfbc4d273534de365983f28ec986e1.png'),(592,151,'/public/upload/goods/2018/04-13/70bf381a09d49747e536f15b7d06e6e1.png'),(593,151,'/public/upload/goods/2018/04-13/31a621abcef5d27465c62f4fa9d67b69.png'),(594,151,'/public/upload/goods/2018/04-13/7e191d0ad58bd0720c087ad5784bac03.png'),(595,151,'/public/upload/goods/2018/04-13/6fefbf235d907f6aff06fa8ccf5f8994.png'),(602,154,'/public/upload/goods/2018/04-16/d5a8c95dd6ada2733044944e65b6e711.png'),(597,152,'/public/upload/goods/2018/04-16/bdc6a4086d20a2d7dcc30ae4a7f0e729.jpg'),(598,153,'/public/upload/goods/2018/04-16/295156dff9497ec4cc1dfd90852e2acb.png'),(599,153,'/public/upload/goods/2018/04-16/7845fa2df82aa0c0c518a1eb83ff2587.png'),(600,153,'/public/upload/goods/2018/04-16/c707a089f0b90050742dca60a80a6672.png'),(601,153,'/public/upload/goods/2018/04-16/662e37a0f558df16a43837cf89bfc4b9.jpg'),(605,154,'/public/upload/goods/2018/04-16/2ae49c7b1e6ad0645315b6bcf40f6bf7.png'),(610,155,'/public/upload/goods/2018/04-16/8dbfaf35aca8efdbae8513a38409f357.png'),(611,155,'/public/upload/goods/2018/04-16/772e4ee7c97dbfc3dc9e9b2ee10843cc.png'),(608,155,'/public/upload/goods/2018/04-16/c354f66f7ea4af4c36d6482605a686fd.png'),(609,69,'/public/upload/goods/2018/04-16/c264441d23f24210d429bf6c58dac1ee.jpg'),(612,111,'/public/upload/goods/2018/04-16/629aa36e3780bc16397b2488cc0f3da4.jpg'),(613,156,'/public/upload/goods/2018/04-16/8ba55e980d61df0415b167d25c6f5741.png'),(614,156,'/public/upload/goods/2018/04-16/ef6282f6dc691257eb82ab8837649062.png'),(615,156,'/public/upload/goods/2018/04-16/b012d07851337d81d095d5e35b45e36a.png'),(620,157,'/public/upload/goods/2018/04-16/367bfeeb8c8fb8a177f3052d88602ae5.png'),(621,157,'/public/upload/goods/2018/04-16/1b013674e6a101cc2abb963d87979d93.png'),(622,157,'/public/upload/goods/2018/04-16/c8fecdafd18ac6fb8a334da07f270937.png'),(623,157,'/public/upload/goods/2018/04-16/2136051cf9825f2c7aa6e636ef2cdb83.png'),(624,157,'/public/upload/goods/2018/04-16/ef3cef460d8b328f2593624f829c064f.png'),(625,158,'/public/upload/goods/2018/04-16/99cf2901a52c04ae11a0b049d690b0e6.jpg'),(626,158,'/public/upload/goods/2018/04-16/c3bd52b81ffe93d02e13e1de78aa04fe.jpg'),(627,158,'/public/upload/goods/2018/04-16/24a1d06cc86f2c22a9d3203bffd8a870.jpg'),(628,158,'/public/upload/goods/2018/04-16/f12529346b917ae9f49105c4690afd6b.jpg'),(629,158,'/public/upload/goods/2018/04-16/0bfd4166d67884d597dba9f27035eed4.jpg'),(630,159,'/public/upload/goods/2018/04-16/a0ca50676cdc91929b500dedf9c15fa1.jpg'),(631,159,'/public/upload/goods/2018/04-16/6cbd07642a7569068e3d4609e7c8c1cd.jpg'),(632,159,'/public/upload/goods/2018/04-16/be2034c529dfbb42c2e8386c59f4675d.jpg'),(633,159,'/public/upload/goods/2018/04-16/dfc999a7668c044b8802e70a90dc7e79.jpg'),(634,160,'/public/upload/goods/2018/04-16/1d84bc5ca76b65eca1a921c7d90cc718.png'),(635,160,'/public/upload/goods/2018/04-16/3afba059c1b7df5ed4c6f400f237783f.png'),(636,160,'/public/upload/goods/2018/04-16/551df0568ca40c5f8094ae18a2b3ff61.png'),(637,160,'/public/upload/goods/2018/04-16/a9a02d947bc8cf946c358f5adb4e7983.png'),(638,161,'/public/upload/goods/2018/04-16/005f3f65d9050cce8d0101268de2e53c.png'),(639,161,'/public/upload/goods/2018/04-16/ec2f8f68c49a7b35b4762b97e361fc95.png'),(640,161,'/public/upload/goods/2018/04-16/2b266b046a90d930f03150802aafa226.png'),(641,162,'/public/upload/goods/2018/04-16/048a0222109ee76110e23e71f79f0c75.png'),(642,162,'/public/upload/goods/2018/04-16/b901de6e7eec505d6f8be2d6d1ebdf3d.png'),(643,162,'/public/upload/goods/2018/04-16/45ae2770fc2a391f2e676b37d60e7e29.png'),(644,162,'/public/upload/goods/2018/04-16/07bf6a02a9838261be6bca17d6a59358.png'),(645,162,'/public/upload/goods/2018/04-16/dc97516ba90277da9d51f318cd64556a.png'),(646,163,'/public/upload/goods/2018/04-16/687c22a1e4c465ac4730e11f732dfae7.png'),(647,163,'/public/upload/goods/2018/04-16/eb537f14c5033c9bbee1c6ea093bf5f7.png'),(648,163,'/public/upload/goods/2018/04-16/757ff057b22c01e9611babd068144825.png'),(649,163,'/public/upload/goods/2018/04-16/2c63abce1d518c236f617f451ebec737.png'),(650,163,'/public/upload/goods/2018/04-16/d26860217ad69f548f0349e80933e873.png'),(651,164,'/public/upload/goods/2018/04-16/1a3ded70ec73e4730a5b37b43194f58b.png'),(652,164,'/public/upload/goods/2018/04-16/0addd086c43e4d746870378139a4b55a.png'),(653,164,'/public/upload/goods/2018/04-16/0c7b6d70d06b74b42fa057f1c60f6205.png'),(654,164,'/public/upload/goods/2018/04-16/27f45e2ce9521c5d4bb3382911b39cc2.png'),(655,165,'/public/upload/goods/2018/04-16/f117f668e25784478bb2ee65e56884b6.png'),(656,165,'/public/upload/goods/2018/04-16/d76dce12bb08e92b6f6fcb2e6d8b6b18.png'),(657,165,'/public/upload/goods/2018/04-16/479f8c72f90f653fee74cb62ab22046d.png'),(658,166,'/public/upload/goods/2018/04-16/7c4e33440b5afd9843a1ad4292b73dd1.png'),(659,166,'/public/upload/goods/2018/04-16/66e370f332eaf3ffb920d7020e7b1202.png'),(660,166,'/public/upload/goods/2018/04-16/ca97958a2df1f55b8a7bbf5c412ff0da.png'),(661,167,'/public/upload/goods/2018/04-16/10874804478ebe3645c37fbeddeb2123.png'),(662,167,'/public/upload/goods/2018/04-16/bc4592cca393f47c74cfda33ce24810d.png'),(663,167,'/public/upload/goods/2018/04-16/fd8f9e6cb01b33b42f68e6cc86cba6fe.png'),(664,168,'/public/upload/goods/2018/04-16/90fbe086057e1c1fd579f6f004968964.png'),(665,168,'/public/upload/goods/2018/04-16/c98563329e133d301dcc47b5686ddc52.png'),(666,168,'/public/upload/goods/2018/04-16/0ac007ee7fe02d84a10aec1492e710fc.png'),(667,169,'/public/upload/goods/2018/04-16/297eaa17baf20e407df63cda42463d92.png'),(668,169,'/public/upload/goods/2018/04-16/6bd35935e738db9de9510bf051f81610.png'),(669,169,'/public/upload/goods/2018/04-16/82a3191093567620669c29158114ebd2.png'),(670,169,'/public/upload/goods/2018/04-16/c99693a946ec5c0df3d80940ab1960f4.png'),(671,169,'/public/upload/goods/2018/04-16/54d3abba8788b30c92a06ceba2680b6b.png'),(672,169,'/public/upload/goods/2018/04-16/789a686cff58a5da7d9041a7fe611009.png'),(673,170,'/public/upload/goods/2018/04-16/7ce2632e4e6a904da1c51afb7c730bbf.png'),(674,170,'/public/upload/goods/2018/04-16/6dc920b9b15466f085222d0d6fa21bd6.png'),(675,170,'/public/upload/goods/2018/04-16/3f18dca687272698eabec624931aa4a7.png'),(676,171,'/public/upload/goods/2018/04-16/036cb22e5b560d0b182312d6de328903.jpg'),(677,171,'/public/upload/goods/2018/04-16/071ff9fc3e440c8aebf34290e78375c1.jpg'),(678,171,'/public/upload/goods/2018/04-16/0c1ea4c8afdaaa82a887430e8d9c9443.jpg'),(679,171,'/public/upload/goods/2018/04-16/92d03de78cf03e919bb0f71577b92cfc.jpg'),(680,171,'/public/upload/goods/2018/04-16/77d46fe7df18cc60ee1699190a3daf3b.jpg'),(681,172,'/public/upload/goods/2018/04-16/bffc8901eba1c3fc3b2feebf309cdd21.png'),(682,172,'/public/upload/goods/2018/04-16/c90b98f708d092ea954366cbd0a8c61a.png'),(683,173,'/public/upload/goods/2018/04-16/3fdd5f38d267f98230fcd525e538f5fb.png'),(684,173,'/public/upload/goods/2018/04-16/99f34b902fb038d9819fd0c5d3cf60b7.png'),(685,173,'/public/upload/goods/2018/04-16/a393e1f68adec0d427e2e6f094d3bcdd.png'),(686,174,'/public/upload/goods/2018/04-16/1085527e0785b0ffb23b9b232c8545bb.jpg'),(687,174,'/public/upload/goods/2018/04-16/fc3d038e10aa3bdf423b12cad143fdd2.png'),(688,174,'/public/upload/goods/2018/04-16/1c370fb9fc6f56b40ab8be614bb9be3e.png'),(689,174,'/public/upload/goods/2018/04-16/f3509cd4603c1dfa7cbba1c085a77309.jpg'),(690,174,'/public/upload/goods/2018/04-16/d9062166ed05718e7a7d4e0ec42c78ed.png'),(691,174,'/public/upload/goods/2018/04-16/e65467e503af54ff3ca622bae79a13fa.png'),(692,174,'/public/upload/goods/2018/04-16/ef1d3905c7cb6a0b97a045fd316c7005.png'),(693,175,'/public/upload/goods/2018/04-16/4987a79394e85f009e530e38bb09744e.png'),(694,175,'/public/upload/goods/2018/04-16/449b01beb684b0862b89b9372859b906.png'),(695,175,'/public/upload/goods/2018/04-16/579ee136cc674d8760dab9db1ea17eb5.png'),(696,134,'/public/upload/goods/2018/04-16/3013080d708e695f4d2116c8c14ef149.jpg'),(697,176,'/public/upload/goods/2018/04-16/005544c4a53bf91bacc845eb6b726c3b.png'),(698,176,'/public/upload/goods/2018/04-16/19beef37e1c2155d0ef4180e4ebe8c3e.png'),(699,176,'/public/upload/goods/2018/04-16/bf6703335b4e525d83d612335bfa1b61.png'),(700,177,'/public/upload/goods/2018/04-16/28fac2e7faa5dcc2ef72ccbcf9a8949b.png'),(701,177,'/public/upload/goods/2018/04-16/eb8c4ebd0f9f10d152e2159c4e877413.png'),(702,177,'/public/upload/goods/2018/04-16/9f8850648bf341e232ccba262ebd9313.png'),(703,178,'/public/upload/goods/2018/04-16/fe759659a7546c976c7296c5501c1a2a.png'),(704,178,'/public/upload/goods/2018/04-16/a82838a5672a839800fb5972df81c319.png'),(705,178,'/public/upload/goods/2018/04-16/7e7ea458a0c539a2dedb2974d108698a.png'),(706,179,'/public/upload/goods/2018/04-16/024573f6d57e3dc508dcf0dcc87fdaa5.png'),(707,180,'/public/upload/goods/2018/04-16/6c2e4fc22006356a4f797e23c0a5352c.jpg'),(708,180,'/public/upload/goods/2018/04-16/6832edac2df8cdc3646741d38ed3d165.jpg'),(709,180,'/public/upload/goods/2018/04-16/7abe677388495d093e306aef8bbe2145.jpg'),(710,180,'/public/upload/goods/2018/04-16/ac3f0581ca45ce542e92712cffcb174d.jpg'),(711,179,'/public/upload/goods/2018/04-16/ab35c691e6207305062452278b68b1a4.png'),(712,179,'/public/upload/goods/2018/04-16/e092ce889263d4cec66548ded68e93ac.png'),(715,182,'/public/upload/goods/2018/04-16/7a18bed2dd0af51e307c878bb2499b47.png'),(851,181,'/public/upload/goods/2018/04-17/604b7de19ba1cab579c18d538c8bdd9b.png'),(716,182,'/public/upload/goods/2018/04-16/2f7c105e1a6b811ecc39c5cf4620d850.png'),(717,182,'/public/upload/goods/2018/04-16/361be47543f77c41baf7923a14ac6698.png'),(718,182,'/public/upload/goods/2018/04-16/9f2c164999d7eff45282a6997956a171.png'),(719,183,'/public/upload/goods/2018/04-16/8c1b57581118d685c199f248e8088e7c.png'),(720,183,'/public/upload/goods/2018/04-16/3f9c5276fa03a13056ee3a15af4d5a6a.png'),(721,183,'/public/upload/goods/2018/04-16/3b64fd1448cb1a7f77c3fd64eb24604c.png'),(722,183,'/public/upload/goods/2018/04-16/c2ad38a04d6aefaeabf69cd9f373d8c9.png'),(723,183,'/public/upload/goods/2018/04-16/52343ad78b0585a4b6e5005640d8f20e.png'),(724,183,'/public/upload/goods/2018/04-16/cde3780ba19ad33f6a6eb234590de3fe.png'),(725,184,'/public/upload/goods/2018/04-16/891278c481c5a3647ae75475d00f2904.jpg'),(726,184,'/public/upload/goods/2018/04-16/b3211b8609ba338e5015e9988351eda3.jpg'),(727,184,'/public/upload/goods/2018/04-16/234d53752def10b7347ab741b7c9ea1b.jpg'),(728,185,'/public/upload/goods/2018/04-16/c03ac10f8a3a38db6164af61f2c76ddd.png'),(729,185,'/public/upload/goods/2018/04-16/84d3c4874e3008e89bffc07c57aa0bca.png'),(730,185,'/public/upload/goods/2018/04-16/884e43ee0a327b3e9c8480085047a15d.png'),(731,186,'/public/upload/goods/2018/04-16/f8e4ea345fc1ced0dcd9e9c794aaa38a.png'),(732,186,'/public/upload/goods/2018/04-16/237ca7c53c0860b5ffbe94696614d25c.png'),(733,186,'/public/upload/goods/2018/04-16/2c65e75cec19da1c1c3cc76496f533a8.png'),(734,186,'/public/upload/goods/2018/04-16/f35a3005202c01ce4c2cdd1d9ca72e88.png'),(735,186,'/public/upload/goods/2018/04-16/3568fd887498b3a423af07fd2f57f582.png'),(736,187,'/public/upload/goods/2018/04-16/1ca677c1f32302a63ecae403a2c4f7a1.png'),(737,187,'/public/upload/goods/2018/04-16/8d5bf76913e012bcc079db394eb68cac.png'),(738,187,'/public/upload/goods/2018/04-16/b98e718bd50e79e89b85ba5d3b5bf6e2.png'),(739,187,'/public/upload/goods/2018/04-16/08816fab5102fd97a0164e685a0a4333.png'),(740,187,'/public/upload/goods/2018/04-16/61f5d62e4a0228333e81d24c30065b3d.png'),(741,188,'/public/upload/goods/2018/04-16/150f01bd81c2bae47a45a1ae48ff086a.png'),(742,188,'/public/upload/goods/2018/04-16/449acd52e353355522bcb9bb86d45c45.png'),(743,188,'/public/upload/goods/2018/04-16/10dad6f63a2b75b44ae673385233441c.png'),(744,188,'/public/upload/goods/2018/04-16/e50b44d892e5d0b9fef230484eb67dec.png'),(745,188,'/public/upload/goods/2018/04-16/ba3f4c5e90f783067a0c60f065400afa.png'),(746,189,'/public/upload/goods/2018/04-16/202c87a4c4bda7bec72a1f59809f4002.jpg'),(747,189,'/public/upload/goods/2018/04-16/faf22eb93d21bdd086c6e7a2590394f7.jpg'),(748,190,'/public/upload/goods/2018/04-16/0afb7460ba914c7138e96b94e90c7e83.png'),(749,190,'/public/upload/goods/2018/04-16/f16922c49ad5441310293f179ee8e007.png'),(750,190,'/public/upload/goods/2018/04-16/71f095c289074117ac91af5bc3f00d19.png'),(751,191,'/public/upload/goods/2018/04-16/08c4fe33dc36f9ce3b3d3dc1ad85898e.png'),(752,191,'/public/upload/goods/2018/04-16/c97c6410c033b8e0121e806227ebbfbf.png'),(753,191,'/public/upload/goods/2018/04-16/c5579780b58589c8a31297005bf8c862.png'),(754,192,'/public/upload/goods/2018/04-16/798050eddf9069ff28aee80bfcc6499e.png'),(755,192,'/public/upload/goods/2018/04-16/b0a806ad64df56db4ce410c88ba32879.png'),(756,192,'/public/upload/goods/2018/04-16/0cbdae03025b6964aaf40f27ec5403a4.png'),(761,10,'/public/upload/goods/2018/04-17/305cf15d476d02cb2771576c9d81d91d.png'),(767,194,'/public/upload/goods/2018/04-17/b38599f93af9cfe6f79a93a8c586106b.png'),(768,194,'/public/upload/goods/2018/04-17/64bc3b79d0f582b2d4544275cf0d5b6e.png'),(769,195,'/public/upload/goods/2018/04-17/389d2a8ffca370060f2e5022669f2e9b.png'),(770,195,'/public/upload/goods/2018/04-17/67b982db375c4f7d3b8cbc2674236bdc.png'),(771,195,'/public/upload/goods/2018/04-17/eaa75de6fd59961788a27534a1bc7fd7.png'),(772,196,'/public/upload/goods/2018/04-17/139088a686e657dcdda1dfe73dd4b62f.jpg'),(773,196,'/public/upload/goods/2018/04-17/a4f3b86e1c3928c9a4632f280943bffa.jpg'),(774,196,'/public/upload/goods/2018/04-17/d8bc0785b849c2f4fd3e0079831c4e02.jpg'),(775,196,'/public/upload/goods/2018/04-17/ca2d009676388eeb545c34232a581e03.jpg'),(776,196,'/public/upload/goods/2018/04-17/bf21e2a73904e685e5cd9a7fe84abb61.jpg'),(777,196,'/public/upload/goods/2018/04-17/2cc4e3f1b7ae838c584c17b0d79e310a.jpg'),(778,197,'/public/upload/goods/2018/04-17/1f06e0613e7d149b2c171b57b0564f4c.png'),(779,197,'/public/upload/goods/2018/04-17/bed5874b9b8e9539e1b2b062798907d8.png'),(780,197,'/public/upload/goods/2018/04-17/b08c351302d9faafeebfa97ed3eea4bf.png'),(781,197,'/public/upload/goods/2018/04-17/61ea94fca6bc4de7e599b57e6abf3949.png'),(782,197,'/public/upload/goods/2018/04-17/fa3163e06b539b123b7cf74c4a0ee274.png'),(783,197,'/public/upload/goods/2018/04-17/447f62e429f36b6f9095639412da8c88.png'),(784,198,'/public/upload/goods/2018/04-17/a1f16f52620ea267e1ed12198ebacf9d.jpg'),(785,198,'/public/upload/goods/2018/04-17/8e10c293ad0c1bc8cbe2c77025e59725.jpg'),(786,198,'/public/upload/goods/2018/04-17/a60781ee70bbbf99f58703a947062f29.jpg'),(787,198,'/public/upload/goods/2018/04-17/244ac3b4fc3f1fe6ae4055345bf11f9f.jpg'),(788,199,'/public/upload/goods/2018/04-17/752fa382357617d24747325b0755df51.jpg'),(789,199,'/public/upload/goods/2018/04-17/6c98d6cb66963aaa116b6449e0f966c3.jpg'),(790,200,'/public/upload/goods/2018/04-17/6f990ffb7e830a808a76c6abbb2cdf72.png'),(791,200,'/public/upload/goods/2018/04-17/b316ff194dc6b67abc1fa8f69ee861fd.png'),(792,200,'/public/upload/goods/2018/04-17/7c8f0846db41ae663cc5f8de4c5ff9d4.png'),(794,201,'/public/upload/goods/2018/04-17/4fc8ad57adb34c65367dc0feb8249d36.png'),(795,201,'/public/upload/goods/2018/04-17/f0cfe08c2285f8ccf26605a487f880fe.png'),(796,201,'/public/upload/goods/2018/04-17/80338ebeec35b9071548d58cc4c3b50f.png'),(797,202,'/public/upload/goods/2018/04-17/dbfed9f415847891c304de81ce5e51be.png'),(798,202,'/public/upload/goods/2018/04-17/5b01e475af05e6c01a3219bf2861aa3f.png'),(799,202,'/public/upload/goods/2018/04-17/0c2873341a20964401b52161ee815dd3.png'),(888,203,'/public/upload/goods/2018/04-17/0aaff2cac62ccc17cae95331bd6ae2ec.png'),(887,203,'/public/upload/goods/2018/04-17/051e59559b35262f81b7c00df903d730.png'),(886,203,'/public/upload/goods/2018/04-17/7beec3372f95acf7b8532ba6491bfe98.png'),(885,203,'/public/upload/goods/2018/04-17/db7567e7d449773d4e8bbf750d083916.png'),(804,204,'/public/upload/goods/2018/04-17/267c58bb03bb1a6db0f97dae53903e88.png'),(805,204,'/public/upload/goods/2018/04-17/119c1feb335847b79d2d44270b6780ea.png'),(806,204,'/public/upload/goods/2018/04-17/11c4223be0aa5e60535918d78e33b17b.png'),(807,205,'/public/upload/goods/2018/04-17/2f121475f02e3028b423473c0777e08d.png'),(808,205,'/public/upload/goods/2018/04-17/91a215b6f8fe91882b62fa72274523d7.png'),(809,205,'/public/upload/goods/2018/04-17/6c9255cb633065d5a179cbfb51250f46.png'),(810,206,'/public/upload/goods/2018/04-17/4e5e1d5541ea1c9e33bd7e0717d551ec.png'),(811,206,'/public/upload/goods/2018/04-17/ef25d69853abcc326df05f84d3b95d8b.png'),(812,206,'/public/upload/goods/2018/04-17/b0c7cb35ff17fd0d261cc4baa3fa1168.png'),(813,207,'/public/upload/goods/2018/04-17/1bb4944acb3b0ac5a70aa0ed23f99aa2.png'),(814,207,'/public/upload/goods/2018/04-17/87cc6501f487c0ce36f0d1f62c592839.png'),(815,207,'/public/upload/goods/2018/04-17/3097773e12acd80a0825afbcff870f0e.png'),(816,207,'/public/upload/goods/2018/04-17/07f5def3b3fb55968b8fd87fd5e175ea.png'),(817,207,'/public/upload/goods/2018/04-17/711d01abbbb67b6439a73ebf8a120c64.png'),(818,207,'/public/upload/goods/2018/04-17/5dc6c3e29b1f4e759038eb6303f95cc7.png'),(819,208,'/public/upload/goods/2018/04-17/60bad6aadfa8e4d624877c6e76f2ab9a.png'),(820,208,'/public/upload/goods/2018/04-17/57008925765001d8cf8a005824d07c5b.png'),(821,208,'/public/upload/goods/2018/04-17/5d2550e7c515b7a2731e414a56046e1f.png'),(822,208,'/public/upload/goods/2018/04-17/faf45b13ec93b536ee86fa7a15399d52.png'),(823,209,'/public/upload/goods/2018/04-17/bbdfc5edb8136e6a9a1aac5cb7e4996f.png'),(824,209,'/public/upload/goods/2018/04-17/e6a9dba86ad20e5763aaa57e5436f059.png'),(825,209,'/public/upload/goods/2018/04-17/14a78c6b346ef0100158210f59ef5626.png'),(828,210,'/public/upload/goods/2018/04-17/f19df39ae43c8267f057b58756667299.jpg'),(829,210,'/public/upload/goods/2018/04-17/b4c0b75336d82d0125f1f31a1404570a.jpg'),(830,210,'/public/upload/goods/2018/04-17/e5ed1c25936b66d0df15d0daa29ceab9.jpg'),(831,32,'/public/upload/goods/2018/04-17/1a767f2695a5bcdf5444599217c5130d.png'),(832,32,'/public/upload/goods/2018/04-17/43598ced75d3cc7bba4e434b0e0edf48.png'),(833,32,'/public/upload/goods/2018/04-17/a743fb9be3d0eb25c4a2e84bde5decc8.png'),(834,32,'/public/upload/goods/2018/04-17/c7bf60ed6b3e1a5b1b2099202efc64e2.png'),(835,211,'/public/upload/goods/2018/04-17/7f82b93ea2760e7047caec5a898d5a95.png'),(836,211,'/public/upload/goods/2018/04-17/6738f4665d89d0ab721037e4489d067d.png'),(837,211,'/public/upload/goods/2018/04-17/4c206e91a1534490f54f8a03919090d6.png'),(838,211,'/public/upload/goods/2018/04-17/418ab6a1323853fe8d8da360e7363e79.png'),(839,211,'/public/upload/goods/2018/04-17/1ef205dcb7386c7554ed755e2cbbf884.png'),(844,212,'/public/upload/goods/2018/04-17/c0805f6879ccec091f1553456f8354b5.jpg'),(845,212,'/public/upload/goods/2018/04-17/e8a4a57f0930f832464d947f47add182.jpg'),(846,212,'/public/upload/goods/2018/04-17/a926e8f97d5499f952a4e943b503f74d.jpg'),(856,25,'/public/upload/goods/2018/04-17/aba23518b59d43d199dc05f36b24eabf.png'),(857,25,'/public/upload/goods/2018/04-17/f51212a40b1d41dc85b9d17397ffba69.png'),(859,79,'/public/upload/goods/2018/04-17/712e9a715093fd02c1cc25b662dc5f86.png'),(860,79,'/public/upload/goods/2018/04-17/496954b32280cdd204ea3abcac8e7fa3.png'),(861,79,'/public/upload/goods/2018/04-17/c8e9a3603620aacb5802d61a219af8e3.png'),(865,147,'/public/upload/goods/2018/04-17/8a82d3cda32ea9d291efabc5dec37b86.png'),(868,145,'/public/upload/goods/2018/04-17/0ded63d6b18a5540d4b222cc180b614b.png'),(869,145,'/public/upload/goods/2018/04-17/b6db735c30506d5f12aae1e109bc79d5.png'),(895,217,'/public/upload/goods/2018/04-19/ff5ed05f8b947682a541bff02129ecc9.jpg'),(896,217,'/public/upload/goods/2018/04-19/a7e538c6d9e2f8607546d199470cb3ee.jpg'),(897,217,'/public/upload/goods/2018/04-19/ba296804ed2a002d3a7fff2ae9684183.jpg'),(899,219,'/public/upload/goods/2018/04-19/fced3012c5693d1a87380ec1ea6cd32c.png'),(900,220,'/public/upload/goods/2018/04-19/b437261a72c87b2a299b39a57c5f0c6c.jpg'),(901,220,'/public/upload/goods/2018/04-19/763686cb073e348ce5927b0720c8ffe9.jpg'),(902,220,'/public/upload/goods/2018/04-19/42409986d627f6ad8deb459ae874b612.jpg'),(903,221,'/public/upload/goods/2018/04-20/f49f279feabb08730e051839d8cb2a9c.jpg'),(904,222,'/public/upload/goods/2018/04-20/7a44af49733bae482112a8b7c0f899da.jpg'),(905,222,'/public/upload/goods/2018/04-20/e22b2d74978a3142842067010d49a6e2.jpg'),(906,222,'/public/upload/goods/2018/04-20/4b2a4a43960282e91a3f3c1efe97bf4e.jpg'),(912,224,'/public/upload/goods/2018/04-20/a1e7dba6487358f3c47c1f5e5f148f82.jpg'),(911,224,'/public/upload/goods/2018/04-20/6a0002ce8bed4d0e04c670025ca88bc6.jpg'),(910,224,'/public/upload/goods/2018/04-20/060cbea6a2ac557aa3548ba177107363.jpg'),(913,225,'/public/upload/goods/2018/04-20/2c520afc0d8ddbffe5cba548a4c4a480.jpg'),(914,225,'/public/upload/goods/2018/04-20/38f9c9c858812ccdb38835a035c4e0b7.jpg'),(915,225,'/public/upload/goods/2018/04-20/b406d450ffe68d66e09e4ec8696beb3e.jpg'),(916,225,'/public/upload/goods/2018/04-20/da3ddd9e9bcd0ec1c3eb03c6dc144866.jpg'),(917,225,'/public/upload/goods/2018/04-20/6792dc28d06b4ff08eaa496b1f0fa770.jpg'),(918,225,'/public/upload/goods/2018/04-20/a79efaef874fac37556e36e9079d0623.jpg'),(919,225,'/public/upload/goods/2018/04-20/bb44155a3f066c305307a8e7844a5200.jpg'),(920,226,'/public/upload/goods/2018/04-20/3a7fbedb62451d64596dacbba51fc050.jpg'),(921,226,'/public/upload/goods/2018/04-20/92470fd3d9464ef6d4e9eb3dd9004743.png'),(922,226,'/public/upload/goods/2018/04-20/b7e023daef51b0fa6449621fd7e3a39e.png'),(923,226,'/public/upload/goods/2018/04-20/48227d0cc3a52b2dba4ee982d278fcdf.png'),(924,227,'/public/upload/goods/2018/04-23/6a2cc994c8118b13ab542d33db4efe8f.jpg'),(925,228,'/public/upload/goods/2018/04-24/25ef94187f28073ae7bdb1300400636b.jpg'),(926,228,'/public/upload/goods/2018/04-24/046339b7ea0adf02f0aea076daa6ba9f.jpg'),(927,228,'/public/upload/goods/2018/04-24/d7958c786d790450adf7edd39a2b62de.jpg'),(928,229,'/public/upload/goods/2018/04-24/b0c42220f1cea282be91850a8afe369f.jpg'),(929,229,'/public/upload/goods/2018/04-24/bb390ed4559cc50796b00a4f7ca3d82d.jpg'),(930,229,'/public/upload/goods/2018/04-24/23accc2fa2ace9e419ce2d199662877f.png'),(931,229,'/public/upload/goods/2018/04-24/0e855b01cd5e57a482b716e72aeca4cf.png'),(932,229,'/public/upload/goods/2018/04-24/2e3d8924c1958f7c9d98bb60476b6bb1.png'),(934,230,'/public/upload/goods/2018/04-26/40f02b9ba295d7cc0938664081378f36.jpg'),(935,230,'/public/upload/goods/2018/04-26/d7053d928000ad92d6ac96fa42c8ddfe.jpg'),(936,231,'/public/upload/goods/2018/04-26/c8cc12dda8c5b8d9c0f6049af316b214.jpg'),(937,232,'/public/upload/goods/2018/04-26/6d48998b3551ab81b63d8fae4592fc9b.jpg'),(938,232,'/public/upload/goods/2018/04-26/b2b1af8b3cf997e703568a8bc60e8d35.jpg'),(939,232,'/public/upload/goods/2018/04-26/7ab9ed71c9873fedb73213faf6a3f855.jpg'),(940,232,'/public/upload/goods/2018/04-26/a4b580799104ebf33b4857b8441ea128.jpg'),(941,232,'/public/upload/goods/2018/04-26/a103d8c89e647f382c33895779c26f55.jpg'),(942,232,'/public/upload/goods/2018/04-26/aab1b811f51954326910acb43a75adc8.jpg'),(943,233,'/public/upload/goods/2018/04-26/e792cf4d113877c137152744ec43a3ce.jpg'),(944,233,'/public/upload/goods/2018/04-26/8ec6c6d96fa3e3a75cc5e0c9009cfa84.jpg'),(945,234,'/public/upload/goods/2018/04-26/e5df54a2c70772680ffe59bf23b4880b.jpg'),(946,234,'/public/upload/goods/2018/04-26/b00e13b15afd81efee90775ff985b3d0.jpg');

UNLOCK TABLES;

/*Table structure for table `tp_goods_type` */

DROP TABLE IF EXISTS `tp_goods_type`;

CREATE TABLE `tp_goods_type` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id自增',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '类型名称',
  PRIMARY KEY (`id`)
)  AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

/*Data for the table `tp_goods_type` */

LOCK TABLES `tp_goods_type` WRITE;

insert  into `tp_goods_type`(`id`,`name`) values (1,'服装'),(2,'手机'),(3,'零食'),(4,'书籍'),(5,'电脑'),(6,'户外'),(7,'鞋子'),(8,'电脑'),(9,'艺术');

UNLOCK TABLES;

/*Table structure for table `tp_goods_visit` */

DROP TABLE IF EXISTS `tp_goods_visit`;

CREATE TABLE `tp_goods_visit` (
  `visit_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `goods_id` int(11) NOT NULL COMMENT '商品ID',
  `user_id` int(11) NOT NULL COMMENT '会员ID',
  `visittime` int(11) NOT NULL COMMENT '浏览时间',
  `cat_id` int(11) NOT NULL COMMENT '商品分类ID',
  `extend_cat_id` int(11) NOT NULL COMMENT '商品扩展分类ID',
  PRIMARY KEY (`goods_id`,`user_id`,`visit_id`),
  KEY `visit_id` (`visit_id`),
  KEY `user_id` (`user_id`)
)  AUTO_INCREMENT=666 DEFAULT CHARSET=utf8 COMMENT='商品浏览历史表';

/*Data for the table `tp_goods_visit` */

LOCK TABLES `tp_goods_visit` WRITE;

insert  into `tp_goods_visit`(`visit_id`,`goods_id`,`user_id`,`visittime`,`cat_id`,`extend_cat_id`) values (351,1,3,1524709425,32,0),(655,1,8,1530787545,32,0),(371,1,10,1524212840,32,0),(589,1,12,1524813555,32,0),(598,1,25,1524816466,32,0),(638,1,39,1524877104,32,0),(436,3,3,1524639737,15,0),(320,3,12,1524128012,15,0),(407,4,3,1524565813,45,0),(442,4,17,1524565435,45,0),(1,5,1,1523254735,53,0),(393,5,3,1524451465,354,0),(603,6,2,1524816719,403,0),(352,6,3,1524446275,403,0),(579,6,24,1524810261,403,0),(634,6,36,1524841164,403,0),(282,7,3,1524128440,14,0),(509,7,22,1524731970,14,0),(643,7,41,1524877679,14,0),(578,8,24,1524810227,57,0),(421,10,3,1524540287,190,0),(147,10,11,1523934269,190,0),(562,10,22,1524798039,190,0),(613,10,24,1524818302,190,0),(429,12,3,1524552602,112,0),(411,12,10,1524470938,112,0),(597,12,25,1524815563,112,0),(626,13,2,1524879095,62,0),(326,13,3,1524132880,62,0),(648,13,8,1540191061,62,0),(410,13,10,1524470827,62,0),(629,13,32,1524825615,62,0),(632,13,33,1524828143,62,0),(401,14,10,1524456797,95,0),(456,15,3,1524722982,16,0),(446,15,17,1524564644,16,0),(608,15,24,1524817080,16,0),(392,16,3,1524552621,80,0),(580,16,24,1524810288,80,0),(623,18,28,1524823663,343,0),(457,20,3,1524703073,223,0),(612,20,24,1524818216,223,0),(423,21,3,1524540416,24,0),(649,22,8,1530784351,108,0),(420,23,3,1524639534,27,0),(426,23,5,1524541675,27,0),(332,25,3,1524189709,62,0),(656,25,8,1540190103,62,0),(633,25,35,1524834699,62,0),(324,27,3,1524129255,80,0),(659,27,8,1540190711,80,0),(398,27,10,1524453836,80,0),(591,27,22,1524814006,80,0),(609,27,24,1524817202,80,0),(650,28,8,1530784438,68,0),(484,31,5,1524720996,400,0),(403,31,10,1524464506,400,0),(527,31,22,1524735128,400,0),(430,32,3,1524552635,396,0),(425,33,3,1524540556,12,0),(644,36,2,1524879062,55,0),(26,36,4,1523326042,55,0),(405,37,10,1524465646,99,0),(399,39,10,1524455179,72,0),(607,39,25,1524816912,72,0),(636,39,38,1524843001,72,0),(654,40,8,1530787435,58,0),(645,42,2,1524879089,61,0),(283,43,3,1524539713,61,0),(34,44,4,1523330450,46,0),(543,46,17,1524792934,49,0),(468,47,1,1524649654,50,0),(308,48,1,1524116321,89,0),(577,49,17,1524810140,90,0),(586,49,23,1524812836,90,0),(576,49,24,1524809579,90,0),(637,51,2,1524877023,91,0),(595,52,25,1524815533,70,0),(496,53,10,1524727801,56,0),(499,54,5,1524728323,71,0),(408,57,10,1524467909,74,0),(42,61,4,1523342544,12,0),(406,62,10,1524470434,77,0),(412,65,10,1524471666,78,0),(134,69,6,1523869511,79,0),(96,70,6,1523602172,81,0),(463,74,1,1524645927,72,0),(619,74,2,1524821834,72,0),(378,74,10,1524469560,72,0),(86,75,5,1523589353,88,0),(133,75,6,1523869498,88,0),(321,77,12,1524130506,57,0),(502,77,22,1524730184,57,0),(132,79,6,1523869467,62,0),(381,83,10,1524215803,60,0),(507,83,23,1524731450,60,0),(617,84,17,1524821528,103,0),(575,84,23,1524809134,103,0),(569,84,24,1524799947,103,0),(305,88,1,1524108457,60,0),(492,91,21,1524726941,44,0),(495,91,22,1524728723,44,0),(653,93,8,1530787407,58,0),(618,93,17,1524821785,58,0),(497,96,22,1524730191,25,0),(331,97,3,1524189477,16,0),(148,98,11,1523934284,17,0),(663,100,8,1540190983,19,0),(581,101,17,1524811137,25,0),(500,101,22,1524730304,25,0),(163,104,1,1523959819,58,0),(304,108,3,1524107018,59,0),(657,108,8,1530789794,59,0),(461,109,12,1524641334,59,0),(592,115,2,1524814914,43,0),(287,118,3,1524186956,183,0),(520,118,22,1524737934,183,0),(383,119,9,1524215899,184,0),(409,119,10,1524469589,184,0),(647,125,8,1530784860,15,0),(641,130,24,1524879170,24,0),(642,130,31,1524879178,24,0),(325,131,3,1524131727,191,0),(309,133,3,1524122398,504,0),(306,133,12,1524108856,504,0),(373,135,10,1524212739,193,0),(651,141,8,1530784960,72,0),(372,141,10,1524470995,72,0),(464,142,1,1524648905,72,0),(646,142,8,1530783275,72,0),(665,145,8,1540191129,62,0),(662,147,8,1540190538,178,0),(610,152,2,1524820538,464,0),(661,152,8,1531558438,464,0),(611,152,25,1524819691,464,0),(658,153,8,1531558176,245,0),(370,153,10,1524212529,245,0),(537,153,17,1524738031,245,0),(491,153,22,1524737965,245,0),(588,153,23,1524813530,245,0),(346,154,3,1524706936,405,0),(279,154,12,1524039771,405,0),(493,154,22,1524814012,405,0),(568,157,23,1524799044,199,0),(364,170,3,1524209045,210,0),(359,170,9,1524208540,210,0),(514,171,17,1524733222,14,0),(513,171,22,1524733987,14,0),(519,171,23,1524735850,14,0),(616,174,2,1524822232,183,0),(333,174,3,1524189724,183,0),(354,174,9,1524208363,183,0),(465,174,17,1524822031,183,0),(551,175,23,1524794548,216,0),(622,177,2,1524822287,214,0),(386,177,10,1524217152,214,0),(302,180,1,1524105597,573,0),(389,181,3,1524456102,371,0),(660,181,8,1531558425,371,0),(550,181,23,1524794543,371,0),(322,182,3,1524128865,220,0),(353,183,9,1524207838,223,0),(376,185,9,1524212985,224,0),(567,186,2,1524822275,226,0),(460,186,18,1524640320,226,0),(521,186,22,1524733698,226,0),(552,186,23,1524794647,226,0),(469,189,1,1524649670,427,0),(614,189,2,1524819542,427,0),(396,189,10,1524462837,427,0),(504,189,22,1524733765,427,0),(517,189,23,1524733336,427,0),(600,189,25,1524816300,427,0),(549,190,23,1524794535,229,0),(315,192,3,1524123165,217,0),(391,193,3,1524561956,443,0),(439,193,17,1524646799,443,0),(574,193,23,1524812671,443,0),(602,193,24,1524824070,443,0),(350,194,3,1524446620,338,0),(367,194,9,1524210026,338,0),(369,194,10,1524729352,338,0),(206,196,8,1524016000,198,0),(303,197,1,1524106741,292,0),(299,198,3,1524099895,536,0),(329,199,3,1524186782,427,0),(149,199,8,1530785720,427,0),(146,199,11,1523935323,427,0),(601,199,25,1524816170,427,0),(145,200,11,1523933955,315,0),(558,201,2,1524797057,351,0),(544,201,17,1524792939,351,0),(559,202,2,1524797062,372,0),(377,202,9,1524213030,372,0),(151,203,1,1523960499,536,0),(604,203,2,1524816767,536,0),(400,203,3,1524549492,536,0),(375,203,9,1524212936,536,0),(175,204,1,1523960402,376,0),(605,204,2,1524816820,376,0),(458,204,17,1524646804,376,0),(584,204,25,1524817174,376,0),(625,205,12,1524824330,344,0),(528,205,23,1524735362,344,0),(624,205,29,1524825022,344,0),(385,206,10,1524216714,381,0),(548,206,23,1524794531,381,0),(281,209,3,1524042468,389,0),(547,209,23,1524794526,389,0),(556,210,2,1524796739,76,0),(284,210,3,1524043157,76,0),(441,210,6,1524561977,76,0),(664,210,8,1540192022,76,0),(404,210,10,1524470435,76,0),(433,210,17,1524563382,76,0),(512,210,23,1524732611,76,0),(555,211,2,1524797037,409,0),(298,211,3,1524099888,409,0),(382,211,10,1524468994,409,0),(582,211,17,1524822039,409,0),(511,211,23,1524794509,409,0),(635,211,37,1524842254,409,0),(539,212,3,1524790671,444,0),(390,212,10,1524464903,444,0),(545,212,17,1524793409,444,0),(498,212,22,1524728773,444,0),(506,212,23,1524812156,444,0),(355,214,9,1524207444,15,0),(334,215,3,1524193297,172,0),(620,215,17,1524821914,172,0),(397,216,10,1524470345,14,0),(508,216,22,1524733665,14,0),(518,216,23,1524794655,14,0),(557,217,2,1524797579,95,0),(563,217,10,1524797754,95,0),(621,217,17,1524822036,95,0),(546,217,23,1524794499,95,0),(585,217,25,1524812048,95,0),(312,218,3,1524120010,100,0),(316,219,3,1524723228,402,0),(615,219,12,1524820639,402,0),(432,219,17,1524822044,402,0),(531,219,21,1524736808,402,0),(523,219,22,1524810648,402,0),(553,219,23,1524808407,402,0),(572,219,24,1524818187,402,0),(573,219,26,1524808170,402,0),(554,220,2,1524795565,402,0),(323,220,3,1524722433,402,0),(652,220,8,1530785324,402,0),(384,220,9,1524216075,402,0),(387,220,10,1524217528,402,0),(431,220,17,1524822186,402,0),(524,220,22,1524735013,402,0),(606,220,24,1524877111,402,0),(590,220,25,1524818367,402,0),(374,221,10,1524465937,58,0),(379,221,12,1524214414,58,0),(380,225,10,1524219376,14,0),(535,225,21,1524737799,14,0),(510,225,22,1524732366,14,0),(368,226,9,1524212104,78,0),(402,227,10,1524462137,200,0),(564,228,2,1524798628,15,0),(565,228,10,1524798008,15,0),(561,228,24,1524825131,15,0),(628,228,31,1524825858,15,0),(566,229,2,1524822295,360,0),(452,229,3,1524708614,360,0),(596,229,17,1524822184,360,0),(486,229,21,1524797032,360,0),(594,229,22,1524815498,360,0),(599,229,24,1524815626,360,0),(627,230,2,1524824627,468,0),(515,230,17,1524733415,468,0),(516,230,22,1524734219,468,0),(529,230,23,1524735880,468,0),(640,230,40,1524877397,468,0),(526,232,22,1524735131,500,0),(587,232,23,1524813290,500,0),(593,234,2,1524822325,541,0),(560,234,24,1524797267,541,0),(639,234,40,1524877385,541,0),(631,235,12,1524826268,18,0),(630,235,31,1524877099,18,0);

UNLOCK TABLES;

/*Table structure for table `tp_group_buy` */

DROP TABLE IF EXISTS `tp_group_buy`;

CREATE TABLE `tp_group_buy` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '团购ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '活动名称',
  `start_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '结束时间',
  `goods_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `item_id` bigint(20) DEFAULT '0' COMMENT '对应spec_goods_price商品规格id',
  `price` decimal(10,2) NOT NULL COMMENT '团购价格',
  `goods_num` int(10) DEFAULT '0' COMMENT '商品参团数',
  `buy_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品已购买数',
  `order_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '已下单人数',
  `virtual_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '虚拟购买数',
  `rebate` decimal(10,1) NOT NULL COMMENT '折扣',
  `intro` text COMMENT '本团介绍',
  `goods_price` decimal(10,2) NOT NULL COMMENT '商品原价',
  `goods_name` varchar(200) NOT NULL DEFAULT '' COMMENT '商品名称',
  `recommended` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否推荐 0.未推荐 1.已推荐',
  `views` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '查看次数',
  `is_end` tinyint(1) DEFAULT '0' COMMENT '是否结束',
  PRIMARY KEY (`id`)
)  AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 COMMENT='团购商品表';

/*Data for the table `tp_group_buy` */

LOCK TABLES `tp_group_buy` WRITE;

insert  into `tp_group_buy`(`id`,`title`,`start_time`,`end_time`,`goods_id`,`item_id`,`price`,`goods_num`,`buy_num`,`order_num`,`virtual_num`,`rebate`,`intro`,`goods_price`,`goods_name`,`recommended`,`views`,`is_end`) values (1,'女生节抢购活动',1523505600,1523592000,99,0,169.00,3,0,0,3,8.9,'',189.00,'2018夏装新款女上衣系带印花喇叭袖粉色复古温柔风漏肩露肩雪纺衫',0,0,0),(2,'女生节抢购活动',1523500020,1523505600,95,0,199.00,300,0,0,50,7.4,'',268.00,'2018新款大码女装春装修身显瘦中长款时尚连衣裙9991',0,0,1),(3,'五一劳动节活动',1523894400,1525190400,205,0,1999.00,8,0,0,52,3.2,'1222',6299.00,'格力(GREE) 3匹 变频 Q铂 立柜式冷暖空调 KFR-72LW/(72596)FNAa-A3',0,0,0),(4,'五一劳动节买的是心动',1523894400,1525190400,212,227,55.00,10,9,5,50,8.5,'来吧！COANG',65.00,'Daphne/达芙妮正品女鞋 春新款羊皮浅口圆头中跟职业工作鞋女单鞋 1016101087尺码:35 颜色:黑色',0,0,0),(5,'五一劳动节GOGO',1523894400,1525190400,212,225,59.00,2,2,2,50,9.1,'',65.00,'Daphne/达芙妮正品女鞋 春新款羊皮浅口圆头中跟职业工作鞋女单鞋 1016101087尺码:38 颜色:白色',0,0,1),(6,'上下上下',1524067200,1525708800,211,0,19.90,9,6,5,45,8.3,'21212',23.90,'绿鲜知 鲜香椿 香椿芽 约150g 新鲜蔬菜',0,0,0),(8,'564',1523980800,1525276800,198,0,68.00,2,2,1,51,8.7,'111',78.00,'全国送花深圳生日鲜花速递同城北京上海红玫瑰花束广州杭州成都店 中礼鲜花 20年老品牌 值得信赖',0,0,1),(9,'888',1523980800,1525276800,83,0,49.00,10,5,3,51,8.2,'',60.00,'简约现代创意沉默是金工艺品摆件北欧雕塑办公室客厅艺术品装饰品',0,0,0),(12,'团购活动列表',1523980800,1524067200,215,237,19.90,8,2,1,76,3.6,'455555',56.00,'团购活动运费选择版本:全网通3G+32G 选择颜色:铂光色 套餐类型:官方标配',0,0,1),(17,'5588',1524153600,1525449600,221,296,250.00,10,4,4,100,9.8,'',255.00,'COACH/蔻驰 女士单肩斜挎手提包57521 客邻尚品颜色:白色',0,0,0),(18,'963',1524153600,1525449600,222,273,499.00,10,0,0,100,8.3,'',599.00,'Vero Moda2018春季新款吊带蕾丝中长款连衣裙|31816Z503 吊带，蕾丝，双层底摆，高腰码数:S',0,0,0),(19,'555',1524464179,1525708800,31,334,10.00,10,0,0,100,6.7,'',15.00,'大青皮绿芒果新鲜水果大青芒果玉芒果生鲜1500g3-5个果选择种类:选择5斤装 种类:礼品盒装',0,0,0),(20,'余杭1234',1524672000,1525017600,232,361,199.00,30,0,0,86,2.0,'544544',990.00,'CASIO卡西欧 BA-120SC-1A 7A 9A 防水防震时尚炫彩运动女表手表颜色:黄色',0,0,0),(21,'6666666',1524797899,1524798600,228,344,185.00,10,1,1,100,6.5,'',285.00,'多规格衣服的的快递选择颜色:紫色 码数:L',0,0,1),(22,'8888888',1524816011,1524817800,199,0,200.00,10,0,0,100,6.7,'jfdhkkhfkjhjgkgfsgfdg',298.00,'送醒酒器法国原瓶进口红酒路易拉菲干红葡萄酒6支整箱装送礼红酒 送红酒杯 送醒酒器开瓶器酒塞',0,0,1);

UNLOCK TABLES;

/*Table structure for table `tp_hijack` */

DROP TABLE IF EXISTS `tp_hijack`;

CREATE TABLE `tp_hijack` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `hijack_url` varchar(255) DEFAULT NULL COMMENT '劫持URL',
  `page_url` varchar(255) DEFAULT NULL COMMENT '发生页面url',
  `add_time` int(15) NOT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_hijack` */

LOCK TABLES `tp_hijack` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_industry_template` */

DROP TABLE IF EXISTS `tp_industry_template`;

CREATE TABLE `tp_industry_template` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `industry_id` int(11) unsigned NOT NULL COMMENT '行业id',
  `style_id` int(11) unsigned NOT NULL COMMENT '风格id',
  `template_name` varchar(64) NOT NULL COMMENT '模板名称',
  `template_html` longtext NOT NULL COMMENT '保存编辑后的HTML',
  `add_time` int(11) unsigned NOT NULL COMMENT '添加时间',
  `block_info` longtext NOT NULL COMMENT '接口数据',
  `thumb` varchar(255) DEFAULT NULL COMMENT '图片展示',
  `code_url` varchar(255) DEFAULT NULL COMMENT '二维码',
  PRIMARY KEY (`id`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_industry_template` */

LOCK TABLES `tp_industry_template` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_invoice` */

DROP TABLE IF EXISTS `tp_invoice`;

CREATE TABLE `tp_invoice` (
  `invoice_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) DEFAULT NULL COMMENT '订单id',
  `user_id` int(11) DEFAULT NULL COMMENT '用户id',
  `invoice_type` tinyint(1) DEFAULT '0' COMMENT '0普通发票1电子发票2增值税发票',
  `invoice_money` decimal(10,2) DEFAULT '0.00' COMMENT '发票金额',
  `invoice_title` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '发票抬头',
  `invoice_desc` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '发票内容',
  `invoice_rate` decimal(10,4) DEFAULT NULL COMMENT '发票税率',
  `taxpayer` varchar(50) CHARACTER SET utf8 DEFAULT NULL COMMENT '纳税人识别号',
  `status` tinyint(1) DEFAULT '0' COMMENT '发票状态0待开1已开2作废',
  `atime` int(11) DEFAULT '0' COMMENT '开票时间',
  `ctime` int(11) DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`invoice_id`)
)  AUTO_INCREMENT=301 DEFAULT CHARSET=latin1 COMMENT='发票信息表';

/*Data for the table `tp_invoice` */

LOCK TABLES `tp_invoice` WRITE;

insert  into `tp_invoice`(`invoice_id`,`order_id`,`user_id`,`invoice_type`,`invoice_money`,`invoice_title`,`invoice_desc`,`invoice_rate`,`taxpayer`,`status`,`atime`,`ctime`) values (1,6,2,0,139.00,'','明细',NULL,'',0,0,1523355241),(2,6,2,0,129.00,'','明细',NULL,'',0,0,1523355751),(3,7,2,0,129.00,'','明细',NULL,'',0,0,1523425501),(4,8,2,0,139.00,'','明细',NULL,'',0,0,1523428298),(5,9,2,0,139.00,'','明细',NULL,'',0,0,1523428631),(6,10,2,0,139.00,'','明细',NULL,'',0,0,1523429855),(7,13,5,0,6999.00,'','明细',NULL,'',0,0,1523589451),(8,15,2,0,35.00,'个人','明细',NULL,'',0,0,1523847216),(9,16,2,0,35.00,'个人','明细',NULL,'',0,0,1523847699),(10,17,2,0,35.00,'个人','明细',NULL,'',0,0,1523847838),(11,18,2,0,96.00,'当爱已成往事','明细',NULL,'123456789123456',0,0,1523849060),(12,19,2,0,13.00,'当爱已成往事','明细',NULL,'123456789123456',0,0,1523849306),(13,20,2,0,307.80,'当爱已成往事','明细',NULL,'123456789123456',0,0,1523850046),(14,21,2,0,19.90,'当爱已成往事','明细',NULL,'123456789123456',0,0,1523850201),(15,22,2,0,13.00,'当爱已成往事','明细',NULL,'123456789123456',0,0,1523850266),(16,23,2,0,13.00,'当爱已成往事','明细',NULL,'123456789123456',0,0,1523850641),(17,24,2,0,70.00,'当爱已成往事','明细',NULL,'123456789123456',0,0,1523850840),(18,26,2,0,177.00,'当爱已成往事','明细',NULL,'123456789123456',0,0,1523857235),(19,25,2,0,9.90,'','明细',NULL,'',1,1523932001,1523857281),(20,31,2,0,327.49,'给自己的歌','明细',NULL,'123456789123456',0,0,1523868306),(21,32,2,0,202.26,'给自己的歌','明细',NULL,'123456789123456',0,0,1523869388),(22,33,2,0,157.41,'给自己的歌','明细',NULL,'123456789123456',0,0,1523870002),(23,34,2,0,39.80,'给自己的歌','明细',NULL,'123456789123456',0,0,1523871112),(24,35,2,0,13.00,'给自己的歌','明细',NULL,'123456789123456',0,0,1523871295),(25,36,2,0,126.72,'给自己的歌','明细',NULL,'123456789123456',0,0,1523872111),(26,38,2,0,99.90,'','明细',NULL,'',0,0,1523872816),(27,39,2,0,1013.76,'给自己的歌','明细',NULL,'123456789123456',0,0,1523873474),(28,40,2,0,126.72,'给自己的歌','明细',NULL,'123456789123456',0,0,1523873570),(29,57,1,0,217.10,'','明细',NULL,'',0,0,1523935851),(30,59,1,0,187.00,'','明细',NULL,'',0,0,1523936632),(31,60,1,0,79.00,'','明细',NULL,'',0,0,1523936863),(32,63,1,0,118.00,'','明细',NULL,'',0,0,1523937181),(33,62,1,0,307.00,'','明细',NULL,'',0,0,1523937211),(34,64,1,0,185.00,'','明细',NULL,'',0,0,1523937571),(35,72,1,0,141.00,'傅','明细',NULL,'18283273718528',0,0,1523951443),(36,77,1,0,438.90,'','明细',NULL,'',0,0,1523952331),(37,50,8,0,55.00,'成都','明细',NULL,'123456789123456',0,0,1523954675),(38,81,3,0,153.90,'转身','明细',NULL,'123456789123456',0,0,1523955774),(39,83,3,0,1399.00,'转身','明细',NULL,'123456789123456',1,1523959258,1523956270),(40,84,3,0,125.00,'转身','明细',NULL,'123456789123456',1,1523959257,1523957538),(41,85,3,0,318.00,'转身','明细',NULL,'123456789123456',1,1523959256,1523958311),(42,86,3,0,196.00,'','明细',NULL,'',1,1523959255,1523958549),(43,87,3,0,196.00,'','明细',NULL,'',1,1523959254,1523958611),(44,88,3,0,636.00,'转身','明细',NULL,'123456789123456',0,0,1523960700),(45,90,3,0,70.00,'转身','明细',NULL,'123456789123456',0,0,1524013783),(46,91,3,0,214.83,'转身','明细',NULL,'123456789123456',0,0,1524015676),(47,93,3,0,199.00,NULL,'明细',NULL,'',0,0,1524016083),(48,94,3,0,198.00,NULL,'明细',NULL,'',0,0,1524016232),(49,97,3,0,24.00,'转身','明细',NULL,'123456789123456',0,0,1524021536),(50,98,3,0,3699.00,'个人','明细',NULL,'',0,0,1524021696),(51,99,3,0,117.00,NULL,'明细',NULL,'',0,0,1524022277),(52,100,3,0,78.00,'转身','明细',NULL,'123456789123456',0,0,1524022621),(53,101,3,0,39.00,'转身','明细',NULL,'123456789123456',0,0,1524022664),(54,102,3,0,49.00,'转身','明细',NULL,'123456789123456',0,0,1524022707),(55,103,3,0,117.00,'转身','明细',NULL,'123456789123456',0,0,1524022951),(56,109,3,0,136.00,NULL,'明细',NULL,'',0,0,1524031798),(57,111,3,0,117.00,NULL,'明细',NULL,'',0,0,1524032743),(58,119,3,0,277.30,NULL,'明细',NULL,'',0,0,1524036355),(59,122,3,0,277.30,NULL,'明细',NULL,'',0,0,1524036468),(60,123,3,0,261.00,'妮娜','明细',NULL,'1234556789123456',0,0,1524036678),(61,124,3,0,414.00,NULL,'明细',NULL,'',0,0,1524037073),(62,128,12,0,70.00,'','明细',NULL,'',0,0,1524039766),(63,133,3,0,3.73,NULL,'明细',NULL,'',0,0,1524043134),(64,136,2,0,198.00,'发票qwer','明细',NULL,'123456789123456',0,0,1524043805),(65,138,3,0,100.00,NULL,'明细',NULL,'',0,0,1524044435),(66,145,2,0,23364.00,'短发','明细',NULL,'123456789012345',0,0,1524100798),(67,148,2,0,225.00,'短发','明细',NULL,'123456789012345',0,0,1524102748),(68,147,2,0,150.00,'短发','明细',NULL,'123456789012345',0,0,1524102758),(69,159,1,0,2189.00,'个人','明细',NULL,'',0,0,1524106774),(70,164,3,0,58.00,'转身','明细',NULL,'123456789123456',0,0,1524107613),(71,167,1,0,1199.00,'个人','明细',NULL,'',0,0,1524108418),(72,170,1,0,1199.00,'个人','明细',NULL,'',0,0,1524108700),(73,171,9,0,59.00,NULL,'明细',NULL,'',0,0,1524109773),(74,169,1,0,47.00,'个人','明细',NULL,'',0,0,1524109866),(75,179,1,0,1599.00,'个人','明细',NULL,'',0,0,1524116115),(76,180,1,0,1599.00,'个人','明细',NULL,'',0,0,1524116275),(77,183,3,0,186.12,NULL,'明细',NULL,'',0,0,1524118106),(78,188,2,0,102.60,NULL,'明细',NULL,'',0,0,1524118295),(79,195,9,0,99.00,NULL,'明细',NULL,'',0,0,1524119285),(80,201,10,0,108.00,NULL,'明细',NULL,'',0,0,1524120398),(81,200,5,0,186.12,NULL,'明细',NULL,'',0,0,1524120406),(82,202,9,0,99.00,NULL,'明细',NULL,'',0,0,1524120548),(83,199,10,0,108.00,NULL,'明细',NULL,'',0,0,1524122521),(84,205,2,0,102.60,NULL,'明细',NULL,'',0,0,1524122650),(85,209,2,0,142.50,NULL,'明细',NULL,'',0,0,1524123445),(86,210,10,0,150.00,NULL,'明细',NULL,'',0,0,1524123555),(87,213,2,0,142.50,NULL,'明细',NULL,'',0,0,1524123689),(88,215,2,0,37.82,NULL,'明细',NULL,'',0,0,1524125666),(89,217,10,0,19.90,NULL,'明细',NULL,'',0,0,1524126097),(90,219,10,0,59.70,NULL,'明细',NULL,'',0,0,1524126267),(91,222,3,0,18.80,NULL,'明细',NULL,'',0,0,1524126744),(92,223,5,0,18.80,NULL,'明细',NULL,'',0,0,1524127087),(93,224,10,0,26.90,NULL,'明细',NULL,'',0,0,1524127168),(94,226,2,0,25.56,NULL,'明细',NULL,'',0,0,1524127233),(95,227,9,0,20.00,NULL,'明细',NULL,'',0,0,1524127340),(96,228,10,0,29.90,'个人','明细',NULL,'',0,0,1524127782),(97,230,3,0,18.71,NULL,'明细',NULL,'',0,0,1524129045),(98,234,2,0,18.91,NULL,'明细',NULL,'',0,0,1524129535),(99,235,2,0,102.60,NULL,'明细',NULL,'',0,0,1524129642),(100,236,10,0,108.00,NULL,'明细',NULL,'',0,0,1524130150),(101,237,10,0,108.00,NULL,'明细',NULL,'',0,0,1524130196),(102,243,10,0,39.90,NULL,'明细',NULL,'',0,0,1524186800),(103,244,10,0,19.90,NULL,'明细',NULL,'',0,0,1524187582),(104,247,2,0,18.91,NULL,'明细',NULL,'',0,0,1524189218),(105,248,2,0,18.91,NULL,'明细',NULL,'',0,0,1524189369),(106,249,3,0,32.90,NULL,'明细',NULL,'',0,0,1524190629),(107,250,3,0,18.80,NULL,'明细',NULL,'',0,0,1524193290),(108,251,3,0,18.80,NULL,'明细',NULL,'',0,0,1524193380),(109,253,2,0,37.91,NULL,'明细',NULL,'',0,0,1524204661),(110,254,3,0,70.00,'转身','明细',NULL,'123456789123456',0,0,1524205359),(111,256,3,0,35.00,'转身','明细',NULL,'123456789123456',0,0,1524206124),(112,257,3,0,261.32,'转身','明细',NULL,'123456789123456',0,0,1524206652),(113,258,9,0,177.00,NULL,'明细',NULL,'',0,0,1524207870),(114,260,10,0,39.90,NULL,'明细',NULL,'',0,0,1524208507),(115,261,9,0,178.20,NULL,'明细',NULL,'',0,0,1524208608),(116,263,2,0,250.00,'个人','明细',NULL,'',0,0,1524208771),(117,264,2,0,49.00,NULL,'明细',NULL,'',0,0,1524208862),(118,265,10,0,19.90,NULL,'明细',NULL,'',1,1524210575,1524209203),(119,277,10,0,76.00,'个人','明细',NULL,'',0,0,1524212862),(120,280,9,0,108.00,NULL,'明细',NULL,'',0,0,1524212957),(121,276,10,0,250.00,'个人','明细',NULL,'',0,0,1524213246),(122,274,10,0,76.00,'个人','明细',NULL,'',0,0,1524213401),(123,268,9,0,120.00,'来日方长','明细',NULL,'123456789123456',0,0,1524213821),(124,267,9,0,120.00,'来日方长','明细',NULL,'123456789123456',0,0,1524213835),(125,281,10,0,9.90,'','明细',NULL,'',0,0,1524214224),(126,282,10,0,9.90,'','明细',NULL,'',0,0,1524214263),(127,283,10,0,9.90,'','明细',NULL,'',0,0,1524214460),(128,286,10,0,250.00,'个人','明细',NULL,'',0,0,1524216002),(129,287,10,0,250.00,'个人','明细',NULL,'',0,0,1524216003),(130,288,10,0,759.00,'拉锯','明细',NULL,'2528',0,0,1524216193),(131,288,10,0,759.00,'拉锯','明细',NULL,'2528',0,0,1524216269),(132,288,10,0,759.00,'拉锯','明细',NULL,'2528',0,0,1524216305),(133,288,10,0,759.00,'拉锯','明细',NULL,'2528',0,0,1524216356),(134,289,10,0,759.00,'个人','明细',NULL,'',0,0,1524216594),(135,289,10,0,759.00,'个人','明细',NULL,'',0,0,1524216640),(136,288,10,0,759.00,'拉锯','明细',NULL,'2528',0,0,1524216764),(137,296,10,0,495.00,NULL,'明细',NULL,'',0,0,1524217615),(138,297,2,0,475.00,NULL,'明细',NULL,'',0,0,1524217872),(139,298,10,0,495.00,NULL,'明细',NULL,'',0,0,1524218242),(140,299,2,0,475.00,NULL,'明细',NULL,'',0,0,1524218364),(141,302,3,0,35.00,'转身','明细',NULL,'123456789123456',0,0,1524446789),(142,304,10,0,158.00,'个人','明细',NULL,'',0,0,1524448673),(143,307,2,0,190.00,NULL,'明细',NULL,'',0,0,1524449918),(144,308,10,0,198.00,NULL,'明细',NULL,'',0,0,1524450120),(145,312,2,0,594.00,NULL,'明细',NULL,'',0,0,1524450692),(146,313,10,0,396.00,NULL,'明细',NULL,'',0,0,1524450778),(147,314,2,0,39.00,'个人','明细',NULL,'',0,0,1524451867),(148,316,2,0,250.00,'个人','明细',NULL,'',0,0,1524453580),(149,317,10,0,125.00,'个人','明细',NULL,'',0,0,1524453933),(150,318,10,0,125.00,'个人','明细',NULL,'',0,0,1524454306),(151,319,3,0,356.00,'89999','明细',NULL,'123456789123456',0,0,1524455265),(152,320,10,0,9.90,'','明细',NULL,'',0,0,1524455300),(153,321,3,0,267.00,'89999','明细',NULL,'123456789123456',0,0,1524455370),(154,323,10,0,39.00,'个人','明细',NULL,'',0,0,1524455807),(155,324,3,0,216.00,'个人','明细',NULL,'',0,0,1524455996),(156,315,10,0,351.00,'个人','明细',NULL,'',0,0,1524462066),(157,325,10,0,100.00,'个人','明细',NULL,'',0,0,1524462356),(158,325,10,0,100.00,'个人','明细',NULL,'',0,0,1524462818),(159,326,10,0,9.90,'','明细',NULL,'',0,0,1524463018),(160,327,10,0,59.00,'个人','明细',NULL,'',0,0,1524464946),(161,329,3,0,317.72,'个人','明细',NULL,'',0,0,1524466432),(162,344,3,0,250.98,'没忘a','明细',NULL,'123456789123455',0,0,1524539942),(163,345,3,0,250.98,'没忘a','明细',NULL,'123456789123455',0,0,1524540131),(164,346,3,0,366.60,'没忘a','明细',NULL,'123456789123455',0,0,1524540437),(165,347,5,0,250.98,'','明细',NULL,'',0,0,1524540800),(166,348,5,0,83.66,'','明细',NULL,'',0,0,1524541232),(167,349,5,0,83.66,'','明细',NULL,'',0,0,1524541462),(168,350,5,0,83.66,'','明细',NULL,'',0,0,1524541695),(169,351,2,0,168.00,'个人','明细',NULL,'',0,0,1524541815),(170,354,2,0,186.00,'个人','明细',NULL,'',0,0,1524548235),(171,355,3,0,216.00,'网络科技','明细',NULL,'123456789123455',0,0,1524549712),(172,356,3,0,102.37,'网络科技','明细',NULL,'123456789123455',0,0,1524552678),(173,357,3,0,199.19,'网络科技','明细',NULL,'123456789123455',0,0,1524553669),(174,358,2,0,285.00,'个人','明细',NULL,'',0,0,1524555667),(175,359,17,0,159.50,NULL,'明细',NULL,'',0,0,1524555720),(176,360,2,0,82.72,'个人','明细',NULL,'',0,0,1524556735),(177,362,3,0,29.90,'网络科技','明细',NULL,'123456789123455',0,0,1524558343),(178,363,3,0,59.80,'网络科技','明细',NULL,'123456789123455',0,0,1524558405),(179,364,3,0,59.80,'网络科技','明细',NULL,'123456789123455',0,0,1524558538),(180,365,3,0,59.80,'网络科技','明细',NULL,'123456789123455',0,0,1524558863),(181,369,2,0,281.06,'个人','明细',NULL,'',0,0,1524561952),(182,368,3,0,196.00,'','明细',NULL,'',0,0,1524562025),(183,371,3,0,112.00,'','明细',NULL,'',0,0,1524562190),(184,372,17,0,294.00,'','明细',NULL,'',0,0,1524562498),(185,370,2,0,281.06,'个人','明细',NULL,'',0,0,1524562533),(186,373,17,0,82.80,'个人','明细',NULL,'',0,0,1524563178),(187,378,2,0,130.66,'个人','明细',NULL,'',0,0,1524565051),(188,379,2,0,93.06,'个人','明细',NULL,'',0,0,1524565330),(189,386,2,0,186.12,'个人','明细',NULL,'',0,0,1524566156),(190,387,2,0,186.12,'个人','明细',NULL,'',0,0,1524566329),(191,388,3,0,163.56,'网络科技','明细',NULL,'123456789123455',0,0,1524617536),(192,389,3,0,70.05,'网络科技','明细',NULL,'123456789123455',0,0,1524619938),(193,390,3,0,70.05,'网络科技','明细',NULL,'123456789123455',0,0,1524628920),(194,391,3,0,408.90,'网络科技','明细',NULL,'123456789123455',0,0,1524634991),(195,394,3,0,408.90,'网络科技','明细',NULL,'123456789123455',0,0,1524635584),(196,395,3,0,665.52,'网络科技','明细',NULL,'123456789123455',0,0,1524635856),(197,398,3,0,371.30,'网络科技','明细',NULL,'123456789123455',0,0,1524639991),(198,399,3,0,297.04,'网络科技','明细',NULL,'123456789123455',0,0,1524640099),(199,400,2,0,2537.06,'个人','明细',NULL,'',0,0,1524640110),(200,401,3,0,314.90,'网络科技','明细',NULL,'123456789123455',0,0,1524640175),(201,402,3,0,251.92,'网络科技','明细',NULL,'123456789123455',0,0,1524640198),(202,403,2,0,2537.06,'个人','明细',NULL,'',0,0,1524640223),(203,404,12,0,88.00,'','明细',NULL,'',0,0,1524640571),(204,406,2,0,2537.06,'个人','明细',NULL,'',0,0,1524640926),(205,407,12,0,88.00,'','明细',NULL,'',0,0,1524641309),(206,408,3,0,148.52,'网络科技','明细',NULL,'123456789123455',0,0,1524641548),(207,409,3,0,245.34,'网络科技','明细',NULL,'123456789123455',0,0,1524641703),(208,410,3,0,297.04,'网络科技','明细',NULL,'123456789123455',0,0,1524642044),(209,413,3,0,297.04,'网络科技','明细',NULL,'123456789123455',0,0,1524642277),(210,414,2,0,939.99,'个人','明细',NULL,'',0,0,1524642324),(211,414,2,0,939.99,'个人','明细',NULL,'',0,0,1524642414),(212,415,2,0,939.99,'个人','明细',NULL,'',0,0,1524642489),(213,416,2,0,251.92,'个人','明细',NULL,'',0,0,1524642621),(214,417,2,0,35.00,'个人','明细',NULL,'',0,0,1524643048),(215,418,1,0,285.00,'傅麻烦','明细',NULL,'2582582582822',0,0,1524645572),(216,424,1,0,99.90,'','明细',NULL,'',0,0,1524647224),(217,425,2,0,59.00,'都没','明细',NULL,'152528282828288',1,1524648084,1524647974),(218,440,3,0,70.00,'网络科技','明细',NULL,'123456789123455',0,0,1524706957),(219,441,3,0,152.00,'网络科技','明细',NULL,'123456789123455',0,0,1524709414),(220,442,3,0,228.00,'网络科技','明细',NULL,'123456789123455',1,1524715408,1524709446),(221,451,3,0,300.71,'网络科技','明细',NULL,'123456789123455',0,0,1524722541),(222,452,21,0,118.00,'个人','明细',NULL,'',0,0,1524724904),(223,453,2,0,219.00,'个人','明细',NULL,'',0,0,1524726588),(224,453,2,0,219.00,'个人','明细',NULL,'',0,0,1524726624),(225,454,22,0,70.00,'个人','明细',NULL,'',0,0,1524727160),(226,455,22,0,35.00,NULL,'明细',NULL,'',0,0,1524727388),(227,457,22,0,518.00,NULL,'明细',NULL,'',0,0,1524727895),(228,462,22,0,110.00,NULL,'明细',NULL,'',0,0,1524728555),(229,466,2,0,90.09,'3223','明细',NULL,'123228282821112',0,0,1524730355),(230,467,22,0,1021.00,NULL,'明细',NULL,'',0,0,1524730365),(231,468,2,0,29.90,'3223','明细',NULL,'123228282821112',0,0,1524731065),(232,469,2,0,1580.00,'3223','明细',NULL,'123228282821112',0,0,1524731672),(233,470,2,0,1580.00,'3223','明细',NULL,'123228282821112',0,0,1524732058),(234,472,22,0,495.00,NULL,'明细',NULL,'',0,0,1524732356),(235,473,23,0,88.70,NULL,'明细',NULL,'',0,0,1524732637),(236,474,2,0,1580.00,'3223','明细',NULL,'123228282821112',0,0,1524732656),(237,475,22,0,147.00,NULL,'明细',NULL,'',0,0,1524733604),(238,477,22,0,163.24,NULL,'明细',NULL,'',0,0,1524733717),(239,476,2,0,23.57,'3223','明细',NULL,'123228282821112',1,1524733820,1524733736),(240,478,2,0,180.18,'3223','明细',NULL,'123228282821112',0,0,1524734243),(241,479,22,0,292.84,NULL,'明细',NULL,'',0,0,1524734727),(242,481,2,0,11.00,'3223','明细',NULL,'123228282821112',0,0,1524737196),(243,480,2,0,11.00,'3223','明细',NULL,'123228282821112',0,0,1524737359),(244,483,2,0,126.49,'3223','明细',NULL,'123228282821112',0,0,1524737821),(245,482,21,0,500.00,NULL,'明细',NULL,'',0,0,1524737824),(246,485,2,0,24.50,'3223','明细',NULL,'123228282821112',0,0,1524738113),(247,486,21,0,108.00,NULL,'明细',NULL,'',0,0,1524738348),(248,487,2,0,24.50,'3223','明细',NULL,'123228282821112',0,0,1524738747),(249,493,17,0,110.00,NULL,'明细',NULL,'',0,0,1524793428),(250,494,23,0,165.00,NULL,'明细',NULL,'',0,0,1524794051),(251,495,23,0,417.90,NULL,'明细',NULL,'',0,0,1524794586),(252,496,23,0,651.40,NULL,'明细',NULL,'',0,0,1524794747),(253,498,17,0,29.90,NULL,'明细',NULL,'',0,0,1524794882),(254,501,17,0,100.00,NULL,'明细',NULL,'',0,0,1524795500),(255,503,24,0,100.00,NULL,'明细',NULL,'',0,0,1524796386),(256,504,23,0,50.00,NULL,'明细',NULL,'',0,0,1524796542),(257,509,24,0,50.00,NULL,'明细',NULL,'',0,0,1524798552),(258,513,23,0,272.00,NULL,'明细',NULL,'',0,0,1524799061),(259,516,23,0,78.00,NULL,'明细',NULL,'',0,0,1524799553),(260,517,24,0,39.00,NULL,'明细',NULL,'',0,0,1524799593),(261,518,23,0,78.00,NULL,'明细',NULL,'',0,0,1524799695),(262,519,24,0,78.00,NULL,'明细',NULL,'',0,0,1524799718),(263,520,24,0,39.00,NULL,'明细',NULL,'',0,0,1524799820),(264,521,23,0,39.00,NULL,'明细',NULL,'',0,0,1524799856),(265,522,23,0,100.00,NULL,'明细',NULL,'',0,0,1524799939),(266,523,24,0,50.00,NULL,'明细',NULL,'',0,0,1524800012),(267,524,22,0,49.50,NULL,'明细',NULL,'',0,0,1524800109),(268,525,23,0,50.00,NULL,'明细',NULL,'',0,0,1524801370),(269,526,25,0,7788.00,NULL,'明细',NULL,'',0,0,1524807547),(270,527,26,0,152.00,NULL,'明细',NULL,'',0,0,1524808092),(271,528,25,0,940.00,NULL,'明细',NULL,'',0,0,1524808381),(272,538,17,0,219.00,NULL,'明细',NULL,'',0,0,1524809640),(273,539,24,0,545.00,'个人','明细',NULL,'',0,0,1524810329),(274,540,17,0,284.70,NULL,'明细',NULL,'',0,0,1524810889),(275,541,25,0,1399.00,NULL,'明细',NULL,'',0,0,1524812155),(276,542,25,0,1399.00,NULL,'明细',NULL,'',0,0,1524812177),(277,543,23,0,438.00,NULL,'明细',NULL,'',0,0,1524813030),(278,545,23,0,1980.00,NULL,'明细',NULL,'',0,0,1524813330),(279,544,25,0,1399.00,NULL,'明细',NULL,'',0,0,1524813364),(280,546,23,0,174.00,'珊珊','明细',NULL,'123423456855445556',0,0,1524813897),(281,547,22,0,70.00,'','明细',NULL,'',0,0,1524814028),(282,551,22,0,58.00,'个人','明细',NULL,'',0,0,1524815527),(283,552,17,0,29.00,NULL,'明细',NULL,'',0,0,1524815641),(284,553,24,0,196.00,'','明细',NULL,'',0,0,1524816472),(285,554,24,0,98.00,'','明细',NULL,'',0,0,1524816520),(286,555,25,0,29.90,NULL,'明细',NULL,'',0,0,1524817570),(287,555,25,0,29.90,NULL,'明细',NULL,'',0,0,1524817578),(288,556,24,0,259.28,'','明细',NULL,'',0,0,1524818028),(289,557,24,0,472.23,'','明细',NULL,'',0,0,1524818412),(290,558,2,0,65.00,'新世界有限公司','明细',NULL,'132252525252525',1,1524819161,1524818616),(291,561,2,0,13.00,'新世界有限公司','明细',NULL,'132252525252525',0,0,1524819776),(292,562,2,0,13.00,'新世界有限公司','明细',NULL,'132252525252525',0,0,1524820518),(293,566,2,0,88.88,NULL,'明细',NULL,'',0,0,1524821142),(294,571,17,0,26.00,'个人','明细',NULL,'',0,0,1524821804),(295,576,31,0,570.00,'个人','明细',NULL,'',0,0,1524825875),(296,578,31,0,256.00,'个人','明细',NULL,'',0,0,1524877537),(297,580,32,0,1699.00,'个人','明细',NULL,'',0,0,1524877877),(298,581,31,0,128.00,'个人','明细',NULL,'',0,0,1524878391),(299,579,32,0,1699.00,'个人','明细',NULL,'',0,0,1524878702),(300,582,31,0,256.00,'个人','明细',NULL,'',0,0,1524879244);

UNLOCK TABLES;

/*Table structure for table `tp_kf_access` */

DROP TABLE IF EXISTS `tp_kf_access`;

CREATE TABLE `tp_kf_access` (
  `role_id` smallint(6) unsigned NOT NULL,
  `node_id` smallint(6) unsigned NOT NULL,
  `pid` smallint(6) unsigned NOT NULL,
  `level` tinyint(1) NOT NULL,
  `module` varchar(50) DEFAULT NULL,
  KEY `groupId` (`role_id`),
  KEY `nodeId` (`node_id`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_kf_access` */

LOCK TABLES `tp_kf_access` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_kf_admin` */

DROP TABLE IF EXISTS `tp_kf_admin`;

CREATE TABLE `tp_kf_admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `login_name` varchar(155) NOT NULL,
  `password` varchar(255) NOT NULL,
  `role` smallint(6) unsigned NOT NULL COMMENT '组ID',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态 1:启用 0:禁止',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注说明',
  `last_login_time` int(11) unsigned NOT NULL COMMENT '最后登录时间',
  `last_login_ip` varchar(15) DEFAULT NULL COMMENT '最后登录IP',
  `last_location` varchar(100) DEFAULT NULL COMMENT '最后登录位置',
  `storeid` int(11) unsigned NOT NULL COMMENT '企业id（店铺id）',
  PRIMARY KEY (`id`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_kf_admin` */

LOCK TABLES `tp_kf_admin` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_kf_answer` */

DROP TABLE IF EXISTS `tp_kf_answer`;

CREATE TABLE `tp_kf_answer` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `que_id` int(11) unsigned NOT NULL COMMENT '问题id',
  `content` varchar(255) NOT NULL COMMENT '内容',
  `add_time` int(11) unsigned NOT NULL COMMENT '添加时间',
  PRIMARY KEY (`id`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_kf_answer` */

LOCK TABLES `tp_kf_answer` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_kf_attr_question` */

DROP TABLE IF EXISTS `tp_kf_attr_question`;

CREATE TABLE `tp_kf_attr_question` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(255) NOT NULL COMMENT '问题分类名称',
  `pid` int(11) unsigned NOT NULL COMMENT '父分类id',
  `storeid` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '所属店铺id',
  `add_time` int(11) unsigned NOT NULL COMMENT '添加时间',
  PRIMARY KEY (`id`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_kf_attr_question` */

LOCK TABLES `tp_kf_attr_question` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_kf_chatlog` */

DROP TABLE IF EXISTS `tp_kf_chatlog`;

CREATE TABLE `tp_kf_chatlog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `from_id` varchar(55) NOT NULL COMMENT '网页用户随机编号(仅为记录参考记录)',
  `kefu_id` varchar(55) NOT NULL COMMENT '客服的id',
  `content` text NOT NULL COMMENT '发送的内容',
  `timeline` int(10) NOT NULL COMMENT '记录时间',
  `is_delete` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除  0：未删除 1：已删除',
  `need_send` tinyint(1) DEFAULT '0' COMMENT '0 不需要推送 1 需要推送',
  `from_name` varchar(155) NOT NULL DEFAULT '' COMMENT '消息来源用户名',
  `to_name` varchar(155) NOT NULL DEFAULT '' COMMENT '接收消息用户名',
  `storeid` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '店铺id',
  `store_name` varchar(50) NOT NULL COMMENT '客服所属店铺名称',
  PRIMARY KEY (`id`),
  KEY `fromid` (`from_id`(4)),
  KEY `toid` (`kefu_id`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_kf_chatlog` */

LOCK TABLES `tp_kf_chatlog` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_kf_kefu` */

DROP TABLE IF EXISTS `tp_kf_kefu`;

CREATE TABLE `tp_kf_kefu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(155) DEFAULT NULL,
  `pwd` varchar(155) DEFAULT NULL COMMENT '密码',
  `sign` varchar(255) DEFAULT NULL,
  `avatar` varchar(255) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0' COMMENT '0下线 1在线',
  `storeid` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '店铺id，默认1',
  `Auditing` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否审核  0：待审核  1：审核通过  2：审核不通过',
  `store_name` varchar(50) NOT NULL COMMENT '客服所属店铺名称',
  `is_delete` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除  0：未删除 1：已删除',
  `role` smallint(6) unsigned NOT NULL DEFAULT '5' COMMENT '组ID',
  PRIMARY KEY (`id`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_kf_kefu` */

LOCK TABLES `tp_kf_kefu` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_kf_node` */

DROP TABLE IF EXISTS `tp_kf_node`;

CREATE TABLE `tp_kf_node` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL COMMENT '节点名称',
  `title` varchar(50) NOT NULL COMMENT '菜单名称',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否激活 1：是 2：否',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注说明',
  `pid` smallint(6) unsigned NOT NULL COMMENT '父ID',
  `level` tinyint(1) unsigned NOT NULL COMMENT '节点等级',
  `data` varchar(255) DEFAULT NULL COMMENT '附加参数',
  `sort` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT '排序权重',
  `display` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '菜单显示类型 0:不显示 1:导航菜单 2:左侧菜单',
  PRIMARY KEY (`id`),
  KEY `level` (`level`),
  KEY `pid` (`pid`),
  KEY `status` (`status`),
  KEY `name` (`name`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_kf_node` */

LOCK TABLES `tp_kf_node` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_kf_question` */

DROP TABLE IF EXISTS `tp_kf_question`;

CREATE TABLE `tp_kf_question` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `name` varchar(255) NOT NULL COMMENT '名称',
  `link` varchar(255) DEFAULT NULL COMMENT '连接',
  `add_time` int(11) unsigned NOT NULL COMMENT '添加时间',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否启用 0 ：不启用  1：启用',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '父级id',
  `storeid` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '店铺id',
  `is_host` tinyint(1) unsigned NOT NULL COMMENT '是否热门  0：否 1：是',
  `is_common` tinyint(1) unsigned NOT NULL COMMENT '是否常见 0：否 1：是',
  PRIMARY KEY (`id`)
)  DEFAULT CHARSET=utf8 COMMENT='问题分类表';

/*Data for the table `tp_kf_question` */

LOCK TABLES `tp_kf_question` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_kf_robot` */

DROP TABLE IF EXISTS `tp_kf_robot`;

CREATE TABLE `tp_kf_robot` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `robot_name` varchar(32) NOT NULL COMMENT '名称',
  `avatar` varchar(255) DEFAULT NULL COMMENT '头像',
  `storeid` int(11) unsigned NOT NULL COMMENT '店铺id',
  PRIMARY KEY (`id`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_kf_robot` */

LOCK TABLES `tp_kf_robot` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_kf_role` */

DROP TABLE IF EXISTS `tp_kf_role`;

CREATE TABLE `tp_kf_role` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL COMMENT '后台组名',
  `pid` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `status` tinyint(1) unsigned DEFAULT '0' COMMENT '是否激活 1：是 0：否',
  `sort` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT '排序权重',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注说明',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `status` (`status`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_kf_role` */

LOCK TABLES `tp_kf_role` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_kf_role_user` */

DROP TABLE IF EXISTS `tp_kf_role_user`;

CREATE TABLE `tp_kf_role_user` (
  `user_id` int(10) unsigned NOT NULL,
  `role_id` smallint(6) unsigned NOT NULL,
  KEY `group_id` (`role_id`),
  KEY `user_id` (`user_id`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_kf_role_user` */

LOCK TABLES `tp_kf_role_user` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_kf_slogan` */

DROP TABLE IF EXISTS `tp_kf_slogan`;

CREATE TABLE `tp_kf_slogan` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '提示语id主键',
  `slogan` varchar(55) DEFAULT NULL COMMENT '标语（客服加载欢迎语）',
  `slogan_status` tinyint(1) unsigned DEFAULT '1' COMMENT '提示语状态  0：不开启  1：开启',
  `auditing` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否审核提示语  0：待审核  1：审核通过  2：审核不通过',
  `timeline` int(11) unsigned DEFAULT NULL COMMENT '提示语设置时间',
  `storeid` int(11) unsigned NOT NULL COMMENT '提示语所属店铺id',
  `is_delete` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除  0：未删除 1：已删除',
  `kefuid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '客服id',
  PRIMARY KEY (`id`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_kf_slogan` */

LOCK TABLES `tp_kf_slogan` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_kf_store` */

DROP TABLE IF EXISTS `tp_kf_store`;

CREATE TABLE `tp_kf_store` (
  `storeid` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '店铺id',
  `store_name` varchar(55) NOT NULL COMMENT '店铺名称',
  `avatar` varchar(255) NOT NULL COMMENT '店铺头像',
  `auditing` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否审核  0：待审核  1：审核通过  2：审核不通过',
  `timeline` int(11) unsigned DEFAULT NULL COMMENT '提示语设置时间',
  `is_delete` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除  0：未删除 1：已删除',
  `webid` varchar(255) NOT NULL COMMENT '网站域名',
  `phone` char(11) NOT NULL COMMENT '企业电话',
  `city` varchar(255) NOT NULL COMMENT '企业地址',
  `email` varchar(255) NOT NULL COMMENT '企业邮箱',
  PRIMARY KEY (`storeid`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_kf_store` */

LOCK TABLES `tp_kf_store` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_kf_suggest` */

DROP TABLE IF EXISTS `tp_kf_suggest`;

CREATE TABLE `tp_kf_suggest` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '客户意见反馈主键id',
  `storeid` int(11) unsigned NOT NULL COMMENT '店铺id',
  `kehuid` varchar(255) NOT NULL COMMENT '客户id',
  `is_satisfied` tinyint(1) unsigned NOT NULL DEFAULT '3' COMMENT '满意度 0：很不满意  1：不满意 2：一般 3：满意 4：非常满意',
  `suggest` varchar(255) DEFAULT NULL COMMENT '建议',
  `timeline` int(11) unsigned DEFAULT NULL COMMENT '反馈时间',
  `is_delete` tinyint(1) unsigned NOT NULL COMMENT '是否删除  0：未删除   1：已删除',
  `kefu_id` int(11) unsigned NOT NULL COMMENT '客服id',
  PRIMARY KEY (`id`)
)  DEFAULT CHARSET=utf8 COMMENT='客户意见表';

/*Data for the table `tp_kf_suggest` */

LOCK TABLES `tp_kf_suggest` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_kf_weixin_merchant` */

DROP TABLE IF EXISTS `tp_kf_weixin_merchant`;

CREATE TABLE `tp_kf_weixin_merchant` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '联关v1_store表主键',
  `storeid` int(11) DEFAULT NULL,
  `wx_type` tinyint(1) DEFAULT '0' COMMENT '众公号类型',
  `wx_url` varchar(100) DEFAULT NULL,
  `wx_token` varchar(50) DEFAULT NULL,
  `wx_EncodingAESKey` varchar(50) DEFAULT NULL COMMENT '消息加密密钥',
  `wx_raw_id` varchar(30) DEFAULT NULL COMMENT '微信原始ID',
  `wx_AppId` varchar(20) DEFAULT NULL,
  `wx_AppSecret` varchar(50) DEFAULT NULL,
  `wx_Random` tinyint(1) DEFAULT '0' COMMENT '是否随机回复',
  `wx_Subscribe` text COMMENT '关注后的回复',
  `wx_NoneReply` text COMMENT '无匹配时的回复',
  `media_id` varchar(255) DEFAULT NULL COMMENT '关注回复',
  `media_id2` varchar(255) DEFAULT NULL COMMENT '无匹配回复',
  PRIMARY KEY (`id`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_kf_weixin_merchant` */

LOCK TABLES `tp_kf_weixin_merchant` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_menu_cfg` */

DROP TABLE IF EXISTS `tp_menu_cfg`;

CREATE TABLE `tp_menu_cfg` (
  `menu_id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(100) NOT NULL DEFAULT '' COMMENT '自定义名称',
  `default_name` varchar(100) NOT NULL DEFAULT '' COMMENT '默认名称',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否显示',
  `is_tab` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否切块',
  `menu_url` varchar(255) NOT NULL DEFAULT '' COMMENT '手机端url',
  PRIMARY KEY (`menu_id`)
)  AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

/*Data for the table `tp_menu_cfg` */

LOCK TABLES `tp_menu_cfg` WRITE;

insert  into `tp_menu_cfg`(`menu_id`,`menu_name`,`default_name`,`is_show`,`is_tab`,`menu_url`) values (1,'订单列表','我的订单',1,1,'/Mobile/Order/order_list'),(2,'优惠券','我的优惠券',1,1,'/Mobile/User/coupon'),(3,'海报','我的海报',0,1,'/Mobile/User/qr_code'),(4,'我的分销','我的分销',0,1,'/Mobile/Distribut/index'),(5,'虚拟订单','虚拟订单',0,1,'/Mobile/Virtual/virtual_list'),(6,'拼团订单','拼团订单',0,1,'/Mobile/Order/team_list'),(7,'预约订单','预约订单',0,1,''),(8,'自提订单','自提订单',0,1,'/Mobile/Order/order_list/is_shop/1'),(9,'我的评价','我的评价',1,1,'/Mobile/Order/comment/status/1'),(10,'积分兑换','积分兑换',1,1,'/Mobile/Goods/integralMall'),(11,'我的签到','我的签到',0,1,'/Mobile/User/sign'),(12,'领券中心','领券中心',1,1,'/Mobile/Activity/coupon_list'),(13,'我的收藏','我的收藏',1,1,'/Mobile/User/collect_list'),(14,'我的足迹','我的足迹',1,1,'/Mobile/User/visit_log'),(15,'我的消息','我的消息',1,1,'/Mobile/User/message_notice'),(16,'我的发票','我的发票',1,1,''),(17,'地址管理','地址管理',1,1,'/Mobile/User/address_list');

UNLOCK TABLES;

/*Table structure for table `tp_message` */

DROP TABLE IF EXISTS `tp_message`;

CREATE TABLE `tp_message` (
  `message_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '管理者id',
  `message` text NOT NULL COMMENT '站内信内容',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '个体消息：0，全体消息1',
  `category` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT ' 系统消息：0，活动消息：1',
  `send_time` int(10) unsigned NOT NULL COMMENT '发送时间',
  `data` text COMMENT '消息序列化内容',
  PRIMARY KEY (`message_id`)
)  AUTO_INCREMENT=46 DEFAULT CHARSET=utf8;

/*Data for the table `tp_message` */

LOCK TABLES `tp_message` WRITE;

insert  into `tp_message`(`message_id`,`admin_id`,`message`,`type`,`category`,`send_time`,`data`) values (1,1,'ddddddd',0,0,1523238852,NULL),(2,1,'ddddd',0,0,1523331889,NULL),(3,1,'思恋最遥遥而无期',1,0,1523861724,NULL),(4,1,'ssfsfsf',0,0,1523862044,NULL),(5,1,'DDDD',0,0,1523862493,NULL),(6,1,'等待等待过多过多过过过',0,0,1523865070,NULL),(7,1,'遇见你是一种魅力',0,0,1523865094,NULL),(8,1,'订单对对对多',0,0,1523865853,NULL),(9,1,'是附属负数',1,0,1523865881,NULL),(10,1,'试试水',0,0,1523929591,NULL),(11,1,'NI NI NI NI I NI I INI ID GSJGLSDJGL G',1,0,1524210694,NULL),(12,1,'登录到大得得得离开上海富士康骄傲刚开始了了单方事故',0,0,1524210707,NULL),(13,1,'感谢',0,0,1524210714,NULL),(14,1,'打得过的多规格个',0,0,1524210815,NULL),(15,1,'打得过的的广东省',0,0,1524210820,NULL),(16,1,'的郭德纲',0,0,1524210824,NULL),(17,1,'NI DHOGHS GKSGSG',1,0,1524211235,NULL),(18,1,'DDGSGGSGSG',0,0,1524211239,NULL),(19,1,'SGSGFDSG',0,0,1524211244,NULL),(20,1,'2852',0,0,1524211298,NULL),(21,1,'大概多少公司公司的公司',0,0,1524211859,NULL),(22,1,'的广东省个是鬼斧神工',0,0,1524211935,NULL),(23,1,'多少个电商公司给第三个是',0,0,1524211942,NULL),(24,1,'是感受感受发过很多很多',0,0,1524211952,NULL),(25,1,'855545566222',0,0,1524445608,NULL),(26,1,'DNGLDGJDLJSKGHLSGJSGSDG',1,0,1524449112,NULL),(27,1,'sfsfsfafsfasgdfgdg',1,0,1524650005,NULL),(28,1,'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa',1,0,1524650031,NULL),(29,1,'2223232323',1,0,1524713374,NULL),(30,1,'23232323322332',1,0,1524713393,NULL),(31,1,'8555',1,0,1524713433,NULL),(32,1,'2323233223',1,0,1524713484,NULL),(33,1,'855000',0,0,1524713508,NULL),(34,1,'你好你好测试测试测测错错错错错错错错错错错错错错错测测测试赛的的二多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多多',1,0,1524726099,NULL),(35,1,'多规格多少个的好都很大方好地方恢复供货大幅度和都好都好法国恢复大声道',1,0,1524726177,NULL),(36,1,'你你看你狂蜂浪蝶十来个老师鬼哭狼嚎老客户输卵管很老实的公司两个还考虑到涵盖了第三个是个好老师个',0,0,1524726232,NULL),(37,1,'85541125',1,0,1524732067,NULL),(38,1,'jdfkjshdhklhkjhfkjhjfskj你临时分类卡还是可好看了黑咕隆咚两个还老客户了读后感良好的孤苦伶仃工行卡号股东会公开刘德华赶快来的',1,0,1524810501,NULL),(39,1,'接口多个合理的开个会大概是回来的改回来快递发货观看了反倒是好的工行卡的联合国老客户电饭锅了来看待了覆盖看了可观的了翰林华府敢肯定',1,0,1524810542,NULL),(40,1,'很好看绿化带上课了复合弓',1,0,1524810614,NULL),(41,1,'的广东省考虑到功夫老勺 ',1,0,1524810619,NULL),(42,1,'收购价和康师傅会计师法规及  多个',1,0,1524810653,NULL),(43,1,'首付款了红烧豆腐哈伦裤婚纱礼服',1,0,1524810661,NULL),(44,1,'测试测试测试测试说所所所所所所所所所所所所所所所所所所所所所所所所以还是测试',1,0,1524810944,NULL),(45,1,'ddgdsgdfghdfh',1,0,1524818191,NULL);

UNLOCK TABLES;

/*Table structure for table `tp_message_activity` */

DROP TABLE IF EXISTS `tp_message_activity`;

CREATE TABLE `tp_message_activity` (
  `message_id` int(11) NOT NULL AUTO_INCREMENT,
  `message_title` varchar(255) NOT NULL COMMENT '消息标题',
  `message_content` text COMMENT '消息内容',
  `img_uri` varchar(255) DEFAULT NULL COMMENT '图片地址',
  `send_time` int(10) unsigned NOT NULL COMMENT '发送时间',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '活动结束时间',
  `mmt_code` varchar(50) NOT NULL COMMENT '用户消息模板编号',
  `prom_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '1抢购2团购3优惠促销4预售5虚拟6拼团7搭配购8自定义图文消息9订单促销',
  `prom_id` int(11) NOT NULL DEFAULT '0' COMMENT '活动id',
  PRIMARY KEY (`message_id`)
)  DEFAULT CHARSET=utf8 COMMENT='活动消息表';

/*Data for the table `tp_message_activity` */

LOCK TABLES `tp_message_activity` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_message_logistics` */

DROP TABLE IF EXISTS `tp_message_logistics`;

CREATE TABLE `tp_message_logistics` (
  `message_id` int(11) NOT NULL AUTO_INCREMENT,
  `message_title` varchar(255) DEFAULT NULL COMMENT '消息标题',
  `message_content` text NOT NULL COMMENT '消息内容',
  `img_uri` varchar(255) DEFAULT NULL COMMENT '图片地址',
  `send_time` int(10) unsigned NOT NULL COMMENT '发送时间',
  `order_sn` varchar(20) NOT NULL DEFAULT '' COMMENT '单号',
  `order_id` int(11) NOT NULL DEFAULT '0' COMMENT '物流订单id',
  `mmt_code` varchar(50) DEFAULT NULL COMMENT '用户消息模板编号',
  `type` tinyint(1) unsigned DEFAULT '0' COMMENT '1到货通知2发货提醒3签收提醒4评价提醒5退货提醒6退款提醒7虚拟商品',
  PRIMARY KEY (`message_id`)
)  DEFAULT CHARSET=utf8 COMMENT='物流消息表';

/*Data for the table `tp_message_logistics` */

LOCK TABLES `tp_message_logistics` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_message_notice` */

DROP TABLE IF EXISTS `tp_message_notice`;

CREATE TABLE `tp_message_notice` (
  `message_id` int(11) NOT NULL AUTO_INCREMENT,
  `message_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '个体消息：0，全体消息:1',
  `message_title` varchar(255) DEFAULT NULL COMMENT '消息标题',
  `message_content` text NOT NULL COMMENT '消息内容',
  `send_time` int(10) unsigned NOT NULL COMMENT '发送时间',
  `mmt_code` varchar(50) DEFAULT NULL COMMENT '用户消息模板编号',
  `type` tinyint(1) unsigned DEFAULT '0' COMMENT '0系统公告1降价通知2优惠券到账提醒3优惠券使用提醒4优惠券即将过期提醒5预售订单尾款支付提醒6提现到账提醒',
  `prom_id` int(11) NOT NULL DEFAULT '0' COMMENT '活动id',
  PRIMARY KEY (`message_id`)
)  DEFAULT CHARSET=utf8 COMMENT='通知消息表';

/*Data for the table `tp_message_notice` */

LOCK TABLES `tp_message_notice` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_message_private` */

DROP TABLE IF EXISTS `tp_message_private`;

CREATE TABLE `tp_message_private` (
  `message_id` int(11) NOT NULL AUTO_INCREMENT,
  `message_content` text NOT NULL COMMENT '消息内容',
  `send_time` int(10) unsigned NOT NULL COMMENT '发送时间',
  `send_user_id` mediumint(8) unsigned NOT NULL COMMENT '发送者',
  PRIMARY KEY (`message_id`)
)  DEFAULT CHARSET=utf8 COMMENT='私信消息表';

/*Data for the table `tp_message_private` */

LOCK TABLES `tp_message_private` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_mobile_block_info` */

DROP TABLE IF EXISTS `tp_mobile_block_info`;

CREATE TABLE `tp_mobile_block_info` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `block_id` int(11) NOT NULL COMMENT '所属板块id',
  `block_type` int(8) unsigned NOT NULL COMMENT '板块类型',
  `title` varchar(120) DEFAULT NULL COMMENT '标题、描述、文字内容',
  `block_content` varchar(255) DEFAULT NULL COMMENT '其它信息',
  PRIMARY KEY (`id`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_mobile_block_info` */

LOCK TABLES `tp_mobile_block_info` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_mobile_template` */

DROP TABLE IF EXISTS `tp_mobile_template`;

CREATE TABLE `tp_mobile_template` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `is_index` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否设为首页 0否 1是',
  `template_name` varchar(64) NOT NULL COMMENT '模板名称',
  `template_html` longtext NOT NULL COMMENT '保存编辑后的HTML',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示 0不显示  1显示',
  `add_time` int(11) unsigned NOT NULL COMMENT '添加时间',
  `block_info` longtext NOT NULL COMMENT '接口数据',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '模板类型 0内页  1首页',
  `thumb` varchar(64) DEFAULT NULL COMMENT '模板缩略图',
  `style_id` int(11) DEFAULT '0' COMMENT '从模板库中添加风格id，',
  PRIMARY KEY (`id`)
)  AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

/*Data for the table `tp_mobile_template` */

LOCK TABLES `tp_mobile_template` WRITE;

insert  into `tp_mobile_template`(`id`,`is_index`,`template_name`,`template_html`,`is_show`,`add_time`,`block_info`,`type`,`thumb`,`style_id`) values (1,0,'可否','                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            &lt;div class=&quot;tpdm-head-wrap&quot; data-name=&quot;搜索框&quot;&gt;                             &lt;div class=&quot;tpdm-head-js tpdm-head-scale&quot;&gt;&lt;div class=&quot;tpd-search-warp clearfix&quot;&gt;&lt;a class=&quot;tpd-logo&quot; href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;/public/static/images/logo.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;form class=&quot;tpd-search-form&quot; action=&quot;&quot;&gt;&lt;i class=&quot;ico-head-search&quot;&gt;&lt;/i&gt;&lt;a href=&quot;/mobile/Goods/ajaxSearch.html&quot;&gt;&lt;input type=&quot;text&quot; placeholder=&quot;请输入您所搜索的商品&quot;&gt;&lt;/a&gt;&lt;/form&gt;&lt;a class=&quot;tpd-personal-warp&quot; href=&quot;/Mobile/User/login.html&quot;&gt; &lt;span&gt;登录&lt;/span&gt; &lt;i class=&quot;ico-head-personal&quot;&gt;&lt;/i&gt; &lt;/a&gt;&lt;/div&gt;&lt;/div&gt;                             &lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;                             &lt;script&gt;                                 $(\'.tpdm-head-wrap\').click(function () {                                     $(this).toggleClass(\'tpdm-head-edit\');                                 });                                 $(\'.tpdm-head-wrap&gt;.tpd-editing-close\').click(function () {                                     $(this).parents(\'.tpdm-head-wrap\').find(\'.tpdm-head-js\').removeClass(\'tpdm-head-scale\').html(\'\');                                     block.is_search=0;                                     delete block.search_style;                                     delete block[block.search_id];                                     delete block.search_id;                                 })                              &lt;/script&gt;                         &lt;/div&gt;                         &lt;div class=&quot;tpd-edits-hidden&quot; data-timeid=&quot;1524642687000&quot; data-eidtid=&quot;1&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-carousel&quot; id=&quot;carousel1524642687&quot;&gt;&lt;ul class=&quot;tpd-banner-list&quot;&gt; &lt;li&gt;&lt;a href=&quot;/index.php/Mobile/Goods/goodsList/id/286.html&quot;&gt;&lt;img src=&quot;/public/upload/temp/2018/04-25/27d6e8fb35b3de8dfafe8d650a4e8f5a.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;/li&gt;&lt;li&gt;&lt;a href=&quot;/index.php?m=Home&amp;amp;c=Goods&amp;amp;a=goodsInfo&amp;amp;id=1&quot;&gt; &lt;img src=&quot;/public/upload/temp/2018/04-25/228f58cb4aff15f144058718b0e70a96.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;/li&gt;&lt;/ul&gt;&lt;div class=&quot;page-num&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-carousel-js&quot;&gt;&lt;script&gt;swiperSlide(carousel1524642687,3000)&lt;/script&gt;&lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpd-edits-hidden&quot; data-timeid=&quot;1523949792000&quot; data-eidtid=&quot;2&quot; style=&quot;margin-bottom: 30px;&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-navstyle clearfix tpdm-navstyle3 tpdm-navstyle-circle&quot;&gt; &lt;a href=&quot;/mobile/index/index2/3&quot;&gt; &lt;div class=&quot;tpdm-navstyle-ico&quot;&gt;&lt;img src=&quot;/public/upload/temp/2018/04-17/d8328e62f91e9a42cb72e26389f66849.png&quot; alt=&quot;&quot;&gt;&lt;/div&gt;&lt;p class=&quot;tpdm-navstyle-cont&quot;&gt;拼团&lt;/p&gt; &lt;/a&gt; &lt;a href=&quot;/mobile/index/index2/2&quot;&gt; &lt;div class=&quot;tpdm-navstyle-ico&quot;&gt;&lt;img src=&quot;/public/upload/temp/2018/04-17/c5e04a4d0801af786e308a930d5b7753.png&quot; alt=&quot;&quot;&gt;&lt;/div&gt; &lt;p class=&quot;tpdm-navstyle-cont&quot;&gt;秒杀&lt;/p&gt; &lt;/a&gt; &lt;a href=&quot;/mobile/Cart/index.html&quot;&gt; &lt;div class=&quot;tpdm-navstyle-ico&quot;&gt;&lt;img src=&quot;/public/upload/temp/2018/04-17/98a701072f9960ed3bf450681bb8d041.png&quot; alt=&quot;&quot;&gt;&lt;/div&gt; &lt;p class=&quot;tpdm-navstyle-cont&quot;&gt;购物车&lt;/p&gt; &lt;/a&gt;   &lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpd-edits-hidden tpd-editing&quot; data-timeid=&quot;1524131029000&quot; data-eidtid=&quot;10&quot; style=&quot;&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-messtyle clearfix&quot;&gt;&lt;div class=&quot;tpdm-mes-logo&quot;&gt;&lt;img src=&quot;/public/upload/temp/2018/04-19/d6bece75e2010001d91d0a6fad6340bb.png&quot; alt=&quot;&quot;&gt;&lt;/div&gt;&lt;ul class=&quot;tpdm-mes-title&quot;&gt;&lt;li class=&quot;tpdm-mesname1&quot;&gt;87&lt;/li&gt;&lt;li class=&quot;tpdm-mesname2&quot;&gt;67&lt;/li&gt;&lt;/ul&gt;&lt;div class=&quot;tpdm-mes-cont&quot;&gt;&lt;a class=&quot;ellipsis1 tpdm-mescont1&quot; href=&quot;/index.php?m=Home&amp;amp;c=Goods&amp;amp;a=goodsInfo&amp;amp;id=1&quot;&gt;123456789012345678901234567890&lt;/a&gt;&lt;a class=&quot;ellipsis1 tpdm-mescont2&quot; href=&quot;/mobile/index/index2/6&quot;&gt;123456789012345678901234567890&lt;/a&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpd-edits-hidden&quot; data-timeid=&quot;1524129137000&quot; data-eidtid=&quot;4&quot; style=&quot;margin-bottom: 20px;&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-wstyle tpdm-wstyle-wrap9&quot;&gt;&lt;a href=&quot;/index.php/Mobile/Goods/goodsList/id/15.html&quot; class=&quot;tpdm-wstyle1&quot;&gt;&lt;img src=&quot;/public/upload/temp/2018/04-17/479a7e27f6d5bbd7b1cbe45c833e23c1.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot; class=&quot;tpdm-wstyle2&quot;&gt;&lt;img src=&quot;/public/upload/temp/2018/04-19/aa5f838149071c5779205f90b057f6e2.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot; class=&quot;tpdm-wstyle3&quot;&gt;&lt;img src=&quot;/public/upload/temp/2018/04-19/d626bd86e3e0cd05c176efe3e3bdf3a2.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot; class=&quot;tpdm-wstyle4&quot;&gt;&lt;img src=&quot;/public/upload/temp/2018/04-19/dbccaf5dd1ee8a1ca97d8229ddbae005.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpd-edits-hidden&quot; data-timeid=&quot;1523949139000&quot; data-eidtid=&quot;1&quot; style=&quot;margin-bottom: 20px;&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-carousel&quot; id=&quot;carousel1523949139&quot;&gt;&lt;ul class=&quot;tpd-banner-list&quot;&gt; &lt;li&gt;&lt;a href=&quot;/index.php/Mobile/Goods/goodsList/id/81.html&quot;&gt;&lt;img src=&quot;/public/upload/temp/2018/04-17/b5fb2a0b2271b36dd128f9a4ea3d4590.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;/li&gt;&lt;li&gt;&lt;a href=&quot;/index.php/Mobile/Goods/goodsList/id/247.html&quot;&gt; &lt;img src=&quot;/public/upload/temp/2018/04-17/d6dd3c98e008b244d1354866697c97a8.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;/li&gt;&lt;/ul&gt;&lt;div class=&quot;page-num&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-carousel-js&quot;&gt;&lt;script&gt;swiperSlide(carousel1523949139,4000)&lt;/script&gt;&lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpd-edits-hidden&quot; data-timeid=&quot;1523949273000&quot; data-eidtid=&quot;3&quot; style=&quot;&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-gdstyle&quot;&gt;&lt;ul class=&quot;tpdm-goods-nav tpdm-goods-nav3&quot;&gt;&lt;li&gt;服饰服装&lt;/li&gt;  &lt;li&gt;新品热卖&lt;/li&gt;&lt;li&gt;推荐商品&lt;/li&gt;&lt;/ul&gt; &lt;div class=&quot;tpdm-goods-list tpdm-goods-list1&quot;&gt; &lt;ul class=&quot;tpdm-goods-wrap clearfix&quot;&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/214&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-18/922b3fabc508efe0cdd6580f66d8b5c9.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/214&quot; class=&quot;tpdm-goods-name&quot;&gt;抢购活动待运费&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥99.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/15&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/135&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-13/686356cfc70ffcf6005d4c4f1d0f98e9.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/135&quot; class=&quot;tpdm-goods-name&quot;&gt;月缦 2018新款礼服A字裙短袖少女中国风学生日常短款中式礼服连衣裙&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥218.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/193&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/171&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-16/036cb22e5b560d0b182312d6de328903.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/171&quot; class=&quot;tpdm-goods-name&quot;&gt;睡衣女士纯棉短袖夏季红豆居家春大码全棉甜美薄款家居服短裤套装 红豆居家女士纯棉睡衣 休闲可外穿&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥128.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/14&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/177&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-16/28fac2e7faa5dcc2ef72ccbcf9a8949b.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/177&quot; class=&quot;tpdm-goods-name&quot;&gt;GENANX闪电潮牌男士拼接格子短袖衬衫 设计师潮牌夏季商务休闲免烫立领衬衫男潮&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥198.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/214&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/210&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-17/e5ed1c25936b66d0df15d0daa29ceab9.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/210&quot; class=&quot;tpdm-goods-name&quot;&gt;苹果7钢化膜iphone8plus手机7plus全屏全覆盖8贴膜水凝7p抗蓝光3D&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥13.80&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/76&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/113&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-11/948c9a2f762c263e34e39369e1c643a8.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/113&quot; class=&quot;tpdm-goods-name&quot;&gt;南极人 polo衫男 翻领短袖t恤男装小鹿印花休闲 灰色 XL&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥129.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/24&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/3&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-09/00218db8155e70da05d95537caddf0ff.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/3&quot; class=&quot;tpdm-goods-name&quot;&gt;佐露絲RALOS实拍大码女装连衣裙春装200斤胖妹妹遮肚子减龄胖mm蕾丝拼接裙子&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥118.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/15&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/10&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-17/305cf15d476d02cb2771576c9d81d91d.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/10&quot; class=&quot;tpdm-goods-name&quot;&gt;歌诺瑞丝衬衫女2018春季新品休闲宽松长袖格子打底上衣潮-NV10302 黄色 L&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥159.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/190&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/118&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-13/447a78f19d258268e6f2e61100e8346f.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/118&quot; class=&quot;tpdm-goods-name&quot;&gt;单蜜半身裙女装2018春季新款高腰破洞牛仔中长裙子&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥138.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/183&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/190&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-16/0afb7460ba914c7138e96b94e90c7e83.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/190&quot; class=&quot;tpdm-goods-name&quot;&gt;三枪秋衣秋裤男女情侣纯棉加厚圆领宽松保暖内衣保暖裤男士女士套装&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥99.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/229&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;/ul&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpd-edits-hidden&quot; data-timeid=&quot;1523949298000&quot; data-eidtid=&quot;3&quot; style=&quot;&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-gdstyle&quot;&gt;&lt;ul class=&quot;tpdm-goods-nav tpdm-goods-nav1&quot;&gt;&lt;li&gt;手机数码&lt;/li&gt;  &lt;/ul&gt; &lt;div class=&quot;tpdm-goods-list tpdm-goods-list1&quot;&gt; &lt;ul class=&quot;tpdm-goods-wrap clearfix&quot;&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/220&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-19/42409986d627f6ad8deb459ae874b612.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/220&quot; class=&quot;tpdm-goods-name&quot;&gt;好多多&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥29.90&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/402&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/133&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-13/fd795b31781cc27b63b9f80961e18cca.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/133&quot; class=&quot;tpdm-goods-name&quot;&gt;【好礼在此】CASIO BABY-G少女时代广告款石英女表&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥1096.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/504&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/214&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-18/922b3fabc508efe0cdd6580f66d8b5c9.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/214&quot; class=&quot;tpdm-goods-name&quot;&gt;抢购活动待运费&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥99.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/15&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/193&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-17/08b6fcdbbaa2583939685981f1f9a4d4.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/193&quot; class=&quot;tpdm-goods-name&quot;&gt;实体店新款鞋兑换券&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥79.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/443&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/135&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-13/686356cfc70ffcf6005d4c4f1d0f98e9.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/135&quot; class=&quot;tpdm-goods-name&quot;&gt;月缦 2018新款礼服A字裙短袖少女中国风学生日常短款中式礼服连衣裙&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥218.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/193&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/171&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-16/036cb22e5b560d0b182312d6de328903.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/171&quot; class=&quot;tpdm-goods-name&quot;&gt;睡衣女士纯棉短袖夏季红豆居家春大码全棉甜美薄款家居服短裤套装 红豆居家女士纯棉睡衣 休闲可外穿&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥128.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/14&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/199&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-17/6c98d6cb66963aaa116b6449e0f966c3.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/199&quot; class=&quot;tpdm-goods-name&quot;&gt;送醒酒器法国原瓶进口红酒路易拉菲干红葡萄酒6支整箱装送礼红酒 送红酒杯 送醒酒器开瓶器酒塞&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥298.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/427&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/210&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-17/e5ed1c25936b66d0df15d0daa29ceab9.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/210&quot; class=&quot;tpdm-goods-name&quot;&gt;苹果7钢化膜iphone8plus手机7plus全屏全覆盖8贴膜水凝7p抗蓝光3D&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥13.80&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/76&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/154&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-16/2ae49c7b1e6ad0645315b6bcf40f6bf7.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/154&quot; class=&quot;tpdm-goods-name&quot;&gt;小熊饼干990&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥35.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/405&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/177&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-16/28fac2e7faa5dcc2ef72ccbcf9a8949b.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/177&quot; class=&quot;tpdm-goods-name&quot;&gt;GENANX闪电潮牌男士拼接格子短袖衬衫 设计师潮牌夏季商务休闲免烫立领衬衫男潮&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥198.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/214&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;/ul&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpd-edits-hidden&quot; data-timeid=&quot;1523954780000&quot; data-eidtid=&quot;5&quot; style=&quot;margin-bottom: 20px;&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-txtnav-list&quot; style=&quot;color: rgb(51, 51, 51);&quot;&gt;&lt;a href=&quot;http://b2t.tp-shop.cn/Home/Article/detail/article_id/2.html&quot;&gt;点此查看商城帮助文件&lt;/a&gt;&lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpd-edits-hidden&quot; data-timeid=&quot;1523949361000&quot; data-eidtid=&quot;3&quot; style=&quot;&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-gdstyle&quot;&gt;&lt;ul class=&quot;tpdm-goods-nav tpdm-goods-nav1&quot;&gt;&lt;li&gt;零食生鲜&lt;/li&gt;  &lt;/ul&gt; &lt;div class=&quot;tpdm-goods-list tpdm-goods-list2&quot;&gt; &lt;ul class=&quot;tpdm-goods-wrap clearfix&quot;&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/220&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-19/42409986d627f6ad8deb459ae874b612.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/220&quot; class=&quot;tpdm-goods-name&quot;&gt;好多多&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥29.90&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/402&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/133&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-13/fd795b31781cc27b63b9f80961e18cca.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/133&quot; class=&quot;tpdm-goods-name&quot;&gt;【好礼在此】CASIO BABY-G少女时代广告款石英女表&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥1096.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/504&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/214&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-18/922b3fabc508efe0cdd6580f66d8b5c9.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/214&quot; class=&quot;tpdm-goods-name&quot;&gt;抢购活动待运费&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥99.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/15&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/193&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-17/08b6fcdbbaa2583939685981f1f9a4d4.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/193&quot; class=&quot;tpdm-goods-name&quot;&gt;实体店新款鞋兑换券&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥79.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/443&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/135&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-13/686356cfc70ffcf6005d4c4f1d0f98e9.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/135&quot; class=&quot;tpdm-goods-name&quot;&gt;月缦 2018新款礼服A字裙短袖少女中国风学生日常短款中式礼服连衣裙&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥218.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/193&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/171&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-16/036cb22e5b560d0b182312d6de328903.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/171&quot; class=&quot;tpdm-goods-name&quot;&gt;睡衣女士纯棉短袖夏季红豆居家春大码全棉甜美薄款家居服短裤套装 红豆居家女士纯棉睡衣 休闲可外穿&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥128.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/14&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/199&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-17/6c98d6cb66963aaa116b6449e0f966c3.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/199&quot; class=&quot;tpdm-goods-name&quot;&gt;送醒酒器法国原瓶进口红酒路易拉菲干红葡萄酒6支整箱装送礼红酒 送红酒杯 送醒酒器开瓶器酒塞&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥298.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/427&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/210&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-17/e5ed1c25936b66d0df15d0daa29ceab9.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/210&quot; class=&quot;tpdm-goods-name&quot;&gt;苹果7钢化膜iphone8plus手机7plus全屏全覆盖8贴膜水凝7p抗蓝光3D&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥13.80&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/76&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/154&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-16/2ae49c7b1e6ad0645315b6bcf40f6bf7.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/154&quot; class=&quot;tpdm-goods-name&quot;&gt;小熊饼干990&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥35.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/405&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;/Mobile/Goods/goodsInfo/id/177&quot;&gt;&lt;img src=&quot;/public/upload/goods/2018/04-16/28fac2e7faa5dcc2ef72ccbcf9a8949b.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/Goods/goodsInfo/id/177&quot; class=&quot;tpdm-goods-name&quot;&gt;GENANX闪电潮牌男士拼接格子短袖衬衫 设计师潮牌夏季商务休闲免烫立领衬衫男潮&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥198.00&lt;/div&gt;&lt;a class=&quot;tpdm-goods-like&quot; href=&quot;/Mobile/Goods/goodsList/id/214&quot;&gt;看相似&lt;/a&gt;&lt;/div&gt;&lt;/li&gt;&lt;/ul&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-footer-wrap&quot; data-name=&quot;底部导航-隐藏&quot;&gt;&lt;div class=&quot;tpd-footer tpd-footer1&quot;&gt;&lt;a class=&quot;footmenu-ac&quot; href=&quot;/mobile/Index/index&quot;&gt;&lt;i class=&quot;ico-foot1&quot;&gt;&lt;/i&gt;&lt;span&gt;首页&lt;/span&gt;&lt;/a&gt;&lt;a href=&quot;/mobile/Goods/categoryList.html&quot;&gt;&lt;i class=&quot;ico-foot2&quot;&gt;&lt;/i&gt;&lt;span&gt;分类&lt;/span&gt;&lt;/a&gt;&lt;a class=&quot;tpd-footer-find&quot; href=&quot;/mobile/Goods/ajaxSearch&quot;&gt; &lt;i class=&quot;ico-foot3&quot;&gt;&lt;/i&gt;&lt;span&gt;发现&lt;/span&gt;&lt;/a&gt;&lt;a href=&quot;/mobile/Cart/index&quot;&gt;&lt;i class=&quot;ico-foot4&quot;&gt;&lt;/i&gt;&lt;span&gt;购物车&lt;/span&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/User/login&quot;&gt; &lt;i class=&quot;ico-foot5&quot;&gt;&lt;/i&gt;&lt;span&gt;我的&lt;/span&gt;&lt;/a&gt;&lt;/div&gt;&lt;/div&gt;                                                                                                                                                                                                                                                                                                                                                                                                               ',1,1524642810,'{&quot;is_notice&quot;:1,&quot;is_header&quot;:0,&quot;is_footer&quot;:1,&quot;is_search&quot;:1,&quot;1523943371000&quot;:{&quot;timeid&quot;:1523943371000,&quot;block_type&quot;:&quot;8&quot;,&quot;search_style&quot;:0},&quot;search_id&quot;:1523943371000,&quot;1523949139000&quot;:{&quot;timeid&quot;:1523949139000,&quot;spacing&quot;:20,&quot;block_type&quot;:&quot;1&quot;,&quot;roll_time&quot;:&quot;4s&quot;,&quot;nav&quot;:[{&quot;pic&quot;:&quot;/public/upload/temp/2018/04-17/b5fb2a0b2271b36dd128f9a4ea3d4590.jpg&quot;,&quot;url&quot;:&quot;/index.php/Mobile/Goods/goodsList/id/81.html&quot;},{&quot;pic&quot;:&quot;/public/upload/temp/2018/04-17/d6dd3c98e008b244d1354866697c97a8.jpg&quot;,&quot;url&quot;:&quot;/index.php/Mobile/Goods/goodsList/id/247.html&quot;}]},&quot;1523949273000&quot;:{&quot;timeid&quot;:1523949273000,&quot;spacing&quot;:10,&quot;block_type&quot;:&quot;3&quot;,&quot;show_type&quot;:0,&quot;num&quot;:10,&quot;name_show&quot;:1,&quot;order&quot;:0,&quot;nav&quot;:[{&quot;tab_title&quot;:&quot;服饰服装&quot;,&quot;str&quot;:&quot;&quot;,&quot;sql_where&quot;:{&quot;min_price&quot;:&quot;&quot;,&quot;max_price&quot;:&quot;&quot;,&quot;num&quot;:10,&quot;ids&quot;:&quot;13,23,26,27,28,&quot;,&quot;order&quot;:0}},{&quot;tab_title&quot;:&quot;新品热卖&quot;,&quot;str&quot;:&quot;&quot;,&quot;sql_where&quot;:{&quot;min_price&quot;:&quot;&quot;,&quot;max_price&quot;:&quot;&quot;,&quot;num&quot;:10,&quot;ids&quot;:&quot;13,23,26,27,28,45,46,47,48,49,50,51,323,&quot;,&quot;order&quot;:0}},{&quot;tab_title&quot;:&quot;推荐商品&quot;,&quot;str&quot;:&quot;&quot;,&quot;sql_where&quot;:{&quot;min_price&quot;:&quot;&quot;,&quot;max_price&quot;:&quot;&quot;,&quot;num&quot;:10,&quot;ids&quot;:&quot;13,23,26,27,28,32,33,34,35,36,168,177,&quot;,&quot;order&quot;:0}}]},&quot;1523949298000&quot;:{&quot;timeid&quot;:1523949298000,&quot;spacing&quot;:10,&quot;block_type&quot;:&quot;3&quot;,&quot;show_type&quot;:0,&quot;num&quot;:10,&quot;name_show&quot;:1,&quot;order&quot;:0,&quot;nav&quot;:[{&quot;tab_title&quot;:&quot;手机数码&quot;,&quot;str&quot;:&quot;&quot;,&quot;sql_where&quot;:{&quot;min_price&quot;:&quot;&quot;,&quot;max_price&quot;:&quot;&quot;,&quot;num&quot;:4,&quot;ids&quot;:&quot;32,33,34,35,36,168,177,&quot;,&quot;order&quot;:0}}]},&quot;1523949361000&quot;:{&quot;timeid&quot;:1523949361000,&quot;spacing&quot;:10,&quot;block_type&quot;:&quot;3&quot;,&quot;show_type&quot;:0,&quot;num&quot;:10,&quot;name_show&quot;:1,&quot;order&quot;:0,&quot;nav&quot;:[{&quot;tab_title&quot;:&quot;零食生鲜&quot;,&quot;str&quot;:&quot;&quot;,&quot;sql_where&quot;:{&quot;min_price&quot;:&quot;&quot;,&quot;max_price&quot;:&quot;&quot;,&quot;num&quot;:4,&quot;ids&quot;:&quot;32,33,34,35,36,168,177,116,117,118,119,120,433,&quot;,&quot;order&quot;:0}}]},&quot;1523949528000&quot;:{&quot;timeid&quot;:1523949528000,&quot;spacing&quot;:10,&quot;block_type&quot;:&quot;11&quot;,&quot;footer_type&quot;:1},&quot;footer_type&quot;:1,&quot;footer_id&quot;:1523949528000,&quot;1523949792000&quot;:{&quot;timeid&quot;:1523949792000,&quot;spacing&quot;:30,&quot;block_type&quot;:&quot;2&quot;,&quot;shape_type&quot;:1,&quot;nav&quot;:[{&quot;pic&quot;:&quot;/public/upload/temp/2018/04-17/d8328e62f91e9a42cb72e26389f66849.png&quot;,&quot;title_name&quot;:&quot;拼团&quot;,&quot;url&quot;:&quot;/mobile/index/index2/3&quot;},{&quot;pic&quot;:&quot;/public/upload/temp/2018/04-17/c5e04a4d0801af786e308a930d5b7753.png&quot;,&quot;title_name&quot;:&quot;秒杀&quot;,&quot;url&quot;:&quot;/mobile/index/index2/2&quot;},{&quot;pic&quot;:&quot;/public/upload/temp/2018/04-17/98a701072f9960ed3bf450681bb8d041.png&quot;,&quot;title_name&quot;:&quot;购物车&quot;,&quot;url&quot;:&quot;/mobile/Cart/index.html&quot;}]},&quot;1523954780000&quot;:{&quot;timeid&quot;:1523954780000,&quot;spacing&quot;:20,&quot;block_type&quot;:&quot;5&quot;,&quot;color&quot;:&quot;#333&quot;,&quot;txt_title&quot;:&quot;点此查看商城帮助文件&quot;,&quot;url&quot;:&quot;http://b2t.tp-shop.cn/Home/Article/detail/article_id/2.html&quot;},&quot;1524129137000&quot;:{&quot;timeid&quot;:1524129137000,&quot;spacing&quot;:20,&quot;block_type&quot;:&quot;4&quot;,&quot;window_style&quot;:8,&quot;nav&quot;:[{&quot;pic&quot;:&quot;/public/upload/temp/2018/04-17/479a7e27f6d5bbd7b1cbe45c833e23c1.png&quot;,&quot;url&quot;:&quot;/index.php/Mobile/Goods/goodsList/id/15.html&quot;},{&quot;pic&quot;:&quot;/public/upload/temp/2018/04-19/aa5f838149071c5779205f90b057f6e2.png&quot;,&quot;url&quot;:&quot;/index.php/Mobile/Goods/integralMall&quot;},{&quot;pic&quot;:&quot;/public/upload/temp/2018/04-19/d626bd86e3e0cd05c176efe3e3bdf3a2.png&quot;,&quot;url&quot;:&quot;/index.php/Mobile/Team/index&quot;},{&quot;pic&quot;:&quot;/public/upload/temp/2018/04-19/dbccaf5dd1ee8a1ca97d8229ddbae005.png&quot;,&quot;url&quot;:&quot;&quot;}]},&quot;1524131029000&quot;:{&quot;timeid&quot;:1524131029000,&quot;spacing&quot;:10,&quot;block_type&quot;:&quot;10&quot;,&quot;nav&quot;:[{&quot;notice_title&quot;:&quot;87&quot;,&quot;notice_info&quot;:&quot;123456789012345678901234567890&quot;,&quot;url&quot;:&quot;/index.php?m=Home&amp;amp;c=Goods&amp;amp;a=goodsInfo&amp;amp;id=1&quot;},{&quot;notice_title&quot;:&quot;67&quot;,&quot;notice_info&quot;:&quot;123456789012345678901234567890&quot;,&quot;url&quot;:&quot;/mobile/index/index2/6&quot;}],&quot;notice_pic&quot;:&quot;/public/upload/temp/2018/04-19/d6bece75e2010001d91d0a6fad6340bb.png&quot;},&quot;1524642687000&quot;:{&quot;timeid&quot;:1524642687000,&quot;spacing&quot;:10,&quot;block_type&quot;:&quot;1&quot;,&quot;roll_time&quot;:&quot;3s&quot;,&quot;nav&quot;:[{&quot;pic&quot;:&quot;/public/upload/temp/2018/04-25/27d6e8fb35b3de8dfafe8d650a4e8f5a.jpg&quot;,&quot;url&quot;:&quot;/index.php/Mobile/Goods/goodsList/id/286.html&quot;},{&quot;pic&quot;:&quot;/public/upload/temp/2018/04-25/228f58cb4aff15f144058718b0e70a96.jpg&quot;,&quot;url&quot;:&quot;/index.php?m=Home&amp;c=Goods&amp;a=goodsInfo&amp;id=1&quot;}]}}',0,NULL,0),(2,0,'秒杀页面','                                              &lt;div class=&quot;tpdm-head-wrap&quot; data-name=&quot;搜索框&quot;&gt;                             &lt;div class=&quot;tpdm-head-js&quot;&gt;                              &lt;/div&gt;                             &lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;                             &lt;script&gt;                                 $(\'.tpdm-head-wrap\').click(function () {                                     $(this).toggleClass(\'tpdm-head-edit\');                                 });                                 $(\'.tpdm-head-wrap&gt;.tpd-editing-close\').click(function () {                                     $(this).parents(\'.tpdm-head-wrap\').find(\'.tpdm-head-js\').removeClass(\'tpdm-head-scale\').html(\'\');                                     block.is_search=0;                                     delete block.search_style;                                     delete block[block.search_id];                                     delete block.search_id;                                 })                              &lt;/script&gt;                         &lt;/div&gt;                         &lt;div class=&quot;tpd-edits-hidden tpd-editing&quot; data-timeid=&quot;1523949663000&quot; data-eidtid=&quot;1&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-carousel&quot; id=&quot;carousel1523949663&quot;&gt;&lt;ul class=&quot;tpd-banner-list&quot;&gt; &lt;li&gt;&lt;a href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;/public/upload/temp/2018/04-17/008b2cf9e2322c12e4af29abb54411ef.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;/li&gt;&lt;li&gt;&lt;a href=&quot;javascript:;&quot;&gt; &lt;img src=&quot;/public/upload/temp/2018/04-17/227e5ab3f66c55bdcbe66e020ba6770e.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;/li&gt;&lt;/ul&gt;&lt;div class=&quot;page-num&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-carousel-js&quot;&gt;&lt;script&gt;swiperSlide(carousel1523949663,3000)&lt;/script&gt;&lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpd-edits-hidden&quot; data-timeid=&quot;1523949645000&quot; data-eidtid=&quot;6&quot; style=&quot;margin-bottom: 20px;&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-acstyle&quot;&gt; &lt;div class=&quot;tpdm-seckill-title&quot;&gt;&lt;label&gt;秒杀专场&lt;/label&gt;&lt;span id=&quot;flash_time&quot;&gt;12点专场&lt;/span&gt; &lt;ul class=&quot;tpdm-seckill-time&quot; id=&quot;hms&quot;&gt; &lt;li id=&quot;time_h&quot;&gt;12&lt;/li&gt; &lt;li id=&quot;time_m&quot;&gt;05&lt;/li&gt; &lt;li id=&quot;time_s&quot;&gt;18&lt;/li&gt; &lt;/ul&gt; &lt;a href=&quot;/Mobile/Activity/flash_sale_list.html&quot;&gt;更多 &amp;gt;&lt;/a&gt; &lt;/div&gt; &lt;div class=&quot;tpdm-seckill-list&quot; id=&quot;flash_list&quot;&gt; &lt;a href=&quot;javascript:;&quot;&gt; &lt;img src=&quot;&quot; alt=&quot;&quot;&gt;&lt;span&gt;￥158&lt;/span&gt;&lt;i&gt;￥258&lt;/i&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;&quot; alt=&quot;&quot;&gt;&lt;span&gt;￥158&lt;/span&gt; &lt;i&gt;￥258&lt;/i&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;&quot; alt=&quot;&quot;&gt;&lt;span&gt;￥158&lt;/span&gt;&lt;i&gt;￥258&lt;/i&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;&quot; alt=&quot;&quot;&gt;&lt;span&gt;￥158&lt;/span&gt;&lt;i&gt;￥258&lt;/i&gt;&lt;/a&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-footer-wrap&quot; data-name=&quot;底部导航-隐藏&quot;&gt;                          &lt;/div&gt;                                          ',1,1523949732,'{&quot;is_notice&quot;:0,&quot;is_header&quot;:0,&quot;is_footer&quot;:0,&quot;is_search&quot;:0,&quot;1523949645000&quot;:{&quot;timeid&quot;:1523949645000,&quot;spacing&quot;:20,&quot;block_type&quot;:&quot;6&quot;,&quot;activity_type&quot;:1,&quot;tab_type&quot;:1,&quot;tab_title&quot;:&quot;&quot;,&quot;show_type&quot;:0},&quot;1523949663000&quot;:{&quot;timeid&quot;:1523949663000,&quot;spacing&quot;:10,&quot;block_type&quot;:&quot;1&quot;,&quot;roll_time&quot;:&quot;3s&quot;,&quot;nav&quot;:[{&quot;pic&quot;:&quot;/public/upload/temp/2018/04-17/008b2cf9e2322c12e4af29abb54411ef.png&quot;,&quot;url&quot;:&quot;&quot;},{&quot;pic&quot;:&quot;/public/upload/temp/2018/04-17/227e5ab3f66c55bdcbe66e020ba6770e.jpg&quot;,&quot;url&quot;:&quot;&quot;}]}}',0,NULL,0),(3,0,'拼团页面','                                              &lt;div class=&quot;tpdm-head-wrap&quot; data-name=&quot;搜索框&quot;&gt;                             &lt;div class=&quot;tpdm-head-js&quot;&gt;                              &lt;/div&gt;                             &lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;                             &lt;script&gt;                                 $(\'.tpdm-head-wrap\').click(function () {                                     $(this).toggleClass(\'tpdm-head-edit\');                                 });                                 $(\'.tpdm-head-wrap&gt;.tpd-editing-close\').click(function () {                                     $(this).parents(\'.tpdm-head-wrap\').find(\'.tpdm-head-js\').removeClass(\'tpdm-head-scale\').html(\'\');                                     block.is_search=0;                                     delete block.search_style;                                     delete block[block.search_id];                                     delete block.search_id;                                 })                              &lt;/script&gt;                         &lt;/div&gt;                         &lt;div class=&quot;tpd-edits-hidden tpd-editing&quot; data-timeid=&quot;1523949758000&quot; data-eidtid=&quot;6&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-acstyle&quot;&gt;&lt;div class=&quot;tpdm-activity-title&quot;&gt;拼团活动&lt;/div&gt;&lt;div class=&quot;tpdm-goods-list tpdm-goods-list2&quot;&gt;&lt;ul class=&quot;tpdm-goods-wrap clearfix&quot; id=&quot;nxkhh&quot;&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot; class=&quot;tpdm-goods-name&quot;&gt;联想台式机主机 GTX1080Ti游戏主机DIY组装机 i7 6700&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥12222228.00&lt;/div&gt;&lt;div class=&quot;tpdm-sold-num&quot;&gt;已拼1000000&lt;/div&gt;&lt;/div&gt; &lt;div class=&quot;tpdm-goods-mes&quot;&gt; &lt;a href=&quot;javascript:;&quot;&gt;去拼单 &amp;gt;&lt;/a&gt;&lt;span&gt;100团&lt;/span&gt;&lt;div class=&quot;tpdm-acbuyer&quot;&gt;&lt;img src=&quot;/public/static/images/pic-wstyle-list1.jpg&quot; alt=&quot;&quot;&gt; ...&lt;/div&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt; &lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot; class=&quot;tpdm-goods-name&quot;&gt;联想台式机主机 GTX1080Ti游戏主机DIY组装机 i7 6700&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥12222228.00&lt;/div&gt; &lt;div class=&quot;tpdm-sold-num&quot;&gt;已拼1000000&lt;/div&gt; &lt;/div&gt;&lt;div class=&quot;tpdm-goods-mes&quot;&gt;&lt;a href=&quot;javascript:;&quot;&gt;去拼单 &amp;gt;&lt;/a&gt;&lt;span&gt;100团&lt;/span&gt;&lt;div class=&quot;tpdm-acbuyer&quot;&gt;&lt;img src=&quot;/public/static/images/pic-wstyle-list1.jpg&quot; alt=&quot;&quot;&gt; ...&lt;/div&gt; &lt;/div&gt; &lt;/li&gt; &lt;li&gt; &lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;&quot; alt=&quot;&quot;&gt;&lt;/a&gt; &lt;a href=&quot;javascript:;&quot; class=&quot;tpdm-goods-name&quot;&gt;联想台式机主机 GTX1080Ti游戏主机DIY组装机 i7 6700&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥12222228.00&lt;/div&gt; &lt;div class=&quot;tpdm-sold-num&quot;&gt;已拼1000000&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-goods-mes&quot;&gt;&lt;a href=&quot;javascript:;&quot;&gt;去拼单 &amp;gt;&lt;/a&gt;&lt;span&gt;100团&lt;/span&gt;&lt;div class=&quot;tpdm-acbuyer&quot;&gt;&lt;img src=&quot;/public/static/images/pic-wstyle-list1.jpg&quot; alt=&quot;&quot;&gt;... &lt;/div&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot; class=&quot;tpdm-goods-name&quot;&gt;联想台式机主机 GTX1080Ti游戏主机DIY组装机 i7 6700&lt;/a&gt; &lt;div class=&quot;tpdm-goods-des&quot;&gt; &lt;div class=&quot;tpdm-goods-price&quot;&gt;￥12222228.00&lt;/div&gt; &lt;div class=&quot;tpdm-sold-num&quot;&gt;已拼1000000&lt;/div&gt; &lt;/div&gt; &lt;div class=&quot;tpdm-goods-mes&quot;&gt; &lt;a href=&quot;javascript:;&quot;&gt;去拼单 &amp;gt;&lt;/a&gt; &lt;span&gt;100团&lt;/span&gt; &lt;div class=&quot;tpdm-acbuyer&quot;&gt; &lt;img src=&quot;/public/static/images/pic-wstyle-list1.jpg&quot; alt=&quot;&quot;&gt;... &lt;/div&gt; &lt;/div&gt; &lt;/li&gt; &lt;/ul&gt; &lt;/div&gt; &lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-footer-wrap&quot; data-name=&quot;底部导航-隐藏&quot;&gt;                          &lt;/div&gt;                                          ',1,1523949776,'{&quot;is_notice&quot;:0,&quot;is_header&quot;:0,&quot;is_footer&quot;:0,&quot;is_search&quot;:0,&quot;1523949758000&quot;:{&quot;timeid&quot;:1523949758000,&quot;spacing&quot;:10,&quot;block_type&quot;:&quot;6&quot;,&quot;activity_type&quot;:0,&quot;tab_type&quot;:1,&quot;tab_title&quot;:&quot;拼团活动&quot;,&quot;show_type&quot;:1}}',0,NULL,0),(4,0,'不仅仅是喜欢','                                                                                                                                          &lt;div class=&quot;tpdm-head-wrap&quot; data-name=&quot;搜索框&quot;&gt;                             &lt;div class=&quot;tpdm-head-js&quot;&gt;                              &lt;/div&gt;                             &lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;                             &lt;script&gt;                                 $(\'.tpdm-head-wrap\').click(function () {                                     $(this).toggleClass(\'tpdm-head-edit\');                                 });                                 $(\'.tpdm-head-wrap&gt;.tpd-editing-close\').click(function () {                                     $(this).parents(\'.tpdm-head-wrap\').find(\'.tpdm-head-js\').removeClass(\'tpdm-head-scale\').html(\'\');                                     block.is_search=0;                                     delete block.search_style;                                     delete block[block.search_id];                                     delete block.search_id;                                 })                              &lt;/script&gt;                         &lt;/div&gt;                         &lt;div class=&quot;tpd-edits-hidden&quot; data-timeid=&quot;1524131428000&quot; data-eidtid=&quot;4&quot; style=&quot;&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-wstyle tpdm-wstyle-wrap1&quot;&gt;&lt;a href=&quot;javascript:;&quot; class=&quot;tpdm-wstyle1&quot;&gt;&lt;img src=&quot;/public/upload/temp/2018/04-19/b61695f1b4602d510291da3a3a5f1dd8.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt; &lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpd-edits-hidden&quot; data-timeid=&quot;1524131643000&quot; data-eidtid=&quot;6&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-acstyle&quot;&gt; &lt;div class=&quot;tpdm-seckill-title&quot;&gt;&lt;label&gt;秒杀专场&lt;/label&gt;&lt;span id=&quot;flash_time&quot;&gt;12点专场&lt;/span&gt; &lt;ul class=&quot;tpdm-seckill-time&quot; id=&quot;hms&quot;&gt; &lt;li id=&quot;time_h&quot;&gt;12&lt;/li&gt; &lt;li id=&quot;time_m&quot;&gt;05&lt;/li&gt; &lt;li id=&quot;time_s&quot;&gt;18&lt;/li&gt; &lt;/ul&gt; &lt;a href=&quot;/Mobile/Activity/flash_sale_list.html&quot;&gt;更多 &amp;gt;&lt;/a&gt; &lt;/div&gt; &lt;div class=&quot;tpdm-seckill-list&quot; id=&quot;flash_list&quot;&gt; &lt;a href=&quot;javascript:;&quot;&gt; &lt;img src=&quot;&quot; alt=&quot;&quot;&gt;&lt;span&gt;￥158&lt;/span&gt;&lt;i&gt;￥258&lt;/i&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;&quot; alt=&quot;&quot;&gt;&lt;span&gt;￥158&lt;/span&gt; &lt;i&gt;￥258&lt;/i&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;&quot; alt=&quot;&quot;&gt;&lt;span&gt;￥158&lt;/span&gt;&lt;i&gt;￥258&lt;/i&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;&quot; alt=&quot;&quot;&gt;&lt;span&gt;￥158&lt;/span&gt;&lt;i&gt;￥258&lt;/i&gt;&lt;/a&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpd-edits-hidden&quot; data-timeid=&quot;1524131508000&quot; data-eidtid=&quot;6&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-acstyle&quot;&gt;&lt;div class=&quot;tpdm-activity-title&quot;&gt;拼团标题（没有标题则此栏不显示）&lt;/div&gt;&lt;div class=&quot;tpdm-goods-list tpdm-goods-list1&quot;&gt;&lt;ul class=&quot;tpdm-goods-wrap clearfix&quot; id=&quot;nxkhh&quot;&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;/public/upload/activity/2018/04-19/959381a8708655bee320efc050226c61.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot; class=&quot;tpdm-goods-name&quot;&gt;零食大礼包选择种类:选择5斤装 种类:袋装 版本:版本3 场景:送长辈&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥35.00&lt;/div&gt;&lt;div class=&quot;tpdm-sold-num&quot;&gt;单买:￥56.00&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-goods-mes&quot;&gt;&lt;a href=&quot;/index.php?m=Mobile&amp;amp;c=Team&amp;amp;a=info&amp;amp;team_id=10&amp;amp;goods_id=219&quot;&gt;去拼单 &amp;gt;&lt;/a&gt;&lt;span&gt;5人团&lt;/span&gt;&lt;div class=&quot;tpdm-acbuyer&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;/public/upload/activity/2018/04-19/a7f615864311f03f03c1d29c2e8eaa00.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot; class=&quot;tpdm-goods-name&quot;&gt;好多多选择种类:选择10斤装 种类:礼品盒装 场景:送孩子&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥19.90&lt;/div&gt;&lt;div class=&quot;tpdm-sold-num&quot;&gt;单买:￥29.90&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-goods-mes&quot;&gt;&lt;a href=&quot;/index.php?m=Mobile&amp;amp;c=Team&amp;amp;a=info&amp;amp;team_id=8&amp;amp;goods_id=220&quot;&gt;去拼单 &amp;gt;&lt;/a&gt;&lt;span&gt;2人团&lt;/span&gt;&lt;div class=&quot;tpdm-acbuyer&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;/public/upload/activity/2018/04-19/fddb3a817539b77817658309eeed0f7b.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot; class=&quot;tpdm-goods-name&quot;&gt;GENANX闪电潮牌男士拼接格子短袖衬衫 设计师潮牌夏季商务休闲免烫立领衬衫男潮&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥108.00&lt;/div&gt;&lt;div class=&quot;tpdm-sold-num&quot;&gt;单买:￥198.00&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-goods-mes&quot;&gt;&lt;a href=&quot;/index.php?m=Mobile&amp;amp;c=Team&amp;amp;a=info&amp;amp;team_id=6&amp;amp;goods_id=177&quot;&gt;去拼单 &amp;gt;&lt;/a&gt;&lt;span&gt;2人团&lt;/span&gt;&lt;div class=&quot;tpdm-acbuyer&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;/public/upload/activity/2018/04-19/9913f034eb46a4729a3985983ea5dc07.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot; class=&quot;tpdm-goods-name&quot;&gt;【好礼在此】CASIO BABY-G少女时代广告款石英女表&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥99.00&lt;/div&gt;&lt;div class=&quot;tpdm-sold-num&quot;&gt;单买:￥1096.00&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-goods-mes&quot;&gt;&lt;a href=&quot;/index.php?m=Mobile&amp;amp;c=Team&amp;amp;a=info&amp;amp;team_id=4&amp;amp;goods_id=133&quot;&gt;去拼单 &amp;gt;&lt;/a&gt;&lt;span&gt;2人团&lt;/span&gt;&lt;div class=&quot;tpdm-acbuyer&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;/public/upload/activity/2018/04-19/55554b766e2bb952825eb69b90013157.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot; class=&quot;tpdm-goods-name&quot;&gt;抢购活动待运费选择颜色:绿色 码数:XS&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥59.00&lt;/div&gt;&lt;div class=&quot;tpdm-sold-num&quot;&gt;单买:￥87.00&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-goods-mes&quot;&gt;&lt;a href=&quot;/index.php?m=Mobile&amp;amp;c=Team&amp;amp;a=info&amp;amp;team_id=3&amp;amp;goods_id=214&quot;&gt;去拼单 &amp;gt;&lt;/a&gt;&lt;span&gt;3人团&lt;/span&gt;&lt;div class=&quot;tpdm-acbuyer&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;/li&gt;&lt;/ul&gt; &lt;/div&gt; &lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpd-edits-hidden&quot; data-timeid=&quot;1523951815000&quot; data-eidtid=&quot;5&quot; style=&quot;margin-bottom: 10px;&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-txtnav-list&quot; style=&quot;color: rgb(255, 165, 9);&quot;&gt;&lt;a href=&quot;/index.php/Mobile/Goods/integralMall&quot;&gt;查看帮助文章&lt;/a&gt;&lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-footer-wrap&quot; data-name=&quot;底部导航-隐藏&quot;&gt;                          &lt;/div&gt;                                                                                    ',1,1524131645,'{&quot;is_notice&quot;:0,&quot;is_header&quot;:0,&quot;is_footer&quot;:0,&quot;is_search&quot;:0,&quot;1523951815000&quot;:{&quot;timeid&quot;:1523951815000,&quot;spacing&quot;:10,&quot;block_type&quot;:&quot;5&quot;,&quot;color&quot;:&quot;#ffa509&quot;,&quot;txt_title&quot;:&quot;查看帮助文章&quot;,&quot;url&quot;:&quot;/index.php/Mobile/Goods/integralMall&quot;},&quot;1524131428000&quot;:{&quot;timeid&quot;:1524131428000,&quot;spacing&quot;:10,&quot;block_type&quot;:&quot;4&quot;,&quot;window_style&quot;:0,&quot;nav&quot;:[{&quot;pic&quot;:&quot;/public/upload/temp/2018/04-19/b61695f1b4602d510291da3a3a5f1dd8.png&quot;,&quot;url&quot;:&quot;&quot;},{&quot;pic&quot;:&quot;&quot;,&quot;url&quot;:&quot;&quot;},{&quot;pic&quot;:&quot;&quot;,&quot;url&quot;:&quot;&quot;},{&quot;pic&quot;:&quot;&quot;,&quot;url&quot;:&quot;&quot;}]},&quot;1524131508000&quot;:{&quot;timeid&quot;:1524131508000,&quot;spacing&quot;:10,&quot;block_type&quot;:&quot;6&quot;,&quot;activity_type&quot;:0,&quot;tab_type&quot;:1,&quot;tab_title&quot;:&quot;&quot;,&quot;show_type&quot;:0},&quot;1524131643000&quot;:{&quot;timeid&quot;:1524131643000,&quot;spacing&quot;:10,&quot;block_type&quot;:&quot;6&quot;,&quot;activity_type&quot;:1,&quot;tab_type&quot;:1,&quot;tab_title&quot;:&quot;&quot;,&quot;show_type&quot;:0}}',0,NULL,0),(6,0,'优惠活动','                                              &lt;div class=&quot;tpdm-head-wrap&quot; data-name=&quot;搜索框&quot;&gt;                             &lt;div class=&quot;tpdm-head-js&quot;&gt;                              &lt;/div&gt;                             &lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;                             &lt;script&gt;                                 $(\'.tpdm-head-wrap\').click(function () {                                     $(this).toggleClass(\'tpdm-head-edit\');                                 });                                 $(\'.tpdm-head-wrap&gt;.tpd-editing-close\').click(function () {                                     $(this).parents(\'.tpdm-head-wrap\').find(\'.tpdm-head-js\').removeClass(\'tpdm-head-scale\').html(\'\');                                     block.is_search=0;                                     delete block.search_style;                                     delete block[block.search_id];                                     delete block.search_id;                                 })                              &lt;/script&gt;                         &lt;/div&gt;                         &lt;div class=&quot;tpd-edits-hidden tpd-editing&quot; data-timeid=&quot;1524193758000&quot; data-eidtid=&quot;0&quot; style=&quot;margin-bottom: 10px;&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;a href=&quot;/index.php/Mobile/Goods/goodsList/id/76.html&quot; class=&quot;tpdm-postyle tpdm-postyle2&quot;&gt; &lt;img src=&quot;/public/upload/temp/2018/04-20/baab8b7d479ea1a036c137537b07b925.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-footer-wrap&quot; data-name=&quot;底部导航-隐藏&quot;&gt;                          &lt;/div&gt;                                          ',1,1524193849,'{&quot;is_notice&quot;:0,&quot;is_header&quot;:0,&quot;is_footer&quot;:0,&quot;is_search&quot;:0,&quot;1524193758000&quot;:{&quot;timeid&quot;:1524193758000,&quot;spacing&quot;:10,&quot;block_type&quot;:&quot;0&quot;,&quot;height_style&quot;:1,&quot;url&quot;:&quot;/index.php/Mobile/Goods/goodsList/id/76.html&quot;,&quot;url_type&quot;:2,&quot;pic&quot;:&quot;/public/upload/temp/2018/04-20/baab8b7d479ea1a036c137537b07b925.jpg&quot;}}',0,NULL,0),(8,0,'曾经','                                              &lt;div class=&quot;tpdm-head-wrap&quot; data-name=&quot;搜索框&quot;&gt;                             &lt;div class=&quot;tpdm-head-js tpdm-head-scale&quot;&gt;&lt;div class=&quot;tpd-search-warp clearfix&quot;&gt;&lt;a class=&quot;tpd-logo&quot; href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;/public/static/images/logo.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;form class=&quot;tpd-search-form&quot; action=&quot;&quot;&gt;&lt;i class=&quot;ico-head-search&quot;&gt;&lt;/i&gt;&lt;a href=&quot;/mobile/Goods/ajaxSearch.html&quot;&gt;&lt;input type=&quot;text&quot; placeholder=&quot;请输入您所搜索的商品&quot;&gt;&lt;/a&gt;&lt;/form&gt;&lt;a class=&quot;tpd-personal-warp&quot; href=&quot;/Mobile/User/login.html&quot;&gt; &lt;span&gt;登录&lt;/span&gt; &lt;i class=&quot;ico-head-personal&quot;&gt;&lt;/i&gt; &lt;/a&gt;&lt;/div&gt;&lt;/div&gt;                             &lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;                             &lt;script&gt;                                 $(\'.tpdm-head-wrap\').click(function () {                                     $(this).toggleClass(\'tpdm-head-edit\');                                 });                                 $(\'.tpdm-head-wrap&gt;.tpd-editing-close\').click(function () {                                     $(this).parents(\'.tpdm-head-wrap\').find(\'.tpdm-head-js\').removeClass(\'tpdm-head-scale\').html(\'\');                                     block.is_search=0;                                     delete block.search_style;                                     delete block[block.search_id];                                     delete block.search_id;                                 })                              &lt;/script&gt;                         &lt;/div&gt;                         &lt;div class=&quot;tpd-edits-hidden&quot; data-timeid=&quot;1524193999000&quot; data-eidtid=&quot;2&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-navstyle tpdm-navstyle5 clearfix&quot;&gt; &lt;a href=&quot;/mobile/Index/index.html&quot;&gt; &lt;div class=&quot;tpdm-navstyle-ico&quot;&gt;&lt;img src=&quot;/public/static/images/ico-nav1.jpg&quot; alt=&quot;&quot;&gt;&lt;/div&gt;&lt;p class=&quot;tpdm-navstyle-cont&quot;&gt;首页&lt;/p&gt; &lt;/a&gt; &lt;a href=&quot;/mobile/Goods/categoryList.html&quot;&gt; &lt;div class=&quot;tpdm-navstyle-ico&quot;&gt;&lt;img src=&quot;/public/static/images/ico-nav2.jpg&quot; alt=&quot;&quot;&gt;&lt;/div&gt; &lt;p class=&quot;tpdm-navstyle-cont&quot;&gt;分类&lt;/p&gt; &lt;/a&gt; &lt;a href=&quot;/Mobile/User/collect_list.html&quot;&gt; &lt;div class=&quot;tpdm-navstyle-ico&quot;&gt;&lt;img src=&quot;/public/static/images/ico-nav3.jpg&quot; alt=&quot;&quot;&gt;&lt;/div&gt; &lt;p class=&quot;tpdm-navstyle-cont&quot;&gt;收藏&lt;/p&gt; &lt;/a&gt; &lt;a href=&quot;/mobile/Cart/index.html&quot;&gt; &lt;div class=&quot;tpdm-navstyle-ico&quot;&gt;&lt;img src=&quot;/public/static/images/ico-nav4.jpg&quot; alt=&quot;&quot;&gt;&lt;/div&gt; &lt;p class=&quot;tpdm-navstyle-cont&quot;&gt;购物车&lt;/p&gt; &lt;/a&gt; &lt;a href=&quot;/mobile/User/index.html&quot;&gt; &lt;div class=&quot;tpdm-navstyle-ico&quot;&gt;&lt;img src=&quot;/public/static/images/ico-nav5.jpg&quot; alt=&quot;&quot;&gt;&lt;/div&gt; &lt;p class=&quot;tpdm-navstyle-cont&quot;&gt;个人中心&lt;/p&gt;&lt;/a&gt; &lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpd-edits-hidden tpd-editing&quot; data-timeid=&quot;1524194177000&quot; data-eidtid=&quot;5&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-txtnav-list&quot;&gt;&lt;a href=&quot;javascript:;&quot;&gt;查看更多&lt;/a&gt;&lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpd-edits-hidden&quot; data-timeid=&quot;1524194210000&quot; data-eidtid=&quot;6&quot; style=&quot;margin-bottom: 10px;&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-acstyle&quot;&gt;&lt;div class=&quot;tpdm-activity-title&quot;&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-goods-list tpdm-goods-list2&quot;&gt;&lt;ul class=&quot;tpdm-goods-wrap clearfix&quot; id=&quot;nxkhh&quot;&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;/public/upload/activity/2018/04-20/06a50383c9f135655e3089509fac42c2.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot; class=&quot;tpdm-goods-name&quot;&gt;团购活动运费选择版本:全网通3G+32G 选择颜色:红色 套餐类型:官方标配&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥20.00&lt;/div&gt;&lt;div class=&quot;tpdm-sold-num&quot;&gt;单买:￥87.00&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-goods-mes&quot;&gt;&lt;a href=&quot;/index.php?m=Mobile&amp;amp;c=Team&amp;amp;a=info&amp;amp;team_id=12&amp;amp;goods_id=215&quot;&gt;去拼单 &amp;gt;&lt;/a&gt;&lt;span&gt;3人团&lt;/span&gt;&lt;div class=&quot;tpdm-acbuyer&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot; class=&quot;tpdm-goods-name&quot;&gt;恒源祥袜子 男士6双装 男士纯棉四季款 吸湿透气全棉男袜 A110030款&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥39.90&lt;/div&gt;&lt;div class=&quot;tpdm-sold-num&quot;&gt;单买:￥49.00&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-goods-mes&quot;&gt;&lt;a href=&quot;/index.php?m=Mobile&amp;amp;c=Team&amp;amp;a=info&amp;amp;team_id=11&amp;amp;goods_id=185&quot;&gt;去拼单 &amp;gt;&lt;/a&gt;&lt;span&gt;5人团&lt;/span&gt;&lt;div class=&quot;tpdm-acbuyer&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;/public/upload/activity/2018/04-19/959381a8708655bee320efc050226c61.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot; class=&quot;tpdm-goods-name&quot;&gt;零食大礼包选择种类:选择5斤装 种类:袋装 版本:版本3 场景:送长辈&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥35.00&lt;/div&gt;&lt;div class=&quot;tpdm-sold-num&quot;&gt;单买:￥56.00&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-goods-mes&quot;&gt;&lt;a href=&quot;/index.php?m=Mobile&amp;amp;c=Team&amp;amp;a=info&amp;amp;team_id=10&amp;amp;goods_id=219&quot;&gt;去拼单 &amp;gt;&lt;/a&gt;&lt;span&gt;5人团&lt;/span&gt;&lt;div class=&quot;tpdm-acbuyer&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;/public/upload/activity/2018/04-19/a7f615864311f03f03c1d29c2e8eaa00.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot; class=&quot;tpdm-goods-name&quot;&gt;好多多选择种类:选择10斤装 种类:礼品盒装 场景:送孩子&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥19.90&lt;/div&gt;&lt;div class=&quot;tpdm-sold-num&quot;&gt;单买:￥29.90&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-goods-mes&quot;&gt;&lt;a href=&quot;/index.php?m=Mobile&amp;amp;c=Team&amp;amp;a=info&amp;amp;team_id=8&amp;amp;goods_id=220&quot;&gt;去拼单 &amp;gt;&lt;/a&gt;&lt;span&gt;2人团&lt;/span&gt;&lt;div class=&quot;tpdm-acbuyer&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;/public/upload/activity/2018/04-19/fddb3a817539b77817658309eeed0f7b.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot; class=&quot;tpdm-goods-name&quot;&gt;GENANX闪电潮牌男士拼接格子短袖衬衫 设计师潮牌夏季商务休闲免烫立领衬衫男潮&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥108.00&lt;/div&gt;&lt;div class=&quot;tpdm-sold-num&quot;&gt;单买:￥198.00&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-goods-mes&quot;&gt;&lt;a href=&quot;/index.php?m=Mobile&amp;amp;c=Team&amp;amp;a=info&amp;amp;team_id=6&amp;amp;goods_id=177&quot;&gt;去拼单 &amp;gt;&lt;/a&gt;&lt;span&gt;2人团&lt;/span&gt;&lt;div class=&quot;tpdm-acbuyer&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;/li&gt;&lt;li&gt;&lt;a class=&quot;tpdm-goods-pic&quot; href=&quot;javascript:;&quot;&gt;&lt;img src=&quot;/public/upload/activity/2018/04-19/9913f034eb46a4729a3985983ea5dc07.png&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;a href=&quot;javascript:;&quot; class=&quot;tpdm-goods-name&quot;&gt;【好礼在此】CASIO BABY-G少女时代广告款石英女表&lt;/a&gt;&lt;div class=&quot;tpdm-goods-des&quot;&gt;&lt;div class=&quot;tpdm-goods-price&quot;&gt;￥99.00&lt;/div&gt;&lt;div class=&quot;tpdm-sold-num&quot;&gt;单买:￥1096.00&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-goods-mes&quot;&gt;&lt;a href=&quot;/index.php?m=Mobile&amp;amp;c=Team&amp;amp;a=info&amp;amp;team_id=4&amp;amp;goods_id=133&quot;&gt;去拼单 &amp;gt;&lt;/a&gt;&lt;span&gt;2人团&lt;/span&gt;&lt;div class=&quot;tpdm-acbuyer&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;/li&gt;&lt;/ul&gt; &lt;/div&gt; &lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpd-edits-hidden&quot; data-timeid=&quot;1524194061000&quot; data-eidtid=&quot;10&quot; style=&quot;margin-bottom: 11px;&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-messtyle clearfix&quot;&gt;&lt;div class=&quot;tpdm-mes-logo&quot;&gt;&lt;img src=&quot;/public/upload/temp/2018/04-20/a899bb7e07ab747765c1fb55c8a30bf1.jpg&quot; alt=&quot;&quot;&gt;&lt;/div&gt;&lt;ul class=&quot;tpdm-mes-title&quot;&gt;&lt;li class=&quot;tpdm-mesname1&quot;&gt;你好&lt;/li&gt;&lt;li class=&quot;tpdm-mesname2&quot;&gt;中国&lt;/li&gt;&lt;/ul&gt;&lt;div class=&quot;tpdm-mes-cont&quot;&gt;&lt;a class=&quot;ellipsis1 tpdm-mescont1&quot; href=&quot;/index.php?m=Home&amp;amp;c=Goods&amp;amp;a=goodsInfo&amp;amp;id=2&quot;&gt;Jon家里的的临时分类临时螺蛳粉&lt;/a&gt;&lt;a class=&quot;ellipsis1 tpdm-mescont2&quot; href=&quot;javascript:;&quot;&gt;订单的观点供电公司感受感受公司故事梗概&lt;/a&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpd-edits-hidden&quot; data-timeid=&quot;1524194171000&quot; data-eidtid=&quot;4&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;div class=&quot;tpdm-wstyle tpdm-wstyle-wrap1&quot;&gt;&lt;a href=&quot;javascript:;&quot; class=&quot;tpdm-wstyle1&quot;&gt;&lt;img src=&quot;/public/static/images/pic-wstyle-list1.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt; &lt;/div&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpd-edits-hidden&quot; data-timeid=&quot;1524193929000&quot; data-eidtid=&quot;0&quot; style=&quot;margin-bottom: 9px;&quot;&gt;&lt;div class=&quot;js-code-wrap&quot;&gt;&lt;a href=&quot;/index.php/Mobile/Goods/integralMall&quot; class=&quot;tpdm-postyle tpdm-postyle1&quot;&gt; &lt;img src=&quot;/public/upload/temp/2018/04-20/fc4c4b7a601404410129889f6cf55ae3.jpg&quot; alt=&quot;&quot;&gt;&lt;/a&gt;&lt;/div&gt;&lt;i class=&quot;tpd-editing-close&quot;&gt;&lt;/i&gt;&lt;div class=&quot;tpd-edit-module&quot;&gt;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;tpdm-footer-wrap&quot; data-name=&quot;底部导航-隐藏&quot;&gt;&lt;div class=&quot;tpd-footer tpd-footer1&quot;&gt;&lt;a class=&quot;footmenu-ac&quot; href=&quot;/mobile/Index/index&quot;&gt;&lt;i class=&quot;ico-foot1&quot;&gt;&lt;/i&gt;&lt;span&gt;首页&lt;/span&gt;&lt;/a&gt;&lt;a href=&quot;/mobile/Goods/categoryList.html&quot;&gt;&lt;i class=&quot;ico-foot2&quot;&gt;&lt;/i&gt;&lt;span&gt;分类&lt;/span&gt;&lt;/a&gt;&lt;a class=&quot;tpd-footer-find&quot; href=&quot;/mobile/Goods/ajaxSearch&quot;&gt; &lt;i class=&quot;ico-foot3&quot;&gt;&lt;/i&gt;&lt;span&gt;发现&lt;/span&gt;&lt;/a&gt;&lt;a href=&quot;/mobile/Cart/index&quot;&gt;&lt;i class=&quot;ico-foot4&quot;&gt;&lt;/i&gt;&lt;span&gt;购物车&lt;/span&gt;&lt;/a&gt;&lt;a href=&quot;/Mobile/User/login&quot;&gt; &lt;i class=&quot;ico-foot5&quot;&gt;&lt;/i&gt;&lt;span&gt;我的&lt;/span&gt;&lt;/a&gt;&lt;/div&gt;&lt;/div&gt;                                          ',1,1524194321,'{&quot;is_notice&quot;:1,&quot;is_header&quot;:0,&quot;is_footer&quot;:1,&quot;is_search&quot;:1,&quot;1524193929000&quot;:{&quot;timeid&quot;:1524193929000,&quot;spacing&quot;:9,&quot;block_type&quot;:&quot;0&quot;,&quot;height_style&quot;:0,&quot;url&quot;:&quot;/index.php/Mobile/Goods/integralMall&quot;,&quot;url_type&quot;:1,&quot;pic&quot;:&quot;/public/upload/temp/2018/04-20/fc4c4b7a601404410129889f6cf55ae3.jpg&quot;},&quot;1524193978000&quot;:{&quot;timeid&quot;:1524193978000,&quot;block_type&quot;:&quot;8&quot;,&quot;search_style&quot;:2},&quot;search_id&quot;:1524193978000,&quot;1524193991000&quot;:{&quot;timeid&quot;:1524193991000,&quot;spacing&quot;:10,&quot;block_type&quot;:&quot;11&quot;},&quot;footer_type&quot;:0,&quot;footer_id&quot;:1524194163000,&quot;1524193999000&quot;:{&quot;timeid&quot;:1524193999000,&quot;spacing&quot;:10,&quot;block_type&quot;:&quot;2&quot;,&quot;shape_type&quot;:0,&quot;nav&quot;:[{&quot;pic&quot;:&quot;/public/static/images/ico-nav1.jpg&quot;,&quot;title_name&quot;:&quot;首页&quot;,&quot;url&quot;:&quot;/mobile/Index/index.html&quot;},{&quot;pic&quot;:&quot;/public/static/images/ico-nav2.jpg&quot;,&quot;title_name&quot;:&quot;分类&quot;,&quot;url&quot;:&quot;/mobile/Goods/categoryList.html&quot;},{&quot;pic&quot;:&quot;/public/static/images/ico-nav3.jpg&quot;,&quot;title_name&quot;:&quot;收藏&quot;,&quot;url&quot;:&quot;/Mobile/User/collect_list.html&quot;},{&quot;pic&quot;:&quot;/public/static/images/ico-nav4.jpg&quot;,&quot;title_name&quot;:&quot;购物车&quot;,&quot;url&quot;:&quot;/mobile/Cart/index.html&quot;},{&quot;pic&quot;:&quot;/public/static/images/ico-nav5.jpg&quot;,&quot;title_name&quot;:&quot;个人中心&quot;,&quot;url&quot;:&quot;/mobile/User/index.html&quot;}]},&quot;1524194061000&quot;:{&quot;timeid&quot;:1524194061000,&quot;spacing&quot;:11,&quot;block_type&quot;:&quot;10&quot;,&quot;nav&quot;:[{&quot;notice_title&quot;:&quot;你好&quot;,&quot;notice_info&quot;:&quot;Jon家里的的临时分类临时螺蛳粉&quot;,&quot;url&quot;:&quot;/index.php?m=Home&amp;c=Goods&amp;a=goodsInfo&amp;id=2&quot;},{&quot;notice_title&quot;:&quot;中国&quot;,&quot;notice_info&quot;:&quot;订单的观点供电公司感受感受公司故事梗概&quot;,&quot;url&quot;:&quot;&quot;}],&quot;notice_pic&quot;:&quot;/public/upload/temp/2018/04-20/a899bb7e07ab747765c1fb55c8a30bf1.jpg&quot;},&quot;1524194163000&quot;:{&quot;timeid&quot;:1524194163000,&quot;spacing&quot;:10,&quot;block_type&quot;:&quot;11&quot;},&quot;1524194171000&quot;:{&quot;timeid&quot;:1524194171000,&quot;spacing&quot;:10,&quot;block_type&quot;:&quot;4&quot;,&quot;window_style&quot;:0,&quot;nav&quot;:[{&quot;pic&quot;:&quot;&quot;,&quot;url&quot;:&quot;&quot;},{&quot;pic&quot;:&quot;&quot;,&quot;url&quot;:&quot;&quot;},{&quot;pic&quot;:&quot;&quot;,&quot;url&quot;:&quot;&quot;},{&quot;pic&quot;:&quot;&quot;,&quot;url&quot;:&quot;&quot;}]},&quot;1524194177000&quot;:{&quot;timeid&quot;:1524194177000,&quot;spacing&quot;:10,&quot;block_type&quot;:&quot;5&quot;,&quot;color&quot;:&quot;#ff2222&quot;,&quot;txt_title&quot;:&quot;查看更多&quot;},&quot;1524194210000&quot;:{&quot;timeid&quot;:1524194210000,&quot;spacing&quot;:10,&quot;block_type&quot;:&quot;6&quot;,&quot;activity_type&quot;:0,&quot;tab_type&quot;:1,&quot;tab_title&quot;:&quot;&quot;,&quot;show_type&quot;:1}}',0,NULL,0);

UNLOCK TABLES;

/*Table structure for table `tp_navigation` */

DROP TABLE IF EXISTS `tp_navigation`;

CREATE TABLE `tp_navigation` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '前台导航表',
  `name` varchar(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '' COMMENT '导航名称',
  `is_show` tinyint(1) DEFAULT '1' COMMENT '是否显示',
  `is_new` tinyint(1) DEFAULT '1' COMMENT '是否新窗口',
  `sort` smallint(6) DEFAULT '50' COMMENT '排序',
  `url` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '' COMMENT '链接地址',
  `position` enum('top','bottom') CHARACTER SET latin1 NOT NULL DEFAULT 'top' COMMENT '菜单位置，top顶部，bottom底部',
  PRIMARY KEY (`id`)
)  AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

/*Data for the table `tp_navigation` */

LOCK TABLES `tp_navigation` WRITE;

insert  into `tp_navigation`(`id`,`name`,`is_show`,`is_new`,`sort`,`url`,`position`) values (1,'限时抢购',0,0,1,'/index.php?m=Home&amp;c=Activity&amp;a=flash_sale_list','top'),(2,'积分商城',1,0,4,'/index.php?m=Home&amp;c=Goods&amp;a=integralMall','top'),(3,'新用户注册',0,0,3,'/index.php/Home/Article/detail/article_id/1','bottom'),(4,'女装',1,0,4,'/index.php/Home/Goods/goodsList/id/12','top'),(6,'手机通讯',1,0,5,'/index.php/Home/Goods/goodsList/id/31','top'),(8,'团购活动',0,0,32767,'/index.php?m=Home&amp;c=Activity&amp;a=group_list','top'),(11,'预售活动',0,0,2,'http://b2t.tp-shop.cn/index.php/home/Activity/pre_sell_list.html','top'),(12,'手机通讯',1,0,3,'/index.php/Home/Goods/goodsList/id/32','top'),(13,'分销',0,0,1221,'/index.php/Home/Article/detail/article_id/34','bottom');

UNLOCK TABLES;

/*Table structure for table `tp_news` */

DROP TABLE IF EXISTS `tp_news`;

CREATE TABLE `tp_news` (
  `article_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `cat_id` smallint(5) NOT NULL DEFAULT '0' COMMENT '类别ID',
  `title` varchar(150) NOT NULL DEFAULT '' COMMENT '文章标题',
  `tags` char(64) DEFAULT NULL COMMENT '新闻标签',
  `content` longtext NOT NULL,
  `author` varchar(30) NOT NULL DEFAULT '' COMMENT '文章作者',
  `author_email` varchar(60) NOT NULL DEFAULT '' COMMENT '作者邮箱',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `article_type` tinyint(1) unsigned NOT NULL DEFAULT '2',
  `is_open` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `file_url` varchar(255) NOT NULL DEFAULT '' COMMENT '附件地址',
  `open_type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `link` varchar(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `description` mediumtext COMMENT '文章摘要',
  `click` int(11) DEFAULT '0' COMMENT '浏览量',
  `publish_time` int(11) DEFAULT NULL COMMENT '文章预告发布时间',
  `thumb` varchar(255) DEFAULT '' COMMENT '文章缩略图',
  PRIMARY KEY (`article_id`),
  KEY `cat_id` (`cat_id`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_news` */

LOCK TABLES `tp_news` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_news_cat` */

DROP TABLE IF EXISTS `tp_news_cat`;

CREATE TABLE `tp_news_cat` (
  `cat_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_name` varchar(20) DEFAULT NULL COMMENT '类别名称',
  `cat_type` smallint(6) DEFAULT '0' COMMENT '默认分组',
  `parent_id` smallint(6) DEFAULT '0' COMMENT '夫级ID',
  `show_in_nav` tinyint(1) DEFAULT '0' COMMENT '是否导航显示',
  `sort_order` smallint(6) DEFAULT '50' COMMENT '排序',
  `cat_desc` varchar(255) DEFAULT NULL COMMENT '分类描述',
  `keywords` varchar(30) DEFAULT NULL COMMENT '搜索关键词',
  `cat_alias` varchar(20) DEFAULT NULL COMMENT '别名',
  PRIMARY KEY (`cat_id`)
)  DEFAULT CHARSET=utf8;

/*Data for the table `tp_news_cat` */

LOCK TABLES `tp_news_cat` WRITE;

UNLOCK TABLES;

/*Table structure for table `tp_oauth_users` */

DROP TABLE IF EXISTS `tp_oauth_users`;

CREATE TABLE `tp_oauth_users` (
  `tu_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '表自增ID',
  `user_id` mediumint(8) NOT NULL COMMENT '用户表ID',
  `openid` varchar(255) NOT NULL COMMENT '第三方开放平台openid',
  `oauth` varchar(50) NOT NULL COMMENT '第三方授权平台',
  `unionid` varchar(255) DEFAULT NULL COMMENT 'unionid',
  `oauth_child` varchar(50) DEFAULT NULL COMMENT 'mp标识来自公众号, open标识来自开放平台,用于标识来自哪个第三方授权平台, 因为同是微信平台有来自公众号和开放平台',
  `nick_name` varchar(64) DEFAULT NULL COMMENT '绑定时的昵称',
  PRIMARY KEY (`tu_id`)
)  AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;

/*Data for the table `tp_oauth_users` */

LOCK TABLES `tp_oauth_users` WRITE;

insert  into `tp_oauth_users`(`tu_id`,`user_id`,`openid`,`oauth`,`unionid`,`oauth_child`,`nick_name`) values (2,2,'oGMnQ1LfgerwTu1FJL835ib1aQpw','wx','oDZRzwxQaus-DTpLhOSJfkA0fkcA','',NULL),(3,23,'B0C344E52B6012FDABEE9ECD0557C0CC','qq','UID_7C1B0B2E4C9CF80BBD262D858DCCFD0F','',NULL),(4,24,'oGMnQ1B17wnBvpAw6xzjQWxqExuQ','wx','oDZRzw30TsZRLWSlUhGXV3_G96VY',NULL,NULL),(5,26,'oGMnQ1HqUFRg4dum-GVONjO5jnno','wx','oDZRzw4nZI87j7Wy75AwnCahD9VA','',NULL),(6,2,'o9cTBwbBQ6HXoonM76VwVgGvmEqQ','weixin','oDZRzwxQaus-DTpLhOSJfkA0fkcA','mp',NULL),(8,28,'o9cTBwWqEYM8svh0ISDq5kBoL_Ko','weixin','oDZRzw0ZB9vFgw7Nr6oiqyxPQhX0','mp',NULL),(9,29,'o9cTBwb9m33ZB0MCH3N816ZKAjfg','weixin','oDZRzw72rtUO20crj0WXAfBXeghc','mp',NULL),(10,30,'o9cTBwZKi0GtnG1OKQdcyOxVH6RE','weixin','oDZRzw13e_Zua9ssc6gqXoyhpDzw','mp',NULL),(11,24,'o9cTBwev16ovxCbeynpnKfSTQVJk','weixin','oDZRzw30TsZRLWSlUhGXV3_G96VY','mp',NULL),(12,32,'o9cTBwS0VxKjNkxe6NM9sYIorhAM','weixin','oDZRzwwyzotr5oVB7EpnoGKLgIEc','mp',NULL),(13,33,'o9cTBwRAb2B6TeE9O75XeJbxXlhM','weixin','oDZRzw9CqkvlycW0wa78eOSSvUKo','mp',NULL),(14,33,'o9cTBwRAb2B6TeE9O75XeJbxXlhM','weixin','oDZRzw9CqkvlycW0wa78eOSSvUKo','mp',NULL),(15,33,'o9cTBwRAb2B6TeE9O75XeJbxXlhM','weixin','oDZRzw9CqkvlycW0wa78eOSSvUKo','mp',NULL),(16,33,'o9cTBwRAb2B6TeE9O75XeJbxXlhM','weixin','oDZRzw9CqkvlycW0wa78eOSSvUKo','mp',NULL),(17,33,'o9cTBwRAb2B6TeE9O75XeJbxXlhM','weixin','oDZRzw9CqkvlycW0wa78eOSSvUKo','mp',NULL),(18,33,'o9cTBwRAb2B6TeE9O75XeJbxXlhM','weixin','oDZRzw9CqkvlycW0wa78eOSSvUKo','mp',NULL),(19,33,'o9cTBwRAb2B6TeE9O75XeJbxXlhM','weixin','oDZRzw9CqkvlycW0wa78eOSSvUKo','mp',NULL),(20,34,'o9cTBwRpt_6Qdoi3egl4wL9mrtbs','weixin','oDZRzw6otRVEClGHh_c3qv8DPSpA','mp',NULL),(21,35,'o9cTBwX3gJORm_u6t9kAlbGATWmg','weixin','oDZRzw0yaJWvrPFKgdpv7mKpDEt0','mp',NULL),(22,36,'o9cTBwf6ki0bPzXi2ChKgl1r-HGA','weixin','oDZRzwyf6ow3yu291ToIwRtCFWmI','mp',NULL),(23,37,'o9cTBwRh80sCWjKs6UjmjAJQbbkg','weixin','oDZRzwxqYCdvTk_LOvlNsOj3J47A','mp',NULL),(24,38,'o9cTBwTeq1-doni8gIfD512RSRec','weixin','oDZRzwziwIEu_00ufvFuYxgVSInE','mp',NULL),(25,39,'o9cTBwdImlnFkA130oApo6UtStUc','weixin','oDZRzwyaFhzPJvUDFxm3rUyJeLCQ','mp',NULL),(26,40,'o9cTBwUDY08LVZUAXIvagXZrrp10','weixin','oDZRzwwwXaH56KgNIOcxopsgR8DY','mp',NULL),(27,41,'o9cTBwVlCnTf2rv9SGxDTpU4HQ_w','weixin','oDZRzw5n2cnE1fX4WQra-Savqgd4','mp',NULL),(28,42,'o9cTBwRO6nW8bwmSfJnHnGNZkIqQ','weixin','oDZRzw2tSS9oaA-r_-_ExiRt7GB0','mp',NULL);

UNLOCK TABLES;

/*Table structure for table `tp_order` */

DROP TABLE IF EXISTS `tp_order`;

CREATE TABLE `tp_order` (
  `order_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '订单id',
  `order_sn` varchar(20) NOT NULL DEFAULT '' COMMENT '订单编号',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `order_status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '订单状态',
  `shipping_status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '发货状态',
  `pay_status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '支付状态',
  `consignee` varchar(60) NOT NULL DEFAULT '' COMMENT '收货人',
  `country` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '国家',
  `province` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '省份',
  `city` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '城市',
  `district` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '县区',
  `twon` int(11) DEFAULT '0' COMMENT '乡镇',
  `address` varchar(255) NOT NULL DEFAULT '' COMMENT '地址',
  `zipcode` varchar(60) NOT NULL DEFAULT '' COMMENT '邮政编码',
  `mobile` varchar(60) NOT NULL DEFAULT '' COMMENT '手机',
  `email` varchar(60) NOT NULL DEFAULT '' COMMENT '邮件',
  `shipping_code` varchar(32) NOT NULL DEFAULT '' COMMENT '物流code',
  `shipping_name` varchar(120) NOT NULL DEFAULT '' COMMENT '物流名称',
  `pay_code` varchar(32) NOT NULL DEFAULT '' COMMENT '支付code',
  `pay_name` varchar(120) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `invoice_title` varchar(256) DEFAULT '' COMMENT '发票抬头',
  `taxpayer` varchar(30) DEFAULT '' COMMENT '纳税人识别号',
  `invoice_desc` varchar(30) DEFAULT NULL COMMENT '发票内容',
  `goods_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '商品总价',
  `shipping_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '邮费',
  `user_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '使用余额',
  `coupon_price` decimal(10,2) DEFAULT '0.00' COMMENT '优惠券抵扣',
  `integral` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '使用积分',
  `integral_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '使用积分抵多少钱',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '应付款金额',
  `total_amount` decimal(10,2) DEFAULT '0.00' COMMENT '订单总价',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '下单时间',
  `shipping_time` int(11) DEFAULT '0' COMMENT '最后新发货时间',
  `confirm_time` int(10) DEFAULT '0' COMMENT '收货确认时间',
  `pay_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `transaction_id` varchar(255) DEFAULT NULL COMMENT '第三方平台交易流水号',
  `prom_id` int(11) unsigned DEFAULT '0' COMMENT '活动ID',
  `prom_type` tinyint(4) unsigned DEFAULT '0' COMMENT '订单类型：0普通订单4预售订单5虚拟订单6拼团订单',
  `order_prom_id` smallint(6) NOT NULL DEFAULT '0' COMMENT '活动id',
  `order_prom_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '活动优惠金额',
  `discount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '价格调整',
  `user_note` varchar(255) NOT NULL DEFAULT '' COMMENT '用户备注',
  `admin_note` varchar(255) DEFAULT '' COMMENT '管理员备注',
  `parent_sn` varchar(100) DEFAULT NULL COMMENT '父单单号',
  `is_distribut` tinyint(1) DEFAULT '0' COMMENT '是否已分成0未分成1已分成',
  `paid_money` decimal(10,2) DEFAULT '0.00' COMMENT '订金',
  `shop_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '自提点门店id',
  `deleted` tinyint(1) NOT NULL DEFAULT '0' COMMENT '用户假删除标识,1:删除,0未删除',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_sn` (`order_sn`),
  KEY `user_id` (`user_id`),
  KEY `add_time` (`add_time`)
)  AUTO_INCREMENT=588 DEFAULT CHARSET=utf8;

/*Data for the table `tp_order` */

LOCK TABLES `tp_order` WRITE;

insert  into `tp_order`(`order_id`,`order_sn`,`user_id`,`order_status`,`shipping_status`,`pay_status`,`consignee`,`country`,`province`,`city`,`district`,`twon`,`address`,`zipcode`,`mobile`,`email`,`shipping_code`,`shipping_name`,`pay_code`,`pay_name`,`invoice_title`,`taxpayer`,`invoice_desc`,`goods_price`,`shipping_price`,`user_money`,`coupon_price`,`integral`,`integral_money`,`order_amount`,`total_amount`,`add_time`,`shipping_time`,`confirm_time`,`pay_time`,`transaction_id`,`prom_id`,`prom_type`,`order_prom_id`,`order_prom_amount`,`discount`,`user_note`,`admin_note`,`parent_sn`,`is_distribut`,`paid_money`,`shop_id`,`deleted`) values (167,'201804191126464325',1,0,0,1,'小小',0,3102,3224,3225,0,'西城工业区12栋','51828482','15915407513','','','','','','个人','',NULL,1199.00,0.00,0.00,0.00,0,0.00,10.00,1199.00,1524108212,0,0,1524108418,NULL,13,4,0,0.00,0.00,'','',NULL,0,10.00,0,0),(168,'201804191135226874',1,0,0,2,'小小',0,3102,3224,3225,0,'西城工业区12栋','51828482','15915407513','','','','','','个人','',NULL,47.00,0.00,0.00,0.00,0,0.00,37.00,47.00,1524108562,0,0,1524108922,NULL,14,4,0,0.00,0.00,'','',NULL,0,10.00,0,0),(261,'201804201516472940',9,2,1,1,'夏夏',0,1,2,3,4,'123456786','','15274851694','','YD','韵达快递','','余额支付',NULL,'',NULL,178.20,0.00,178.20,0.00,0,0.00,0.00,178.20,1524208607,1524208756,1524208768,1524208608,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(260,'201804201514538922',10,0,0,1,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','','','','','余额支付',NULL,'',NULL,39.90,0.00,39.90,0.00,0,0.00,0.00,39.90,1524208493,0,0,1524208507,NULL,11,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(258,'201804201504303648',9,2,1,1,'夏夏',0,1,2,3,4,'123456786','','15274851694','','YTO','圆通快递','','余额支付',NULL,'',NULL,177.00,0.00,177.00,0.00,0,0.00,0.00,177.00,1524207870,1524207913,1524207926,1524207870,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(259,'201804201510574786',2,3,0,0,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','余额支付','个人','',NULL,125.00,0.00,24.00,0.00,1000,100.00,1.00,125.00,1524208257,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(257,'201804201444127651',3,2,1,1,'咖啡',0,3102,3379,3395,3399,'站北地区11号大街','12345665','15274851694','','YD','韵达快递','','余额支付','转身','123456789123456',NULL,261.32,0.00,261.32,0.00,0,0.00,0.00,261.32,1524206652,1524206694,1524206716,1524206652,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(13,'201804131117304233',5,2,1,1,'直径4CM棒棒',0,636,1188,1190,1195,'棒棒','','13800138006','','shunfeng','顺丰快递','','余额支付','','',NULL,6999.00,0.00,6999.00,0.00,0,0.00,0.00,6999.00,1523589450,1523589647,1523861402,1523589451,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(12,'201804121012019579',1,3,0,0,'上海滩',0,7531,7706,7768,NULL,'西城工业区12栋','51551112','15915407513','15915407513@163.com','','','','','','',NULL,774.00,16.00,0.00,0.00,0,0.00,790.00,790.00,1523499121,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(256,'201804201435244467',3,3,0,3,'咖啡',0,3102,3379,3395,3399,'站北地区11号大街','12345665','15274851694','','','','','积分兑换','转身','123456789123456',NULL,35.00,0.00,0.00,0.00,350,35.00,0.00,35.00,1524206124,0,0,1524206124,NULL,0,0,0,0.00,0.00,'订单不能按预计时间送达','',NULL,1,0.00,0,0),(255,'201804201424551009',2,3,0,0,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','','','','','','个人','',NULL,85.00,0.00,0.00,0.00,0,0.00,10.00,85.00,1524205495,0,0,0,NULL,19,4,0,0.00,0.00,'','',NULL,0,0.00,0,0),(254,'201804201422393062',3,2,1,1,'咖啡',0,3102,3379,3395,3399,'站北地区11号大街','12345665','15274851694','','YTO','圆通快递','','积分兑换','转身','123456789123456',NULL,70.00,0.00,0.00,0.00,700,70.00,0.00,70.00,1524205359,1524205452,1524205501,1524205359,NULL,0,0,0,0.00,0.00,'43343434344343433434','',NULL,1,0.00,0,0),(253,'201804201410507328',2,0,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','','','','','余额支付',NULL,'',NULL,37.90,0.00,37.91,0.00,0,0.00,0.00,37.91,1524204650,0,0,1524204661,NULL,11,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(251,'201804201102075320',3,0,0,1,'夏夏',0,636,637,639,4,'炫舞大厅112','','15274851694','','','','','余额支付',NULL,'',NULL,18.80,8.00,26.80,0.00,0,0.00,0.00,26.80,1524193327,0,0,1524193380,NULL,12,6,0,0.00,0.00,'1234567890','',NULL,1,0.00,0,0),(252,'201804201130393117',2,3,0,0,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','alipayMobile','手机网站支付宝','个人','',NULL,125.00,0.00,0.00,0.00,1000,100.00,25.00,125.00,1524195039,0,0,0,NULL,0,0,0,0.00,0.00,'DDD DDDD DGDGDGGDSGG','',NULL,1,0.00,0,0),(250,'201804201100389900',3,0,0,1,'夏夏',0,636,637,639,4,'炫舞大厅112','','15274851694','','','','','余额支付',NULL,'',NULL,18.80,8.00,26.80,0.00,0,0.00,0.00,26.80,1524193238,0,0,1524193290,NULL,12,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(249,'201804201014599182',3,0,0,1,'xiasj',0,28240,28558,28581,28582,'433434344','60025569','18516589423','','','','','余额支付',NULL,'',NULL,32.90,10.00,22.90,0.00,200,20.00,0.00,42.90,1524190499,0,0,1524190629,NULL,10,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(248,'201804200955479850',2,0,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','','','','','余额支付',NULL,'',NULL,18.90,9.00,27.91,0.00,0,0.00,0.00,27.91,1524189347,0,0,1524189369,NULL,8,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(246,'201804200949514020',3,3,0,0,'青春',0,0,0,0,0,'','','18516589423','','','','','',NULL,'',NULL,32.90,0.00,0.00,0.00,0,0.00,32.90,32.90,1524188991,0,0,0,NULL,10,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(247,'201804200953146860',2,0,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','','','','','余额支付',NULL,'',NULL,18.90,9.00,27.91,0.00,0,0.00,0.00,27.91,1524189194,0,0,1524189218,NULL,8,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(245,'201804200949222498',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,25.55,0.00,0.00,0.00,0,0.00,25.56,25.56,1524188962,0,0,0,NULL,9,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(243,'201804200912448956',10,0,0,1,'傅慢',0,17359,18829,18949,18954,'他提供啦太可怜了','','15915407513','','','','','余额支付',NULL,'',NULL,39.90,0.00,39.90,0.00,0,0.00,0.00,39.90,1524186764,0,0,1524186800,NULL,11,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(244,'201804200926046917',10,0,0,1,'傅慢',0,17359,18829,18949,18954,'他提供啦太可怜了','','15915407513','','','','','余额支付',NULL,'',NULL,19.90,10.00,29.90,0.00,0,0.00,0.00,29.90,1524187564,0,0,1524187582,NULL,8,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(242,'201804200908244367',3,3,0,0,'青春',0,0,0,0,0,'','','18516589423','','','','','',NULL,'',NULL,65.80,0.00,0.00,0.00,0,0.00,65.80,65.80,1524186504,0,0,0,NULL,10,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(241,'201804191758434070',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,18.90,0.00,0.00,0.00,0,0.00,18.91,18.91,1524131923,0,0,0,NULL,8,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(239,'201804191753493645',3,3,0,0,'青春',0,0,0,0,0,'','','18516589423','','','','','',NULL,'',NULL,93.06,0.00,0.00,0.00,0,0.00,93.06,93.06,1524131629,0,0,0,NULL,4,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(240,'201804191753588176',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,102.60,0.00,0.00,0.00,0,0.00,102.60,102.60,1524131638,0,0,0,NULL,6,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(238,'201804191752475427',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,33.25,0.00,0.00,0.00,0,0.00,33.25,33.25,1524131567,0,0,0,NULL,10,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(237,'201804191729283108',10,3,0,3,'傅慢',0,17359,18829,18949,18954,'他提供啦太可怜了','','15915407513','','','','','余额支付',NULL,'',NULL,108.00,0.00,108.00,0.00,0,0.00,0.00,108.00,1524130168,0,0,1524130196,NULL,6,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(235,'201804191720239500',2,0,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','','','','','余额支付',NULL,'',NULL,102.60,0.00,102.60,0.00,0,0.00,0.00,102.60,1524129623,0,0,1524129642,NULL,6,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(236,'201804191727544276',10,0,0,1,'傅慢',0,17359,18829,18949,18954,'他提供啦太可怜了','','15915407513','','','','','余额支付',NULL,'',NULL,108.00,0.00,108.00,0.00,0,0.00,0.00,108.00,1524130074,0,0,1524130150,NULL,6,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(234,'201804191718103193',2,0,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','','','','','余额支付',NULL,'',NULL,18.90,9.00,27.91,0.00,0,0.00,0.00,27.91,1524129490,0,0,1524129535,NULL,8,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(233,'201804191716037250',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,18.90,0.00,0.00,0.00,0,0.00,18.91,18.91,1524129363,0,0,0,NULL,8,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(231,'201804191708111471',3,3,0,0,'青春',0,0,0,0,0,'','','18516589423','','','','','',NULL,'',NULL,18.71,0.00,0.00,0.00,0,0.00,18.71,18.71,1524128891,0,0,0,NULL,8,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(232,'201804191708154569',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,18.90,0.00,0.00,0.00,0,0.00,18.91,18.91,1524128895,0,0,0,NULL,8,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(230,'201804191708099385',3,1,0,1,'咖啡',0,3102,3379,3395,3399,'站北地区11号大街','12345665','15274851694','','','','','余额支付',NULL,'',NULL,18.71,9.00,10.01,0.00,177,17.70,0.00,27.71,1524128889,0,0,1524129045,NULL,8,6,0,0.00,0.00,'12345678912345678912345678912345678912345678812345','',NULL,1,0.00,0,0),(229,'201804191658081386',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,18.90,0.00,0.00,0.00,0,0.00,18.91,18.91,1524128288,0,0,0,NULL,8,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(228,'201804191649421833',10,3,0,1,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','15825@163.com','','','','余额支付','个人','',NULL,29.90,10.00,39.90,0.00,0,0.00,0.00,39.90,1524127782,0,0,1524127782,NULL,0,0,0,0.00,0.00,'重复下单/误下单','',NULL,1,0.00,0,0),(227,'201804191641409909',9,2,1,1,'1234',0,14234,14687,14764,0,'123456789','','18515252525','','YD','韵达快递','','余额支付',NULL,'',NULL,20.00,10.00,30.00,0.00,0,0.00,0.00,30.00,1524127300,1524127708,1524127789,1524127340,NULL,7,6,0,0.00,0.00,'454545454','',NULL,1,0.00,0,0),(226,'201804191640111379',2,1,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','','','','','余额支付',NULL,'',NULL,25.55,9.00,34.56,0.00,0,0.00,0.00,34.56,1524127211,0,0,1524127233,NULL,9,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(225,'201804191639573233',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,25.55,0.00,0.00,0.00,0,0.00,25.56,25.56,1524127197,0,0,0,NULL,9,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(224,'201804191639037742',10,1,0,1,'傅慢',0,17359,18829,18949,18954,'他提供啦太可怜了','','15915407513','','','','','余额支付',NULL,'',NULL,26.90,10.00,36.90,0.00,0,0.00,0.00,36.90,1524127143,0,0,1524127168,NULL,9,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(223,'201804191637482212',5,3,0,3,'代代',0,1,2,3,0,'123456','','18516589423','','','','','余额支付',NULL,'',NULL,18.80,10.00,28.80,0.00,0,0.00,0.00,28.80,1524127068,0,0,1524127087,NULL,7,6,0,0.00,0.00,'22344343434','',NULL,1,0.00,0,0),(222,'201804191632098352',3,4,1,1,'咖啡',0,3102,3379,3395,3399,'站北地区11号大街','12345665','15274851694','','zhongtong','中通快递','','余额支付',NULL,'',NULL,18.80,9.00,0.00,0.00,278,27.80,0.00,27.80,1524126729,1524128753,1524128782,1524126744,NULL,7,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(221,'201804191628405878',3,3,0,0,'18516589423',0,0,0,0,0,'','','18516589423','','','','','',NULL,'',NULL,18.71,0.00,0.00,0.00,0,0.00,18.71,18.71,1524126520,0,0,0,NULL,8,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(220,'201804191626203332',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,18.90,0.00,0.00,0.00,0,0.00,18.91,18.91,1524126380,0,0,0,NULL,8,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(219,'201804191623521017',10,1,0,1,'傅慢',0,17359,18829,18949,18954,'他提供啦太可怜了','','15915407513','','','','','余额支付',NULL,'',NULL,59.70,10.00,69.70,0.00,0,0.00,0.00,69.70,1524126232,0,0,1524126267,NULL,8,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(218,'201804191622575839',10,3,0,0,'傅慢',0,17359,18829,18949,18954,'他提供啦太可怜了','','15915407513','','','','','余额支付',NULL,'',NULL,59.70,10.00,60.00,0.00,0,0.00,9.70,69.70,1524126177,0,0,0,NULL,8,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(206,'201804191536352587',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,142.50,0.00,0.00,0.00,0,0.00,142.50,142.50,1524123395,0,0,0,NULL,5,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(207,'201804191536395563',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,142.50,0.00,0.00,0.00,0,0.00,142.50,142.50,1524123399,0,0,0,NULL,5,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(52,'201804171106141412',11,0,0,0,'欧沃',0,46047,46380,46410,46420,'11区','60082252','17785858585','','','','','','','',NULL,373.00,0.00,0.00,0.00,0,0.00,373.00,373.00,1523934374,0,0,0,NULL,0,0,0,0.00,0.00,'3232323','',NULL,1,0.00,0,0),(53,'201804171112286945',8,3,0,0,'成都',0,636,1291,1319,1322,'12345666','','15274851694','','','','','',NULL,'',NULL,177.00,0.00,0.00,0.00,0,0.00,177.00,177.00,1523934748,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(54,'201804171116378098',8,3,0,0,'成都',0,636,1291,1319,1322,'12345666','','15274851694','','','','','',NULL,'',NULL,177.00,0.00,0.00,0.00,0,0.00,177.00,177.00,1523934997,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(55,'201804171120026059',11,0,0,0,'欧沃',0,46047,46380,46410,46420,'11区','60082252','17785858585','','','','','','','',NULL,177.00,0.00,0.00,0.00,0,0.00,177.00,177.00,1523935202,0,0,0,NULL,0,0,0,0.00,0.00,'成都的街头走一走','',NULL,1,0.00,0,0),(56,'201804171120408727',1,3,0,0,'xiaoxiao',0,30164,30165,30174,NULL,'乐宁镇往路店','158285','1591540','15915407513@163.com','YTO','圆通快递','alipay','PC端支付宝','傅曼','',NULL,3915.00,0.00,0.00,0.00,0,0.00,3915.00,3915.00,1523935240,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(57,'201804171128591999',1,2,1,1,'xiaoxiao',0,1,300,322,NULL,'西城工业区12栋','51828','15915407513','15915407513@163.com','shunfeng','顺丰快递','','','','',NULL,217.10,0.00,0.00,0.00,0,0.00,217.10,217.10,1523935739,1523935956,1523935967,1523935851,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(58,'201804171129599877',1,3,0,0,'小小',0,1,2,14,NULL,'西城工业区12栋','518282','15915407513','15915407513@163.com','','','','','','',NULL,114.00,0.00,0.00,0.00,0,0.00,114.00,114.00,1523935799,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(59,'201804171135214854',1,0,0,1,'1582',0,338,569,570,NULL,'黄铜村第六巷','对对对大概是','15915407513','15915407513@163.com','shunfeng','顺丰快递','weixinH5','微信支付','','',NULL,187.00,0.00,0.00,0.00,0,0.00,187.00,187.00,1523936121,0,0,1523936632,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(60,'201804171143229433',1,3,0,1,'15915407513@163.com',0,338,569,570,NULL,'黄铜村第六巷','对对对大概是','15915407513','15915407513@163.com','shunfeng','顺丰快递','weixinH5','微信支付','','',NULL,79.00,0.00,0.00,0.00,0,0.00,79.00,79.00,1523936602,0,0,1523936863,NULL,0,0,0,0.00,0.00,'其他渠道价格更低','','201804171135214854',1,0.00,0,0),(217,'201804191621165259',10,1,0,1,'傅慢',0,17359,18829,18949,18954,'他提供啦太可怜了','','15915407513','','','','','余额支付',NULL,'',NULL,19.90,10.00,29.90,0.00,0,0.00,0.00,29.90,1524126076,0,0,1524126097,NULL,8,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(62,'201804171149479728',1,2,1,1,'苏苏',0,1,2,3,NULL,'黄田岗贝工业区12栋','518282','15915407513','15915407513@163.com','shunfeng','顺丰快递','','','','',NULL,307.00,0.00,0.00,0.00,0,0.00,307.00,307.00,1523936987,1523937230,1523937296,1523937211,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(216,'201804191620573684',10,3,0,0,'等待',0,0,0,0,0,'','','15919919433','15825@163.com','','','','',NULL,'',NULL,19.90,0.00,0.00,0.00,0,0.00,19.90,19.90,1524126057,0,0,0,NULL,8,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(64,'201804171156094142',1,0,0,1,'7585',0,3102,3103,3104,NULL,'对对对的观点','518285','15915407513','15915407513@163.com','','','','','','',NULL,185.00,0.00,0.00,0.00,0,0.00,185.00,185.00,1523937369,0,0,1523937571,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(65,'201804171201143566',1,0,0,1,'7585',0,3102,3103,3104,NULL,'对对对的观点','518285','15915407513','15915407513@163.com','','','','','','',NULL,99.00,0.00,0.00,0.00,0,0.00,99.00,99.00,1523937674,0,0,1523937571,NULL,0,0,0,0.00,0.00,'','','201804171156094142',1,0.00,0,0),(214,'201804191550023618',3,3,0,0,'18516589423',0,0,0,0,0,'','','18516589423','','','','','',NULL,'',NULL,18.80,0.00,0.00,0.00,0,0.00,18.80,18.80,1524124202,0,0,0,NULL,7,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(215,'201804191613335437',2,1,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','','','','','余额支付',NULL,'',NULL,37.82,9.00,46.82,0.00,0,0.00,0.00,46.82,1524125613,0,0,1524125666,NULL,8,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(212,'201804191540318637',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,142.50,0.00,0.00,0.00,0,0.00,142.50,142.50,1524123631,0,0,0,NULL,5,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(213,'201804191540599893',2,2,1,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','','shunfeng','顺丰快递','','余额支付',NULL,'',NULL,142.50,0.00,142.50,0.00,0,0.00,0.00,142.50,1524123659,1524123871,1524210392,1524123689,NULL,5,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(211,'201804191538382233',10,3,0,0,'等待',0,0,0,0,0,'','','15919919433','15825@163.com','','','','',NULL,'',NULL,150.00,0.00,0.00,0.00,0,0.00,150.00,150.00,1524123518,0,0,0,NULL,5,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(210,'201804191538171030',10,4,1,1,'傅慢',0,17359,18829,18949,18954,'他提供啦太可怜了','','15915407513','','shunfeng','顺丰快递','','余额支付',NULL,'',NULL,150.00,0.00,150.00,0.00,0,0.00,0.00,150.00,1524123497,1524123895,1524210392,1524123555,NULL,5,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(72,'201804171549355436',1,0,0,1,'小小',0,338,569,586,NULL,'对对对的','518282','15915407513','15915407513@163.com','','','','','傅','18283273718528',NULL,141.00,0.00,0.00,0.00,0,0.00,141.00,141.00,1523951375,0,0,1523951443,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(209,'201804191536391831',2,3,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','','','','','余额支付',NULL,'',NULL,142.50,0.00,142.50,0.00,0,0.00,0.00,142.50,1524123399,0,0,1524123445,NULL,5,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(77,'201804171603071811',1,2,1,1,'对对对',0,636,936,938,NULL,'新城成','518285','15915407513','15915407513@163.com','YZPY','中国邮政','','','','',NULL,438.90,0.00,0.00,0.00,0,0.00,438.90,438.90,1523952187,1524047505,1524189711,1523952331,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(204,'201804191523205025',2,3,0,0,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','','','','','',NULL,'',NULL,102.60,0.00,0.00,0.00,0,0.00,102.60,102.60,1524122600,0,0,0,NULL,6,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(205,'201804191523415828',2,4,1,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','','shunfeng','顺丰快递','','余额支付',NULL,'',NULL,102.60,0.00,102.60,0.00,0,0.00,0.00,102.60,1524122621,1524122982,1524123181,1524122650,NULL,6,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(81,'201804171702545505',3,2,1,1,'咖啡',0,45753,45871,45903,45909,'站北地区11号大街','12345665','18516589423','','YD','韵达快递','','余额支付','转身','123456789123456',NULL,153.90,0.00,133.90,20.00,0,0.00,0.00,153.90,1523955774,1523955870,1523956471,1523955774,NULL,0,0,0,0.00,0.00,'232332','',NULL,1,0.00,0,0),(203,'201804191504531435',3,3,0,0,'18516589423',0,0,0,0,0,'','','18516589423','','','','','',NULL,'',NULL,110.92,0.00,0.00,0.00,0,0.00,110.92,110.92,1524121493,0,0,0,NULL,3,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(83,'201804171711102334',3,3,0,1,'18516589423',0,45753,45871,45903,45909,'站北地区11号大街','12345665','18516589423','','','','','余额支付','转身','123456789123456',NULL,1399.00,0.00,1359.00,40.00,0,0.00,0.00,1399.00,1523956270,0,0,1523956270,NULL,0,0,0,0.00,0.00,'订单不能按预计时间送达','',NULL,1,0.00,0,0),(84,'201804171732185193',3,3,0,3,'18516589423',0,45753,45871,45903,45909,'站北地区11号大街','12345665','18516589423','','','','','余额支付','转身','123456789123456',NULL,125.00,0.00,25.00,0.00,1000,100.00,0.00,125.00,1523957538,0,0,1523957538,NULL,0,0,0,0.00,0.00,'其他渠道价格更低','',NULL,1,0.00,0,0),(85,'201804171745113240',3,2,1,1,'咖啡',0,45753,45871,45903,45909,'站北地区11号大街','12345665','15274851694','','shunfeng','顺丰快递','','余额支付','转身','123456789123456',NULL,318.00,0.00,288.00,30.00,0,0.00,0.00,318.00,1523958311,1523958370,1523958669,1523958311,NULL,0,0,0,0.00,0.00,'8554555','',NULL,1,0.00,0,0),(86,'201804171748245332',3,1,0,1,'18516589423',0,0,0,0,0,'','','18516589423','','','','','','','',NULL,196.00,0.00,0.00,0.00,0,0.00,196.00,196.00,1523958504,1523958549,0,1523958549,NULL,0,5,0,0.00,0.00,'','',NULL,0,0.00,0,0),(87,'201804171749405284',3,1,0,1,'18516589423',0,0,0,0,0,'','','18516589423','','','','','','','',NULL,196.00,0.00,0.00,0.00,0,0.00,196.00,196.00,1523958580,1523958611,0,1523958611,NULL,0,5,0,0.00,0.00,'32232322323','',NULL,0,0.00,0,0),(88,'201804171824596144',3,3,0,1,'18516589423',0,45753,45871,45903,45909,'站北地区11号大街','12345665','18516589423','','','','','余额支付','转身','123456789123456',NULL,636.00,0.00,445.20,0.00,0,0.00,0.00,636.00,1523960699,0,0,1523960700,NULL,0,0,3,190.80,0.00,'订单不能按预计时间送达','',NULL,1,0.00,0,0),(90,'201804180909434096',3,2,1,1,'咖啡',0,45753,45871,45903,45909,'站北地区11号大街','12345665','15274851694','','YD','韵达快递','','积分兑换','转身','123456789123456',NULL,70.00,0.00,0.00,0.00,700,70.00,0.00,70.00,1524013783,1524013871,1524013921,1524013783,NULL,0,0,0,0.00,0.00,'用心良口','',NULL,1,0.00,0,0),(91,'201804180941158584',3,0,0,1,'咖啡',0,45753,45871,45903,45909,'站北地区11号大街','12345665','15274851694','','','','','余额支付','转身','123456789123456',NULL,214.83,0.00,214.83,0.00,0,0.00,0.00,214.83,1524015675,0,0,1524015676,NULL,0,0,0,0.00,0.00,'44343434','',NULL,1,0.00,0,0),(202,'201804191448531215',9,0,0,1,'1234',0,14234,14687,14764,0,'123456789','','18515252525','','','','','余额支付',NULL,'',NULL,99.00,0.00,99.00,0.00,0,0.00,0.00,99.00,1524120533,0,0,1524120548,NULL,4,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(93,'201804180948035281',3,2,1,1,'咖啡',0,45753,45871,45903,45909,'站北地区11号大街','12345665','15274851694','','YD','韵达快递','','余额支付',NULL,'',NULL,199.00,0.00,199.00,0.00,0,0.00,0.00,199.00,1524016083,1524016637,1524016650,1524016083,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(94,'201804180950326430',3,4,1,1,'咖啡',0,45753,45871,45903,45909,'站北地区11号大街','12345665','15274851694','','YTO','圆通快递','','余额支付',NULL,'',NULL,198.00,0.00,198.00,0.00,0,0.00,0.00,198.00,1524016232,1524016263,1524016418,1524016232,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(200,'201804191445229243',5,0,0,1,'代代',0,1,2,3,0,'123456','','18516589423','','','','','余额支付',NULL,'',NULL,186.12,0.00,186.12,0.00,0,0.00,0.00,186.12,1524120322,0,0,1524120406,NULL,4,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(201,'201804191446213375',10,4,1,1,'傅慢',0,17359,18829,18949,18954,'他提供啦太可怜了','','15915407513','','shunfeng','顺丰快递','','余额支付',NULL,'',NULL,108.00,0.00,108.00,0.00,0,0.00,0.00,108.00,1524120381,1524121280,1524122331,1524120398,NULL,6,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(199,'201804191439479569',10,4,1,1,'傅慢',0,17359,18829,18949,18954,'他提供啦太可怜了','','15915407513','','shunfeng','顺丰快递','','余额支付',NULL,'',NULL,108.00,0.00,108.00,0.00,0,0.00,0.00,108.00,1524119987,1524123026,1524123224,1524122521,NULL,6,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(97,'201804181118567164',3,0,0,1,'咖啡',0,45753,45871,45903,45909,'站北地区11号大街','12345665','15274851694','','','','','余额支付','转身','123456789123456',NULL,24.00,0.00,24.00,0.00,0,0.00,0.00,24.00,1524021536,0,0,1524021536,NULL,0,0,0,0.00,0.00,'花花世界','',NULL,1,0.00,0,0),(98,'201804181121369575',3,2,1,1,'咖啡',0,45753,45871,45903,45909,'站北地区11号大街','12345665','15274851694','','YTO','圆通快递','','余额支付','个人','',NULL,3699.00,0.00,2589.30,0.00,0,0.00,0.00,3699.00,1524021696,1524021770,1524021780,1524021696,NULL,0,0,3,1109.70,0.00,'','',NULL,1,0.00,0,0),(99,'201804181131176524',3,3,0,1,'咖啡',0,45753,45871,45903,45909,'站北地区11号大街','12345665','15274851694','','','','','余额支付',NULL,'',NULL,117.00,0.00,117.00,0.00,0,0.00,0.00,117.00,1524022277,0,0,1524022277,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(100,'201804181137003556',3,3,0,1,'咖啡',0,45753,45871,45903,45909,'站北地区11号大街','12345665','15274851694','','','','','余额支付','转身','123456789123456',NULL,78.00,0.00,78.00,0.00,0,0.00,0.00,78.00,1524022620,0,0,1524022621,NULL,0,0,0,0.00,0.00,'订单不能按预计时间送达','',NULL,1,0.00,0,0),(101,'201804181137448196',3,3,0,1,'咖啡',0,45753,45871,45903,45909,'站北地区11号大街','12345665','15274851694','','','','','余额支付','转身','123456789123456',NULL,39.00,0.00,39.00,0.00,0,0.00,0.00,39.00,1524022664,0,0,1524022664,NULL,0,0,0,0.00,0.00,'订单不能按预计时间送达','',NULL,1,0.00,0,0),(102,'201804181138272876',3,3,0,1,'咖啡',0,45753,45871,45903,45909,'站北地区11号大街','12345665','15274851694','','','','','余额支付','转身','123456789123456',NULL,49.00,0.00,49.00,0.00,0,0.00,0.00,49.00,1524022707,0,0,1524022707,NULL,0,0,0,0.00,0.00,'订单不能按预计时间送达','',NULL,1,0.00,0,0),(103,'201804181142316679',3,0,0,1,'咖啡',0,45753,45871,45903,45909,'站北地区11号大街','12345665','15274851694','','','','','余额支付','转身','123456789123456',NULL,117.00,0.00,117.00,0.00,0,0.00,0.00,117.00,1524022951,0,0,1524022951,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(198,'201804191434189382',10,3,0,0,'等待',0,0,0,0,0,'','','15919919433','15825@163.com','','','','',NULL,'',NULL,108.00,0.00,0.00,0.00,0,0.00,108.00,108.00,1524119658,0,0,0,NULL,6,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(197,'201804191432481658',10,3,0,0,'等待',0,0,0,0,0,'','','15919919433','15825@163.com','','','','',NULL,'',NULL,108.00,0.00,0.00,0.00,0,0.00,108.00,108.00,1524119568,0,0,0,NULL,6,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(196,'201804191430444553',10,3,0,0,'等待',0,0,0,0,0,'','','15919919433','15825@163.com','','','','',NULL,'',NULL,108.00,0.00,0.00,0.00,0,0.00,108.00,108.00,1524119444,0,0,0,NULL,6,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(194,'201804191424252535',9,3,0,0,'nana',0,0,0,0,0,'','','15274851525','','','','','',NULL,'',NULL,99.00,0.00,0.00,0.00,0,0.00,99.00,99.00,1524119065,0,0,0,NULL,4,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(195,'201804191427531531',9,2,1,1,'1234',0,14234,14687,14764,0,'123456789','','18515252525','','YD','韵达快递','','余额支付',NULL,'',NULL,99.00,0.00,99.00,0.00,0,0.00,0.00,99.00,1524119273,1524121541,1524208101,1524119285,NULL,4,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(193,'201804191418162857',9,3,0,0,'nana',0,0,0,0,0,'','','15274851525','','','','','',NULL,'',NULL,99.00,0.00,0.00,0.00,0,0.00,99.00,99.00,1524118696,0,0,0,NULL,4,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(109,'201804181409587926',3,0,0,1,'咖啡',0,45753,45871,45903,45909,'站北地区11号大街','12345665','15274851694','','','','','余额支付',NULL,'',NULL,136.00,0.00,136.00,0.00,0,0.00,0.00,136.00,1524031798,0,0,1524031798,NULL,0,0,0,0.00,0.00,'阿里郎','',NULL,1,0.00,0,0),(192,'201804191417556837',9,3,0,0,'nana',0,0,0,0,0,'','','15274851525','','','','','',NULL,'',NULL,198.00,0.00,0.00,0.00,0,0.00,198.00,198.00,1524118675,0,0,0,NULL,4,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(111,'201804181425438341',3,0,0,1,'咖啡',0,1,2,3,4,'站北地区11号大街','12345665','15274851694','','','','','余额支付',NULL,'',NULL,117.00,18.00,135.00,0.00,0,0.00,0.00,135.00,1524032743,0,0,1524032743,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(191,'201804191417509049',9,3,0,0,'nana',0,0,0,0,0,'','','15274851525','','','','','',NULL,'',NULL,198.00,0.00,0.00,0.00,0,0.00,198.00,198.00,1524118670,0,0,0,NULL,4,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(190,'201804191411567043',5,3,0,0,'15766212618',0,0,0,0,0,'','','15766212618','','','','','',NULL,'',NULL,93.06,0.00,0.00,0.00,0,0.00,93.06,93.06,1524118316,0,0,0,NULL,4,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(189,'201804191411242135',5,3,0,0,'15766212618',0,0,0,0,0,'','','15766212618','','','','','',NULL,'',NULL,279.18,0.00,0.00,0.00,0,0.00,279.18,279.18,1524118284,0,0,0,NULL,4,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(188,'201804191410534924',2,2,1,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','','shunfeng','顺丰快递','','余额支付',NULL,'',NULL,102.60,0.00,102.60,0.00,0,0.00,0.00,102.60,1524118253,1524122375,1524123178,1524118295,NULL,6,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(187,'201804191410511642',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,102.60,0.00,0.00,0.00,0,0.00,102.60,102.60,1524118251,0,0,0,NULL,6,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(186,'201804191409571805',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,102.60,0.00,0.00,0.00,0,0.00,102.60,102.60,1524118197,0,0,0,NULL,6,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(185,'201804191408075570',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,102.60,0.00,0.00,0.00,0,0.00,102.60,102.60,1524118087,0,0,0,NULL,6,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(118,'201804181525101348',3,3,0,0,'咖啡',0,636,1188,1208,1212,'站北地区11号大街','12345665','15274851694','','','','','',NULL,'',NULL,39.80,8.00,0.00,0.00,0,0.00,47.80,47.80,1524036310,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(119,'201804181525553150',3,3,0,3,'咖啡',0,636,1188,1208,1212,'站北地区11号大街','12345665','15274851694','','','','','余额支付',NULL,'',NULL,277.30,0.00,277.30,0.00,0,0.00,0.00,277.30,1524036355,0,0,1524036355,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(120,'201804181526501415',3,3,0,0,'咖啡',0,636,1188,1208,1212,'站北地区11号大街','12345665','15274851694','','','','','',NULL,'',NULL,277.30,0.00,0.00,0.00,0,0.00,277.30,277.30,1524036410,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(121,'201804181527182903',3,3,0,0,'咖啡',0,636,1188,1208,1212,'站北地区11号大街','12345665','15274851694','','','','','',NULL,'',NULL,277.30,0.00,0.00,0.00,0,0.00,277.30,277.30,1524036438,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(122,'201804181527487192',3,0,0,1,'咖啡',0,636,1188,1208,1212,'站北地区11号大街','12345665','15274851694','','','','','余额支付',NULL,'',NULL,277.30,0.00,277.30,0.00,0,0.00,0.00,277.30,1524036468,0,0,1524036468,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(158,'201804191051162596',1,5,0,0,'小小',0,3102,3224,3225,0,'西城工业区12栋','51828482','15915407513','','','','','','个人','',NULL,2189.00,0.00,0.00,0.00,0,0.00,10.00,2189.00,1524106276,0,0,0,NULL,9,4,0,0.00,0.00,'','',NULL,0,0.00,0,0),(124,'201804181537404906',3,2,1,1,'咖啡',0,636,1188,1208,1212,'站北地区11号大街','12345665','15274851694','','YZPY','中国邮政','','',NULL,'',NULL,414.00,0.00,0.00,100.00,0,0.00,189.80,414.00,1524037060,1524047505,1524107046,1524037073,NULL,0,0,3,124.20,0.00,'','',NULL,1,0.00,0,0),(165,'201804191122523591',1,3,0,0,'小小',0,3102,3224,3225,0,'西城工业区12栋','51828482','15915407513','','','','','','个人','',NULL,25179.00,0.00,0.00,0.00,0,0.00,210.00,25179.00,1524108172,0,0,0,NULL,13,4,0,0.00,0.00,'','',NULL,0,0.00,0,0),(184,'201804191406212393',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,205.20,0.00,0.00,0.00,0,0.00,205.20,205.20,1524117982,0,0,0,NULL,6,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(128,'201804181622465608',12,2,1,1,'夏夏',0,1,2,3,0,'123456489','','15274851694','','YTO','圆通快递','','积分兑换','','',NULL,70.00,0.00,0.00,0.00,700,70.00,0.00,70.00,1524039766,1524039947,1524040091,1524039766,NULL,0,0,0,0.00,0.00,'12345678912345678912345678912334567891234123456789','',NULL,1,0.00,0,0),(183,'201804191405212235',3,4,1,1,'xiasj',0,28240,28558,28581,28582,'433434344','60025569','18516589423','','YD','韵达快递','alipayMobile','余额支付',NULL,'',NULL,186.12,0.00,20.02,0.00,1661,166.10,0.00,186.12,1524117921,1524121541,1524121718,1524118106,NULL,4,6,0,0.00,0.00,'123456789012345678901234567890','',NULL,1,0.00,0,0),(182,'201804191357255298',3,3,0,0,'咖啡',0,3102,3379,3395,3399,'站北地区11号大街','12345665','15274851694','','','','alipayMobile','手机网站支付宝',NULL,'',NULL,93.06,0.00,0.00,0.00,0,0.00,93.06,93.06,1524117445,0,0,0,NULL,4,6,0,0.00,0.00,'655456544','',NULL,1,0.00,0,0),(181,'201804191353514275',3,3,0,0,'18516589423',0,0,0,0,0,'','','18516589423','','','','','',NULL,'',NULL,166.38,0.00,0.00,0.00,0,0.00,166.38,166.38,1524117231,0,0,0,NULL,3,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(180,'201804191335536436',1,0,0,1,'小小',0,3102,3224,3225,0,'西城工业区12栋','51828482','15915407513','','','','','','个人','',NULL,1599.00,0.00,0.00,0.00,0,0.00,1599.00,1599.00,1524116153,0,0,1524116275,NULL,16,4,0,0.00,0.00,'','',NULL,0,0.00,0,0),(179,'201804191334402586',1,0,0,1,'小小',0,3102,3224,3225,0,'西城工业区12栋','51828482','15915407513','','','','','','个人','',NULL,1599.00,0.00,0.00,0.00,0,0.00,1599.00,1599.00,1524116080,0,0,1524116115,NULL,16,4,0,0.00,0.00,'','',NULL,0,0.00,0,0),(159,'201804191052081510',1,0,0,1,'小小',0,3102,3224,3225,0,'西城工业区12栋','51828482','15915407513','','','','','','个人','',NULL,2189.00,0.00,0.00,0.00,0,0.00,10.00,2189.00,1524106303,0,0,1524106774,NULL,9,4,0,0.00,0.00,'','',NULL,0,10.00,0,0),(160,'201804191053289882',1,3,0,0,'小小',0,3102,3224,3225,0,'西城工业区12栋','51828482','15915407513','','','','','','个人','',NULL,2189.00,0.00,0.00,0.00,0,0.00,10.00,2189.00,1524106408,0,0,0,NULL,9,4,0,0.00,0.00,'','',NULL,0,0.00,0,0),(161,'201804191054143461',3,0,0,2,'夏夏',0,1,2,3,30,'炫舞大厅','','15274851694','','','','','','转身','123456789123456',NULL,255.00,0.00,0.00,0.00,0,0.00,30.00,255.00,1524106418,0,0,1524106454,NULL,10,4,0,0.00,0.00,'','',NULL,0,30.00,0,0),(162,'201804191054071398',3,0,0,2,'咖啡',0,3102,3379,3395,3399,'站北地区11号大街','12345665','15274851694','','','','','','转身','123456789123456',NULL,340.00,0.00,0.00,0.00,0,0.00,40.00,340.00,1524106439,0,0,1524106447,NULL,10,4,0,0.00,0.00,'','',NULL,0,40.00,0,0),(163,'201804191103443839',1,0,0,2,'小小',0,3102,3224,3225,0,'西城工业区12栋','51828482','15915407513','','','','','','个人','',NULL,2189.00,0.00,0.00,0.00,0,0.00,2179.00,2189.00,1524106756,0,0,1524107024,NULL,9,4,0,0.00,0.00,'','',NULL,0,10.00,0,0),(166,'201804191127324926',1,0,0,2,'小小',0,3102,3224,3225,0,'西城工业区12栋','51828482','15915407513','','','','','','个人','',NULL,1199.00,0.00,0.00,0.00,0,0.00,10.00,1199.00,1524108201,0,0,1524108452,NULL,13,4,0,0.00,0.00,'','',NULL,0,10.00,0,0),(138,'201804181740351558',3,4,1,1,'咖啡',0,3102,3379,3395,3399,'站北地区11号大街','12345665','15274851694','','YD','韵达快递','','余额支付',NULL,'',NULL,100.00,0.00,100.00,0.00,0,0.00,0.00,100.00,1524044435,1524044872,1524044881,1524044435,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(178,'201804191203168721',1,0,0,2,'小小',0,3102,3224,3225,0,'西城工业区12栋','51828482','15915407513','','','','','','个人','',NULL,598.00,0.00,0.00,0.00,0,0.00,1.00,598.00,1524110578,0,0,1524110596,NULL,17,4,0,0.00,0.00,'','',NULL,0,1.00,0,0),(177,'201804191203241099',1,0,0,2,'小小',0,3102,3224,3225,0,'西城工业区12栋','51828482','15915407513','','','','','','个人','',NULL,2392.00,0.00,0.00,0.00,0,0.00,4.00,2392.00,1524110554,0,0,1524110604,NULL,17,4,0,0.00,0.00,'','',NULL,0,4.00,0,0),(176,'201804191158355668',3,3,0,0,'18516589423',0,0,0,0,0,'','','18516589423','','','','','',NULL,'',NULL,93.06,0.00,0.00,0.00,0,0.00,93.06,93.06,1524110315,0,0,0,NULL,4,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(175,'201804191142286488',3,3,0,0,'夏夏',0,1,2,3,4,'炫舞大厅112','','15274851694','','','','alipayMobile','手机网站支付宝',NULL,'',NULL,166.38,18.00,0.00,0.00,0,0.00,184.38,184.38,1524109348,0,0,0,NULL,3,6,0,0.00,0.00,'123456789012345678901234567890','',NULL,1,0.00,0,0),(174,'201804191138208593',9,3,0,0,'nana',0,0,0,0,0,'','','15274851525','','','','','',NULL,'',NULL,59.00,0.00,0.00,0.00,0,0.00,59.00,59.00,1524109100,0,0,0,NULL,3,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(164,'201804191113099998',3,0,0,1,'咖啡',0,3102,3379,3395,3399,'站北地区11号大街','12345665','15274851694','','','','','','转身','123456789123456',NULL,58.00,0.00,0.00,0.00,0,0.00,58.00,58.00,1524107589,0,0,1524107613,NULL,12,4,0,0.00,0.00,'','',NULL,0,0.00,0,0),(208,'201804191536393735',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,142.50,0.00,0.00,0.00,0,0.00,142.50,142.50,1524123399,0,0,0,NULL,5,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(173,'201804191138026765',9,3,0,0,'nana',0,0,0,0,0,'','','15274851525','','','','','',NULL,'',NULL,59.00,0.00,0.00,0.00,0,0.00,59.00,59.00,1524109082,0,0,0,NULL,3,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(170,'201804191131363872',1,2,1,1,'小小',0,3102,3224,3225,0,'西城工业区12栋','51828482','15915407513','','YTO','圆通快递','','','个人','',NULL,1199.00,0.00,0.00,0.00,0,0.00,10.00,1199.00,1524108681,1524108729,1524108766,1524108700,NULL,13,4,0,0.00,0.00,'','',NULL,0,10.00,0,0),(171,'201804191137215202',9,3,0,3,'nana',0,0,0,0,0,'','','15274851525','','','','','',NULL,'',NULL,59.00,0.00,0.00,0.00,0,0.00,59.00,59.00,1524109041,0,0,1524109773,NULL,3,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(172,'201804191137333030',9,3,0,0,'nana',0,0,0,0,0,'','','15274851525','','','','','',NULL,'',NULL,59.00,0.00,0.00,0.00,0,0.00,59.00,59.00,1524109053,0,0,0,NULL,3,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(157,'201804191038402780',1,5,0,0,'小小',0,3102,3224,3225,0,'西城工业区12栋','51828482','15915407513','','','','','','个人','',NULL,108.00,0.00,0.00,0.00,0,0.00,10.00,108.00,1524105520,0,0,0,NULL,8,4,0,0.00,0.00,'','',NULL,0,0.00,0,0),(156,'201804191038534536',1,5,0,2,'小小',0,3102,3224,3225,0,'西城工业区12栋','51828482','15915407513','','','','','','个人','',NULL,108.00,0.00,0.00,0.00,0,0.00,10.00,108.00,1524105475,0,0,1524105533,NULL,8,4,0,0.00,0.00,'','',NULL,0,10.00,0,0),(155,'201804191037058053',1,5,0,2,'小小',0,3102,3224,3225,0,'西城工业区12栋','51828482','15915407513','','','','','','个人','',NULL,108.00,0.00,0.00,0.00,0,0.00,10.00,108.00,1524105396,0,0,1524105425,NULL,8,4,0,0.00,0.00,'','',NULL,0,10.00,0,0),(169,'201804191135088117',1,2,1,1,'小小',0,3102,3224,3225,0,'西城工业区12栋','51828482','15915407513','','shunfeng','顺丰快递','','','个人','',NULL,47.00,0.00,0.00,0.00,0,0.00,37.00,47.00,1524108619,1524109891,1524196300,1524109866,NULL,14,4,0,0.00,0.00,'','',NULL,0,10.00,0,0),(262,'201804201518034699',10,3,0,0,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','15825@163.com','','','cod','到货付款','个人','',NULL,250.00,10.00,250.00,0.00,0,0.00,10.00,260.00,1524208683,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(263,'201804201519314892',2,0,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','余额支付','个人','',NULL,250.00,9.00,250.00,0.00,90,9.00,0.00,259.00,1524208771,0,0,1524208771,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(264,'201804201521024404',2,0,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','余额支付',NULL,'',NULL,49.00,0.00,49.00,0.00,0,0.00,0.00,49.00,1524208862,0,0,1524208862,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(265,'201804201525412217',10,0,0,1,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','','','','alipayMobile','余额支付',NULL,'',NULL,19.90,10.00,29.90,0.00,0,0.00,0.00,29.90,1524209141,0,0,1524209203,NULL,8,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(266,'201804201600234190',9,0,0,2,'夏夏',0,1,2,3,4,'123456786','','15274851694','','','','','','个人','',NULL,80.00,0.00,0.00,0.00,0,0.00,60.00,80.00,1524211214,0,0,1524211223,NULL,20,4,0,0.00,0.00,'','',NULL,0,20.00,0,0),(267,'201804201601104633',9,2,1,1,'夏夏',0,1,2,3,4,'123456786','','15274851694','','YTO','圆通快递','','','来日方长','123456789123456',NULL,120.00,0.00,0.00,0.00,0,0.00,90.00,120.00,1524211259,1524214354,1524214419,1524213835,NULL,20,4,0,0.00,0.00,'','',NULL,0,30.00,0,0),(268,'201804201602569047',9,2,1,1,'夏夏',0,1,2,3,4,'123456786','','15274851694','','YD','韵达快递','tenpay','PC端财付通','来日方长','123456789123456',NULL,120.00,0.00,0.00,0.00,0,0.00,90.00,120.00,1524211359,1524213941,1524213956,1524213821,NULL,20,4,0,0.00,0.00,'','',NULL,0,30.00,0,0),(269,'201804201614008080',9,5,0,2,'trrr',0,10543,10544,10560,10567,'这是上海地区','','18516589423','','','','','','来日方长','123456789123456',NULL,178.00,0.00,0.00,0.00,0,0.00,20.00,178.00,1524211868,0,0,1524212040,NULL,21,4,0,0.00,0.00,'','',NULL,0,20.00,0,0),(270,'201804201622089747',9,5,0,2,'trrr',0,10543,10544,10560,10567,'这是上海地区','','18516589423','','','','','','来日方长','123456789123456',NULL,178.00,0.00,0.00,0.00,0,0.00,20.00,178.00,1524212225,0,0,1524212528,NULL,21,4,0,0.00,0.00,'','',NULL,0,20.00,0,0),(273,'201804201621437253',10,3,0,0,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','15825@163.com','','','cod','到货付款','个人','',NULL,1580.00,0.00,0.00,0.00,0,0.00,1106.00,1580.00,1524212503,0,0,0,NULL,0,0,3,474.00,0.00,'','',NULL,1,0.00,0,0),(272,'201804201621099183',9,5,0,2,'夏夏',0,1,2,3,4,'123456786','','15274851694','','','','','','个人','',NULL,178.00,0.00,0.00,0.00,0,0.00,20.00,178.00,1524212454,0,0,1524212469,NULL,21,4,0,0.00,0.00,'','',NULL,0,20.00,0,0),(274,'201804201622259675',10,4,1,1,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','15825@163.com','YTO','圆通快递','cod','到货付款','个人','',NULL,76.00,10.00,0.00,0.00,0,0.00,86.00,86.00,1524212545,1524213362,1524213412,1524213412,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(281,'201804201646015747',10,0,0,1,'等待',0,0,0,0,0,'','','15919919433','','','','cod','到货付款','','',NULL,9.90,0.00,0.00,0.00,0,0.00,9.90,9.90,1524213961,1546272000,0,1524214224,NULL,0,5,0,0.00,0.00,'你好你好你后多个虚拟服务类商品订单凭借电子兑换码验证消费虚拟服务类商品订单凭借电子兑换码验证消费虚拟服务类商品订单凭借电子兑换码验证消费虚拟服务类商品订单凭借电子兑换码验证消费虚拟服务类商品订单凭借电子兑换码验证消费','',NULL,0,0.00,0,0),(276,'201804201626314342',10,4,1,1,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','15825@163.com','shunfeng','顺丰快递','cod','到货付款','个人','',NULL,250.00,10.00,0.00,0.00,0,0.00,260.00,260.00,1524212791,1524212921,1524213263,1524213263,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(277,'201804201627427860',10,0,0,1,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','15825@163.com','','','','余额支付','个人','',NULL,76.00,10.00,86.00,0.00,0,0.00,0.00,86.00,1524212862,0,0,1524212862,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(278,'201804201627459371',9,0,0,0,'nana',0,0,0,0,0,'','','15274851525','','','','','',NULL,'',NULL,70.00,0.00,0.00,0.00,0,0.00,70.00,70.00,1524212865,0,0,0,NULL,10,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(279,'201804201628096747',9,0,0,0,'nana',0,0,0,0,0,'','','15274851525','','','','','',NULL,'',NULL,79.80,0.00,0.00,0.00,0,0.00,79.80,79.80,1524212889,0,0,0,NULL,11,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(280,'201804201629172125',9,0,0,0,'夏夏',0,1,2,3,4,'123456786','','15274851694','','','','','余额支付',NULL,'',NULL,108.00,0.00,108.00,0.00,0,0.00,0.00,108.00,1524212957,0,0,1524212957,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(282,'201804201650492893',10,0,0,1,'等待',0,0,0,0,0,'','','15919919433','','','','alipay','PC端支付宝','','',NULL,9.90,0.00,0.00,0.00,0,0.00,9.90,9.90,1524214249,1546272000,0,1524214263,NULL,0,5,0,0.00,0.00,'','',NULL,0,0.00,0,0),(283,'201804201653576566',10,0,0,1,'等待',0,0,0,0,0,'','','15919919433','','','','unionpay','银联在线支付','','',NULL,9.90,0.00,0.00,0.00,0,0.00,9.90,9.90,1524214437,1546272000,0,1524214460,NULL,0,5,0,0.00,0.00,'','',NULL,0,0.00,0,0),(284,'201804201717287328',10,3,0,0,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','15825@163.com','','','','','个人','',NULL,49.00,0.00,0.00,0.00,0,0.00,49.00,49.00,1524215848,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(285,'201804201719159411',10,3,0,0,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','15825@163.com','','','','','个人','',NULL,250.00,10.00,0.00,0.00,0,0.00,260.00,260.00,1524215955,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(286,'201804201720027469',10,0,0,1,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','15825@163.com','','','','余额支付','个人','',NULL,250.00,10.00,260.00,0.00,0,0.00,0.00,260.00,1524216002,0,0,1524216002,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(287,'201804201720037606',10,0,0,1,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','15825@163.com','','','','余额支付','个人','',NULL,250.00,10.00,260.00,0.00,0,0.00,0.00,260.00,1524216003,0,0,1524216003,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(288,'201804201723132286',10,3,0,0,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','15825@163.com','','','','余额支付','拉锯','2528',NULL,759.00,0.00,531.30,0.00,0,0.00,0.00,759.00,1524216193,0,0,1524216764,NULL,0,0,3,227.70,0.00,'','',NULL,1,0.00,0,0),(289,'201804201729316760',10,5,0,1,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','15825@163.com','','','','','个人','',NULL,759.00,0.00,0.00,0.00,0,0.00,531.30,759.00,1524216571,0,0,1524216640,NULL,0,0,3,227.70,0.00,'','',NULL,1,0.00,0,0),(290,'201804201746219647',10,3,0,0,'等待',0,0,0,0,0,'','','15919919433','15825@163.com','','','','',NULL,'',NULL,495.00,0.00,0.00,0.00,0,0.00,495.00,495.00,1524217581,0,0,0,NULL,13,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(291,'201804201746218516',10,3,0,0,'等待',0,0,0,0,0,'','','15919919433','15825@163.com','','','','',NULL,'',NULL,495.00,0.00,0.00,0.00,0,0.00,495.00,495.00,1524217581,0,0,0,NULL,13,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(292,'201804201746216394',10,3,0,0,'等待',0,0,0,0,0,'','','15919919433','15825@163.com','','','','',NULL,'',NULL,495.00,0.00,0.00,0.00,0,0.00,495.00,495.00,1524217581,0,0,0,NULL,13,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(293,'201804201746229896',10,3,0,0,'等待',0,0,0,0,0,'','','15919919433','15825@163.com','','','','',NULL,'',NULL,495.00,0.00,0.00,0.00,0,0.00,495.00,495.00,1524217582,0,0,0,NULL,13,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(294,'201804201746226264',10,3,0,0,'等待',0,0,0,0,0,'','','15919919433','15825@163.com','','','','',NULL,'',NULL,495.00,0.00,0.00,0.00,0,0.00,495.00,495.00,1524217582,0,0,0,NULL,13,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(295,'201804201746224967',10,3,0,0,'等待',0,0,0,0,0,'','','15919919433','15825@163.com','','','','',NULL,'',NULL,495.00,0.00,0.00,0.00,0,0.00,495.00,495.00,1524217582,0,0,0,NULL,13,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(296,'201804201746328746',10,1,0,1,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','','','','','余额支付',NULL,'',NULL,495.00,10.00,505.00,0.00,0,0.00,0.00,505.00,1524217592,0,0,1524217615,NULL,13,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(297,'201804201750463182',2,1,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','','','','','余额支付',NULL,'',NULL,475.00,9.00,484.00,0.00,0,0.00,0.00,484.00,1524217846,0,0,1524217872,NULL,13,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(298,'201804201756461015',10,2,1,1,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','','YTO','圆通快递','','余额支付',NULL,'',NULL,495.00,10.00,505.00,0.00,0,0.00,0.00,505.00,1524218206,1524218568,1524420323,1524218242,NULL,13,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(299,'201804201759055459',2,4,1,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','','shunfeng','顺丰快递','','余额支付',NULL,'',NULL,475.00,9.00,484.00,0.00,0,0.00,0.00,484.00,1524218345,1524218541,1524218598,1524218364,NULL,13,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(300,'201804201759546334',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,475.00,0.00,0.00,0.00,0,0.00,475.00,475.00,1524218394,0,0,0,NULL,13,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(301,'201804230923266319',3,3,0,0,'咖啡',0,3102,3379,3395,3399,'站北地区11号大街','12345665','15274851694','','','','cod','到货付款','转身','123456789123456',NULL,1580.00,0.00,0.00,0.00,0,0.00,1106.00,1580.00,1524446606,0,0,0,NULL,0,0,3,474.00,0.00,'11111111111111111111111111111111111111111111111111','',NULL,1,0.00,0,0),(302,'201804230926287100',3,0,0,1,'咖啡',0,3102,3379,3395,3399,'站北地区11号大街','12345665','15274851694','','','','','积分兑换','转身','123456789123456',NULL,35.00,0.00,0.00,0.00,350,35.00,0.00,35.00,1524446788,0,0,1524446788,NULL,0,0,0,0.00,0.00,'85534343434343434343434343434343434343434343434343','',NULL,1,0.00,0,0),(303,'201804230933006106',3,3,0,0,'青春',0,0,0,0,0,'','','15274851694','','','','','','','',NULL,168.00,0.00,0.00,0.00,0,0.00,168.00,168.00,1524447180,1526745600,0,0,NULL,0,5,0,0.00,0.00,'您本次购买的商品不需要收货地址','',NULL,0,0.00,0,0),(304,'201804230957475502',10,1,0,1,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','','','','','','个人','',NULL,158.00,0.00,0.00,0.00,0,0.00,10.00,158.00,1524448643,0,0,1524448673,NULL,22,4,0,0.00,0.00,'','',NULL,0,10.00,0,0),(305,'201804231015463793',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,190.00,0.00,0.00,0.00,0,0.00,190.00,190.00,1524449746,0,0,0,NULL,14,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(306,'201804231016271973',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,190.00,0.00,0.00,0.00,0,0.00,190.00,190.00,1524449787,0,0,0,NULL,14,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(307,'201804231017098339',2,1,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','','','','','余额支付',NULL,'',NULL,190.00,8.00,198.00,0.00,0,0.00,0.00,198.00,1524449829,0,0,1524449918,NULL,14,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(308,'201804231019529851',10,1,0,1,'XIAO',0,636,936,952,0,'SKFHKSHFKSF','','15919919433','','','','','余额支付',NULL,'',NULL,198.00,8.00,190.00,0.00,160,16.00,0.00,206.00,1524449992,0,0,1524450120,NULL,14,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(309,'201804231025331576',10,3,0,0,'等待',0,0,0,0,0,'','','15919919433','15825@163.com','','','','',NULL,'',NULL,198.00,0.00,0.00,0.00,0,0.00,198.00,198.00,1524450333,0,0,0,NULL,15,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(310,'201804231029569503',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,198.00,0.00,0.00,0.00,0,0.00,198.00,198.00,1524450596,0,0,0,NULL,15,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(311,'201804231029584101',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,198.00,0.00,0.00,0.00,0,0.00,198.00,198.00,1524450598,0,0,0,NULL,15,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(312,'201804231030524150',2,1,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','','','','','余额支付',NULL,'',NULL,594.00,8.00,602.00,0.00,0,0.00,0.00,602.00,1524450652,0,0,1524450692,NULL,14,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(313,'201804231032302189',10,1,0,1,'XIAO',0,636,936,952,0,'SKFHKSHFKSF','','15919919433','','','','','余额支付',NULL,'',NULL,396.00,8.00,404.00,0.00,0,0.00,0.00,404.00,1524450750,0,0,1524450778,NULL,14,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(314,'201804231051078308',2,0,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','余额支付','个人','',NULL,39.00,10.00,44.00,0.00,50,5.00,0.00,49.00,1524451867,0,0,1524451867,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(315,'201804231057135002',10,2,1,1,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','15825@163.com','shunfeng','顺丰快递','cod','到货付款','个人','',NULL,351.00,55.00,352.00,0.00,0,0.00,54.00,406.00,1524452233,1524462021,1524462078,1524462078,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(316,'201804231119409851',2,3,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','余额支付','个人','',NULL,250.00,0.00,50.00,0.00,2000,200.00,0.00,250.00,1524453580,0,0,1524453580,NULL,0,0,0,0.00,0.00,'操作有误(商品、地址等选错)','',NULL,1,0.00,0,0),(317,'201804231125338576',10,1,0,1,'XIAO',0,636,936,952,0,'SKFHKSHFKSF','','15919919433','15825@163.com','','','','余额支付','个人','',NULL,125.00,0.00,25.00,0.00,1000,100.00,0.00,125.00,1524453933,0,0,1524453933,NULL,0,0,0,0.00,0.00,'DGDGDSSSDDFG','',NULL,1,0.00,0,0),(318,'201804231131468119',10,0,0,1,'XIAO',0,636,936,952,0,'SKFHKSHFKSF','','15919919433','15825@163.com','','','','余额支付','个人','',NULL,125.00,0.00,25.00,0.00,1000,100.00,0.00,125.00,1524454306,0,0,1524454306,NULL,0,0,0,0.00,0.00,'DGDGDSSSDDFG','',NULL,1,0.00,0,0),(319,'201804231144312290',3,0,0,1,'咖啡',0,5827,6476,6488,6492,'站北地区11号大街12号','12345665','15274851694','','','','','','89999','123456789123456',NULL,356.00,0.00,0.00,0.00,0,0.00,356.00,356.00,1524455071,0,0,1524455265,NULL,23,4,0,0.00,0.00,'','',NULL,0,0.00,0,0),(320,'201804231147305805',10,4,0,1,'等待',0,0,0,0,0,'','','15919919433','','','','alipayMobile','手机网站支付宝','','',NULL,9.90,0.00,0.00,0.00,0,0.00,9.90,9.90,1524455250,1524455300,1524455331,1524455300,NULL,0,5,0,0.00,0.00,'','',NULL,0,0.00,0,0),(321,'201804231149132156',3,0,0,1,'罗华',0,7531,7986,8008,8009,'34343434334','600','18515453456','','','','','','89999','123456789123456',NULL,267.00,0.00,0.00,0.00,0,0.00,267.00,267.00,1524455353,0,0,1524455370,NULL,23,4,0,0.00,0.00,'','',NULL,0,0.00,0,0),(322,'201804231154111447',3,3,0,0,'华晨宇',0,7531,7706,7708,7717,'1233455','60025536','18516589423','','','','','','个人','',NULL,207.00,0.00,0.00,0.00,0,0.00,207.00,207.00,1524455651,0,0,0,NULL,23,4,0,0.00,0.00,'','',NULL,0,0.00,0,0),(323,'201804231156477263',10,2,1,1,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','15825@163.com','YD','韵达快递','','余额支付','个人','',NULL,39.00,10.00,25.00,0.00,240,24.00,0.00,49.00,1524455807,1524456047,1524456078,1524455807,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(324,'201804231159562431',3,0,0,1,'咖啡',0,5827,6476,6488,6492,'站北地区11号大街12号','12345665','15274851694','','','','','余额支付','个人','',NULL,216.00,0.00,201.00,15.00,0,0.00,0.00,216.00,1524455996,0,0,1524455996,NULL,0,0,0,0.00,0.00,'343343434','',NULL,1,0.00,0,0),(325,'201804231345569849',10,2,1,1,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','15825@163.com','shunfeng','顺丰快递','','余额支付','个人','',NULL,100.00,0.00,100.00,0.00,0,0.00,0.00,100.00,1524462356,1524462854,1524464008,1524462818,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(326,'201804231356386989',10,4,0,1,'等待',0,0,0,0,0,'','','15919919433','','','','','','','',NULL,9.90,0.00,0.00,0.00,0,0.00,9.90,9.90,1524462998,1524463018,1524466507,1524463018,NULL,0,5,0,0.00,0.00,'','',NULL,0,0.00,0,0),(327,'201804231429051062',10,2,1,1,'方法',0,28240,28558,28590,0,'西城工业区12栋','582','15915407513','15825@163.com','shunfeng','顺丰快递','','余额支付','个人','',NULL,59.00,0.00,59.00,0.00,0,0.00,0.00,59.00,1524464945,1524465065,1524466606,1524464946,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(328,'201804231449297833',10,1,0,1,'小红帽',0,28240,28558,28590,28591,'西乡西城工业区12栋','18282058','15915407513','15825@163.com','','','','余额支付','','',NULL,10.00,0.00,10.00,0.00,0,0.00,0.00,10.00,1524466169,0,0,1524466169,NULL,0,0,0,0.00,0.00,'jsgkflhslkghslkfoidujslgjlskjgdskjlgs','',NULL,1,0.00,0,0),(329,'201804231453528829',3,4,1,1,'咖啡',0,5827,6476,6488,6492,'站北地区11号大街12号','12345665','15274851694','','YTO','圆通快递','','余额支付','个人','',NULL,317.72,0.00,317.72,0.00,0,0.00,0.00,317.72,1524466432,1524466496,1524466508,1524466432,NULL,0,0,0,0.00,0.00,'11111111111111111111111111111111111111111111111111','',NULL,1,0.00,0,0),(330,'201804231503544313',10,3,0,0,'XIAO',0,636,936,952,0,'SKFHKSHFKSF','','15919919433','','','','','余额支付',NULL,'',NULL,54.52,8.00,59.00,0.00,35,3.50,0.02,62.52,1524467034,0,0,0,NULL,17,6,0,0.00,0.00,'ggfyffhhf','',NULL,1,0.00,0,0),(331,'201804231505202616',10,3,0,0,'等待',0,0,0,0,0,'','','15919919433','15825@163.com','','','','',NULL,'',NULL,27.26,0.00,0.00,0.00,0,0.00,27.26,27.26,1524467120,0,0,0,NULL,17,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(332,'201804231505454729',10,3,0,0,'等待',0,0,0,0,0,'','','15919919433','15825@163.com','','','','',NULL,'',NULL,27.26,0.00,0.00,0.00,0,0.00,27.26,27.26,1524467145,0,0,0,NULL,17,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(333,'201804231506238774',10,3,0,0,'等待',0,0,0,0,0,'','','15919919433','15825@163.com','','','','',NULL,'',NULL,27.26,0.00,0.00,0.00,0,0.00,27.26,27.26,1524467183,0,0,0,NULL,17,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(334,'201804231506496492',10,3,0,0,'等待',0,0,0,0,0,'','','15919919433','15825@163.com','','','','',NULL,'',NULL,470.00,0.00,0.00,0.00,0,0.00,470.00,470.00,1524467209,0,0,0,NULL,13,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(335,'201804231510394474',10,0,0,1,'XIAO',0,636,936,952,0,'SKFHKSHFKSF','','15919919433','15825@163.com','','','','余额支付','个人','',NULL,59.00,8.00,67.00,0.00,0,0.00,0.00,67.00,1524467439,0,0,1524467439,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(336,'201804231517577007',10,3,0,0,'dfds',0,28240,28241,28243,28244,'dgdgdg','85582','15915407513','','','','','','','',NULL,1276.00,0.00,0.00,0.00,0,0.00,1276.00,1276.00,1524467877,0,0,0,NULL,24,4,0,0.00,0.00,'','',NULL,0,0.00,0,0),(337,'201804231539513010',10,3,0,0,'等待dgdgdfgdfgdfhdfhdfhfdhdfh',0,0,0,0,0,'','','15919919433','1522585@qq.com','','','','',NULL,'',NULL,101.52,0.00,0.00,0.00,0,0.00,101.52,101.52,1524469191,0,0,0,NULL,6,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(338,'201804231546346994',10,2,1,1,'dfds',0,28240,28241,28243,28244,'dgdgdg','85582','15915407513','1522585@qq.com','YTO','圆通快递','cod','到货付款','','',NULL,83.66,0.00,0.00,0.00,0,0.00,83.66,83.66,1524469594,1524469647,1524469684,1524469684,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(339,'201804231553396775',10,0,0,1,'XIAO',0,636,936,952,0,'SKFHKSHFKSF','','15919919433','1522585@qq.com','','','','余额支付','','',NULL,10.00,0.00,10.00,0.00,0,0.00,0.00,10.00,1524470019,0,0,1524470019,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(340,'201804231559531419',10,0,0,1,'XIAO',0,636,936,952,0,'SKFHKSHFKSF','','15919919433','1522585@qq.com','','','','余额支付','','',NULL,32.40,10.00,42.40,0.00,0,0.00,0.00,42.40,1524470393,0,0,1524470394,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(341,'201804231621586676',10,0,0,1,'XIAO',0,636,936,952,0,'SKFHKSHFKSF','','15919919433','1522585@qq.com','','','','余额支付','','',NULL,398.00,0.00,378.00,20.00,0,0.00,0.00,398.00,1524471718,0,0,1524471718,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(342,'201804231629437863',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','123456@qq.com','','','','',NULL,'',NULL,1069.20,0.00,0.00,0.00,0,0.00,1069.20,1069.20,1524472183,0,0,0,NULL,6,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(343,'201804241113433323',3,0,0,2,'华晨宇',0,7531,7706,7708,7717,'1233455','60025536','18516589423','','','','','','没忘a','123456789123455',NULL,178.00,0.00,0.00,0.00,0,0.00,40.00,178.00,1524539592,0,0,1524539623,NULL,25,4,0,0.00,0.00,'','',NULL,0,40.00,0,0),(344,'201804241119028560',3,0,0,1,'咖啡',0,5827,6476,6488,6492,'站北地区11号大街12号','12345665','15274851694','','','','','余额支付','没忘a','123456789123455',NULL,250.98,0.00,250.98,0.00,0,0.00,0.00,250.98,1524539942,0,0,1524539942,NULL,0,0,0,0.00,0.00,'8554411113443','',NULL,1,0.00,0,0),(345,'201804241122111765',3,0,0,1,'咖啡',0,5827,6476,6488,6492,'站北地区11号大街12号','12345665','15274851694','','','','','余额支付','没忘a','123456789123455',NULL,250.98,0.00,250.98,0.00,0,0.00,0.00,250.98,1524540131,0,0,1524540131,NULL,0,0,0,0.00,0.00,'1234455','',NULL,1,0.00,0,0),(346,'201804241127174962',3,0,0,1,'咖啡',0,5827,6476,6488,6492,'站北地区11号大街12号','12345665','15274851694','','','','','余额支付','没忘a','123456789123455',NULL,366.60,0.00,366.60,0.00,0,0.00,0.00,366.60,1524540437,0,0,1524540437,NULL,0,0,0,0.00,0.00,'85555555555','',NULL,1,0.00,0,0),(347,'201804241133207290',5,0,0,1,'代代',0,1,2,3,0,'123456','','18516589423','','','','','余额支付','','',NULL,250.98,0.00,250.98,0.00,0,0.00,0.00,250.98,1524540800,0,0,1524540800,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(348,'201804241140327904',5,0,0,1,'代代',0,1,2,3,0,'123456','','18516589423','','','','','余额支付','','',NULL,83.66,0.00,83.66,0.00,0,0.00,0.00,83.66,1524541232,0,0,1524541232,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(349,'201804241144229148',5,0,0,1,'代代',0,1,2,3,0,'123456','','18516589423','','','','','余额支付','','',NULL,83.66,0.00,83.66,0.00,0,0.00,0.00,83.66,1524541462,0,0,1524541462,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(350,'201804241148157916',5,0,0,1,'代代',0,1,2,3,0,'123456','','18516589423','','','','','余额支付','','',NULL,83.66,0.00,83.66,0.00,0,0.00,0.00,83.66,1524541695,0,0,1524541695,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(351,'201804241150159981',2,2,1,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','shunfeng','顺丰快递','','余额支付','个人','',NULL,168.00,9.00,177.00,0.00,0,0.00,0.00,177.00,1524541815,1524541870,1524541916,1524541815,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(352,'201804241156489468',3,0,0,2,'罗华',0,7531,7986,8008,8009,'34343434334','600','18515453456','','','','','','没忘a','123456789123455',NULL,178.00,0.00,0.00,0.00,0,0.00,40.00,178.00,1524542170,0,0,1524542208,NULL,25,4,0,0.00,0.00,'','',NULL,0,40.00,0,0),(353,'201804241202315315',1,1,1,0,'25825',0,1,2,14,NULL,'28582','28582','15915407513282','15915407513@163.com','zhongtong','中通快递','cod','到货付款','FUMAN','282828282',NULL,2280.00,19.00,0.00,0.00,0,0.00,1615.00,2299.00,1524542551,1524548549,0,0,NULL,0,0,3,684.00,0.00,'','',NULL,1,0.00,0,0),(354,'201804241337157707',2,3,0,1,'15915407513',0,24022,24453,24471,24475,'站北地区11号大街','12345678','15915407513','123456@qq.com','','','','余额支付','个人','',NULL,186.00,10.00,196.00,0.00,0,0.00,0.00,196.00,1524548235,0,0,1524548235,NULL,0,0,0,0.00,0.00,'重复下单/误下单','',NULL,1,0.00,0,0),(355,'201804241401525238',3,3,0,1,'华晨宇',0,7531,7706,7708,7717,'1233455','60025536','18516589423','','','','','余额支付','网络科技','123456789123455',NULL,216.00,0.00,216.00,0.00,0,0.00,0.00,216.00,1524549712,0,0,1524549712,NULL,0,0,0,0.00,0.00,'其他渠道价格更低','',NULL,1,0.00,0,0),(356,'201804241451186379',3,4,1,1,'华晨宇',0,7531,7706,7708,7717,'1233455','60025536','18516589423','','YZPY','中国邮政','','余额支付','网络科技','123456789123455',NULL,102.37,0.00,102.37,0.00,0,0.00,0.00,102.37,1524552678,1524553154,1524553215,1524552678,NULL,0,0,0,0.00,0.00,'12334444444444444444444444444444444444444444444444','',NULL,1,0.00,0,0),(357,'201804241507495471',3,2,1,1,'罗华',0,7531,7986,8008,8009,'34343434334','600','18515453456','','zhongtong','中通快递','','余额支付','网络科技','123456789123455',NULL,199.19,0.00,199.19,0.00,0,0.00,0.00,199.19,1524553669,1524553721,1524553753,1524553669,NULL,0,0,0,0.00,0.00,'434343434','',NULL,1,0.00,0,0),(358,'201804241541069985',2,5,1,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','shunfeng','顺丰快递','','余额支付','个人','',NULL,285.00,9.00,294.00,0.00,0,0.00,0.00,294.00,1524555666,1524555692,0,1524555667,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(359,'201804241542003139',17,2,1,1,'夏夏',0,1,2,14,15,'124547785555666','','15274851694','','zhongtong','顺丰快递','','余额支付',NULL,'',NULL,159.50,13.00,172.50,0.00,0,0.00,0.00,172.50,1524555720,1524555887,1524555904,1524555720,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(360,'201804241558554559',2,3,0,1,'15915407513',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','余额支付','个人','',NULL,82.72,0.00,82.72,0.00,0,0.00,0.00,82.72,1524556735,0,0,1524556735,NULL,0,0,0,0.00,0.00,'重复下单/误下单','',NULL,1,0.00,0,0),(361,'201804241606516695',2,3,0,0,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','','个人','',NULL,82.72,0.00,0.00,0.00,0,0.00,82.72,82.72,1524557211,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(362,'201804241625433279',3,0,0,1,'咖啡',0,5827,6476,6488,6492,'站北地区11号大街12号','12345665','15274851694','','','','','余额支付','网络科技','123456789123455',NULL,29.90,10.00,39.90,0.00,0,0.00,0.00,39.90,1524558343,0,0,1524558343,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(363,'201804241626455164',3,0,0,1,'咖啡',0,5827,6476,6488,6492,'站北地区11号大街12号','12345665','15274851694','','','','','余额支付','网络科技','123456789123455',NULL,59.80,10.00,69.80,0.00,0,0.00,0.00,69.80,1524558405,0,0,1524558405,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(364,'201804241628587011',3,2,1,1,'咖啡',0,5827,6476,6488,6492,'站北地区11号大街12号','12345665','15274851694','','YTO','圆通快递','','余额支付','网络科技','123456789123455',NULL,59.80,10.00,69.80,0.00,0,0.00,0.00,69.80,1524558538,1524558608,1524558744,1524558538,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(365,'201804241634228009',3,0,0,1,'咖啡',0,5827,6476,6488,6492,'站北地区11号大街12号','12345665','15274851694','','','','','积分兑换','网络科技','123456789123455',NULL,59.80,10.00,0.00,0.00,698,69.80,0.00,69.80,1524558862,0,0,1524558863,NULL,0,0,0,0.00,0.00,'855448555','',NULL,1,0.00,0,0),(366,'201804241657051851',2,5,0,0,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','','个人','',NULL,939.99,0.00,0.00,0.00,0,0.00,657.99,939.99,1524560225,0,0,0,NULL,0,0,3,282.00,0.00,'','',NULL,1,0.00,0,0),(367,'201804241706123432',2,3,0,0,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','','个人','',NULL,278.24,0.00,0.00,0.00,0,0.00,278.24,278.24,1524560772,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(368,'201804241724048340',3,0,0,1,'青春',0,0,0,0,0,'','','18516589423','','','','','','','',NULL,196.00,0.00,0.00,0.00,0,0.00,196.00,196.00,1524561844,1526745600,0,1524562025,NULL,0,5,0,0.00,0.00,'18516589423','',NULL,0,0.00,0,0),(369,'201804241725527037',2,5,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','余额支付','个人','',NULL,281.06,0.00,281.06,0.00,0,0.00,0.00,281.06,1524561952,0,0,1524561952,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(370,'201804241728517701',2,3,0,1,'15915407513',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','','个人','',NULL,281.06,0.00,0.00,0.00,0,0.00,281.06,281.06,1524562131,0,0,1524562533,NULL,0,0,0,0.00,0.00,'重复下单/误下单','',NULL,1,0.00,0,0),(371,'201804241729165470',3,0,0,1,'青春',0,0,0,0,0,'','','18516589423','','','','','','','',NULL,112.00,0.00,0.00,0.00,0,0.00,112.00,112.00,1524562156,1526745600,0,1524562190,NULL,0,5,0,0.00,0.00,'3434','',NULL,0,0.00,0,0),(372,'201804241731477798',17,0,0,1,'15247471414',0,0,0,0,0,'','','15247471414','','','','weixinH5','微信支付','','',NULL,294.00,0.00,0.00,0.00,0,0.00,294.00,294.00,1524562307,1526745600,0,1524562498,NULL,0,5,0,0.00,0.00,'152474714141524747141415247471414152474714141524747141415247471414152474714141524747141415247471414152474714141524747141415247471414152474714141524747','',NULL,0,0.00,0,0),(373,'201804241746187580',17,0,0,1,'夏夏',0,1,2,14,15,'124547785555666','','15274851694','','','','','余额支付','个人','',NULL,82.80,0.00,82.80,0.00,0,0.00,0.00,82.80,1524563178,0,0,1524563178,NULL,0,0,0,0.00,0.00,'3322323323223','',NULL,1,0.00,0,0),(374,'201804241759121896',2,3,0,0,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','','个人','',NULL,939.06,0.00,0.00,0.00,0,0.00,657.34,939.06,1524563952,0,0,0,NULL,0,0,3,281.72,0.00,'','',NULL,1,0.00,0,0),(375,'201804241800505493',2,5,0,0,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','','个人','',NULL,939.06,0.00,0.00,0.00,0,0.00,657.34,939.06,1524564050,0,0,0,NULL,0,0,3,281.72,0.00,'','',NULL,1,0.00,0,0),(376,'201804241812107506',2,5,0,0,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','','个人','',NULL,130.66,9.00,0.00,0.00,0,0.00,139.66,139.66,1524564730,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(377,'201804241813469255',2,3,0,0,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','','个人','',NULL,130.66,9.00,0.00,0.00,0,0.00,139.66,139.66,1524564826,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(378,'201804241817302207',2,5,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','余额支付','个人','',NULL,130.66,9.00,139.66,0.00,0,0.00,0.00,139.66,1524565050,0,0,1524565051,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(379,'201804241821105259',2,3,0,1,'15915407513',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','','个人','',NULL,93.06,0.00,0.00,0.00,0,0.00,93.06,93.06,1524565270,0,0,1524565330,NULL,0,0,0,0.00,0.00,'操作有误（商品、地址等选错）','',NULL,1,0.00,0,0),(380,'201804241824409829',3,3,0,0,'咖啡',0,5827,6476,6488,6492,'站北地区11号大街12号','12345665','15274851694','','','','','','网络科技','123456789123455',NULL,794.30,0.00,0.00,0.00,0,0.00,556.01,794.30,1524565480,0,0,0,NULL,0,0,3,238.29,0.00,'','',NULL,1,0.00,0,0),(381,'201804241825178412',3,3,0,0,'咖啡',0,5827,6476,6488,6492,'站北地区11号大街12号','12345665','15274851694','','','','','','网络科技','123456789123455',NULL,794.30,0.00,0.00,0.00,0,0.00,556.01,794.30,1524565517,0,0,0,NULL,0,0,3,238.29,0.00,'','',NULL,1,0.00,0,0),(382,'201804241828059511',3,3,0,0,'咖啡',0,1,2,14,17,'站北地区11号大街12号','12345665','15274851694','','','','','','网络科技','123456789123455',NULL,245.34,8.00,0.00,0.00,0,0.00,253.34,253.34,1524565685,0,0,0,NULL,0,0,0,0.00,0.00,'3443','',NULL,1,0.00,0,0),(383,'201804241829315849',2,3,0,0,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','','个人','',NULL,32.90,0.00,0.00,0.00,0,0.00,32.90,32.90,1524565771,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(384,'201804241832326381',2,5,0,0,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','','个人','',NULL,32.90,0.00,0.00,0.00,0,0.00,32.90,32.90,1524565952,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(385,'201804241834014819',2,3,0,0,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','','个人','',NULL,186.12,0.00,0.00,0.00,0,0.00,186.12,186.12,1524566041,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(386,'201804241835097272',2,5,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','','个人','',NULL,186.12,0.00,0.00,0.00,0,0.00,186.12,186.12,1524566109,0,0,1524566156,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(387,'201804241838496183',2,3,0,1,'15915407513',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','余额支付','个人','',NULL,186.12,0.00,186.12,0.00,0,0.00,0.00,186.12,1524566329,0,0,1524566329,NULL,0,0,0,0.00,0.00,'订单不能按预计时间送达','',NULL,1,0.00,0,0),(388,'201804250852158739',3,2,1,1,'咖啡',0,1,2,14,17,'站北地区11号大街12号','12345665','15274851694','','YTO','圆通快递','','余额支付','网络科技','123456789123455',NULL,163.56,8.00,0.06,0.00,1715,171.50,0.00,171.56,1524617535,1524617640,1524617657,1524617536,NULL,0,0,0,0.00,0.00,'23232323','',NULL,1,0.00,0,0),(389,'201804250932188377',3,5,0,1,'咖啡',0,1,2,14,17,'站北地区11号大街12号','12345665','15274851694','','','','','余额支付','网络科技','123456789123455',NULL,70.05,0.00,70.05,0.00,0,0.00,0.00,70.05,1524619938,0,0,1524619938,NULL,0,0,0,0.00,0.00,'123444','',NULL,1,0.00,0,0),(390,'201804251201591732',3,5,0,1,'咖啡',0,1,2,14,17,'站北地区11号大街12号','12345665','15274851694','','','','','余额支付','网络科技','123456789123455',NULL,70.05,0.00,70.05,0.00,0,0.00,0.00,70.05,1524628919,0,0,1524628920,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(391,'201804251343119753',3,5,0,1,'咖啡',0,1,2,14,17,'站北地区11号大街12号','12345665','15274851694','','','','','余额支付','网络科技','123456789123455',NULL,408.90,8.00,294.23,0.00,0,0.00,0.00,416.90,1524634991,0,0,1524634991,NULL,0,0,3,122.67,0.00,'','',NULL,1,0.00,0,0),(392,'201804251345567412',3,3,0,0,'咖啡',0,1,2,14,17,'站北地区11号大街12号','12345665','15274851694','','','','','','网络科技','123456789123455',NULL,245.34,8.00,0.00,0.00,0,0.00,253.34,253.34,1524635156,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(393,'201804251346476597',3,3,0,0,'咖啡',0,1,2,14,17,'站北地区11号大街12号','12345665','15274851694','','','','','','网络科技','123456789123455',NULL,245.34,8.00,0.00,0.00,0,0.00,253.34,253.34,1524635207,0,0,0,NULL,0,0,0,0.00,0.00,'232323','',NULL,1,0.00,0,0),(394,'201804251353042717',3,3,0,3,'青春',0,1,2,14,17,'站北地区11号大街12号','12345665','18516589423','','','','','余额支付','网络科技','123456789123455',NULL,408.90,8.00,294.23,0.00,0,0.00,0.00,416.90,1524635584,0,0,1524635584,NULL,0,0,3,122.67,0.00,'订单不能按预计时间送达','',NULL,1,0.00,0,0),(395,'201804251357361806',3,3,0,3,'青春',0,1,2,14,17,'站北地区11号大街12号','12345665','18516589423','','','','','余额支付','网络科技','123456789123455',NULL,665.52,0.00,465.86,0.00,0,0.00,0.00,665.52,1524635856,0,0,1524635856,NULL,0,0,3,199.66,0.00,'订单不能按预计时间送达','',NULL,1,0.00,0,0),(396,'201804251501427935',3,5,0,0,'咖啡',0,1,2,14,17,'站北地区11号大街12号','12345665','15274851694','','','','','','网络科技','123456789123455',NULL,297.04,0.00,0.00,0.00,0,0.00,297.04,297.04,1524639702,0,0,0,NULL,0,0,0,0.00,0.00,'8555544111','',NULL,1,0.00,0,0),(398,'201804251506313069',3,5,0,1,'咖啡',0,1,2,14,17,'站北地区11号大街12号','12345665','15274851694','','','','','余额支付','网络科技','123456789123455',NULL,371.30,0.00,371.30,0.00,0,0.00,0.00,371.30,1524639991,0,0,1524639991,NULL,0,0,0,0.00,0.00,'43343434','',NULL,1,0.00,0,0),(399,'201804251508197412',3,2,1,1,'咖啡',0,1,2,14,17,'站北地区11号大街12号','12345665','15274851694','','YD','韵达快递','','余额支付','网络科技','123456789123455',NULL,297.04,0.00,297.04,0.00,0,0.00,0.00,297.04,1524640099,1524726359,1524731018,1524640099,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(400,'201804251508301323',2,5,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','余额支付','个人','',NULL,2537.06,0.00,1700.04,0.00,759,75.90,0.00,2537.06,1524640110,0,0,1524640110,NULL,0,0,3,761.12,0.00,'','',NULL,1,0.00,0,0),(401,'201804251509356054',3,0,0,1,'咖啡',0,1,2,14,17,'站北地区11号大街12号','12345665','15274851694','','','','','余额支付','网络科技','123456789123455',NULL,314.90,8.00,322.90,0.00,0,0.00,0.00,322.90,1524640175,0,0,1524640175,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(402,'201804251509589099',3,5,0,1,'咖啡',0,1,2,14,17,'站北地区11号大街12号','12345665','15274851694','','','','','余额支付','网络科技','123456789123455',NULL,251.92,8.00,259.92,0.00,0,0.00,0.00,259.92,1524640198,0,0,1524640198,NULL,0,0,0,0.00,0.00,'34434','',NULL,1,0.00,0,0),(403,'201804251510236147',2,3,0,3,'15915407513',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','余额支付','个人','',NULL,2537.06,0.00,1775.94,0.00,0,0.00,0.00,2537.06,1524640223,0,0,1524640223,NULL,0,0,3,761.12,0.00,'重复下单/误下单','',NULL,1,0.00,0,0),(404,'201804251516107466',12,5,0,1,'夏夏',0,1,2,3,0,'123456489','','15274851694','1546515984@11.com','','','','余额支付','','',NULL,88.00,0.00,88.00,0.00,0,0.00,0.00,88.00,1524640570,0,0,1524640571,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(405,'201804251520282303',12,5,0,0,'夏夏',0,1,2,3,0,'123456489','','15274851694','1546515984@11.com','','','','','','',NULL,88.00,0.00,0.00,0.00,0,0.00,88.00,88.00,1524640828,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(406,'201804251521438147',2,2,1,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','shunfeng','顺丰快递','','余额支付','个人','',NULL,2537.06,0.00,1775.12,0.00,8,0.80,0.02,2537.06,1524640903,1524640951,1524640963,1524640926,NULL,0,0,3,761.12,0.00,'','',NULL,1,0.00,0,0),(407,'201804251528297240',12,5,0,1,'夏夏',0,1,2,3,0,'123456489','','15274851694','1546515984@11.com','','','','余额支付','','',NULL,88.00,0.00,88.00,0.00,0,0.00,0.00,88.00,1524641309,0,0,1524641309,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(408,'201804251532281641',3,5,0,1,'咖啡',0,1,2,14,17,'站北地区11号大街12号','12345665','15274851694','','','','','余额支付','网络科技','123456789123455',NULL,148.52,0.00,148.52,0.00,0,0.00,0.00,148.52,1524641548,0,0,1524641548,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(411,'201804251543265352',3,3,0,0,'咖啡',0,1,2,14,17,'站北地区11号大街12号','12345665','15274851694','','','','','','网络科技','123456789123455',NULL,297.04,0.00,0.00,0.00,0,0.00,297.04,297.04,1524642206,0,0,0,NULL,0,0,0,0.00,0.00,'85555','',NULL,1,0.00,0,0),(410,'201804251540442415',3,2,1,1,'咖啡',0,1,2,14,17,'站北地区11号大街12号','12345665','15274851694','','shunfeng','顺丰快递','','余额支付','网络科技','123456789123455',NULL,297.04,0.00,297.04,0.00,0,0.00,0.00,297.04,1524642044,1524642072,1524642084,1524642044,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(412,'201804251543521849',3,5,0,0,'咖啡',0,1,2,14,17,'站北地区11号大街12号','12345665','15274851694','','','','','','网络科技','123456789123455',NULL,297.04,0.00,0.00,0.00,0,0.00,297.04,297.04,1524642232,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(413,'201804251544362936',3,5,0,1,'咖啡',0,1,2,14,17,'站北地区11号大街12号','12345665','15274851694','','','','','余额支付','网络科技','123456789123455',NULL,297.04,0.00,297.04,0.00,0,0.00,0.00,297.04,1524642276,0,0,1524642277,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(414,'201804251545249728',2,5,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','余额支付','个人','',NULL,939.99,0.00,657.99,0.00,0,0.00,0.00,939.99,1524642324,0,0,1524642414,NULL,0,0,3,282.00,0.00,'','',NULL,1,0.00,0,0),(415,'201804251548092992',2,5,0,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','余额支付','个人','',NULL,939.99,0.00,657.99,0.00,0,0.00,0.00,939.99,1524642489,0,0,1524642489,NULL,0,0,3,282.00,0.00,'','',NULL,1,0.00,0,0),(416,'201804251550211718',2,5,1,1,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','shunfeng','顺丰快递','','余额支付','个人','',NULL,251.92,0.00,251.92,0.00,0,0.00,0.00,251.92,1524642621,1524642658,0,1524642621,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(417,'201804251557289441',2,3,0,3,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','123456@qq.com','','','','积分兑换','个人','',NULL,35.00,0.00,0.00,0.00,350,35.00,0.00,35.00,1524643048,0,0,1524643048,NULL,0,0,0,0.00,0.00,'重复下单/误下单','',NULL,1,0.00,0,0),(418,'201804251635489652',1,5,1,1,'FUMAN',0,338,339,347,NULL,'天津市天津市','58282','159154075135','15915407513@163.com','YTO','圆通快递','','','傅麻烦','2582582582822',NULL,285.00,9.00,0.00,0.00,0,0.00,294.00,294.00,1524645348,1524645597,0,1524645572,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(419,'201804251645056249',1,3,0,0,'15915407513@163.com',0,0,0,0,0,'','','15915407513','','','','','','','',NULL,99.90,0.00,0.00,0.00,0,0.00,99.90,99.90,1524645905,1577808000,0,0,NULL,0,5,0,0.00,0.00,'的上市公司','打得过的',NULL,0,0.00,0,0),(420,'201804251647031370',1,0,0,0,'15915407513@163.com',0,0,0,0,0,'','','15915407513','','','','','','','',NULL,99.90,0.00,0.00,0.00,0,0.00,99.90,99.90,1524646023,1577808000,0,0,NULL,0,5,0,0.00,0.00,'烦死了快上级返利是快乐时光克里斯涵盖了肯定是管理科大圣归来的思考和公里数孤苦伶仃和关联的后果','',NULL,0,0.00,0,0),(421,'201804251648001672',1,0,0,0,'15915407513@163.com',0,0,0,0,0,'','','15915407513','','','','','','','',NULL,99.90,0.00,0.00,0.00,0,0.00,99.90,99.90,1524646080,1577808000,0,0,NULL,0,5,0,0.00,0.00,'虚拟服务类商品订单凭借电子兑换码验证消费  说本次购买的商品不需要收货地址，请正确输入接收手机号码，确保及时获得“电子兑换码”。可使用您已经绑定的手机明：您本本次购买的商品不需要收货地址，请正确输入接收手机号码，确保及时获得“电子兑换码”。可使用您已经绑定的手机次购买的商品不本次购买的商品不需要收货地址，请正确输入接收手机号码，确保及时获得“电子兑换码”。可使用您已经绑定的手机需要收货地址，请本次购买的商品不需要收货地址，请正确输入接收手机号码，确保及时获得“电子兑换码”。可使用您已经绑定的手机正确输入接','',NULL,0,0.00,0,0),(422,'201804251651325517',3,0,0,2,'可可',0,1,2,105,110,'站北地区11号大街12','12345665','18516589423','','','','','','网络科技','123456789123455',NULL,100.00,0.00,0.00,0.00,0,0.00,20.00,100.00,1524646280,0,0,1524646292,NULL,27,4,0,0.00,0.00,'','',NULL,0,20.00,0,0),(423,'201804251651386005',1,0,0,0,'15915407513@163.com',0,0,0,0,0,'','','15915407513','','','','','','','',NULL,99.90,0.00,0.00,0.00,0,0.00,99.90,99.90,1524646299,1577808000,0,0,NULL,0,5,0,0.00,0.00,'数据库了司法局了快速分手快乐个了快速观看了时光里是个老手和关联看帅哥老客户上课刚回来可视电话经过考虑很多事联合国是两个很兰嗖开个会老师看过了烧开后鬼哭狼嚎苏格兰和思考了很给力是开高三四个了海枯石烂个','',NULL,0,0.00,0,0),(424,'201804251653316703',1,4,0,1,'15915407513@163.com',0,0,0,0,0,'','','15915407513','','','','','','','',NULL,99.90,0.00,0.00,0.00,0,0.00,99.90,99.90,1524646411,1524647225,1524647267,1524647224,NULL,0,5,0,0.00,0.00,'数据库了司法局了快速分手快乐个了快速观看了时光里是个老手和关联看帅哥老客户上课刚回来可视电话经过考虑很多事联合国是两个很兰嗖开个会老师看过了烧开后鬼哭狼嚎苏格兰和思考了很给力是开高三数据库了司法局了快速分手快乐个了快速观看了时光里是个老手和关联看帅哥老客户上课刚回来可视电话经过考虑很多事联合国是两个很兰嗖开个会老师看过了烧开后鬼哭狼嚎苏格兰和思考了很给力是开高三四个了海数据库了司法局了快速分手快乐个了快速观看了时光里是个老手和关联看帅哥老客户上课刚回来可视电话经过考虑很多事联合国是两个很兰嗖开个会老师看过','',NULL,0,0.00,0,0),(425,'201804251719345355',2,2,1,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','shunfeng','顺丰快递','','余额支付','都没','152528282828288',NULL,59.00,0.00,59.00,0.00,0,0.00,0.00,59.00,1524647974,1524648072,1524648588,1524647974,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(426,'201804251723538622',2,0,0,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','','','','余额支付','','',NULL,12.97,0.00,12.97,0.00,0,0.00,0.00,12.97,1524648233,0,0,1524648233,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(429,'201804251759342677',2,2,1,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','shunfeng','顺丰快递','','余额支付','','',NULL,100.00,0.00,90.00,10.00,0,0.00,0.00,100.00,1524650374,1524650406,1524651149,1524650374,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(428,'201804251752019282',2,2,1,1,'阿拉',0,7531,8216,8300,8307,'踏踏他她他她她','','15915407513','123456@qq.com','shunfeng','顺丰快递','','余额支付','','',NULL,100.00,0.00,100.00,0.00,0,0.00,0.00,100.00,1524649921,1524649959,1524650156,1524649921,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(430,'201804251821457831',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','','','','','','','',NULL,9.90,0.00,0.00,0.00,0,0.00,9.90,9.90,1524651705,1546272000,0,0,NULL,0,5,0,0.00,0.00,'三国杀广东省的感受感受三观都三观都高大上的好地方返回的活动活动电话好的h','',NULL,0,0.00,0,0),(431,'201804251822192039',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','','','','','','','',NULL,9.90,0.00,0.00,0.00,0,0.00,9.90,9.90,1524651739,1546272000,0,0,NULL,0,5,0,0.00,0.00,'您本次购买的商品不需要收货地址，请正确输入接收手机号码，确保及时获得“电子兑换码”。可使用您已经绑定的手机或重新输入其它手机号码。    	商品	市场价（元）	单价（元）	数量	小计（元）	操作  广西移动 手机 话费充值 50元 快充直充 24小时自动您本次购买的商品不需要收货地址，请正确输入接收手机号码，确保及时获得“电子兑换码”。可使用您已经绑定的手机或重新输入其它手机号码。    	商品	市场价（元）	单价（元）	数量	小计（元）	操作  广西移动 手机 话费充值 50元 快充直充 24小时自动充','',NULL,0,0.00,0,0),(434,'201804251830483726',2,2,1,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','shunfeng','顺丰快递','','余额支付','','',NULL,195.52,0.00,195.52,0.00,0,0.00,0.00,195.52,1524652248,1524652277,1524652283,1524652248,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(433,'201804251826212190',2,4,1,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','shunfeng','顺丰快递','','余额支付','','',NULL,195.52,0.00,195.52,0.00,0,0.00,0.00,195.52,1524651981,1524652012,1524652019,1524651981,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(435,'201804260858356632',2,3,0,3,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','','','','余额支付',NULL,'',NULL,19.90,0.00,19.90,0.00,0,0.00,0.00,19.90,1524704315,0,0,1524704315,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(436,'201804260909062973',2,3,0,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','','','','余额支付',NULL,'',NULL,83.75,0.00,83.75,0.00,0,0.00,0.00,83.75,1524704946,0,0,1524704946,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(437,'201804260909546002',2,3,0,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','','','','余额支付','个人','',NULL,83.75,0.00,83.75,0.00,0,0.00,0.00,83.75,1524704994,0,0,1524704994,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(438,'201804260910125832',2,3,0,0,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','','','','',NULL,'',NULL,83.75,0.00,0.00,0.00,0,0.00,83.75,83.75,1524705012,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(439,'201804260921142445',2,4,1,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','shunfeng','顺丰快递','cod','到货付款','','',NULL,129900.00,0.00,100.00,0.00,10000,1000.00,128800.00,129900.00,1524705674,1524705747,1524727737,1524727737,NULL,0,0,0,0.00,0.00,'你好你 你后测试测测试测试测试测试测试测试测试测试测试测试测试测试测试测试测试测定测试测试测','',NULL,1,0.00,0,0),(440,'201804260942379901',3,0,0,1,'咖啡',0,1,2,14,17,'站北地区11号大街12号','12345665','15274851694','','','','','积分兑换','网络科技','123456789123455',NULL,70.00,0.00,0.00,0.00,700,70.00,0.00,70.00,1524706957,0,0,1524706957,NULL,0,0,0,0.00,0.00,'21212121','',NULL,1,0.00,0,0),(441,'201804261023344536',3,0,0,1,'咖啡',0,1,2,14,17,'站北地区11号大街12号','12345665','15274851694','','','','','余额支付','网络科技','123456789123455',NULL,152.00,10.00,162.00,0.00,0,0.00,0.00,162.00,1524709414,0,0,1524709414,NULL,0,0,0,0.00,0.00,'23232323','',NULL,1,0.00,0,0),(442,'201804261024065410',3,3,0,3,'青春',0,1,2,14,17,'站北地区11号大街12号','12345665','18516589423','','','','','余额支付','网络科技','123456789123455',NULL,228.00,10.00,188.00,50.00,0,0.00,0.00,238.00,1524709446,0,0,1524709446,NULL,0,0,0,0.00,0.00,'订单不能按预计时间送达','',NULL,1,0.00,0,0),(443,'201804261115428011',2,3,0,0,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','','','','','个人','',NULL,65.00,0.00,0.00,0.00,0,0.00,65.00,65.00,1524712542,0,0,1524712559,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(444,'201804261125376116',2,3,0,0,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','','','','余额支付','','',NULL,39.00,10.00,49.00,0.00,0,0.00,0.00,49.00,1524713137,0,0,1524713157,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(445,'201804261129268145',2,3,0,0,'15915407513',0,0,0,0,0,'','','15915407513','','','','','','','',NULL,9.90,0.00,0.00,0.00,0,0.00,9.90,9.90,1524713366,1546272000,0,0,NULL,0,5,0,0.00,0.00,'您本次购买的商品不需要收货地址，请正确输入接收手机号码，确保及时获得“电子兑换码”。您本次购买的商品不需要收货地址，请正确输入接收手机号码，确保及时获得“电子兑换码”。可使用您已经绑定的手机或重新输入您本次购买的商品不需要收货地址，请正确输入接收手机号码，确保及时获得“电子兑换码”。可使用您已经绑定的手机或重新输入其它手机号码。您本次购买的商品不需要收货地址，请正确输入接收手机号码，确保及时获得“电子兑换码”。可使用您已经绑定的手机或重新输入其它手机您本次购买的商品不需要收货地址，请正确输入接收手机号码，','',NULL,0,0.00,0,0),(446,'201804261145032776',2,0,0,2,'SH2',0,636,637,639,644,'建北大桥15号','60050023','15915407513','','','','','','个人','',NULL,6900.00,0.00,0.00,0.00,0,0.00,6899.90,6900.00,1524714264,0,0,1524714303,NULL,28,4,0,0.00,0.00,'','',NULL,0,0.10,0,0),(447,'201804261149301939',2,0,0,2,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','','','','','','个人','',NULL,6900.00,0.00,0.00,0.00,0,0.00,6899.90,6900.00,1524714557,0,0,1524714570,NULL,28,4,0,0.00,0.00,'','',NULL,0,0.10,0,0),(448,'201804261334333272',2,0,0,2,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','','','','','','个人','',NULL,3000.00,0.00,0.00,0.00,0,0.00,2990.00,3000.00,1524715403,0,0,1524720873,NULL,29,4,0,0.00,0.00,'','',NULL,0,10.00,0,0),(449,'201804261334161108',2,0,0,2,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','','','','','','个人','',NULL,3000.00,0.00,0.00,0.00,0,0.00,2990.00,3000.00,1524715426,0,0,1524720856,NULL,29,4,0,0.00,0.00,'','',NULL,0,10.00,0,0),(450,'201804261337367723',2,5,0,0,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','','','','','','个人','',NULL,3000.00,0.00,0.00,0.00,0,0.00,10.00,3000.00,1524721056,0,0,0,NULL,29,4,0,0.00,0.00,'','',NULL,0,0.00,0,0),(451,'201804261402207777',3,4,1,1,'可可',0,1,2,105,110,'站北地区11号大街12','12345665','18516589423','','YD','韵达快递','','余额支付','网络科技','123456789123455',NULL,300.71,10.00,260.71,50.00,0,0.00,0.00,310.71,1524722540,1524722571,1524722588,1524722541,NULL,0,0,0,0.00,0.00,'344343443','',NULL,1,0.00,0,0),(452,'201804261441441117',21,0,0,1,'七七',0,1,2,3,0,'yuyuyuyuyuyuyuyuu','','15274851694','','','','','余额支付','个人','',NULL,118.00,8.00,126.00,0.00,0,0.00,0.00,126.00,1524724904,0,0,1524724904,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(453,'201804261509304559',2,2,1,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','shunfeng','顺丰快递','','余额支付','个人','',NULL,219.00,10.00,207.00,10.00,100,10.00,2.00,229.00,1524726570,1524726640,1524726651,1524726624,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(454,'201804261519202279',22,0,0,1,'夏夏',0,1,2,3,4,'法国红酒','','15274851694','','','','','积分兑换','个人','',NULL,70.00,0.00,0.00,0.00,700,70.00,0.00,70.00,1524727160,0,0,1524727160,NULL,0,0,0,0.00,0.00,'这跟烦烦烦 v','',NULL,1,0.00,0,0),(455,'201804261523089667',22,3,0,1,'夏夏',0,1,2,3,4,'法国红酒','','15274851694','','','','','积分兑换',NULL,'',NULL,35.00,0.00,0.00,0.00,350,35.00,0.00,35.00,1524727388,0,0,1524727388,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(456,'201804261530084978',10,3,0,0,'XIAO',0,636,936,952,0,'SKFHKSHFKSF','','15919919433','1522585@qq.com','','','','',NULL,'',NULL,100.00,0.00,0.00,0.00,0,0.00,100.00,100.00,1524727808,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(457,'201804261531359209',22,0,0,1,'夏夏',0,1,2,3,4,'法国红酒','','15274851694','','','','','余额支付',NULL,'',NULL,518.00,10.00,372.60,0.00,0,0.00,0.00,528.00,1524727895,0,0,1524727895,NULL,0,0,3,155.40,0.00,'','',NULL,1,0.00,0,0),(458,'201804261532327457',2,3,0,0,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','','','','',NULL,'',NULL,100.00,0.00,0.00,0.00,0,0.00,100.00,100.00,1524727952,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(459,'201804261538523864',5,0,0,0,'15766212618',0,0,0,0,0,'','','15766212618','','','','alipayMobile','手机网站支付宝','','',NULL,9.90,0.00,0.00,0.00,0,0.00,9.90,9.90,1524728332,1534953599,0,0,NULL,0,5,0,0.00,0.00,'','',NULL,0,0.00,0,0),(460,'201804261539146473',5,0,0,0,'15766212618',0,0,0,0,0,'','','15766212618','','','','weixinH5','微信支付','','',NULL,9.90,0.00,0.00,0.00,0,0.00,9.90,9.90,1524728354,1534953599,0,0,NULL,0,5,0,0.00,0.00,'','',NULL,0,0.00,0,0),(461,'201804261542334113',10,2,1,1,'XIAO',0,636,936,952,0,'SKFHKSHFKSF','','15919919433','1522585@qq.com','shunfeng','顺丰快递','','',NULL,'',NULL,1580.00,0.00,0.00,0.00,0,0.00,1106.00,1580.00,1524728553,1524728636,1524728644,1524728579,NULL,0,0,3,474.00,0.00,'','',NULL,1,0.00,0,0),(462,'201804261542358862',22,4,1,1,'夏夏',0,1,2,3,4,'法国红酒','','15274851694','','YD','韵达快递','','余额支付',NULL,'',NULL,110.00,0.00,110.00,0.00,0,0.00,0.00,110.00,1524728555,1524728627,1524728648,1524728555,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(463,'201804261552169775',10,2,1,1,'XIAO',0,636,936,952,0,'SKFHKSHFKSF','','15919919433','1522585@qq.com','shunfeng','顺丰快递','','余额支付','','',NULL,1580.00,0.00,1106.00,0.00,0,0.00,0.00,1580.00,1524729136,1524729234,1524729253,1524729156,NULL,0,0,3,474.00,0.00,'','',NULL,1,0.00,0,0),(464,'201804261601361661',22,3,0,0,'夏夏',0,1,2,3,4,'法国红酒','','15274851694','','','','','',NULL,'',NULL,278.00,10.00,0.00,0.00,0,0.00,288.00,288.00,1524729696,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(465,'201804261612017361',2,3,0,0,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','','','','余额支付','3223','123228282821112',NULL,90.09,0.00,80.00,10.00,0,0.00,0.09,90.09,1524730321,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(466,'201804261612352068',2,0,0,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','','','','余额支付','3223','123228282821112',NULL,90.09,0.00,80.09,10.00,0,0.00,0.00,90.09,1524730355,0,0,1524730355,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(467,'201804261612452649',22,2,1,1,'夏夏',0,1,2,3,4,'法国红酒','','15274851694','','YZPY','中国邮政','','余额支付',NULL,'',NULL,1021.00,23.00,737.70,0.00,0,0.00,0.00,1044.00,1524730365,1524730451,1524730487,1524730365,NULL,0,0,3,306.30,0.00,'','',NULL,1,0.00,0,0),(468,'201804261624252460',2,3,0,3,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','','','','余额支付','3223','123228282821112',NULL,29.90,10.00,39.90,0.00,0,0.00,0.00,39.90,1524731065,0,0,1524731065,NULL,0,0,0,0.00,0.00,'操作有误(商品、地址等选错)','',NULL,1,0.00,0,0),(469,'201804261634327133',2,4,1,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','shunfeng','顺丰快递','','积分兑换','3223','123228282821112',NULL,1580.00,0.00,0.00,100.00,10060,1006.00,0.00,1580.00,1524731672,1524731735,1524731771,1524731672,NULL,0,0,3,474.00,0.00,'','',NULL,1,0.00,0,0),(470,'201804261640578629',2,2,1,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','shunfeng','顺丰快递','','余额支付','3223','123228282821112',NULL,1580.00,0.00,6.00,100.00,10000,1000.00,0.00,1580.00,1524732057,1524732091,1524732102,1524732057,NULL,0,0,3,474.00,0.00,'','',NULL,1,0.00,0,0),(471,'201804261644431954',22,0,0,0,'13243434343',0,0,0,0,0,'','','13243434343','','','','','',NULL,'',NULL,1485.00,0.00,0.00,0.00,0,0.00,1485.00,1485.00,1524732283,0,0,0,NULL,13,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(472,'201804261645044726',22,0,0,1,'夏夏',0,1,2,3,4,'法国红酒','','15274851694','','','','','余额支付',NULL,'',NULL,495.00,10.00,5.00,0.00,5000,500.00,0.00,505.00,1524732304,0,0,1524732356,NULL,13,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(473,'201804261650371588',23,3,0,1,'罗',0,3102,3379,3388,3391,'哦用','','18679683657','','','','','余额支付',NULL,'',NULL,88.70,0.00,88.70,0.00,0,0.00,0.00,88.70,1524732637,0,0,1524732637,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(474,'201804261650566293',2,2,1,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','shunfeng','顺丰快递','','积分兑换','3223','123228282821112',NULL,1580.00,0.00,0.00,0.00,11060,1106.00,0.00,1580.00,1524732656,1524732675,1524732687,1524732656,NULL,0,0,3,474.00,0.00,'','',NULL,1,0.00,0,0),(475,'201804261706445927',22,0,0,1,'风格过',0,338,339,340,341,'36746888','','15274851694','','','','','余额支付',NULL,'',NULL,147.00,10.00,157.00,0.00,0,0.00,0.00,157.00,1524733604,0,0,1524733604,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(476,'201804261708098683',2,4,1,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','shunfeng','顺丰快递','','积分兑换','3223','123228282821112',NULL,23.57,0.00,0.00,0.00,235,23.50,0.07,23.57,1524733689,1524733751,1524733865,1524733736,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(477,'201804261708375102',22,3,0,1,'风格过',0,338,339,340,341,'36746888','','15274851694','','','','','余额支付',NULL,'',NULL,163.24,19.00,182.24,0.00,0,0.00,0.00,182.24,1524733717,0,0,1524733717,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(478,'201804261717231285',2,1,0,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','','','','余额支付','3223','123228282821112',NULL,180.18,0.00,180.18,0.00,0,0.00,0.00,180.18,1524734243,0,0,1524734243,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(479,'201804261725279363',22,2,1,1,'风格过',0,338,339,340,341,'36746888','','15274851694','','YTO','圆通快递','','余额支付',NULL,'',NULL,292.84,19.00,311.84,0.00,0,0.00,0.00,311.84,1524734727,1524734919,1524734940,1524734727,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(480,'201804261757322164',2,4,1,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','','shunfeng','顺丰快递','unionpay','银联在线支付','3223','123228282821112',NULL,11.00,0.00,0.00,0.00,0,0.00,10.00,11.00,1524736625,1524737370,1524737380,1524737359,NULL,31,4,0,0.00,0.00,'','',NULL,0,1.00,0,0),(481,'201804261758169633',2,2,1,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','','shunfeng','顺丰快递','','','3223','123228282821112',NULL,11.00,0.00,0.00,0.00,0,0.00,10.00,11.00,1524736687,1524737208,1524737219,1524737196,NULL,31,4,0,0.00,0.00,'','',NULL,0,1.00,0,0),(482,'201804261816456427',21,0,0,1,'七七',0,1,2,3,0,'yuyuyuyuyuyuyuyuu','','15274851694','','','','','余额支付',NULL,'',NULL,500.00,10.00,510.00,0.00,0,0.00,0.00,510.00,1524737805,0,0,1524737824,NULL,13,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(483,'201804261817017729',2,2,1,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','shunfeng','顺丰快递','','余额支付','3223','123228282821112',NULL,126.49,0.00,126.49,0.00,0,0.00,0.00,126.49,1524737821,1524737842,1524737854,1524737821,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(484,'201804261820598521',22,0,0,0,'风格过',0,338,339,340,341,'36746888','','15274851694','','','','','积分兑换',NULL,'',NULL,174.00,0.00,0.00,0.00,1980,198.00,-24.00,174.00,1524738059,0,0,0,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(485,'201804261821539815',2,2,1,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','shunfeng','顺丰快递','','余额支付','3223','123228282821112',NULL,24.50,0.00,24.50,0.00,0,0.00,0.00,24.50,1524738113,1524738208,1524738219,1524738113,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(486,'201804261822427498',21,0,0,1,'七七',0,1,2,3,0,'yuyuyuyuyuyuyuyuu','','15274851694','','','','','余额支付',NULL,'',NULL,108.00,0.00,108.00,0.00,0,0.00,0.00,108.00,1524738162,0,0,1524738348,NULL,6,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(487,'201804261832273397',2,4,1,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123456@qq.com','YZPY','中国邮政','','余额支付','3223','123228282821112',NULL,24.50,0.00,24.50,0.00,0,0.00,0.00,24.50,1524738747,1524738766,1524738773,1524738747,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(488,'201804261834394895',21,0,0,0,'路人甲',0,0,0,0,0,'','','15274851596','','','','','',NULL,'',NULL,500.00,0.00,0.00,0.00,0,0.00,500.00,500.00,1524738879,0,0,0,NULL,13,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(489,'201804261836352042',2,3,0,0,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','','','','','','','',NULL,11.00,0.00,0.00,0.00,0,0.00,11.00,11.00,1524738995,0,0,0,NULL,32,4,0,0.00,0.00,'','',NULL,0,0.00,0,0),(490,'201804270924131249',2,5,0,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','','','','','','','',NULL,54.00,0.00,0.00,0.00,0,0.00,0.10,54.00,1524792232,0,0,1524792256,NULL,33,4,0,0.00,0.00,'','',NULL,0,0.10,0,0),(491,'201804270925409541',2,0,0,2,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','','','','','','','',NULL,54.00,0.00,0.00,0.00,0,0.00,53.90,54.00,1524792330,0,0,1524792340,NULL,33,4,0,0.00,0.00,'','',NULL,0,0.10,0,0),(492,'201804270926153471',2,5,0,0,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','','','','','','','',NULL,54.00,0.00,0.00,0.00,0,0.00,0.10,54.00,1524792375,0,0,0,NULL,33,4,0,0.00,0.00,'','',NULL,0,0.00,0,0),(493,'201804270943487885',17,1,0,1,'夏夏',0,1,2,14,15,'124547785555666','','15274851694','','','','','余额支付',NULL,'',NULL,110.00,0.00,110.00,0.00,0,0.00,0.00,110.00,1524793428,0,0,1524793428,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(494,'201804270954113027',23,2,1,1,'罗',0,3102,3379,3388,3391,'哦用','','18679683657','','shunfeng','顺丰快递','','余额支付',NULL,'',NULL,165.00,0.00,165.00,0.00,0,0.00,0.00,165.00,1524794051,1524794137,1524794153,1524794051,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(495,'201804271003064332',23,3,0,1,'罗',0,3102,3379,3388,3391,'哦用','','18679683657','','','','','余额支付',NULL,'',NULL,417.90,0.00,292.53,0.00,0,0.00,0.00,417.90,1524794586,0,0,1524794586,NULL,0,0,3,125.37,0.00,'','',NULL,1,0.00,0,0),(496,'201804271005474592',23,3,0,1,'罗',0,3102,3379,3388,3391,'哦用','','18679683657','','','','','余额支付',NULL,'',NULL,651.40,22.00,477.98,0.00,0,0.00,0.00,673.40,1524794747,0,0,1524794747,NULL,0,0,3,195.42,0.00,'','',NULL,1,0.00,0,0),(497,'201804271006227097',23,3,0,0,'18679683657',0,0,0,0,0,'','','18679683657','','','','','',NULL,'',NULL,19.90,0.00,0.00,0.00,0,0.00,19.90,19.90,1524794782,0,0,0,NULL,8,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(498,'201804271008023215',17,3,0,1,'夏夏',0,1,2,14,15,'124547785555666','','15274851694','','','','','余额支付',NULL,'',NULL,29.90,10.00,39.90,0.00,0,0.00,0.00,39.90,1524794882,0,0,1524794882,NULL,0,0,0,0.00,0.00,'该商品降价了','',NULL,1,0.00,0,0),(499,'201804271013563601',17,0,0,0,'15247471414',0,0,0,0,0,'','','15247471414','','','','','',NULL,'',NULL,100.00,0.00,0.00,0.00,0,0.00,100.00,100.00,1524795236,0,0,0,NULL,19,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(500,'201804271014089370',17,0,0,0,'夏夏',0,338,339,340,341,'124547785555666','','15274851694','','','','','余额支付',NULL,'',NULL,100.00,0.00,80.00,0.00,0,0.00,20.00,100.00,1524795248,0,0,0,NULL,19,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(501,'201804271017075618',17,1,0,1,'夏夏',0,338,339,340,341,'124547785555666','','15274851694','','','','','余额支付',NULL,'',NULL,100.00,0.00,60.00,20.00,200,20.00,0.00,100.00,1524795427,0,0,1524795500,NULL,19,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(502,'201804271023211810',24,0,0,0,'18516589423',0,0,0,0,0,'','','18516589423','','','','','',NULL,'',NULL,100.00,0.00,0.00,0.00,0,0.00,100.00,100.00,1524795801,0,0,0,NULL,19,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(503,'201804271032297694',24,2,1,1,'夏夏',0,1,2,3,0,'3545454545454','','15274851694','','YD','韵达快递','','余额支付',NULL,'',NULL,100.00,0.00,100.00,0.00,0,0.00,0.00,100.00,1524796349,1524797645,1530613665,1524796386,NULL,19,6,0,0.00,0.00,'23232323','',NULL,1,0.00,0,0),(504,'201804271035318046',23,4,1,1,'罗',0,3102,3379,3388,3391,'哦用','','18679683657','','YD','韵达快递','','余额支付',NULL,'',NULL,50.00,0.00,50.00,0.00,0,0.00,0.00,50.00,1524796531,1524797666,1524797885,1524796542,NULL,19,6,0,0.00,0.00,'','',NULL,1,0.00,0,0),(505,'201804271038362928',2,0,0,1,'度以上都是',0,4670,5029,5118,5124,'内蒙古自治区','','15915407513','123','','','','余额支付',NULL,'',NULL,19.90,0.00,19.90,0.00,0,0.00,0.00,19.90,1524796716,0,0,1524796716,NULL,0,0,0,0.00,0.00,'','',NULL,1,0.00,0,0),(506,'201804271039341359',2,0,0,1,'度以上都是',0,4