<?php
// +----------------------------------------------------------------------
// | yershop网店管理系统
// +----------------------------------------------------------------------
// | Copyright (c) 2017 http://www.yershop.com All rights reserved.
// +----------------------------------------------------------------------
// | 版权申明：yershop网店管理系统不是一个自由软件，是贝云网络官方推出的商业源码，严禁在未经许可的情况下
// | 拷贝、复制、传播、使用yershop网店管理系统的任意代码，如有违反，请立即删除，否则您将面临承担相应
// | 法律责任的风险。如果需要取得官方授权，请联系官方http://www.yershop.com
// +----------------------------------------------------------------------
namespace app\common\Controller;
use think\Controller;
use think\Db;
use think\View;
use think\Config;

/**
 * 插件基类
 */

abstract class Addons {

    protected $view = null; //视图实例对象
    public $addons_path = ''; // 当前插件目录


    public function __construct() {
        // 获取当前插件目录
        $this->addons_path = ADDON_PATH . $this->getName() . DS;

        // 初始化视图模型
        $config = ['view_path' => $this->addons_path];
        $config = array_merge(Config::get('template'), $config); //修改模板路径
        $this->view = new View($config);
    }

    /**
     * 解析和获取模板内容 用于输出
     * @param string    $template 模板文件名或者内容
     * @param array     $vars     模板输出变量
     * @param array     $replace 替换内容
     * @param array     $config     模板参数
     * @return string
     */
    public function fetch($template = '', $vars = [], $replace = [], $config = [])
    {
        if(!is_file($template)){
            $template = DS . $template;
        }
        echo $this->view->fetch($template, $vars, $replace, $config);
    }

    /**
     * 获取当前插件名
     * @return [string] [返回类似book]
     * final 子类不能重写
     */
    final public function getName() {
        $class = explode('\\', get_class($this));; // get_class返回定义的类名
        // array_pop 删除数组中最后一个元素，array_pop的值为所删除的元素
        return strtolower(array_pop($class)); // strtolower大写转小写
    }



    // 安装插件（必须实现）
    abstract public function install();

    // 卸载插件（必须实现）
    abstract public function uninstall();
}
