<?php
// +----------------------------------------------------------------------
// | yershop网店管理系统
// +----------------------------------------------------------------------
// | Copyright (c) 2017 http://www.yershop.com All rights reserved.
// +----------------------------------------------------------------------
// | 版权申明：yershop网店管理系统不是一个自由软件，是贝云网络官方推出的商业源码，严禁在未经许可的情况下
// | 拷贝、复制、传播、使用yershop网店管理系统的任意代码，如有违反，请立即删除，否则您将面临承担相应
// | 法律责任的风险。如果需要取得官方授权，请联系官方http://www.yershop.com
// +----------------------------------------------------------------------
namespace app\index\controller;
use think\Controller;
use think\Db;
/**
 * 收藏模型控制器
 * 收藏模型列表和详情
 */
class Cash extends Home {
	
	public function index($type=null){
		if(!session_uid()) {
		    $this->redirect( "User/login");
		}
		
		$this->meta_title = '提现';	
		
		return $this->fetch();
		
	}
	
	public function lists($type=null){
		if(!session_uid()) {
		    $this->redirect( "User/login");
		}
		if(!is_null($type)){
		$map[]=['type','=',$type];
		}else{
			$map[]=['status','>=',0];
		}
		 $map[]=['uid','=',is_login()]; 
		$this->meta_title = '提现记录';	
		$this->assign('meta_title',$this->meta_title);
       
		$res=getLists("cash",$map,"24","id desc");
		$this->assign('res', $res);
		return $this->fetch();
		
	}
      //增加收藏
     public function	parse($n){
		if($n==0){
			
		  return "申请中";
		}
	   if($n==1){
			
		  return "已通过";
		}
		if($n==2){
			
		  return "已拒绝";
		}
		
		
	}   
    	   //提现
    public function add(){
		
		if(!session_uid()) {
		    $this->redirect( "User/login");
		}
		$money=input('money');
		
		if(!$money||$money<0){
	   	    $this->error('提现金额必须大于0');
	   }
	   if(!input('account')){
				$this->error( "银行卡号不能为空");
	   }
		if(!input('bank')){
				$this->error( "开户行名称不能为空");
		}
        if(!input('username')){
				$this->error( "开户姓名不能为空");
		}		
		$uid=session_uid(); 
		$map["uid"]=$uid;
	   $where['id']=$uid;
	   $info=db('user')->where($where)->find();
	   if(!$info['status']){
	   	    $this->error('账号被封禁');
	   }
	   if($info["account"]<$money){
             $this->error('提现金额大于余额');
	   	
	   }	   
	   $save['account']=$info['account']-$money;
	   db('user')->where($where)->field('account')->update($save);
	   
                 $data["create_time"]=time();
				 $data["type"]=2;//提现
				 $data["uid"]=$uid;//提现费率
                 $data["money"]=$money; 
                 $data["total"]=$save['account'];
                 $data["content"]='提现';
	             db('account_log')->insert($data);
	              
	             unset($data);
		         $data["create_time"]=time();
				 $data["status"]=0;//申请中
				 $data["percent"]=api("PERCENT");//提现费率
                 $data["money"]=$money;
                 $data['uid']=$uid;  
                 $data["content"]='申请提现';
                 $data["total"]=$save['account'];
                 $percent=(float)api("PERCENT")/100;
			     $arrive_money=$money-$money*$percent;
				 $data["arrive_money"]=$arrive_money;//实际到账
				 $data["bank"]=input("bank");//银行名称
				 $data["account"]=input("account");//银行账户
				 $data["username"]=input("username");//银行开户名
				   
		        $ids=db("cash")->insertGetId($data);
		 
      if($ids){
		  $this->success("已提交审核");
	   }else{
		  $this->error("申请失败");
	   }
	  
   }
   public function delete(){
	   if(!session_uid() ) {
			$this->error( "您还没有登陆",url("User/login") );
	   }
	   $id=input('id'); // 用intval过滤$_POST['id']
	   $id=safe_replace($id);//过滤
	   $map["id"]=$id; 
	   $map["uid"]=session_uid();
	   $res=db("collect")->where($map)->delete();
	   if($res){
		  $this->success("删除成功");
	   }else{
		  $this->error("删除失败");
	   }
   }
}

