<?php
// +----------------------------------------------------------------------
// | yershop网店管理系统
// +----------------------------------------------------------------------
// | Copyright (c) 2017 http://www.yershop.com All rights reserved.
// +----------------------------------------------------------------------
// | 版权申明：yershop网店管理系统不是一个自由软件，是贝云网络官方推出的商业源码，严禁在未经许可的情况下
// | 拷贝、复制、传播、使用yershop网店管理系统的任意代码，如有违反，请立即删除，否则您将面临承担相应
// | 法律责任的风险。如果需要取得官方授权，请联系官方http://www.yershop.com
// +----------------------------------------------------------------------
namespace app\index\controller;
use think\Controller;
use think\Db;
/**
 * 收藏模型控制器
 * 收藏模型列表和详情
 */
class Score extends Home {
	
	public function index(){
		if(!session_uid()) {
		    $this->redirect( "User/login");
		}
		
		$uid=session_uid();
		$this->meta_title = '我的积分明细';	
		$this->assign('meta_title',$this->meta_title);
        $map['uid']=$uid;//用户id
		$res=getLists("score_log",$map,"24","id desc");
		$this->assign('res', $res);
		return $this->fetch();
		
	}
	public function lists(){
		if(!session_uid()) {
		    $this->redirect( "User/login");
		}
		
		$uid=session_uid();
		$this->meta_title = '我的账户明细';	
		$this->assign('meta_title',$this->meta_title);
        $map['uid']=$uid;//用户id
		$res=getLists("score_log",$map,"24","id desc");
		$this->assign('res', $res);
		return $this->fetch();
		
	}
	
	public function user($type=null){
		if(!session_uid()) {
		    $this->redirect( "User/login");
		}
		if(!is_null($type)){
		    $map[]=['status','=',$type];
		}else{
			$map[]=['status','>=',0];
		}
		$uid=session_uid();
		$map[]=['uid','=',is_login()]; 
		$this->meta_title = '我的账户明细';	
		$this->assign('meta_title',$this->meta_title);
       
		$res=getLists("score_order",$map,"24","id desc");
		$this->assign('res', $res);
		return $this->fetch();
		
	}
	public function update($id=0){
		if(!session_uid()) {
		   	$this->error( "您还没有登陆",url("User/login") );
		}
		$id=input('id');
		if(!$id){
		  	$this->error( "id错误");
		}
		$map[]=['id','=',$type];
		$uid=session_uid();
		$map[]=['uid','=',is_login()]; 
		$info=db("score_order")->where($map)->find();
        if(!$info){
		    $this->error('订单不存在！');
		}
		$data['username']=input('username');
		$data['address']=input('province').input('city').input('area').input('address');
		$data['mobile']=input('mobile');
		$res=db("score_order")->where($map)->update($data);
		if($res){
			  $this->success("更新成功！");
		}else{			
			  $this->error("更新失败！");
		}
		
	}
	
	
	  public function ordersn(){
		$yCode = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J','K');
		$orderSn = $yCode[intval(date('Y')) - 2011] . strtoupper(dechex(date('m'))) . date('d') . substr(time(), -5) . substr(microtime(), 2, 5) . sprintf('%04d%02d', rand(1000, 9999),rand(0,99));
		return $orderSn;
	}
   	/*积分兑换*/
	public function save(){
     	if(!session_uid()) {
		   	$this->error( "您还没有登陆",url("User/login") );
		}
		
		$uid= session_uid();
		
		$num=1;
		if(!($num && is_numeric($num))){
		  $this->error('数量错误！');
		}
		if(!input('username')){
		  // error('用户名不能为空！');
		}
		if(!input('mobile')){
		  // error('手机号不能为空！');
		}
		if(!input('address')){
		   //error('地址不能为空！');
		}
		//$uid=is_login(); 
		$id=(int)input('id'); // 用intval过滤$_POST['id']
       
		if($id){
		    $map['id']=safe_replace($id);
		}
		$info=db("score_goods")->where($map)->find();
        if(!$info){
		    $this->error('商品不存在！');
		}
		if(!$info['sku']){
		  $this->error('sku库存数量为0！');
		} 
		
      	$condition["id"]=$uid;
		$user=db("user")->where($condition)->find();
		$score=$user["score"];//积分
       
        $total_score=$info['num'];
		if($total_score>$user["score"]){
		   $this->error('积分不足！');
		}else{
		   $save["score"]=$user["score"]-$total_score;//积分
		}
		
		$orderId=$this->ordersn();
		if(!$orderId){
		  $this->error('订单号获取出错');	
		}
		
	     $data["orderId"]=$orderId; 	
		 $data["score"]=$total_score;
		 $data["title"]=$info["title"];
		 $data["type_id"]=$info["type_id"];
		 
		 $data["express"]=safe_replace(input("express"));
		 $data["username"]=safe_replace(input("username"));
		 $data["mobile"]=safe_replace(input("mobile"));
		 $data["address"]=safe_replace(input("address"));
		  
         $data["uid"]=$uid;	
         $data['status']=0;
		 $data["create_time"]=time(); 
	     $data["goods_id"]=$id;
		 $res=db("score_order")->insertGetId($data);
		 
		 
		 db("user")->where($condition)->field("id,score")->update($save);
		 db("score_goods")->where($map)->setField('sku',$info['sku']-1);
		 unset($data);
		 $data["score"]=$total_score;
					$data["type"]=0;//-
					$data["content"]="积分兑换商品";
					$data["create_time"]=time();
					$data["uid"]=$uid;
					$data["total"]=$save["score"];
					
					db("ScoreLog")->insertGetId($data);
		if($res){
			  $this->success("兑换成功！");
		}else{			
			  $this->error("兑换失败！");
		} 
	}
  
}

