/*
Navicat MySQL Data Transfer

Source Server         : root
Source Server Version : 50553
Source Host           : 127.0.0.1:3306
Source Database       : 2c

Target Server Type    : MYSQL
Target Server Version : 50553
File Encoding         : 65001

Date: 2020-07-02 20:43:20
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for yer_account_log
-- ----------------------------
DROP TABLE IF EXISTS `yer_account_log`;
CREATE TABLE `yer_account_log` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id,自增主键',
  `money` decimal(50,2) NOT NULL DEFAULT '0.00',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1+,0-',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `total` decimal(50,2) NOT NULL DEFAULT '0.00',
  `content` varchar(225) DEFAULT NULL,
  `status` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COMMENT='资金变化表';

-- ----------------------------
-- Records of yer_account_log
-- ----------------------------
INSERT INTO `yer_account_log` VALUES ('1', '10.00', '82', '0', '0', '90.00', '提现', '1');
INSERT INTO `yer_account_log` VALUES ('2', '24.00', '82', '0', '1591936828', '0.00', '余额支付订单', '0');
INSERT INTO `yer_account_log` VALUES ('3', '100.00', '104', '2', '1592116648', '500.00', '提现', '0');
INSERT INTO `yer_account_log` VALUES ('4', '100.00', '104', '2', '1592117114', '400.00', '提现', '0');
INSERT INTO `yer_account_log` VALUES ('5', '100.00', '104', '2', '1592117406', '300.00', '提现', '0');
INSERT INTO `yer_account_log` VALUES ('6', '100.00', '104', '2', '1592117434', '200.00', '提现', '0');
INSERT INTO `yer_account_log` VALUES ('7', '5.00', '104', '2', '1592118171', '195.00', '提现', '0');
INSERT INTO `yer_account_log` VALUES ('8', '5.00', '104', '2', '1592118263', '190.00', '提现', '0');
INSERT INTO `yer_account_log` VALUES ('9', '6.00', '104', '2', '1592118420', '184.00', '提现', '0');
INSERT INTO `yer_account_log` VALUES ('10', '6.00', '104', '2', '1592118453', '178.00', '提现', '0');
INSERT INTO `yer_account_log` VALUES ('11', '17.00', '104', '2', '1592140117', '161.00', '提现', '0');
INSERT INTO `yer_account_log` VALUES ('12', '123.00', '104', '2', '1592199512', '38.00', '提现', '0');
INSERT INTO `yer_account_log` VALUES ('13', '88.00', '104', '2', '1592393045', '3800.00', '提现', '0');
INSERT INTO `yer_account_log` VALUES ('14', '2342.00', '104', '0', '1592480912', '0.00', '余额支付订单', '0');
INSERT INTO `yer_account_log` VALUES ('15', '10.00', '82', '2', '1593271715', '416.00', '提现', '0');
INSERT INTO `yer_account_log` VALUES ('16', '10.00', '82', '2', '1593271799', '406.00', '提现', '0');

-- ----------------------------
-- Table structure for yer_ad
-- ----------------------------
DROP TABLE IF EXISTS `yer_ad`;
CREATE TABLE `yer_ad` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `url` varchar(255) DEFAULT NULL COMMENT '链接',
  `place` varchar(255) DEFAULT NULL COMMENT '位置',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(2) DEFAULT '1' COMMENT '数据状态',
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '广告图片',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='广告表';

-- ----------------------------
-- Records of yer_ad
-- ----------------------------
INSERT INTO `yer_ad` VALUES ('1', '广告1', 'goods/lists?id=107', '1', '0', '0', '1', '218', '0');
INSERT INTO `yer_ad` VALUES ('2', '广告2', 'goods/lists?id=107', '2', '0', '0', '1', '220', '0');
INSERT INTO `yer_ad` VALUES ('3', '广告3', 'goods/lists?id=107', '6', '0', '0', '1', '221', '0');
INSERT INTO `yer_ad` VALUES ('4', '广告4', 'goods/lists?id=107', '4', '0', '0', '1', '222', '0');
INSERT INTO `yer_ad` VALUES ('6', '手机数码广告1', 'goods/lists?id=52', '1', '0', '0', '1', '234', '107');
INSERT INTO `yer_ad` VALUES ('7', '手机数码2', 'goods/lists?id=52', '2', '0', '0', '1', '235', '107');
INSERT INTO `yer_ad` VALUES ('8', '手机数码广告3', 'goods/lists?id=107', '2', '0', '0', '1', '446', '107');
INSERT INTO `yer_ad` VALUES ('9', '食品饮料', 'goods/lists?id=107', '33', '0', '0', '1', '237', '52');
INSERT INTO `yer_ad` VALUES ('10', '头部banner', 'goods/detail?id=177', '99', '0', '0', '1', '281', '0');
INSERT INTO `yer_ad` VALUES ('11', '手机端广告1', 'http://demo.yershop.com/wap/goods/detail/id/168.html', '9', '0', '0', '1', '365', '0');
INSERT INTO `yer_ad` VALUES ('12', '手机端广告2', 'http://demo.yershop.com/wap/goods/detail/id/203.html', '10', '0', '0', '1', '366', '0');
INSERT INTO `yer_ad` VALUES ('13', '手机端广告位1', 'goods/detail?id=203', '100', '0', '0', '1', '367', '0');
INSERT INTO `yer_ad` VALUES ('14', '手机端广告位2', 'goods/detail?id=166', '101', '0', '0', '1', '368', '0');
INSERT INTO `yer_ad` VALUES ('15', '手机端广告位3	', 'http://wx.bycms.cn/weixin/weixin/index/id/1.html', '1', '0', '0', '1', '369', '0');
INSERT INTO `yer_ad` VALUES ('17', '56', '56', '1', '0', '0', '1', '444', '0');
INSERT INTO `yer_ad` VALUES ('18', 'banner广告位1', 'goods/detail?id=166', '3', '0', '0', '1', '447', '0');
INSERT INTO `yer_ad` VALUES ('19', 'banner广告位2', 'goods/detail?id=203', '3', '0', '0', '1', '448', '0');
INSERT INTO `yer_ad` VALUES ('20', '魔方广告位1', 'goods/detail?id=225', '5', '0', '0', '1', '537', '0');
INSERT INTO `yer_ad` VALUES ('21', '魔方广告位2', 'goods/detail?id=204', '5', '0', '0', '1', '538', '0');
INSERT INTO `yer_ad` VALUES ('22', '魔方广告位3', 'goods/detail?id=205', '5', '0', '0', '1', '539', '0');
INSERT INTO `yer_ad` VALUES ('23', '魔方广告位4', 'goods/detail?id=206', '5', '0', '0', '1', '540', '0');
INSERT INTO `yer_ad` VALUES ('25', '首页广告', 'http://yershop.com', '1', '0', '0', '1', '530', '75');

-- ----------------------------
-- Table structure for yer_address
-- ----------------------------
DROP TABLE IF EXISTS `yer_address`;
CREATE TABLE `yer_address` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `mobile` varchar(225) DEFAULT NULL COMMENT '手机号',
  `province` varchar(225) DEFAULT NULL COMMENT '省',
  `city` varchar(225) DEFAULT NULL COMMENT '市',
  `area` varchar(225) DEFAULT NULL COMMENT '区县',
  `address` varchar(225) DEFAULT NULL COMMENT '详细地址',
  `username` varchar(225) DEFAULT NULL COMMENT '收件人',
  `zipcode` varchar(225) DEFAULT NULL COMMENT '邮编',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否默认',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='收件人地址表';

-- ----------------------------
-- Records of yer_address
-- ----------------------------
INSERT INTO `yer_address` VALUES ('27', '13212301230', '广东省', '广州市', '海珠区', 'asfas', 'dfgdfg', null, '0', '0', '104');
INSERT INTO `yer_address` VALUES ('28', 'WERWEERWE', '浙江省', '杭州市', '西湖区', 'WEERWE', 'bymall', null, '0', '0', '82');

-- ----------------------------
-- Table structure for yer_answer
-- ----------------------------
DROP TABLE IF EXISTS `yer_answer`;
CREATE TABLE `yer_answer` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `appid` varchar(225) DEFAULT NULL COMMENT '公众号id',
  `keyword` varchar(225) NOT NULL DEFAULT '' COMMENT '关键词',
  `type` varchar(225) DEFAULT NULL COMMENT '回复类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='被动回复表';

-- ----------------------------
-- Records of yer_answer
-- ----------------------------
INSERT INTO `yer_answer` VALUES ('1', 'wx643f65392e6a5e8c', '1', 'text');
INSERT INTO `yer_answer` VALUES ('2', 'wx643f65392e6a5e8c', '2', 'news');
INSERT INTO `yer_answer` VALUES ('3', 'wx643f65392e6a5e8c', '3', 'images');
INSERT INTO `yer_answer` VALUES ('4', 'wx643f65392e6a5e8c', '5', 'text');

-- ----------------------------
-- Table structure for yer_attachment
-- ----------------------------
DROP TABLE IF EXISTS `yer_attachment`;
CREATE TABLE `yer_attachment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id自增',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '路径',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '图片链接',
  `md5` char(32) NOT NULL DEFAULT '' COMMENT '文件md5',
  `sha1` char(40) NOT NULL DEFAULT '' COMMENT '文件 sha1编码',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '状态',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `exts` varchar(225) DEFAULT NULL,
  `type` smallint(2) NOT NULL DEFAULT '0',
  `size` varchar(225) DEFAULT NULL,
  `oldname` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=599 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='附件表';

-- ----------------------------
-- Records of yer_attachment
-- ----------------------------
INSERT INTO `yer_attachment` VALUES ('1', '/public/uploads/picture/2014-09-02/5405e0f3b1705.png', '', '36d077267c76901835c07eb98f43647f', '0f7ce26261cb7a81dcfb14e057982ec60fa3a6e0', '1', '1409671411', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('118', '/public/uploads/picture/2015-09-18/55faf2ac353a5.png', '', '02273f1c88dd109270b8658aaa50adb7', '03072f5a6ad8edebed49f2a2aaab0946fee911dc', '1', '1442509483', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('119', '/public/uploads/picture/2015-09-18/55faf2b05d1f7.jpg', '', 'f19560a9dce4d5856f8bd94ec4f94f7c', 'df47fefa04680b0f94333f73538369ac1a02a705', '1', '1442509488', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('120', '/public/uploads/picture/2015-09-18/55fbea25cce43.png', '', 'db6d75524ce0adbe0aa392e89db2c967', 'd5c00b55590a673c72f32bfef5f248eea2541b48', '1', '1442572836', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('121', '/public/uploads/picture/2015-09-18/55fbed7b89833.jpg', '', '85e8b28767fb07b93c2f0325c885890d', '680153590e2abd8b0751758b0b10fe488d8a132a', '1', '1442573691', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('122', '/public/uploads/picture/2015-09-18/55fbfa12f0583.jpg', '', '165a1f4c326e02c467e56017eb31341e', 'a41ebd344dc020cd14d49b45d48b05c0b5a014ae', '1', '1442576914', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('123', '/public/uploads/picture/2015-09-18/55fbfb43e5845.jpg', '', '75e3a97a6bf974893c19b188d5952eca', '192bffee7bcb4ff8682a4ebf0bc97cf6f1cfcdc4', '1', '1442577219', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('124', '/public/uploads/picture/2015-09-18/55fbfba4b5a30.jpg', '', '29e0e481e4642156586f85de4a56f241', '077944d495a9e2a9106ae86a4bed7b36a3200183', '1', '1442577316', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('125', '/public/uploads/picture/2015-09-18/55fbfbd2a1254.png', '', 'ce4df64ea0cf6ea03b1814ba39c9ac14', 'd4ac154920c0c2ec9bc37735066a38baf9b35042', '1', '1442577362', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('126', '/public/uploads/picture/2015-09-18/55fbfbfea4cec.jpg', '', '5750a2e4be1eabb48c387c1701285c19', 'bc2fad2962e2ed53ef9c7fd1d54ea2f183e3744b', '1', '1442577406', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('127', '/public/uploads/picture/2015-09-18/55fbfca553025.jpg', '', 'e5897ab5d0968219417382de088c9b51', 'fe762a96ec7b66522a573397aef54dfac790efb4', '1', '1442577572', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('128', '/public/uploads/picture/2015-09-18/55fbfefe3b46c.jpg', '', '9d63a525c72228392bc9995a2dccb804', '1128a13c77f928305aa74250c73849e0fdb66baa', '1', '1442578173', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('129', '/public/uploads/picture/2015-09-18/55fc06d81d259.png', '', 'c74ead772a7ef411298074a2cfda3b00', 'f81103f81942d48c7a08da5a7b902ae73c0d032f', '1', '1442580183', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('130', '/public/uploads/picture/2015-09-18/55fc0db08a573.png', '', '74e827839f9878de5ee040f501d44e24', '64da8dfcdeb5c91f21ef8c8d4e28e16c0988ec99', '1', '1442581936', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('131', '/public/uploads/picture/2015-09-18/55fc14f557c2b.jpg', '', 'febb770b7148c2554c89dc8f2aad47ef', '58e1fff98127903f37d0034ad4bfb89e1b24220b', '1', '1442583797', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('132', '/public/uploads/picture/2015-09-18/55fc25884bc20.jpg', '', '7ffeea044ed576b6c399aea469013995', '2491a13692bffc0ba29dcac65d0a51cb81870ec3', '1', '1442588039', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('133', '/public/uploads/picture/2015-09-18/55fc268046052.jpg', '', '2c2884ec3ad9671595f2c8ba7ec83e61', '208e93d8b664ad2c6cb0ed6613b85cb17d15735c', '1', '1442588287', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('134', '/public/uploads/picture/2015-09-18/55fc26c302c6c.jpg', '', 'cd8289f0b5e2cce081e64cf728a3dad9', '77359403d19d2d7758a38816ffc25e92de6f5071', '1', '1442588354', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('135', '/public/uploads/picture/2015-09-19/55fd2ce92c34a.png', '', 'beee2b89375a6b029a82fa8ca5ba6a07', '96f52b0bdb148e5bc82c9a195a36a7592784ae7c', '1', '1442655464', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('136', '/public/uploads/picture/2015-09-19/55fd2d31abbfb.png', '', '54529b60a5b44ae3551a316c51c5c732', 'a9b4dd9e304d61b8b0af4eed2204899b360d3958', '1', '1442655537', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('137', '/public/uploads/picture/2015-09-19/55fd2d7a24d4d.jpg', '', '8258766e1b790fb7c1fe5a2a9caa65d0', 'd6ded094cff01419050eeb23c39ce85812bf2ce8', '1', '1442655609', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('138', '/public/uploads/picture/2015-09-19/55fd2da7b3e38.jpg', '', 'fc9680b79fdb0a6b4cef1973f2b3e975', '9ea0bdb5c85eb2bbf31a2ea68f40b11b1e1e9363', '1', '1442655655', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('139', '/public/uploads/picture/2015-09-19/55fd2e824761b.png', '', '460076b755fda8aeab55b154d878eb2b', 'e06d5861fa44e30f3f74f912bf43b45039a4c9a1', '1', '1442655873', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('140', '/public/uploads/picture/2015-09-19/55fd2ea40f9eb.jpg', '', 'd82b42da9052d7d0c9941607966bd68b', '89e4ce2c36bcd3fb0ba08675d6193ef49a7018cc', '1', '1442655907', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('141', '/public/uploads/picture/2015-09-19/55fd2ed346ca2.jpg', '', '325a5b1e756187740de7876ee8217624', 'edb5db598f9e88235113d1238d882572b01b99fc', '1', '1442655954', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('142', '/public/uploads/picture/2015-09-19/55fd2f09a9c17.png', '', 'a0be05f9d4637a9369f21ec2a350a3d8', '05428eced8ae43f41d59a3ed1d616473a1c35e39', '1', '1442656009', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('143', '/public/uploads/picture/2015-09-19/55fd2f35c4d1b.png', '', 'cb5e8cc8a5e7835b1ce44cfe070c10d7', '3ba85af092c0a04b70fe5625f7bae675158c3fc2', '1', '1442656047', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('144', '/public/uploads/picture/2015-09-19/55fd2f63de016.jpg', '', '46b06af357db9e001e210da953943cad', '69310227d7099372e31924f6d0405489e52eb492', '1', '1442656099', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('145', '/public/uploads/picture/2015-09-19/55fd30a01fb76.png', '', 'e18a8be03a63aaf98309caeebcbb3ff6', '7143023f23da57142f4b2129201d65d06a0320ed', '1', '1442656415', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('146', '/public/uploads/picture/2015-09-19/55fd3107afdb4.png', '', '5f0924eb289d82e72956f98d5782cf34', 'b64e99156213aba7cec70a52796cac7c535aaf46', '1', '1442656519', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('147', '/public/uploads/picture/2015-09-21/55fef291d180a.jpg', '', '6bfa43f557fd45417a7332a1c76b9d0c', '4f5fc0d9bb35b82c7ed3524eb94cb00b9f0efb80', '1', '1442771601', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('148', '/public/uploads/picture/2015-09-21/55ff9daf421da.jpg', '', '8aa0ca20041c70a3a7ed52439ad17e87', '2104acbddfb7896074262f06629cd531eb051f44', '1', '1442815398', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('149', '/public/uploads/picture/2015-10-01/560c353d68810.jpg', '', 'd368c2e6e97c5ef8d3c5a28f9ff86272', '2ea38906b4184f9f3040ae2ca4e46ec057aac4a1', '1', '1443640636', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('150', '/public/uploads/picture/2015-10-01/560c36d681ed7.png', '', '89f9dc5aba8d7c17e33b54f8820113c8', '6d16bcd39d6af6cbca714833dd003ade7753f196', '1', '1443641046', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('151', '/public/uploads/picture/2015-10-01/560c398857058.jpg', '', 'cf14018177659b6cebc315af384e557d', '0bc0eccb7a8c0e41ec199adf74f42ca29b9426f2', '1', '1443641735', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('152', '/public/uploads/picture/2015-10-01/560c482057eb2.jpg', '', '0b79878d6e22f05624dc67c924a1403f', '4001e0b6b42b7e643dce002ec5825a22322e1518', '1', '1443645472', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('153', '/public/uploads/picture/2015-10-01/560c497ba8fab.jpg', '', '3cb499f3f19b59a4f764f854ffda13fd', 'a9c334d0aa35040fbb6eb5c87055557cd22f3899', '1', '1443645819', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('154', '/public/uploads/picture/2015-10-01/560c4c6a574dd.jpg', '', 'dbaa89d809c1f11a6be878a901cc6ef3', 'ee8a749b0cfe74f315710d08293499c104ccebc6', '1', '1443646570', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('155', '/public/uploads/picture/2015-10-01/560c4fbe38b7e.jpg', '', '3f6be98ec909bd442df7f3bdec87837d', '2febfa649830eaa2347dc78f3dcb3fc9f1ab0b31', '1', '1443647422', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('156', '/public/uploads/picture/2017-03-18/1489833130.jpg', '', '', '', '1', '1489833130', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('157', '/public/uploads/picture/2017-03-18/1489833193.jpg', '', '', '', '1', '1489833193', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('158', '/public/uploads/picture/2017-03-18/1489833237.jpg', '', '', '', '1', '1489833237', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('159', '/public/uploads/picture/2017-04-10/58ea728da93d6.jpg', '', 'fbe492e4129c37da9108def74891ffd3', '', '0', '0', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('160', '/public/uploads/picture/2017-04-10/58ea72ad6b7b5.jpg', '', 'e772bdc47334739991c6e0ed7b883044', '', '0', '0', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('161', '/public/uploads/picture/2017-04-10/58ea7344ba5bb.jpg', '', 'e772bdc47334739991c6e0ed7b883044', '', '0', '0', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('162', '/public/uploads/picture/2017-04-10/58ea7373323c6.jpg', '', 'e772bdc47334739991c6e0ed7b883044', '', '0', '0', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('163', '/public/uploads/picture/2017-04-10/58ea739e5b426.jpg', '', 'e772bdc47334739991c6e0ed7b883044', '', '0', '0', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('164', '/public/uploads/picture/2017-04-10/58ea741c3c765.jpg', '', '3f2f102f8b1de130101378eb6e6f523c', '', '0', '0', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('165', '/public/uploads/picture/2017-04-10/58ea74c57144b.png', '', 'a9e8476c71652114c1a8485948bc2eb3', '', '0', '0', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('166', '/public/uploads/picture/2017-04-10/58ea750990423.jpg', '', '60be787ff19aacedca764129855f883d', '', '0', '0', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('167', '/public/uploads/picture/2017-04-10/58ea755252f92.jpg', '', 'e772bdc47334739991c6e0ed7b883044', '', '0', '0', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('168', '/public/uploads/picture/2017-04-10/58ea75e593ffa.png', '', 'a9e8476c71652114c1a8485948bc2eb3', '', '0', '0', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('169', '/public/uploads/picture/2017-04-10/58ea76457e34b.jpg', '', 'e772bdc47334739991c6e0ed7b883044', '', '0', '0', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('170', '/public/uploads/picture/2017-04-10/58ea76f647856.jpg', '', 'e772bdc47334739991c6e0ed7b883044', '', '0', '0', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('171', '/public/uploads/picture/2017-04-10/58ea77613b2e9.jpg', '', 'e772bdc47334739991c6e0ed7b883044', '', '0', '0', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('172', '/public/uploads/picture/2017-04-10/58ea7889a445b.jpg', '', 'e772bdc47334739991c6e0ed7b883044', '', '0', '0', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('173', '/public/uploads/picture/2017-04-10/58ea78f890081.png', '', 'a9e8476c71652114c1a8485948bc2eb3', '', '0', '0', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('174', '/public/uploads/picture/2017-04-10/58ea7bf470e88.jpg', '', 'e772bdc47334739991c6e0ed7b883044', '', '0', '0', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('175', '/public/uploads/picture/2017-04-27/59015a64a416f.png', '', 'aad4be71840752d8dbbc39e74c9acaef', '1533a5279b892edc075dd6413c7aa08ad2cd2978', '0', '1493260900', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('176', '/public/uploads/picture/2017-04-27/59015ab2ae242.png', '', '3c15c452b0634481b5ed31ece7fe8476', 'b941e181d8ac55a3229f9606f6b5589444bee74c', '0', '1493260978', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('177', '/public/uploads/picture/2017-04-27/59015ade4a915.jpg', '', '8258766e1b790fb7c1fe5a2a9caa65d0', 'd6ded094cff01419050eeb23c39ce85812bf2ce8', '0', '1493261022', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('178', '/public/uploads/picture/2017-04-27/59015b313731d.jpg', '', '8258766e1b790fb7c1fe5a2a9caa65d0', 'd6ded094cff01419050eeb23c39ce85812bf2ce8', '0', '1493261105', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('179', '/public/uploads/picture/2017-04-27/59015c4f2bbc7.png', '', 'e0f4a9ff4018d01a8ea9f372405426e7', 'e05fa3c0980421692ac72d712deb92e6f84b026a', '0', '1493261391', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('180', '/public/uploads/picture/2017-04-27/59015d2658d3a.jpg', '', '29e0e481e4642156586f85de4a56f241', '077944d495a9e2a9106ae86a4bed7b36a3200183', '0', '1493261606', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('181', '/public/uploads/picture/2017-04-27/590160abd4107.png', '', 'f7946d29cd2293bcef37768578592624', '4907c286571625da4bc04eb817513425a1eff329', '0', '1493262507', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('182', '/public/uploads/picture/2017-04-27/5901af9262172.jpg', '', 'd82b42da9052d7d0c9941607966bd68b', '89e4ce2c36bcd3fb0ba08675d6193ef49a7018cc', '0', '1493282706', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('183', '/public/uploads/picture/2017-04-27/5901afa1842a0.png', '', 'f7946d29cd2293bcef37768578592624', '4907c286571625da4bc04eb817513425a1eff329', '0', '1493282721', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('184', '/public/uploads/picture/2017-04-27/5901b05425217.png', '', 'f7946d29cd2293bcef37768578592624', '4907c286571625da4bc04eb817513425a1eff329', '0', '1493282900', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('185', '/public/uploads/picture/2017-04-27/5901b0cc729e2.png', '', 'f7946d29cd2293bcef37768578592624', '4907c286571625da4bc04eb817513425a1eff329', '0', '1493283020', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('186', '/public/uploads/picture/2017-04-27/5901b3c6051cc.jpg', '', '59895df03becec239632a8fa0c36b8d3', '90e3e6767eb9e6fa375fe4c0f6fc3fd62e4e5fc4', '0', '1493283782', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('187', '/public/uploads/picture/2017-06-03/593246bab5b4e.jpg', '', 'df18e2fba1ea9d775b62898993896f09', 'ea848e85275b794cddedac4605e1da14ab3fa980', '0', '1496467130', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('188', '/public/uploads/picture/2017-06-03/593246f20b365.png', '', '3db4a9c86c87941e35f64bada2989012', 'a2d9fd4a194ba1867f73aeb9e3e298e3844f1328', '0', '1496467186', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('189', '/public/uploads/picture/2017-06-03/59324718d315d.jpg', '', '12f46a2077e8613d9b7e0bd707f9e281', 'f7865b97e36f4c7e0a46a6ccc82ad3f0cc5a1006', '0', '1496467224', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('190', '/public/uploads/picture/2017-06-03/5932473a94475.png', '', 'dba4ab759283ce84a2f3db1c38a0251a', '0c58990f7e2dd14d866d8aa71acd3ad8cca2a3cb', '0', '1496467258', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('191', '/public/uploads/picture/2017-06-03/59324765b3951.png', '', 'dba4ab759283ce84a2f3db1c38a0251a', '0c58990f7e2dd14d866d8aa71acd3ad8cca2a3cb', '0', '1496467301', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('192', '/public/uploads/picture/2017-06-03/5932476f2b323.jpg', '', '92ebda32af67ee222a8761c039235f16', 'ad41c51ed019bbb7c5d1b341025098c0e82d2fab', '0', '1496467311', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('193', '/public/uploads/picture/2017-06-03/593247cf5672d.jpg', '', '12f46a2077e8613d9b7e0bd707f9e281', 'f7865b97e36f4c7e0a46a6ccc82ad3f0cc5a1006', '0', '1496467407', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('194', '/public/uploads/picture/2017-06-03/593247d5aff74.png', '', 'a658f9e720b91e0ea69d99b978bed497', '8e8a697972a17ceebc85367230c4516eac977dc9', '0', '1496467413', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('195', '/public/uploads/picture/2017-06-03/5932481da3fc0.jpg', '', 'df18e2fba1ea9d775b62898993896f09', 'ea848e85275b794cddedac4605e1da14ab3fa980', '0', '1496467485', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('196', '/public/uploads/picture/2017-06-03/593248237106d.jpg', '', '92ebda32af67ee222a8761c039235f16', 'ad41c51ed019bbb7c5d1b341025098c0e82d2fab', '0', '1496467491', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('197', '/public/uploads/picture/2017-06-03/593251449e0b3.jpg', '', '12f46a2077e8613d9b7e0bd707f9e281', 'f7865b97e36f4c7e0a46a6ccc82ad3f0cc5a1006', '0', '1496469828', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('198', '/public/uploads/picture/2017-06-03/5932514c5e670.png', '', '3db4a9c86c87941e35f64bada2989012', 'a2d9fd4a194ba1867f73aeb9e3e298e3844f1328', '0', '1496469836', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('199', '/public/uploads/picture/2017-06-03/593252a70d3ca.jpg', '', '92ebda32af67ee222a8761c039235f16', 'ad41c51ed019bbb7c5d1b341025098c0e82d2fab', '0', '1496470183', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('200', '/public/uploads/picture/2017-06-03/593252ab19939.jpg', '', 'df18e2fba1ea9d775b62898993896f09', 'ea848e85275b794cddedac4605e1da14ab3fa980', '0', '1496470187', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('201', '/public/uploads/picture/2017-06-04/59339aaf30f7e.jpg', '', 'df18e2fba1ea9d775b62898993896f09', 'ea848e85275b794cddedac4605e1da14ab3fa980', '0', '1496554159', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('202', '/public/uploads/picture/2017-06-04/59339ab4443fe.png', '', '3db4a9c86c87941e35f64bada2989012', 'a2d9fd4a194ba1867f73aeb9e3e298e3844f1328', '0', '1496554164', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('203', '/public/uploads/picture/2017-06-04/59339abc39975.jpg', '', 'e91d7b93dd88d79eb1ab6029b9420e87', '4f15a3484196aabef7996f514ec9079ff815a4b3', '0', '1496554172', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('204', '/public/uploads/picture/2017-06-08/59382de1f0c4d.png', '', 'ade99d895ebc71b9a9e52a08a451c1f6', 'b363746196da6d7a37ae7bb6cc79157dc0118b40', '0', '1496853985', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('205', '/public/uploads/picture/2017-06-08/59382e6989c21.jpg', '', 'df18e2fba1ea9d775b62898993896f09', 'ea848e85275b794cddedac4605e1da14ab3fa980', '0', '1496854121', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('206', '/public/uploads/picture/2017-06-08/5938321d1a0b8.jpg', '', 'df18e2fba1ea9d775b62898993896f09', 'ea848e85275b794cddedac4605e1da14ab3fa980', '0', '1496855069', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('207', '/public/uploads/picture/2017-06-10/593af2721c9df.jpg', '', '5332d77768534c1863d87e4660ee207b', '3c21386aa1f23038b1240680b079bed2f2a12097', '0', '1497035378', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('208', '/public/uploads/picture/2017-06-10/593af2ab73069.jpg', '', '618f425810aaee83564b2d5384c43500', '176ed5bdbf544fe8a67a1c53480b0d3a546fdb4b', '0', '1497035435', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('209', '/public/uploads/picture/2017-06-10/593b473d21a8d.jpg', '', 'f40309d6e909e5475c063c8502c9776c', '38f96bd641cdf99db3b5ce3e9fe568c98439f517', '0', '1497057085', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('210', '/public/uploads/picture/2017-06-10/593b4858b844a.jpg', '', 'a57729b797ee17917c3e5436d6d31e6d', '432e8e755ae89588dfd074f2dddb7f9829cde2af', '0', '1497057368', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('211', '/public/uploads/picture/2017-06-10/593b48aa7b751.jpg', '', '536c08c0a5cb10edaf1bac707c55025a', 'a26fb784f006c0a7192ed30ba87390c1a98e7c68', '0', '1497057450', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('212', '/public/uploads/picture/2017-06-10/593b48c2917d3.jpg', '', '38affd4dcca613daba37db6a9f91b204', 'e6c87d94ad2051d2072dbfc3f3c5108fc8195a21', '0', '1497057474', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('213', '/public/uploads/picture/2017-06-10/593b48cf7a6a4.jpg', '', '536c08c0a5cb10edaf1bac707c55025a', 'a26fb784f006c0a7192ed30ba87390c1a98e7c68', '0', '1497057487', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('214', '/public/uploads/picture/2017-06-10/593b48dfd1488.jpg', '', '244b2e7c149af541900f5c9cb3c17e0a', '5ba16ece19ec85058ee5ee62d6bd153305d0afbd', '0', '1497057503', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('215', '/public/uploads/picture/2017-06-10/593b49029c41a.jpg', '', '83ca6fb33e1164d3e4699849237bff10', 'de3c7e6e0ed67243daafa611c4b15d97a90789be', '0', '1497057538', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('216', '/public/uploads/picture/2017-06-10/593b492a3f651.jpg', '', 'f3e60ab5a1c41f282080c306301cc354', '6df99acc50de9fa7e48d1d274a9a0b3d4da14e32', '0', '1497057578', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('217', '/public/uploads/picture/2017-06-10/593b49652e774.jpg', '', '9633a7a94a30bb85ee65feb7745fd074', '93974ac32e0aa464213b5429827101606f251158', '0', '1497057637', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('218', '/public/uploads/picture/2017-06-10/593b49da4be8a.png', '', '6a42de2dc1c015959b6876fd0091bd99', 'acb907a5ef5c6310b526dd6f999d59b73147b164', '0', '1497057754', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('219', '/public/uploads/picture/2017-06-10/593b4a23873de.jpg', '', '536c08c0a5cb10edaf1bac707c55025a', 'a26fb784f006c0a7192ed30ba87390c1a98e7c68', '0', '1497057827', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('220', '/public/uploads/picture/2017-06-10/593b4be76841c.png', '', '4b34ceeb1a62296ac07c69542fc60ccc', 'e05700fdb4425424464cdfb551e7351b7ec76dbd', '0', '1497058279', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('221', '/public/uploads/picture/2017-06-10/593b4ca5b86a6.jpg', '', '570c2bc96240f2868469caebaee43565', 'b0c7aefc53eed5851f2c535d6df315ecd450e791', '0', '1497058469', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('222', '/public/uploads/picture/2017-06-10/593b4cc8b89ee.jpg', '', '8895b46e241808531b52238a66261e34', '8a775a65ac498e52c1277d9fc7c5de2659b906f1', '0', '1497058504', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('223', '/public/uploads/picture/2017-06-10/593b4cf227b4e.jpg', '', '0af856cabcfb15c409defd5a90900494', 'f5e0c8518d74761f4284c7dc6438b996e7f33817', '0', '1497058546', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('224', '/public/uploads/picture/2017-06-10/593b4e639e660.jpg', '', 'ece3884ec7bf17a0580b8856dde247aa', 'd5f0ce295385e2c2e8b546ccd55d1ceb29e69507', '0', '1497058915', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('225', '/public/uploads/picture/2017-06-10/593b50055245a.jpg', '', '239769d731a5eb504f1183722cde4d09', 'f53c5cf8f1300a5a247fff354a111d7008c56a4b', '0', '1497059333', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('226', '/public/uploads/picture/2017-06-10/593b5029f0f5c.jpg', '', '8f6dee1b82487959a34961811d6871f6', 'eed689df64393a45ab645b7b1299fe4486fd53b9', '0', '1497059369', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('227', '/public/uploads/picture/2017-06-10/593b505453a4c.jpg', '', 'fc13447d9ea4269f9067c68e0fa86eef', 'd80d828010ed09799809ae2b7c37f7aea33cdac9', '0', '1497059412', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('228', '/public/uploads/picture/2017-06-10/593b508b77396.jpg', '', '50d4f43e24ad56331fc41f05cf51699c', '55da9adddc17420b24832675704806babd21fcf6', '0', '1497059467', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('229', '/public/uploads/picture/2017-06-10/593b533ad646a.jpg', '', '2f6d092829f2dbe171479fae26dc7e02', '4368a3051dd1c35f3c60deacc9490004a28320f9', '0', '1497060154', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('230', '/public/uploads/picture/2017-06-10/593b56975d266.jpg', '', 'ece3884ec7bf17a0580b8856dde247aa', 'd5f0ce295385e2c2e8b546ccd55d1ceb29e69507', '0', '1497061015', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('231', '/public/uploads/picture/2017-06-11/593c6f8d00bae.jpg', '', 'eacd46878b826fc8f377282eced38a5f', '350435aff3cf87b546781320f3c67de752d0a88e', '0', '1497132941', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('232', '/public/uploads/picture/2017-06-11/593c7095e1a73.jpg', '', '205670ac324cd1516da2928cb4dbdebe', '58b847589eeeab811402f2047458a63d38197f45', '0', '1497133205', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('233', '/public/uploads/picture/2017-06-11/593c71358b2f8.jpg', '', '1268ecb74cdb78e9a00c3a7bd9f07cbb', '36664122deddb0965ad78f2263b69f85c273cde4', '0', '1497133365', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('234', '/public/uploads/picture/2017-06-11/593c71d37866e.jpg', '', '24d12a976c2b0387ed6582dd87f5dfd9', '0795b56a9ad6cf91ad98cbde4ba78243c864921b', '0', '1497133523', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('235', '/public/uploads/picture/2017-06-11/593c71e910c8f.jpg', '', '85e921f8946870510435ebc9d9cb073b', '8511e201fca9fc8561373d1c63bfc57b45043438', '0', '1497133545', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('236', '/public/uploads/picture/2017-06-11/593c722b21ce0.jpg', '', '8f6c1ab8a368c4608ad88b6f2e3d990a', 'd6971cef2494d08a9e2374b23df8f03228061579', '0', '1497133611', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('237', '/public/uploads/picture/2017-06-11/593c73c59ba63.jpg', '', '2643aad1795d84a1ddd4651584888533', 'f5481198541d4facc063c113d19cb24256369139', '0', '1497134021', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('238', '/public/uploads/picture/2017-06-11/593d619bc1557.png', '', '8a0e828202dc55abb32d581a650a499b', '7b2d18fc2c9970997fd65d8bc8fef11973b108ba', '0', '1497194907', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('239', '/public/uploads/picture/2017-06-11/593d66418184d.jpg', '', 'cd8289f0b5e2cce081e64cf728a3dad9', '77359403d19d2d7758a38816ffc25e92de6f5071', '0', '1497196097', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('240', '/public/uploads/picture/2017-06-11/593d668a0b335.jpg', '', '8258766e1b790fb7c1fe5a2a9caa65d0', 'd6ded094cff01419050eeb23c39ce85812bf2ce8', '0', '1497196170', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('241', '/public/uploads/picture/2017-06-11/593d66b13441e.png', '', '642eb204ee46c475e3663ee66412a064', 'a065eca31d835a10ad0739990aef1833858ed57c', '0', '1497196209', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('252', '/public/uploads/picture/2017-11-04/1509764207.jpg', '', '', '', '1', '1509764207', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('253', '/public/uploads/picture/2017-11-04/1509764309.jpg', '', '', '', '1', '1509764309', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('243', '/public/uploads/picture/2017-06-12/593d720ba26b3.jpg', '', 'cc40bf13003b952c6cb8fe128522ec21', '21984feb63ba59495d667e2ed765e0e4d90dbd94', '0', '1497199115', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('244', '/public/uploads/picture/2017-06-18/594565c199a91.jpg', '', '685b1133c2fb45479218b2acd6a8b852', 'd8145cf3becdf9e0fdeb24b43cd0cee1518a4699', '0', '1497720257', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('245', '/public/uploads/picture/2017-06-18/5945725f48956.png', '', 'a16a431bbb61e642b18b940b1473dfd3', 'f4398e7803c4a9bf6430e44be134f335f46a0914', '0', '1497723487', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('260', '/public/uploads/picture/2017-11-04/1509767146.jpg', '', '', '', '1', '1509767146', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('261', '/public/uploads/picture/2017-11-04/1509767152.jpg', '', '', '', '1', '1509767152', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('258', '/public/uploads/picture/2017-11-04/1509766137.jpg', '', '', '', '1', '1509766137', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('259', '/public/uploads/picture/2017-11-04/1509767121.jpg', '', '', '', '1', '1509767121', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('256', '/public/uploads/picture/2017-11-04/1509764517.jpg', '', '', '', '1', '1509764517', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('257', '/public/uploads/picture/2017-11-04/1509764709.jpg', '', '', '', '1', '1509764709', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('254', '/public/uploads/picture/2017-11-04/1509764326.jpg', '', '', '', '1', '1509764326', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('255', '/public/uploads/picture/2017-11-04/1509764474.jpg', '', '', '', '1', '1509764474', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('250', '/public/uploads/picture/2017-10-04/59d49d19e995b.png', '', 'e52be7fe9f76f0b2d20440d01c75b51a', 'b9294fe039b5daedf352ef1c9d0a4dc269c4f423', '0', '1507106073', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('251', '/public/uploads/picture/2017-10-07/59d88b31c73ea.gif', '', '927d4a2ecfc5380f4b35efe256104c9f', '14644b7ff9b25cd5ec113e3ab7659290b7c81f6a', '0', '1507363633', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('262', '/public/uploads/picture/2017-11-04/1509767768.jpg', '', '', '', '1', '1509767768', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('263', '/public/uploads/picture/2017-11-04/1509767785.jpg', '', '', '', '1', '1509767785', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('264', '/public/uploads/picture/2017-11-04/1509767848.jpg', '', '', '', '1', '1509767848', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('265', '/public/uploads/picture/2017-11-04/1509767938.jpg', '', '', '', '1', '1509767938', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('266', '/public/uploads/picture/2017-11-04/1509768029.jpg', '', '', '', '1', '1509768029', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('267', '/public/uploads/picture/2017-11-04/1509768183.jpg', '', '', '', '1', '1509768183', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('268', '/public/uploads/picture/2017-11-04/1509768213.jpg', '', '', '', '1', '1509768213', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('269', '/public/uploads/picture/2017-11-04/1509768258.jpg', '', '', '', '1', '1509768258', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('270', '/public/uploads/picture/2017-11-04/1509768364.jpg', '', '', '', '1', '1509768364', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('271', '/public/uploads/picture/2017-11-04/1509768371.jpg', '', '', '', '1', '1509768371', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('272', '/public/uploads/picture/2017-11-04/1509768375.jpg', '', '', '', '1', '1509768375', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('273', '/public/uploads/picture/2017-11-04/1509768484.jpg', '', '', '', '1', '1509768484', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('274', '/public/uploads/picture/2017-11-04/1509768556.jpg', '', '', '', '1', '1509768556', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('275', '/public/uploads/picture/2017-11-04/1509768616.jpg', '', '', '', '1', '1509768616', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('276', '/public/uploads/picture/2017-11-04/1509768733.jpg', '', '', '', '1', '1509768733', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('277', '/public/uploads/picture/2017-11-04/1509768791.jpg', '', '', '', '1', '1509768791', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('278', '/public/uploads/picture/2017-11-04/1509768797.jpg', '', '', '', '1', '1509768797', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('279', '/public/uploads/picture/2017-11-04/1509768842.jpg', '', '', '', '1', '1509768842', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('280', '/public/uploads/picture/2017-11-04/1509768864.jpg', '', '', '', '1', '1509768864', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('281', '/public/uploads/picture/2017-11-04/1509768989.jpg', '', '', '', '1', '1509768989', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('282', '/public/uploads/picture/2017-11-04/1509774996.jpg', '', '', '', '1', '1509774996', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('283', '/public/uploads/picture/2017-11-04/1509775088.jpg', '', '', '', '1', '1509775088', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('284', '/public/uploads/picture/2017-11-04/1509775098.jpg', '', '', '', '1', '1509775098', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('285', '/public/uploads/picture/2017-11-04/1509776126.jpg', '', '', '', '1', '1509776126', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('286', '/public/uploads/picture/2017-11-04/1509776284.jpg', '', '', '', '1', '1509776284', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('287', '/public/uploads/picture/2017-11-04/1509776887.jpg', '', '', '', '1', '1509776887', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('288', '/public/uploads/picture/2017-11-04/1509776974.jpg', '', '', '', '1', '1509776974', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('289', '/public/uploads/picture/2017-11-04/1509776995.jpg', '', '', '', '1', '1509776995', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('290', '/public/uploads/picture/2017-11-04/1509777008.jpg', '', '', '', '1', '1509777008', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('291', '/public/uploads/picture/2017-11-04/1509777060.jpg', '', '', '', '1', '1509777060', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('292', '/public/uploads/picture/2017-11-04/1509777944.jpg', '', '', '', '1', '1509777944', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('293', '/public/uploads/picture/2017-11-04/1509778821.jpg', '', '', '', '1', '1509778821', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('294', '/public/uploads/picture/2017-11-04/1509778828.jpg', '', '', '', '1', '1509778828', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('295', '/public/uploads/picture/2017-11-04/1509788391.jpg', '', '', '', '1', '1509788391', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('296', '/public/uploads/picture/2017-11-04/1509788398.jpg', '', '', '', '1', '1509788398', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('297', '/public/uploads/picture/2017-11-04/1509788431.jpg', '', '', '', '1', '1509788431', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('298', '/public/uploads/picture/2017-11-04/1509788440.jpg', '', '', '', '1', '1509788440', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('299', '/public/uploads/picture/2017-11-04/1509788469.jpg', '', '', '', '1', '1509788469', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('300', '/public/uploads/picture/2017-11-04/1509788610.jpg', '', '', '', '1', '1509788610', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('301', '/public/uploads/picture/2017-11-04/1509788628.jpg', '', '', '', '1', '1509788628', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('302', '/public/uploads/picture/2017-11-04/1509788835.jpg', '', '', '', '1', '1509788835', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('303', '/public/uploads/picture/2017-11-04/1509788851.jpg', '', '', '', '1', '1509788851', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('304', '/public/uploads/picture/2017-11-04/1509788982.jpg', '', '', '', '1', '1509788982', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('305', '/public/uploads/picture/2017-11-04/1509789038.jpg', '', '', '', '1', '1509789038', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('306', '/public/uploads/picture/2017-11-04/1509789055.jpg', '', '', '', '1', '1509789055', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('307', '/public/uploads/picture/2017-11-04/1509789339.jpg', '', '', '', '1', '1509789339', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('308', '/public/uploads/picture/2017-11-04/1509789347.jpg', '', '', '', '1', '1509789347', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('309', '/public/uploads/picture/2017-11-04/1509789494.jpg', '', '', '', '1', '1509789494', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('310', '/public/uploads/picture/2017-11-04/1509790026.jpg', '', '', '', '1', '1509790026', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('311', '/public/uploads/picture/2017-11-04/1509790033.jpg', '', '', '', '1', '1509790033', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('312', '/public/uploads/picture/2017-11-04/1509790249.jpg', '', '', '', '1', '1509790249', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('313', '/public/uploads/picture/2017-11-04/1509790257.jpg', '', '', '', '1', '1509790257', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('314', '/public/uploads/picture/2017-11-04/1509793893.jpg', '', '', '', '1', '1509793893', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('315', '/public/uploads/picture/2017-11-04/1509793969.jpg', '', '', '', '1', '1509793969', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('316', '/public/uploads/picture/2017-11-04/1509794136.jpg', '', '', '', '1', '1509794136', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('317', '/public/uploads/picture/2017-11-04/1509794168.jpg', '', '', '', '1', '1509794168', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('318', '/public/uploads/picture/2017-11-04/1509794190.jpg', '', '', '', '1', '1509794190', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('319', '/public/uploads/picture/2017-11-04/1509794471.jpg', '', '', '', '1', '1509794471', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('320', '/public/uploads/picture/2017-11-04/1509794559.jpg', '', '', '', '1', '1509794559', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('321', '/public/uploads/picture/2017-11-04/1509794563.jpg', '', '', '', '1', '1509794563', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('322', '/public/uploads/picture/2017-11-04/1509794567.jpg', '', '', '', '1', '1509794567', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('323', '/public/uploads/picture/2017-11-04/1509794971.jpg', '', '', '', '1', '1509794971', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('324', '/public/uploads/picture/2017-11-04/1509794984.jpg', '', '', '', '1', '1509794984', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('325', '/public/uploads/picture/2017-11-04/1509795815.jpg', '', '', '', '1', '1509795815', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('326', '/public/uploads/picture/2017-11-04/1509796230.jpg', '', '', '', '1', '1509796230', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('327', '/public/uploads/picture/2017-11-04/1509796692.jpg', '', '', '', '1', '1509796692', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('328', '/public/uploads/picture/2017-11-06/1509907313.jpg', '', '', '', '1', '1509907313', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('329', '/public/uploads/picture/2017-11-06/1509907337.jpg', '', '', '', '1', '1509907337', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('330', '/public/uploads/picture/2017-11-06/1509907467.jpg', '', '', '', '1', '1509907467', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('331', '/public/uploads/picture/2017-11-06/1509907531.jpg', '', '', '', '1', '1509907531', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('332', '/public/uploads/picture/2017-11-06/1509907751.jpg', '', '', '', '1', '1509907751', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('333', '/public/uploads/picture/2017-11-06/1509907987.jpg', '', '', '', '1', '1509907987', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('334', '/public/uploads/picture/2017-11-06/1509908117.jpg', '', '', '', '1', '1509908117', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('335', '/public/uploads/picture/2017-11-06/1509908203.jpg', '', '', '', '1', '1509908203', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('336', '/public/uploads/picture/2017-11-06/1509908206.jpg', '', '', '', '1', '1509908206', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('337', '/public/uploads/picture/2017-11-06/1509908277.jpg', '', '', '', '1', '1509908277', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('338', '/public/uploads/picture/2017-11-06/1509909114.jpg', '', '', '', '1', '1509909114', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('339', '/public/uploads/picture/2017-11-06/1509909120.jpg', '', '', '', '1', '1509909120', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('340', '/public/uploads/picture/2017-11-06/1509909193.jpg', '', '', '', '1', '1509909193', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('341', '/public/uploads/picture/2017-11-06/1509909295.jpg', '', '', '', '1', '1509909295', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('342', '/public/uploads/picture/2017-11-06/1509909380.jpg', '', '', '', '1', '1509909380', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('343', '/public/uploads/picture/2017-11-06/1509909396.jpg', '', '', '', '1', '1509909396', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('344', '/public/uploads/picture/2017-11-06/1509909486.jpg', '', '', '', '1', '1509909486', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('345', '/public/uploads/picture/2017-11-06/1509909558.jpg', '', '', '', '1', '1509909558', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('346', '/public/uploads/picture/2017-11-06/1509909638.jpg', '', '', '', '1', '1509909638', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('347', '/public/uploads/picture/2017-11-06/1509909645.jpg', '', '', '', '1', '1509909645', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('348', '/public/uploads/picture/2017-11-06/1509909698.jpg', '', '', '', '1', '1509909698', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('349', '/public/uploads/picture/2017-11-06/1509910076.jpg', '', '', '', '1', '1509910076', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('350', '/public/uploads/picture/2017-11-06/1509936498.jpg', '', '', '', '1', '1509936498', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('351', '/public/uploads/picture/2017-11-06/1509936564.jpg', '', '', '', '1', '1509936564', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('352', '/public/uploads/picture/2017-11-06/1509936614.jpg', '', '', '', '1', '1509936614', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('353', '/public/uploads/picture/2017-11-06/1509936698.jpg', '', '', '', '1', '1509936698', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('354', '/public/uploads/picture/2017-11-06/1509936841.jpg', '', '', '', '1', '1509936841', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('355', '/public/uploads/picture/2017-11-06/1509937018.jpg', '', '', '', '1', '1509937018', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('356', '/public/uploads/picture/2017-11-06/1509937133.jpg', '', '', '', '1', '1509937133', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('357', '/public/uploads/picture/2017-11-06/1509937244.jpg', '', '', '', '1', '1509937244', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('358', '/public/uploads/picture/2017-11-19/1511030221.jpg', '', '', '', '1', '1511030221', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('359', '/public/uploads/picture/2017-11-27/1511717517.jpg', '', '', '', '1', '1511717517', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('360', '/public/uploads/picture/2017-11-27/1511717612.jpg', '', '', '', '1', '1511717612', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('361', '/public/uploads/picture/2017-11-27/1511717656.jpg', '', '', '', '1', '1511717656', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('362', '/public/uploads/picture/2017-11-27/1511722538.jpg', '', '', '', '1', '1511722538', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('363', '/public/uploads/picture/2017-11-27/1511722690.jpg', '', '', '', '1', '1511722690', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('364', '/public/uploads/picture/2017-11-27/1511723165.jpg', '', '', '', '1', '1511723165', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('365', '/public/uploads/picture/2017-11-27/1511724412.jpg', '', '', '', '1', '1511724412', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('366', '/public/uploads/picture/2017-11-27/1511724464.jpg', '', '', '', '1', '1511724464', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('367', '/public/uploads/picture/2017-12-05/1512476667.jpg', '', '', '', '1', '1512476667', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('368', '/public/uploads/picture/2017-12-05/1512476751.jpg', '', '', '', '1', '1512476751', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('369', '/public/uploads/picture/2017-12-05/1512476796.jpg', '', '', '', '1', '1512476796', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('370', '/public/uploads/picture/2017-12-13/1513112743.jpg', '', '', '', '1', '1513112743', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('371', '/public/uploads/picture/2017-12-13/1513113066.jpg', '', '', '', '1', '1513113066', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('372', '/public/uploads/picture/2017-12-13/1513113397.jpg', '', '', '', '1', '1513113397', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('373', '/public/uploads/picture/2017-12-13/1513113513.jpg', '', '', '', '1', '1513113513', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('374', '/public/uploads/picture/2017-12-13/1513113938.jpg', '', '', '', '1', '1513113938', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('375', '/public/uploads/picture/2017-12-13/1513113981.jpg', '', '', '', '1', '1513113981', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('376', '/public/uploads/picture/2017-12-13/1513114264.jpg', '', '', '', '1', '1513114264', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('377', '/public/uploads/picture/2017-12-13/1513114393.jpg', '', '', '', '1', '1513114393', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('378', '/public/uploads/picture/2017-12-13/1513114409.jpg', '', '', '', '1', '1513114409', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('379', '/public/uploads/picture/2017-12-13/1513114476.jpg', '', '', '', '1', '1513114476', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('380', '/public/uploads/picture/2017-12-13/1513120326.jpg', '', '', '', '1', '1513120326', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('381', '/public/uploads/picture/2017-12-13/1513120363.jpg', '', '', '', '1', '1513120363', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('382', '/public/uploads/picture/2017-12-13/1513120464.jpg', '', '', '', '1', '1513120464', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('383', '/public/uploads/picture/2017-12-13/1513120596.jpg', '', '', '', '1', '1513120596', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('384', '/public/uploads/picture/2017-12-13/1513120740.jpg', '', '', '', '1', '1513120740', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('385', '/public/uploads/picture/2017-12-13/1513120854.jpg', '', '', '', '1', '1513120854', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('386', '/public/uploads/picture/2017-12-13/1513121077.jpg', '', '', '', '1', '1513121077', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('387', '/public/uploads/picture/2017-12-31/1514712571.jpg', '', '', '', '1', '1514712571', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('388', '/public/uploads/picture/2017-12-31/1514712577.jpg', '', '', '', '1', '1514712577', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('389', '/public/uploads/picture/2017-12-31/1514712584.jpg', '', '', '', '1', '1514712584', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('390', '/public/uploads/picture/2017-12-31/1514712588.jpg', '', '', '', '1', '1514712588', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('391', '/public/uploads/picture/2017-12-31/1514713465.jpg', '', '', '', '1', '1514713465', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('392', '/public/uploads/picture/2017-12-31/1514713482.jpg', '', '', '', '1', '1514713482', '', '0', '', '');
INSERT INTO `yer_attachment` VALUES ('393', '/public/uploads/picture/20180323/acbad249da651b0d33f71117873e8c9c.jpg', '', '', '', '1', '1521764062', 'jpg', '1', '15416', '5717a95ae4b0a3162509557b.230x230.jpg');
INSERT INTO `yer_attachment` VALUES ('394', '/public/uploads/picture/20180323/47c63440b95cae2352fc4e49f0fcdedf.jpg', '', '', '', '1', '1521767405', 'jpg', '1', '15416', '5717a95ae4b0a3162509557b.230x230.jpg');
INSERT INTO `yer_attachment` VALUES ('395', '/public/uploads/picture/20180413/91ff269f56e24c7039ce12e746997190.jpg', '', '', '', '1', '1523575865', 'jpg', '1', '41557', 'timg (1).jpg');
INSERT INTO `yer_attachment` VALUES ('396', '/public/uploads/picture/20180413/9ff4f0f9c0c238d76fb5cc7baf9a8b84.jpg', '', '', '', '1', '1523575964', 'jpg', '1', '44074', 'timg.jpg');
INSERT INTO `yer_attachment` VALUES ('397', '/public/uploads/picture/20180414/c8bb05d69bec5c7dcef6facb2e0e2fcb.jpg', '', '', '', '1', '1523682189', 'jpg', '1', '14033', '下载.jpg');
INSERT INTO `yer_attachment` VALUES ('398', '/public/uploads/picture/20180414/6bbcbf2e0444b2c9d96011df7df0d30d.jpg', '', '', '', '1', '1523682372', 'jpg', '1', '14033', '下载.jpg');
INSERT INTO `yer_attachment` VALUES ('399', '/public/uploads/picture/20180414/cb7a9f7734f2f74fe34353e4c9949391.jpg', '', '', '', '1', '1523682440', 'jpg', '1', '14033', '下载.jpg');
INSERT INTO `yer_attachment` VALUES ('400', '/public/uploads/picture/20180414/dc874694ef85fd2418e0b9ccc82de88c.jpg', '', '', '', '1', '1523682838', 'jpg', '1', '54455', '100108492174748689picA_1.jpg');
INSERT INTO `yer_attachment` VALUES ('401', '/public/uploads/picture/20180414/28fc25a63346acf9b5b8b970bda09e87.jpg', '', '', '', '1', '1523682969', 'jpg', '1', '204121', '0000000000-000000000174748689_1.jpg');
INSERT INTO `yer_attachment` VALUES ('402', '/public/uploads/picture/20180414/50162a2561bc8f310d6b47019c26deca.jpg', '', '', '', '1', '1523683074', 'jpg', '1', '124454', '0000000000-000000000124818483_1.jpg');
INSERT INTO `yer_attachment` VALUES ('403', '/public/uploads/picture/20180414/63d13d912e9ca954dd9d774b4700de58.jpg', '', '', '', '1', '1523683123', 'jpg', '1', '136282', '0000000000-000000000176305331_2.jpg');
INSERT INTO `yer_attachment` VALUES ('404', '/public/uploads/picture/20180414/36130ca5c1f35c44d792a86e659752f8.jpg', '', '', '', '1', '1523683188', 'jpg', '1', '171305', '0000000000-000000000633296969_1.jpg');
INSERT INTO `yer_attachment` VALUES ('405', '/public/uploads/picture/20180414/6488198bd60105ca810b51cd43ed65d4.jpg', '', '', '', '1', '1523683349', 'jpg', '1', '90456', '0000000000-000000000109802658_1.jpg');
INSERT INTO `yer_attachment` VALUES ('406', '/public/uploads/picture/20180414/3b2748c6064c2a97df143d64b0d77a2a.jpg', '', '', '', '1', '1523683401', 'jpg', '1', '120063', '0000000000-000000000155520007_1.jpg');
INSERT INTO `yer_attachment` VALUES ('407', '/public/uploads/picture/20180414/269e5ebbf26dc27ef736af73dbb30744.jpg', '', '', '', '1', '1523683526', 'jpg', '1', '185549', '0000000000-000000000149659011_2.jpg');
INSERT INTO `yer_attachment` VALUES ('408', '/public/uploads/picture/20180414/9a9c6735441c4a55741e37dcfb0ced3c.jpg', '', '', '', '1', '1523683580', 'jpg', '1', '556689', '0000000000-000000000127191157_2.jpg');
INSERT INTO `yer_attachment` VALUES ('409', '/public/uploads/picture/20180414/f1b42dc00a45f036d57c1769c9af5334.jpg', '', '', '', '1', '1523683669', 'jpg', '1', '144609', '0000000000-000000000626364062_2.jpg');
INSERT INTO `yer_attachment` VALUES ('410', '/public/uploads/picture/20180414/cd648d4c0437eaaf4082b2e362968f16.jpg', '', '', '', '1', '1523683796', 'jpg', '1', '188295', '0000000000-000000000104243087_2.jpg');
INSERT INTO `yer_attachment` VALUES ('411', '/public/uploads/picture/20180423/c077995da5cb03ad6170bf05fbe003a3.jpg', '', '', '', '1', '1524462010', 'jpg', '1', '97654', 'TB25JBbmXXXXXatXXXXXXXXXXXX_!!309886021.jpg_400x400.jpg_.webp (1).jpg');
INSERT INTO `yer_attachment` VALUES ('412', '/public/uploads/picture/20180423/b16c11f1fec684da9d58c4701c599239.jpg', '', '', '', '1', '1524462630', 'jpg', '1', '135645', 'TB2bABzXbOJ.eBjy1XaXXbNupXa_!!309886021.jpg_400x400.jpg_.webp.jpg');
INSERT INTO `yer_attachment` VALUES ('413', '/public/uploads/picture/20180423/9246d4a68d11c896c3227b38f3774755.jpg', '', '', '', '1', '1524462791', 'jpg', '1', '58772', 'TB2dKdObbuWBuNjSszgXXb8jVXa_!!75859100.jpg_400x400.jpg_.webp.jpg');
INSERT INTO `yer_attachment` VALUES ('414', '/public/uploads/picture/20180423/97a92378147a5e0fa99f99d3ad469e66.jpg', '', '', '', '1', '1524462915', 'jpg', '1', '84375', 'TB2dKdObbuWBuNjSszgXXb8jVXa_!!75859100.jpg');
INSERT INTO `yer_attachment` VALUES ('415', '/public/uploads/picture/20180423/88b1507e45e52f8e0bc25a852380a7f5.jpg', '', '', '', '1', '1524462920', 'jpg', '1', '194069', 'TB2MuhObbuWBuNjSszgXXb8jVXa_!!75859100.jpg');
INSERT INTO `yer_attachment` VALUES ('416', '/public/uploads/picture/20180423/a59056150b392f96e171cc719c2aed95.jpg', '', '', '', '1', '1524462934', 'jpg', '1', '21027', 'TB2_B82bb9YBuNjy0FgXXcxcXXa_!!75859100.jpg_400x400.jpg_.webp.jpg');
INSERT INTO `yer_attachment` VALUES ('417', '/public/uploads/picture/20180423/70ae44fa50f463816ecf4b51dbb86b60.jpg', '', '', '', '1', '1524463104', 'jpg', '1', '41056', 'TB2AsS2eSBYBeNjy0FeXXbnmFXa_!!827873810-0-item_pic.jpg_430x430q90.jpg');
INSERT INTO `yer_attachment` VALUES ('418', '/public/uploads/picture/20180423/9bd36425fd91b57699e3e57d9beb2f98.jpg', '', '', '', '1', '1524463180', 'jpg', '1', '47397', 'TB2NFBMeGmWBuNjy1XaXXXCbXXa_!!827873810.jpg_430x430q90.jpg');
INSERT INTO `yer_attachment` VALUES ('419', '/public/uploads/picture/20180423/b26f1dfede86dd2b998f4a9bb38e947d.jpg', '', '', '', '1', '1524463186', 'jpg', '1', '40025', 'TB2IMdnXLNZWeJjSZFpXXXjBFXa_!!1796610007.jpg_430x430q90.jpg');
INSERT INTO `yer_attachment` VALUES ('420', '/public/uploads/picture/20180423/3f48f2fc3131515cdaae34561e9b29e1.jpg', '', '', '', '1', '1524471089', 'jpg', '1', '40025', 'TB2IMdnXLNZWeJjSZFpXXXjBFXa_!!1796610007.jpg_430x430q90.jpg');
INSERT INTO `yer_attachment` VALUES ('421', '/public/uploads/picture/20180424/f2e58cc3735a92aea1c876a9b5b554c8.jpg', '', '', '', '1', '1524511385', 'jpg', '1', '37958', '5a51eb79N3d872884.jpg');
INSERT INTO `yer_attachment` VALUES ('422', '/public/uploads/picture/20180424/189c1b0cc4bed79a2ea91dfb8bbdc86b.jpg', '', '', '', '1', '1524512335', 'jpg', '1', '127441', '5981d8b4N829af261.jpg');
INSERT INTO `yer_attachment` VALUES ('423', '/public/uploads/picture/20180424/249a75cb67f90577cd6c015a83801383.jpg', '', '', '', '1', '1524512529', 'jpg', '1', '12812', '5ac242f2N70412aed.jpg');
INSERT INTO `yer_attachment` VALUES ('424', '/public/uploads/picture/20180424/db6a6d9da0c4f66b58b3f2b4839abecc.jpg', '', '', '', '1', '1524512674', 'jpg', '1', '12686', '55f269bdNaeeed77c.jpg');
INSERT INTO `yer_attachment` VALUES ('425', '/public/uploads/picture/20180428/e3e64e42c4a98a3c909ebe4bc2a3fd42.jpg', '', '', '', '1', '1524853505', 'jpg', '1', '8418', '590067a1Nc27f04fe.jpg');
INSERT INTO `yer_attachment` VALUES ('426', '/public/uploads/picture/20180428/4f188be9f224b1b7c16c5683fa19b7b4.jpg', '', '', '', '1', '1524853541', 'jpg', '1', '20954', '59bb6677N70278118.jpg!q80.webp.jpg');
INSERT INTO `yer_attachment` VALUES ('427', '/public/uploads/picture/20180428/a8521e612dede5a4e7a267d3eff36793.jpg', '', '', '', '1', '1524853610', 'jpg', '1', '37818', '5a72dec6N3bd64d43.jpg');
INSERT INTO `yer_attachment` VALUES ('428', '/public/uploads/picture/20180428/d2b85c3d9ce98c1660a058fb73ca643d.jpg', '', '', '', '1', '1524853686', 'jpg', '1', '14408', '5a431eb6N0db60e76.jpg!q80.webp.jpg');
INSERT INTO `yer_attachment` VALUES ('429', '/public/uploads/picture/20180428/08869bbbcadb8f5e5b0ad03bc9a05bc7.jpg', '', '', '', '1', '1524853734', 'jpg', '1', '23511', '58573635Nff99b235.jpg');
INSERT INTO `yer_attachment` VALUES ('430', '/public/uploads/picture/20180428/2c4a0e1a614279b423bb8fd1a7d1d995.jpg', '', '', '', '1', '1524853778', 'jpg', '1', '56471', '5a51d14eNa115e050.jpg');
INSERT INTO `yer_attachment` VALUES ('431', '/public/uploads/picture/20180428/e3ae61b47599d39fffc663b0ea959c57.jpg', '', '', '', '1', '1524853832', 'jpg', '1', '5962', '58b6744aNb11a6cc3.jpg!q90.jpg');
INSERT INTO `yer_attachment` VALUES ('432', '/public/uploads/picture/20180428/1a4290c2ce145e329cfd66b9148faeb0.jpg', '', '', '', '1', '1524853939', 'jpg', '1', '11782', '53faaa96N2afb4c64.jpg!q90.webp.jpg');
INSERT INTO `yer_attachment` VALUES ('433', '/public/uploads/picture/20180428/bbbfab8f19c0666f0308e5d9939dfeef.jpg', '', '', '', '1', '1524853993', 'jpg', '1', '45810', '5ae14aa8N65d4d369.jpg');
INSERT INTO `yer_attachment` VALUES ('434', '/public/uploads/picture/20180428/4fbb69f6448066b36edd2c9d1fd17e0c.jpg', '', '', '', '1', '1524854014', 'jpg', '1', '40496', '5aa5fa4cNbeb988c9.jpg');
INSERT INTO `yer_attachment` VALUES ('435', '/public/uploads/picture/20180428/844ef1a9300b4b362038eeb1f8b99809.jpg', '', '', '', '1', '1524866995', 'jpg', '1', '81203', '5a31e7f2Nbbbdf3db.jpg');
INSERT INTO `yer_attachment` VALUES ('436', '/public/uploads/picture/20180428/22374078076e21990e8fb59177339548.jpg', '', '', '', '1', '1524867042', 'jpg', '1', '40496', '5aa5fa4cNbeb988c9.jpg');
INSERT INTO `yer_attachment` VALUES ('440', '/public/uploads/picture/20180629/7a6aa50e7a5d316b0635b406d42cc05c.jpg', '', '', '', '1', '1530219007', 'jpg', '1', '40496', '22374078076e21990e8fb59177339548.jpg');
INSERT INTO `yer_attachment` VALUES ('445', '/public/uploads/picture/20180716/d480a92b04e50dee9cd0086df793f624.jpg', '', '', '', '1', '1531735599', 'jpg', '1', '192857', 'TB1vkDZEhWYBuNjy1zkSutGGpXa.jpg_q100.jpg_.webp.jpg');
INSERT INTO `yer_attachment` VALUES ('444', '/public/uploads/picture/20180716/21f1a68e916aba08dc13a9093de6c05a.jpg', '', '', '', '1', '1531735540', 'jpg', '1', '192857', 'TB1vkDZEhWYBuNjy1zkSutGGpXa.jpg_q100.jpg_.webp.jpg');
INSERT INTO `yer_attachment` VALUES ('443', '/public/uploads/picture/20180710/713d296bf90bb19783c722472720263b.gif', '', '', '', '1', '1531195909', 'gif', '1', '3521', 'logo_pic.gif');
INSERT INTO `yer_attachment` VALUES ('446', '/public/uploads/picture/20180716/66ae51d4b03b507d9d7181e20dde2b25.jpg', '', '', '', '1', '1531740353', 'jpg', '1', '23550', 'TB1_ZV3yHSYBuNjSspiSutNzpXa.jpg');
INSERT INTO `yer_attachment` VALUES ('447', '/public/uploads/picture/20180716/4572ddf9f80200b2e9268176ca11d0fe.png', '', '', '', '1', '1531742409', 'png', '1', '35144', 'TB2f8NVu5CYBuNkHFCcXXcHtVXa_!!151-2-luban.png_240x5000q100.png');
INSERT INTO `yer_attachment` VALUES ('448', '/public/uploads/picture/20180716/f500e6bbf5fccea20494f010696ec556.png', '', '', '', '1', '1531742438', 'png', '1', '27645', '56.png');
INSERT INTO `yer_attachment` VALUES ('449', '/public/uploads/picture/20180716/4edfda71749ff3ca393945d279a34264.jpg', '', '', '', '1', '1531749847', 'jpg', '1', '190362', '1.webp.jpg');
INSERT INTO `yer_attachment` VALUES ('450', '/public/uploads/picture/20180716/c4df671ab2b2ec635b06560ba4cbc92c.jpg', '', '', '', '1', '1531749877', 'jpg', '1', '192441', '2.webp.jpg');
INSERT INTO `yer_attachment` VALUES ('451', '/public/uploads/picture/20180716/3926450e22a9866a9f139c8124f1876c.jpg', '', '', '', '1', '1531749982', 'jpg', '1', '136234', 'TB1XbKEEnlYBeNjSszcXXbwhFXa-476-538.jpg_500x1000q75s0.jpg_.webp.jpg');
INSERT INTO `yer_attachment` VALUES ('452', '/public/uploads/picture/20180716/2bebe011960bf654cc113c40b0f50a5d.jpg', '', '', '', '1', '1531750016', 'jpg', '1', '178220', '4.webp.jpg');
INSERT INTO `yer_attachment` VALUES ('453', '/public/uploads/picture/20180716/443ff53c4ba53ec9b1c24e6280708c5d.jpg', '', '', '', '1', '1531750042', 'jpg', '1', '149883', '5.webp.jpg');
INSERT INTO `yer_attachment` VALUES ('454', '/public/uploads/picture/20180720/9be3903cd4babe24692ae70ac3237542.jpg', '', '', '', '1', '1532094389', 'jpg', '1', '175496', 'TB1NIErwsuYBuNkSmRySuwA3pXa.jpg');
INSERT INTO `yer_attachment` VALUES ('455', '/public/uploads/picture/20180720/09d7d1dd7ac0d1058773fdd04473ce92.jpg', '', '', '', '1', '1532094536', 'jpg', '1', '245824', 'TB2Yg.sw_dYBeNkSmLyXXXfnVXa-1714128138.jpg');
INSERT INTO `yer_attachment` VALUES ('456', '/public/uploads/picture/20180720/6c6b8f4f94f0ef457164c4d0d352ec1c.jpg', '', '', '', '1', '1532094675', 'jpg', '1', '103552', 'TB1FNzxDgmTBuNjy1XbXXaMrVXa-468-1236.jpg');
INSERT INTO `yer_attachment` VALUES ('457', '/public/uploads/picture/20180720/271b4a7e77b4d7aaa9aee33a8a27e52b.jpg', '', '', '', '1', '1532094724', 'jpg', '1', '181576', 'TB1HS58EYSYBuNjSspiSutNzpXa.jpg');
INSERT INTO `yer_attachment` VALUES ('458', '/public/uploads/picture/20180720/f390d772d0a337ceeb260f909d63b017.jpg', '', '', '', '1', '1532094867', 'jpg', '1', '189444', 'TB18UKMbuySBuNjy1zdXXXPxFXa-468-1236.jpg');
INSERT INTO `yer_attachment` VALUES ('459', '/public/uploads/picture/20180720/181c99382fe478c5e537defc99f7e4cf.jpg', '', '', '', '1', '1532094898', 'jpg', '1', '116683', 'TB1uDEvJFXXXXbAXVXXvMNvHpXX-460-780.jpg');
INSERT INTO `yer_attachment` VALUES ('460', '/public/uploads/picture/20180724/554511767008e4dd00fe33efff24b7cf.jpg', '', '', '', '1', '1532371918', 'jpg', '1', '103552', 'TB1FNzxDgmTBuNjy1XbXXaMrVXa-468-1236.jpg');
INSERT INTO `yer_attachment` VALUES ('461', '/public/uploads/picture/20180724/1d8fcb5fb87097732ae7de3e944c71b4.jpg', '', '', '', '1', '1532372010', 'jpg', '1', '136400', '5b51a712N9c1e947e.jpg');
INSERT INTO `yer_attachment` VALUES ('462', '/public/uploads/picture/20180724/07806cdeb1ab661bb1d939eca1bf05e8.jpg', '', '', '', '1', '1532372094', 'jpg', '1', '136400', '5b519547Nbe5180fc.jpg');
INSERT INTO `yer_attachment` VALUES ('463', '/public/uploads/picture/20180724/39c3e67450ac4562196e6126a0b38c6a.jpg', '', '', '', '1', '1532372111', 'jpg', '1', '136400', '5b51a712N9c1e947e.jpg');
INSERT INTO `yer_attachment` VALUES ('464', '/public/uploads/picture/20180724/e116a4808adea53c1e7a7cd12bdbfd2e.jpg', '', '', '', '1', '1532372164', 'jpg', '1', '136400', '5b51a712N9c1e947e.jpg');
INSERT INTO `yer_attachment` VALUES ('465', '/public/uploads/picture/20180724/e3ff286c9686528d93c451b8f44125bf.jpg', '', '', '', '1', '1532372176', 'jpg', '1', '13960', '5b557c8dN76763b67.jpg');
INSERT INTO `yer_attachment` VALUES ('466', '/public/uploads/picture/20190122/64fbec70ef9a340f75631c0efaed15a7.png', '', '', '', '1', '1548154110', 'png', '1', '4229', '贝云4.png');
INSERT INTO `yer_attachment` VALUES ('467', '/public/uploads/picture/20190206/a8de1682674bffc23ae7142af949b4fe.jpg', '', '', '', '1', '1549425899', 'jpg', '1', '25841', 'u=1500915263,1513583227&fm=26&gp=0.jpg');
INSERT INTO `yer_attachment` VALUES ('468', '/public/uploads/picture/20190206/3482bd10cf1cf045a46f19d62fe3440e.jpg', '', '', '', '1', '1549427293', 'jpg', '1', '12134', 'gg.jpg');
INSERT INTO `yer_attachment` VALUES ('469', '/public/uploads/picture/20190206/cc03559f31206fc40c52977bb9136dfc.jpg', '', '', '', '1', '1549457718', 'jpg', '1', '39896', '1121373789-1_e_3.jpg');
INSERT INTO `yer_attachment` VALUES ('532', '/public/uploads/picture/20191209/3720dd698089bd3c83e8f190e9b81301.jpg', '', '', '', '1', '1575873035', 'jpg', '1', '94187', '1580139244-1_k_1.jpg');
INSERT INTO `yer_attachment` VALUES ('531', '/public/uploads/picture/20191209/bf99b1a1f776190090cb604c6c1e0130.png', '', '', '', '1', '1575872606', 'png', '1', '281', 'icleft.png');
INSERT INTO `yer_attachment` VALUES ('473', '/public/uploads/picture/20190708/3598866dabf7f83d89a3720b23ed0df7.jpg', '', '', '', '1', '1562585990', 'jpg', '1', '94691', '1-1603061G41GV.jpg');
INSERT INTO `yer_attachment` VALUES ('474', '/public/uploads/picture/20190708/3136ff201ba90981d4e5bac31a6047d7.jpg', '', '', '', '1', '1562586103', 'jpg', '1', '94691', '1-1603061G41GV.jpg');
INSERT INTO `yer_attachment` VALUES ('475', '/public/uploads/picture/20190708/07c22be68424c767bff1a2b9637c307a.jpg', '', '', '', '1', '1562586112', 'jpg', '1', '7084', '1528647169549.jpg');
INSERT INTO `yer_attachment` VALUES ('476', '/public/uploads/picture/20190708/2387c2b68743e23e3a20c9e8b888b1c7.jpg', '', '', '', '1', '1562586171', 'jpg', '1', '94691', '1-1603061G41GV.jpg');
INSERT INTO `yer_attachment` VALUES ('477', '/public/uploads/picture/20190708/ed75960252a86c8a776a89daa46c6cba.png', '', '', '', '1', '1562586178', 'png', '1', '730798', '017ca458b780a5a801219c77e157e8.PNG@2o.png');
INSERT INTO `yer_attachment` VALUES ('536', '/public/uploads/picture/20191209/24e4bf57f2427aba40a9a179155441bb.jpg', '', '', '', '1', '1575875118', 'jpg', '1', '96093', 'd846b840-3ac4-4bbb-8c73-0f7ef84e993e_420_420.jpg');
INSERT INTO `yer_attachment` VALUES ('535', '/public/uploads/picture/20191209/76245ad6b0fe054fbc26e9acb0a2adf3.jpg', '', '', '', '1', '1575874907', 'jpg', '1', '229666', 'eda50015-010a-44f7-995d-a3c9d8dc64eb_420_420.jpg');
INSERT INTO `yer_attachment` VALUES ('533', '/public/uploads/picture/20191209/c529703f51444c8d26f8f5667621b04e.jpg', '', '', '', '1', '1575873147', 'jpg', '1', '85402', '1419412325-1_k_3.jpg');
INSERT INTO `yer_attachment` VALUES ('534', '/public/uploads/picture/20191209/dd7ee60339cfba2c043f7c7b19b5436b.jpg', '', '', '', '1', '1575873669', 'jpg', '1', '75682', 'f59e3594-e3ea-4568-875d-ca1a202bb738_420_420.jpg');
INSERT INTO `yer_attachment` VALUES ('529', '/public/uploads/picture/20191204/2dd0d89d519cd19630f251ff386bfcfe.gif', '', '', '', '1', '1575423510', 'gif', '1', '3082', 'spxq_pic_02.gif');
INSERT INTO `yer_attachment` VALUES ('530', '/public/uploads/picture/20191204/97c04f9905450e85922b40606ce808a0.png', '', '', '', '1', '1575423868', 'png', '1', '59105', 'index_banner_01.png');
INSERT INTO `yer_attachment` VALUES ('528', '/public/uploads/picture/20191204/2a3190aca970819b8fe95ea5e4df443a.gif', '', '', '', '1', '1575423505', 'gif', '1', '6207', '73a488ca3a9f8a86dd9e53d809d4b615.gif');
INSERT INTO `yer_attachment` VALUES ('537', '/public/uploads/picture/20200411/6deb4a73e9ff6985432b4b2490690658.jpg', '', '', '', '1', '1586579265', 'jpg', '1', '7319', '1557566529748.jpg');
INSERT INTO `yer_attachment` VALUES ('538', '/public/uploads/picture/20200411/5c79612d2f3833948f1a93268218997f.jpg', '', '', '', '1', '1586579282', 'jpg', '1', '7328', '1557389277721.jpg');
INSERT INTO `yer_attachment` VALUES ('539', '/public/uploads/picture/20200411/6920abcdaf75ef826e7c880d9e2fc3b4.jpg', '', '', '', '1', '1586579307', 'jpg', '1', '9313', '1557566579080.jpg');
INSERT INTO `yer_attachment` VALUES ('540', '/public/uploads/picture/20200411/63dc1f2ea8c365a258b92a62d9cc754e.png', '', '', '', '1', '1586579406', 'png', '1', '54166', 'topic-2.png');
INSERT INTO `yer_attachment` VALUES ('541', '/public/uploads/picture/20200413/f473c2e3f2152c34306f62885751c376.png', '', '', '', '1', '1586789848', 'png', '1', '5650', 'logo.png');
INSERT INTO `yer_attachment` VALUES ('542', '/public/uploads/picture/20200428/ef0748fb3b0487e34e1a6168c09ba96f.jpg', '', '', '', '1', '1588047547', 'jpg', '1', '76050', '30d20353f6e75e5a.jpg');
INSERT INTO `yer_attachment` VALUES ('543', '/public/uploads/picture/20200529/c4335c89e93dea1270529bd75814c70c.jpg', '', '', '', '1', '1590759042', 'jpg', '1', '31939', 'u=3753332979,1341785886&fm=26&gp=0.jpg');
INSERT INTO `yer_attachment` VALUES ('544', '/public/uploads/picture/20200601/3c7be07de819c674187514dd26f765f8.jpg', '', '', '', '1', '1590979910', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.UPSKeDWkvqQY0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('545', '/public/uploads/picture/20200601/78457006b4131448fc4745e45d5d2826.jpg', '', '', '', '1', '1590979987', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.U6V2FsC76WVY0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('546', '/public/uploads/picture/20200601/f7825cc541af996b1b4ed1a45f7dfca3.jpg', '', '', '', '1', '1590980144', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.GdERzXObCYKn101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `yer_attachment` VALUES ('547', '/public/uploads/picture/20200601/0dd8c4fdcd8a0f9caf77f52f5f7a5d20.jpg', '', '', '', '1', '1590980215', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.b6MlSiICaaML0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('548', '/public/uploads/picture/20200601/7a7ab0b2a2b103ea16f68990d12bc84e.png', '', '', '', '1', '1590980355', 'png', '1', '133535', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.QOQG0O8t1iKYda23f04aa4474878c2611c05bf136ded.png');
INSERT INTO `yer_attachment` VALUES ('549', '/public/uploads/picture/20200601/cea954724f47f139f325d96be522ca6c.jpg', '', '', '', '1', '1590980395', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.itBnLIy9yDXr0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('550', '/public/uploads/picture/20200601/cfc7daa92e5b7bba6b72c3bf4be610f8.jpg', '', '', '', '1', '1590980471', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.uWuoGtRYilp4101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `yer_attachment` VALUES ('551', '/public/uploads/picture/20200601/63922ab76459ecc370b092e3dc89617d.jpg', '', '', '', '1', '1590980555', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.dMUl6JUEv2bU0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('552', '/public/uploads/picture/20200601/9dcb4b6585b48fb7959638ac2085a1de.jpg', '', '', '', '1', '1590980606', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.GBZ5dl566SBv0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('553', '/public/uploads/picture/20200601/45e9ca49c4b20be52d1eb321c9b6d9f6.jpg', '', '', '', '1', '1590980671', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.aMLwLy7Siozl0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('554', '/public/uploads/picture/20200601/4112cc85b7d3a547c8165879d078afbc.jpg', '', '', '', '1', '1590980752', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.klpNgCTHJxe80fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('555', '/public/uploads/picture/20200601/999debf59397aff340d8f59da591a7a0.jpg', '', '', '', '1', '1590980885', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.QOEzf8rYfc7p0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('556', '/public/uploads/picture/20200601/064a045016377be626b6fac22fe727ec.jpg', '', '', '', '1', '1590980976', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.IThYFTpWkgtY0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('557', '/public/uploads/picture/20200601/488efa8bfe06480425ce10dedb12a18c.jpg', '', '', '', '1', '1590981039', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.MPzYrlOjyr050fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('558', '/public/uploads/picture/20200601/aad698d89da6d5eba6386d3dc241e1fe.jpg', '', '', '', '1', '1590981319', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.6wiZdWwVrQcI0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('559', '/public/uploads/picture/20200601/8c28bb5e1b230c049398c0c25ebbe93e.jpg', '', '', '', '1', '1590981514', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.lyGBhIPCcmHg0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('560', '/public/uploads/picture/20200601/11e27d60e480e3a9c1c0d964297d25fe.jpg', '', '', '', '1', '1590981592', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.Yt0QNJHeyQ6I0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('561', '/public/uploads/picture/20200601/cf1aaa7639398a3ce382f5b43ff48cc2.jpg', '', '', '', '1', '1590981690', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.579EteR4k87h0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('562', '/public/uploads/picture/20200601/5aa5b3de99b5f517f17ff67c32217074.jpg', '', '', '', '1', '1590981722', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.P0HcGU6V1aiH0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('563', '/public/uploads/picture/20200601/398918193e6914261c266d12aa222325.jpg', '', '', '', '1', '1590981768', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.rApSqTb9CSHJ0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('564', '/public/uploads/picture/20200601/213f8a11570b67ad18f12c43c27f8379.jpg', '', '', '', '1', '1591004501', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.evUouGmJwceo101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `yer_attachment` VALUES ('565', '/public/uploads/picture/20200602/8d726284ea055c13d0f4b0c7f4908c17.jpg', '', '', '', '1', '1591062310', 'jpg', '1', '8176', 'u=3881948964,3937096216&fm=26&gp=0.jpg');
INSERT INTO `yer_attachment` VALUES ('566', '/public/uploads/picture/20200602/fd8a49ea571381fa78b4a9a0e039b1fb.jpg', '', '', '', '1', '1591062390', 'jpg', '1', '108816', '下载.jpg');
INSERT INTO `yer_attachment` VALUES ('567', '/public/uploads/attachment/20200602/9160e6628b40c5fb2f557913f44f0c58.jpg', '', '', '', '1', '1591101142', 'jpg', '3', '13885', 'tmp_c8e943894f7de1cef207765a60aacbd672047d84932bc47b.jpg');
INSERT INTO `yer_attachment` VALUES ('568', '/public/uploads/picture/20200611/dc99da38eed37b1cd413c3f0e0f6b4b7.jpg', '', '', '', '1', '1591849850', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.YDU6SGMQA6TE0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('569', '/public/uploads/picture/20200611/7078281206f953258bd60878deb10765.jpg', '', '', '', '1', '1591849909', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.0PKfuz3Zvdmy0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('570', '/public/uploads/picture/20200611/978e22ad562808193ef953079c926273.jpg', '', '', '', '1', '1591849927', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.OlniJTnQ6C2b101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `yer_attachment` VALUES ('571', '/public/uploads/picture/20200611/d9c736fd724c9e28b920b41975e09433.jpg', '', '', '', '1', '1591850240', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.vtuwAr1eFByv0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('572', '/public/uploads/picture/20200611/75a18794b79c20c820122fb5c367d97d.jpg', '', '', '', '1', '1591850318', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.eeod5Xm5dv7Z0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('573', '/public/uploads/picture/20200611/6bac70fdf5554bacd648d725ac0fd175.jpg', '', '', '', '1', '1591850325', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.IO2kyd4ACvAx0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('574', '/public/uploads/picture/20200611/686e9e11b3ee6a24902a521ba109c46b.jpg', '', '', '', '1', '1591853277', 'jpg', '1', '13885', 'tmp_102977cedc221b4996d1452a68cdc2b10155d753784d1eb8.jpg');
INSERT INTO `yer_attachment` VALUES ('575', '/public/uploads/picture/20200611/a4f7fef8c78598b1437a5fea8639384a.jpg', '', '', '', '1', '1591861482', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.LESZmIOH8jbD0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('576', '/public/uploads/picture/20200611/d6eaa34fa8aeac57a9bfb2fb91bae87b.jpg', '', '', '', '1', '1591861503', 'jpg', '1', '1481', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.fdNsGhyMEEuQ3cc8b90dc59b95a304bb660d0afc52e7.jpg');
INSERT INTO `yer_attachment` VALUES ('577', '/public/uploads/picture/20200611/3e7c8f127b1e98fdd8cfbebc1b09dbb9.jpg', '', '', '', '1', '1591861573', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.fWjlHrPjqLU40fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('578', '/public/uploads/picture/20200611/97767a7fe3080f7beecd1998196f1e5f.jpg', '', '', '', '1', '1591861792', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.d7DKtPW7Jk4s101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `yer_attachment` VALUES ('579', '/public/uploads/picture/20200611/89e45bea4213cb50671bc08a383fc8f8.jpg', '', '', '', '1', '1591861826', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.LPEmKyRmrI5Q101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `yer_attachment` VALUES ('580', '/public/uploads/picture/20200611/b7e63c25c22c1363362d47cf04c3cc98.jpg', '', '', '', '1', '1591862119', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.3WvURJrdBeeY0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('581', '/public/uploads/picture/20200611/c4b31d8504fa359b6495499beff278c2.png', '', '', '', '1', '1591862126', 'png', '1', '50618', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.JRO5HBg51qFbf4d2ac70ce414264e6ade89b1087b828.png');
INSERT INTO `yer_attachment` VALUES ('582', '/public/uploads/picture/20200611/fad70fd0f9be413b8ccf939eae0fd89e.jpg', '', '', '', '1', '1591862796', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.u2gVOPG2f1zu0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('583', '/public/uploads/picture/20200611/d375e3f8a1352a033fb39decaedc1711.jpg', '', '', '', '1', '1591862810', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.Zw7O6NC7p6Ag101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `yer_attachment` VALUES ('584', '/public/uploads/picture/20200611/d845d4ca0e45c22bf7ac44cb2ef6f04f.jpg', '', '', '', '1', '1591863180', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.iubtWfoQRycN0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('585', '/public/uploads/picture/20200611/7b34491779d13efad792f23a08fc5fbc.jpg', '', '', '', '1', '1591863190', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.Amkb32irTjIY101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `yer_attachment` VALUES ('586', '/public/uploads/picture/20200611/a09fc6d8a275bff4906b05e565cc3622.jpg', '', '', '', '1', '1591863478', 'jpg', '1', '23812', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.YzcBhUg1eapo0fe40343da8d026f8f64294775a9f8aa.jpg');
INSERT INTO `yer_attachment` VALUES ('587', '/public/uploads/picture/20200611/ab12b34e89ace3a5b8864a18aa54fa86.jpg', '', '', '', '1', '1591863484', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.XvSEnYR3oAV1101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `yer_attachment` VALUES ('588', '/public/uploads/picture/20200612/a19b73decbcd7239b81a36e74c27de13.jpg', '', '', '', '1', '1591977331', 'jpg', '1', '81160', 'tmp_fdd5b9337009ef09447ba9aedab19ea1c4656d6a24ab2eef.jpg');
INSERT INTO `yer_attachment` VALUES ('589', '/public/uploads/picture/20200614/0ab0271cf5218377fe3ae810c20c0716.jpg', '', '', '', '1', '1592066326', 'jpg', '1', '13885', 'tmp_59481455c931f8d928b6e61b2b2356423f7e358fef339cb4.jpg');
INSERT INTO `yer_attachment` VALUES ('590', '/public/uploads/picture/20200617/cb62e565235e03bc9da058e77e0b589b.jpg', '', '', '', '1', '1592399033', 'jpg', '1', '1562', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.TzfkluidcTFc6627ab38f27e06577409c7201443e934.jpg');
INSERT INTO `yer_attachment` VALUES ('591', '/public/uploads/picture/20200617/0fde3853490db68a36495a44948d06bb.jpg', '', '', '', '1', '1592399043', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.Qqs0P9ONLyAl101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `yer_attachment` VALUES ('592', '/public/uploads/picture/20200617/8044d8bb488e451a166d633a1deeb908.png', '', '', '', '1', '1592399176', 'png', '1', '50618', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.ysfXawnRGb2qf4d2ac70ce414264e6ade89b1087b828.png');
INSERT INTO `yer_attachment` VALUES ('593', '/public/uploads/picture/20200617/adb2fa1f3f03fa18337b0312f10c82b7.jpg', '', '', '', '1', '1592399190', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.XvvifvHW4pOv101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `yer_attachment` VALUES ('594', '/public/uploads/picture/20200617/f8ff9c42b759fdc8f1c3f46a867f8505.jpg', '', '', '', '1', '1592399369', 'jpg', '1', '71519', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.0d7WQeMYMdae101706cbb99c5862dde7ea3741d4ff53.jpg');
INSERT INTO `yer_attachment` VALUES ('595', '/public/uploads/picture/20200617/7a722add090ed65b1fb82a77f81968bb.jpg', '', '', '', '1', '1592399534', 'jpg', '1', '10410', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.wCKOE6i2xoQL508ae5c7ffe4d60193eeb1a0f8924e26.jpg');
INSERT INTO `yer_attachment` VALUES ('596', '/public/uploads/picture/20200617/7fa271e052f8b17c29f925a2ba336afa.jpg', '', '', '', '1', '1592399570', 'jpg', '1', '18654', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.PcsKXpaa9Sev2dae826d32dad3564cdca5a923cc4b9c.jpg');
INSERT INTO `yer_attachment` VALUES ('597', '/public/uploads/picture/20200618/a1e80b86503af1953a02a6e09da85c1b.jpg', '', '', '', '1', '1592447863', 'jpg', '1', '10410', 'wx5370124f8b9dbd91.o6zAJswnuUAaMjxKpm-k7pau49fU.xDxP7nYP9DHH508ae5c7ffe4d60193eeb1a0f8924e26.jpg');
INSERT INTO `yer_attachment` VALUES ('598', '/public/uploads/picture/20200618/db2a1c476f358824844f7cfd9958fc03.jpg', '', '', '', '1', '1592452413', 'jpg', '1', '81160', 'tmp_866c355759bb13f4cce0b9a94ce20dae70f96c92f5c3620e.jpg');

-- ----------------------------
-- Table structure for yer_attributes
-- ----------------------------
DROP TABLE IF EXISTS `yer_attributes`;
CREATE TABLE `yer_attributes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `title` varchar(225) CHARACTER SET utf8 DEFAULT NULL,
  `sort` int(10) NOT NULL DEFAULT '0',
  `types_id` int(10) NOT NULL DEFAULT '0',
  `type` int(2) DEFAULT '0',
  `value` varchar(225) CHARACTER SET utf8 DEFAULT NULL,
  `is_show` int(2) NOT NULL DEFAULT '1',
  `short_title` varchar(225) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=270 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC COMMENT='商品属性表';

-- ----------------------------
-- Records of yer_attributes
-- ----------------------------
INSERT INTO `yer_attributes` VALUES ('24', '0', '笔记本定位', '1', '44', '0', ' 商务办公、高清游戏、学生', '1', '');
INSERT INTO `yer_attributes` VALUES ('75', '24', '学生', '0', '44', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('72', '24', ' 商务办公', '0', '44', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('73', '24', '高清游戏', '0', '44', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('74', '24', 'kk', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('76', '0', '颜色', '0', '42', '0', '红色、白色、橙色、绿色', '1', '');
INSERT INTO `yer_attributes` VALUES ('80', '76', '红色', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('81', '76', '白色', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('82', '76', '橙色', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('83', '76', '绿色', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('84', '0', '人群', '0', '42', '0', '青年、青少年、老年、情侣装、大码人群、中年', '1', '');
INSERT INTO `yer_attributes` VALUES ('85', '84', '青年', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('86', '84', '青少年', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('87', '84', '老年', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('88', '84', '情侣装', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('89', '84', '大码人群', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('90', '84', '中年', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('91', '0', '版型', '0', '42', '0', '超修身、标准型、宽松型', '1', '');
INSERT INTO `yer_attributes` VALUES ('92', '91', '超修身', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('93', '91', '标准型', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('94', '91', '宽松型', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('95', '0', '上市时间', '0', '42', '0', '2016春季、2016夏季、往季、2017冬季、2017夏季、2017春季', '1', '');
INSERT INTO `yer_attributes` VALUES ('96', '95', '2016春季', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('97', '95', '2016夏季', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('98', '95', '往季', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('99', '95', '2017冬季', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('100', '95', '2017夏季', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('101', '95', '2017春季', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('102', '0', '领型', '0', '42', '0', '扣领、尖领、撞色领、方领、礼服领、立领、翻领、连帽', '1', '');
INSERT INTO `yer_attributes` VALUES ('103', '102', '扣领', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('104', '102', '尖领', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('105', '102', '撞色领', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('106', '102', '方领', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('107', '102', '礼服领', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('108', '102', '立领', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('109', '102', '翻领', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('110', '102', '连帽', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('111', '0', '风格', '0', '42', '0', '清新日系、欧美风格、青春休闲、运动休闲、英伦风格、精致韩风、嘻哈风格、商务正装、商务休闲、时尚休闲', '1', '');
INSERT INTO `yer_attributes` VALUES ('112', '111', '清新日系', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('113', '111', '欧美风格', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('114', '111', '青春休闲', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('115', '111', '运动休闲', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('116', '111', '英伦风格', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('117', '111', '精致韩风', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('118', '111', '嘻哈风格', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('119', '111', '商务正装', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('120', '111', '商务休闲', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('121', '111', '时尚休闲', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('122', '0', '分类', '0', '41', '0', '每日坚果、长寿果/碧根果、夏威夷果、开心果、腰果、松子、巴西松子、杏仁/巴旦木、核桃', '1', '');
INSERT INTO `yer_attributes` VALUES ('123', '122', '每日坚果', '0', '41', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('124', '122', '长寿果/碧根果', '0', '41', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('125', '122', '夏威夷果', '0', '41', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('126', '122', '开心果', '0', '41', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('127', '122', '腰果', '0', '41', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('128', '122', '松子', '0', '41', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('129', '122', '巴西松子', '0', '41', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('130', '122', '杏仁/巴旦木', '0', '41', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('131', '122', '核桃', '0', '41', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('132', '0', '产地', '0', '41', '0', '中国大陆、美国、马来西亚、泰国、港澳台、韩国、澳洲 、其它', '1', '');
INSERT INTO `yer_attributes` VALUES ('133', '132', '中国大陆', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('134', '132', '美国', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('135', '132', '马来西亚', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('136', '132', '泰国', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('137', '132', '港澳台', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('138', '132', '韩国', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('139', '132', '澳洲 ', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('140', '132', '其它', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('141', '0', '口味', '0', '41', '0', '原味、炭烧、奶油味、五香味、麻辣味、椒盐味、盐焗味、蒜香味、芥末味、紫薯味', '1', '');
INSERT INTO `yer_attributes` VALUES ('142', '141', '原味', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('143', '141', '炭烧', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('144', '141', '奶油味', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('145', '141', '五香味', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('146', '141', '麻辣味', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('147', '141', '椒盐味', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('148', '141', '盐焗味', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('149', '141', '蒜香味', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('150', '141', '芥末味', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('151', '141', '紫薯味', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('152', '0', '国产/进口', '0', '41', '0', '国产、进口', '1', '');
INSERT INTO `yer_attributes` VALUES ('153', '152', '国产', '0', '41', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('154', '152', '进口', '0', '41', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('155', '0', '包装', '0', '41', '0', '礼盒装、组合装、独立小包装、袋装、罐装', '1', '');
INSERT INTO `yer_attributes` VALUES ('156', '155', '礼盒装', '0', '41', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('157', '155', '组合装', '0', '41', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('158', '155', '独立小包装', '0', '41', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('159', '155', '袋装', '0', '41', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('160', '155', '罐装', '0', '41', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('161', '0', '特性', '0', '41', '0', '带皮、果仁', '1', '');
INSERT INTO `yer_attributes` VALUES ('162', '161', '带皮', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('163', '161', '果仁', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('164', '0', '系统', '0', '43', '0', '安卓、苹果、微软、基础功能机', '1', '');
INSERT INTO `yer_attributes` VALUES ('177', '164', '微软', '0', '43', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('176', '164', '苹果', '0', '43', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('175', '164', '安卓', '0', '43', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('169', '0', '屏幕尺寸', '0', '43', '0', '5.6英寸及以上、5.5-5.1英寸、5.0-4.6英寸、4.5-3.1英寸、3.0英寸及以下', '1', '');
INSERT INTO `yer_attributes` VALUES ('170', '169', '5.6英寸及以上', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('171', '169', '5.5-5.1英寸', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('172', '169', '5.0-4.6英寸', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('173', '169', '4.5-3.1英寸', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('174', '169', '3.0英寸及以下', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('180', '0', '材质', '0', '43', '0', '塑料、合金、木制', '1', '');
INSERT INTO `yer_attributes` VALUES ('179', '164', '基础功能机', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('181', '180', '塑料', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('182', '180', '合金', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('183', '180', '木制', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('184', '0', '热点', '0', '42', '0', '以旧换新、功能机、儿童手机、合约机、全面屏、直板键盘、翻盖、商务手机、安全手机', '1', '');
INSERT INTO `yer_attributes` VALUES ('185', '184', '以旧换新', '0', '42', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('186', '184', '功能机', '0', '42', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('187', '184', '儿童手机', '0', '42', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('188', '184', '合约机', '0', '42', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('189', '184', '全面屏', '0', '42', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('190', '184', '直板键盘', '0', '42', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('191', '184', '翻盖', '0', '42', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('192', '184', '商务手机', '0', '42', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('193', '184', '安全手机', '0', '42', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('194', '0', '网络', '0', '43', '0', '移动4G/联通4G/电信4G、移动4G+、移动4G、联通4G、电信4G、双卡单4G、双卡双4G、双卡2G网络', '1', '');
INSERT INTO `yer_attributes` VALUES ('195', '194', '移动4G/联通4G/电信4G', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('196', '194', '移动4G+', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('197', '194', '移动4G', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('198', '194', '联通4G', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('199', '194', '电信4G', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('200', '194', '双卡单4G', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('201', '194', '双卡双4G', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('202', '194', '双卡2G网络', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('203', '0', '运行内存', '0', '43', '0', '8GB、6GB、4GB、3GB、2GB、2GB以下', '1', '');
INSERT INTO `yer_attributes` VALUES ('211', '0', '购买方式', '0', '43', '0', '移动合约、联通合约、电信合约', '1', '');
INSERT INTO `yer_attributes` VALUES ('205', '203', '8GB', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('206', '203', '6GB', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('207', '203', '4GB', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('208', '203', '3GB', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('209', '203', '2GB', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('210', '203', '2GB以下', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('212', '211', '移动合约', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('213', '211', '联通合约', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('214', '211', '电信合约', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('215', '0', '前置摄像头像素', '0', '43', '0', '1600万及以上、800万-1599万、500万-799万、200万-499万120万-199万、120万以下', '1', '');
INSERT INTO `yer_attributes` VALUES ('216', '215', '1600万及以上', '0', '43', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('217', '215', '800万-1599万', '0', '43', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('218', '215', '500万-799万', '0', '43', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('219', '215', '200万-499万120万-199万', '0', '43', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('220', '215', '120万以下', '0', '43', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('221', '0', '分类', '0', '45', '0', '微型车、小型车、紧凑型车、中型车、中大型车、豪华车、MPV', '1', '');
INSERT INTO `yer_attributes` VALUES ('222', '221', '微型车', '0', '45', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('223', '221', '小型车', '0', '45', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('224', '221', '紧凑型车', '0', '45', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('225', '221', '中型车', '0', '45', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('226', '221', '中大型车', '0', '45', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('227', '221', '豪华车', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('228', '221', 'MPV', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('229', '0', '国别', '0', '45', '0', '不限、自主、合资', '1', '');
INSERT INTO `yer_attributes` VALUES ('230', '229', '不限', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('231', '229', '自主', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('232', '229', '合资', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('233', '0', '级别', '0', '45', '0', '微型车、小型车、紧凑型车、中型车、中大型车、SUV、MPV 皮卡', '1', '');
INSERT INTO `yer_attributes` VALUES ('234', '233', 'SUV', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('235', '233', 'MPV 皮卡', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('236', '0', '相关分类', '0', '46', '0', '市场营销、企业管理与培训、管理学、项目管理、经济计划与管理、管理/电子商务、参考工具书', '1', '');
INSERT INTO `yer_attributes` VALUES ('237', '236', '市场营销', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('238', '236', '企业管理与培训', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('239', '236', '管理学', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('240', '236', '项目管理', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('241', '236', '经济计划与管理', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('242', '236', '管理/电子商务', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('243', '236', '参考工具书', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('244', '0', '出版社', '0', '46', '0', '电子工业出版社、机械工业出版社、人民邮电出版社、科学出版社、中国社会科学出版社、清华大学出版社、北京大学出版社、东南大学出版社、武汉大学出版社', '1', '');
INSERT INTO `yer_attributes` VALUES ('245', '244', '电子工业出版社', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('246', '244', '机械工业出版社', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('247', '244', '人民邮电出版社', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('248', '244', '科学出版社', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('249', '244', '中国社会科学出版社', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('250', '244', '清华大学出版社', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('251', '244', '北京大学出版社', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('252', '244', '东南大学出版社', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('253', '244', '武汉大学出版社', '0', '0', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('254', '0', '市场营销类型', '0', '46', '0', '销售管理、广告管理、品牌管理、产品管理、渠道管理、价格管理、客户服务、公共关系、国际市场、互联网', '1', '');
INSERT INTO `yer_attributes` VALUES ('255', '254', '销售管理', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('256', '254', '广告管理', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('257', '254', '品牌管理', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('258', '254', '产品管理', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('259', '254', '渠道管理', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('260', '254', '价格管理', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('261', '254', '客户服务', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('262', '254', '公共关系', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('263', '254', '国际市场', '0', '46', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('265', '264', '876', '0', '47', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('266', '264', '7687', '0', '47', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('268', '264', '567', '0', '47', '0', '', '1', '');
INSERT INTO `yer_attributes` VALUES ('269', '254', '互联网', '0', '46', '0', '', '1', '');

-- ----------------------------
-- Table structure for yer_auth_extend
-- ----------------------------
DROP TABLE IF EXISTS `yer_auth_extend`;
CREATE TABLE `yer_auth_extend` (
  `group_id` mediumint(10) unsigned NOT NULL COMMENT '用户id',
  `extend_id` mediumint(8) unsigned NOT NULL COMMENT '扩展表中数据的id',
  `type` tinyint(1) unsigned NOT NULL COMMENT '扩展类型标识 1:栏目分类权限;2:模型权限',
  UNIQUE KEY `group_extend_type` (`group_id`,`extend_id`,`type`) USING BTREE,
  KEY `uid` (`group_id`) USING BTREE,
  KEY `group_id` (`extend_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='用户组与分类的对应关系表';

-- ----------------------------
-- Records of yer_auth_extend
-- ----------------------------
INSERT INTO `yer_auth_extend` VALUES ('1', '1', '1');
INSERT INTO `yer_auth_extend` VALUES ('1', '1', '2');
INSERT INTO `yer_auth_extend` VALUES ('1', '2', '1');
INSERT INTO `yer_auth_extend` VALUES ('1', '2', '2');
INSERT INTO `yer_auth_extend` VALUES ('1', '3', '1');
INSERT INTO `yer_auth_extend` VALUES ('1', '3', '2');
INSERT INTO `yer_auth_extend` VALUES ('1', '4', '1');
INSERT INTO `yer_auth_extend` VALUES ('1', '37', '1');

-- ----------------------------
-- Table structure for yer_auth_group
-- ----------------------------
DROP TABLE IF EXISTS `yer_auth_group`;
CREATE TABLE `yer_auth_group` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户组id,自增主键',
  `module` varchar(20) NOT NULL DEFAULT '' COMMENT '用户组所属模块',
  `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '组类型',
  `title` char(20) NOT NULL DEFAULT '' COMMENT '用户组中文名称',
  `description` varchar(80) NOT NULL DEFAULT '' COMMENT '描述信息',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '用户组状态：为1正常，为0禁用,-1为删除',
  `rules` varchar(500) NOT NULL DEFAULT '' COMMENT '用户组拥有的规则id，多个规则 , 隔开',
  `group_id` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of yer_auth_group
-- ----------------------------
INSERT INTO `yer_auth_group` VALUES ('6', 'admin', '1', '营销', '', '1', '74,77', '0');
INSERT INTO `yer_auth_group` VALUES ('7', 'admin', '1', '财务', '', '1', '74,77,78,127,128,129,133', '0');
INSERT INTO `yer_auth_group` VALUES ('8', 'admin', '1', '物流', '', '1', '', '0');
INSERT INTO `yer_auth_group` VALUES ('4', 'admin', '1', '客服', '', '1', '142,144,148,167', '0');
INSERT INTO `yer_auth_group` VALUES ('5', 'admin', '1', '运营', '', '1', '148', '0');

-- ----------------------------
-- Table structure for yer_auth_group_access
-- ----------------------------
DROP TABLE IF EXISTS `yer_auth_group_access`;
CREATE TABLE `yer_auth_group_access` (
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `group_id` mediumint(8) unsigned NOT NULL COMMENT '用户组id',
  `id` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `uid_group_id` (`uid`,`group_id`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE,
  KEY `group_id` (`group_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
-- Records of yer_auth_group_access
-- ----------------------------
INSERT INTO `yer_auth_group_access` VALUES ('6', '3', '0');
INSERT INTO `yer_auth_group_access` VALUES ('6', '2', '0');

-- ----------------------------
-- Table structure for yer_auth_rule
-- ----------------------------
DROP TABLE IF EXISTS `yer_auth_rule`;
CREATE TABLE `yer_auth_rule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '规则id,自增主键',
  `module` varchar(20) NOT NULL COMMENT '规则所属module',
  `type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '1-url;2-主菜单',
  `name` char(80) NOT NULL DEFAULT '' COMMENT '规则唯一英文标识',
  `title` char(20) NOT NULL DEFAULT '' COMMENT '规则中文描述',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否有效(0:无效,1:有效)',
  `condition` varchar(300) NOT NULL DEFAULT '' COMMENT '规则附加条件',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `module` (`module`,`status`,`type`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=259 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of yer_auth_rule
-- ----------------------------
INSERT INTO `yer_auth_rule` VALUES ('1', 'admin', '2', 'Admin/Index/index', '首页', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('2', 'admin', '2', 'Admin/Article/index', '文章', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('3', 'admin', '2', 'Admin/User/index', '用户', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('4', 'admin', '2', 'Admin/Addons/index', '扩展', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('5', 'admin', '2', 'Admin/Config/group', '系统', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('7', 'admin', '1', 'Admin/article/add', '新增', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('8', 'admin', '1', 'Admin/article/edit', '编辑', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('9', 'admin', '1', 'Admin/article/setStatus', '改变状态', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('10', 'admin', '1', 'Admin/article/update', '保存', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('11', 'admin', '1', 'Admin/article/autoSave', '保存草稿', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('12', 'admin', '1', 'Admin/article/move', '移动', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('13', 'admin', '1', 'Admin/article/copy', '复制', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('14', 'admin', '1', 'Admin/article/paste', '粘贴', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('15', 'admin', '1', 'Admin/article/permit', '还原', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('16', 'admin', '1', 'Admin/article/clear', '清空', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('17', 'admin', '1', 'Admin/Article/examine', '审核列表', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('18', 'admin', '1', 'Admin/article/recycle', '回收站', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('19', 'admin', '1', 'Admin/User/addaction', '新增用户行为', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('20', 'admin', '1', 'Admin/User/editaction', '编辑用户行为', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('21', 'admin', '1', 'Admin/User/saveAction', '保存用户行为', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('22', 'admin', '1', 'Admin/User/setStatus', '变更行为状态', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('23', 'admin', '1', 'Admin/User/changeStatus?method=forbidUser', '禁用会员', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('24', 'admin', '1', 'Admin/User/changeStatus?method=resumeUser', '启用会员', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('25', 'admin', '1', 'Admin/User/changeStatus?method=deleteUser', '删除会员', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('26', 'admin', '1', 'Admin/User/index', '用户信息', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('27', 'admin', '1', 'Admin/User/action', '用户行为', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('28', 'admin', '1', 'Admin/AuthManager/changeStatus?method=deleteGroup', '删除', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('29', 'admin', '1', 'Admin/AuthManager/changeStatus?method=forbidGroup', '禁用', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('30', 'admin', '1', 'Admin/AuthManager/changeStatus?method=resumeGroup', '恢复', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('31', 'admin', '1', 'Admin/AuthManager/createGroup', '新增', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('32', 'admin', '1', 'Admin/AuthManager/editGroup', '编辑', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('33', 'admin', '1', 'Admin/AuthManager/writeGroup', '保存用户组', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('34', 'admin', '1', 'Admin/AuthManager/group', '授权', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('35', 'admin', '1', 'Admin/AuthManager/access', '访问授权', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('36', 'admin', '1', 'Admin/AuthManager/user', '成员授权', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('37', 'admin', '1', 'Admin/AuthManager/removeFromGroup', '解除授权', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('38', 'admin', '1', 'Admin/AuthManager/addToGroup', '保存成员授权', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('39', 'admin', '1', 'Admin/AuthManager/category', '分类授权', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('40', 'admin', '1', 'Admin/AuthManager/addToCategory', '保存分类授权', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('41', 'admin', '1', 'Admin/AuthManager/index', '权限管理', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('42', 'admin', '1', 'Admin/Addons/create', '创建', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('43', 'admin', '1', 'Admin/Addons/checkForm', '检测创建', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('44', 'admin', '1', 'Admin/Addons/preview', '预览', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('45', 'admin', '1', 'Admin/Addons/build', '快速生成插件', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('46', 'admin', '1', 'Admin/Addons/config', '设置', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('47', 'admin', '1', 'Admin/Addons/disable', '禁用', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('48', 'admin', '1', 'Admin/Addons/enable', '启用', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('49', 'admin', '1', 'Admin/Addons/install', '安装', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('50', 'admin', '1', 'Admin/Addons/uninstall', '卸载', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('51', 'admin', '1', 'Admin/Addons/saveconfig', '更新配置', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('52', 'admin', '1', 'Admin/Addons/adminList', '插件后台列表', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('53', 'admin', '1', 'Admin/Addons/execute', 'URL方式访问插件', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('54', 'admin', '1', 'Admin/Addons/index', '插件管理', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('55', 'admin', '1', 'Admin/Addons/hooks', '钩子管理', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('56', 'admin', '1', 'Admin/model/add', '新增', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('57', 'admin', '1', 'Admin/model/edit', '编辑', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('58', 'admin', '1', 'Admin/model/setStatus', '改变状态', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('59', 'admin', '1', 'Admin/model/update', '保存数据', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('60', 'admin', '1', 'Admin/Model/index', '模型管理', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('61', 'admin', '1', 'Admin/Config/edit', '编辑', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('62', 'admin', '1', 'Admin/Config/del', '删除', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('63', 'admin', '1', 'Admin/Config/add', '新增', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('64', 'admin', '1', 'Admin/Config/save', '保存', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('65', 'admin', '1', 'Admin/Config/group', '网站设置', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('66', 'admin', '1', 'Admin/Config/index', '配置管理', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('67', 'admin', '1', 'Admin/Channel/add', '新增', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('68', 'admin', '1', 'Admin/Channel/edit', '编辑', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('69', 'admin', '1', 'Admin/Channel/del', '删除', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('70', 'admin', '1', 'Admin/Channel/index', '导航管理', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('71', 'admin', '1', 'Admin/Category/edit', '编辑', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('72', 'admin', '1', 'Admin/Category/add', '新增', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('73', 'admin', '1', 'Admin/Category/remove', '删除', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('74', 'admin', '1', 'Admin/Category/index', '商品分类', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('75', 'admin', '1', 'Admin/file/upload', '上传控件', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('76', 'admin', '1', 'Admin/file/uploadPicture', '上传图片', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('77', 'admin', '1', 'Admin/file/download', '下载', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('94', 'admin', '1', 'Admin/AuthManager/modelauth', '模型授权', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('79', 'admin', '1', 'Admin/article/batchOperate', '导入', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('80', 'admin', '1', 'Admin/Database/index?type=export', '备份数据库', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('81', 'admin', '1', 'Admin/Database/index?type=import', '还原数据库', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('82', 'admin', '1', 'Admin/Database/export', '备份', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('83', 'admin', '1', 'Admin/Database/optimize', '优化表', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('84', 'admin', '1', 'Admin/Database/repair', '修复表', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('86', 'admin', '1', 'Admin/Database/import', '恢复', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('87', 'admin', '1', 'Admin/Database/del', '删除', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('88', 'admin', '1', 'Admin/User/add', '新增用户', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('89', 'admin', '1', 'Admin/Attribute/index', '属性管理', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('90', 'admin', '1', 'Admin/Attribute/add', '新增', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('91', 'admin', '1', 'Admin/Attribute/edit', '编辑', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('92', 'admin', '1', 'Admin/Attribute/setStatus', '改变状态', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('93', 'admin', '1', 'Admin/Attribute/update', '保存数据', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('95', 'admin', '1', 'Admin/AuthManager/addToModel', '保存模型授权', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('96', 'admin', '1', 'Admin/Category/move', '移动', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('97', 'admin', '1', 'Admin/Category/merge', '合并', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('98', 'admin', '1', 'Admin/Config/menu', '后台菜单管理', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('99', 'admin', '1', 'Admin/Article/mydocument', '内容', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('100', 'admin', '1', 'Admin/Menu/index', '菜单管理', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('101', 'admin', '1', 'Admin/other', '其他', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('102', 'admin', '1', 'Admin/Menu/add', '新增', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('103', 'admin', '1', 'Admin/Menu/edit', '编辑', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('104', 'admin', '1', 'Admin/Think/lists?model=article', '文章管理', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('105', 'admin', '1', 'Admin/Think/lists?model=download', '下载管理', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('106', 'admin', '1', 'Admin/Think/lists?model=config', '配置管理', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('107', 'admin', '1', 'Admin/Action/actionlog', '行为日志', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('108', 'admin', '1', 'Admin/User/updatePassword', '修改密码', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('109', 'admin', '1', 'Admin/User/updateNickname', '修改昵称', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('110', 'admin', '1', 'Admin/action/edit', '查看行为日志', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('205', 'admin', '1', 'Admin/think/add', '新增数据', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('111', 'admin', '2', 'Admin/article/index', '文档列表', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('112', 'admin', '2', 'Admin/article/add', '新增', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('113', 'admin', '2', 'Admin/article/edit', '编辑', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('114', 'admin', '2', 'Admin/article/setStatus', '改变状态', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('115', 'admin', '2', 'Admin/article/update', '保存', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('116', 'admin', '2', 'Admin/article/autoSave', '保存草稿', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('117', 'admin', '2', 'Admin/article/move', '移动', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('118', 'admin', '2', 'Admin/article/copy', '复制', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('119', 'admin', '2', 'Admin/article/paste', '粘贴', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('120', 'admin', '2', 'Admin/article/batchOperate', '导入', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('121', 'admin', '2', 'Admin/article/recycle', '回收站', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('122', 'admin', '2', 'Admin/article/permit', '还原', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('123', 'admin', '2', 'Admin/article/clear', '清空', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('124', 'admin', '2', 'Admin/User/add', '新增用户', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('125', 'admin', '2', 'Admin/User/action', '用户行为', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('126', 'admin', '2', 'Admin/User/addAction', '新增用户行为', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('127', 'admin', '2', 'Admin/User/editAction', '编辑用户行为', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('128', 'admin', '2', 'Admin/User/saveAction', '保存用户行为', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('129', 'admin', '2', 'Admin/User/setStatus', '变更行为状态', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('130', 'admin', '2', 'Admin/User/changeStatus?method=forbidUser', '禁用会员', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('131', 'admin', '2', 'Admin/User/changeStatus?method=resumeUser', '启用会员', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('132', 'admin', '2', 'Admin/User/changeStatus?method=deleteUser', '删除会员', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('133', 'admin', '2', 'Admin/AuthManager/index', '权限管理', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('134', 'admin', '2', 'Admin/AuthManager/changeStatus?method=deleteGroup', '删除', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('135', 'admin', '2', 'Admin/AuthManager/changeStatus?method=forbidGroup', '禁用', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('136', 'admin', '2', 'Admin/AuthManager/changeStatus?method=resumeGroup', '恢复', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('137', 'admin', '2', 'Admin/AuthManager/createGroup', '新增', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('138', 'admin', '2', 'Admin/AuthManager/editGroup', '编辑', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('139', 'admin', '2', 'Admin/AuthManager/writeGroup', '保存用户组', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('140', 'admin', '2', 'Admin/AuthManager/group', '授权', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('141', 'admin', '2', 'Admin/AuthManager/access', '访问授权', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('142', 'admin', '2', 'Admin/AuthManager/user', '成员授权', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('143', 'admin', '2', 'Admin/AuthManager/removeFromGroup', '解除授权', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('144', 'admin', '2', 'Admin/AuthManager/addToGroup', '保存成员授权', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('145', 'admin', '2', 'Admin/AuthManager/category', '分类授权', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('146', 'admin', '2', 'Admin/AuthManager/addToCategory', '保存分类授权', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('147', 'admin', '2', 'Admin/AuthManager/modelauth', '模型授权', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('148', 'admin', '2', 'Admin/AuthManager/addToModel', '保存模型授权', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('149', 'admin', '2', 'Admin/Addons/create', '创建', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('150', 'admin', '2', 'Admin/Addons/checkForm', '检测创建', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('151', 'admin', '2', 'Admin/Addons/preview', '预览', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('152', 'admin', '2', 'Admin/Addons/build', '快速生成插件', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('153', 'admin', '2', 'Admin/Addons/config', '设置', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('154', 'admin', '2', 'Admin/Addons/disable', '禁用', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('155', 'admin', '2', 'Admin/Addons/enable', '启用', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('156', 'admin', '2', 'Admin/Addons/install', '安装', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('157', 'admin', '2', 'Admin/Addons/uninstall', '卸载', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('158', 'admin', '2', 'Admin/Addons/saveconfig', '更新配置', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('159', 'admin', '2', 'Admin/Addons/adminList', '插件后台列表', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('160', 'admin', '2', 'Admin/Addons/execute', 'URL方式访问插件', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('161', 'admin', '2', 'Admin/Addons/hooks', '钩子管理', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('162', 'admin', '2', 'Admin/Model/index', '模型管理', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('163', 'admin', '2', 'Admin/model/add', '新增', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('164', 'admin', '2', 'Admin/model/edit', '编辑', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('165', 'admin', '2', 'Admin/model/setStatus', '改变状态', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('166', 'admin', '2', 'Admin/model/update', '保存数据', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('167', 'admin', '2', 'Admin/Attribute/index', '属性管理', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('168', 'admin', '2', 'Admin/Attribute/add', '新增', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('169', 'admin', '2', 'Admin/Attribute/edit', '编辑', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('170', 'admin', '2', 'Admin/Attribute/setStatus', '改变状态', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('171', 'admin', '2', 'Admin/Attribute/update', '保存数据', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('172', 'admin', '2', 'Admin/Config/index', '配置管理', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('173', 'admin', '2', 'Admin/Config/edit', '编辑', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('174', 'admin', '2', 'Admin/Config/del', '删除', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('175', 'admin', '2', 'Admin/Config/add', '新增', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('176', 'admin', '2', 'Admin/Config/save', '保存', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('177', 'admin', '2', 'Admin/Menu/index', '菜单管理', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('178', 'admin', '2', 'Admin/Channel/index', '导航管理', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('179', 'admin', '2', 'Admin/Channel/add', '新增', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('180', 'admin', '2', 'Admin/Channel/edit', '编辑', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('181', 'admin', '2', 'Admin/Channel/del', '删除', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('182', 'admin', '2', 'Admin/Category/index', '分类管理', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('183', 'admin', '2', 'Admin/Category/edit', '编辑', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('184', 'admin', '2', 'Admin/Category/add', '新增', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('185', 'admin', '2', 'Admin/Category/remove', '删除', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('186', 'admin', '2', 'Admin/Category/move', '移动', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('187', 'admin', '2', 'Admin/Category/merge', '合并', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('188', 'admin', '2', 'Admin/Database/index?type=export', '备份数据库', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('189', 'admin', '2', 'Admin/Database/export', '备份', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('190', 'admin', '2', 'Admin/Database/optimize', '优化表', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('191', 'admin', '2', 'Admin/Database/repair', '修复表', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('192', 'admin', '2', 'Admin/Database/index?type=import', '还原数据库', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('193', 'admin', '2', 'Admin/Database/import', '恢复', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('194', 'admin', '2', 'Admin/Database/del', '删除', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('195', 'admin', '2', 'Admin/other', '其他', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('196', 'admin', '2', 'Admin/Menu/add', '新增', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('197', 'admin', '2', 'Admin/Menu/edit', '编辑', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('198', 'admin', '2', 'Admin/Think/lists?model=article', '应用', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('199', 'admin', '2', 'Admin/Think/lists?model=download', '下载管理', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('200', 'admin', '2', 'Admin/Think/lists?model=config', '应用', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('201', 'admin', '2', 'Admin/Action/actionlog', '行为日志', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('202', 'admin', '2', 'Admin/User/updatePassword', '修改密码', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('203', 'admin', '2', 'Admin/User/updateNickname', '修改昵称', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('204', 'admin', '2', 'Admin/action/edit', '查看行为日志', '-1', '');
INSERT INTO `yer_auth_rule` VALUES ('206', 'admin', '1', 'Admin/think/edit', '编辑数据', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('207', 'admin', '1', 'Admin/Menu/import', '导入', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('208', 'admin', '1', 'Admin/Model/generate', '生成', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('209', 'admin', '1', 'Admin/Addons/addHook', '新增钩子', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('210', 'admin', '1', 'Admin/Addons/edithook', '编辑钩子', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('211', 'admin', '1', 'Admin/Article/sort', '文档排序', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('212', 'admin', '1', 'Admin/Config/sort', '排序', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('213', 'admin', '1', 'Admin/Menu/sort', '排序', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('214', 'admin', '1', 'Admin/Channel/sort', '排序', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('215', 'admin', '1', 'Admin/Category/operate/type/move', '移动', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('216', 'admin', '1', 'Admin/Category/operate/type/merge', '合并', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('217', 'admin', '1', 'Admin/article/index', '文档列表', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('218', 'admin', '1', 'Admin/think/lists', '数据列表', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('219', 'admin', '1', 'Admin/Attributes/index', '属性配置', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('220', 'admin', '1', 'Admin/Brand/index', '品牌管理', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('221', 'admin', '1', 'Admin/Slide/index', '幻灯片', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('222', 'admin', '1', 'Admin/Ad/index', '广告', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('223', 'admin', '1', 'Admin/Check/index', '商家审核', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('224', 'admin', '1', 'Admin/SellerMenu/index', '后台菜单', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('225', 'admin', '1', 'Admin/Types/index', ' 商品类型', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('226', 'admin', '1', 'Admin/Order/index', '提交订单', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('227', 'admin', '1', 'Admin/GoodsAttributes/index', '商品属性', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('228', 'admin', '1', 'Admin/Cancel/index', '取消管理', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('229', 'admin', '1', 'Admin/Catearticle/index', '文章分类', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('230', 'admin', '1', 'Admin/Goods/index', '商品列表', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('231', 'admin', '1', 'Admin/Back/index', '正退货订单', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('232', 'admin', '1', 'Admin/Stock/index', '库存sku', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('233', 'admin', '1', 'Admin/Fcoupon/index', '优惠券', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('234', 'admin', '1', 'Admin/Change/index', '换货管理', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('235', 'admin', '2', 'Admin/Goods/index', '商品', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('236', 'admin', '1', 'Admin/Backrefuse/index', '拒绝退货订单', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('237', 'admin', '2', 'Admin/Order/index', '订单', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('238', 'admin', '1', 'Admin/UserLog/index', '日志管理', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('239', 'admin', '1', 'Admin/Backon/index', '退货中订单', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('240', 'admin', '1', 'Admin/Email/index', '邮件管理', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('241', 'admin', '1', 'Admin/Backagree/index', '同意退货订单', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('242', 'admin', '1', 'Admin/Sms/index', '短信管理', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('243', 'admin', '1', 'Admin/Reserve/index', '预约列表', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('244', 'admin', '1', 'Admin/Backover/index', '已退货订单', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('245', 'admin', '1', 'Admin/Pay/index', '支付管理', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('246', 'admin', '1', 'Admin/Envelope/index', '站内信管理', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('247', 'admin', '1', 'Admin/Express/index', ' 快递管理', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('248', 'admin', '2', 'Admin/Slide/index', '广告', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('249', 'admin', '1', 'Admin/Message/index', '留言管理', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('250', 'admin', '1', 'Admin/Reply/index', '回复管理', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('251', 'admin', '2', 'Admin/Check/index', '商家', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('252', 'admin', '1', 'Admin/Statistics/index', '今日销量统计', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('253', 'admin', '1', 'Admin/Statistics/week', '本周销量统计', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('254', 'admin', '1', 'Admin/Statistics/month', '本月销量统计', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('255', 'admin', '1', 'Admin/Report/index', '每日数据', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('256', 'admin', '1', 'Admin/Report/week', '每周数据', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('257', 'admin', '1', 'Admin/Report/month', '每月统计', '1', '');
INSERT INTO `yer_auth_rule` VALUES ('258', 'admin', '1', 'Admin/Lookup/index', '流量统计', '1', '');

-- ----------------------------
-- Table structure for yer_backup
-- ----------------------------
DROP TABLE IF EXISTS `yer_backup`;
CREATE TABLE `yer_backup` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `title` varchar(225) DEFAULT NULL COMMENT '文件名',
  `type` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '类型',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=180 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='备份还原表';

-- ----------------------------
-- Records of yer_backup
-- ----------------------------
INSERT INTO `yer_backup` VALUES ('178', '20191210110537_all_v1.sql', '1', '1575947137');
INSERT INTO `yer_backup` VALUES ('179', '20191210111128_all_v1.sql', '1', '1575947488');

-- ----------------------------
-- Table structure for yer_bank
-- ----------------------------
DROP TABLE IF EXISTS `yer_bank`;
CREATE TABLE `yer_bank` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `username` varchar(255) DEFAULT NULL COMMENT '标题',
  `name` varchar(255) DEFAULT NULL COMMENT '链接',
  `account` varchar(255) DEFAULT NULL COMMENT '位置',
  `status` tinyint(2) DEFAULT '1' COMMENT '数据状态',
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '广告图片',
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='银行卡';

-- ----------------------------
-- Records of yer_bank
-- ----------------------------
INSERT INTO `yer_bank` VALUES ('1', 'sfds', 'sdfsdfds', 'dsfsdfs', '1', '0', '1');
INSERT INTO `yer_bank` VALUES ('2', 'sfds', 'sdfsdfds', 'dsfsdfs', '1', '0', '1');
INSERT INTO `yer_bank` VALUES ('3', 'sfds', 'sdfsdfds', 'dsfsdfs', '1', '0', '1');
INSERT INTO `yer_bank` VALUES ('4', '规定非官方', 'df地方官地方固定', 'df地方官地方', '1', '0', '1');
INSERT INTO `yer_bank` VALUES ('5', '10', '10', '10', '1', '0', '82');
INSERT INTO `yer_bank` VALUES ('6', '11454545656', '6456446644', '445454664', '1', '0', '82');
INSERT INTO `yer_bank` VALUES ('7', 'fasfa', 'asdas', 'asdas', '1', '0', '104');
INSERT INTO `yer_bank` VALUES ('8', '123456', '123456', '123456', '1', '0', '104');

-- ----------------------------
-- Table structure for yer_brand
-- ----------------------------
DROP TABLE IF EXISTS `yer_brand`;
CREATE TABLE `yer_brand` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '标志',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `price` varchar(50) NOT NULL DEFAULT '' COMMENT '金额',
  `code` varchar(255) NOT NULL COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `meta_title` varchar(100) NOT NULL DEFAULT '',
  `allow_publish` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否允许发布内容',
  `display` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '可见性',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '数据状态',
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '图标',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `goodid` varchar(225) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `id` (`id`) USING BTREE,
  UNIQUE KEY `uk_name` (`name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='品牌表';

-- ----------------------------
-- Records of yer_brand
-- ----------------------------
INSERT INTO `yer_brand` VALUES ('1', 'Maxwell', '麦斯威尔', '', '', '', '', '0', '1', '1442509490', '1442572614', '1', '119', '52', '');
INSERT INTO `yer_brand` VALUES ('4', 'ylrh\'', '元朗荣华', '', '', '', '', '0', '1', '1442576731', '1442576731', '1', '120', '57', '');
INSERT INTO `yer_brand` VALUES ('5', 'jrkj', '肌肉科技', '', '', '', '', '0', '1', '1442576899', '1442576899', '1', '121', '57', '');
INSERT INTO `yer_brand` VALUES ('6', 'ychdzx', '阳澄湖大闸蟹', '', '', '', '', '0', '1', '1442576947', '1442576947', '1', '122', '52', '');
INSERT INTO `yer_brand` VALUES ('7', 'hennessy', 'hennessy', '', '', '', '', '0', '1', '1442577280', '1442577280', '1', '123', '52', '');
INSERT INTO `yer_brand` VALUES ('8', 'dxc', '稻香村', '', '', '', '', '0', '1', '1442577327', '1442577327', '1', '124', '57', '');
INSERT INTO `yer_brand` VALUES ('9', 'gzmt', '贵州茅台', '', '', '', '', '0', '1', '1442577383', '1442577383', '1', '125', '52', '');
INSERT INTO `yer_brand` VALUES ('10', 'lafei', '拉菲', '', '', '', '', '0', '1', '1442577421', '1442577421', '1', '126', '52', '');
INSERT INTO `yer_brand` VALUES ('11', 'bsl', '博士伦', '', '', '', '', '0', '1', '1442577594', '1442577594', '1', '127', '57', '');
INSERT INTO `yer_brand` VALUES ('12', 'qhsj', '奇华世家', '', '', '', '', '0', '1', '1442588150', '1442588150', '1', '132', '52', '');
INSERT INTO `yer_brand` VALUES ('13', 'lppz', '良品铺子', '', '', '', '', '0', '1', '1442588302', '1442588302', '1', '133', '52', '');
INSERT INTO `yer_brand` VALUES ('14', 'dzph', '德州扒鹤', '', '', '', '', '0', '1', '1442588386', '1442588386', '1', '134', '57', '');
INSERT INTO `yer_brand` VALUES ('15', 'AOC', '冠捷', '', '', '', '', '0', '1', '1442655509', '1442655509', '1', '135', '107', '');
INSERT INTO `yer_brand` VALUES ('16', 'lenovo', '联想', '', '', '', '', '0', '1', '1442655587', '1442655587', '1', '136', '107', '');
INSERT INTO `yer_brand` VALUES ('17', 'hp', '惠普打印', '', '', '', '', '0', '1', '1442655629', '1442655629', '1', '137', '107', '');
INSERT INTO `yer_brand` VALUES ('18', 'leishen', '雷神', '', '', '', '', '0', '1', '1442655789', '1442655789', '1', '138', '107', '');
INSERT INTO `yer_brand` VALUES ('19', 'acer', '宏碁', '', '', '', '', '0', '1', '1442655887', '1442655887', '1', '139', '107', '');
INSERT INTO `yer_brand` VALUES ('20', 'samsung', '三星', '', '', '', '', '0', '1', '1442655930', '1442655930', '1', '140', '107', '');
INSERT INTO `yer_brand` VALUES ('21', 'midea', '美的', '', '', '', '', '0', '1', '1442655970', '1442655970', '1', '141', '107', '');
INSERT INTO `yer_brand` VALUES ('22', 'apple', '苹果', '', '', '', '', '0', '1', '1442656023', '1442656023', '1', '142', '107', '');
INSERT INTO `yer_brand` VALUES ('23', 'flyco', '飞科', '', '', '', '', '0', '1', '1442656073', '1442656073', '1', '143', '107', '');
INSERT INTO `yer_brand` VALUES ('24', 'blueair', '布鲁雅尔', '', '', '', '', '0', '1', '1442656143', '1442656143', '1', '144', '107', '');
INSERT INTO `yer_brand` VALUES ('25', 'LG', 'LG', '', '', '', '', '0', '1', '1442656437', '1442656437', '1', '145', '107', '');

-- ----------------------------
-- Table structure for yer_caigou
-- ----------------------------
DROP TABLE IF EXISTS `yer_caigou`;
CREATE TABLE `yer_caigou` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `orderId` varchar(255) DEFAULT NULL COMMENT '采购单号',
  `username` varchar(255) DEFAULT NULL COMMENT '供应商',
  `money` varchar(255) DEFAULT NULL COMMENT '采购金额',
  `buyer` varchar(255) DEFAULT NULL COMMENT '采购人员',
  `maker` varchar(255) DEFAULT NULL COMMENT '制单人员',
  `time` varchar(255) DEFAULT NULL COMMENT '创建时间',
  `status` tinyint(2) DEFAULT '0' COMMENT '审核状态',
  `put` tinyint(2) DEFAULT '0' COMMENT '入库状态',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='采购单表';

-- ----------------------------
-- Records of yer_caigou
-- ----------------------------

-- ----------------------------
-- Table structure for yer_cart
-- ----------------------------
DROP TABLE IF EXISTS `yer_cart`;
CREATE TABLE `yer_cart` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `goods_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `num` int(50) DEFAULT NULL COMMENT '商品数量',
  `price` varchar(225) NOT NULL DEFAULT '' COMMENT '商品价格',
  `title` varchar(225) NOT NULL DEFAULT '' COMMENT '商品名称',
  `sku_id` varchar(225) NOT NULL DEFAULT '' COMMENT '库存序号',
  `specifications` varchar(225) NOT NULL DEFAULT '' COMMENT '商品参数',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `path` varchar(225) DEFAULT NULL,
  `key` varchar(225) DEFAULT NULL,
  `reduction_id` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=684 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='购物车表';

-- ----------------------------
-- Records of yer_cart
-- ----------------------------
INSERT INTO `yer_cart` VALUES ('468', '193', '74', '1', '454.00', '', '300', '&nbsp;普装&nbsp;16开', '0', '113,116', null, '0');
INSERT INTO `yer_cart` VALUES ('425', '230', '68', '1', '11.00', '', '378', '&nbsp;', '0', '', '', '0');
INSERT INTO `yer_cart` VALUES ('528', '177', '75', '2', '456.00', '', '260', '&nbsp;黑&nbsp;官方标配', '0', '91,95', null, '0');
INSERT INTO `yer_cart` VALUES ('431', '183', '68', '3', '234.00', '', '284', '&nbsp;', '0', '', '', '0');
INSERT INTO `yer_cart` VALUES ('432', '197', '68', '1', '234.00', '', '307', '&nbsp;', '0', '', '', '0');
INSERT INTO `yer_cart` VALUES ('529', '229', '75', '2', '23.00', '', '374', '&nbsp;红色&nbsp;x', '0', '63,66', null, '0');
INSERT INTO `yer_cart` VALUES ('527', '179', '75', '9', '5465.00', '', '273', '&nbsp;黑&nbsp;官方标配&nbsp;1g', '0', '91,95,101', null, '0');
INSERT INTO `yer_cart` VALUES ('469', '230', '74', '3', '11.00', '', '378', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('447', '193', '70', '3', '454.00', '', '300', '&nbsp;普装&nbsp;16开', '0', '113,116', null, '0');
INSERT INTO `yer_cart` VALUES ('458', '171', '70', '4', '56765.00', '', '237', '&nbsp;4G&nbsp;16G', '0', '76,87', null, '0');
INSERT INTO `yer_cart` VALUES ('545', '229', '78', '1', '23.00', '', '374', '&nbsp;红色&nbsp;x', '0', '63,66', null, '0');
INSERT INTO `yer_cart` VALUES ('534', '231', '75', '1', '23.00', '', '379', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('532', '172', '75', '4', '4560.00', '', '241', '&nbsp;3G&nbsp;16G', '0', '75,87', null, '0');
INSERT INTO `yer_cart` VALUES ('533', '227', '75', '4', '101231.00', '', '367', '&nbsp;黑&nbsp;官方标配&nbsp;1g', '0', '91,95,101', null, '0');
INSERT INTO `yer_cart` VALUES ('475', '224', '71', '1', '0.10', '', '354', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('476', '223', '71', '1', '12.00', '', '353', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('477', '169', '71', '1', '77.00', '', '221', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('478', '203', '71', '1', '12.00', '', '313', '&nbsp;1kg&nbsp;优惠套装1', '0', '80,83', null, '0');
INSERT INTO `yer_cart` VALUES ('479', '175', '71', '1', '435.00', '', '250', '&nbsp;红色&nbsp;x', '0', '63,66', null, '0');
INSERT INTO `yer_cart` VALUES ('480', '170', '71', '1', '6456.00', '', '231', '&nbsp;3G&nbsp;16G', '0', '75,87', null, '0');
INSERT INTO `yer_cart` VALUES ('546', '225', '79', '9', '1999.00', '', '355', '&nbsp;3G&nbsp;16G', '0', '75,87', null, '0');
INSERT INTO `yer_cart` VALUES ('543', '177', '78', '1', '456.00', '', '260', '&nbsp;黑&nbsp;官方标配', '0', '91,95', null, '0');
INSERT INTO `yer_cart` VALUES ('544', '173', '78', '1', '3056.00', '', '244', '&nbsp;4G&nbsp;16G', '0', '76,87', null, '0');
INSERT INTO `yer_cart` VALUES ('537', '225', '78', '9', '1999.00', '', '355', '&nbsp;3G&nbsp;16G', '0', '75,87', null, '0');
INSERT INTO `yer_cart` VALUES ('486', '230', '71', '1', '11.00', '', '378', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('531', '200', '75', '1', '234.00', '', '310', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('489', '223', '70', '4', '12.00', '', '353', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('539', '179', '78', '5', '5465.00', '', '273', '&nbsp;黑&nbsp;官方标配&nbsp;1g', '0', '91,95,101', null, '0');
INSERT INTO `yer_cart` VALUES ('540', '228', '78', '5', '44.00', '', '373', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('541', '172', '78', '3', '4560.00', '', '241', '&nbsp;3G&nbsp;16G', '0', '75,87', null, '0');
INSERT INTO `yer_cart` VALUES ('542', '227', '78', '1', '101231.00', '', '367', '&nbsp;黑&nbsp;官方标配&nbsp;1g', '0', '91,95,101', null, '0');
INSERT INTO `yer_cart` VALUES ('538', '231', '78', '1', '23.00', '', '379', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('536', '173', '75', '1', '3056.00', '', '244', '&nbsp;4G&nbsp;16G', '0', '76,87', null, '0');
INSERT INTO `yer_cart` VALUES ('535', '228', '75', '5', '44.00', '', '373', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('530', '201', '75', '2', '34554.00', '', '311', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('526', '225', '75', '17', '1999.00', '', '355', '&nbsp;3G&nbsp;16G', '0', '75,87', null, '0');
INSERT INTO `yer_cart` VALUES ('547', '231', '79', '1', '23.00', '', '379', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('548', '179', '79', '5', '5465.00', '', '273', '&nbsp;黑&nbsp;官方标配&nbsp;1g', '0', '91,95,101', null, '0');
INSERT INTO `yer_cart` VALUES ('549', '228', '79', '5', '44.00', '', '373', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('550', '172', '79', '3', '4560.00', '', '241', '&nbsp;3G&nbsp;16G', '0', '75,87', null, '0');
INSERT INTO `yer_cart` VALUES ('551', '227', '79', '1', '101231.00', '', '367', '&nbsp;黑&nbsp;官方标配&nbsp;1g', '0', '91,95,101', null, '0');
INSERT INTO `yer_cart` VALUES ('552', '177', '79', '1', '456.00', '', '260', '&nbsp;黑&nbsp;官方标配', '0', '91,95', null, '0');
INSERT INTO `yer_cart` VALUES ('553', '173', '79', '1', '3056.00', '', '244', '&nbsp;4G&nbsp;16G', '0', '76,87', null, '0');
INSERT INTO `yer_cart` VALUES ('554', '229', '79', '1', '23.00', '', '374', '&nbsp;红色&nbsp;x', '0', '63,66', null, '0');
INSERT INTO `yer_cart` VALUES ('555', '225', '80', '132', '1999.00', '', '355', '&nbsp;3G&nbsp;16G', '0', '75,87', null, '0');
INSERT INTO `yer_cart` VALUES ('556', '231', '80', '32', '23.00', '', '379', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('557', '179', '80', '56', '5465.00', '', '273', '&nbsp;黑&nbsp;官方标配&nbsp;1g', '0', '91,95,101', null, '0');
INSERT INTO `yer_cart` VALUES ('558', '228', '80', '5', '44.00', '', '373', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('559', '172', '80', '3', '4560.00', '', '241', '&nbsp;3G&nbsp;16G', '0', '75,87', null, '0');
INSERT INTO `yer_cart` VALUES ('560', '227', '80', '76', '101231.00', '', '367', '&nbsp;黑&nbsp;官方标配&nbsp;1g', '0', '91,95,101', null, '0');
INSERT INTO `yer_cart` VALUES ('561', '177', '80', '1', '456.00', '', '260', '&nbsp;黑&nbsp;官方标配', '0', '91,95', null, '0');
INSERT INTO `yer_cart` VALUES ('562', '173', '80', '1', '3056.00', '', '244', '&nbsp;4G&nbsp;16G', '0', '76,87', null, '0');
INSERT INTO `yer_cart` VALUES ('563', '229', '80', '116', '23.00', '', '374', '&nbsp;红色&nbsp;x', '0', '63,66', null, '0');
INSERT INTO `yer_cart` VALUES ('564', '201', '80', '1', '34554.00', '', '311', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('565', '171', '80', '5', '56765.00', '', '237', '&nbsp;4G&nbsp;16G', '0', '76,87', null, '0');
INSERT INTO `yer_cart` VALUES ('566', '175', '80', '9', '435.00', '', '250', '&nbsp;红色&nbsp;x', '0', '63,66', null, '0');
INSERT INTO `yer_cart` VALUES ('567', '186', '80', '4', '234.00', '', '293', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('568', '227', '81', '545', '101231.00', '', '367', '&nbsp;黑&nbsp;官方标配&nbsp;1g', '0', '91,95,101', null, '0');
INSERT INTO `yer_cart` VALUES ('569', '225', '81', '83', '1999.00', '', '355', '&nbsp;3G&nbsp;16G', '0', '75,87', null, '0');
INSERT INTO `yer_cart` VALUES ('570', '179', '81', '113', '5465.00', '', '273', '&nbsp;黑&nbsp;官方标配&nbsp;1g', '0', '91,95,101', null, '0');
INSERT INTO `yer_cart` VALUES ('571', '171', '81', '11', '56765.00', '', '237', '&nbsp;4G&nbsp;16G', '0', '76,87', null, '0');
INSERT INTO `yer_cart` VALUES ('572', '229', '81', '206', '23.00', '', '374', '&nbsp;红色&nbsp;x', '0', '63,66', null, '0');
INSERT INTO `yer_cart` VALUES ('573', '231', '81', '1', '23.00', '', '379', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('574', '223', '81', '1894', '12.00', '', '353', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('575', '224', '81', '4283', '0.10', '', '354', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('576', '203', '81', '1472', '12.00', '', '313', '&nbsp;1kg&nbsp;优惠套装1', '0', '80,83', null, '0');
INSERT INTO `yer_cart` VALUES ('578', '169', '81', '157', '77.00', '', '221', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('579', '166', '81', '133', '30.00', '', '218', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('674', '225', '82', '3', '1999.00', '', '355', '&nbsp;3G&nbsp;16G', '0', '75,87', null, '0');
INSERT INTO `yer_cart` VALUES ('581', '183', '81', '42', '234.00', '', '284', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('582', '177', '81', '18', '456.00', '', '260', '&nbsp;黑&nbsp;官方标配', '0', '91,95', null, '0');
INSERT INTO `yer_cart` VALUES ('583', '165', '81', '9', '8.90', '', '217', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('681', '225', '104', '1', '5254.00', '', '358', ' 6G 32G', '0', '77,88', null, '0');
INSERT INTO `yer_cart` VALUES ('680', '167', '82', '4', '34.00', '', '219', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('679', '197', '82', '1', '234.00', '', '307', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('677', '169', '82', '1', '77.00', '', '221', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('672', '223', '82', '117', '12.00', '', '353', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('673', '224', '82', '65', '0.10', '', '354', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('663', '162', '105', '2', '0.10', '', '214', '&nbsp;', '0', '', null, '0');
INSERT INTO `yer_cart` VALUES ('675', '203', '82', '29', '12.00', '', '313', '&nbsp;1kg&nbsp;优惠套装1', '0', '80,83', null, '0');
INSERT INTO `yer_cart` VALUES ('676', '227', '82', '34', '101231.00', '', '367', '&nbsp;黑&nbsp;官方标配&nbsp;1g', '0', '91,95,101', null, '0');
INSERT INTO `yer_cart` VALUES ('682', '229', '82', '13', '23.00', '', '374', '&nbsp;红色&nbsp;x', '0', '63,66', null, '0');
INSERT INTO `yer_cart` VALUES ('683', '168', '82', '2', '99.00', '', '220', '&nbsp;', '0', '', null, '0');

-- ----------------------------
-- Table structure for yer_cash
-- ----------------------------
DROP TABLE IF EXISTS `yer_cash`;
CREATE TABLE `yer_cash` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id,自增主键',
  `money` decimal(50,2) NOT NULL DEFAULT '0.00',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1+,0-',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `total` decimal(50,2) NOT NULL DEFAULT '0.00',
  `content` varchar(225) DEFAULT NULL,
  `remark` varchar(225) DEFAULT NULL,
  `status` int(10) NOT NULL DEFAULT '0',
  `bank` varchar(255) DEFAULT NULL,
  `account` varchar(255) DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `percent` varchar(255) DEFAULT NULL,
  `arrive_money` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=59 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='现金表';

-- ----------------------------
-- Records of yer_cash
-- ----------------------------
INSERT INTO `yer_cash` VALUES ('47', '2.00', '82', '0', '1525644392', '0.00', '12344', '', '0', '        <view>建设银行（6200********0000）</view>\r\n建设银行', 'asdsd', '34534543', null, null);
INSERT INTO `yer_cash` VALUES ('48', '2.00', '82', '0', '1525644395', '0.00', '12344', '', '2', '建设银行', 'asdsa546456', '34534534', null, null);
INSERT INTO `yer_cash` VALUES ('49', '2.00', '82', '0', '1525644455', '0.00', '222', '1', '1', '建设银行', '76876785674564564545645635', '3453454354', null, null);
INSERT INTO `yer_cash` VALUES ('50', '5.00', '0', '0', '1592118171', '0.00', null, null, '0', 'asdas', 'asdas', 'fasfa', '5%', '4.75');
INSERT INTO `yer_cash` VALUES ('51', '5.00', '104', '0', '1592118263', '190.00', null, null, '0', 'asdas', 'asdas', 'fasfa', '5%', '4.75');
INSERT INTO `yer_cash` VALUES ('52', '6.00', '104', '0', '1592118420', '184.00', '申请提现', null, '0', 'asdas', 'asdas', 'fasfa', '5%', '5.7');
INSERT INTO `yer_cash` VALUES ('53', '6.00', '104', '0', '1592118453', '178.00', '申请提现', null, '0', 'asdas', 'asdas', 'fasfa', '5%', '5.7');
INSERT INTO `yer_cash` VALUES ('54', '17.00', '104', '0', '1592140117', '161.00', '申请提现', null, '0', 'asdas', 'asdas', 'fasfa', '5%', '16.15');
INSERT INTO `yer_cash` VALUES ('55', '123.00', '104', '0', '1592199512', '38.00', '申请提现', null, '0', 'asdas', 'asdas', 'fasfa', '5%', '116.85');
INSERT INTO `yer_cash` VALUES ('56', '88.00', '104', '0', '1592393045', '3800.00', '申请提现', null, '0', '123456', '123456', '123456', '5%', '83.6');
INSERT INTO `yer_cash` VALUES ('57', '10.00', '82', '0', '1593271715', '416.00', '申请提现', null, '0', 'fgfdfg', 'gh_29acb9247af4', 'sdfdsf', '5%', '9.5');
INSERT INTO `yer_cash` VALUES ('58', '10.00', '82', '0', '1593271799', '406.00', '申请提现', null, '0', 'fgfdfg', 'gh_29acb9247af4', 'yershop', '5%', '9.5');

-- ----------------------------
-- Table structure for yer_cate
-- ----------------------------
DROP TABLE IF EXISTS `yer_cate`;
CREATE TABLE `yer_cate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `sort` int(1) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL DEFAULT '0',
  `name` varchar(225) DEFAULT NULL,
  `content` text NOT NULL COMMENT '内容',
  `type` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='文章分类表';

-- ----------------------------
-- Records of yer_cate
-- ----------------------------
INSERT INTO `yer_cate` VALUES ('5', '0', '关于我们', '2', '1', '', '', '1');
INSERT INTO `yer_cate` VALUES ('2', '1', '购物流程', '0', '1', '', '', '1');
INSERT INTO `yer_cate` VALUES ('6', '5', '关于我们', '0', '1', '', '<p>\r\n	<span style=\"font-size:16px;color:#000000;\"> </span>\r\n</p>\r\n<p>\r\n	<span style=\"font-size:16px;\">\r\n	<p style=\"color:#666666;font-family:&quot;background-color:#FFFFFF;\">\r\n		&nbsp;yershop商城（yershop.com）-是xx有限公司旗下专业的综合网上购物商城，在线销售家用电器、数码通讯、电脑、家居百货、服装服饰、母婴、图书、食品、在线旅游等数万个品牌千万种优质商品。&nbsp;\r\n	</p>\r\n	<p style=\"color:#666666;font-family:&quot;background-color:#FFFFFF;\">\r\n		&nbsp; &nbsp; &nbsp; &nbsp; 目前，yershop商城在线销售涵盖食品饮料、酒水、生鲜、进口食品、进口牛奶、美容化妆、个人护理、服饰鞋靴、厨卫清洁、母婴用品、手机数码、家居家纺、家用电器、保健用品、箱包珠宝、运动用品及礼品卡等商品。\r\n	</p>\r\n	<p style=\"color:#666666;font-family:&quot;background-color:#FFFFFF;\">\r\n		&nbsp; &nbsp; &nbsp; &nbsp; 淘库商城以“诚信”为本，在供应商筛选、商品质量管理和商品入库、入驻商家引进及日常运营监管等环节上，由专业人员严格把关，保障商品和服务的高质量，并严格遵照国家有关“三包”的法律法规，让顾客放心购买。&nbsp; &nbsp;&nbsp;\r\n	</p>\r\n	<p style=\"color:#666666;font-family:&quot;background-color:#FFFFFF;\">\r\n		&nbsp; &nbsp; &nbsp; &nbsp; 与传统零售相比，yershop商城有3-5%的运营成本优势，同时，通过建立高效优化的供应链，节省采购、仓储、配送、售后服务等各个环节的成本并回馈给顾客，并通过科学的价格管理，保证淘库商城的价格优惠。\r\n	</p>\r\n	<p style=\"color:#666666;font-family:&quot;background-color:#FFFFFF;\">\r\n		&nbsp; &nbsp; &nbsp; &nbsp; yershop商城将在全国一百多城市成立分公司并建立自配送物流体系。提供当天达、次日达、隔日达以满足顾客快速收货的需求。\r\n	</p>\r\n	<p style=\"color:#666666;font-family:&quot;background-color:#FFFFFF;\">\r\n		<span style=\"font-family:&quot;\">淘库商城（yershop.com)-全球优选、正品低价、送货到家、简单网购！</span>&nbsp;网站公告:<span style=\"color:#337FE5;\"><a href=\"https://yershop.com\" target=\"_blank\">https:/yershop.com</a></span>&nbsp;\r\n	</p>\r\n</span>\r\n</p>\r\n<h3 style=\"vertical-align:baseline;text-align:center;\">\r\n	<div style=\"color:#222731;font-family:&quot;font-size:20px;font-weight:bold;text-align:left;\">\r\n		<b></b>\r\n	</div>\r\n	<div style=\"color:#222731;font-family:&quot;font-size:20px;font-weight:bold;text-align:left;\">\r\n		<b></b>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span><span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span><span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span><span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span><span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span><span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span><span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span><span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span><span>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;color:#000000;\"></span>\r\n	</div>\r\n</span>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n<span> \r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;color:#000000;\"></span> \r\n	</div>\r\n</span> \r\n</h3>\r\n<p style=\"color:#2F2F2F;font-family:&quot;font-size:0.3rem;><br />\r\n	</p>\r\n<span style=\" color:#777777;font-family:simsun,=\"\" arial,=\"\" helvetica,=\"\" clean,=\"\" sans-serif;background-color:#ffffff;font-size:16px;\"=\"\"><span style=\"color:#666666;font-family:微软雅黑;background-color:#F5F5F5;font-size:14px;\"></span> \r\n</p>', '1');
INSERT INTO `yer_cate` VALUES ('9', '5', '联系我们', '0', '1', '', '联系我们<br />\r\n欢迎来到xx商城。<br />\r\n<br />\r\n关于xx商城的使用问题、改进建议，或举报不良信息，请点击每个网页右下角：意见反馈。<br />\r\n<br />\r\n&nbsp;<br />\r\n<br />\r\n服务热线：<br />\r\n<br />\r\nxx商城客服：国内 4006-345-678 海外 +86-10-8341-6888<br />\r\n<br />\r\n服务邮箱：<br />\r\n<br />\r\nxx商城广告部：AD@mafengwo.com<br />\r\n<br />\r\nxx商城商城商务合作：sales-cooperation@mafengwo.com (如需申请入驻xx商城旅行商城,请在线提交申请:http://www.mafengwo.cn/sales/alliance.php)<br />\r\n<br />\r\nxx商城内容及流量合作：hezuo@mafengwo.com （邮件请注明“内容合作”或“流量合作”）<br />\r\n<br />\r\nxx商城品牌市场部：pr@mafengwo.com<br />\r\n<br />\r\n酒店及OTA合作：hotel@mafengwo.com（如需申请入驻xx商城酒店，请在线提交申请https://w.mafengwo.cn/hotel_open_platform/#/register/welcome）<br />\r\n<br />\r\n其他：<br />\r\n<br />\r\n创建新商户（餐厅、景点）： http://www.mafengwo.cn/poi/add.php<br />\r\n<br />\r\nxx商城（贵州公司）：贵州省贵阳市观山湖区毕节路58号联合广场A栋24层<br />\r\n<br />\r\nxx商城全球总部：北京市朝阳区酒仙桥北路9号院恒通国际创新园C9xx商城<br />', '1');
INSERT INTO `yer_cate` VALUES ('10', '5', '用户协议', '0', '1', '', '<p>\r\n	<span style=\"font-size:16px;\">北京xx科技有限公司（以下简称“xx科技”）在此特别提醒您（用户）在注册成为用户之前，请认真阅读本《用户协议》（以下简称“协议”），确保您充分理解本协议中各条款。请您审慎阅读并选择接受或不接受本协议。除非您接受本协议所有条款，否则您无权注册、登录或使用本协议所涉服务。您的注册、登录、使用等行为将视为对本协议的接受，并同意接受本协议各项条款的约束。<br />\r\n<br />\r\n本协议约定xx科技与用户之间关于“xx”软件服务（以下简称“服务”）的权利义务。“用户”是指注册、登录、使用本服务的个人。本协议可由xx科技随时更新，更新后的协议条款一旦公布即代替原来的协议条款，恕不再另行通知，用户可在本网站查阅最新版协议条款。在xx科技修改协议条款后，如果用户不接受修改后的条款，请立即停止使用xx科技提供的服务，用户继续使用xx科技提供的服务将被视为接受修改后的协议。<br />\r\n<br />\r\n一、帐号注册<br />\r\n1、用户在使用本服务前需要注册一个“xx”帐号。“xx”帐号应当使用手机号码绑定注册，请用户使用尚未与“xx”帐号绑定的手机号码，以及未被xx科技根据本协议封禁的手机号码注册“xx”帐号。xx科技可以根据用户需求或产品需要对帐号注册和绑定的方式进行变更，而无须事先通知用户。<br />\r\n<br />\r\n2、“xx”系基于地理位置的移动社交产品，用户注册时应当授权xx科技公开及使用其地理位置信息方可成功注册“xx”帐号。故用户完成注册即表明用户同意xx科技提取、公开及使用用户的地理位置信息。如用户需要终止向其他用户公开其地理位置信息，可自行设置为隐身状态。<br />\r\n<br />\r\n3、鉴于“xx”帐号的绑定注册方式，您同意xx科技在注册时将使用您提供的手机号码及/或自动提取您的手机号码及自动提取您的手机设备识别码等信息用于注册。您同意给予运营商授权，授权运营商有权自动提取您的手机号码进行认证并用于“xx”账号注册，您保证遵守运营商的相关服务条款（点击查看服务条款），如运营商对您的手机号认证成功，则您的注册即完成。如您不同意对运营商的授权和/或服务条款或者是您的手机号认证失败，您可以手动修改运营商提取的手机号码，采取验证码方式进行注册登录。<br />\r\n<br />\r\n4、在用户注册及使用本服务时，xx科技需要搜集能识别用户身份的个人信息以便xx科技可以在必要时联系用户，或为用户提供更好的使用体验。xx科技搜集的信息包括但不限于用户的姓名、性别、年龄、出生日期、身份证号、地址、学校情况、公司情况、所属行业、兴趣爱好、常出没的地方、个人说明；xx科技同意对这些信息的使用将受限于第三条用户个人隐私信息保护的约束。<br />\r\n<br />\r\n二、服务内容<br />\r\n1、本服务的具体内容由xx科技根据实际情况提供，包括但不限于授权用户通过其帐号进行即时通讯、添加好友、加入群组、关注他人、发布留言。xx科技可以对其提供的服务予以变更，且xx科技提供的服务内容可能随时变更；用户将会收到xx科技关于服务变更的通知。<br />\r\n<br />\r\n2、xx科技提供的服务包含免费服务与收费服务。用户可以通过付费方式购买收费服务，具体方式为：用户通过网上银行、支付宝或其他“xx”平台提供的付费途径支付一定数额的人民币购买“xx”平台的虚拟货币——xx币，然后根据xx科技公布的资费标准以xx币购买用户欲使用的收费服务，从而获得收费服务使用权限。对于收费服务，xx科技会在用户使用之前给予用户明确的提示，只有用户根据提示确认其同意按照前述支付方式支付费用并完成了支付行为，用户才能使用该等收费服务。支付行为的完成以银行或第三方支付平台生成“支付已完成”的确认通知为准。<br />\r\n<br />\r\n三、用户个人信息保护<br />\r\n1、用户在注册帐号或使用本服务的过程中，可能需要填写或提交一些必要的个人信息，如法律法规、规章规范性文件（以下称“法律法规”）规定的需要填写的身份信息。如用户提交的信息不完整或不符合法律法规的规定，则用户可能无法使用本服务或在使用本服务的过程中受到限制。<br />\r\n<br />\r\n2、用户个人信息包括：1）用户自行提供的用户个人信息（如注册时填写的手机号码，电子邮件等个人信息，使用服务时提供的共享信息等）；2）其他方分享的用户个人信息；3）xx科技为提供服务而合法收集的用户必要个人信息（如使用服务时系统自动采集的设备或软件信息，浏览历史信息，通讯时间信息等技术信息，用户开启定位功能并使用服务时的地理位置信息等）。<br />\r\n<br />\r\n其中个人隐私信息是指涉及用户个人身份或个人隐私的信息，比如，用户真实姓名、身份证号、手机号码、手机设备识别码、IP地址、用户聊天记录。非个人隐私信息是指用户对本服务的操作状态以及使用习惯等明确且客观反映在xx科技服务器端的基本记录信息、个人隐私信息范围外的其它普通信息，以及用户同意公开的上述隐私信息。xx科技保证在取得用户书面同意的情况下收集、使用或公开用户的个人隐私信息，用户同意xx科技无需获得用户的另行确认与授权即可收集、使用或公开用户的非个人隐私信息。<br />\r\n<br />\r\n3、尊重用户个人信息的私有性是xx科技的一贯制度，xx科技将采取技术措施和其他必要措施，确保用户个人信息安全，防止在本服务中收集的用户个人信息泄露、毁损或丢失。在发生前述情形或者xx科技发现存在发生前述情形的可能时，xx科技将及时采取补救措施并告知用户，用户如发现存在前述情形亦需立即与xx科技联系。<br />\r\n<br />\r\n4、xx科技未经用户同意不向任何第三方公开、 透露用户个人隐私信息。但以下特定情形除外：<br />\r\n<br />\r\n(1) xx科技根据法律法规规定或有权机关的指示提供用户的个人隐私信息；<br />\r\n<br />\r\n(2) 由于用户将其用户密码告知他人或与他人共享注册帐户与密码，由此导致的任何个人信息的泄漏，或其他非因xx科技原因导致的个人隐私信息的泄露；<br />\r\n<br />\r\n(3) 用户自行向第三方公开其个人隐私信息；<br />\r\n<br />\r\n(4) 用户与xx科技及合作单位之间就用户个人隐私信息的使用公开达成约定，xx科技因此向合作单位公开用户个人隐私信息；<br />\r\n<br />\r\n(5) 任何由于黑客攻击、电脑病毒侵入及其他不可抗力事件导致用户个人隐私信息的泄露；<br />\r\n<br />\r\n(6) 用户个人信息已经经过处理无法识别特定个人且不能复原。<br />\r\n<br />\r\n5、用户同意xx科技可在以下事项中使用用户的个人隐私信息：<br />\r\n<br />\r\n(1) xx科技向用户及时发送重要通知，如软件更新、本协议条款的变更；<br />\r\n<br />\r\n(2) xx科技内部进行审计、数据分析和研究等，以改进xx科技的产品、服务和与用户之间的沟通；<br />\r\n<br />\r\n(3) 依本协议约定，xx科技管理、审查用户信息及进行处理措施；<br />\r\n<br />\r\n(4) 适用法律法规规定的其他事项。<br />\r\n<br />\r\n除上述事项外，如未取得用户事先同意，xx科技不会将用户个人隐私信息使用于任何其他用途。<br />\r\n<br />\r\n6、xx科技重视对未成年人的保护。xx科技将依赖用户提供的个人信息判断用户是否为未成年人。任何18岁以下的未成年人均不得注册帐号或使用本服务<br />\r\n<br />\r\n7、因xx科技提供的服务系基于地理位置提供的移动社交服务，用户确认，其地理位置信息为非个人隐私信息，用户成功注册“xx”帐号视为确认授权xx科技提取、公开及使用用户的地理位置信息。用户地理位置信息将作为用户公开资料之一，由xx科技向其他用户公开以便xx科技向用户提供基于地理位置的移动社交服务。如用户需要终止向其他用户公开其地理位置信息，可随时自行设置为隐身状态。<br />\r\n<br />\r\n8、为了改善xx科技的技术和服务，向用户提供更好的服务体验，xx科技或可会自行收集使用或向第三方提供用户的非个人隐私信息。<br />\r\n<br />\r\n9、xx科技保证在合法、正当与必要的原则下收集、使用或者公开用户个人信息且不会收集与提供的服务无关的用户个人信息。<br />\r\n<br />\r\n10、xx科技十分注重保护用户的个人隐私，并制定了《xx隐私权政策》（点击查看），用户亦可以通过“设置”页面里的“帮助”来进行具体查看，用户确认并同意使用xx科技提供的服务将被视为接受《xx隐私权政策》。<br />\r\n<br />\r\n四、内容规范<br />\r\n1、本条所述内容是指用户使用本服务过程中所制作、上载、复制、发布、传播的任何内容，包括但不限于帐号头像、名称、用户说明等注册信息及认证资料，或文字、语音、图片、视频、图文等发送、回复或自动回复消息和相关链接页面，以及其他使用帐号或本服务所产生的内容。<br />\r\n<br />\r\n2、用户不得利用“xx”帐号或本服务制作、上载、复制、发布、传播如下法律、法规和政策禁止的内容：<br />\r\n<br />\r\n(1) 反对宪法所确定的基本原则的；<br />\r\n<br />\r\n(2) 危害国家安全，泄露国家秘密，颠覆国家政权，破坏国家统一的；<br />\r\n<br />\r\n(3) 损害国家荣誉和利益的；<br />\r\n<br />\r\n(4) 煽动民族仇恨、民族歧视，破坏民族团结的；<br />\r\n<br />\r\n(5) 破坏国家宗教政策，宣扬邪教和封建迷信的；<br />\r\n<br />\r\n(6) 散布谣言，扰乱社会秩序，破坏社会稳定的；<br />\r\n<br />\r\n(7) 散布淫秽、色情、赌博、暴力、凶杀、恐怖或者教唆犯罪的；<br />\r\n<br />\r\n(8) 侮辱或者诽谤他人，侵害他人合法权益的；<br />\r\n<br />\r\n(9) 不遵守法律法规底线、社会主义制度底线、国家利益底线、公民合法权益底线、社会公共秩序底线、道德风尚底线和信息真实性底线的“七条底线”要求的；<br />\r\n<br />\r\n(10) 含有法律、行政法规禁止的其他内容的信息。<br />\r\n<br />\r\n3、用户不得利用“xx”帐号或本服务制作、上载、复制、发布、传播如下干扰“xx”正常运营，以及侵犯其他用户或第三方合法权益的内容：<br />\r\n<br />\r\n(1) 含有任何性或性暗示的；<br />\r\n<br />\r\n(2) 含有辱骂、恐吓、威胁内容的；<br />\r\n<br />\r\n(3) 含有骚扰、垃圾广告、恶意信息、诱骗信息的；<br />\r\n<br />\r\n(4) 涉及他人隐私、个人信息或资料的；<br />\r\n<br />\r\n(5) 侵害他人名誉权、肖像权、知识产权、商业秘密等合法权利的；<br />\r\n<br />\r\n(6) 含有其他干扰本服务正常运营和侵犯其他用户或第三方合法权益内容的信息。<br />\r\n<br />\r\n五、使用规则<br />\r\n1、用户在本服务中或通过本服务所传送、发布的任何内容并不反映或代表，也不得被视为反映或代表xx科技的观点、立场或政策，xx科技对此不承担任何责任。<br />\r\n<br />\r\n2、用户不得利用“xx”帐号或本服务进行如下行为：<br />\r\n<br />\r\n(1) 提交、发布虚假信息，或盗用他人头像或资料，冒充、利用他人名义的；<br />\r\n<br />\r\n(2) 强制、诱导其他用户关注、点击链接页面或分享信息的；<br />\r\n<br />\r\n(3) 虚构事实、隐瞒真相以误导、欺骗他人的；<br />\r\n<br />\r\n(4) 利用技术手段批量建立虚假帐号的；<br />\r\n<br />\r\n(5) 利用“xx”帐号或本服务从事任何违法犯罪活动的；<br />\r\n<br />\r\n(6) 制作、发布与以上行为相关的方法、工具，或对此类方法、工具进行运营或传播，无论这些行为是否为商业目的；<br />\r\n<br />\r\n(7) 其他违反法律法规规定、侵犯其他用户合法权益、干扰“xx”正常运营或xx科技未明示授权的行为。<br />\r\n<br />\r\n3、用户须对利用“xx”帐号或本服务传送信息的真实性、合法性、无害性、准确性、有效性等全权负责，与用户所传播的信息相关的任何法律责任由用户自行承担，与xx科技无关。如因此给xx科技或第三方造成损害的，用户应当依法予以赔偿。<br />\r\n<br />\r\n4、xx科技提供的服务中可能包括广告，用户同意在使用过程中显示xx科技和第三方供应商、合作伙伴提供的广告。除法律法规明确规定外，用户应自行对依该广告信息进行的交易负责，对用户因依该广告信息进行的交易或前述广告商提供的内容而遭受的损失或损害，xx科技不承担任何责任。<br />\r\n<br />\r\n5、除非xx科技书面许可，用户不得从事下列任一行为：<br />\r\n<br />\r\n(1) 删除软件及其副本上关于著作权的信息；<br />\r\n<br />\r\n(2) 对软件进行反向工程、反向汇编、反向编译，或者以其他方式尝试发现软件的源代码；<br />\r\n<br />\r\n(3) 对xx科技拥有知识产权的内容进行使用、出租、出借、复制、修改、链接、转载、汇编、发表、出版、建立镜像站点等；<br />\r\n<br />\r\n(4) 对软件或者软件运行过程中释放到任何终端内存中的数据、软件运行过程中客户端与服务器端的交互数据，以及软件运行所必需的系统数据，进行复制、修改、增加、删除、挂接运行或创作任何衍生作品，形式包括但不限于使用插件、外挂或非经xx科技授权的第三方工具/服务接入软件和相关系统；<br />\r\n<br />\r\n(5) 通过修改或伪造软件运行中的指令、数据，增加、删减、变动软件的功能或运行效果，或者将用于上述用途的软件、方法进行运营或向公众传播，无论这些行为是否为商业目的；<br />\r\n<br />\r\n(6) 通过非xx科技开发、授权的第三方软件、插件、外挂、系统，登录或使用xx科技软件及服务，或制作、发布、传播非xx科技开发、授权的第三方软件、插件、外挂、系统。<br />\r\n<br />\r\n六、虚拟货币<br />\r\n1、xx科技将在“xx”平台发行虚拟货币，即xx币。xx币可用于购买“xx”平台的增值服务，包括但不限于表情服务及会员服务，除此外，不得用于其他任何用途。该等增值服务的价格均以xx币为单位，具体价格信息将由xx科技自行决定并在相关服务页面上显示。<br />\r\n<br />\r\n2、xx币和人民币的兑换比例依用户购买渠道的不同而有不同的兑换比例，具体兑换比例以用户购买xx币相关渠道服务页面显示为准。xx科技有权根据运营情况随时变更上述兑换比例，并将在用户购买xx币相关渠道服务页面显示。<br />\r\n<br />\r\n3、用户默认已开通xx币账户，可进行xx币购买（下称“充值”）和消费。用户可在设置页面查询到xx币余额、购买记录和消费记录。xx币相关信息将不作为公开信息。<br />\r\n<br />\r\n4、用户可以通过网上银行、支付宝或其他“xx”平台提供的充值途径为xx币账户进行充值。用户使用xx币购买相关收费服务后，可将相关收费服务赠与其他用户。用户确认不会以非法方式或者使用非平台所指定的充值途径进行充值,如果用户违规使用非xx科技认可的充值途径非法充值/购买xx币，则xx科技不保证充值顺利或正确完成，若因此造成用户权益受损，xx科技将不会作出任何补偿或赔偿，xx科技同时保留随时终止用户xx账号资格及使用各项充值服务的权利，并进行相应惩罚。<br />\r\n<br />\r\n5、用户确认在进行充值前已经仔细确认过自己的账号并仔细选择了相关操作选项，若因用户自身输入账号错误、操作不当或不了解充值计费方式等因素造成充错账号、错选充值种类等情形而损害自身权益的，xx科技将不会作出任何补偿或赔偿。<br />\r\n<br />\r\n6、用户确认，xx币一经充值成功，除法律法规明确规定外，在任何情况下不能兑换为法定货币，不能转让他人。除法律法规明确规定外，xx币账户充值完成后，xx科技不予退款。<br />\r\n<br />\r\n7、用户确认，xx币只能用于购买“xx”平台上的各类增值服务，任何情况下不得与xx科技以外的第三方进行xx币交易，亦不得在除“xx”平台以外的第三方平台（如淘宝）上进行交易；如违反前述约定，造成用户或第三方任何损失，xx科技不负任何责任，且如xx科技有理由怀疑用户的xx币账户或使用情况有作弊或异常状况，xx科技将拒绝该用户使用xx币进行支付，直至按本协议约定采取相关封禁措施。<br />\r\n<br />\r\n8、xx科技有权基于交易安全等方面的考虑不时设定或修改涉及交易的相关事项，包括但不限于交易限额、交易次数等。用户了解并确认xx科技的前述设定或修改可能对用户的交易产生一定的不便，用户对此没有异议。<br />\r\n<br />\r\n9、用户确认，除法律法规明确规定或本协议另有约定外，用户已购买的任何收费服务不能以任何理由退购（即退换成xx币或法定货币）或调换成其他服务。<br />\r\n<br />\r\n10、因用户自身的原因导致xx科技无法提供xx币购买服务或提供xx币购买服务时发生任何错误而产生的任何损失或责任，由用户自行负责，xx科技不承担责任，包括但不限于：<br />\r\n<br />\r\n(1) 因用户的xx账号丢失、被封禁或冻结；<br />\r\n<br />\r\n(2) 用户将密码告知他人导致的财产损失；<br />\r\n<br />\r\n(3) 因用户绑定的第三方支付机构账户的原因导致的任何损失或责任；<br />\r\n<br />\r\n(4) 其他用户故意或者重大过失或者违反法律法规导致的财产损失。<br />\r\n<br />\r\n11、用户在使用xx科技提供的服务时，如出现违反国家法律法规、本协议约定或其他本平台对用户的管理规定的情形，xx科技有权暂时或永久封禁用户的账号。账号封禁后至解禁（如有）前，用户账户上的剩余xx币将被暂时冻结或全部扣除，不可继续用于购买平台上的虚拟产品或服务，同时不予返还用户购买xx币时的现金价值。<br />\r\n<br />\r\n12、用户确认并同意如用户主动注销账号，则用户已充值到账的xx币，购买的虚拟礼物，游戏币以及会员权益等视为自动放弃，xx科技不予返还相应的现金价值，也不会作出任何补偿。<br />\r\n<br />\r\n七、账户管理<br />\r\n1、 “xx”帐号的所有权归xx科技所有，用户完成申请注册手续后，获得“xx”帐号的使用权，该使用权仅属于初始申请注册人，禁止赠与、借用、租用、转让或售卖。xx科技因经营需要，有权回收用户的“xx”帐号。<br />\r\n<br />\r\n2、用户可以通过1）查看与编辑个人资料页，2）“设置”页面里的“账号与安全”页面来查询、更改、删除、注销“xx”帐户上的个人资料、注册信息及传送内容等，但需注意，删除有关信息的同时也会删除用户储存在系统中的文字和图片。用户需承担该风险。<br />\r\n<br />\r\n3、用户有责任妥善保管注册帐号信息及帐号密码的安全，因用户保管不善可能导致遭受盗号或密码失窃，责任由用户自行承担。用户需要对注册帐号以及密码下的行为承担法律责任。用户同意在任何情况下不使用其他用户的帐号或密码。在用户怀疑他人使用其帐号或密码时，用户同意立即通知xx科技。<br />\r\n<br />\r\n4、用户应遵守本协议的各项条款，正确、适当地使用本服务，如因用户违反本协议中的任何条款，xx科技在通知用户后有权依据协议中断或终止对违约用户“xx”帐号提供服务。同时，xx科技保留在任何时候收回“xx”帐号、用户名的权利。<br />\r\n<br />\r\n5、如用户注册“xx”帐号后一年不登录，通知用户后，xx科技可以收回该帐号，以免造成资源浪费，由此造成的不利后果由用户自行承担。<br />\r\n<br />\r\n6、用户可以通过“设置”页面里的“账号与安全”页面来进行账号注销服务，用户确认注销账号是不可恢复的操作，用户应自行备份与xx账号相关的信息和数据，用户确认操作之前与xx账号相关的所有服务均已进行妥善处理。用户确认并同意注销账号后并不代表本xx账号注销前的账号行为和相关责任得到豁免或减轻，如在注销期间，用户的账号被他人投诉、被国家机关调查或者正处于诉讼、仲裁程序中，xx科技有限自行终止用户的账号注销并无需另行得到用户的同意。<br />\r\n<br />\r\n八、数据储存<br />\r\n1、xx科技不对用户在本服务中相关数据的删除或储存失败负责。<br />\r\n<br />\r\n2、xx科技可以根据实际情况自行决定用户在本服务中数据的最长储存期限，并在服务器上为其分配数据最大存储空间等。用户可根据自己的需要自行备份本服务中的相关数据。<br />\r\n<br />\r\n3、如用户停止使用本服务或本服务终止，xx科技可以从服务器上永久地删除用户的数据。本服务停止、终止后，xx科技没有义务向用户返还任何数据。<br />\r\n<br />\r\n九、风险承担<br />\r\n1、用户理解并同意，“xx”仅为用户提供信息分享、传送及获取的平台，用户必须为自己注册帐号下的一切行为负责，包括用户所传送的任何内容以及由此产生的任何后果。用户应对“xx”及本服务中的内容自行加以判断，并承担因使用内容而引起的所有风险，包括因对内容的正确性、完整性或实用性的依赖而产生的风险。xx科技无法且不会对因用户行为而导致的任何损失或损害承担责任。<br />\r\n<br />\r\n如果用户发现任何人违反本协议约定或以其他不当的方式使用本服务，请立即向xx科技举报或投诉，举报或投诉电话为028-62836666，xx科技将依本协议约定进行处理。<br />\r\n<br />\r\n2、用户理解并同意，因业务发展需要，xx科技保留单方面对本服务的全部或部分服务内容变更、暂停、终止或撤销的权利，用户需承担此风险。<br />\r\n<br />\r\n十、知识产权声明<br />\r\n1、除本服务中涉及广告的知识产权由相应广告商享有外，xx科技在本服务中提供的内容（包括但不限于网页、文字、图片、音频、视频、图表等）的知识产权均归xx科技所有，但用户在使用本服务前对自己发布的内容已合法取得知识产权的除外。<br />\r\n<br />\r\n2、除另有特别声明外，xx科技提供本服务时所依托软件的著作权、专利权及其他知识产权均归xx科技所有。<br />\r\n<br />\r\n3、xx科技在本服务中所涉及的图形、文字或其组成，以及其他xx科技标志及产品、服务名称（以下统称“xx科技标识”），其著作权或商标权归xx科技所有。未经xx科技事先书面同意，用户不得将xx科技标识以任何方式展示或使用或作其他处理，也不得向他人表明用户有权展示、使用、或其他有权处理xx科技标识的行为。<br />\r\n<br />\r\n4、上述及其他任何xx科技或相关广告商依法拥有的知识产权均受到法律保护，未经xx科技或相关广告商书面许可，用户不得以任何形式进行使用或创造相关衍生作品。<br />\r\n<br />\r\n5、用户在使用xx服务时发表上传的文字、图片、视频、音频、软件以及表演等信息，此部分信息的知识产权归用户，责任由用户承担。但用户的发表、上传行为视为对xx科技的授权，用户理解并同意授予xx科技及其关联公司全球范围内完全免费、不可撤销、独家、永久、可转授权和可再许可的权利，包括但不限于：复制权、发行权、出租权、展览权、表演权、放映权、广播权、信息网络传播权、摄制权、改编权、翻译权、汇编权以及《著作权法》规定的由著作权人享有的其他著作财产权利及邻接权利。xx科技可自行选择是否使用以及使用方式，包括但不限于将前述信息在xx科技旗下的服务平台上使用与传播，将上述信息再次编辑后使用，以及由xx科技授权给合作方使用、编辑与传播等。<br />\r\n<br />\r\n十一、法律责任<br />\r\n1、如果xx科技发现或收到他人举报或投诉用户违反本协议约定的，xx科技有权不经通知随时对相关内容，包括但不限于用户资料、聊天记录进行审查、删除，并视情节轻重对违规帐号处以包括但不限于警告、帐号封禁 、设备封禁 、功能封禁 的处罚，且通知用户处理结果。<br />\r\n<br />\r\n2、因违反用户协议被封禁的用户，可以自行到 http://immomo.com/my 查询封禁期限，并在封禁期限届满后自助解封。其中，被实施功能封禁的用户会在封禁期届满后自动恢复被封禁功能。被封禁用户可向xx科技网站相关页面提交申诉，xx科技将对申诉进行审查，并自行合理判断决定是否变更处罚措施。<br />\r\n<br />\r\n3、用户理解并同意，xx科技有权依合理判断对违反有关法律法规或本协议规定的行为进行处罚，对违法违规的任何用户采取适当的法律行动，并依据法律法规保存有关信息向有关部门报告等，用户应承担由此而产生的一切法律责任。<br />\r\n<br />\r\n4、用户理解并同意，因用户违反本协议约定，导致或产生的任何第三方主张的任何索赔、要求或损失，包括合理的律师费，用户应当赔偿xx科技与合作公司、关联公司，并使之免受损害。<br />\r\n<br />\r\n十二、不可抗力及其他免责事由<br />\r\n1、用户理解并确认，在使用本服务的过程中，可能会遇到不可抗力等风险因素，使本服务发生中断。不可抗力是指不能预见、不能克服并不能避免且对一方或双方造成重大影响的客观事件，包括但不限于自然灾害如洪水、地震、瘟疫流行和风暴等以及社会事件如战争、动乱、政府行为等。出现上述情况时，xx科技将努力在第一时间与相关单位配合，及时进行修复，但是由此给用户或第三方造成的损失，xx科技及合作单位在法律允许的范围内免责。<br />\r\n<br />\r\n2、本服务同大多数互联网服务一样，受包括但不限于用户原因、网络服务质量、社会环境等因素的差异影响，可能受到各种安全问题的侵扰，如他人利用用户的资料，造成现实生活中的骚扰；用户下载安装的其它软件或访问的其他网站中含有“特洛伊木马”等病毒，威胁到用户的计算机信息和数据的安全，继而影响本服务的正常使用等等。用户应加强信息安全及使用者资料的保护意识，要注意加强密码保护，以免遭致损失和骚扰。<br />\r\n<br />\r\n3、用户理解并确认，本服务存在因不可抗力、计算机病毒或黑客攻击、系统不稳定、用户所在位置、用户关机以及其他任何技术、互联网络、通信线路原因等造成的服务中断或不能满足用户要求的风险，因此导致的用户或第三方任何损失，xx科技不承担任何责任。<br />\r\n<br />\r\n4、用户理解并确认，在使用本服务过程中存在来自任何他人的包括误导性的、欺骗性的、威胁性的、诽谤性的、令人反感的或非法的信息，或侵犯他人权利的匿名或冒名的信息，以及伴随该等信息的行为，因此导致的用户或第三方的任何损失，xx科技不承担任何责任。<br />\r\n<br />\r\n5、用户理解并确认，xx科技需要定期或不定期地对“xx”平台或相关的设备进行检修或者维护，如因此类情况而造成服务在合理时间内的中断，xx科技无需为此承担任何责任，但xx科技应事先进行通告。<br />\r\n<br />\r\n6、xx科技依据法律法规、本协议约定获得处理违法违规或违约内容的权利，该权利不构成xx科技的义务或承诺，xx科技不能保证及时发现违法违规或违约行为或进行相应处理。<br />\r\n<br />\r\n7、用户理解并确认，对于xx科技向用户提供的下列产品或者服务的质量缺陷及其引发的任何损失，xx科技无需承担任何责任：<br />\r\n<br />\r\n(1) xx科技向用户免费提供的服务；<br />\r\n<br />\r\n(2) xx科技向用户赠送的任何产品或者服务。<br />\r\n<br />\r\n8、在任何情况下，xx科技均不对任何间接性、后果性、惩罚性、偶然性、特殊性或刑罚性的损害，包括因用户使用“xx”或本服务而遭受的利润损失，承担责任（即使xx科技已被告知该等损失的可能性亦然）。尽管本协议中可能含有相悖的规定，xx科技对用户承担的全部责任，无论因何原因或何种行为方式，始终不超过用户因使用xx科技提供的服务而支付给xx科技的费用(如有)。<br />\r\n<br />\r\n十三、服务的变更、中断、终止<br />\r\n1、鉴于网络服务的特殊性，用户同意xx科技有权随时变更、中断或终止部分或全部的服务（包括收费服务）。xx科技变更、中断或终止的服务，xx科技应当在变更、中断或终止之前通知用户，并应向受影响的用户提供等值的替代性的服务；如用户不愿意接受替代性的服务，如果该用户已经向xx科技支付的xx币，xx科技应当按照该用户实际使用服务的情况扣除相应xx币之后将剩余的xx币退还用户的xx币账户中。<br />\r\n<br />\r\n2、如发生下列任何一种情形，xx科技有权变更、中断或终止向用户提供的免费服务或收费服务，而无需对用户或任何第三方承担任何责任：<br />\r\n<br />\r\n(1) 根据法律规定用户应提交真实信息，而用户提供的个人资料不真实、或与注册时信息不一致又未能提供合理证明；<br />\r\n<br />\r\n(2) 用户违反相关法律法规或本协议的约定；<br />\r\n<br />\r\n(3) 按照法律规定或有权机关的要求；<br />\r\n<br />\r\n(4) 出于安全的原因或其他必要的情形。<br />\r\n<br />\r\n十四、“附近活动”服务说明与免责条款<br />\r\n1、xx“附近活动”功能板块，是以地理位置为基础、发布用户周边文化活动信息的活动信息共享平台（下称“本平台”）。<br />\r\n<br />\r\n2、本平台发布之全部文化活动信息,包括但不限于活动地理位置信息，均直接或者间接来自于文化活动主办方。<br />\r\n<br />\r\n3、本平台发布文化活动信息，意在宣传文化活动、丰富用户文化生活。本平台用户于本平台“附近活动”功能板块发布的留言、评论等信息，均系用户自行发布。本平台不对上述信息的真实性、准确性，或及时性、完整性负责。<br />\r\n<br />\r\n4、如果相关文化活动主办方及/或相关权利主体，认为该等文化活动信息之发布，侵害其合法权益，可发邮件至mmsrc(at)immomo.com，本平台在核实其提供的证明材料后，将依法履行网络平台发布者的义务，维护其合法权益。<br />\r\n<br />\r\n十五、其他<br />\r\n1、xx科技郑重提醒用户注意本协议中免除xx科技责任和限制用户权利的条款，请用户仔细阅读，自主考虑风险<br />\r\n<br />\r\n2、本协议的效力、解释及纠纷的解决，适用于中华人民共和国法律。若用户和xx科技之间发生任何纠纷或争议，首先应友好协商解决，协商不成的，用户同意将纠纷或争议提交xx科技住所地有管辖权的人民法院管辖。<br />\r\n<br />\r\n3、本协议的任何条款无论因何种原因无效或不具可执行性，其余条款仍有效，对双方具有约束力。<br />\r\n<br />\r\n4、由于互联网高速发展，您与xx科技签署的本协议列明的条款可能并不能完整罗列并覆盖您与xx所有权利与义务，现有的约定也不能保证完全符合未来发展的需求。因此，xx隐私权政策、xx平台行为规范等均为本协议的补充协议，与本协议不可分割且具有同等法律效力。如您使用xx平台服务，视为您同意上述补充协议。<br />\r\n</span>\r\n</p>\r\n<h3 style=\"vertical-align:baseline;text-align:center;\">\r\n	<div style=\"color:#222731;font-family:&quot;font-size:20px;font-weight:bold;text-align:left;\">\r\n		<b></b>\r\n	</div>\r\n	<div style=\"color:#222731;font-family:&quot;font-size:20px;font-weight:bold;text-align:left;\">\r\n		<b></b>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\"></span>\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"text-align:left;\">\r\n		<span style=\"font-size:16px;\"></span> \r\n	</div>\r\n</h3>', '1');
INSERT INTO `yer_cate` VALUES ('15', '0', '售后保障', '0', '1', '', '', '1');
INSERT INTO `yer_cate` VALUES ('16', '15', '退换货政策', '0', '1', '', '<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"color:#FF0000;\"><span style=\"font-size:small;\">退换货承诺：</span></span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;自您签收商品之日起7日内，为您提供退换货服务！</span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n<span style=\"color:#FF0000;\">&nbsp; &nbsp; &nbsp; &nbsp;补充说明：</span></span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;符合以下情况的，不享受无理由退货服务：</span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;1、	非商品质量问题不予办理退换货业务；</span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;2、	在保障商品质量的基础上，对无适当退换理由的（如误买、不喜欢等），不予办理退换货；</span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;3、	任何</span>xx商城<span style=\"font-size:small;\">商品都支持现场验货（请当场验收，如对产品数量和质量有异议，可以当场拒收，否则视为产品合格交付；且考虑商品性质价值较高且涉及食品安全，故对本产品不支持退换货服务）；</span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;4、	酒瓶已经开封，不予办理退换货；</span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;5、	参与特殊活动（注明不予退换货）的商品；</span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;6、	定制了个性化酒标的；</span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;7、	因顾客原因导致酒标损坏等影响二次销售；</span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;8、	双方关于退换货另有书面约定的。</span> \r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;感谢您对</span>xx商城<span style=\"font-size:small;\">的支持，</span>99米名酒直供商城<span style=\"font-size:small;\">将为您提供最优质的商品及服务，</span><span style=\"font-size:small;\">祝您生活愉快！</span> \r\n</p>', '1');
INSERT INTO `yer_cate` VALUES ('17', '0', '购物指南', '1', '1', '', '', '1');
INSERT INTO `yer_cate` VALUES ('22', '15', '价格保证', '0', '1', '', '', '1');
INSERT INTO `yer_cate` VALUES ('23', '15', '服务保障承诺', '0', '1', '', '<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	1、在线响应\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp; &nbsp;&nbsp; 请拨打全国统一客服专线&nbsp;<span style=\"font-size:x-small;\"><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">4001</span></span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">9</span><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">-40019</span></span><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">/</span></span><span>4007-222-222</span></span><span style=\"font-size:smaller;\">（周一至周日8:00-21:00）</span>，将您的问题告知我们，我们的工作人员会尽快审核确认并指导您进行后续处理。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp; &nbsp;&nbsp; 2、解决方式\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp; &nbsp; &nbsp; 凡做换货、补发、补偿或者全额退款等处理的，我们会派出专业客服人员与您联系，就退换货处理方式与您做全面沟通，争取得到您满分的认可。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 3、365天*14小时服务热线\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp; &nbsp; &nbsp; &nbsp; 99米名酒直供商城针对所有会员客户，提供全年365天*14小时服务热线<span style=\"font-size:x-small;\"><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">4001</span></span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">9</span><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">-40019</span></span><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">/</span></span><span>4007-222-222</span></span>（<span style=\"font-size:10px;\">8:00-21:00</span>），为99米名酒直供商城会员随时解决产品问题及服务咨询。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 4、7天内无理由退换货\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 凡是从99米名酒直供商城成功购买商品的客户，在不影响二次销售的情况下，均可享受7天无理由退换货服务。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 5、维权中心无条件接受客户投诉\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 自接到客户投诉之时起，24小时内反馈客户问题，xx商城为了提升客户满意度，提升服务质量，郑重做出“维权中心24小时内反馈客户问题并及时跟进解决”的承诺。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 6、快递承诺\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;&nbsp;xx合作的高端物流送达，承诺一线城市最快24小时内送达，二线城市最快48小时内送达，偏远地区除外。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 7、会员价产品\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;&nbsp;99米名酒直供商城将不定期针对不同等级会员，开设特惠产品专区，等级越高，优惠越大。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 8、参加酒水品鉴会活动\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;99米名酒直供商城将不定期举办高端酒水品鉴会活动，对于三星及以上会员免费开放。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;9、免费参观会所\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;99米名酒直供商城宣扬酒文化，建立酒文化体验馆，会馆针对99米名酒直供商城四星及以上会员客户免费开放，以供参观。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;10、、个性化定制\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 专门针对高级会员量身定制独一无二的产品。例如：定制瓶身上印有会员名字或者特殊语句的产品，以供五星及以上等级会员做纪念、送礼等特殊用途。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 11、参与节目录制\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 六星会员客户专属权益，可以有机会亲临节目录制现场，参与到99米名酒直供商城主办的电视节目之中。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 12、大师讲座\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 六星会员专属服务，有机会与酒水大师面对面，交流酒水文化以及养生知识。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 13、公益活动\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 针对五星及以上会员，可以参与到99米名酒直供商城发起的公益活动中。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 14、商务活动\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 针对五星及以上会员，可提供会员与会员间的商务活动共享。\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 15、自选客服\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 针对六星级会员，客户可以综合评判，选择自己的专属客服。\r\n</p>', '1');
INSERT INTO `yer_cate` VALUES ('29', '17', '购物指南', '0', '1', '', '', '1');
INSERT INTO `yer_cate` VALUES ('32', '0', '支付方式', '0', '0', '', '', '1');
INSERT INTO `yer_cate` VALUES ('33', '17', '配送方式', '0', '0', '', '<p style=\"color:#757575;font-family:&quot;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:SimHei;font-size:14px;background-color:#FFFFFF;\"><span>xx商城自营物流-万茗堂配送中心，配送范围遍布全国各级城市；对于偏远地区采用第三方物流服务，所谓第三方指顺丰、申通、EMS、宅急送、圆通等物流公司。</span></span><span style=\"color:#404040;font-family:SimHei;font-size:14px;background-color:#FFFFFF;\">因酒类属特殊商品，国家规定只能陆运，不能空运。同时为保证货品安全，每瓶酒都采用酒类专用安全包装，以确保在运输途中不会因挤压、碰撞等因素造成破损；如出现破损，请与快递人员当面核实，并对破损进行拍照取证，请客户一定要当面验收，如有问题联系&nbsp;&nbsp;</span><span style=\"font-family:SimHei;color:#404040;background-color:#FFFFFF;font-size:small;\"><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">4001</span></span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">9</span><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">-40019</span></span><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">/</span></span><span>4007-222-222</span></span><span style=\"color:#404040;font-family:SimHei;font-size:14px;background-color:#FFFFFF;\">（周一至周日8:00-21:00）</span>\r\n</p>\r\n<p>\r\n	<br />\r\n</p>', '1');
INSERT INTO `yer_cate` VALUES ('35', '32', '在线支付', '0', '0', '', '<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:medium;\">&nbsp;1、在线支付平台</span>\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:medium;\"><br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;xx提供微信、支付宝等支付方式，覆盖率达98％。选择在线支付，即时到帐，准确快捷！</span>\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:medium;\"><br />\r\n<br />\r\n</span>\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:medium;\">&nbsp; &nbsp;2、到款时间</span>\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<br />\r\n<span>&nbsp; &nbsp; &nbsp; &nbsp;网上支付均是支付成功即到账。若由于网络故障导致您已支付成功的订单未改变订单状态，请您联系我们的客服人员为您解决，客服热线：</span><span style=\"font-size:medium;\">&nbsp;<span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">4001</span></span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">9</span><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">-40019</span></span><span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">/</span></span><span>4007-222-222</span></span>（周一至周日8:00-21:00）（仅收市话费）\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:medium;\"><br />\r\n&nbsp; &nbsp; &nbsp; &nbsp;温馨提示：在线支付付款等待期限为2小时。请您在订购成功后2小时内完成支付，否则我们将不会保留您的订单。</span>\r\n</p>', '1');
INSERT INTO `yer_cate` VALUES ('36', '32', '货到付款', '0', '0', '', '<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\">货到付款是快递人员送货上门，客户收单验货后，直接将货款交给配送员的一种结算方式。</span>\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-size:small;\"><br />\r\n</span><span style=\"color:#FF0000;\"><span style=\"font-size:small;\">&nbsp; &nbsp; &nbsp; &nbsp;注：目前暂未开通POS机刷卡服务的地区，货到后需要现金支付。</span></span>\r\n</p>', '1');
INSERT INTO `yer_cate` VALUES ('38', '0', '公告', '0', '1', '', '', '2');
INSERT INTO `yer_cate` VALUES ('39', '38', '手机公告', '0', '1', '', '', '1');
INSERT INTO `yer_cate` VALUES ('40', '38', '手机公告', '0', '1', '', '', '2');
INSERT INTO `yer_cate` VALUES ('41', '0', '底部分类', '0', '1', '', '', '2');
INSERT INTO `yer_cate` VALUES ('42', '41', '招聘信息', '0', '1', '', '<a href=\"http://hr.wanmei.com/\" target=\"_blank\">招聘信息</a>', '1');
INSERT INTO `yer_cate` VALUES ('43', '41', '法律声明', '0', '1', '', '<p class=\"MsoNormal\" style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:宋体;font-size:14pt;\">&nbsp;</span>\r\n</p>\r\n<p class=\"NewStyle15\" style=\"margin-left:17.85pt;font-family:SimHei;text-indent:-17.85pt;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:Symbol;font-size:10pt;\">·&nbsp;</span><span style=\"font-family:宋体;font-size:14pt;\">凡本网标明“</span><span style=\"font-family:宋体;font-size:14pt;\">来源：www.yershop.com”</span><span style=\"font-family:宋体;font-size:14pt;\">或者未标明来源的作品，均为本网原创作品，本网依法享有著作权。</span>\r\n</p>\r\n<p class=\"NewStyle15\" style=\"margin-left:17.85pt;font-family:SimHei;text-indent:-17.85pt;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	&nbsp;\r\n</p>\r\n<p class=\"NewStyle15\" style=\"margin-left:17.85pt;font-family:SimHei;text-indent:-17.85pt;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:宋体;font-size:14pt;\"></span>\r\n</p>\r\n<p class=\"NewStyle15\" style=\"margin-left:17.85pt;font-family:SimHei;text-indent:-17.85pt;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:Symbol;font-size:10pt;\">·&nbsp;</span><span style=\"font-family:宋体;font-size:14pt;\">原创作品版权所有，非经授权，禁止转载。如需使用，请与本站进行联系。</span>\r\n</p>\r\n<p class=\"NewStyle15\" style=\"margin-left:17.85pt;font-family:SimHei;text-indent:-17.85pt;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	&nbsp;\r\n</p>\r\n<p class=\"NewStyle15\" style=\"margin-left:17.85pt;font-family:SimHei;text-indent:-17.85pt;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:宋体;font-size:14pt;\"></span>\r\n</p>\r\n<p class=\"NewStyle15\" style=\"margin-left:17.85pt;font-family:SimHei;text-indent:-17.85pt;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:Symbol;font-size:10pt;\">·&nbsp;</span><span style=\"font-family:宋体;font-size:14pt;\">凡本网标明“版权所有，欢迎转载”的作品，本网授权不特定多数人信息网络传播权，希望向更多人传播更多信息资源。转载请标明来源本网站。</span>\r\n</p>\r\n<p class=\"NewStyle15\" style=\"margin-left:17.85pt;font-family:SimHei;text-indent:-17.85pt;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	&nbsp;\r\n</p>\r\n<p class=\"NewStyle15\" style=\"margin-left:17.85pt;font-family:SimHei;text-indent:-17.85pt;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:宋体;font-size:14pt;\"></span>\r\n</p>\r\n<p class=\"NewStyle15\" style=\"margin-left:17.85pt;font-family:SimHei;text-indent:-17.85pt;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"font-family:Symbol;font-size:10pt;\">·&nbsp;</span><span style=\"font-family:宋体;font-size:14pt;\">如因作品内容、版权、产品宣传或其它问题需要同本网站联系的，请拨打</span><span style=\"font-size:medium;\"><span>&nbsp;</span></span><span style=\"font-size:medium;\"><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">4001</span></span><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);font-size:medium;\">9</span><span style=\"font-size:medium;\"><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">-40019</span></span><span style=\"font-size:medium;\"><span style=\"font-family:微软雅黑, arial, sans-serif;background-color:rgba(255, 255, 255, 0.8);\">/</span></span><span style=\"font-size:medium;\">4007-222-222</span><span><span style=\"font-size:18.6667px;\">（周一至周日8:00-21:00）</span></span><span style=\"font-family:宋体;font-size:14pt;\">与本站联系</span>\r\n</p>', '1');
INSERT INTO `yer_cate` VALUES ('44', '5', '隐私政策', '0', '1', '', '<p style=\"color:#666666;font-family:微软雅黑, 宋体, Tahoma, Arial;font-size:14px;background-color:#F2F2F2;\">\r\n	<span style=\"font-size:16px;\">xx商城个人信息保护政策&nbsp;</span>\r\n</p>\r\n<p style=\"color:#666666;font-family:微软雅黑, 宋体, Tahoma, Arial;font-size:14px;background-color:#F2F2F2;\">\r\n	<span style=\"font-size:16px;\">为切实保护xx商城用户隐私权，优化用户体验，xx商城根据现行法规及政策，制定本《个人信息保护政策》。本《个人信息保护政策》将详细说明xx商城在获取、管理及保护用户个人信息方面的政策及措施。本《个人信息保护政策》适用于xx商城向你提供的所有服务，无论你是通过计算机设备、移动终端或其他设备获得的xx商城服务。</span>\r\n</p>\r\n<h3 style=\"color:#666666;font-family:微软雅黑, 宋体, Tahoma, Arial;background-color:#F2F2F2;vertical-align:baseline;text-align:center;\">\r\n	<div style=\"margin:0px;padding:0px;color:#222731;font-family:&quot;font-size:20px;font-weight:bold;text-align:left;\">\r\n		<b></b>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;color:#222731;font-family:&quot;font-size:20px;font-weight:bold;text-align:left;\">\r\n		<b></b>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">本个人信息保护政策是你使用xx商城服务及各项功能的基础性法律文件，我们希望你在使用xx商城服务前仔细阅读并明确你已经充分理解、接受本政策的内容，希望你可以根据自己的理解做出合适的选择。在我们更新本个人信息保护政策后，你继续使用我们的产品与/或服务，即意味着你同意本个人信息保护政策(含更新版本)内容，并且同意我们按照本个人信息保护政策收集、使用、保存和共享你的相关信息。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">本个人信息保护政策涉及的个人信息包括：基本信息（包括个人姓名、生日、性别、住址、个人电话号码、电子邮箱）；个人位置信息；网络身份标识信息（包括系统账号、IP地址、邮箱地址及与前述有关的密码、密保）；个人上网记录（包括搜索记录、使用记录、点击记录）；个人常用设备信息（包括硬件型号、设备MAC地址、操作系统类型）；</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">一、个人信息的收集</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">你已知悉且同意，在你注册xx商城账号或使用xx商城提供的服务时，xx商城将记录你提供的相关个人信息，如：密码、手机号码等，上述个人信息是你获得xx商城提供服务的基础。同时，基于优化用户体验之目的，xx商城会获取与提升xx商城服务有关的其他信息，例如当你访问xx商城时，我们可能会收集哪些服务的受欢迎程度、浏览器软件信息等以便优化我们的服务。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">在你使用xx商城前，我们会引导你阅读本协议，并在你接受本协议的基础上，获得你的相关个人信息。如果你不同意提供个人信息，你将无法使用xx商城的全部或部分功能和服务。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">xx商城仅会在出现下列情况时收集你的个人信息：</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">在你注册xx商城账号时，我们至少会收集你的账户昵称、性别、密码、密码保护选项、电子邮箱、手机号码等信息。若你以其他方式关联登陆xx商城，我们会向关联第三方请求你的个人信息，对于我们要求但第三方无法提供的个人信息，我们仍可以要求你提供。如果你拒绝提供这些信息，将影响你使用xx商城或xx商城的相关功能。在您注册使用xx商城时，我们会对你进行实名验证，如果你拒绝提供有关信息，xx商城将拒绝向你提供服务。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">在你使用xx商城提供的搜索服务时，我们会收集你的查询关键字信息、设备信息等，为了提供高效的搜索服务，这些信息有部分会暂时存储在你的本地存储设备之中。在此，你需要注意的是，你的关键词信息无法单独识别你的个人身份，其不属于你的个人信息，因此我们有权以其他的目的对其进行使用；只有当你的搜索关键词信息与你的其他信息互有联系并可以识别你的个人身份时，则在结合使用期间，我们会将你的搜索关键词信息作为你的个人信息，与你的搜索历史记录一同按照本个人信息保护政策对其进行处理与保护。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">在你使用xx商城提供的身份认证服务时，我们会收集你的姓名、身份证号、职业、有关身份证明等信息，xx商城对你的这些隐私信息会加以最大程度的保护，如果你不提供这些信息，我们将无法提供相关服务。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">当你参加xx商城的有关营销活动时，我们会收集你的姓名、学校名称、通讯地址、联系方式、银行账号等信息。这些信息是你收到转账或礼品的基础，如果你拒绝提供这些信息，我们将无法向你转账或发放礼品。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">当涉及国家安全与利益、社会公共利益、与犯罪侦查有关的相关活动、你或他人生命财产安全但在特殊情况下无法获得你的及时授权、能够从其他合法公开的渠道、法律法规规定的其他情形下，xx商城可能在不经过你的同意或授权的前提下，收集你的个人信息。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">另，如在上述场景之外获得你的个人信息，将重新征得你的明示同意，并在获得你明示同意前向你充分说明应用场景与获取你相关信息的内容与范围。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">二、对Cookie及web beacon的使用</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">Cookie可以帮助网站辨认注册用户，计算用户数量，通常被各网站用来判定完成注册的用户是否已经实现登录。xx商城承诺，对cookie信息的研究仅用于提升服务/产品质量及优化用户体验之目的。同时，如不希望个人信息保留在cookie中，你可以对浏览器进行配置：选择\"拒绝cookie\"或\"当网站发送cookie时通知你\"，你知道，鉴于xx商城的服务是通过支持cookie来是实现的，完成关闭cookie的操作后，可能影响到你访问xx商城或不能充分取得xx商城的服务。你不禁用cookie时，可能会得到提示，是否在下一次进入此网站时保留用户信息以便简化登录手续（如一键登录）。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">xx商城使用web beacon的方法和目的与cookie是相同的。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">三、个人信息的保护和安全措施</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">1、xx商城将尽一切合理努力保护其获得的用户个人信息，并由专门的数据安全部门对个人信息进行保护。为防止用户个人信息在意外的、未经授权的情况下被非法访问、复制、修改、传送、遗失、破坏、处理或使用，xx商城已经并将继续采取以下措施保护你的个人信息：</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">1）通过采取加密技术对用户个人信息进行加密保存，并通过隔离技术进行隔离。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">2）在个人信息使用时，例如个人信息展示、个人信息关联计算，我们会采用包括内容替换、加密脱敏等多种数据脱敏技术增强个人信息在使用中安全性。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">3）设立严格的数据使用和访问制度，采用严格的数据访问权限控制和多重身份认证技术保护个人信息，避免数据被违规使用。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">2、保护个人信息采取的其他安全措施</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">1）通过建立数据分类分级制度、数据安全管理规范、数据安全开发规范来管理规范个人信息的存储和使用。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">2）建立数据安全专项部门，负责安全应急响应组织来推进和保障个人信息安全。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">3、个人信息安全事件的通知</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">1）如发生个人信息引发的安全事件，xx商城将第一事件向相应主管机关报备，并即时进行问题排查，开展应急措施。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">2）通过与全量用户发送通知提醒更改密码。还可能通过电话、短信等各种方式触达用户知晓，在xx商城公共运营平台运营宣传，制止数据泄露。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">尽管已经采取了上述合理有效措施，并已经遵守了相关法律规定要求的标准，但xx商城仍然无法保证你的个人信息通过不安全途径进行交流时的安全性。因此，用户个人应采取积极措施保证个人信息的安全，如：定期修改账号密码，不将自己的账号密码等个人信息透露给他人。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">你知悉：xx商城提供的个人信息保护措施仅适用于xx商城平台，一旦你离开xx商城，浏览或使用其他网站、服务及内容资源，xx商城即没有能力及义务保护你在xx商城以外的网站提交的任何个人信息，无论你登录或浏览上述网站是否基于xx商城的链接或引导。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">网络环境中始终存在各种信息泄漏的风险，当出现意外事件、不可抗力等情形导致你的信息出现泄漏时，xx商城将极力控制局面，及时告知你事件起因、xx商城采取的安全措施、你可以主动采取的安全措施等相关情况。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">四、个人信息的存储</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">xx商城会采取合适的安全措施和技术手段存储及保护你的个人信息，以防止丢失、被误用、受到未授权访问或泄漏、被篡改或毁坏。你的个人信息存放在有密码控制的位于中国境内的服务器中，访问均是受到限制的。当你需要跨境信息传输服务时，xx商城会默认你继续使用中国境内的服务器。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">xx商城会依照个人信息的不同等级存储不同期限，存储期限严格按照法律及相关法规规定，最低期限不少于6个月。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">根据本条款的规定，我们仅允许有必要知晓这些信息的xx商城员工等第三方访问个人信息，并要求他们履行相应的保密义务。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">五、个人信息的使用和对外提供</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">未经你本人允许，xx商城不会向任何第三方公开（包括共享、转让、公开披露等方式）你的个人信息，下列情形除外：</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">1、xx商城已经取得你或你监护人的授权或同意；</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">2、司法机关或行政机关基于法定程序要求xx商城披露的；</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">3、xx商城为维护自身合法权益而向用户提起诉讼或仲裁时；</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">4、根据你与xx商城相关服务条款、应用许可使用协议的约定；</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">5、在法律允许的范围内，为保障xx商城、xx商城用户以及社会公共利益免受损害时；</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">6、符合你与其他第三人之间有关约定的；</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">你可以向特定的对象发送你的照片、身份信息、位置信息等，也可以基于xx商城的服务向不特定人共享自己的照片、位置信息、身份信息等。当你因为你的共享行为导致你的信息发生泄漏等严重情况时，xx商城不承担相关法律责任。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">7、在不透露单个用户隐私资料的前提下，xx商城有权对整个用户数据库进行分析并对用户数据库进行适当的使用。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">六、个人信息的管理</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">当你完成xx商城的账号注册并进行合理和必要的身份验证后，你可以查阅、修改、删除你提交给xx商城的个人信息。一般情况下，你可随时浏览、修改、删除自己提交的信息，但出于安全性和身份识别（如号码申诉服务）的考虑，你可能无法修改注册时提供的某些初始注册信息及验证信息。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">你有权自主更新或更正你的个人信息，或授权xx商城客服进行信息更新、更正。在你进行信息更新更正之前，我们会首先验证你的身份，其次才能进行信息的更正与更新。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">你可以自主注销xx商城账号，注销后xx商城不再收集你的个人信息。在你注销你的账号之前，xx商城将验证你的个人身份、安全状态、账户密码等信息。你注销账号的行为是不可逆的行为，一旦你注销你的账号，xx商城将即刻删除有关你账户的一切信息，并保证这些信息不会泄露，同时，你也无法通过已注销的账户获得xx商城的服务。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">七、对未成年人个人信息的特别保护</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">xx商城非常重视对未成年人个人信息的保护。若你是14周岁以下的未成年人，在使用xx商城的服务前，应确保事先取得监护人的同意，如果你是已满14不满18岁的未成年人，在使用xx商城服务前，应确保事先取得本人或监护人的同意。如你在xx商城上申请注册账号，xx商城将默认为你已得到前述同意。xx商城将根据国家相关法律法规及本《个人信息保护政策》的规定保护未成年人的个人信息。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">八、争议解决</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;font-weight:normal;\">当你因为本政策的实施与xx商城产生任何纠纷时，双方应首先协商友好解决；若不能协商解决，双方有权依照注册协议向有管辖权的法院提起诉讼。</span>\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<br />\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;text-align:left;\">\r\n		<span style=\"font-size:16px;\">如果你对本个人信息保护政策有任何疑问，请你联系xx商城客服咨询，我们会及时解决你的问题。</span>\r\n	</div>\r\n</h3>\r\n<br />', '1');
INSERT INTO `yer_cate` VALUES ('45', '41', 'Cookie政策', '0', '1', '', '<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	<b>Cookies</b>\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	我们使用Cookies来保持我们网站的可靠性，安全性和个性化。当您接受Cookies时，这有助于通过识别用户身份、记住您的偏好、或提供个性化用户体验来帮助我们改善网站。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	此Cookie政策适用于链接到此政策并由完美集团发布的所有网站、移动APP及其他网络应用程序（“完美网站”）。完美集团指完美世界(北京)数字科技有限公司、其下属各分支机构以及其合并报表范围内的下属公司或合伙企业。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	本政策应与我们的隐私政策一起阅读，该隐私政策解释了我们如何使用个人信息。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	如果您对我们使用您的个人信息或Cookies的方式有任何疑问，请通过<a href=\"mailto:privacy@pwrd.com\">privacy@pwrd.com</a>与我们联系。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	如果您想管理您的Cookies，请按照下面“如何管理Cookies”部分中的说明进行操作。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	什么是Cookies？\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	Cookies是一种小型文本文件，当您访问网站时，网站可能会将这些文件放在您的计算机或设备上。Cookies会帮助网站或其他网站在您下次访问时识别您的设备。网站信标、像素或其他类似文件也可以做同样的事情。我们在此政策中使用术语“Cookies”来指代以这种方式收集信息的所有文件。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	Cookies提供许多功能。例如，他们可以帮助我们记住您的用户名和偏好，分析我们网站的效果，或者允许我们推荐我们认为与您最相关的内容。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	大多数网站使用Cookies来收集和保留有关其访问者的个人信息。大多数Cookies收集一般信息，例如访问者如何到达和使用我们的网站，他们使用的设备，他们的互联网协议地址（IP地址），他们正在查看的页面及其大致位置（例如，我们将能够认识到您正在从北京访问我们的网站）。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	Cookies的目的\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	我们将Cookies分为以下类别:\r\n</p>\r\n<table class=\"result_table\" style=\"margin:auto;padding:0px;border:1px solid #EAEAEA;color:#666666;font-family:&quot;font-size:16px;\">\r\n	<tbody>\r\n		<tr>\r\n			<th width=\"20%\" style=\"text-align:center;background:#F7F8FD;color:#333333;\">\r\n				用途\r\n			</th>\r\n			<th style=\"text-align:center;background:#F7F8FD;color:#333333;\">\r\n				说明\r\n			</th>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"border:1px solid #EAEAEA;text-align:center;\">\r\n				授权\r\n			</td>\r\n			<td style=\"border:1px solid #EAEAEA;text-align:center;\">\r\n				您登录完美网站时，我们可通过 Cookie 提供正确信息，为您打造个性化的体验。例如：Cookie有助于我们辨认您作为我们的注册用户的身份。\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"border:1px solid #EAEAEA;text-align:center;\">\r\n				安全措施\r\n			</td>\r\n			<td style=\"border:1px solid #EAEAEA;text-align:center;\">\r\n				我们通过 Cookie 启用及支持安全功能，监控和防止可疑活动、欺诈性流量和违反完美用户协议的行为。\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"border:1px solid #EAEAEA;text-align:center;\">\r\n				偏好、功能和服务\r\n			</td>\r\n			<td style=\"border:1px solid #EAEAEA;text-align:center;\">\r\n				我们使用功能性Cookies来让我们记住您的偏好，或保存您向我们提供的有关您的喜好或其他信息。\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"border:1px solid #EAEAEA;text-align:center;\">\r\n				广告\r\n			</td>\r\n			<td style=\"border:1px solid #EAEAEA;text-align:center;\">\r\n				我们使用Cookies为您提供我们认为与您和您的兴趣相关的广告。您可能会在我们的网站和您访问的其他网站上看到这些广告。\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"border:1px solid #EAEAEA;text-align:center;\">\r\n				网站性能、分析和研究\r\n			</td>\r\n			<td style=\"border:1px solid #EAEAEA;text-align:center;\">\r\n				我们使用这些cookie来监控网站性能。这使我们能够通过快速识别和解决出现的任何问题来提供高质量的体验。\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<br />\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	我们网站上的第三方Cookies\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	我们还在我们的网站上使用属于上述类别的第三方Cookies，用于以下目的：\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·帮助我们监控网站上的流量；\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·识别欺诈或非人为性流量；\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·协助市场调研；\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·改善网站功能；\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·监督我们的注册协议和隐私政策的遵守情况。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	如何管理Cookies？\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	在将Cookie放置在您的计算机或设备上之前，系统会显示一个弹出窗口，要求您同意设置这些Cookie。通过同意放置Cookies，您可以让我们为您提供最佳的体验和服务。如果您愿意，您可以拒绝同意放置Cookies（除非这些Cookie是绝对必要的）； 但是，我们网站的某些功能可能无法完全或按预期运行。您最初将有机会允许和/或拒绝使用Cookie。您可以通过访问浏览器设置随时返回到您的Cookie偏好设置以查看和/或删除它们。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	除了我们提供的控件之外，您还可以选择在Internet浏览器中启用或禁用Cookie。大多数互联网浏览器还允许您选择是要禁用所有Cookie还是仅禁用第三方Cookie。默认情况下，大多数互联网浏览器都接受Cookie，但这可以更改。有关详细信息，请参阅Internet浏览器中的帮助菜单或设备随附的文档。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	以下链接提供了有关如何在所有主流浏览器中控制Cookie的说明：\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·<a href=\"https://support.google.com/chrome/answer/95647?hl=en\" target=\"_blank\">Google Chrome</a>\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·<a href=\"https://support.microsoft.com/en-us/help/260971/description-of-Cookies\" target=\"_blank\">IE</a>\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·<a href=\"https://support.apple.com/kb/PH5042?locale=en_US\" target=\"_blank\">Safari（桌面版）</a>\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·<a href=\"https://support.apple.com/en-us/HT201265\" target=\"_blank\">Safari（移动版）</a>\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·<a href=\"https://support.mozilla.org/en-US/kb/Cookies-information-websites-store-on-your-computer\" target=\"_blank\">火狐浏览器</a>\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	　　·<a href=\"http://support.google.com/ics/nexus/bin/answer.py?hl=en&amp;answer=2425067\" target=\"_blank\">Android浏览器</a>\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	如您使用其他浏览器，请参阅浏览器制造商提供的文档。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	有关Cookies以及如何管理Cookies的更多信息，请访问：\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	wikipedia.org、www.allaboutCookies.org或www.aboutCookies.org\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	更多信息\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	有关我们数据处理的更多信息，请参阅我们的隐私政策。如果您对此Cookie政策有任何疑问，请通过<a href=\"mailto:privacy@pwrd.com\">privacy@pwrd.com</a>与我们联系。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	对此Cookie政策的更改\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	此政策自2018年【11】月【15】日起生效。\r\n</p>\r\n<p style=\"text-indent:2em;color:#666666;font-family:&quot;font-size:16px;\">\r\n	我们可能对此Cookie政策所做的任何更改都将发布在此页面上。如果更改很重要，我们可能会选择通过电子邮件通知您，或在我们的主页上明确指出该政策已更新。\r\n</p>', '1');
INSERT INTO `yer_cate` VALUES ('46', '41', '企业资质', '0', '1', '', '', '1');
INSERT INTO `yer_cate` VALUES ('47', '17', '配送范围', '0', '1', '', '<p style=\"font-family:SimHei;text-indent:2em;color:#404040;background-color:#FFFFFF;\">\r\n	<span>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n		xx商城支持全国所有地区的免费配送业务（港、澳、台海外除外），xx商城自营物流万茗堂配送中心，配送范围遍布全国各级城市；对于偏远地区采用第三方物流服务，包括顺丰、申通、EMS、宅急送、圆通等物流公司。&nbsp;\r\n	</p>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n		&nbsp;\r\n	</p>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n		以下为xx商城支持免费专人配送的城市：\r\n	</p>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;text-align:center;\">\r\n		<a href=\"http://www.99mi.com/images/upload/File/111.png\"><img alt=\"\" src=\"http://www.99mi.com/images/upload/File/111.png\" /></a>&nbsp;\r\n	</p>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n		<strong>服务说明：</strong>\r\n	</p>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n		&nbsp;\r\n	</p>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n		①、 由万茗堂配送中心配送且是整箱的商品（偏远区域除外），享受货到付款服务。\r\n	</p>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n		&nbsp;\r\n	</p>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n		②、 由于业务发展变化、行政区域更名等因素，货到付款区域可能会不时有扩大、变更或调整，具体区域请以99米名酒直供商城最新确认为准。\r\n	</p>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n		&nbsp;\r\n	</p>\r\n	<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n		③、以上地址仅限市区，特别偏远地区将不支持货到付款。\r\n	</p>\r\n</span>\r\n</p>\r\n<p style=\"font-family:SimHei;text-indent:2em;color:#404040;font-size:14px;background-color:#FFFFFF;\">\r\n	<span style=\"color:#FF0000;\"><span style=\"font-size:small;\"></span></span> \r\n</p>', '1');
INSERT INTO `yer_cate` VALUES ('48', '17', '订单查询', '0', '1', '', '&nbsp;登陆会员中心即可查询订单', '1');
INSERT INTO `yer_cate` VALUES ('49', '38', '积分商城消息', '0', '1', null, '', '2');

-- ----------------------------
-- Table structure for yer_category
-- ----------------------------
DROP TABLE IF EXISTS `yer_category`;
CREATE TABLE `yer_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `name` varchar(30) NOT NULL COMMENT '标志',
  `title` varchar(50) NOT NULL COMMENT '标题',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `list_row` tinyint(3) unsigned NOT NULL DEFAULT '10' COMMENT '列表每页行数',
  `meta_title` varchar(50) NOT NULL DEFAULT '' COMMENT 'SEO的网页标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `template_index` varchar(100) NOT NULL COMMENT '频道页模板',
  `template_lists` varchar(100) NOT NULL COMMENT '列表页模板',
  `template_detail` varchar(100) NOT NULL COMMENT '详情页模板',
  `template_edit` varchar(100) NOT NULL COMMENT '编辑页模板',
  `type` varchar(100) NOT NULL DEFAULT '' COMMENT '允许发布的内容类型',
  `display` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '可见性',
  `extend` text NOT NULL COMMENT '扩展设置',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '数据状态',
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类图标',
  `types_id` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=184 DEFAULT CHARSET=utf8 COMMENT='分类表';

-- ----------------------------
-- Records of yer_category
-- ----------------------------
INSERT INTO `yer_category` VALUES ('52', 'fruit', '食品饮料', '0', '7', '10', '', '', '', '', 'goods/lists', 'goods/detail', 'goods/edit', '1', '1', '\"\"', '1411925214', '1489562378', '1', '454', '41');
INSERT INTO `yer_category` VALUES ('58', 'j_fruit', '进口水果', '52', '0', '10', '', '', '', '', '', '', '', '1', '1', '', '1411935041', '1421425884', '1', '430', '42');
INSERT INTO `yer_category` VALUES ('57', 'c_fruit', '国内水果', '52', '0', '10', '', '', '', '', '', '', '', '1', '1', '', '1411934874', '1422719396', '1', '429', '42');
INSERT INTO `yer_category` VALUES ('71', 'tushu', '图书音像', '0', '4', '10', '', '', '', '', 'goods/lists', 'goods/detail', 'goods/edit', '0', '1', '', '1414344085', '1420956824', '1', '459', '46');
INSERT INTO `yer_category` VALUES ('72', 'xie', '珠宝钟表', '0', '0', '10', '', '', '', '', '', '', '', '0', '1', '', '1414674812', '1421415890', '1', '211', '40');
INSERT INTO `yer_category` VALUES ('73', 'car', '汽车用品', '0', '0', '10', '', '', '', '', 'goods/lists', 'goods/detail', 'goods/edit', '0', '1', '', '1414674847', '1421388297', '1', '458', '45');
INSERT INTO `yer_category` VALUES ('75', 'fushi', '服装鞋包', '0', '5', '10', '', '', '', '', 'goods/lists', 'goods/detail', 'goods/edit', '1', '1', '', '1414674964', '1421391978', '1', '456', '42');
INSERT INTO `yer_category` VALUES ('76', 'jiaju', '玩具乐器', '0', '0', '10', '', '', '', '', '', '', '', '0', '1', '\"\"', '1414675003', '1438934343', '1', '214', '40');
INSERT INTO `yer_category` VALUES ('126', 'apple', '苹果', '57', '0', '10', '', '', '', '', '', '', '', '1', '1', '', '1421502954', '1421502954', '1', '454', '40');
INSERT INTO `yer_category` VALUES ('81', 'ebook', '电子书', '71', '0', '10', '', '', '', '', '', '', '', '', '1', '', '1420956858', '1420956858', '1', '0', '39');
INSERT INTO `yer_category` VALUES ('82', 'mianfei', '免费', '81', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420956901', '1420956901', '1', '0', '38');
INSERT INTO `yer_category` VALUES ('83', 'emusic', '数字音乐', '81', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420959330', '1420960517', '1', '0', '46');
INSERT INTO `yer_category` VALUES ('86', 'renwensheke', '人文社科', '71', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420960622', '1420960622', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('87', 'history', '历史', '86', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420960661', '1420960661', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('88', 'xinli', '心理学', '86', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420960700', '1420960711', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('108', 'qingjie', '清洁', '106', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420963449', '1420963449', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('92', 'nvxie', '女鞋', '72', '0', '10', '', '', '', '', '', '', 'goods/edit', '1', '1', '', '1420961778', '1420961778', '1', '0', '42');
INSERT INTO `yer_category` VALUES ('90', 'gex', '个护化妆', '0', '0', '10', '', '', '', '', '', '', '', '2,1,3', '1', '', '1420961431', '1421388355', '1', '216', '40');
INSERT INTO `yer_category` VALUES ('93', 'nvxue', '女靴', '92', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420961856', '1420961856', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('94', 'nanxie', '男鞋', '72', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420961909', '1420961909', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('96', 'yundongxie', '运动鞋', '94', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420962056', '1420962056', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('97', 'quanbuche', '全部整车', '73', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420962156', '1420962156', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('98', 'xiaoxingche', '小型车', '97', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420962208', '1420962208', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('99', 'nvbao', '女包', '72', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420962320', '1420962320', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('100', 'danjianbao', '单肩包', '99', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420962475', '1420962475', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('101', 'shoutibao', '手提包', '99', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420962560', '1420962560', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('102', 'weixiubaoyang', '维修保养', '73', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420962736', '1420962736', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('103', 'yunhuayou', '润滑油', '102', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420962815', '1420962815', '1', '213', '40');
INSERT INTO `yer_category` VALUES ('109', 'dianchi', '电池', '105', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420963534', '1421426883', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('104', 'shoujitx', '手机通信', '107', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420963032', '1420963107', '1', '0', '38');
INSERT INTO `yer_category` VALUES ('105', 'shoujipj', '手机配件', '107', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420963151', '1420963151', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('106', 'mbhli', '面部护肤', '90', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420963200', '1420963200', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('107', 'sjsmtx', '手机数码', '0', '6', '10', '', '', '', '', 'goods/lists', 'goods/detail', 'goods/edit', '1', '1', '', '1420963286', '1421388202', '1', '455', '43');
INSERT INTO `yer_category` VALUES ('110', 'mobilephone', '手机', '104', '0', '10', '', '', '', '', '', '', '', '2', '1', '\"\"', '1420963589', '1428684577', '1', '0', '43');
INSERT INTO `yer_category` VALUES ('111', 'jiajujiaz', '家具家装', '0', '0', '10', '', '', '', '', 'goods/lists', 'goods/detail', 'goods/edit', '1', '1', '', '1420963642', '1421388233', '1', '457', '40');
INSERT INTO `yer_category` VALUES ('112', 'chuju', '厨具', '111', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420963698', '1420963698', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('114', 'daojiancb', '刀剪菜板', '112', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420963850', '1420963850', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('115', 'nanzhuang', '男装', '75', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420964463', '1420964463', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('116', 'chenshan', '衬衫', '115', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420964510', '1420964510', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('117', 'nvzhuang', '女装', '75', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420964548', '1420964548', '1', '0', '39');
INSERT INTO `yer_category` VALUES ('118', 'fushipj', '服饰配件', '75', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420964671', '1420964671', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('119', 'zbss', '珠宝首饰', '75', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420964736', '1420964736', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('120', 'milk', '奶粉', '76', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420965368', '1420965391', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('121', 'yyfs', '营养辅食', '76', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420965451', '1420965451', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('123', 'tyj', '太阳镜', '118', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1420965553', '1420965553', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('124', 'clz', '车厘子', '58', '0', '10', '', '', '', '', 'goods/lists', 'goods/detail', 'goods/edit', '1', '1', '', '1420965600', '1420965600', '1', '543', '40');
INSERT INTO `yer_category` VALUES ('129', 'yurf', '羽绒服', '115', '0', '10', '', '', '', '', '', '', '', '2', '1', '', '1421591035', '1421591035', '1', '0', '42');
INSERT INTO `yer_category` VALUES ('150', 'lysx', '粮油生鲜', '52', '0', '30', '', '', '', '', '', '', '', '1', '1', '\"\"', '1442675312', '1442675312', '1', '428', '40');
INSERT INTO `yer_category` VALUES ('151', 'ylnn', '饮料牛奶', '52', '0', '30', '', '', '', '', 'goods/lists', 'goods/detail', 'goods/edit', '1', '1', '\"\"', '1442675533', '1442675533', '1', '427', '47');
INSERT INTO `yer_category` VALUES ('152', 'xxsp', '休闲食品', '52', '0', '30', '', '', '', '', '', '', '', '1', '1', '\"\"', '1442675864', '1442675864', '1', '426', '41');
INSERT INTO `yer_category` VALUES ('153', 'djmj', '鼎极名酒', '52', '0', '30', '', '', '', '', '', '', '', '1', '1', '\"\"', '1442742276', '1442946577', '1', '425', '40');
INSERT INTO `yer_category` VALUES ('154', 'clyy', '潮流影音', '107', '0', '30', '', '', '', '', '', '', '', '2', '1', '\"\"', '1442754697', '1442754697', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('155', 'divyj', 'DIV硬件', '107', '0', '30', '', '', '', '', '', '', '', '1', '1', '\"\"', '1442754780', '1442754780', '1', '434', '40');
INSERT INTO `yer_category` VALUES ('156', 'djyx', '电竞游戏', '107', '0', '30', '', '', '', '', '', '', '', '1', '1', '\"\"', '1442754842', '1442754842', '1', '432', '44');
INSERT INTO `yer_category` VALUES ('157', 'bgwl', '办公网络', '107', '0', '30', '', '', '', '', '', '', '', '1', '1', '\"\"', '1442754922', '1442754922', '1', '431', '44');
INSERT INTO `yer_category` VALUES ('158', 'ejem', '耳机耳麦', '154', '0', '30', '', '', '', '', '', '', '', '2', '1', '\"\"', '1442771388', '1442771388', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('159', '', '长袖', '117', '0', '10', '', '', '', '', '', '', '', '', '0', '', '0', '0', '0', '0', '39');
INSERT INTO `yer_category` VALUES ('160', '', '笔记本', '157', '0', '0', '', '', '', '', '', '', '', '2', '0', '', '0', '0', '1', '0', '44');
INSERT INTO `yer_category` VALUES ('161', '', '坚果', '152', '0', '0', '', '', '', '', '', '', '', '1', '0', '', '0', '0', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('162', '', '糖果', '152', '0', '0', '', '', '', '', '', '', '', '2', '0', '', '0', '0', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('163', '', '下装', '115', '0', '0', '', '', '', '', '', '', '', '2', '0', '', '0', '0', '1', '0', '42');
INSERT INTO `yer_category` VALUES ('164', '', '闪购', '0', '0', '0', '', '', '', '', '', 'goods/time_detail', 'goods/time', '0', '0', '', '0', '0', '1', '0', '48');
INSERT INTO `yer_category` VALUES ('165', '', '手机端', '164', '0', '0', '', '', '', '', '', '', 'goods/time', '1', '0', '', '0', '0', '1', '0', '48');
INSERT INTO `yer_category` VALUES ('167', '', '10点场', '165', '0', '0', '', '', '', '', '', '', '', '1', '0', '', '0', '0', '1', '0', '48');
INSERT INTO `yer_category` VALUES ('168', '', '15点场', '165', '0', '0', '', '', '', '', '', '', '', '1', '0', '', '0', '0', '1', '0', '48');
INSERT INTO `yer_category` VALUES ('169', '', '20点场', '165', '0', '0', '', '', '', '', '', '', '', '1', '0', '', '0', '0', '1', '0', '48');
INSERT INTO `yer_category` VALUES ('170', '', '22点场', '165', '0', '0', '', '', '', '', '', '', '', '2', '0', '', '0', '0', '1', '0', '48');
INSERT INTO `yer_category` VALUES ('172', '', '积分', '0', '0', '0', '', '', '', '', 'goods/score_lists', 'goods/score_detail', 'goods/score', '0', '0', '', '0', '0', '1', '0', '50');
INSERT INTO `yer_category` VALUES ('173', '', '手机积分购', '172', '0', '0', '', '', '', '', 'goods/score_lists', 'goods/score_detail', 'goods/score', '1', '0', '', '0', '0', '1', '0', '50');
INSERT INTO `yer_category` VALUES ('174', '', '通用', '165', '0', '0', '', '', '', '', 'goods/time_lists', 'goods/time_detail', 'goods/time', '1', '0', '', '0', '0', '1', '0', '48');
INSERT INTO `yer_category` VALUES ('175', '', '上衣', '115', '0', '0', '', '', '', '', '', '', 'goods/edit', '1', '0', '', '0', '0', '1', '0', '42');
INSERT INTO `yer_category` VALUES ('176', '', '手机专享', '0', '0', '0', '', '', '', '', '', '', '', '0', '0', '', '0', '0', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('177', '', '医药保健', '0', '0', '0', '', '', '', '', '', '', '', '0', '1', '', '0', '0', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('178', '', '机票酒店', '0', '0', '0', '', '', '', '', '', '', '', '0', '1', '', '0', '0', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('179', '', '安装维修', '0', '0', '0', '', '', '', '', '', '', '', '0', '1', '', '0', '0', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('180', '', '理财保险', '0', '0', '0', '', '', '', '', '', '', '', '0', '1', '', '0', '0', '1', '0', '40');
INSERT INTO `yer_category` VALUES ('182', '', '预约', '0', '0', '0', '', '', '', '', 'goods/yuyue_lists', 'goods/yuyue_detail', 'goods/edit', '0', '0', '', '0', '0', '1', '0', '51');
INSERT INTO `yer_category` VALUES ('183', '', '电脑', '75', '0', '0', '', '', '', '', 'goods/lists', 'goods/detail', 'goods/edit', '', '0', '', '0', '0', '1', '0', '40');

-- ----------------------------
-- Table structure for yer_change
-- ----------------------------
DROP TABLE IF EXISTS `yer_change`;
CREATE TABLE `yer_change` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `goodid` int(10) unsigned NOT NULL DEFAULT '0',
  `num` int(10) unsigned NOT NULL DEFAULT '0',
  `tool` varchar(225) NOT NULL DEFAULT '' COMMENT '订单号',
  `toolid` varchar(225) NOT NULL DEFAULT '' COMMENT '订单号',
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(2) NOT NULL DEFAULT '0',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `info` varchar(225) NOT NULL DEFAULT '',
  `total` decimal(50,2) NOT NULL DEFAULT '0.00',
  `backinfo` varchar(225) NOT NULL DEFAULT '',
  `shopid` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `assistant` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(225) NOT NULL DEFAULT '',
  `reason` varchar(225) NOT NULL DEFAULT '',
  `changetool` varchar(225) NOT NULL DEFAULT '',
  `changetoolid` varchar(225) NOT NULL DEFAULT '',
  `address` varchar(225) NOT NULL DEFAULT '',
  `contact` varchar(225) NOT NULL DEFAULT '',
  `parameters` varchar(225) NOT NULL DEFAULT '',
  `backname` varchar(225) NOT NULL DEFAULT '',
  `acceptname` varchar(255) NOT NULL DEFAULT '',
  `acceptphone` varchar(225) NOT NULL DEFAULT '',
  `acceptaddress` varchar(225) NOT NULL DEFAULT '',
  `username` varchar(255) NOT NULL DEFAULT '' COMMENT '联系人',
  `userphone` varchar(225) NOT NULL DEFAULT '' COMMENT '联系方式',
  `useraddress` varchar(225) NOT NULL DEFAULT '' COMMENT '联系地址',
  `partnerid` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='换货表';

-- ----------------------------
-- Records of yer_change
-- ----------------------------

-- ----------------------------
-- Table structure for yer_channel
-- ----------------------------
DROP TABLE IF EXISTS `yer_channel`;
CREATE TABLE `yer_channel` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '频道ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级频道ID',
  `title` char(30) NOT NULL COMMENT '频道标题',
  `url` char(100) NOT NULL COMMENT '频道连接',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '导航排序',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态',
  `target` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '新窗口打开',
  `uid` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `pid` (`pid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='导航表';

-- ----------------------------
-- Records of yer_channel
-- ----------------------------
INSERT INTO `yer_channel` VALUES ('1', '0', '首页', 'Index/index', '1', '1379475111', '1379923177', '1', '0', '0');
INSERT INTO `yer_channel` VALUES ('16', '0', '官网', 'http://yershop.com/', '0', '1564053245', '1564053245', '1', '0', '3');
INSERT INTO `yer_channel` VALUES ('17', '0', '优惠券', 'coupon/index', '0', '1593329419', '1593329419', '1', '0', '82');
INSERT INTO `yer_channel` VALUES ('18', '0', '积分商城', 'index/score', '0', '1593500998', '1593500998', '1', '0', '82');

-- ----------------------------
-- Table structure for yer_collect
-- ----------------------------
DROP TABLE IF EXISTS `yer_collect`;
CREATE TABLE `yer_collect` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `goods_id` int(10) unsigned NOT NULL DEFAULT '0',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `status` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '1-可见 -1-无效',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=55 DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='收藏表';

-- ----------------------------
-- Records of yer_collect
-- ----------------------------

-- ----------------------------
-- Table structure for yer_comment
-- ----------------------------
DROP TABLE IF EXISTS `yer_comment`;
CREATE TABLE `yer_comment` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `goods_id` int(100) unsigned NOT NULL DEFAULT '0',
  `sales_id` int(100) unsigned NOT NULL DEFAULT '0',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `score` varchar(225) DEFAULT NULL,
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `des` int(5) unsigned NOT NULL DEFAULT '0',
  `service` int(5) unsigned NOT NULL DEFAULT '0',
  `delivery` int(5) unsigned NOT NULL DEFAULT '0',
  `content` varchar(225) DEFAULT NULL,
  `tag` varchar(225) DEFAULT NULL,
  `is_over` int(2) DEFAULT '0',
  `cover_id` varchar(225) DEFAULT NULL COMMENT '图片',
  `status` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '1-可见 -1-无效',
  `uid` int(10) DEFAULT '0',
  `is_picture` int(2) NOT NULL DEFAULT '0',
  `not_empty` int(2) NOT NULL DEFAULT '1',
  `hide` int(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='商品表';

-- ----------------------------
-- Records of yer_comment
-- ----------------------------
INSERT INTO `yer_comment` VALUES ('1', '207', '0', '0', null, '0', '0', '0', '0', '66666', null, '0', null, '0', '82', '0', '1', '1');
INSERT INTO `yer_comment` VALUES ('2', '207', '0', '0', null, '0', '0', '0', '0', '好评', null, '0', null, '0', '82', '0', '1', '1');
INSERT INTO `yer_comment` VALUES ('28', '207', '355', '1591862289', null, '0', '0', '0', '0', 'SDFSDFSDF', null, '0', null, '0', '82', '0', '1', '1');
INSERT INTO `yer_comment` VALUES ('29', '207', '355', '1591862290', null, '0', '0', '0', '0', 'SDFSDFSDF', null, '0', null, '0', '82', '0', '1', '1');
INSERT INTO `yer_comment` VALUES ('30', '207', '354', '1591862813', null, '0', '0', '0', '0', '', null, '0', null, '0', '82', '0', '1', '1');
INSERT INTO `yer_comment` VALUES ('31', '199', '351', '1591863286', null, '0', '2', '2', '3', '6666', null, '0', null, '0', '82', '0', '1', '1');
INSERT INTO `yer_comment` VALUES ('32', '207', '350', '1591863486', null, '0', '3', '4', '5', 'safafasf', null, '0', '588,589', '0', '82', '0', '1', '1');
INSERT INTO `yer_comment` VALUES ('33', '225', '372', '1592448003', null, '0', '2', '3', '4', '好评...6666', null, '0', '593,597', '0', '104', '0', '1', '1');
INSERT INTO `yer_comment` VALUES ('34', '225', '372', '1592399198', null, '0', '2', '3', '4', '好评', null, '0', '592,593', '0', '104', '0', '1', '1');
INSERT INTO `yer_comment` VALUES ('35', '207', '372', '1592399236', null, '0', '2', '3', '4', '好评', null, '0', '592,593', '0', '104', '0', '1', '1');
INSERT INTO `yer_comment` VALUES ('36', '207', '371', '1592464215', null, '0', '2', '3', '4', '好评.....', null, '0', '594', '0', '104', '0', '1', '1');
INSERT INTO `yer_comment` VALUES ('37', '227', '370', '1592399543', null, '0', '2', '2', '2', '好评', null, '0', '595', '0', '104', '0', '1', '1');
INSERT INTO `yer_comment` VALUES ('38', '227', '370', '1592399544', null, '0', '2', '2', '2', '好评', null, '0', '595', '0', '104', '0', '1', '1');
INSERT INTO `yer_comment` VALUES ('39', '225', '369', '1592399576', null, '0', '1', '1', '1', '好评', null, '0', '596', '0', '104', '0', '1', '1');
INSERT INTO `yer_comment` VALUES ('40', '207', '371', '1592452415', null, '0', '3', '3', '3', '好评', null, '0', '598', '0', '104', '0', '1', '1');

-- ----------------------------
-- Table structure for yer_comment_tag
-- ----------------------------
DROP TABLE IF EXISTS `yer_comment_tag`;
CREATE TABLE `yer_comment_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attr_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(64) NOT NULL,
  `category_id` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='评价标签表';

-- ----------------------------
-- Records of yer_comment_tag
-- ----------------------------

-- ----------------------------
-- Table structure for yer_config
-- ----------------------------
DROP TABLE IF EXISTS `yer_config`;
CREATE TABLE `yer_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '配置名称',
  `type` varchar(225) DEFAULT '0' COMMENT '配置类型',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '配置说明',
  `group` varchar(225) DEFAULT '0' COMMENT '配置分组',
  `extra` varchar(255) NOT NULL DEFAULT '' COMMENT '配置值',
  `remark` varchar(100) NOT NULL DEFAULT '' COMMENT '配置说明',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态',
  `value` text COMMENT '配置值',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=166 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='配置表';

-- ----------------------------
-- Records of yer_config
-- ----------------------------
INSERT INTO `yer_config` VALUES ('1', 'WEB_SITE_TITLE', 'text', '网站标题', '0', '', '网站标题前台显示标题', '1378898976', '1379235274', '1', 'yershop商城系统', '0');
INSERT INTO `yer_config` VALUES ('2', 'DESCRIPTION', 'textarea', '网站描述', '0', '', '网站搜索引擎描述', '1378898976', '1379235841', '1', 'yershop商城系统,567575', '1');
INSERT INTO `yer_config` VALUES ('3', 'KEYWORD', 'textarea', '网站关键字', '1', '', '网站搜索引擎关键字', '1378898976', '1381390100', '1', 'yershop,OneThink商城，thinkphp商城系统', '8');
INSERT INTO `yer_config` VALUES ('4', 'WEB_SITE_CLOSE', 'checkbox', '关闭站点', '0', '0:开启,on:关闭', '站点关闭后其他用户不能访问，管理员可以正常访问', '1378898976', '1379235296', '1', '0', '1');
INSERT INTO `yer_config` VALUES ('100', 'QQKEY', 'text', 'QqKEY', '2', '', 'qq登录key,申请地址https://connect.qq.com/', '0', '0', '0', '7897', '0');
INSERT INTO `yer_config` VALUES ('101', 'QQSECRET', 'text', 'QqSecret', '2', '', 'qq登录密钥', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('92', 'logo', 'picture', '网站logo', '0', '', '网站logo', '0', '0', '0', '466', '0');
INSERT INTO `yer_config` VALUES ('91', 'GROUP', 'text', '配置分组', '-1', '', '', '0', '0', '0', '基本|高级|登录|参数|运营|支付|上传|小程序|分销|短信', '0');
INSERT INTO `yer_config` VALUES ('102', 'DIALOG_STYLE', 'select', '提示框弹窗类型', '1', '0:旧式风格,\r\n1:改进型easyDialog风格\r\n2:layer风格', '处理成功后弹出类型', '0', '0', '0', '2', '0');
INSERT INTO `yer_config` VALUES ('106', 'USER_ALLOW_REGISTER', 'select', '是否开启会员注册', '1', '0:关闭,1:开启', '0:关闭,1:开启', '0', '0', '0', '1', '0');
INSERT INTO `yer_config` VALUES ('110', 'PHONE', 'text', '联系方式', '4', '', '', '0', '0', '0', '027-88125684', '0');
INSERT INTO `yer_config` VALUES ('111', 'ALI', 'text', '阿里旺旺号', '4', '', '', '0', '0', '0', '234234', '0');
INSERT INTO `yer_config` VALUES ('112', 'STAR', 'textarea', '星座配置', '3', '', '', '0', '0', '0', '巨蟹座|狮子座|双鱼座|处女座|双子座|天蝎座 |射手座|水瓶座', '0');
INSERT INTO `yer_config` VALUES ('113', 'APPID', 'text', '微信AppID', '2', '', '微信开放平台AppID', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('114', 'APPSECRET', 'text', '微信AppSecret', '2', '', '微信开放平台AppSecret', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('115', 'COLOR', 'color', '后台主题颜色', '1', '', '#357eca,#e8303f,#40AB7E，#00CC99\r\n', '0', '0', '0', '#0082df', '0');
INSERT INTO `yer_config` VALUES ('117', 'ALIPAYPARTNER', 'text', '支付宝合作身份者ID', '5', '', '合作身份者ID，签约账号，以2088开头由16位纯数字组成的字符串，查看地址：https://b.alipay.com/order/pidAndKey.htm', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('118', 'ALIPAYSELLERID', 'text', '收款支付宝账号', '5', '', '收款支付宝账号，以2088开头由16位纯数字组成的字符串，一般情况下收款账号就是签约账号', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('119', 'ALIPAYKEY', 'text', '支付宝MD5密钥', '5', '', 'MD5密钥，安全检验码，由数字和字母组成的32位字符串，查看地址：https://b.alipay.com/order/pidAndKey.htm', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('120', 'HUYIUSERNAME', 'text', '互亿短信账号', '9', '', '申请后获得，申请地址http://www.ihuyi.com/', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('121', 'HUYIPASSWORD', 'text', '互亿短信密码', '9', '', '申请后获得，申请地址http://www.ihuyi.com/', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('122', 'SINAAPPID', 'text', '新浪微博appid', '2', '', '申请后获得，申请地址http://open.weibo.com/', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('123', 'SINASECRET', 'text', '新浪微博secret', '2', '', '申请后获得，申请地址http://open.weibo.com/', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('126', 'REKEWORD', 'text', '热门搜索', '0', '', '热门搜索', '0', '0', '0', '手机|电脑|笔记本|yershop|苹果|梨', '0');
INSERT INTO `yer_config` VALUES ('127', 'upload_type', 'select', '上传驱动', '6', '0:本地上传\r\n1:阿里云oss\r\n2:七牛云', '默认使用本地上传', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('128', 'ACCESSID', 'text', '阿里云AccessId', '6', '', '阿里云OSS AccessId', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('129', 'ACCESSKEY', 'text', '阿里云AccessKey', '6', '', '阿里云AccessKey', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('130', 'SERVERURL', 'text', '阿里云服务器地址', '6', '', '域名地址', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('131', 'SITE_NAME', 'text', '网站名称', '0', '', '网站名称', '0', '0', '0', 'yershop', '0');
INSERT INTO `yer_config` VALUES ('132', 'mini_appid', 'text', '小程序appid', '7', '', '申请地址https://mp.weixin.qq.com', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('133', 'mini_secret', 'text', '小程序secret', '7', '', '小程序secret', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('157', 'mch_id', 'text', '微信支付商户号', '7', '', '申请地址：https://pay.weixin.qq.com/index.php/core/home/login?return_url=%2Findex.php%2Fextend%2Fpay_sett', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('134', 'IS_MANG', 'select', '是否开启满减优惠', '3', '0:关闭,1:开启', '开启后计算满减优惠，默认开启', '0', '0', '0', '1', '0');
INSERT INTO `yer_config` VALUES ('135', 'pin', 'select', '是否开启拼团', '3', '0:关闭,1:开启', '0:关闭,1:开启', '0', '0', '0', '1', '0');
INSERT INTO `yer_config` VALUES ('136', 'fenxiao', 'select', '是否开启分销', '8', '0:关闭,1:开启', '0:关闭,1:开启', '0', '0', '0', '1', '0');
INSERT INTO `yer_config` VALUES ('137', 'l1', 'text', '一级提成比例', '8', '', '', '0', '0', '0', '1', '0');
INSERT INTO `yer_config` VALUES ('138', 'l2', 'text', '二级提成比例', '8', '', '', '0', '0', '0', '2', '0');
INSERT INTO `yer_config` VALUES ('139', 'l3', 'text', '三级提成比例', '8', '', '', '0', '0', '0', '3', '0');
INSERT INTO `yer_config` VALUES ('140', 'l4', 'text', '四级提成比例', '8', '', '', '0', '0', '0', '4', '0');
INSERT INTO `yer_config` VALUES ('143', 'ishttps', 'select', '开启https', '4', '0:关闭,1:开启', '是否开启https', '0', '0', '0', '0', '0');
INSERT INTO `yer_config` VALUES ('144', 'QACCESSKEY', 'text', '七牛云accessKey', '6', '', '申请地址https://www.qiniu.com/', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('145', 'QSECRETKEY', 'text', '七牛云secretKey', '6', '', '七牛云SECRETKEY', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('146', 'QDOMAIN', 'text', '七牛云空间绑定的域名', '6', '', '域名', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('147', 'QBUCKET', 'text', '七牛云上传的空间名称', '6', '', '七牛云BUCKET', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('148', 'copyright', 'textarea', '版权信息', '1', '', 'copyright', '0', '0', '0', 'CopyRight @ yershop 2014 - 2020 ', '0');
INSERT INTO `yer_config` VALUES ('149', 'isp', 'text', '备案号', '1', '', '网站备案号', '0', '0', '0', '鄂ICP备15013601号-1', '0');
INSERT INTO `yer_config` VALUES ('150', 'wxcode', 'picture', '微信商城二维码', '0', '', '微信商城链接二维码', '0', '0', '0', '528', '0');
INSERT INTO `yer_config` VALUES ('151', 'gz', 'picture', '微信公众号二维码', '0', '', '微信客服二维码', '0', '0', '0', '529', '0');
INSERT INTO `yer_config` VALUES ('152', 'home_logo', 'picture', '会员中心logo', '0', '', '透明logo,151*47', '0', '0', '0', '541', '0');
INSERT INTO `yer_config` VALUES ('153', 'dl', 'picture', '登陆页背景图片', '0', '', '', '0', '0', '0', '542', '0');
INSERT INTO `yer_config` VALUES ('154', 'PERCENT', 'text', '提现手续费率', '4', '', '百分比', '0', '0', '0', '5%', '0');
INSERT INTO `yer_config` VALUES ('158', 'wxkey', 'text', '微信支付密钥', '7', '', '微信支付key', '0', '0', '0', '', '0');
INSERT INTO `yer_config` VALUES ('159', 'isTest', 'checkbox', '是否开启小测试模式', '7', '', '使用测试类目申请上线，审核通过使用正式类目\r\n', '0', '0', '0', 'on', '0');
INSERT INTO `yer_config` VALUES ('160', 'retail_type', 'select', '分红模式', '8', '1:分级模式\r\n2:固定分红金额\r\n', '分销模式，1-订单金额分级计算，2-根据商品佣金只计算上一级', '0', '0', '0', '2', '0');
INSERT INTO `yer_config` VALUES ('161', 'add_score', 'text', '登录每次赠送积分', '4', '', '会员登录每次赠送多少积分', '0', '0', '0', '2', '0');
INSERT INTO `yer_config` VALUES ('162', 'is_pc', 'select', '二维码扫码后进入pc端还是wap端', '8', '1:pc端\r\n2:wap端', '二维码扫码结果', '0', '0', '0', '1', '0');
INSERT INTO `yer_config` VALUES ('163', 'zhouqi', 'text', '结算周期', '8', '', '订单确认收货多少天后返佣', '0', '0', '0', '15', '0');
INSERT INTO `yer_config` VALUES ('164', 'sms_code_length', 'text', '短信验证码长度', '9', '', '获取的长度短信验证码', '0', '0', '0', '4', '0');
INSERT INTO `yer_config` VALUES ('165', 'signScore', 'text', '签到赠送积分', '4', '', '签到赠送积分数量', '0', '0', '0', '3', '0');

-- ----------------------------
-- Table structure for yer_consult
-- ----------------------------
DROP TABLE IF EXISTS `yer_consult`;
CREATE TABLE `yer_consult` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_time` int(10) NOT NULL DEFAULT '0',
  `message` text NOT NULL,
  `uid` int(10) NOT NULL DEFAULT '0',
  `reply` varchar(225) DEFAULT NULL,
  `goods_id` int(10) NOT NULL DEFAULT '0',
  `is_hide` int(10) NOT NULL DEFAULT '0',
  `type` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='咨询表';

-- ----------------------------
-- Records of yer_consult
-- ----------------------------

-- ----------------------------
-- Table structure for yer_count
-- ----------------------------
DROP TABLE IF EXISTS `yer_count`;
CREATE TABLE `yer_count` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户组id,自增主键',
  `mark` text NOT NULL COMMENT '名称',
  `num` tinyint(11) NOT NULL DEFAULT '1' COMMENT '数量',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(2) NOT NULL DEFAULT '0',
  `model` varchar(225) DEFAULT NULL,
  `time` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='数量表';

-- ----------------------------
-- Records of yer_count
-- ----------------------------
INSERT INTO `yer_count` VALUES ('3', '访客数+1', '67', '1495735475', '0', 'visitor', '20170526');
INSERT INTO `yer_count` VALUES ('2', '访客数+1', '39', '1495650488', '0', 'visitor', '20170525');
INSERT INTO `yer_count` VALUES ('4', '访客数+1', '40', '1495816863', '0', 'visitor', '20170527');
INSERT INTO `yer_count` VALUES ('5', '访客数+1', '127', '1495904307', '0', 'visitor', '20170528');
INSERT INTO `yer_count` VALUES ('6', '访客数+1', '127', '1495989967', '0', 'visitor', '20170529');
INSERT INTO `yer_count` VALUES ('7', '访客数+1', '68', '1496075914', '0', 'visitor', '20170530');
INSERT INTO `yer_count` VALUES ('8', '访客数+1', '3', '1496243612', '0', 'visitor', '20170531');

-- ----------------------------
-- Table structure for yer_coupon
-- ----------------------------
DROP TABLE IF EXISTS `yer_coupon`;
CREATE TABLE `yer_coupon` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `title` varchar(225) NOT NULL DEFAULT '' COMMENT '标题',
  `money` varchar(225) NOT NULL DEFAULT '' COMMENT '链接',
  `total` varchar(225) NOT NULL DEFAULT '',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '结束时间',
  `status` tinyint(2) DEFAULT '1' COMMENT '数据状态',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COMMENT='优惠券表';

-- ----------------------------
-- Records of yer_coupon
-- ----------------------------
INSERT INTO `yer_coupon` VALUES ('9', '新用户首单优惠券', '2', '100', '1588076328', '1608812328', '1');
INSERT INTO `yer_coupon` VALUES ('10', '五一劳动节优惠券', '10', '100', '1588077910', '1593521110', '1');
INSERT INTO `yer_coupon` VALUES ('11', '六一儿童节', '50', '1000', '1590940800', '1601222400', '1');
INSERT INTO `yer_coupon` VALUES ('12', '10元优惠券', '10', '200', '1588176000', '1602691200', '1');

-- ----------------------------
-- Table structure for yer_document
-- ----------------------------
DROP TABLE IF EXISTS `yer_document`;
CREATE TABLE `yer_document` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `title` char(80) NOT NULL DEFAULT '' COMMENT '标题',
  `category_id` int(10) unsigned NOT NULL COMMENT '所属分类',
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '封面',
  `view` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '数据状态',
  `content` text NOT NULL,
  `sort` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_category_status` (`category_id`,`status`) USING BTREE,
  KEY `idx_status_type_pid` (`status`,`uid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=102 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='文章表';

-- ----------------------------
-- Records of yer_document
-- ----------------------------
INSERT INTO `yer_document` VALUES ('92', '82', 'yershop商城运费调整公告', '40', '566', '0', '1591062392', '1591062392', '1', '<p style=\"color:#666666;font-family:Arial, Verdana, 宋体;\">\r\n	<span style=\"font-family:宋体;font-size:20px;\">尊敬的各位会员：</span> \r\n</p>\r\n<p style=\"color:#666666;font-family:Arial, Verdana, 宋体;text-indent:37px;\">\r\n	<span style=\"font-family:宋体;font-size:20px;\">2019年<span style=\"font-size:24px;font-family:Calibri;\">1</span>月<span style=\"font-size:24px;font-family:Calibri;\">1</span>日起，我司针对自营商品配送的运费进行了调整，调整后，会员购买自营商品满<span style=\"font-size:24px;font-family:Calibri;\">88</span>元免运费，不满<span style=\"font-size:24px;font-family:Calibri;\">88</span>元每单收取<span style=\"font-size:24px;font-family:Calibri;\">6</span>元运费。个别商品将延续包邮，请以商品页面标准为准。望广大会员周知。</span> \r\n</p>\r\n<p style=\"color:#666666;font-family:Arial, Verdana, 宋体;text-indent:37px;\">\r\n	<span style=\"font-family:宋体;font-size:20px;\">第三方入驻卖家，则按卖家在商品详情页公示的运费标准收取。不同的卖家店铺收取的标准各异，一般存在情形如下：</span> \r\n</p>\r\n<p style=\"color:#666666;font-family:Arial, Verdana, 宋体;text-indent:37px;\">\r\n	<span style=\"font-family:宋体;font-size:16px;\">1、<span style=\"font-size:20px;\">同一店铺内商品，每单固定运费。</span></span> \r\n</p>\r\n<p style=\"color:#666666;font-family:Arial, Verdana, 宋体;text-indent:37px;\">\r\n	<span style=\"font-family:宋体;font-size:16px;\">2、<span style=\"font-size:20px;\">同一店铺内商品，每单满一定金额免运费。不满则收取一定运费。</span></span> \r\n</p>\r\n<p style=\"color:#666666;font-family:Arial, Verdana, 宋体;text-indent:37px;\">\r\n	<span style=\"font-family:宋体;font-size:16px;\">3、<span style=\"font-size:20px;\">按订单中不同商品类型分别收取运费。</span></span> \r\n</p>\r\n<p style=\"color:#666666;font-family:Arial, Verdana, 宋体;text-indent:37px;\">\r\n	<span style=\"font-family:宋体;font-size:16px;\">4、<span style=\"font-size:20px;\">其他公示的运费标准。</span></span> \r\n</p>\r\n<p style=\"color:#666666;font-family:Arial, Verdana, 宋体;\">\r\n	<span style=\"font-size:16px;\"><span style=\"font-family:宋体;font-size:20px;\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span></span> \r\n</p>', '0');
INSERT INTO `yer_document` VALUES ('93', '82', '春节放假公告', '40', '565', '0', '1591062313', '1591062313', '1', '<p style=\"font-size:16px;color:#333333;text-align:justify;font-family:arial;background-color:#FFFFFF;\">\r\n	<span class=\"bjh-p\"><span class=\"bjh-strong\" style=\"font-size:18px;font-weight:700;\">放假通知</span></span> \r\n</p>\r\n<p style=\"font-size:16px;color:#333333;text-align:justify;font-family:arial;background-color:#FFFFFF;\">\r\n	<span class=\"bjh-p\">广大学员、关心研究院的社会各界人士：<span class=\"bjh-br\"></span></span> \r\n</p>\r\n<p style=\"font-size:16px;color:#333333;text-align:justify;font-family:arial;background-color:#FFFFFF;\">\r\n	<span class=\"bjh-p\">根据《国务院关于修改〈全国年节及纪念日放假办法〉的决定》，结合东方生命研究院的实际情况，现将2019年春节放假调休时间安排公布如下：</span> \r\n</p>\r\n<p style=\"font-size:16px;color:#333333;text-align:justify;font-family:arial;background-color:#FFFFFF;\">\r\n	<span class=\"bjh-p\">2019年2月2日至2月17日放假调休，共16天。</span> \r\n</p>\r\n<p style=\"font-size:16px;color:#333333;text-align:justify;font-family:arial;background-color:#FFFFFF;\">\r\n	<span class=\"bjh-p\">节假日期间，研究院全员放假，无法接待来访人员。请有意者春节后再行来访。研究院微信公众平台“东方生命研究院”和今日头条“生命与国学”将正常发布文章或视频。</span> \r\n</p>\r\n<p style=\"font-size:16px;color:#333333;text-align:justify;font-family:arial;background-color:#FFFFFF;\">\r\n	<span class=\"bjh-p\">感谢大家一直以来对我们的支持和信任。</span> \r\n</p>', '0');
INSERT INTO `yer_document` VALUES ('98', '82', '【消息】官方QQ群获取更多赚积分方式', '49', '0', '0', '1593570070', '1593570070', '1', '<a href=\"http://jq.qq.com/?_wv=1027&amp;k=XBxLmA\" target=\"_blank\">【消息】官方QQ群获取更多赚积分方式</a>', '0');
INSERT INTO `yer_document` VALUES ('99', '82', '【通知】积分商城上线公告', '49', '0', '0', '1593572240', '1593572240', '1', '【通知】积分商城上线公告', '0');
INSERT INTO `yer_document` VALUES ('100', '82', '【活动】参与调研，获100积分', '49', '0', '0', '1593572255', '1593572255', '1', '<a href=\"http://sina.diaoyan360.com/\" target=\"_blank\">【活动】参与调研，获10万积分</a>', '0');
INSERT INTO `yer_document` VALUES ('101', '82', '【活动】众筹中奖晒单得积分', '49', '0', '0', '1593572274', '1593572274', '1', '<a href=\"http://jifen.sina.com.cn/zc\" target=\"_blank\">【活动】众筹中奖晒单得积分</a>', '0');

-- ----------------------------
-- Table structure for yer_download
-- ----------------------------
DROP TABLE IF EXISTS `yer_download`;
CREATE TABLE `yer_download` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id自增',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '路径',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '图片链接',
  `md5` char(32) NOT NULL DEFAULT '' COMMENT '文件md5',
  `sha1` char(40) NOT NULL DEFAULT '' COMMENT '文件 sha1编码',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '状态',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `exts` varchar(225) DEFAULT NULL,
  `type` smallint(2) NOT NULL DEFAULT '0',
  `size` varchar(225) DEFAULT NULL,
  `oldname` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='订单生成表';

-- ----------------------------
-- Records of yer_download
-- ----------------------------

-- ----------------------------
-- Table structure for yer_email
-- ----------------------------
DROP TABLE IF EXISTS `yer_email`;
CREATE TABLE `yer_email` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `title` varchar(225) DEFAULT NULL COMMENT '标题',
  `api_user` varchar(225) DEFAULT NULL COMMENT '邮箱',
  `content` varchar(225) DEFAULT NULL COMMENT '回复内容',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `status` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '1已发送 -1禁用',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `group` varchar(225) DEFAULT NULL COMMENT '分组',
  `to` varchar(225) DEFAULT NULL,
  `hash` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='发送邮件记录表';

-- ----------------------------
-- Records of yer_email
-- ----------------------------

-- ----------------------------
-- Table structure for yer_envelope
-- ----------------------------
DROP TABLE IF EXISTS `yer_envelope`;
CREATE TABLE `yer_envelope` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `username` varchar(225) DEFAULT NULL COMMENT '用户名',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `sid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '发件人',
  `title` varchar(225) DEFAULT NULL COMMENT '标题',
  `content` text NOT NULL COMMENT '发送内容',
  `status` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '1-未读2-已读',
  `view` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '阅读数量',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `group` varchar(225) DEFAULT NULL COMMENT '分组',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='站内信表';

-- ----------------------------
-- Records of yer_envelope
-- ----------------------------
INSERT INTO `yer_envelope` VALUES ('4', null, '83', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1589204617', '0', '2');
INSERT INTO `yer_envelope` VALUES ('5', null, '84', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1589247472', '0', '2');
INSERT INTO `yer_envelope` VALUES ('6', null, '85', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1589257649', '0', '2');
INSERT INTO `yer_envelope` VALUES ('7', null, '86', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1589434729', '0', '2');
INSERT INTO `yer_envelope` VALUES ('8', null, '87', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1589443808', '0', '2');
INSERT INTO `yer_envelope` VALUES ('9', null, '88', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1589511512', '0', '2');
INSERT INTO `yer_envelope` VALUES ('10', null, '89', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1589603156', '0', '2');
INSERT INTO `yer_envelope` VALUES ('11', null, '90', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1589647461', '0', '2');
INSERT INTO `yer_envelope` VALUES ('12', null, '91', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1589800459', '0', '2');
INSERT INTO `yer_envelope` VALUES ('13', null, '92', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1589802178', '0', '2');
INSERT INTO `yer_envelope` VALUES ('14', null, '93', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1590046321', '0', '2');
INSERT INTO `yer_envelope` VALUES ('15', null, '94', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1590750998', '0', '2');
INSERT INTO `yer_envelope` VALUES ('16', null, '95', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1590890552', '0', '2');
INSERT INTO `yer_envelope` VALUES ('17', null, '96', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1590989314', '0', '2');
INSERT INTO `yer_envelope` VALUES ('18', null, '97', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1590991941', '0', '2');
INSERT INTO `yer_envelope` VALUES ('19', null, '98', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1590991957', '0', '2');
INSERT INTO `yer_envelope` VALUES ('20', null, '99', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1591017668', '0', '2');
INSERT INTO `yer_envelope` VALUES ('21', null, '100', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1591262733', '0', '2');
INSERT INTO `yer_envelope` VALUES ('22', null, '101', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1591325856', '0', '2');
INSERT INTO `yer_envelope` VALUES ('23', null, '102', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1591326138', '0', '2');
INSERT INTO `yer_envelope` VALUES ('24', null, '103', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1591326155', '0', '2');
INSERT INTO `yer_envelope` VALUES ('25', null, '105', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1591684153', '0', '2');
INSERT INTO `yer_envelope` VALUES ('26', null, '106', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1591687050', '0', '2');
INSERT INTO `yer_envelope` VALUES ('27', null, '107', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1591727332', '0', '2');
INSERT INTO `yer_envelope` VALUES ('28', null, '108', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1591867210', '0', '2');
INSERT INTO `yer_envelope` VALUES ('29', null, '109', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1591931068', '0', '2');
INSERT INTO `yer_envelope` VALUES ('30', null, '110', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1591955120', '0', '2');
INSERT INTO `yer_envelope` VALUES ('31', null, '111', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1592107933', '0', '2');
INSERT INTO `yer_envelope` VALUES ('32', null, '113', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1592317604', '0', '2');
INSERT INTO `yer_envelope` VALUES ('33', null, '115', '82', null, '注册会员成功! 感谢您的注册, 我们将尽最大的努力为您提供优质快捷的服务,如果您对我们有任何意见，请联系027-88125684', '0', '0', '1592469291', '0', '2');

-- ----------------------------
-- Table structure for yer_express
-- ----------------------------
DROP TABLE IF EXISTS `yer_express`;
CREATE TABLE `yer_express` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `title` varchar(225) NOT NULL DEFAULT '' COMMENT '标题',
  `code` varchar(225) NOT NULL DEFAULT '' COMMENT '链接',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(2) DEFAULT '1' COMMENT '数据状态',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='快递表';

-- ----------------------------
-- Records of yer_express
-- ----------------------------
INSERT INTO `yer_express` VALUES ('1', '2', '332', '0', '0', '1');

-- ----------------------------
-- Table structure for yer_flow
-- ----------------------------
DROP TABLE IF EXISTS `yer_flow`;
CREATE TABLE `yer_flow` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `ip` varchar(225) DEFAULT NULL COMMENT 'ip地址',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `url` text NOT NULL COMMENT '网址',
  `time` varchar(255) DEFAULT NULL COMMENT '时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=42179 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='流量表';

-- ----------------------------
-- Records of yer_flow
-- ----------------------------

-- ----------------------------
-- Table structure for yer_focus
-- ----------------------------
DROP TABLE IF EXISTS `yer_focus`;
CREATE TABLE `yer_focus` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `appid` varchar(225) DEFAULT NULL COMMENT '公众号id',
  `content` text NOT NULL COMMENT '内容',
  `type` varchar(225) DEFAULT NULL COMMENT '回复类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='公众号关注回复表';

-- ----------------------------
-- Records of yer_focus
-- ----------------------------
INSERT INTO `yer_focus` VALUES ('1', 'wx643f65392e6a5e8c', 'QQ搞怪个性文字头像490 2019-10-21 QQ好看唯美风景静物头像269 2019-10-21 QQ好看粉嫩清新头像272 2019-10-21 dfgdgd唯美意境小清新风格的QQ风景头像285 2019-10 ', '');

-- ----------------------------
-- Table structure for yer_follow
-- ----------------------------
DROP TABLE IF EXISTS `yer_follow`;
CREATE TABLE `yer_follow` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `appid` varchar(255) NOT NULL DEFAULT '' COMMENT '公众号appid',
  `openid` varchar(255) NOT NULL DEFAULT '' COMMENT '用户OpenId',
  `nickname` varchar(255) NOT NULL DEFAULT '' COMMENT '昵称',
  `sex` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '性别',
  `city` varchar(255) NOT NULL DEFAULT '' COMMENT '城市',
  `province` varchar(255) NOT NULL DEFAULT '' COMMENT '省份',
  `country` varchar(255) NOT NULL DEFAULT '' COMMENT '国家',
  `language` varchar(50) NOT NULL DEFAULT 'zh_CN' COMMENT '语言',
  `headimgurl` varchar(255) NOT NULL DEFAULT '' COMMENT '头像',
  `subscribe_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '关注时间',
  `mobile` varchar(255) NOT NULL DEFAULT '' COMMENT '手机号',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '用户状态',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `uid` int(10) NOT NULL DEFAULT '0' COMMENT '用户uid',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='公众号粉丝表';

-- ----------------------------
-- Records of yer_follow
-- ----------------------------

-- ----------------------------
-- Table structure for yer_goods
-- ----------------------------
DROP TABLE IF EXISTS `yer_goods`;
CREATE TABLE `yer_goods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(256) CHARACTER SET utf8 DEFAULT NULL,
  `create_time` int(10) NOT NULL DEFAULT '0',
  `is_specs` tinyint(2) NOT NULL DEFAULT '0',
  `num` int(10) NOT NULL DEFAULT '0',
  `status` int(10) NOT NULL DEFAULT '1',
  `content` text CHARACTER SET utf8 NOT NULL,
  `category_id` int(10) NOT NULL DEFAULT '110',
  `brand_id` int(10) NOT NULL DEFAULT '0',
  `cover_id` int(10) NOT NULL DEFAULT '1',
  `price` decimal(50,2) NOT NULL DEFAULT '0.00',
  `sales` int(10) NOT NULL DEFAULT '0',
  `profit` decimal(50,2) NOT NULL DEFAULT '0.00',
  `j_price` decimal(50,2) NOT NULL DEFAULT '0.00',
  `attributes` varchar(225) DEFAULT '',
  `view` int(10) NOT NULL DEFAULT '0',
  `comments` int(10) NOT NULL DEFAULT '0',
  `baoyou` tinyint(2) NOT NULL DEFAULT '0',
  `has` tinyint(2) NOT NULL DEFAULT '1',
  `attrs` varchar(255) DEFAULT NULL,
  `spress` int(10) DEFAULT '0',
  `collect` int(10) NOT NULL DEFAULT '0',
  `covers` varchar(225) DEFAULT NULL,
  `specs` varchar(225) CHARACTER SET utf8 DEFAULT NULL,
  `update_time` int(10) NOT NULL DEFAULT '0',
  `uid` int(10) NOT NULL DEFAULT '0',
  `start_time` int(10) NOT NULL DEFAULT '0',
  `end_time` int(10) NOT NULL DEFAULT '0',
  `is_time` tinyint(2) NOT NULL DEFAULT '0',
  `score` int(10) NOT NULL DEFAULT '0',
  `reduction_id` int(10) NOT NULL DEFAULT '0',
  `pin_max_num` int(10) NOT NULL DEFAULT '0',
  `pin_price` varchar(225) DEFAULT NULL,
  `cut` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=239 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC COMMENT='商品表';

-- ----------------------------
-- Records of yer_goods
-- ----------------------------
INSERT INTO `yer_goods` VALUES ('163', '陕西精品红富士1kg 80-85mm 苹果 水果', '0', '0', '666', '1', '<img src=\"https://img.alicdn.com/imgextra/i1/1910146537/TB2CB72sl8lpuFjSspaXXXJKpXa_!!1910146537.jpg\" />', '126', '0', '285', '23.80', '0', '0.00', '0.00', '', '907', '0', '0', '1', '', '0', '0', '286,287,290,291', '', '0', '0', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('162', '澳大利亚晚季脐橙10个140g以上/个橙子水果', '1522714009', '0', '100', '1', '<img src=\"https://img.alicdn.com/imgextra/i2/1910146537/TB26vh4afNNTKJjSspcXXb4KVXa_!!1910146537.jpg\" />', '58', '0', '282', '0.10', '0', '0.00', '0.00', '', '637', '0', '0', '1', '', '0', '1', '283,284', '', '1522714009', '1', '1522714009', '1522714009', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('164', '泰国龙眼1kg 热带桂圆 进口水果', '0', '0', '122', '1', '<div class=\"col-main tm-clear clearfix\" style=\"margin:0px;padding:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;\">\r\n	<div id=\"mainwrap\" class=\"main-wrap\" style=\"margin:0px 0px 0px 200px;padding:0px;\">\r\n		<div id=\"attributes\" class=\"attributes\" style=\"margin:0px;padding:0px;\">\r\n			<div class=\"j-mdv tm-detail-slide\" style=\"margin:0px 0px 10px;padding:0px;\">\r\n				<ol class=\"ks-switchable-content\">\r\n					<li class=\"ks-switchable-panel-internal581\">\r\n						<a href=\"https://pages.tmall.com/wow/chaoshi/act/dhua?pos=2&amp;acm=201505273.1003.2.2452416&amp;scm=1003.2.201505273.OTHER_1509619719966_2452416\" target=\"_blank\"><img alt=\"\" src=\"https://img.alicdn.com/tfs/TB1xYG8XS_I8KJjy0FoXXaFnVXa-750-291.jpg\" style=\"width:790px;height:305px;\" /></a>\r\n					</li>\r\n					<li class=\"ks-switchable-panel-internal581\">\r\n						<a href=\"https://pages.tmall.com/wow/chaoshi/act/jpde?pos=3&amp;acm=201505273.1003.2.2452416&amp;scm=1003.2.201505273.OTHER_1508089941480_2452416\" target=\"_blank\"><img alt=\"\" src=\"https://img.alicdn.com/imgextra/i4/1752136151/TB2vvxSa9_I8KJjy0FoXXaFnVXa_!!1752136151.jpg\" style=\"width:790px;height:305px;\" /></a>\r\n					</li>\r\n					<li class=\"ks-switchable-panel-internal581\">\r\n						<a href=\"https://pages.tmall.com/wow/chaoshi/act/shuang11tiqianhaidi2?pos=4&amp;acm=201505273.1003.2.2452416&amp;scm=1003.2.201505273.OTHER_1510671412227_2452416\" target=\"_blank\"><img alt=\"\" src=\"https://img.alicdn.com/imgextra/i1/2102356460/TB2t4eqXkfb_uJkSnb4XXXCrXXa_!!2102356460.jpg\" style=\"width:790px;height:305px;\" /></a>\r\n					</li>\r\n					<li class=\"ks-switchable-panel-internal581\">\r\n						<a href=\"https://chaoshi.tmall.com/activity/hubV2.do?activityKey=6618812d23976bd49e3a5b4a25a6069a&amp;pos=5&amp;acm=201505273.1003.2.2452416&amp;scm=1003.2.201505273.OTHER_1509092263691_2452416\" target=\"_blank\"><img alt=\"\" src=\"https://gw.alicdn.com/tfs/TB1nvrtXLDH8KJjy1XcXXcpdXXa-750-291.jpg\" style=\"width:790px;height:305px;\" /></a>\r\n					</li>\r\n					<li class=\"ks-switchable-panel-internal581\">\r\n						<a href=\"https://chaoshi.tmall.com/activity/hubV2.do?activityKey=3250542978ea34ce3ff0a332ad2ae657&amp;pos=6&amp;acm=201505273.1003.2.2452416&amp;scm=1003.2.201505273.OTHER_1509497270317_2452416\" target=\"_blank\"><img alt=\"\" src=\"https://img.alicdn.com/imgextra/i2/1910146537/TB2aJeqXgvD8KJjSsplXXaIEFXa_!!1910146537.jpg\" style=\"width:790px;height:305px;\" /></a>\r\n					</li>\r\n				</ol>\r\n				<ul class=\"ks-switchable-nav\">\r\n					<li class=\"ks-switchable-trigger-internal580\" style=\"font-size:14px;background:#716564;text-align:center;color:#FFFFFF;\">\r\n						1\r\n					</li>\r\n					<li class=\"ks-switchable-trigger-internal580 ks-active\" style=\"font-size:14px;background:#B91919;text-align:center;color:#FFFFFF;\">\r\n						2\r\n					</li>\r\n					<li class=\"ks-switchable-trigger-internal580\" style=\"font-size:14px;background:#716564;text-align:center;color:#FFFFFF;\">\r\n						3\r\n					</li>\r\n					<li class=\"ks-switchable-trigger-internal580\" style=\"font-size:14px;background:#716564;text-align:center;color:#FFFFFF;\">\r\n						4\r\n					</li>\r\n					<li class=\"ks-switchable-trigger-internal580\" style=\"font-size:14px;background:#716564;text-align:center;color:#FFFFFF;\">\r\n						5\r\n					</li>\r\n					<li class=\"ks-switchable-trigger-internal580\" style=\"font-size:14px;background:#716564;text-align:center;color:#FFFFFF;\">\r\n						6\r\n					</li>\r\n				</ul>\r\n			</div>\r\n		</div>\r\n		<div id=\"mall-banner\" style=\"margin:0px;padding:0px;\">\r\n		</div>\r\n		<div id=\"J_DcTopRightWrap\" style=\"margin:0px;padding:0px;\">\r\n			<div id=\"J_DcTopRight\" class=\"J_DcAsyn tb-shop\" style=\"margin:0px;padding:0px;\">\r\n			</div>\r\n		</div>\r\n		<div id=\"description\" class=\"J_DetailSection tshop-psm tshop-psm-bdetaildes\" style=\"margin:0px;padding:0px;\">\r\n			<div class=\"content ke-post\" style=\"margin:10px 0px 0px;padding:0px;font-size:14px;font-family:tahoma, arial, 宋体, sans-serif;\">\r\n				<div style=\"margin:0px;padding:0px;\">\r\n					<a name=\"maijsoft_s1_145813_start\"></a>\r\n				</div>\r\n				<p>\r\n					<a target=\"_blank\" href=\"https://taoquan.taobao.com/coupon/unify_apply.htm?sellerId=1910146537&amp;activityId=04f6b0278d824691924bd57eaaa44e71\"><img alt=\"\" src=\"https://img.alicdn.com/imgextra/i1/1910146537/TB2w026aS_I8KJjy0FoXXaFnVXa_!!1910146537.jpg\" class=\"img-ks-lazyload\" /></a>\r\n				</p>\r\n				<div style=\"margin:0px;padding:0px;\">\r\n					<a name=\"maijsoft_s1_145813_end\"></a>\r\n				</div>\r\n				<p>\r\n					<img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i2/1910146537/TB2dpfvXxbxQeBjy1XdXXXVBFXa_!!1910146537.jpg\" class=\"img-ks-lazyload\" />\r\n				</p>\r\n				<p>\r\n					<img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i2/1910146537/TB2w7ZLsbBkpuFjy1zkXXbSpFXa_!!1910146537.jpg\" class=\"img-ks-lazyload\" /><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i2/1910146537/TB2GA0QsB0kpuFjSsppXXcGTXXa_!!1910146537.jpg\" class=\"img-ks-lazyload\" /><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i3/1910146537/TB24KI8sbXlpuFjSszfXXcSGXXa_!!1910146537.jpg\" class=\"img-ks-lazyload\" /><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i1/1910146537/TB2dFVbsB0kpuFjy1zdXXXuUVXa_!!1910146537.jpg\" class=\"img-ks-lazyload\" /><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i1/1910146537/TB2MD38sl0kpuFjSsziXXa.oVXa_!!1910146537.jpg\" class=\"img-ks-lazyload\" /><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i2/1910146537/TB28x4GsrVkpuFjSspcXXbSMVXa_!!1910146537.jpg\" class=\"img-ks-lazyload\" />\r\n				</p>\r\n				<p>\r\n					<img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i3/1910146537/TB2z2wsaVXXXXaJXpXXXXXXXXXX_!!1910146537.jpg\" class=\"img-ks-lazyload\" />\r\n				</p>\r\n				<div style=\"margin:0px;padding:0px;\">\r\n					<a name=\"hlg_list_5_17546621_start\"></a>\r\n				</div>\r\n				<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"margin:0px auto;padding:0px;border-collapse:separate;\" class=\"ke-zeroborder\">\r\n					<tbody>\r\n						<tr>\r\n							<td>\r\n								<div style=\"margin:0px;padding:0px;\">\r\n									<div style=\"margin:0px;padding:0px;\">\r\n										<img alt=\"自定义 20171025\" src=\"https://img.alicdn.com/imgextra/i1/1910146537/TB28Gn8m6uhSKJjSspdXXc11XXa_!!1910146537.jpg\" class=\"img-ks-lazyload\" />\r\n									</div>\r\n								</div>\r\n							</td>\r\n						</tr>\r\n					</tbody>\r\n				</table>\r\n				<div style=\"margin:0px;padding:0px;\">\r\n					<a name=\"hlg_list_5_17546621_end\"></a>\r\n				</div>\r\n				<div style=\"margin:0px;padding:0px;\">\r\n					<a name=\"hlg_list_6_17546631_start\"></a>\r\n				</div>\r\n				<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"margin:0px auto;padding:0px;border-collapse:separate;\" class=\"ke-zeroborder\">\r\n					<tbody>\r\n						<tr>\r\n							<td>\r\n								<div style=\"margin:0px;padding:0px;\">\r\n									<div style=\"margin:0px;padding:0px;\">\r\n										<img alt=\"自定义 20171025\" src=\"https://img.alicdn.com/imgextra/i2/1910146537/TB2GV53rgoQMeJjy0FoXXcShVXa_!!1910146537.jpg\" class=\"img-ks-lazyload\" />\r\n									</div>\r\n								</div>\r\n							</td>\r\n						</tr>\r\n					</tbody>\r\n				</table>\r\n				<div style=\"margin:0px;padding:0px;\">\r\n					<a name=\"hlg_list_6_17546631_end\"></a>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div id=\"J_DcBottomRightWrap\" style=\"margin:0px;padding:0px;\">\r\n			<div id=\"J_DcBottomRight\" class=\"J_DcAsyn tb-shop\" style=\"margin:0px;padding:0px;\">\r\n			</div>\r\n			<div id=\"J_ZebraPriceDesc\" class=\"j-mdv\" style=\"margin:0px;padding:0px;\">\r\n			</div>\r\n		</div>\r\n		<div id=\"J_Detail\" style=\"margin:0px;padding:0px;\">\r\n			<div id=\"J_Reviews\" class=\"J_DetailSection\" style=\"margin:0px;padding:0px;\">\r\n				<h4 class=\"hd\" style=\"font-weight:400;background-color:#FF0036;color:#FFFFFF;\">\r\n					累计评价\r\n				</h4>\r\n			</div>\r\n			<div id=\"J_SellerInfo\" class=\"J_DetailSection tb-sellerinfo\" style=\"margin:0px;padding:0px;\">\r\n				<h5 class=\"hd\" style=\"font-size:12px;font-weight:400;background-color:#FF0036;color:#FFFFFF;\">\r\n					店铺30天服务情况\r\n				</h5>\r\n			</div>\r\n			<div id=\"J_chaoshiService\" class=\"j-mdv J_DetailSection\" style=\"margin:0px;padding:0px;\">\r\n				<h4 class=\"hd\" style=\"font-weight:400;background-color:#FF0036;color:#FFFFFF;\">\r\n					售后服务\r\n				</h4>\r\n			</div>\r\n			<div id=\"official-remind\" class=\"j-mdv\" style=\"margin:20px 0px 0px;padding:10px;background-color:#FFFFE5;border:1px solid #FFCC7F;\">\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"col-sub\" style=\"margin:0px 0px 0px -1190px;padding:0px;background:0px 0px #FFFFFF;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;\">\r\n	<div class=\"j-mdv tm-detail-chaoshibanner\" style=\"margin:0px;padding:0px;\">\r\n		<div style=\"margin:0px 0px 10px;padding:0px;\">\r\n			<a href=\"https://pages.tmall.com/wow/chaoshi/act/miyou?spm=a312d.7832034.0.0.6bbc9edbVDoCjX&amp;pos=1&amp;acm=201505271.1003.2.2452353&amp;scm=1003.2.201505271.OTHER_1509048545563_2452353\" target=\"_blank\"><img src=\"https://img.alicdn.com/imgextra/i3/771510470/TB2kiHYdbglyKJjSZFuXXaE6FXa-771510470.jpg\" alt=\"\" /></a>\r\n		</div>\r\n		<div style=\"margin:0px 0px 10px;padding:0px;\">\r\n			<a href=\"https://content.tmall.com/wow/pegasus/subject/1/725677994/8599322?site=ALL&amp;pos=2&amp;channel=chaoshi&amp;acm=201505271.1003.2.2452353&amp;id=8599322&amp;scm=1003.2.201505271.OTHER_1511483250704_2452353&amp;gccpm=0.815.2.subject-chaoshi-2004.709074&amp;wh_channel=chaoshi4\" target=\"_blank\"><img src=\"https://img.alicdn.com/imgextra/i2/52660971/TB2D6RdrwoQMeJjy0FoXXcShVXa_!!52660971.jpg\" alt=\"\" /></a>\r\n		</div>\r\n		<div style=\"margin:0px 0px 10px;padding:0px;\">\r\n			<a href=\"https://pages.tmall.com/wow/chaoshi/act/jiunuanxaingrong?spm=a312d.7832034.0.0.3106884fxCrxi0&amp;pos=3&amp;acm=201505271.1003.2.2452353&amp;scm=1003.2.201505271.OTHER_1510582082862_2452353\" target=\"_blank\"><img src=\"https://img.alicdn.com/tfs/TB1aPAaXL2H8KJjy0FcXXaDlFXa-188-170.jpg\" alt=\"\" /></a>\r\n		</div>\r\n		<div>\r\n			<br />\r\n		</div>\r\n	</div>\r\n	<div class=\"tm-chaoshi-hot J_CSRecommend\" style=\"margin:33px 0px 0px;padding:0px;\">\r\n	</div>\r\n</div>', '58', '0', '292', '19.90', '0', '0.00', '0.00', '', '545', '0', '0', '1', '', '0', '2', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('165', '新农哥五香花生136g 坚果炒货小吃', '1522089611', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i1/725677994/TB2htJEmHVkpuFjSspcXXbSMVXa_!!725677994.jpg\" />', '161', '0', '293', '8.90', '0', '0.00', '0.00', '', '521', '0', '0', '1', '', '0', '1', '294', '', '1522089611', '1', '1522089611', '1522089611', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('166', '费列罗巧克力零食48粒 3*16条 休闲零食 香浓美味', '0', '0', '23', '1', '<p>\r\n	<img src=\"https://img.alicdn.com/imgextra/i2/725677994/TB2XBSkXr5K.eBjy0FfXXbApVXa_!!725677994.jpg\" />\r\n</p>\r\n<p>\r\n	<img src=\"https://img.alicdn.com/imgextra/i1/725677994/TB2LB13gsPRfKJjSZFOXXbKEVXa_!!725677994.jpg\" />\r\n</p>', '162', '0', '295', '30.00', '0', '0.00', '0.00', '', '580', '0', '0', '1', '', '0', '4', '296,297,298,299', '', '0', '0', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('167', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', '0', '0', '333', '1', '<img src=\"https://img.alicdn.com/imgextra/i1/725677994/TB2i3kzbvBNTKJjy0FdXXcPpVXa_!!725677994.jpg\" />', '161', '0', '300', '34.00', '0', '0.00', '0.00', '', '600', '0', '0', '1', '', '0', '0', '301', '', '0', '0', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('168', '费列罗榛果威化巧克力零食30粒 休闲零食香浓美味', '0', '0', '10', '1', '<div class=\"tm-chaoshi-nav nav-float\" style=\"margin:0px;padding:0px;background-color:#FFFFFF;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;\">\r\n	<div class=\"layout\" style=\"margin:0px auto;padding:0px;\">\r\n		<div id=\"nav-bar\" style=\"margin:0px;padding:0px;\">\r\n			<div class=\"nav-cont\" style=\"margin:0px;padding:0px;\">\r\n				<ul>\r\n					<li class=\"qc\">\r\n						<div class=\"col-main tm-clear clearfix\" style=\"margin:0px;padding:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;\">\r\n							<div id=\"mainwrap\" class=\"main-wrap\" style=\"margin:0px 0px 0px 200px;padding:0px;\">\r\n								<div id=\"description\" class=\"J_DetailSection tshop-psm tshop-psm-bdetaildes\" style=\"margin:0px;padding:0px;\">\r\n									<div class=\"content ke-post\" style=\"margin:10px 0px 0px;padding:0px;font-size:14px;font-family:tahoma, arial, 宋体, sans-serif;\">\r\n										<p>\r\n											<img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i3/725677994/TB2gluhXraI.eBjSszdXXaB6XXa_!!725677994.jpg\" class=\"img-ks-lazyload\" /><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i1/725677994/TB2ptqkXB9J.eBjy0FoXXXyvpXa_!!725677994.jpg\" class=\"img-ks-lazyload\" /><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i4/725677994/TB2sXGZXxaK.eBjSZFBXXagMXXa_!!725677994.jpg\" class=\"img-ks-lazyload\" /><img align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i4/725677994/TB23XaiXr1J.eBjSspnXXbUeXXa_!!725677994.jpg\" class=\"img-ks-lazyload\" />\r\n										</p>\r\n									</div>\r\n								</div>\r\n								<div id=\"J_DcBottomRightWrap\" style=\"margin:0px;padding:0px;\">\r\n									<div id=\"J_DcBottomRight\" class=\"J_DcAsyn tb-shop\" style=\"margin:0px;padding:0px;\">\r\n									</div>\r\n									<div id=\"J_ZebraPriceDesc\" class=\"j-mdv\" style=\"margin:0px;padding:0px;\">\r\n										<img width=\"790\" src=\"https://img.alicdn.com/tfs/TB1H9BARpXXXXc1XpXXXXXXXXXX-1420-274.png\" />\r\n									</div>\r\n								</div>\r\n								<div id=\"J_Detail\" style=\"margin:0px;padding:0px;\">\r\n									<div id=\"J_Reviews\" class=\"J_DetailSection\" style=\"margin:0px;padding:0px;\">\r\n										<h4 class=\"hd\" style=\"font-weight:400;background-color:#FF0036;color:#FFFFFF;\">\r\n											累计评价&nbsp;<span class=\"J_ReviewsCount\">9932</span>\r\n										</h4>\r\n										<div class=\"tm-rate\" style=\"margin:0px;padding:0px;\">\r\n											<div class=\"rate-header rate-header-tags\" style=\"margin:0px;padding:10px 0px;border:1px solid #C8C8C8;\">\r\n												<div class=\"rate-score\" style=\"margin:0px;padding:0px 20px;vertical-align:top;text-align:center;\">\r\n													<h4 style=\"font-weight:100;\">\r\n														与描述相符\r\n													</h4>\r\n<span style=\"color:#FF6600;font-family:arial;font-size:32px;line-height:32px;\">4.8</span>\r\n													<p style=\"text-align:left;\">\r\n														<span class=\"score-value-no score-value-4d8\" style=\"background:url(&quot;\"><span style=\"background:url(&quot;\"></span></span>\r\n													</p>\r\n												</div>\r\n												<div class=\"rate-tag-box\" style=\"margin:0px;padding:0px;vertical-align:top;\">\r\n													<div class=\"rate-tag-label\" style=\"margin:4px 0px 0px;padding:0px 12px 0px 25px;vertical-align:top;color:#CCCCCC;font-size:11px;background:url(&quot;\">\r\n														<span>大家都写到</span>\r\n													</div>\r\n													<div class=\"rate-tag-list\" style=\"margin:0px;padding:0px;vertical-align:top;\">\r\n														<div class=\"rate-tag-inner\" style=\"margin:0px;padding:0px;\">\r\n															<span class=\"tag-posi\"><a id=\"ratetag807_420a\" href=\"https://chaoshi.detail.tmall.com/item.htm?spm=a3204.7933263.0.0.1d2958ffOFfu0J&amp;id=16106006756&amp;rewcatid=50504021#\">物流快(8)<s></s></a></span><span class=\"tag-posi\"><a id=\"ratetag807_620a\" href=\"https://chaoshi.detail.tmall.com/item.htm?spm=a3204.7933263.0.0.1d2958ffOFfu0J&amp;id=16106006756&amp;rewcatid=50504021#\">质量好(4)<s></s></a></span><span class=\"tag-posi\"><a id=\"ratetag807_520a\" href=\"https://chaoshi.detail.tmall.com/item.htm?spm=a3204.7933263.0.0.1d2958ffOFfu0J&amp;id=16106006756&amp;rewcatid=50504021#\">便宜(3)<s></s></a></span><span class=\"tag-posi\"><a id=\"ratetag807_10420a\" href=\"https://chaoshi.detail.tmall.com/item.htm?spm=a3204.7933263.0.0.1d2958ffOFfu0J&amp;id=16106006756&amp;rewcatid=50504021#\">发货快(3)<s></s></a></span><span class=\"tag-posi\"><a id=\"ratetag807_637a\" href=\"https://chaoshi.detail.tmall.com/item.htm?spm=a3204.7933263.0.0.1d2958ffOFfu0J&amp;id=16106006756&amp;rewcatid=50504021#\">保质期(3)<s></s></a></span>\r\n														</div>\r\n													</div>\r\n<span class=\"rate-tag-toggle\" style=\"vertical-align:top;background:url(&quot;\"></span>\r\n												</div>\r\n											</div>\r\n											<div class=\"rate-compose\" style=\"margin:0px;padding:0px;\">\r\n											</div>\r\n											<div class=\"rate-charts\" style=\"margin:0px;padding:0px;background:#F4F4F4;\">\r\n											</div>\r\n											<div class=\"rate-toolbar\" style=\"margin:0px;padding:5px 10px;background:#EFEFEF;border:1px solid #C8C8C8;text-align:right;\">\r\n												<span class=\"rate-filter\">全部追评 (15)图片 (136)</span><span class=\"tm-toolbar-lft\"><span class=\"tm-rate-addin\"></span>有内容\r\n												<div class=\"rate-sort \" style=\"margin:0px;padding:0px;\">\r\n													<div class=\"tm-selectbtn tm-rate-sort\" style=\"margin:0px;padding:0px 5px;text-align:center;\">\r\n														<span class=\"tm-current\" style=\"background:url(&quot;line-height:20px;\">按默认</span>\r\n													</div>\r\n												</div>\r\n</span>\r\n											</div>\r\n											<div class=\"rate-grid\" style=\"margin:0px;padding:0px;\">\r\n												<table style=\"margin:0px;padding:0px;width:790px;\">\r\n													<tbody>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		家中常备巧克力，快递给力，满意\r\n																	</div>\r\n																	<div class=\"tm-m-photos\" style=\"margin:0px;padding:0px;\">\r\n																		<ul class=\"tm-m-photos-thumb\">\r\n																			<li>\r\n																				<img src=\"https://img.alicdn.com/bao/uploaded/i1/0/TB29YYYXSfD8KJjSszhXXbIJFXa_!!0-rate.jpg_40x40.jpg\" style=\"width:40px;height:40px;\" /><b class=\"tm-photos-arrow\"></b>\r\n																			</li>\r\n																		</ul>\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.30\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	n***n（匿名）\r\n																</div>\r\n																<div class=\"rate-user-grade\" style=\"margin:0px;padding:0px;\">\r\n																	<p class=\"gold-user\" style=\"color:#C09459;\">\r\n																		超级会员\r\n																	</p>\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		九月份生产的，挺新鲜的。\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.31\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	老***0（匿名）\r\n																</div>\r\n																<div class=\"rate-user-grade\" style=\"margin:0px;padding:0px;\">\r\n																	<p class=\"gold-user\" style=\"color:#C09459;\">\r\n																		超级会员\r\n																	</p>\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		很快，不错，跟超市价格一样\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.29\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	武***7（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		巧克力很好吃，日期是最近的新日期，店家很用心包装裹了厚厚的泡沫塑料来保护盒子。感谢老板。祝你生意兴隆。\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.25\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	t***3（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		很不错哦，买给朋友的小礼物\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	11.02\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	1***c（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		口感不错 发货速度快\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.30\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	小***怀（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		包裹包装的很好 东西送人的 量也比较足 很好\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.25\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	高***1（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		送女朋友的。看着很不错的\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.26\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	赵***4（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		送人不知道礼盒坏没有\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	11.01\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	j***v（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		今天去家乐福超市看到了相同的巧克力，没有特价和任何活动卖105，天猫卖115还不参加满减活动，原来价格比超市贵那么多啊～真是长经验了\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.16\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	生***彩（匿名）\r\n																</div>\r\n																<div class=\"rate-user-grade\" style=\"margin:0px;padding:0px;\">\r\n																	<p class=\"gold-user\" style=\"color:#C09459;\">\r\n																		超级会员\r\n																	</p>\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		口味不错，送给我爱的她！\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.26\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	脱***光（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		中秋节当天，上午9点多才下单，下午4点就收到了，买了很多东西正好赶上能送人，不耽误事，太好了。\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.17\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	m***6（匿名）\r\n																</div>\r\n																<div class=\"rate-user-grade\" style=\"margin:0px;padding:0px;\">\r\n																	<p class=\"gold-user\" style=\"color:#C09459;\">\r\n																		超级会员\r\n																	</p>\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		天猫超市太方便啦\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.21\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	c***y（匿名）\r\n																</div>\r\n																<div class=\"rate-user-grade\" style=\"margin:0px;padding:0px;\">\r\n																	<p class=\"gold-user\" style=\"color:#C09459;\">\r\n																		超级会员\r\n																	</p>\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		天猫超市几乎每个月都必须买点东西，快捷方便，适合现在的生活，超市没有啥竞争力了，感谢天猫给我们带来的便捷。东西都很好\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.09\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	s***公（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		很好……一会儿吃没了\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.16\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	t***6（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		不错，很好\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.16\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	j***9（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		日期比较新鲜\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.15\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	高***9（匿名）\r\n																</div>\r\n																<div class=\"rate-user-grade\" style=\"margin:0px;padding:0px;\">\r\n																	<p class=\"gold-user\" style=\"color:#C09459;\">\r\n																		超级会员\r\n																	</p>\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		给别人买的，具体不详，应该还不错\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.11\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	a***f（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		还是那个味道！\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.25\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	调***苗（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n														<tr>\r\n															<td class=\"tm-col-master\">\r\n																<div class=\"tm-rate-content\" style=\"margin:0px;padding:0px;color:#333333;\">\r\n																	<div class=\"tm-rate-fulltxt\" style=\"margin:0px;padding:0px;\">\r\n																		味道很好！\r\n																	</div>\r\n																</div>\r\n																<div class=\"tm-rate-date\" style=\"margin:0px;padding:0px;color:#CCCCCC;\">\r\n																	10.10\r\n																</div>\r\n															</td>\r\n															<td class=\"col-meta\" style=\"color:#999999;\">\r\n																<div class=\"rate-sku\" style=\"margin:0px 0px 3px;padding:0px;\">\r\n																</div>\r\n																<div class=\"rate-user-profile\" style=\"margin:0px;padding:0px;\">\r\n																</div>\r\n															</td>\r\n															<td class=\"col-author\">\r\n																<div class=\"rate-user-info\" style=\"margin:0px;padding:0px;\">\r\n																	亲***9（匿名）\r\n																</div>\r\n															</td>\r\n														</tr>\r\n													</tbody>\r\n												</table>\r\n											</div>\r\n											<div class=\"rate-page\" style=\"margin:0px;padding:0px;\">\r\n												<div class=\"rate-paginator\" style=\"margin:20px 30px 0px 0px;padding:20px 0px 10px;text-align:right;background:url(&quot;\">\r\n													<span class=\"rate-page-prev\" style=\"vertical-align:top;line-height:27px;color:#999999;font-size:14px;\">&lt;&lt;上一页</span><span style=\"vertical-align:top;line-height:27px;color:#999999;font-size:14px;\">1</span><a href=\"https://chaoshi.detail.tmall.com/item.htm?page=2\">2</a><a href=\"https://chaoshi.detail.tmall.com/item.htm?page=3\">3</a><span class=\"rate-page-break\" style=\"vertical-align:top;line-height:20px;color:#999999;font-size:14px;\">...</span><a href=\"https://chaoshi.detail.tmall.com/item.htm?page=2\">下一页&gt;&gt;</a>\r\n												</div>\r\n											</div>\r\n											<div class=\"rate-tryreport\" style=\"margin:0px;padding:0px;\">\r\n												<div class=\"tm-trygrid\" style=\"margin:0px;padding:0px;\">\r\n												</div>\r\n												<div class=\"tm-trypage\" style=\"margin:0px;padding:0px;\">\r\n												</div>\r\n											</div>\r\n										</div>\r\n									</div>\r\n									<div id=\"J_SellerInfo\" class=\"J_DetailSection tb-sellerinfo\" style=\"margin:0px;padding:0px;\">\r\n										<h5 class=\"hd\" style=\"font-size:12px;font-weight:400;background-color:#FF0036;color:#FFFFFF;\">\r\n											店铺30天服务情况\r\n										</h5>\r\n									</div>\r\n									<div id=\"J_chaoshiService\" class=\"j-mdv J_DetailSection\" style=\"margin:0px;padding:0px;\">\r\n										<h4 class=\"hd\" style=\"font-weight:400;background-color:#FF0036;color:#FFFFFF;\">\r\n											售后服务\r\n										</h4>\r\n									</div>\r\n									<div id=\"official-remind\" class=\"j-mdv\" style=\"margin:20px 0px 0px;padding:10px;background-color:#FFFFE5;border:1px solid #FFCC7F;\">\r\n									</div>\r\n								</div>\r\n							</div>\r\n						</div>\r\n						<div class=\"col-sub\" style=\"margin:0px 0px 0px -1190px;padding:0px;background:0px 0px #FFFFFF;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;\">\r\n							<div class=\"j-mdv tm-detail-chaoshibanner\" style=\"margin:0px;padding:0px;\">\r\n								<div style=\"margin:0px 0px 10px;padding:0px;\">\r\n									<a href=\"https://pages.tmall.com/wow/chaoshi/act/miyou?spm=a312d.7832034.0.0.6bbc9edbVDoCjX&amp;pos=1&amp;acm=201505271.1003.2.2452353&amp;scm=1003.2.201505271.OTHER_1509048545563_2452353\" target=\"_blank\"><img src=\"https://img.alicdn.com/imgextra/i3/771510470/TB2kiHYdbglyKJjSZFuXXaE6FXa-771510470.jpg\" alt=\"\" /></a>\r\n								</div>\r\n								<div style=\"margin:0px 0px 10px;padding:0px;\">\r\n									<a href=\"https://content.tmall.com/wow/pegasus/subject/1/725677994/8599322?site=ALL&amp;pos=2&amp;channel=chaoshi&amp;acm=201505271.1003.2.2452353&amp;id=8599322&amp;scm=1003.2.201505271.OTHER_1511483250704_2452353&amp;gccpm=0.815.2.subject-chaoshi-2004.709074&amp;wh_channel=chaoshi4\" target=\"_blank\"><img src=\"https://img.alicdn.com/imgextra/i2/52660971/TB2D6RdrwoQMeJjy0FoXXcShVXa_!!52660971.jpg\" alt=\"\" /></a>\r\n								</div>\r\n								<div style=\"margin:0px 0px 10px;padding:0px;\">\r\n									<a href=\"https://pages.tmall.com/wow/chaoshi/act/jiunuanxaingrong?spm=a312d.7832034.0.0.3106884fxCrxi0&amp;pos=3&amp;acm=201505271.1003.2.2452353&amp;scm=1003.2.201505271.OTHER_1510582082862_2452353\" target=\"_blank\"><img src=\"https://img.alicdn.com/tfs/TB1aPAaXL2H8KJjy0FcXXaDlFXa-188-170.jpg\" alt=\"\" /></a>\r\n								</div>\r\n								<div>\r\n									<br />\r\n								</div>\r\n							</div>\r\n							<div class=\"tm-chaoshi-hot J_CSRecommend\" style=\"margin:33px 0px 0px;padding:0px;\">\r\n							</div>\r\n						</div>\r\n<br />\r\n					</li>\r\n				</ul>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>', '162', '0', '302', '99.00', '0', '0.00', '0.00', '', '957', '0', '0', '1', '', '0', '0', '303', '', '0', '0', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('169', '良品铺子猪肉脯100g芝麻味自然片猪肉干零食小吃特产休闲食品', '0', '0', '77', '1', '<img src=\"https://img.alicdn.com/imgextra/i4/725677994/TB2zoRnXwL8F1JjSspjXXbZgpXa_!!725677994.jpg\" /><br />\r\n<p>\r\n	<img src=\"https://img.alicdn.com/imgextra/i1/725677994/TB2Zfb9XC69F1JjSZFOXXXK.VXa_!!725677994.jpg\" />\r\n</p>', '161', '0', '304', '77.00', '0', '0.00', '0.00', '', '635', '0', '0', '1', '', '0', '1', '305,306', '', '0', '0', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('170', '【低至5488元】Apple/苹果iPhone 8 Plus ', '1522089719', '0', '5675', '1', '<img src=\"https://img.alicdn.com/imgextra/i1/2616970884/TB2giEVgU3IL1JjSZFMXXajrFXa-2616970884.jpg\" />', '110', '0', '307', '5488.00', '0', '0.00', '0.00', '176,171', '420', '0', '0', '1', '164,169', '0', '0', '309', '2G,3G,4G,6G,16G,32G,64G', '1522089719', '1', '1522089719', '1522089719', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('171', '华为honor/荣耀 畅玩7X全网通全面屏官方手机', '0', '0', '5677', '1', '<img src=\"https://img.alicdn.com/imgextra/i4/1114511827/TB2sogiXTnI8KJjSszbXXb4KFXa_!!1114511827.jpg\" />', '110', '0', '310', '5676.00', '0', '0.00', '0.00', '', '391', '0', '0', '1', '', '0', '0', '311', '2G,4G,16G,32G,64G', '0', '0', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('172', 'Xiaomi/小米 红米手机4A 超长待机双卡智能手机', '0', '0', '343', '1', 'Xiaomi/小米 红米手机4A 超长待机双卡智能手机', '110', '0', '313', '34.00', '0', '0.00', '0.00', '175,171,182,195,208', '441', '0', '0', '1', '164,169,180,194,203', '0', '0', '312', '2G,3G,4G,6G,16G', '0', '0', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('173', 'Huawei/华为 Mate 10 4G+64G年度旗舰手机', '0', '0', '345', '1', '<img src=\"https://gdp.alicdn.com/imgextra/i2/2838892713/TB2wSW3hO0TMKJjSZFNXXa_1FXa_!!2838892713.jpg\" alt=\"\" class=\"img-ks-lazyload\" border=\"0\" />', '110', '0', '314', '345.00', '0', '0.00', '0.00', '', '457', '0', '0', '1', '', '0', '0', '315', '4G,16G,32G,64G', '0', '0', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('174', 'OPPO R11S全面屏拍照4G手机oppor11s', '0', '0', '56', '1', '<img alt=\"\" src=\"https://img.alicdn.com/imgextra/i2/901409638/TB2yUIiaDnI8KJjSszbXXb4KFXa_!!901409638.jpg\" class=\"img-ks-lazyload\" />', '110', '0', '316', '345.00', '0', '0.00', '0.00', '175,171', '539', '0', '0', '1', '164,169', '0', '0', '317,318', '2G,16G,32G,64G', '0', '0', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('175', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ', '0', '0', '345', '1', '<h1>\r\n	<img src=\"https://img.alicdn.com/imgextra/i1/454291526/TB2TMxQXx685uJjSZFHXXc49pXa-454291526.jpg\" class=\"img-ks-lazyload\" />\r\n</h1>', '129', '0', '320', '34.00', '0', '0.00', '0.00', '', '246', '0', '0', '1', '', '0', '0', '321,322', '红色,蓝色,x,xl,xxl', '0', '0', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('176', '冬季新款中长款纯色加厚棉袄棉服保暖外套 ', '0', '0', '1232', '1', '<img alt=\"217309501_G01.jpg\" src=\"https://img.alicdn.com/imgextra/i1/305358018/TB2fHPhXtLO8KJjSZFxXXaGEVXa-305358018.jpg\" class=\"img-ks-lazyload\" />', '129', '0', '323', '21.00', '0', '0.00', '0.00', '85', '283', '0', '0', '1', '84', '0', '0', '324', '红色,白色,xl,xxl', '0', '0', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('177', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', '0', '0', '345', '1', '<h1>\r\n	<br />\r\n</h1>\r\n<h1>\r\n	<table width=\"876\" class=\"ke-zeroborder\" style=\"border-collapse:collapse;font-size:12.0px;font-family:微软雅黑;text-align:center;color:#ff0000;width:790.0px;font-weight:bold;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n		<tbody>\r\n			<tr>\r\n				<td width=\"79\" style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"font-size:14.0px;\"><strong>套餐</strong></span></span> \r\n				</td>\r\n				<td width=\"92\" style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"font-size:14.0px;\">处理器</span></span> \r\n				</td>\r\n				<td width=\"54\" style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"font-size:14.0px;\"><strong>内存</strong></span></span> \r\n				</td>\r\n				<td width=\"97\" style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"font-size:14.0px;\"><strong>硬盘</strong></span></span> \r\n				</td>\r\n				<td width=\"167\" style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"font-size:14.0px;\"><strong>显卡</strong></span></span> \r\n				</td>\r\n				<td width=\"108\" style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"font-size:14.0px;\">分辨率</span> \r\n				</td>\r\n				<td width=\"90\" style=\"color:#ff0000;\" bgcolor=\"#ffffff\">\r\n					<span style=\"font-size:14.0px;\">银色/金色<br />\r\n新品价</span> \r\n				</td>\r\n				<td width=\"102\" bgcolor=\"#ffffff\">\r\n					<p>\r\n						<span style=\"color:#ff0000;\"><span style=\"font-size:14.0px;\">粉色<br />\r\n<span style=\"color:#ff0000;font-family:微软雅黑;font-weight:bold;line-height:28.0px;\">新品</span>价</span></span>\r\n					</p>\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">官方标配</span></span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">i5-7200U</span></span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">4G</span></span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">500G机械</span></span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"> \r\n					<div>\r\n						&nbsp;GeForce&nbsp;940MX\r\n					</div>\r\n</span></span></span><span style=\"color:#000000;\"><strong><span style=\"font-size:14.0px;\"><span style=\"font-size:16.0px;\">2G独显</span></span></strong></span> \r\n				</td>\r\n				<td style=\"color:#333333;font-weight:normal;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><strong>14英寸<br />\r\n1920*1080<br />\r\n</strong></span></span></span> \r\n				</td>\r\n				<td bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">￥4799</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;font-weight:normal;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><strong>￥5099</strong></span></span> \r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">标准套餐</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">i5-7200U</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">4G</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">128G固态</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span><span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"> \r\n					<div>\r\n						&nbsp;GeForce&nbsp;940MX\r\n					</div>\r\n</span></span></span><span style=\"color:#000000;\"><strong><span style=\"font-size:14.0px;\"><span style=\"font-size:16.0px;\">2G独显</span></span></strong></span> \r\n				</td>\r\n				<td style=\"color:#333333;font-weight:normal;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><strong><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">14英寸</span><br />\r\n<span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">1920*1080</span></strong><strong><br />\r\n</strong></span></span> \r\n				</td>\r\n				<td bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">￥5099</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;font-weight:normal;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><strong>￥5399</strong></span></span> \r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#ff0000;\"><span style=\"font-size:14.0px;\"><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">套餐一</span><br />\r\n</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#ff0000;\"><span style=\"font-size:14.0px;\">i5-7200U</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#ff0000;\"><span style=\"font-size:14.0px;\">4G</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#ff0000;\"><span style=\"font-size:14.0px;\">256G固态</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#ff0000;\"><span style=\"font-size:14.0px;\"><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">GeForce&nbsp;940MX</span><br />\r\n<span style=\"font-size:16.0px;\">2G独显</span></span></span> \r\n				</td>\r\n				<td style=\"color:#333333;font-weight:normal;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#ff0000;\"><span style=\"font-size:14.0px;\"><strong>14英寸<br />\r\n1920*1080<br />\r\n</strong></span></span> \r\n				</td>\r\n				<td style=\"color:#ff0000;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#ff0000;\"><span style=\"font-size:14.0px;\"><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">特惠</span><br />\r\n<span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">￥5349</span><br />\r\n</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;font-weight:normal;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#ff0000;\"><span style=\"font-size:14.0px;\"><strong><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">特惠</span><br />\r\n<span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">￥5649</span></strong></span></span> \r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">套餐二</span><br />\r\n</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">i5-7200U</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">4G</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<p style=\"color:#000000;\">\r\n						<span style=\"font-size:14.0px;\"><span style=\"color:#000000;font-family:微软雅黑;font-weight:bold;line-height:28.0px;\">128G固态</span></span>\r\n					</p>\r\n					<p style=\"color:#000000;\">\r\n						<span style=\"font-size:14.0px;\"><span style=\"color:#000000;font-family:微软雅黑;font-weight:bold;line-height:28.0px;\">+</span>500G机械<br />\r\n</span>\r\n					</p>\r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">GeForce&nbsp;940MX</span><br />\r\n<span style=\"font-size:16.0px;\">2G独显</span></span></span> \r\n				</td>\r\n				<td style=\"color:#333333;font-weight:normal;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><strong>14英寸<br />\r\n1920*1080<br />\r\n</strong></span></span> \r\n				</td>\r\n				<td style=\"color:#ff0000;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><span style=\"font-weight:bold;line-height:20.0px;\">￥5349</span><br />\r\n</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">￥5649</span></span> \r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">套餐三</span><br />\r\n</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">i5-7200U</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">8G</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">256G固态</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">GeForce&nbsp;940MX</span><br />\r\n<span style=\"font-size:16.0px;\">2G独显</span></span></span> \r\n				</td>\r\n				<td style=\"color:#333333;font-weight:normal;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><strong>14英寸<br />\r\n1920*1080<br />\r\n</strong></span></span> \r\n				</td>\r\n				<td style=\"color:#ff0000;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">￥5549</span></span> \r\n				</td>\r\n				<td style=\"color:#0000ff;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">￥5849</span></span> \r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#0000ff;\"><span style=\"font-size:14.0px;\"><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">套餐四</span><br />\r\n</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#0000ff;\"><span style=\"font-size:14.0px;\">i5-7200U</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#0000ff;\"><span style=\"font-size:14.0px;\">8G</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<p style=\"color:#0000ff;\">\r\n						<span style=\"font-size:14.0px;\"><span style=\"color:#0000ff;font-family:微软雅黑;font-weight:bold;line-height:28.0px;\">128G固态</span></span>\r\n					</p>\r\n					<p style=\"color:#0000ff;\">\r\n						<span style=\"font-size:14.0px;\"><span style=\"color:#0000ff;font-family:微软雅黑;font-weight:bold;line-height:28.0px;\">+</span>500G机械<br />\r\n</span>\r\n					</p>\r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#0000ff;\"><span style=\"font-size:14.0px;\"><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">GeForce&nbsp;940MX</span><br />\r\n<span style=\"font-size:16.0px;\">2G独显</span></span></span> \r\n				</td>\r\n				<td style=\"color:#333333;font-weight:normal;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#0000ff;\"><span style=\"font-size:14.0px;\"><strong>14英寸<br />\r\n1920*1080<br />\r\n</strong></span></span> \r\n				</td>\r\n				<td style=\"color:#ff0000;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#0000ff;\"><span style=\"font-size:14.0px;\">玩家推荐</span><span style=\"font-size:14.0px;\"><span style=\"font-weight:bold;line-height:20.0px;\"><br />\r\n￥5549</span></span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#0000ff;\"><span style=\"font-size:14.0px;\">玩家推荐<br />\r\n￥5849</span></span> \r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#0000ff;\"><span style=\"font-size:14.0px;\"><span style=\"color:#000000;font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">套餐五</span><br />\r\n</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">i5-7200U</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">8G</span></span> \r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<p style=\"font-size:14.0px;\">\r\n						<span style=\"color:#333333;font-family:微软雅黑;font-weight:bold;line-height:28.0px;\">240G固态</span>\r\n					</p>\r\n					<p style=\"font-size:14.0px;\">\r\n						<span style=\"color:#333333;font-family:微软雅黑;font-weight:bold;line-height:28.0px;\">+</span>500G机械\r\n					</p>\r\n				</td>\r\n				<td style=\"color:#333333;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><span style=\"font-family:微软雅黑;font-weight:bold;line-height:20.0px;\">GeForce&nbsp;940MX</span><br />\r\n<span style=\"font-size:16.0px;\">2G独显</span></span></span> \r\n				</td>\r\n				<td style=\"color:#333333;font-weight:normal;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\"><strong>14英寸<br />\r\n1920*1080<br />\r\n</strong></span></span> \r\n				</td>\r\n				<td style=\"color:#ff0000;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">￥5749</span></span> \r\n				</td>\r\n				<td style=\"color:#0000ff;\" bgcolor=\"#ffffff\">\r\n					<span style=\"color:#000000;\"><span style=\"font-size:14.0px;\">￥6049</span></span> \r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td style=\"color:#333333;text-align:left;\" bgcolor=\"#ffffff\" colspan=\"8\">\r\n					<ul style=\"color:#ff0000;\">\r\n						<li>\r\n							注：1.（升级内存/硬盘为买家个人定制需求，升级后可能与原标识配置不一样）~~~~~【详情请咨询客服】<br />\r\n2.网页链接默认为官方标配，根据买家购买配置不同，实际发货以套餐为准，敬请谅解！\r\n						</li>\r\n					</ul>\r\n				</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</h1>\r\n<h1>\r\n	<br />\r\n</h1>\r\n<h1>\r\n	<img align=\"absmiddle\" class=\"img-ks-lazyload\" src=\"https://img.alicdn.com/imgextra/i2/133668489/TB2Xn2Ybyb_F1JjSZFzXXc6KXXa_!!133668489.jpg\" />\r\n</h1>', '160', '0', '325', '34.00', '0', '0.00', '0.00', '', '776', '0', '0', '1', '', '0', '0', '', '黑,白,金,官方标配,套餐1,套餐2', '0', '0', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('178', 'OPPO耳机原装正品全球限量版', '1509832095', '0', '100', '1', '567', '158', '0', '326', '39.90', '0', '0.00', '0.00', '', '619', '0', '0', '1', '', '0', '0', '', '', '1509832095', '1', '1523618826', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('179', 'HP/惠普 暗影精灵 光影精灵3代游戏本', '1521765481', '0', '657', '1', '<img align=\"absmiddle\" class=\"img-ks-lazyload\" src=\"https://img.alicdn.com/imgextra/i4/2736964691/TB2PLy_tmBjpuFjSsplXXa5MVXa_!!2736964691.jpg\" />', '156', '0', '327', '5399.00', '0', '0.00', '0.00', '', '1484', '0', '0', '1', '', '0', '0', '', '黑,白,官方标配,套餐1,1g,2g', '1521765481', '1', '1521765481', '1521765481', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('180', 'ZARA 男装 黑色热封短版连帽夹克外套 棉衣01966330800', '1509907402', '0', '122', '1', '<img src=\"https://img.alicdn.com/imgextra/i2/2228361831/TB2wBjGboF7MKJjSZFLXXcMBVXa_!!2228361831.jpg\" />', '118', '0', '329', '34.00', '0', '0.00', '0.00', '', '417', '0', '0', '1', '', '0', '0', '', '', '1509907402', '1', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('181', 'ZARA 新品 男装 细针美丽诺针织衫 00693300500', '1509907480', '0', '23', '1', '<img src=\"https://img.alicdn.com/imgextra/i2/2228361831/TB2SZHaqlUSMeJjy1zkXXaWmpXa_!!2228361831.jpg\" />', '118', '0', '330', '223.00', '0', '0.00', '0.00', '', '323', '0', '0', '1', '', '0', '1', '', '', '1509907480', '1', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('182', 'ZARA 男装 绒面质感裤子 06706310707', '1509907548', '0', '123', '1', '<img src=\"https://img.alicdn.com/imgextra/i3/2228361831/TB2Iy1_XPqhSKJjSspnXXc79XXa_!!2228361831.jpg\" />', '118', '0', '331', '233.00', '0', '0.00', '0.00', '', '432', '0', '0', '1', '', '0', '0', '', '', '1509907548', '1', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('183', 'PUMA彪马男鞋女鞋2017秋季SUEDE', '1509907754', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i3/133227658/TB2BHApdbVkpuFjSspcXXbSMVXa_!!133227658.gif\" />', '118', '0', '332', '234.00', '0', '0.00', '0.00', '', '374', '0', '0', '1', '', '0', '0', '', '', '1509907754', '1', '1523618788', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('184', '阿迪达斯男裤2017冬季小脚运动裤保暖', '1509908052', '0', '123', '1', '<img src=\"https://img.alicdn.com/imgextra/i3/133227658/TB250MNmbwTMeJjSszfXXXbtFXa_!!133227658.jpg\" /><img src=\"https://img.alicdn.com/imgextra/i3/133227658/TB250MNmbwTMeJjSszfXXXbtFXa_!!133227658.jpg\" /><img src=\"https://img.alicdn.com/imgextra/i1/133227658/TB2vgBrmrsTMeJjSszhXXcGCFXa_!!133227658.jpg\" />', '163', '0', '333', '123.00', '0', '0.00', '0.00', '', '372', '0', '0', '1', '', '0', '0', '', '蓝色,白色,x,xl,xxl', '1509908052', '1', '1523618799', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('185', '阿迪达斯长裤男 2017秋季新款运动裤针织', '1509908153', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i2/1993730769/TB2R2ZaXz2lJKJjSszcXXaopVXa_!!1993730769.gif\" />', '163', '0', '334', '234.00', '0', '0.00', '0.00', '', '1027', '0', '0', '1', '', '0', '0', '335,336', '红色,蓝色,x,xl', '1509908153', '1', '1523618778', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('186', '正版书籍包邮 龙应台人生三书', '1509909138', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i4/750751837/TB21C._krtlpuFjSspoXXbcDpXa_!!750751837.jpg\" />', '88', '0', '338', '234.00', '0', '0.00', '0.00', '', '252', '0', '0', '1', '', '0', '0', '339', '', '1509909138', '1', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('187', '正版现货 白夜行(精装典藏版)东野圭吾小说集', '1509909317', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i4/1049653664/TB2CpM4kXXXXXbjXpXXXXXXXXXX_!!1049653664.jpg\" />', '88', '0', '341', '234.00', '0', '0.00', '0.00', '', '261', '0', '0', '1', '', '0', '0', '', '', '1509909317', '1', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('188', '国家图书奖朱自清散文集徐志摩经典大全集', '1509909415', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i1/2374668160/TB2dsI4lr_0UKFjy1XaXXbKfXXa_!!2374668160.jpg\" />', '88', '0', '343', '234.00', '0', '0.00', '0.00', '', '303', '0', '0', '1', '', '0', '0', '', '', '1509909415', '1', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('189', '罗辑思维官方 今天故事书', '1509909506', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i2/2760223904/TB2pUYZbZtnpuFjSZFKXXalFFXa-2760223904.png\" />', '88', '0', '344', '234.00', '0', '0.00', '0.00', '', '298', '0', '0', '1', '', '0', '0', '', '', '1509909506', '1', '1523618734', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('190', '【亚马逊图书】王小波文集：黄金时代+青铜时代+', '1509909593', '0', '324', '1', '<img src=\"https://img.alicdn.com/bao/uploaded/TB1NZwQorsTMeJjSszhXXcGCFXa_!!0-item_pic.jpg_250x250.jpg\" />', '88', '0', '345', '34.00', '0', '0.00', '0.00', '', '285', '0', '0', '1', '', '0', '0', '', '', '1509909593', '1', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('191', '布鲁克林有棵树正版包邮(美)史密斯著', '1509909668', '0', '123', '1', '<span style=\"color:#666666;font-family:tahoma, arial, 宋体, sans-serif;background-color:#FFFFFF;\">第一章 宁静这个词用于纽约布鲁克林恰如其分。尤其是在1912年的夏天。沉静这个词大概更好些，只是对布鲁克林的威廉斯堡不大合适。大草原的可爱，雪兰多的悦耳，用于布鲁克林都不合适。只能用宁静这个词，特别是夏日的一个星期六下午。 下午的斜阳照在弗兰西·诺兰家爬满苔藓的院子里，把破旧的木篱笆晒得暖暖的。看着斜射下来的一缕缕阳光，弗兰西心头涌出一种美好的感觉来。这样的感觉，她回忆起一首诗歌时也有过。这诗她在学校里背诵过，是这样的： 这里是原始森林 松树和铁杉，低语阵阵 苔藓如须，翠绿满身 黄昏中伫立，依稀朦胧 如一个个德鲁伊老僧 弗兰西院子里的树既不是松树，也不是铁杉。树上的绿色枝条从树干向四周发散，枝条上长满了尖尖的叶子，整棵树看起来如同无数撑开的绿伞。有人称之为天堂树。不管它的种子落到什么地方，都会长出一棵树来，向着天空，努力生长。这树长在四周围满木篱的空场子里，或是从无人留意的垃圾堆里钻出来；它也是唯一能在水泥地里长出来的树。它长得很茂盛，而且只在居民区长。 星期天下午，你去散散步，走到一个不错的居民区，挺高档的居民区。你会从通往人家院子的铁门中看见这样一棵小树，这时候你就知道，布鲁克林这一带会变成居民区了。树懂。树会打前站。到了后来，渐渐会有些贫穷的外国人跑过来，把破旧的褐砂石房子修理成平房。他们把羽毛褥垫从窗户里推出来晒。天堂树长得郁郁葱葱。这种树就这习性。它喜欢穷人。 弗兰西院子里长的就是这种树。在她的三楼太平梯附近，树上的小“伞”一个个蜷曲过来。一个坐在太平梯上的十一岁女孩会觉得自己住在树上。夏天的每个星期六下午，弗兰西都是这么想象的。 啊，布鲁克林的星期六多么美好。啊，到处都是那么美好！人们星期六照样能领薪水。星期六是个周末假日，却又不要守星期天那些清规戒律。人们有钱出去买东西。他们这一天会好好吃上一顿饭，喝醉，约会，做爱，熬夜，唱歌，放音乐，打架，跳舞，因为次日会有自由自在的一天，可以睡个懒觉，至少可以睡到晚场的弥撒。 星期天，大部分人会挤着去参加十一点钟的弥撒。怎么说呢，也有一些人，很少一些，会去参加六点钟的那一场。人们夸他们赶得早，其实他们不配这样的夸奖，因为他们本来是在外头呆得太久，回到家的时候，都是早晨了。他们于是去这场弥撒，应付过去，把罪给洗了，然后回家安安心心睡一天大觉。 弗兰西的星期六，是从去垃圾回收站开始的。和其他布鲁克林小孩一样，她和弟弟尼雷会在外头捡些布头、纸张、金属、橡胶等破烂，藏在地下室的箱子里，上着锁，或是藏在床底下。从星期一到星期五，每天放学回家的路上，弗兰西会慢慢走，边走边看排水沟，希望找到烟盒的锡纸，或是口香糖的包装纸。回头她会将这些放在一个小罐子的盖子里头熔化。垃圾站不收没有熔化的锡球，因为很多孩子会将铁垫圈放在中间抵重量。有时候，尼雷会找到一个苏打水壶。弗兰西会帮他把壶嘴弄下来，熔化出其中的铅来。垃圾站的人怕苏打水公司的人找麻烦，不敢回收完整的壶嘴。壶嘴是好货。化掉后，能卖五分钱。 弗兰西和尼雷每天晚上都到地下室，把升降机架子上当日收的破烂全倒出来。弗兰西和尼雷的妈妈是清洁工，所以两个孩子享有这项特权，能下到地下室去。他们会把架子上的纸张、布头和能回收的瓶子全都拿走。纸张不值什么钱，十磅才能卖一分钱。布头一磅两分钱，铁是一磅四分钱。铜是好货，一磅能卖一毛钱。有时候，弗兰西会撞上大运，找到废弃的煮衣锅锅底。她会用开罐器将它掰下来，折起，捶打，再折，再捶打。 星期六早晨九点一过，孩子们就从大街小巷钻出来，纷纷涌到主干道曼哈顿大道上。他们沿着曼哈顿大道，慢慢走到斯科尔斯街。有的孩子把破烂直接拿在手上。有的拖着木头做的肥皂包装盒，盒子下头装有很稳当的木头轮子。还有几个推着童车，里面装得满满的。 弗兰西和尼雷两个人把破烂装进一只麻袋里，一人拎一只角，在街上拖着走，沿着曼啥顿大道，路过茂吉街、滕·艾耶克街、斯塔格街，最后来到斯科尔斯街。这都是些丑陋的街道，名字倒是很漂亮。每条偏街陋巷里都会有衣衫褴褛的小孩子钻出来，汇入破烂大军，前往卡尼的垃圾站。他们去的路上，会遇到空手而归的孩子们。这些孩子已经把破烂卖掉，钱也都花得一个子儿都不剩了。现在，他们大摇大摆走回来，还嘲笑起其他小孩来。 “捡破烂的！捡破烂的！” 听到这种骂声，弗兰西的脸立刻就涨红了。她知道这些骂人的人自己也捡破烂，可是这也无济于事。其实过一会儿弟弟也会和他的小伙伴们一起，空着手，大摇大摆走回来，同样嘲笑着后来的人，可是这也安慰不了她。她就是害臊得慌。 卡尼在一个摇摇欲坠的马棚里，经营起垃圾回收的生意来。转过街角，弗兰西就看到那两扇大门被钩子钩住，友善地敞开着；那个样子平淡的指针式磅秤的指针晃了一下，弗兰西想象那是欢迎的手势。她看到了卡尼，铁锈色的头发，铁锈色的胡须，铁锈色的眼睛，守在磅秤边。卡尼对女孩子更喜欢些。他伸手去捏女孩子脸蛋的时候，要是对方不退缩，他会多给一分钱。 鉴于有可能拿到这额外好处，尼雷就闪到一边，让弗兰西把麻袋拖进马棚。卡尼跳上前，把袋子里的东西倒在地上，然后先在弗兰西脸上捏了一把。当他将破烂堆上磅秤的时候，弗兰西的眼睛不习惯这里头的黑暗，眨了一眨，想适应过来。她能闻到空气中的苔藓味和湿布头的臭味。卡尼眼睛朝磅秤指针瞟了一眼，然后说了两个字，也就是他的出价。弗兰西知道讨价还价他是不允许的，只好点头称是。卡尼把磅秤上的破烂掀了下去，叫她等着。他自己把废纸码到一个角落，布头扔往另外一个角落，然后把金属分拣出来。这一切都弄完了，他才把手伸进口袋，扯出一个用蜡线拴着的旧皮袋子，掏出一枚枚分币来。分币都发绿了，本身就像破烂似的。她低声说了句：“谢谢您。”这时候卡尼贱贱地看了她一眼，然后伸手狠狠捏了她的脸蛋一把。她坚持着没作什么反应。他笑了，又多给了她一分钱。然后他的举止陡然一变，嘴上咋咋呼呼，手脚敏捷麻利。 “过来，”他冲排队的下一个男孩叫道，“把铅拿出来！”他等着孩子们发笑。“我可不是说破烂啊！”孩子们十分配合地笑了起来。这笑声听来如同迷失羔羊的咩咩叫唤，不过卡尼似乎心满意足了。 弗兰西走了出去，向弟弟汇报情况。“他给了我一毛六，还有捏脸给的一分钱。” “那一分钱归你。”他说。这都是二人之间很早就有的协定了。 她把这一分钱放进衣服口袋，把余下的交给弟弟。尼雷才十岁，比弗兰西小一岁。不过他是男孩，钱的事情归他管。他将这些分币小心翼翼地分好。 “八分钱放进储蓄罐。”这是规定。他们不管在哪里挣到的钱，都将一半存入储蓄罐里。这个储蓄罐是个锡罐子，钉在衣橱间最阴暗的角落里。“四分钱归你，四分钱归我。” 弗兰西把归储蓄罐的钱用手帕包好，打上结。她看着自己的五分钱，很高兴这钱能换成一个五分硬币。 尼雷把麻袋卷起来，用胳膊夹着，冲进查理便宜店里，弗兰西就跟在他身后。查理便宜店是一家廉价糖果店，紧挨着卡尼的垃圾回收站，也是专门为了垃圾站这边的生意而开的。星期六结束后，糖果店的钱柜里会装满发绿的分币。根据某个不成文的规定，这店只有男孩才能进去。所以弗兰西并没有进去，而是靠在门口。 男孩子们的年龄从八岁到十四岁不等，看上去都差不多，都穿着松松垮垮的灯笼裤，戴着鸭舌帽，帽檐都是破破烂烂的。他们到处站着，手插在口袋里，瘦瘦的肩膀用力朝前弓着。他们长大后也会是这样，也会在各样扎堆的地方这么站着。唯一不同的是，长大后，他们嘴边总叼着香烟，就像是永远粘在嘴上一般。他们带着口音说起话来，嘴角的烟就跟着一起一伏。 孩子们惴惴不安地在那里呆着，瘦瘦的脸一会儿面向查理，</span>', '88', '0', '347', '123.00', '0', '0.00', '0.00', '', '274', '0', '0', '1', '', '0', '0', '', '', '1509909668', '1', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('192', '【国家图书奖】鲁迅散文选集', '1509909712', '0', '123', '1', '<img src=\"https://img.alicdn.com/imgextra/i2/2374668160/TB2._4wkUUIL1JjSZFrXXb3xFXa_!!2374668160.jpg\" />', '88', '0', '439', '213.00', '0', '0.00', '0.00', '', '276', '0', '0', '1', '', '0', '0', '', '', '1509909712', '3', '1525190256', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('193', '初等英语3-6级词汇速记手册', '1509910093', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i2/2378431138/TB2jo9RXiGfF1Jjy0FjXXXZdVXa_!!2378431138.jpg\" />', '83', '0', '349', '43.00', '0', '0.00', '0.00', '', '560', '0', '0', '1', '', '0', '0', '', '普装,精装,16开,32开', '1509910093', '1', '1523618750', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('194', '欧神诺瓷砖 特权订金10元抵500元', '1509936513', '0', '324', '1', '<img src=\"https://img.alicdn.com/imgextra/i2/651798426/TB2wEwJcR8lpuFjSspaXXXJKpXa-651798426.jpg\" />', '114', '0', '350', '434.00', '0', '0.00', '0.00', '', '407', '0', '0', '1', '', '0', '0', '', '', '1509936513', '1', '1523618761', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('195', '北欧无缝无纺布壁画 电视背景墙现代沙发客厅卧室', '1509936578', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i4/414749207/TB2E2cIbxwlyKJjSZFsXXar3XXa_!!414749207.jpg\" />', '114', '0', '351', '324.00', '0', '0.00', '0.00', '', '364', '0', '0', '1', '', '0', '0', '', '', '1509936578', '3', '1525190164', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('196', '百安居 699精致全包装修套餐', '1509936626', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i4/2670771506/TB25jVhbKkJL1JjSZFmXXcw0XXa_!!2670771506.jpg\" />', '114', '0', '352', '324.00', '0', '0.00', '0.00', '', '443', '0', '0', '1', '', '0', '0', '', '', '1509936626', '1', '1523618723', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('197', '捷阳 电动晾衣架 遥控升降智能自动晾衣机', '1509936714', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i1/2712564245/TB2YdWzXJzJ8KJjSspkXXbF7VXa_!!2712564245.jpg\" />', '114', '0', '353', '234.00', '0', '0.00', '0.00', '', '442', '0', '0', '1', '', '0', '0', '', '', '1509936714', '1', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('198', 'TATA木门 简约静音门室内门', '1509936856', '0', '435', '1', '<img src=\"https://img.alicdn.com/imgextra/i2/826813153/TB2mIw3lV9gSKJjSspbXXbeNXXa_!!826813153.jpg\" />', '114', '0', '354', '345.00', '0', '0.00', '0.00', '', '364', '0', '0', '1', '', '0', '0', '', '', '1509936856', '1', '1523618710', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('199', '简约转角书桌实木书架书柜组合一体', '1509937022', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i3/1657682766/TB2fieyzctnpuFjSZFKXXalFFXa_!!1657682766.jpg\" />', '114', '0', '355', '3245.00', '0', '0.00', '0.00', '', '505', '0', '0', '1', '', '0', '0', '', '', '1509937022', '1', '1523618678', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('200', '厨房置物架 壁挂 304不锈钢刀架厨具', '1509937154', '0', '234', '1', '<img src=\"https://img.alicdn.com/imgextra/i3/1692257579/TB2x6boaMnH8KJjSspcXXb3QFXa_!!1692257579.jpg\" />', '114', '0', '356', '234.00', '0', '0.00', '0.00', '', '741', '0', '0', '1', '', '0', '0', '', '', '1509937154', '1', '1523618646', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('201', '耐夫刀具套装厨房组合全套不锈钢德国菜刀套装家用', '1509937256', '0', '345', '1', '<img src=\"https://img.alicdn.com/imgextra/i4/2818590914/TB2jnwnhuALL1JjSZFjXXasqXXa_!!2818590914.jpg_q90.jpg\" />', '114', '0', '357', '34554.00', '0', '0.00', '0.00', '', '847', '0', '0', '1', '', '0', '0', '', '', '1509937256', '1', '1509937256', '1509937256', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('203', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', '1511030273', '0', '121', '1', '<p>\r\n	<img src=\"https://img.alicdn.com/imgextra/i3/700459267/TB2MEntayqAXuNjy1XdXXaYcVXa_!!700459267.jpg\" /> \r\n</p>\r\n<p>\r\n	<img src=\"https://img.alicdn.com/imgextra/i1/299244686/TB2pKXYcMFkpuFjSspnXXb4qFXa-299244686.jpg\" /> \r\n</p>\r\n<p>\r\n	<br />\r\n</p>', '151', '0', '358', '12.00', '0', '0.00', '0.00', '', '1570', '0', '0', '1', '', '0', '0', '', '1kg,2kg,优惠套装1,优惠套装2', '1511030273', '1', '0', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('204', '套餐】Apple iPad 32G银+intermail', '1523686247', '0', '123', '1', '<img src=\"https://image.suning.cn/uimg/sop/commodity/881497240158799213071490_x.jpg\" />', '174', '0', '359', '7213.00', '0', '0.00', '0.00', '', '722', '0', '0', '1', '', '0', '0', '', '', '1523686247', '1', '1523686247', '1533139200', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('205', 'Apple iPad mini 4 7.9英寸平板电脑', '1511717623', '0', '23', '1', '<img src=\"https://image.suning.cn/uimg/BTC/PDI/134162973_20150910095419.jpg\" />', '174', '0', '360', '2342.00', '10', '0.00', '0.00', '', '4286', '0', '0', '1', '', '0', '0', '', '', '1511717623', '1', '1511719000', '1511744200', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('206', '惠普（HP）ENVY 13-ad109TU笔记本电脑', '1523686225', '0', '23432', '1', '<img src=\"https://image.suning.cn/uimg/sop/commodity/156254755313200260630300_x.jpg\" />', '174', '0', '361', '234.00', '0', '0.00', '0.00', '', '858', '0', '0', '1', '', '0', '0', '', '', '1523686225', '1', '1523686225', '1528738477', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('207', '美的（Midea）M3-L253C 智能微波炉 光波烧烤', '1523686189', '0', '344', '1', '<img class=\"err-product\" alt=\"\" src=\"https://image.suning.cn/uimg/sop/commodity/187782841565914587180800_x.jpg\" />', '174', '0', '362', '599.00', '0', '0.00', '0.00', '', '8444', '0', '0', '1', '', '0', '1', '', '', '1523686189', '1', '1523686189', '1537728960', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('208', '永赢一路发一苏宁银车挂 银色', '1523686158', '0', '234', '1', '<img src=\"https://image.suning.cn/uimg/sop/commodity/849064331912942412454000_x.jpg\" />', '174', '0', '363', '0.01', '0', '0.00', '0.00', '', '1320', '0', '0', '1', '', '0', '0', '', '', '1523686158', '1', '1523686158', '1541962710', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('209', 'Xiaomi/小米 小米手机Note3 ', '1525156481', '0', '234', '1', '<img src=\"https://image.suning.cn/uimg/sop/commodity/659360312923674112540000_x.jpg\" />', '174', '0', '364', '0.01', '0', '0.00', '0.00', '', '1501', '0', '0', '1', '', '0', '1', '', '', '1525156481', '3', '1525156481', '1539878400', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('212', '九阳(Joyoung) K15-F23 电水壶', '1523682452', '0', '10', '1', '九阳(Joyoung) K15-F23 电水壶', '173', '0', '399', '100.00', '0', '0.00', '0.00', '', '268', '0', '0', '1', '', '0', '0', '', '', '1523682452', '1', '1523682452', '0', '1', '60000', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('213', '伊利 安慕希希腊风味酸牛奶原味', '1523682971', '0', '20', '1', '伊利 安慕希希腊风味酸牛奶原味205g*16盒 浓浓安慕希 &nbsp;', '173', '0', '401', '66.00', '0', '0.00', '0.00', '', '162', '0', '0', '1', '', '0', '0', '', '', '1523682971', '1', '1523682971', '0', '1', '66660', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('214', '洁霸（Attack）瞬清无磷洗衣液3kg/瓶 ', '1523683091', '0', '10', '1', '洁霸（Attack）瞬清无磷洗衣液3kg/瓶&nbsp;', '173', '0', '402', '30.00', '0', '0.00', '0.00', '', '234', '0', '0', '1', '', '0', '1', '', '', '1523683091', '1', '1523683091', '0', '1', '30000', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('215', '容声（Ronshen）BCD-218D11N 218升', '1523683149', '0', '60', '1', '<h1 id=\"itemDisplayName\" style=\"font-size:16px;font-family:微软雅黑;color:#222222;\">\r\n	容声（Ronshen）BCD-218D11N 218升\r\n</h1>', '173', '0', '403', '1200.00', '0', '0.00', '0.00', '', '270', '0', '0', '1', '', '0', '1', '', '', '1523683149', '1', '1523683149', '0', '1', '1200000', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('216', '水井坊 井台瓶 52度 500ml 单瓶装', '1523683209', '0', '66', '1', '水井坊 井台瓶 52度 500ml 单瓶装', '173', '0', '404', '120.00', '0', '0.00', '0.00', '', '282', '0', '0', '1', '', '0', '0', '', '', '1523683209', '1', '1523683209', '0', '1', '12000', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('217', 'walch/威露士衣物家居消毒液 3L 消毒除菌液', '1523683361', '0', '10', '1', '<h1 id=\"itemDisplayName\" style=\"font-size:16px;font-family:微软雅黑;color:#222222;\">\r\n	walch/威露士衣物家居消毒液 3L 消毒除菌液\r\n</h1>', '173', '0', '405', '100.00', '0', '0.00', '0.00', '', '190', '0', '0', '1', '', '0', '0', '', '', '1523683361', '1', '1523683361', '0', '1', '60000', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('218', '安佳（Anchor）全脂纯牛奶1L*12盒整箱', '1523683423', '0', '10', '1', '安佳（Anchor）全脂纯牛奶1L*12盒整箱', '173', '0', '406', '100.00', '0', '0.00', '0.00', '', '254', '0', '0', '1', '', '0', '0', '', '', '1523683423', '1', '1523683423', '0', '1', '10000', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('219', 'Mixx炼奶起士味饼干500g (袋装)', '1525156332', '0', '10', '1', '<h1 id=\"itemDisplayName\" style=\"font-size:16px;font-family:微软雅黑;color:#222222;\">\r\n	Mixx炼奶起士味饼干500g&nbsp;\r\n</h1>', '173', '0', '407', '6.00', '0', '0.00', '0.00', '', '340', '0', '0', '1', '', '0', '1', '', '', '1525156332', '3', '1525156332', '0', '1', '600', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('220', '佳能(Canon) EOS 750D单反数码相机', '1523683614', '0', '6', '1', '<h1 id=\"itemDisplayName\" style=\"font-size:16px;font-family:微软雅黑;color:#222222;\">\r\n	佳能(Canon) EOS 750D 入门级单反数码相机\r\n</h1>', '173', '0', '408', '500.00', '0', '0.00', '0.00', '', '368', '0', '0', '1', '', '0', '1', '', '', '1523683614', '1', '1523683614', '0', '1', '50000', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('221', '华硕(ASUS)轻薄本笔记本电脑', '1523683729', '0', '1', '1', '&nbsp;14.0英寸轻薄本笔记本电脑', '173', '0', '409', '5600.00', '0', '0.00', '0.00', '', '595', '0', '0', '1', '', '0', '0', '', '', '1523683729', '1', '1523683729', '0', '1', '5600000', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('222', '福临门苏软香米5kg/袋 中粮出品 粳米', '1523683797', '0', '1', '1', '<h1 id=\"itemDisplayName\" style=\"font-size:16px;font-family:微软雅黑;color:#222222;\">\r\n	福临门苏软香米5kg/袋 中粮出品 粳米\r\n</h1>', '173', '0', '410', '20.00', '0', '0.00', '0.00', '', '479', '0', '0', '1', '', '0', '0', '', '', '1523683797', '1', '1523683797', '0', '1', '1000', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('223', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', '1524462575', '0', '100', '1', '1000<img src=\"https://img.alicdn.com/imgextra/i1/309886021/TB2gPmGcNXkpuFjy0FiXXbUfFXa_!!309886021.jpg\" />', '151', '0', '411', '12.00', '0', '0.00', '0.00', '', '2064', '0', '0', '1', '', '0', '1', '', '', '1524462575', '1', '1524462575', '0', '0', '0', '0', '2', '55', null);
INSERT INTO `yer_goods` VALUES ('224', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '1524462649', '0', '11', '1', '<img src=\"https://img.alicdn.com/imgextra/i2/309886021/TB2Rlk.cB0lpuFjSszdXXcdxFXa_!!309886021.jpg\" />', '151', '0', '412', '0.10', '0', '0.00', '0.00', null, '1957', '0', '0', '1', null, '0', '0', '', null, '1524462649', '82', '1524462649', '0', '0', '0', '0', '10', '15', '0.01');
INSERT INTO `yer_goods` VALUES ('225', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', '1524462852', '0', '0', '1', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机<br />', '110', '0', '413', '19000.00', '0', '0.00', '0.00', '', '6009', '0', '0', '1', '', '0', '2', '414,415,416', '3G,6G,16G,32G', '1524462852', '1', '1524462852', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('228', 'HLA海澜之家短袖T恤男基础款简约圆领', '1524511415', '0', '44', '1', 'HLA海澜之家短袖T恤男基础款简约圆领HNTBJ2E', '116', '0', '421', '44.00', '0', '0.00', '0.00', '', '1562', '0', '0', '1', '', '0', '0', '', '', '1524511415', '3', '1524511415', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('227', '联想 小新 潮7000-13 (i7 8550u)', '1524471123', '0', '10', '1', '联想 小新 潮7000-13 (i7 8550u)', '160', '16', '420', '4664.00', '0', '0.00', '0.00', '', '3327', '0', '0', '1', '', '0', '4', '', '黑,白,金,官方标配,套餐1,套餐2,1g,2g,3g,4g,6g', '1524471123', '3', '1524471123', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('229', '卡宾Cabbeen 短袖T恤男装黑色', '1524512363', '0', '11', '1', '<h1 class=\"mh\" id=\"productMainName\" style=\"font-size:16px;font-family:\" color:#333333;\"=\"\">\r\n	卡宾Cabbeen 短袖T恤男装黑色\r\n	</h1>', '175', '0', '422', '33.00', '0', '0.00', '0.00', '81', '1368', '0', '0', '1', '76,84', '0', '0', '', '红色,蓝色,白色,x,xl', '1524512363', '3', '1524512363', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('230', '2018年注册会计师全国统一考试辅导教材 ', '1524512536', '0', '11', '1', '<h1 class=\"mh\" id=\"productMainName\" style=\"font-size:16px;font-family:&quot;color:#333333;\">\r\n	2018年注册会计师全国统一考试辅导教材&nbsp;\r\n</h1>', '86', '0', '423', '11.00', '0', '0.00', '0.00', '', '805', '0', '0', '1', '', '0', '0', '', '', '1524512536', '1', '1524512536', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('231', '浮生六记（汪涵推荐，全译本，畅销150万册）', '1524512682', '0', '33', '1', '<h1 class=\"mh\" id=\"productMainName\" style=\"font-size:16px;font-family:&quot;color:#333333;\">\r\n	浮生六记（汪涵推荐，全译本，畅销150万册）\r\n</h1>', '86', '0', '424', '23.00', '0', '0.00', '0.00', '', '1127', '0', '0', '1', '', '0', '0', '', '', '1524512682', '1', '1524512682', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('232', '汪汪队立大功儿童毛绒玩具狗狗毛绒公仔', '1524867002', '0', '45', '1', '狗年吉祥物3只礼盒装 天天毛毛路马', '176', '0', '435', '454.00', '0', '0.00', '0.00', '', '643', '0', '1', '1', '', '0', '0', '', '', '1524867002', '3', '1524867002', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('233', '一品国度 绝地求生游戏台式吃鸡电脑主机', '1524867064', '0', '6', '1', '<span style=\"color:#666666;font-family:Arial, \" font-size:16px;font-weight:bold;background-color:#ffffff;\"=\"\">游戏台式吃鸡电脑主机</span>', '176', '0', '440', '6767.00', '0', '0.00', '0.00', '', '959', '0', '1', '1', '', '0', '0', '481', '', '1524867064', '3', '1524867064', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('234', '美国进口 健安喜（GNC）三倍浓缩鱼', '1532372074', '0', '100', '1', '', '182', '0', '461', '169.00', '0', '0.00', '0.00', '', '279', '0', '1', '1', '', '0', '0', '', '', '1532372074', '22', '1532372074', '0', '0', '0', '0', '0', '', null);
INSERT INTO `yer_goods` VALUES ('235', '爱他美（Aptamil） 【旗舰店】德国奶粉 ', '1610132127', '0', '121', '1', '', '182', '0', '465', '189.00', '0', '0.00', '0.00', null, '353', '0', '1', '1', null, '0', '0', '', null, '1592274393', '82', '1592276154', '1593197727', '0', '0', '0', '0', '', '1');

-- ----------------------------
-- Table structure for yer_group
-- ----------------------------
DROP TABLE IF EXISTS `yer_group`;
CREATE TABLE `yer_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `url` char(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `hide` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态',
  `module` varchar(225) DEFAULT NULL,
  `icon` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `pid` (`pid`) USING BTREE,
  KEY `status` (`status`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='分组表';

-- ----------------------------
-- Records of yer_group
-- ----------------------------
INSERT INTO `yer_group` VALUES ('1', '系统', '0', '1', 'systems/index', '0', '1', '', '');
INSERT INTO `yer_group` VALUES ('7', '文章', '40', '3', 'document/index', '0', '1', '', '');
INSERT INTO `yer_group` VALUES ('28', '营销', '0', '5', 'ScoreType/index', '0', '1', null, null);
INSERT INTO `yer_group` VALUES ('16', '用户', '0', '4', 'user/index', '0', '1', '', '');
INSERT INTO `yer_group` VALUES ('19', '广告', '0', '5', 'ad/index', '0', '1', '', '');
INSERT INTO `yer_group` VALUES ('21', '商品', '0', '2', 'goods/index', '0', '1', '', '');
INSERT INTO `yer_group` VALUES ('25', '首页', '0', '0', 'index/index', '0', '1', '', '');
INSERT INTO `yer_group` VALUES ('26', '微信', '0', '7', 'weixin/index', '0', '1', '', '');
INSERT INTO `yer_group` VALUES ('27', '订单', '0', '3', 'order/index', '0', '1', null, null);

-- ----------------------------
-- Table structure for yer_history
-- ----------------------------
DROP TABLE IF EXISTS `yer_history`;
CREATE TABLE `yer_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `goods_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ip地址',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '日期',
  `time` varchar(255) DEFAULT NULL COMMENT '当前时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=4328 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='历史记录表';

-- ----------------------------
-- Records of yer_history
-- ----------------------------

-- ----------------------------
-- Table structure for yer_images
-- ----------------------------
DROP TABLE IF EXISTS `yer_images`;
CREATE TABLE `yer_images` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `appid` varchar(225) DEFAULT NULL COMMENT '公众号id',
  `content` varchar(225) NOT NULL DEFAULT '' COMMENT '单图文id列表，如1,2,3',
  `keyword` varchar(225) DEFAULT NULL COMMENT '关键词',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='微信多图文回复表';

-- ----------------------------
-- Records of yer_images
-- ----------------------------
INSERT INTO `yer_images` VALUES ('1', 'wx643f65392e6a5e8c', '1,2', '3');

-- ----------------------------
-- Table structure for yer_keyword
-- ----------------------------
DROP TABLE IF EXISTS `yer_keyword`;
CREATE TABLE `yer_keyword` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `title` varchar(225) NOT NULL DEFAULT '' COMMENT '标题',
  `uid` varchar(225) NOT NULL DEFAULT '' COMMENT '链接',
  `remark` varchar(225) NOT NULL DEFAULT '',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `key` varchar(225) DEFAULT NULL,
  `status` int(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='搜索表';

-- ----------------------------
-- Records of yer_keyword
-- ----------------------------

-- ----------------------------
-- Table structure for yer_menu
-- ----------------------------
DROP TABLE IF EXISTS `yer_menu`;
CREATE TABLE `yer_menu` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `appid` varchar(225) DEFAULT NULL COMMENT '公众号id',
  `content` text NOT NULL COMMENT '内容',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='微信自定义菜单表';

-- ----------------------------
-- Records of yer_menu
-- ----------------------------
INSERT INTO `yer_menu` VALUES ('1', 'wx643f65392e6a5e8c', '{\"menu\":{\"button\":[{\"type\":\"click\",\"name\":\"今日歌曲\",\"sub_button\":[],\"key\":\"2\"},{\"type\":\"view\",\"name\":\"百度一下\",\"url\":\"http://www.baidu.com/\",\"sub_button\":[]},{\"name\":\"菜单\",\"sub_button\":[{\"type\":\"click\",\"name\":\"测试\",\"url\":\"http://www.soso.com/\",\"key\":\"5\"},{\"type\":\"view\",\"name\":\"视频\",\"url\":\"http://v.qq.com/\"},{\"type\":\"click\",\"name\":\"赞一下我们\",\"key\":\"col_1\"}]}]}}');

-- ----------------------------
-- Table structure for yer_message
-- ----------------------------
DROP TABLE IF EXISTS `yer_message`;
CREATE TABLE `yer_message` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `goodid` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(225) DEFAULT NULL COMMENT '标题',
  `content` varchar(225) DEFAULT NULL COMMENT '留言内容',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '默认null-未提交订单1-未读2-已读',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `group` varchar(225) DEFAULT NULL COMMENT '分组',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='留言表';

-- ----------------------------
-- Records of yer_message
-- ----------------------------

-- ----------------------------
-- Table structure for yer_mini
-- ----------------------------
DROP TABLE IF EXISTS `yer_mini`;
CREATE TABLE `yer_mini` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `nickName` varchar(255) DEFAULT NULL COMMENT '昵称',
  `country` varchar(255) DEFAULT NULL COMMENT '国家',
  `province` varchar(255) DEFAULT NULL COMMENT '省份',
  `city` varchar(255) DEFAULT NULL COMMENT '城市',
  `language` varchar(255) DEFAULT NULL COMMENT '语言',
  `gender` varchar(255) DEFAULT NULL COMMENT '性别',
  `avatarUrl` varchar(255) DEFAULT NULL COMMENT '头像',
  `appid` varchar(255) DEFAULT NULL COMMENT 'appid',
  `openid` varchar(255) DEFAULT NULL COMMENT 'opnid',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'uid',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='小程序用户表';

-- ----------------------------
-- Records of yer_mini
-- ----------------------------
INSERT INTO `yer_mini` VALUES ('1', 'james', 'China', 'Hubei', 'Wuhan', 'zh_CN', '1', 'https://wx.qlogo.cn/mmopen/vi_32/DYAIOgq83ep3V0v8Akich3S9bojiamlQ6kZCdKMsSBeRjXZOVldbicjAvuYTtcUqiboUaWZ8qNwmibhSaEBhaamiczRw/132', 'wx5370124f8b9dbd91', 'oijfM4uU5MoLfOz_SRvi7K7NJxOY', '104');

-- ----------------------------
-- Table structure for yer_module
-- ----------------------------
DROP TABLE IF EXISTS `yer_module`;
CREATE TABLE `yer_module` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `url` char(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `group_id` int(2) DEFAULT '0',
  `font` varchar(225) NOT NULL,
  `status` tinyint(2) NOT NULL DEFAULT '1',
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `pid` (`pid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=239 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='模块表';

-- ----------------------------
-- Records of yer_module
-- ----------------------------
INSERT INTO `yer_module` VALUES ('1', '系统管理', '0', '2', '', '1', 'icon-setting1', '1', null);
INSERT INTO `yer_module` VALUES ('3', '模块管理', '1', '0', 'module/index', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('7', '商品分类', '40', '1', 'category/index', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('8', '文章分类', '1', '0', 'cate/index', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('9', '文章管理', '43', '0', 'document/index', '7', '', '1', null);
INSERT INTO `yer_module` VALUES ('143', '增加', '142', '0', 'slide/add', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('135', '用户组授权', '74', '0', 'auth/group', '16', '', '1', null);
INSERT INTO `yer_module` VALUES ('134', '删除', '74', '0', 'auth/del', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('14', '商品属性', '40', '0', 'attributes/index', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('141', '删除', '9', '0', 'document/del', '7', '', '1', null);
INSERT INTO `yer_module` VALUES ('16', '订单管理', '41', '0', 'order/index', '27', '', '1', null);
INSERT INTO `yer_module` VALUES ('140', '编辑', '9', '0', 'document/edit', '7', '', '1', null);
INSERT INTO `yer_module` VALUES ('18', '商品类型', '40', '0', 'types/index', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('139', '增加', '9', '0', 'document/add', '7', '', '1', null);
INSERT INTO `yer_module` VALUES ('138', '删除', '8', '0', 'cate/del', '7', '', '1', null);
INSERT INTO `yer_module` VALUES ('224', '积分管理', '0', '0', '', '28', 'icon-jifen', '1', null);
INSERT INTO `yer_module` VALUES ('137', '编辑', '8', '0', 'cate/edit', '7', '', '1', null);
INSERT INTO `yer_module` VALUES ('151', '规格属性', '40', '0', 'specs/index', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('136', '增加', '8', '0', 'cate/add', '7', '', '1', null);
INSERT INTO `yer_module` VALUES ('68', '配置管理', '1', '2', 'config/index', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('40', '商品管理', '0', '1', '', '1', 'icon-shangpin', '1', null);
INSERT INTO `yer_module` VALUES ('41', '订单管理', '0', '2', '', '27', 'icon-order', '1', null);
INSERT INTO `yer_module` VALUES ('43', '文章管理', '0', '0', '', '7', '', '1', null);
INSERT INTO `yer_module` VALUES ('133', '写入用户组', '74', '0', 'auth/writeGrou', '0', '', '1', null);
INSERT INTO `yer_module` VALUES ('132', '访问授权', '74', '0', 'auth/access', '16', '', '1', null);
INSERT INTO `yer_module` VALUES ('131', '编辑', '74', '0', 'auth/edit', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('130', '增加', '74', '0', 'auth/add', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('129', '删除', '78', '0', 'ucenter/del', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('128', '编辑', '78', '0', 'ucenter/edit', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('127', '增加', '78', '0', 'ucenter/add', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('60', '奖品管理', '58', '0', 'ScratchPrize/index', '0', '', '1', null);
INSERT INTO `yer_module` VALUES ('73', '分组管理', '1', '0', 'group/index', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('222', '财务管理', '0', '0', '', '27', 'icon-caiwu1', '1', null);
INSERT INTO `yer_module` VALUES ('65', '奖品管理', '63', '0', 'SmashingPrize/index', '0', '', '1', null);
INSERT INTO `yer_module` VALUES ('70', '系统设置', '1', '3', 'systems/index', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('74', '权限管理', '77', '0', 'auth/index', '16', '', '1', null);
INSERT INTO `yer_module` VALUES ('75', '增加', '3', '0', 'module/add', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('76', '编辑', '3', '2', 'module/edit', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('77', '用户管理', '0', '2', '', '16', 'icon-person', '1', null);
INSERT INTO `yer_module` VALUES ('78', '用户列表', '77', '2', 'user/index', '16', '', '1', null);
INSERT INTO `yer_module` VALUES ('79', '广告管理', '148', '0', 'ad/index', '19', '', '1', null);
INSERT INTO `yer_module` VALUES ('152', '增加', '151', '0', 'specs/add', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('81', '删除', '3', '0', 'module/del', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('82', '增加', '68', '0', 'config/add', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('83', '编辑', '68', '0', 'config/edit', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('84', '删除', '68', '0', 'config/del', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('85', '增加', '73', '0', 'group/add', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('86', '编辑', '73', '0', 'group/edit', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('87', '删除', '73', '0', 'group/del', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('88', '增加', '79', '0', 'ad/add', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('89', '编辑', '79', '0', 'ad/edit', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('90', '删除', '79', '0', 'ad/del', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('91', '增加', '7', '0', 'category/add', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('92', '编辑', '7', '0', 'category/edit', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('93', '删除', '7', '0', 'category/del', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('94', '增加', '14', '0', 'attributes/add', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('95', '编辑', '14', '0', 'attributes/edit', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('96', '删除', '14', '0', 'attributes/del', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('97', '增加', '18', '0', 'types/add', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('98', '编辑', '18', '0', '	types/edit', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('99', '删除', '18', '0', '	types/del', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('154', '删除', '151', '0', 'specs/del', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('153', '编辑', '151', '0', 'specs/edit', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('102', '增加', '71', '0', 'goods/add', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('103', '创建sku', '71', '0', 'goods/add_stock', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('104', '更新sku', '71', '0', 'goods/update_stock', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('105', '增加排列组合', '71', '0', 'goods/ addsu', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('106', '更新排列组合', '71', '0', 'goods/updatesu', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('107', '获取规格属性', '71', '0', 'goods/getalltypes', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('108', '编辑', '71', '0', 'goods/edit', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('109', '切换分类', '71', '0', 'goods/change', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('110', '删除', '71', '0', 'goods/del', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('111', '增加', '72', '0', 'sku/add', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('112', '编辑', '72', '0', 'sku/edit', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('113', '删除', '72', '0', 'sku/del', '3', '', '1', null);
INSERT INTO `yer_module` VALUES ('114', '增加', '16', '0', 'order/add', '15', '', '1', null);
INSERT INTO `yer_module` VALUES ('115', '编辑', '16', '0', 'order/edit', '15', '', '1', null);
INSERT INTO `yer_module` VALUES ('116', '导出订单', '16', '0', 'order/out', '15', '', '1', null);
INSERT INTO `yer_module` VALUES ('117', '删除', '16', '0', 'order/del', '15', '', '1', null);
INSERT INTO `yer_module` VALUES ('118', '增加', '21', '0', 'drawback/add', '15', '', '1', null);
INSERT INTO `yer_module` VALUES ('119', '编辑', '21', '0', 'drawback/edit', '15', '', '1', null);
INSERT INTO `yer_module` VALUES ('120', '删除', '21', '0', 'drawback/del', '15', '', '1', null);
INSERT INTO `yer_module` VALUES ('121', '增加', '22', '0', 'pay/add', '15', '', '1', null);
INSERT INTO `yer_module` VALUES ('122', '编辑', '22', '0', 'pay/edit', '15', '', '1', null);
INSERT INTO `yer_module` VALUES ('123', '删除', '22', '0', 'rank/del', '15', '', '1', null);
INSERT INTO `yer_module` VALUES ('142', '幻灯片管理', '148', '0', 'slide/index', '19', '', '1', null);
INSERT INTO `yer_module` VALUES ('144', '编辑', '142', '0', 'slide/edit', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('145', '删除', '142', '0', 'slide/del', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('146', '切换分类', '142', '0', 'slide/change', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('147', '导航管理', '1', '0', 'channel/index', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('148', '图片管理', '0', '0', '', '19', 'icon-tupian', '1', null);
INSERT INTO `yer_module` VALUES ('149', '资源管理', '148', '0', 'Attachment/index', '19', '', '1', null);
INSERT INTO `yer_module` VALUES ('215', '数据库管理', '0', '0', '', '1', 'icon-jurassic_data', '1', null);
INSERT INTO `yer_module` VALUES ('155', '增加', '147', '0', 'channel/add', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('156', '编辑', '147', '0', 'channel/edit', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('157', '删除', '147', '0', 'channel/del', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('158', '评价管理', '77', '0', 'comment/index', '16', '', '1', null);
INSERT INTO `yer_module` VALUES ('159', '增加', '158', '0', 'comment/add', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('160', '编辑', '158', '0', 'comment/edit', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('161', '删除', '158', '0', 'comment/del', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('162', '商品品牌', '40', '0', 'brand/index', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('163', '增加', '162', '0', 'brand/add', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('164', '编辑', '162', '0', 'brand/edit', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('165', '删除', '162', '0', 'brand/del', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('210', '地址管理', '77', '0', 'address/index', '16', '', '1', null);
INSERT INTO `yer_module` VALUES ('167', '用户行为', '0', '0', '', '16', 'icon-dongzuo', '1', null);
INSERT INTO `yer_module` VALUES ('168', '操作日志', '167', '0', 'log/index', '16', '', '1', null);
INSERT INTO `yer_module` VALUES ('169', '增加', '168', '0', 'log/add', '16', '', '1', null);
INSERT INTO `yer_module` VALUES ('170', '编辑', '168', '0', 'log/edit', '16', '', '1', null);
INSERT INTO `yer_module` VALUES ('171', '删除', '168', '0', 'log/del', '16', '', '1', null);
INSERT INTO `yer_module` VALUES ('173', '快递管理', '220', '0', 'Express/index', '27', '', '1', null);
INSERT INTO `yer_module` VALUES ('174', '销售记录', '41', '0', 'sales/index', '27', '', '1', null);
INSERT INTO `yer_module` VALUES ('175', '菜单生成器', '176', '0', 'Code/index', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('176', '快捷工具', '0', '0', '', '1', 'icon-gongju', '1', null);
INSERT INTO `yer_module` VALUES ('177', 'Sql命令', '176', '0', 'Sql/index', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('178', '新增', '172', '0', 'goods/add', '20', '', '1', null);
INSERT INTO `yer_module` VALUES ('183', '促销管理', '0', '0', '', '20', '', '1', null);
INSERT INTO `yer_module` VALUES ('184', '满减优惠', '183', '0', 'reduction/index', '20', '', '1', null);
INSERT INTO `yer_module` VALUES ('193', '浏览记录', '77', '0', 'history/index', '16', '', '1', null);
INSERT INTO `yer_module` VALUES ('195', '首页', '1', '0', 'index/index', '1', '', '0', null);
INSERT INTO `yer_module` VALUES ('196', '数据备份', '215', '0', 'table/index', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('197', '购物车管理', '77', '0', 'cart/index', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('200', '流量管理', '1', '0', 'flow/index', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('201', '微信管理', '0', '0', '', '26', 'icon-weixin2', '1', null);
INSERT INTO `yer_module` VALUES ('202', '公众号管理', '201', '0', 'weixin/index', '26', '', '1', null);
INSERT INTO `yer_module` VALUES ('203', '关注回复', '201', '0', 'focus/index', '26', '', '1', null);
INSERT INTO `yer_module` VALUES ('204', '被动回复管理', '201', '0', 'answer/index', '26', '', '1', null);
INSERT INTO `yer_module` VALUES ('205', '文本回复', '201', '0', 'text/index', '26', '', '1', null);
INSERT INTO `yer_module` VALUES ('206', '单图文管理', '201', '0', 'news/index', '26', '', '1', null);
INSERT INTO `yer_module` VALUES ('207', '多图文管理', '201', '0', 'images/index', '26', '', '1', null);
INSERT INTO `yer_module` VALUES ('208', '自定义菜单管理', '201', '0', 'menu/index', '26', '', '1', null);
INSERT INTO `yer_module` VALUES ('209', '粉丝管理', '201', '0', 'follow/index', '26', '', '1', null);
INSERT INTO `yer_module` VALUES ('216', '数据还原', '215', '0', 'backup/index', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('217', '采购管理', '0', '0', '', '27', 'icon-cart1', '1', null);
INSERT INTO `yer_module` VALUES ('218', '供应商管理', '217', '0', 'supplier/index', '27', '', '1', null);
INSERT INTO `yer_module` VALUES ('219', '采购单管理', '217', '0', 'caigou/index', '27', '', '1', null);
INSERT INTO `yer_module` VALUES ('220', '库存管理', '0', '0', '', '27', 'icon-kucun', '1', null);
INSERT INTO `yer_module` VALUES ('221', '库存管理', '220', '0', 'sku/index', '27', '', '1', null);
INSERT INTO `yer_module` VALUES ('223', '支付管理', '222', '0', 'pay/index', '27', '', '1', null);
INSERT INTO `yer_module` VALUES ('225', '积分类型', '224', '0', 'ScoreType/index', '28', '', '1', null);
INSERT INTO `yer_module` VALUES ('226', '积分商品', '224', '0', 'ScoreGoods/index', '28', '', '1', null);
INSERT INTO `yer_module` VALUES ('227', '兑换管理', '224', '0', 'ScoreOrder/index', '28', '', '1', null);
INSERT INTO `yer_module` VALUES ('228', '消费明细', '224', '0', 'ScoreLog/index', '28', '', '1', null);
INSERT INTO `yer_module` VALUES ('229', '兑换码管理', '224', '0', 'ScoreCode/index', '28', '', '1', null);
INSERT INTO `yer_module` VALUES ('231', '计划任务', '215', '0', 'download/index', '1', '', '1', null);
INSERT INTO `yer_module` VALUES ('232', '消息管理', '77', '0', 'envelope/index', '16', '', '1', null);
INSERT INTO `yer_module` VALUES ('233', '优惠券管理', '0', '0', '', '28', 'icon-youhuiquan', '1', null);
INSERT INTO `yer_module` VALUES ('234', '优惠券', '233', '0', 'coupon/index', '28', '', '1', null);
INSERT INTO `yer_module` VALUES ('235', '用户优惠券管理', '233', '0', 'userCoupon/index', '28', '', '1', null);
INSERT INTO `yer_module` VALUES ('236', '银行卡管理', '77', '0', 'bank/index', '16', '', '1', null);
INSERT INTO `yer_module` VALUES ('237', '账户明细', '77', '0', 'AccountLog/index', '16', '', '1', null);
INSERT INTO `yer_module` VALUES ('238', '提现管理', '77', '0', 'cash/index', '16', '', '1', null);

-- ----------------------------
-- Table structure for yer_news
-- ----------------------------
DROP TABLE IF EXISTS `yer_news`;
CREATE TABLE `yer_news` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `appid` varchar(225) DEFAULT NULL COMMENT '公众号id',
  `title` varchar(225) DEFAULT NULL COMMENT '关键词',
  `content` text NOT NULL COMMENT '内容',
  `keyword` varchar(225) DEFAULT NULL COMMENT '关键词',
  `media_id` varchar(255) DEFAULT NULL COMMENT '缩略图id',
  `des` varchar(255) DEFAULT NULL COMMENT '描述',
  `author` varchar(255) DEFAULT NULL COMMENT '作者',
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '封面id',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '发布时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='微信单一图文回复表';

-- ----------------------------
-- Records of yer_news
-- ----------------------------
INSERT INTO `yer_news` VALUES ('1', 'wx643f65392e6a5e8c', '从“点题”到“破题” 习近平引领“中国之治”开辟新境', '<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;text-align:center;\">\r\n	<img alt=\"\" src=\"http://i.ce.cn/ce/xwzx/gnsz/gdxw/201911/09/W020191109683495060705.jpg\" /> \r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　6年前，党的十八届三中全会提出“全面深化改革的总目标是完善和发展中国特色社会主义制度，推进国家治理体系和治理能力现代化”，开启了全面深化改革新征程。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　今年，党的十九届四中全会审议通过了重磅文件《中共中央关于坚持和完善中国特色社会主义制度、推进国家治理体系和治理能力现代化若干重大问题的决定》。《决定》对党的十八届三中全会提出的总目标进行深化和展开，为我们推动各方面制度更加成熟更加定型明确了时间表、路线图。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　从“点题”到“破题”，中国共产党人如何把改革蓝图转化成全方位治理中的改革实践？让我们从习近平关于全面深化改革的重要论述中寻找答案。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　经济体制改革取得重大突破\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　我们是在中国共产党领导和社会主义制度的大前提下发展市场经济，什么时候都不能忘了“社会主义”这个定语。之所以说是社会主义市场经济，就是要坚持我们的制度优越性，有效防范资本主义市场经济的弊端。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2015年11月23日，在十八届中央政治局第二十八次集体学习时的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　公有制经济、非公有制经济应该相辅相成、相得益彰，而不是相互排斥、相互抵消。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2016年3月4日，在参加全国政协十二届四次会议民建、工商联界委员联组会时的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　经济体制改革必须以完善产权制度和要素市场化配置为重点，实现产权有效激励、要素自由流动、价格反应灵活、竞争公平有序、企业优胜劣汰。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2017年10月18日，在中国共产党第十九次全国代表大会上的报告\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;text-align:center;\">\r\n	<img alt=\"\" src=\"http://i.ce.cn/ce/xwzx/gnsz/gdxw/201911/09/W020191109683495138825.gif\" /> \r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;text-align:center;\">\r\n	　　<strong>政治体制改革稳步推进</strong> \r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　在全面深化改革进程中，我们要积极稳妥推进政治体制改革，以保证人民当家作主为根本，以增强党和国家活力、调动人民积极性为目标，不断建设社会主义政治文明。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2014年9月5日，在庆祝全国人民代表大会成立六十周年大会上的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　发展社会主义民主政治就是要体现人民意志、保障人民权益、激发人民创造活力，用制度体系保证人民当家作主。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2017年10月18日，在中国共产党第十九次全国代表大会上的报告\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　深化国家监察体制改革，目的是加强党对反腐败工作的统一领导，实现对所有行使公权力的公职人员监察全覆盖。国家监察委员会就是中国特色的国家反腐败机构。国家监察委员会同中央纪委合署办公，履行纪检、监察两项职责，实行一套工作机构、两个机关名称。不再保留监察部、国家预防腐败局。这项改革是事关全局的重大政治体制改革，具有鲜明的中国特色，展现了我们党自我革命的勇气和担当，意义重大而深远。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2018年2月26日至28日，在党的十九届三中全会上关于深化党和国家机构改革方案的说明\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;text-align:center;\">\r\n	<img alt=\"\" src=\"http://i.ce.cn/ce/xwzx/gnsz/gdxw/201911/09/W020191109683495989740.gif\" /> \r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;text-align:center;\">\r\n	　　<strong>文化体制改革不断创新发展</strong> \r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　一个国家选择什么样的治理体系，是由这个国家的历史传承、文化传统、经济社会发展水平决定的，是由这个国家的人民决定的。我国今天的国家治理体系，是在我国历史传承、文化传统、经济社会发展的基础上长期发展、渐进改进、内生性演化的结果。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2014年2月17日，在省部级主要领导干部学习贯彻十八届三中全会精神全面深化改革专题研讨班开班式上的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　要增强文化自信，在传承中华优秀传统文化基础上发展社会主义先进文化，加快建设社会主义文化强国。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2017年4月19日，在广西考察时的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　文学艺术创造、哲学社会科学研究首先要搞清楚为谁创作、为谁立言的问题，这是一个根本问题。人民是创作的源头活水，只有扎根人民，创作才能获得取之不尽、用之不竭的源泉。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2019年3月4日，在看望参加全国政协十三届二次会议的文化艺术界、社会科学界委员时的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;text-align:center;\">\r\n	<img alt=\"\" src=\"http://i.ce.cn/ce/xwzx/gnsz/gdxw/201911/09/W020191109683496753248.gif\" /> \r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;text-align:center;\">\r\n	　<strong>　社会体制改革全面推进</strong> \r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　要通过社会体制改革创新，充分调动各方面积极性，最大限度增强社会发展活力，充分发挥人民群众首创精神，使全社会创造能量充分释放、创业活动蓬勃开展。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2013年7月23日，在湖北省武汉市主持召开部分省市负责人座谈会时的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　社会建设要以共建共享为基本原则，在体制机制、制度政策上系统谋划，从保障和改善民生做起，坚持群众想什么、我们就干什么，既尽力而为又量力而行，多一些雪中送炭，使各项工作都做到愿望和效果相统一。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2015年5月25日至27日，在浙江调研时的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　要继续加强和创新社会治理，完善中国特色社会主义社会治理体系，努力建设更高水平的平安中国，进一步增强人民群众安全感。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2016年10月，就加强和创新社会治理作出的指示\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;text-align:center;\">\r\n	<img alt=\"\" src=\"http://i.ce.cn/ce/xwzx/gnsz/gdxw/201911/09/W020191109683497736312.gif\" /> \r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;text-align:center;\">\r\n	　　生态文明体制改革加快推进\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　保护生态环境必须依靠制度、依靠法治。只有实行最严格的制度、最严密的法治，才能为生态文明建设提供可靠保障。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2013年5月24日，在十八届中央政治局第六次集体学习时的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　生态环境问题，归根到底是资源过度开发、粗放利用、奢侈消费造成的。资源开发利用既要支撑当代人过上幸福生活，也要为子孙后代留下生存根基。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2017年5月26日，在十八届中央政治局第四十一次集体学习时的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　生态文明体制改革是全面深化改革的重要领域，要以解决生态环境领域突出问题为导向，抓好已出台改革举措的落地，及时制定新的改革方案。对涉及生态文明体制改革的一些重要举措要尽快到位、发挥作用。\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;\">\r\n	　　——2018年5月18日，在全国生态环境保护大会上的讲话\r\n</p>\r\n<p style=\"font-size:16px;color:#434343;font-family:&quot;background-color:#FFFFFF;text-align:center;\">\r\n	<img alt=\"\" src=\"http://i.ce.cn/ce/xwzx/gnsz/gdxw/201911/09/W020191109683498597854.gif\" /> \r\n</p>', '2', 'Gleo07uFEjKR6IlZV8DsC0MGtIxsZVz2pvAdc-tHshrM3fSRusmPLx44GhfXDYsW', 'asda', 'asdsa', '523', '0');
INSERT INTO `yer_news` VALUES ('2', 'wx643f65392e6a5e8c', 'Quarkus 1.0 发布，Java 云原生、容器优先框架', '<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	<img src=\"https://static.oschina.net/uploads/space/2019/0326/084503_pNcF_3820517.png\" class=\"zoom-in-cursor\" style=\"height:auto !important;\" /> \r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	Quarkus 是 Kubernetes 原生的 Java 技术栈，它由同类中最佳的 Java 库和标准精制而成，并针对容器和云部署量身定制。Quarkus 的总体目标是将 Java 带入云原生的应用开发，并使它成为 Serverless、云和 Kubernetes 环境的领先平台。\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	Quarkus 代表了现代应用开发人员的根本性转变，旨在解决 Java 在云原生应用架构（如容器、微服务和 Serverless）方面面临的一些缺陷。Java 开发人员能够使用 Quarkus 构建具有比传统的基于 Java 的微服务框架更快的启动时间并占用更少内存的应用。它包括灵活、易于使用的 API，这些 API 使开发人员能够构建云原生应用，同时还包含大多数开发人员已经熟悉的同类最佳框架，比如 Eclipse MicroProfile、Apache Kafka、RESTEasy（JAX-RS）、Hibernate ORM（JPA）、CDI、Spring 相关、Infinispan 与 Camel 等。\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	此外 Quarkus 还统一了响应式和命令式编程模型，开发人员可以选择最适合其用例的模型，并更轻松地将其代码与其它组件集成到响应式系统中，例如带有 Vert.x 和 Kafka 的响应式流、响应式数据库 API 等。\r\n</p>\r\n<p style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	1.0 版本主要更新包括：\r\n</p>\r\n<ul style=\"color:#333333;font-family:&quot;font-size:16px;background-color:#FFFFFF;\">\r\n	<li>\r\n		基于 Vert.x 的响应式内核，使响应式编程成为 Quarkus 的一级特性\r\n	</li>\r\n	<li>\r\n		一个新的非阻塞安全层，它可以进行响应式身份验证和授权，还可以使响应式安全操作与 Vert.x 集成\r\n	</li>\r\n	<li>\r\n		改进的 Spring API 兼容性，包括 Spring Web 和 Spring Data JPA 以及 Spring DI\r\n	</li>\r\n</ul>', '5', '1x9Zd-FdttOBgWMg9BcSwgBB34gwkQDXC1CjvexDKPbny9BkFxfg8LnIdlg97qe-', '12312', '123', '524', '0');

-- ----------------------------
-- Table structure for yer_order
-- ----------------------------
DROP TABLE IF EXISTS `yer_order`;
CREATE TABLE `yer_order` (
  `id` int(225) unsigned NOT NULL AUTO_INCREMENT COMMENT '订单id',
  `order_sn` varchar(225) DEFAULT NULL,
  `total_money` decimal(50,2) NOT NULL DEFAULT '0.00',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0-系统生成完成1-用户已提交订单2-3系统处理进入物流配送',
  `update_time` varchar(255) DEFAULT NULL COMMENT '更新时间',
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `ship_price` decimal(50,2) NOT NULL DEFAULT '0.00',
  `ispay` tinyint(2) NOT NULL DEFAULT '0' COMMENT '1在线支付未完成2在线支付完成3-货到付款',
  `total` decimal(50,2) NOT NULL DEFAULT '0.00',
  `express` varchar(225) DEFAULT NULL COMMENT '是否默认地址',
  `address_id` int(10) unsigned NOT NULL DEFAULT '0',
  `shipway` varchar(225) DEFAULT NULL COMMENT '送货方式',
  `invoice_header` varchar(225) DEFAULT NULL COMMENT '发票抬头',
  `message` varchar(225) DEFAULT NULL COMMENT '留言',
  `score` int(10) unsigned NOT NULL DEFAULT '0',
  `coupon_money` varchar(225) DEFAULT NULL,
  `score_money` decimal(50,2) NOT NULL DEFAULT '0.00',
  `username` varchar(225) DEFAULT NULL,
  `mobile` varchar(225) DEFAULT NULL,
  `address` varchar(225) DEFAULT NULL,
  `express_code` varchar(225) DEFAULT NULL,
  `arrive_time` decimal(50,2) DEFAULT '0.00',
  `isdao` int(10) NOT NULL DEFAULT '0',
  `saleslist` text NOT NULL,
  `invoice_content` varchar(225) DEFAULT NULL COMMENT '发票内容',
  `invoice_type` varchar(225) DEFAULT NULL,
  `is_invoice` varchar(225) DEFAULT NULL,
  `is_mobile` tinyint(2) NOT NULL DEFAULT '0',
  `type` tinyint(2) NOT NULL DEFAULT '0',
  `paytype` int(2) NOT NULL DEFAULT '0',
  `send_time` int(10) NOT NULL DEFAULT '0',
  `confirm_time` int(10) NOT NULL DEFAULT '0',
  `spress_type` tinyint(2) NOT NULL DEFAULT '0',
  `order_type` int(10) NOT NULL DEFAULT '0',
  `wait_pay_money` decimal(50,2) DEFAULT '0.00',
  `pay_money` decimal(50,2) DEFAULT '0.00',
  `num` int(10) NOT NULL DEFAULT '0',
  `goods_id` int(10) NOT NULL DEFAULT '0',
  `pin_status` tinyint(2) NOT NULL DEFAULT '0',
  `submit_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '提交时间',
  `expire_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最终可支付时间',
  `pay_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `coupon_id` int(10) NOT NULL DEFAULT '0' COMMENT '优惠券id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='订单表';

-- ----------------------------
-- Records of yer_order
-- ----------------------------

-- ----------------------------
-- Table structure for yer_pay
-- ----------------------------
DROP TABLE IF EXISTS `yer_pay`;
CREATE TABLE `yer_pay` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `out_trade_no` varchar(225) DEFAULT NULL,
  `total_money` decimal(50,2) NOT NULL DEFAULT '0.00' COMMENT '优惠后的总金额',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '数据状态',
  `paytype` int(10) NOT NULL DEFAULT '0' COMMENT '付款类型1-货到付款2-在线支付',
  `uid` int(10) NOT NULL DEFAULT '0',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `model` varchar(225) DEFAULT NULL,
  `trade_no` varchar(225) DEFAULT NULL,
  `trade_status` varchar(225) DEFAULT NULL,
  `remark` varchar(225) DEFAULT NULL,
  `order_id` int(10) NOT NULL DEFAULT '0',
  `type` tinyint(2) NOT NULL DEFAULT '1',
  `score` int(10) NOT NULL DEFAULT '0',
  `score_money` decimal(50,2) NOT NULL DEFAULT '0.00',
  `wait_pay_money` decimal(50,2) NOT NULL DEFAULT '0.00',
  `cost` decimal(50,2) NOT NULL DEFAULT '0.00' COMMENT '成本',
  `profit` decimal(50,2) NOT NULL DEFAULT '0.00' COMMENT '利润',
  `time` varchar(255) DEFAULT NULL COMMENT '当前时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=232 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='在线支付表';

-- ----------------------------
-- Records of yer_pay
-- ----------------------------
INSERT INTO `yer_pay` VALUES ('1', 'J2042347901000382442', '107462.00', '1', '5', '74', '1580823529', '2020', 'order', null, null, null, '2', '2', '0', '0.00', '0.00', '50.00', '174.00', '2020-02-04 21:39:00');
INSERT INTO `yer_pay` VALUES ('2', 'J2042357587400472513', '101231.00', '0', '0', '74', '1580823579', '0', 'order', null, null, null, '3', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('3', 'J2042398282500115648', '1999.00', '1', '5', '74', '1580823987', '2020', 'order', null, null, null, '4', '2', '0', '0.00', '0.00', '50.00', '174.00', '2020-02-04 21:47:14');
INSERT INTO `yer_pay` VALUES ('4', 'J2042413949400921578', '5465.00', '1', '5', '74', '1580824143', '2020', 'order', null, null, null, '5', '2', '0', '0.00', '0.00', '31.00', '176.00', '2020-02-04 21:49:07');
INSERT INTO `yer_pay` VALUES ('5', 'J2067986634261300368', '44.00', '1', '5', '74', '1580979871', '2020', 'order', null, null, null, '7', '2', '0', '0.00', '0.00', '35.00', '137.00', '2020-02-06 17:04:48');
INSERT INTO `yer_pay` VALUES ('6', 'J2139371147421380493', '101231.00', '0', '0', '74', '1581593732', '0', 'order', null, null, null, '15', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('7', 'J2139754480621273052', '11.00', '1', '5', '74', '1581597548', '2020', 'order', null, null, null, '17', '2', '0', '0.00', '0.00', '24.00', '104.00', '2020-02-13 20:40:56');
INSERT INTO `yer_pay` VALUES ('8', 'J2139886181821837795', '101231.00', '1', '5', '74', '1581598866', '2020', 'order', null, null, null, '18', '2', '0', '0.00', '0.00', '13.00', '111.00', '2020-02-13 21:01:10');
INSERT INTO `yer_pay` VALUES ('9', 'J3225215296600667223', '101231.00', '1', '5', '71', '1584852174', '2020', 'order', null, null, null, '21', '2', '0', '0.00', '0.00', '13.00', '111.00', '2020-03-22 12:42:59');
INSERT INTO `yer_pay` VALUES ('10', 'J3225268978500475181', '11.00', '1', '5', '71', '1584852695', '2020', 'order', null, null, null, '22', '2', '0', '0.00', '0.00', '24.00', '104.00', '2020-03-22 12:51:39');
INSERT INTO `yer_pay` VALUES ('11', 'J3226029324600207563', '1999.00', '1', '5', '71', '1584860298', '2020', 'order', null, null, null, '24', '2', '0', '0.00', '0.00', '50.00', '174.00', '2020-03-22 14:58:22');
INSERT INTO `yer_pay` VALUES ('12', 'J3228550699900193701', '23.00', '0', '0', '72', '1584886116', '0', 'order', null, null, null, '28', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('13', 'J3228550699900193701', '23.00', '0', '0', '72', '1584886168', '0', 'order', null, null, null, '28', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('14', 'J3228624306500716498', '23.00', '1', '5', '72', '1584886246', '2020', 'order', null, null, null, '29', '2', '0', '0.00', '0.00', '41.00', '178.00', '2020-03-22 22:10:47');
INSERT INTO `yer_pay` VALUES ('15', 'J4038115867080678589', '94.00', '1', '5', '74', '1585881166', '2020', 'order', null, null, null, '34', '2', '0', '0.00', '0.00', '41.00', '178.00', '2020-04-03 10:33:49');
INSERT INTO `yer_pay` VALUES ('16', 'J4038115867080678589', '94.00', '1', '5', '74', '1585881229', '2020', 'order', null, null, null, '34', '2', '0', '0.00', '0.00', '41.00', '178.00', '2020-04-03 10:33:49');
INSERT INTO `yer_pay` VALUES ('17', 'J4118245164600877738', '46.00', '0', '0', '74', '1586582459', '0', 'order', null, null, null, '36', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('18', 'J4118254858000405780', '303693.00', '1', '5', '74', '1586582556', '2020', 'order', null, null, null, '37', '2', '0', '0.00', '0.00', '13.00', '111.00', '2020-04-11 13:24:22');
INSERT INTO `yer_pay` VALUES ('19', 'J4205883966090751444', '101231.00', '0', '0', '80', '1587358886', '0', 'order', null, null, null, '3', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('20', 'J4287588093820568597', '23.00', '0', '0', '80', '1588075925', '0', 'order', null, null, null, '24', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('21', 'J5066886563900969232', '101231.00', '0', '0', '81', '1588768879', '0', 'order', null, null, null, '2', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('22', 'J5124750960087996274', '0.10', '1', '5', '84', '1589247520', '2020', 'order', null, null, null, '6', '2', '0', '0.00', '0.00', '9.00', '110.00', '2020-05-12 09:38:40');
INSERT INTO `yer_pay` VALUES ('23', 'J5124764102154128869', '12.00', '1', '5', '84', '1589247645', '2020', 'order', null, null, null, '7', '2', '0', '0.00', '0.00', '15.00', '113.00', '2020-05-12 09:40:45');
INSERT INTO `yer_pay` VALUES ('24', 'J5160447607142145925', '12.00', '0', '0', '89', '1589605056', '0', 'order', null, null, null, '13', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('25', 'J5160447607142145925', '12.00', '0', '0', '89', '1589605056', '0', 'order', null, null, null, '13', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('26', 'J5160515813047919774', '99.00', '0', '0', '89', '1589605162', '0', 'order', null, null, null, '14', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('27', 'J5180218615479282512', '0.10', '0', '0', '92', '1589802196', '0', 'order', null, null, null, '15', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('28', 'J5282879367739340267', '23.00', '0', '0', '82', '1590628809', '0', 'order', null, null, null, '24', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('29', 'J5283003112030414136', '599.00', '0', '0', '82', '1590630037', '0', 'order', null, null, null, '25', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('30', 'J5283003112030414136', '599.00', '0', '0', '82', '1590630037', '0', 'order', null, null, null, '25', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('31', 'J5283054529055355029', '599.00', '0', '0', '82', '1590630549', '0', 'order', null, null, null, '26', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('32', 'J5286716269051974279', '599.00', '0', '0', '82', '1590667165', '0', 'order', null, null, null, '27', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('33', 'J5295935977792802183', '1999.00', '0', '0', '82', '1590759365', '0', 'order', null, null, null, '31', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('34', '1590805787500', '10.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('35', '1590805856430', '10.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('36', '1590805857390', '10.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('37', '1590805986150', '10.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('38', '1590806010250', '10.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('39', '1590806011490', '10.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('40', '1590806422570', '10.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('41', '1590806470320', '10.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('42', 'J5300649649334311771', '599.00', '0', '0', '82', '1590806499', '0', 'order', null, null, null, '35', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('43', 'J5300653221937101609', '599.00', '0', '0', '82', '1590806534', '0', 'order', null, null, null, '36', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('44', 'J5300671352354980684', '599.00', '0', '0', '82', '1590806715', '0', 'order', null, null, null, '37', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('45', '1590807555460', '10.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('46', '1590807628570', '10.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('47', '1590807676430', '10.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('48', '1590807677430', '10.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('49', '1590810352480', '10.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('50', '1590810352190', '10.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('51', '1590817460250', '40.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('52', 'J5301746928519237680', '599.00', '0', '0', '82', '1590817474', '0', 'order', null, null, null, '38', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('53', 'J5303488929382797698', '599.00', '0', '0', '82', '1590834894', '0', 'order', null, null, null, '41', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('54', 'J5315974777134505787', '36.50', '0', '0', '82', '1590859751', '0', 'order', null, null, null, '43', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('55', 'J5319055874665870855', '0.10', '0', '0', '95', '1590890570', '0', 'order', null, null, null, '44', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('56', '20200531159089071895', '39.90', '0', '3', '95', '1590890723', '0', 'order', null, null, null, '45', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('57', '1591093044500', '5222.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('58', 'J6031503929629317798', '101231.00', '0', '0', '82', '1591115048', '0', 'order', null, null, null, '54', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('59', 'J6036023663647744129', '12.00', '0', '0', '96', '1591160259', '0', 'order', null, null, null, '55', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('60', 'J6045106411937246755', '599.00', '0', '0', '82', '1591251085', '0', 'order', null, null, null, '65', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('61', 'J6051993640487976520', '599.00', '0', '0', '82', '1591320362', '0', 'order', null, null, null, '80', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('62', 'J6052060373237905563', '599.00', '0', '0', '82', '1591320619', '0', 'order', null, null, null, '81', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('63', 'J6052353607893426332', '599.00', '0', '0', '82', '1591323541', '0', 'order', null, null, null, '82', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('64', 'J6052370098952623756', '599.00', '0', '0', '82', '1591323703', '0', 'order', null, null, null, '83', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('65', 'J6052382933026613718', '599.00', '0', '0', '82', '1591323833', '0', 'order', null, null, null, '84', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('66', 'J6052411984447434730', '599.00', '0', '0', '82', '1591324122', '0', 'order', null, null, null, '85', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('67', 'J6052438434045604189', '599.00', '0', '0', '82', '1591324392', '0', 'order', null, null, null, '86', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('68', 'J6052464817405716107', '599.00', '0', '0', '82', '1591324652', '0', 'order', null, null, null, '87', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('69', 'J6052481353225481902', '599.00', '0', '0', '82', '1591324815', '0', 'order', null, null, null, '88', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('70', 'J6052491933826428753', '599.00', '0', '0', '82', '1591324926', '0', 'order', null, null, null, '89', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('71', 'J6052491933826428753', '599.00', '0', '0', '82', '1591324927', '0', 'order', null, null, null, '89', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('72', 'J6052506985851691597', '599.00', '0', '0', '82', '1591325072', '0', 'order', null, null, null, '90', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('73', 'J6052518850298348617', '599.00', '0', '0', '82', '1591325193', '0', 'order', null, null, null, '92', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('74', 'J6052533828452983013', '599.00', '0', '0', '82', '1591325341', '0', 'order', null, null, null, '94', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('75', 'J6052533828452983013', '599.00', '0', '0', '82', '1591325342', '0', 'order', null, null, null, '94', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('76', 'J6052540610141847143', '599.00', '0', '0', '82', '1591325408', '0', 'order', null, null, null, '95', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('77', 'J6052552060710218175', '599.00', '0', '0', '82', '1591325523', '0', 'order', null, null, null, '96', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('78', 'J6052558733281713945', '599.00', '0', '0', '82', '1591325589', '0', 'order', null, null, null, '98', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('79', 'J6052572758707207243', '599.00', '0', '0', '82', '1591325731', '0', 'order', null, null, null, '100', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('80', 'J6052628234538813789', '599.00', '0', '0', '82', '1591326357', '0', 'order', null, null, null, '102', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('81', 'J6052673718034127341', '599.00', '0', '0', '82', '1591326742', '0', 'order', null, null, null, '103', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('82', 'J6052695734730562457', '599.00', '0', '0', '82', '1591326961', '0', 'order', null, null, null, '105', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('83', 'J6052706976442180656', '599.00', '0', '0', '82', '1591327074', '0', 'order', null, null, null, '107', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('84', 'J6052717789702500336', '599.00', '0', '0', '82', '1591327182', '0', 'order', null, null, null, '110', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('85', 'J6052723177475915041', '599.00', '0', '0', '82', '1591327233', '0', 'order', null, null, null, '111', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('86', 'J6052723177475915041', '599.00', '0', '0', '82', '1591327234', '0', 'order', null, null, null, '111', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('87', 'J6052731937645192025', '1999.00', '0', '0', '82', '1591327345', '0', 'order', null, null, null, '112', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('88', 'J6052744193510203820', '599.00', '0', '0', '82', '1591327447', '0', 'order', null, null, null, '113', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('89', 'J6052748934212258631', '599.00', '0', '0', '82', '1591327522', '0', 'order', null, null, null, '114', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('90', 'J6052809188954542739', '599.00', '0', '0', '82', '1591328102', '0', 'order', null, null, null, '117', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('91', 'J6052809188954542739', '599.00', '0', '0', '82', '1591328102', '0', 'order', null, null, null, '117', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('92', 'J6052916615633183087', '599.00', '0', '0', '82', '1591329170', '0', 'order', null, null, null, '119', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('93', 'J6053127579286401066', '599.00', '0', '0', '82', '1591331278', '0', 'order', null, null, null, '120', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('94', 'J6053297168241153136', '599.00', '0', '0', '82', '1591332974', '0', 'order', null, null, null, '122', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('95', 'J6053315666450875995', '599.00', '0', '0', '82', '1591333159', '0', 'order', null, null, null, '123', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('96', 'J6053490938067726308', '4937.80', '0', '0', '82', '1591334911', '0', 'order', null, null, null, '125', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('97', 'J6053663476836742019', '599.00', '0', '0', '82', '1591336637', '0', 'order', null, null, null, '128', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('98', 'J6053684186307856120', '2342.00', '0', '0', '82', '1591336844', '0', 'order', null, null, null, '129', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('99', 'J6053684186307856120', '2342.00', '0', '0', '82', '1591336844', '0', 'order', null, null, null, '129', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('100', 'J6053776345066449363', '599.00', '0', '0', '82', '1591337765', '0', 'order', null, null, null, '130', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('101', 'J6054232709271408394', '599.00', '0', '0', '82', '1591342329', '0', 'order', null, null, null, '132', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('102', 'J6054318049737894940', '599.00', '0', '0', '82', '1591343185', '0', 'order', null, null, null, '137', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('103', 'J6054318049737894940', '599.00', '0', '0', '82', '1591343185', '0', 'order', null, null, null, '137', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('104', 'J6054338753642840177', '599.00', '0', '0', '82', '1591343390', '0', 'order', null, null, null, '138', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('105', 'J6054343813913845943', '599.00', '0', '0', '82', '1591343441', '0', 'order', null, null, null, '139', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('106', 'J6054345200629472192', '599.00', '0', '0', '82', '1591343461', '0', 'order', null, null, null, '140', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('107', 'J6054345200629472192', '599.00', '0', '0', '82', '1591343461', '0', 'order', null, null, null, '140', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('108', 'J6054345200629472192', '599.00', '0', '0', '82', '1591343464', '0', 'order', null, null, null, '140', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('109', 'J6054345200629472192', '599.00', '0', '0', '82', '1591343464', '0', 'order', null, null, null, '140', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('110', 'J6054345200629472192', '599.00', '0', '0', '82', '1591343465', '0', 'order', null, null, null, '140', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('111', 'J6054345200629472192', '599.00', '0', '0', '82', '1591343465', '0', 'order', null, null, null, '140', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('112', 'J6054345200629472192', '599.00', '0', '0', '82', '1591343466', '0', 'order', null, null, null, '140', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('113', 'J6054345200629472192', '599.00', '0', '0', '82', '1591343466', '0', 'order', null, null, null, '140', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('114', 'J6054345200629472192', '599.00', '0', '0', '82', '1591343466', '0', 'order', null, null, null, '140', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('115', 'J6054345200629472192', '599.00', '0', '0', '82', '1591343467', '0', 'order', null, null, null, '140', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('116', 'J6054349212888562053', '599.00', '0', '0', '82', '1591343494', '0', 'order', null, null, null, '141', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('117', 'J6054361179492192689', '1999.00', '0', '0', '82', '1591343613', '0', 'order', null, null, null, '142', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('118', 'J6054361179492192689', '1999.00', '0', '0', '82', '1591343614', '0', 'order', null, null, null, '142', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('119', 'J6054363097039420276', '599.00', '0', '0', '82', '1591343633', '0', 'order', null, null, null, '143', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('120', 'J6054386839098766240', '599.00', '0', '0', '82', '1591343873', '0', 'order', null, null, null, '145', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('121', 'J6054386839098766240', '599.00', '0', '0', '82', '1591343874', '0', 'order', null, null, null, '145', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('122', 'J6054386839098766240', '599.00', '0', '0', '82', '1591343876', '0', 'order', null, null, null, '145', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('123', 'J6054386839098766240', '599.00', '0', '0', '82', '1591343886', '0', 'order', null, null, null, '145', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('124', 'J6054386839098766240', '599.00', '0', '0', '82', '1591343886', '0', 'order', null, null, null, '145', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('125', 'J6054386839098766240', '599.00', '0', '0', '82', '1591343888', '0', 'order', null, null, null, '145', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('126', 'J6054386839098766240', '599.00', '0', '0', '82', '1591343898', '0', 'order', null, null, null, '145', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('127', 'J6054386839098766240', '599.00', '0', '0', '82', '1591343907', '0', 'order', null, null, null, '145', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('128', 'J6054392000795178858', '599.00', '0', '0', '82', '1591343922', '0', 'order', null, null, null, '146', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('129', 'J6054392000795178858', '599.00', '0', '0', '82', '1591343922', '0', 'order', null, null, null, '146', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('130', 'J6054392034250863978', '599.00', '0', '0', '82', '1591343939', '0', 'order', null, null, null, '147', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('131', 'J6054392034250863978', '599.00', '0', '0', '82', '1591343965', '0', 'order', null, null, null, '147', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('132', 'J6054401212483905790', '599.00', '0', '0', '82', '1591344014', '0', 'order', null, null, null, '148', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('133', 'J6054401212483905790', '599.00', '0', '0', '82', '1591344015', '0', 'order', null, null, null, '148', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('134', 'J6054401212483905790', '599.00', '0', '0', '82', '1591344016', '0', 'order', null, null, null, '148', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('135', 'J6054401212483905790', '599.00', '0', '0', '82', '1591344016', '0', 'order', null, null, null, '148', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('136', 'J6054401212483905790', '599.00', '0', '0', '82', '1591344016', '0', 'order', null, null, null, '148', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('137', 'J6054413532015505762', '599.00', '0', '0', '82', '1591344138', '0', 'order', null, null, null, '150', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('138', 'J6054425813199141392', '599.00', '0', '0', '82', '1591344259', '0', 'order', null, null, null, '152', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('139', 'J6054425813199141392', '599.00', '0', '0', '82', '1591344260', '0', 'order', null, null, null, '152', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('140', 'J6054471342653548061', '599.00', '0', '0', '82', '1591344717', '0', 'order', null, null, null, '154', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('141', 'J6055134585856607726', '599.00', '0', '0', '82', '1591351348', '0', 'order', null, null, null, '155', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('142', 'J6055134585856607726', '599.00', '0', '0', '82', '1591351348', '0', 'order', null, null, null, '155', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('143', 'J6055308780471348265', '599.00', '0', '0', '82', '1591353089', '0', 'order', null, null, null, '156', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('144', 'J6055323424777182777', '599.00', '0', '0', '82', '1591353237', '0', 'order', null, null, null, '157', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('145', 'J6055323424777182777', '599.00', '0', '0', '82', '1591353237', '0', 'order', null, null, null, '157', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('146', 'J6055364892283182475', '599.00', '0', '0', '82', '1591353653', '0', 'order', null, null, null, '161', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('147', 'J6055364892283182475', '599.00', '0', '0', '82', '1591353654', '0', 'order', null, null, null, '161', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('148', 'J6055369235915323035', '6595.10', '0', '0', '82', '1591353699', '0', 'order', null, null, null, '162', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('149', 'J6055386894664884505', '599.00', '0', '0', '82', '1591353872', '0', 'order', null, null, null, '163', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('150', 'J6056717579916592099', '599.00', '0', '0', '82', '1591367177', '0', 'order', null, null, null, '165', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('151', 'J6057224935557369991', '599.00', '0', '0', '82', '1591372253', '0', 'order', null, null, null, '166', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('152', 'J6057224935557369991', '599.00', '0', '0', '82', '1591372253', '0', 'order', null, null, null, '166', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('153', 'J6057228506768928298', '599.00', '0', '0', '82', '1591372288', '0', 'order', null, null, null, '169', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('154', 'J6069954726053305271', '599.00', '0', '0', '82', '1591399549', '0', 'order', null, null, null, '170', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('155', 'J6060253880068310851', '599.00', '0', '0', '82', '1591402541', '0', 'order', null, null, null, '171', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('156', 'J6060365122363967231', '599.00', '0', '0', '82', '1591403655', '0', 'order', null, null, null, '172', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('157', 'J6061208353360508998', '599.00', '0', '0', '82', '1591412085', '0', 'order', null, null, null, '173', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('158', 'J6063621480626119849', '599.00', '0', '0', '82', '1591436217', '0', 'order', null, null, null, '175', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('159', 'J6063904145886958745', '599.00', '0', '0', '82', '1591439043', '0', 'order', null, null, null, '176', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('160', 'J6063999422542526700', '2342.00', '0', '0', '82', '1591439997', '0', 'order', null, null, null, '177', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('161', 'J6064003860018619505', '36.70', '0', '0', '82', '1591440044', '0', 'order', null, null, null, '178', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('162', 'J6064189367620190669', '599.00', '0', '0', '82', '1591441895', '0', 'order', null, null, null, '179', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('163', 'J6064205291386492433', '599.00', '0', '0', '82', '1591442055', '0', 'order', null, null, null, '180', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('164', 'J6064209179661638069', '599.00', '0', '0', '82', '1591442093', '0', 'order', null, null, null, '181', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('165', 'J6064638813545631727', '599.00', '0', '0', '82', '1591446389', '0', 'order', null, null, null, '182', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('166', 'J6064638813545631727', '599.00', '0', '0', '82', '1591446390', '0', 'order', null, null, null, '182', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('167', 'J6065373739283267462', '599.00', '0', '0', '104', '1591453742', '0', 'order', null, null, null, '185', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('168', 'J6075926268493491964', '599.00', '0', '0', '104', '1591459265', '0', 'order', null, null, null, '187', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('169', 'J6073946423203369341', '599.00', '0', '0', '82', '1591539467', '0', 'order', null, null, null, '188', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('170', 'J6074166338099439082', '599.00', '0', '0', '82', '1591541683', '0', 'order', null, null, null, '190', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('171', 'J6084649632493710673', '599.00', '0', '0', '82', '1591546498', '0', 'order', null, null, null, '192', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('172', 'J6084652471850180282', '599.00', '0', '0', '82', '1591546533', '0', 'order', null, null, null, '193', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('173', 'J6084652471850180282', '599.00', '0', '0', '82', '1591546534', '0', 'order', null, null, null, '193', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('174', 'J6088058091170377651', '599.00', '0', '0', '82', '1591580584', '0', 'order', null, null, null, '194', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('175', 'J6089172176385602133', '599.00', '0', '0', '82', '1591591724', '0', 'order', null, null, null, '196', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('176', 'J6080565561442280139', '599.00', '0', '0', '82', '1591605657', '0', 'order', null, null, null, '197', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('177', 'J6098589689429661664', '0.10', '0', '0', '105', '1591685942', '0', 'order', null, null, null, '198', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('178', 'J6106931761250584015', '599.00', '0', '0', '104', '1591769320', '0', 'order', null, null, null, '199', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('179', 'J6108418666975721574', '599.00', '0', '0', '82', '1591784192', '0', 'order', null, null, null, '201', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('180', 'J6108421244802473291', '599.00', '0', '0', '82', '1591784793', '0', 'order', null, null, null, '203', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('181', 'J6108599125311555053', '599.00', '0', '0', '82', '1591785994', '0', 'order', null, null, null, '204', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('182', 'J6108678426453699839', '599.00', '0', '0', '82', '1591786960', '0', 'order', null, null, null, '205', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('183', 'J6108678426453699839', '599.00', '0', '0', '82', '1591786961', '0', 'order', null, null, null, '205', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('184', 'J6108746819901828957', '599.00', '0', '0', '82', '1591787471', '0', 'order', null, null, null, '206', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('185', 'J6108815083218295522', '599.00', '0', '0', '82', '1591788154', '0', 'order', null, null, null, '207', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('186', 'J6108969566263799772', '599.00', '0', '0', '82', '1591789703', '0', 'order', null, null, null, '208', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('187', 'J6108978209990936762', '599.00', '0', '0', '82', '1591789786', '0', 'order', null, null, null, '210', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('188', 'J6109055220425942476', '599.00', '0', '0', '82', '1591790556', '0', 'order', null, null, null, '212', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('189', 'J6109077851782601504', '599.00', '0', '0', '82', '1591790781', '0', 'order', null, null, null, '214', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('190', 'J6109105729877859268', '2342.00', '0', '0', '82', '1591791059', '0', 'order', null, null, null, '215', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('191', 'J6109118466994560055', '599.00', '0', '0', '82', '1591791187', '0', 'order', null, null, null, '217', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('192', 'J6109166732708586500', '577.00', '0', '0', '104', '1591791670', '0', 'order', null, null, null, '219', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('193', 'J6116912781480871977', '303805.00', '0', '0', '82', '1591869135', '0', 'order', null, null, null, '222', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('194', '1591892694360', '10.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('195', '1591892696150', '10.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('196', 'J6123107250743579905', '12.00', '0', '0', '109', '1591931092', '0', 'order', null, null, null, '223', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('197', 'J6123682342754851403', '24.00', '0', '0', '82', '1591936826', '0', 'order', null, null, null, '224', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('198', '1592015273430', '100.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('199', 'J6134724712540707188', '3007.00', '0', '0', '82', '1592047250', '0', 'order', null, null, null, '225', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('200', '1592053601420', '10.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('201', '1592053603270', '10.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('202', '1592053604460', '10.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('203', 'J6136243937859207786', '599.00', '0', '0', '82', '1592062442', '0', 'order', null, null, null, '226', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('204', '1592062496370', '500.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('205', 'J6146829596491707932', '1198.00', '0', '0', '82', '1592068313', '0', 'order', null, null, null, '228', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('206', 'J6146829596491707932', '1198.00', '0', '0', '82', '1592068349', '0', 'order', null, null, null, '228', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('207', 'J6146836316450984358', '599.00', '0', '0', '82', '1592068403', '0', 'order', null, null, null, '229', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('208', 'J6140796548895595155', '68.00', '0', '0', '111', '1592108017', '0', 'order', null, null, null, '230', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('209', '1592151377240', '500.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('210', '1592151379550', '500.00', '0', '0', '0', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('211', 'J6159320314261837577', '599.00', '0', '0', '104', '1592193212', '0', 'order', null, null, null, '231', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('212', 'J6159320314261837577', '599.00', '0', '0', '104', '1592193212', '0', 'order', null, null, null, '231', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('213', 'J6173638285382192872', '599.00', '0', '0', '104', '1592336397', '0', 'order', null, null, null, '234', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('214', 'J6188090694859286411', '2342.00', '0', '0', '104', '1592480909', '0', 'order', null, null, null, '256', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('215', 'J6188092438551418911', '2342.00', '0', '0', '104', '1592480926', '0', 'order', null, null, null, '257', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('216', 'J6240407634820921454', '0.10', '0', '0', '82', '1593005496', '0', 'order', null, null, null, '263', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('217', 'J6240407634820921454', '0.10', '0', '0', '82', '1593005830', '0', 'order', null, null, null, '263', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('218', 'J6258540637700714479', '0.10', '0', '0', '82', '1593085411', '0', 'order', null, null, null, '265', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('219', 'J6276359728600112886', '0.10', '0', '0', '82', '1593263600', '0', 'order', null, null, null, '269', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('220', '15932647591382', '2000.00', '0', '0', '82', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('221', '15932649064382', '1000.00', '0', '0', '82', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('222', '15932651985582', '50.00', '0', '0', '82', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('223', '15932652672782', '2000.00', '0', '0', '82', '0', '0', 'account', null, null, null, '0', '1', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('224', 'J6292082183060928839', '0.10', '0', '0', '82', '1593420824', '0', 'order', null, null, null, '271', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('225', 'J6293616331560161294', '0.10', '0', '0', '82', '1593436168', '0', 'order', null, null, null, '273', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('226', 'J6308785373660173776', '1999.00', '0', '0', '82', '1593487894', '0', 'order', null, null, null, '14', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('227', 'J6308785373660173776', '1949.00', '0', '0', '82', '1593487920', '0', 'order', null, null, null, '14', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('228', 'J6308785373660173776', '1899.00', '0', '0', '82', '1593487938', '0', 'order', null, null, null, '14', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('229', 'J6308785373660173776', '1849.00', '0', '0', '82', '1593488030', '0', 'order', null, null, null, '276', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('230', 'J6308812483860308395', '1999.00', '0', '0', '82', '1593488131', '0', 'order', null, null, null, '279', '2', '0', '0.00', '0.00', '0.00', '0.00', null);
INSERT INTO `yer_pay` VALUES ('231', 'J6308828119960832904', '5455.00', '0', '0', '82', '1593488286', '0', 'order', null, null, null, '280', '2', '0', '0.00', '0.00', '0.00', '0.00', null);

-- ----------------------------
-- Table structure for yer_reduction
-- ----------------------------
DROP TABLE IF EXISTS `yer_reduction`;
CREATE TABLE `yer_reduction` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `goods` varchar(225) DEFAULT NULL COMMENT '商品列表',
  `title` varchar(225) DEFAULT NULL COMMENT '名称',
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '广告图片',
  `total` decimal(50,2) NOT NULL DEFAULT '0.00' COMMENT '优惠金额',
  `total_money` decimal(50,2) NOT NULL DEFAULT '0.00' COMMENT '消费额',
  `start_time` int(10) NOT NULL DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '结束时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='满减优惠';

-- ----------------------------
-- Records of yer_reduction
-- ----------------------------
INSERT INTO `yer_reduction` VALUES ('9', '', '满2000减50', '395', '2000.00', '50.00', '1524673332', '1524846132');
INSERT INTO `yer_reduction` VALUES ('10', '201,202,203', '满68减50', '396', '68.00', '5.00', '1524672000', '1545926400');

-- ----------------------------
-- Table structure for yer_reply
-- ----------------------------
DROP TABLE IF EXISTS `yer_reply`;
CREATE TABLE `yer_reply` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `messageid` int(10) unsigned NOT NULL DEFAULT '0',
  `content` varchar(225) DEFAULT NULL COMMENT '回复内容',
  `status` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '默认null-未提交订单1-未读2-已读',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `group` varchar(225) DEFAULT NULL COMMENT '分组',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='回复表';

-- ----------------------------
-- Records of yer_reply
-- ----------------------------

-- ----------------------------
-- Table structure for yer_sales
-- ----------------------------
DROP TABLE IF EXISTS `yer_sales`;
CREATE TABLE `yer_sales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_time` int(10) NOT NULL DEFAULT '0',
  `specifications` varchar(225) CHARACTER SET utf8 DEFAULT NULL,
  `uid` int(10) NOT NULL DEFAULT '0',
  `title` varchar(225) CHARACTER SET utf8 DEFAULT NULL,
  `order_sn` varchar(225) CHARACTER SET utf8 DEFAULT NULL,
  `goods_id` int(10) NOT NULL DEFAULT '0',
  `is_hide` int(10) NOT NULL DEFAULT '0',
  `total` decimal(50,2) NOT NULL DEFAULT '0.00',
  `num` int(10) NOT NULL DEFAULT '0',
  `price` decimal(50,2) NOT NULL DEFAULT '0.00',
  `sku_id` int(10) NOT NULL DEFAULT '0',
  `is_picture` int(10) NOT NULL DEFAULT '0',
  `path` varchar(225) DEFAULT NULL,
  `comment_status` int(10) NOT NULL DEFAULT '0',
  `spress` varchar(255) DEFAULT NULL,
  `status` tinyint(2) NOT NULL DEFAULT '0',
  `type` int(10) NOT NULL DEFAULT '0',
  `reduction_id` int(10) NOT NULL DEFAULT '0',
  `cost` decimal(50,2) NOT NULL DEFAULT '0.00' COMMENT '成本',
  `profit` decimal(50,2) NOT NULL DEFAULT '0.00' COMMENT '利润',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=420 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC COMMENT='销售表';

-- ----------------------------
-- Records of yer_sales
-- ----------------------------

-- ----------------------------
-- Table structure for yer_score_code
-- ----------------------------
DROP TABLE IF EXISTS `yer_score_code`;
CREATE TABLE `yer_score_code` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `code` varchar(255) DEFAULT NULL COMMENT '兑换码',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态',
  `orderId` varchar(255) DEFAULT NULL COMMENT '订单号',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后更新时间',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '积分类型',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='积分兑换码表';

-- ----------------------------
-- Records of yer_score_code
-- ----------------------------
INSERT INTO `yer_score_code` VALUES ('1', 'xdkjkkjksdfr324342', '2', '', '1575880833', '0', '3');

-- ----------------------------
-- Table structure for yer_score_goods
-- ----------------------------
DROP TABLE IF EXISTS `yer_score_goods`;
CREATE TABLE `yer_score_goods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `title` varchar(255) DEFAULT NULL COMMENT '商品名称',
  `num` varchar(255) DEFAULT NULL COMMENT '积分数量',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态',
  `tpl` varchar(255) DEFAULT NULL COMMENT '模板名称',
  `type` tinyint(2) DEFAULT '0' COMMENT '商品类型',
  `type_id` tinyint(2) DEFAULT '0' COMMENT '积分类型id',
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '封面图片',
  `content` text NOT NULL COMMENT '详情',
  `sku` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='积分商品表';

-- ----------------------------
-- Records of yer_score_goods
-- ----------------------------
INSERT INTO `yer_score_goods` VALUES ('1', '洁柔Face百花香味135抽3层抽取式纸面巾JR069-01(3包装)', '30000', '1', '', '0', '1', '536', '<img src=\"https://m.jf.10010.com/cms/jf-res/gdesc/ed55af40-213f-44b3-8d38-6e7ec1eff635.jpg\" />', '1000');
INSERT INTO `yer_score_goods` VALUES ('2', '小马宝莉48粒拼图-丰收的喜悦', '4200', '1', 'add', '0', '1', '535', '<img src=\"https://m.jf.10010.com/cms/jf-res/gdesc/cc4293a2-d227-4721-aa7c-d40783ec614f.jpg\" />', '1000');
INSERT INTO `yer_score_goods` VALUES ('3', '腾讯视频VIP会员月卡', '1800', '1', 'film', '0', '3', '534', '<img src=\"https://m.jf.10010.com/cms/jf-res/gdesc/bfbf6d36-37da-408f-b7a6-551d422db98d.jpg\" />', '1000');

-- ----------------------------
-- Table structure for yer_score_log
-- ----------------------------
DROP TABLE IF EXISTS `yer_score_log`;
CREATE TABLE `yer_score_log` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id,自增主键',
  `score` varchar(255) DEFAULT NULL COMMENT '积分值',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '类型1+,0-',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `total` varchar(255) DEFAULT NULL COMMENT '剩余积分',
  `content` varchar(225) DEFAULT NULL COMMENT '详细说明',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=90 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='积分变化表';

-- ----------------------------
-- Records of yer_score_log
-- ----------------------------
INSERT INTO `yer_score_log` VALUES ('47', '4200', '70', '0', '1575876861', '874580', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('48', '4200', '70', '0', '1575877071', '870380', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('49', '1800', '82', '0', '1575880413', '868580', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('50', '1800', '82', '0', '1590033503', '8200', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('51', '30000', '104', '0', '1592316532', '570000', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('52', '1800', '104', '0', '1592316619', '568200', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('53', '1800', '104', '0', '1592316983', '566400', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('54', '1800', '104', '0', '1592316983', '566400', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('55', '1800', '104', '0', '1592316983', '564600', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('56', '1800', '104', '0', '1592316983', '562800', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('57', '1800', '104', '0', '1592316983', '562800', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('58', '1800', '104', '0', '1592316984', '562800', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('59', '1800', '104', '0', '1592316984', '561000', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('60', '1800', '104', '0', '1592316985', '559200', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('61', '1800', '104', '0', '1592316985', '557400', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('62', '1800', '104', '0', '1592319096', '555600', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('63', '1800', '104', '0', '1592319097', '553800', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('64', '1800', '104', '0', '1592319097', '552000', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('65', '1800', '104', '0', '1592319097', '552000', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('66', '1800', '104', '0', '1592319097', '550200', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('67', '1800', '104', '0', '1592319097', '550200', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('68', '1800', '104', '0', '1592319098', '548400', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('69', '1800', '104', '0', '1592319098', '546600', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('70', '4200', '104', '0', '1592322582', '542400', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('71', '30000', '104', '0', '1592323284', '512400', '积分兑换商品');
INSERT INTO `yer_score_log` VALUES ('73', '10', '82', '1', '1593011973', '20', '登录赠送积分');
INSERT INTO `yer_score_log` VALUES ('74', '10', '82', '1', '1593064809', '30', '登录赠送积分');
INSERT INTO `yer_score_log` VALUES ('75', '10', '82', '1', '1593132098', '40', '登录赠送积分');
INSERT INTO `yer_score_log` VALUES ('76', '10', '82', '1', '1593229090', '50', '登录赠送积分');
INSERT INTO `yer_score_log` VALUES ('77', '10', '82', '1', '1593309310', '60', '登录赠送积分');
INSERT INTO `yer_score_log` VALUES ('78', '10', '82', '1', '1593401956', '70', '登录赠送积分');
INSERT INTO `yer_score_log` VALUES ('79', '2', '82', '1', '1593485326', '72', '登录赠送积分');
INSERT INTO `yer_score_log` VALUES ('87', '2', '82', '1', '1593572212', '85', '登录赠送积分');
INSERT INTO `yer_score_log` VALUES ('86', '1', '82', '2', '1593566926', '83', '签到赠送');
INSERT INTO `yer_score_log` VALUES ('88', '2', '82', '1', '1593684983', '87', '登录赠送积分');
INSERT INTO `yer_score_log` VALUES ('89', '3', '82', '2', '1593685303', '90', '签到赠送');

-- ----------------------------
-- Table structure for yer_score_order
-- ----------------------------
DROP TABLE IF EXISTS `yer_score_order`;
CREATE TABLE `yer_score_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `orderId` varchar(255) DEFAULT NULL COMMENT '订单号',
  `score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '积分',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '状态',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后更新时间',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `express` varchar(225) DEFAULT NULL COMMENT '快递名称',
  `express_code` varchar(225) DEFAULT NULL COMMENT '快递单号',
  `username` varchar(225) DEFAULT NULL COMMENT '用户名',
  `mobile` varchar(225) DEFAULT NULL COMMENT '联系方式',
  `address` varchar(225) DEFAULT NULL COMMENT '地址',
  `code` varchar(225) DEFAULT NULL COMMENT '兑换码',
  `type_id` varchar(225) DEFAULT NULL COMMENT '积分类型id',
  `title` varchar(255) DEFAULT NULL COMMENT '商品名称',
  `goods_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='积分兑换表';

-- ----------------------------
-- Records of yer_score_order
-- ----------------------------
INSERT INTO `yer_score_order` VALUES ('1', '20191209157587686170', '4200', '1575876861', '0', '0', '70', '顺丰速递', null, 'e5345', '34534', '3453453', null, '1', '小马宝莉48粒拼图-丰收的喜悦', '0');
INSERT INTO `yer_score_order` VALUES ('2', '20191209157587707170', '4200', '1575877071', '0', '0', '70', '顺丰速递', null, 'e5345', '34534', '3453453', null, '1', '小马宝莉48粒拼图-丰收的喜悦', '0');
INSERT INTO `yer_score_order` VALUES ('3', '20191209157588041370', '1800', '1575880413', '1', '1575880833', '70', '', 'xdkjkkjksdfr324342', '', '', '', 'xdkjkkjksdfr324342', '3', '腾讯视频VIP会员月卡', '0');
INSERT INTO `yer_score_order` VALUES ('4', null, '1800', '1590033503', '0', '0', '82', '', null, '', '', '', null, '3', '腾讯视频VIP会员月卡', '0');
INSERT INTO `yer_score_order` VALUES ('5', null, '30000', '1592316532', '0', '0', '104', '', null, '', '', '', null, '1', '洁柔Face百花香味135抽3层抽取式纸面巾JR069-01(3包装)', '0');
INSERT INTO `yer_score_order` VALUES ('6', null, '1800', '1592316619', '0', '0', '104', '', null, '', '', '', null, '3', '腾讯视频VIP会员月卡', '0');
INSERT INTO `yer_score_order` VALUES ('7', 'J6161698300165446123', '1800', '1592316983', '0', '0', '104', '', null, '', '', '', null, '3', '腾讯视频VIP会员月卡', '0');
INSERT INTO `yer_score_order` VALUES ('8', 'J6161698300935634051', '1800', '1592316983', '0', '0', '104', '', null, '', '', '', null, '3', '腾讯视频VIP会员月卡', '0');
INSERT INTO `yer_score_order` VALUES ('9', 'J6161698347029953204', '1800', '1592316983', '0', '0', '104', '', null, '', '', '', null, '3', '腾讯视频VIP会员月卡', '0');
INSERT INTO `yer_score_order` VALUES ('10', 'J6161698391527369698', '1800', '1592316983', '0', '0', '104', '', null, '', '', '', null, '3', '腾讯视频VIP会员月卡', '0');
INSERT INTO `yer_score_order` VALUES ('11', 'J6161698392013131125', '1800', '1592316983', '0', '0', '104', '', null, '', '', '', null, '3', '腾讯视频VIP会员月卡', '0');
INSERT INTO `yer_score_order` VALUES ('12', 'J6161698394771130150', '1800', '1592316983', '0', '0', '104', '', null, '', '', '', null, '3', '腾讯视频VIP会员月卡', '0');
INSERT INTO `yer_score_order` VALUES ('13', 'J6161698459771960270', '1800', '1592316984', '0', '0', '104', '', null, '', '', '', null, '3', '腾讯视频VIP会员月卡', '0');
INSERT INTO `yer_score_order` VALUES ('14', 'J6161698511167563474', '1800', '1592316985', '0', '0', '104', '', null, '', '', '', null, '3', '腾讯视频VIP会员月卡', '0');
INSERT INTO `yer_score_order` VALUES ('15', 'J6161698540212136616', '1800', '1592316985', '0', '0', '104', '', null, '', '', '', null, '3', '腾讯视频VIP会员月卡', '0');
INSERT INTO `yer_score_order` VALUES ('16', 'J6161909675853723564', '1800', '1592319096', '0', '0', '104', '', null, '', '', '', null, '3', '腾讯视频VIP会员月卡', '3');
INSERT INTO `yer_score_order` VALUES ('17', 'J6161909704782617322', '1800', '1592319097', '0', '0', '104', '', null, '', '', '', null, '3', '腾讯视频VIP会员月卡', '3');
INSERT INTO `yer_score_order` VALUES ('18', 'J6161909733912929397', '1800', '1592319097', '0', '0', '104', '', null, '', '', '', null, '3', '腾讯视频VIP会员月卡', '3');
INSERT INTO `yer_score_order` VALUES ('19', 'J6161909735056753321', '1800', '1592319097', '0', '0', '104', '', null, '', '', '', null, '3', '腾讯视频VIP会员月卡', '3');
INSERT INTO `yer_score_order` VALUES ('20', 'J6161909786354853555', '1800', '1592319097', '0', '0', '104', '', null, '', '', '', null, '3', '腾讯视频VIP会员月卡', '3');
INSERT INTO `yer_score_order` VALUES ('21', 'J6161909789541256292', '1800', '1592319097', '0', '0', '104', '', null, '', '', '', null, '3', '腾讯视频VIP会员月卡', '3');
INSERT INTO `yer_score_order` VALUES ('22', 'J6161909839427927130', '1800', '1592319098', '0', '0', '104', '', null, '', '', '', null, '3', '腾讯视频VIP会员月卡', '3');
INSERT INTO `yer_score_order` VALUES ('23', 'J6161909863657119984', '1800', '1592319098', '0', '0', '104', '', null, '', '', '', null, '3', '腾讯视频VIP会员月卡', '3');
INSERT INTO `yer_score_order` VALUES ('24', 'J6162258263746565883', '4200', '1592322582', '0', '0', '104', '', null, '', '', '', null, '1', '小马宝莉48粒拼图-丰收的喜悦', '2');
INSERT INTO `yer_score_order` VALUES ('25', 'J6172328462562538217', '30000', '1592323284', '0', '0', '104', '', null, '', '', '', null, '1', '洁柔Face百花香味135抽3层抽取式纸面巾JR069-01(3包装)', '1');

-- ----------------------------
-- Table structure for yer_score_type
-- ----------------------------
DROP TABLE IF EXISTS `yer_score_type`;
CREATE TABLE `yer_score_type` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `title` varchar(255) DEFAULT NULL COMMENT '供应商名称',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态',
  `tpl` varchar(255) DEFAULT NULL COMMENT '模板名称',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='积分类型表';

-- ----------------------------
-- Records of yer_score_type
-- ----------------------------
INSERT INTO `yer_score_type` VALUES ('1', '生活家居', '1', 'scoregoods/edit');
INSERT INTO `yer_score_type` VALUES ('3', 'vip会员', '1', '');
INSERT INTO `yer_score_type` VALUES ('4', '购物卡', '1', '');
INSERT INTO `yer_score_type` VALUES ('5', '话费卡', '1', '');

-- ----------------------------
-- Table structure for yer_service
-- ----------------------------
DROP TABLE IF EXISTS `yer_service`;
CREATE TABLE `yer_service` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(225) DEFAULT NULL,
  `content` varchar(225) DEFAULT NULL,
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `assistant` int(10) unsigned NOT NULL DEFAULT '0',
  `reply` varchar(225) DEFAULT NULL,
  `type` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='售后服务表';

-- ----------------------------
-- Records of yer_service
-- ----------------------------

-- ----------------------------
-- Table structure for yer_sku
-- ----------------------------
DROP TABLE IF EXISTS `yer_sku`;
CREATE TABLE `yer_sku` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(225) DEFAULT NULL COMMENT '规格名称',
  `goods_id` int(11) NOT NULL DEFAULT '0' COMMENT '商品id',
  `cost` decimal(50,2) NOT NULL DEFAULT '0.00' COMMENT '成本价',
  `price` decimal(50,2) NOT NULL DEFAULT '0.00' COMMENT '销售价',
  `create_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `sales` int(1) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `hits` int(11) NOT NULL DEFAULT '0',
  `path` varchar(64) DEFAULT '',
  `attributes` text,
  `num` int(10) NOT NULL DEFAULT '999999',
  `cover_id` int(10) NOT NULL DEFAULT '0',
  `mprice` int(10) NOT NULL DEFAULT '0',
  `j_price` decimal(50,2) NOT NULL DEFAULT '0.00',
  `profit` decimal(50,2) NOT NULL DEFAULT '0.00' COMMENT '利润',
  `number` int(10) NOT NULL DEFAULT '0' COMMENT '库存编号',
  `upc` varchar(225) DEFAULT NULL,
  `code` varchar(225) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL COMMENT '商品名称',
  `cut` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=384 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of yer_sku
-- ----------------------------
INSERT INTO `yer_sku` VALUES ('220', '无', '168', '18.00', '99.00', '0000-00-00 00:00:00', '0', '1', '0', '168', '', '10', '0', '0', '0.00', '102.00', '0', '', '', '费列罗榛果威化巧克力零食30粒 休闲零食香浓美味', null);
INSERT INTO `yer_sku` VALUES ('218', '无', '166', '6.00', '30.00', '0000-00-00 00:00:00', '0', '1', '0', '166', '', '23', '0', '0', '0.00', '191.00', '0', '', '', '费列罗巧克力零食48粒 3*16条 休闲零食 香浓美味', null);
INSERT INTO `yer_sku` VALUES ('219', '无', '167', '12.00', '34.00', '0000-00-00 00:00:00', '0', '1', '0', '167', '', '333', '0', '0', '0.00', '195.00', '0', '', '', '德芙巧克力礼盒 香浓黑巧252g碗装 新老包装随机发货', null);
INSERT INTO `yer_sku` VALUES ('217', '无', '165', '24.00', '8.90', '0000-00-00 00:00:00', '0', '1', '0', '165', '', '234', '0', '0', '0.00', '159.00', '0', '', '', '新农哥五香花生136g 坚果炒货小吃', null);
INSERT INTO `yer_sku` VALUES ('216', '无', '164', '15.00', '20.00', '0000-00-00 00:00:00', '0', '1', '0', '164', '', '122', '0', '0', '0.00', '107.00', '0', '', '', '泰国龙眼1kg 热带桂圆 进口水果', null);
INSERT INTO `yer_sku` VALUES ('215', '无', '163', '11.00', '24.00', '0000-00-00 00:00:00', '0', '1', '0', '163', '', '664', '0', '0', '0.00', '192.00', '0', '', '', '陕西精品红富士1kg 80-85mm 苹果 水果', null);
INSERT INTO `yer_sku` VALUES ('214', '无', '162', '25.00', '0.10', '0000-00-00 00:00:00', '0', '1', '0', '162', '', '100', '0', '0', '0.00', '158.00', '0', '', '', '澳大利亚晚季脐橙10个140g以上/个橙子水果', null);
INSERT INTO `yer_sku` VALUES ('221', '无', '169', '42.00', '77.00', '0000-00-00 00:00:00', '0', '1', '0', '169', '', '77', '0', '0', '0.00', '124.00', '0', '', '', '良品铺子猪肉脯100g芝麻味自然片猪肉干零食小吃特产休闲食品', null);
INSERT INTO `yer_sku` VALUES ('233', '3G、64G', '170', '46.00', '7464.00', '0000-00-00 00:00:00', '0', '1', '0', '75,89', '', '76', '0', '0', '0.00', '137.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ', null);
INSERT INTO `yer_sku` VALUES ('232', '3G、32G', '170', '49.00', '6479.00', '0000-00-00 00:00:00', '0', '1', '0', '75,88', '', '47', '0', '0', '0.00', '128.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ', null);
INSERT INTO `yer_sku` VALUES ('231', '3G、16G', '170', '45.00', '6456.00', '0000-00-00 00:00:00', '0', '1', '0', '75,87', '', '56', '0', '0', '0.00', '114.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ', null);
INSERT INTO `yer_sku` VALUES ('230', '2G、64G', '170', '26.00', '5654.00', '0000-00-00 00:00:00', '0', '1', '0', '74,89', '', '34', '0', '0', '0.00', '108.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ', null);
INSERT INTO `yer_sku` VALUES ('229', '2G、32G', '170', '32.00', '5654.00', '0000-00-00 00:00:00', '0', '1', '0', '74,88', '', '98', '0', '0', '0.00', '159.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ', null);
INSERT INTO `yer_sku` VALUES ('228', '2G、16G', '170', '49.00', '5488.00', '0000-00-00 00:00:00', '0', '1', '0', '74,87', '', '10', '0', '0', '0.00', '180.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ', null);
INSERT INTO `yer_sku` VALUES ('234', '2G、16G', '171', '10.00', '5675.00', '0000-00-00 00:00:00', '0', '1', '0', '74,87', '', '5638', '0', '0', '0.00', '121.00', '0', '', '', '华为honor/荣耀 畅玩7X全网通全面屏官方手机', null);
INSERT INTO `yer_sku` VALUES ('235', '2G、32G', '171', '28.00', '65567.00', '0000-00-00 00:00:00', '0', '1', '0', '74,88', '', '5676', '0', '0', '0.00', '170.00', '0', '', '', '华为honor/荣耀 畅玩7X全网通全面屏官方手机', null);
INSERT INTO `yer_sku` VALUES ('236', '2G、64G', '171', '30.00', '5467.00', '0000-00-00 00:00:00', '0', '1', '0', '74,89', '', '56765', '0', '0', '0.00', '131.00', '0', '', '', '华为honor/荣耀 畅玩7X全网通全面屏官方手机', null);
INSERT INTO `yer_sku` VALUES ('237', '4G、16G', '171', '18.00', '56765.00', '0000-00-00 00:00:00', '0', '1', '0', '76,87', '', '5675', '0', '0', '0.00', '142.00', '0', '', '', '华为honor/荣耀 畅玩7X全网通全面屏官方手机', null);
INSERT INTO `yer_sku` VALUES ('238', '4G、32G', '171', '21.00', '56765.00', '0000-00-00 00:00:00', '0', '1', '0', '76,88', '', '56765', '0', '0', '0.00', '131.00', '0', '', '', '华为honor/荣耀 畅玩7X全网通全面屏官方手机', null);
INSERT INTO `yer_sku` VALUES ('239', '4G、64G', '171', '32.00', '567657.00', '0000-00-00 00:00:00', '0', '1', '0', '76,89', '', '56765', '0', '0', '0.00', '161.00', '0', '', '', '华为honor/荣耀 畅玩7X全网通全面屏官方手机', null);
INSERT INTO `yer_sku` VALUES ('240', '2G、16G', '172', '15.00', '5460.00', '0000-00-00 00:00:00', '0', '1', '0', '74,87', '', '50', '0', '0', '0.00', '101.00', '0', '', '', 'Xiaomi/小米 红米手机4A 超长待机双卡智能手机', null);
INSERT INTO `yer_sku` VALUES ('241', '3G、16G', '172', '42.00', '4560.00', '0000-00-00 00:00:00', '0', '1', '0', '75,87', '', '40', '0', '0', '0.00', '118.00', '0', '', '', 'Xiaomi/小米 红米手机4A 超长待机双卡智能手机', null);
INSERT INTO `yer_sku` VALUES ('242', '4G、16G', '172', '47.00', '4560.00', '0000-00-00 00:00:00', '0', '1', '0', '76,87', '', '50', '0', '0', '0.00', '158.00', '0', '', '', 'Xiaomi/小米 红米手机4A 超长待机双卡智能手机', null);
INSERT INTO `yer_sku` VALUES ('243', '6G、16G', '172', '28.00', '5564.00', '0000-00-00 00:00:00', '0', '1', '0', '77,87', '', '45', '0', '0', '0.00', '121.00', '0', '', '', 'Xiaomi/小米 红米手机4A 超长待机双卡智能手机', null);
INSERT INTO `yer_sku` VALUES ('244', '4G、16G', '173', '39.00', '3056.00', '0000-00-00 00:00:00', '0', '1', '0', '76,87', '', '345', '0', '0', '0.00', '175.00', '0', '', '', 'Huawei/华为 Mate 10 4G+64G年度旗舰手机', null);
INSERT INTO `yer_sku` VALUES ('245', '4G、32G', '173', '47.00', '3453.00', '0000-00-00 00:00:00', '0', '1', '0', '76,88', '', '345', '0', '0', '0.00', '121.00', '0', '', '', 'Huawei/华为 Mate 10 4G+64G年度旗舰手机', null);
INSERT INTO `yer_sku` VALUES ('246', '4G、64G', '173', '47.00', '5475.00', '0000-00-00 00:00:00', '0', '1', '0', '76,89', '', '4564', '0', '0', '0.00', '124.00', '0', '', '', 'Huawei/华为 Mate 10 4G+64G年度旗舰手机', null);
INSERT INTO `yer_sku` VALUES ('247', '2G、16G', '174', '41.00', '3455.00', '0000-00-00 00:00:00', '0', '1', '0', '74,87', '', '345', '0', '0', '0.00', '194.00', '0', '', '', 'OPPO R11S全面屏拍照4G手机oppor11s', null);
INSERT INTO `yer_sku` VALUES ('248', '2G、32G', '174', '40.00', '3454.00', '0000-00-00 00:00:00', '0', '1', '0', '74,88', '', '34535', '0', '0', '0.00', '154.00', '0', '', '', 'OPPO R11S全面屏拍照4G手机oppor11s', null);
INSERT INTO `yer_sku` VALUES ('249', '2G、64G', '174', '33.00', '34543.00', '0000-00-00 00:00:00', '0', '1', '0', '74,89', '', '3', '0', '0', '0.00', '117.00', '0', '', '', 'OPPO R11S全面屏拍照4G手机oppor11s', null);
INSERT INTO `yer_sku` VALUES ('250', '红色、x', '175', '38.00', '435.00', '0000-00-00 00:00:00', '0', '1', '0', '63,66', '', '546', '0', '0', '0.00', '136.00', '0', '', '', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ', null);
INSERT INTO `yer_sku` VALUES ('251', '红色、xl', '175', '41.00', '4564.00', '0000-00-00 00:00:00', '0', '1', '0', '63,67', '', '456', '0', '0', '0.00', '174.00', '0', '', '', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ', null);
INSERT INTO `yer_sku` VALUES ('252', '红色、xxl', '175', '23.00', '4564.00', '0000-00-00 00:00:00', '0', '1', '0', '63,68', '', '456', '0', '0', '0.00', '132.00', '0', '', '', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ', null);
INSERT INTO `yer_sku` VALUES ('253', '蓝色、x', '175', '9.00', '546.00', '0000-00-00 00:00:00', '0', '1', '0', '64,66', '', '546', '0', '0', '0.00', '160.00', '0', '', '', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ', null);
INSERT INTO `yer_sku` VALUES ('254', '蓝色、xl', '175', '33.00', '5465.00', '0000-00-00 00:00:00', '0', '1', '0', '64,67', '', '546', '0', '0', '0.00', '143.00', '0', '', '', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ', null);
INSERT INTO `yer_sku` VALUES ('255', '蓝色、xxl', '175', '29.00', '456.00', '0000-00-00 00:00:00', '0', '1', '0', '64,68', '', '4565', '0', '0', '0.00', '138.00', '0', '', '', 'GXG男装冬季保暖中长款连帽羽绒服外套男174811205 ', null);
INSERT INTO `yer_sku` VALUES ('256', '红色、xl', '176', '36.00', '567.00', '0000-00-00 00:00:00', '0', '1', '0', '63,67', '', '678', '0', '0', '0.00', '144.00', '0', '', '', '冬季新款中长款纯色加厚棉袄棉服保暖外套 ', null);
INSERT INTO `yer_sku` VALUES ('257', '红色、xxl', '176', '35.00', '6576.00', '0000-00-00 00:00:00', '0', '1', '0', '63,68', '', '7897', '0', '0', '0.00', '111.00', '0', '', '', '冬季新款中长款纯色加厚棉袄棉服保暖外套 ', null);
INSERT INTO `yer_sku` VALUES ('258', '白色、xl', '176', '19.00', '78987.00', '0000-00-00 00:00:00', '0', '1', '0', '69,67', '', '789', '0', '0', '0.00', '144.00', '0', '', '', '冬季新款中长款纯色加厚棉袄棉服保暖外套 ', null);
INSERT INTO `yer_sku` VALUES ('259', '白色、xxl', '176', '37.00', '7897.00', '0000-00-00 00:00:00', '0', '1', '0', '69,68', '', '7897', '0', '0', '0.00', '166.00', '0', '', '', '冬季新款中长款纯色加厚棉袄棉服保暖外套 ', null);
INSERT INTO `yer_sku` VALUES ('260', '黑、官方标配', '177', '41.00', '456.00', '0000-00-00 00:00:00', '0', '1', '0', '91,95', '', '456', '0', '0', '0.00', '102.00', '0', '', '', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', null);
INSERT INTO `yer_sku` VALUES ('261', '黑、套餐1', '177', '27.00', '456.00', '0000-00-00 00:00:00', '0', '1', '0', '91,96', '', '456', '0', '0', '0.00', '198.00', '0', '', '', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', null);
INSERT INTO `yer_sku` VALUES ('262', '黑、套餐2', '177', '31.00', '456.00', '0000-00-00 00:00:00', '0', '1', '0', '91,97', '', '456', '0', '0', '0.00', '180.00', '0', '', '', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', null);
INSERT INTO `yer_sku` VALUES ('263', '白、官方标配', '177', '43.00', '456.00', '0000-00-00 00:00:00', '0', '1', '0', '92,95', '', '456', '0', '0', '0.00', '121.00', '0', '', '', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', null);
INSERT INTO `yer_sku` VALUES ('264', '白、套餐1', '177', '45.00', '4565.00', '0000-00-00 00:00:00', '0', '1', '0', '92,96', '', '456', '0', '0', '0.00', '117.00', '0', '', '', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', null);
INSERT INTO `yer_sku` VALUES ('265', '白、套餐2', '177', '26.00', '45645.00', '0000-00-00 00:00:00', '0', '1', '0', '92,97', '', '45654', '0', '0', '0.00', '153.00', '0', '', '', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', null);
INSERT INTO `yer_sku` VALUES ('266', '金、官方标配', '177', '49.00', '45654.00', '0000-00-00 00:00:00', '0', '1', '0', '93,95', '', '456', '0', '0', '0.00', '118.00', '0', '', '', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', null);
INSERT INTO `yer_sku` VALUES ('267', '金、套餐1', '177', '11.00', '45654.00', '0000-00-00 00:00:00', '0', '1', '0', '93,96', '', '456', '0', '0', '0.00', '170.00', '0', '', '', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', null);
INSERT INTO `yer_sku` VALUES ('268', '金、套餐2', '177', '35.00', '4564.00', '0000-00-00 00:00:00', '0', '1', '0', '93,97', '', '4565', '0', '0', '0.00', '175.00', '0', '', '', 'HP/惠普 PAVILION -14 畅游人笔记本电脑超薄 轻薄便携 商务办公', null);
INSERT INTO `yer_sku` VALUES ('269', '无', '178', '15.00', '39.90', '0000-00-00 00:00:00', '0', '1', '0', '178', '', '100', '0', '0', '0.00', '143.00', '0', '', '', 'OPPO耳机原装正品全球限量版', null);
INSERT INTO `yer_sku` VALUES ('274', '黑、官方标配、2g', '179', '8.00', '3456.00', '0000-00-00 00:00:00', '0', '1', '0', '91,95,102', '', '654', '0', '0', '0.00', '164.00', '0', '', '', 'HP/惠普 暗影精灵 光影精灵3代游戏本', null);
INSERT INTO `yer_sku` VALUES ('273', '黑、官方标配、1g', '179', '31.00', '5465.00', '0000-00-00 00:00:00', '0', '1', '0', '91,95,101', '', '545', '0', '0', '0.00', '176.00', '0', '', '', 'HP/惠普 暗影精灵 光影精灵3代游戏本', null);
INSERT INTO `yer_sku` VALUES ('275', '黑、套餐1、1g', '179', '24.00', '5456.00', '0000-00-00 00:00:00', '0', '1', '0', '91,96,101', '', '645', '0', '0', '0.00', '135.00', '0', '', '', 'HP/惠普 暗影精灵 光影精灵3代游戏本', null);
INSERT INTO `yer_sku` VALUES ('276', '黑、套餐1、2g', '179', '49.00', '4456.00', '0000-00-00 00:00:00', '0', '1', '0', '91,96,102', '', '645', '0', '0', '0.00', '154.00', '0', '', '', 'HP/惠普 暗影精灵 光影精灵3代游戏本', null);
INSERT INTO `yer_sku` VALUES ('277', '白、官方标配、1g', '179', '16.00', '4456.00', '0000-00-00 00:00:00', '0', '1', '0', '92,95,101', '', '645', '0', '0', '0.00', '163.00', '0', '', '', 'HP/惠普 暗影精灵 光影精灵3代游戏本', null);
INSERT INTO `yer_sku` VALUES ('278', '白、官方标配、2g', '179', '29.00', '6456.00', '0000-00-00 00:00:00', '0', '1', '0', '92,95,102', '', '54', '0', '0', '0.00', '121.00', '0', '', '', 'HP/惠普 暗影精灵 光影精灵3代游戏本', null);
INSERT INTO `yer_sku` VALUES ('279', '白、套餐1、1g', '179', '35.00', '7456.00', '0000-00-00 00:00:00', '0', '1', '0', '92,96,101', '', '456', '0', '0', '0.00', '139.00', '0', '', '', 'HP/惠普 暗影精灵 光影精灵3代游戏本', null);
INSERT INTO `yer_sku` VALUES ('280', '白、套餐1、2g', '179', '42.00', '84564.00', '0000-00-00 00:00:00', '0', '1', '0', '92,96,102', '', '456', '0', '0', '0.00', '151.00', '0', '', '', 'HP/惠普 暗影精灵 光影精灵3代游戏本', null);
INSERT INTO `yer_sku` VALUES ('281', '无', '180', '32.00', '34.00', '0000-00-00 00:00:00', '0', '1', '0', '180', '', '122', '0', '0', '0.00', '164.00', '0', '', '', 'ZARA 男装 黑色热封短版连帽夹克外套 棉衣01966330800', null);
INSERT INTO `yer_sku` VALUES ('282', '无', '181', '38.00', '223.00', '0000-00-00 00:00:00', '0', '1', '0', '181', '', '23', '0', '0', '0.00', '124.00', '0', '', '', 'ZARA 新品 男装 细针美丽诺针织衫 00693300500', null);
INSERT INTO `yer_sku` VALUES ('283', '无', '182', '35.00', '233.00', '0000-00-00 00:00:00', '0', '1', '0', '182', '', '123', '0', '0', '0.00', '133.00', '0', '', '', 'ZARA 男装 绒面质感裤子 06706310707', null);
INSERT INTO `yer_sku` VALUES ('284', '无', '183', '12.00', '234.00', '0000-00-00 00:00:00', '0', '1', '0', '183', '', '234', '0', '0', '0.00', '150.00', '0', '', '', 'PUMA彪马男鞋女鞋2017秋季SUEDE', null);
INSERT INTO `yer_sku` VALUES ('285', '蓝色、xl', '184', '38.00', '234.00', '0000-00-00 00:00:00', '0', '1', '0', '64,66', '', '32', '0', '0', '0.00', '100.00', '0', '', '', '阿迪达斯男裤2017冬季小脚运动裤保暖', null);
INSERT INTO `yer_sku` VALUES ('286', '蓝色、xxl', '184', '12.00', '342.00', '0000-00-00 00:00:00', '0', '1', '0', '64,66', '', '23', '0', '0', '0.00', '148.00', '0', '', '', '阿迪达斯男裤2017冬季小脚运动裤保暖', null);
INSERT INTO `yer_sku` VALUES ('287', '白色、xl', '184', '5.00', '234.00', '0000-00-00 00:00:00', '0', '1', '0', '69,66', '', '324', '0', '0', '0.00', '156.00', '0', '', '', '阿迪达斯男裤2017冬季小脚运动裤保暖', null);
INSERT INTO `yer_sku` VALUES ('288', '白色、xxl', '184', '20.00', '343.00', '0000-00-00 00:00:00', '0', '1', '0', '69,66', '', '32324', '0', '0', '0.00', '154.00', '0', '', '', '阿迪达斯男裤2017冬季小脚运动裤保暖', null);
INSERT INTO `yer_sku` VALUES ('289', '红色、x', '185', '6.00', '124.00', '0000-00-00 00:00:00', '0', '1', '0', '63,66', '', '567', '0', '0', '0.00', '111.00', '0', '', '', '阿迪达斯长裤男 2017秋季新款运动裤针织', null);
INSERT INTO `yer_sku` VALUES ('290', '红色、xl', '185', '33.00', '235.00', '0000-00-00 00:00:00', '0', '1', '0', '63,67', '', '567', '0', '0', '0.00', '147.00', '0', '', '', '阿迪达斯长裤男 2017秋季新款运动裤针织', null);
INSERT INTO `yer_sku` VALUES ('291', '蓝色、x', '185', '12.00', '534.00', '0000-00-00 00:00:00', '0', '1', '0', '64,66', '', '675', '0', '0', '0.00', '197.00', '0', '', '', '阿迪达斯长裤男 2017秋季新款运动裤针织', null);
INSERT INTO `yer_sku` VALUES ('292', '蓝色、xl', '185', '42.00', '765.00', '0000-00-00 00:00:00', '0', '1', '0', '64,67', '', '567', '337', '0', '0.00', '174.00', '0', '', '', '阿迪达斯长裤男 2017秋季新款运动裤针织', null);
INSERT INTO `yer_sku` VALUES ('293', '无', '186', '17.00', '234.00', '0000-00-00 00:00:00', '0', '1', '0', '186', '', '234', '0', '0', '0.00', '127.00', '0', '', '', '正版书籍包邮 龙应台人生三书', null);
INSERT INTO `yer_sku` VALUES ('294', '无', '187', '16.00', '234.00', '0000-00-00 00:00:00', '0', '1', '0', '187', '', '234', '0', '0', '0.00', '153.00', '0', '', '', '正版现货 白夜行(精装典藏版)东野圭吾小说集', null);
INSERT INTO `yer_sku` VALUES ('295', '无', '188', '41.00', '234.00', '0000-00-00 00:00:00', '0', '1', '0', '188', '', '234', '0', '0', '0.00', '129.00', '0', '', '', '国家图书奖朱自清散文集徐志摩经典大全集', null);
INSERT INTO `yer_sku` VALUES ('296', '无', '189', '5.00', '234.00', '0000-00-00 00:00:00', '0', '1', '0', '189', '', '234', '0', '0', '0.00', '183.00', '0', '', '', '罗辑思维官方 今天故事书', null);
INSERT INTO `yer_sku` VALUES ('297', '无', '190', '35.00', '34.00', '0000-00-00 00:00:00', '0', '1', '0', '190', '', '324', '0', '0', '0.00', '113.00', '0', '', '', '【亚马逊图书】王小波文集：黄金时代+青铜时代+', null);
INSERT INTO `yer_sku` VALUES ('298', '无', '191', '16.00', '123.00', '0000-00-00 00:00:00', '0', '1', '0', '191', '', '123', '0', '0', '0.00', '124.00', '0', '', '', '布鲁克林有棵树正版包邮(美)史密斯著', null);
INSERT INTO `yer_sku` VALUES ('299', '无', '192', '22.00', '213.00', '0000-00-00 00:00:00', '0', '1', '0', '192', '', '123', '0', '0', '0.00', '150.00', '0', '', '', '【国家图书奖】鲁迅散文选集', null);
INSERT INTO `yer_sku` VALUES ('300', '普装、16开', '193', '12.00', '454.00', '0000-00-00 00:00:00', '0', '1', '0', '113,116', '', '345', '0', '0', '0.00', '159.00', '0', '', '', '初等英语3-6级词汇速记手册', null);
INSERT INTO `yer_sku` VALUES ('301', '普装、32开', '193', '38.00', '345.00', '0000-00-00 00:00:00', '0', '1', '0', '113,117', '', '345', '0', '0', '0.00', '177.00', '0', '', '', '初等英语3-6级词汇速记手册', null);
INSERT INTO `yer_sku` VALUES ('302', '精装、16开', '193', '49.00', '345.00', '0000-00-00 00:00:00', '0', '1', '0', '114,116', '', '345', '0', '0', '0.00', '158.00', '0', '', '', '初等英语3-6级词汇速记手册', null);
INSERT INTO `yer_sku` VALUES ('303', '精装、32开', '193', '18.00', '345.00', '0000-00-00 00:00:00', '0', '1', '0', '114,117', '', '345', '0', '0', '0.00', '103.00', '0', '', '', '初等英语3-6级词汇速记手册', null);
INSERT INTO `yer_sku` VALUES ('304', '无', '194', '40.00', '434.00', '0000-00-00 00:00:00', '0', '1', '0', '194', '', '324', '0', '0', '0.00', '129.00', '0', '', '', '欧神诺瓷砖 特权订金10元抵500元', null);
INSERT INTO `yer_sku` VALUES ('305', '无', '195', '19.00', '324.00', '0000-00-00 00:00:00', '0', '1', '0', '195', '', '234', '0', '0', '0.00', '120.00', '0', '', '', '北欧无缝无纺布壁画 电视背景墙现代沙发客厅卧室', null);
INSERT INTO `yer_sku` VALUES ('306', '无', '196', '45.00', '324.00', '0000-00-00 00:00:00', '0', '1', '0', '196', '', '234', '0', '0', '0.00', '127.00', '0', '', '', '百安居 699精致全包装修套餐', null);
INSERT INTO `yer_sku` VALUES ('307', '无', '197', '39.00', '234.00', '0000-00-00 00:00:00', '0', '1', '0', '197', '', '234', '0', '0', '0.00', '149.00', '0', '', '', '捷阳 电动晾衣架 遥控升降智能自动晾衣机', null);
INSERT INTO `yer_sku` VALUES ('308', '无', '198', '8.00', '345.00', '0000-00-00 00:00:00', '0', '1', '0', '198', '', '433', '0', '0', '0.00', '147.00', '0', '', '', 'TATA木门 简约静音门室内门', null);
INSERT INTO `yer_sku` VALUES ('309', '无', '199', '42.00', '3245.00', '0000-00-00 00:00:00', '0', '1', '0', '199', '', '234', '0', '0', '0.00', '148.00', '0', '', '', '简约转角书桌实木书架书柜组合一体', null);
INSERT INTO `yer_sku` VALUES ('310', '无', '200', '17.00', '234.00', '0000-00-00 00:00:00', '0', '1', '0', '200', '', '233', '0', '0', '0.00', '141.00', '0', '', '', '厨房置物架 壁挂 304不锈钢刀架厨具', null);
INSERT INTO `yer_sku` VALUES ('311', '无', '201', '7.00', '34554.00', '0000-00-00 00:00:00', '0', '1', '0', '201', '', '345', '0', '0', '0.00', '143.00', '0', '', '', '耐夫刀具套装厨房组合全套不锈钢德国菜刀套装家用', null);
INSERT INTO `yer_sku` VALUES ('312', '无', '202', '26.00', '34554.00', '0000-00-00 00:00:00', '0', '1', '0', '202', '', '345', '0', '0', '0.00', '180.00', '0', '', '', null, null);
INSERT INTO `yer_sku` VALUES ('313', '1kg、优惠套装1', '203', '15.00', '12.00', '0000-00-00 00:00:00', '0', '1', '0', '80,83', '', '56764', '0', '0', '0.00', '113.00', '0', '', '', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', null);
INSERT INTO `yer_sku` VALUES ('314', '1kg、优惠套装2', '203', '14.00', '18.00', '0000-00-00 00:00:00', '0', '1', '0', '80,84', '', '567', '0', '0', '0.00', '102.00', '0', '', '', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', null);
INSERT INTO `yer_sku` VALUES ('315', '2kg、优惠套装1', '203', '30.00', '20.00', '0000-00-00 00:00:00', '0', '1', '0', '81,83', '', '567', '0', '0', '0.00', '103.00', '0', '', '', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', null);
INSERT INTO `yer_sku` VALUES ('316', '2kg、优惠套装2', '203', '41.00', '26.00', '0000-00-00 00:00:00', '0', '1', '0', '81,84', '', '5675', '0', '0', '0.00', '127.00', '0', '', '', '伊利 安慕希 205g*16盒 原味 常温酸奶 12盒+4盒', null);
INSERT INTO `yer_sku` VALUES ('317', '无', '204', '44.00', '7213.00', '0000-00-00 00:00:00', '0', '1', '0', '204', '', '123', '0', '0', '0.00', '111.00', '0', '', '', '套餐】Apple iPad 32G银+intermail', null);
INSERT INTO `yer_sku` VALUES ('318', '无', '205', '14.00', '2342.00', '0000-00-00 00:00:00', '0', '1', '0', '205', '', '23', '0', '0', '0.00', '120.00', '0', '', '', 'Apple iPad mini 4 7.9英寸平板电脑', null);
INSERT INTO `yer_sku` VALUES ('319', '无', '206', '36.00', '234.00', '0000-00-00 00:00:00', '0', '1', '0', '206', '', '23432', '0', '0', '0.00', '127.00', '0', '', '', '惠普（HP）ENVY 13-ad109TU笔记本电脑', null);
INSERT INTO `yer_sku` VALUES ('320', '无', '207', '14.00', '599.00', '0000-00-00 00:00:00', '0', '1', '0', '207', '', '344', '0', '0', '0.00', '110.00', '0', '', '', '美的（Midea）M3-L253C 智能微波炉 光波烧烤', null);
INSERT INTO `yer_sku` VALUES ('321', '无', '208', '22.00', '0.01', '0000-00-00 00:00:00', '0', '1', '0', '208', '', '234', '0', '0', '0.00', '175.00', '0', '', '', '永赢一路发一苏宁银车挂 银色', null);
INSERT INTO `yer_sku` VALUES ('322', '无', '209', '28.00', '0.01', '0000-00-00 00:00:00', '0', '1', '0', '209', '', '234', '0', '0', '0.00', '125.00', '0', '', '', 'Xiaomi/小米 小米手机Note3 ', null);
INSERT INTO `yer_sku` VALUES ('334', '4G、16G', '170', '24.00', '0.00', '0000-00-00 00:00:00', '0', '1', '0', '76,87', '', '0', '0', '0', '0.00', '105.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ', null);
INSERT INTO `yer_sku` VALUES ('335', '4G、32G', '170', '21.00', '0.00', '0000-00-00 00:00:00', '0', '1', '0', '76,88', '', '0', '0', '0', '0.00', '107.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ', null);
INSERT INTO `yer_sku` VALUES ('336', '4G、64G', '170', '36.00', '0.00', '0000-00-00 00:00:00', '0', '1', '0', '76,89', '', '0', '0', '0', '0.00', '194.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ', null);
INSERT INTO `yer_sku` VALUES ('337', '6G、16G', '170', '31.00', '0.00', '0000-00-00 00:00:00', '0', '1', '0', '77,87', '', '0', '0', '0', '0.00', '109.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ', null);
INSERT INTO `yer_sku` VALUES ('338', '6G、32G', '170', '27.00', '0.00', '0000-00-00 00:00:00', '0', '1', '0', '77,88', '', '0', '0', '0', '0.00', '193.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ', null);
INSERT INTO `yer_sku` VALUES ('339', '6G、64G', '170', '48.00', '0.00', '0000-00-00 00:00:00', '0', '1', '0', '77,89', '', '0', '0', '0', '0.00', '162.00', '0', '', '', '【低至5488元】Apple/苹果iPhone 8 Plus ', null);
INSERT INTO `yer_sku` VALUES ('340', '蓝色、x', '184', '30.00', '0.00', '0000-00-00 00:00:00', '0', '1', '0', '64,66', '', '0', '0', '0', '0.00', '116.00', '0', '', '', '阿迪达斯男裤2017冬季小脚运动裤保暖', null);
INSERT INTO `yer_sku` VALUES ('341', '白色、x', '184', '8.00', '0.00', '0000-00-00 00:00:00', '0', '1', '0', '69,66', '', '0', '0', '0', '0.00', '109.00', '0', '', '', '阿迪达斯男裤2017冬季小脚运动裤保暖', null);
INSERT INTO `yer_sku` VALUES ('342', '无', '212', '40.00', '100.00', '0000-00-00 00:00:00', '0', '1', '0', '212', '', '10', '0', '0', '0.00', '126.00', '0', '', '', '九阳(Joyoung) K15-F23 电水壶', null);
INSERT INTO `yer_sku` VALUES ('343', '无', '213', '49.00', '66.00', '0000-00-00 00:00:00', '0', '1', '0', '213', '', '20', '0', '0', '0.00', '143.00', '0', '', '', '伊利 安慕希希腊风味酸牛奶原味', null);
INSERT INTO `yer_sku` VALUES ('344', '无', '214', '25.00', '30.00', '0000-00-00 00:00:00', '0', '1', '0', '214', '', '10', '0', '0', '0.00', '129.00', '0', '', '', '洁霸（Attack）瞬清无磷洗衣液3kg/瓶 ', null);
INSERT INTO `yer_sku` VALUES ('345', '无', '215', '38.00', '1200.00', '0000-00-00 00:00:00', '0', '1', '0', '215', '', '60', '0', '0', '0.00', '171.00', '0', '', '', '容声（Ronshen）BCD-218D11N 218升', null);
INSERT INTO `yer_sku` VALUES ('346', '无', '216', '49.00', '120.00', '0000-00-00 00:00:00', '0', '1', '0', '216', '', '66', '0', '0', '0.00', '180.00', '0', '', '', '水井坊 井台瓶 52度 500ml 单瓶装', null);
INSERT INTO `yer_sku` VALUES ('347', '无', '217', '6.00', '100.00', '0000-00-00 00:00:00', '0', '1', '0', '217', '', '10', '0', '0', '0.00', '104.00', '0', '', '', 'walch/威露士衣物家居消毒液 3L 消毒除菌液', null);
INSERT INTO `yer_sku` VALUES ('348', '无', '218', '10.00', '100.00', '0000-00-00 00:00:00', '0', '1', '0', '218', '', '10', '0', '0', '0.00', '100.00', '0', '', '', '安佳（Anchor）全脂纯牛奶1L*12盒整箱', null);
INSERT INTO `yer_sku` VALUES ('349', '无', '219', '26.00', '6.00', '0000-00-00 00:00:00', '0', '1', '0', '219', '', '10', '0', '0', '0.00', '116.00', '0', '', '', 'Mixx炼奶起士味饼干500g (袋装)', null);
INSERT INTO `yer_sku` VALUES ('350', '无', '220', '40.00', '500.00', '0000-00-00 00:00:00', '0', '1', '0', '220', '', '6', '0', '0', '0.00', '108.00', '0', '', '', '佳能(Canon) EOS 750D单反数码相机', null);
INSERT INTO `yer_sku` VALUES ('351', '无', '221', '16.00', '5600.00', '0000-00-00 00:00:00', '0', '1', '0', '221', '', '1', '0', '0', '0.00', '139.00', '0', '', '', '华硕(ASUS)轻薄本笔记本电脑', null);
INSERT INTO `yer_sku` VALUES ('352', '无', '222', '48.00', '20.00', '0000-00-00 00:00:00', '0', '1', '0', '222', '', '1', '0', '0', '0.00', '188.00', '0', '', '', '福临门苏软香米5kg/袋 中粮出品 粳米', null);
INSERT INTO `yer_sku` VALUES ('353', '无', '223', '22.00', '12.00', '0000-00-00 00:00:00', '0', '1', '0', '223', '', '100', '0', '0', '0.00', '180.00', '0', '', '', '鸣香冻顶乌龙茶 新凤鸣正品浓香型茶叶', null);
INSERT INTO `yer_sku` VALUES ('354', '无', '224', '9.00', '0.10', '0000-00-00 00:00:00', '0', '1', '0', '224', '', '11', '0', '0', '0.00', '110.00', '0', '', '', '新凤鸣台湾红豆薏仁粉 营养早餐代餐粉五谷杂粮粉', '0.01');
INSERT INTO `yer_sku` VALUES ('355', '3G、16G', '225', '50.00', '1999.00', '0000-00-00 00:00:00', '0', '1', '0', '75,87', '', '10206', '0', '0', '0.00', '174.00', '0', '', '', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', null);
INSERT INTO `yer_sku` VALUES ('356', '3G、32G', '225', '14.00', '3997.00', '0000-00-00 00:00:00', '0', '1', '0', '75,88', '', '1012321', '0', '0', '0.00', '122.00', '0', '', '', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', null);
INSERT INTO `yer_sku` VALUES ('357', '6G、16G', '225', '15.00', '4999.00', '0000-00-00 00:00:00', '0', '1', '0', '77,87', '', '101231', '0', '0', '0.00', '159.00', '0', '', '', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', null);
INSERT INTO `yer_sku` VALUES ('358', '6G、32G', '225', '23.00', '5254.00', '0000-00-00 00:00:00', '0', '1', '0', '77,88', '', '1212321', '0', '0', '0.00', '113.00', '0', '', '', 'Nokia/诺基亚 7 plus骁龙660 全网通4G手机', null);
INSERT INTO `yer_sku` VALUES ('373', '无', '228', '35.00', '44.00', '0000-00-00 00:00:00', '0', '1', '0', '228', '', '43', '0', '0', '0.00', '137.00', '0', '', '', 'HLA海澜之家短袖T恤男基础款简约圆领', null);
INSERT INTO `yer_sku` VALUES ('372', '黑、套餐1、3g', '227', '24.00', '12321.00', '0000-00-00 00:00:00', '0', '1', '0', '91,96,109', '', '10', '0', '0', '0.00', '111.00', '0', '', '', '联想 小新 潮7000-13 (i7 8550u)', null);
INSERT INTO `yer_sku` VALUES ('371', '黑、套餐1、2g', '227', '17.00', '1231.00', '0000-00-00 00:00:00', '0', '1', '0', '91,96,102', '', '12', '0', '0', '0.00', '135.00', '0', '', '', '联想 小新 潮7000-13 (i7 8550u)', null);
INSERT INTO `yer_sku` VALUES ('370', '黑、套餐1、1g', '227', '10.00', '1231.00', '0000-00-00 00:00:00', '0', '1', '0', '91,96,101', '', '12', '0', '0', '0.00', '156.00', '0', '', '', '联想 小新 潮7000-13 (i7 8550u)', null);
INSERT INTO `yer_sku` VALUES ('369', '黑、官方标配、3g', '227', '48.00', '1231.00', '0000-00-00 00:00:00', '0', '1', '0', '91,95,109', '', '12', '0', '0', '0.00', '127.00', '0', '', '', '联想 小新 潮7000-13 (i7 8550u)', null);
INSERT INTO `yer_sku` VALUES ('368', '黑、官方标配、2g', '227', '13.00', '1212.00', '0000-00-00 00:00:00', '0', '1', '0', '91,95,102', '', '12', '0', '0', '0.00', '199.00', '0', '', '', '联想 小新 潮7000-13 (i7 8550u)', null);
INSERT INTO `yer_sku` VALUES ('367', '黑、官方标配、1g', '227', '13.00', '101231.00', '0000-00-00 00:00:00', '0', '1', '0', '91,95,101', '', '1', '0', '0', '0.00', '111.00', '0', '', '', '联想 小新 潮7000-13 (i7 8550u)', null);
INSERT INTO `yer_sku` VALUES ('374', '红色、x', '229', '25.00', '23.00', '0000-00-00 00:00:00', '0', '1', '0', '63,66', '', '22', '0', '0', '0.00', '151.00', '0', '', '', '卡宾Cabbeen 短袖T恤男装黑色', null);
INSERT INTO `yer_sku` VALUES ('375', '红色、xl', '229', '34.00', '24.00', '0000-00-00 00:00:00', '0', '1', '0', '63,67', '', '22', '0', '0', '0.00', '187.00', '0', '', '', '卡宾Cabbeen 短袖T恤男装黑色', null);
INSERT INTO `yer_sku` VALUES ('376', '蓝色、x', '229', '49.00', '25.00', '0000-00-00 00:00:00', '0', '1', '0', '64,66', '', '22', '0', '0', '0.00', '139.00', '0', '', '', '卡宾Cabbeen 短袖T恤男装黑色', null);
INSERT INTO `yer_sku` VALUES ('377', '蓝色、xl', '229', '32.00', '22.00', '0000-00-00 00:00:00', '0', '1', '0', '64,67', '', '22', '0', '0', '0.00', '195.00', '0', '', '', '卡宾Cabbeen 短袖T恤男装黑色', null);
INSERT INTO `yer_sku` VALUES ('378', '无', '230', '24.00', '11.00', '0000-00-00 00:00:00', '0', '1', '0', '230', '', '9', '0', '0', '0.00', '104.00', '0', '', '', '2018年注册会计师全国统一考试辅导教材 ', null);
INSERT INTO `yer_sku` VALUES ('379', '无', '231', '41.00', '23.00', '0000-00-00 00:00:00', '0', '1', '0', '231', '', '30', '0', '0', '0.00', '178.00', '0', '', '', '浮生六记（汪涵推荐，全译本，畅销150万册）', null);
INSERT INTO `yer_sku` VALUES ('380', '无', '232', '47.00', '454.00', '0000-00-00 00:00:00', '0', '1', '0', '232', '', '45', '0', '0', '0.00', '145.00', '0', '', '', '汪汪队立大功儿童毛绒玩具狗狗毛绒公仔', null);
INSERT INTO `yer_sku` VALUES ('381', '无', '233', '43.00', '6767.00', '0000-00-00 00:00:00', '0', '1', '0', '233', '', '6', '0', '0', '0.00', '165.00', '0', '', '', '一品国度 绝地求生游戏台式吃鸡电脑主机', null);
INSERT INTO `yer_sku` VALUES ('382', '无', '234', '32.00', '169.00', '0000-00-00 00:00:00', '0', '1', '0', '234', '', '100', '0', '0', '0.00', '137.00', '0', '', '', '美国进口 健安喜（GNC）三倍浓缩鱼', null);
INSERT INTO `yer_sku` VALUES ('383', '无', '235', '20.00', '189.00', '0000-00-00 00:00:00', '0', '1', '0', '235', '', '121', '0', '0', '0.00', '164.00', '0', '', '', '爱他美（Aptamil） 【旗舰店】德国奶粉 ', null);

-- ----------------------------
-- Table structure for yer_slide
-- ----------------------------
DROP TABLE IF EXISTS `yer_slide`;
CREATE TABLE `yer_slide` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `title` varchar(225) DEFAULT '' COMMENT '标题',
  `url` varchar(225) DEFAULT '' COMMENT '链接',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '外链',
  `place` tinyint(30) unsigned NOT NULL DEFAULT '0' COMMENT '是否允许发布内容',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '数据状态',
  `cover_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类图标',
  `sort` int(10) NOT NULL DEFAULT '0',
  `goods_id` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='幻灯片表';

-- ----------------------------
-- Records of yer_slide
-- ----------------------------
INSERT INTO `yer_slide` VALUES ('16', 'linin', 'goods/lists?id=52', '0', '0', '0', '0', '1', '207', '0', '229');
INSERT INTO `yer_slide` VALUES ('17', '43534', 'goods/lists?id=52', '0', '0', '0', '0', '1', '208', '0', '232');
INSERT INTO `yer_slide` VALUES ('18', '11', '12', '0', '1', '0', '0', '1', '445', '1', '0');

-- ----------------------------
-- Table structure for yer_sms
-- ----------------------------
DROP TABLE IF EXISTS `yer_sms`;
CREATE TABLE `yer_sms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `mobile` varchar(225) NOT NULL DEFAULT '' COMMENT '手机号码',
  `content` varchar(225) NOT NULL DEFAULT '' COMMENT '短信内容',
  `extcode` varchar(225) NOT NULL DEFAULT '' COMMENT '扩展子号',
  `signtag` varchar(225) NOT NULL DEFAULT '' COMMENT '签名',
  `uid` varchar(225) NOT NULL DEFAULT '' COMMENT '用户id',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '发送时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `tempid` varchar(255) NOT NULL DEFAULT '' COMMENT '模板编号',
  `group` tinyint(2) NOT NULL DEFAULT '0' COMMENT '分组1-验证2-通知',
  `other` tinyint(2) NOT NULL DEFAULT '0' COMMENT '备用',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '状态1-有效2-过期3-验证',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='短信记录表';

-- ----------------------------
-- Records of yer_sms
-- ----------------------------

-- ----------------------------
-- Table structure for yer_specs
-- ----------------------------
DROP TABLE IF EXISTS `yer_specs`;
CREATE TABLE `yer_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `title` varchar(64) CHARACTER SET utf8 NOT NULL,
  `sort` int(10) NOT NULL DEFAULT '0',
  `types_id` int(10) NOT NULL DEFAULT '0',
  `type` int(2) DEFAULT '0',
  `value` varchar(225) CHARACTER SET utf8 DEFAULT NULL,
  `is_show` int(2) NOT NULL DEFAULT '1',
  `short_title` varchar(225) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=135 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC COMMENT='规格表';

-- ----------------------------
-- Records of yer_specs
-- ----------------------------
INSERT INTO `yer_specs` VALUES ('62', '0', '颜色', '0', '42', '0', '红色、蓝色、白色', '1', '');
INSERT INTO `yer_specs` VALUES ('63', '62', '红色', '0', '42', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('64', '62', '蓝色', '0', '42', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('65', '0', '尺码', '0', '42', '0', 'x、xl、xxl', '1', '');
INSERT INTO `yer_specs` VALUES ('66', '65', 'x', '0', '42', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('67', '65', 'xl', '0', '42', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('68', '65', 'xxl', '0', '42', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('69', '62', '白色', '0', '42', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('90', '0', '颜色', '0', '44', '0', '黑、白、金', '1', '');
INSERT INTO `yer_specs` VALUES ('71', '70', '黑色', '0', '0', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('72', '70', '银色', '0', '0', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('73', '0', '内存', '0', '43', '0', '3G、4G、6G、8G', '1', '');
INSERT INTO `yer_specs` VALUES ('75', '73', '3G', '0', '0', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('76', '73', '4G', '0', '0', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('77', '73', '6G', '0', '0', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('78', '73', '8G', '0', '0', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('79', '0', '克重', '0', '47', '0', '1kg、2kg', '1', '');
INSERT INTO `yer_specs` VALUES ('80', '79', '1kg', '0', '0', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('81', '79', '2kg', '0', '0', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('82', '0', '优惠套装', '0', '47', '0', '优惠套装1、优惠套装2、优惠套装3', '1', '');
INSERT INTO `yer_specs` VALUES ('83', '82', '优惠套装1', '0', '47', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('84', '82', '优惠套装2', '0', '47', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('85', '82', '优惠套装3', '0', '47', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('86', '0', '存储容量', '0', '43', '0', '16G、32G、64G', '1', '');
INSERT INTO `yer_specs` VALUES ('87', '86', '16G', '0', '0', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('88', '86', '32G', '0', '0', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('89', '86', '64G', '0', '0', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('91', '90', '黑', '0', '0', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('92', '90', '白', '0', '0', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('93', '90', '金', '0', '0', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('94', '0', '套餐类型', '0', '44', '0', '官方标配、套餐1、套餐2', '1', '');
INSERT INTO `yer_specs` VALUES ('95', '94', '官方标配', '0', '0', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('96', '94', '套餐1', '0', '0', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('97', '94', '套餐2', '0', '0', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('98', '0', '显卡容量', '0', '44', '0', '1g、2g、3g、4g、6g', '1', '');
INSERT INTO `yer_specs` VALUES ('101', '98', '1g', '0', '44', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('102', '98', '2g', '0', '44', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('109', '98', '3g', '0', '44', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('106', '105', '54646', '0', '41', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('107', '105', '676', '0', '41', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('108', '105', '而', '0', '41', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('110', '98', '4g', '0', '44', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('111', '98', '6g', '0', '44', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('112', '0', '包装', '0', '46', '0', '普装、精装', '1', '');
INSERT INTO `yer_specs` VALUES ('113', '112', '普装', '0', '46', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('114', '112', '精装', '0', '46', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('115', '0', '开数', '0', '46', '0', '16开、32开', '1', '');
INSERT INTO `yer_specs` VALUES ('116', '115', '16开', '0', '46', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('117', '115', '32开', '0', '46', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('121', '120', '红色', '0', '42', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('122', '120', '白色', '0', '42', '0', '', '1', '');
INSERT INTO `yer_specs` VALUES ('123', '120', '黑色', '0', '42', '0', '', '1', '');

-- ----------------------------
-- Table structure for yer_supplier
-- ----------------------------
DROP TABLE IF EXISTS `yer_supplier`;
CREATE TABLE `yer_supplier` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `username` varchar(255) DEFAULT NULL COMMENT '供应商名称',
  `contact` varchar(255) DEFAULT NULL COMMENT '联系人',
  `mobile` varchar(255) DEFAULT NULL COMMENT '联系方式',
  `area` varchar(255) DEFAULT NULL COMMENT '所属区域',
  `address` varchar(255) DEFAULT NULL COMMENT '详细地址',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='供应商表';

-- ----------------------------
-- Records of yer_supplier
-- ----------------------------
INSERT INTO `yer_supplier` VALUES ('1', '45654665', '544554', '', '', '', '0');

-- ----------------------------
-- Table structure for yer_tags
-- ----------------------------
DROP TABLE IF EXISTS `yer_tags`;
CREATE TABLE `yer_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(225) CHARACTER SET utf8 NOT NULL,
  `num` int(10) NOT NULL DEFAULT '0',
  `status` tinyint(2) NOT NULL DEFAULT '1',
  `goods_id` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC COMMENT='标签表';

-- ----------------------------
-- Records of yer_tags
-- ----------------------------

-- ----------------------------
-- Table structure for yer_text
-- ----------------------------
DROP TABLE IF EXISTS `yer_text`;
CREATE TABLE `yer_text` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `appid` varchar(225) DEFAULT NULL COMMENT '公众号id',
  `title` varchar(225) NOT NULL DEFAULT '' COMMENT '标题',
  `content` varchar(225) NOT NULL DEFAULT '' COMMENT '内容',
  `keyword` varchar(225) DEFAULT NULL COMMENT '关键词',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='微信文本回复表';

-- ----------------------------
-- Records of yer_text
-- ----------------------------
INSERT INTO `yer_text` VALUES ('1', 'wx643f65392e6a5e8c', '', '32432', '1');

-- ----------------------------
-- Table structure for yer_third_login
-- ----------------------------
DROP TABLE IF EXISTS `yer_third_login`;
CREATE TABLE `yer_third_login` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `openid` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `access_token` varchar(255) NOT NULL,
  `refresh_token` varchar(255) NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `appid` varchar(225) DEFAULT NULL,
  `create_time` int(10) NOT NULL DEFAULT '0',
  `figureurl` varchar(226) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='第三方登陆表';

-- ----------------------------
-- Records of yer_third_login
-- ----------------------------

-- ----------------------------
-- Table structure for yer_types
-- ----------------------------
DROP TABLE IF EXISTS `yer_types`;
CREATE TABLE `yer_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) CHARACTER SET utf8 NOT NULL,
  `sort` int(1) NOT NULL DEFAULT '0',
  `status` tinyint(2) NOT NULL DEFAULT '1',
  `tags` varchar(226) CHARACTER SET utf8 DEFAULT NULL,
  `type` tinyint(2) NOT NULL DEFAULT '0',
  `template_add` varchar(225) NOT NULL DEFAULT 'goods/add',
  `template_edit` varchar(225) NOT NULL DEFAULT 'goods/edit',
  `template_detail` varchar(225) NOT NULL DEFAULT 'goods/goods_detail',
  `template_lists` varchar(225) NOT NULL DEFAULT 'goods/goods_lists',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC COMMENT='类型表';

-- ----------------------------
-- Records of yer_types
-- ----------------------------
INSERT INTO `yer_types` VALUES ('42', '服装', '0', '1', '', '0', 'goods/add', 'goods/edit', 'goods/goods_detail', 'goods/goods_lists');
INSERT INTO `yer_types` VALUES ('41', '零食', '0', '1', '', '0', 'goods/add', 'goods/edit', 'goods/goods_detail', 'goods/goods_lists');
INSERT INTO `yer_types` VALUES ('40', '普通商品', '0', '1', '', '0', 'goods/add', 'goods/edit', 'goods/goods_detail', 'goods/goods_lists');
INSERT INTO `yer_types` VALUES ('43', '手机', '0', '1', '', '0', 'goods/add', 'goods/edit', 'goods/goods_detail', 'goods/goods_lists');
INSERT INTO `yer_types` VALUES ('44', '笔记本', '0', '1', '', '0', 'goods/add', 'goods/edit', 'goods/goods_detail', 'goods/goods_lists');
INSERT INTO `yer_types` VALUES ('45', '汽车', '0', '1', '', '0', 'goods/add', 'goods/edit', 'goods/goods_detail', 'goods/goods_lists');
INSERT INTO `yer_types` VALUES ('46', '图书', '0', '1', '', '0', 'goods/add', 'goods/edit', 'goods/goods_detail', 'goods/goods_lists');
INSERT INTO `yer_types` VALUES ('47', '牛奶', '0', '1', '', '0', 'goods/add', 'goods/edit', 'goods/goods_detail', 'goods/goods_lists');
INSERT INTO `yer_types` VALUES ('48', '闪购', '0', '1', '', '0', 'goods/time', 'goods/time', 'goods/time_detail', 'goods/time_lists');
INSERT INTO `yer_types` VALUES ('49', '拼团', '0', '1', '', '0', 'goods/tuan', 'goods/tuan', 'goods/tuan_detail', 'goods/tuan_lists');
INSERT INTO `yer_types` VALUES ('50', '积分', '0', '1', '', '0', 'goods/score', 'goods/score', 'goods/goods_score', 'goods/score_lists');
INSERT INTO `yer_types` VALUES ('51', '预约', '0', '1', '', '0', 'goods/add', 'goods/edit', 'goods/goods_detail', 'goods/goods_lists');

-- ----------------------------
-- Table structure for yer_user
-- ----------------------------
DROP TABLE IF EXISTS `yer_user`;
CREATE TABLE `yer_user` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户ID',
  `username` char(16) NOT NULL COMMENT '用户名',
  `password` varchar(225) NOT NULL COMMENT '密码',
  `email` varchar(225) DEFAULT NULL COMMENT '用户邮箱',
  `mobile` bigint(11) NOT NULL DEFAULT '0' COMMENT '用户手机',
  `reg_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '注册时间',
  `reg_ip` varchar(255) DEFAULT NULL COMMENT '注册IP',
  `last_login_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后登录时间',
  `last_login_ip` bigint(20) NOT NULL DEFAULT '0' COMMENT '最后登录IP',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) DEFAULT '0' COMMENT '用户状态',
  `cover_id` int(10) NOT NULL DEFAULT '1',
  `account` decimal(50,2) NOT NULL DEFAULT '0.00',
  `score` int(10) DEFAULT '0',
  `birthday` int(10) NOT NULL DEFAULT '0',
  `star` varchar(225) DEFAULT NULL,
  `sex` varchar(225) DEFAULT NULL,
  `province` varchar(225) DEFAULT NULL,
  `city` varchar(225) DEFAULT NULL,
  `area` varchar(225) DEFAULT NULL,
  `pid` int(10) NOT NULL DEFAULT '0',
  `number` int(10) NOT NULL DEFAULT '0',
  `token` varchar(225) DEFAULT NULL,
  `expire_time` varchar(225) DEFAULT NULL,
  `level` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=119 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='用户表';

-- ----------------------------
-- Table structure for yer_user_coupon
-- ----------------------------
DROP TABLE IF EXISTS `yer_user_coupon`;
CREATE TABLE `yer_user_coupon` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `coupon_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券id',
  `title` varchar(225) NOT NULL DEFAULT '' COMMENT '标题',
  `money` varchar(225) NOT NULL DEFAULT '' COMMENT '链接',
  `total` varchar(225) NOT NULL DEFAULT '',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '结束时间',
  `status` tinyint(2) DEFAULT '1' COMMENT '数据状态',
  `uid` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COMMENT='用户优惠券表';

-- ----------------------------
-- Records of yer_user_coupon
-- ----------------------------
INSERT INTO `yer_user_coupon` VALUES ('9', '12', '10元优惠券', '10', '200', '1588176000', '1602691200', '0', '1');
INSERT INTO `yer_user_coupon` VALUES ('10', '12', '10元优惠券', '10', '200', '1588176000', '1602691200', '1', '82');
INSERT INTO `yer_user_coupon` VALUES ('11', '11', '六一儿童节', '50', '1000', '1590940800', '1601222400', '0', '1');
INSERT INTO `yer_user_coupon` VALUES ('12', '10', '五一劳动节优惠券', '10', '100', '1588077910', '1593521110', '0', '1');
INSERT INTO `yer_user_coupon` VALUES ('13', '9', '新用户首单优惠券', '2', '100', '1588076328', '1608812328', '0', '1');
INSERT INTO `yer_user_coupon` VALUES ('14', '11', '六一儿童节', '50', '1000', '1590940800', '1601222400', '1', '82');
INSERT INTO `yer_user_coupon` VALUES ('15', '9', '新用户首单优惠券', '2', '100', '1588076328', '1608812328', '0', '82');
INSERT INTO `yer_user_coupon` VALUES ('16', '10', '五一劳动节优惠券', '10', '100', '1588077910', '1593521110', '2', '82');
INSERT INTO `yer_user_coupon` VALUES ('17', '12', '10元优惠券', '10', '200', '1588176000', '1602691200', '0', '104');

-- ----------------------------
-- Table structure for yer_user_log
-- ----------------------------
DROP TABLE IF EXISTS `yer_user_log`;
CREATE TABLE `yer_user_log` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户组id,自增主键',
  `title` text COMMENT '名称',
  `uid` int(10) unsigned NOT NULL COMMENT '用户id',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '用户组状态：为1正常，为0禁用,2为已使用',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=208 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='操作记录表';

-- ----------------------------
-- Records of yer_user_log
-- ----------------------------

-- ----------------------------
-- Table structure for yer_weixin
-- ----------------------------
DROP TABLE IF EXISTS `yer_weixin`;
CREATE TABLE `yer_weixin` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id,自增主键',
  `title` varchar(225) DEFAULT NULL COMMENT '公众号名称',
  `appid` varchar(225) DEFAULT NULL COMMENT '公众号id',
  `secret` varchar(225) DEFAULT NULL COMMENT '公众号密钥',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否默认值',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `email` varchar(255) NOT NULL DEFAULT '' COMMENT '公众号登陆邮箱',
  `password` varchar(255) DEFAULT NULL COMMENT '公众号登陆密码',
  `wechat` varchar(255) NOT NULL DEFAULT '' COMMENT '微信号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='微信公众号表';

-- ----------------------------
-- Records of yer_weixin
-- ----------------------------
INSERT INTO `yer_weixin` VALUES ('1', 'gh_5827609668c3', 'wx643f65392e6a5e8c', 'f1d31c23b46ba39ed513149417e7350e', '0', '1574092800', '2508390663@qq.com', 'aa', 'gh_5827609668c3');
