<?php
namespace wstshop\admin\model;
use think\Db;
/**
 * ============================================================================
 * WSTShop网上商店
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wstshop.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 文章业务处理
 */
class Articles extends Base{
	/**
	 * 分页
	 */
	public function pageQuery(){
		$key = input('key');
		$catId = (int)input('catId');
		$catIds = [];
		if($catId>0){
		    $catIds = model('ArticleCats')->getChild($catId);
        }
		$where = [];
		$where['a.dataFlag'] = 1;
		if(count($catIds)>0)$where['a.catId'] = ['in',$catIds];
		if($key!='')$where['a.articleTitle'] = ['like','%'.$key.'%'];
		$page = Db::name('articles')->alias('a')
		->join('__ARTICLE_CATS__ ac','a.catId= ac.catId','left')
		->join('__STAFFS__ s','a.staffId= s.staffId','left')
		->where($where)
		->field('a.articleId,a.catId,a.articleTitle,a.isShow,a.articleContent,a.articleKey,a.createTime,a.catSort,ac.catName,s.staffName')
		->order('a.articleId', 'desc')
		->paginate(input('post.limit/d'))->toArray();
		if(count($page['Rows'])>0){
			foreach ($page['Rows'] as $key => $v){
				$page['Rows'][$key]['articleContent'] = strip_tags(htmlspecialchars_decode($v['articleContent']));
			}
		}
		return $page;
	}
	
	/**
	 * 显示是否显示/隐藏
	 */
	public function editiIsShow(){
		$id = input('post.id/d');
		$isShow = input('post.isShow/d')==0?0:1;
		$result = $this->where(['articleId'=>$id])->update(['isShow' => $isShow]);
		if(false !== $result){
			WSTClearAllCache();
			return WSTReturn("操作成功", 1);
		}else{
			return WSTReturn($this->getError(),-1);
		}
	}
	
	/**
	 * 获取指定对象
	 */
	public function getById($id){
		$single = $this->where(['articleId'=>$id,'dataFlag'=>1])->find();
		$singlec = Db::name('article_cats')->where(['catId'=>$single['catId'],'dataFlag'=>1])->field('catName')->find();
		$single['catName']=$singlec['catName'];
		$single['articleContent'] = htmlspecialchars_decode($single['articleContent']);
		return $single;
	}
	
	/**
	 * 新增
	 */
	public function add(){
		$data = input('post.');
		WSTUnset($data,'articleId,dataFlag');
		$data["staffId"] = (int)session('WST_STAFF.staffId');
		$data['createTime'] = date('Y-m-d H:i:s');
		Db::startTrans();
        try{
        	$data['articleContent'] = WSTRichEditorFilter($data['articleContent']);
        	$result = $this->validate('Articles.add')->allowField(true)->save($data);
        	if(false !== $result){
        		// 预览图
				WSTUseResources(1, $this->articleId, $data['coverImg']);
				//文章描述图片
				WSTEditorImageRocord(1, $this->articleId, '',$data['articleContent']);
				WSTClearAllCache();
	        	Db::commit();
				return WSTReturn("新增成功", 1);
			}else{
				return WSTReturn($this->getError(),-1);
			}
        }catch(\Exception $e){
			Db::rollback();
        }
        return WSTReturn("新增失败");
    }
	
	/**
	 * 编辑
	 */
	public function edit(){
		$articleId = input('post.articleId/d');
		$data = input('post.');
		WSTUnset($data,'articleId,dataFlag,createTime');
		$data["staffId"] = (int)session('WST_STAFF.staffId');
		Db::startTrans();
        try{
        	$data['articleContent'] = WSTRichEditorFilter($data['articleContent']);
        	// 预览图
			WSTUseResources(0, $articleId, $data['coverImg'],'articles','coverImg');
        	//文章描述图片
			$oldArticleContent = $this->where('articleId',$articleId)->value('articleContent');// 旧描述
			WSTEditorImageRocord(1, $articleId, $oldArticleContent,$data['articleContent']);
        	$result = $this->validate('Articles.edit')->allowField(true)->update($data,['articleId'=>$articleId]);
        	if(false !== $result){
        		WSTClearAllCache();
				Db::commit();
				return WSTReturn("修改成功", 1);
			}
		}catch(\Exception $e){
			Db::rollback();
			return WSTReturn($this->getError(),-1);
        }
        return WSTReturn("新增失败".$this->getError());
	}
	
	/**
	 * 删除
	 */
	public function del(){
		$id = input('post.id/d');
		$data = [];
		$data['dataFlag'] = -1;
		Db::startTrans();
		try{
			$result = $this->where(['articleId'=>$id])->update($data);
			if(false !== $result){
				// 预览图
				WSTUnuseResources('articles','coverImg',$id);
	        	//文章描述图片
				$oldArticleContent = $this->where('articleId',$id)->value('articleContent');// 旧描述
				WSTEditorImageRocord(1, $id, $oldArticleContent,'');
				WSTClearAllCache();
				Db::commit();
				return WSTReturn("删除成功", 1);
			}
		}catch (\Exception $e) {
            Db::rollback();
			return WSTReturn('删除失败',-1);
        }
	}
	/**
	 * 批量删除
	 */
	public function delByBatch(){
		$ids = input('post.ids');
		$data = [];
		$data['dataFlag'] = -1;
		Db::startTrans();
		try{
			$result = $this->where(['articleId'=>['in',$ids]])->update($data);
			if(false !== $result){
				$oldArticleContent = $this->field('articleId,articleContent')->where(['articleId'=>['in',$ids]])->select();// 旧描述
				foreach($oldArticleContent as $k=>$v){
					// 预览图
					WSTUnuseResources('articles','coverImg',$v['articleId']);
					//文章描述图片
					WSTEditorImageRocord(1, $v['articleId'], $v['articleContent'],'');
				}
				WSTClearAllCache();
				Db::commit();
				return WSTReturn("删除成功", 1);
			}
		}catch (\Exception $e) {
			echo $e->getMessage();
            Db::rollback();
			return WSTReturn('删除失败',-1);
        }
	}
	/**
	 * 修改排序
	 */
	public function changeSort(){
		$id = (int)input('id');
		$catSort = (int)input('catSort');
		$result = $this->setField(['articleId'=>$id,'catSort'=>$catSort]);
		if(false !== $result){
			WSTClearAllCache();
			return WSTReturn("操作成功", 1);
		}else{
			return WSTReturn($this->getError(),-1);
		}
	}
}