<?php
/**
 * ============================================================================
 * WSTShop网上商店
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wstshop.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 */

use think\Db;
use think\Loader;
/**
 * 生成验证码
 */

const WST_ADDON_PATH = './addons/';

function WSTVerify(){
	ob_clean();
	$Verify = new \verify\Verify();
    $Verify->length   = 4;
    $Verify->entry();
}
/**
 * 核对验证码
 */
function WSTVerifyCheck($code){
	$code = str_replace(' ','',$code);
	$verify = new \verify\Verify();
	return $verify->check($code);
}
/**
 * 生成数据返回值
 */
function WSTReturn($msg,$status = -1,$data = []){
	$rs = ['status'=>$status,'msg'=>$msg];
	if(!empty($data))$rs['data'] = $data;
	return $rs;
}
/**
 * 生成数据返回值
 */
function jsonReturn($msg,$status = -1,$data = []){
	if(isset($data['status']))return json_encode($data);
	$rs = ['status'=>$status,'msg'=>$msg];
	if(!empty($data))$rs['data'] = $data;
	return json_encode($rs);
}
/**
 * 检测字符串不否包含
 * @param $srcword 被检测的字符串
 * @param $filterWords 禁用使用的字符串列表
 * @return boolean true-检测到,false-未检测到
 */
function WSTCheckFilterWords($srcword,$filterWords){
	$flag = true;
	if($filterWords!=""){
		$filterWords = str_replace("，",",",$filterWords);
		$words = explode(",",$filterWords);
		for($i=0;$i<count($words);$i++){
			if($words[$i]=='')continue;
			if(strpos($srcword,$words[$i]) !== false){
				$flag = false;
				break;
			}
		}
	}
	return $flag;
}

/**
 * 中国网建短信服务商
 * @param string $phoneNumer  手机号码
 * @param string $content     短信内容
 */
function WSTSendSMS($phoneNumer,$content){
	$url = 'http://utf8.sms.webchinese.cn/?Uid='.WSTConf("CONF.smsKey").'&Key='.WSTConf("CONF.smsPass").'&smsMob='.$phoneNumer.'&smsText='.$content;
	$ch=curl_init($url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);//设置否输出到页面
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30 ); //设置连接等待时间
	curl_setopt($ch, CURLOPT_ENCODING, "gzip" );
	$data=curl_exec($ch);
	curl_close($ch);
	return $data;
}


/**
 * 获取指定的全局配置
 */
function WSTConf($key,$v = ''){
	if(is_null($v)){
		if(array_key_exists('WSTSHOPCONF',$GLOBALS) && array_key_exists($key,$GLOBALS['WSTSHOPCONF'])){
		    unset($GLOBALS['WSTSHOPCONF'][$key]);
		}
	}else if($v === ''){
		if(array_key_exists('WSTSHOPCONF',$GLOBALS)){
			$conf = $GLOBALS['WSTSHOPCONF'];
			$ks = explode(".",$key);
			for($i=0,$k=count($ks);$i<$k;$i++){
				if(array_key_exists($ks[$i],$conf)){
					$conf = $conf[$ks[$i]];
				}else{
					return null;
				}
			}
			return $conf;
		}
	}else{
		return $GLOBALS['WSTSHOPCONF'][$key] = $v;
	}
	return null;
}

//php获取中文字符拼音首字母
function WSTGetFirstCharter($str){
	if(empty($str)){
		return '';
	}
	$fchar=ord($str{0});
	if($fchar>=ord('A')&&$fchar<=ord('z')) return strtoupper($str{0});
	$s1=iconv('UTF-8','gb2312',$str);
	$s2=iconv('gb2312','UTF-8',$s1);
	$s=$s2==$str?$s1:$str;
	if(empty($s{1})){
		return '';
	}
	$asc=ord($s{0})*256+ord($s{1})-65536;
	if($asc>=-20319 && $asc<=-20284) return 'A';
	if($asc>=-20283 && $asc<=-19776) return 'B';
	if($asc>=-19775 && $asc<=-19219) return 'C';
	if($asc>=-19218 && $asc<=-18711) return 'D';
	if($asc>=-18710 && $asc<=-18527) return 'E';
	if($asc>=-18526 && $asc<=-18240) return 'F';
	if($asc>=-18239 && $asc<=-17923) return 'G';
	if($asc>=-17922 && $asc<=-17418) return 'H';
	if($asc>=-17417 && $asc<=-16475) return 'J';
	if($asc>=-16474 && $asc<=-16213) return 'K';
	if($asc>=-16212 && $asc<=-15641) return 'L';
	if($asc>=-15640 && $asc<=-15166) return 'M';
	if($asc>=-15165 && $asc<=-14923) return 'N';
	if($asc>=-14922 && $asc<=-14915) return 'O';
	if($asc>=-14914 && $asc<=-14631) return 'P';
	if($asc>=-14630 && $asc<=-14150) return 'Q';
	if($asc>=-14149 && $asc<=-14091) return 'R';
	if($asc>=-14090 && $asc<=-13319) return 'S';
	if($asc>=-13318 && $asc<=-12839) return 'T';
	if($asc>=-12838 && $asc<=-12557) return 'W';
	if($asc>=-12556 && $asc<=-11848) return 'X';
	if($asc>=-11847 && $asc<=-11056) return 'Y';
	if($asc>=-11055 && $asc<=-10247) return 'Z';
	return null;
}

/**
 * 设置当前页面对象
 * @param int 0-用户  1-商家
 */
function WSTLoginTarget($target = 0){
	$WST_USER = session('WST_USER');
	$WST_USER['loginTarget'] = $target;
	session('WST_USER',$WST_USER);
}
/**
 * 邮件发送函数
 * @param string to      要发送的邮箱地址
 * @param string subject 邮件标题
 * @param string content 邮件内容
 * @return array
 */
function WSTSendMail($to, $subject, $content) {
	$rs = [];
	if(WSTConf("CONF.mailOpen")==1){
		$mail = new \phpmailer\phpmailer();
	    // 装配邮件服务器
	    $mail->IsSMTP();
	    $mail->SMTPDebug = 0;
	    $mail->Timeout = 5;
	    $mail->Host = (WSTConf("CONF.mailOpenSSL")==1?'ssl://':'').WSTConf("CONF.mailSmtp");
	    $mail->SMTPAuth = WSTConf("CONF.mailAuth");
	    $mail->Username = WSTConf("CONF.mailUserName");
	    $mail->Password = WSTConf("CONF.mailPassword");
	    $mail->CharSet = 'utf-8';
	    $mail->Port = WSTConf("CONF.mailPort");
	    // 装配邮件头信息
	    $mail->From = WSTConf("CONF.mailAddress");
	    $mail->AddAddress($to);
	    $mail->FromName = WSTConf("CONF.mailSendTitle");
	    $mail->IsHTML(true);
	    // 装配邮件正文信息
	    $mail->Subject = $subject;
	    $mail->Body = $content;
	    // 发送邮件
	    $rs =array();
	    if (!$mail->Send()) {
	    	$rs['status'] = 0;
	    	$rs['msg'] = $mail->ErrorInfo;
	        return $rs;
	    } else {
	    	$rs['status'] = 1;
	        return $rs;
	    }
	}
	return ['status'=>0,'msg'=>'未开启邮件发送功能'];
}

/**
 * 获取系统配置数据
 */
function WSTConfig(){
	$rs = cache('WST_CONF');
	if(!$rs){
		
		$rv = Db::name('sys_configs')->field('fieldCode,fieldValue')->select();
		$rs = [];
		foreach ($rv as $v){
			$rs[$v['fieldCode']] = $v['fieldValue'];
		}
		//获取风格
        $styles = Db::name('styles')->where(['isUse'=>1])->field('styleSys,stylePath,id')->select();
        if(!empty($styles)){
	        foreach ($styles as $key => $v) {
		        $rs['wst'.$v['styleSys'].'Style'] = $v['stylePath'];
		        $rs['wst'.$v['styleSys'].'StyleId'] = $v['id'];
	        }
        }
        //判断资源路径
        $rs['resourcePath'] = (isset($rs['ossService']) && $rs['ossService']!='')?WSTProtocol().$rs['ossBucket'].'.'.$rs['ossBucketDomain']:str_replace('/index.php','',request()->root());
        $rs['resourceDomain'] = (isset($rs['ossService']) && $rs['ossService']!='')?WSTProtocol().$rs['ossBucket'].'.'.$rs['ossBucketDomain']:str_replace('/index.php','',request()->root(true));
		//获取上传文件目录配置
		$data = Db::name('datas')->where('catId',3)->column('dataVal');
		foreach ($data as $key => $v){
			$data[$key] = str_replace('_','',$v);
		}
		$rs['wstUploads'] = $data;
		if($rs['shopLicense']=='')$rs['shopSlogan'] = $rs['shopSlogan']."  ".base64_decode('IC0gUG93ZXJlZCBCeSBXU1RTaG9w');
		cache('WST_CONF',$rs,31536000);
	}
	return $rs;
} 

/**
 * 判断手机号格式是否正确
 */
function WSTIsPhone($phoneNo){
	$reg = "/^1[\d]{10}$$/";
	$rs = \think\Validate::regex($phoneNo,$reg);
	return $rs;
}

/**
 * 检测登录账号是否可用
 * @param $key 要检测的内容
 */
function WSTCheckLoginKey($val,$userId = 0){
    if($val=='')return WSTReturn("登录账号不能为空");
    if(!WSTCheckFilterWords($val,WSTConf("CONF.registerLimitWords"))){
    	return WSTReturn("登录账号包含非法字符");
    }
    $dbo = Db::name('users')->where(["loginName|userEmail|userPhone"=>['=',$val],'dataFlag'=>1]);
    if($userId>0){
    	$dbo->where("userId", "<>", $userId);
    }
    $rs = $dbo->count();
    if($rs==0){
    	return WSTReturn("该登录账号可用",1);
    }
    return WSTReturn("对不起，登录账号已存在");
}

/**
 * 生成随机数账号
 */
function WSTRandomLoginName($loginName){
	$chars = array("a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z");
    //简单的派字母
    foreach ($chars as $key =>$c){
    	$crs = WSTCheckLoginKey($loginName."_".$c);
    	if($crs['status']==1)return $loginName."_".$c;
    }
    //随机派三位数值
    for($i=0;$i<1000;$i++){
    	$crs = $this->WSTCheckLoginKey($loginName."_".$i);
    	if($crs['status']==1)return $loginName."_".$i;
    }
    return '';
}

/**
 * 开启自动注册生成的随机账号
 */
function WSTAutoRegisterName(){
    $chars = array("a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z",'0','1','2','3','4','5','6','7','8','9');
    $loginName = '';
    for($i=0;$i<13;$i++){
        $rand = rand(0,35);
        $loginName .= $chars[$rand];
    }
    $loginName = 'wst_'.$loginName;
    $crs = WSTCheckLoginKey($loginName);
    if($crs['status']==1)return $loginName;
    return '';
}

/*
 * 微信端,小程序端自动注册
 */
function WSTAutoRegister($loginSrc = 0){
    $data = [];
    $openId = '';
    $user = [];
    $sendMsg = false;
    //检测账号是否存在
    $userName = '';
    $userPhoto = '';
    $wxUnionId = '';
    if($loginSrc == 5){
        $openId = input('openId','');
        $user = Db::name('users')->where(["weOpenId"=>$openId,'dataFlag'=>1])->find();
    }else{
        $openId = session('WST_WX_OPENID')?session('WST_WX_OPENID'):'';
        if($openId!=''){
            $user = Db::name('users')->where([["wxOpenId",'=',$openId],['dataFlag','=',1]])->find();
        }
        $userinfo = session('WST_WX_USERINFO');
        if($userinfo){
            $nickname = json_encode($userinfo['nickname']);
            $nickname = preg_replace("/\\\u[ed][0-9a-f]{3}\\\u[ed][0-9a-f]{3}/","*",$nickname);//替换成*
            $userName = json_decode($nickname);
            $userPhoto = $userinfo['headimgurl'];
            $wxUnionId = isset($userinfo['unionid'])?$userinfo['unionid']:'';
        }
    }
    if(empty($user)) {
        $sendMsg = true;
        $loginName = WSTAutoRegisterName();
        $crs = WSTCheckLoginKey($loginName);
        if ($crs['status'] != 1) return $crs;
        $data['loginName'] = $loginName;
        $data['loginPwd'] = rand(100000, 999999);
        $data["loginSecret"] = rand(1000, 9999);
        $data['loginPwd'] = $loginSrc == 1 ? md5($data['loginPwd'] . $data['loginSecret']) : '';
        $data['userName'] = ($userName!="")?$userName:$loginName;
        $data['userPhoto'] = ($userPhoto!="")?$userPhoto:"";
        $data['wxUnionId'] = ($wxUnionId!="")?$wxUnionId:"";
        $data['userQQ'] = "";
        $data['userScore'] = 0;
        $data['createTime'] = date('Y-m-d H:i:s');
        $data['dataFlag'] = 1;
        $data['userStatus'] = 1;
        if ($loginSrc == 5) {
            $data['weOpenId'] = $openId;
        } else {
            $data['wxOpenId'] = $openId;
        }
    }

    Db::startTrans();
    try {
        if(empty($user)) {
            $userId = Db::name('users')->insertGetId($data);
        }else {
            $userId = $user['userId'];
        }
        if (false !== $userId) {
            $data = array();
            $ip = request()->ip();
            $data['lastTime'] = date('Y-m-d H:i:s');
            $data['lastIP'] = $ip;
            Db::name('users')->where(["userId" => $userId])->update($data);
            //记录登录日志
            $data = array();
            $data["userId"] = $userId;
            $data["loginTime"] = date('Y-m-d H:i:s');
            $data["loginIp"] = $ip;
            $data['loginSrc'] = $loginSrc;
            Db::name('log_user_logins')->insert($data);
            $user = Db::name('users')->where(['userId' => $userId])->find();
            if ($user['userPhoto'] == '') $user['userPhoto'] = WSTConf('CONF.userLogo');
            if ($loginSrc == 1) {
                session('WST_USER', $user);
                //注册成功后执行钩子
                hook('afterUserRegist', ['user' => $user]);
            }

            //发送消息
            $tpl = WSTMsgTemplates('USER_REGISTER');
            if ($tpl['tplContent'] != '' && $tpl['status'] == '1' && $sendMsg) {
                $find = ['${LOGIN_NAME}', '${SHOP_NAME}'];
                $replace = [$user['loginName'], WSTConf('CONF.mallName')];
                WSTSendMsg($userId, str_replace($find, $replace, $tpl['tplContent']), ['from' => 0, 'dataId' => 0]);
            }
            if ($loginSrc == 5) {
                //记录tokenId
                $data = array();
                $key = sprintf('%011d', $userId);
                $tokenId = WSTToGuidString($key . time());
                $data['userId'] = $userId;
                $data['tokenId'] = $tokenId;
                $data['startTime'] = date('Y-m-d H:i:s');
                $data['deviceId'] = input('deviceId');
                Db::name('weapp_session')->insert($data);
                if(!empty($user)) {
                    //删除上一条登录记录
                    Db::name('weapp_session')->where('tokenId!="' . $tokenId . '" and userId=' . $userId)->delete();
                }
            }
            Db::commit();
            if ($loginSrc == 1) {
                return true;
            } else {
                return $tokenId;
            }
        }
    } catch (\Exception $e) {
        if ($loginSrc == 1) {
            session('WST_USER', null);
        }
        Db::rollback();
    }
    return false;
}

function WSTToGuidString($mix) {
    if (is_object($mix)) {
        return spl_object_hash($mix);
    } elseif (is_resource($mix)) {
        $mix = get_resource_type($mix) . strval($mix);
    } else {
        $mix = serialize($mix);
    }
    return md5($mix);
}

/**
 * 删除一维数组里的多个key
 */
function WSTUnset(&$data,$keys){
    if($keys!='' && is_array($data)){
        $key = explode(',',$keys);
        foreach ($key as $v)unset($data[$v]);
    }
}
/**
 * 只允许一维数组里的某些key通过
 */
function WSTAllow(&$data,$keys){
    if($keys!='' && is_array($data)){
        $key = explode(',',$keys);
        foreach ($data as $vkeys =>$v)if(!in_array($vkeys,$key))unset($data[$vkeys]);
    }
}

/**
 * 字符串替换
 * @param string $str     要替换的字符串
 * @param string $repStr  即将被替换的字符串
 * @param int $start      要替换的起始位置,从0开始
 * @param string $splilt  遇到这个指定的字符串就停止替换
 */
function WSTStrReplace($str,$repStr,$start,$splilt = ''){
	$newStr = substr($str,0,$start);
	$breakNum = -1;
	for ($i=$start;$i<strlen($str);$i++){
		$char = substr($str,$i,1);
		if($char==$splilt){
			$breakNum = $i;
			break;
		}
		$newStr.=$repStr;
	}
	if($splilt!='' && $breakNum>-1){
		for ($i=$breakNum;$i<strlen($str);$i++){
			$char = substr($str,$i,1);
			$newStr.=$char;
		}
	}
	return $newStr;
}

/**
 * 获取指定商品分类的子分类列表
 */
function WSTGoodsCats($parentId = 0,$isFloor = -1){
	$dbo = Db::name('goods_cats')->where(['dataFlag'=>1, 'isShow' => 1,'parentId'=>$parentId]);
	if($isFloor!=-1)$dbo->where('isFloor',$isFloor);
	return $dbo->field("catName,simpleName,catId")->order('catSort asc')->select();
}


/**
 * 上传图片
 * 需要生成缩略图： isThumb=1
 * 需要加水印：isWatermark=1
 * pc版缩略图： width height
 * 手机版原图：mWidth mHeight
 * 缩略图：mTWidth mTHeight
 * 判断图片来源：fromType 0：商家/用户   1：平台管理员
 */
function WSTUploadPic($fromType=0){
	$fileKey = key($_FILES);
	$dir = Input('param.dir');
	if($dir=='')return json_encode(['msg'=>'没有指定文件目录！','status'=>-1]);
	$dirs = WSTConf("CONF.wstUploads");
   	if(!in_array($dir, $dirs)){
   		return json_encode(['msg'=>'非法文件目录！','status'=>-1]);
   	}
   	// 上传文件
    $file = request()->file($fileKey);
    if($file===null){
    	return json_encode(['msg'=>'上传文件不存在或超过服务器限制','status'=>-1]);
    }
    $validate = new \think\Validate([
	    ['fileMime','fileMime:image/png,image/gif,image/jpeg,image/x-ms-bmp','只允许上传jpg,gif,png,bmp类型的文件'],
	    ['fileExt','fileExt:jpg,jpeg,gif,png,bmp','只允许上传后缀为jpg,gif,png,bmp的文件'],
	    ['fileSize','fileSize:20971520','文件大小超出限制'],//最大2M
	]);
	$data = ['fileMime'  => $file,
	    	 'fileSize' => $file,
	         'fileExt'=> $file
	        ];
	if (!$validate->check($data)) {
	    return json_encode(['msg'=>$validate->getError(),'status'=>-1]);
	}
    $info = $file->rule('uniqid')->move(ROOT_PATH.'/upload/'.$dir."/".date('Y-m'));
    if($info){
    	$filePath = $info->getPathname();
    	$filePath = str_replace(ROOT_PATH,'',$filePath);
    	$filePath = str_replace('\\','/',$filePath);
    	$name = $info->getFilename();
    	$filePath = str_replace($name,'',$filePath);
    	//原图路径
    	$imageSrc = trim($filePath.$name,'/');
    	//图片记录
    	WSTRecordResources($imageSrc, (int)$fromType);
    	//打开原图
    	$image = \image\Image::open($imageSrc);
    	//缩略图路径 手机版原图路径 手机版缩略图路径
    	$thumbSrc = $mSrc = $mThumb = null;
    	//手机版原图宽高
    	$mWidth = min($image->width(),(int)input('mWidth',700));
		$mHeight = min($image->height(),(int)input('mHeight',700));
		//手机版缩略图宽高
		$mTWidth = min($image->width(),(int)input('mTWidth',250));
		$mTHeight = min($image->height(),(int)input('mTHeight',250));

    	/****************************** 生成缩略图 *********************************/
    	$isThumb = (int)input('isThumb');
    	if($isThumb==1){
    		//缩略图路径
    		$thumbSrc = str_replace('.', '_thumb.', $imageSrc);
    		$image->thumb((int)input('width',min(300,$image->width())), (int)input('height',min(300,$image->height())),2)->save($thumbSrc,$image->type(),90);
    		//是否需要生成移动版的缩略图
    		$suffix = WSTConf("CONF.wstMobileImgSuffix");
    		if(!empty($suffix)){
    			$image = \image\Image::open($imageSrc);
    			$mSrc = str_replace('.',"$suffix.",$imageSrc);
    			$mThumb = str_replace('.', '_thumb.',$mSrc);
    			$image->thumb($mWidth, $mHeight)->save($mSrc,$image->type(),90);
    			$image->thumb($mTWidth, $mTHeight, 2)->save($mThumb,$image->type(),90);
    		}


    	}
    	/***************************** 添加水印 ***********************************/
    	$isWatermark=(int)input('isWatermark');
    	if($isWatermark==1 && (int)WSTConf('CONF.watermarkPosition')!==0){
	    	//取出水印配置
	    	$wmWord = WSTConf('CONF.watermarkWord');//文字
	    	$wmFile = trim(WSTConf('CONF.watermarkFile'),'/');//水印文件
	    	$wmPosition = (int)WSTConf('CONF.watermarkPosition');//水印位置
	    	$wmSize = ((int)WSTConf('CONF.watermarkSize')!=0)?WSTConf('CONF.watermarkSize'):'20';//大小
	    	$wmColor = (WSTConf('CONF.watermarkColor')!='')?WSTConf('CONF.watermarkColor'):'#000000';//颜色必须是16进制的
	    	$wmOpacity = ((int)WSTConf('CONF.watermarkOpacity')!=0)?WSTConf('CONF.watermarkOpacity'):'100';//水印透明度
	    	//是否有自定义字体文件
	    	$customTtf = $_SERVER['DOCUMENT_ROOT'].WSTConf('CONF.watermarkTtf');
	    	$ttf = is_file($customTtf)?$customTtf:EXTEND_PATH.'/verify/verify/ttfs/3.ttf';
	        $image = \image\Image::open($imageSrc);
	    	if(!empty($wmWord)){//当设置了文字水印 就一定会执行文字水印,不管是否设置了文件水印
		    	
	    		//执行文字水印
	    		$image->text($wmWord, $ttf, $wmSize, $wmColor, $wmPosition)->save($imageSrc);
	    		if($thumbSrc!==null){
	    			$image->thumb((int)input('width',min(300,$image->width())), (int)input('height',min(300,$image->height())),2)->save($thumbSrc,$image->type(),90);
	    		}
	    		//如果有生成手机版原图
	    		if(!empty($mSrc)){
	    			$image = \image\Image::open($imageSrc);
	    			$image->thumb($mWidth, $mHeight)->save($mSrc,$image->type(),90);
	    			$image->thumb($mTWidth, $mTHeight, 2)->save($mThumb,$image->type(),90);
	    		}
	    	}elseif(!empty($wmFile)){//设置了文件水印,并且没有设置文字水印
	    		//执行图片水印
	    		$image->water($wmFile, $wmPosition, $wmOpacity)->save($imageSrc);
	    		if($thumbSrc!==null){
	    			$image->thumb((int)input('width',min(300,$image->width())), (int)input('height',min(300,$image->height())),2)->save($thumbSrc,$image->type(),90);
	    		}
	    		//如果有生成手机版原图
	    		if($mSrc!==null){
	    			$image = \image\Image::open($imageSrc);
	    			$image->thumb($mWidth, $mHeight)->save($mSrc,$image->type(),90);
	    			$image->thumb($mTWidth, $mTHeight,2)->save($mThumb,$image->type(),90);
	    		}
	    	}
    	}
    	//判断是否有生成缩略图
    	$thumbSrc = ($thumbSrc==null)?$info->getFilename():str_replace('.','_thumb.', $info->getFilename());
		$filePath = ltrim($filePath,'/');
		// 用户头像上传宽高限制
		$isCut = (int)input('isCut');
		if($isCut){
			$imgSrc = $filePath.$info->getFilename();
			$image = \image\Image::open($imgSrc);
			$size = $image->size();//原图宽高
			$w = $size[0];
			$h = $size[1];
			$rate = $w/$h;
			if($w>$h && $w>500){
				$newH = 500/$rate;
				$image->thumb(500, $newH)->save($imgSrc,$image->type(),90);
			}elseif($h>$w && $h>500){
				$newW = 500*$rate;
				$image->thumb($newW, 500)->save($imgSrc,$image->type(),90);
			}
		}
		$rdata = ['status'=>1,'savePath'=>$filePath,'name'=>$info->getFilename(),'thumb'=>$thumbSrc];
		hook('afterUploadPic',['data'=>&$rdata,'isLocation'=>(int)input('isLocation')]);
        return json_encode($rdata);
    }else{
        //上传失败获取错误信息
        return $file->getError();
    }    
}

/**
 * 上传视频
 */
function WSTUploadVideo(){
	$fileKey = key($_FILES);
	$dir = input('post.dir');
	if($dir=='')return json_encode(['msg'=>'没有指定文件目录！','status'=>-1]);
	$dirs = WSTConf("CONF.wstUploads");
   	if(!in_array($dir, $dirs)){
   		return json_encode(['msg'=>'非法文件目录！','status'=>-1]);
   	}
   	//上传文件
    $file = request()->file($fileKey);
    if($file===null){
    	return json_encode(['msg'=>'上传文件不存在或超过服务器限制','status'=>-1]);
    }
    $rule = ['ext'=>'3gp,mp4,rmvb,mov,avi,m4v'];
    $info = $file->validate($rule)->rule('uniqid')->move(ROOT_PATH.'/upload/'.$dir."/".date('Y-m'));
	if($info){
		//保存路径
	    $filePath = $info->getPathname();
		$filePath = str_replace(ROOT_PATH.'/','',$filePath);
		$filePath = str_replace('\\','/',$filePath);
		$name = $info->getFilename();
		$filePath = str_replace($name,'',$filePath);
		$rdata = ['status'=>1,'name'=>$info->getFilename(),'savePath'=>$filePath];
		// 视频记录
		$videoSrc = trim($filePath.$name,'/');
		// 只有商家才能上传视频
    	WSTRecordResources($videoSrc, 0, 1);
		hook('afterUploadPic',['data'=>&$rdata,'isVideo'=>true]);
		return json_encode($rdata);
	}else{
		//上传失败获取错误信息
		return $file->getError();
	}
}
/**
 * 上传文件
 */
function WSTUploadFile(){
	$fileKey = key($_FILES);
	$dir = Input('post.dir');
	if($dir=='')return json_encode(['msg'=>'没有指定文件目录！','status'=>-1]);
	$dirs = WSTConf("CONF.wstUploads");
   	if(!in_array($dir, $dirs)){
   		return json_encode(['msg'=>'非法文件目录！','status'=>-1]);
   	}
   	//上传文件
    $file = request()->file($fileKey);
    if($file===null){
    	return json_encode(['msg'=>'上传文件不存在或超过服务器限制','status'=>-1]);
    }
    $validate = new \think\Validate([
	    ['fileExt','fileExt:xls,xlsx,xlsm','只允许上传后缀为xls,xlsx,xlsm的文件']
	]);
	$data = ['fileExt'=> $file];
	if (!$validate->check($data)) {
	    return json_encode(['msg'=>$validate->getError(),'status'=>-1]);
	}
    $info = $file->rule('uniqid')->move(ROOT_PATH.'/upload/'.$dir."/".date('Y-m'));
    //保存路径
    $filePath = $info->getPathname();
	$filePath = str_replace(ROOT_PATH,'',$filePath);
	$filePath = str_replace('\\','/',$filePath);
	$name = $info->getFilename();
	$filePath = str_replace($name,'',$filePath);
	if($info){
		return json_encode(['status'=>1,'name'=>$info->getFilename(),'route'=>$filePath]);
	}else{
		//上传失败获取错误信息
		return $file->getError();
	}
}
/**
 * 生成默认商品编号/货号
 */
function WSTGoodsNo($pref = ''){
	return $pref.(round(microtime(true),4)*10000).mt_rand(0,9);
}

/**
* 资源管理
* @param $resPath    资源路径
* @param $fromType   0：用户/商家 1：平台管理员
* @param $resType   0：图片 1：视频
*/
function WSTRecordResources($resPath, $fromType, $resType=0){
	$data = [];
	$data['resPath'] = $resPath;
	if(file_exists($resPath)){
		$data['resSize'] = filesize($resPath); //返回字节数 resSize/1024 k  	resSize/1024/1024 m
	}
	//获取表名
	$table = explode('/',$resPath);
	$data['fromTable'] = $table[1];
	$data['fromType'] = (int)$fromType; 
	//根据类型判断所有者
	$data['ownId'] = ((int)$fromType==0)?(int)session('WST_USER.userId'):(int)session('WST_STAFF.staffId');
	$data['isUse'] = 0; //默认不使用
	$data['createTime'] = date('Y-m-d H:i:s');
	$data['resType'] = $resType;

	//保存记录
	Db::name('resources')->insert($data);

}
/**
* 启用资源文件
* @param $fromType 0：  用户/商家 1：平台管理员
* @param $dataId        来源记录id
* @param $resPath       资源路径,要处理多个资源时请传入一位数组,或用","连接资源路径
* @param $fromTable     该记录来自哪张表
* @param $resFieldName  表中的资源字段名称
*/
function WSTUseResources($fromType, $dataId, $resPath, $fromTable='', $resFieldName=''){
	if(empty($resPath))return;

	$image['fromType'] = (int)$fromType;
	//根据类型判断所有者
	$image['ownId'] = ((int)$fromType==0)?(int)session('WST_USER.userId'):(int)session('WST_STAFF.staffId');
	$image['dataId'] = (int)$dataId;

	$image['isUse'] = 1;//标记为启用
	if($fromTable!=''){
		$tmp = ['',''];
		if(strpos($fromTable,'-')!==false){
			$tmp = explode('-',$fromTable);
			$fromTable = str_replace('-'.$tmp[1],'',$fromTable);
		}
		$image['fromTable'] = str_replace('_','',$fromTable.$tmp[1]);
	}

	$resPath = is_array($resPath)?$resPath:explode(',',$resPath);//转数组


	//用于与旧图比较
	$newRes = $resPath;

	// 不为空说明执行修改
	if($resFieldName!=''){
		//要操作的表名  $fromTable;
		// 获取`$fromTable`表的主键
		$prefix = config('database.prefix');
		$tableName = $prefix.$fromTable;
		$pk = Db::getTableInfo("$tableName", 'pk');
		// 取出旧图
		$oldResPath = model("$fromTable")->where("$pk",$dataId)->value("$resFieldName"); 
		// 转数组
		$oldResPath = explode(',', $oldResPath);

		// 1.要设置为启用的文件
		$newRes = array_diff($resPath, $oldResPath);
		// 2.要标记为删除的文件
		$oldResPath = array_diff($oldResPath, $resPath);
		//旧图数组跟新图数组相同则不需要继续执行
		if($newRes!=$oldResPath)WSTUnuseResources($oldResPath);
	}
	if(!empty($newRes)){
		Db::name('resources')->where(['resPath'=>['in',$newRes]])->update($image);
	}
}

/**
* 编辑器图片记录
* @param $fromType 0：  用户/商家 1：平台管理员
* @param $dataId        来源记录id
* @param $oldDesc       旧商品描述
* @param $newDesc       新商品描述
*/
function WSTEditorImageRocord($fromType, $dataId, $oldDesc, $newDesc){
		// 解义
		$oldDesc = htmlspecialchars_decode($oldDesc);
		$newDesc = htmlspecialchars_decode($newDesc);

		//编辑器里的图片
		$rule = '/src=".*?\/(upload.*?)"/';
	    // 获取旧的src数组
	    preg_match_all($rule,$oldDesc,$images);
	    $oldResPath = $images[1];
	    preg_match_all($rule,$newDesc,$images);  
	    // 获取新的src数组
	    $resPath = $images[1];
		// 1.要设置为启用的文件
		$newImage = array_diff($resPath, $oldResPath);
		// 2.要标记为删除的文件
		$oldResPath = array_diff($oldResPath, $resPath);

		//旧图数组跟新图数组相同则不需要继续执行
		if($newImage!=$oldResPath){
			//标记新图启用
			WSTUseResources($fromType, $dataId, $newImage);
			//标记旧图删除
			WSTUnuseResources($oldResPath);
		}
}

/**
* 标记删除资源文件
*/
function WSTUnuseResources($fromTable, $field = '' , $dataId = 0){
	if($fromTable=='')return;
	$resPath = $fromTable;
	if($field!=''){
		$prefix = config('database.prefix');
		$tableName = $prefix.$fromTable;
		$pk = Db::getTableInfo("$tableName", 'pk');
		// 取出旧资源
		$resPath = model("$fromTable")->where("$pk",$dataId)->value("$field");
	}
	if(!empty($resPath)){
		$resPath = is_array($resPath)?$resPath:explode(',',$resPath);//转数组
		Db::name('resources')->where(['resPath'=>['in',$resPath]])->setField('isUse',0);
	}
}
/**
 * 获取系统根目录
 */
function WSTRootPath(){
	return dirname(dirname(dirname(dirname(__File__))));
}
/**
 * 切换图片
 * @param $imgurl 图片路径
 * @param $imgType 图片类型    0:PC版大图   1:PC版缩略图       2:移动版大图    3:移动版缩略图
 * 图片规则  
 * PC版版大图 :201635459344.jpg
 * PC版版缩略图 :201635459344_thumb.jpg
 * 移动版大图 :201635459344_m.jpg
 * 移动版缩略图 :201635459344_m_thumb.jpg
 */
function WSTImg($imgurl,$imgType = 1){
	$m = WSTConf('CONF.wstMobileImgSuffix');
	$imgurl = str_replace($m.'.','.',$imgurl);
	$imgurl = str_replace($m.'_thumb.','.',$imgurl);
	$imgurl = str_replace('_thumb.','.',$imgurl);
	$img = '';
	switch ($imgType){
		case 0:$img =  $imgurl;break;
		case 1:$img =  str_replace('.','_thumb.',$imgurl);break;
		case 2:$img =  str_replace('.',$m.'.',$imgurl);break;
		case 3:$img =  str_replace('.',$m.'_thumb.',$imgurl);break;
	}
	return ((file_exists(WSTRootPath()."/".$img))?$img:$imgurl);
}
/**
 * 生成订单号
 */
function WSTOrderNo(){
    $orderId = Db::name('orderids')->insertGetId(['rnd'=>time()]);
	return $orderId.(fmod($orderId,7));
}
/**
 * 高精度数字相加
 * @param $num
 * @param number $i 保留小数位
 */
function WSTBCMoney($num1,$num2,$i=2){
	$num = bcadd($num1, $num2, $i);
	return (float)$num;
}
/**
 * 获取支付方式
 */
function WSTLangPayType($v){
	return ($v==1)?"在线支付":"货到付款";
}
/**
 * 收货方式
 */
function WSTLangDeliverType($v){
	return ($v==1)?"自提":"送货上门";
}
/**
 * 订单状态
 */
function WSTLangOrderStatus($v){
	switch($v){
		case -3:return '用户拒收';
		case -2:return '待支付';
		case -1:return '已取消';
		case 0:return '待发货';
		case 1:return '待收货';
		case 2:return '已收货';
	}
}
/**
 * 积分来源
 */
function WSTLangScore($v){
    switch($v){
		case 1:return '商品订单';
		case 2:return '评价订单';
		case 5:return '积分签到';
		default:return '其他';
	}
}
/**
 * 资金来源
 */
function WSTLangMoneySrc($v){
    switch($v){
		case 1:return '商品订单';
		case 2:return '订单结算';
		case 3:return '提现申请';
		case 4:return '钱包充值';
		default:return '其他';
	}
}
/**
 * 积分来源
 */
function WSTLangComplainStatus($v){
    switch($v){
		case 0:return '等待处理';
		case 1:return '等待应诉人应诉';
		case 2:return '应诉人已应诉';
		case 3:return '等待仲裁';
		case 4:return '已仲裁';
	}
}
/**
 * 支付来源
 */
function WSTLangPayFrom($pkey){
    $paySrc = cache('WST_PAY_SRC');
    if(!$paySrc){
        $paySrc = Db::name('payments')->where(['enabled'=>1])->order('payOrder asc')->select();
        cache('WST_PAY_SRC',$paySrc,31622400);
    }
    foreach($paySrc as $v){
       if($pkey==$v['payCode'])return $v['payName'];
    }
    return '其他';
}
/**
 * 获取业务数据内容【根据catCode获取】
 */
function WSTDatas($catCode,$id = 0){
	$catId = (int)Db::name('data_cats')->where(['catCode'=>$catCode])->value('catId');
	$rs = Db::name('datas')->where(['dataFlag'=>1])->order('catId asc,dataSort asc,id asc')->cache(31536000)->select();
	$data = [];
	foreach ($rs as $key =>$v){
		$data[$v['catId']][$v['dataVal']] = $v;
	}
	if(isset($data[$catId])){
		if($id==0)return $data[$catId];
		return isset($data[$catId][$id])?$data[$catId][$id]:'';
	}
	return [];
}
/**
 * 截取字符串
 */
function WSTMSubstr($str, $start = 0, $length, $charset = "utf-8", $suffix = false){
	$newStr = '';
	if (function_exists ( "mb_substr" )) {
		if ($suffix){
			$newStr = mb_substr ( $str, $start, $length, $charset )."...";
		}else{
			$newStr = mb_substr ( $str, $start, $length, $charset );
		}
	} elseif (function_exists ( 'iconv_substr' )) {
		if ($suffix){
			$newStr = iconv_substr ( $str, $start, $length, $charset )."...";
		}else{
			$newStr = iconv_substr ( $str, $start, $length, $charset );
		}
	}
	if($newStr==''){
	$re ['utf-8'] = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|[\xe0-\xef][\x80-\xbf]{2}|[\xf0-\xff][\x80-\xbf]{3}/";
	$re ['gb2312'] = "/[\x01-\x7f]|[\xb0-\xf7][\xa0-\xfe]/";
	$re ['gbk'] = "/[\x01-\x7f]|[\x81-\xfe][\x40-\xfe]/";
	$re ['big5'] = "/[\x01-\x7f]|[\x81-\xfe]([\x40-\x7e]|\xa1-\xfe])/";
	preg_match_all ( $re [$charset], $str, $match );
	$slice = join ( "", array_slice ( $match [0], $start, $length ) );
	if ($suffix)
		$newStr = $slice;
	}
	return $newStr;
}
function WSTScore($score,$users,$type = 5,$len = 0,$total = 1){
	if((int)$score==0)return $type;
	switch($type){
		case 5:return round($score/$total/$users,0);
		case 10:return round($score/$total*2/$users,$len);
		case 100:return round($score/$total*2/$users,$len);
	}
}
function WSTShopEncrypt($goodsId){
	return md5(base64_encode("wstshop".date("Y-m-d").$goodsId));
}
/**
 * 根据子分类循环获取其父级分类
 */
function WSTGoodsCatPath($catId, $data = []){
    if($catId==0)return $data;
    $data[] = $catId;
	$parentId = Db::name('goods_cats')->where('catId',$catId)->value('parentId');
	if($parentId==0){
		krsort($data);
		return $data;
	}else{
		return WSTGoodsCatPath($parentId, $data);
	}
}
/**
 * 提供原生分页处理
 */
function WSTPager($total,$rs,$page,$size = 0){
	$pageSize = ($size>0)?$size:config('paginate.list_rows');
	$totalPage = ($total%$pageSize==0)?($total/$pageSize):(intval($total/$pageSize)+1);
	return ['Total'=>$total,'PerPage'=>$pageSize,'CurrentPage'=>$page,'TotalPage'=>$totalPage,'Rows'=>$rs];
}


/**
* 编辑器上传图片
*/
function WSTEditUpload($fromType){
	$root = str_replace('/index.php','',\think\Request::instance()->root());
    //PHP上传失败
    if (!empty($_FILES['imgFile']['error'])) {
        switch($_FILES['imgFile']['error']){
            case '1':
                $error = '超过php.ini允许的大小。';
                break;
            case '2':
                $error = '超过表单允许的大小。';
                break;
            case '3':
                $error = '图片只有部分被上传。';
                break;
            case '4':
                $error = '请选择图片。';
                break;
            case '6':
                $error = '找不到临时目录。';
                break;
            case '7':
                $error = '写文件到硬盘出错。';
                break;
            case '8':
                $error = 'File upload stopped by extension。';
                break;
            case '999':
            default:
                $error = '未知错误。';
        }
        return ['error'=>1,'msg'=>$error];
    }

    $fileKey = key($_FILES);
	$dir = 'image'; // 编辑器上传图片目录
	$dirs = WSTConf("CONF.wstUploads");
   	if(!in_array($dir, $dirs)){
   		return json_encode(['error'=>1,'message'=>'非法文件目录！']);
   	}
   	// 上传文件
    $file = request()->file($fileKey);
    if($file===null){
    	return json_encode(["error"=>1,"message"=>'上传文件不存在或超过服务器限制']);
	}
	// 图片验证规则
	$validateRule = [
	    ['fileMime','fileMime:image/png,image/gif,image/jpeg,image/x-ms-bmp','只允许上传jpg,gif,png,bmp类型的文件'],
	    ['fileExt','fileExt:jpg,jpeg,gif,png,bmp','只允许上传后缀为jpg,gif,png,bmp的文件'],
	    ['fileSize','fileSize:2097152','文件大小超出限制'],//最大2M
	];
	$mediaType = 0;
	if(input('dir')=='media'){
		// 上传类型为视频或音频时，不限制大小
		$validateRule = [
			['fileMime','fileMime:video/3gp,video/mp4,video/rmvb,video/mov,video/avi,video/m4v','只允许上传3gp,mp4,rmvb,mov,avi,m4v类型的文件'],
			['fileExt','fileExt:3gp,mp4,rmvb,mov,avi,m4v','只允许上传后缀为3gp,mp4,rmvb,mov,avi,m4v的文件']
		];
		$mediaType = 1;
	}
    $validate = new \think\Validate($validateRule);
	$data = ['fileMime'  => $file,
	    	 'fileSize' => $file,
	         'fileExt'=> $file
	        ];
	if (!$validate->check($data)) {
	    return json_encode(['message'=>$validate->getError(),'error'=>1]);
	}
    $info = $file->rule('uniqid')->move(ROOT_PATH.'/upload/'.$dir."/".date('Y-m'));
    if($info){
    	$filePath = $info->getPathname();
    	$filePath = str_replace(ROOT_PATH,'',$filePath);
    	$filePath = str_replace('\\','/',$filePath);
    	$name = $info->getFilename();
    	$imageSrc = trim($filePath,'/');
    	//图片记录
    	WSTRecordResources($imageSrc, (int)$fromType, $mediaType);
    	return json_encode(array('error' => 0, 'url' => $root.$filePath));
	}
	return json_encode(["error"=>1,"message"=>$file->getError()]);
}
/**
 * 转义单引号
 */
function WSTHtmlspecialchars($v){
	return htmlspecialchars($v,ENT_QUOTES);
}

/**
* 发送商城消息
* @param int 	$to 接受者d
* @param string $content 内容
* @param array  $msgJson 存放json数据
*/
function WSTSendMsg($to,$content,$msgJson=[],$msgType = 1){
	$message = [];
	$message['msgType'] = $msgType;
	$message['sendUserId'] = 1;
	$message['createTime'] = date('Y-m-d H:i:s');
	$message['msgStatus'] = 0;
	$message['dataFlag'] = 1;

	$message['receiveUserId'] = $to;
	$message['msgContent'] = $content;
	$message['msgJson'] = json_encode($msgJson);
	Db::name('messages')->insert($message);

}
/**
 * 将传过来的字符串格式化为数值字符串
 * @param string $split 要格式的字符串
 * @param string $str 字符串中的分隔符号
 * @param boolean $isJoin 是否连成字符串返回
 */
function WSTFormatIn($split,$str,$isJoin = true){
    if($str=='')return $isJoin?'':[];
    $strdatas = explode($split,$str);
    $data = array();
    for($i=0;$i<count($strdatas);$i++){
        $data[] = (int)$strdatas[$i];
    }
    $data = array_unique($data);
    if($isJoin)return implode($split,$data);
    return $data;

}

/**
 * 根据送货城市获取运费
 * @param $cityId 送货城市Id
 * @param @shopIds 店铺ID
 */
function WSTOrderFreight($cityId){
	$rs = Db::name('freights')
	     ->where('areaId2',$cityId)->field('freight')->find();
	// 该地区未设置运费则取后台默认运费
	$rs['freight'] = (((string)$rs['freight']===''))?WSTConf('CONF.defaultFreight'):$rs['freight'];
    return (float)$rs['freight'];
}

/**
 * 获取路由规则
 */
function WSTRoute(){
	$data = cache('WST_ROUTES');
	if(!$data){
		$routes = \think\Route::rules('*');
		$data = [];
		foreach ($routes as $key => $v) {
			if($v['rule']=='addon/:route')continue;
			$data[$v['route']] = $v['rule'];
		}
		cache('WST_ROUTES',$data,31536000);
	}
	return json_encode($data);
}

/**
 * 获取项目根路径
 */
function WSTDomain(){
	$url  = request()->root(true);
	$data = explode("/index.php",$url);
	return $data[0];
}

/**
 * URL 64位加密处理
 * @param string $data 字符串内容
 * @param boolean $isEncode true:编码  false:解码
 */
function WSTBase64url($data,$isEncode = true) { 
  return ($isEncode)?rtrim(strtr(base64_encode($data), '+/', '-_'), '='):base64_decode(str_pad(strtr($data, '-_', '+/'), strlen($data) % 4, '=', STR_PAD_RIGHT)); 
}


/**
 * URL 64位加密处理[编码]
 * @param string $data 字符串内容
 */
function WSTBase64urlEncode($data){
	$secretKey = WSTConf('CONF.urlSecretKey');
	$base64 = new \org\Base64();
 	$key = WSTBase64url($base64->encrypt($data, $secretKey),true);
 	return $key;
}

/**
 * URL 64位加密处理[解码]
 * @param string $data 字符串内容
 */
function WSTBase64urlDecode($data){
	$secretKey = WSTConf('CONF.urlSecretKey');
	$key = WSTBase64url($data,false);
	$base64 = new \org\Base64();
  	$key = $base64->decrypt($key,$secretKey);
  	return $key;
}


/**
 * 插件状态
 */
function WSTLangAddonStatus($v){
	switch($v){
		case 0:return '未安装';
		case 1:return '启用';
		case 2:return '禁用';
	}
}

function WSTClearHookCache(){
	WSTConf('listenUrl',null);
	$STAFF = session('WST_STAFF');
	if(!empty($STAFF)){
		//获取角色权限
		$STAFF['privileges'] = Db::name('privileges')->where(['dataFlag'=>1])->column('privilegeCode');
		$STAFF['menuIds'] = Db::name('menus')->where('dataFlag',1)->column('menuId');
		session('WST_STAFF',$STAFF);
	}
	WSTConf('protectedUrl',null);
	cache('WST_HOME_MENUS',null);
	cache('WST_PRO_MENUS',null);
	cache('WST_MOBILE_BTN',null);
	cache('hooks',null);
	cache('WST_ADDONS',null);
	WSTConf('WST_ADDONS',null);
}

/**
 * 积分兑金额
 * $isBack=true则$score实际上传入金额，通过金额反推需要兑换的积分
 */
function WSTScoreToMoney($score,$isBack = false){
	$scoreToMoney = (int)WSTConf('CONF.scoreToMoney');
	if($scoreToMoney<=0)return 0;
	if($isBack){
		return intval(strval($score*$scoreToMoney));
	}else{
		return round($score/$scoreToMoney,2);
	}
}

/**
 * 将空内容设置为特定内容
 * @param [type] $[name] [description]
 */
function WSTBlank($v,$defaultValue = ''){
	if($v=='')return $defaultValue;
	if($v=='0000-00-00')return $defaultValue;
	if($v=='0000-00-00 00:00:00')return $defaultValue;
}

/**
 * 判断访问端来源
 */
function WSTVisitModule(){
    $request = request();
    if($request->isMobile()){
        return (strpos($_SERVER['HTTP_USER_AGENT'], 'MicroMessenger') !== false)?'wechat':'mobile';
    }
    return 'home';
}

/**
 * 获取消息模板
 */
function WSTMsgTemplates($tplCode){
    $data = cache('WST_MSG_TEMPLATES');
	if(!$data){
		$rs = Db::name('template_msgs')->order('id asc')->select();
		$data = [];
		foreach ($rs as $key =>$v){
			if($v['tplType']==3 && (int)WSTConf('CONF.wxenabled')==1){
				$ps = Db::name('wx_template_params')->where('parentId',$v['id'])->select();
				$v['params'] = $ps;
			}
			if($v['tplContent']==''){
                $data[$v['tplCode']] = $v;
			}else{
				$v['content'] = htmlspecialchars_decode($v['tplContent']);
				$v['tplContent'] = strip_tags(htmlspecialchars_decode($v['tplContent']));
				$data[$v['tplCode']] = $v;
			}
		}
		cache('WST_MSG_TEMPLATES',$data,378432000);
	}
	return (isset($data[$tplCode]))?$data[$tplCode]:null;
}
/**
 * 发送微信消息
 */
function WSTWxMessage($params){
    $tpl = WSTMsgTemplates($params['CODE']);
	if($tpl && file_exists('wstshop'.DS.'wechat'.DS.'behavior'.DS.'InitWechatMessges.php')){
		\think\Hook::exec('wstshop\\wechat\\behavior\\InitWechatMessges','run',$params);
	}
}
/**
 * 批量发送微信消息
 */
function WSTWxBatchMessage($params){
    $tpl = WSTMsgTemplates($params['CODE']);
	if($tpl && file_exists('wstshop'.DS.'wechat'.DS.'behavior'.DS.'InitWechatMessges.php')){
		\think\Hook::exec('wstshop\\wechat\\behavior\\InitWechatMessges','batchRun',$params);
	}
}
/**
 * 金额兑积分
 */
function WSTMoneyGiftScore($money){
    $moneyToScore = (float)WSTConf('CONF.moneyToScore');
    return intval($money*$moneyToScore);
}

function WSTOrderQnique(){
	return (round(microtime(true),4)*10000).mt_rand(1000,9999);
}
/**
 * 获取移动端首页按钮
 */
function WSTMobileBtns($src){
    $data = cache('WST_MOBILE_BTN');
    if(!$data){
        $rs = Db::name('mobile_btns')->order('btnSort asc')->select();
        $data = [];
        foreach ($rs as $key => $v) {
        	$data[$v['btnSrc']][] = $v;
        }
        cache('WST_MOBILE_BTN',$data,31536000);
    }

    return isset($data[$src])?$data[$src]:[];
}

/**
 * 获取用户等级
 */
function WSTUserRank($userScore){
	$data = cache('WST_USER_RANK');
	if(!$data){
		$data =  Db::name('user_ranks')->where('dataFlag',1)->order('startScore asc,rankId desc')->select();
	    cache('WST_USER_RANK',$data,2592000);
	}
	if(!$data)$data = [];
	foreach ($data as $key => $v) {
		if($userScore>=$v['startScore'] && $userScore<$v['endScore'])return $v;
	}
	return ['rankName'=>'','rankId'=>0,'userrankImg'=>''];

}

/**
 * 头像处理
 */
function WSTUserPhoto($userPhoto=''){
	if(substr($userPhoto,0,4)!='http' && $userPhoto){
		$userPhoto  = WSTDomain()."/".$userPhoto;
	}else if(!$userPhoto){
		$userPhoto  = WSTDomain()."/".WSTConf('CONF.userLogo');
	}
	return $userPhoto;
}
/**
* 增加文章访问数
*/
function WSTArticleVisitorNum($id){
	Db::name('articles')->where(['articleId'=>$id])->setInc('visitorNum',1);
}

/**
 * 保持数值为大于0的数值
 */
function WSTPositiveNum($num){
   return ($num>0)?$num:0;
}

/**
 * 将字符串转换为时间戳，解决部分服务器时间不能超过2038的问题
 */
function WSTStrToTime($str){
   if(strtotime('2099-09-09 23:59:59')){
       return strtotime($str);
   }else{
   	   $date = new DateTime($str);
       return $date->format('U');
   }
}

/**
 * 清除整个所有缓存
 * 注意：此函数非迫不得己不要调用。能删除指定缓存的就尽量删除指定缓存。尽量只在后台管理员才做时调用，前台用户操作就不要调用了
 */
function WSTClearAllCache(){
	cache(null);
}

/**
 * 适应mmgrid的表格返回结构
 */
function WSTGrid($page){
	if(!is_array($page))$page = $page->toArray();
	$rs = ['status'=>1,'msg'=>'','items'=>$page['Rows'],'totalCount'=>$page['Total']];
	return $rs;
}

/**
 * 建立文件夹
 * @param string $aimUrl
 * @return viod
 */
function WSTCreateDir($aimUrl) {
	$aimUrl = str_replace('', '/', $aimUrl);
	$aimDir = '';
	$arr = explode('/', $aimUrl);
	$result = true;
	foreach ($arr as $str) {
		$aimDir .= $str . '/';
		if (!file_exists($aimDir)) {
			$result = mkdir($aimDir,0777);
		}
	}
	return $result;
}
/**
 * 获取购物车数量
 */
function WSTCartNum(){
	$userId = session('WST_USER.userId');
	$cartNum = Db::name('carts')->where(['userId'=>$userId])->field('cartId')->select();
	$count = count($cartNum);
	return $count;
}

/**
 * 页面转换
 */
function WSTSwitchs($omodule = '',$ocontroller = '',$oaction = '',$oaddon = ''){
	$request = request();
	$module = ($omodule!='')?$omodule:strtolower($request->module());
	$controller = ($ocontroller!='')?$ocontroller:strtolower($request->controller());
	$action = ($oaction!='')?$oaction:strtolower($request->action());
	$currURL =  $module."/".$controller."/".$action;//当前页面
	$allowURL = ['weixinpays',
				 'unionpays',
				 'alipays',
				 'weixinpaysmo',
				 'weixinpayswx',
				 'cron'];		 
	//遇到放行的url则不转换
    if(in_array($controller,$allowURL))return;
    $data = cache('WST_SWITCHS');
    if(!$data){
    	$rs  = Db::name('switchs')->select();
    	$data = [];
        foreach ($rs as $key => $v) {
        	$data[strtolower($v['homeURL'])] = ['home'=>$v['homeURL'],'mobile'=>$v['mobileURL'],'wechat'=>$v['wechatURL']];
        	$data[strtolower($v['mobileURL'])] = ['home'=>$v['homeURL'],'mobile'=>$v['mobileURL'],'wechat'=>$v['wechatURL']];
        	$data[strtolower($v['wechatURL'])] = ['home'=>$v['homeURL'],'mobile'=>$v['mobileURL'],'wechat'=>$v['wechatURL']];
        }
    	cache('WST_SWITCHS',$data,2592000);
    }
    
	$isMobile = $request->isMobile();
	$isWeChat = (strpos($_SERVER['HTTP_USER_AGENT'], 'MicroMessenger') !== false);
	$hasMobile = (WSTDatas('ADS_TYPE',3)!='')?true:false;
	$hasWechat = (WSTDatas('ADS_TYPE',2)!='')?true:false;
	$dispathURL = '';//应转发的页面
	$dispathModule = 'home';//应进入的端
    if(!empty($data) && isset($data[$currURL])){
	    $dispathArrs = $data[$currURL];//目标页面数组
		//按优先级依次判断
		if($isWeChat && $hasWechat)$dispathURL = $dispathArrs['wechat'];
		if($dispathURL=='' && $isMobile && $hasMobile)$dispathURL = $dispathArrs['mobile'];
		if($dispathURL=='')$dispathURL = $dispathArrs['home'];
		//找到对应的网址，进行跳转
		if($currURL!=$dispathURL){
			$data = input();
			unset($data['s']);
			if($oaddon=='addon'){
				$dispath = explode('/',$dispathURL);
				WSTUnset($data,'module,action,method');
                header("Location:".addon_url($dispath[0].'://'.$dispath[1].'/'.$dispath[2],$data));
			}else{
			    header("Location:".url($dispathURL,$data));
			}
		    exit();
		}
	}
	//找不到对应的网址，但是访问端也不匹配的话，就强制跳转到相应端的主页
	if($isWeChat && $hasWechat)$dispathModule = 'wechat';
	if($dispathModule=='home' && $isMobile && $hasMobile)$dispathModule = 'mobile';
	if($oaddon=='' && $module!=$dispathModule){
       header("Location:".url($dispathModule."/index/index"));
	   exit();
	}
}

/**
 * 获取https设置情况
 */
function WSTProtocol(){
	return request()->isSsl()?'https://':'http://';
}


/**
 * 获取订单来源模块
 */
function WSTOrderModule($orderCode = ''){
	$addonMaps = model("common/addons")->getAddonsMaps();
	if($orderCode!=''){
        return array_key_exists($orderCode,$addonMaps)?$addonMaps[$orderCode]:"普通订单";
	}else{
        $data = [];
        $data[] = ['name'=>'order','title'=>'普通订单'];
        foreach ($addonMaps as $key => $v) {
        	$data[] = ['name'=>strtolower($key),'title'=>$v];
        }
        return $data;
	}
}

/**
 * 性别
 */
function WSTLangSex($v){
	switch($v){
		case 0:return '保密';
		case 1:return '男';
		case 2:return '女';
	}
}

/**
 * 检测业务数据内容
 */
function WSTCheckDatas($catCode,$val){
    $data = WSTDatas($catCode);
    foreach ($data as $key => $v) {
        if($v['dataVal']==$val)return true;
    }
    return false;
}


/***
 * 对富文本编辑器进行过滤
 * @param string $html              要转换的内容
 * @param boolean $isTranferBefore  是否传入前已经进行了转义
 */
function WSTRichEditorFilter($html,$isTranferBefore = true){
    if($isTranferBefore)$html = htmlspecialchars_decode($html);
    require_once EXTEND_PATH.'/htmlpurifier/HTMLPurifier.auto.php';
    $config = \HTMLPurifier_Config::createDefault();
    $config->set('HTML.SafeEmbed', true);
    $config->set('HTML.SafeObject', true);
    //$config->set('HTML.Allowed', 'div,b,strong,i,em,a[href|title],ul,ol,li,br,span[style],img[width|height|alt|src]');
    $purifier = new \HTMLPurifier($config);
    $html = $purifier->purify($html);
    if($isTranferBefore)$html =  htmlspecialchars($html);
    $html = str_replace(['%7B','%7b'],'{',$html);
    $html = str_replace(['%7D','%7d'],'}',$html);
    $html = str_replace('application/x-shockwave-flash','',$html);
    return $html;
}
/**
 * 过滤内容里边的html标签
 * @param string $str                要处理的字符串内容
 * @param boolean $isTranferBefore   是否传入前已经进行了转义
 */
function WSTStripTags($str,$isTranferBefore = true){
    if($isTranferBefore)$str = htmlspecialchars_decode($str);
    $str = strip_tags($str);
    if($isTranferBefore)$str =  htmlspecialchars($str);
    return $str;
}


/**
 * 微信配置
 */
function WSTWechat(){
	$wechat = new \wechat\WSTWechat(WSTConf('CONF.wxAppId'),WSTConf('CONF.wxAppKey'));
	return $wechat;
}
function WSTBindWeixin($type=1){
	$USER = session('WST_USER');
	$we = WSTWechat();
	if($USER['userId']=='' || $USER['wxOpenId']==''){
		$wdata = $we->getUserInfo(input('param.code'));
		$userinfo = session('WST_WX_USERINFO');
		if(empty($userinfo['openid'])){
			$userinfo = $we->UserInfo($wdata);
			session('WST_WX_USERINFO',$userinfo);
		}
		$users = model("wechat/users"); 
		if($userinfo['openid']!=''){
		session('WST_WX_OPENID',$userinfo['openid']);
		$rs = Db::name('users')->where(['wxOpenId'=>$userinfo['openid'],'dataFlag'=>1])->field('wxOpenId,wxUnionId')->select();
		if(count($rs)==0 && session('WST_WX_OPENID')!=''){
			if($type==1){
				header("location:".url('wechat/users/login'));
				exit;
			}
		}else{
			$users->accordLogin();
			$url = session('WST_WX_WlADDRESS');
			if($url){
				header("location:".$url);
				exit;
			}
		}
	}
	}
	//主要获取subscribe(是否关注公众号)
	if($USER['wxOpenId'] !='' || !empty($userinfo['openid'])){
		$openid = ($USER['wxOpenId'])?$USER['wxOpenId']:$userinfo['openid'];
		$signinfo = $we->wxUserInfo($openid);
		session('WST_WX_SIGNINFO',$signinfo);
	}
}