<?php
namespace wstshop\home\controller;
/**
 * ============================================================================
 * WSTShop网上商店
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wstshop.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 基础控制器
 */
use think\Controller;
class Base extends Controller {
	public function __construct(){
		parent::__construct();
		WSTSwitchs();
		$this->assign("v",WSTConf('CONF.wstVersion')."_".WSTConf('CONF.wstPCStyleId'));
		hook('homeControllerBase');
		if(WSTConf('CONF.seoShopSwitch')==0){
			$this->redirect('home/switchs/index');
			exit;
		}
	}

	protected function fetch($template = '', $vars = [], $replace = [], $config = [])
    {
    	$style = WSTConf('CONF.wsthomeStyle')?WSTConf('CONF.wsthomeStyle'):'default';
    	$replace['__STYLE__'] = str_replace('/index.php','',\think\Request::instance()->root()).'/wstshop/home/view/'.WSTConf('CONF.wsthomeStyle');
    	$replace['__RESOURCE_PATH__'] = WSTConf('CONF.resourcePath');
        return $this->view->fetch($style."/".$template, $vars, $replace, $config);
    }

	/**
	 * 上传图片
	 */
	public function uploadPic(){
		$this->checkAuth();
		return WSTUploadPic(0);
	}
	/**
    * 编辑器上传文件
    */
    public function editorUpload(){
    	$this->checkAuth();
        return WSTEditUpload(0);
    }
	
	/**
	 * 获取验证码
	 */
	public function getVerify(){
		WSTVerify();
	}

    //登录验证方法
    protected function checkAuth(){
       	$USER = session('WST_USER');
        if(empty($USER)){
        	if(request()->isAjax()){
        		die('{"status":-999,"msg":"您还未登录"}');
        	}else{
        		$this->redirect('home/users/login');
        		exit;
        	}
        }else{
        	$userId = (int)session('WST_USER.userId');
        	$uinfo = model("common/Users")->getFieldsById($userId,"userStatus,dataFlag");
        	if(!($uinfo['dataFlag']==1 && $uinfo['userStatus']==1)){
        		session('WST_USER',null);
        		if(request()->isAjax()){
	        		die('{"status":-999,"msg":"您的帐号已停用，请联系管理员"}');
	        	}else{
	        		$this->redirect('home/users/login');
	        		exit;
	        	}
        	}
        }
    }

}