SET FOREIGN_KEY_CHECKS=0;


DROP TABLE IF EXISTS `wst_goods`;
CREATE TABLE `wst_goods` (
  `goodsId` int(11) NOT NULL AUTO_INCREMENT,
  `goodsSn` varchar(20) NOT NULL,
  `productNo` varchar(20) NOT NULL,
  `goodsName` varchar(50) NOT NULL,
  `goodsImg` varchar(150) NOT NULL,
  `marketPrice` decimal(11,2) NOT NULL DEFAULT '0.00',
  `shopPrice` decimal(11,2) NOT NULL DEFAULT '0.00',
  `warnStock` int(11) NOT NULL DEFAULT '0',
  `goodsStock` int(11) NOT NULL DEFAULT '0',
  `goodsUnit` char(10) NOT NULL,
  `goodsTips` text,
  `isSale` tinyint(4) NOT NULL DEFAULT '1',
  `isBest` tinyint(4) NOT NULL DEFAULT '0',
  `isHot` tinyint(4) NOT NULL DEFAULT '0',
  `isNew` tinyint(4) NOT NULL DEFAULT '0',
  `isRecom` tinyint(4) DEFAULT '0',
  `goodsCatIdPath` varchar(255) DEFAULT NULL,
  `goodsCatId` int(11) NOT NULL,
  `brandId` int(11) DEFAULT '0',
  `goodsDesc` text NOT NULL,
  `saleNum` int(11) NOT NULL DEFAULT '0',
  `saleTime` datetime NOT NULL,
  `visitNum` int(11) DEFAULT '0',
  `appraiseNum` int(11) DEFAULT '0',
  `isSpec` tinyint(4) NOT NULL DEFAULT '0',
  `gallery` text,
  `goodsSeoKeywords` varchar(200) DEFAULT NULL,
  `dataFlag` tinyint(4) NOT NULL DEFAULT '1',
  `createTime` datetime NOT NULL,
  `isFreeShipping` tinyint(4) DEFAULT '0',
  `goodsType` tinyint(4) DEFAULT '0',
  `fictitiousSales` int(11) DEFAULT '0',
  `goodsVideo` varchar(150) DEFAULT NULL,
  `goodsSeoDesc` varchar(600) DEFAULT NULL,
  PRIMARY KEY (`goodsId`),
  KEY `goodsStatus` (`dataFlag`,`isSale`) USING BTREE,
  KEY `goodsCatIdPath` (`goodsCatIdPath`)
) ENGINE=InnoDB AUTO_INCREMENT=86 DEFAULT CHARSET=utf8mb4;


INSERT INTO `wst_goods` VALUES ('1', '148267147080903', '148267147080903', '海南蜜宝红心火龙果2.5kg蜜宝红心火龙果是非常受欢迎的健康水果之一', 'upload/goods/2016-12/585fc6537e1b7.png', '75.00', '69.00', '100', '5997', '个', '元旦促销，前100名赠送山特产一斤，先到先得~', '1', '1', '1', '1', '1', '47_61', '61', '0', '&lt;img src=&quot;/upload/image/2016-12/585fc6f6bbe85.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fc70ec776e.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fc72ccb6b7.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fc75ac7d21.jpg&quot; alt=&quot;&quot; /&gt;', '3', '2016-12-25 21:32:01', '13', '1', '1', 'upload/goods/2016-12/585fc93ce8992.png,upload/goods/2016-12/585fc90ea3b77.png', '', '1', '2016-12-25 21:22:34', '0', '0', '0', null, '元旦促销，前100名赠送山特产一斤，先到先得~'),
('2', '148267301243249', '148267301243249', '17.5度橙铂金 10斤', 'upload/goods/2016-12/5860c7e2c6e83.jpg', '0.00', '65.00', '100', '1995', '个', '农夫山泉酝酿十年出品，11月下旬自然成熟，个头中等、果形周正，甜润中带着丝丝酸感，果肉脆嫩、化渣，清香开胃，可食率达74%，含果汁55%以上，品质极高！', '1', '1', '1', '0', '1', '47_61', '61', '4', '&lt;img src=&quot;/upload/image/2016-12/585fcc94132b3.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fcc94a4214.jpg&quot; alt=&quot;&quot; /&gt;', '3', '2016-12-26 16:04:02', '17', '1', '1', 'upload/goods/2016-12/585fcc97001be.png,upload/goods/2016-12/585fcc96e12d0.png', 'wstshop,赣橙,橙子', '1', '2016-12-25 21:42:46', '0', '0', '0', null, '农夫山泉酝酿十年出品，11月下旬自然成熟，个头中等、果形周正，甜润中带着丝丝酸感，果肉脆嫩、化渣，清香开胃，可食率达74%，含果汁55%以上，品质极高！'),
('3', '148267342247157', '148267342247157', '红肉菠萝蜜 1盒约300g', 'upload/goods/2016-12/585fcdeaee36c.jpg', '32.00', '18.00', '10', '998', '盒', '红肉菠萝蜜是一种甜蜜的热带水果，果肉肥厚、色泽鲜艳、丰润饱满，香甜多汁，吃完后口齿留香，故有“齿留香”的称号。此果不仅清香甘甜，而且营养丰富，具有止渴、通乳、补中益气的功效。', '1', '1', '0', '0', '1', '47_71', '71', '0', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;font-family:arial, 宋体, sans-serif;font-size:14px;line-height:24px;background-color:#FFFFFF;&quot;&gt;早结丰产，综合性状优良，无性繁殖遗传性状稳定。具有一年多次开花结果的特性，嫁接苗定植后2～3年开始开花结果。果长椭圆形，中等大，平均单果重9.5公斤，干苞，果肉橙红色，肉厚爽脆、味清甜有香气，可溶性固形物含量18.87%，维生素C含量9.54毫克/100克，果实成熟后少乳胶&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/upload/image/2016-12/585fce2aa9d91.jpg&quot; alt=&quot;&quot; /&gt; \n&lt;/p&gt;', '2', '2016-12-25 21:50:43', '9', '1', '0', 'upload/goods/2016-12/585fce0568d2c.jpg,upload/goods/2016-12/585fce054e1eb.jpg,upload/goods/2016-12/585fce0559907.jpg', 'wstshop,菠萝蜜,果肉肥厚', '1', '2016-12-25 21:49:20', '0', '0', '0', null, '红肉菠萝蜜是一种甜蜜的热带水果，果肉肥厚、色泽鲜艳、丰润饱满，香甜多汁，吃完后口齿留香，故有“齿留香”的称号。此果不仅清香甘甜，而且营养丰富，具有止渴、通乳、补中益气的功效。'),
('4', '148267395515669', '148267395515669', '新西兰佳沛阳光金果', 'upload/goods/2016-12/585fcfe5c05a0.jpg', '2.00', '9.00', '100', '5998', '个', '', '1', '0', '1', '1', '1', '47_71', '71', '4', '&lt;img src=&quot;/upload/image/2016-12/585fcffb51e4d.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fcffbd3990.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fcffc55b76.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fcffcc0880.jpg&quot; alt=&quot;&quot; /&gt;', '2', '2016-12-26 19:56:42', '13', '1', '1', 'upload/goods/2016-12/585fd079e006c.jpg,upload/goods/2016-12/585fd079ef492.jpg,upload/goods/2016-12/585fd079f319c.jpg', 'wstshop,猕猴桃', '1', '2016-12-25 21:58:20', '0', '0', '0', null, ''),
('5', '148267445559454', '148267445559454', '高山甜柚', 'upload/goods/2016-12/585fd13835da1.jpg', '25.00', '20.00', '10', '199', '个', '', '1', '0', '1', '0', '1', '47_61', '61', '0', '&lt;h3 style=&quot;color:#666666;font-size:12px;font-weight:normal;&quot;&gt;\n	海拔600米以上的玉林地区、高山种植。无污染、纯天然、属沙田柚极品！上端短颈，下端大而圆，柚皮油黄，口感细腻，肉质脆嫩，入口化渣，香甜多汁，营养丰富，柚香怡人！糖尿病人的优选之品！&lt;img src=&quot;/upload/image/2016-12/585fd1b53aa4a.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fd1b5d70d0.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fd1b64247d.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fd1b6a1a6b.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fd1b6ea21f.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/h3&gt;', '1', '2016-12-25 22:03:39', '7', '0', '0', 'upload/goods/2016-12/585fd1628debb.jpg,upload/goods/2016-12/585fd162a4cf4.jpg,upload/goods/2016-12/585fd162b0411.jpg,upload/goods/2016-12/585fd162caf53.jpg', 'wstshop,柚子', '1', '2016-12-25 22:02:26', '0', '0', '0', null, ''),
('6', '148267480688703', '148267480688703', '砂糖桔', 'upload/goods/2016-12/585fd29d1a1f5.jpg', '9.00', '60.00', '10', '2997', '斤', '果实扁圆形，顶部有瘤状突起，蒂脐端凹陷，色泽橙黄，裹壁薄，易剥离；果肉爽脆、汁多、化渣、味清甜，吃后沁心润喉，耐人寻味。', '1', '1', '1', '0', '1', '47_71', '71', '0', '&lt;img src=&quot;/upload/image/2016-12/585fd2c9446dd.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fd2c9d193d.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fd2ca81795.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fd2cb0397c.jpg&quot; alt=&quot;&quot; /&gt;', '3', '2016-12-25 22:10:54', '6', '2', '1', 'upload/goods/2016-12/585fd2d81e65e.jpg,upload/goods/2016-12/585fd2d826071.jpg,upload/goods/2016-12/585fd2d840bb4.jpg', 'wstshop,砂糖桔，果肉爽脆', '1', '2016-12-25 22:10:05', '0', '0', '0', null, '果实扁圆形，顶部有瘤状突起，蒂脐端凹陷，色泽橙黄，裹壁薄，易剥离；果肉爽脆、汁多、化渣、味清甜，吃后沁心润喉，耐人寻味。'),
('7', '148267540665622', '148267540665622', '草莓', 'upload/goods/2016-12/585fd4e800309.jpg', '20.00', '19.00', '10', '997', '斤', '新鲜采摘，外观呈心形，鲜美红嫩，果肉多汁，含有特殊的浓郁水果芳香。含丰富的维生素C ，有帮助消化的功效，与此同时，草莓还可以巩固齿龈，清新口气，润泽喉部。', '1', '1', '1', '0', '1', '47_71', '71', '0', '&lt;img src=&quot;/upload/image/2016-12/585fd50167629.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fd501e1759.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fd5023d6e1.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fd5026f05c.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fd502d605d.jpg&quot; alt=&quot;&quot; /&gt;', '3', '2016-12-25 22:18:12', '2', '2', '0', '', 'wstshop，草莓', '1', '2016-12-25 22:18:12', '0', '0', '0', null, '新鲜采摘，外观呈心形，鲜美红嫩，果肉多汁，含有特殊的浓郁水果芳香。含丰富的维生素C ，有帮助消化的功效，与此同时，草莓还可以巩固齿龈，清新口气，润泽喉部。'),
('8', '148267551353469', '148267551353469', '哈密瓜', 'upload/goods/2016-12/585fd5bb7818f.jpg', '50.00', '42.00', '10', '99', '个', '', '1', '1', '1', '1', '1', '47_71', '71', '4', '&lt;img src=&quot;/upload/image/2016-12/585fd5df20a35.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fd5dfb56a7.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fd5e019042.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fd5e0617f6.jpg&quot; alt=&quot;&quot; /&gt;', '1', '2016-12-26 16:04:38', '4', '0', '0', 'upload/goods/2016-12/585fd5f29adc5.jpg,upload/goods/2016-12/585fd5f2b1bfe.jpg', 'wtshop,新疆哈密瓜', '1', '2016-12-25 22:21:42', '0', '0', '0', null, ''),
('9', '148267577224604', '148267577224604', '进口红提', 'upload/goods/2016-12/585fd68e25d1e.jpg', '15.00', '12.00', '100', '999', '斤', '来自南半球的奇特水果王国——秘鲁，色如玛瑙，形似珍珠，果实均匀，颗颗精粹，饱满诱人，甜润多汁，每一口都是阳光的味道。', '1', '0', '1', '1', '1', '47_71', '71', '0', '&lt;img src=&quot;/upload/image/2016-12/585fd6c92a188.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fd6c9a05ae.jpg&quot; alt=&quot;&quot; /&gt;', '1', '2016-12-25 22:26:43', '4', '0', '0', 'upload/goods/2016-12/585fd6d3a06ee.jpg,upload/goods/2016-12/585fd6d3a43f8.jpg', 'wstshop,进口红提,秘鲁', '1', '2016-12-25 22:25:28', '0', '0', '0', null, '来自南半球的奇特水果王国——秘鲁，色如玛瑙，形似珍珠，果实均匀，颗颗精粹，饱满诱人，甜润多汁，每一口都是阳光的味道。'),
('10', '148267627859044', '148267627859044', '速食荞麦凉面 荞面杂粮挂面 速食面条炒面拌面饸饹 粗粮无糖食品', 'upload/goods/2016-12/585fd83b255b5.jpg', '45.00', '39.00', '100', '5000', '斤', '整整5袋哦，每袋足足1斤，每袋可供4-5个成年人食用。荞麦具有低糖高膳食纤维的特点，夏季10几分钟就可以做出地道的一份凉面，凉爽滑溜，再加上丫丫家的拌面酱、油辣椒、泽蒙花味道就棒透了。', '1', '1', '0', '1', '1', '50_223', '223', '0', '&lt;ul class=&quot;attributes-list&quot;&gt;\n	&lt;li&gt;\n		生产许可证编号:&amp;nbsp;QS150107010059\n	&lt;/li&gt;\n	&lt;li&gt;\n		产品标准号:&amp;nbsp;Q/NRS000S-2012\n	&lt;/li&gt;\n	&lt;li&gt;\n		厂名:&amp;nbsp;呼和浩特市纳瑞森食品有限公司\n	&lt;/li&gt;\n	&lt;li&gt;\n		厂址:&amp;nbsp;呼和浩特市玉泉区209国道(呼市至和林)12公里处路西100米\n	&lt;/li&gt;\n	&lt;li&gt;\n		厂家联系方式:&amp;nbsp;0471-5699262\n	&lt;/li&gt;\n	&lt;li&gt;\n		配料表:&amp;nbsp;荞麦粉、小麦粉等\n	&lt;/li&gt;\n	&lt;li&gt;\n		储藏方法:&amp;nbsp;阴凉、避光保存\n	&lt;/li&gt;\n	&lt;li&gt;\n		保质期:&amp;nbsp;365\n	&lt;/li&gt;\n	&lt;li&gt;\n		食品添加剂:&amp;nbsp;无\n	&lt;/li&gt;\n	&lt;li&gt;\n		净含量:&amp;nbsp;2500g\n	&lt;/li&gt;\n	&lt;li&gt;\n		包装方式:&amp;nbsp;包装\n	&lt;/li&gt;\n	&lt;li&gt;\n		品牌:&amp;nbsp;纳瑞森\n	&lt;/li&gt;\n	&lt;li&gt;\n		系列:&amp;nbsp;速食面条\n	&lt;/li&gt;\n	&lt;li&gt;\n		产地:&amp;nbsp;中国大陆\n	&lt;/li&gt;\n	&lt;li&gt;\n		省份:&amp;nbsp;内蒙古自治区\n	&lt;/li&gt;\n	&lt;li&gt;\n		城市:&amp;nbsp;呼和浩特市\n	&lt;/li&gt;\n	&lt;li&gt;\n		套餐份量:&amp;nbsp;5人份\n	&lt;/li&gt;\n	&lt;li&gt;\n		面种类:&amp;nbsp;其他\n	&lt;/li&gt;\n	&lt;li&gt;\n		原料成分:&amp;nbsp;荞麦\n	&lt;/li&gt;\n	&lt;li&gt;\n		形状:&amp;nbsp;细条型\n	&lt;/li&gt;\n	&lt;li&gt;\n		是否冷藏:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li&gt;\n		是否含酱料包:&amp;nbsp;否\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-25 22:33:12', '5', '0', '0', 'upload/goods/2016-12/585fd853d8d73.jpg,upload/goods/2016-12/585fd853d8d73.jpg', 'wstshop,凉面', '1', '2016-12-25 22:33:12', '0', '0', '0', null, '整整5袋哦，每袋足足1斤，每袋可供4-5个成年人食用。荞麦具有低糖高膳食纤维的特点，夏季10几分钟就可以做出地道的一份凉面，凉爽滑溜，再加上丫丫家的拌面酱、油辣椒、泽蒙花味道就棒透了。'),
('11', '148267685820274', '148267685820274', '坚果休闲零食特产琥珀核桃仁188gX3罐', 'upload/goods/2016-12/585fda810791f.jpg', '38.00', '28.00', '10', '99', '罐', '一件起包邮 拍2件减2元，拍3件减4元，拍4件减6元，多买多减，上不封顶，机不可失失不再来。拍1件就是3罐.', '1', '1', '1', '1', '1', '52_189', '189', '0', '&lt;img src=&quot;/upload/image/2016-12/585fdb0960d9b.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fdb0a51995.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fdb0b33169.jpg&quot; alt=&quot;&quot; /&gt;', '1', '2016-12-25 22:43:35', '3', '1', '0', 'upload/goods/2016-12/585fdaf4828af.jpg,upload/goods/2016-12/585fdaf42acd5.jpg', 'wstshop,核桃', '1', '2016-12-25 22:43:35', '0', '0', '0', null, '一件起包邮 拍2件减2元，拍3件减4元，拍4件减6元，多买多减，上不封顶，机不可失失不再来。拍1件就是3罐.'),
('12', '148267711675986', '148267711675986', '卫龙馋魔芋爽220g美味辣条办公室休闲小吃零食魔芋丝香麻辣素毛肚', 'upload/goods/2016-12/585fdb82eef1a.jpg', '10.00', '8.00', '10', '998', '包', '', '1', '1', '1', '0', '1', '52_190', '190', '0', '&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, &#039;Hiragino Sans GB&#039;, 宋体, sans-serif;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		生产许可证编号:&amp;nbsp;QS411107010002\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		产品标准号:&amp;nbsp;Q/LPS 0005S\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		厂名:&amp;nbsp;漯河市平平食品有限责任公司\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		厂址:&amp;nbsp;漯河经济开发区燕山路南段民营工业园\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		厂家联系方式:&amp;nbsp;03952610601\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		配料表:&amp;nbsp;生活饮用水、魔芋精粉、植物油、淀粉、食用盐、白砂糖、香辛料、食品添加剂、食用香精香料。\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		储藏方法:&amp;nbsp;置于阴凉干燥处，避免阳光直射\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		保质期:&amp;nbsp;180\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		食品添加剂:&amp;nbsp;见包装袋\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		重量(g):&amp;nbsp;220\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		包装方式:&amp;nbsp;包装\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		口味:&amp;nbsp;香辣味1袋10包 香辣味2袋20包 香辣味3袋30包 香辣味4袋40包 香辣味5袋50包 香辣味6袋60包 香辣味7袋70包 香辣味8袋80包 香辣味9袋90包 香辣味10袋100包\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		豆制品种类:&amp;nbsp;其他/other\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		品牌:&amp;nbsp;WEILONG－FOODS/卫龙\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		系列:&amp;nbsp;魔芋爽220g\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		产地:&amp;nbsp;中国大陆\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		省份:&amp;nbsp;河南省\n	&lt;/li&gt;\n&lt;/ul&gt;', '2', '2016-12-25 22:50:33', '8', '1', '1', 'upload/goods/2016-12/585fdb9e24fa3.jpg,upload/goods/2016-12/585fdb9e5e331.jpg,upload/goods/2016-12/585fdb9e5691e.jpg,upload/goods/2016-12/585fdb9f11e93.jpg', '', '1', '2016-12-25 22:46:48', '0', '0', '0', null, ''),
('13', '148267752781843', '148267752781843', '辣媳妇 香辣/麻辣金针菇15g*10袋 散装休闲零食重庆特产小吃独立小包装', 'upload/goods/2016-12/585fdd63b9080.jpg', '9.00', '7.00', '100', '1999', '包', '精选菌盖饱满 香辣爽口 营养丰富 根本停不下来', '1', '0', '1', '1', '1', '52_190', '190', '0', '&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, &#039;Hiragino Sans GB&#039;, 宋体, sans-serif;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		生产许可证编号:&amp;nbsp;QS510116010741\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		产品标准号:&amp;nbsp;Q/CLS 0001S\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		厂名:&amp;nbsp;成都市辣媳妇双源食品有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		厂址:&amp;nbsp;双流西南航空港开发区空港一路二段\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		厂家联系方式:&amp;nbsp;400-023-9930\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		配料表:&amp;nbsp;金针菇、植物油、食用盐、白砂糖、香辛料、食用香精香料等\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		储藏方法:&amp;nbsp;置于阴凉干燥处，避免阳光直射\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		保质期:&amp;nbsp;270\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		食品添加剂:&amp;nbsp;见包装袋\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		净含量:&amp;nbsp;150g\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		包装方式:&amp;nbsp;包装\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		品牌:&amp;nbsp;Spice Lady/辣媳妇\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		系列:&amp;nbsp;香辣金针菇15g\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		商品条形码:&amp;nbsp;6954244500052\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		食品工艺:&amp;nbsp;其他/other\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		是否含糖:&amp;nbsp;含糖\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		产地:&amp;nbsp;中国大陆\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		省份:&amp;nbsp;重庆\n	&lt;/li&gt;\n&lt;/ul&gt;', '1', '2016-12-25 22:56:41', '3', '1', '1', 'upload/goods/2016-12/585fdd8d37973.jpg,upload/goods/2016-12/585fdd8e20b54.jpg,upload/goods/2016-12/585fdd8e59ee1.jpg', 'wstshop,香辣,金针菇,辣媳妇', '1', '2016-12-25 22:56:03', '0', '0', '0', null, '精选菌盖饱满 香辣爽口 营养丰富 根本停不下来'),
('14', '148267784674856', '148267784674856', '山椒笋尖80g*5袋 休闲素食零食重庆特产小吃山椒笋片笋子', 'upload/goods/2016-12/585fde93ca30c.jpg', '14.00', '12.00', '100', '998', '包', '优质野生笋尖 精心泡制 肉厚皮薄 口感细腻 香脆', '1', '1', '1', '0', '1', '52_190', '190', '0', '&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, &#039;Hiragino Sans GB&#039;, 宋体, sans-serif;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		生产许可证编号:&amp;nbsp;QS500816010157\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		产品标准号:&amp;nbsp;DBS50/ 005\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		厂名:&amp;nbsp;重庆市辣媳妇食品有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		厂址:&amp;nbsp;重庆市合川区大石街道办事处长安路\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		厂家联系方式:&amp;nbsp;400-023-9930\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		配料表:&amp;nbsp;竹笋、泡山椒、水、食用盐、白砂糖、酵母提取物、香辛料、食用香精香料等\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		储藏方法:&amp;nbsp;置于阴凉干燥处，避免阳光直射\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		保质期:&amp;nbsp;270\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		食品添加剂:&amp;nbsp;见包装袋\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		净含量:&amp;nbsp;400g\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		包装方式:&amp;nbsp;包装\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		品牌:&amp;nbsp;Spice Lady/辣媳妇\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		系列:&amp;nbsp;山椒笋尖80g\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		商品条形码:&amp;nbsp;6927622400770\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		食品工艺:&amp;nbsp;其他/other\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		是否含糖:&amp;nbsp;含糖\n	&lt;/li&gt;\n&lt;/ul&gt;', '2', '2016-12-25 22:59:24', '2', '2', '0', 'upload/goods/2016-12/585fdebd0bb69.jpg,upload/goods/2016-12/585fdebd2e0bd.jpg', 'wstshop,辣媳妇,山椒笋', '1', '2016-12-25 22:59:24', '0', '0', '0', null, '优质野生笋尖 精心泡制 肉厚皮薄 口感细腻 香脆'),
('15', '148267803986283', '148267803986283', '休闲零食坚果带壳山核桃味葵花籽250g', 'upload/goods/2016-12/585fdf251f6fe.jpg', '12.00', '10.00', '10', '3999', '包', '', '1', '0', '1', '0', '0', '52_190', '190', '0', '&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, &#039;Hiragino Sans GB&#039;, 宋体, sans-serif;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		净含量:&amp;nbsp;250g\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		包装方式:&amp;nbsp;食用农产品\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		品牌:&amp;nbsp;方林富\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		系列:&amp;nbsp;坚果\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		食品口味:&amp;nbsp;山核桃味\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		瓜子种类:&amp;nbsp;葵花子\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		产地:&amp;nbsp;中国大陆\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		省份:&amp;nbsp;新疆维吾尔族自治区\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		城市:&amp;nbsp;乌鲁木齐市\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		是否新货:&amp;nbsp;是\n	&lt;/li&gt;\n&lt;/ul&gt;', '1', '2016-12-25 23:02:19', '0', '1', '1', '', 'wstshop，核桃瓜子', '1', '2016-12-25 23:02:19', '0', '0', '0', null, ''),
('16', '148267818600729', '148267818600729', '殷宜燕的窝 伊朗无花果干干果坚果休闲零食 250g', 'upload/goods/2016-12/585fdfae8eec2.jpg', '30.00', '125.00', '100', '3999', '包', '', '1', '1', '1', '0', '1', '52_190', '190', '0', '&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, &#039;Hiragino Sans GB&#039;, 宋体, sans-serif;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		生产许可证编号:&amp;nbsp;QS510114020216\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		产品标准号:&amp;nbsp;Q/SZL0003S\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		厂名:&amp;nbsp;四川自然之宝绿色食品有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		厂址:&amp;nbsp;成都市青羊区蛟龙工业港青羊园区高新区A-29号\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		厂家联系方式:&amp;nbsp;400-8703770\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		配料表:&amp;nbsp;无花果\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		储藏方法:&amp;nbsp;由于糖分过高易生虫，需密封冰箱冷藏保存，避免日晒、\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		保质期:&amp;nbsp;180\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		食品添加剂:&amp;nbsp;无\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		净含量:&amp;nbsp;250g\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		包装方式:&amp;nbsp;包装\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		商品条形码:&amp;nbsp;6970082650827\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		是否为有机食品:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		是否含糖:&amp;nbsp;含糖\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		产地:&amp;nbsp;中国大陆\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		省份:&amp;nbsp;四川省\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		城市:&amp;nbsp;成都市\n	&lt;/li&gt;\n&lt;/ul&gt;', '1', '2016-12-25 23:07:29', '0', '1', '1', 'upload/goods/2016-12/585fdff570d90.jpg,upload/goods/2016-12/585fdff5aa11d.jpg,upload/goods/2016-12/585fdff5c8969.jpg,upload/goods/2016-12/585fdff6154c8.jpg', 'wstshop,无花果干，伊朗', '1', '2016-12-25 23:04:34', '0', '0', '0', null, ''),
('17', '148267852539090', '148267852539090', '怡浓76%可可含量偏苦黑巧克力散装纯可可脂礼盒休闲零食品', 'upload/goods/2016-12/585fe1111eb28.jpg', '23.00', '19.90', '100', '998', '包', '', '1', '1', '1', '1', '1', '52_190', '190', '0', '&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, &#039;Hiragino Sans GB&#039;, 宋体, sans-serif;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		生产许可证编号:&amp;nbsp;QS121013010007\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		产品标准号:&amp;nbsp;GB/T19343\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		厂名:&amp;nbsp;天津市福厦食品有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		厂址:&amp;nbsp;天津市武清区开发区开源道36号\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		厂家联系方式:&amp;nbsp;4000360208\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		配料表:&amp;nbsp;可可液块、磷脂、食用香精香料等\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		储藏方法:&amp;nbsp;请存放于阴凉干燥处，避免阳光直接照射\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		保质期:&amp;nbsp;365\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		食品添加剂:&amp;nbsp;有\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		净含量:&amp;nbsp;99g\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		包装方式:&amp;nbsp;包装\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		包装种类:&amp;nbsp;盒装\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		品牌:&amp;nbsp;enon/怡浓\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		系列:&amp;nbsp;铁盒76%\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		巧克力品类:&amp;nbsp;黑巧克力\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		巧克力价格:&amp;nbsp;20-30元\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		是否含糖:&amp;nbsp;含糖\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		产地:&amp;nbsp;中国大陆\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		省份:&amp;nbsp;天津\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		是否含有代可可脂:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		巧克力制作工艺:&amp;nbsp;手工\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		形状:&amp;nbsp;其他/other\n	&lt;/li&gt;\n&lt;/ul&gt;', '2', '2016-12-25 23:10:17', '2', '2', '0', 'upload/goods/2016-12/585fe140ce78c.jpg,upload/goods/2016-12/585fe140ecfd7.jpg,upload/goods/2016-12/585fe141138d9.jpg,upload/goods/2016-12/585fe1419170f.jpg', 'wstshop,怡浓，巧克力', '1', '2016-12-25 23:10:17', '0', '0', '0', null, ''),
('18', '148267887835302', '148267887835302', '天天特价 魅洁干洗剂羽绒服清洗剂免水洗衣物去油渍衣服2瓶装', 'upload/goods/2016-12/585fe2629ae08.jpg', '23.00', '13.80', '100', '999', '瓶', '亏本促销，品质保证！① 浓缩型，不伤羽绒，羽绒服洗涤专用，洗涤更彻底。 免洗一喷净，随洗随穿，方便经济！ 　②全新升级款大容量250ml，泡沫型羽绒服去污能力提升3倍 　　　　　　　　　　　　　③一般', '1', '1', '0', '1', '1', '51_164', '164', '0', '&lt;img src=&quot;/upload/image/2016-12/585fe2f1e8111.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fe2f2ba4ba.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585fe2f375a2a.jpg&quot; alt=&quot;&quot; /&gt;', '1', '2016-12-25 23:17:22', '0', '1', '0', 'upload/goods/2016-12/585fe2fd9066c.jpg,upload/goods/2016-12/585fe2fdab1ae.jpg,upload/goods/2016-12/585fe2fdb68ca.jpg', 'wstshop,清洁洗涤', '1', '2016-12-25 23:17:22', '0', '0', '0', null, '亏本促销，品质保证！① 浓缩型，不伤羽绒，羽绒服洗涤专用，洗涤更彻底。 免洗一喷净，随洗随穿，方便经济！ 　②全新升级款大容量250ml，泡沫型羽绒服去污能力提升3倍 　　　　　　　　　　　　　③一般'),
('19', '148267909057721', '148267909057721', '三金西瓜霜漱口水除口臭杀菌去牙渍异味便携清新口气', 'upload/goods/2016-12/585fe346e0f7e.jpg', '23.00', '19.90', '100', '5999', '瓶', '口腔清洁上火口腔全面清洁 防止口腔问题 传统去牙渍 去口臭 4种口味可选 西瓜 柠檬 薄荷 苹果 付款时备注留言哦，或者给客服留言。没有备注的默认发西瓜味的哦', '1', '0', '0', '1', '1', '51_164', '164', '0', '&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, &#039;Hiragino Sans GB&#039;, 宋体, sans-serif;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		产品名称:&amp;nbsp;三金 西瓜霜天然漱口水\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		品牌:&amp;nbsp;三金\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		型号:&amp;nbsp;西瓜霜天然漱口水\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		是否量贩装:&amp;nbsp;是\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		功能:&amp;nbsp;美白 抗敏感 去牙渍 防蛀/固齿 抗菌/牙龈护理 其它\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		净含量:&amp;nbsp;500ml\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		适用对象:&amp;nbsp;通用\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		规格类型:&amp;nbsp;常规单品\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		产地:&amp;nbsp;中国大陆\n	&lt;/li&gt;\n&lt;/ul&gt;', '1', '2016-12-25 23:21:18', '0', '1', '1', 'upload/goods/2016-12/585fe3e70c589.jpg,upload/goods/2016-12/585fe3e8a8c24.jpg', 'wstshop,漱口水', '1', '2016-12-25 23:21:18', '0', '0', '0', null, '口腔清洁上火口腔全面清洁 防止口腔问题 传统去牙渍 去口臭 4种口味可选 西瓜 柠檬 薄荷 苹果 付款时备注留言哦，或者给客服留言。没有备注的默认发西瓜味的哦'),
('20', '148267932092693', '148267932092693', '魔涤婴儿洗衣液宝宝儿童衣物尿布消毒清洗剂除菌1kg', 'upload/goods/2016-12/585fe43373d21.jpg', '23.00', '19.90', '100', '1000', '瓶', '纯天然酵素，呵护宝宝衣物不伤身，高效去除奶渍和污渍，无残留；杀菌除螨率达99.99%，赶快行动吧！！！', '1', '0', '1', '1', '1', '51_164', '164', '0', '&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, &#039;Hiragino Sans GB&#039;, 宋体, sans-serif;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		净含量:&amp;nbsp;1L(含)-2L(含)\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		功效:&amp;nbsp;增柔\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		包装体积:&amp;nbsp;1.5kg\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		品牌:&amp;nbsp;D@\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		是否量贩装:&amp;nbsp;是\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		毛重:&amp;nbsp;1.5kg\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		适用范围:&amp;nbsp;贴身内衣/婴儿衣物\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		产地:&amp;nbsp;中国大陆\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		计价单位:&amp;nbsp;瓶\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		香味:&amp;nbsp;自然香型\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-25 23:23:26', '1', '0', '0', 'upload/goods/2016-12/585fe45f9a3e5.jpg,upload/goods/2016-12/585fe45fdee8e.jpg,upload/goods/2016-12/585fe45fcfa69.jpg', 'wstshop,洗涤液', '1', '2016-12-25 23:23:26', '0', '0', '0', null, '纯天然酵素，呵护宝宝衣物不伤身，高效去除奶渍和污渍，无残留；杀菌除螨率达99.99%，赶快行动吧！！！'),
('21', '148267956504250', '148267956504250', '娥佩兰保湿滋润 大容量 薏仁水', 'upload/goods/2016-12/585fe51128e98.jpg', '60.00', '55.00', '10', '99', '瓶', '', '1', '1', '1', '0', '1', '51_167', '167', '0', '&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, &#039;Hiragino Sans GB&#039;, 宋体, sans-serif;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		产品名称:&amp;nbsp;Opera/娥佩兰 薏苡仁化妆水\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		上市时间:&amp;nbsp;2014年\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		化妆品品类:&amp;nbsp;其它化妆水/爽肤水\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		是否为特殊用途化妆品:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		规格类型:&amp;nbsp;正常规格\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		功效:&amp;nbsp;滋养肌肤 补水 保湿\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		适合肤质:&amp;nbsp;任何肤质\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		品牌:&amp;nbsp;Opera/娥佩兰\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		化妆水/爽肤水单品:&amp;nbsp;薏苡仁化妆水\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		产地:&amp;nbsp;中国\n	&lt;/li&gt;\n&lt;/ul&gt;', '1', '2016-12-25 23:27:21', '1', '1', '0', 'upload/goods/2016-12/585fe54c79644.jpg,upload/goods/2016-12/585fe54c94185.jpg', 'wstshop,薏仁水', '1', '2016-12-25 23:27:21', '0', '0', '0', null, ''),
('22', '148267970521795', '148267970521795', '泰国正品代购Mistine婴儿隔离BB霜裸妆遮瑕防晒美白保湿控油轻薄', 'upload/goods/2016-12/585fe5af7a02a.jpg', '0.00', '20.00', '2', '199', '瓶', '泰国品牌 韩国研制 mistine的BB霜非常好用贴肤，完全不输给任何大牌，也是我个人非常喜欢的单品！【现有活动 购买套餐即0元得泰国去黑头水哦，机会难得 ，仅50套，描述下拉拍套餐】', '1', '1', '0', '1', '1', '51_167', '167', '0', '&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, &#039;Hiragino Sans GB&#039;, 宋体, sans-serif;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		产品名称:&amp;nbsp;Mistine Smooth Skin with BB Baby Micro Powder\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		上市时间:&amp;nbsp;2014年\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		是否为特殊用途化妆品:&amp;nbsp;是\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		颜色分类:&amp;nbsp;自然色\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		是否防晒:&amp;nbsp;是\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		规格类型:&amp;nbsp;正常规格\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		品牌:&amp;nbsp;Mistine\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		单品:&amp;nbsp;Smooth Skin with BB Baby Micro Powder\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		功效:&amp;nbsp;保湿 美白 防晒 遮瑕 隔离\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		产地:&amp;nbsp;泰国\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		保质期:&amp;nbsp;24个月\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		适合肤质:&amp;nbsp;任何肤质\n	&lt;/li&gt;\n&lt;/ul&gt;', '1', '2016-12-25 23:30:41', '1', '1', '1', 'upload/goods/2016-12/585fe5b690f16.jpg,upload/goods/2016-12/585fe5b698928.jpg', 'wstshop,泰国品牌 韩国研制 mistine的BB霜非常好用贴肤', '1', '2016-12-25 23:30:41', '0', '0', '0', null, '泰国品牌 韩国研制 mistine的BB霜非常好用贴肤，完全不输给任何大牌，也是我个人非常喜欢的单品！【现有活动 购买套餐即0元得泰国去黑头水哦，机会难得 ，仅50套，描述下拉拍套餐】'),
('23', '148267987684738', '148267987684738', '美国NIVEA POST SHAVE BALM妮维雅敏感肌须后乳100ML 可做妆前乳', 'upload/goods/2016-12/585fe6b43aca4.jpg', '40.00', '35.00', '100', '999', '件', '', '1', '1', '1', '1', '1', '51_165', '165', '0', '&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, &#039;Hiragino Sans GB&#039;, 宋体, sans-serif;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		产品名称:&amp;nbsp;Nivea/妮维雅 男士须后润肤露\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		上市时间:&amp;nbsp;2012年\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		月份:&amp;nbsp;3月\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		是否为特殊用途化妆品:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		限期使用日期范围:&amp;nbsp;2016-08-17至2019-08-17\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		功效:&amp;nbsp;滋润\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		品牌:&amp;nbsp;Nivea/妮维雅\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		男士护理单品:&amp;nbsp;男士须后润肤露\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		适合肤质:&amp;nbsp;任何肤质\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		产地:&amp;nbsp;美国\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		保质期:&amp;nbsp;3年\n	&lt;/li&gt;\n&lt;/ul&gt;', '1', '2016-12-25 23:34:27', '0', '1', '0', 'upload/goods/2016-12/585fe6fc87893.jpg,upload/goods/2016-12/585fe6fc83b8a.jpg', 'wstshop,美国NIVEA POST SHAVE BALM妮维雅敏感肌须后乳', '1', '2016-12-25 23:34:27', '0', '0', '0', null, ''),
('24', '148268031093668', '148268031093668', '密封保鲜盒六件套冰箱收纳盒塑料长方形微波炉饭盒', 'upload/goods/2016-12/585fe7feb6ed1.jpg', '25.00', '29.90', '10', '200', '个', '微波炉冰箱专用保鲜盒饭盒正方形长方形套装 价格实惠 加厚型 密封性能强，安全食品级材质pp制造，通过S级认证，无毒无味 安全 健康 环保，居家必备', '1', '1', '1', '1', '1', '54_118', '118', '0', '&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, &#039;Hiragino Sans GB&#039;, 宋体, sans-serif;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		品牌:&amp;nbsp;一扣\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		型号:&amp;nbsp;保鲜盒六件套装\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		形状:&amp;nbsp;多规格套装\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		适用对象:&amp;nbsp;成人\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		颜色分类:&amp;nbsp;长方形/正方形 六件套 【长方形】 六件套\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		容量:&amp;nbsp;1L及以上\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		材质:&amp;nbsp;塑料\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		包装数量:&amp;nbsp;6个\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		产地:&amp;nbsp;中国\n	&lt;/li&gt;\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\n		尺寸:&amp;nbsp;多款尺寸\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-25 23:44:03', '2', '0', '1', '', 'wstshop，保鲜盒', '1', '2016-12-25 23:44:03', '0', '0', '0', null, '微波炉冰箱专用保鲜盒饭盒正方形长方形套装 价格实惠 加厚型 密封性能强，安全食品级材质pp制造，通过S级认证，无毒无味 安全 健康 环保，居家必备'),
('25', '148268088220128', '148268088220128', '酒仙网52度剑南春500ml四川浓香型白酒高度酒水礼盒装国产', 'upload/goods/2016-12/585feacd39573.jpg', '678.00', '369.00', '5', '199', '瓶', '', '1', '1', '0', '1', '1', '49_78', '78', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		生产许可证编号：QS5100 1501 0003\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品标准号：见背标\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：四川绵竹剑南春酒厂有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：绵竹市春溢街289号\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：4006179999\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		配料表：水、高粱、小麦\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		储藏方法：恒温避光储藏\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：18260 天\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		食品添加剂：无\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：剑南春 普通装 500ml 52度\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		体积(ml):&amp;nbsp;500\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;剑南春\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品名:&amp;nbsp;普通装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;中国大陆地区\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		省份:&amp;nbsp;四川\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		香型:&amp;nbsp;浓香型\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		酒精纯度:&amp;nbsp;高度白酒（50%以上）\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装方式:&amp;nbsp;包装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装种类:&amp;nbsp;瓶装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		净含量:&amp;nbsp;500ml\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		度数:&amp;nbsp;52%Vol.\n	&lt;/li&gt;\n&lt;/ul&gt;', '1', '2016-12-25 23:53:40', '4', '1', '1', 'upload/goods/2016-12/585fead27a350.jpg', 'wstshop,酒仙网,剑南春', '1', '2016-12-25 23:53:40', '0', '0', '0', null, ''),
('26', '148268175627538', '148268175627538', '酒仙网52度泸州老窖藏品珍藏5 500ml六瓶整箱装浓香型白酒', 'upload/goods/2016-12/585fedaa841c9.jpg', '396.00', '99.00', '10', '99', '瓶', '', '1', '1', '0', '1', '1', '49_78', '78', '0', '&lt;li&gt;\n	厂名：中国泸州老窖股份有限公司\n&lt;/li&gt;\n&lt;li&gt;\n	厂址：1.四川省泸州市国窖广场2.四川省泸州市龙马潭区罗汉镇罗汉场泸州老窖基地3.四川省泸州市龙马潭\n&lt;/li&gt;\n&lt;li&gt;\n	厂家联系方式：4006179999\n&lt;/li&gt;\n&lt;li&gt;\n	保质期：18260 天\n&lt;/li&gt;\n&lt;li id=&quot;J_attrBrandName&quot;&gt;\n	品牌:&amp;nbsp;泸州老窖\n&lt;/li&gt;\n&lt;li&gt;\n	品名:&amp;nbsp;泸州老窖藏品珍藏5 500ml六瓶套装\n&lt;/li&gt;\n&lt;li&gt;\n	产地:&amp;nbsp;四川\n&lt;/li&gt;\n&lt;li&gt;\n	香型:&amp;nbsp;浓香型\n&lt;/li&gt;\n&lt;li&gt;\n	酒精纯度:&amp;nbsp;高度白酒（50%以上）\n&lt;/li&gt;\n&lt;li&gt;\n	包装方式:&amp;nbsp;包装\n&lt;/li&gt;\n&lt;li&gt;\n	包装种类:&amp;nbsp;瓶装\n&lt;/li&gt;\n&lt;li&gt;\n	净含量:&amp;nbsp;500ml*6\n&lt;/li&gt;\n&lt;li&gt;\n	度数:&amp;nbsp;52%Vol.\n&lt;/li&gt;', '1', '2016-12-26 00:03:54', '1', '1', '0', '', 'wstshop,酒仙网,泸州老窖', '1', '2016-12-26 00:03:54', '0', '0', '0', null, ''),
('27', '148268183491708', '148268183491708', '酒仙网52度泸州老窖龙香醇·福装500ml 六瓶 浓香型白酒口粮酒', 'upload/goods/2016-12/585fee27ef50a.jpg', '354.00', '99.00', '10', '99', '瓶', '泸州老窖 股份出品 高性价比 自饮婚庆皆宜', '1', '1', '0', '1', '1', '49_78', '78', '0', '&lt;li&gt;\n	生产许可证编号：QS5100 1501 0375\n&lt;/li&gt;\n&lt;li&gt;\n	厂名：泸州老窖股份有限公司\n&lt;/li&gt;\n&lt;li&gt;\n	厂址：1.四川省泸州市国窖广场2.四川省泸州市龙马潭区罗汉镇罗汉场泸州老窖基地3.四川省泸州市龙马潭区安宁\n&lt;/li&gt;\n&lt;li&gt;\n	厂家联系方式：400-617-9999\n&lt;/li&gt;\n&lt;li&gt;\n	保质期：18260 天\n&lt;/li&gt;\n&lt;li&gt;\n	体积(ml):&amp;nbsp;500\n&lt;/li&gt;\n&lt;li id=&quot;J_attrBrandName&quot;&gt;\n	品牌:&amp;nbsp;泸州老窖\n&lt;/li&gt;\n&lt;li&gt;\n	品名:&amp;nbsp;龙香醇福装套装\n&lt;/li&gt;\n&lt;li&gt;\n	产地:&amp;nbsp;中国大陆地区\n&lt;/li&gt;\n&lt;li&gt;\n	省份:&amp;nbsp;四川\n&lt;/li&gt;\n&lt;li&gt;\n	香型:&amp;nbsp;浓香型\n&lt;/li&gt;\n&lt;li&gt;\n	酒精纯度:&amp;nbsp;高度白酒（50%以上）\n&lt;/li&gt;\n&lt;li&gt;\n	包装方式:&amp;nbsp;包装\n&lt;/li&gt;\n&lt;li&gt;\n	包装种类:&amp;nbsp;瓶装\n&lt;/li&gt;\n&lt;li&gt;\n	净含量:&amp;nbsp;500ml*6\n&lt;/li&gt;\n&lt;li&gt;\n	度数:&amp;nbsp;52%Vol.\n&lt;/li&gt;', '1', '2016-12-26 00:06:22', '0', '1', '0', '', 'wstshop,酒仙网,泸州老窖龙香醇', '1', '2016-12-26 00:06:22', '0', '0', '0', null, '泸州老窖 股份出品 高性价比 自饮婚庆皆宜'),
('28', '148268198287204', '148268198287204', '酒仙网 53度茅台王子500ml六瓶装整箱白酒酱香贵州名酒', 'upload/goods/2016-12/585feea43c69a.jpg', '984.00', '522.00', '10', '99', '瓶', '', '1', '1', '1', '0', '1', '49_78', '78', '0', '&lt;li&gt;\n	生产许可证编号：QS5200 1501 0001\n&lt;/li&gt;\n&lt;li&gt;\n	厂名：贵州茅台酒股份有限公司\n&lt;/li&gt;\n&lt;li&gt;\n	厂址：贵州省仁怀市茅台镇；仁怀市二合镇玉屏社区；习水县习酒镇黄金坪村\n&lt;/li&gt;\n&lt;li&gt;\n	厂家联系方式：400-617-9999\n&lt;/li&gt;\n&lt;li&gt;\n	保质期：18260 天\n&lt;/li&gt;\n&lt;li&gt;\n	食品添加剂：无\n&lt;/li&gt;\n&lt;li id=&quot;J_attrBrandName&quot;&gt;\n	品牌:&amp;nbsp;Moutai/茅台\n&lt;/li&gt;\n&lt;li&gt;\n	品名:&amp;nbsp;王子6瓶套装\n&lt;/li&gt;\n&lt;li&gt;\n	产地:&amp;nbsp;中国大陆地区\n&lt;/li&gt;\n&lt;li&gt;\n	省份:&amp;nbsp;贵州\n&lt;/li&gt;\n&lt;li&gt;\n	香型:&amp;nbsp;酱香型\n&lt;/li&gt;\n&lt;li&gt;\n	酒精纯度:&amp;nbsp;高度白酒（50%以上）\n&lt;/li&gt;\n&lt;li&gt;\n	包装方式:&amp;nbsp;包装\n&lt;/li&gt;\n&lt;li&gt;\n	包装种类:&amp;nbsp;瓶装\n&lt;/li&gt;\n&lt;li&gt;\n	净含量:&amp;nbsp;500mlX6\n&lt;/li&gt;\n&lt;li&gt;\n	度数:&amp;nbsp;53%vol.\n&lt;/li&gt;', '1', '2016-12-26 00:08:05', '0', '1', '0', '', 'wstshop,酒仙网,茅台王子', '1', '2016-12-26 00:08:05', '0', '0', '0', null, ''),
('29', '148268208588899', '148268208588899', '酒仙网42度五岭洞藏私房酒1000ml安徽古井镇酒浓香型白酒大坛酒', 'upload/goods/2016-12/585fef3d5f393.jpg', '168.00', '98.00', '10', '99', '瓶', '', '1', '1', '0', '1', '1', '49_78', '78', '0', '&lt;li&gt;\n	生产许可证编号：SC11534160200142\n&lt;/li&gt;\n&lt;li&gt;\n	厂名：安徽五岭洞藏酒业有限公司\n&lt;/li&gt;\n&lt;li&gt;\n	厂址：安徽省亳州市谯城区古井镇古井路一号\n&lt;/li&gt;\n&lt;li&gt;\n	厂家联系方式：400-617-9999\n&lt;/li&gt;\n&lt;li&gt;\n	保质期：18260 天\n&lt;/li&gt;\n&lt;li&gt;\n	产品名称：五岭 五岭私房酒 1000mL 4...\n&lt;/li&gt;\n&lt;li&gt;\n	体积(ml):&amp;nbsp;1000\n&lt;/li&gt;\n&lt;li id=&quot;J_attrBrandName&quot;&gt;\n	品牌:&amp;nbsp;五岭\n&lt;/li&gt;\n&lt;li&gt;\n	品名:&amp;nbsp;五岭私房酒\n&lt;/li&gt;\n&lt;li&gt;\n	产地:&amp;nbsp;中国大陆地区\n&lt;/li&gt;\n&lt;li&gt;\n	省份:&amp;nbsp;安徽\n&lt;/li&gt;\n&lt;li&gt;\n	香型:&amp;nbsp;浓香型\n&lt;/li&gt;\n&lt;li&gt;\n	酒精纯度:&amp;nbsp;中度白酒（40%-50%）\n&lt;/li&gt;\n&lt;li&gt;\n	包装方式:&amp;nbsp;包装\n&lt;/li&gt;\n&lt;li&gt;\n	包装种类:&amp;nbsp;礼盒装\n&lt;/li&gt;\n&lt;li&gt;\n	净含量:&amp;nbsp;1000mL\n&lt;/li&gt;\n&lt;li&gt;\n	度数:&amp;nbsp;42%Vol.\n&lt;/li&gt;', '1', '2016-12-26 00:10:15', '0', '1', '0', '', 'wstshop,酒仙网,五岭洞藏私房酒', '1', '2016-12-26 00:10:15', '0', '0', '0', null, ''),
('30', '148268221651564', '148268221651564', '酒仙网52度泸州老窖浓香兰瓷500ml*6 整箱白酒高度白酒', 'upload/goods/2016-12/585fef9f94efa.jpg', '678.00', '356.00', '10', '98', '瓶', '', '1', '1', '1', '1', '1', '49_78', '78', '0', '&lt;li&gt;\n	厂名：泸州老窖股份有限公司\n&lt;/li&gt;\n&lt;li&gt;\n	厂址：1.四川省泸州市国窖广场2.四川省泸州市龙马潭区罗汉镇罗汉场泸州老窖基地3.四川省泸州市龙马潭区安宁\n&lt;/li&gt;\n&lt;li&gt;\n	厂家联系方式：400-617-9999\n&lt;/li&gt;\n&lt;li&gt;\n	保质期：18260 天\n&lt;/li&gt;\n&lt;li id=&quot;J_attrBrandName&quot;&gt;\n	品牌:&amp;nbsp;泸州老窖\n&lt;/li&gt;\n&lt;li&gt;\n	品名:&amp;nbsp;浓香兰瓷套装\n&lt;/li&gt;\n&lt;li&gt;\n	产地:&amp;nbsp;四川\n&lt;/li&gt;\n&lt;li&gt;\n	香型:&amp;nbsp;浓香型\n&lt;/li&gt;\n&lt;li&gt;\n	酒精纯度:&amp;nbsp;高度白酒（50%以上）\n&lt;/li&gt;\n&lt;li&gt;\n	包装方式:&amp;nbsp;包装\n&lt;/li&gt;\n&lt;li&gt;\n	包装种类:&amp;nbsp;箱装\n&lt;/li&gt;\n&lt;li&gt;\n	净含量:&amp;nbsp;500ml*6\n&lt;/li&gt;\n&lt;li&gt;\n	度数:&amp;nbsp;52%Vol.\n&lt;/li&gt;', '2', '2016-12-26 00:11:41', '7', '2', '0', '', 'wstshop,酒仙网,泸州老窖浓香兰瓷', '1', '2016-12-26 00:11:41', '0', '0', '0', null, ''),
('31', '148268249651924', '148268249651924', '现货当天发送豪礼 Xiaomi/小米 红米手机3S全网通红米3s手机', 'upload/goods/2016-12/585ff085c36e9.jpg', '800.00', '699.00', '10', '4499', '台', '', '1', '0', '1', '1', '1', '334_348', '348', '0', '测试商品，请勿下单', '1', '2016-12-26 15:08:00', '6', '1', '1', 'upload/goods/2016-12/585ff1dae303f.jpg', 'wstshop,小米,红米3s', '1', '2016-12-26 00:21:24', '0', '0', '0', null, ''),
('32', '148268301527585', '148268301527585', '360移动版指纹八核f4手机', 'upload/goods/2016-12/585ff2baeb585.jpg', '700.00', '499.00', '10', '749', '台', '现货当天发，购买送纳米防爆膜+购机礼包+入耳线控耳机套餐加送蓝牙耳机/16G内存卡+自拍杆等豪礼！18点前付款当天发出！360F4,圆润有型，自如随心，0.4S指纹解锁，安全支付，13', '1', '0', '1', '1', '1', '334_348', '348', '0', '&lt;img src=&quot;/upload/image/2016-12/585ff374d1391.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585ff3755ec8a.jpg&quot; alt=&quot;&quot; /&gt;', '1', '2016-12-26 15:06:45', '3', '1', '1', 'upload/goods/2016-12/585ff36903313.jpg', 'wstshop,360手机，', '1', '2016-12-26 00:27:39', '0', '0', '0', null, '现货当天发，购买送纳米防爆膜+购机礼包+入耳线控耳机套餐加送蓝牙耳机/16G内存卡+自拍杆等豪礼！18点前付款当天发出！360F4,圆润有型，自如随心，0.4S指纹解锁，安全支付，13'),
('33', '148268331745160', '148268331745160', 'Meizu/魅族 MX5e移动联通4G智能手机', 'upload/goods/2016-12/585ff3fb8cfab.jpg', '799.00', '699.00', '10', '299', '台', '官方授权，皇冠大卖家。大量现货急速发，下单即防爆膜，透明保护套，购机大礼包等豪礼，购买套餐四即送10400毫安移动电源+魅族原装EP21耳机+高档视窗皮套+剪卡器含卡托等豪礼。', '1', '1', '1', '1', '1', '334_348', '348', '0', '&lt;img src=&quot;/upload/image/2016-12/585ff4682df39.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585ff468d99d7.jpg&quot; alt=&quot;&quot; /&gt;', '1', '2016-12-26 15:05:46', '3', '1', '1', 'upload/goods/2016-12/585ff44800131.jpg', 'wstshop,魅族,meizu手机', '1', '2016-12-26 00:32:11', '0', '0', '0', null, '官方授权，皇冠大卖家。大量现货急速发，下单即防爆膜，透明保护套，购机大礼包等豪礼，购买套餐四即送10400毫安移动电源+魅族原装EP21耳机+高档视窗皮套+剪卡器含卡托等豪礼。'),
('34', '148268357612672', '148268357612672', '华为 honor/荣耀 畅玩4C移动版电信双4G智能手机', 'upload/goods/2016-12/585ff50c8dd52.jpg', '899.00', '799.00', '10', '799', '台', '本店为华为荣耀官方自营店，享受官方高品质物流及售后服务', '1', '1', '0', '1', '1', '334_348', '348', '0', '&lt;ul class=&quot;attributes-list&quot;&gt;\n	&lt;li&gt;\n		CPU品牌:&amp;nbsp;海思\n	&lt;/li&gt;\n	&lt;li&gt;\n		CPU型号:&amp;nbsp;麒麟620\n	&lt;/li&gt;\n	&lt;li&gt;\n		产品名称:&amp;nbsp;荣耀畅玩4C\n	&lt;/li&gt;\n	&lt;li&gt;\n		品牌:&amp;nbsp;honor/荣耀\n	&lt;/li&gt;\n	&lt;li&gt;\n		型号:&amp;nbsp;畅玩4C移动版\n	&lt;/li&gt;\n	&lt;li&gt;\n		上市时间:&amp;nbsp;2015年5月\n	&lt;/li&gt;\n	&lt;li&gt;\n		网络类型:&amp;nbsp;移动4G\n	&lt;/li&gt;\n	&lt;li&gt;\n		款式:&amp;nbsp;直板\n	&lt;/li&gt;\n	&lt;li&gt;\n		尺寸:&amp;nbsp;5.0英寸\n	&lt;/li&gt;\n	&lt;li&gt;\n		机身颜色:&amp;nbsp;移动定制高配白色\n	&lt;/li&gt;\n	&lt;li&gt;\n		套餐类型:&amp;nbsp;官方标配\n	&lt;/li&gt;\n	&lt;li&gt;\n		后置摄像头:&amp;nbsp;1300万\n	&lt;/li&gt;\n	&lt;li&gt;\n		操作系统:&amp;nbsp;Android/安卓\n	&lt;/li&gt;\n	&lt;li&gt;\n		附加功能:&amp;nbsp;OTG 光线感应 重力感应 WIFI上网 GPS导航 双卡双待 GPRS上网\n	&lt;/li&gt;\n	&lt;li&gt;\n		宝贝成色:&amp;nbsp;全新\n	&lt;/li&gt;\n	&lt;li&gt;\n		售后服务:&amp;nbsp;全国联保\n	&lt;/li&gt;\n	&lt;li&gt;\n		触摸屏类型:&amp;nbsp;电容屏，多点触控\n	&lt;/li&gt;\n	&lt;li&gt;\n		存储容量:&amp;nbsp;16GB\n	&lt;/li&gt;\n	&lt;li&gt;\n		键盘类型:&amp;nbsp;虚拟触屏键盘\n	&lt;/li&gt;\n	&lt;li&gt;\n		厚度:&amp;nbsp;9mm以下\n	&lt;/li&gt;\n	&lt;li&gt;\n		分辨率:&amp;nbsp;1280x720\n	&lt;/li&gt;\n	&lt;li&gt;\n		手机类型:&amp;nbsp;拍照手机 音乐手机 时尚手机 智能手机 4G手机 女性手机\n	&lt;/li&gt;\n	&lt;li&gt;\n		电池类型:&amp;nbsp;不可拆卸式电池\n	&lt;/li&gt;\n	&lt;li&gt;\n		摄像头类型:&amp;nbsp;双摄像头（前后）\n	&lt;/li&gt;\n	&lt;li&gt;\n		视频显示格式:&amp;nbsp;1080P(全高清D5)\n	&lt;/li&gt;\n	&lt;li&gt;\n		网络模式:&amp;nbsp;双卡多模\n	&lt;/li&gt;\n	&lt;li&gt;\n		版本类型:&amp;nbsp;中国大陆\n	&lt;/li&gt;\n&lt;/ul&gt;', '1', '2016-12-26 15:05:00', '2', '1', '1', 'upload/goods/2016-12/585ff53d3a0fb.jpg', 'wstshop,华为手机,荣耀畅玩4c', '1', '2016-12-26 00:36:06', '0', '0', '0', null, '本店为华为荣耀官方自营店，享受官方高品质物流及售后服务'),
('35', '148268381208292', '148268381208292', 'Apple/苹果 iPhone 6 Plus苹果6p港版美版S版无锁官换机 花呗分期', 'upload/goods/2016-12/585ff5f6bc573.jpg', '4210.00', '3310.00', '10', '2099', '台', '【全新未激活官换机【支持8天无理由退货】【支持专柜验货--官方售后验证--顺丰包邮】【亚太选框为新加坡版支持移动联通234G】欧版选框为美国V版支持移动2G联通电信234G', '1', '1', '1', '0', '1', '334_348', '348', '0', '&lt;img src=&quot;/upload/image/2016-12/585ff6d0785b4.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585ff6d0e32b6.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585ff6d1cc48b.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585ff6d2d7bb4.jpg&quot; alt=&quot;&quot; /&gt;', '1', '2016-12-26 15:04:01', '2', '1', '1', 'upload/goods/2016-12/585ff6398af55.jpg,upload/goods/2016-12/585ff639cf9fb.jpg', 'wstshop,Apple/苹果 iPhone 6 Plus', '1', '2016-12-26 00:42:12', '0', '0', '0', null, '【全新未激活官换机【支持8天无理由退货】【支持专柜验货--官方售后验证--顺丰包邮】【亚太选框为新加坡版支持移动联通234G】欧版选框为美国V版支持移动2G联通电信234G'),
('36', '148268417429079', '148268417429079', '现货送豪礼 honor/荣耀 荣耀7i移动版全网通翻转镜头手机', 'upload/goods/2016-12/585ff75d0711f.png', '799.00', '699.00', '10', '1298', '台', '购买即送纳米防爆膜，NaNo剪卡器，套餐加送入耳耳机，透明保护套等购机礼品，具体可见套餐详情，荣耀7i，翻转吧，视界。创新的180度旋转镜头，可自由停在任意角度，让你更有趣地记录生活，拍出精彩。', '1', '0', '1', '1', '1', '334_348', '348', '0', '&lt;ul class=&quot;attributes-list&quot;&gt;\n	&lt;li&gt;\n		&lt;img src=&quot;/upload/image/2016-12/585ff7a829a32.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/585ff7a929a3e.jpg&quot; alt=&quot;&quot; /&gt;\n	&lt;/li&gt;\n&lt;/ul&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;', '1', '2016-12-26 15:02:15', '9', '1', '1', 'upload/goods/2016-12/585ff7b34c011.jpg,upload/goods/2016-12/585ff7b37226d.jpg', 'wstshop,华为荣耀( honor)7i', '1', '2016-12-26 00:47:55', '0', '0', '0', null, '购买即送纳米防爆膜，NaNo剪卡器，套餐加送入耳耳机，透明保护套等购机礼品，具体可见套餐详情，荣耀7i，翻转吧，视界。创新的180度旋转镜头，可自由停在任意角度，让你更有趣地记录生活，拍出精彩。'),
('37', '148273320515996', '148273320515996', 'CONBA/康恩贝 维生素C咀嚼片（香橙味） 1.2g/片*100片*2瓶套餐', 'upload/goods/2016-12/5860b69e6058d.jpg', '212.00', '39.00', '10', '999', '瓶', '口碑力荐 累计销售 超300万瓶 香橙味', '1', '1', '1', '0', '1', '53_137', '137', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：山东圣海保健品有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：山东省淄博市\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：4006838080\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：730 天\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：CONBA/康恩贝 维生素C咀嚼...\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品剂型:&amp;nbsp;片剂\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保健食品产品名称:&amp;nbsp;维生素C咀嚼片（香橙味）\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;CONBA/康恩贝\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准文号:&amp;nbsp;国食健字G20100544\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		具体规格:&amp;nbsp;1.2g/片*100片*2瓶套餐\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		是否礼盒装:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		是否进口:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		注意事项:本品不能代替药物；不宜超过推荐量或与同类营养素补充剂同时食用\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准日期:2013-11-04\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		不适宜人群:孕妇、乳母\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准变更日期:2014-07-21\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		有效期至:2018-11-03\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		贮藏方法:密封、置阴凉干燥处\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称:维生素C咀嚼片（香橙味）\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		功能:补充维生素C\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		申请人中文名称:山东圣海保健品有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		功效成分/标志性成分含量:每片含：维生素C 213mg\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		适宜人群:需要补充维生素C的成人\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		主要原料:维生素C、木糖醇、淀粉、聚维酮K30、甜菊糖苷、甜橙油、姜黄色素、硬脂酸镁\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准文号:国食健字G20100544\n	&lt;/li&gt;\n&lt;/ul&gt;\n&lt;img src=&quot;/upload/image/2016-12/5860b733dbd1a.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/5860b73420e6a.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/5860b73469621.jpg&quot; alt=&quot;&quot; /&gt;', '1', '2016-12-26 14:22:54', '0', '1', '0', 'upload/goods/2016-12/5860b6a917f7d.jpg,upload/goods/2016-12/5860b6a92369a.jpg', 'wstshop,CONBA/康恩贝, 维生素C', '1', '2016-12-26 14:22:54', '0', '0', '0', null, '口碑力荐 累计销售 超300万瓶 香橙味'),
('38', '148273337486961', '148273337486961', '安普生邦利 鱼油软胶囊 1g/粒*300粒*2瓶套餐', 'upload/goods/2016-12/5860b7c53555a.jpg', '298.00', '199.00', '10', '999', '瓶', '中老年保健 辅助降血脂 健康孝心礼 配磷脂更好', '1', '1', '1', '1', '1', '53_138', '138', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：广州联存医药科技股份有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：广州市越秀区先烈中路100号23-1栋402、404房\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：020-87680731\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：720 天\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：安普生邦利 鱼油软胶囊 1g...\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品剂型:&amp;nbsp;胶囊\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保健食品产品名称:&amp;nbsp;鱼油软胶囊\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;安普生邦利\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准文号:&amp;nbsp;国食健字G20130079\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		具体规格:&amp;nbsp;1g/粒*300粒*2瓶套餐\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		是否礼盒装:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		是否进口:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		注意事项:本品不能代替药物；本品添加了营养素，与同类营养素同时食用不宜超过推荐量\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准日期:2011-01-28\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		不适宜人群:少年儿童、孕妇、乳母\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准变更日期:2015-08-18\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		有效期至:2016-01-27\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		贮藏方法:密封，置阴凉干燥处\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称:鱼油软胶囊\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		功能:辅助降血脂\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		申请人中文名称:广州联存医药科技股份有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		功效成分/标志性成分含量:每100g含：二十碳五烯酸（EPA) 16g、二十二碳六烯酸（DHA）10g\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		适宜人群:血脂偏高者\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		主要原料:鱼油、天然维生素E、明胶、甘油、水\n	&lt;/li&gt;\n&lt;/ul&gt;\n&lt;p&gt;\n	&lt;ul style=&quot;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;&quot;&gt;\n		&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n			批准文号:国食健字G20130079\n		&lt;/li&gt;\n		&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n			&lt;img src=&quot;/upload/image/2016-12/5860b81e39fbd.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/5860b8210c3bd.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/5860b822da3ea.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/5860b82310114.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\n		&lt;/li&gt;\n	&lt;/ul&gt;\n&lt;/p&gt;', '1', '2016-12-26 14:27:06', '1', '1', '0', 'upload/goods/2016-12/5860b832de35a.jpg,upload/goods/2016-12/5860b8336424d.jpg,upload/goods/2016-12/5860b83395bca.jpg', 'wstshop,安普生邦利 鱼油软胶囊', '1', '2016-12-26 14:27:06', '0', '0', '0', null, '中老年保健 辅助降血脂 健康孝心礼 配磷脂更好'),
('39', '148273362739492', '148273362739492', '安普生邦利 联合邦利牌芦荟软胶囊 1g/粒*60粒*2瓶套餐', 'upload/goods/2016-12/5860b8aa4e5ed.jpg', '99.00', '68.00', '20', '999', '瓶', '清肠通便 一身轻松 买2件送VB 收藏送药盒', '1', '1', '1', '1', '1', '53_138', '138', '0', '&lt;ul id=&quot;J_AttrUL&quot;&gt;\n	&lt;li&gt;\n		厂名：广州联存医药科技有限公司\n	&lt;/li&gt;\n	&lt;li&gt;\n		厂址：广州市白云区钟落谭镇良田中路170号\n	&lt;/li&gt;\n	&lt;li&gt;\n		厂家联系方式：020-87680731\n	&lt;/li&gt;\n	&lt;li&gt;\n		保质期：730 天\n	&lt;/li&gt;\n	&lt;li&gt;\n		产品名称：安普生邦利 联合邦利牌芦荟...\n	&lt;/li&gt;\n	&lt;li&gt;\n		产品剂型:&amp;nbsp;胶囊\n	&lt;/li&gt;\n	&lt;li&gt;\n		保健食品产品名称:&amp;nbsp;联合邦利牌芦荟软胶囊\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot;&gt;\n		品牌:&amp;nbsp;安普生邦利\n	&lt;/li&gt;\n	&lt;li&gt;\n		批准文号:&amp;nbsp;国食健字G20130519\n	&lt;/li&gt;\n	&lt;li&gt;\n		具体规格:&amp;nbsp;1g/粒*60粒*2瓶套餐\n	&lt;/li&gt;\n	&lt;li&gt;\n		是否礼盒装:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li&gt;\n		是否进口:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li&gt;\n		食用方法和食用量:每日2次，每次1粒，口服\n	&lt;/li&gt;\n	&lt;li&gt;\n		注意事项:本品不能代替药物；食用本品后如出现腹泻，请立即停止食用\n	&lt;/li&gt;\n	&lt;li&gt;\n		批准日期:2015-06-02\n	&lt;/li&gt;\n	&lt;li&gt;\n		不适宜人群:少年儿童、孕产妇、乳母、慢性腹泻者\n	&lt;/li&gt;\n	&lt;li&gt;\n		有效期至:2020-06-01\n	&lt;/li&gt;\n	&lt;li&gt;\n		贮藏方法:密封，置阴凉干燥处\n	&lt;/li&gt;\n	&lt;li&gt;\n		产品名称:联合邦利牌芦荟软胶囊\n	&lt;/li&gt;\n	&lt;li&gt;\n		功能:通便\n	&lt;/li&gt;\n	&lt;li&gt;\n		申请人中文名称:广州联存医药科技股份有限公司\n	&lt;/li&gt;\n	&lt;li&gt;\n		功效成分/标志性成分含量:每100g含：芦荟苷 4.0g\n	&lt;/li&gt;\n	&lt;li&gt;\n		适宜人群:便秘者\n	&lt;/li&gt;\n	&lt;li&gt;\n		主要原料:芦荟粉、大豆油、蜂蜡、明胶、甘油、二氧化钛、柠檬黄、纯化水\n	&lt;/li&gt;\n&lt;/ul&gt;\n&lt;p&gt;\n	&lt;ul&gt;\n		&lt;li&gt;\n			批准文号:国食健字G20130519\n		&lt;/li&gt;\n		&lt;li&gt;\n			&lt;img src=&quot;/upload/image/2016-12/5860b932799bd.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/5860b93338c41.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/5860b93488e31.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/5860b934af091.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/5860b9362988d.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\n		&lt;/li&gt;\n	&lt;/ul&gt;\n&lt;/p&gt;', '1', '2016-12-26 14:31:35', '0', '1', '0', 'upload/goods/2016-12/5860b944d5557.jpg', 'wstshop,安普生邦利 联合邦利牌芦荟软胶囊', '1', '2016-12-26 14:31:35', '0', '0', '0', null, '清肠通便 一身轻松 买2件送VB 收藏送药盒'),
('40', '148273389587396', '148273389587396', '盛力源牌蜂胶软胶囊 0.5g/粒*100粒*4瓶套餐', 'upload/goods/2016-12/5860b9d795dc1.jpg', '389.00', '298.00', '10', '999', '盒', '买一送一 送同款', '1', '0', '1', '1', '1', '53_138', '138', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：郑州轩生堂药业有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：郑州高新区丁香里12号三层\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：400-000-1613\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		配料表：黄芪、西洋参、枸杞子、绞股蓝、银耳、女贞子、黄精\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		储藏方法：密封，置阴凉干燥处\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：720 天\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：轩生堂牌百福生胶囊 0.3g...\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品剂型:&amp;nbsp;胶囊\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保健食品产品名称:&amp;nbsp;轩生堂牌百福生胶囊\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;轩生堂\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准文号:&amp;nbsp;卫食健字(2002)第0467号\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		具体规格:&amp;nbsp;0.3g/粒*100粒\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		是否礼盒装:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		是否进口:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		注意事项:本品不能代替药物\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准日期:2002-06-19\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		不适宜人群:少年儿童\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		受让方:郑州轩生堂药业有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		贮藏方法:密封、置阴凉干燥处\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称:轩生堂牌百福生胶囊\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		功能:免疫调节、抗疲劳\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		申请人中文名称:郑州轩生堂药业有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		功效成分/标志性成分含量:每100g含：粗多糖（以葡聚糖计）798mg、总皂甙（以人参皂甙Re计）253.5mg\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		转让方中文名称:郑州博生医药技术发展有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		适宜人群:免疫力低下者、易疲劳者\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		主要原料:黄芪、西洋参、枸杞子、绞股蓝、银耳、女贞子、黄精\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准文号:卫食健字(2002)第0467号\n	&lt;/li&gt;\n&lt;/ul&gt;\n&lt;img src=&quot;/upload/image/2016-12/5860ba70dfc6a.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/5860ba7124dba.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/5860ba715e14a.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/5860ba71e399a.jpg&quot; alt=&quot;&quot; /&gt;', '1', '2016-12-26 14:36:40', '0', '1', '0', 'upload/goods/2016-12/5860b9dc41fad.jpg,upload/goods/2016-12/5860b9dc6820d.jpg,upload/goods/2016-12/5860b9dc7f047.jpg', 'wstshop,盛力源牌蜂胶软胶囊', '1', '2016-12-26 14:36:40', '0', '0', '0', null, '买一送一 送同款'),
('41', '148273420121386', '148273420121386', '康富来 赛天仙牌牦牛骨髓壮骨粉 30g/袋*10袋*2罐', 'upload/goods/2016-12/5860bb4f3d07b.jpg', '120.00', '98.00', '10', '999', '盒', '新店开业 购物有礼', '1', '1', '1', '1', '1', '53_138', '138', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：广东康富来药业有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：广东省佛山市顺德区容桂容里成业路63路\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：400-888-0682\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：730 天\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：康富来 赛天仙牌牦牛骨髓壮...\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品剂型:&amp;nbsp;粉剂\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保健食品产品名称:&amp;nbsp;赛天仙牌牦牛骨髓壮骨粉\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;康富来\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准文号:&amp;nbsp;国食健字G20041288\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		具体规格:&amp;nbsp;30g/袋*10袋*2罐\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		是否礼盒装:&amp;nbsp;是\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		是否进口:&amp;nbsp;是\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		食用方法和食用量:每日1次，每次30g，以沸水冲成糊状食用\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		注意事项:本品不能代替药物\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称:赛天仙牌牦牛骨髓壮骨粉\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		功能:增加骨密度、增强免疫力\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准日期:2004-10-26\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		申请人中文名称:广东康富来药业有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		功效成分/标志性成分含量:每100g含：钙3.30g、粗多糖 1.07g\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		不适宜人群:无\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		适宜人群:中老年人、免疫力低下者\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		贮藏方法:置阴凉干燥处\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		主要原料:芝麻、大米、花生、山药、莲子、牦牛骨髓骨粉、麦芽糊精、脱脂奶粉、酪蛋白磷酸肽、阿斯巴甜（含苯丙氨酸）\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准文号:国食健字G20041288\n	&lt;/li&gt;\n&lt;/ul&gt;', '1', '2016-12-26 14:41:35', '1', '1', '0', 'upload/goods/2016-12/5860bb99e53a1.jpg,upload/goods/2016-12/5860bb9a67581.jpg,upload/goods/2016-12/5860bb9ad9c98.jpg', 'wstshop,康富来 赛天仙牌牦牛骨髓壮骨粉', '1', '2016-12-26 14:41:35', '0', '0', '0', null, '新店开业 购物有礼'),
('42', '148273449559539', '148273449559539', '盛力源牌蜂胶软胶囊 0.5g/粒*100粒*4瓶套餐', 'upload/goods/2016-12/5860bc175962e.jpg', '698.00', '569.00', '10', '998', '瓶', '盛力源牌原厂 正品 拍1发8瓶 总黄酮 6.12', '1', '0', '1', '0', '1', '53_138', '138', '0', '&lt;ul id=&quot;J_AttrUL&quot;&gt;\n	&lt;li&gt;\n		厂名：河南佰汇康生物科技有限公司\n	&lt;/li&gt;\n	&lt;li&gt;\n		厂址：长葛市产业聚集区未来路东侧\n	&lt;/li&gt;\n	&lt;li&gt;\n		厂家联系方式：0731-82625767\n	&lt;/li&gt;\n	&lt;li&gt;\n		保质期：730 天\n	&lt;/li&gt;\n	&lt;li&gt;\n		产品名称：盛力源牌蜂胶软胶囊 0.5g...\n	&lt;/li&gt;\n	&lt;li&gt;\n		产品剂型:&amp;nbsp;软胶囊\n	&lt;/li&gt;\n	&lt;li&gt;\n		保健食品产品名称:&amp;nbsp;盛力源牌蜂胶软胶囊\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot;&gt;\n		品牌:&amp;nbsp;盛力源\n	&lt;/li&gt;\n	&lt;li&gt;\n		批准文号:&amp;nbsp;国食健字G20110465\n	&lt;/li&gt;\n	&lt;li&gt;\n		具体规格:&amp;nbsp;0.5g/粒*100粒*4瓶套餐\n	&lt;/li&gt;\n	&lt;li&gt;\n		是否礼盒装:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li&gt;\n		是否进口:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li&gt;\n		食用方法和食用量:每日1次，每次2粒\n	&lt;/li&gt;\n	&lt;li&gt;\n		注意事项:本品不能代替药物\n	&lt;/li&gt;\n	&lt;li&gt;\n		批准日期:2011-07-26\n	&lt;/li&gt;\n	&lt;li&gt;\n		不适宜人群:少年儿童及蜂产品过敏者\n	&lt;/li&gt;\n	&lt;li&gt;\n		有效期至:2016-07-25\n	&lt;/li&gt;\n	&lt;li&gt;\n		贮藏方法:密闭，置阴凉干燥避光处\n	&lt;/li&gt;\n	&lt;li&gt;\n		产品名称:盛力源牌蜂胶软胶囊\n	&lt;/li&gt;\n	&lt;li&gt;\n		功能:增强免疫力\n	&lt;/li&gt;\n	&lt;li&gt;\n		申请人中文名称:河南佰汇康生物科技有限公司\n	&lt;/li&gt;\n	&lt;li&gt;\n		功效成分/标志性成分含量:每100g含：总黄酮 6.12g\n	&lt;/li&gt;\n	&lt;li&gt;\n		适宜人群:免疫力低下者\n	&lt;/li&gt;\n	&lt;li&gt;\n		主要原料:蜂胶、聚乙二醇400、明胶、甘油、水\n	&lt;/li&gt;\n	&lt;li&gt;\n		批准文号:国食健字G20110465\n	&lt;/li&gt;\n&lt;/ul&gt;\n&lt;img src=&quot;/upload/image/2016-12/5860bc7896e09.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/5860bc79e32d6.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/5860bc7ae6ff3.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/5860bc7c654dd.jpg&quot; alt=&quot;&quot; /&gt;', '2', '2016-12-26 14:45:42', '3', '2', '0', 'upload/goods/2016-12/5860bc914ab2f.jpg,upload/goods/2016-12/5860bc9161967.jpg,upload/goods/2016-12/5860bc9174a95.jpg', 'wstshop,', '1', '2016-12-26 14:45:42', '0', '0', '0', null, '盛力源牌原厂 正品 拍1发8瓶 总黄酮 6.12'),
('43', '148273659098220', '148273659098220', '海之梦 洗车液 泡沫洗车水蜡套装汽车清洗清洁剂去污浓缩大桶用品', 'upload/goods/2016-12/5860c3fd4458a.jpg', '39.00', '29.00', '10', '1000', '瓶', '去污上光 3件套 磨绒加厚毛巾 珊瑚海绵', '1', '0', '0', '0', '1', '48_258', '258', '1', '&lt;p class=&quot;attr-list-hd tm-clear&quot; style=&quot;color:#999999;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;&quot;&gt;\n	&lt;span style=&quot;font-weight:700;&quot;&gt;产品参数：&lt;/span&gt; \n&lt;/p&gt;\n&lt;ul id=&quot;J_AttrUL&quot; style=&quot;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;&quot;&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;海之梦\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		型号:&amp;nbsp;xzm-023\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		净含量:&amp;nbsp;1L(含)-2L(含)\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		服务内容:&amp;nbsp;支持清洗服务\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		车用清洗剂分类:&amp;nbsp;洗车蜡\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		锈渍去除剂:&amp;nbsp;去污上光\n	&lt;/li&gt;\n&lt;/ul&gt;\n&lt;p&gt;\n	&lt;span&gt;&lt;img src=&quot;/upload/image/2016-12/5860c46b48ad3.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\n&lt;/span&gt; \n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span&gt;&lt;br /&gt;\n&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span&gt;&lt;img src=&quot;/upload/image/2016-12/5860c4ca6b747.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\n&lt;/span&gt;\n&lt;/p&gt;', '0', '2016-12-26 15:20:45', '2', '0', '0', 'upload/goods/2016-12/5860c406e49bd.jpg,upload/goods/2016-12/5860c4073cc37.jpg,upload/goods/2016-12/5860c4074c05c.jpg', '免费B2C', '1', '2016-12-26 15:19:10', '0', '0', '0', null, '去污上光 3件套 磨绒加厚毛巾 珊瑚海绵'),
('44', '148273720865036', '148273720865036', '【5袋装】优洁士百洁布厨房清洁用品魔力海绵擦清洁布双面海绵刷', 'upload/goods/2016-12/5860c6552102d.jpg', '30.00', '29.00', '10', '1000', '件', '', '1', '1', '0', '0', '1', '48_258', '258', '2', '&lt;p&gt;\n	&lt;p class=&quot;attr-list-hd tm-clear&quot; style=&quot;color:#999999;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;&quot;&gt;\n		&lt;span style=&quot;font-weight:700;&quot;&gt;&amp;nbsp;&lt;/span&gt;\n	&lt;/p&gt;\n	&lt;p class=&quot;attr-list-hd tm-clear&quot; style=&quot;color:#999999;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;&quot;&gt;\n		&lt;span style=&quot;font-weight:700;&quot;&gt;产品参数：&lt;/span&gt;\n	&lt;/p&gt;\n	&lt;ul id=&quot;J_AttrUL&quot; style=&quot;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;&quot;&gt;\n		&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n			品牌:&amp;nbsp;优洁士\n		&lt;/li&gt;\n		&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n			型号:&amp;nbsp;百洁布海绵刷\n		&lt;/li&gt;\n		&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n			颜色分类:&amp;nbsp;15片 发泡粒子百洁布&amp;nbsp;5片 起绒印&lt;span style=&quot;font-family:&#039;sans serif&#039;, tahoma, verdana, helvetica;line-height:1.5;&quot;&gt;&lt;/span&gt;\n		&lt;/li&gt;\n	&lt;/ul&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/upload/image/2016-12/5860c69c979a0.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '2016-12-26 15:28:56', '1', '0', '0', 'upload/goods/2016-12/5860c65d4361a.jpg,upload/goods/2016-12/5860c65d4361a.jpg', 'php开源系统', '1', '2016-12-26 15:28:56', '0', '0', '0', null, ''),
('45', '148273937757761', '148273937757761', '3双装厨房家用洗碗手套加长洗衣加绒加厚耐用家务手套清洁加长', 'upload/goods/2016-12/5860cebf7642a.jpg', '9.00', '8.00', '20', '20000', '件', '', '1', '1', '0', '1', '1', '48_258', '258', '3', '&lt;img src=&quot;/upload/image/2016-12/5860cf2064187.jpg&quot; alt=&quot;&quot; /&gt;', '0', '2016-12-26 16:04:50', '0', '0', '0', 'upload/goods/2016-12/5860cec635794.jpg,upload/goods/2016-12/5860cec71ac77.jpg,upload/goods/2016-12/5860cec72268a.jpg', '开源B2C商城', '1', '2016-12-26 16:04:50', '0', '0', '0', null, ''),
('46', '148273981382875', '148273981382875', '5卷100只加厚垃圾袋断点式彩色厨房卫生间家用塑料袋中大号', 'upload/goods/2016-12/5860d07e0fa2a.jpg', '30.00', '28.00', '20', '20000', '件', '促销大卖', '1', '1', '1', '1', '1', '48_261', '261', '3', '&lt;img src=&quot;/upload/image/2016-12/5860d0ee053da.jpg&quot; alt=&quot;&quot; /&gt;', '0', '2016-12-26 16:12:32', '0', '0', '0', 'upload/goods/2016-12/5860d084c6cdd.jpg,upload/goods/2016-12/5860d084f0c47.jpg,upload/goods/2016-12/5860d0852e384.jpg', 'php免费B2C商城', '1', '2016-12-26 16:12:32', '0', '0', '0', null, '促销大卖'),
('47', '148274021185975', '148274021185975', 'Walch/威露士绿劲去重油污净700ml*2', 'upload/goods/2016-12/5860d28477ad7.jpg', '35.00', '29.00', '23', '23099', '件', '居家必选', '1', '1', '1', '1', '1', '48_258', '258', '5', '&lt;img src=&quot;/upload/image/2016-12/5860d2e3061f7.jpg&quot; alt=&quot;&quot; /&gt;', '0', '2016-12-26 16:20:53', '0', '0', '0', 'upload/goods/2016-12/5860d28be28f0.jpg', 'PHP开源商城', '1', '2016-12-26 16:20:53', '0', '0', '0', null, '居家必选'),
('48', '148274760955620', '148274760955620', '冠莲 红莲子干货去芯粮油土特产农产品特价洪湖莲子', 'upload/goods/2016-12/5860f39e933ec.jpg', '52.00', '33.00', '5', '50', '件', '', '1', '1', '1', '1', '1', '50_219', '219', '0', '&lt;span style=&quot;color:#DD2727;font-family:&#039;microsoft yahei&#039;;font-size:14px;font-style:normal;font-weight:normal;line-height:21px;background-color:#FFFFFF;&quot;&gt;\n&lt;p class=&quot;attr-list-hd tm-clear&quot; style=&quot;color:#999999;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&lt;em&gt;产品参数：&lt;/em&gt;\n&lt;/p&gt;\n&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		生产许可证编号：QS3600 1601 0182\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品标准号：GB/T20356-2006\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：广昌县福兴食品有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：江西省抚州市广昌县工业园区\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：0794-3631618\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		配料表：莲子\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		储藏方法：阴凉干燥处\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：360 天\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		食品添加剂：无\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		净含量:&amp;nbsp;500g\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装方式:&amp;nbsp;包装\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;冠莲\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		系列:&amp;nbsp;钻芯红莲\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		规格:&amp;nbsp;500g\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;中国大陆\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		省份:&amp;nbsp;湖北省\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		城市:&amp;nbsp;荆州市\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		套餐份量:&amp;nbsp;4人份\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		套餐周期:&amp;nbsp;1周\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		配送频次:&amp;nbsp;1周2次\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		克重:&amp;nbsp;200g(含)-500g(含)\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		是否进口:&amp;nbsp;国产\n	&lt;/li&gt;\n&lt;/ul&gt;\n&lt;/span&gt;&lt;br /&gt;', '0', '2016-12-26 18:55:33', '2', '0', '0', 'upload/goods/2016-12/5860f6e815db9.jpg,upload/goods/2016-12/5860f6e8c927c.jpg,upload/goods/2016-12/5860f6e95e596.jpg', '冠莲 红莲子 洪湖莲子', '1', '2016-12-26 18:41:23', '0', '0', '0', null, ''),
('49', '148274922550996', '148274922550996', '【冠莲和田小枣250g】新疆干果和田红枣休闲零食干果新疆特产一等', 'upload/goods/2016-12/5860f69b690ff.jpg', '30.00', '9.90', '10', '3975', '件', '', '1', '1', '1', '1', '1', '50_219', '219', '0', '&lt;p class=&quot;attr-list-hd tm-clear&quot; style=&quot;color:#999999;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&lt;em&gt;产品参数：&lt;/em&gt;\n&lt;/p&gt;\n&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		生产许可证编号：QS3600 1702 0024\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：广昌县福兴食品有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：江西省抚州市广昌县工业园区\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：0794-3637565\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：360 天\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		食品添加剂：无\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		净含量:&amp;nbsp;250g\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装方式:&amp;nbsp;包装\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;冠莲\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		系列:&amp;nbsp;和田小枣\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		零食种类:&amp;nbsp;新疆和田枣\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		枣类产品:&amp;nbsp;原粒枣\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		特产品类:&amp;nbsp;新疆和田玉枣\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		级别:&amp;nbsp;一级\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;中国大陆\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		省份:&amp;nbsp;新疆维吾尔族自治区\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-26 18:55:46', '2', '0', '0', '', 'WSTShop 冠莲 和田小枣 红枣新疆特产', '1', '2016-12-26 18:53:35', '0', '0', '0', null, ''),
('50', '148274996583527', '148274996583527', '国标一级 稻园牌稻米油粮油米糠油绿色植物油食用油5L 三大健康油', 'upload/goods/2016-12/5860f8884b59c.jpg', '169.00', '149.00', '10', '1555', '件', '', '1', '1', '1', '1', '1', '50_220', '220', '0', '&lt;p class=&quot;attr-list-hd tm-clear&quot; style=&quot;color:#999999;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&lt;em&gt;产品参数：&lt;/em&gt;\n&lt;/p&gt;\n&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		生产许可证编号：QS2304 0201 4017\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品标准号： GB19112\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：黑龙江万禾园油脂有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：鹤岗市蔬园乡财经学校南侧\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：0451--87707234\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		配料表：100%特殊冷过滤稻米油、天然谷维素\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		储藏方法：低温、干燥、避光保存\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：540 天\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		食品添加剂：无\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		净含量:&amp;nbsp;5000ml\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装方式:&amp;nbsp;包装\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;稻园\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		系列:&amp;nbsp;一级稻米油\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		规格:&amp;nbsp;5L\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		商品条形码:&amp;nbsp;6939984300056\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		是否为有机食品:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		油品类:&amp;nbsp;米糠油\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;中国大陆\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		省份:&amp;nbsp;黑龙江省\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		城市:&amp;nbsp;哈尔滨市\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		套餐份量:&amp;nbsp;3人份\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		套餐周期:&amp;nbsp;1个月\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		配送频次:&amp;nbsp;1周2次\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-26 19:04:00', '1', '0', '0', 'upload/goods/2016-12/5860f91cecf63.jpg,upload/goods/2016-12/5860f91d58313.jpg,upload/goods/2016-12/5860f91e1b29f.jpg', '国标一级 稻园牌 植物油 食用油 健康油', '1', '2016-12-26 19:03:16', '0', '0', '0', null, ''),
('51', '148275050530904', '148275050530904', '晋味美沁州黄小米1.8kg山西特产小黄米粮油宝宝米农家杂粮小米粥', 'upload/goods/2016-12/5860faf14925c.jpg', '40.90', '36.50', '10', '4520', '件', '', '1', '1', '1', '1', '1', '50_222', '222', '0', '&lt;p class=&quot;attr-list-hd tm-clear&quot; style=&quot;color:#999999;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&lt;em&gt;产品参数：&lt;/em&gt;\n&lt;/p&gt;\n&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		生产许可证编号：SC1011404301014X\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品标准号：GB/T11766\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：沁县晋味美食品有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：山西省长治市沁县定昌镇下曲峪村\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：03516860688\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		配料表：沁州黄小米\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		储藏方法：阴凉干燥通风处\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：365 天\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		食品添加剂：无\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：晋味美 沁州黄石碾小米 18...\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		净含量:&amp;nbsp;1800g\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装方式:&amp;nbsp;包装\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;晋味美\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		货号:&amp;nbsp;沁州黄石碾小米\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		规格:&amp;nbsp;1800g\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		售卖方式:&amp;nbsp;单品\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;中国大陆\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		省份:&amp;nbsp;山西省\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		城市:&amp;nbsp;长治市\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		特产品类:&amp;nbsp;沁州黄小米\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-26 19:12:02', '0', '0', '0', '', 'WSTShop 小米 晋味 山西特产', '1', '2016-12-26 19:12:02', '0', '0', '0', null, ''),
('52', '148275078680121', '148275078680121', '泰金香茉莉香米5KG 原粮进口国内包装 非东北米', 'upload/goods/2016-12/5860fc4af29d5.jpg', '48.90', '32.90', '120', '5681', '件', '', '1', '0', '1', '1', '0', '50_221', '221', '0', '&lt;h1 style=&quot;font-size:16px;font-weight:700;font-family:&#039;microsoft yahei&#039;;color:#000000;font-style:normal;text-align:start;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	泰金香茉莉香米5KG 原粮进口国内包装 非东北米\n&lt;/h1&gt;', '0', '2016-12-26 19:18:39', '0', '0', '0', 'upload/goods/2016-12/5860fc8af2ea2.jpg,upload/goods/2016-12/5860fc8b71379.jpg,upload/goods/2016-12/5860fc8bef1ac.jpg', 'WSTShop 泰金香 茉莉香米', '1', '2016-12-26 19:18:39', '0', '0', '0', null, ''),
('53', '148275111955769', '148275111955769', '甬上花 S-X04电热水龙头 即热式厨房宝快速热自来水加热器小厨宝', 'upload/goods/2016-12/5860fdf7007af.jpg', '498.00', '168.90', '30', '1156', '件', '', '1', '1', '1', '1', '1', '54_118', '118', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		证书编号：2015010706795639\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		证书状态：有效\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		申请人名称：宁波保税区滴答石电子商务有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		制造商名称：慈溪市滴答石电器有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：快热式热水器（电热水龙头)\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		3C产品型号：S-X01 , S-X02 , S-X03 , S-X04 3400W , D-C01 , D-C...\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：甬上花 S-X04\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		上市时间:&amp;nbsp;2014-5\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		净重:&amp;nbsp;1kg\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		加热功率:&amp;nbsp;3400W\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装尺寸:&amp;nbsp;456x95x297mm\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;甬上花\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		型号:&amp;nbsp;S-X04\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		堆码层数极限:&amp;nbsp;5层\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		尺寸:&amp;nbsp;160x240x390mm\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		毛重:&amp;nbsp;1.5kg\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		电线截面要求:&amp;nbsp;1.5平方mm\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		进水方式:&amp;nbsp;下进水\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		采购地:&amp;nbsp;中国大陆\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		颜色分类:&amp;nbsp;白色（双柄温显）&amp;nbsp;红色（双柄温显）&amp;nbsp;黑色（双柄温显）&amp;nbsp;香槟色（双柄温显）&amp;nbsp;银色（双柄温显）&amp;nbsp;金色&amp;nbsp;银灰色&amp;nbsp;银色(小弯)&amp;nbsp;香槟色(小弯)\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		款式:&amp;nbsp;双把单孔\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		龙头是否旋转:&amp;nbsp;可旋转\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-26 19:25:30', '1', '0', '0', 'upload/goods/2016-12/5860fe1d4cf42.jpg,upload/goods/2016-12/5860fe1dbb950.jpg,upload/goods/2016-12/5860fe1e2e70b.jpg', 'WSTShop 甬上花 电热水龙头 即热式厨房宝 自来水 加热器 小厨宝', '1', '2016-12-26 19:25:30', '0', '0', '0', null, ''),
('54', '148275177472643', '148275177472643', '美的电磁炉Midea/美的 WK2102电磁炉特价家用触摸屏电池炉灶正品', 'upload/goods/2016-12/5860ff64f2859.jpg', '399.00', '199.00', '50', '2654', '件', '', '1', '1', '1', '1', '1', '54_119', '119', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		证书编号：2014010711675141\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		证书状态：有效\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		申请人名称：广东美的生活电器制造有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		制造商名称：广东美的生活电器制造有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：多功能电磁炉\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		3C产品型号：C22-RT2240,C22-RT2241,C22-WK2202,C22-SN2205,2200W;...\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：Midea/美的 WK2102\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		电磁炉品牌:&amp;nbsp;Midea/美的\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		型号:&amp;nbsp;WK2102\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		货号:&amp;nbsp;WK2102T\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		颜色分类:&amp;nbsp;黑色\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		电磁炉炉头:&amp;nbsp;1个\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		功能:&amp;nbsp;爆炒&amp;nbsp;炒菜&amp;nbsp;炖奶&amp;nbsp;蒸煮&amp;nbsp;煮粥&amp;nbsp;煲汤&amp;nbsp;火锅&amp;nbsp;烧水&amp;nbsp;煎炸&amp;nbsp;定时\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		电磁炉面板类型:&amp;nbsp;黑色微晶面板\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		操作方式:&amp;nbsp;触摸式\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		能效等级:&amp;nbsp;三级\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-26 19:31:14', '0', '0', '0', 'upload/goods/2016-12/5860ff7f15644.jpg,upload/goods/2016-12/5860ff7fd050b.jpg,upload/goods/2016-12/5860ff80563f5.jpg', 'WSTShop 美的 电磁炉', '1', '2016-12-26 19:31:14', '0', '0', '0', null, ''),
('55', '148275357865177', '148275357865177', '云南蒙自甜枇杷 新鲜水果 枇杷果琵琶果3斤', 'upload/goods/2016-12/58610683889fb.jpg', '109.00', '81.90', '20', '1451', '件', '', '1', '1', '1', '0', '1', '47_71', '71', '12', '&lt;p class=&quot;attr-list-hd tm-clear&quot; style=&quot;color:#999999;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&lt;em&gt;产品参数：&lt;/em&gt;\n&lt;/p&gt;\n&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：蒙自龙泽堂商贸责任有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：蒙自龙泽堂商贸责任有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：13097424253\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		配料表：蒙自枇杷\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		储藏方法：低温保鲜\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：30 天\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		食品添加剂：无\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		净含量:&amp;nbsp;1500g\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装方式:&amp;nbsp;散装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		同城服务:&amp;nbsp;同城24小时物流送货上门\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;唯享\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		售卖方式:&amp;nbsp;单品\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		热卖时间:&amp;nbsp;1月&amp;nbsp;2月&amp;nbsp;3月&amp;nbsp;4月&amp;nbsp;11月&amp;nbsp;12月\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;中国大陆\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		省份:&amp;nbsp;云南省\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		城市:&amp;nbsp;红河哈尼族彝族自治州\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		套餐份量:&amp;nbsp;3人份\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		套餐周期:&amp;nbsp;1周\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		配送频次:&amp;nbsp;1周1次\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		特产品类:&amp;nbsp;蒙自枇杷\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		净含量:&amp;nbsp;0.5kg(含）-2.5kg(不含)\n	&lt;/li&gt;\n&lt;/ul&gt;', '1', '2016-12-26 20:02:28', '0', '0', '0', 'upload/goods/2016-12/58610693cd5d6.jpg,upload/goods/2016-12/586106944f7b6.jpg', 'WSTSop 枇杷', '1', '2016-12-26 20:01:25', '0', '0', '0', null, ''),
('56', '148275408556768', '148275408556768', '海南三亚新鲜水果仙人掌果仙人果2斤/份', 'upload/goods/2016-12/58610881b4fa2.jpg', '40.90', '32.50', '10', '255', '件', '', '1', '0', '1', '0', '0', '47_71', '71', '13', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：百盛果业有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：海南省三亚市河东区\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：13307608720\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：30 天\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		净含量:&amp;nbsp;1000g\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装方式:&amp;nbsp;散装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		同城服务:&amp;nbsp;同城24小时卖家送货上门\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;益优果\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		系列:&amp;nbsp;新鲜水果 仙人掌果\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		规格:&amp;nbsp;2斤\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		水果种类:&amp;nbsp;其他\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		热卖时间:&amp;nbsp;1月&amp;nbsp;2月&amp;nbsp;3月&amp;nbsp;4月&amp;nbsp;5月&amp;nbsp;6月&amp;nbsp;7月&amp;nbsp;8月&amp;nbsp;9月&amp;nbsp;10月&amp;nbsp;11月&amp;nbsp;12月\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;中国大陆\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		省份:&amp;nbsp;海南省\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		城市:&amp;nbsp;三亚市\n	&lt;/li&gt;\n&lt;/ul&gt;', '1', '2016-12-26 20:09:39', '0', '0', '0', '', 'WTShop 仙人果', '1', '2016-12-26 20:09:39', '0', '0', '0', null, ''),
('57', '148275461512228', '148275461512228', '红酒整箱 法国葡萄酒 进口红酒 罗莎玛索红葡萄酒6支', 'upload/goods/2016-12/58610aa0f3ca3.jpg', '235.00', '219.90', '10', '1560', '件', '', '1', '0', '1', '0', '0', '49_78', '78', '39', '&lt;img src=&quot;/upload/image/2016-12/58610a9912b2b.jpg&quot; alt=&quot;&quot; /&gt;', '0', '2016-12-26 20:18:42', '0', '0', '0', '', 'WSTShop 红酒', '1', '2016-12-26 20:18:42', '0', '0', '0', null, ''),
('58', '148275472351428', '148275472351428', '山西杏花村52度汾酒475mlx6原酒 整箱装白酒礼盒装国产白酒', 'upload/goods/2016-12/58610b2a1ac7d.jpg', '400.90', '389.00', '20', '1236', '件', '', '1', '0', '1', '0', '0', '49_78', '78', '32', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		生产许可证编号：QS1400 1501 0676\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：山西杏花村汾酒集团有限责任公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：1、山西省吕梁汾阳市杏花村；2、山西省吕梁孝义市振兴街6号\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：400-668-9999\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		配料表：水、高粱、大麦、豌豆\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		储藏方法：避光、防潮、常温\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：9999 天\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;汾酒\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		系列:&amp;nbsp;原酒套装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;中国大陆地区\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		省份:&amp;nbsp;山西\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		香型:&amp;nbsp;清香型\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		酒精纯度:&amp;nbsp;高度白酒（50%以上）\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		适用场景:&amp;nbsp;礼节拜访区\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装方式:&amp;nbsp;包装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装种类:&amp;nbsp;礼盒装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		净含量:&amp;nbsp;475mlx6瓶\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		度数:&amp;nbsp;52%Vol.\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-26 20:20:59', '0', '0', '0', '', 'WSTShop 汾酒', '1', '2016-12-26 20:20:59', '0', '0', '0', null, ''),
('59', '148275486048477', '148275486048477', '江小白北上广同款小酒高粱酒粮食酒白酒清香型送礼100ml*6瓶箱装', 'upload/goods/2016-12/58610b9b9cd5d.jpg', '158.50', '99.00', '20', '1540', '件', '', '1', '0', '1', '0', '0', '49_78', '78', '34', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		生产许可证编号：QS5081 1501 7899\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品标准号：GB/T 26761-2011（优级）\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：重庆江记酒庄有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：重庆市江津区白沙工业园兴盛路21号\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：400-058-9797\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		配料表：水，高粱\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		储藏方法：常温保存\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：9999 天\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		食品添加剂：无\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		体积(ml):&amp;nbsp;600\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;江小白\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		系列:&amp;nbsp;六瓶套装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		年份:&amp;nbsp;1年及以下\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		是否为有机食品:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;中国大陆地区\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		省份:&amp;nbsp;重庆\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		香型:&amp;nbsp;清香型\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		酒精纯度:&amp;nbsp;中度白酒（40%-50%）\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		适用场景:&amp;nbsp;团圆小酌区\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装方式:&amp;nbsp;包装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装种类:&amp;nbsp;礼盒装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		净含量:&amp;nbsp;100mlx6\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		度数:&amp;nbsp;45%Vol.\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-26 20:22:53', '0', '0', '0', '', 'WSTShop 白酒', '1', '2016-12-26 20:22:53', '0', '0', '0', null, ''),
('60', '148275497372069', '148275497372069', '酒仙网52度泸州老窖三人炫1000ml双瓶+三人炫100ml浓香高度白酒', 'upload/goods/2016-12/58610c36b4354.jpg', '226.50', '250.90', '50', '1580', '件', '', '1', '0', '1', '0', '0', '49_78', '78', '36', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		生产许可证编号：QS5100 1501 0375\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：泸州老窖股份有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：1.四川省泸州市国窖广场2.四川省泸州市龙马潭区罗汉镇罗汉场泸州老窖基地3.四川省泸州市龙马潭区安宁\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：4006179999\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：18620 天\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;泸州老窖\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品名:&amp;nbsp;三人炫双瓶套装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;中国大陆地区\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		省份:&amp;nbsp;四川\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		香型:&amp;nbsp;浓香型\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		酒精纯度:&amp;nbsp;高度白酒（50%以上）\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装方式:&amp;nbsp;包装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装种类:&amp;nbsp;瓶装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		净含量:&amp;nbsp;1LX2\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		度数:&amp;nbsp;52%Vol.\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-26 20:25:29', '0', '0', '0', '', 'WSTShop  白酒', '1', '2016-12-26 20:25:29', '0', '0', '0', null, ''),
('61', '148275530522701', '148275530522701', '古井贡酒 老玻贡50度750ml*6瓶 白酒整箱特价 浓香型 古井贡', 'upload/goods/2016-12/58610d33569ef.jpg', '209.50', '200.50', '50', '2650', '件', '', '1', '0', '1', '0', '0', '49_78', '78', '33', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		生产许可证编号：QS3400 1501 0477\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：安徽古井贡酒股份有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：安徽省亳州市古井镇\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：4008877519\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：3650 天\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;古井贡\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品名:&amp;nbsp;古井贡酒 50度老玻贡750ml 6瓶套装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;中国大陆地区\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		省份:&amp;nbsp;安徽\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		香型:&amp;nbsp;浓香型\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		酒精纯度:&amp;nbsp;中度白酒（40%-50%）\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装方式:&amp;nbsp;包装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装种类:&amp;nbsp;箱装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		净含量:&amp;nbsp;750mlX6瓶\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		度数:&amp;nbsp;50%Vol.\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-26 20:29:41', '0', '0', '0', '', 'WSTShop 古井贡酒', '1', '2016-12-26 20:29:41', '0', '0', '0', null, ''),
('62', '148275538240181', '148275538240181', '拉菲庄园2009红酒整箱 6只装红酒特价干红葡萄酒整箱 送醒酒器', 'upload/goods/2016-12/58610db403e75.jpg', '305.50', '298.50', '100', '2250', '件', '', '1', '0', '1', '0', '0', '49_78', '78', '43', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		生产许可证编号：QS3201 1502 0364\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：南京华夏葡萄酿酒有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：南京市江宁区汤山工业集中区汤山片区\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：4000909030\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		配料表：葡萄汁、二氧化硫\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		储藏方法：贮存于5-25°避光阴凉处，卧放或倒放为宜。\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：3650 天\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		食品添加剂：二氧化硫\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		净含量:&amp;nbsp;4500ml\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;LAFEI MANOR/拉菲庄园\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		系列:&amp;nbsp;012\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		套装规格:&amp;nbsp;整箱\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		年份:&amp;nbsp;3年(含)-8年(含)\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		葡萄酒种类:&amp;nbsp;红葡萄酒\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		葡萄酒等级:&amp;nbsp;中国大陆地区\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		中国产区:&amp;nbsp;其他\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		葡萄种类:&amp;nbsp;赤霞珠&amp;nbsp;美乐/梅洛\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		口味:&amp;nbsp;干葡萄酒 （含糖量小于4克/升）\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		饮酒场合:&amp;nbsp;商务宴请区\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;中国大陆地区\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		省份:&amp;nbsp;其他\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装方式:&amp;nbsp;包装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		搭配菜肴:&amp;nbsp;红肉/野味/陈乳酪\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		醒酒时间:&amp;nbsp;15分钟(含)-30分钟(含)\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		香味:&amp;nbsp;水果香\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-26 20:31:50', '0', '0', '0', '', 'WSTShop 红酒', '1', '2016-12-26 20:31:50', '0', '0', '0', null, ''),
('63', '148275551065673', '148275551065673', '奥希耶徽纹进口干红葡萄酒 6支装整箱 原瓶正品', 'upload/goods/2016-12/58610e2c99ceb.jpg', '3585.00', '799.00', '100', '2560', '件', '', '1', '0', '1', '0', '0', '49_78', '78', '33', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：拉菲罗斯柴尔德集团\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：拉菲罗斯柴尔德集团\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：400-883-2299\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：5475 天\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;Lafite/拉菲\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		系列:&amp;nbsp;奥西耶徽纹六支装套装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		套装规格:&amp;nbsp;6支装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		葡萄酒种类:&amp;nbsp;红葡萄酒\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		葡萄酒等级:&amp;nbsp;法国产区\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		法国产区:&amp;nbsp;其他\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		口味:&amp;nbsp;干葡萄酒 （含糖量小于4克/升）\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		饮酒场合:&amp;nbsp;商务宴请区\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;法国\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		分级:&amp;nbsp;高级aoc\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装方式:&amp;nbsp;包装\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-26 20:33:50', '0', '0', '0', '', 'WSTShop 葡萄酒', '1', '2016-12-26 20:33:50', '0', '0', '0', null, ''),
('64', '148275563080203', '148275563080203', '水井坊浓香型白酒52度井台装500ml高档名酒中国名酒礼盒包邮', 'upload/goods/2016-12/58610ea4eedbf.jpg', '596.00', '499.00', '10', '600', '件', '', '1', '0', '1', '0', '0', '49_78', '78', '33', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		生产许可证编号：QS5100 1501 0388\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：四川水井坊股份有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：四川省成都市金牛区全兴路9号、四川省成都市锦江区水井街19号\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：028-87502070\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：3650 天\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：水井坊 井台瓶 500ml 52度\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		体积(ml):&amp;nbsp;500\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;水井坊\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品名:&amp;nbsp;井台瓶\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;中国大陆地区\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		省份:&amp;nbsp;四川\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		香型:&amp;nbsp;浓香型\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		酒精纯度:&amp;nbsp;高度白酒（50%以上）\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装方式:&amp;nbsp;包装\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-26 20:35:50', '0', '0', '0', '', 'WSTShop 水井坊 白酒', '1', '2016-12-26 20:35:50', '0', '0', '0', null, ''),
('65', '148275575099417', '148275575099417', '资生堂Fino浸透美容液发膜230gX2护理倒模改善毛躁护发柔顺组合装', 'upload/goods/2016-12/58610f919185f.jpg', '139.00', '118.00', '100', '5451', '件', '', '1', '0', '1', '0', '0', '51_165', '165', '0', '&lt;ul class=&quot;J_subAttrList&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品:&amp;nbsp;发膜&amp;nbsp;\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;Shiseido/资生堂&amp;nbsp;\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		型号:&amp;nbsp;Fino高效渗透护发膜&amp;nbsp;\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		护发用品:&amp;nbsp;发膜&amp;nbsp;\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		是否量贩装:&amp;nbsp;否&amp;nbsp;\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		功能:&amp;nbsp;滋养修复&amp;nbsp;改善毛躁&amp;nbsp;\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		净含量:&amp;nbsp;230g&amp;nbsp;\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		适用对象:&amp;nbsp;女士&amp;nbsp;\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		规格类型:&amp;nbsp;常规单品&amp;nbsp;\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;日本&amp;nbsp;\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		适用发质:&amp;nbsp;所有发质 &lt;br /&gt;\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-26 20:39:46', '0', '0', '0', '', 'WSTShop 美容护理', '1', '2016-12-26 20:39:46', '0', '0', '0', null, ''),
('66', '148275598728367', '148275598728367', '大宝SOD蜜100ml+美容洗面奶220ml护肤套装补水保湿', 'upload/goods/2016-12/58611037bcc88.jpg', '30.50', '21.90', '50', '1520', '件', '', '1', '0', '1', '0', '0', '51_165', '165', '0', '&lt;span style=&quot;color:#404040;font-family:tahoma, arial, 宋体, sans-serif;font-size:14px;font-style:normal;font-weight:normal;line-height:19.6px;background-color:#FFFFFF;&quot;&gt;规格：大宝SOD蜜100ML+美容洗面奶220ML&lt;/span&gt;', '0', '2016-12-26 20:42:33', '0', '0', '0', '', 'WSTShop 大宝 护肤品', '1', '2016-12-26 20:42:33', '0', '0', '0', null, ''),
('67', '148275615449217', '148275615449217', '韩后水动力化妆品套装面部护理 美容护肤品女爽肤水 秋冬补水保湿', 'upload/goods/2016-12/586110b01e75b.jpg', '169.00', '159.00', '100', '1489', '件', '', '1', '0', '0', '0', '0', '51_165', '165', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：Hanhoo/韩后 水动力澎湃保...\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		上市时间:&amp;nbsp;2014年\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		月份:&amp;nbsp;6月\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		限期使用日期范围:&amp;nbsp;2018-10-02至2019-10-01\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		颜色分类:&amp;nbsp;水动力补水5件套\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		功效:&amp;nbsp;补水&amp;nbsp;保湿&amp;nbsp;控油&amp;nbsp;滋润&amp;nbsp;舒缓肌肤\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		规格类型:&amp;nbsp;正常规格\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;Hanhoo/韩后\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		面部护理套装单品:&amp;nbsp;水动力澎湃保湿精灵礼盒\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		适合肤质:&amp;nbsp;任何肤质\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;中国\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期:&amp;nbsp;3年\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-26 20:44:34', '0', '0', '0', '', 'WSTShop 韩后', '1', '2016-12-26 20:44:34', '0', '0', '0', null, ''),
('68', '148275627460929', '148275627460929', '翰皇鞋油兽皮大王油蜡皮鞋油护理膏油皮膏美容滋养无色真皮保养油', 'upload/goods/2016-12/586111361bb12.jpg', '30.90', '25.80', '50', '1542', '件', '', '1', '0', '1', '0', '0', '51_165', '165', '0', '&lt;p class=&quot;attr-list-hd tm-clear&quot; style=&quot;color:#999999;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&lt;em&gt;产品参数：&lt;/em&gt;\n&lt;/p&gt;\n&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		体积(ml):&amp;nbsp;90\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;兽皮大王\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		型号:&amp;nbsp;油皮美容护理膏\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		颜色分类:&amp;nbsp;无色油皮美容护理膏(无色适合\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-26 20:46:48', '0', '0', '0', '', 'WSTShop 保养油', '1', '2016-12-26 20:46:48', '0', '0', '0', null, ''),
('69', '148275640858234', '148275640858234', '京润珍珠套装正品美白补水保湿滋润美容护肤品女化妆品官方旗舰店', 'upload/goods/2016-12/586111c83b59e.png', '256.90', '199.00', '100', '2365', '件', '', '1', '0', '1', '0', '0', '51_165', '165', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		上市时间:&amp;nbsp;2011年\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		月份:&amp;nbsp;1月\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		化妆品保质期:&amp;nbsp;4年\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		限期使用日期范围:&amp;nbsp;2016-06-01至2019-10-31\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		颜色分类:&amp;nbsp;珍珠补水保湿滋养3件套【洗面奶+珍珠水+保湿乳】&amp;nbsp;珍珠补水保湿滋养4件套【洗面奶+珍珠水+保湿乳+保湿霜】&amp;nbsp;珍珠补水保湿滋养5件套【洗面奶+珍珠水+保湿乳+保湿霜+眼精华】&amp;nbsp;心动组合【珍珠水+保湿乳+眼精华+洗面奶15g+保湿霜10g】\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		功效:&amp;nbsp;补水&amp;nbsp;保湿&amp;nbsp;控油&amp;nbsp;去角质&amp;nbsp;收缩毛孔&amp;nbsp;抗皱&amp;nbsp;提拉紧致&amp;nbsp;提亮肤色&amp;nbsp;滋润&amp;nbsp;遮瑕&amp;nbsp;其他/other&amp;nbsp;去黑头&amp;nbsp;清洁毛孔&amp;nbsp;嫩肤&amp;nbsp;深层清洁&amp;nbsp;去干纹&amp;nbsp;收缩毛孔舒缓肌肤\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		规格类型:&amp;nbsp;正常规格\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;gN Pearl/京润珍珠\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		面部护理套装:&amp;nbsp;珍珠靓采补水保湿滋养套装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		适合肤质:&amp;nbsp;任何肤质\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;中国\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期:&amp;nbsp;4年\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-26 20:49:15', '0', '0', '0', '', 'WSTShop 化妆品', '1', '2016-12-26 20:49:15', '0', '0', '0', null, ''),
('70', '148280171240909', '148280171240909', '半亩花田玫瑰蜜糖手膜 手部护理嫩白保湿补水 美容防裂凝胶手套', 'upload/goods/2016-12/5861c29e5d3ed.jpg', '98.00', '59.00', '30', '500', '件', '', '1', '0', '1', '0', '0', '51_165', '165', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：Little Dream Garden/半亩...\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		上市时间:&amp;nbsp;2015年\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		月份:&amp;nbsp;8月\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		规格类型:&amp;nbsp;正常规格\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		功效:&amp;nbsp;保湿&amp;nbsp;滋润&amp;nbsp;补水\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		化妆品净含量:&amp;nbsp;180g\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;Little Dream Garden/半亩花田\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		手部保养单品:&amp;nbsp;浪漫玫瑰蜜糖手膜\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准文号:&amp;nbsp;(2013)卫妆准字12-XK-010\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-27 09:23:45', '0', '0', '0', '', 'WSTShop 半亩花田 美容护理', '1', '2016-12-27 09:23:45', '0', '0', '0', null, ''),
('71', '148280182544466', '148280182544466', '红色小象婴儿沐浴露洗发二合一 无泪新生儿童宝宝洗发沐浴露2合1', 'upload/goods/2016-12/5861c32c4b80a.jpg', '55.00', '35.00', '100', '5620', '件', '', '1', '0', '1', '0', '0', '51_164', '164', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;红色小象\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		系列(型号):&amp;nbsp;婴儿无硅油洗发沐浴露\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		容量:&amp;nbsp;99ml\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		百货品类:&amp;nbsp;沐浴露\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		适用年龄:&amp;nbsp;新生&amp;nbsp;1个月&amp;nbsp;2个月&amp;nbsp;3个月&amp;nbsp;4个月&amp;nbsp;5个月&amp;nbsp;6个月&amp;nbsp;7个月&amp;nbsp;8个月&amp;nbsp;9个月&amp;nbsp;10个月&amp;nbsp;11个月&amp;nbsp;12个月\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;中国大陆\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-27 09:26:06', '0', '0', '0', '', 'WSTShop 洗发露 沐浴露', '1', '2016-12-27 09:26:06', '0', '0', '0', null, ''),
('72', '148280196649684', '148280196649684', '韩国进口所望牛奶沐浴露沐浴液保湿滋润女持久留香男美肌沐浴正品', 'upload/goods/2016-12/5861c39d950b4.jpg', '299.00', '58.00', '50', '2561', '件', '', '1', '0', '1', '0', '0', '51_164', '164', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：SOMANG/所望 牛奶沐浴露\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;SOMANG/所望\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		型号:&amp;nbsp;牛奶沐浴露\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		是否量贩装:&amp;nbsp;是\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		功能:&amp;nbsp;补水&amp;nbsp;深层清洁&amp;nbsp;清爽&amp;nbsp;滋润保湿&amp;nbsp;清洁&amp;nbsp;清凉舒爽\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		净含量:&amp;nbsp;750mL\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		适用对象:&amp;nbsp;通用\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		规格类型:&amp;nbsp;常规单品\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期:&amp;nbsp;3年\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;韩国\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-27 09:27:59', '0', '0', '0', '', 'WSTShop 沐浴露', '1', '2016-12-27 09:27:59', '0', '0', '0', null, ''),
('73', '148280156349709', '148280156349709', '【三只松鼠_开心果225gx2袋】休闲零食坚果炒货干果原味无漂白', 'upload/goods/2016-12/5861c3744c2d7.jpg', '119.00', '52.90', '100', '9998', '包', '满69元 ,包邮', '1', '0', '1', '0', '0', '52_189', '189', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		生产许可证编号：SC11834020305037\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品标准号：GB/T22165\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：三只松鼠股份有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：安徽省芜湖市弋江区芜湖高新技术产业开发区久盛路8号;安徽省芜湖市弋江区高新开发区南区龙华厂房\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：400-800-4900\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		配料表：开心果、食用盐、白砂糖、味精、葡萄糖、麦芽糖、食品添加剂、食用香精香料\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		储藏方法：请置于阴凉干燥处\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：240 天\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		食品添加剂：安赛蜜、甜蜜素、阿斯巴甜（含苯丙氨酸）、特丁基对苯二酚\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		净含量:&amp;nbsp;450g\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装方式:&amp;nbsp;包装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装种类:&amp;nbsp;袋装\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;Three Squirrels/三只松鼠\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		系列:&amp;nbsp;开心果225gX2组合\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;中国大陆\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		省份:&amp;nbsp;浙江省\n	&lt;/li&gt;\n&lt;/ul&gt;', '1', '2016-12-27 10:21:02', '2', '1', '0', 'upload/goods/2016-12/5861c375ec691.jpg,upload/goods/2016-12/5861c39167274.jpg,upload/goods/2016-12/5861c38caf96a.jpg,upload/goods/2016-12/5861c38dce1dd.jpg', '三只松鼠', '1', '2016-12-27 09:29:23', '0', '0', '0', null, '满69元 ,包邮'),
('74', '148280208011067', '148280208011067', '正品COCOVEL沐浴露 香水味持久留香男士女士非美白补水保湿家庭装', 'upload/goods/2016-12/5861c405967ef.jpg', '98.00', '29.00', '100', '2510', '件', '', '1', '0', '1', '0', '0', '51_164', '164', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：COCOVEL/蔻露薇 水润蛋白...\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;COCOVEL/蔻露薇\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		型号:&amp;nbsp;水润蛋白香芬沐浴露\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		是否量贩装:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		适合肤质:&amp;nbsp;任何肤质\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		功能:&amp;nbsp;滋润保湿&amp;nbsp;控油&amp;nbsp;清洁&amp;nbsp;清凉舒爽\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		净含量:&amp;nbsp;1000ml&amp;nbsp;750mL\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		适用对象:&amp;nbsp;通用\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		规格类型:&amp;nbsp;常规单品\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期:&amp;nbsp;3年\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-27 09:29:43', '0', '0', '0', '', 'WSTShop 沐浴露', '1', '2016-12-27 09:29:43', '0', '0', '0', null, ''),
('75', '148280218349154', '148280218349154', '【旗舰新品】OPPO R9S全网通前后1600万指纹识别4G拍照手机r9s', 'upload/goods/2016-12/5861c49e5ae48.jpg', '2999.00', '2799.00', '50', '2540', '件', '', '1', '0', '1', '0', '0', '334_348', '348', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		证书编号：2016011606905621\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		证书状态：有效\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		申请人名称：广东欧珀移动通信有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		制造商名称：广东欧珀移动通信有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：TD-LTE数字移动电话机\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		3C产品型号：OPPO R9s\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：OPPO R9S\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		CPU型号:&amp;nbsp;MSM8953\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		OPPO型号:&amp;nbsp;R9S\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		机身颜色:&amp;nbsp;金色&amp;nbsp;玫瑰金&amp;nbsp;黑色\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		运行内存RAM:&amp;nbsp;4GB\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		存储容量:&amp;nbsp;64GB\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		网络模式:&amp;nbsp;双卡双待\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		电池容量:&amp;nbsp;3010mAh\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-27 09:32:16', '0', '0', '0', '', 'WSTShop  OPPO', '1', '2016-12-27 09:32:16', '0', '0', '0', null, ''),
('76', '148280233673182', '148280233673182', 'Xiaomi/小米 小米Max 国产超薄6.44英寸大屏指纹识别解锁智能手机', 'upload/goods/2016-12/5861c5365c515.jpg', '1299.00', '1199.00', '30', '2560', '件', '', '1', '0', '1', '0', '0', '334_348', '348', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		证书编号：2015011606811643\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		证书状态：有效\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		申请人名称：小米通讯技术有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		制造商名称：小米通讯技术有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：TD-LTE数字移动电话机\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		3C产品型号：2014816(电源适配器：MDY-08-EG 输出：5VDC 1A)\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：Xiaomi/小米 小米Max\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		CPU型号:&amp;nbsp;骁龙650\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		型号:&amp;nbsp;小米Max\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		机身颜色:&amp;nbsp;银色&amp;nbsp;浅灰&amp;nbsp;金色\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		运行内存RAM:&amp;nbsp;3GB\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		存储容量:&amp;nbsp;32GB\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		网络模式:&amp;nbsp;双卡多模\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		电池容量:&amp;nbsp;4760mAh\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-27 09:34:48', '0', '0', '0', '', 'WSTShop 小米 手机', '1', '2016-12-27 09:34:48', '0', '0', '0', null, ''),
('77', '148280250491017', '148280250491017', 'Apple/苹果 iPhone 6 Plus 正品国行4G手机未激活', 'upload/goods/2016-12/5861c5b67fd9f.jpg', '3758.00', '3658.00', '20', '1520', '件', '', '1', '0', '1', '0', '0', '334_348', '348', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		证书编号：2014011606717029\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		证书状态：有效\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		申请人名称：美国苹果公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		制造商名称：美国苹果公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：TD-LTE 数字移动电话机\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		3C产品型号：A1524（电源适配器：A1443,输出:5.0VDC,1.0A）（电源适配器为可选部件）\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：Apple/苹果 iPhone 6 Plu...\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		Apple型号:&amp;nbsp;iPhone 6 Plus\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		机身颜色:&amp;nbsp;深空灰色&amp;nbsp;金色&amp;nbsp;银色\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		运行内存RAM:&amp;nbsp;1GB\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		存储容量:&amp;nbsp;16GB&amp;nbsp;64GB\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		网络模式:&amp;nbsp;单卡多模\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		电池容量:&amp;nbsp;2915mAh\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-27 09:36:57', '0', '0', '0', '', 'WSTShop 手机 苹果', '1', '2016-12-27 09:36:57', '0', '0', '0', null, ''),
('78', '148280217033484', '148280217033484', '【三只松鼠_猪肉猪肉脯210g】休闲食品小吃零食靖江特产猪肉干', 'upload/goods/2016-12/5861c65cf009b.jpg', '40.00', '19.90', '100', '9998', '包', '满69元 ,包邮', '1', '0', '1', '0', '0', '52_190', '190', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		生产许可证编号：SC10432128200482\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品标准号：SB/T10283\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：靖江喜友食品有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：江苏省泰州市靖江市靖广路668号\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：400-800-4900\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		配料表：猪后腿瘦肉，白砂糖，鸡蛋，鱼露，味精，食用盐、香辛料，食品添加剂（D-异抗坏血酸钠，红曲红）\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		储藏方法：请置于阴凉干燥处，避免阳光直射\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：180 天\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		食品添加剂：D-异抗坏血酸钠，红曲红\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		净含量:&amp;nbsp;210g\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		包装方式:&amp;nbsp;包装\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;Three Squirrels/三只松鼠\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		系列:&amp;nbsp;【三只松鼠】猪肉猪肉脯210g 袋装\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		肉类产品:&amp;nbsp;猪肉脯\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		口味:&amp;nbsp;其他口味\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;中国大陆\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		省份:&amp;nbsp;江苏省\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		城市:&amp;nbsp;泰州市\n	&lt;/li&gt;\n&lt;/ul&gt;\n&lt;br /&gt;', '1', '2016-12-27 10:20:36', '1', '1', '0', 'upload/goods/2016-12/5861c592db11f.jpg,upload/goods/2016-12/5861c5904645b.jpg,upload/goods/2016-12/5861c58f871d8.jpg,upload/goods/2016-12/5861c59146482.jpg,upload/goods/2016-12/5861c592e2b32.jpg', '三只松鼠、猪肉脯', '1', '2016-12-27 09:38:44', '0', '0', '0', null, '满69元 ,包邮'),
('79', '148280261824261', '148280261824261', 'Huawei/华为 Mate 9全网通mate9手机64G高配', 'upload/goods/2016-12/5861c64f0ed72.jpg', '3599.00', '3399.00', '50', '2150', '件', '', '1', '0', '1', '0', '0', '334_348', '348', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		证书编号：2015011606824295\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		证书状态：有效\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：TD-LTE数字移动电话机\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：Huawei/华为 Mate 9\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		华为型号:&amp;nbsp;Mate 9\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		机身颜色:&amp;nbsp;月光银&amp;nbsp;苍穹灰&amp;nbsp;金色&amp;nbsp;香槟金&amp;nbsp;摩卡金&amp;nbsp;陶瓷白&amp;nbsp;黑色\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		运行内存RAM:&amp;nbsp;4GB\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		存储容量:&amp;nbsp;32GB&amp;nbsp;64GB\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		网络模式:&amp;nbsp;双卡双待单通\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		电池容量:&amp;nbsp;4000mAh\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-27 09:39:29', '0', '0', '0', '', 'WSTShop 手机  华为', '1', '2016-12-27 09:39:29', '0', '0', '0', null, ''),
('80', '148280276931093', '148280276931093', 'Huawei/华为 Mate 9 Pro 4GB+64GB全网通手机mate9', 'upload/goods/2016-12/5861c6ba1b49b.jpg', '5288.00', '5188.00', '20', '1000', '件', '', '1', '0', '1', '0', '0', '334_348', '348', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		证书编号：2016011606916333\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		证书状态：有效\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		申请人名称：华为技术有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		制造商名称：华为技术有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：TD-LTE数字移动电话机\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		3C产品型号：LON-AL00\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：Huawei/华为 Mate 9 Pro ...\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		华为型号:&amp;nbsp;Mate 9 Pro 4GB+64GB\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		机身颜色:&amp;nbsp;琥珀金&amp;nbsp;银钻灰&amp;nbsp;玫瑰金\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		运行内存RAM:&amp;nbsp;4GB\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		存储容量:&amp;nbsp;64GB\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		网络模式:&amp;nbsp;双卡双待单通\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		电池容量:&amp;nbsp;4000mAh\n	&lt;/li&gt;\n&lt;/ul&gt;', '0', '2016-12-27 09:41:26', '0', '0', '0', '', 'WSTShop 手机 华为', '1', '2016-12-27 09:41:26', '0', '0', '0', null, ''),
('81', '148280306147836', '148280306147836', 'TC蔓越莓曲奇饼干手提兔子铁礼盒手工休闲零食品80g', 'upload/goods/2016-12/5861c7d57d4ff.jpg', '36.00', '13.80', '100', '9998', '盒', '精美手提 兔子铁盒 独立包装 自吃送人 非常漂亮', '1', '0', '1', '0', '0', '52_193', '193', '0', '&lt;p style=&quot;color:#404040;font-family:tahoma, arial, 宋体, sans-serif;font-size:14px;font-style:normal;font-weight:normal;text-align:left;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	规格：80g/盒（铁罐兔子礼盒装）\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:tahoma, arial, 宋体, sans-serif;font-size:14px;font-style:normal;font-weight:normal;text-align:left;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	产地：上海\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:tahoma, arial, 宋体, sans-serif;font-size:14px;font-style:normal;font-weight:normal;text-align:left;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&lt;span style=&quot;font-size:14px;line-height:1.5;&quot;&gt;食用方法：开封即食&lt;/span&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:tahoma, arial, 宋体, sans-serif;font-size:14px;font-style:normal;font-weight:normal;text-align:left;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	贮存方法：&lt;span style=&quot;font-size:14px;line-height:1.5;&quot;&gt;请置于阴凉干燥处，常温保存。&lt;/span&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:tahoma, arial, 宋体, sans-serif;font-size:14px;font-style:normal;font-weight:normal;text-align:left;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	适用人群：常人\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/upload/image/2016-12/5861d08048dba.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/5861d098c04c0.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/5861d09fb74d6.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/5861d0a499c8b.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/upload/image/2016-12/5861d0a96c4a9.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '1', '2016-12-27 10:23:40', '1', '1', '0', 'upload/goods/2016-12/5861c861ddfef.jpg,upload/goods/2016-12/5861c862085fb.jpg,upload/goods/2016-12/5861c86286438.jpg,upload/goods/2016-12/5861c8627ad1b.jpg,upload/goods/2016-12/5861c86308622.jpg', '精美手提', '1', '2016-12-27 09:48:36', '0', '0', '0', null, '精美手提 兔子铁盒 独立包装 自吃送人 非常漂亮'),
('82', '148280372976960', '148280372976960', '雅培进口全安素成人乳清蛋白质粉中老年代餐粉营养品800g', 'upload/goods/2016-12/5861ca67d397b.jpg', '399.00', '288.00', '100', '9998', '罐', '下单即送毛巾 颜色随机 送完截止', '1', '0', '1', '0', '0', '53_141', '141', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：雅培贸易（上海）有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：上海市外高桥保税区美盛路56号4号楼109部\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：400-920-2660\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		配料表：详情请见配料表\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		储藏方法：阴凉、干燥\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：1080 天\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期:&amp;nbsp;36个月\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		生产企业:&amp;nbsp;雅培制药\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		计价单位:&amp;nbsp;罐\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		适用人群:&amp;nbsp;不限\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		适用性别:&amp;nbsp;通用\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;全安素\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		系列:&amp;nbsp;罐\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品剂型:&amp;nbsp;粉剂\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		规格（粒/袋/ml/g）:&amp;nbsp;800g\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产地:&amp;nbsp;荷兰\n	&lt;/li&gt;\n&lt;/ul&gt;\n&lt;br /&gt;', '1', '2016-12-27 10:15:49', '0', '1', '0', 'upload/goods/2016-12/5861ca72cfe18.jpg,upload/goods/2016-12/5861ca6fb5262.jpg,upload/goods/2016-12/5861ca70d77df.jpg,upload/goods/2016-12/5861ca7274532.jpg,upload/goods/2016-12/5861ca73ee68b.jpg', 'wstshop', '1', '2016-12-27 09:57:27', '0', '0', '0', null, '下单即送毛巾 颜色随机 送完截止'),
('83', '148280384853985', '148280384853985', '唐巢 破壁灵芝孢子粉胶囊 0.3g/粒*240粒', 'upload/goods/2016-12/5861cb54ca5eb.jpg', '298.00', '138.00', '100', '9996', '罐', '买2送60粒 孢子粉胶囊 保鲜颗粒 抢先加购', '1', '0', '1', '0', '0', '53_139', '139', '0', '&lt;p class=&quot;attr-list-hd tm-clear&quot; style=&quot;color:#999999;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&lt;em&gt;产品参数：&lt;/em&gt;\n&lt;/p&gt;\n&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：威海紫光科技园公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：威海经济区东安路\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：4008206118\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：730 天\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：唐巢 破壁灵芝孢子粉胶囊 ...\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品剂型:&amp;nbsp;胶囊\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保健食品产品名称:&amp;nbsp;破壁灵芝孢子粉胶囊\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;唐巢\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准文号:&amp;nbsp;国食健字G20120436\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		具体规格:&amp;nbsp;0.3G/粒*240粒\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		是否礼盒装:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		是否进口:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		食用方法和食用量:每日2次，每次2粒，口服\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		注意事项:本品不能代替药物\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准日期:2012-10-10\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		不适宜人群:少年儿童\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准变更日期:2013-10-14\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		有效期至:2017-10-09\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		贮藏方法:密封、阴凉、干燥处保存\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称:破壁灵芝孢子粉胶囊\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		功能:增强免疫力\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		申请人中文名称:威海紫光科技园有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		功效成分/标志性成分含量:每100g含：粗多糖 2.01g、灵芝三萜 1.71g\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		适宜人群:免疫力低下者\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		主要原料:破壁灵芝孢子粉、羧甲基纤维素钠\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准文号:国食健字G20120436\n	&lt;/li&gt;\n&lt;/ul&gt;\n&lt;br /&gt;', '1', '2016-12-27 10:15:21', '0', '1', '0', 'upload/goods/2016-12/5861cb6f48eb2.jpg,upload/goods/2016-12/5861cb6e9534b.jpg,upload/goods/2016-12/5861cb6ee921f.jpg,upload/goods/2016-12/5861cb6f22c52.jpg', 'wstshop', '1', '2016-12-27 10:02:01', '0', '0', '0', null, '买2送60粒 孢子粉胶囊 保鲜颗粒 抢先加购'),
('84', '148280412247227', '148280412247227', '脑白金胶囊、口服液 (胶囊)0.25克*20粒+(口服液)250毫升*2瓶', 'upload/goods/2016-12/5861cdc46871a.jpg', '299.00', '258.00', '100', '9998', '盒', '改善睡眠 润肠通便', '1', '0', '1', '0', '0', '53_138', '138', '0', '&lt;p class=&quot;attr-list-hd tm-clear&quot; style=&quot;color:#999999;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&lt;em&gt;产品参数：&lt;/em&gt;\n&lt;/p&gt;\n&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：无锡健特药业有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：无锡太湖国家旅游度假区南堤路88号\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：400-820-6020\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：540 天\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：脑白金胶囊、口服液 (胶囊...\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品剂型:&amp;nbsp;口服液\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保健食品产品名称:&amp;nbsp;脑白金胶囊、口服液(原名：脑白金)\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;脑白金\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准文号:&amp;nbsp;卫食健字(1997)第723号\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		具体规格:&amp;nbsp;(胶囊)0.25克*20粒+(口服液)250毫升*2瓶\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		是否礼盒装:&amp;nbsp;是\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		是否进口:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称:脑白金胶囊、口服液(原名：脑白金)\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		功能:改善睡眠、润肠通便\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准日期:1997-12-12\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		申请人中文名称:珠海康奇有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准文号:卫食健字(1997)第723号\n	&lt;/li&gt;\n&lt;/ul&gt;\n&lt;br /&gt;', '1', '2016-12-27 10:14:55', '0', '1', '0', 'upload/goods/2016-12/5861cdce3e560.jpg,upload/goods/2016-12/5861cdcf9d004.jpg,upload/goods/2016-12/5861cdce3e930.jpg,upload/goods/2016-12/5861cdcf389f8.jpg', 'wstshop', '1', '2016-12-27 10:13:37', '0', '0', '0', null, '改善睡眠 润肠通便'),
('85', '148280508500704', '148280508500704', 'Dr．Herbs/禾博士 B族维生素片 0.55g/片*100片', 'upload/goods/2016-12/5861cf94d2203.jpg', '128.00', '39.00', '100', '998', '罐', '买2送2维C 高含量B族 复合维生素B', '1', '0', '1', '0', '0', '53_139', '139', '0', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;text-indent:0px;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;font-size:12px;font-style:normal;font-weight:normal;text-align:start;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂名：仙乐健康科技股份有限公司\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂址：汕头市泰山路83号\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		厂家联系方式：400-616-5176\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保质期：730 天\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称：Dr．Herbs/禾博士 B族维生...\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品剂型:&amp;nbsp;片剂\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		保健食品产品名称:&amp;nbsp;B族维生素片\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		品牌:&amp;nbsp;Dr．Herbs/禾博士\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准文号:&amp;nbsp;国食健字G20100019\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		具体规格:&amp;nbsp;0.55g/片*100片\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		是否礼盒装:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		是否进口:&amp;nbsp;否\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		产品名称:B族维生素片\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		功能:补充多种B族维生素\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准日期:2016-06-24\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		功效成分/标志性成分含量:每片含：维生素B1 10mg、维生素B2 10mg、维生素B6 5mg、烟酰胺 25mg、泛酸 10mg、叶酸 0.2mg\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		不适宜人群:少年儿童、孕妇、乳母\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		有效期至:2021-06-23\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		主要原料:维生素B1（盐酸硫胺素）、维生素B2（核黄素）、维生素B6（盐酸吡哆醇）、烟酰胺、D-泛酸钙、叶酸（蝶酰谷氨酸）、山梨糖醇、硬脂酸镁、薄膜包衣预混剂（羟丙甲纤维素、聚乙烯吡咯烷酮、聚乙二醇、甘油）\n	&lt;/li&gt;\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\n		批准文号:国食健字G20100019\n	&lt;/li&gt;\n&lt;/ul&gt;', '1', '2016-12-27 10:19:28', '0', '1', '0', 'upload/goods/2016-12/5861cfab2224a.jpg,upload/goods/2016-12/5861cfab2c284.jpg,upload/goods/2016-12/5861cfac6e731.jpg,upload/goods/2016-12/5861cfabcdcfa.jpg,upload/goods/2016-12/5861cfabb94e7.jpg', 'wstshop', '1', '2016-12-27 10:19:28', '0', '0', '0', null, '买2送2维C 高含量B族 复合维生素B');
