<?php
namespace wstshop\mobile\model;
use think\Db;
/**
 * ============================================================================
 * wstshop多用户商城
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wstshop.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 *  文章类
 */
class Articles extends Base{

	/**
	* 获取咨询中中心所有文章
	*/
	public function getArticles(){
		// 获取咨询中心下的所有分类id
		$catId = input('catId');
		$rs = $this->alias('a')
			  ->field('a.*')
			  ->join('__ARTICLE_CATS__ ac','a.catId=ac.catId','inner')
			  ->where(['a.catId'=>$catId,
			  		   'ac.dataFlag'=>1,
			  		   'ac.isShow'=>1,
			  		   'ac.parentId'=>['<>',7],
			  		   'a.dataFlag'=>1,
			  		   'a.isShow'=>1
			  		   ])
			  ->order('a.catSort asc,a.createTime desc')
			  ->paginate((int)input('pagesize'));
		return $rs;
	}


	/**
	*  根据id获取资讯文章
	*/
	public function getNewsById(){
		$id = (int)input('id');
		WSTArticleVisitorNum($id);// 统计文章访问量
		$article = $this->alias('a')
					->field('a.*')
					->join('__ARTICLE_CATS__ ac','a.catId=ac.catId','inner')
					->where('a.catId<>7 and ac.parentId<>7 and a.dataFlag=1 and a.isShow=1')
					->cache(true)
					->find($id);
	    // 图片延迟加载
        $article['articleContent']=htmlspecialchars_decode($article['articleContent']);
        $rule = '/<img src="\/(wstmartp.*?)"/';
        preg_match_all($rule, $article['articleContent'],$images);
        foreach($images[0] as $k=>$v){
            $article['articleContent'] = str_replace($v, "<img src='/".WSTImg($images[1][$k],3)."'", $article['articleContent']);
        }
        $articleId = cookie("like_articleId");
		$articleId = is_array($articleId)?$articleId:[];
		$rc = !empty($articleId)?in_array($id,$articleId):'';
		if($rc){
         $article['likeState'] = 1;
		}else{
         $article['likeState'] = 0;
		}
        return $article;
	}
	/**
	 * 点赞
	 */
	public function like(){
	    $id = input("param.id/d");
		//判断记录是否存在
		$articleId = cookie("like_articleId");
		$articleId = is_array($articleId)?$articleId:[];
		$rc = !empty($articleId)?in_array($id,$articleId):'';
		if($rc)return WSTReturn("已点赞成功", -1);
		$rs = $this->where(['isShow'=>1,'dataFlag'=>1,'articleId'=>$id])->setInc('likeNum',1);
		//判断是否点赞成功
		if(false !== $rs){
			array_push($articleId,$id);
			cookie("like_articleId",$articleId,25920000);
			return WSTReturn("点赞成功", 1);
		}else{
			return WSTReturn($this->getError(),-1);
		}
	}
	/**
	* 获取资讯中心的子集分类
	*/
	public function getChildInfos(){
		$infos = cache('NEW_INFOS');
		$i = 0;
		if(!$infos){
			$data = Db::name('article_cats')->where(['isShow'=>1,'dataFlag'=>1])->cache(true)->select();
			foreach($data as $k=>$v){
				if($v['parentId']== 8){
					$infos[$i]['catId'] = $v['catId'];
					$infos[$i]['catName'] = $v['catName'];
					$i++;
				}
			}
            cache('NEW_INFOS',$infos);
		}
		return $infos;
	}
}
	
