<?php

namespace app\common\library\storage\engine;

use think\Exception;
use think\Request;

/**
 * 存储引擎抽象类
 */
abstract class Server
{
    protected $file;
    protected $error;
    protected $fileName;
    protected $fileInfo;

    /**
     * 构造函数
     */
    protected function __construct()
    {
        // 接收上传的文件
        $this->file = Request::instance()->file('iFile');
        if (empty($this->file)) {
            throw new Exception('未找到上传文件的信息');
        }
        // 生成保存文件名
        $this->fileName = $this->buildSaveName();
        // 文件信息
        $this->fileInfo = $this->file->getInfo();
    }

    /**
     * 文件上传
     */
    abstract protected function upload();

    /**
     * 返回上传后文件路径
     */
    abstract public function getFileName();

    /**
     * 返回文件信息
     */
    public function getFileInfo()
    {
        return $this->fileInfo;
    }

    /**
     * 返回错误信息
     */
    public function getError()
    {
        return $this->error;
    }

    /**
     * 生成保存文件名
     */
    private function buildSaveName()
    {
        // 要上传图片的本地路径
        $realPath = $this->file->getRealPath();
        // 扩展名
        $ext = pathinfo($this->file->getInfo('name'), PATHINFO_EXTENSION);
        // 自动生成文件名
        return date('YmdHis') . substr(md5($realPath), 0, 5)
            . str_pad(rand(0, 9999), 4, '0', STR_PAD_LEFT) . '.' . $ext;
    }

}
