<?php

namespace app\store\controller\setting;

use app\store\controller\Controller;
use app\store\model\Region;
use app\store\model\Delivery as DeliveryModel;

/**
 * 配送设置
 */
class Delivery extends Controller
{
    /**
     * 配送模板列表
     */
    public function index()
    {
        $model = new DeliveryModel;
        $list = $model->getList();
        return $this->fetch('index', compact('list'));
    }

    /**
     * 删除模板
     */
    public function delete($delivery_id)
    {
		if($err = is_power()){
			return $this->renderError($err);
		}
        $model = DeliveryModel::detail($delivery_id);
        if (!$model->remove()) {
            $error = $model->getError() ?: '删除失败';
            return $this->renderError($error);
        }
        return $this->renderSuccess('删除成功');
    }

    /**
     * 添加配送模板
     */
    public function add()
    {
        if (!$this->request->isAjax()) {
            // 获取所有地区
            $regionData = json_encode(Region::getCacheTree());
            return $this->fetch('add', compact('regionData'));
        }
		if($err = is_power()){
			return $this->renderError($err);
		}
        // 新增记录
        $model = new DeliveryModel;
        if ($model->add($this->postData('delivery'))) {
            return $this->renderSuccess('添加成功', url('setting.delivery/index'));
        }
        $error = $model->getError() ?: '添加失败';
        return $this->renderError($error);
    }

    /**
     * 编辑配送模板
     */
    public function edit($delivery_id)
    {
        // 模板详情
        $model = DeliveryModel::detail($delivery_id);
        if (!$this->request->isAjax()) {
            // 获取所有地区
			$regionData = json_encode(Region::getCacheTree());
			for($n=0;$n<sizeof($model['rule']);$n++){
				$city = explode(',',$model['rule'][$n]['region']);
				$regionAll = Region::getCacheAll();
				$index = 0;
				$province = array();
				for($i=0;$i<sizeof($city);$i++){
					if(!isset($province[$index])){
						$province[$index]=$regionAll[$city[$i]]['pid'];
					}else{
						if($regionAll[$city[$i]]['pid']!= $province[$index]) {
							$index = $index+1;
							$province[$index] = $regionAll[$city[$i]]['pid'];
						}					
					}
				}
				$model['rule'][$n]['province'] = $province;
				$model['rule'][$n]['citys'] = $city;
			}
			$rule = json_encode($model['rule']);
            return $this->fetch('edit', compact('regionData','model','rule'));
        }
		if($err = is_power()){
			return $this->renderError($err);
		}
        // 更新记录
        if ($model->edit($this->postData('delivery'))) {
            return $this->renderSuccess('更新成功', url('setting.delivery/index'));
        }
        $error = $model->getError() ?: '更新失败';
        return $this->renderError($error);
    }

}
