<?php namespace Phpcmf\Controllers;

class Api extends \Phpcmf\Common {

    // 购物车数量
    public function nums() {
        exit($this->_jsonp(1, 'ok', \Phpcmf\Service::M('Cart', 'cart')->my_count($this->uid)));
    }

    // 购物车详情
    public function show() {

        !$this->uid && exit($this->_jsonp(0, '没有登录', 0));

        $list = \Phpcmf\Service::M('Cart', 'cart')->my_list($this->uid);
        !$list  && exit($this->_jsonp(0, '没有商品', 0));

        ob_start();
        \Phpcmf\Service::V()->assign('list', $list);
        \Phpcmf\Service::V()->display('api_show.html');
        $html = ob_get_contents();
        ob_clean();

        $this->_jsonp(1, $html);
    }

    // 删除购物车
    public function del() {

        !$this->uid && exit($this->_jsonp(0, dr_lang('登录之后在操作')));

        $id = (int)\Phpcmf\Service::L('Input')->get('id');
        !$id && exit($this->_json(0, dr_lang('id参数不存在')));

        exit($this->_jsonp(1, dr_lang('操作成功'), \Phpcmf\Service::M('Cart', 'cart')->my_delete($this->uid, $id)));
    }

    // 更新购物车数量
    public function update() {

        !$this->uid && exit($this->_jsonp(0, dr_lang('登录之后在操作')));

        $id = (int)\Phpcmf\Service::L('Input')->get('id');
        $num = max(1, (int)\Phpcmf\Service::L('Input')->get('num'));
        !$id && exit($this->_json(0, dr_lang('id参数不存在')));

        $data = \Phpcmf\Service::M('Cart', 'cart')->my_info($this->uid, $id);
        !$data && exit($this->_jsonp(0, dr_lang('商品不存在')));

        \Phpcmf\Service::M('Cart', 'cart')->update_num($id, $num);

        exit($this->_jsonp(1, dr_lang('操作成功'), [
            'nums' => \Phpcmf\Service::M('Cart', 'cart')->my_count($this->uid),
            'total' => number_format($data['price'] * $num, 2)
        ]));
    }

    // 加入购物车
    public function add() {

        !$this->uid && exit($this->_json(0, dr_lang('登录之后在操作')));

        $id = (int)\Phpcmf\Service::L('Input')->get('id');
        $fid = (int)\Phpcmf\Service::L('Input')->get('fid');

        !$id && exit($this->_json(0, dr_lang('id参数不存在')));
        !$fid && exit($this->_json(0, dr_lang('字段fid参数不存在')));

        $field = $this->get_cache('table-field', $fid);
        !$field && exit($this->_json(0, dr_lang('支付字段不存在')));

        // 获取付款价格
        $num = max(1, (int)\Phpcmf\Service::L('Input')->get('num'));
        $sku = dr_safe_replace(\Phpcmf\Service::L('Input')->get('sku'), 'undefined');
        $rt = \Phpcmf\Service::M('pay')->get_pay_info($id, $field, $num, $sku);
        isset($rt['code']) && !$rt['code'] && exit($this->_msg(0, $rt['msg']));

        // 店铺
        if (!isset($rt['data']['mall_cid']) || !isset($rt['data']['mall_name'])) {
            exit($this->_json(0, dr_lang('没有找到商品的所属店铺')));
        }

        $rt['mall_uid'] = $rt['data']['uid'];
        $rt['mall_url'] = $rt['data']['mall_url'];
        $rt['mall_cid'] = $rt['data']['mall_cid'];
        $rt['mall_name'] = $rt['data']['mall_name'];

        \Phpcmf\Service::M('cart', 'cart')->add_cart($this->uid, $rt, $sku, $num);

        exit($this->_json(1, dr_lang('操作成功'), \Phpcmf\Service::M('cart', 'cart')->my_count($this->uid)));
    }

    // 加入购物车并选择属性
    public function select() {

        !$this->uid && exit($this->_json(0, dr_lang('登录之后在操作')));

        $id = (int)\Phpcmf\Service::L('Input')->get('id');
        $fid = dr_safe_replace(\Phpcmf\Service::L('Input')->get('fid'));
        $mid = dr_safe_replace(\Phpcmf\Service::L('Input')->get('mid'));

        !$id && exit($this->_json(0, dr_lang('id参数不存在')));
        !$fid && exit($this->_json(0, dr_lang('字段fid参数不存在')));
        !$mid && exit($this->_json(0, dr_lang('模块mid参数不存在')));

        $module = \Phpcmf\Service::L('cache')->get('module-'.SITE_ID.'-'.$mid);
        !$module && exit($this->_json(0, dr_lang('模块【%s】不存在', $mid)));

        // 查询模块的数据
        $data = \Phpcmf\Service::M('cart', 'cart')->get_module_row($mid, $id);
        if (!$data) {
            exit($this->_json(0, dr_lang('商品内容不存在')));
        } elseif (!isset($data[$fid])) {
            exit($this->_json(0, dr_lang('支付字段【%s】不存在', $fid)));
        } elseif (!isset($module['field'][$fid])) {
            exit($this->_json(0, dr_lang('支付字段【%s】未定义', $fid)));
        } elseif (!in_array($module['field'][$fid]['fieldtype'], ['Pay', 'Pays'])) {
            exit($this->_json(0, dr_lang('支付字段【%s】无效', $fid)));
        } elseif (!isset($data['mall_cid']) || !isset($data['mall_name'])) {
            exit($this->_json(0, dr_lang('没有找到商品的所属店铺')));
        }

        $price = (float)$data[$fid];

        $_tmp = dr_string2array($data['thumb']);
        $thumb = is_array($_tmp) ? $_tmp['file'][0] : $data['thumb'];

        $field = $module['field'][$fid];
        // 判断是否存在多属性商品
        if ($field['fieldtype'] == 'Pays') {
            $sku = dr_string2array($data[$fid.'_sku']);
            if ($sku) {
                // 存在组合商品
                ob_start();
                \Phpcmf\Service::V()->assign([
                    'price' => $price,
                    'price_sku' => $sku,
                ]);
                \Phpcmf\Service::V()->display('select.html');
                $html = ob_get_clean();
                exit($this->_json(2, $html, '/index.php?is_ajax=1&s=cart&c=api&m=add&id='.$id.'&fid='.$module['field'][$fid]['id'].'&thumb='.$thumb.'&url='.urlencode($data['url'])));
            }
        }


        // 表名-主键id-字段id-数量-sku
        $mid = SITE_ID.'_goods' .'-'. $id .'-'. $field['id'] .'-1-null';

        $rt = [
            'mid' => $mid,
            'price' => $price,
            'url' => $data['url'],
            'mall_uid' => $data['uid'],
            'mall_url' => $data['mall_url'],
            'mall_cid' => $data['mall_cid'],
            'mall_name' => $data['mall_name'],
            'title' => $data['title'],
            'thumb' => (string)$thumb,
            'sku_name' =>'',

        ];

        \Phpcmf\Service::M('cart', 'cart')->add_cart($this->uid, $rt, '', 1);

        exit($this->_json(1, dr_lang('操作成功'), \Phpcmf\Service::M('cart', 'cart')->my_count($this->uid)));
    }


}
