<?php namespace Phpcmf\Model;

class Cart extends \Phpcmf\Model
{

    private $zk;

    // 我的购物车商品数量
    public function my_count($uid) {

        if (!$uid) {
            return 0;
        }

        $count = $this->db->table(SITE_ID.'_cart')->selectSum('quantity')->where('uid', $uid)->get()->getRowArray();

        return (int)$count['quantity'];
    }

    // 我的购物车商品详情
    public function my_list($uid) {

        if (!$uid) {
            return [];
        }

        $list = $this->db->table(SITE_ID.'_cart')->where('uid', $uid)->get()->getResultArray();
        if (!$list) {
            return [];
        }

        foreach ($list as $i => $t) {
            // mid = 表名-主键id-字段id-数量-sku
            list($table, $cid) = explode('-', $t['mid']);
            if ($table == SITE_ID.'_goods') {
                $p = \Phpcmf\Service::M('order', 'order')->get_goods_discount($cid, $t['price'], $t['mall_uid']);
                if ($p['promotion']) {
                    $list[$i]['yuan'] = $t['price'];
                    $list[$i]['price'] = $p['price'];
                    $list[$i]['p_name'] = $p['promotion']['title'];
                    $list[$i]['p_info'] = $p['info'];
                }
            }
        }

        return $list;
    }

    // 我的购物车单个商品详情
    public function my_info($uid, $id) {

        if (!$uid) {
            return [];
        }

        $t = $this->db->table(SITE_ID.'_cart')->where('id', $id)->where('uid', $uid)->get()->getRowArray();
        if ($t) {
            // mid = 表名-主键id-字段id-数量-sku
            list($table, $cid) = explode('-', $t['mid']);
            if ($table == SITE_ID.'_goods') {
                // 计算折扣价格
                $p = \Phpcmf\Service::M('order', 'order')->get_goods_discount($cid, $t['price'], $t['mall_uid']);
                if ($p) {
                    $t['price'] = $p['price'];
                }
            }
            return $t;
        } else {
            return [];
        }
    }

    // 删除我的购物车商品
    public function my_delete($uid, $id) {

        if (!$uid) {
            return 0;
        }

        $this->db->table(SITE_ID.'_cart')->where('uid', $uid)->where('id', $id)->delete();

        return $this->my_count($uid);
    }

    public function update_num($id, $num) {

        $this->db->table(SITE_ID.'_cart')->where('id', $id)->update([
            'quantity' => $num
        ]);
    }



    // 加入我的购物车
    public function add_cart($uid, $rt, $sku, $num) {

        $data = $this->db->table(SITE_ID.'_cart')->where('uid', $uid)->where('mid', $rt['mid'])->where('sku_value', $sku)->get()->getRowArray();

        if ($data) {
            // 更新
            $this->table(SITE_ID.'_cart')->update($data['id'], [
                'url' => $rt['url'],
                'price' => $rt['price'],
                'title' => $rt['title'],
                'thumb' => $rt['thumb'],
                'mall_uid' => $rt['mall_uid'],
                'mall_url' => $rt['mall_url'],
                'mall_cid' => $rt['mall_cid'],
                'mall_name' => $rt['mall_name'],
                'quantity' => $data['quantity']+$num,
            ]);
        } else {
            // 新增
            $this->table(SITE_ID.'_cart')->insert([
                'mid' => $rt['mid'],
                'uid' => $uid,
                'price' => $rt['price'],
                'title' => $rt['title'],
                'thumb' => $rt['thumb'],
                'url' => $rt['url'],
                'mall_uid' => $rt['mall_uid'],
                'mall_url' => $rt['mall_url'],
                'mall_cid' => $rt['mall_cid'],
                'mall_name' => $rt['mall_name'],
                'sku_name' => dr_array2string($rt['sku_name']),
                'sku_value' => $sku,
                'quantity' => $num,
                'inputtime' => SYS_TIME,
            ]);
        }
    }

    public function my_items($ids) {
        return $this->db->table(SITE_ID.'_cart')->whereIn('id', $ids)->where('uid', $this->uid)->get()->getResultArray();
    }

    public function update_cart($id, $rt) {
        $this->table(SITE_ID.'_cart')->update($id, [
            'url' => $rt['url'],
            'price' => $rt['price'],
            'title' => $rt['title'],
            'thumb' => $rt['thumb'],
        ]);
    }

    public function get_module_row($mid, $id) {
        return $this->db->table(SITE_ID.'_'.$mid)->where('id', $id)->get()->getRowArray();
    }
    
}