<?php namespace Phpcmf\Model\Goods;

// 模块内容模型类

class Content extends \Phpcmf\Model\Content {


    // 重新获取内容
    public function _format_content_data($data) {

        // 设置sku信息
        $data['sku_value'] = dr_mall_sku_array(\Phpcmf\Service::L('input')->get('page'));

        // 查询是否优惠商品
        $data['promotion'] = [];
        $data['price_sku'] = dr_string2array($data['price_sku']);
        $data['promotion_data'] = [];
        $p = \Phpcmf\Service::M('order', 'order')->get_goods_discount($data['id'], $data['price'], $data['uid']);
        if ($p) {
            $p['promotion'] && $data['promotion_data'] = $p['promotion'];
            if ($data['price_sku']) {
                foreach ($data['price_sku']['value'] as $i => $m) {
                    $p = \Phpcmf\Service::M('order', 'order')->get_goods_discount($data['id'], $m['price'], $data['uid']);
                    $p && $data['promotion'][$i] = $p['info'];
                }
            } else {
                $data['promotion']['price'] = $p['info'];
            }
        }

        return $data;
    }

    public function _call_show($data) {

        $data['thumb_sku_first'] = $data['thumb_sku_sn'] = [];
        if (is_array($data['thumb']) && is_array($data['price_sku'])) {
            // 查找firest
            $first = [];
            if (isset($data['price_sku']['name'][0]) && is_array($data['price_sku']['name'][0])) {
                foreach ($data['price_sku']['name'][0] as $t) {
                    $first[$t] = 0;
                }
            }
            // 查找sn
            $sn = [];
            if (isset($data['price_sku']['value']) && is_array($data['price_sku']['value'])) {
                foreach ($data['price_sku']['value'] as $t) {
                    if (is_array($t)) {
                        $sn[$t['sn']] = 0;
                    }
                }
            }
            foreach ($data['thumb'] as $t) {
                if (isset($sn[$t['title']])) {
                    $sn[$t['title']] = dr_get_file($t['file']);
                }
                if (isset($first[$t['title']])) {
                    $first[$t['title']] = dr_get_file($t['file']);
                }
            }
            $data['thumb_sku_sn'] = $sn;
            $data['thumb_sku_first'] = $first;
        }

        $data['mall'] = \Phpcmf\Service::M('order', 'order')->get_mall_info_id($data['mall_cid']);
        return $data;
    }

    // 更新url
    public function update_url($row, $url) {
        $update = ['url' => $url];
        if ($mall = \Phpcmf\Service::M('order', 'order')->get_mall_info($row['uid'])) {
            $update['mall_cid'] = $mall['id'];
            $update['mall_url'] = $mall['url'];
            $update['mall_name'] = $mall['title'];
        }
        $this->table($this->mytable)->update((int)$row['id'], $update);
        return $url;
    }

    // 保存内容重写
    public function save($id, $data, $old = []) {

        // 验证店铺存在
        $mall = \Phpcmf\Service::M('order', 'order')->get_mall_info($data[1]['uid']);
        if (!$mall) {
            return dr_return_data(0, dr_lang('该账号未创建店铺，无法发布商品内容'));
        }

        return parent::save($id, $data, $old);
    }

}